/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.config.ir.compiler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyHash;
import org.logstash.RubyUtil;
import org.logstash.config.ir.compiler.AbstractFilterDelegatorExt;
import org.logstash.config.ir.compiler.AbstractOutputDelegatorExt;
import org.logstash.config.ir.compiler.ClassFields;
import org.logstash.config.ir.compiler.Closure;
import org.logstash.config.ir.compiler.ComputeStepSyntaxElement;
import org.logstash.config.ir.compiler.Dataset;
import org.logstash.config.ir.compiler.EventCondition;
import org.logstash.config.ir.compiler.MethodLevelSyntaxElement;
import org.logstash.config.ir.compiler.MethodSyntaxElement;
import org.logstash.config.ir.compiler.SplitDataset;
import org.logstash.config.ir.compiler.SyntaxFactory;
import org.logstash.config.ir.compiler.ValueSyntaxElement;
import org.logstash.config.ir.compiler.VariableDefinition;
import org.logstash.ext.JrubyEventExtLibrary;

public final class DatasetCompiler {
    private static final String FLUSH = "flush";
    public static final SyntaxFactory.IdentifierStatement FLUSH_ARG = SyntaxFactory.identifier("flushArg");
    public static final SyntaxFactory.IdentifierStatement SHUTDOWN_ARG = SyntaxFactory.identifier("shutdownArg");
    public static final SyntaxFactory.IdentifierStatement BATCH_ARG = SyntaxFactory.identifier("batchArg");

    private DatasetCompiler() {
    }

    public static ComputeStepSyntaxElement<SplitDataset> splitDataset(Collection<Dataset> parents, EventCondition condition) {
        ComputeAndClear compute;
        ClassFields fields = new ClassFields();
        ValueSyntaxElement ifData = fields.add(new ArrayList());
        ValueSyntaxElement elseData = fields.add(new ArrayList());
        ValueSyntaxElement right = fields.add(Complement.class);
        VariableDefinition event = new VariableDefinition(JrubyEventExtLibrary.RubyEvent.class, "event");
        fields.addAfterInit(Closure.wrap(SyntaxFactory.assignment(right, SyntaxFactory.cast(Complement.class, SyntaxFactory.constant(DatasetCompiler.class, Complement.class.getSimpleName()).call("from", SyntaxFactory.identifier("this"), elseData)))));
        ValueSyntaxElement conditionField = fields.add(condition);
        if (parents.isEmpty()) {
            compute = DatasetCompiler.withOutputBuffering(DatasetCompiler.conditionalLoop(event, BATCH_ARG, conditionField, ifData, elseData), Closure.wrap(DatasetCompiler.clear(elseData)), ifData, fields);
        } else {
            Collection parentFields = parents.stream().map(fields::add).collect(Collectors.toList());
            ValueSyntaxElement inputBuffer = fields.add(new ArrayList());
            compute = DatasetCompiler.withOutputBuffering(DatasetCompiler.withInputBuffering(DatasetCompiler.conditionalLoop(event, inputBuffer, conditionField, ifData, elseData), parentFields, inputBuffer), DatasetCompiler.clearSyntax(parentFields).add(DatasetCompiler.clear(elseData)), ifData, fields);
        }
        return ComputeStepSyntaxElement.create(Arrays.asList(compute.compute(), compute.clear(), MethodSyntaxElement.right(right)), compute.fields(), SplitDataset.class);
    }

    public static ComputeStepSyntaxElement<Dataset> filterDataset(Collection<Dataset> parents, AbstractFilterDelegatorExt plugin) {
        Closure compute;
        ClassFields fields = new ClassFields();
        ValueSyntaxElement outputBuffer = fields.add(new ArrayList());
        Closure clear = Closure.wrap(new MethodLevelSyntaxElement[0]);
        if (parents.isEmpty()) {
            compute = DatasetCompiler.filterBody(outputBuffer, BATCH_ARG, fields, plugin);
        } else {
            Collection parentFields = parents.stream().map(fields::add).collect(Collectors.toList());
            RubyArray inputBuffer = RubyUtil.RUBY.newArray();
            clear.add(DatasetCompiler.clearSyntax(parentFields));
            ValueSyntaxElement inputBufferField = fields.add(inputBuffer);
            compute = DatasetCompiler.withInputBuffering(DatasetCompiler.filterBody(outputBuffer, inputBufferField, fields, plugin), parentFields, inputBufferField);
        }
        return DatasetCompiler.prepare(DatasetCompiler.withOutputBuffering(compute, clear, outputBuffer, fields));
    }

    public static Dataset terminalDataset(Collection<Dataset> parents) {
        Dataset result;
        int count = parents.size();
        if (count > 1) {
            ClassFields fields = new ClassFields();
            Collection parentFields = parents.stream().map(fields::add).collect(Collectors.toList());
            result = DatasetCompiler.compileOutput(Closure.wrap((MethodLevelSyntaxElement[])parentFields.stream().map(DatasetCompiler::computeDataset).toArray(MethodLevelSyntaxElement[]::new)).add(DatasetCompiler.clearSyntax(parentFields)), Closure.EMPTY, fields).instantiate();
        } else if (count == 1) {
            result = parents.iterator().next();
        } else {
            throw new IllegalArgumentException("Cannot create Terminal Dataset for an empty number of parent datasets");
        }
        return result;
    }

    public static ComputeStepSyntaxElement<Dataset> outputDataset(Collection<Dataset> parents, AbstractOutputDelegatorExt output, boolean terminal) {
        Closure computeSyntax;
        Closure clearSyntax;
        ClassFields fields = new ClassFields();
        if (parents.isEmpty()) {
            clearSyntax = Closure.EMPTY;
            computeSyntax = Closure.wrap(DatasetCompiler.invokeOutput(fields.add((Object)output), BATCH_ARG));
        } else {
            Closure inlineClear;
            Collection parentFields = parents.stream().map(fields::add).collect(Collectors.toList());
            RubyArray buffer = RubyUtil.RUBY.newArray();
            if (terminal) {
                clearSyntax = Closure.EMPTY;
                inlineClear = DatasetCompiler.clearSyntax(parentFields);
            } else {
                inlineClear = Closure.EMPTY;
                clearSyntax = DatasetCompiler.clearSyntax(parentFields);
            }
            ValueSyntaxElement inputBuffer = fields.add(buffer);
            computeSyntax = DatasetCompiler.withInputBuffering(Closure.wrap(DatasetCompiler.invokeOutput(fields.add((Object)output), inputBuffer), inlineClear), parentFields, inputBuffer);
        }
        return DatasetCompiler.compileOutput(computeSyntax, clearSyntax, fields);
    }

    private static ValueSyntaxElement invokeOutput(ValueSyntaxElement output, MethodLevelSyntaxElement events) {
        return output.call("multiReceive", events);
    }

    private static Closure filterBody(ValueSyntaxElement outputBuffer, ValueSyntaxElement inputBuffer, ClassFields fields, AbstractFilterDelegatorExt plugin) {
        ValueSyntaxElement filterField = fields.add((Object)plugin);
        Closure body = Closure.wrap(DatasetCompiler.buffer(outputBuffer, filterField.call("multiFilter", inputBuffer)));
        if (plugin.hasFlush()) {
            body.add(DatasetCompiler.callFilterFlush(fields, outputBuffer, filterField, !plugin.periodicFlush()));
        }
        return body;
    }

    private static Closure conditionalLoop(VariableDefinition event, MethodLevelSyntaxElement inputBuffer, ValueSyntaxElement condition, ValueSyntaxElement ifData, ValueSyntaxElement elseData) {
        ValueSyntaxElement eventVal = event.access();
        return Closure.wrap(SyntaxFactory.value("org.logstash.config.ir.compiler.Utils").call("filterEvents", inputBuffer, condition, ifData, elseData));
    }

    private static ComputeStepSyntaxElement<Dataset> prepare(ComputeAndClear compute) {
        return ComputeStepSyntaxElement.create(Arrays.asList(compute.compute(), compute.clear()), compute.fields(), Dataset.class);
    }

    private static Closure withInputBuffering(Closure compute, Collection<ValueSyntaxElement> parents, ValueSyntaxElement inputBuffer) {
        return Closure.wrap((MethodLevelSyntaxElement[])parents.stream().map(par -> SyntaxFactory.value("org.logstash.config.ir.compiler.Utils").call("copyNonCancelledEvents", DatasetCompiler.computeDataset(par), inputBuffer)).toArray(MethodLevelSyntaxElement[]::new)).add(compute).add(DatasetCompiler.clear(inputBuffer));
    }

    private static ComputeAndClear withOutputBuffering(Closure compute, Closure clear, ValueSyntaxElement outputBuffer, ClassFields fields) {
        SyntaxFactory.MethodCallReturnValue done = new SyntaxFactory.MethodCallReturnValue(SyntaxFactory.value("this"), "isDone", new MethodLevelSyntaxElement[0]);
        return DatasetCompiler.computeAndClear(Closure.wrap(SyntaxFactory.ifCondition(done, Closure.wrap(SyntaxFactory.ret(outputBuffer)))).add(compute).add(new SyntaxFactory.MethodCallReturnValue(SyntaxFactory.value("this"), "setDone", new MethodLevelSyntaxElement[0])).add(SyntaxFactory.ret(outputBuffer)), Closure.wrap(SyntaxFactory.ifCondition(done, Closure.wrap(clear.add(DatasetCompiler.clear(outputBuffer)), new SyntaxFactory.MethodCallReturnValue(SyntaxFactory.value("this"), "clearDone", new MethodLevelSyntaxElement[0])))), fields);
    }

    private static MethodLevelSyntaxElement callFilterFlush(ClassFields fields, ValueSyntaxElement resultBuffer, ValueSyntaxElement filterPlugin, boolean shutdownOnly) {
        ValueSyntaxElement flushArgs;
        MethodLevelSyntaxElement condition;
        ValueSyntaxElement flushFinal = fields.add(DatasetCompiler.flushOpts(true));
        if (shutdownOnly) {
            condition = SyntaxFactory.and(FLUSH_ARG, SHUTDOWN_ARG);
            flushArgs = flushFinal;
        } else {
            condition = FLUSH_ARG;
            flushArgs = SyntaxFactory.ternary(SHUTDOWN_ARG, flushFinal, fields.add(DatasetCompiler.flushOpts(false)));
        }
        return SyntaxFactory.ifCondition(condition, Closure.wrap(DatasetCompiler.buffer(resultBuffer, filterPlugin.call(FLUSH, flushArgs))));
    }

    private static MethodLevelSyntaxElement clear(ValueSyntaxElement field) {
        return field.call("clear", new MethodLevelSyntaxElement[0]);
    }

    private static ValueSyntaxElement computeDataset(ValueSyntaxElement parent) {
        return parent.call("compute", BATCH_ARG, FLUSH_ARG, SHUTDOWN_ARG);
    }

    private static RubyHash flushOpts(boolean fin) {
        RubyHash res = RubyHash.newHash((Ruby)RubyUtil.RUBY);
        res.put((Object)RubyUtil.RUBY.newSymbol("final"), (Object)RubyUtil.RUBY.newBoolean(fin));
        return res;
    }

    private static ComputeStepSyntaxElement<Dataset> compileOutput(Closure syntax, Closure clearSyntax, ClassFields fields) {
        return DatasetCompiler.prepare(DatasetCompiler.computeAndClear(syntax.add(MethodLevelSyntaxElement.RETURN_NULL), clearSyntax, fields));
    }

    private static MethodLevelSyntaxElement buffer(ValueSyntaxElement resultBuffer, ValueSyntaxElement argument) {
        return resultBuffer.call("addAll", argument);
    }

    private static Closure clearSyntax(Collection<ValueSyntaxElement> toClear) {
        return Closure.wrap((MethodLevelSyntaxElement[])toClear.stream().map(DatasetCompiler::clear).toArray(MethodLevelSyntaxElement[]::new));
    }

    private static ComputeAndClear computeAndClear(Closure compute, Closure clear, ClassFields fields) {
        return new ComputeAndClear(compute, clear, fields);
    }

    private static final class ComputeAndClear {
        private final MethodSyntaxElement compute;
        private final MethodSyntaxElement clear;
        private final ClassFields fields;

        private ComputeAndClear(Closure compute, Closure clear, ClassFields fields) {
            this.compute = MethodSyntaxElement.compute(compute);
            this.clear = MethodSyntaxElement.clear(clear);
            this.fields = fields;
        }

        public MethodSyntaxElement compute() {
            return this.compute;
        }

        public MethodSyntaxElement clear() {
            return this.clear;
        }

        public ClassFields fields() {
            return this.fields;
        }
    }

    public static final class Complement
    implements Dataset {
        private final Dataset parent;
        private final Collection<JrubyEventExtLibrary.RubyEvent> data;
        private boolean done;

        public static Dataset from(Dataset parent, Collection<JrubyEventExtLibrary.RubyEvent> complement) {
            return new Complement(parent, complement);
        }

        private Complement(Dataset left, Collection<JrubyEventExtLibrary.RubyEvent> complement) {
            this.parent = left;
            this.data = complement;
        }

        @Override
        public Collection<JrubyEventExtLibrary.RubyEvent> compute(RubyArray batch, boolean flush, boolean shutdown) {
            if (this.done) {
                return this.data;
            }
            this.parent.compute(batch, flush, shutdown);
            this.done = true;
            return this.data;
        }

        @Override
        public void clear() {
            if (this.done) {
                this.parent.clear();
                this.done = false;
            }
        }
    }
}

