/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import org.bouncycastle.jsse.BCSNIHostName;
import org.bouncycastle.jsse.BCSNIServerName;
import org.bouncycastle.jsse.provider.JsseUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class JsseUtils_8
extends JsseUtils {
    JsseUtils_8() {
    }

    static SNIHostName exportSNIServerName(BCSNIServerName bCSNIServerName) {
        if (bCSNIServerName == null || bCSNIServerName.getType() != 0) {
            return null;
        }
        return new SNIHostName(bCSNIServerName.getEncoded());
    }

    static Object exportSNIServerNames(List<BCSNIServerName> list) {
        if (list == null) {
            return null;
        }
        ArrayList<SNIHostName> arrayList = new ArrayList<SNIHostName>(list.size());
        for (BCSNIServerName bCSNIServerName : list) {
            SNIHostName sNIHostName = JsseUtils_8.exportSNIServerName(bCSNIServerName);
            if (sNIHostName == null) continue;
            arrayList.add(sNIHostName);
        }
        if (!arrayList.isEmpty()) {
            return Collections.unmodifiableList(arrayList);
        }
        return Collections.emptyList();
    }

    static BCSNIHostName importSNIServerName(SNIServerName sNIServerName) {
        if (sNIServerName == null || sNIServerName.getType() != 0) {
            return null;
        }
        return new BCSNIHostName(sNIServerName.getEncoded());
    }

    static List<BCSNIServerName> importSNIServerNames(Object object) {
        if (object == null) {
            return null;
        }
        List list = (List)object;
        ArrayList<BCSNIHostName> arrayList = new ArrayList<BCSNIHostName>(list.size());
        for (SNIServerName sNIServerName : list) {
            BCSNIHostName bCSNIHostName = JsseUtils_8.importSNIServerName(sNIServerName);
            if (bCSNIHostName == null) continue;
            arrayList.add(bCSNIHostName);
        }
        if (!arrayList.isEmpty()) {
            return Collections.unmodifiableList(arrayList);
        }
        return Collections.emptyList();
    }
}

