/*
 * Decompiled with CFR 0.152.
 */
package nokogiri.internals;

import java.math.BigInteger;
import java.util.List;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionException;
import nokogiri.XmlNode;
import nokogiri.XmlNodeSet;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyInteger;
import org.jruby.RubyString;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.w3c.dom.NodeList;

public class NokogiriXPathFunction
implements XPathFunction {
    private final IRubyObject handler;
    private final String name;
    private final int arity;

    public static NokogiriXPathFunction create(IRubyObject iRubyObject, String string, int n) {
        return new NokogiriXPathFunction(iRubyObject, string, n);
    }

    private NokogiriXPathFunction(IRubyObject iRubyObject, String string, int n) {
        this.handler = iRubyObject;
        this.name = string;
        this.arity = n;
    }

    public Object evaluate(List list) throws XPathFunctionException {
        if (list.size() != this.arity) {
            throw new XPathFunctionException("arity does not match");
        }
        Ruby ruby = this.handler.getRuntime();
        ThreadContext threadContext = ruby.getCurrentContext();
        IRubyObject iRubyObject = RuntimeHelpers.invoke((ThreadContext)threadContext, (IRubyObject)this.handler, (String)this.name, (IRubyObject[])NokogiriXPathFunction.fromObjectToRubyArgs(ruby, list));
        return NokogiriXPathFunction.fromRubyToObject(ruby, iRubyObject);
    }

    private static IRubyObject[] fromObjectToRubyArgs(Ruby ruby, List list) {
        IRubyObject[] iRubyObjectArray = new IRubyObject[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            iRubyObjectArray[i] = NokogiriXPathFunction.fromObjectToRuby(ruby, list.get(i));
        }
        return iRubyObjectArray;
    }

    private static IRubyObject fromObjectToRuby(Ruby ruby, Object object) {
        if (object instanceof NodeList) {
            XmlNodeSet xmlNodeSet = XmlNodeSet.newEmptyNodeSet(ruby.getCurrentContext());
            xmlNodeSet.setNodeList((NodeList)object);
            return xmlNodeSet;
        }
        return JavaUtil.convertJavaToUsableRubyObject((Ruby)ruby, (Object)object);
    }

    private static Object fromRubyToObject(Ruby ruby, IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyString) {
            return iRubyObject.asJavaString();
        }
        if (iRubyObject instanceof RubyBoolean) {
            return iRubyObject.toJava(Boolean.class);
        }
        if (iRubyObject instanceof RubyFloat) {
            return iRubyObject.toJava(Double.class);
        }
        if (iRubyObject instanceof RubyInteger) {
            if (iRubyObject instanceof RubyFixnum) {
                return RubyFixnum.fix2long((IRubyObject)iRubyObject);
            }
            return iRubyObject.toJava(BigInteger.class);
        }
        if (iRubyObject instanceof XmlNodeSet) {
            return iRubyObject;
        }
        if (iRubyObject instanceof RubyArray) {
            return XmlNodeSet.newXmlNodeSet(ruby.getCurrentContext(), ((RubyArray)iRubyObject).toJavaArray());
        }
        return ((XmlNode)iRubyObject).getNode();
    }
}

