/*
 * Decompiled with CFR 0.152.
 */
package nokogiri.internals;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import nokogiri.XmlSyntaxError;
import nokogiri.internals.NokogiriHelpers;
import nokogiri.internals.XmlDeclHandler;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.DefaultHandler2;

public class NokogiriHandler
extends DefaultHandler2
implements XmlDeclHandler {
    StringBuilder charactersBuilder;
    private final Ruby runtime;
    private final RubyClass attrClass;
    private final IRubyObject object;
    private final LinkedList<RaiseException> errors = new LinkedList();
    private Locator locator;
    private boolean needEmptyAttrCheck;
    static final Set<String> EMPTY_ATTRS;

    public NokogiriHandler(Ruby ruby, IRubyObject iRubyObject) {
        assert (iRubyObject != null);
        this.runtime = ruby;
        this.attrClass = (RubyClass)ruby.getClassFromPath("Nokogiri::XML::SAX::Parser::Attribute");
        this.object = iRubyObject;
        this.charactersBuilder = new StringBuilder();
        String string = iRubyObject.getMetaClass().getName();
        if ("Nokogiri::HTML::SAX::Parser".equals(string)) {
            this.needEmptyAttrCheck = true;
        }
    }

    @Override
    public void skippedEntity(String string) {
        this.call("error", (IRubyObject)this.runtime.newString("Entity '" + string + "' not defined\n"));
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void startDocument() {
        this.call("start_document");
    }

    @Override
    public void xmlDecl(String string, String string2, String string3) {
        this.call("xmldecl", NokogiriHelpers.stringOrNil(this.runtime, string), NokogiriHelpers.stringOrNil(this.runtime, string2), NokogiriHelpers.stringOrNil(this.runtime, string3));
    }

    @Override
    public void endDocument() {
        this.populateCharacters();
        this.call("end_document");
    }

    @Override
    public void processingInstruction(String string, String string2) {
        this.call("processing_instruction", (IRubyObject)this.runtime.newString(string), (IRubyObject)this.runtime.newString(string2));
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        Ruby ruby = this.runtime;
        ThreadContext threadContext = ruby.getCurrentContext();
        RubyArray rubyArray = RubyArray.newArray((Ruby)ruby);
        RubyArray rubyArray2 = RubyArray.newArray((Ruby)ruby);
        boolean bl = false;
        for (int i = 0; i < attributes.getLength(); ++i) {
            String string4 = attributes.getURI(i);
            String string5 = attributes.getQName(i);
            String string6 = attributes.getLocalName(i);
            String string7 = attributes.getValue(i);
            String string8 = NokogiriHelpers.getPrefix(string5);
            if (string6 == null || string6.isEmpty()) {
                string6 = NokogiriHelpers.getLocalPart(string5);
            }
            if (NokogiriHelpers.isNamespace(string5) && !bl) {
                if (string6.equals("xmlns")) {
                    string6 = null;
                }
                rubyArray2.append((IRubyObject)ruby.newArray(NokogiriHelpers.stringOrNil(ruby, string6), (IRubyObject)ruby.newString(string7)));
                continue;
            }
            IRubyObject[] iRubyObjectArray = null;
            if (this.needEmptyAttrCheck && NokogiriHandler.isEmptyAttr(string6)) {
                iRubyObjectArray = new IRubyObject[]{NokogiriHelpers.stringOrNil(ruby, string6), NokogiriHelpers.stringOrNil(ruby, string8), NokogiriHelpers.stringOrNil(ruby, string4)};
            }
            if (iRubyObjectArray == null) {
                iRubyObjectArray = new IRubyObject[]{NokogiriHelpers.stringOrNil(ruby, string6), NokogiriHelpers.stringOrNil(ruby, string8), NokogiriHelpers.stringOrNil(ruby, string4), NokogiriHelpers.stringOrNil(ruby, string7)};
            }
            rubyArray.append(RuntimeHelpers.invoke((ThreadContext)threadContext, (IRubyObject)this.attrClass, (String)"new", iRubyObjectArray));
        }
        if (string2 == null || string2.isEmpty()) {
            string2 = NokogiriHelpers.getLocalPart(string3);
        }
        this.populateCharacters();
        this.call("start_element_namespace", NokogiriHelpers.stringOrNil(ruby, string2), (IRubyObject)rubyArray, NokogiriHelpers.stringOrNil(ruby, NokogiriHelpers.getPrefix(string3)), NokogiriHelpers.stringOrNil(ruby, string), (IRubyObject)rubyArray2);
    }

    private static boolean isEmptyAttr(String string) {
        return EMPTY_ATTRS.contains(string);
    }

    public final Integer getLine() {
        int n = this.locator.getLineNumber();
        return n == -1 ? null : Integer.valueOf(n);
    }

    public final Integer getColumn() {
        int n = this.locator.getColumnNumber();
        return n == -1 ? null : Integer.valueOf(n - 1);
    }

    @Override
    public void endElement(String string, String string2, String string3) {
        this.populateCharacters();
        this.call("end_element_namespace", NokogiriHelpers.stringOrNil(this.runtime, string2), NokogiriHelpers.stringOrNil(this.runtime, NokogiriHelpers.getPrefix(string3)), NokogiriHelpers.stringOrNil(this.runtime, string));
    }

    @Override
    public void characters(char[] cArray, int n, int n2) {
        this.charactersBuilder.append(cArray, n, n2);
    }

    @Override
    public void comment(char[] cArray, int n, int n2) {
        this.populateCharacters();
        this.call("comment", (IRubyObject)this.runtime.newString(new String(cArray, n, n2)));
    }

    @Override
    public void startCDATA() {
        this.populateCharacters();
    }

    @Override
    public void endCDATA() {
        this.call("cdata_block", (IRubyObject)this.runtime.newString(this.charactersBuilder.toString()));
        this.charactersBuilder.setLength(0);
    }

    @Override
    public void error(SAXParseException sAXParseException) {
        try {
            String string = sAXParseException.getMessage();
            this.call("error", (IRubyObject)this.runtime.newString(string == null ? "" : string));
            this.addError(new RaiseException((RubyException)XmlSyntaxError.createError(this.runtime, sAXParseException), true));
        }
        catch (RaiseException raiseException) {
            this.addError(raiseException);
        }
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) {
        try {
            String string = sAXParseException.getMessage();
            this.call("error", (IRubyObject)this.runtime.newString(string == null ? "" : string));
            this.addError(new RaiseException((RubyException)XmlSyntaxError.createFatalError(this.runtime, sAXParseException), true));
        }
        catch (RaiseException raiseException) {
            this.addError(raiseException);
        }
    }

    @Override
    public void warning(SAXParseException sAXParseException) {
        String string = sAXParseException.getMessage();
        this.call("warning", (IRubyObject)this.runtime.newString(string == null ? "" : string));
    }

    protected synchronized void addError(RaiseException raiseException) {
        this.errors.add(raiseException);
    }

    public synchronized int getErrorCount() {
        return this.errors.size();
    }

    public synchronized RaiseException getLastError() {
        return this.errors.getLast();
    }

    private void call(String string) {
        ThreadContext threadContext = this.runtime.getCurrentContext();
        RuntimeHelpers.invoke((ThreadContext)threadContext, (IRubyObject)this.document(threadContext), (String)string);
    }

    private void call(String string, IRubyObject iRubyObject) {
        ThreadContext threadContext = this.runtime.getCurrentContext();
        RuntimeHelpers.invoke((ThreadContext)threadContext, (IRubyObject)this.document(threadContext), (String)string, (IRubyObject)iRubyObject);
    }

    private void call(String string, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        ThreadContext threadContext = this.runtime.getCurrentContext();
        RuntimeHelpers.invoke((ThreadContext)threadContext, (IRubyObject)this.document(threadContext), (String)string, (IRubyObject)iRubyObject, (IRubyObject)iRubyObject2);
    }

    private void call(String string, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        ThreadContext threadContext = this.runtime.getCurrentContext();
        RuntimeHelpers.invoke((ThreadContext)threadContext, (IRubyObject)this.document(threadContext), (String)string, (IRubyObject)iRubyObject, (IRubyObject)iRubyObject2, (IRubyObject)iRubyObject3);
    }

    private void call(String string, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3, IRubyObject iRubyObject4, IRubyObject iRubyObject5) {
        ThreadContext threadContext = this.runtime.getCurrentContext();
        RuntimeHelpers.invoke((ThreadContext)threadContext, (IRubyObject)this.document(threadContext), (String)string, (IRubyObject[])new IRubyObject[]{iRubyObject, iRubyObject2, iRubyObject3, iRubyObject4, iRubyObject5});
    }

    private IRubyObject document(ThreadContext threadContext) {
        return this.object.getInstanceVariables().getInstanceVariable("@document");
    }

    protected void populateCharacters() {
        if (this.charactersBuilder.length() > 0) {
            this.call("characters", (IRubyObject)this.runtime.newString(this.charactersBuilder.toString()));
            this.charactersBuilder.setLength(0);
        }
    }

    static {
        String[] stringArray = new String[]{"checked", "compact", "declare", "defer", "disabled", "ismap", "multiple", "noresize", "nohref", "noshade", "nowrap", "readonly", "selected"};
        EMPTY_ATTRS = new HashSet<String>(Arrays.asList(stringArray));
    }
}

