/*
 * Decompiled with CFR 0.152.
 */
package nokogiri;

import java.util.Arrays;
import nokogiri.NokogiriService;
import nokogiri.XmlNamespace;
import nokogiri.XmlNode;
import nokogiri.internals.NokogiriHelpers;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyObject;
import org.jruby.RubyRange;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@JRubyClass(name={"Nokogiri::XML::NodeSet"})
public class XmlNodeSet
extends RubyObject
implements NodeList {
    private IRubyObject[] nodes;

    @JRubyMethod(name={"new"}, meta=true, rest=true)
    public static IRubyObject rbNew(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
        RubyClass rubyClass = (RubyClass)iRubyObject;
        XmlNodeSet xmlNodeSet = (XmlNodeSet)rubyClass.allocate();
        xmlNodeSet.setNodes(new IRubyObject[0]);
        xmlNodeSet.callInit(iRubyObjectArray, block);
        return xmlNodeSet;
    }

    public XmlNodeSet(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    private static XmlNodeSet create(Ruby ruby) {
        return (XmlNodeSet)NokogiriService.XML_NODESET_ALLOCATOR.allocate(ruby, NokogiriHelpers.getNokogiriClass(ruby, "Nokogiri::XML::NodeSet"));
    }

    public static XmlNodeSet newEmptyNodeSet(ThreadContext threadContext) {
        XmlNodeSet xmlNodeSet = XmlNodeSet.create(threadContext.getRuntime());
        xmlNodeSet.nodes = new IRubyObject[0];
        return xmlNodeSet;
    }

    public static XmlNodeSet newXmlNodeSet(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        XmlNodeSet xmlNodeSet = XmlNodeSet.create(threadContext.runtime);
        xmlNodeSet.setNodes(iRubyObjectArray);
        return xmlNodeSet;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    void setNodes(IRubyObject[] iRubyObjectArray) {
        this.nodes = iRubyObjectArray;
        IRubyObject iRubyObject = iRubyObjectArray.length > 0 ? iRubyObjectArray[0] : null;
        this.initialize(this.getRuntime(), iRubyObject);
    }

    private void setReference(XmlNodeSet xmlNodeSet) {
        IRubyObject iRubyObject = xmlNodeSet.nodes.length > 0 ? xmlNodeSet.nodes[0] : null;
        this.initialize(this.getRuntime(), iRubyObject);
    }

    public void setNodeList(NodeList nodeList) {
        this.setNodes(NokogiriHelpers.nodeListToRubyArray(this.getRuntime(), nodeList));
    }

    final void initialize(Ruby ruby, IRubyObject iRubyObject) {
        if (iRubyObject instanceof XmlNode) {
            IRubyObject iRubyObject2 = ((XmlNode)iRubyObject).document(ruby);
            XmlNode.setDocumentAndDecorate(ruby.getCurrentContext(), this, iRubyObject2);
        }
    }

    public int length() {
        return this.nodes == null ? 0 : this.nodes.length;
    }

    public void relink_namespace(ThreadContext threadContext) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (!(this.nodes[i] instanceof XmlNode)) continue;
            ((XmlNode)this.nodes[i]).relink_namespace(threadContext);
        }
    }

    @JRubyMethod(name={"&"})
    public IRubyObject op_and(ThreadContext threadContext, IRubyObject iRubyObject) {
        IRubyObject[] iRubyObjectArray = XmlNodeSet.getNodes(threadContext, iRubyObject);
        if (iRubyObjectArray == null || iRubyObjectArray.length == 0) {
            return XmlNodeSet.newEmptyNodeSet(threadContext);
        }
        if (this.nodes == null || this.nodes.length == 0) {
            return XmlNodeSet.newEmptyNodeSet(threadContext);
        }
        IRubyObject[] iRubyObjectArray2 = this.nodes;
        IRubyObject[] iRubyObjectArray3 = XmlNodeSet.getNodes(threadContext, iRubyObject);
        IRubyObject[] iRubyObjectArray4 = new IRubyObject[this.nodes.length];
        int n = 0;
        block0: for (int i = 0; i < iRubyObjectArray2.length; ++i) {
            IRubyObject iRubyObject2 = iRubyObjectArray2[i];
            for (int j = 0; j < iRubyObjectArray3.length; ++j) {
                if (iRubyObjectArray3[j] != iRubyObject2) continue;
                iRubyObjectArray4[n++] = iRubyObject2;
                continue block0;
            }
        }
        XmlNodeSet xmlNodeSet = XmlNodeSet.newXmlNodeSet(threadContext, Arrays.copyOf(iRubyObjectArray4, n));
        xmlNodeSet.setReference(this);
        return xmlNodeSet;
    }

    @JRubyMethod
    public IRubyObject delete(ThreadContext threadContext, IRubyObject iRubyObject) {
        IRubyObject iRubyObject2 = XmlNodeSet.asXmlNodeOrNamespace(threadContext, iRubyObject);
        if (this.nodes.length == 0) {
            return threadContext.nil;
        }
        IRubyObject[] iRubyObjectArray = this.nodes;
        IRubyObject[] iRubyObjectArray2 = new IRubyObject[this.nodes.length];
        int n = 0;
        for (int i = 0; i < iRubyObjectArray.length; ++i) {
            IRubyObject iRubyObject3 = iRubyObjectArray[i];
            if (iRubyObject3 == iRubyObject2) continue;
            iRubyObjectArray2[n++] = iRubyObject3;
        }
        if (iRubyObject2 instanceof XmlNamespace) {
            ((XmlNamespace)iRubyObject2).deleteHref();
        }
        this.nodes = Arrays.copyOf(iRubyObjectArray2, n);
        if (this.nodes.length < iRubyObjectArray.length) {
            return iRubyObject2;
        }
        return threadContext.nil;
    }

    @JRubyMethod
    public IRubyObject dup(ThreadContext threadContext) {
        return XmlNodeSet.newXmlNodeSet(threadContext, this.nodes);
    }

    @JRubyMethod(name={"include?"})
    public IRubyObject include_p(ThreadContext threadContext, IRubyObject iRubyObject) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] != iRubyObject) continue;
            return threadContext.tru;
        }
        return threadContext.runtime.getFalse();
    }

    @JRubyMethod(name={"length", "size"})
    public IRubyObject length(ThreadContext threadContext) {
        return threadContext.getRuntime().newFixnum(this.nodes.length);
    }

    @JRubyMethod(name={"-"})
    public IRubyObject op_diff(ThreadContext threadContext, IRubyObject iRubyObject) {
        IRubyObject[] iRubyObjectArray = XmlNodeSet.getNodes(threadContext, iRubyObject);
        if (iRubyObjectArray.length == 0) {
            return this.dup(threadContext);
        }
        if (this.nodes.length == 0) {
            return XmlNodeSet.newEmptyNodeSet(threadContext);
        }
        IRubyObject[] iRubyObjectArray2 = this.nodes;
        IRubyObject[] iRubyObjectArray3 = XmlNodeSet.getNodes(threadContext, iRubyObject);
        IRubyObject[] iRubyObjectArray4 = new IRubyObject[this.nodes.length];
        int n = 0;
        block0: for (int i = 0; i < iRubyObjectArray2.length; ++i) {
            IRubyObject iRubyObject2 = iRubyObjectArray2[i];
            for (int j = 0; j < iRubyObjectArray3.length; ++j) {
                if (iRubyObjectArray3[j] == iRubyObject2) continue block0;
            }
            iRubyObjectArray4[n++] = iRubyObject2;
        }
        XmlNodeSet xmlNodeSet = XmlNodeSet.newXmlNodeSet(threadContext, Arrays.copyOf(iRubyObjectArray4, n));
        xmlNodeSet.setReference(this);
        return xmlNodeSet;
    }

    @JRubyMethod(name={"|", "+"})
    public IRubyObject op_or(ThreadContext threadContext, IRubyObject iRubyObject) {
        IRubyObject[] iRubyObjectArray = XmlNodeSet.getNodes(threadContext, iRubyObject);
        if (this.nodes.length == 0) {
            return ((XmlNodeSet)iRubyObject).dup(threadContext);
        }
        if (iRubyObjectArray.length == 0) {
            return this.dup(threadContext);
        }
        IRubyObject[] iRubyObjectArray2 = this.nodes;
        IRubyObject[] iRubyObjectArray3 = XmlNodeSet.getNodes(threadContext, iRubyObject);
        IRubyObject[] iRubyObjectArray4 = Arrays.copyOf(iRubyObjectArray2, iRubyObjectArray2.length + iRubyObjectArray3.length);
        int n = iRubyObjectArray2.length;
        block0: for (int i = 0; i < iRubyObjectArray3.length; ++i) {
            IRubyObject iRubyObject2 = iRubyObjectArray3[i];
            for (int j = 0; j < iRubyObjectArray2.length; ++j) {
                if (iRubyObjectArray2[j] == iRubyObject2) continue block0;
            }
            iRubyObjectArray4[n++] = iRubyObject2;
        }
        XmlNodeSet xmlNodeSet = XmlNodeSet.newXmlNodeSet(threadContext, Arrays.copyOf(iRubyObjectArray4, n));
        xmlNodeSet.setReference(this);
        return xmlNodeSet;
    }

    @JRubyMethod(name={"push", "<<"})
    public IRubyObject push(ThreadContext threadContext, IRubyObject iRubyObject) {
        this.nodes = Arrays.copyOf(this.nodes, this.nodes.length + 1);
        this.nodes[this.nodes.length - 1] = iRubyObject;
        return this;
    }

    private static IRubyObject rangeBeginLength(ThreadContext threadContext, IRubyObject iRubyObject, int n, int[] nArray) {
        RubyRange rubyRange = (RubyRange)iRubyObject;
        int n2 = rubyRange.begin(threadContext).convertToInteger().getIntValue();
        int n3 = rubyRange.end(threadContext).convertToInteger().getIntValue();
        if (n2 < 0 && (n2 += n) < 0) {
            throw threadContext.runtime.newRangeError(n2 + ".." + (rubyRange.isExcludeEnd() ? "." : "") + n3 + " out of range");
        }
        if (n3 < 0) {
            n3 += n;
        }
        if (!rubyRange.isExcludeEnd()) {
            // empty if block
        }
        nArray[0] = n2;
        nArray[1] = ++n3;
        return threadContext.tru;
    }

    @JRubyMethod(name={"[]", "slice"})
    public IRubyObject slice(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject instanceof RubyFixnum) {
            int n = ((RubyFixnum)iRubyObject).getIntValue();
            if (n < 0) {
                n += this.nodes.length;
            }
            if (n >= this.nodes.length || n < 0) {
                return threadContext.nil;
            }
            return this.nodes[n];
        }
        int[] nArray = new int[2];
        XmlNodeSet.rangeBeginLength(threadContext, iRubyObject, this.nodes.length, nArray);
        int n = nArray[0];
        int n2 = nArray[1];
        return this.subseq(threadContext, n, n2 - n);
    }

    @JRubyMethod(name={"[]", "slice"})
    public IRubyObject slice(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        int n = ((RubyFixnum)iRubyObject).getIntValue();
        int n2 = ((RubyFixnum)iRubyObject2).getIntValue();
        if (n < 0) {
            n += this.nodes.length;
        }
        return this.subseq(threadContext, n, n2);
    }

    public IRubyObject subseq(ThreadContext threadContext, int n, int n2) {
        if (n > this.nodes.length) {
            return threadContext.nil;
        }
        if (n < 0 || n2 < 0) {
            return threadContext.nil;
        }
        if (n + n2 > this.nodes.length) {
            n2 = this.nodes.length - n;
        }
        int n3 = n + n2;
        IRubyObject[] iRubyObjectArray = Arrays.copyOfRange(this.nodes, n, n3);
        return XmlNodeSet.newXmlNodeSet(threadContext, iRubyObjectArray);
    }

    @JRubyMethod(name={"to_a", "to_ary"})
    public IRubyObject to_a(ThreadContext threadContext) {
        return threadContext.runtime.newArrayNoCopy(this.nodes);
    }

    @JRubyMethod(name={"unlink", "remove"})
    public IRubyObject unlink(ThreadContext threadContext) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (!(this.nodes[i] instanceof XmlNode)) continue;
            ((XmlNode)this.nodes[i]).unlink(threadContext);
        }
        return this;
    }

    private static XmlNodeSet newXmlNodeSet(ThreadContext threadContext, XmlNodeSet xmlNodeSet) {
        XmlNodeSet xmlNodeSet2 = XmlNodeSet.create(threadContext.getRuntime());
        xmlNodeSet2.setReference(xmlNodeSet);
        xmlNodeSet2.nodes = new IRubyObject[0];
        return xmlNodeSet2;
    }

    private static IRubyObject asXmlNodeOrNamespace(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject instanceof XmlNode || iRubyObject instanceof XmlNamespace) {
            return iRubyObject;
        }
        throw threadContext.getRuntime().newArgumentError("node must be a Nokogiri::XML::Node or Nokogiri::XML::Namespace");
    }

    static IRubyObject[] getNodes(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject instanceof XmlNodeSet) {
            return ((XmlNodeSet)iRubyObject).nodes;
        }
        throw threadContext.getRuntime().newArgumentError("node must be a Nokogiri::XML::NodeSet");
    }

    @Override
    public int getLength() {
        return this.nodes.length;
    }

    @Override
    public Node item(int n) {
        IRubyObject iRubyObject = this.nodes[n];
        if (iRubyObject instanceof XmlNode) {
            return ((XmlNode)iRubyObject).node;
        }
        if (iRubyObject instanceof XmlNamespace) {
            return ((XmlNamespace)iRubyObject).getNode();
        }
        return null;
    }
}

