/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventhubs.impl;

import com.microsoft.azure.eventhubs.EventData;
import com.microsoft.azure.eventhubs.EventHubException;
import com.microsoft.azure.eventhubs.PartitionReceiveHandler;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReceivePump {
    private static final Logger TRACE_LOGGER = LoggerFactory.getLogger(ReceivePump.class);
    private final IPartitionReceiver receiver;
    private final PartitionReceiveHandler onReceiveHandler;
    private final boolean invokeOnTimeout;
    private final CompletableFuture<Void> stopPump;
    private AtomicBoolean stopPumpRaised;

    public ReceivePump(IPartitionReceiver receiver, PartitionReceiveHandler receiveHandler, boolean invokeOnReceiveWithNoEvents) {
        this.receiver = receiver;
        this.onReceiveHandler = receiveHandler;
        this.invokeOnTimeout = invokeOnReceiveWithNoEvents;
        this.stopPump = new CompletableFuture();
        this.stopPumpRaised = new AtomicBoolean(false);
    }

    public void run() {
        boolean isPumpHealthy = true;
        while (isPumpHealthy && !this.stopPumpRaised.get()) {
            Iterable<EventData> receivedEvents;
            block7: {
                receivedEvents = null;
                try {
                    receivedEvents = this.receiver.receive(this.onReceiveHandler.getMaxEventCount());
                }
                catch (Throwable clientException) {
                    isPumpHealthy = false;
                    this.onReceiveHandler.onError(clientException);
                    if (!TRACE_LOGGER.isWarnEnabled()) break block7;
                    TRACE_LOGGER.warn(String.format("Receive pump for partition (%s) exiting after receive exception %s", this.receiver.getPartitionId(), clientException.toString()));
                }
            }
            try {
                if (receivedEvents == null && (receivedEvents != null || !this.invokeOnTimeout || !isPumpHealthy)) continue;
                this.onReceiveHandler.onReceive(receivedEvents);
            }
            catch (Throwable userCodeError) {
                isPumpHealthy = false;
                this.onReceiveHandler.onError(userCodeError);
                if (userCodeError instanceof InterruptedException) {
                    if (TRACE_LOGGER.isInfoEnabled()) {
                        TRACE_LOGGER.info(String.format("Interrupting receive pump for partition (%s)", this.receiver.getPartitionId()));
                    }
                    Thread.currentThread().interrupt();
                    continue;
                }
                TRACE_LOGGER.error(String.format("Receive pump for partition (%s) exiting after user exception %s", this.receiver.getPartitionId(), userCodeError.toString()));
            }
        }
        this.stopPump.complete(null);
    }

    public CompletableFuture<Void> stop() {
        this.stopPumpRaised.set(true);
        return this.stopPump;
    }

    public boolean isRunning() {
        return !this.stopPump.isDone();
    }

    public static interface IPartitionReceiver {
        public String getPartitionId();

        public Iterable<EventData> receive(int var1) throws EventHubException;
    }
}

