/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.util;

import java.io.IOException;
import java.io.OutputStream;

public class MemoryByteArrayOutputStream
extends OutputStream {
    private int initialBufferSize;
    private int maximumBufferIncrement;
    private int cursor;
    private byte[] buffer;
    private byte[] singleIntArray;

    public MemoryByteArrayOutputStream() {
        this(4096, 65536);
    }

    public MemoryByteArrayOutputStream(int n, int n2) {
        this.initialBufferSize = n;
        this.maximumBufferIncrement = n2;
        this.buffer = new byte[n];
        this.singleIntArray = new byte[1];
    }

    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n2 + n > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureSize(this.cursor + n2);
        System.arraycopy(byArray, n, this.buffer, this.cursor, n2);
        this.cursor += n2;
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public synchronized void write(int n) throws IOException {
        this.singleIntArray[0] = (byte)(0xFF & n);
        this.write(this.singleIntArray, 0, 1);
    }

    private void ensureSize(int n) {
        if (this.buffer.length >= n) {
            return;
        }
        int n2 = (int)Math.min((double)(this.buffer.length + 1) * 1.5, (double)(this.buffer.length + this.maximumBufferIncrement));
        int n3 = Math.max(n, n2);
        byte[] byArray = new byte[n3];
        System.arraycopy(this.buffer, 0, byArray, 0, this.cursor);
        this.buffer = byArray;
    }

    public void flush() throws IOException {
    }

    public void close() throws IOException {
    }

    public synchronized byte[] toByteArray() {
        byte[] byArray = new byte[this.cursor];
        System.arraycopy(this.buffer, 0, byArray, 0, this.cursor);
        return byArray;
    }

    public int getLength() {
        return this.cursor;
    }

    public byte[] getRaw() {
        return this.buffer;
    }
}

