/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.blocksmaker.helpers;

import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.visitors.blocksmaker.helpers.BlocksPair;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public final class BlocksRemoveInfo {
    private final Set<BlocksPair> processed = new HashSet<BlocksPair>();
    private final Set<BlocksPair> outs = new HashSet<BlocksPair>();
    private final Map<RegisterArg, RegisterArg> regMap = new HashMap<RegisterArg, RegisterArg>();
    private BlocksPair start;
    private BlocksPair end;
    private int startSplitIndex;
    private int endSplitIndex;
    private BlockNode startPredecessor;
    private boolean applied;

    public BlocksRemoveInfo(BlocksPair start) {
        this.start = start;
    }

    public Set<BlocksPair> getProcessed() {
        return this.processed;
    }

    public Set<BlocksPair> getOuts() {
        return this.outs;
    }

    public BlocksPair getStart() {
        return this.start;
    }

    public void setStart(BlocksPair start) {
        this.start = start;
    }

    public BlocksPair getEnd() {
        return this.end;
    }

    public void setEnd(BlocksPair end) {
        this.end = end;
    }

    public int getStartSplitIndex() {
        return this.startSplitIndex;
    }

    public void setStartSplitIndex(int startSplitIndex) {
        this.startSplitIndex = startSplitIndex;
    }

    public int getEndSplitIndex() {
        return this.endSplitIndex;
    }

    public void setEndSplitIndex(int endSplitIndex) {
        this.endSplitIndex = endSplitIndex;
    }

    public void setStartPredecessor(BlockNode startPredecessor) {
        this.startPredecessor = startPredecessor;
    }

    public BlockNode getStartPredecessor() {
        return this.startPredecessor;
    }

    public Map<RegisterArg, RegisterArg> getRegMap() {
        return this.regMap;
    }

    @Nullable
    public BlockNode getByFirst(BlockNode first) {
        for (BlocksPair blocksPair : this.processed) {
            if (blocksPair.getFirst() != first) continue;
            return blocksPair.getSecond();
        }
        return null;
    }

    @Nullable
    public BlockNode getBySecond(BlockNode second) {
        for (BlocksPair blocksPair : this.processed) {
            if (blocksPair.getSecond() != second) continue;
            return blocksPair.getSecond();
        }
        return null;
    }

    public boolean isApplied() {
        return this.applied;
    }

    public void setApplied(boolean applied) {
        this.applied = applied;
    }

    public String toString() {
        return "BRI{start: " + this.start + ", end: " + this.end + ", processed: " + this.processed + ", outs: " + this.outs + ", regMap: " + this.regMap + ", split: " + this.startSplitIndex + "-" + this.endSplitIndex + "}";
    }
}

