/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.blocksmaker;

import jadx.core.dex.attributes.AType;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.trycatch.ExcHandlerAttr;
import jadx.core.dex.trycatch.SplitterBlockAttr;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.utils.BlockUtils;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockFinish
extends AbstractVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(BlockFinish.class);

    @Override
    public void visit(MethodNode mth) {
        if (mth.isNoCode()) {
            return;
        }
        for (BlockNode block : mth.getBasicBlocks()) {
            block.updateCleanSuccessors();
            BlockFinish.fixSplitterBlock(mth, block);
        }
        mth.finishBasicBlocks();
    }

    private static void fixSplitterBlock(MethodNode mth, BlockNode block) {
        ExcHandlerAttr excHandlerAttr = block.get(AType.EXC_HANDLER);
        if (excHandlerAttr == null) {
            return;
        }
        BlockNode handlerBlock = excHandlerAttr.getHandler().getHandlerBlock();
        if (handlerBlock.getPredecessors().size() < 2) {
            return;
        }
        HashMap<BlockNode, SplitterBlockAttr> splitters = new HashMap<BlockNode, SplitterBlockAttr>();
        for (BlockNode pred : handlerBlock.getPredecessors()) {
            SplitterBlockAttr splitterAttr = (pred = BlockUtils.skipSyntheticPredecessor(pred)).get(AType.SPLITTER_BLOCK);
            if (splitterAttr == null || pred != splitterAttr.getBlock()) continue;
            splitters.put(pred, splitterAttr);
        }
        if (splitters.size() < 2) {
            return;
        }
        BlockNode topSplitter = BlockUtils.getTopBlock(splitters.keySet());
        if (topSplitter == null) {
            mth.addWarn("Unknown top exception splitter block from list: " + splitters);
            return;
        }
        for (Map.Entry entry : splitters.entrySet()) {
            BlockNode pred = (BlockNode)entry.getKey();
            SplitterBlockAttr splitterAttr = (SplitterBlockAttr)entry.getValue();
            if (pred == topSplitter) {
                block.addAttr(splitterAttr);
                continue;
            }
            pred.remove(AType.SPLITTER_BLOCK);
            for (BlockNode s : pred.getCleanSuccessors()) {
                s.remove(AType.SPLITTER_BLOCK);
            }
        }
    }
}

