/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.info;

import com.android.dex.MethodId;
import com.android.dex.ProtoId;
import jadx.core.codegen.TypeGen;
import jadx.core.dex.info.ClassInfo;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.nodes.DexNode;
import jadx.core.utils.Utils;
import java.util.List;

public final class MethodInfo {
    private final String name;
    private final ArgType retType;
    private final List<ArgType> args;
    private final ClassInfo declClass;
    private final String shortId;
    private String alias;
    private boolean aliasFromPreset;

    private MethodInfo(DexNode dex, int mthIndex) {
        MethodId mthId = dex.getMethodId(mthIndex);
        this.alias = this.name = dex.getString(mthId.getNameIndex());
        this.aliasFromPreset = false;
        this.declClass = ClassInfo.fromDex(dex, mthId.getDeclaringClassIndex());
        ProtoId proto = dex.getProtoId(mthId.getProtoIndex());
        this.retType = dex.getType(proto.getReturnTypeIndex());
        this.args = dex.readParamList(proto.getParametersOffset());
        this.shortId = this.makeSignature(true);
    }

    public static MethodInfo fromDex(DexNode dex, int mthIndex) {
        MethodInfo mth = dex.root().getInfoStorage().getMethod(dex, mthIndex);
        if (mth != null) {
            return mth;
        }
        mth = new MethodInfo(dex, mthIndex);
        return dex.root().getInfoStorage().putMethod(dex, mthIndex, mth);
    }

    public String makeSignature(boolean includeRetType) {
        StringBuilder signature = new StringBuilder();
        signature.append(this.name);
        signature.append('(');
        for (ArgType arg : this.args) {
            signature.append(TypeGen.signature(arg));
        }
        signature.append(')');
        if (includeRetType) {
            signature.append(TypeGen.signature(this.retType));
        }
        return signature.toString();
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return this.declClass.getFullName() + "." + this.name;
    }

    public String getFullId() {
        return this.declClass.getFullName() + "." + this.shortId;
    }

    public String getRawFullId() {
        return this.declClass.makeRawFullName() + "." + this.shortId;
    }

    public String getShortId() {
        return this.shortId;
    }

    public ClassInfo getDeclClass() {
        return this.declClass;
    }

    public ArgType getReturnType() {
        return this.retType;
    }

    public List<ArgType> getArgumentsTypes() {
        return this.args;
    }

    public int getArgsCount() {
        return this.args.size();
    }

    public boolean isConstructor() {
        return this.name.equals("<init>");
    }

    public boolean isClassInit() {
        return this.name.equals("<clinit>");
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public boolean isRenamed() {
        return !this.name.equals(this.alias);
    }

    public boolean isAliasFromPreset() {
        return this.aliasFromPreset;
    }

    public void setAliasFromPreset(boolean value) {
        this.aliasFromPreset = value;
    }

    public int hashCode() {
        int result = this.declClass.hashCode();
        result = 31 * result + this.retType.hashCode();
        result = 31 * result + this.shortId.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MethodInfo)) {
            return false;
        }
        MethodInfo other = (MethodInfo)obj;
        return this.shortId.equals(other.shortId) && this.retType.equals(other.retType) && this.declClass.equals(other.declClass);
    }

    public String toString() {
        return this.declClass.getFullName() + "." + this.name + "(" + Utils.listToString(this.args) + "):" + this.retType;
    }
}

