#!/bin/sh
export PATH='/usr/obj/ports/hs-cmdargs-0.10.18/bin:/usr/bin:/bin:/usr/sbin:/sbin:/usr/local/bin:/usr/X11R6/bin'
echo 'name: cmdargs
version: 0.10.18
id: cmdargs-0.10.18-7Qr7HWgx9P71aSeNykhqeH
key: cmdargs-0.10.18-7Qr7HWgx9P71aSeNykhqeH
license: BSD3
copyright: Neil Mitchell 2009-2017
maintainer: Neil Mitchell <ndmitchell@gmail.com>
homepage: https://github.com/ndmitchell/cmdargs#readme
synopsis: Command line argument processing
description:
    This library provides an easy way to define command line parsers. Most users
    will want to use the "System.Console.CmdArgs.Implicit" module, whose
    documentation contains an example.
    .
    * "System.Console.CmdArgs.Explicit" provides a way to write command line
    parsers for both single mode programs (most programs) and multiple
    mode programs (e.g. darcs or cabal). Parsers are defined by constructing
    a data structure.
    .
    * "System.Console.CmdArgs.Implicit" provides a way to concisely define
    command line parsers, up to three times shorter than getopt. These parsers
    are translated into the Explicit data type.
    .
    * "System.Console.CmdArgs.GetOpt" provides a wrapper allowing compatiblity
    with existing getopt parsers, mapping to the Explicit data type.
    .
    For a general reference on what command line flags are commonly used,
    see <http://www.faqs.org/docs/artu/ch10s05.html>.
category: Console
author: Neil Mitchell <ndmitchell@gmail.com>
exposed: True
indefinite: False
exposed-modules:
    System.Console.CmdArgs System.Console.CmdArgs.Annotate
    System.Console.CmdArgs.Default System.Console.CmdArgs.Explicit
    System.Console.CmdArgs.GetOpt System.Console.CmdArgs.Helper
    System.Console.CmdArgs.Implicit System.Console.CmdArgs.Quote
    System.Console.CmdArgs.Text System.Console.CmdArgs.Verbosity
hidden-modules: Data.Generics.Any Data.Generics.Any.Prelude
                System.Console.CmdArgs.Explicit.Complete
                System.Console.CmdArgs.Explicit.ExpandArgsAt
                System.Console.CmdArgs.Explicit.Help
                System.Console.CmdArgs.Explicit.Process
                System.Console.CmdArgs.Explicit.SplitJoin
                System.Console.CmdArgs.Explicit.Type
                System.Console.CmdArgs.Implicit.Ann
                System.Console.CmdArgs.Implicit.Global
                System.Console.CmdArgs.Implicit.Local
                System.Console.CmdArgs.Implicit.Reader
                System.Console.CmdArgs.Implicit.Reform
                System.Console.CmdArgs.Implicit.Type
                System.Console.CmdArgs.Implicit.UI
abi: 81a2e435c782bfcc6479fd357808030f
trusted: False
import-dirs: /usr/local/lib/ghc/cmdargs-0.10.18
library-dirs: /usr/local/lib/ghc/cmdargs-0.10.18
              /usr/local/lib/x86_64-openbsd-ghc-8.2.2
data-dir: /usr/local/share/hs-cmdargs-0.10.18
hs-libraries: HScmdargs-0.10.18-7Qr7HWgx9P71aSeNykhqeH
depends:
    base-4.10.1.0 filepath-1.4.1.2 transformers-0.5.2.0 process-1.6.1.0
    template-haskell-2.12.0.0
abi-depends: base-4.10.1.0=3319c96bc0bdd0e7df6bb89e8bc8756b
             filepath-1.4.1.2=f49190c9093d895f9f159c40e7d1ff46
             transformers-0.5.2.0=e04579c0363c9229351d1a0b394bf2d5
             process-1.6.1.0=7237ff1c5fb267c936a1910f591febc6
             template-haskell-2.12.0.0=23eb77c3fcb7809b7db73842f3d4fcfe
haddock-interfaces: /usr/local/share/doc/hs-cmdargs-0.10.18/html/cmdargs.haddock
haddock-html: /usr/local/share/doc/hs-cmdargs-0.10.18/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"

