(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/srfi/133#nonneg-int?
    (lambda (_x93831_)
      (if (integer? _x93831_) (not (negative? _x93831_)) '#f)))
  (define std/srfi/133#between?
    (lambda (_x93827_ _y93828_ _z93829_)
      (if (< _x93827_ _y93828_) (<= _y93828_ _z93829_) '#f)))
  (define std/srfi/133#unspecified-value (lambda () (if '#f '#f '#!void)))
  (define std/srfi/133#vectors-ref
    (lambda (_vectors93821_ _i93822_)
      (map (lambda (_v93824_) (vector-ref _v93824_ _i93822_)) _vectors93821_)))
  (define std/srfi/133#check-type
    (lambda (_pred?93817_ _value93818_ _callee93819_)
      (if (_pred?93817_ _value93818_)
          _value93818_
          (std/srfi/133#check-type
           _pred?93817_
           (error '"erroneous value"
                  (list _pred?93817_ _value93818_)
                  (cons 'while (cons 'calling (cons _callee93819_ '()))))
           _callee93819_))))
  (define std/srfi/133#check-index
    (lambda (_vec93811_ _index93812_ _callee93813_)
      (let ((_index93815_
             (std/srfi/133#check-type integer? _index93812_ _callee93813_)))
        (if (< _index93815_ '0)
            (std/srfi/133#check-index
             _vec93811_
             (error '"vector index too low"
                    _index93815_
                    (cons 'into (cons 'vector (cons _vec93811_ '())))
                    (cons 'while (cons 'calling (cons _callee93813_ '()))))
             _callee93813_)
            (if (>= _index93815_ (vector-length _vec93811_))
                (std/srfi/133#check-index
                 _vec93811_
                 (error '"vector index too high"
                        _index93815_
                        (cons 'into (cons 'vector (cons _vec93811_ '())))
                        (cons 'while (cons 'calling (cons _callee93813_ '()))))
                 _callee93813_)
                _index93815_)))))
  (define std/srfi/133#check-indices
    (lambda (_vec93795_
             _start93796_
             _start-name93797_
             _end93798_
             _end-name93799_
             _callee93800_)
      (let ((_lose93804_
             (lambda _things93802_
               (apply error
                      '"vector range out of bounds"
                      (append _things93802_
                              (cons 'vector (cons 'was (cons _vec93795_ '())))
                              (cons _start-name93797_
                                    (cons 'was (cons _start93796_ '())))
                              (cons _end-name93799_
                                    (cons 'was (cons _end93798_ '())))
                              (cons 'while
                                    (cons 'calling
                                          (cons _callee93800_ '())))))))
            (_start93805_
             (std/srfi/133#check-type integer? _start93796_ _callee93800_))
            (_end93806_
             (std/srfi/133#check-type integer? _end93798_ _callee93800_)))
        (if (> _start93805_ _end93806_)
            (let ((_g94006_
                   (_lose93804_
                    (cons _end-name93799_
                          (cons '< (cons _start-name93797_ '()))))))
              (begin
                (let ((_g94007_
                       (if (##values? _g94006_) (##vector-length _g94006_) 1)))
                  (if (not (##fx= _g94007_ 2))
                      (error "Context expects 2 values" _g94007_)))
                (let ((_new-start93808_ (##vector-ref _g94006_ 0))
                      (_new-end93809_ (##vector-ref _g94006_ 1)))
                  (std/srfi/133#check-indices
                   _vec93795_
                   _new-start93808_
                   _start-name93797_
                   _new-end93809_
                   _end-name93799_
                   _callee93800_))))
            (if (< _start93805_ '0)
                (std/srfi/133#check-indices
                 _vec93795_
                 (_lose93804_ (cons _start-name93797_ (cons '< (cons '0 '()))))
                 _start-name93797_
                 _end93806_
                 _end-name93799_
                 _callee93800_)
                (if (>= _start93805_ (vector-length _vec93795_))
                    (std/srfi/133#check-indices
                     _vec93795_
                     (_lose93804_
                      (cons _start-name93797_ (cons '> (cons 'len '())))
                      (cons 'len
                            (cons 'was (cons (vector-length _vec93795_) '()))))
                     _start-name93797_
                     _end93806_
                     _end-name93799_
                     _callee93800_)
                    (if (> _end93806_ (vector-length _vec93795_))
                        (std/srfi/133#check-indices
                         _vec93795_
                         _start93805_
                         _start-name93797_
                         (_lose93804_
                          (cons _end-name93799_ (cons '> (cons 'len '())))
                          (cons 'len
                                (cons 'was
                                      (cons (vector-length _vec93795_) '()))))
                         _end-name93799_
                         _callee93800_)
                        (values _start93805_ _end93806_))))))))
  (define std/srfi/133#vector-parse-start+end
    (lambda (_vec93787_
             _args93788_
             _start-name93789_
             _end-name93790_
             _callee93791_)
      (let ((_len93793_ (vector-length _vec93787_)))
        (if (null? _args93788_)
            (values '0 _len93793_)
            (if (null? (cdr _args93788_))
                (std/srfi/133#check-indices
                 _vec93787_
                 (car _args93788_)
                 _start-name93789_
                 _len93793_
                 _end-name93790_
                 _callee93791_)
                (if (null? (cddr _args93788_))
                    (std/srfi/133#check-indices
                     _vec93787_
                     (car _args93788_)
                     _start-name93789_
                     (cadr _args93788_)
                     _end-name93790_
                     _callee93791_)
                    (error '"too many arguments"
                           (cons 'extra
                                 (cons 'args
                                       (cons 'were
                                             (cons (cddr _args93788_) '()))))
                           (cons 'while
                                 (cons 'calling
                                       (cons _callee93791_ '()))))))))))
  (define std/srfi/133#%smallest-length
    (letrec ((_loop93781_
              (lambda (_vector-list93783_ _length93784_ _callee93785_)
                (if (null? _vector-list93783_)
                    _length93784_
                    (_loop93781_
                     (cdr _vector-list93783_)
                     (min (vector-length
                           (std/srfi/133#check-type
                            vector?
                            (car _vector-list93783_)
                            _callee93785_))
                          _length93784_)
                     _callee93785_)))))
      _loop93781_))
  (define std/srfi/133#%vector-copy!
    (letrec ((_loop/l->r93760_
              (lambda (_target93763_
                       _source93764_
                       _send93765_
                       _i93766_
                       _j93767_)
                (if (< _i93766_ _send93765_)
                    (begin
                      (vector-set!
                       _target93763_
                       _j93767_
                       (vector-ref _source93764_ _i93766_))
                      (_loop/l->r93760_
                       _target93763_
                       _source93764_
                       _send93765_
                       (+ _i93766_ '1)
                       (+ _j93767_ '1)))
                    '#!void)))
             (_loop/r->l93761_
              (lambda (_target93769_
                       _source93770_
                       _sstart93771_
                       _i93772_
                       _j93773_)
                (if (>= _i93772_ _sstart93771_)
                    (begin
                      (vector-set!
                       _target93769_
                       _j93773_
                       (vector-ref _source93770_ _i93772_))
                      (_loop/r->l93761_
                       _target93769_
                       _source93770_
                       _sstart93771_
                       (- _i93772_ '1)
                       (- _j93773_ '1)))
                    '#!void))))
      (lambda (_target93775_
               _tstart93776_
               _source93777_
               _sstart93778_
               _send93779_)
        (if (> _sstart93778_ _tstart93776_)
            (_loop/l->r93760_
             _target93775_
             _source93777_
             _send93779_
             _sstart93778_
             _tstart93776_)
            (_loop/r->l93761_
             _target93775_
             _source93777_
             _sstart93778_
             (- _send93779_ '1)
             (+ '-1 _tstart93776_ _send93779_ (- _sstart93778_)))))))
  (define std/srfi/133#%vector-reverse-copy!
    (letrec ((_loop93746_
              (lambda (_target93748_
                       _source93749_
                       _sstart93750_
                       _i93751_
                       _j93752_)
                (if (>= _i93751_ _sstart93750_)
                    (begin
                      (vector-set!
                       _target93748_
                       _j93752_
                       (vector-ref _source93749_ _i93751_))
                      (_loop93746_
                       _target93748_
                       _source93749_
                       _sstart93750_
                       (- _i93751_ '1)
                       (+ _j93752_ '1)))
                    '#!void))))
      (lambda (_target93754_
               _tstart93755_
               _source93756_
               _sstart93757_
               _send93758_)
        (_loop93746_
         _target93754_
         _source93756_
         _sstart93757_
         (- _send93758_ '1)
         _tstart93755_))))
  (define std/srfi/133#%vector-reverse!
    (letrec ((_loop93734_
              (lambda (_vec93736_ _i93737_ _j93738_)
                (if (<= _i93737_ _j93738_)
                    (let ((_v93740_ (vector-ref _vec93736_ _i93737_)))
                      (vector-set!
                       _vec93736_
                       _i93737_
                       (vector-ref _vec93736_ _j93738_))
                      (vector-set! _vec93736_ _j93738_ _v93740_)
                      (_loop93734_ _vec93736_ (+ _i93737_ '1) (- _j93738_ '1)))
                    '#!void))))
      (lambda (_vec93742_ _start93743_ _end93744_)
        (_loop93734_ _vec93742_ _start93743_ (- _end93744_ '1)))))
  (define std/srfi/133#%vector-fold1
    (letrec ((_loop93721_
              (lambda (_kons93723_ _knil93724_ _len93725_ _vec93726_ _i93727_)
                (if (= _i93727_ _len93725_)
                    _knil93724_
                    (_loop93721_
                     _kons93723_
                     (_kons93723_ _knil93724_ (vector-ref _vec93726_ _i93727_))
                     _len93725_
                     _vec93726_
                     (+ _i93727_ '1))))))
      (lambda (_kons93729_ _knil93730_ _len93731_ _vec93732_)
        (_loop93721_ _kons93729_ _knil93730_ _len93731_ _vec93732_ '0))))
  (define std/srfi/133#%vector-fold2+
    (letrec ((_loop93708_
              (lambda (_kons93710_
                       _knil93711_
                       _len93712_
                       _vectors93713_
                       _i93714_)
                (if (= _i93714_ _len93712_)
                    _knil93711_
                    (_loop93708_
                     _kons93710_
                     (apply _kons93710_
                            _knil93711_
                            (std/srfi/133#vectors-ref _vectors93713_ _i93714_))
                     _len93712_
                     _vectors93713_
                     (+ _i93714_ '1))))))
      (lambda (_kons93716_ _knil93717_ _len93718_ _vectors93719_)
        (_loop93708_ _kons93716_ _knil93717_ _len93718_ _vectors93719_ '0))))
  (define std/srfi/133#%vector-map1!
    (letrec ((_loop93694_
              (lambda (_f93696_ _target93697_ _vec93698_ _i93699_)
                (if (zero? _i93699_)
                    _target93697_
                    (let ((_j93701_ (- _i93699_ '1)))
                      (vector-set!
                       _target93697_
                       _j93701_
                       (_f93696_ (vector-ref _vec93698_ _j93701_)))
                      (_loop93694_
                       _f93696_
                       _target93697_
                       _vec93698_
                       _j93701_))))))
      (lambda (_f93703_ _target93704_ _vec93705_ _len93706_)
        (_loop93694_ _f93703_ _target93704_ _vec93705_ _len93706_))))
  (define std/srfi/133#%vector-map2+!
    (letrec ((_loop93680_
              (lambda (_f93682_ _target93683_ _vectors93684_ _i93685_)
                (if (zero? _i93685_)
                    _target93683_
                    (let ((_j93687_ (- _i93685_ '1)))
                      (vector-set!
                       _target93683_
                       _j93687_
                       (apply _f93682_
                              (std/srfi/133#vectors-ref
                               _vectors93684_
                               _j93687_)))
                      (_loop93680_
                       _f93682_
                       _target93683_
                       _vectors93684_
                       _j93687_))))))
      (lambda (_f93689_ _target93690_ _vectors93691_ _len93692_)
        (_loop93680_ _f93689_ _target93690_ _vectors93691_ _len93692_))))
  (define std/srfi/133#vector-unfold
    (lambda (_f93674_ _length93675_ . _initial-seeds93676_)
      (letrec* ((_vec93678_ (make-vector _length93675_)))
        (apply std/srfi/133#vector-unfold!
               _f93674_
               _vec93678_
               '0
               _length93675_
               _initial-seeds93676_)
        _vec93678_)))
  (define std/srfi/133#vector-unfold!
    (letrec ((_tabulate!93636_
              (lambda (_f93640_ _vec93641_ _i93642_ _len93643_)
                (if (< _i93642_ _len93643_)
                    (begin
                      (vector-set! _vec93641_ _i93642_ (_f93640_ _i93642_))
                      (_tabulate!93636_
                       _f93640_
                       _vec93641_
                       (+ _i93642_ '1)
                       _len93643_))
                    '#!void)))
             (_unfold1!93637_
              (lambda (_f93645_ _vec93646_ _i93647_ _len93648_ _seed93649_)
                (if (< _i93647_ _len93648_)
                    (let ((_g94008_ (_f93645_ _i93647_ _seed93649_)))
                      (begin
                        (let ((_g94009_
                               (if (##values? _g94008_)
                                   (##vector-length _g94008_)
                                   1)))
                          (if (not (##fx= _g94009_ 2))
                              (error "Context expects 2 values" _g94009_)))
                        (let ((_elt93651_ (##vector-ref _g94008_ 0))
                              (_new-seed93652_ (##vector-ref _g94008_ 1)))
                          (begin
                            (vector-set! _vec93646_ _i93647_ _elt93651_)
                            (_unfold1!93637_
                             _f93645_
                             _vec93646_
                             (+ _i93647_ '1)
                             _len93648_
                             _new-seed93652_)))))
                    '#!void)))
             (_unfold2+!93638_
              (lambda (_f93654_ _vec93655_ _i93656_ _len93657_ _seeds93658_)
                (if (< _i93656_ _len93657_)
                    (let ((_g94010_ (apply _f93654_ _i93656_ _seeds93658_)))
                      (begin
                        (let ((_g94011_
                               (if (##values? _g94010_)
                                   (##vector-length _g94010_)
                                   1)))
                          (if (not (##fx>= _g94011_ 1))
                              (error "Context expects at least 1 values"
                                     _g94011_)))
                        (let ((_elt93660_
                               (if (##values? _g94010_)
                                   (##vector-ref _g94010_ 0)
                                   _g94010_))
                              (_new-seeds93661_
                               (if (##values? _g94010_)
                                   (##cdr (##vector->list _g94010_))
                                   '())))
                          (begin
                            (vector-set! _vec93655_ _i93656_ _elt93660_)
                            (_unfold2+!93638_
                             _f93654_
                             _vec93655_
                             (+ _i93656_ '1)
                             _len93657_
                             _new-seeds93661_)))))
                    '#!void))))
      (lambda (_f93663_
               _vec93664_
               _start93665_
               _end93666_
               .
               _initial-seeds93667_)
        (let ((_f93669_
               (std/srfi/133#check-type
                procedure?
                _f93663_
                std/srfi/133#vector-unfold!))
              (_start93670_
               (std/srfi/133#check-type
                std/srfi/133#nonneg-int?
                _start93665_
                std/srfi/133#vector-unfold!))
              (_end93671_
               (std/srfi/133#check-type
                std/srfi/133#nonneg-int?
                _end93666_
                std/srfi/133#vector-unfold!)))
          (let ()
            (if (null? _initial-seeds93667_)
                (_tabulate!93636_ _f93669_ _vec93664_ _start93670_ _end93671_)
                (if (null? (cdr _initial-seeds93667_))
                    (_unfold1!93637_
                     _f93669_
                     _vec93664_
                     _start93670_
                     _end93671_
                     (car _initial-seeds93667_))
                    (_unfold2+!93638_
                     _f93669_
                     _vec93664_
                     _start93670_
                     _end93671_
                     _initial-seeds93667_))))))))
  (define std/srfi/133#vector-unfold-right
    (lambda (_f93630_ _len93631_ . _initial-seeds93632_)
      (letrec* ((_vec93634_ (make-vector _len93631_)))
        (apply std/srfi/133#vector-unfold-right!
               _f93630_
               _vec93634_
               '0
               _len93631_
               _initial-seeds93632_)
        _vec93634_)))
  (define std/srfi/133#vector-unfold-right!
    (lambda (_f93594_
             _vec93595_
             _start93596_
             _end93597_
             .
             _initial-seeds93598_)
      (letrec ((_tabulate!93600_
                (lambda (_f93604_ _vec93605_ _i93606_)
                  (if (>= _i93606_ _start93596_)
                      (begin
                        (vector-set! _vec93605_ _i93606_ (_f93604_ _i93606_))
                        (_tabulate!93600_ _f93604_ _vec93605_ (- _i93606_ '1)))
                      '#!void)))
               (_unfold1!93601_
                (lambda (_f93608_ _vec93609_ _i93610_ _seed93611_)
                  (if (>= _i93610_ _start93596_)
                      (let ((_g94012_ (_f93608_ _i93610_ _seed93611_)))
                        (begin
                          (let ((_g94013_
                                 (if (##values? _g94012_)
                                     (##vector-length _g94012_)
                                     1)))
                            (if (not (##fx= _g94013_ 2))
                                (error "Context expects 2 values" _g94013_)))
                          (let ((_elt93613_ (##vector-ref _g94012_ 0))
                                (_new-seed93614_ (##vector-ref _g94012_ 1)))
                            (begin
                              (vector-set! _vec93609_ _i93610_ _elt93613_)
                              (_unfold1!93601_
                               _f93608_
                               _vec93609_
                               (- _i93610_ '1)
                               _new-seed93614_)))))
                      '#!void)))
               (_unfold2+!93602_
                (lambda (_f93616_ _vec93617_ _i93618_ _seeds93619_)
                  (if (>= _i93618_ _start93596_)
                      (let ((_g94014_ (apply _f93616_ _i93618_ _seeds93619_)))
                        (begin
                          (let ((_g94015_
                                 (if (##values? _g94014_)
                                     (##vector-length _g94014_)
                                     1)))
                            (if (not (##fx>= _g94015_ 1))
                                (error "Context expects at least 1 values"
                                       _g94015_)))
                          (let ((_elt93621_
                                 (if (##values? _g94014_)
                                     (##vector-ref _g94014_ 0)
                                     _g94014_))
                                (_new-seeds93622_
                                 (if (##values? _g94014_)
                                     (##cdr (##vector->list _g94014_))
                                     '())))
                            (begin
                              (vector-set! _vec93617_ _i93618_ _elt93621_)
                              (_unfold2+!93602_
                               _f93616_
                               _vec93617_
                               (- _i93618_ '1)
                               _new-seeds93622_)))))
                      '#!void))))
        (let ((_f93624_
               (std/srfi/133#check-type
                procedure?
                _f93594_
                std/srfi/133#vector-unfold-right!))
              (_start93625_
               (std/srfi/133#check-type
                std/srfi/133#nonneg-int?
                _start93596_
                std/srfi/133#vector-unfold-right!))
              (_end93626_
               (std/srfi/133#check-type
                std/srfi/133#nonneg-int?
                _end93597_
                std/srfi/133#vector-unfold-right!)))
          (let ((_i93628_ (- _end93626_ '1)))
            (if (null? _initial-seeds93598_)
                (_tabulate!93600_ _f93624_ _vec93595_ _i93628_)
                (if (null? (cdr _initial-seeds93598_))
                    (_unfold1!93601_
                     _f93624_
                     _vec93595_
                     _i93628_
                     (car _initial-seeds93598_))
                    (_unfold2+!93602_
                     _f93624_
                     _vec93595_
                     _i93628_
                     _initial-seeds93598_))))))))
  (define std/srfi/133#vector-copy
    (lambda (_vec93583_ . _args93584_)
      (let* ((_vec93586_
              (std/srfi/133#check-type
               vector?
               _vec93583_
               std/srfi/133#vector-copy))
             (_g94016_
              (std/srfi/133#vector-copy:parse-args _vec93586_ _args93584_)))
        (begin
          (let ((_g94017_
                 (if (##values? _g94016_) (##vector-length _g94016_) 1)))
            (if (not (##fx= _g94017_ 3))
                (error "Context expects 3 values" _g94017_)))
          (let ((_start93588_ (##vector-ref _g94016_ 0))
                (_end93589_ (##vector-ref _g94016_ 1))
                (_fill93590_ (##vector-ref _g94016_ 2)))
            (let ((_new-vector93592_
                   (make-vector (- _end93589_ _start93588_) _fill93590_)))
              (std/srfi/133#%vector-copy!
               _new-vector93592_
               '0
               _vec93586_
               _start93588_
               (if (> _end93589_ (vector-length _vec93586_))
                   (vector-length _vec93586_)
                   _end93589_))
              _new-vector93592_))))))
  (define std/srfi/133#vector-copy:parse-args
    (lambda (_vec93568_ _args93569_)
      (letrec ((_parse-args93571_
                (lambda (_start93575_ _end93576_ _n93577_ _fill93578_)
                  (let ((_start93580_
                         (std/srfi/133#check-type
                          std/srfi/133#nonneg-int?
                          _start93575_
                          std/srfi/133#vector-copy))
                        (_end93581_
                         (std/srfi/133#check-type
                          std/srfi/133#nonneg-int?
                          _end93576_
                          std/srfi/133#vector-copy)))
                    (if (and (<= '0 _start93580_ _end93581_)
                             (<= _start93580_ _n93577_))
                        (values _start93580_ _end93581_ _fill93578_)
                        (error '"illegal arguments"
                               (cons 'while
                                     (cons 'calling
                                           (cons std/srfi/133#vector-copy
                                                 '())))
                               (cons 'start
                                     (cons 'was (cons _start93580_ '())))
                               (cons 'end (cons 'was (cons _end93581_ '())))
                               (cons 'vector
                                     (cons 'was (cons _vec93568_ '())))))))))
        (let ((_n93573_ (vector-length _vec93568_)))
          (if (null? _args93569_)
              (_parse-args93571_
               '0
               _n93573_
               _n93573_
               (std/srfi/133#unspecified-value))
              (if (null? (cdr _args93569_))
                  (_parse-args93571_
                   (car _args93569_)
                   _n93573_
                   _n93573_
                   (std/srfi/133#unspecified-value))
                  (if (null? (cddr _args93569_))
                      (_parse-args93571_
                       (car _args93569_)
                       (cadr _args93569_)
                       _n93573_
                       (std/srfi/133#unspecified-value))
                      (if (null? (cdddr _args93569_))
                          (_parse-args93571_
                           (car _args93569_)
                           (cadr _args93569_)
                           _n93573_
                           (caddr _args93569_))
                          (error '"too many arguments"
                                 std/srfi/133#vector-copy
                                 (cdddr _args93569_))))))))))
  (define std/srfi/133#vector-reverse-copy
    (lambda (_vec93558_ . _maybe-start+end93559_)
      (let* ((_vec93561_
              (std/srfi/133#check-type
               vector?
               _vec93558_
               std/srfi/133#vector-reverse-copy))
             (_g94018_
              (std/srfi/133#vector-parse-start+end
               _vec93561_
               _maybe-start+end93559_
               'start
               'end
               std/srfi/133#vector-reverse-copy)))
        (begin
          (let ((_g94019_
                 (if (##values? _g94018_) (##vector-length _g94018_) 1)))
            (if (not (##fx= _g94019_ 2))
                (error "Context expects 2 values" _g94019_)))
          (let ((_start93563_ (##vector-ref _g94018_ 0))
                (_end93564_ (##vector-ref _g94018_ 1)))
            (let ((_new93566_ (make-vector (- _end93564_ _start93563_))))
              (std/srfi/133#%vector-reverse-copy!
               _new93566_
               '0
               _vec93561_
               _start93563_
               _end93564_)
              _new93566_))))))
  (define std/srfi/133#vector-append
    (lambda _vectors93556_
      (std/srfi/133#vector-concatenate:aux
       _vectors93556_
       std/srfi/133#vector-append)))
  (define std/srfi/133#vector-concatenate
    (lambda (_vector-list93554_)
      (std/srfi/133#vector-concatenate:aux
       _vector-list93554_
       std/srfi/133#vector-concatenate)))
  (define std/srfi/133#vector-concatenate:aux
    (letrec ((_compute-length93524_
              (lambda (_vectors93527_ _len93528_ _callee93529_)
                (if (null? _vectors93527_)
                    _len93528_
                    (let ((_vec93531_
                           (std/srfi/133#check-type
                            vector?
                            (car _vectors93527_)
                            _callee93529_)))
                      (_compute-length93524_
                       (cdr _vectors93527_)
                       (+ (vector-length _vec93531_) _len93528_)
                       _callee93529_)))))
             (_concatenate!93525_
              (lambda (_vectors93533_ _target93534_ _to93535_)
                (if (null? _vectors93533_)
                    _target93534_
                    (let* ((_vec193537_ (car _vectors93533_))
                           (_len93539_ (vector-length _vec193537_)))
                      (std/srfi/133#%vector-copy!
                       _target93534_
                       _to93535_
                       _vec193537_
                       '0
                       _len93539_)
                      (_concatenate!93525_
                       (cdr _vectors93533_)
                       _target93534_
                       (+ _to93535_ _len93539_)))))))
      (lambda (_vectors93542_ _callee93543_)
        (if (null? _vectors93542_)
            (make-vector '0)
            (if (null? (cdr _vectors93542_))
                (let* ((_vec93545_
                        (std/srfi/133#check-type
                         vector?
                         (car _vectors93542_)
                         _callee93543_))
                       (_len93547_ (vector-length _vec93545_))
                       (_new93549_ (make-vector _len93547_)))
                  (std/srfi/133#%vector-copy!
                   _new93549_
                   '0
                   _vec93545_
                   '0
                   _len93547_)
                  _new93549_)
                (let ((_new-vector93552_
                       (make-vector
                        (_compute-length93524_
                         _vectors93542_
                         '0
                         _callee93543_))))
                  (_concatenate!93525_ _vectors93542_ _new-vector93552_ '0)
                  _new-vector93552_))))))
  (define std/srfi/133#vector-append-subvectors
    (lambda _args93475_
      (letrec ((_gather-args93477_
                (lambda (_args93515_)
                  (let _loop93517_ ((_args93519_ _args93515_)
                                    (_vecs93520_ '())
                                    (_starts93521_ '())
                                    (_ends93522_ '()))
                    (if (null? _args93519_)
                        (values (reverse _vecs93520_)
                                (reverse _starts93521_)
                                (reverse _ends93522_))
                        (_loop93517_
                         (cdddr _args93519_)
                         (cons (car _args93519_) _vecs93520_)
                         (cons (cadr _args93519_) _starts93521_)
                         (cons (caddr _args93519_) _ends93522_))))))
               (_total-length93478_
                (lambda (_starts93503_ _ends93504_)
                  (let _loop93506_ ((_count93508_ '0)
                                    (_starts93509_ _starts93503_)
                                    (_ends93510_ _ends93504_))
                    (if (null? _starts93509_)
                        _count93508_
                        (let ((_start93512_ (car _starts93509_))
                              (_end93513_ (car _ends93510_)))
                          (_loop93506_
                           (+ _count93508_ (- _end93513_ _start93512_))
                           (cdr _starts93509_)
                           (cdr _ends93510_)))))))
               (_copy-each!93479_
                (lambda (_result93487_ _vecs93488_ _starts93489_ _ends93490_)
                  (let _loop93492_ ((_at93494_ '0)
                                    (_vecs93495_ _vecs93488_)
                                    (_starts93496_ _starts93489_)
                                    (_ends93497_ _ends93490_))
                    (if (null? _vecs93495_)
                        _result93487_
                        (let ((_vec93499_ (car _vecs93495_))
                              (_start93500_ (car _starts93496_))
                              (_end93501_ (car _ends93497_)))
                          (std/srfi/133#%vector-copy!
                           _result93487_
                           _at93494_
                           _vec93499_
                           _start93500_
                           _end93501_)
                          (_loop93492_
                           (+ _at93494_ (- _end93501_ _start93500_))
                           (cdr _vecs93495_)
                           (cdr _starts93496_)
                           (cdr _ends93497_))))))))
        (let ((_g94020_ (_gather-args93477_ _args93475_)))
          (begin
            (let ((_g94021_
                   (if (##values? _g94020_) (##vector-length _g94020_) 1)))
              (if (not (##fx= _g94021_ 3))
                  (error "Context expects 3 values" _g94021_)))
            (let ((_vecs93481_ (##vector-ref _g94020_ 0))
                  (_starts93482_ (##vector-ref _g94020_ 1))
                  (_ends93483_ (##vector-ref _g94020_ 2)))
              (letrec* ((_result93485_
                         (make-vector
                          (_total-length93478_ _starts93482_ _ends93483_))))
                (_copy-each!93479_
                 _result93485_
                 _vecs93481_
                 _starts93482_
                 _ends93483_))))))))
  (define std/srfi/133#vector-empty?
    (lambda (_vec93471_)
      (let ((_vec93473_
             (std/srfi/133#check-type
              vector?
              _vec93471_
              std/srfi/133#vector-empty?)))
        (zero? (vector-length _vec93473_)))))
  (define std/srfi/133#vector=
    (lambda (_elt=?93456_ . _vectors93457_)
      (let ((_elt=?93459_
             (std/srfi/133#check-type
              procedure?
              _elt=?93456_
              std/srfi/133#vector=)))
        (if (null? _vectors93457_)
            '#t
            (if (null? (cdr _vectors93457_))
                (begin
                  (std/srfi/133#check-type
                   vector?
                   (car _vectors93457_)
                   std/srfi/133#vector=)
                  '#t)
                (let _loop93461_ ((_vecs93463_ _vectors93457_))
                  (let ((_vec193465_
                         (std/srfi/133#check-type
                          vector?
                          (car _vecs93463_)
                          std/srfi/133#vector=))
                        (_vec2+93466_ (cdr _vecs93463_)))
                    (let ((_$e93468_ (null? _vec2+93466_)))
                      (if _$e93468_
                          _$e93468_
                          (if (std/srfi/133#binary-vector=
                               _elt=?93459_
                               _vec193465_
                               (car _vec2+93466_))
                              (_loop93461_ _vec2+93466_)
                              '#f))))))))))
  (define std/srfi/133#binary-vector=
    (lambda (_elt=?93445_ _vector-a93446_ _vector-b93447_)
      (let ((_length-a93449_ (vector-length _vector-a93446_))
            (_length-b93450_ (vector-length _vector-b93447_)))
        (if (= _length-a93449_ _length-b93450_)
            (let _loop93452_ ((_i93454_ '0))
              (if (= _i93454_ _length-a93449_)
                  '#t
                  (if (_elt=?93445_
                       (vector-ref _vector-a93446_ _i93454_)
                       (vector-ref _vector-b93447_ _i93454_))
                      (_loop93452_ (+ _i93454_ '1))
                      '#f)))
            '#f))))
  (define std/srfi/133#vector-fold
    (lambda (_kons93437_ _knil93438_ _vec93439_ . _vectors93440_)
      (let ((_kons93442_
             (std/srfi/133#check-type
              procedure?
              _kons93437_
              std/srfi/133#vector-fold))
            (_vec93443_
             (std/srfi/133#check-type
              vector?
              _vec93439_
              std/srfi/133#vector-fold)))
        (if (null? _vectors93440_)
            (std/srfi/133#%vector-fold1
             _kons93442_
             _knil93438_
             (vector-length _vec93443_)
             _vec93443_)
            (std/srfi/133#%vector-fold2+
             _kons93442_
             _knil93438_
             (std/srfi/133#%smallest-length
              _vectors93440_
              (vector-length _vec93443_)
              std/srfi/133#vector-fold)
             (cons _vec93443_ _vectors93440_))))))
  (define std/srfi/133#vector-fold-right
    (letrec ((_loop193416_
              (lambda (_kons93419_ _knil93420_ _vec93421_ _i93422_)
                (if (negative? _i93422_)
                    _knil93420_
                    (_loop193416_
                     _kons93419_
                     (_kons93419_ _knil93420_ (vector-ref _vec93421_ _i93422_))
                     _vec93421_
                     (- _i93422_ '1)))))
             (_loop2+93417_
              (lambda (_kons93424_ _knil93425_ _vectors93426_ _i93427_)
                (if (negative? _i93427_)
                    _knil93425_
                    (_loop2+93417_
                     _kons93424_
                     (apply _kons93424_
                            _knil93425_
                            (std/srfi/133#vectors-ref _vectors93426_ _i93427_))
                     _vectors93426_
                     (- _i93427_ '1))))))
      (lambda (_kons93429_ _knil93430_ _vec93431_ . _vectors93432_)
        (let ((_kons93434_
               (std/srfi/133#check-type
                procedure?
                _kons93429_
                std/srfi/133#vector-fold-right))
              (_vec93435_
               (std/srfi/133#check-type
                vector?
                _vec93431_
                std/srfi/133#vector-fold-right)))
          (if (null? _vectors93432_)
              (_loop193416_
               _kons93434_
               _knil93430_
               _vec93435_
               (- (vector-length _vec93435_) '1))
              (_loop2+93417_
               _kons93434_
               _knil93430_
               (cons _vec93435_ _vectors93432_)
               (- (std/srfi/133#%smallest-length
                   _vectors93432_
                   (vector-length _vec93435_)
                   std/srfi/133#vector-fold-right)
                  '1)))))))
  (define std/srfi/133#vector-map
    (lambda (_f93405_ _vec93406_ . _vectors93407_)
      (let ((_f93409_
             (std/srfi/133#check-type
              procedure?
              _f93405_
              std/srfi/133#vector-map))
            (_vec93410_
             (std/srfi/133#check-type
              vector?
              _vec93406_
              std/srfi/133#vector-map)))
        (if (null? _vectors93407_)
            (let ((_len93412_ (vector-length _vec93410_)))
              (std/srfi/133#%vector-map1!
               _f93409_
               (make-vector _len93412_)
               _vec93410_
               _len93412_))
            (let ((_len93414_
                   (std/srfi/133#%smallest-length
                    _vectors93407_
                    (vector-length _vec93410_)
                    std/srfi/133#vector-map)))
              (std/srfi/133#%vector-map2+!
               _f93409_
               (make-vector _len93414_)
               (cons _vec93410_ _vectors93407_)
               _len93414_))))))
  (define std/srfi/133#vector-map!
    (lambda (_f93398_ _vec93399_ . _vectors93400_)
      (let ((_f93402_
             (std/srfi/133#check-type
              procedure?
              _f93398_
              std/srfi/133#vector-map!))
            (_vec93403_
             (std/srfi/133#check-type
              vector?
              _vec93399_
              std/srfi/133#vector-map!)))
        (if (null? _vectors93400_)
            (std/srfi/133#%vector-map1!
             _f93402_
             _vec93403_
             _vec93403_
             (vector-length _vec93403_))
            (std/srfi/133#%vector-map2+!
             _f93402_
             _vec93403_
             (cons _vec93403_ _vectors93400_)
             (std/srfi/133#%smallest-length
              _vectors93400_
              (vector-length _vec93403_)
              std/srfi/133#vector-map!)))
        (std/srfi/133#unspecified-value))))
  (define std/srfi/133#vector-for-each
    (letrec ((_for-each193378_
              (lambda (_f93381_ _vec93382_ _i93383_ _len93384_)
                (if (< _i93383_ _len93384_)
                    (begin
                      (_f93381_ (vector-ref _vec93382_ _i93383_))
                      (_for-each193378_
                       _f93381_
                       _vec93382_
                       (+ _i93383_ '1)
                       _len93384_))
                    '#!void)))
             (_for-each2+93379_
              (lambda (_f93386_ _vecs93387_ _i93388_ _len93389_)
                (if (< _i93388_ _len93389_)
                    (begin
                      (apply _f93386_
                             (std/srfi/133#vectors-ref _vecs93387_ _i93388_))
                      (_for-each2+93379_
                       _f93386_
                       _vecs93387_
                       (+ _i93388_ '1)
                       _len93389_))
                    '#!void))))
      (lambda (_f93391_ _vec93392_ . _vectors93393_)
        (let ((_f93395_
               (std/srfi/133#check-type
                procedure?
                _f93391_
                std/srfi/133#vector-for-each))
              (_vec93396_
               (std/srfi/133#check-type
                vector?
                _vec93392_
                std/srfi/133#vector-for-each)))
          (if (null? _vectors93393_)
              (_for-each193378_
               _f93395_
               _vec93396_
               '0
               (vector-length _vec93396_))
              (_for-each2+93379_
               _f93395_
               (cons _vec93396_ _vectors93393_)
               '0
               (std/srfi/133#%smallest-length
                _vectors93393_
                (vector-length _vec93396_)
                std/srfi/133#vector-for-each)))))))
  (define std/srfi/133#vector-count
    (lambda (_pred?93365_ _vec93366_ . _vectors93367_)
      (let ((_pred?93369_
             (std/srfi/133#check-type
              procedure?
              _pred?93365_
              std/srfi/133#vector-count))
            (_vec93370_
             (std/srfi/133#check-type
              vector?
              _vec93366_
              std/srfi/133#vector-count)))
        (if (null? _vectors93367_)
            (std/srfi/133#%vector-fold1
             (lambda (_count93372_ _elt93373_)
               (if (_pred?93369_ _elt93373_) (+ _count93372_ '1) _count93372_))
             '0
             (vector-length _vec93370_)
             _vec93370_)
            (std/srfi/133#%vector-fold2+
             (lambda (_count93375_ . _elts93376_)
               (if (apply _pred?93369_ _elts93376_)
                   (+ _count93375_ '1)
                   _count93375_))
             '0
             (std/srfi/133#%smallest-length
              _vectors93367_
              (vector-length _vec93370_)
              std/srfi/133#vector-count)
             (cons _vec93370_ _vectors93367_))))))
  (define std/srfi/133#vector-cumulate
    (lambda (_f93346_ _knil93347_ _vec93348_)
      (let* ((_len93350_ (vector-length _vec93348_))
             (_result93352_ (make-vector _len93350_)))
        (let _loop93355_ ((_i93357_ '0) (_left93358_ _knil93347_))
          (if (= _i93357_ _len93350_)
              _result93352_
              (let* ((_right93360_ (vector-ref _vec93348_ _i93357_))
                     (_r93362_ (_f93346_ _left93358_ _right93360_)))
                (vector-set! _result93352_ _i93357_ _r93362_)
                (_loop93355_ (+ _i93357_ '1) _r93362_)))))))
  (define std/srfi/133#vector-index
    (lambda (_pred?93342_ _vec93343_ . _vectors93344_)
      (std/srfi/133#vector-index/skip
       _pred?93342_
       _vec93343_
       _vectors93344_
       std/srfi/133#vector-index)))
  (define std/srfi/133#vector-skip
    (lambda (_pred?93336_ _vec93337_ . _vectors93338_)
      (std/srfi/133#vector-index/skip
       (lambda _elts93340_ (not (apply _pred?93336_ _elts93340_)))
       _vec93337_
       _vectors93338_
       std/srfi/133#vector-skip)))
  (define std/srfi/133#vector-index/skip
    (letrec ((_loop193315_
              (lambda (_pred?93318_ _vec93319_ _len93320_ _i93321_)
                (if (= _i93321_ _len93320_)
                    '#f
                    (if (_pred?93318_ (vector-ref _vec93319_ _i93321_))
                        _i93321_
                        (_loop193315_
                         _pred?93318_
                         _vec93319_
                         _len93320_
                         (+ _i93321_ '1))))))
             (_loop2+93316_
              (lambda (_pred?93323_ _vectors93324_ _len93325_ _i93326_)
                (if (= _i93326_ _len93325_)
                    '#f
                    (if (apply _pred?93323_
                               (std/srfi/133#vectors-ref
                                _vectors93324_
                                _i93326_))
                        _i93326_
                        (_loop2+93316_
                         _pred?93323_
                         _vectors93324_
                         _len93325_
                         (+ _i93326_ '1)))))))
      (lambda (_pred?93328_ _vec93329_ _vectors93330_ _callee93331_)
        (let ((_pred?93333_
               (std/srfi/133#check-type procedure? _pred?93328_ _callee93331_))
              (_vec93334_
               (std/srfi/133#check-type vector? _vec93329_ _callee93331_)))
          (if (null? _vectors93330_)
              (_loop193315_
               _pred?93333_
               _vec93334_
               (vector-length _vec93334_)
               '0)
              (_loop2+93316_
               _pred?93333_
               (cons _vec93334_ _vectors93330_)
               (std/srfi/133#%smallest-length
                _vectors93330_
                (vector-length _vec93334_)
                _callee93331_)
               '0))))))
  (define std/srfi/133#vector-index-right
    (lambda (_pred?93311_ _vec93312_ . _vectors93313_)
      (std/srfi/133#vector-index/skip-right
       _pred?93311_
       _vec93312_
       _vectors93313_
       std/srfi/133#vector-index-right)))
  (define std/srfi/133#vector-skip-right
    (lambda (_pred?93305_ _vec93306_ . _vectors93307_)
      (std/srfi/133#vector-index/skip-right
       (lambda _elts93309_ (not (apply _pred?93305_ _elts93309_)))
       _vec93306_
       _vectors93307_
       std/srfi/133#vector-index-right)))
  (define std/srfi/133#vector-index/skip-right
    (letrec ((_loop193286_
              (lambda (_pred?93289_ _vec93290_ _i93291_)
                (if (negative? _i93291_)
                    '#f
                    (if (_pred?93289_ (vector-ref _vec93290_ _i93291_))
                        _i93291_
                        (_loop193286_
                         _pred?93289_
                         _vec93290_
                         (- _i93291_ '1))))))
             (_loop2+93287_
              (lambda (_pred?93293_ _vectors93294_ _i93295_)
                (if (negative? _i93295_)
                    '#f
                    (if (apply _pred?93293_
                               (std/srfi/133#vectors-ref
                                _vectors93294_
                                _i93295_))
                        _i93295_
                        (_loop2+93287_
                         _pred?93293_
                         _vectors93294_
                         (- _i93295_ '1)))))))
      (lambda (_pred?93297_ _vec93298_ _vectors93299_ _callee93300_)
        (let ((_pred?93302_
               (std/srfi/133#check-type procedure? _pred?93297_ _callee93300_))
              (_vec93303_
               (std/srfi/133#check-type vector? _vec93298_ _callee93300_)))
          (if (null? _vectors93299_)
              (_loop193286_
               _pred?93302_
               _vec93303_
               (- (vector-length _vec93303_) '1))
              (_loop2+93287_
               _pred?93302_
               (cons _vec93303_ _vectors93299_)
               (- (std/srfi/133#%smallest-length
                   _vectors93299_
                   (vector-length _vec93303_)
                   _callee93300_)
                  '1)))))))
  (define std/srfi/133#vector-binary-search
    (lambda (_vec93261_ _value93262_ _cmp93263_ . _maybe-start+end93264_)
      (let* ((_cmp93266_
              (std/srfi/133#check-type
               procedure?
               _cmp93263_
               std/srfi/133#vector-binary-search))
             (_vec93268_
              (std/srfi/133#check-type
               vector?
               _vec93261_
               std/srfi/133#vector-binary-search))
             (_g94022_
              (std/srfi/133#vector-parse-start+end
               _vec93268_
               _maybe-start+end93264_
               'start
               'end
               std/srfi/133#vector-binary-search)))
        (begin
          (let ((_g94023_
                 (if (##values? _g94022_) (##vector-length _g94022_) 1)))
            (if (not (##fx= _g94023_ 2))
                (error "Context expects 2 values" _g94023_)))
          (let ((_start93270_ (##vector-ref _g94022_ 0))
                (_end93271_ (##vector-ref _g94022_ 1)))
            (let _loop93273_ ((_start93275_ _start93270_)
                              (_end93276_ _end93271_)
                              (_j93277_ '#f))
              (let ((_i93279_ (quotient (+ _start93275_ _end93276_) '2)))
                (if (or (= _start93275_ _end93276_)
                        (and _j93277_ (= _i93279_ _j93277_)))
                    '#f
                    (let ((_comparison93284_
                           (std/srfi/133#check-type
                            integer?
                            (_cmp93266_
                             (vector-ref _vec93268_ _i93279_)
                             _value93262_)
                            (cons _cmp93266_
                                  (cons 'for
                                        (cons std/srfi/133#vector-binary-search
                                              '()))))))
                      (if (zero? _comparison93284_)
                          _i93279_
                          (if (positive? _comparison93284_)
                              (_loop93273_ _start93275_ _i93279_ _i93279_)
                              (_loop93273_
                               _i93279_
                               _end93276_
                               _i93279_))))))))))))
  (define std/srfi/133#vector-any
    (letrec ((_loop193229_
              (lambda (_pred?93232_
                       _vec93233_
                       _i93234_
                       _len93235_
                       _len-193236_)
                (if (not (= _i93234_ _len93235_))
                    (if (= _i93234_ _len-193236_)
                        (_pred?93232_ (vector-ref _vec93233_ _i93234_))
                        (let ((_$e93238_
                               (_pred?93232_
                                (vector-ref _vec93233_ _i93234_))))
                          (if _$e93238_
                              _$e93238_
                              (_loop193229_
                               _pred?93232_
                               _vec93233_
                               (+ _i93234_ '1)
                               _len93235_
                               _len-193236_))))
                    '#f)))
             (_loop2+93230_
              (lambda (_pred?93241_
                       _vectors93242_
                       _i93243_
                       _len93244_
                       _len-193245_)
                (if (not (= _i93243_ _len93244_))
                    (if (= _i93243_ _len-193245_)
                        (apply _pred?93241_
                               (std/srfi/133#vectors-ref
                                _vectors93242_
                                _i93243_))
                        (let ((_$e93247_
                               (apply _pred?93241_
                                      (std/srfi/133#vectors-ref
                                       _vectors93242_
                                       _i93243_))))
                          (if _$e93247_
                              _$e93247_
                              (_loop2+93230_
                               _pred?93241_
                               _vectors93242_
                               (+ _i93243_ '1)
                               _len93244_
                               _len-193245_))))
                    '#f))))
      (lambda (_pred?93250_ _vec93251_ . _vectors93252_)
        (let ((_pred?93254_
               (std/srfi/133#check-type
                procedure?
                _pred?93250_
                std/srfi/133#vector-any))
              (_vec93255_
               (std/srfi/133#check-type
                vector?
                _vec93251_
                std/srfi/133#vector-any)))
          (if (null? _vectors93252_)
              (let ((_len93257_ (vector-length _vec93255_)))
                (_loop193229_
                 _pred?93254_
                 _vec93255_
                 '0
                 _len93257_
                 (- _len93257_ '1)))
              (let ((_len93259_
                     (std/srfi/133#%smallest-length
                      _vectors93252_
                      (vector-length _vec93255_)
                      std/srfi/133#vector-any)))
                (_loop2+93230_
                 _pred?93254_
                 (cons _vec93255_ _vectors93252_)
                 '0
                 _len93259_
                 (- _len93259_ '1))))))))
  (define std/srfi/133#vector-every
    (letrec ((_loop193197_
              (lambda (_pred?93200_
                       _vec93201_
                       _i93202_
                       _len93203_
                       _len-193204_)
                (let ((_$e93206_ (= _i93202_ _len93203_)))
                  (if _$e93206_
                      _$e93206_
                      (if (= _i93202_ _len-193204_)
                          (_pred?93200_ (vector-ref _vec93201_ _i93202_))
                          (if (_pred?93200_ (vector-ref _vec93201_ _i93202_))
                              (_loop193197_
                               _pred?93200_
                               _vec93201_
                               (+ _i93202_ '1)
                               _len93203_
                               _len-193204_)
                              '#f))))))
             (_loop2+93198_
              (lambda (_pred?93209_
                       _vectors93210_
                       _i93211_
                       _len93212_
                       _len-193213_)
                (let ((_$e93215_ (= _i93211_ _len93212_)))
                  (if _$e93215_
                      _$e93215_
                      (if (= _i93211_ _len-193213_)
                          (apply _pred?93209_
                                 (std/srfi/133#vectors-ref
                                  _vectors93210_
                                  _i93211_))
                          (if (apply _pred?93209_
                                     (std/srfi/133#vectors-ref
                                      _vectors93210_
                                      _i93211_))
                              (_loop2+93198_
                               _pred?93209_
                               _vectors93210_
                               (+ _i93211_ '1)
                               _len93212_
                               _len-193213_)
                              '#f)))))))
      (lambda (_pred?93218_ _vec93219_ . _vectors93220_)
        (let ((_pred?93222_
               (std/srfi/133#check-type
                procedure?
                _pred?93218_
                std/srfi/133#vector-every))
              (_vec93223_
               (std/srfi/133#check-type
                vector?
                _vec93219_
                std/srfi/133#vector-every)))
          (if (null? _vectors93220_)
              (let ((_len93225_ (vector-length _vec93223_)))
                (_loop193197_
                 _pred?93222_
                 _vec93223_
                 '0
                 _len93225_
                 (- _len93225_ '1)))
              (let ((_len93227_
                     (std/srfi/133#%smallest-length
                      _vectors93220_
                      (vector-length _vec93223_)
                      std/srfi/133#vector-every)))
                (_loop2+93198_
                 _pred?93222_
                 (cons _vec93223_ _vectors93220_)
                 '0
                 _len93227_
                 (- _len93227_ '1))))))))
  (define std/srfi/133#vector-partition
    (lambda (_pred?93179_ _vec93180_)
      (let* ((_len93182_ (vector-length _vec93180_))
             (_cnt93184_ (std/srfi/133#vector-count _pred?93179_ _vec93180_))
             (_result93186_ (make-vector _len93182_)))
        (let _loop93189_ ((_i93191_ '0) (_yes93192_ '0) (_no93193_ _cnt93184_))
          (if (= _i93191_ _len93182_)
              (values _result93186_ _cnt93184_)
              (let ((_elem93195_ (vector-ref _vec93180_ _i93191_)))
                (if (_pred?93179_ _elem93195_)
                    (begin
                      (vector-set! _result93186_ _yes93192_ _elem93195_)
                      (_loop93189_
                       (+ _i93191_ '1)
                       (+ _yes93192_ '1)
                       _no93193_))
                    (begin
                      (vector-set! _result93186_ _no93193_ _elem93195_)
                      (_loop93189_
                       (+ _i93191_ '1)
                       _yes93192_
                       (+ _no93193_ '1))))))))))
  (define std/srfi/133#vector-swap!
    (lambda (_vec93168_ _i93169_ _j93170_)
      (let ((_vec93172_
             (std/srfi/133#check-type
              vector?
              _vec93168_
              std/srfi/133#vector-swap!)))
        (let ((_i93174_
               (std/srfi/133#check-index
                _vec93172_
                _i93169_
                std/srfi/133#vector-swap!))
              (_j93175_
               (std/srfi/133#check-index
                _vec93172_
                _j93170_
                std/srfi/133#vector-swap!)))
          (let ((_x93177_ (vector-ref _vec93172_ _i93174_)))
            (vector-set! _vec93172_ _i93174_ (vector-ref _vec93172_ _j93175_))
            (vector-set! _vec93172_ _j93175_ _x93177_))))))
  (define std/srfi/133#vector-fill!
    (lambda (_vec93154_ _value93155_ . _maybe-start+end93156_)
      (let* ((_vec93158_
              (std/srfi/133#check-type
               vector?
               _vec93154_
               std/srfi/133#vector-fill!))
             (_g94024_
              (std/srfi/133#vector-parse-start+end
               _vec93158_
               _maybe-start+end93156_
               'start
               'end
               std/srfi/133#vector-fill!)))
        (begin
          (let ((_g94025_
                 (if (##values? _g94024_) (##vector-length _g94024_) 1)))
            (if (not (##fx= _g94025_ 2))
                (error "Context expects 2 values" _g94025_)))
          (let ((_start93160_ (##vector-ref _g94024_ 0))
                (_end93161_ (##vector-ref _g94024_ 1)))
            (let _$loop93163_ ((_i93166_ _start93160_))
              (if (= _i93166_ _end93161_)
                  '#!void
                  (begin
                    (vector-set! _vec93158_ _i93166_ _value93155_)
                    (_$loop93163_ (+ _i93166_ '1))))))))))
  (define std/srfi/133#vector-copy!
    (lambda (_target93137_
             _tstart93138_
             _source93139_
             .
             _maybe-sstart+send93140_)
      (letrec ((_doit!93142_
                (lambda (_sstart93146_ _send93147_ _source-length93148_)
                  (let ((_tstart93150_
                         (std/srfi/133#check-type
                          std/srfi/133#nonneg-int?
                          _tstart93138_
                          std/srfi/133#vector-copy!))
                        (_sstart93151_
                         (std/srfi/133#check-type
                          std/srfi/133#nonneg-int?
                          _sstart93146_
                          std/srfi/133#vector-copy!))
                        (_send93152_
                         (std/srfi/133#check-type
                          std/srfi/133#nonneg-int?
                          _send93147_
                          std/srfi/133#vector-copy!)))
                    (if (and (<= '0
                                 _sstart93151_
                                 _send93152_
                                 _source-length93148_)
                             (<= (+ _tstart93150_
                                    (- _send93152_ _sstart93151_))
                                 (vector-length _target93137_)))
                        (std/srfi/133#%vector-copy!
                         _target93137_
                         _tstart93150_
                         _source93139_
                         _sstart93151_
                         _send93152_)
                        (error '"illegal arguments"
                               (cons 'while
                                     (cons 'calling
                                           (cons std/srfi/133#vector-copy!
                                                 '())))
                               (cons 'target
                                     (cons 'was (cons _target93137_ '())))
                               (cons 'target-length
                                     (cons 'was
                                           (cons (vector-length _target93137_)
                                                 '())))
                               (cons 'tstart
                                     (cons 'was (cons _tstart93150_ '())))
                               (cons 'source
                                     (cons 'was (cons _source93139_ '())))
                               (cons 'source-length
                                     (cons 'was
                                           (cons _source-length93148_ '())))
                               (cons 'sstart
                                     (cons 'was (cons _sstart93151_ '())))
                               (cons 'send
                                     (cons 'was (cons _send93152_ '())))))))))
        (let ((_n93144_ (vector-length _source93139_)))
          (if (null? _maybe-sstart+send93140_)
              (_doit!93142_ '0 _n93144_ _n93144_)
              (if (null? (cdr _maybe-sstart+send93140_))
                  (_doit!93142_
                   (car _maybe-sstart+send93140_)
                   _n93144_
                   _n93144_)
                  (if (null? (cddr _maybe-sstart+send93140_))
                      (_doit!93142_
                       (car _maybe-sstart+send93140_)
                       (cadr _maybe-sstart+send93140_)
                       _n93144_)
                      (error '"too many arguments"
                             std/srfi/133#vector-copy!
                             (cddr _maybe-sstart+send93140_)))))))))
  (define std/srfi/133#vector-reverse-copy!
    (lambda (_target93117_
             _tstart93118_
             _source93119_
             .
             _maybe-sstart+send93120_)
      (letrec ((_doit!93122_
                (lambda (_sstart93126_ _send93127_ _source-length93128_)
                  (let ((_tstart93130_
                         (std/srfi/133#check-type
                          std/srfi/133#nonneg-int?
                          _tstart93118_
                          std/srfi/133#vector-reverse-copy!))
                        (_sstart93131_
                         (std/srfi/133#check-type
                          std/srfi/133#nonneg-int?
                          _sstart93126_
                          std/srfi/133#vector-reverse-copy!))
                        (_send93132_
                         (std/srfi/133#check-type
                          std/srfi/133#nonneg-int?
                          _send93127_
                          std/srfi/133#vector-reverse-copy!)))
                    (if (and (eq? _target93117_ _source93119_)
                             (or (std/srfi/133#between?
                                  _sstart93131_
                                  _tstart93130_
                                  _send93132_)
                                 (std/srfi/133#between?
                                  _tstart93130_
                                  _sstart93131_
                                  (+ _tstart93130_
                                     (- _send93132_ _sstart93131_)))))
                        (error '"vector range for self-copying overlaps"
                               std/srfi/133#vector-reverse-copy!
                               (cons 'vector
                                     (cons 'was (cons _target93117_ '())))
                               (cons 'tstart
                                     (cons 'was (cons _tstart93130_ '())))
                               (cons 'sstart
                                     (cons 'was (cons _sstart93131_ '())))
                               (cons 'send (cons 'was (cons _send93132_ '()))))
                        (if (and (<= '0
                                     _sstart93131_
                                     _send93132_
                                     _source-length93128_)
                                 (<= (+ _tstart93130_
                                        (- _send93132_ _sstart93131_))
                                     (vector-length _target93117_)))
                            (std/srfi/133#%vector-reverse-copy!
                             _target93117_
                             _tstart93130_
                             _source93119_
                             _sstart93131_
                             _send93132_)
                            (error '"illegal arguments"
                                   (cons 'while
                                         (cons 'calling
                                               (cons std/srfi/133#vector-reverse-copy!
                                                     '())))
                                   (cons 'target
                                         (cons 'was (cons _target93117_ '())))
                                   (cons 'target-length
                                         (cons 'was
                                               (cons (vector-length
                                                      _target93117_)
                                                     '())))
                                   (cons 'tstart
                                         (cons 'was (cons _tstart93130_ '())))
                                   (cons 'source
                                         (cons 'was (cons _source93119_ '())))
                                   (cons 'source-length
                                         (cons 'was
                                               (cons _source-length93128_
                                                     '())))
                                   (cons 'sstart
                                         (cons 'was (cons _sstart93131_ '())))
                                   (cons 'send
                                         (cons 'was
                                               (cons _send93132_ '()))))))))))
        (let ((_n93124_ (vector-length _source93119_)))
          (if (null? _maybe-sstart+send93120_)
              (_doit!93122_ '0 _n93124_ _n93124_)
              (if (null? (cdr _maybe-sstart+send93120_))
                  (_doit!93122_
                   (car _maybe-sstart+send93120_)
                   _n93124_
                   _n93124_)
                  (if (null? (cddr _maybe-sstart+send93120_))
                      (_doit!93122_
                       (car _maybe-sstart+send93120_)
                       (cadr _maybe-sstart+send93120_)
                       _n93124_)
                      (error '"too many arguments"
                             std/srfi/133#vector-reverse-copy!
                             (cddr _maybe-sstart+send93120_)))))))))
  (define std/srfi/133#vector-reverse!
    (lambda (_vec93109_ . _start+end93110_)
      (let* ((_vec93112_
              (std/srfi/133#check-type
               vector?
               _vec93109_
               std/srfi/133#vector-reverse!))
             (_g94026_
              (std/srfi/133#vector-parse-start+end
               _vec93112_
               _start+end93110_
               'start
               'end
               std/srfi/133#vector-reverse!)))
        (begin
          (let ((_g94027_
                 (if (##values? _g94026_) (##vector-length _g94026_) 1)))
            (if (not (##fx= _g94027_ 2))
                (error "Context expects 2 values" _g94027_)))
          (let ((_start93114_ (##vector-ref _g94026_ 0))
                (_end93115_ (##vector-ref _g94026_ 1)))
            (std/srfi/133#%vector-reverse!
             _vec93112_
             _start93114_
             _end93115_))))))
  (define std/srfi/133#vector->list
    (lambda (_vec93095_ . _maybe-start+end93096_)
      (let* ((_vec93098_
              (std/srfi/133#check-type
               vector?
               _vec93095_
               std/srfi/133#vector->list))
             (_g94028_
              (std/srfi/133#vector-parse-start+end
               _vec93098_
               _maybe-start+end93096_
               'start
               'end
               std/srfi/133#vector->list)))
        (begin
          (let ((_g94029_
                 (if (##values? _g94028_) (##vector-length _g94028_) 1)))
            (if (not (##fx= _g94029_ 2))
                (error "Context expects 2 values" _g94029_)))
          (let ((_start93100_ (##vector-ref _g94028_ 0))
                (_end93101_ (##vector-ref _g94028_ 1)))
            (let _$loop93103_ ((_i93106_ (- _end93101_ '1))
                               (_result93107_ '()))
              (if (< _i93106_ _start93100_)
                  _result93107_
                  (_$loop93103_
                   (- _i93106_ '1)
                   (cons (vector-ref _vec93098_ _i93106_)
                         _result93107_)))))))))
  (define std/srfi/133#reverse-vector->list
    (lambda (_vec93081_ . _maybe-start+end93082_)
      (let* ((_vec93084_
              (std/srfi/133#check-type
               vector?
               _vec93081_
               std/srfi/133#reverse-vector->list))
             (_g94030_
              (std/srfi/133#vector-parse-start+end
               _vec93084_
               _maybe-start+end93082_
               'start
               'end
               std/srfi/133#reverse-vector->list)))
        (begin
          (let ((_g94031_
                 (if (##values? _g94030_) (##vector-length _g94030_) 1)))
            (if (not (##fx= _g94031_ 2))
                (error "Context expects 2 values" _g94031_)))
          (let ((_start93086_ (##vector-ref _g94030_ 0))
                (_end93087_ (##vector-ref _g94030_ 1)))
            (let _$loop93089_ ((_i93092_ _start93086_) (_result93093_ '()))
              (if (= _i93092_ _end93087_)
                  _result93093_
                  (_$loop93089_
                   (+ _i93092_ '1)
                   (cons (vector-ref _vec93084_ _i93092_)
                         _result93093_)))))))))
  (define std/srfi/133#list->vector
    (lambda (_lst93037_ . _maybe-start+end93038_)
      (if (null? _maybe-start+end93038_)
          (let* ((_start93040_ '0) (_end93042_ (length _lst93037_)))
            (let ((_start93045_
                   (std/srfi/133#check-type
                    std/srfi/133#nonneg-int?
                    _start93040_
                    std/srfi/133#list->vector))
                  (_end93046_
                   (std/srfi/133#check-type
                    std/srfi/133#nonneg-int?
                    _end93042_
                    std/srfi/133#list->vector)))
              ((lambda (_f93048_)
                 (std/srfi/133#vector-unfold
                  _f93048_
                  (- _end93046_ _start93045_)
                  (list-tail _lst93037_ _start93045_)))
               (lambda (_index93050_ _l93051_)
                 (if (null? _l93051_)
                     (error '"list was too short"
                            (cons 'list (cons 'was (cons _lst93037_ '())))
                            (cons 'attempted
                                  (cons 'end
                                        (cons 'was (cons _end93046_ '()))))
                            (cons 'while
                                  (cons 'calling
                                        (cons std/srfi/133#list->vector '()))))
                     (if (pair? _l93051_)
                         (values (car _l93051_) (cdr _l93051_))
                         (error '"erroneous value"
                                (list list? _lst93037_)
                                (cons 'while
                                      (cons 'calling
                                            (cons std/srfi/133#list->vector
                                                  '()))))))))))
          (let ((_start93053_ (car _maybe-start+end93038_))
                (_new-args93054_ (cdr _maybe-start+end93038_)))
            (if (null? _new-args93054_)
                (let ((_end93057_ (length _lst93037_)))
                  (let ((_start93060_
                         (std/srfi/133#check-type
                          std/srfi/133#nonneg-int?
                          _start93053_
                          std/srfi/133#list->vector))
                        (_end93061_
                         (std/srfi/133#check-type
                          std/srfi/133#nonneg-int?
                          _end93057_
                          std/srfi/133#list->vector)))
                    ((lambda (_f93063_)
                       (std/srfi/133#vector-unfold
                        _f93063_
                        (- _end93061_ _start93060_)
                        (list-tail _lst93037_ _start93060_)))
                     (lambda (_index93065_ _l93066_)
                       (if (null? _l93066_)
                           (error '"list was too short"
                                  (cons 'list
                                        (cons 'was (cons _lst93037_ '())))
                                  (cons 'attempted
                                        (cons 'end
                                              (cons 'was
                                                    (cons _end93061_ '()))))
                                  (cons 'while
                                        (cons 'calling
                                              (cons std/srfi/133#list->vector
                                                    '()))))
                           (if (pair? _l93066_)
                               (values (car _l93066_) (cdr _l93066_))
                               (error '"erroneous value"
                                      (list list? _lst93037_)
                                      (cons 'while
                                            (cons 'calling
                                                  (cons std/srfi/133#list->vector
                                                        '()))))))))))
                (let ((_end93068_ (car _new-args93054_))
                      (_new-args93069_ (cdr _new-args93054_)))
                  (if (null? _new-args93069_)
                      (let ()
                        (let ((_start93073_
                               (std/srfi/133#check-type
                                std/srfi/133#nonneg-int?
                                _start93053_
                                std/srfi/133#list->vector))
                              (_end93074_
                               (std/srfi/133#check-type
                                std/srfi/133#nonneg-int?
                                _end93068_
                                std/srfi/133#list->vector)))
                          ((lambda (_f93076_)
                             (std/srfi/133#vector-unfold
                              _f93076_
                              (- _end93074_ _start93073_)
                              (list-tail _lst93037_ _start93073_)))
                           (lambda (_index93078_ _l93079_)
                             (if (null? _l93079_)
                                 (error '"list was too short"
                                        (cons 'list
                                              (cons 'was
                                                    (cons _lst93037_ '())))
                                        (cons 'attempted
                                              (cons 'end
                                                    (cons 'was
                                                          (cons _end93074_
                                                                '()))))
                                        (cons 'while
                                              (cons 'calling
                                                    (cons std/srfi/133#list->vector
                                                          '()))))
                                 (if (pair? _l93079_)
                                     (values (car _l93079_) (cdr _l93079_))
                                     (error '"erroneous value"
                                            (list list? _lst93037_)
                                            (cons 'while
                                                  (cons 'calling
                                                        (cons std/srfi/133#list->vector
                                                              '()))))))))))
                      (error '"too many arguments"
                             (length _maybe-start+end93038_)
                             _maybe-start+end93038_))))))))
  (define std/srfi/133#reverse-list->vector
    (lambda (_lst92993_ . _maybe-start+end92994_)
      (if (null? _maybe-start+end92994_)
          (let* ((_start92996_ '0) (_end92998_ (length _lst92993_)))
            (let ((_start93001_
                   (std/srfi/133#check-type
                    std/srfi/133#nonneg-int?
                    _start92996_
                    std/srfi/133#reverse-list->vector))
                  (_end93002_
                   (std/srfi/133#check-type
                    std/srfi/133#nonneg-int?
                    _end92998_
                    std/srfi/133#reverse-list->vector)))
              ((lambda (_f93004_)
                 (std/srfi/133#vector-unfold-right
                  _f93004_
                  (- _end93002_ _start93001_)
                  (list-tail _lst92993_ _start93001_)))
               (lambda (_index93006_ _l93007_)
                 (if (null? _l93007_)
                     (error '"list too short"
                            (cons 'list (cons 'was (cons _lst92993_ '())))
                            (cons 'attempted
                                  (cons 'end
                                        (cons 'was (cons _end93002_ '()))))
                            (cons 'while
                                  (cons 'calling
                                        (cons std/srfi/133#reverse-list->vector
                                              '()))))
                     (if (pair? _l93007_)
                         (values (car _l93007_) (cdr _l93007_))
                         (error '"erroneous value"
                                (list list? _lst92993_)
                                (cons 'while
                                      (cons 'calling
                                            (cons std/srfi/133#reverse-list->vector
                                                  '()))))))))))
          (let ((_start93009_ (car _maybe-start+end92994_))
                (_new-args93010_ (cdr _maybe-start+end92994_)))
            (if (null? _new-args93010_)
                (let ((_end93013_ (length _lst92993_)))
                  (let ((_start93016_
                         (std/srfi/133#check-type
                          std/srfi/133#nonneg-int?
                          _start93009_
                          std/srfi/133#reverse-list->vector))
                        (_end93017_
                         (std/srfi/133#check-type
                          std/srfi/133#nonneg-int?
                          _end93013_
                          std/srfi/133#reverse-list->vector)))
                    ((lambda (_f93019_)
                       (std/srfi/133#vector-unfold-right
                        _f93019_
                        (- _end93017_ _start93016_)
                        (list-tail _lst92993_ _start93016_)))
                     (lambda (_index93021_ _l93022_)
                       (if (null? _l93022_)
                           (error '"list too short"
                                  (cons 'list
                                        (cons 'was (cons _lst92993_ '())))
                                  (cons 'attempted
                                        (cons 'end
                                              (cons 'was
                                                    (cons _end93017_ '()))))
                                  (cons 'while
                                        (cons 'calling
                                              (cons std/srfi/133#reverse-list->vector
                                                    '()))))
                           (if (pair? _l93022_)
                               (values (car _l93022_) (cdr _l93022_))
                               (error '"erroneous value"
                                      (list list? _lst92993_)
                                      (cons 'while
                                            (cons 'calling
                                                  (cons std/srfi/133#reverse-list->vector
                                                        '()))))))))))
                (let ((_end93024_ (car _new-args93010_))
                      (_new-args93025_ (cdr _new-args93010_)))
                  (if (null? _new-args93025_)
                      (let ()
                        (let ((_start93029_
                               (std/srfi/133#check-type
                                std/srfi/133#nonneg-int?
                                _start93009_
                                std/srfi/133#reverse-list->vector))
                              (_end93030_
                               (std/srfi/133#check-type
                                std/srfi/133#nonneg-int?
                                _end93024_
                                std/srfi/133#reverse-list->vector)))
                          ((lambda (_f93032_)
                             (std/srfi/133#vector-unfold-right
                              _f93032_
                              (- _end93030_ _start93029_)
                              (list-tail _lst92993_ _start93029_)))
                           (lambda (_index93034_ _l93035_)
                             (if (null? _l93035_)
                                 (error '"list too short"
                                        (cons 'list
                                              (cons 'was
                                                    (cons _lst92993_ '())))
                                        (cons 'attempted
                                              (cons 'end
                                                    (cons 'was
                                                          (cons _end93030_
                                                                '()))))
                                        (cons 'while
                                              (cons 'calling
                                                    (cons std/srfi/133#reverse-list->vector
                                                          '()))))
                                 (if (pair? _l93035_)
                                     (values (car _l93035_) (cdr _l93035_))
                                     (error '"erroneous value"
                                            (list list? _lst92993_)
                                            (cons 'while
                                                  (cons 'calling
                                                        (cons std/srfi/133#reverse-list->vector
                                                              '()))))))))))
                      (error '"too many arguments"
                             (length _maybe-start+end92994_)
                             _maybe-start+end92994_))))))))
  (define std/srfi/133#vector->string
    (lambda (_vec92974_ . _maybe-start+end92975_)
      (let* ((_len92977_ (vector-length _vec92974_))
             (_start92979_
              (if (null? _maybe-start+end92975_)
                  '0
                  (car _maybe-start+end92975_)))
             (_end92981_
              (if (null? _maybe-start+end92975_)
                  _len92977_
                  (if (null? (cdr _maybe-start+end92975_))
                      _len92977_
                      (cadr _maybe-start+end92975_))))
             (_size92983_ (- _end92981_ _start92979_)))
        (letrec* ((_result92986_ (make-string _size92983_)))
          (let _loop92988_ ((_at92990_ '0) (_i92991_ _start92979_))
            (if (= _i92991_ _end92981_)
                _result92986_
                (begin
                  (string-set!
                   _result92986_
                   _at92990_
                   (vector-ref _vec92974_ _i92991_))
                  (_loop92988_ (+ _at92990_ '1) (+ _i92991_ '1)))))))))
  (define std/srfi/133#string->vector
    (lambda (_str92955_ . _maybe-start+end92956_)
      (let* ((_len92958_ (string-length _str92955_))
             (_start92960_
              (if (null? _maybe-start+end92956_)
                  '0
                  (car _maybe-start+end92956_)))
             (_end92962_
              (if (null? _maybe-start+end92956_)
                  _len92958_
                  (if (null? (cdr _maybe-start+end92956_))
                      _len92958_
                      (cadr _maybe-start+end92956_))))
             (_size92964_ (- _end92962_ _start92960_)))
        (letrec* ((_result92967_ (make-vector _size92964_)))
          (let _loop92969_ ((_at92971_ '0) (_i92972_ _start92960_))
            (if (= _i92972_ _end92962_)
                _result92967_
                (begin
                  (vector-set!
                   _result92967_
                   _at92971_
                   (string-ref _str92955_ _i92972_))
                  (_loop92969_ (+ _at92971_ '1) (+ _i92972_ '1))))))))))
