(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/protobuf/io#marshal
    (lambda (_obj181841_ _bio-write-e181842_)
      (let ((_buf181844_
             (std/net/bio/buffer#open-serializer-output-buffer__0)))
        (_bio-write-e181842_ _obj181841_ _buf181844_)
        (std/net/bio/buffer#chunked-output-u8vector _buf181844_))))
  (define std/protobuf/io#unmarshal
    (lambda (_bytes181836_ _bio-read-e181837_)
      (let ((_buf181839_
             (std/net/bio/buffer#open-input-buffer__0 _bytes181836_)))
        (_bio-read-e181837_ _buf181839_))))
  (define std/protobuf/io#read-delimited__%
    (lambda (_bio-read-e181813_ _port181814_)
      (let* ((_len181816_ (std/protobuf/io#read-varuint _port181814_))
             (_bytes181818_ (make-u8vector _len181816_))
             (_rd181820_
              (read-subu8vector _bytes181818_ '0 _len181816_ _port181814_))
             (_g181845_
              (if (fx= _rd181820_ _len181816_)
                  '#!void
                  (std/error#raise-io-error
                   'read-delimited
                   '"Premature end of input"
                   _port181814_
                   _rd181820_)))
             (_buf181823_
              (std/net/bio/buffer#open-input-buffer__0 _bytes181818_)))
        (_bio-read-e181813_ _buf181823_))))
  (define std/protobuf/io#read-delimited__0
    (lambda (_bio-read-e181829_)
      (let ((_port181831_ (current-input-port)))
        (std/protobuf/io#read-delimited__% _bio-read-e181829_ _port181831_))))
  (define std/protobuf/io#read-delimited
    (lambda _g181847_
      (let ((_g181846_ (length _g181847_)))
        (cond ((##fx= _g181846_ 1)
               (apply std/protobuf/io#read-delimited__0 _g181847_))
              ((##fx= _g181846_ 2)
               (apply std/protobuf/io#read-delimited__% _g181847_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/protobuf/io#read-delimited
                _g181847_))))))
  (define std/protobuf/io#write-delimited__%
    (lambda (_x181790_ _bio-write-e181791_ _port181792_)
      (let ((_buf181794_
             (std/net/bio/buffer#open-serializer-output-buffer__0)))
        (_bio-write-e181791_ _x181790_ _buf181794_)
        (let ((_len181796_
               (std/net/bio/buffer#chunked-output-length _buf181794_)))
          (std/protobuf/io#write-varuint _len181796_ _port181792_)
          (for-each
           (lambda (_bytes181798_)
             (write-subu8vector
              _bytes181798_
              '0
              (u8vector-length _bytes181798_)
              _port181792_))
           (std/net/bio/buffer#chunked-output-chunks _buf181794_))))))
  (define std/protobuf/io#write-delimited__0
    (lambda (_x181803_ _bio-write-e181804_)
      (let ((_port181806_ (current-output-port)))
        (std/protobuf/io#write-delimited__%
         _x181803_
         _bio-write-e181804_
         _port181806_))))
  (define std/protobuf/io#write-delimited
    (lambda _g181849_
      (let ((_g181848_ (length _g181849_)))
        (cond ((##fx= _g181848_ 2)
               (apply std/protobuf/io#write-delimited__0 _g181849_))
              ((##fx= _g181848_ 3)
               (apply std/protobuf/io#write-delimited__% _g181849_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/protobuf/io#write-delimited
                _g181849_))))))
  (define std/protobuf/io#read-varuint
    (lambda (_port181774_)
      (let _lp181776_ ((_shift181778_ '0) (_r181779_ '0))
        (let* ((_bits181781_ (read-u8 _port181774_))
               (_g181850_
                (if (eof-object? _bits181781_)
                    (std/error#raise-io-error
                     'read-varuint
                     '"Premature end of input"
                     _port181774_)
                    '#!void))
               (_limb181784_ (##fxand _bits181781_ '127))
               (_r181786_
                (bitwise-ior
                 (arithmetic-shift _limb181784_ _shift181778_)
                 _r181779_)))
          (if (##fxzero? (##fxand _bits181781_ '128))
              _r181786_
              (_lp181776_ (##fx+ _shift181778_ '7) _r181786_))))))
  (define std/protobuf/io#write-varuint
    (lambda (_x181762_ _port181763_)
      (let _lp181765_ ((_bits181767_ _x181762_))
        (if (< _bits181767_ '128)
            (write-u8 _bits181767_ _port181763_)
            (let* ((_limb181769_ (bitwise-and _bits181767_ '127))
                   (_obits181771_ (##fxior _limb181769_ '128)))
              (write-u8 _obits181771_ _port181763_)
              (_lp181765_ (arithmetic-shift _bits181767_ '-7)))))))
  (define std/protobuf/io#bio-read-field
    (lambda (_buf181758_)
      (let ((_field181760_ (std/protobuf/io#bio-read-varint _buf181758_)))
        (values (arithmetic-shift _field181760_ '-3)
                (std/protobuf/io#byte->tag (bitwise-and _field181760_ '7))))))
  (define std/protobuf/io#bio-write-field
    (lambda (_x181754_ _tag181755_ _buf181756_)
      (std/protobuf/io#bio-write-varint
       (bitwise-ior
        (arithmetic-shift _x181754_ '3)
        (std/protobuf/io#tag->byte _tag181755_))
       _buf181756_)))
  (define std/protobuf/io#byte->tag
    (lambda (_x181749_)
      (let ((_$e181751_ _x181749_))
        (if (eq? '0 _$e181751_)
            'VARINT
            (if (eq? '1 _$e181751_)
                'FIXED64
                (if (eq? '2 _$e181751_)
                    'VARLEN
                    (if (eq? '5 _$e181751_)
                        'FIXED32
                        (error '"Unknown type tag" _x181749_))))))))
  (define std/protobuf/io#tag->byte
    (lambda (_x181744_)
      (let ((_$e181746_ _x181744_))
        (if (eq? 'VARINT _$e181746_)
            '0
            (if (eq? 'FIXED64 _$e181746_)
                '1
                (if (eq? 'VARLEN _$e181746_)
                    '2
                    (if (eq? 'FIXED32 _$e181746_)
                        '5
                        (error '"Unknown type tag" _x181744_))))))))
  (define std/protobuf/io#bio-input-skip-unknown
    (lambda (_tag181738_ _buf181739_)
      (let ((_$e181741_ _tag181738_))
        (if (eq? 'VARINT _$e181741_)
            (std/protobuf/io#bio-input-skip-varint _buf181739_)
            (if (eq? 'FIXED64 _$e181741_)
                (std/net/bio/input#bio-input-skip '8 _buf181739_)
                (if (eq? 'VARLEN _$e181741_)
                    (std/net/bio/input#bio-input-skip
                     (std/protobuf/io#bio-read-varint _buf181739_)
                     _buf181739_)
                    (if (eq? 'FIXED32 _$e181741_)
                        (std/net/bio/input#bio-input-skip '4 _buf181739_)
                        (error '"Unknown type tag" _tag181738_))))))))
  (define std/protobuf/io#bio-input-skip-varint
    (lambda (_buf181731_)
      (let _lp181733_ ()
        (let ((_byte181736_ (std/net/bio/input#bio-read-u8 _buf181731_)))
          (if (eof-object? _byte181736_)
              (std/error#raise-io-error
               'bio-input-skip-varint
               '"Premature end of input"
               _buf181731_)
              '#!void)
          (if (##fxzero? (##fxand _byte181736_ '128)) '#!void (_lp181733_))))))
  (define std/protobuf/io#bio-read-packed
    (lambda (_bio-read-e181719_ _buf181720_)
      (let* ((_len181722_ (std/protobuf/io#bio-read-varint _buf181720_))
             (_buf181724_
              (std/net/bio/buffer#open-delimited-input-buffer
               _buf181720_
               _len181722_)))
        (let _lp181727_ ((_r181729_ '()))
          (if (eof-object? (std/net/bio/input#bio-peek-u8 _buf181724_))
              (reverse _r181729_)
              (_lp181727_
               (cons (_bio-read-e181719_ _buf181724_) _r181729_)))))))
  (define std/protobuf/io#bio-write-packed
    (lambda (_xs181705_ _bio-write-e181706_ _buf181707_)
      (let ((_tmpbuf181709_
             (std/net/bio/buffer#open-serializer-output-buffer__0)))
        (for-each
         (lambda (_g181710181712_)
           (_bio-write-e181706_ _g181710181712_ _tmpbuf181709_))
         _xs181705_)
        (std/protobuf/io#bio-write-varint
         (std/net/bio/buffer#chunked-output-length _tmpbuf181709_)
         _buf181707_)
        (for-each
         (lambda (_g181714181716_)
           (std/net/bio/output#bio-write-bytes _g181714181716_ _buf181707_))
         (std/net/bio/buffer#chunked-output-chunks _tmpbuf181709_)))))
  (define std/protobuf/io#bio-read-key-value-pair
    (lambda (_bio-read-key-e181685_ _bio-read-value-e181686_ _buf181687_)
      (let* ((_len181689_ (std/protobuf/io#bio-read-varint _buf181687_))
             (_buf181691_
              (std/net/bio/buffer#open-delimited-input-buffer
               _buf181687_
               _len181689_)))
        (let _lp181694_ ((_key181696_ '#f) (_value181697_ '#f))
          (if (eof-object? (std/net/bio/input#bio-peek-u8 _buf181691_))
              (cons _key181696_ _value181697_)
              (let ((_g181851_ (std/protobuf/io#bio-read-field _buf181691_)))
                (begin
                  (let ((_g181852_
                         (if (##values? _g181851_)
                             (##vector-length _g181851_)
                             1)))
                    (if (not (##fx= _g181852_ 2))
                        (error "Context expects 2 values" _g181852_)))
                  (let ((_field181699_ (##vector-ref _g181851_ 0))
                        (_tag181700_ (##vector-ref _g181851_ 1)))
                    (let ((_$e181702_ _field181699_))
                      (if (eq? '1 _$e181702_)
                          (_lp181694_
                           (_bio-read-key-e181685_ _buf181691_)
                           _value181697_)
                          (if (eq? '2 _$e181702_)
                              (_lp181694_
                               _key181696_
                               (_bio-read-value-e181686_ _buf181691_))
                              (begin
                                (std/protobuf/io#bio-input-skip-unknown
                                 _tag181700_
                                 _buf181691_)
                                (_lp181694_
                                 _key181696_
                                 _value181697_)))))))))))))
  (define std/protobuf/io#bio-write-key-value-pair
    (lambda (_k181663_
             _v181664_
             _ktag181665_
             _bio-write-key-e181666_
             _vtag181667_
             _bio-write-value-e181668_
             _buf181669_)
      (let* ((_tmpbuf181671_
              (std/net/bio/buffer#open-serializer-output-buffer__0))
             (_tmpbuf-write181678_
              (lambda (_field181673_
                       _tag181674_
                       _val181675_
                       _bio-write-e181676_)
                (std/protobuf/io#bio-write-field
                 _field181673_
                 _tag181674_
                 _tmpbuf181671_)
                (_bio-write-e181676_ _val181675_ _tmpbuf181671_))))
        (_tmpbuf-write181678_
         '1
         _ktag181665_
         _k181663_
         _bio-write-key-e181666_)
        (_tmpbuf-write181678_
         '2
         _vtag181667_
         _v181664_
         _bio-write-value-e181668_)
        (std/protobuf/io#bio-write-varint
         (std/net/bio/buffer#chunked-output-length _tmpbuf181671_)
         _buf181669_)
        (for-each
         (lambda (_g181680181682_)
           (std/net/bio/output#bio-write-bytes _g181680181682_ _buf181669_))
         (std/net/bio/buffer#chunked-output-chunks _tmpbuf181671_)))))
  (define std/protobuf/io#bio-read-delimited
    (lambda (_bio-read-e181655_ _buf181656_)
      (let* ((_len181658_ (std/protobuf/io#bio-read-varint _buf181656_))
             (_buf181660_
              (std/net/bio/buffer#open-delimited-input-buffer
               _buf181656_
               _len181658_)))
        (_bio-read-e181655_ _buf181660_))))
  (define std/protobuf/io#bio-write-delimited
    (lambda (_x181645_ _bio-write-e181646_ _buf181647_)
      (let ((_tmpbuf181649_
             (std/net/bio/buffer#open-serializer-output-buffer__0)))
        (_bio-write-e181646_ _x181645_ _tmpbuf181649_)
        (std/protobuf/io#bio-write-varint
         (std/net/bio/buffer#chunked-output-length _tmpbuf181649_)
         _buf181647_)
        (for-each
         (lambda (_g181650181652_)
           (std/net/bio/output#bio-write-bytes _g181650181652_ _buf181647_))
         (std/net/bio/buffer#chunked-output-chunks _tmpbuf181649_)))))
  (define std/protobuf/io#bio-read-delimited-string
    (lambda (_buf181629_)
      (declare (not safe))
      (let* ((_len181632_ (std/protobuf/io#bio-read-varint _buf181629_))
             (_buf181634_
              (std/net/bio/buffer#open-delimited-input-buffer
               _buf181629_
               _len181632_))
             (_str181636_ (make-string _len181632_)))
        (let _lp181639_ ((_i181641_ '0))
          (if (eof-object? (std/net/bio/input#bio-peek-u8 _buf181634_))
              (begin (string-shrink! _str181636_ _i181641_) _str181636_)
              (let ((_char181643_
                     (std/net/bio/input#bio-read-char _buf181634_)))
                (string-set! _str181636_ _i181641_ _char181643_)
                (_lp181639_ (fx+ _i181641_ '1))))))))
  (define std/protobuf/io#bio-write-delimited-string
    (lambda (_x181624_ _buf181625_)
      (let ((_len181627_ (std/text/utf8#string-utf8-length__0 _x181624_)))
        (std/protobuf/io#bio-write-varint _len181627_ _buf181625_)
        (std/net/bio/output#bio-write-string _x181624_ _buf181625_))))
  (define std/protobuf/io#bio-read-delimited-bytes
    (lambda (_buf181617_)
      (let* ((_len181619_ (std/protobuf/io#bio-read-varint _buf181617_))
             (_bytes181621_ (make-u8vector _len181619_)))
        (std/net/bio/input#bio-read-bytes _bytes181621_ _buf181617_)
        _bytes181621_)))
  (define std/protobuf/io#bio-write-delimited-bytes
    (lambda (_x181614_ _buf181615_)
      (std/protobuf/io#bio-write-varint
       (u8vector-length _x181614_)
       _buf181615_)
      (std/net/bio/output#bio-write-bytes _x181614_ _buf181615_)))
  (define std/protobuf/io#bio-read-boolean
    (lambda (_buf181612_)
      (not (zero? (std/protobuf/io#bio-read-varint _buf181612_)))))
  (define std/protobuf/io#bio-write-boolean
    (lambda (_x181609_ _buf181610_)
      (std/protobuf/io#bio-write-varint (if _x181609_ '1 '0) _buf181610_)))
  (define std/protobuf/io#2^31 (expt '2 '31))
  (define std/protobuf/io#2^32 (expt '2 '32))
  (define std/protobuf/io#2^63 (expt '2 '63))
  (define std/protobuf/io#2^64 (expt '2 '64))
  (define std/protobuf/io#bio-read-varint
    (lambda (_buf181590_)
      (letrec ((_complement181592_
                (lambda (_r181607_)
                  (if (< _r181607_ std/protobuf/io#2^63)
                      _r181607_
                      (- _r181607_ std/protobuf/io#2^64)))))
        (let _lp181594_ ((_shift181596_ '0) (_r181597_ '0))
          (let* ((_bits181599_ (std/net/bio/input#bio-read-u8 _buf181590_))
                 (_g181853_
                  (if (eof-object? _bits181599_)
                      (std/error#raise-io-error
                       'bio-read-varint
                       '"Premature end of input"
                       _buf181590_)
                      '#!void))
                 (_limb181602_ (##fxand _bits181599_ '127))
                 (_r181604_
                  (bitwise-ior
                   (arithmetic-shift _limb181602_ _shift181596_)
                   _r181597_)))
            (if (##fxzero? (##fxand _bits181599_ '128))
                (_complement181592_ _r181604_)
                (_lp181594_ (##fx+ _shift181596_ '7) _r181604_)))))))
  (define std/protobuf/io#bio-write-varint
    (lambda (_x181574_ _buf181575_)
      (letrec ((_complement181577_
                (lambda (_r181588_)
                  (if (< _r181588_ '0)
                      (+ std/protobuf/io#2^64 _r181588_)
                      _r181588_))))
        (let _lp181579_ ((_bits181581_ (_complement181577_ _x181574_)))
          (if (< _bits181581_ '128)
              (std/net/bio/output#bio-write-u8 _bits181581_ _buf181575_)
              (let* ((_limb181583_ (bitwise-and _bits181581_ '127))
                     (_obits181585_ (##fxior _limb181583_ '128)))
                (std/net/bio/output#bio-write-u8 _obits181585_ _buf181575_)
                (_lp181579_ (arithmetic-shift _bits181581_ '-7))))))))
  (define std/protobuf/io#bio-read-varint-zigzag
    (lambda (_buf181570_)
      (let ((_y181572_ (std/protobuf/io#bio-read-varint _buf181570_)))
        (if (even? _y181572_)
            (quotient _y181572_ '2)
            (- (quotient (+ _y181572_ '1) '2))))))
  (define std/protobuf/io#bio-write-varint-zigzag
    (lambda (_x181565_ _buf181566_)
      (let ((_y181568_
             (if (negative? _x181565_)
                 (- (+ (* _x181565_ '2) '1))
                 (* _x181565_ '2))))
        (std/protobuf/io#bio-write-varint _y181568_ _buf181566_))))
  (define std/protobuf/io#bio-read-fixed-uint
    (lambda (_n181555_ _buf181556_)
      (let _lp181558_ ((_i181560_ '0) (_bits181561_ '0))
        (if (##fx< _i181560_ _n181555_)
            (let ((_byte181563_ (std/net/bio/input#bio-read-u8 _buf181556_)))
              (if (eof-object? _byte181563_)
                  (std/error#raise-io-error
                   'bio-read-sfixed32
                   '"Premature end of input"
                   _buf181556_)
                  '#!void)
              (_lp181558_
               (##fx+ _i181560_ '1)
               (bitwise-ior
                _bits181561_
                (arithmetic-shift _byte181563_ (##fx* '8 _i181560_)))))
            _bits181561_))))
  (define std/protobuf/io#bio-write-fixed-uint
    (lambda (_x181546_ _n181547_ _buf181548_)
      (let _lp181550_ ((_i181552_ '0) (_bits181553_ _x181546_))
        (if (##fx< _i181552_ _n181547_)
            (begin
              (std/net/bio/output#bio-write-u8
               (bitwise-and _bits181553_ '255)
               _buf181548_)
              (_lp181550_
               (##fx+ _i181552_ '1)
               (arithmetic-shift _bits181553_ '-8)))
            '#!void))))
  (define std/protobuf/io#bio-read-fixed32
    (lambda (_buf181544_)
      (std/protobuf/io#bio-read-fixed-uint '4 _buf181544_)))
  (define std/protobuf/io#bio-write-fixed32
    (lambda (_x181541_ _buf181542_)
      (std/protobuf/io#bio-write-fixed-uint _x181541_ '4 _buf181542_)))
  (define std/protobuf/io#bio-read-sfixed32
    (lambda (_buf181537_)
      (let ((_y181539_ (std/protobuf/io#bio-read-fixed-uint '4 _buf181537_)))
        (if (< _y181539_ std/protobuf/io#2^31)
            _y181539_
            (- _y181539_ std/protobuf/io#2^32)))))
  (define std/protobuf/io#bio-write-sfixed32
    (lambda (_x181532_ _buf181533_)
      (let ((_y181535_
             (if (< _x181532_ '0)
                 (+ std/protobuf/io#2^32 _x181532_)
                 _x181532_)))
        (std/protobuf/io#bio-write-fixed-uint _y181535_ '4 _buf181533_))))
  (define std/protobuf/io#bio-read-fixed64
    (lambda (_buf181530_)
      (std/protobuf/io#bio-read-fixed-uint '8 _buf181530_)))
  (define std/protobuf/io#bio-write-fixed64
    (lambda (_x181527_ _buf181528_)
      (std/protobuf/io#bio-write-fixed-uint _x181527_ '8 _buf181528_)))
  (define std/protobuf/io#bio-read-sfixed64
    (lambda (_buf181523_)
      (let ((_y181525_ (std/protobuf/io#bio-read-fixed-uint '8 _buf181523_)))
        (if (< _y181525_ std/protobuf/io#2^63)
            _y181525_
            (- _y181525_ std/protobuf/io#2^64)))))
  (define std/protobuf/io#bio-write-sfixed64
    (lambda (_x181518_ _buf181519_)
      (let ((_y181521_
             (if (< _x181518_ '0)
                 (+ std/protobuf/io#2^64 _x181518_)
                 _x181518_)))
        (std/protobuf/io#bio-write-fixed-uint _y181521_ '8 _buf181519_))))
  (define std/protobuf/io#bio-read-float
    (lambda (_buf181516_)
      (std/protobuf/io#bio-read-float-bytes
       '4
       std/protobuf/io#bytes->float
       _buf181516_)))
  (define std/protobuf/io#bio-write-float
    (lambda (_x181513_ _buf181514_)
      (std/protobuf/io#bio-write-float-bytes
       _x181513_
       '4
       std/protobuf/io#float->bytes!
       _buf181514_)))
  (define std/protobuf/io#bio-read-double
    (lambda (_buf181511_)
      (std/protobuf/io#bio-read-float-bytes
       '8
       std/protobuf/io#bytes->double
       _buf181511_)))
  (define std/protobuf/io#bio-write-double
    (lambda (_x181508_ _buf181509_)
      (std/protobuf/io#bio-write-float-bytes
       _x181508_
       '8
       std/protobuf/io#double->bytes!
       _buf181509_)))
  (define std/protobuf/io#bio-read-float-bytes
    (lambda (_n181502_ _bytes->flonum181503_ _buf181504_)
      (let ((_bytes181506_ (make-u8vector _n181502_)))
        (std/net/bio/input#bio-read-bytes _bytes181506_ _buf181504_)
        (_bytes->flonum181503_ _bytes181506_))))
  (define std/protobuf/io#bio-write-float-bytes
    (lambda (_x181495_ _n181496_ _flonum->bytes!181497_ _buf181498_)
      (let ((_bytes181500_ (make-u8vector _n181496_)))
        (_flonum->bytes!181497_ _x181495_ _bytes181500_)
        (std/net/bio/output#bio-write-bytes _bytes181500_ _buf181498_))))
  (define-macro (define-guard guard defn)
    (if (eval `(cond-expand (,guard #t) (else #f)))
        '(begin)
        (begin (eval `(define-cond-expand-feature ,guard)) defn)))
  (define-macro (define-c-lambda id args ret #!optional (name #f))
    (let ((name (or name (symbol->string id))))
      `(define ,id (c-lambda ,args ,ret ,name))))
  (define-macro (define-const symbol)
    (let* ((str (symbol->string symbol))
           (ref (string-append "___return (" str ");")))
      `(define ,symbol ((c-lambda () int ,ref)))))
  (define-macro (define-const* symbol)
    (let* ((str (symbol->string symbol))
           (code (string-append
                  "#ifdef "
                  str
                  "\n"
                  "___return (___FIX ("
                  str
                  "));\n"
                  "#else \n"
                  "___return (___FAL);\n"
                  "#endif")))
      `(define ,symbol ((c-lambda () scheme-object ,code)))))
  (c-declare "#include <stdlib.h>")
  (c-declare "static ___SCMOBJ ffi_free (void *ptr);")
  (c-declare
   "#ifndef ___HAVE_FFI_U8VECTOR\n#define ___HAVE_FFI_U8VECTOR\n#define U8_DATA(obj) ___CAST (___U8*, ___BODY_AS (obj, ___tSUBTYPED))\n#define U8_LEN(obj) ___HD_BYTES (___HEADER (obj))\n#endif")
  (namespace
   ("std/protobuf/io#"
    bytes->float
    float->bytes!
    bytes->double
    double->bytes!))
  (c-declare
   "static float ffi_read_float_bytes (___SCMOBJ bytes)\n{\n return *(float*)(U8_DATA (bytes));\n}\n\nstatic void ffi_write_float_bytes (float val, ___SCMOBJ bytes)\n{\n *(float*)(U8_DATA (bytes)) = val;\n}\n\nstatic double ffi_read_double_bytes (___SCMOBJ bytes)\n{\n return *(double*)(U8_DATA (bytes));\n}\n\nstatic void ffi_write_double_bytes (double val, ___SCMOBJ bytes)\n{\n *(double*)(U8_DATA (bytes)) = val;\n}")
  (define-c-lambda bytes->float (scheme-object) float "ffi_read_float_bytes")
  (define-c-lambda
   float->bytes!
   (float scheme-object)
   void
   "ffi_write_float_bytes")
  (define-c-lambda
   bytes->double
   (scheme-object)
   double
   "ffi_read_double_bytes")
  (define-c-lambda
   double->bytes!
   (double scheme-object)
   void
   "ffi_write_double_bytes")
  (c-declare
   "#ifndef ___HAVE_FFI_FREE\n#define ___HAVE_FFI_FREE\n___SCMOBJ ffi_free (void *ptr)\n{\n free (ptr);\n return ___FIX (___NO_ERR);\n}\n#endif"))
