(declare (block) (standard-bindings) (extended-bindings))
(begin
  (declare (not safe))
  (define std/net/httpd/file#open-flags
    (if std/os/fcntl#O_NOATIME
        (fxior std/os/fcntl#O_RDONLY std/os/fcntl#O_NOATIME)
        std/os/fcntl#O_RDONLY))
  (define std/net/httpd/file#http-response-file
    (lambda (_res153681_ _headers153682_ _path153683_)
      (let ((_file153685_
             (std/os/fdio#open__0 _path153683_ std/net/httpd/file#open-flags)))
        (with-unwind-protect
         (lambda ()
           (std/net/httpd/file#http-response-write-file
            _res153681_
            _headers153682_
            _file153685_))
         (lambda () (close-port _file153685_))))))
  (define std/net/httpd/file#http-response-write-file
    (lambda (_res153670_ _headers153671_ _file153672_)
      (let ((_buf153674_ (std/net/httpd/file#get-file-buffer)))
        (std/net/httpd/handler#http-response-begin
         _res153670_
         '200
         _headers153671_)
        (let _lp153676_ ()
          (let ((_rd153679_ (std/os/fdio#fdread__0 _file153672_ _buf153674_)))
            (if (not _rd153679_)
                (begin
                  (std/event#wait__0 (std/os/fd#fd-io-in _file153672_))
                  (_lp153676_))
                (if (fx= _rd153679_ '0)
                    (begin
                      (std/net/httpd/file#put-file-buffer _buf153674_)
                      (std/net/httpd/handler#http-response-end _res153670_))
                    (begin
                      (std/net/httpd/handler#http-response-chunk__%
                       _res153670_
                       _buf153674_
                       '0
                       _rd153679_)
                      (_lp153676_)))))))))
  (define std/net/httpd/file#buffer-cache '())
  (define std/net/httpd/file#get-file-buffer
    (lambda ()
      (declare (not interrupts-enabled))
      (if (##pair? std/net/httpd/file#buffer-cache)
          (let ((_buf153668_ (##car std/net/httpd/file#buffer-cache)))
            (set! std/net/httpd/file#buffer-cache
                  (##cdr std/net/httpd/file#buffer-cache))
            _buf153668_)
          (make-u8vector '8192))))
  (define std/net/httpd/file#put-file-buffer
    (lambda (_buf153663_)
      (declare (not interrupts-enabled))
      (set! std/net/httpd/file#buffer-cache
            (##cons _buf153663_ std/net/httpd/file#buffer-cache)))))
