(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/misc/threads#primordial-thread-group
    (lambda () (thread-thread-group ##primordial-thread)))
  (define std/misc/threads#thread-group->thread-list*
    (lambda (_tg41471_)
      (let _lp41473_ ((_rest41475_ (thread-group->thread-group-list _tg41471_))
                      (_r41476_ (thread-group->thread-list _tg41471_)))
        (let* ((_rest4147741485_ _rest41475_)
               (_else4147941493_ (lambda () _r41476_))
               (_K4148141499_
                (lambda (_rest41496_ _tg41497_)
                  (_lp41473_
                   (foldl1 cons
                           _rest41496_
                           (thread-group->thread-group-list _tg41497_))
                   (foldl1 cons
                           _r41476_
                           (thread-group->thread-list _tg41497_))))))
          (if (##pair? _rest4147741485_)
              (let ((_hd4148241502_ (##car _rest4147741485_))
                    (_tl4148341504_ (##cdr _rest4147741485_)))
                (let* ((_tg41507_ _hd4148241502_) (_rest41509_ _tl4148341504_))
                  (_K4148141499_ _rest41509_ _tg41507_)))
              (_else4147941493_))))))
  (define std/misc/threads#all-threads
    (lambda ()
      (std/misc/threads#thread-group->thread-list*
       (std/misc/threads#primordial-thread-group))))
  (namespace ("std/misc/threads#" thread-dead?))
  (define (thread-dead? thread) (not (macro-thread-end-condvar thread)))
  (namespace
   ("std/misc/threads#"
    thread-group-kill!
    tgroup-kill!
    tgroup-kill-threads!
    tgroup-detach!))
  (define (thread-group-kill! tg)
    (declare (not interrupts-enabled))
    (define (check-tgroup! tg)
      (let ((mytg (macro-thread-tgroup (##current-thread))))
        (let lp ((mytg mytg))
          (cond ((##eq? mytg tg)
                 (error "Cannot kill thread group; thread-group includes current thread"
                        tg))
                ((##not mytg))
                (else (lp (macro-tgroup-parent mytg)))))))
    (if (macro-tgroup? tg)
        (begin
          (check-tgroup! tg)
          (cond-expand
           (enable-smp (let lp () (if (##fx> (tgroup-kill! tg) 0) (lp))))
           (else (tgroup-kill! tg)))
          (tgroup-detach! tg)
          (void))
        (error "Bad argument; expected thread-group" tg)))
  (define (tgroup-kill! tg)
    (declare (not interrupts-enabled))
    (let ((tgroups (##tgroup->tgroup-vector tg)))
      (let lp ((i 0) (r 0))
        (if (##fx< i (##vector-length tgroups))
            (let ((count (tgroup-kill! (##vector-ref tgroups i))))
              (lp (##fx+ i 1) (##fx+ r count)))
            (let ((count (tgroup-kill-threads! tg))) (##fx+ r count))))))
  (define (tgroup-kill-threads! tg)
    (declare (not interrupts-enabled))
    (let ((threads (##tgroup->thread-vector tg)))
      (let lp ((i 0))
        (if (##fx< i (##vector-length threads))
            (begin
              (##thread-terminate! (##vector-ref threads i))
              (lp (##fx+ i 1)))
            i))))
  (define (tgroup-detach! tg)
    (declare (not interrupts-enabled))
    (if (macro-tgroup-parent tg)
        (begin
          (let ((next (macro-tgroup-tgroups-deq-next tg))
                (prev (macro-tgroup-tgroups-deq-prev tg)))
            (cond-expand
             (enable-smp
              (##vector-set! prev 2 next)
              (##vector-set! next 3 prev))
             (else (##vector-set! prev 1 next) (##vector-set! next 2 prev)))
            (macro-tgroup-tgroups-deq-next-set! tg tg)
            (macro-tgroup-tgroups-deq-prev-set! tg tg))
          (cond-expand
           (enable-smp (##vector-set! tg 8 #f))
           (else (macro-tgroup-parent-set! tg #f))))))
  (define std/misc/threads#thread-abort::t
    (make-struct-type
     'std/misc/threads#thread-abort::t
     '#f
     '0
     'thread-abort
     '((final: . #t))
     '#f
     '()))
  (define std/misc/threads#thread-abort?
    (make-struct-predicate std/misc/threads#thread-abort::t))
  (define std/misc/threads#make-thread-abort
    (lambda _$args41467_
      (apply make-struct-instance
             std/misc/threads#thread-abort::t
             _$args41467_)))
  (define std/misc/threads#thread-abort::display-exception
    (lambda (_self41464_ _port41465_)
      (display '"thread aborted" _port41465_)
      (newline _port41465_)))
  (bind-method!
   std/misc/threads#thread-abort::t
   'display-exception
   std/misc/threads#thread-abort::display-exception
   '#f)
  (define std/misc/threads#+thread-abort+
    (##structure std/misc/threads#thread-abort::t))
  (define std/misc/threads#thread-abort!
    (lambda (_thread41339_)
      (std/misc/threads#thread-raise!
       _thread41339_
       std/misc/threads#+thread-abort+)))
  (define std/misc/threads#thread-raise!
    (lambda (_thread41335_ _obj41336_)
      (if (not (thread? _thread41335_))
          (error '"Bad argument; expected thread" _thread41335_)
          (if (eq? _thread41335_ (current-thread))
              (raise _obj41336_)
              (std/misc/threads#thread-intr!
               _thread41335_
               (lambda () (raise _obj41336_)))))))
  (define std/misc/threads#thread-async!
    (lambda (_thread41332_ _thunk41333_)
      (if (not (thread? _thread41332_))
          (error '"Bad argument; expected thread" _thread41332_)
          (if (eq? _thread41332_ (current-thread))
              (_thunk41333_)
              (std/misc/threads#thread-intr! _thread41332_ _thunk41333_)))))
  (namespace ("std/misc/threads#" thread-intr!))
  (define (thread-intr! thread thunk)
    (declare (not interrupts-enabled))
    (if (and (macro-initialized-thread? thread)
             (##not (macro-terminated-thread-given-initialized? thread))
             (cond-expand
              (enable-smp (macro-started-thread? thread))
              (else (macro-started-thread-given-initialized? thread))))
        (begin
          (cond-expand
           (enable-smp (##thread-intr! thread #t thunk))
           (else (##thread-int! thread thunk)))
          (##void))
        #f))
  (define std/misc/threads#on-all-processors
    (lambda (_thunk41330_)
      (cons (gerbil/gambit/threads#spawn-thread__0 _thunk41330_) '()))))
