(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/misc/string#string-trim-prefix
    (lambda (_prefix112690_ _string112691_)
      (if (std/srfi/13#string-prefix?__0 _prefix112690_ _string112691_)
          (std/srfi/13#string-drop
           _string112691_
           (string-length _prefix112690_))
          _string112691_)))
  (define std/misc/string#string-split-prefix
    (lambda (_prefix112685_ _string112686_)
      (let ((_trimmed112688_
             (std/misc/string#string-trim-prefix
              _prefix112685_
              _string112686_)))
        (if (eq? _trimmed112688_ _string112686_)
            (values _string112686_ '"")
            (values _trimmed112688_ _prefix112685_)))))
  (define std/misc/string#string-trim-suffix
    (lambda (_suffix112682_ _string112683_)
      (if (std/srfi/13#string-suffix?__0 _suffix112682_ _string112683_)
          (std/srfi/13#string-drop-right
           _string112683_
           (string-length _suffix112682_))
          _string112683_)))
  (define std/misc/string#string-split-suffix
    (lambda (_suffix112677_ _string112678_)
      (let ((_trimmed112680_
             (std/misc/string#string-trim-suffix
              _suffix112677_
              _string112678_)))
        (if (eq? _trimmed112680_ _string112678_)
            (values _string112678_ '"")
            (values _trimmed112680_ _suffix112677_)))))
  (define std/misc/string#+cr+ '"\r")
  (define std/misc/string#+lf+ '"\n")
  (define std/misc/string#+crlf+ '"\r\n")
  (define std/misc/string#string-trim-eol
    (lambda (_string112579_)
      (let ((_trimmed112668_
             (std/misc/string#string-trim-suffix
              std/misc/string#+crlf+
              _string112579_)))
        (if (eq? _trimmed112668_ _string112579_)
            (let ((_trimmed112671_
                   (std/misc/string#string-trim-suffix
                    std/misc/string#+lf+
                    _string112579_)))
              (if (eq? _trimmed112671_ _string112579_)
                  (let ((_trimmed112674_
                         (std/misc/string#string-trim-suffix
                          std/misc/string#+cr+
                          _string112579_)))
                    (if (eq? _trimmed112674_ _string112579_)
                        _string112579_
                        _trimmed112674_))
                  _trimmed112671_))
            _trimmed112668_))))
  (define std/misc/string#string-split-eol
    (lambda (_string112479_)
      (let ((_trimmed112570_
             (std/misc/string#string-trim-suffix
              std/misc/string#+crlf+
              _string112479_)))
        (if (eq? _trimmed112570_ _string112479_)
            (let ((_trimmed112573_
                   (std/misc/string#string-trim-suffix
                    std/misc/string#+lf+
                    _string112479_)))
              (if (eq? _trimmed112573_ _string112479_)
                  (let ((_trimmed112576_
                         (std/misc/string#string-trim-suffix
                          std/misc/string#+cr+
                          _string112479_)))
                    (if (eq? _trimmed112576_ _string112479_)
                        (values _string112479_ '"")
                        (values _trimmed112576_ std/misc/string#+cr+)))
                  (values _trimmed112573_ std/misc/string#+lf+)))
            (values _trimmed112570_ std/misc/string#+crlf+)))))
  (define std/misc/string#subst-helper-empty-old
    (lambda (_str112460_ _new112461_ _count112462_)
      (declare (fixnum))
      (letrec* ((_len-str112464_ (string-length _str112460_)))
        (if (= _count112462_ '1)
            (string-append _new112461_ _str112460_)
            (call-with-output-string
             (lambda (_port112466_)
               (gerbil/gambit/ports#write-string__% _new112461_ _port112466_)
               (let ((_stop112471_ (- _len-str112464_ '1))
                     (_count112472_
                      (if (or (negative? _count112462_)
                              (> _count112462_ _len-str112464_))
                          (+ _len-str112464_ '1)
                          _count112462_)))
                 (let _loop112474_ ((_i112476_ '0) (_matches112477_ '1))
                   (if (= _matches112477_ _count112472_)
                       (begin
                         (gerbil/gambit/ports#write-string__%
                          _new112461_
                          _port112466_)
                         (write-substring
                          _str112460_
                          _i112476_
                          _len-str112464_
                          _port112466_))
                       (if (= _i112476_ _stop112471_)
                           (begin
                             (if (zero? _i112476_)
                                 '#!void
                                 (gerbil/gambit/ports#write-string__%
                                  _new112461_
                                  _port112466_))
                             (write-char
                              (string-ref _str112460_ _i112476_)
                              _port112466_)
                             (gerbil/gambit/ports#write-string__%
                              _new112461_
                              _port112466_))
                           (begin
                             (if (zero? _i112476_)
                                 '#!void
                                 (gerbil/gambit/ports#write-string__%
                                  _new112461_
                                  _port112466_))
                             (write-char
                              (string-ref _str112460_ _i112476_)
                              _port112466_)
                             (_loop112474_
                              (+ _i112476_ '1)
                              (+ _matches112477_ '1)))))))))))))
  (define std/misc/string#subst-helper-nonempty-old
    (lambda (_str112442_ _old112443_ _new112444_ _count112445_)
      (declare (fixnum))
      (letrec* ((_len-str112447_ (string-length _str112442_))
                (_size-old112448_ (- (string-length _old112443_) '1))
                (_size-str112449_ (- (string-length _str112442_) '1)))
        (call-with-output-string
         (lambda (_port112451_)
           (let _loop112453_ ((_i112455_ '0)
                              (_matches112456_ '0)
                              (_last112457_ '0)
                              (_j112458_ '0))
             (if (= _matches112456_ _count112445_)
                 (write-substring
                  _str112442_
                  _i112455_
                  _len-str112447_
                  _port112451_)
                 (if (= _i112455_ _size-str112449_)
                     (if (and (eq? (string-ref _str112442_ _i112455_)
                                   (string-ref _old112443_ _j112458_))
                              (= _j112458_ _size-old112448_))
                         (gerbil/gambit/ports#write-string__%
                          _new112444_
                          _port112451_)
                         (write-substring
                          _str112442_
                          _last112457_
                          _len-str112447_
                          _port112451_))
                     (if (eq? (string-ref _str112442_ _i112455_)
                              (string-ref _old112443_ _j112458_))
                         (if (= _j112458_ _size-old112448_)
                             (begin
                               (gerbil/gambit/ports#write-string__%
                                _new112444_
                                _port112451_)
                               (_loop112453_
                                (+ _i112455_ '1)
                                (+ _matches112456_ '1)
                                (+ _i112455_ '1)
                                '0))
                             (_loop112453_
                              (+ _i112455_ '1)
                              _matches112456_
                              _last112457_
                              (+ _j112458_ '1)))
                         (begin
                           (write-substring
                            _str112442_
                            _last112457_
                            (+ _i112455_ '1)
                            _port112451_)
                           (_loop112453_
                            (+ _i112455_ '1)
                            _matches112456_
                            (+ _i112455_ '1)
                            '0)))))))))))
  (define std/misc/string#string-subst__%
    (lambda (_g112692_ _count112405112408_ _str112410_ _old112411_ _new112412_)
      (let ((_count112414_
             (if (eq? _count112405112408_ absent-value)
                 '#f
                 _count112405112408_)))
        (declare (fixnum))
        (letrec* ((_g112693_
                   (let ((_g112694_
                          (if (or (not _count112414_) (fixnum? _count112414_))
                              '#!void
                              (error '"Illegal argument; count must be a fixnum or #f, got:"
                                     _count112414_))))
                     #!void
                     _g112694_))
                  (_old-empty?112419_ (string-empty? _old112411_))
                  (_new-empty?112420_ (string-empty? _new112412_))
                  (_str-empty?112421_ (string-empty? _str112410_)))
          (if (or (and _old-empty?112419_ _new-empty?112420_)
                  (and _count112414_ (<= _count112414_ '0)))
              _str112410_
              (let ((_count112426_
                     (if (number? _count112414_) _count112414_ '-1)))
                (if _old-empty?112419_
                    (std/misc/string#subst-helper-empty-old
                     _str112410_
                     _new112412_
                     _count112426_)
                    (if _str-empty?112421_
                        _str112410_
                        (std/misc/string#subst-helper-nonempty-old
                         _str112410_
                         _old112411_
                         _new112412_
                         _count112426_)))))))))
  (define std/misc/string#string-subst__@
    (lambda (_keys112404112431_ . _args112433_)
      (apply std/misc/string#string-subst__%
             _keys112404112431_
             (table-ref _keys112404112431_ 'count: absent-value)
             _args112433_)))
  (define std/misc/string#string-subst
    (lambda _args112406112439_
      (apply keyword-dispatch
             '#(count:)
             std/misc/string#string-subst__@
             _args112406112439_))))
