/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.ItemSelectable;
import java.awt.MenuItem;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.peer.CheckboxMenuItemPeer;
import java.util.EventListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckboxMenuItem
extends MenuItem
implements ItemSelectable,
Accessible {
    private static transient long next_chkmenuitem_number;
    private static final long serialVersionUID = 6190621106981774043L;
    private boolean state;
    private transient ItemListener item_listeners;

    public CheckboxMenuItem() {
        this("", false);
    }

    public CheckboxMenuItem(String label) {
        this(label, false);
    }

    public CheckboxMenuItem(String label, boolean state) {
        super(label);
        this.state = state;
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
    }

    public boolean getState() {
        return this.state;
    }

    public synchronized void setState(boolean state) {
        this.state = state;
        if (this.peer != null) {
            CheckboxMenuItemPeer cp = (CheckboxMenuItemPeer)this.peer;
            cp.setState(state);
        }
    }

    @Override
    public Object[] getSelectedObjects() {
        if (!this.state) {
            return null;
        }
        Object[] obj = new Object[]{this.getLabel()};
        return obj;
    }

    @Override
    public synchronized void addNotify() {
        if (this.peer == null) {
            this.peer = this.getToolkit().createCheckboxMenuItem(this);
        }
        super.addNotify();
    }

    @Override
    public synchronized void addItemListener(ItemListener listener) {
        this.item_listeners = AWTEventMulticaster.add(this.item_listeners, listener);
        this.enableEvents(512L);
    }

    @Override
    public synchronized void removeItemListener(ItemListener listener) {
        this.item_listeners = AWTEventMulticaster.remove(this.item_listeners, listener);
    }

    @Override
    protected void processEvent(AWTEvent event) {
        if (event instanceof ItemEvent) {
            this.processItemEvent((ItemEvent)event);
        } else {
            super.processEvent(event);
        }
    }

    protected void processItemEvent(ItemEvent event) {
        if (this.item_listeners != null) {
            this.item_listeners.itemStateChanged(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void dispatchEventImpl(AWTEvent e) {
        if (e instanceof ItemEvent) {
            CheckboxMenuItem checkboxMenuItem = this;
            synchronized (checkboxMenuItem) {
                this.state = ((ItemEvent)e).getStateChange() == 1;
            }
        }
        if (e.id <= 701 && e.id >= 701 && (this.item_listeners != null || (this.eventMask & 0x200L) != 0L)) {
            this.processEvent(e);
        } else {
            super.dispatchEventImpl(e);
        }
    }

    @Override
    public String paramString() {
        return "label=" + this.getLabel() + ",state=" + this.state + "," + super.paramString();
    }

    @Override
    public <T extends EventListener> T[] getListeners(Class<T> listenerType) {
        if (listenerType == ItemListener.class) {
            return AWTEventMulticaster.getListeners((EventListener)this.item_listeners, listenerType);
        }
        return super.getListeners(listenerType);
    }

    public ItemListener[] getItemListeners() {
        return (ItemListener[])this.getListeners(ItemListener.class);
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTCheckboxMenuItem();
        }
        return this.accessibleContext;
    }

    @Override
    String generateName() {
        return "chkmenuitem" + CheckboxMenuItem.getUniqueLong();
    }

    private static synchronized long getUniqueLong() {
        return next_chkmenuitem_number++;
    }

    protected class AccessibleAWTCheckboxMenuItem
    extends MenuItem.AccessibleAWTMenuItem
    implements AccessibleAction,
    AccessibleValue {
        private static final long serialVersionUID = -1122642964303476L;

        protected AccessibleAWTCheckboxMenuItem() {
            super(CheckboxMenuItem.this);
        }
    }
}

