/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.cipher;

import gnu.java.security.Registry;
import gnu.javax.crypto.cipher.Anubis;
import gnu.javax.crypto.cipher.BaseCipher;
import gnu.javax.crypto.cipher.Blowfish;
import gnu.javax.crypto.cipher.Cast5;
import gnu.javax.crypto.cipher.DES;
import gnu.javax.crypto.cipher.IBlockCipher;
import gnu.javax.crypto.cipher.Khazad;
import gnu.javax.crypto.cipher.NullCipher;
import gnu.javax.crypto.cipher.Rijndael;
import gnu.javax.crypto.cipher.Serpent;
import gnu.javax.crypto.cipher.Square;
import gnu.javax.crypto.cipher.TripleDES;
import gnu.javax.crypto.cipher.Twofish;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class CipherFactory
implements Registry {
    private CipherFactory() {
    }

    public static final IBlockCipher getInstance(String name) {
        if (name == null) {
            return null;
        }
        name = name.trim();
        BaseCipher result = null;
        if (name.equalsIgnoreCase("anubis")) {
            result = new Anubis();
        } else if (name.equalsIgnoreCase("blowfish")) {
            result = new Blowfish();
        } else if (name.equalsIgnoreCase("des")) {
            result = new DES();
        } else if (name.equalsIgnoreCase("khazad")) {
            result = new Khazad();
        } else if (name.equalsIgnoreCase("rijndael") || name.equalsIgnoreCase("aes")) {
            result = new Rijndael();
        } else if (name.equalsIgnoreCase("serpent")) {
            result = new Serpent();
        } else if (name.equalsIgnoreCase("square")) {
            result = new Square();
        } else if (name.equalsIgnoreCase("tripledes") || name.equalsIgnoreCase("desede")) {
            result = new TripleDES();
        } else if (name.equalsIgnoreCase("twofish")) {
            result = new Twofish();
        } else if (name.equalsIgnoreCase("cast5") || name.equalsIgnoreCase("cast128") || name.equalsIgnoreCase("cast-128")) {
            result = new Cast5();
        } else if (name.equalsIgnoreCase("null")) {
            result = new NullCipher();
        }
        if (result != null && !result.selfTest()) {
            throw new InternalError(result.name());
        }
        return result;
    }

    public static final Set getNames() {
        HashSet<String> hs = new HashSet<String>();
        hs.add("anubis");
        hs.add("blowfish");
        hs.add("des");
        hs.add("khazad");
        hs.add("rijndael");
        hs.add("serpent");
        hs.add("square");
        hs.add("tripledes");
        hs.add("twofish");
        hs.add("cast5");
        hs.add("null");
        return Collections.unmodifiableSet(hs);
    }
}

