/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.font.opentype.truetype;

import gnu.java.awt.font.opentype.Hinter;
import gnu.java.awt.font.opentype.Scaler;
import gnu.java.awt.font.opentype.truetype.GlyphLoader;
import gnu.java.awt.font.opentype.truetype.GlyphLocator;
import gnu.java.awt.font.opentype.truetype.GlyphMeasurer;
import gnu.java.awt.font.opentype.truetype.VirtualMachine;
import gnu.java.awt.font.opentype.truetype.Zone;
import java.awt.FontFormatException;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.nio.ByteBuffer;

public final class TrueTypeScaler
extends Scaler {
    private ByteBuffer glyfTable;
    private GlyphLoader glyphLoader;
    private final GlyphMeasurer glyphMeasurer;
    private final Zone glyphZone;
    private int unitsPerEm;

    public TrueTypeScaler(int unitsPerEm, ByteBuffer hhea, ByteBuffer htmx, ByteBuffer vhea, ByteBuffer vtmx, ByteBuffer maxp, ByteBuffer controlValueTable, ByteBuffer fpgm, int locaFormat, ByteBuffer loca, ByteBuffer glyf, ByteBuffer preProgram) throws FontFormatException {
        int maxContours = Math.max(maxp.getChar(8), maxp.getChar(12)) + 8;
        int maxPoints = Math.max(maxp.getChar(6), maxp.getChar(10)) + 12;
        this.glyphZone = new Zone(maxPoints + 4);
        this.glyfTable = glyf;
        VirtualMachine vm = new VirtualMachine(unitsPerEm, maxp, controlValueTable, fpgm, preProgram);
        GlyphLocator locator = GlyphLocator.forTable(locaFormat, loca, glyf);
        this.glyphMeasurer = new GlyphMeasurer(hhea, htmx, vhea, vtmx);
        this.glyphLoader = new GlyphLoader(locator, vm, unitsPerEm, maxContours, maxPoints, this.glyphMeasurer);
        this.unitsPerEm = unitsPerEm;
    }

    public GeneralPath getOutline(int glyphIndex, float pointSize, AffineTransform deviceTransform, boolean antialias, boolean fractionalMetrics, Hinter hinter, int type) {
        this.glyphLoader.loadGlyph(glyphIndex, pointSize, deviceTransform, antialias, this.glyphZone, hinter);
        return this.glyphZone.getPath(type);
    }

    public Zone getRawOutline(int glyphIndex, AffineTransform transform) {
        Zone zone = new Zone(this.glyphZone.getCapacity());
        this.glyphLoader.loadGlyph(glyphIndex, transform, zone, null);
        return zone;
    }

    public void getAdvance(int glyphIndex, float pointSize, AffineTransform transform, boolean antialias, boolean fractionalMetrics, boolean horizontal, Point2D advance) {
        double scaleFactor = (double)pointSize / (double)this.unitsPerEm;
        advance.setLocation(scaleFactor * (double)this.glyphMeasurer.getAdvanceWidth(glyphIndex, horizontal), scaleFactor * (double)this.glyphMeasurer.getAdvanceHeight(glyphIndex, horizontal));
        transform.transform(advance, advance);
    }

    private float scaleFromFUnits(int funits, float pointSize, AffineTransform transform, boolean fractionalMetrics, boolean horizontal) {
        double s = (double)pointSize / (double)this.unitsPerEm;
        if (transform != null) {
            s *= horizontal ? transform.getScaleY() : transform.getScaleX();
        }
        s *= (double)funits;
        if (!fractionalMetrics) {
            s = Math.round(s);
        }
        return (float)s;
    }

    public float getAscent(float pointSize, AffineTransform transform, boolean antialias, boolean fractionalMetrics, boolean horizontal) {
        return this.scaleFromFUnits(this.glyphMeasurer.getAscent(horizontal), pointSize, transform, fractionalMetrics, !horizontal);
    }

    public float getDescent(float pointSize, AffineTransform transform, boolean antialiased, boolean fractionalMetrics, boolean horizontal) {
        return this.scaleFromFUnits(this.glyphMeasurer.getDescent(horizontal), pointSize, transform, fractionalMetrics, !horizontal);
    }
}

