/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt;

import gnu.java.awt.EmbeddedWindow;
import gnu.java.awt.peer.ClasspathDesktopPeer;
import gnu.java.awt.peer.ClasspathFontPeer;
import gnu.java.awt.peer.EmbeddedWindowPeer;
import gnu.java.security.action.SetAccessibleAction;
import java.awt.AWTException;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.peer.DesktopPeer;
import java.awt.peer.RobotPeer;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.util.Map;
import javax.imageio.spi.IIORegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClasspathToolkit
extends Toolkit {
    public abstract GraphicsEnvironment getLocalGraphicsEnvironment();

    public abstract ClasspathFontPeer getClasspathFontPeer(String var1, Map<?, ?> var2);

    public Font getFont(String name, Map attrs) {
        Font f = null;
        try {
            Constructor fontConstructor = Font.class.getDeclaredConstructor(String.class, Map.class);
            AccessController.doPrivileged(new SetAccessibleAction(fontConstructor));
            f = (Font)fontConstructor.newInstance(name, attrs);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
        catch (InstantiationException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            throw new AssertionError((Object)e);
        }
        return f;
    }

    public abstract Font createFont(int var1, InputStream var2);

    public abstract RobotPeer createRobot(GraphicsDevice var1) throws AWTException;

    public abstract EmbeddedWindowPeer createEmbeddedWindow(EmbeddedWindow var1);

    public void registerImageIOSpis(IIORegistry reg) {
    }

    public int getMouseNumberOfButtons() {
        return -1;
    }

    @Override
    protected DesktopPeer createDesktopPeer(Desktop target) throws HeadlessException {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        return ClasspathDesktopPeer.getDesktop();
    }
}

