/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.javah;

import gnu.classpath.tools.javah.CniPrintStream;
import gnu.classpath.tools.javah.FieldHelper;
import gnu.classpath.tools.javah.Main;
import gnu.classpath.tools.javah.MethodHelper;
import gnu.classpath.tools.javah.Text;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassWrapper
extends ClassNode {
    Main classpath;
    ClassWrapper superClass;
    ArrayList<ClassWrapper> interfaceClasses;
    ArrayList<MethodNode> vtable;
    HashSet<String> bridgeTargets;
    HashSet<String> methodNames = new HashSet();
    HashMap<String, String> methodNameMap = new HashMap();

    public ClassWrapper(Main classpath) {
        this.classpath = classpath;
    }

    public boolean hasNativeMethod() {
        for (MethodNode method : this.methods) {
            if (!Modifier.isNative(method.access)) continue;
            return true;
        }
        return false;
    }

    public boolean isThrowable() throws IOException {
        this.linkSupers();
        ClassWrapper self = this;
        while (self != null) {
            if (self.name.equals("java/lang/Throwable")) {
                return true;
            }
            self = self.superClass;
        }
        return false;
    }

    void linkSupers() throws IOException {
        if (this.superName == null) {
            return;
        }
        if (this.superClass == null) {
            this.superClass = this.classpath.getClass(this.superName);
            assert (this.interfaceClasses == null);
            this.interfaceClasses = new ArrayList();
            int i = 0;
            while (i < this.interfaces.size()) {
                String ifname = (String)this.interfaces.get(i);
                ClassWrapper iface = this.classpath.getClass(ifname);
                iface.linkSupers();
                this.interfaceClasses.add(iface);
                ++i;
            }
        }
        this.superClass.linkSupers();
    }

    private int findSlot(MethodNode method) {
        int i = this.vtable.size() - 1;
        while (i >= 0) {
            MethodNode base = this.vtable.get(i);
            if (MethodHelper.overrides(method, base)) {
                return i;
            }
            --i;
        }
        return -1;
    }

    private void addInterfaceMethods(ClassWrapper iface) {
        for (MethodNode im : iface.methods) {
            int slot = this.findSlot(im);
            if (slot != -1) continue;
            this.vtable.add(im);
            this.methods.add(im);
        }
        this.addInterfaces(iface);
    }

    private void addInterfaces(ClassWrapper base) {
        if (base.interfaceClasses == null) {
            return;
        }
        for (ClassWrapper iface : base.interfaceClasses) {
            this.addInterfaceMethods(iface);
        }
    }

    private void addLocalMethods() {
        for (MethodNode meth : this.methods) {
            this.methodNames.add(meth.name);
            if (Modifier.isStatic(meth.access)) continue;
            int slot = this.findSlot(meth);
            if (slot == -1) {
                this.vtable.add(meth);
                continue;
            }
            this.vtable.set(slot, meth);
        }
    }

    private void makeVtable() throws IOException {
        if (this.vtable != null) {
            return;
        }
        if (this.superClass != null) {
            this.superClass.makeVtable();
            this.vtable = new ArrayList<MethodNode>(this.superClass.vtable);
            this.bridgeTargets = new HashSet<String>(this.superClass.bridgeTargets);
            this.methodNameMap = new HashMap<String, String>(this.superClass.methodNameMap);
        } else {
            this.vtable = new ArrayList();
            this.bridgeTargets = new HashSet();
            this.methodNameMap = new HashMap();
        }
        this.addLocalMethods();
        this.addInterfaces(this);
        for (MethodNode m : this.methods) {
            String sum;
            boolean newTarget;
            String desc = MethodHelper.getBridgeTarget(m);
            if (desc == null || !(newTarget = this.bridgeTargets.add(sum = String.valueOf(m.name) + desc))) continue;
            String cname = this.name;
            int index = cname.lastIndexOf(47);
            cname = cname.substring(index + 1);
            this.methodNameMap.put(sum, String.valueOf(cname) + "$" + m.name);
        }
    }

    private void printFields(CniPrintStream out) {
        Iterator i = this.fields.iterator();
        ClassWrapper self = this.superClass;
        while (i.hasNext()) {
            boolean hasMethodName;
            FieldNode f = (FieldNode)i.next();
            if (!FieldHelper.print(out, f, self, hasMethodName = this.methodNames.contains(f.name))) continue;
            self = null;
        }
    }

    private void printMethods(CniPrintStream out) throws IOException {
        this.makeVtable();
        for (MethodNode m : this.methods) {
            String sum = String.valueOf(m.name) + m.desc;
            String nameToUse = this.bridgeTargets.contains(sum) ? this.methodNameMap.get(sum) : m.name;
            this.methodNameMap.put(sum, nameToUse);
            MethodHelper.print(out, m, this, nameToUse);
        }
    }

    private void printTextList(PrintStream out, int what, ArrayList<Text> textList) {
        if (textList == null) {
            return;
        }
        Iterator<Text> i = textList.iterator();
        boolean first = true;
        while (i.hasNext()) {
            Text item = i.next();
            if (item.type != what) continue;
            if (first) {
                out.println();
                first = false;
            }
            if (what == 2) {
                out.print("  friend ");
            }
            out.println(item.text);
        }
    }

    public void print(CniPrintStream out) {
        out.print("::");
        out.printName(this.name);
    }

    private void printContents(CniPrintStream out, ArrayList<Text> textList) throws IOException {
        this.printTextList(out, 3, textList);
        out.println();
        out.print("class ");
        out.printName(this.name);
        if (this.superClass != null) {
            out.print(" : public ");
            this.superClass.print(out);
        }
        out.println();
        out.println("{");
        this.printTextList(out, 0, textList);
        out.println();
        this.printMethods(out);
        this.printFields(out);
        out.setModifiers(1);
        out.println("  static ::java::lang::Class class$;");
        this.printTextList(out, 2, textList);
        out.print("}");
        if (Modifier.isInterface(this.access)) {
            out.print(" __attribute__ ((java_interface))");
        }
        out.println(";");
        this.printTextList(out, 1, textList);
    }

    public void printFully(PrintStream out) throws IOException {
        this.linkSupers();
        ArrayList<Text> textList = this.classpath.getClassTextList(this.name);
        out.println("// DO NOT EDIT THIS FILE - it is machine generated -*- c++ -*-");
        out.println();
        String xname = "__" + this.name.replaceAll("/", "_") + "__";
        out.println("#ifndef " + xname);
        out.println("#define " + xname);
        out.println();
        out.println("#pragma interface");
        out.println();
        if (this.superClass != null) {
            out.print("#include <");
            out.print(this.superName);
            out.println(".h>");
        }
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        CniPrintStream cxxOut = new CniPrintStream(bytes);
        cxxOut.addClass(this);
        this.printContents(cxxOut, textList);
        cxxOut.printNamespaces(out);
        bytes.writeTo(out);
        out.println();
        out.println("#endif // " + xname);
    }

    public String toString() {
        return this.name;
    }
}

