/*
 * Decompiled with CFR 0.152.
 */
package com.github.arara.utils;

import com.github.arara.exception.AraraException;
import com.github.arara.model.AraraCommand;
import com.github.arara.model.AraraRuleArgument;
import com.github.arara.model.AraraRuleConfig;
import com.github.arara.model.AraraTask;
import com.github.arara.utils.AraraLocalization;
import com.github.arara.utils.AraraMethods;
import com.github.arara.utils.AraraUtils;
import com.github.arara.utils.ConfigurationLoader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.SystemUtils;
import org.mvel2.templates.TemplateRuntime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.error.MarkedYAMLException;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskDeployer {
    static final Logger logger = LoggerFactory.getLogger(TaskDeployer.class);
    static final AraraLocalization localization = AraraLocalization.getInstance();
    private List<AraraTask> tasks;
    private List<AraraCommand> commands;
    private ConfigurationLoader configuration;

    public TaskDeployer(List<AraraTask> tasks, ConfigurationLoader configuration) {
        this.tasks = tasks;
        this.configuration = configuration;
        this.commands = new ArrayList<AraraCommand>();
    }

    public List<AraraCommand> deploy() throws Exception {
        logger.info("Deploying tasks into commands.");
        for (AraraTask currentTask : this.tasks) {
            int pathIndex = this.findRule(currentTask);
            if (pathIndex != -1) {
                this.deployRule(currentTask, pathIndex);
                continue;
            }
            throw new AraraException(localization.getMessage("Error_RuleNotFound", currentTask.getName()));
        }
        return this.commands;
    }

    private int findRule(AraraTask task) {
        List<String> paths = this.configuration.getPaths();
        for (int i = 0; i < paths.size(); ++i) {
            if (!new File(paths.get(i).concat(File.separator).concat(task.getName()).concat(".yaml")).exists()) continue;
            logger.trace(localization.getMessage("Log_RuleFound", task.getName(), paths.get(i)));
            return i;
        }
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void deployRule(AraraTask task, int pathIndex) throws Exception {
        Representer representer = new Representer();
        representer.addClassTag(AraraRuleConfig.class, new Tag("!config"));
        representer.addClassTag(AraraRuleArgument.class, new Tag("!argument"));
        Yaml yaml = new Yaml(new Constructor(AraraRuleConfig.class), representer);
        FileReader fileReader = null;
        fileReader = new FileReader(this.configuration.getPaths().get(pathIndex).concat(File.separator).concat(task.getName()).concat(".yaml"));
        AraraRuleConfig plainRule = null;
        try {
            plainRule = (AraraRuleConfig)yaml.load(fileReader);
        }
        catch (MarkedYAMLException yamlException) {
            throw new AraraException(localization.getMessage("Error_InvalidYAMLRule", task.getName(), this.configuration.getPaths().get(pathIndex)).concat("\n\n").concat(AraraUtils.extractInformationFromYAMLException(yamlException)));
        }
        try {
            fileReader.close();
        }
        catch (IOException ioException) {
            // empty catch block
        }
        if (plainRule == null) {
            throw new AraraException(localization.getMessage("Error_InvalidRule", task.getName(), this.configuration.getPaths().get(pathIndex)));
        }
        if (plainRule.getIdentifier() == null) {
            throw new AraraException(localization.getMessage("Error_EmptyIdentifierRule", task.getName(), this.configuration.getPaths().get(pathIndex)));
        }
        if (plainRule.getName() == null) {
            throw new AraraException(localization.getMessage("Error_EmptyNameRule", task.getName(), this.configuration.getPaths().get(pathIndex)));
        }
        if (plainRule.getArguments() == null) {
            throw new AraraException(localization.getMessage("Error_EmptyArgumentsListRule", task.getName(), this.configuration.getPaths().get(pathIndex)));
        }
        if (!task.getName().equals(plainRule.getIdentifier())) {
            throw new AraraException(localization.getMessage("Error_WrongIdentifierRule", task.getName(), this.configuration.getPaths().get(pathIndex), plainRule.getIdentifier()));
        }
        if (plainRule.checkForForbiddenIdentifiers() != null) {
            throw new AraraException(localization.getMessage("Error_ForbiddenIdentifierRule", task.getName(), this.configuration.getPaths().get(pathIndex), plainRule.checkForForbiddenIdentifiers()));
        }
        List<String> availableArgumentsInRule = plainRule.getIdentifiersList();
        availableArgumentsInRule.add("file");
        availableArgumentsInRule.add("item");
        HashMap directiveMap = task.getParameters();
        ArrayList<String> availableArgumentsInDirective = new ArrayList<String>();
        for (Object theKey : directiveMap.keySet()) {
            availableArgumentsInDirective.add((String)theKey);
        }
        List argumentsNotDefinedInDirective = (List)CollectionUtils.subtract(availableArgumentsInRule, availableArgumentsInDirective);
        List argumentsNotDefinedInRule = (List)CollectionUtils.subtract(availableArgumentsInDirective, availableArgumentsInRule);
        if (!argumentsNotDefinedInRule.isEmpty()) {
            throw new AraraException(localization.getMessage("Error_ArgumentsNotDefinedInRule", task.getName(), this.configuration.getPaths().get(pathIndex), argumentsNotDefinedInRule.toString()));
        }
        for (String currentKey : argumentsNotDefinedInDirective) {
            directiveMap.put(currentKey, "");
        }
        HashMap argumentMap = new HashMap();
        argumentMap.put("file", directiveMap.get("file"));
        argumentMap.put("item", directiveMap.get("item"));
        directiveMap.remove("file");
        directiveMap.remove("item");
        argumentMap.put("parameters", directiveMap);
        argumentMap.put("SystemUtils", SystemUtils.class);
        argumentMap.put("isEmpty", AraraMethods.class.getMethod("isEmpty", String.class));
        argumentMap.put("isNotEmpty", AraraMethods.class.getMethod("isNotEmpty", String.class));
        argumentMap.put("isEmpty", AraraMethods.class.getMethod("isEmpty", String.class, String.class));
        argumentMap.put("isNotEmpty", AraraMethods.class.getMethod("isNotEmpty", String.class, String.class));
        argumentMap.put("isEmpty", AraraMethods.class.getMethod("isEmpty", String.class, String.class, String.class));
        argumentMap.put("isNotEmpty", AraraMethods.class.getMethod("isNotEmpty", String.class, String.class, String.class));
        argumentMap.put("isTrue", AraraMethods.class.getMethod("isTrue", String.class));
        argumentMap.put("isFalse", AraraMethods.class.getMethod("isFalse", String.class));
        argumentMap.put("isTrue", AraraMethods.class.getMethod("isTrue", String.class, String.class));
        argumentMap.put("isFalse", AraraMethods.class.getMethod("isFalse", String.class, String.class));
        argumentMap.put("isTrue", AraraMethods.class.getMethod("isTrue", String.class, String.class, String.class));
        argumentMap.put("isFalse", AraraMethods.class.getMethod("isFalse", String.class, String.class, String.class));
        argumentMap.put("isTrue", AraraMethods.class.getMethod("isTrue", String.class, String.class, String.class, String.class));
        argumentMap.put("isFalse", AraraMethods.class.getMethod("isFalse", String.class, String.class, String.class, String.class));
        argumentMap.put("trimSpaces", AraraMethods.class.getMethod("trimSpaces", String.class));
        argumentMap.put("getFilename", AraraMethods.class.getMethod("getFilename", String.class));
        argumentMap.put("getBasename", AraraMethods.class.getMethod("getBasename", String.class));
        argumentMap.put("getFiletype", AraraMethods.class.getMethod("getFiletype", String.class));
        argumentMap.put("getDirname", AraraMethods.class.getMethod("getDirname", String.class));
        argumentMap.put("isFile", AraraMethods.class.getMethod("isFile", String.class));
        argumentMap.put("isDir", AraraMethods.class.getMethod("isDir", String.class));
        argumentMap.put("isWindows", AraraMethods.class.getMethod("isWindows", String.class, String.class));
        argumentMap.put("isLinux", AraraMethods.class.getMethod("isLinux", String.class, String.class));
        argumentMap.put("isUnix", AraraMethods.class.getMethod("isUnix", String.class, String.class));
        argumentMap.put("isMac", AraraMethods.class.getMethod("isMac", String.class, String.class));
        argumentMap.put("isTrue", AraraMethods.class.getMethod("isTrue", Boolean.TYPE, String.class));
        argumentMap.put("isTrue", AraraMethods.class.getMethod("isTrue", Boolean.TYPE, String.class, String.class));
        argumentMap.put("isFalse", AraraMethods.class.getMethod("isFalse", Boolean.TYPE, String.class));
        argumentMap.put("isFalse", AraraMethods.class.getMethod("isFalse", Boolean.TYPE, String.class, String.class));
        argumentMap.put("getOriginalFile", AraraMethods.class.getMethod("getOriginalFile", new Class[0]));
        HashMap<String, Object> ruleMap = new HashMap<String, Object>();
        for (AraraRuleArgument currentArgument : plainRule.getArguments()) {
            if (currentArgument.getDefault() == null) {
                ruleMap.put(currentArgument.getIdentifier(), "");
                continue;
            }
            try {
                String defaultValue = (String)TemplateRuntime.eval(currentArgument.getDefault(), argumentMap);
                ruleMap.put(currentArgument.getIdentifier(), defaultValue);
            }
            catch (RuntimeException runtimeException) {
                throw new AraraException(localization.getMessage("Error_DefaultValueRuntimeErrorRule", currentArgument.getIdentifier(), task.getName(), this.configuration.getPaths().get(pathIndex), AraraUtils.getVariableFromException(runtimeException)));
            }
        }
        ruleMap.put("parameters", directiveMap);
        ruleMap.put("file", argumentMap.get("file"));
        ruleMap.put("item", argumentMap.get("item"));
        ruleMap.put("SystemUtils", SystemUtils.class);
        ruleMap.put("isEmpty", AraraMethods.class.getMethod("isEmpty", String.class));
        ruleMap.put("isNotEmpty", AraraMethods.class.getMethod("isNotEmpty", String.class));
        ruleMap.put("isEmpty", AraraMethods.class.getMethod("isEmpty", String.class, String.class));
        ruleMap.put("isNotEmpty", AraraMethods.class.getMethod("isNotEmpty", String.class, String.class));
        ruleMap.put("isEmpty", AraraMethods.class.getMethod("isEmpty", String.class, String.class, String.class));
        ruleMap.put("isNotEmpty", AraraMethods.class.getMethod("isNotEmpty", String.class, String.class, String.class));
        ruleMap.put("isTrue", AraraMethods.class.getMethod("isTrue", String.class));
        ruleMap.put("isFalse", AraraMethods.class.getMethod("isFalse", String.class));
        ruleMap.put("isTrue", AraraMethods.class.getMethod("isTrue", String.class, String.class));
        ruleMap.put("isFalse", AraraMethods.class.getMethod("isFalse", String.class, String.class));
        ruleMap.put("isTrue", AraraMethods.class.getMethod("isTrue", String.class, String.class, String.class));
        ruleMap.put("isFalse", AraraMethods.class.getMethod("isFalse", String.class, String.class, String.class));
        ruleMap.put("isTrue", AraraMethods.class.getMethod("isTrue", String.class, String.class, String.class, String.class));
        ruleMap.put("isFalse", AraraMethods.class.getMethod("isFalse", String.class, String.class, String.class, String.class));
        ruleMap.put("trimSpaces", AraraMethods.class.getMethod("trimSpaces", String.class));
        ruleMap.put("getFilename", AraraMethods.class.getMethod("getFilename", String.class));
        ruleMap.put("getBasename", AraraMethods.class.getMethod("getBasename", String.class));
        ruleMap.put("getFiletype", AraraMethods.class.getMethod("getFiletype", String.class));
        ruleMap.put("getDirname", AraraMethods.class.getMethod("getDirname", String.class));
        ruleMap.put("isFile", AraraMethods.class.getMethod("isFile", String.class));
        ruleMap.put("isDir", AraraMethods.class.getMethod("isDir", String.class));
        ruleMap.put("isWindows", AraraMethods.class.getMethod("isWindows", String.class, String.class));
        ruleMap.put("isLinux", AraraMethods.class.getMethod("isLinux", String.class, String.class));
        ruleMap.put("isUnix", AraraMethods.class.getMethod("isUnix", String.class, String.class));
        ruleMap.put("isMac", AraraMethods.class.getMethod("isMac", String.class, String.class));
        ruleMap.put("isTrue", AraraMethods.class.getMethod("isTrue", Boolean.TYPE, String.class));
        ruleMap.put("isTrue", AraraMethods.class.getMethod("isTrue", Boolean.TYPE, String.class, String.class));
        ruleMap.put("isFalse", AraraMethods.class.getMethod("isFalse", Boolean.TYPE, String.class));
        ruleMap.put("isFalse", AraraMethods.class.getMethod("isFalse", Boolean.TYPE, String.class, String.class));
        ruleMap.put("getOriginalFile", AraraMethods.class.getMethod("getOriginalFile", new Class[0]));
        availableArgumentsInDirective.remove("file");
        availableArgumentsInDirective.remove("item");
        for (AraraRuleArgument currentArgument : plainRule.getArguments()) {
            if (!this.isArgumentDefinedInDirective(availableArgumentsInDirective, currentArgument) || currentArgument.getFlag() == null) continue;
            try {
                String defaultFlag = (String)TemplateRuntime.eval(currentArgument.getFlag(), ruleMap);
                ruleMap.put(currentArgument.getIdentifier(), defaultFlag);
            }
            catch (RuntimeException runtimeException) {
                throw new AraraException(localization.getMessage("Error_FlagRuntimeErrorRule", currentArgument.getIdentifier(), task.getName(), this.configuration.getPaths().get(pathIndex), AraraUtils.getVariableFromException(runtimeException)));
            }
        }
        ArrayList<String> commandsList = new ArrayList<String>();
        if (plainRule.getCommand() != null) {
            if (plainRule.getCommands() != null) throw new AraraException(localization.getMessage("Error_DuplicatedCommandElementsRule", task.getName(), this.configuration.getPaths().get(pathIndex)));
            commandsList.add(plainRule.getCommand());
        } else {
            if (plainRule.getCommands() == null) {
                throw new AraraException(localization.getMessage("Error_MissingCommandElementsRule", task.getName(), this.configuration.getPaths().get(pathIndex)));
            }
            commandsList.addAll(plainRule.getCommands());
        }
        for (String commandTemplate : commandsList) {
            try {
                commandTemplate = (String)TemplateRuntime.eval(commandTemplate, ruleMap);
            }
            catch (RuntimeException runtimeException) {
                throw new AraraException(localization.getMessage("Error_CommandRuntimeErrorRule", task.getName(), this.configuration.getPaths().get(pathIndex), AraraUtils.getVariableFromException(runtimeException)));
            }
            if ("".equals(commandTemplate.trim())) continue;
            AraraCommand araraCommand = new AraraCommand();
            araraCommand.setCommand(commandTemplate);
            araraCommand.setName(plainRule.getName());
            this.commands.add(araraCommand);
        }
    }

    private boolean isArgumentDefinedInDirective(List<String> arguments, AraraRuleArgument argument) {
        for (String current : arguments) {
            if (!current.equalsIgnoreCase(argument.getIdentifier())) continue;
            return true;
        }
        return false;
    }
}

