/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.rmid;

import gnu.classpath.tools.common.ClasspathToolParser;
import gnu.classpath.tools.getopt.Option;
import gnu.classpath.tools.getopt.OptionException;
import gnu.classpath.tools.getopt.OptionGroup;
import gnu.classpath.tools.getopt.Parser;
import gnu.classpath.tools.rmid.ActivationSystemImpl;
import gnu.classpath.tools.rmid.Messages;
import gnu.java.rmi.activation.ActivationSystemTransient;
import gnu.java.rmi.server.UnicastServerRef;
import java.io.File;
import java.net.InetAddress;
import java.rmi.Remote;
import java.rmi.activation.ActivationSystem;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.ObjID;
import java.rmi.server.RMIServerSocketFactory;

public class Main {
    static RMIServerSocketFactory ACTIVATION_REGISTY_SOCKET_FACTORY = null;
    static int ACTIVATION_REGISTRY_PORT = 1098;
    static String ACTIVATION_SYSTEM_NAME = "java.rmi.activation.ActivationSystem";
    private boolean stop = false;
    private String directory = ".";
    private boolean cold = false;
    private boolean persistent = false;

    private Parser initializeParser() {
        ClasspathToolParser parser = new ClasspathToolParser("rmiregistry", true);
        parser.setHeader(Messages.getString("Main.Usage"));
        OptionGroup controlGroup = new OptionGroup(Messages.getString("Main.ControlGroup"));
        controlGroup.add(new Option("port", Messages.getString("Main.PortOption"), Messages.getString("Main.Port")){

            public void parsed(String portArgument) throws OptionException {
                ACTIVATION_REGISTRY_PORT = Integer.parseInt(portArgument);
            }
        });
        controlGroup.add(new Option("restart", Messages.getString("Main.Restart")){

            public void parsed(String argument) throws OptionException {
                Main.this.cold = true;
            }
        });
        controlGroup.add(new Option("stop", Messages.getString("Main.Stop")){

            public void parsed(String argument) throws OptionException {
                Main.this.stop = true;
            }
        });
        parser.add(controlGroup);
        OptionGroup persistenceGroup = new OptionGroup(Messages.getString("Main.PersistenceGroup"));
        persistenceGroup.add(new Option("persistent", Messages.getString("Main.Persistent")){

            public void parsed(String argument) throws OptionException {
                Main.this.persistent = true;
            }
        });
        persistenceGroup.add(new Option("directory", Messages.getString("Main.Directory"), Messages.getString("Main.DirectoryArgument")){

            public void parsed(String argument) throws OptionException {
                Main.this.directory = argument;
            }
        });
        parser.add(persistenceGroup);
        OptionGroup debuggingGroup = new OptionGroup(Messages.getString("Main.DebugGroup"));
        debuggingGroup.add(new Option("verbose", Messages.getString("Main.Verbose")){

            public void parsed(String argument) throws OptionException {
                ActivationSystemTransient.debug = true;
            }
        });
        parser.add(debuggingGroup);
        return parser;
    }

    private void run(String[] args) {
        block9: {
            Parser p = this.initializeParser();
            p.parse(args);
            try {
                if (!this.stop) {
                    File dataDirectory = new File(this.directory);
                    if (!dataDirectory.exists()) {
                        dataDirectory.mkdirs();
                    }
                    ActivationSystem system = !this.persistent ? ActivationSystemTransient.getInstance() : ActivationSystemImpl.getInstance(dataDirectory, this.cold);
                    UnicastServerRef sref = new UnicastServerRef(new ObjID(1), ACTIVATION_REGISTRY_PORT, ACTIVATION_REGISTY_SOCKET_FACTORY);
                    Remote systemStub = sref.exportObject((Remote)system);
                    try {
                        Registry r = LocateRegistry.getRegistry(ACTIVATION_REGISTRY_PORT);
                        r.rebind(ACTIVATION_SYSTEM_NAME, systemStub);
                    }
                    catch (Exception exception) {
                        Registry r = LocateRegistry.createRegistry(ACTIVATION_REGISTRY_PORT);
                        r.rebind(ACTIVATION_SYSTEM_NAME, systemStub);
                    }
                    String host = InetAddress.getLocalHost().getCanonicalHostName();
                    System.out.println("The RMI daemon is listening on " + host + " (port " + ACTIVATION_REGISTRY_PORT + ")");
                    break block9;
                }
                try {
                    System.out.print("Stopping RMI daemon at " + ACTIVATION_REGISTRY_PORT + " ... ");
                    Registry r = LocateRegistry.getRegistry(ACTIVATION_REGISTRY_PORT);
                    ActivationSystem asys = (ActivationSystem)r.lookup(ACTIVATION_SYSTEM_NAME);
                    asys.shutdown();
                    System.out.println("OK.");
                }
                catch (Exception ex) {
                    System.out.println("The RMI daemon seems not running at " + ACTIVATION_REGISTRY_PORT);
                    if (ActivationSystemTransient.debug) {
                        ex.printStackTrace();
                    }
                }
            }
            catch (Exception e) {
                System.out.println("Failed to start the RMI daemon.");
                if (!ActivationSystemTransient.debug) break block9;
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        Main rmidprogram = new Main();
        try {
            rmidprogram.run(args);
        }
        catch (Exception e) {
            System.err.println(Messages.getString("Main.InternalError"));
            e.printStackTrace(System.err);
            System.exit(1);
        }
    }
}

