/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.gjdoc;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ThrowsTag;
import gnu.classpath.tools.gjdoc.AbstractTagImpl;
import gnu.classpath.tools.gjdoc.ClassDocImpl;
import gnu.classpath.tools.gjdoc.Main;
import gnu.classpath.tools.gjdoc.MemberDocImpl;
import gnu.classpath.tools.gjdoc.Parser;

public class ThrowsTagImpl
extends AbstractTagImpl
implements ThrowsTag {
    private ClassDoc exception;
    private String exceptionName;
    private String exceptionComment;

    public ThrowsTagImpl(String text, ClassDocImpl contextClass, MemberDocImpl contextMember) {
        super(text);
        char[] textarr = text.toCharArray();
        int i = 0;
        while (i < textarr.length) {
            if (!Parser.isWhitespace(textarr[i])) break;
            ++i;
        }
        while (i < textarr.length) {
            if (Parser.isWhitespace(textarr[i])) {
                this.exceptionName = new String(textarr, 0, i).trim();
                this.exceptionComment = new String(textarr, i, textarr.length - i).trim();
                break;
            }
            ++i;
        }
        if (this.exceptionName != null) {
            this.exception = contextClass == null ? Main.getRootDoc().classNamed(this.exceptionName) : contextClass.findClass(this.exceptionName);
            if (this.exception != null) {
                this.exceptionName = this.exception.qualifiedName();
            } else if (text.trim().startsWith("<")) {
                Main.getRootDoc().printWarning("Expected exception name but got '" + text + "' in class " + contextClass.getClassName());
            }
        } else {
            Main.getRootDoc().printWarning("@throws tag in comment for " + contextClass.qualifiedName() + "." + contextMember.name() + " doesn't specify an exception.");
        }
        if (this.exceptionComment != null) {
            this.setBody(this.exceptionComment, contextClass, contextMember);
        }
    }

    public ClassDoc exception() {
        return this.exception;
    }

    public String exceptionName() {
        return this.exceptionName;
    }

    public String exceptionComment() {
        return this.exceptionComment;
    }

    public String kind() {
        return "@throws";
    }
}

