/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio;

import gnu.java.nio.SelectorImpl;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractSelectionKey;
import java.util.Set;

public abstract class SelectionKeyImpl
extends AbstractSelectionKey {
    private int readyOps;
    private int interestOps;
    private final SelectorImpl impl;
    final SelectableChannel ch;

    public SelectionKeyImpl(SelectableChannel ch, SelectorImpl impl) {
        this.ch = ch;
        this.impl = impl;
    }

    public SelectableChannel channel() {
        return this.ch;
    }

    public synchronized int readyOps() {
        if (!this.isValid()) {
            throw new CancelledKeyException();
        }
        return this.readyOps;
    }

    public synchronized SelectionKey readyOps(int ops) {
        if (!this.isValid()) {
            throw new CancelledKeyException();
        }
        this.readyOps = ops;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int interestOps() {
        if (!this.isValid()) {
            throw new CancelledKeyException();
        }
        Set<SelectionKey> set = this.impl.selectedKeys();
        synchronized (set) {
            return this.interestOps;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SelectionKey interestOps(int ops) {
        if (!this.isValid()) {
            throw new CancelledKeyException();
        }
        Set<SelectionKey> set = this.impl.selectedKeys();
        synchronized (set) {
            this.interestOps = ops;
        }
        return this;
    }

    public Selector selector() {
        return this.impl;
    }

    public abstract int getNativeFD();
}

