(function(root, factory) {
//  if(typeof exports === 'object' && typeof module === 'object')
//    module.exports = factory();
//  else if(typeof define === 'function' && define.amd)
//    define("Bokeh", [], factory);
//  else if(typeof exports === 'object')
//    exports["Bokeh"] = factory();
//  else
    root["Bokeh"] = factory();
})(this, function() {
  var define;
  return (function(modules, aliases, entry) {
    var cache = {};

    var require = function(name) {
      var id = aliases[name] != null ? aliases[name] : name;

      if (!cache[id]) {
        if (!modules[id]) {
          var err = new Error("Cannot find module '" + name + "'");
          err.code = 'MODULE_NOT_FOUND';
          throw err;
        }

        var module = cache[id] = {exports: {}};
        modules[id].call(module.exports, require, module, module.exports);
      }

      return cache[id].exports;
    }

    var main = require(entry);
    main.require = require;

    main.register_plugin = function(plugin_modules, plugin_aliases, plugin_entry) {
      for (var name in plugin_modules) {
        modules[name] = plugin_modules[name];
      }

      for (var name in plugin_aliases) {
        aliases[name] = plugin_aliases[name];
      }

      var plugin = require(plugin_entry);

      for (var name in plugin) {
        main[name] = plugin[name];
      }

      return plugin;
    }

    return main;
  })
([
/*base*/
function _(require, module, exports) {
    var models = require(136    /* ./models/index */);
    var object_1 = require(31    /* ./core/util/object */);
    exports.overrides = {};
    var _all_models = object_1.clone(models);
    exports.Models = function (name) {
        var model = exports.overrides[name] || _all_models[name];
        if (model == null) {
            throw new Error('Model \'' + name + '\' does not exist. This could be due to a widget\n                     or a custom model not being registered before first usage.');
        }
        return model;
    };
    exports.Models.register = function (name, model) {
        exports.overrides[name] = model;
    };
    exports.Models.unregister = function (name) {
        delete exports.overrides[name];
    };
    exports.Models.register_models = function (models, force, errorFn) {
        if (force === void 0) {
            force = false;
        }
        if (models == null)
            return;
        for (var name_1 in models) {
            var model = models[name_1];
            if (force || !_all_models.hasOwnProperty(name_1))
                _all_models[name_1] = model;
            else if (errorFn != null)
                errorFn(name_1);
            else
                console.warn('Model \'' + name_1 + '\' was already registered');
        }
    };
    exports.register_models = exports.Models.register_models;
    exports.Models.registered_names = function () {
        return Object.keys(_all_models);
    };
    // "index" is a map from the toplevel model IDs rendered by
    // embed.coffee, to the view objects for those models. It doesn't
    // contain all views, only those explicitly rendered to an element
    // by embed.coffee.
    exports.index = {};    
},
/*client/connection*/
function _(require, module, exports) {
    var es6_promise_1 = require(307    /* es6-promise */);
    var logging_1 = require(14    /* core/logging */);
    var document_1 = require(48    /* document */);
    var message_1 = require(250    /* protocol/message */);
    var receiver_1 = require(251    /* protocol/receiver */);
    var session_1 = require(2    /* ./session */);
    exports.DEFAULT_SERVER_WEBSOCKET_URL = 'ws://localhost:5006/ws';
    exports.DEFAULT_SESSION_ID = 'default';
    var _connection_count = 0;
    var ClientConnection = function () {
        function ClientConnection(url, id, args_string, _on_have_session_hook, _on_closed_permanently_hook) {
            if (url === void 0) {
                url = exports.DEFAULT_SERVER_WEBSOCKET_URL;
            }
            if (id === void 0) {
                id = exports.DEFAULT_SESSION_ID;
            }
            if (args_string === void 0) {
                args_string = null;
            }
            if (_on_have_session_hook === void 0) {
                _on_have_session_hook = null;
            }
            if (_on_closed_permanently_hook === void 0) {
                _on_closed_permanently_hook = null;
            }
            this.url = url;
            this.id = id;
            this.args_string = args_string;
            this._on_have_session_hook = _on_have_session_hook;
            this._on_closed_permanently_hook = _on_closed_permanently_hook;
            this._number = _connection_count++;
            this.socket = null;
            this.session = null;
            this.closed_permanently = false;
            this._current_handler = null;
            this._pending_ack = null;
            // null or [resolve,reject]
            this._pending_replies = {};
            // map reqid to [resolve,reject]
            this._receiver = new receiver_1.Receiver();
            logging_1.logger.debug('Creating websocket ' + this._number + ' to \'' + this.url + '\' session \'' + this.id + '\'');
        }
        ClientConnection.prototype.connect = function () {
            var _this = this;
            if (this.closed_permanently)
                return es6_promise_1.Promise.reject(new Error('Cannot connect() a closed ClientConnection'));
            if (this.socket != null)
                return es6_promise_1.Promise.reject(new Error('Already connected'));
            this._pending_replies = {};
            this._current_handler = null;
            try {
                var versioned_url = this.url + '?bokeh-protocol-version=1.0&bokeh-session-id=' + this.id;
                if (this.args_string != null && this.args_string.length > 0)
                    versioned_url += '&' + this.args_string;
                this.socket = new WebSocket(versioned_url);
                return new es6_promise_1.Promise(function (resolve, reject) {
                    // "arraybuffer" gives us binary data we can look at;
                    // if we just needed an opaque blob we could use "blob"
                    _this.socket.binaryType = 'arraybuffer';
                    _this.socket.onopen = function () {
                        return _this._on_open(resolve, reject);
                    };
                    _this.socket.onmessage = function (event) {
                        return _this._on_message(event);
                    };
                    _this.socket.onclose = function (event) {
                        return _this._on_close(event);
                    };
                    _this.socket.onerror = function () {
                        return _this._on_error(reject);
                    };
                });
            } catch (error) {
                logging_1.logger.error('websocket creation failed to url: ' + this.url);
                logging_1.logger.error(' - ' + error);
                return es6_promise_1.Promise.reject(error);
            }
        };
        ClientConnection.prototype.close = function () {
            if (!this.closed_permanently) {
                logging_1.logger.debug('Permanently closing websocket connection ' + this._number);
                this.closed_permanently = true;
                if (this.socket != null)
                    this.socket.close(1000, 'close method called on ClientConnection ' + this._number);
                this.session._connection_closed();
                if (this._on_closed_permanently_hook != null) {
                    this._on_closed_permanently_hook();
                    this._on_closed_permanently_hook = null;
                }
            }
        };
        ClientConnection.prototype._schedule_reconnect = function (milliseconds) {
            var _this = this;
            var retry = function () {
                // TODO commented code below until we fix reconnection to repull
                // the document when required. Otherwise, we get a lot of
                // confusing errors that are causing trouble when debugging.
                /*
            if (this.closed_permanently) {
            */
                if (!_this.closed_permanently)
                    logging_1.logger.info('Websocket connection ' + _this._number + ' disconnected, will not attempt to reconnect');
                return;    /*
            } else {
              logger.debug(`Attempting to reconnect websocket ${this._number}`)
              this.connect()
            }
            */
            };
            setTimeout(retry, milliseconds);
        };
        ClientConnection.prototype.send = function (message) {
            if (this.socket == null)
                throw new Error('not connected so cannot send ' + message);
            message.send(this.socket);
        };
        ClientConnection.prototype.send_with_reply = function (message) {
            var _this = this;
            var promise = new es6_promise_1.Promise(function (resolve, reject) {
                _this._pending_replies[message.msgid()] = [
                    resolve,
                    reject
                ];
                _this.send(message);
            });
            return promise.then(function (message) {
                if (message.msgtype() === 'ERROR')
                    throw new Error('Error reply ' + message.content['text']);
                else
                    return message;
            }, function (error) {
                throw error;
            });
        };
        ClientConnection.prototype._pull_doc_json = function () {
            var message = message_1.Message.create('PULL-DOC-REQ', {});
            var promise = this.send_with_reply(message);
            return promise.then(function (reply) {
                if (!('doc' in reply.content))
                    throw new Error('No \'doc\' field in PULL-DOC-REPLY');
                return reply.content['doc'];
            }, function (error) {
                throw error;
            });
        };
        ClientConnection.prototype._repull_session_doc = function () {
            var _this = this;
            if (this.session == null)
                logging_1.logger.debug('Pulling session for first time');
            else
                logging_1.logger.debug('Repulling session');
            this._pull_doc_json().then(function (doc_json) {
                if (_this.session == null) {
                    if (_this.closed_permanently)
                        logging_1.logger.debug('Got new document after connection was already closed');
                    else {
                        var document_2 = document_1.Document.from_json(doc_json);
                        // Constructing models changes some of their attributes, we deal with that
                        // here. This happens when models set attributes during construction
                        // or initialization.
                        var patch = document_1.Document._compute_patch_since_json(doc_json, document_2);
                        if (patch.events.length > 0) {
                            logging_1.logger.debug('Sending ' + patch.events.length + ' changes from model construction back to server');
                            var patch_message = message_1.Message.create('PATCH-DOC', {}, patch);
                            _this.send(patch_message);
                        }
                        _this.session = new session_1.ClientSession(_this, document_2, _this.id);
                        logging_1.logger.debug('Created a new session from new pulled doc');
                        if (_this._on_have_session_hook != null) {
                            _this._on_have_session_hook(_this.session);
                            _this._on_have_session_hook = null;
                        }
                    }
                } else {
                    _this.session.document.replace_with_json(doc_json);
                    logging_1.logger.debug('Updated existing session with new pulled doc');
                }
            }, function (error) {
                // handling the error here is useless because we wouldn't
                // get errors from the resolve handler above, so see
                // the catch below instead
                throw error;
            }).catch(function (error) {
                if (console.trace != null)
                    console.trace(error);
                logging_1.logger.error('Failed to repull session ' + error);
            });
        };
        ClientConnection.prototype._on_open = function (resolve, reject) {
            var _this = this;
            logging_1.logger.info('Websocket connection ' + this._number + ' is now open');
            this._pending_ack = [
                resolve,
                reject
            ];
            this._current_handler = function (message) {
                _this._awaiting_ack_handler(message);
            };
        };
        ClientConnection.prototype._on_message = function (event) {
            if (this._current_handler == null)
                logging_1.logger.error('Got a message with no current handler set');
            try {
                this._receiver.consume(event.data);
            } catch (e) {
                this._close_bad_protocol(e.toString());
            }
            if (this._receiver.message == null)
                return;
            var msg = this._receiver.message;
            var problem = msg.problem();
            if (problem != null)
                this._close_bad_protocol(problem);
            this._current_handler(msg);
        };
        ClientConnection.prototype._on_close = function (event) {
            var _this = this;
            logging_1.logger.info('Lost websocket ' + this._number + ' connection, ' + event.code + ' (' + event.reason + ')');
            this.socket = null;
            if (this._pending_ack != null) {
                this._pending_ack[1](new Error('Lost websocket connection, ' + event.code + ' (' + event.reason + ')'));
                this._pending_ack = null;
            }
            var pop_pending = function () {
                for (var reqid in _this._pending_replies) {
                    var promise_funcs_1 = _this._pending_replies[reqid];
                    delete _this._pending_replies[reqid];
                    return promise_funcs_1;
                }
                return null;
            };
            var promise_funcs = pop_pending();
            while (promise_funcs != null) {
                promise_funcs[1]('Disconnected');
                promise_funcs = pop_pending();
            }
            if (!this.closed_permanently)
                this._schedule_reconnect(2000);
        };
        ClientConnection.prototype._on_error = function (reject) {
            logging_1.logger.debug('Websocket error on socket ' + this._number);
            reject(new Error('Could not open websocket'));
        };
        ClientConnection.prototype._close_bad_protocol = function (detail) {
            logging_1.logger.error('Closing connection: ' + detail);
            if (this.socket != null)
                this.socket.close(1002, detail);    // 1002 = protocol error
        };
        ClientConnection.prototype._awaiting_ack_handler = function (message) {
            var _this = this;
            if (message.msgtype() === 'ACK') {
                this._current_handler = function (message) {
                    return _this._steady_state_handler(message);
                };
                // Reload any sessions
                // TODO (havocp) there's a race where we might get a PATCH before
                // we send and get a reply to our pulls.
                this._repull_session_doc();
                if (this._pending_ack != null) {
                    this._pending_ack[0](this);
                    this._pending_ack = null;
                }
            } else
                this._close_bad_protocol('First message was not an ACK');
        };
        ClientConnection.prototype._steady_state_handler = function (message) {
            if (message.reqid() in this._pending_replies) {
                var promise_funcs = this._pending_replies[message.reqid()];
                delete this._pending_replies[message.reqid()];
                promise_funcs[0](message);
            } else
                this.session.handle(message);
        };
        return ClientConnection;
    }();
    exports.ClientConnection = ClientConnection;
    // Returns a promise of a ClientSession
    // The returned promise has a close() method in case you want to close before
    // getting a session; session.close() works too once you have a session.
    function pull_session(url, session_id, args_string) {
        var connection;
        var promise = new es6_promise_1.Promise(function (resolve, reject) {
            connection = new ClientConnection(url, session_id, args_string, function (session) {
                try {
                    resolve(session);
                } catch (error) {
                    logging_1.logger.error('Promise handler threw an error, closing session ' + error);
                    session.close();
                    throw error;
                }
            }, function () {
                // we rely on reject() as a no-op if we already resolved
                reject(new Error('Connection was closed before we successfully pulled a session'));
            });
            return connection.connect().then(function (_) {
                return undefined;
            }, function (error) {
                logging_1.logger.error('Failed to connect to Bokeh server ' + error);
                throw error;
            });
        });
        /*
    // add a "close" method to the promise... too weird?
    promise.close = () => {
      connection.close()
    }
    */
        return promise;
    }
    exports.pull_session = pull_session;    
},
/*client/session*/
function _(require, module, exports) {
    var logging_1 = require(14    /* core/logging */);
    var document_1 = require(48    /* document */);
    var message_1 = require(250    /* protocol/message */);
    var ClientSession = function () {
        function ClientSession(_connection, document, id) {
            var _this = this;
            this._connection = _connection;
            this.document = document;
            /*Document*/
            this.id = id;
            this._document_listener = function (event) {
                return _this._document_changed(event);
            };
            this.document.on_change(this._document_listener);
            this.event_manager = this.document.event_manager;
            this.event_manager.session = this;
        }
        ClientSession.prototype.handle = function (message) {
            var msgtype = message.msgtype();
            if (msgtype === 'PATCH-DOC')
                this._handle_patch(message);
            else if (msgtype === 'OK')
                this._handle_ok(message);
            else if (msgtype === 'ERROR')
                this._handle_error(message);
            else
                logging_1.logger.debug('Doing nothing with message ' + message.msgtype());
        };
        ClientSession.prototype.close = function () {
            this._connection.close();
        };
        ClientSession.prototype.send_event = function (event) {
            var message = message_1.Message.create('EVENT', {}, JSON.stringify(event));
            this._connection.send(message);
        };
        /*protected*/
        ClientSession.prototype._connection_closed = function () {
            this.document.remove_on_change(this._document_listener);
        };
        // Sends a request to the server for info about the server, such as its Bokeh
        // version. Returns a promise, the value of the promise is a free-form dictionary
        // of server details.
        ClientSession.prototype.request_server_info = function () {
            var message = message_1.Message.create('SERVER-INFO-REQ', {});
            var promise = this._connection.send_with_reply(message);
            return promise.then(function (reply) {
                return reply.content;
            });
        };
        // Sends some request to the server (no guarantee about which one) and returns
        // a promise which is completed when the server replies. The purpose of this
        // is that if you wait for the promise to be completed, you know the server
        // has processed the request. This is useful when writing tests because once
        // the server has processed this request it should also have processed any
        // events or requests you sent previously, which means you can check for the
        // results of that processing without a race condition. (This assumes the
        // server processes events in sequence, which it mostly has to semantically,
        // since reordering events might change the final state.)
        ClientSession.prototype.force_roundtrip = function () {
            return this.request_server_info().then(function (_) {
                return undefined;
            });
        };
        ClientSession.prototype._document_changed = function (event) {
            // Filter out events that were initiated by the ClientSession itself
            if (event.setter_id === this.id)
                return;
            // Filter out changes to attributes that aren't server-visible
            if (event instanceof document_1.ModelChangedEvent && !(event.attr in event.model.serializable_attributes()))
                return;
            // TODO (havocp) the connection may be closed here, which will
            // cause this send to throw an error - need to deal with it more cleanly.
            var message = message_1.Message.create('PATCH-DOC', {}, this.document.create_json_patch([event]));
            this._connection.send(message);
        };
        ClientSession.prototype._handle_patch = function (message) {
            this.document.apply_json_patch(message.content, message.buffers, this.id);
        };
        ClientSession.prototype._handle_ok = function (message) {
            logging_1.logger.trace('Unhandled OK reply to ' + message.reqid());
        };
        ClientSession.prototype._handle_error = function (message) {
            logging_1.logger.error('Unhandled ERROR reply to ' + message.reqid() + ': ' + message.content['text']);
        };
        return ClientSession;
    }();
    exports.ClientSession = ClientSession;    
},
/*core/bokeh_events*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    var logging_1 = require(14    /* ./logging */);
    var object_1 = require(31    /* ./util/object */);
    var event_classes = {};
    function register_event_class(event_name) {
        return function (event_cls) {
            event_cls.prototype.event_name = event_name;
            event_classes[event_name] = event_cls;
        };
    }
    exports.register_event_class = register_event_class;
    function register_with_event(event_cls) {
        var models = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            models[_i - 1] = arguments[_i];
        }
        var applicable_models = event_cls.prototype.applicable_models.concat(models);
        event_cls.prototype.applicable_models = applicable_models;
    }
    exports.register_with_event = register_with_event;
    var BokehEvent = function () {
        function BokehEvent(options) {
            if (options === void 0) {
                options = {};
            }
            this.model_id = null;
            this._options = options;
            if (options.model_id) {
                this.model_id = options.model_id;
            }
        }
        BokehEvent.prototype.set_model_id = function (id) {
            this._options.model_id = id;
            this.model_id = id;
            return this;
        };
        BokehEvent.prototype.is_applicable_to = function (obj) {
            return this.applicable_models.some(function (model) {
                return obj instanceof model;
            });
        };
        BokehEvent.event_class = function (e) {
            // Given an event with a type attribute matching the event_name,
            // return the appropriate BokehEvent class
            if (e.type) {
                return event_classes[e.type];
            } else {
                logging_1.logger.warn('BokehEvent.event_class required events with a string type attribute');
            }
        };
        BokehEvent.prototype.toJSON = function () {
            return {
                event_name: this.event_name,
                event_values: object_1.clone(this._options)
            };
        };
        BokehEvent.prototype._customize_event = function (_model) {
            return this;
        };
        return BokehEvent;
    }();
    exports.BokehEvent = BokehEvent;
    BokehEvent.prototype.applicable_models = [];
    var ButtonClick = function (_super) {
        tslib_1.__extends(ButtonClick, _super);
        function ButtonClick() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        ButtonClick = tslib_1.__decorate([register_event_class('button_click')], ButtonClick);
        return ButtonClick;
    }(BokehEvent);
    exports.ButtonClick = ButtonClick;
    // A UIEvent is an event originating on a PlotCanvas this includes
    // DOM events such as keystrokes as well as hammer events and LOD events.
    var UIEvent = function (_super) {
        tslib_1.__extends(UIEvent, _super);
        function UIEvent() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return UIEvent;
    }(BokehEvent);
    exports.UIEvent = UIEvent;
    var LODStart = function (_super) {
        tslib_1.__extends(LODStart, _super);
        function LODStart() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        LODStart = tslib_1.__decorate([register_event_class('lodstart')], LODStart);
        return LODStart;
    }(UIEvent);
    exports.LODStart = LODStart;
    var LODEnd = function (_super) {
        tslib_1.__extends(LODEnd, _super);
        function LODEnd() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        LODEnd = tslib_1.__decorate([register_event_class('lodend')], LODEnd);
        return LODEnd;
    }(UIEvent);
    exports.LODEnd = LODEnd;
    var SelectionGeometry = function (_super) {
        tslib_1.__extends(SelectionGeometry, _super);
        function SelectionGeometry(options) {
            var _this = _super.call(this, options) || this;
            _this.geometry = options.geometry;
            _this.final = options.final;
            return _this;
        }
        SelectionGeometry = tslib_1.__decorate([register_event_class('selectiongeometry')], SelectionGeometry);
        return SelectionGeometry;
    }(UIEvent);
    exports.SelectionGeometry = SelectionGeometry;
    var Reset = function (_super) {
        tslib_1.__extends(Reset, _super);
        function Reset() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Reset = tslib_1.__decorate([register_event_class('reset')], Reset);
        return Reset;
    }(UIEvent);
    exports.Reset = Reset;
    var PointEvent = function (_super) {
        tslib_1.__extends(PointEvent, _super);
        function PointEvent(options) {
            var _this = _super.call(this, options) || this;
            _this.sx = options.sx;
            _this.sy = options.sy;
            _this.x = null;
            _this.y = null;
            return _this;
        }
        PointEvent.from_event = function (e, model_id) {
            if (model_id === void 0) {
                model_id = null;
            }
            return new this({
                sx: e.bokeh['sx'],
                sy: e.bokeh['sy'],
                model_id: model_id
            });
        };
        PointEvent.prototype._customize_event = function (plot) {
            var xscale = plot.plot_canvas.frame.xscales['default'];
            var yscale = plot.plot_canvas.frame.yscales['default'];
            this.x = xscale.invert(this.sx);
            this.y = yscale.invert(this.sy);
            this._options['x'] = this.x;
            this._options['y'] = this.y;
            return this;
        };
        return PointEvent;
    }(UIEvent);
    exports.PointEvent = PointEvent;
    var Pan = function (_super) {
        tslib_1.__extends(Pan, _super);
        function Pan(options) {
            if (options === void 0) {
                options = {};
            }
            var _this = _super.call(this, options) || this;
            _this.delta_x = options.delta_x;
            _this.delta_y = options.delta_y;
            return _this;
        }
        Pan.from_event = function (e, model_id) {
            if (model_id === void 0) {
                model_id = null;
            }
            return new this({
                sx: e.bokeh['sx'],
                sy: e.bokeh['sy'],
                delta_x: e.deltaX,
                delta_y: e.deltaY,
                direction: e.direction,
                model_id: model_id
            });
        };
        Pan = tslib_1.__decorate([register_event_class('pan')], Pan);
        return Pan;
    }(PointEvent);
    exports.Pan = Pan;
    var Pinch = function (_super) {
        tslib_1.__extends(Pinch, _super);
        function Pinch(options) {
            if (options === void 0) {
                options = {};
            }
            var _this = _super.call(this, options) || this;
            _this.scale = options.scale;
            return _this;
        }
        Pinch.from_event = function (e, model_id) {
            if (model_id === void 0) {
                model_id = null;
            }
            return new this({
                sx: e.bokeh['sx'],
                sy: e.bokeh['sy'],
                scale: e.scale,
                model_id: model_id
            });
        };
        Pinch = tslib_1.__decorate([register_event_class('pinch')], Pinch);
        return Pinch;
    }(PointEvent);
    exports.Pinch = Pinch;
    var MouseWheel = function (_super) {
        tslib_1.__extends(MouseWheel, _super);
        function MouseWheel(options) {
            if (options === void 0) {
                options = {};
            }
            var _this = _super.call(this, options) || this;
            _this.delta = options.delta;
            return _this;
        }
        MouseWheel.from_event = function (e, model_id) {
            if (model_id === void 0) {
                model_id = null;
            }
            return new this({
                sx: e.bokeh['sx'],
                sy: e.bokeh['sy'],
                delta: e.bokeh['delta'],
                model_id: model_id
            });
        };
        MouseWheel = tslib_1.__decorate([register_event_class('wheel')], MouseWheel);
        return MouseWheel;
    }(PointEvent);
    exports.MouseWheel = MouseWheel;
    var MouseMove = function (_super) {
        tslib_1.__extends(MouseMove, _super);
        function MouseMove() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        MouseMove = tslib_1.__decorate([register_event_class('mousemove')], MouseMove);
        return MouseMove;
    }(PointEvent);
    exports.MouseMove = MouseMove;
    var MouseEnter = function (_super) {
        tslib_1.__extends(MouseEnter, _super);
        function MouseEnter() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        MouseEnter = tslib_1.__decorate([register_event_class('mouseenter')], MouseEnter);
        return MouseEnter;
    }(PointEvent);
    exports.MouseEnter = MouseEnter;
    var MouseLeave = function (_super) {
        tslib_1.__extends(MouseLeave, _super);
        function MouseLeave() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        MouseLeave = tslib_1.__decorate([register_event_class('mouseleave')], MouseLeave);
        return MouseLeave;
    }(PointEvent);
    exports.MouseLeave = MouseLeave;
    var Tap = function (_super) {
        tslib_1.__extends(Tap, _super);
        function Tap() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Tap = tslib_1.__decorate([register_event_class('tap')], Tap);
        return Tap;
    }(PointEvent);
    exports.Tap = Tap;
    var DoubleTap = function (_super) {
        tslib_1.__extends(DoubleTap, _super);
        function DoubleTap() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        DoubleTap = tslib_1.__decorate([register_event_class('doubletap')], DoubleTap);
        return DoubleTap;
    }(PointEvent);
    exports.DoubleTap = DoubleTap;
    var Press = function (_super) {
        tslib_1.__extends(Press, _super);
        function Press() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Press = tslib_1.__decorate([register_event_class('press')], Press);
        return Press;
    }(PointEvent);
    exports.Press = Press;
    var PanStart = function (_super) {
        tslib_1.__extends(PanStart, _super);
        function PanStart() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        PanStart = tslib_1.__decorate([register_event_class('panstart')], PanStart);
        return PanStart;
    }(PointEvent);
    exports.PanStart = PanStart;
    var PanEnd = function (_super) {
        tslib_1.__extends(PanEnd, _super);
        function PanEnd() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        PanEnd = tslib_1.__decorate([register_event_class('panend')], PanEnd);
        return PanEnd;
    }(PointEvent);
    exports.PanEnd = PanEnd;
    var PinchStart = function (_super) {
        tslib_1.__extends(PinchStart, _super);
        function PinchStart() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        PinchStart = tslib_1.__decorate([register_event_class('pinchstart')], PinchStart);
        return PinchStart;
    }(PointEvent);
    exports.PinchStart = PinchStart;
    var PinchEnd = function (_super) {
        tslib_1.__extends(PinchEnd, _super);
        function PinchEnd() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        PinchEnd = tslib_1.__decorate([register_event_class('pinchend')], PinchEnd);
        return PinchEnd;
    }(PointEvent);
    exports.PinchEnd = PinchEnd;    
},
/*core/build_views*/
function _(require, module, exports) {
    var array_1 = require(22    /* ./util/array */);
    var object_1 = require(31    /* ./util/object */);
    function build_views(view_storage, models, options, cls) {
        if (cls === void 0) {
            cls = function (model) {
                return model.default_view;
            };
        }
        var to_remove = array_1.difference(Object.keys(view_storage), models.map(function (model) {
            return model.id;
        }));
        for (var _i = 0, to_remove_1 = to_remove; _i < to_remove_1.length; _i++) {
            var model_id = to_remove_1[_i];
            view_storage[model_id].remove();
            delete view_storage[model_id];
        }
        var created_views = [];
        var new_models = models.filter(function (model) {
            return view_storage[model.id] == null;
        });
        for (var _a = 0, new_models_1 = new_models; _a < new_models_1.length; _a++) {
            var model = new_models_1[_a];
            var view_cls = cls(model);
            var view_options = object_1.extend({}, options, {
                model: model,
                connect_signals: false
            });
            var view = new view_cls(view_options);
            view_storage[model.id] = view;
            created_views.push(view);
        }
        for (var _b = 0, created_views_1 = created_views; _b < created_views_1.length; _b++) {
            var view = created_views_1[_b];
            view.connect_signals();
        }
        return created_views;
    }
    exports.build_views = build_views;
    function remove_views(view_storage) {
        for (var id in view_storage) {
            view_storage[id].remove();
            delete view_storage[id];
        }
    }
    exports.remove_views = remove_views;    
},
/*core/dom*/
function _(require, module, exports) {
    var types_1 = require(43    /* ./util/types */);
    var _createElement = function (tag) {
        return function (attrs) {
            if (attrs === void 0) {
                attrs = {};
            }
            var children = [];
            for (var _i = 1; _i < arguments.length; _i++) {
                children[_i - 1] = arguments[_i];
            }
            var element = document.createElement(tag);
            for (var attr in attrs) {
                var value = attrs[attr];
                if (value == null || types_1.isBoolean(value) && !value)
                    continue;
                if (attr === 'class' && types_1.isArray(value)) {
                    for (var _a = 0, _b = value; _a < _b.length; _a++) {
                        var cls = _b[_a];
                        if (cls != null)
                            element.classList.add(cls);
                    }
                    continue;
                }
                if (attr === 'style' && types_1.isObject(value)) {
                    for (var prop in value) {
                        element.style[prop] = value[prop];
                    }
                    continue;
                }
                if (attr === 'data' && types_1.isObject(value)) {
                    for (var key in value) {
                        element.dataset[key] = value[key];
                    }
                    continue;
                }
                element.setAttribute(attr, value);
            }
            function append(child) {
                if (child instanceof HTMLElement)
                    element.appendChild(child);
                else if (types_1.isString(child))
                    element.appendChild(document.createTextNode(child));
                else if (child != null && child !== false)
                    throw new Error('expected an HTMLElement, string, false or null, got ' + JSON.stringify(child));
            }
            for (var _c = 0, children_1 = children; _c < children_1.length; _c++) {
                var child = children_1[_c];
                if (types_1.isArray(child)) {
                    for (var _d = 0, child_1 = child; _d < child_1.length; _d++) {
                        var _child = child_1[_d];
                        append(_child);
                    }
                } else
                    append(child);
            }
            return element;
        };
    };
    function createElement(tag, attrs) {
        var children = [];
        for (var _i = 2; _i < arguments.length; _i++) {
            children[_i - 2] = arguments[_i];
        }
        return _createElement(tag).apply(void 0, [attrs].concat(children));
    }
    exports.createElement = createElement;
    exports.div = _createElement('div'), exports.span = _createElement('span'), exports.link = _createElement('link'), exports.style = _createElement('style'), exports.a = _createElement('a'), exports.p = _createElement('p'), exports.i = _createElement('i'), exports.pre = _createElement('pre'), exports.button = _createElement('button'), exports.label = _createElement('label'), exports.input = _createElement('input'), exports.select = _createElement('select'), exports.option = _createElement('option'), exports.optgroup = _createElement('optgroup'), exports.textarea = _createElement('textarea'), exports.canvas = _createElement('canvas'), exports.ul = _createElement('ul'), exports.ol = _createElement('ol'), exports.li = _createElement('li');
    exports.nbsp = document.createTextNode('\xA0');
    function removeElement(element) {
        var parent = element.parentNode;
        if (parent != null) {
            parent.removeChild(element);
        }
    }
    exports.removeElement = removeElement;
    function replaceWith(element, replacement) {
        var parent = element.parentNode;
        if (parent != null) {
            parent.replaceChild(replacement, element);
        }
    }
    exports.replaceWith = replaceWith;
    function prepend(element) {
        var nodes = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            nodes[_i - 1] = arguments[_i];
        }
        var first = element.firstChild;
        for (var _a = 0, nodes_1 = nodes; _a < nodes_1.length; _a++) {
            var node = nodes_1[_a];
            element.insertBefore(node, first);
        }
    }
    exports.prepend = prepend;
    function empty(element) {
        var child;
        while (child = element.firstChild) {
            element.removeChild(child);
        }
    }
    exports.empty = empty;
    function show(element) {
        element.style.display = '';
    }
    exports.show = show;
    function hide(element) {
        element.style.display = 'none';
    }
    exports.hide = hide;
    function position(element) {
        return {
            top: element.offsetTop,
            left: element.offsetLeft
        };
    }
    exports.position = position;
    function offset(element) {
        var rect = element.getBoundingClientRect();
        return {
            top: rect.top + window.pageYOffset - document.documentElement.clientTop,
            left: rect.left + window.pageXOffset - document.documentElement.clientLeft
        };
    }
    exports.offset = offset;
    function matches(el, selector) {
        var p = Element.prototype;
        var f = p.matches || p.webkitMatchesSelector || p.mozMatchesSelector || p.msMatchesSelector;
        return f.call(el, selector);
    }
    exports.matches = matches;
    function parent(el, selector) {
        var node = el;
        while (node = node.parentElement) {
            if (matches(node, selector))
                return node;
        }
        return null;
    }
    exports.parent = parent;
    function margin(el) {
        var style = getComputedStyle(el);
        return {
            top: parseFloat(style.marginTop) || 0,
            bottom: parseFloat(style.marginBottom) || 0,
            left: parseFloat(style.marginLeft) || 0,
            right: parseFloat(style.marginRight) || 0
        };
    }
    exports.margin = margin;
    var Keys;
    (function (Keys) {
        Keys[Keys['Backspace'] = 8] = 'Backspace';
        Keys[Keys['Tab'] = 9] = 'Tab';
        Keys[Keys['Enter'] = 13] = 'Enter';
        Keys[Keys['Esc'] = 27] = 'Esc';
        Keys[Keys['PageUp'] = 33] = 'PageUp';
        Keys[Keys['PageDown'] = 34] = 'PageDown';
        Keys[Keys['Up'] = 38] = 'Up';
        Keys[Keys['Down'] = 40] = 'Down';
        Keys[Keys['Delete'] = 46] = 'Delete';
    }(Keys = exports.Keys || (exports.Keys = {})));    
},
/*core/dom_view*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    var view_1 = require(46    /* ./view */);
    var DOM = require(5    /* ./dom */);
    var DOMView = function (_super) {
        tslib_1.__extends(DOMView, _super);
        function DOMView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        DOMView.prototype.initialize = function (options) {
            _super.prototype.initialize.call(this, options);
            this._has_finished = false;
            this.el = this._createElement();
        };
        DOMView.prototype.remove = function () {
            DOM.removeElement(this.el);
            _super.prototype.remove.call(this);
        };
        DOMView.prototype.css_classes = function () {
            return [];
        };
        DOMView.prototype.layout = function () {
        };
        DOMView.prototype.render = function () {
        };
        DOMView.prototype.renderTo = function (element, replace) {
            if (replace === void 0) {
                replace = false;
            }
            if (!replace)
                element.appendChild(this.el);
            else
                DOM.replaceWith(element, this.el);
            this.layout();
        };
        DOMView.prototype.has_finished = function () {
            return this._has_finished;
        };
        Object.defineProperty(DOMView.prototype, '_root_element', {
            get: function () {
                return DOM.parent(this.el, '.bk-root') || document.body;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(DOMView.prototype, 'solver', {
            get: function () {
                return this.is_root ? this._solver : this.parent.solver;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(DOMView.prototype, 'is_idle', {
            get: function () {
                return this.has_finished();
            },
            enumerable: true,
            configurable: true
        });
        DOMView.prototype._createElement = function () {
            return DOM.createElement(this.tagName, {
                id: this.id,
                class: this.css_classes()
            });
        };
        return DOMView;
    }(view_1.View);
    exports.DOMView = DOMView;
    DOMView.prototype.tagName = 'div';    
},
/*core/enums*/
function _(require, module, exports) {
    exports.AngleUnits = [
        'deg',
        'rad'
    ];
    exports.Dimension = [
        'width',
        'height'
    ];
    exports.Dimensions = [
        'width',
        'height',
        'both'
    ];
    exports.Direction = [
        'clock',
        'anticlock'
    ];
    exports.FontStyle = [
        'normal',
        'italic',
        'bold'
    ];
    exports.LatLon = [
        'lat',
        'lon'
    ];
    exports.LineCap = [
        'butt',
        'round',
        'square'
    ];
    exports.LineJoin = [
        'miter',
        'round',
        'bevel'
    ];
    exports.Location = [
        'above',
        'below',
        'left',
        'right'
    ];
    exports.LegendClickPolicy = [
        'none',
        'hide',
        'mute'
    ];
    exports.LegendLocation = [
        'top_left',
        'top_center',
        'top_right',
        'center_left',
        'center',
        'center_right',
        'bottom_left',
        'bottom_center',
        'bottom_right'
    ];
    exports.Anchor = exports.LegendLocation;
    exports.Orientation = [
        'vertical',
        'horizontal'
    ];
    exports.OutputBackend = [
        'canvas',
        'svg',
        'webgl'
    ];
    exports.RenderLevel = [
        'image',
        'underlay',
        'glyph',
        'annotation',
        'overlay'
    ];
    exports.RenderMode = [
        'canvas',
        'css'
    ];
    exports.Side = [
        'above',
        'below',
        'left',
        'right'
    ];
    exports.Place = [
        'above',
        'below',
        'left',
        'right',
        'center'
    ];
    exports.SpatialUnits = [
        'screen',
        'data'
    ];
    exports.StartEnd = [
        'start',
        'end'
    ];
    exports.VerticalAlign = [
        'top',
        'middle',
        'bottom'
    ];
    exports.TextAlign = [
        'left',
        'right',
        'center'
    ];
    exports.TextBaseline = [
        'top',
        'middle',
        'bottom',
        'alphabetic',
        'hanging',
        'ideographic'
    ];
    exports.TooltipAttachment = [
        'horizontal',
        'vertical',
        'left',
        'right',
        'above',
        'below'
    ];
    exports.Distribution = [
        'uniform',
        'normal'
    ];
    exports.StepMode = [
        'after',
        'before',
        'center'
    ];
    exports.SizingMode = [
        'stretch_both',
        'scale_width',
        'scale_height',
        'scale_both',
        'fixed'
    ];
    exports.PaddingUnits = [
        'percent',
        'absolute'
    ];
    exports.SliderCallbackPolicy = [
        'continuous',
        'throttle',
        'mouseup'
    ];
    exports.RoundingFunction = [
        'round',
        'nearest',
        'floor',
        'rounddown',
        'ceil',
        'roundup'
    ];
    exports.UpdateMode = [
        'replace',
        'append'
    ];
    exports.HTTPMethod = [
        'POST',
        'GET'
    ];
    exports.Logo = [
        'normal',
        'grey'
    ];    
},
/*core/has_props*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    var signaling_1 = require(20    /* ./signaling */);
    var property_mixins = require(16    /* ./property_mixins */);
    var refs_1 = require(34    /* ./util/refs */);
    var p = require(15    /* ./properties */);
    var string_1 = require(38    /* ./util/string */);
    var array_1 = require(22    /* ./util/array */);
    var object_1 = require(31    /* ./util/object */);
    var types_1 = require(43    /* ./util/types */);
    var eq_1 = require(29    /* ./util/eq */);
    var HasProps = function (_super) {
        tslib_1.__extends(HasProps, _super);
        function HasProps(attrs, opts) {
            if (attrs === void 0) {
                attrs = {};
            }
            if (opts === void 0) {
                opts = {};
            }
            var _this = _super.call(this) || this;
            _this._subtype = undefined;
            _this.document = null;
            _this.destroyed = new signaling_1.Signal(_this, 'destroyed');
            _this.change = new signaling_1.Signal(_this, 'change');
            _this.transformchange = new signaling_1.Signal(_this, 'transformchange');
            _this.attributes = {};
            _this.properties = {};
            _this._set_after_defaults = {};
            _this._pending = false;
            _this._changing = false;
            for (var name_1 in _this.props) {
                var _a = _this.props[name_1], type = _a.type, default_value = _a.default_value;
                if (type != null)
                    _this.properties[name_1] = new type(_this, name_1, default_value);
                else
                    throw new Error('undefined property type for ' + _this.type + '.' + name_1);
            }
            // auto generating ID
            if (attrs.id == null)
                _this.setv({ id: string_1.uniqueId() }, { silent: true });
            _this.setv(attrs, { silent: true });
            // allowing us to defer initialization when loading many models
            // when loading a bunch of models, we want to do initialization as a second pass
            // because other objects that this one depends on might not be loaded yet
            if (!opts.defer_initialization)
                _this.finalize();
            return _this;
        }
        HasProps.initClass = function () {
            this.prototype.type = 'HasProps';
            this.prototype.props = {};
            this.prototype.mixins = [];
            this.define({ id: [p.Any] });
        };
        // }}}
        HasProps._fix_default = function (default_value, _attr) {
            if (default_value === undefined)
                return undefined;
            else if (types_1.isFunction(default_value))
                return default_value;
            else if (!types_1.isObject(default_value))
                return function () {
                    return default_value;
                };
            else {
                //logger.warn(`${this.prototype.type}.${attr} uses unwrapped non-primitive default value`)
                if (types_1.isArray(default_value))
                    return function () {
                        return array_1.copy(default_value);
                    };
                else
                    return function () {
                        return object_1.clone(default_value);
                    };
            }
        };
        HasProps.define = function (obj) {
            var _loop_1 = function (name_2) {
                var prop = obj[name_2];
                if (this_1.prototype.props[name_2] != null)
                    throw new Error('attempted to redefine property \'' + this_1.prototype.type + '.' + name_2 + '\'');
                if (this_1.prototype[name_2] != null)
                    throw new Error('attempted to redefine attribute \'' + this_1.prototype.type + '.' + name_2 + '\'');
                Object.defineProperty(this_1.prototype, name_2, {
                    // XXX: don't use tail calls in getters/setters due to https://bugs.webkit.org/show_bug.cgi?id=164306
                    get: function () {
                        var value = this.getv(name_2);
                        return value;
                    },
                    set: function (value) {
                        this.setv((_a = {}, _a[name_2] = value, _a));
                        return this;
                        var _a;
                    },
                    configurable: false,
                    enumerable: true
                });
                var type = prop[0], default_value = prop[1], internal = prop[2];
                var refined_prop = {
                    type: type,
                    default_value: this_1._fix_default(default_value, name_2),
                    internal: internal || false
                };
                var props = object_1.clone(this_1.prototype.props);
                props[name_2] = refined_prop;
                this_1.prototype.props = props;
            };
            var this_1 = this;
            for (var name_2 in obj) {
                _loop_1(name_2);
            }
        };
        HasProps.internal = function (obj) {
            var _object = {};
            for (var name_3 in obj) {
                var prop = obj[name_3];
                var type = prop[0], default_value = prop[1];
                _object[name_3] = [
                    type,
                    default_value,
                    true
                ];
            }
            this.define(_object);
        };
        HasProps.mixin = function () {
            var names = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                names[_i] = arguments[_i];
            }
            this.define(property_mixins.create(names));
            var mixins = this.prototype.mixins.concat(names);
            this.prototype.mixins = mixins;
        };
        HasProps.mixins = function (names) {
            this.mixin.apply(this, names);
        };
        HasProps.override = function (obj) {
            for (var name_4 in obj) {
                var default_value = this._fix_default(obj[name_4], name_4);
                var value = this.prototype.props[name_4];
                if (value == null)
                    throw new Error('attempted to override nonexistent \'' + this.prototype.type + '.' + name_4 + '\'');
                var props = object_1.clone(this.prototype.props);
                props[name_4] = object_1.extend({}, value, { default_value: default_value });
                this.prototype.props = props;
            }
        };
        HasProps.prototype.toString = function () {
            return this.type + '(' + this.id + ')';
        };
        HasProps.prototype.finalize = function () {
            var _this = this;
            // This is necessary because the initial creation of properties relies on
            // model.get which is not usable at that point yet in the constructor. This
            // initializer is called when deferred initialization happens for all models
            // and insures that the Bokeh properties are initialized from Backbone
            // attributes in a consistent way.
            //
            // TODO (bev) split property creation up into two parts so that only the
            // portion of init that can be done happens in HasProps constructor and so
            // that subsequent updates do not duplicate that setup work.
            for (var name_5 in this.properties) {
                var prop = this.properties[name_5];
                prop.update();
                if (prop.spec.transform != null)
                    this.connect(prop.spec.transform.change, function () {
                        return _this.transformchange.emit(undefined);
                    });
            }
            this.initialize();
            this.connect_signals();
        };
        HasProps.prototype.initialize = function () {
        };
        HasProps.prototype.connect_signals = function () {
        };
        HasProps.prototype.disconnect_signals = function () {
            signaling_1.Signal.disconnectReceiver(this);
        };
        HasProps.prototype.destroy = function () {
            this.disconnect_signals();
            this.destroyed.emit(undefined);
        };
        // Create a new model with identical attributes to this one.
        HasProps.prototype.clone = function () {
            return new this.constructor(this.attributes);
        };
        // Set a hash of model attributes on the object, firing `"change"`. This is
        // the core primitive operation of a model, updating the data and notifying
        // anyone who needs to know about the change in state. The heart of the beast.
        HasProps.prototype._setv = function (attrs, options) {
            // Extract attributes and options.
            var check_eq = options.check_eq;
            var silent = options.silent;
            var changes = [];
            var changing = this._changing;
            this._changing = true;
            var current = this.attributes;
            // For each `set` attribute, update or delete the current value.
            for (var attr in attrs) {
                var val = attrs[attr];
                if (check_eq !== false) {
                    if (!eq_1.isEqual(current[attr], val))
                        changes.push(attr);
                } else
                    changes.push(attr);
                current[attr] = val;
            }
            // Trigger all relevant attribute changes.
            if (!silent) {
                if (changes.length > 0)
                    this._pending = true;
                for (var i = 0; i < changes.length; i++)
                    this.properties[changes[i]].change.emit(current[changes[i]]);
            }
            // You might be wondering why there's a `while` loop here. Changes can
            // be recursively nested within `"change"` events.
            if (changing)
                return;
            if (!silent && !options.no_change) {
                while (this._pending) {
                    this._pending = false;
                    this.change.emit(undefined);
                }
            }
            this._pending = false;
            this._changing = false;
        };
        HasProps.prototype.setv = function (attrs, options) {
            if (options === void 0) {
                options = {};
            }
            for (var key in attrs) {
                if (!attrs.hasOwnProperty(key))
                    continue;
                var prop_name = key;
                if (this.props[prop_name] == null)
                    throw new Error('property ' + this.type + '.' + prop_name + ' wasn\'t declared');
                if (!(options != null && options.defaults))
                    this._set_after_defaults[key] = true;
            }
            if (!object_1.isEmpty(attrs)) {
                var old = {};
                for (var key in attrs)
                    old[key] = this.getv(key);
                this._setv(attrs, options);
                var silent = options.silent;
                if (silent == null || !silent) {
                    for (var key in attrs)
                        this._tell_document_about_change(key, old[key], this.getv(key), options);
                }
            }
        };
        HasProps.prototype.getv = function (prop_name) {
            if (this.props[prop_name] == null)
                throw new Error('property ' + this.type + '.' + prop_name + ' wasn\'t declared');
            else
                return this.attributes[prop_name];
        };
        HasProps.prototype.ref = function () {
            return refs_1.create_ref(this);
        };
        // we only keep the subtype so we match Python;
        // only Python cares about this
        HasProps.prototype.set_subtype = function (subtype) {
            this._subtype = subtype;
        };
        HasProps.prototype.attribute_is_serializable = function (attr) {
            var prop = this.props[attr];
            if (prop == null)
                throw new Error(this.type + '.attribute_is_serializable(\'' + attr + '\'): ' + attr + ' wasn\'t declared');
            else
                return !prop.internal;
        };
        // dict of attributes that should be serialized to the server. We
        // sometimes stick things in attributes that aren't part of the
        // Document's models, subtypes that do that have to remove their
        // extra attributes here.
        HasProps.prototype.serializable_attributes = function () {
            var attrs = {};
            for (var name_6 in this.attributes) {
                var value = this.attributes[name_6];
                if (this.attribute_is_serializable(name_6))
                    attrs[name_6] = value;
            }
            return attrs;
        };
        HasProps._value_to_json = function (_key, value, _optional_parent_object) {
            if (value instanceof HasProps)
                return value.ref();
            else if (types_1.isArray(value)) {
                var ref_array = [];
                for (var i = 0; i < value.length; i++) {
                    var v = value[i];
                    ref_array.push(HasProps._value_to_json(i.toString(), v, value));
                }
                return ref_array;
            } else if (types_1.isObject(value)) {
                var ref_obj = {};
                for (var subkey in value) {
                    if (value.hasOwnProperty(subkey))
                        ref_obj[subkey] = HasProps._value_to_json(subkey, value[subkey], value);
                }
                return ref_obj;
            } else
                return value;
        };
        // Convert attributes to "shallow" JSON (values which are themselves models
        // are included as just references)
        // TODO (havocp) can this just be toJSON (from Backbone / JSON.stingify?)
        // backbone will have implemented a toJSON already that we may need to override
        // optional value_to_json is for test to override with a "deep" version to replace the
        // standard "shallow" HasProps._value_to_json
        HasProps.prototype.attributes_as_json = function (include_defaults, value_to_json) {
            if (include_defaults === void 0) {
                include_defaults = true;
            }
            if (value_to_json === void 0) {
                value_to_json = HasProps._value_to_json;
            }
            var serializable = this.serializable_attributes();
            var attrs = {};
            for (var key in serializable) {
                if (serializable.hasOwnProperty(key)) {
                    var value = serializable[key];
                    if (include_defaults)
                        attrs[key] = value;
                    else if (key in this._set_after_defaults)
                        attrs[key] = value;
                }
            }
            return value_to_json('attributes', attrs, this);
        };
        // this is like _value_record_references but expects to find refs
        // instead of models, and takes a doc to look up the refs in
        HasProps._json_record_references = function (doc, v, result, recurse) {
            if (v == null) {
            } else if (refs_1.is_ref(v)) {
                if (!(v.id in result)) {
                    var model = doc.get_model_by_id(v.id);
                    HasProps._value_record_references(model, result, recurse);
                }
            } else if (types_1.isArray(v)) {
                for (var _i = 0, v_1 = v; _i < v_1.length; _i++) {
                    var elem = v_1[_i];
                    HasProps._json_record_references(doc, elem, result, recurse);
                }
            } else if (types_1.isObject(v)) {
                for (var k in v) {
                    if (v.hasOwnProperty(k)) {
                        var elem = v[k];
                        HasProps._json_record_references(doc, elem, result, recurse);
                    }
                }
            }
        };
        // add all references from 'v' to 'result', if recurse
        // is true then descend into refs, if false only
        // descend into non-refs
        HasProps._value_record_references = function (v, result, recurse) {
            if (v == null) {
            } else if (v instanceof HasProps) {
                if (!(v.id in result)) {
                    result[v.id] = v;
                    if (recurse) {
                        var immediate = v._immediate_references();
                        for (var _i = 0, immediate_1 = immediate; _i < immediate_1.length; _i++) {
                            var obj = immediate_1[_i];
                            HasProps._value_record_references(obj, result, true);
                        }    // true=recurse
                    }
                }
            } else if (v.buffer instanceof ArrayBuffer) {
            } else if (types_1.isArray(v)) {
                for (var _a = 0, v_2 = v; _a < v_2.length; _a++) {
                    var elem = v_2[_a];
                    HasProps._value_record_references(elem, result, recurse);
                }
            } else if (types_1.isObject(v)) {
                for (var k in v) {
                    if (v.hasOwnProperty(k)) {
                        var elem = v[k];
                        HasProps._value_record_references(elem, result, recurse);
                    }
                }
            }
        };
        // Get models that are immediately referenced by our properties
        // (do not recurse, do not include ourselves)
        HasProps.prototype._immediate_references = function () {
            var result = {};
            var attrs = this.serializable_attributes();
            for (var key in attrs) {
                var value = attrs[key];
                HasProps._value_record_references(value, result, false);    // false = no recurse
            }
            return object_1.values(result);
        };
        HasProps.prototype.references = function () {
            var references = {};
            HasProps._value_record_references(this, references, true);
            return object_1.values(references);
        };
        HasProps.prototype._doc_attached = function () {
        };
        HasProps.prototype.attach_document = function (doc) {
            // This should only be called by the Document implementation to set the document field
            if (this.document != null && this.document != doc)
                throw new Error('models must be owned by only a single document');
            this.document = doc;
            this._doc_attached();
        };
        HasProps.prototype.detach_document = function () {
            // This should only be called by the Document implementation to unset the document field
            this.document = null;
        };
        HasProps.prototype._tell_document_about_change = function (attr, old, new_, options) {
            if (!this.attribute_is_serializable(attr))
                return;
            if (this.document != null) {
                var new_refs = {};
                HasProps._value_record_references(new_, new_refs, false);
                var old_refs = {};
                HasProps._value_record_references(old, old_refs, false);
                var need_invalidate = false;
                for (var new_id in new_refs) {
                    if (!(new_id in old_refs)) {
                        need_invalidate = true;
                        break;
                    }
                }
                if (!need_invalidate) {
                    for (var old_id in old_refs) {
                        if (!(old_id in new_refs)) {
                            need_invalidate = true;
                            break;
                        }
                    }
                }
                if (need_invalidate)
                    this.document._invalidate_all_models();
                this.document._notify_change(this, attr, old, new_, options);
            }
        };
        HasProps.prototype.materialize_dataspecs = function (source) {
            // Note: this should be moved to a function separate from HasProps
            var data = {};
            for (var name_7 in this.properties) {
                var prop = this.properties[name_7];
                if (!prop.dataspec)
                    continue;
                // this skips optional properties like radius for circles
                if (prop.optional && prop.spec.value == null && !(name_7 in this._set_after_defaults))
                    continue;
                data['_' + name_7] = prop.array(source);
                // the shapes are indexed by the column name, but when we materialize the dataspec, we should
                // store under the canonical field name, e.g. _image_shape, even if the column name is "foo"
                if (prop.spec.field != null && prop.spec.field in source._shapes)
                    data['_' + name_7 + '_shape'] = source._shapes[prop.spec.field];
                if (prop instanceof p.Distance)
                    data['max_' + name_7] = array_1.max(data['_' + name_7]);
            }
            return data;
        };
        return HasProps;
    }(signaling_1.Signalable());
    exports.HasProps = HasProps;
    HasProps.initClass();    
},
/*core/hittest*/
function _(require, module, exports) {
    var array_1 = require(22    /* ./util/array */);
    var object_1 = require(31    /* ./util/object */);
    function point_in_poly(x, y, px, py) {
        var inside = false;
        var x1 = px[px.length - 1];
        var y1 = py[py.length - 1];
        for (var i = 0; i < px.length; i++) {
            var x2 = px[i];
            var y2 = py[i];
            if (y1 < y != y2 < y) {
                if (x1 + (y - y1) / (y2 - y1) * (x2 - x1) < x)
                    inside = !inside;
            }
            x1 = x2;
            y1 = y2;
        }
        return inside;
    }
    exports.point_in_poly = point_in_poly;
    var nullreturner = function () {
        return null;
    };
    // stub function shared by all hittests by default
    var HitTestResult = function () {
        function HitTestResult() {
            // 0d is only valid for line and patch glyphs
            this['0d'] = {
                // the glyph that was picked
                glyph: null,
                get_view: nullreturner,
                // array with the [smallest] index of the segment of the line that was hit
                indices: []
            };
            // 1d for all other glyphs apart from multilines and multi patches
            this['1d'] = {
                // index of the closest point to the crossed segment
                // useful for special glyphs like line that are continuous and
                // not discrete between 2 data points
                indices: []
            };
            // 2d for all for multilines and multi patches
            this['2d'] = {
                // mapping of indices of the multiglyph to array of glyph indices that were hit
                // e.g. {3: [5, 6], 4: [5]}
                indices: {}
            };
        }
        Object.defineProperty(HitTestResult.prototype, '_0d', {
            get: function () {
                return this['0d'];
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(HitTestResult.prototype, '_1d', {
            get: function () {
                return this['1d'];
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(HitTestResult.prototype, '_2d', {
            get: function () {
                return this['2d'];
            },
            enumerable: true,
            configurable: true
        });
        HitTestResult.prototype.is_empty = function () {
            return this._0d.indices.length == 0 && this._1d.indices.length == 0 && object_1.isEmpty(this._2d.indices);
        };
        HitTestResult.prototype.update_through_union = function (other) {
            this._0d.indices = array_1.union(other._0d.indices, this._0d.indices);
            this._0d.glyph = other._0d.glyph || this._0d.glyph;
            this._1d.indices = array_1.union(other._1d.indices, this._1d.indices);
            this._2d.indices = object_1.merge(other._2d.indices, this._2d.indices);
        };
        return HitTestResult;
    }();
    exports.HitTestResult = HitTestResult;
    function create_hit_test_result() {
        return new HitTestResult();
    }
    exports.create_hit_test_result = create_hit_test_result;
    function create_1d_hit_test_result(hits) {
        var result = new HitTestResult();
        result._1d.indices = array_1.sortBy(hits, function (_a) {
            var _i = _a[0], dist = _a[1];
            return dist;
        }).map(function (_a) {
            var i = _a[0], _dist = _a[1];
            return i;
        });
        return result;
    }
    exports.create_1d_hit_test_result = create_1d_hit_test_result;
    function validate_bbox_coords(_a, _b) {
        var x0 = _a[0], x1 = _a[1];
        var y0 = _b[0], y1 = _b[1];
        // rbush expects x0, y0 to be min, x1, y1 max
        if (x0 > x1)
            _c = [
                x1,
                x0
            ], x0 = _c[0], x1 = _c[1];
        if (y0 > y1)
            _d = [
                y1,
                y0
            ], y0 = _d[0], y1 = _d[1];
        return {
            minX: x0,
            minY: y0,
            maxX: x1,
            maxY: y1
        };
        var _c, _d;
    }
    exports.validate_bbox_coords = validate_bbox_coords;
    function sqr(x) {
        return x * x;
    }
    function dist_2_pts(x0, y0, x1, y1) {
        return sqr(x0 - x1) + sqr(y0 - y1);
    }
    exports.dist_2_pts = dist_2_pts;
    function dist_to_segment_squared(p, v, w) {
        var l2 = dist_2_pts(v.x, v.y, w.x, w.y);
        if (l2 == 0)
            return dist_2_pts(p.x, p.y, v.x, v.y);
        var t = ((p.x - v.x) * (w.x - v.x) + (p.y - v.y) * (w.y - v.y)) / l2;
        if (t < 0)
            return dist_2_pts(p.x, p.y, v.x, v.y);
        if (t > 1)
            return dist_2_pts(p.x, p.y, w.x, w.y);
        return dist_2_pts(p.x, p.y, v.x + t * (w.x - v.x), v.y + t * (w.y - v.y));
    }
    exports.dist_to_segment_squared = dist_to_segment_squared;
    function dist_to_segment(p, v, w) {
        return Math.sqrt(dist_to_segment_squared(p, v, w));
    }
    exports.dist_to_segment = dist_to_segment;
    function check_2_segments_intersect(l0_x0, l0_y0, l0_x1, l0_y1, l1_x0, l1_y0, l1_x1, l1_y1) {
        /*
     *  Check if 2 segments (l0 and l1) intersect. Returns a structure with
     *  the following attributes:
     *   * hit (boolean): whether the 2 segments intersect
     *   * x (float): x coordinate of the intersection point
     *   * y (float): y coordinate of the intersection point
     */
        var den = (l1_y1 - l1_y0) * (l0_x1 - l0_x0) - (l1_x1 - l1_x0) * (l0_y1 - l0_y0);
        if (den == 0) {
            return {
                hit: false,
                x: null,
                y: null
            };
        } else {
            var a = l0_y0 - l1_y0;
            var b = l0_x0 - l1_x0;
            var num1 = (l1_x1 - l1_x0) * a - (l1_y1 - l1_y0) * b;
            var num2 = (l0_x1 - l0_x0) * a - (l0_y1 - l0_y0) * b;
            a = num1 / den;
            b = num2 / den;
            var x = l0_x0 + a * (l0_x1 - l0_x0);
            var y = l0_y0 + a * (l0_y1 - l0_y0);
            return {
                hit: a > 0 && a < 1 && (b > 0 && b < 1),
                x: x,
                y: y
            };
        }
    }
    exports.check_2_segments_intersect = check_2_segments_intersect;    
},
/*core/layout/alignments*/
function _(require, module, exports) {
    var solver_1 = require(13    /* ./solver */);
    var array_1 = require(22    /* ../util/array */);
    function vstack(container, children) {
        var constraints = [];
        if (children.length > 0) {
            constraints.push(solver_1.EQ(array_1.head(children)._bottom, [
                -1,
                container._bottom
            ]));
            constraints.push(solver_1.EQ(array_1.tail(children)._top, [
                -1,
                container._top
            ]));
            constraints.push.apply(constraints, array_1.pairwise(children, function (prev, next) {
                return solver_1.EQ(prev._top, [
                    -1,
                    next._bottom
                ]);
            }));
            for (var _i = 0, children_1 = children; _i < children_1.length; _i++) {
                var child = children_1[_i];
                constraints.push(solver_1.EQ(child._left, [
                    -1,
                    container._left
                ]));
                constraints.push(solver_1.EQ(child._right, [
                    -1,
                    container._right
                ]));
            }
        }
        return constraints;
    }
    exports.vstack = vstack;
    function hstack(container, children) {
        var constraints = [];
        if (children.length > 0) {
            constraints.push(solver_1.EQ(array_1.head(children)._right, [
                -1,
                container._right
            ]));
            constraints.push(solver_1.EQ(array_1.tail(children)._left, [
                -1,
                container._left
            ]));
            constraints.push.apply(constraints, array_1.pairwise(children, function (prev, next) {
                return solver_1.EQ(prev._left, [
                    -1,
                    next._right
                ]);
            }));
            for (var _i = 0, children_2 = children; _i < children_2.length; _i++) {
                var child = children_2[_i];
                constraints.push(solver_1.EQ(child._top, [
                    -1,
                    container._top
                ]));
                constraints.push(solver_1.EQ(child._bottom, [
                    -1,
                    container._bottom
                ]));
            }
        }
        return constraints;
    }
    exports.hstack = hstack;    
},
/*core/layout/layout_canvas*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    var solver_1 = require(13    /* ./solver */);
    var has_props_1 = require(8    /* ../has_props */);
    var bbox_1 = require(24    /* ../util/bbox */);
    var LayoutCanvas = function (_super) {
        tslib_1.__extends(LayoutCanvas, _super);
        function LayoutCanvas(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        LayoutCanvas.initClass = function () {
            this.prototype.type = 'LayoutCanvas';
        };
        LayoutCanvas.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            this._top = new solver_1.Variable(this.toString() + '.top');
            this._left = new solver_1.Variable(this.toString() + '.left');
            this._width = new solver_1.Variable(this.toString() + '.width');
            this._height = new solver_1.Variable(this.toString() + '.height');
            this._right = new solver_1.Variable(this.toString() + '.right');
            this._bottom = new solver_1.Variable(this.toString() + '.bottom');
            this._hcenter = new solver_1.Variable(this.toString() + '.hcenter');
            this._vcenter = new solver_1.Variable(this.toString() + '.vcenter');
        };
        LayoutCanvas.prototype.get_editables = function () {
            return [];
        };
        LayoutCanvas.prototype.get_constraints = function () {
            return [
                solver_1.GE(this._top),
                solver_1.GE(this._bottom),
                solver_1.GE(this._left),
                solver_1.GE(this._right),
                solver_1.GE(this._width),
                solver_1.GE(this._height),
                solver_1.EQ(this._left, this._width, [
                    -1,
                    this._right
                ]),
                solver_1.EQ(this._top, this._height, [
                    -1,
                    this._bottom
                ]),
                solver_1.EQ([
                    2,
                    this._hcenter
                ], [
                    -1,
                    this._left
                ], [
                    -1,
                    this._right
                ]),
                solver_1.EQ([
                    2,
                    this._vcenter
                ], [
                    -1,
                    this._top
                ], [
                    -1,
                    this._bottom
                ])
            ];
        };
        LayoutCanvas.prototype.get_layoutable_children = function () {
            return [];
        };
        Object.defineProperty(LayoutCanvas.prototype, 'bbox', {
            get: function () {
                return new bbox_1.BBox({
                    x0: this._left.value,
                    y0: this._top.value,
                    x1: this._right.value,
                    y1: this._bottom.value
                });
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(LayoutCanvas.prototype, 'layout_bbox', {
            get: function () {
                return {
                    top: this._top.value,
                    left: this._left.value,
                    width: this._width.value,
                    height: this._height.value,
                    right: this._right.value,
                    bottom: this._bottom.value,
                    hcenter: this._hcenter.value,
                    vcenter: this._vcenter.value
                };
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(LayoutCanvas.prototype, 'xview', {
            get: function () {
                var _this = this;
                return {
                    compute: function (x) {
                        return _this._left.value + x;
                    },
                    v_compute: function (xx) {
                        var _xx = new Float64Array(xx.length);
                        var left = _this._left.value;
                        for (var i = 0; i < xx.length; i++) {
                            _xx[i] = left + xx[i];
                        }
                        return _xx;
                    }
                };
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(LayoutCanvas.prototype, 'yview', {
            get: function () {
                var _this = this;
                return {
                    compute: function (y) {
                        return _this._bottom.value - y;
                    },
                    v_compute: function (yy) {
                        var _yy = new Float64Array(yy.length);
                        var bottom = _this._bottom.value;
                        for (var i = 0; i < yy.length; i++) {
                            _yy[i] = bottom - yy[i];
                        }
                        return _yy;
                    }
                };
            },
            enumerable: true,
            configurable: true
        });
        return LayoutCanvas;
    }(has_props_1.HasProps);
    exports.LayoutCanvas = LayoutCanvas;
    LayoutCanvas.initClass();    
},
/*core/layout/side_panel*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    var solver_1 = require(13    /* ./solver */);
    var layout_canvas_1 = require(11    /* ./layout_canvas */);
    var p = require(15    /* ../properties */);
    var logging_1 = require(14    /* ../logging */);
    var types_1 = require(43    /* ../util/types */);
    // This table lays out the rules for configuring the baseline, alignment, etc. of
    // title text, based on it's location and orientation
    //
    // side    orient        baseline   align     angle   normal-dist
    // ------------------------------------------------------------------------------
    // above   parallel      bottom     center    0       height
    //         normal        middle     left      -90     width
    //         horizontal    bottom     center    0       height
    //         [angle > 0]   middle     left              width * sin + height * cos
    //         [angle < 0]   middle     right             width * sin + height * cos
    //
    // below   parallel      top        center    0       height
    //         normal        middle     right     90      width
    //         horizontal    top        center    0       height
    //         [angle > 0]   middle     right             width * sin + height * cos
    //         [angle < 0]   middle     left              width * sin + height * cos
    //
    // left    parallel      bottom     center    90      height
    //         normal        middle     right     0       width
    //         horizontal    middle     right     0       width
    //         [angle > 0]   middle     right             width * cos + height * sin
    //         [angle < 0]   middle     right             width * cos + height + sin
    //
    // right   parallel      bottom     center   -90      height
    //         normal        middle     left     0        width
    //         horizontal    middle     left     0        width
    //         [angle > 0]   middle     left              width * cos + height * sin
    //         [angle < 0]   middle     left              width * cos + height + sin
    var pi2 = Math.PI / 2;
    var ALPHABETIC = 'alphabetic';
    var TOP = 'top';
    var BOTTOM = 'bottom';
    var MIDDLE = 'middle';
    var HANGING = 'hanging';
    var LEFT = 'left';
    var RIGHT = 'right';
    var CENTER = 'center';
    var _angle_lookup = {
        above: {
            parallel: 0,
            normal: -pi2,
            horizontal: 0,
            vertical: -pi2
        },
        below: {
            parallel: 0,
            normal: pi2,
            horizontal: 0,
            vertical: pi2
        },
        left: {
            parallel: -pi2,
            normal: 0,
            horizontal: 0,
            vertical: -pi2
        },
        right: {
            parallel: pi2,
            normal: 0,
            horizontal: 0,
            vertical: pi2
        }
    };
    var _baseline_lookup = {
        above: {
            justified: TOP,
            parallel: ALPHABETIC,
            normal: MIDDLE,
            horizontal: ALPHABETIC,
            vertical: MIDDLE
        },
        below: {
            justified: BOTTOM,
            parallel: HANGING,
            normal: MIDDLE,
            horizontal: HANGING,
            vertical: MIDDLE
        },
        left: {
            justified: TOP,
            parallel: ALPHABETIC,
            normal: MIDDLE,
            horizontal: MIDDLE,
            vertical: ALPHABETIC
        },
        right: {
            justified: TOP,
            parallel: ALPHABETIC,
            normal: MIDDLE,
            horizontal: MIDDLE,
            vertical: ALPHABETIC
        }
    };
    var _align_lookup = {
        above: {
            justified: CENTER,
            parallel: CENTER,
            normal: LEFT,
            horizontal: CENTER,
            vertical: LEFT
        },
        below: {
            justified: CENTER,
            parallel: CENTER,
            normal: LEFT,
            horizontal: CENTER,
            vertical: LEFT
        },
        left: {
            justified: CENTER,
            parallel: CENTER,
            normal: RIGHT,
            horizontal: RIGHT,
            vertical: CENTER
        },
        right: {
            justified: CENTER,
            parallel: CENTER,
            normal: LEFT,
            horizontal: LEFT,
            vertical: CENTER
        }
    };
    var _align_lookup_negative = {
        above: RIGHT,
        below: LEFT,
        left: RIGHT,
        right: LEFT
    };
    var _align_lookup_positive = {
        above: LEFT,
        below: RIGHT,
        left: RIGHT,
        right: LEFT
    };
    exports._view_sizes = new WeakMap();
    exports._view_constraints = new WeakMap();
    function update_panel_constraints(view) {
        var s = view.solver;
        var size = view.get_size();
        var constraint = exports._view_constraints.get(view);
        if (constraint != null && s.has_constraint(constraint)) {
            if (exports._view_sizes.get(view) === size)
                return;
            s.remove_constraint(constraint);
        }
        constraint = solver_1.GE(view.model.panel._size, -size);
        s.add_constraint(constraint);
        exports._view_sizes.set(view, size);
        exports._view_constraints.set(view, constraint);
    }
    exports.update_panel_constraints = update_panel_constraints;
    var SidePanel = function (_super) {
        tslib_1.__extends(SidePanel, _super);
        function SidePanel(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        SidePanel.initClass = function () {
            this.prototype.type = 'SidePanel';
            this.internal({ side: [p.String] });
        };
        SidePanel.prototype.toString = function () {
            return this.type + '(' + this.id + ', ' + this.side + ')';
        };
        SidePanel.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            switch (this.side) {
            case 'above':
                this._dim = 0;
                this._normals = [
                    0,
                    -1
                ];
                this._size = this._height;
                break;
            case 'below':
                this._dim = 0;
                this._normals = [
                    0,
                    1
                ];
                this._size = this._height;
                break;
            case 'left':
                this._dim = 1;
                this._normals = [
                    -1,
                    0
                ];
                this._size = this._width;
                break;
            case 'right':
                this._dim = 1;
                this._normals = [
                    1,
                    0
                ];
                this._size = this._width;
                break;
            default:
                logging_1.logger.error('unrecognized side: \'' + this.side + '\'');
            }
        };
        Object.defineProperty(SidePanel.prototype, 'dimension', {
            get: function () {
                return this._dim;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(SidePanel.prototype, 'normals', {
            get: function () {
                return this._normals;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(SidePanel.prototype, 'is_horizontal', {
            get: function () {
                return this.side == 'above' || this.side == 'below';
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(SidePanel.prototype, 'is_vertical', {
            get: function () {
                return this.side == 'left' || this.side == 'right';
            },
            enumerable: true,
            configurable: true
        });
        SidePanel.prototype.apply_label_text_heuristics = function (ctx, orient) {
            var side = this.side;
            var baseline;
            var align;
            if (types_1.isString(orient)) {
                baseline = _baseline_lookup[side][orient];
                align = _align_lookup[side][orient];
            } else {
                if (orient === 0) {
                    baseline = 'whatever';
                    // XXX: _baseline_lookup[side][orient]
                    align = 'whatever';    // XXX: _align_lookup[side][orient]
                } else if (orient < 0) {
                    baseline = 'middle';
                    align = _align_lookup_negative[side];
                } else {
                    baseline = 'middle';
                    align = _align_lookup_positive[side];
                }
            }
            ctx.textBaseline = baseline;
            ctx.textAlign = align;
        };
        SidePanel.prototype.get_label_angle_heuristic = function (orient) {
            return _angle_lookup[this.side][orient];
        };
        return SidePanel;
    }(layout_canvas_1.LayoutCanvas);
    exports.SidePanel = SidePanel;
    SidePanel.initClass();    
},
/*core/layout/solver*/
function _(require, module, exports) {
    var kiwi_1 = require(326    /* kiwi */);
    exports.Variable = kiwi_1.Variable;
    exports.Expression = kiwi_1.Expression;
    exports.Constraint = kiwi_1.Constraint;
    exports.Operator = kiwi_1.Operator;
    exports.Strength = kiwi_1.Strength;
    function _constrainer(op) {
        return function () {
            var terms = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                terms[_i] = arguments[_i];
            }
            return new kiwi_1.Constraint(new (kiwi_1.Expression.bind.apply(kiwi_1.Expression, [void 0].concat(terms)))(), op);
        };
    }
    function _weak_constrainer(op) {
        return function () {
            var terms = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                terms[_i] = arguments[_i];
            }
            return new kiwi_1.Constraint(new (kiwi_1.Expression.bind.apply(kiwi_1.Expression, [void 0].concat(terms)))(), op, kiwi_1.Strength.weak);
        };
    }
    exports.EQ = _constrainer(kiwi_1.Operator.Eq);
    exports.LE = _constrainer(kiwi_1.Operator.Le);
    exports.GE = _constrainer(kiwi_1.Operator.Ge);
    exports.WEAK_EQ = _weak_constrainer(kiwi_1.Operator.Eq);
    exports.WEAK_LE = _weak_constrainer(kiwi_1.Operator.Le);
    exports.WEAK_GE = _weak_constrainer(kiwi_1.Operator.Ge);
    var Solver = function () {
        function Solver() {
            this.solver = new kiwi_1.Solver();
        }
        Solver.prototype.clear = function () {
            this.solver = new kiwi_1.Solver();
        };
        Solver.prototype.toString = function () {
            return 'Solver(num_constraints=' + this.num_constraints + ', num_editables=' + this.num_editables + ')';
        };
        Object.defineProperty(Solver.prototype, 'num_constraints', {
            get: function () {
                return this.solver.numConstraints;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Solver.prototype, 'num_editables', {
            get: function () {
                return this.solver.numEditVariables;
            },
            enumerable: true,
            configurable: true
        });
        Solver.prototype.get_constraints = function () {
            return this.solver.getConstraints();
        };
        Solver.prototype.update_variables = function () {
            this.solver.updateVariables();
        };
        Solver.prototype.has_constraint = function (constraint) {
            return this.solver.hasConstraint(constraint);
        };
        Solver.prototype.add_constraint = function (constraint) {
            try {
                this.solver.addConstraint(constraint);
            } catch (e) {
                throw new Error(e.message + ': ' + constraint.toString());
            }
        };
        Solver.prototype.remove_constraint = function (constraint) {
            this.solver.removeConstraint(constraint);
        };
        Solver.prototype.add_edit_variable = function (variable, strength) {
            this.solver.addEditVariable(variable, strength);
        };
        Solver.prototype.remove_edit_variable = function (variable) {
            this.solver.removeEditVariable(variable);
        };
        Solver.prototype.suggest_value = function (variable, value) {
            this.solver.suggestValue(variable, value);
        };
        return Solver;
    }();
    exports.Solver = Solver;    
},
/*core/logging*/
function _(require, module, exports) {
    var types_1 = require(43    /* ./util/types */);
    var _loggers = {};
    var LogLevel = function () {
        function LogLevel(name, level) {
            this.name = name;
            this.level = level;
        }
        return LogLevel;
    }();
    exports.LogLevel = LogLevel;
    var Logger = function () {
        function Logger(name, level) {
            if (level === void 0) {
                level = Logger.INFO;
            }
            this._name = name;
            this.set_level(level);
        }
        Object.defineProperty(Logger, 'levels', {
            get: function () {
                return Object.keys(Logger.log_levels);
            },
            enumerable: true,
            configurable: true
        });
        Logger.get = function (name, level) {
            if (level === void 0) {
                level = Logger.INFO;
            }
            if (name.length > 0) {
                var logger_1 = _loggers[name];
                if (logger_1 == null)
                    _loggers[name] = logger_1 = new Logger(name, level);
                return logger_1;
            } else
                throw new TypeError('Logger.get() expects a non-empty string name and an optional log-level');
        };
        Object.defineProperty(Logger.prototype, 'level', {
            get: function () {
                return this.get_level();
            },
            enumerable: true,
            configurable: true
        });
        Logger.prototype.get_level = function () {
            return this._log_level;
        };
        Logger.prototype.set_level = function (log_level) {
            if (log_level instanceof LogLevel)
                this._log_level = log_level;
            else if (types_1.isString(log_level) && Logger.log_levels[log_level] != null)
                this._log_level = Logger.log_levels[log_level];
            else
                throw new Error('Logger.set_level() expects a log-level object or a string name of a log-level');
            var logger_name = '[' + this._name + ']';
            for (var name_1 in Logger.log_levels) {
                var log_level_1 = Logger.log_levels[name_1];
                if (log_level_1.level < this._log_level.level || this._log_level.level === Logger.OFF.level)
                    this[name_1] = function () {
                    };
                else
                    this[name_1] = _method_factory(name_1, logger_name);
            }
        };
        Logger.prototype.trace = function () {
            var _args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                _args[_i] = arguments[_i];
            }
        };
        Logger.prototype.debug = function () {
            var _args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                _args[_i] = arguments[_i];
            }
        };
        Logger.prototype.info = function () {
            var _args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                _args[_i] = arguments[_i];
            }
        };
        Logger.prototype.warn = function () {
            var _args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                _args[_i] = arguments[_i];
            }
        };
        Logger.prototype.error = function () {
            var _args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                _args[_i] = arguments[_i];
            }
        };
        Logger.TRACE = new LogLevel('trace', 0);
        Logger.DEBUG = new LogLevel('debug', 1);
        Logger.INFO = new LogLevel('info', 2);
        Logger.WARN = new LogLevel('warn', 6);
        Logger.ERROR = new LogLevel('error', 7);
        Logger.FATAL = new LogLevel('fatal', 8);
        Logger.OFF = new LogLevel('off', 9);
        Logger.log_levels = {
            trace: Logger.TRACE,
            debug: Logger.DEBUG,
            info: Logger.INFO,
            warn: Logger.WARN,
            error: Logger.ERROR,
            fatal: Logger.FATAL,
            off: Logger.OFF
        };
        return Logger;
    }();
    exports.Logger = Logger;
    function _method_factory(method_name, logger_name) {
        if (console[method_name] != null)
            return console[method_name].bind(console, logger_name);
        else if (console.log != null)
            return console.log.bind(console, logger_name);
        else
            return function () {
            };
    }
    exports.logger = Logger.get('bokeh');
    function set_log_level(level) {
        if (Logger.log_levels[level] == null) {
            console.log('[bokeh] unrecognized logging level \'' + level + '\' passed to Bokeh.set_log_level(), ignoring');
            console.log('[bokeh] valid log levels are: ' + Logger.levels.join(', '));
        } else {
            console.log('[bokeh] setting log level to: \'' + level + '\'');
            exports.logger.set_level(level);
        }
    }
    exports.set_log_level = set_log_level;    
},
/*core/properties*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    var signaling_1 = require(20    /* ./signaling */);
    var enums = require(7    /* ./enums */);
    var svg_colors = require(39    /* ./util/svg_colors */);
    var color_1 = require(27    /* ./util/color */);
    var array_1 = require(22    /* ./util/array */);
    var types_1 = require(43    /* ./util/types */);
    function valueToString(value) {
        try {
            return JSON.stringify(value);
        } catch (_a) {
            return value.toString();
        }
    }
    //
    // Property base class
    //
    var Property = function (_super) {
        tslib_1.__extends(Property, _super);
        function Property(obj, attr, default_value) {
            var _this = _super.call(this) || this;
            _this.obj = obj;
            _this.attr = attr;
            _this.default_value = default_value;
            _this.optional = false;
            _this.change = new signaling_1.Signal(_this.obj, 'change');
            _this._init();
            _this.connect(_this.change, function () {
                return _this._init();
            });
            return _this;
        }
        Property.prototype.update = function () {
            this._init();
        };
        // ----- customizable policies
        Property.prototype.init = function () {
        };
        Property.prototype.transform = function (values) {
            return values;
        };
        Property.prototype.validate = function (_value) {
        };
        // ----- property accessors
        Property.prototype.value = function (do_spec_transform) {
            if (do_spec_transform === void 0) {
                do_spec_transform = true;
            }
            if (this.spec.value === undefined)
                throw new Error('attempted to retrieve property value for property without value specification');
            var ret = this.transform([this.spec.value])[0];
            if (this.spec.transform != null && do_spec_transform)
                ret = this.spec.transform.compute(ret);
            return ret;
        };
        Property.prototype.array = function (source) {
            if (!this.dataspec)
                throw new Error('attempted to retrieve property array for non-dataspec property');
            var data = source.data;
            var ret;
            if (this.spec.field != null) {
                if (this.spec.field in data)
                    ret = this.transform(source.get_column(this.spec.field));
                else
                    throw new Error('attempted to retrieve property array for nonexistent field \'' + this.spec.field + '\'');
            } else if (this.spec.expr != null) {
                ret = this.transform(this.spec.expr._v_compute(source));
            } else {
                var length_1 = source.get_length();
                if (length_1 == null)
                    length_1 = 1;
                var value = this.value(false);
                // don't apply any spec transform
                ret = array_1.repeat(value, length_1);
            }
            if (this.spec.transform != null)
                ret = this.spec.transform.v_compute(ret);
            return ret;
        };
        // ----- private methods
        /*protected*/
        Property.prototype._init = function () {
            var obj = this.obj;
            var attr = this.attr;
            var attr_value = obj.getv(attr);
            if (attr_value === undefined) {
                var default_value = this.default_value;
                if (default_value !== undefined)
                    attr_value = default_value(obj);
                else
                    attr_value = null;
                obj.setv((_a = {}, _a[attr] = attr_value, _a), {
                    silent: true,
                    defaults: true
                });
            }
            if (types_1.isArray(attr_value))
                this.spec = { value: attr_value };
            else if (types_1.isObject(attr_value) && (attr_value.value === undefined ? 0 : 1) + (attr_value.field === undefined ? 0 : 1) + (attr_value.expr === undefined ? 0 : 1) == 1)
                this.spec = attr_value;
            else
                this.spec = { value: attr_value };
            if (this.spec.field != null && !types_1.isString(this.spec.field))
                throw new Error('field value for property \'' + attr + '\' is not a string');
            if (this.spec.value != null)
                this.validate(this.spec.value);
            this.init();
            var _a;
        };
        Property.prototype.toString = function () {
            /*${this.name}*/
            return 'Prop(' + this.obj + '.' + this.attr + ', spec: ' + valueToString(this.spec) + ')';
        };
        return Property;
    }(signaling_1.Signalable());
    exports.Property = Property;
    Property.prototype.dataspec = false;
    //
    // Simple Properties
    //
    function simple_prop(name, pred) {
        return function (_super) {
            tslib_1.__extends(class_1, _super);
            function class_1() {
                return _super !== null && _super.apply(this, arguments) || this;
            }
            class_1.prototype.validate = function (value) {
                if (!pred(value))
                    throw new Error(name + ' property \'' + this.attr + '\' given invalid value: ' + valueToString(value));
            };
            return class_1;
        }(Property);
    }
    exports.simple_prop = simple_prop;
    var Any = function (_super) {
        tslib_1.__extends(Any, _super);
        function Any() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return Any;
    }(simple_prop('Any', function (_x) {
        return true;
    }));
    exports.Any = Any;
    var Array = function (_super) {
        tslib_1.__extends(Array, _super);
        function Array() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return Array;
    }(simple_prop('Array', function (x) {
        return types_1.isArray(x) || x instanceof Float64Array;
    }));
    exports.Array = Array;
    var Bool = function (_super) {
        tslib_1.__extends(Bool, _super);
        function Bool() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return Bool;
    }(simple_prop('Bool', types_1.isBoolean));
    exports.Bool = Bool;
    exports.Boolean = Bool;
    var Color = function (_super) {
        tslib_1.__extends(Color, _super);
        function Color() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return Color;
    }(simple_prop('Color', function (x) {
        return svg_colors[x.toLowerCase()] != null || x.substring(0, 1) == '#' || color_1.valid_rgb(x);
    }));
    exports.Color = Color;
    var Instance = function (_super) {
        tslib_1.__extends(Instance, _super);
        function Instance() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return Instance;
    }(simple_prop('Instance', function (x) {
        return x.properties != null;
    }));
    exports.Instance = Instance;
    // TODO (bev) separate booleans?
    var Number = function (_super) {
        tslib_1.__extends(Number, _super);
        function Number() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return Number;
    }(simple_prop('Number', function (x) {
        return types_1.isNumber(x) || types_1.isBoolean(x);
    }));
    exports.Number = Number;
    exports.Int = Number;
    // TODO extend Number instead of copying it's predicate
    //class Percent extends Number("Percent", (x) -> 0 <= x <= 1.0)
    var Percent = function (_super) {
        tslib_1.__extends(Percent, _super);
        function Percent() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return Percent;
    }(simple_prop('Number', function (x) {
        return (types_1.isNumber(x) || types_1.isBoolean(x)) && 0 <= x && x <= 1;
    }));
    exports.Percent = Percent;
    var String = function (_super) {
        tslib_1.__extends(String, _super);
        function String() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return String;
    }(simple_prop('String', types_1.isString));
    exports.String = String;
    // TODO (bev) don't think this exists python side
    var Font = function (_super) {
        tslib_1.__extends(Font, _super);
        function Font() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return Font;
    }(String);
    exports.Font = Font;
    //
    // Enum properties
    //
    function enum_prop(name, enum_values) {
        return function (_super) {
            tslib_1.__extends(class_2, _super);
            function class_2() {
                return _super !== null && _super.apply(this, arguments) || this;
            }
            return class_2;
        }(simple_prop(name, function (x) {
            return array_1.includes(enum_values, x);
        }));
    }
    exports.enum_prop = enum_prop;
    var Anchor = function (_super) {
        tslib_1.__extends(Anchor, _super);
        function Anchor() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return Anchor;
    }(enum_prop('Anchor', enums.LegendLocation));
    exports.Anchor = Anchor;
    var AngleUnits = function (_super) {
        tslib_1.__extends(AngleUnits, _super);
        function AngleUnits() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return AngleUnits;
    }(enum_prop('AngleUnits', enums.AngleUnits));
    exports.AngleUnits = AngleUnits;
    var Direction = function (_super) {
        tslib_1.__extends(Direction, _super);
        function Direction() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Direction.prototype.transform = function (values) {
            var result = new Uint8Array(values.length);
            for (var i = 0; i < values.length; i++) {
                switch (values[i]) {
                case 'clock':
                    result[i] = 0;
                    break;
                case 'anticlock':
                    result[i] = 1;
                    break;
                }
            }
            return result;
        };
        return Direction;
    }(enum_prop('Direction', enums.Direction));
    exports.Direction = Direction;
    var Dimension = function (_super) {
        tslib_1.__extends(Dimension, _super);
        function Dimension() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return Dimension;
    }(enum_prop('Dimension', enums.Dimension));
    exports.Dimension = Dimension;
    var Dimensions = function (_super) {
        tslib_1.__extends(Dimensions, _super);
        function Dimensions() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return Dimensions;
    }(enum_prop('Dimensions', enums.Dimensions));
    exports.Dimensions = Dimensions;
    var FontStyle = function (_super) {
        tslib_1.__extends(FontStyle, _super);
        function FontStyle() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return FontStyle;
    }(enum_prop('FontStyle', enums.FontStyle));
    exports.FontStyle = FontStyle;
    var LatLon = function (_super) {
        tslib_1.__extends(LatLon, _super);
        function LatLon() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return LatLon;
    }(enum_prop('LatLon', enums.LatLon));
    exports.LatLon = LatLon;
    var LineCap = function (_super) {
        tslib_1.__extends(LineCap, _super);
        function LineCap() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return LineCap;
    }(enum_prop('LineCap', enums.LineCap));
    exports.LineCap = LineCap;
    var LineJoin = function (_super) {
        tslib_1.__extends(LineJoin, _super);
        function LineJoin() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return LineJoin;
    }(enum_prop('LineJoin', enums.LineJoin));
    exports.LineJoin = LineJoin;
    var LegendLocation = function (_super) {
        tslib_1.__extends(LegendLocation, _super);
        function LegendLocation() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return LegendLocation;
    }(enum_prop('LegendLocation', enums.LegendLocation));
    exports.LegendLocation = LegendLocation;
    var Location = function (_super) {
        tslib_1.__extends(Location, _super);
        function Location() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return Location;
    }(enum_prop('Location', enums.Location));
    exports.Location = Location;
    var OutputBackend = function (_super) {
        tslib_1.__extends(OutputBackend, _super);
        function OutputBackend() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return OutputBackend;
    }(enum_prop('OutputBackend', enums.OutputBackend));
    exports.OutputBackend = OutputBackend;
    var Orientation = function (_super) {
        tslib_1.__extends(Orientation, _super);
        function Orientation() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return Orientation;
    }(enum_prop('Orientation', enums.Orientation));
    exports.Orientation = Orientation;
    var VerticalAlign = function (_super) {
        tslib_1.__extends(VerticalAlign, _super);
        function VerticalAlign() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return VerticalAlign;
    }(enum_prop('VerticalAlign', enums.VerticalAlign));
    exports.VerticalAlign = VerticalAlign;
    var TextAlign = function (_super) {
        tslib_1.__extends(TextAlign, _super);
        function TextAlign() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return TextAlign;
    }(enum_prop('TextAlign', enums.TextAlign));
    exports.TextAlign = TextAlign;
    var TextBaseline = function (_super) {
        tslib_1.__extends(TextBaseline, _super);
        function TextBaseline() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return TextBaseline;
    }(enum_prop('TextBaseline', enums.TextBaseline));
    exports.TextBaseline = TextBaseline;
    var RenderLevel = function (_super) {
        tslib_1.__extends(RenderLevel, _super);
        function RenderLevel() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return RenderLevel;
    }(enum_prop('RenderLevel', enums.RenderLevel));
    exports.RenderLevel = RenderLevel;
    var RenderMode = function (_super) {
        tslib_1.__extends(RenderMode, _super);
        function RenderMode() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return RenderMode;
    }(enum_prop('RenderMode', enums.RenderMode));
    exports.RenderMode = RenderMode;
    var SizingMode = function (_super) {
        tslib_1.__extends(SizingMode, _super);
        function SizingMode() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return SizingMode;
    }(enum_prop('SizingMode', enums.SizingMode));
    exports.SizingMode = SizingMode;
    var SpatialUnits = function (_super) {
        tslib_1.__extends(SpatialUnits, _super);
        function SpatialUnits() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return SpatialUnits;
    }(enum_prop('SpatialUnits', enums.SpatialUnits));
    exports.SpatialUnits = SpatialUnits;
    var Distribution = function (_super) {
        tslib_1.__extends(Distribution, _super);
        function Distribution() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return Distribution;
    }(enum_prop('Distribution', enums.Distribution));
    exports.Distribution = Distribution;
    var StepMode = function (_super) {
        tslib_1.__extends(StepMode, _super);
        function StepMode() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return StepMode;
    }(enum_prop('StepMode', enums.StepMode));
    exports.StepMode = StepMode;
    var PaddingUnits = function (_super) {
        tslib_1.__extends(PaddingUnits, _super);
        function PaddingUnits() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return PaddingUnits;
    }(enum_prop('PaddingUnits', enums.PaddingUnits));
    exports.PaddingUnits = PaddingUnits;
    var StartEnd = function (_super) {
        tslib_1.__extends(StartEnd, _super);
        function StartEnd() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return StartEnd;
    }(enum_prop('StartEnd', enums.StartEnd));
    exports.StartEnd = StartEnd;
    //
    // Units Properties
    //
    function units_prop(name, valid_units, default_units) {
        return function (_super) {
            tslib_1.__extends(class_3, _super);
            function class_3() {
                return _super !== null && _super.apply(this, arguments) || this;
            }
            class_3.prototype.init = function () {
                if (this.spec.units == null)
                    this.spec.units = default_units;
                var units = this.spec.units;
                if (!array_1.includes(valid_units, units))
                    throw new Error(name + ' units must be one of ' + valid_units + ', given invalid value: ' + units);
            };
            Object.defineProperty(class_3.prototype, 'units', {
                get: function () {
                    return this.spec.units;
                },
                set: function (units) {
                    this.spec.units = units;
                },
                enumerable: true,
                configurable: true
            });
            return class_3;
        }(Number);
    }
    exports.units_prop = units_prop;
    var Angle = function (_super) {
        tslib_1.__extends(Angle, _super);
        function Angle() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Angle.prototype.transform = function (values) {
            if (this.spec.units == 'deg')
                values = array_1.map(values, function (x) {
                    return x * Math.PI / 180;
                });
            values = array_1.map(values, function (x) {
                return -x;
            });
            return _super.prototype.transform.call(this, values);
        };
        return Angle;
    }(units_prop('Angle', enums.AngleUnits, 'rad'));
    exports.Angle = Angle;
    var Distance = function (_super) {
        tslib_1.__extends(Distance, _super);
        function Distance() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return Distance;
    }(units_prop('Distance', enums.SpatialUnits, 'data'));
    exports.Distance = Distance;
    //
    // DataSpec properties
    //
    var AngleSpec = function (_super) {
        tslib_1.__extends(AngleSpec, _super);
        function AngleSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return AngleSpec;
    }(Angle);
    exports.AngleSpec = AngleSpec;
    AngleSpec.prototype.dataspec = true;
    var ColorSpec = function (_super) {
        tslib_1.__extends(ColorSpec, _super);
        function ColorSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return ColorSpec;
    }(Color);
    exports.ColorSpec = ColorSpec;
    ColorSpec.prototype.dataspec = true;
    var DirectionSpec = function (_super) {
        tslib_1.__extends(DirectionSpec, _super);
        function DirectionSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return DirectionSpec;
    }(Distance);
    exports.DirectionSpec = DirectionSpec;
    DirectionSpec.prototype.dataspec = true;
    var DistanceSpec = function (_super) {
        tslib_1.__extends(DistanceSpec, _super);
        function DistanceSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return DistanceSpec;
    }(Distance);
    exports.DistanceSpec = DistanceSpec;
    DistanceSpec.prototype.dataspec = true;
    var FontSizeSpec = function (_super) {
        tslib_1.__extends(FontSizeSpec, _super);
        function FontSizeSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return FontSizeSpec;
    }(String);
    exports.FontSizeSpec = FontSizeSpec;
    FontSizeSpec.prototype.dataspec = true;
    var NumberSpec = function (_super) {
        tslib_1.__extends(NumberSpec, _super);
        function NumberSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return NumberSpec;
    }(Number);
    exports.NumberSpec = NumberSpec;
    NumberSpec.prototype.dataspec = true;
    var StringSpec = function (_super) {
        tslib_1.__extends(StringSpec, _super);
        function StringSpec() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return StringSpec;
    }(String);
    exports.StringSpec = StringSpec;
    StringSpec.prototype.dataspec = true;    
},
/*core/property_mixins*/
function _(require, module, exports) {
    var p = require(15    /* ./properties */);
    var object_1 = require(31    /* ./util/object */);
    function _gen_mixin(mixin, prefix) {
        var result = {};
        for (var name_1 in mixin) {
            var prop = mixin[name_1];
            result[prefix + name_1] = prop;
        }
        return result;
    }
    var _line_mixin = {
        line_color: [
            p.ColorSpec,
            'black'
        ],
        line_width: [
            p.NumberSpec,
            1
        ],
        line_alpha: [
            p.NumberSpec,
            1
        ],
        line_join: [
            p.LineJoin,
            'miter'
        ],
        line_cap: [
            p.LineCap,
            'butt'
        ],
        line_dash: [
            p.Array,
            []
        ],
        line_dash_offset: [
            p.Number,
            0
        ]
    };
    exports.line = function (prefix) {
        if (prefix === void 0) {
            prefix = '';
        }
        return _gen_mixin(_line_mixin, prefix);
    };
    var _fill_mixin = {
        fill_color: [
            p.ColorSpec,
            'gray'
        ],
        fill_alpha: [
            p.NumberSpec,
            1
        ]
    };
    exports.fill = function (prefix) {
        if (prefix === void 0) {
            prefix = '';
        }
        return _gen_mixin(_fill_mixin, prefix);
    };
    var _text_mixin = {
        text_font: [
            p.Font,
            'helvetica'
        ],
        text_font_size: [
            p.FontSizeSpec,
            '12pt'
        ],
        text_font_style: [
            p.FontStyle,
            'normal'
        ],
        text_color: [
            p.ColorSpec,
            '#444444'
        ],
        text_alpha: [
            p.NumberSpec,
            1
        ],
        text_align: [
            p.TextAlign,
            'left'
        ],
        text_baseline: [
            p.TextBaseline,
            'bottom'
        ],
        text_line_height: [
            p.Number,
            1.2
        ]
    };
    exports.text = function (prefix) {
        if (prefix === void 0) {
            prefix = '';
        }
        return _gen_mixin(_text_mixin, prefix);
    };
    function create(configs) {
        var result = {};
        for (var _i = 0, configs_1 = configs; _i < configs_1.length; _i++) {
            var config = configs_1[_i];
            var _a = config.split(':'), kind = _a[0], prefix = _a[1];
            var mixin = void 0;
            switch (kind) {
            case 'line':
                mixin = exports.line;
                break;
            case 'fill':
                mixin = exports.fill;
                break;
            case 'text':
                mixin = exports.text;
                break;
            default:
                throw new Error('Unknown property mixin kind \'' + kind + '\'');
            }
            object_1.extend(result, mixin(prefix));
        }
        return result;
    }
    exports.create = create;    
},
/*core/selection_manager*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    var has_props_1 = require(8    /* ./has_props */);
    var selector_1 = require(18    /* ./selector */);
    var hittest = require(9    /* ./hittest */);
    var p = require(15    /* ./properties */);
    var SelectionManager = function (_super) {
        tslib_1.__extends(SelectionManager, _super);
        function SelectionManager() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        SelectionManager.initClass = function () {
            this.prototype.type = 'SelectionManager';
            this.internal({ source: [p.Any] });
        };
        SelectionManager.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            this.selector = new selector_1.Selector();
            this.inspectors = {};
        };
        SelectionManager.prototype.select = function (renderer_views, geometry, final, append) {
            if (append === void 0) {
                append = false;
            }
            var did_hit = false;
            for (var _i = 0, renderer_views_1 = renderer_views; _i < renderer_views_1.length; _i++) {
                var r = renderer_views_1[_i];
                did_hit = did_hit || r.hit_test(geometry, final, append);
            }
            return did_hit;
        };
        SelectionManager.prototype.inspect = function (renderer_view, geometry) {
            var did_hit = false;
            did_hit = did_hit || renderer_view.hit_test(geometry, false, false, 'inspect');
            return did_hit;
        };
        SelectionManager.prototype.clear = function () {
            this.selector.clear();
            this.source.selected = hittest.create_hit_test_result();
        };
        SelectionManager.prototype.get_or_create_inspector = function (rmodel) {
            if (this.inspectors[rmodel.id] == null)
                this.inspectors[rmodel.id] = new selector_1.Selector();
            return this.inspectors[rmodel.id];
        };
        return SelectionManager;
    }(has_props_1.HasProps);
    exports.SelectionManager = SelectionManager;
    SelectionManager.initClass();    
},
/*core/selector*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    var has_props_1 = require(8    /* ./has_props */);
    var hittest_1 = require(9    /* ./hittest */);
    var p = require(15    /* ./properties */);
    var Selector = function (_super) {
        tslib_1.__extends(Selector, _super);
        function Selector() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Selector.initClass = function () {
            this.prototype.type = 'Selector';
            this.internal({
                indices: [
                    p.Any,
                    function () {
                        return new hittest_1.HitTestResult();
                    }
                ],
                final: [p.Boolean],
                timestamp: [p.Any]
            });
        };
        Selector.prototype.update = function (indices, final, append, silent) {
            if (silent === void 0) {
                silent = false;
            }
            this.setv({ timestamp: new Date() }, { silent: silent });
            this.setv({ final: final }, { silent: silent });
            if (append)
                indices.update_through_union(this.indices);
            this.setv({ indices: indices }, { silent: silent });
        };
        Selector.prototype.clear = function () {
            this.timestamp = new Date();
            this.final = true;
            this.indices = new hittest_1.HitTestResult();
        };
        return Selector;
    }(has_props_1.HasProps);
    exports.Selector = Selector;
    Selector.initClass();    
},
/*core/settings*/
function _(require, module, exports) {
    var Settings = function () {
        function Settings() {
            this._dev = false;
        }
        Object.defineProperty(Settings.prototype, 'dev', {
            get: function () {
                return this._dev;
            },
            set: function (dev) {
                this._dev = dev;
            },
            enumerable: true,
            configurable: true
        });
        return Settings;
    }();
    exports.Settings = Settings;
    exports.settings = new Settings();    
},
/*core/signaling*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    var callback_1 = require(25    /* ./util/callback */);
    var array_1 = require(22    /* ./util/array */);
    var Signal = function () {
        function Signal(sender, name) {
            this.sender = sender;
            this.name = name;
        }
        Signal.prototype.connect = function (slot, context) {
            if (context === void 0) {
                context = null;
            }
            if (!receiversForSender.has(this.sender)) {
                receiversForSender.set(this.sender, []);
            }
            var receivers = receiversForSender.get(this.sender);
            if (findConnection(receivers, this, slot, context) != null) {
                return false;
            }
            var receiver = context || slot;
            if (!sendersForReceiver.has(receiver)) {
                sendersForReceiver.set(receiver, []);
            }
            var senders = sendersForReceiver.get(receiver);
            var connection = {
                signal: this,
                slot: slot,
                context: context
            };
            receivers.push(connection);
            senders.push(connection);
            return true;
        };
        Signal.prototype.disconnect = function (slot, context) {
            if (context === void 0) {
                context = null;
            }
            var receivers = receiversForSender.get(this.sender);
            if (receivers == null || receivers.length === 0) {
                return false;
            }
            var connection = findConnection(receivers, this, slot, context);
            if (connection == null) {
                return false;
            }
            var receiver = context || slot;
            var senders = sendersForReceiver.get(receiver);
            connection.signal = null;
            scheduleCleanup(receivers);
            scheduleCleanup(senders);
            return true;
        };
        Signal.prototype.emit = function (args) {
            var receivers = receiversForSender.get(this.sender) || [];
            for (var _i = 0, receivers_1 = receivers; _i < receivers_1.length; _i++) {
                var _a = receivers_1[_i], signal = _a.signal, slot = _a.slot, context = _a.context;
                if (signal === this) {
                    slot.call(context, args, this.sender);
                }
            }
        };
        return Signal;
    }();
    exports.Signal = Signal;
    (function (Signal) {
        function disconnectBetween(sender, receiver) {
            var receivers = receiversForSender.get(sender);
            if (receivers == null || receivers.length === 0)
                return;
            var senders = sendersForReceiver.get(receiver);
            if (senders == null || senders.length === 0)
                return;
            for (var _i = 0, senders_1 = senders; _i < senders_1.length; _i++) {
                var connection = senders_1[_i];
                if (connection.signal == null)
                    return;
                if (connection.signal.sender === sender)
                    connection.signal = null;
            }
            scheduleCleanup(receivers);
            scheduleCleanup(senders);
        }
        Signal.disconnectBetween = disconnectBetween;
        function disconnectSender(sender) {
            var receivers = receiversForSender.get(sender);
            if (receivers == null || receivers.length === 0)
                return;
            for (var _i = 0, receivers_2 = receivers; _i < receivers_2.length; _i++) {
                var connection = receivers_2[_i];
                if (connection.signal == null)
                    return;
                var receiver = connection.context || connection.slot;
                connection.signal = null;
                scheduleCleanup(sendersForReceiver.get(receiver));
            }
            scheduleCleanup(receivers);
        }
        Signal.disconnectSender = disconnectSender;
        function disconnectReceiver(receiver) {
            var senders = sendersForReceiver.get(receiver);
            if (senders == null || senders.length === 0)
                return;
            for (var _i = 0, senders_2 = senders; _i < senders_2.length; _i++) {
                var connection = senders_2[_i];
                if (connection.signal == null)
                    return;
                var sender = connection.signal.sender;
                connection.signal = null;
                scheduleCleanup(receiversForSender.get(sender));
            }
            scheduleCleanup(senders);
        }
        Signal.disconnectReceiver = disconnectReceiver;
        function disconnectAll(obj) {
            var receivers = receiversForSender.get(obj);
            if (receivers != null && receivers.length !== 0) {
                for (var _i = 0, receivers_3 = receivers; _i < receivers_3.length; _i++) {
                    var connection = receivers_3[_i];
                    connection.signal = null;
                }
                scheduleCleanup(receivers);
            }
            var senders = sendersForReceiver.get(obj);
            if (senders != null && senders.length !== 0) {
                for (var _a = 0, senders_3 = senders; _a < senders_3.length; _a++) {
                    var connection = senders_3[_a];
                    connection.signal = null;
                }
                scheduleCleanup(senders);
            }
        }
        Signal.disconnectAll = disconnectAll;
    }(Signal = exports.Signal || (exports.Signal = {})));
    exports.Signal = Signal;
    function Signalable(Base) {
        // XXX: `class Foo extends Signalable(Object)` doesn't work (compiles, but fails at runtime), so
        // we have to do this to allow signalable classes without an explict base class.
        if (Base != null) {
            return function (_super) {
                tslib_1.__extends(class_1, _super);
                function class_1() {
                    return _super !== null && _super.apply(this, arguments) || this;
                }
                class_1.prototype.connect = function (signal, slot) {
                    return signal.connect(slot, this);
                };
                return class_1;
            }(Base);
        } else {
            return function () {
                function class_2() {
                }
                class_2.prototype.connect = function (signal, slot) {
                    return signal.connect(slot, this);
                };
                return class_2;
            }();
        }
    }
    exports.Signalable = Signalable;
    var _Signalable;
    (function (_Signalable) {
        function connect(signal, slot) {
            return signal.connect(slot, this);
        }
        _Signalable.connect = connect;
    }(_Signalable = exports._Signalable || (exports._Signalable = {})));
    var receiversForSender = new WeakMap();
    var sendersForReceiver = new WeakMap();
    function findConnection(conns, signal, slot, context) {
        return array_1.find(conns, function (conn) {
            return conn.signal === signal && conn.slot === slot && conn.context === context;
        });
    }
    var dirtySet = new Set();
    function scheduleCleanup(connections) {
        if (dirtySet.size === 0) {
            callback_1.defer(cleanupDirtySet);
        }
        dirtySet.add(connections);
    }
    function cleanupDirtySet() {
        dirtySet.forEach(function (connections) {
            array_1.removeBy(connections, function (connection) {
                return connection.signal == null;
            });
        });
        dirtySet.clear();
    }    
},
/*core/ui_events*/
function _(require, module, exports) {
    /* XXX: partial */
    var Hammer = require(323    /* hammerjs */);
    var signaling_1 = require(20    /* ./signaling */);
    var logging_1 = require(14    /* ./logging */);
    var dom_1 = require(5    /* ./dom */);
    var wheel_1 = require(44    /* ./util/wheel */);
    var array_1 = require(22    /* ./util/array */);
    var object_1 = require(31    /* ./util/object */);
    var bokeh_events_1 = require(3    /* ./bokeh_events */);
    var UIEvents = function () {
        // new (plot_view: PlotCanvasView, toolbar: Toolbar, hit_area: Element, plot: Plot)
        function UIEvents(plot_view, toolbar, hit_area, plot) {
            this.plot_view = plot_view;
            this.toolbar = toolbar;
            this.hit_area = hit_area;
            this.plot = plot;
            this.tap = new signaling_1.Signal(this, 'tap');
            this.doubletap = new signaling_1.Signal(this, 'doubletap');
            this.press = new signaling_1.Signal(this, 'press');
            this.pan_start = new signaling_1.Signal(this, 'pan:start');
            this.pan = new signaling_1.Signal(this, 'pan');
            this.pan_end = new signaling_1.Signal(this, 'pan:end');
            this.pinch_start = new signaling_1.Signal(this, 'pinch:start');
            this.pinch = new signaling_1.Signal(this, 'pinch');
            this.pinch_end = new signaling_1.Signal(this, 'pinch:end');
            this.rotate_start = new signaling_1.Signal(this, 'rotate:start');
            this.rotate = new signaling_1.Signal(this, 'rotate');
            this.rotate_end = new signaling_1.Signal(this, 'rotate:end');
            this.move_enter = new signaling_1.Signal(this, 'move:enter');
            this.move = new signaling_1.Signal(this, 'move');
            this.move_exit = new signaling_1.Signal(this, 'move:exit');
            this.scroll = new signaling_1.Signal(this, 'scroll');
            this.keydown = new signaling_1.Signal(this, 'keydown');
            this.keyup = new signaling_1.Signal(this, 'keyup');
            this._configure_hammerjs();
        }
        UIEvents.prototype._configure_hammerjs = function () {
            var _this = this;
            this.hammer = new Hammer(this.hit_area);
            // This is to be able to distinguish double taps from single taps
            this.hammer.get('doubletap').recognizeWith('tap');
            this.hammer.get('tap').requireFailure('doubletap');
            this.hammer.get('doubletap').dropRequireFailure('tap');
            this.hammer.on('doubletap', function (e) {
                return _this._doubletap(e);
            });
            this.hammer.on('tap', function (e) {
                return _this._tap(e);
            });
            this.hammer.on('press', function (e) {
                return _this._press(e);
            });
            this.hammer.get('pan').set({ direction: Hammer.DIRECTION_ALL });
            this.hammer.on('panstart', function (e) {
                return _this._pan_start(e);
            });
            this.hammer.on('pan', function (e) {
                return _this._pan(e);
            });
            this.hammer.on('panend', function (e) {
                return _this._pan_end(e);
            });
            this.hammer.get('pinch').set({ enable: true });
            this.hammer.on('pinchstart', function (e) {
                return _this._pinch_start(e);
            });
            this.hammer.on('pinch', function (e) {
                return _this._pinch(e);
            });
            this.hammer.on('pinchend', function (e) {
                return _this._pinch_end(e);
            });
            this.hammer.get('rotate').set({ enable: true });
            this.hammer.on('rotatestart', function (e) {
                return _this._rotate_start(e);
            });
            this.hammer.on('rotate', function (e) {
                return _this._rotate(e);
            });
            this.hammer.on('rotateend', function (e) {
                return _this._rotate_end(e);
            });
            this.hit_area.addEventListener('mousemove', function (e) {
                return _this._mouse_move(e);
            });
            this.hit_area.addEventListener('mouseenter', function (e) {
                return _this._mouse_enter(e);
            });
            this.hit_area.addEventListener('mouseleave', function (e) {
                return _this._mouse_exit(e);
            });
            this.hit_area.addEventListener('wheel', function (e) {
                return _this._mouse_wheel(e);
            });
            document.addEventListener('keydown', function (e) {
                return _this._key_down(e);
            });
            return document.addEventListener('keyup', function (e) {
                return _this._key_up(e);
            });
        };
        UIEvents.prototype.register_tool = function (tool_view, event_type, shared) {
            if (shared === void 0) {
                shared = true;
            }
            var e;
            var et = event_type || tool_view.model.event_type;
            if (et != null && !(typeof et === 'string')) {
                for (var index = 0; index < et.length; index++) {
                    e = et[index];
                    // Multi-tools should only registered shared events once
                    this.register_tool(tool_view, e, index < 1);
                }
                return;
            }
            var id = tool_view.model.id;
            var type = tool_view.model.type;
            // tool_viewbar button events handled by tool_view manager
            if (et == null) {
                logging_1.logger.debug('Button tool: ' + type);
                return;
            }
            var v = tool_view;
            switch (et) {
            case 'pan':
                if (v._pan_start != null) {
                    v.connect(this.pan_start, function (x) {
                        if (x.id === id) {
                            return v._pan_start(x.e);
                        }
                    });
                }
                if (v._pan != null) {
                    v.connect(this.pan, function (x) {
                        if (x.id === id) {
                            return v._pan(x.e);
                        }
                    });
                }
                if (v._pan_end != null) {
                    v.connect(this.pan_end, function (x) {
                        if (x.id === id) {
                            return v._pan_end(x.e);
                        }
                    });
                }
                break;
            case 'pinch':
                if (v._pinch_start != null) {
                    v.connect(this.pinch_start, function (x) {
                        if (x.id === id) {
                            return v._pinch_start(x.e);
                        }
                    });
                }
                if (v._pinch != null) {
                    v.connect(this.pinch, function (x) {
                        if (x.id === id) {
                            return v._pinch(x.e);
                        }
                    });
                }
                if (v._pinch_end != null) {
                    v.connect(this.pinch_end, function (x) {
                        if (x.id === id) {
                            return v._pinch_end(x.e);
                        }
                    });
                }
                break;
            case 'rotate':
                if (v._rotate_start != null) {
                    v.connect(this.rotate_start, function (x) {
                        if (x.id === id) {
                            return v._rotate_start(x.e);
                        }
                    });
                }
                if (v._rotate != null) {
                    v.connect(this.rotate, function (x) {
                        if (x.id === id) {
                            return v._rotate(x.e);
                        }
                    });
                }
                if (v._rotate_end != null) {
                    v.connect(this.rotate_end, function (x) {
                        if (x.id === id) {
                            return v._rotate_end(x.e);
                        }
                    });
                }
                break;
            case 'move':
                if (v._move_enter != null) {
                    v.connect(this.move_enter, function (x) {
                        if (x.id === id) {
                            return v._move_enter(x.e);
                        }
                    });
                }
                if (v._move != null) {
                    v.connect(this.move, function (x) {
                        if (x.id === id) {
                            return v._move(x.e);
                        }
                    });
                }
                if (v._move_exit != null) {
                    v.connect(this.move_exit, function (x) {
                        if (x.id === id) {
                            return v._move_exit(x.e);
                        }
                    });
                }
                break;
            case 'tap':
                if (v._tap != null) {
                    v.connect(this.tap, function (x) {
                        if (x.id === id) {
                            return v._tap(x.e);
                        }
                    });
                }
                break;
            case 'press':
                if (v._press != null) {
                    v.connect(this.press, function (x) {
                        if (x.id === id) {
                            return v._press(x.e);
                        }
                    });
                }
                break;
            case 'scroll':
                if (v._scroll != null) {
                    v.connect(this.scroll, function (x) {
                        if (x.id === id) {
                            return v._scroll(x.e);
                        }
                    });
                }
                break;
            default:
                throw new Error('unsupported event_type: ' + et);
            }
            // Skip shared events if registering multi-tool
            if (!shared) {
                return;
            }
            if (v._doubletap != null) {
                v.connect(this.doubletap, function (x) {
                    return v._doubletap(x.e);
                });
            }
            if (v._keydown != null) {
                v.connect(this.keydown, function (x) {
                    return v._keydown(x.e);
                });
            }
            if (v._keyup != null) {
                v.connect(this.keyup, function (x) {
                    return v._keyup(x.e);
                });
            }
            // Dual touch hack part 1/2
            // This is a hack for laptops with touch screen who may be pinching or scrolling
            // in order to use the wheel zoom tool. If it's a touch screen the WheelZoomTool event
            // will be linked to pinch. But we also want to trigger in the case of a scroll.
            if ('ontouchstart' in window || navigator.maxTouchPoints > 0) {
                if (et === 'pinch') {
                    logging_1.logger.debug('Registering scroll on touch screen');
                    return v.connect(this.scroll, function (x) {
                        if (x.id === id) {
                            return v._scroll(x.e);
                        }
                    });
                }
            }
        };
        UIEvents.prototype._hit_test_renderers = function (sx, sy) {
            var iterable = this.plot_view.get_renderer_views();
            for (var i = iterable.length - 1; i >= 0; i--) {
                var view = iterable[i];
                if (array_1.includes([
                        'annotation',
                        'overlay'
                    ], view.model.level) && view.bbox != null) {
                    if (view.bbox().contains(sx, sy)) {
                        return view;
                    }
                }
            }
            return null;
        };
        UIEvents.prototype._hit_test_frame = function (sx, sy) {
            return this.plot_view.frame.bbox.contains(sx, sy);
        };
        UIEvents.prototype._trigger = function (signal, e) {
            var _this = this;
            var event_type = signal.name;
            var base_type = event_type.split(':')[0];
            var view = this._hit_test_renderers(e.bokeh.sx, e.bokeh.sy);
            switch (base_type) {
            case 'move': {
                    var active_gesture = this.toolbar.gestures[base_type].active;
                    if (active_gesture != null)
                        this.trigger(signal, e, active_gesture.id);
                    var active_inspectors = this.toolbar.inspectors.filter(function (t) {
                        return t.active;
                    });
                    var cursor = 'default';
                    // the event happened on a renderer
                    if (view != null) {
                        if (view.model.cursor != null) {
                            cursor = view.model.cursor();
                        }
                        if (!object_1.isEmpty(active_inspectors)) {
                            // override event_type to cause inspectors to clear overlays
                            signal = this.move_exit;
                            event_type = signal.name;
                        }    // the event happened on the plot frame but off a renderer
                    } else if (this._hit_test_frame(e.bokeh.sx, e.bokeh.sy)) {
                        if (!object_1.isEmpty(active_inspectors)) {
                            cursor = 'crosshair';
                        }
                    }
                    this.plot_view.set_cursor(cursor);
                    active_inspectors.map(function (inspector) {
                        return _this.trigger(signal, e, inspector.id);
                    });
                    break;
                }
            case 'tap': {
                    if (view != null) {
                        if (typeof view.on_hit === 'function') {
                            view.on_hit(e.bokeh.sx, e.bokeh.sy);
                        }
                    }
                    var active_gesture = this.toolbar.gestures[base_type].active;
                    if (active_gesture != null) {
                        this.trigger(signal, e, active_gesture.id);
                    }
                    break;
                }
            case 'scroll': {
                    // Dual touch hack part 2/2
                    // This is a hack for laptops with touch screen who may be pinching or scrolling
                    // in order to use the wheel zoom tool. If it's a touch screen the WheelZoomTool event
                    // will be linked to pinch. But we also want to trigger in the case of a scroll.
                    var base = 'ontouchstart' in window || navigator.maxTouchPoints > 0 ? 'pinch' : 'scroll';
                    var active_gesture = this.toolbar.gestures[base].active;
                    if (active_gesture != null) {
                        e.preventDefault();
                        e.stopPropagation();
                        this.trigger(signal, e, active_gesture.id);
                    }
                    break;
                }
            default: {
                    var active_gesture = this.toolbar.gestures[base_type].active;
                    if (active_gesture != null)
                        this.trigger(signal, e, active_gesture.id);
                }
            }
        };
        UIEvents.prototype.trigger = function (signal, event, id) {
            if (id === void 0) {
                id = null;
            }
            return signal.emit({
                id: id,
                e: event
            });
        };
        UIEvents.prototype._event_sxy = function (event) {
            var _a = dom_1.offset(this.hit_area), left = _a.left, top = _a.top;
            return {
                sx: event.pageX - left,
                sy: event.pageY - top
            };
        };
        UIEvents.prototype._bokify_hammer = function (e, extras) {
            if (extras === void 0) {
                extras = {};
            }
            e.bokeh = object_1.extend(this._event_sxy(e.srcEvent), extras);
            var event_cls = bokeh_events_1.BokehEvent.event_class(e);
            if (event_cls != null) {
                return this.plot.trigger_event(event_cls.from_event(e));
            } else {
                return logging_1.logger.debug('Unhandled event of type ' + e.type);
            }
        };
        UIEvents.prototype._bokify_point_event = function (e, extras) {
            if (extras === void 0) {
                extras = {};
            }
            e.bokeh = object_1.extend(this._event_sxy(e), extras);
            var event_cls = bokeh_events_1.BokehEvent.event_class(e);
            if (event_cls != null) {
                return this.plot.trigger_event(event_cls.from_event(e));
            } else {
                return logging_1.logger.debug('Unhandled event of type ' + e.type);
            }
        };
        UIEvents.prototype._tap = function (e) {
            this._bokify_hammer(e);
            return this._trigger(this.tap, e);
        };
        UIEvents.prototype._doubletap = function (e) {
            // NOTE: doubletap event triggered unconditionally
            this._bokify_hammer(e);
            return this.trigger(this.doubletap, e);
        };
        UIEvents.prototype._press = function (e) {
            this._bokify_hammer(e);
            return this._trigger(this.press, e);
        };
        UIEvents.prototype._pan_start = function (e) {
            this._bokify_hammer(e);
            // back out delta to get original center point
            e.bokeh.sx -= e.deltaX;
            e.bokeh.sy -= e.deltaY;
            return this._trigger(this.pan_start, e);
        };
        UIEvents.prototype._pan = function (e) {
            this._bokify_hammer(e);
            return this._trigger(this.pan, e);
        };
        UIEvents.prototype._pan_end = function (e) {
            this._bokify_hammer(e);
            return this._trigger(this.pan_end, e);
        };
        UIEvents.prototype._pinch_start = function (e) {
            this._bokify_hammer(e);
            return this._trigger(this.pinch_start, e);
        };
        UIEvents.prototype._pinch = function (e) {
            this._bokify_hammer(e);
            return this._trigger(this.pinch, e);
        };
        UIEvents.prototype._pinch_end = function (e) {
            this._bokify_hammer(e);
            return this._trigger(this.pinch_end, e);
        };
        UIEvents.prototype._rotate_start = function (e) {
            this._bokify_hammer(e);
            return this._trigger(this.rotate_start, e);
        };
        UIEvents.prototype._rotate = function (e) {
            this._bokify_hammer(e);
            return this._trigger(this.rotate, e);
        };
        UIEvents.prototype._rotate_end = function (e) {
            this._bokify_hammer(e);
            return this._trigger(this.rotate_end, e);
        };
        UIEvents.prototype._mouse_enter = function (e) {
            this._bokify_point_event(e);
            return this._trigger(this.move_enter, e);
        };
        UIEvents.prototype._mouse_move = function (e) {
            this._bokify_point_event(e);
            return this._trigger(this.move, e);
        };
        UIEvents.prototype._mouse_exit = function (e) {
            this._bokify_point_event(e);
            return this._trigger(this.move_exit, e);
        };
        UIEvents.prototype._mouse_wheel = function (e) {
            this._bokify_point_event(e, { delta: wheel_1.getDeltaY(e) });
            return this._trigger(this.scroll, e);
        };
        UIEvents.prototype._key_down = function (e) {
            // NOTE: keyup event triggered unconditionally
            return this.trigger(this.keydown, e);
        };
        UIEvents.prototype._key_up = function (e) {
            // NOTE: keyup event triggered unconditionally
            return this.trigger(this.keyup, e);
        };
        return UIEvents;
    }();
    exports.UIEvents = UIEvents;    
},
/*core/util/array*/
function _(require, module, exports) {
    var math_1 = require(30    /* ./math */);
    var assert_1 = require(23    /* ./assert */);
    var slice = Array.prototype.slice;
    function head(array) {
        return array[0];
    }
    exports.head = head;
    function tail(array) {
        return array[array.length - 1];
    }
    exports.tail = tail;
    function last(array) {
        return array[array.length - 1];
    }
    exports.last = last;
    function copy(array) {
        return slice.call(array);
    }
    exports.copy = copy;
    function concat(arrays) {
        return (_a = []).concat.apply(_a, arrays);
        var _a;
    }
    exports.concat = concat;
    function includes(array, value) {
        return array.indexOf(value) !== -1;
    }
    exports.includes = includes;
    exports.contains = includes;
    function nth(array, index) {
        return array[index >= 0 ? index : array.length + index];
    }
    exports.nth = nth;
    function zip(As, Bs) {
        var n = Math.min(As.length, Bs.length);
        var ABs = new Array(n);
        for (var i = 0; i < n; i++) {
            ABs[i] = [
                As[i],
                Bs[i]
            ];
        }
        return ABs;
    }
    exports.zip = zip;
    function unzip(ABs) {
        var n = ABs.length;
        var As = new Array(n);
        var Bs = new Array(n);
        for (var i = 0; i < n; i++) {
            _a = ABs[i], As[i] = _a[0], Bs[i] = _a[1];
        }
        return [
            As,
            Bs
        ];
        var _a;
    }
    exports.unzip = unzip;
    function range(start, stop, step) {
        if (step === void 0) {
            step = 1;
        }
        assert_1.assert(step > 0, '\'step\' must be a positive number');
        if (stop == null) {
            stop = start;
            start = 0;
        }
        var max = Math.max, ceil = Math.ceil, abs = Math.abs;
        var delta = start <= stop ? step : -step;
        var length = max(ceil(abs(stop - start) / step), 0);
        var range = Array(length);
        for (var i = 0; i < length; i++, start += delta) {
            range[i] = start;
        }
        return range;
    }
    exports.range = range;
    function linspace(start, stop, num) {
        if (num === void 0) {
            num = 100;
        }
        var step = (stop - start) / (num - 1);
        var array = new Array(num);
        for (var i = 0; i < num; i++) {
            array[i] = start + step * i;
        }
        return array;
    }
    exports.linspace = linspace;
    function transpose(array) {
        var rows = array.length;
        var cols = array[0].length;
        var transposed = [];
        for (var j = 0; j < cols; j++) {
            transposed[j] = [];
            for (var i = 0; i < rows; i++) {
                transposed[j][i] = array[i][j];
            }
        }
        return transposed;
    }
    exports.transpose = transpose;
    function sum(array) {
        return array.reduce(function (a, b) {
            return a + b;
        }, 0);
    }
    exports.sum = sum;
    function cumsum(array) {
        var result = [];
        array.reduce(function (a, b, i) {
            return result[i] = a + b;
        }, 0);
        return result;
    }
    exports.cumsum = cumsum;
    function min(array) {
        var value;
        var result = Infinity;
        for (var i = 0, length_1 = array.length; i < length_1; i++) {
            value = array[i];
            if (value < result) {
                result = value;
            }
        }
        return result;
    }
    exports.min = min;
    function minBy(array, key) {
        if (array.length == 0)
            throw new Error('minBy() called with an empty array');
        var result = array[0];
        var resultComputed = key(result);
        for (var i = 1, length_2 = array.length; i < length_2; i++) {
            var value = array[i];
            var computed = key(value);
            if (computed < resultComputed) {
                result = value;
                resultComputed = computed;
            }
        }
        return result;
    }
    exports.minBy = minBy;
    function max(array) {
        var value;
        var result = -Infinity;
        for (var i = 0, length_3 = array.length; i < length_3; i++) {
            value = array[i];
            if (value > result) {
                result = value;
            }
        }
        return result;
    }
    exports.max = max;
    function maxBy(array, key) {
        if (array.length == 0)
            throw new Error('maxBy() called with an empty array');
        var result = array[0];
        var resultComputed = key(result);
        for (var i = 1, length_4 = array.length; i < length_4; i++) {
            var value = array[i];
            var computed = key(value);
            if (computed > resultComputed) {
                result = value;
                resultComputed = computed;
            }
        }
        return result;
    }
    exports.maxBy = maxBy;
    function argmin(array) {
        return minBy(range(array.length), function (i) {
            return array[i];
        });
    }
    exports.argmin = argmin;
    function argmax(array) {
        return maxBy(range(array.length), function (i) {
            return array[i];
        });
    }
    exports.argmax = argmax;
    function all(array, predicate) {
        for (var _i = 0, array_1 = array; _i < array_1.length; _i++) {
            var item = array_1[_i];
            if (!predicate(item))
                return false;
        }
        return true;
    }
    exports.all = all;
    function any(array, predicate) {
        for (var _i = 0, array_2 = array; _i < array_2.length; _i++) {
            var item = array_2[_i];
            if (predicate(item))
                return true;
        }
        return false;
    }
    exports.any = any;
    function findIndexFactory(dir) {
        return function (array, predicate) {
            var length = array.length;
            var index = dir > 0 ? 0 : length - 1;
            for (; index >= 0 && index < length; index += dir) {
                if (predicate(array[index]))
                    return index;
            }
            return -1;
        };
    }
    exports.findIndex = findIndexFactory(1);
    exports.findLastIndex = findIndexFactory(-1);
    function find(array, predicate) {
        var index = exports.findIndex(array, predicate);
        return index == -1 ? undefined : array[index];
    }
    exports.find = find;
    function findLast(array, predicate) {
        var index = exports.findLastIndex(array, predicate);
        return index == -1 ? undefined : array[index];
    }
    exports.findLast = findLast;
    function sortedIndex(array, value) {
        var low = 0;
        var high = array.length;
        while (low < high) {
            var mid = Math.floor((low + high) / 2);
            if (array[mid] < value)
                low = mid + 1;
            else
                high = mid;
        }
        return low;
    }
    exports.sortedIndex = sortedIndex;
    function sortBy(array, key) {
        var tmp = array.map(function (value, index) {
            return {
                value: value,
                index: index,
                key: key(value)
            };
        });
        tmp.sort(function (left, right) {
            var a = left.key;
            var b = right.key;
            if (a !== b) {
                if (a > b || a === undefined)
                    return 1;
                if (a < b || b === undefined)
                    return -1;
            }
            return left.index - right.index;
        });
        return tmp.map(function (item) {
            return item.value;
        });
    }
    exports.sortBy = sortBy;
    function uniq(array) {
        var result = [];
        for (var _i = 0, array_3 = array; _i < array_3.length; _i++) {
            var value = array_3[_i];
            if (!includes(result, value)) {
                result.push(value);
            }
        }
        return result;
    }
    exports.uniq = uniq;
    function uniqBy(array, key) {
        var result = [];
        var seen = [];
        for (var _i = 0, array_4 = array; _i < array_4.length; _i++) {
            var value = array_4[_i];
            var computed = key(value);
            if (!includes(seen, computed)) {
                seen.push(computed);
                result.push(value);
            }
        }
        return result;
    }
    exports.uniqBy = uniqBy;
    function union() {
        var arrays = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            arrays[_i] = arguments[_i];
        }
        return uniq(concat(arrays));
    }
    exports.union = union;
    function intersection(array) {
        var arrays = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            arrays[_i - 1] = arguments[_i];
        }
        var result = [];
        top:
            for (var _a = 0, array_5 = array; _a < array_5.length; _a++) {
                var item = array_5[_a];
                if (includes(result, item))
                    continue;
                for (var _b = 0, arrays_1 = arrays; _b < arrays_1.length; _b++) {
                    var other = arrays_1[_b];
                    if (!includes(other, item))
                        continue top;
                }
                result.push(item);
            }
        return result;
    }
    exports.intersection = intersection;
    function difference(array) {
        var arrays = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            arrays[_i - 1] = arguments[_i];
        }
        var rest = concat(arrays);
        return array.filter(function (value) {
            return !includes(rest, value);
        });
    }
    exports.difference = difference;
    function removeBy(array, key) {
        for (var i = 0; i < array.length;) {
            if (key(array[i]))
                array.splice(i, 1);
            else
                i++;
        }
    }
    exports.removeBy = removeBy;
    // Shuffle a collection, using the modern version of the
    // [Fisher-Yates shuffle](http://en.wikipedia.org/wiki/Fisher–Yates_shuffle).
    function shuffle(array) {
        var length = array.length;
        var shuffled = new Array(length);
        for (var i = 0; i < length; i++) {
            var rand = math_1.randomIn(0, i);
            if (rand !== i)
                shuffled[i] = shuffled[rand];
            shuffled[rand] = array[i];
        }
        return shuffled;
    }
    exports.shuffle = shuffle;
    function pairwise(array, fn) {
        var n = array.length;
        var result = new Array(n - 1);
        for (var i = 0; i < n - 1; i++) {
            result[i] = fn(array[i], array[i + 1]);
        }
        return result;
    }
    exports.pairwise = pairwise;
    function reversed(array) {
        var n = array.length;
        var result = new Array(n);
        for (var i = 0; i < n; i++) {
            result[n - i - 1] = array[i];
        }
        return result;
    }
    exports.reversed = reversed;
    function repeat(value, n) {
        var result = new Array(n);
        for (var i = 0; i < n; i++) {
            result[i] = value;
        }
        return result;
    }
    exports.repeat = repeat;
    function map(array, fn) {
        var n = array.length;
        var result = new Array(n);
        for (var i = 0; i < n; i++) {
            result[i] = fn(array[i]);
        }
        return result;
    }
    exports.map = map;    
},
/*core/util/assert*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    var AssertionError = function (_super) {
        tslib_1.__extends(AssertionError, _super);
        function AssertionError() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return AssertionError;
    }(Error);
    exports.AssertionError = AssertionError;
    function assert(condition, message) {
        if (condition === true || condition !== false && condition())
            return;
        throw new AssertionError(message || 'Assertion failed');
    }
    exports.assert = assert;    
},
/*core/util/bbox*/
function _(require, module, exports) {
    var min = Math.min, max = Math.max;
    function empty() {
        return {
            minX: Infinity,
            minY: Infinity,
            maxX: -Infinity,
            maxY: -Infinity
        };
    }
    exports.empty = empty;
    function positive_x() {
        return {
            minX: Number.MIN_VALUE,
            minY: -Infinity,
            maxX: Infinity,
            maxY: Infinity
        };
    }
    exports.positive_x = positive_x;
    function positive_y() {
        return {
            minX: -Infinity,
            minY: Number.MIN_VALUE,
            maxX: Infinity,
            maxY: Infinity
        };
    }
    exports.positive_y = positive_y;
    function union(a, b) {
        return {
            minX: min(a.minX, b.minX),
            maxX: max(a.maxX, b.maxX),
            minY: min(a.minY, b.minY),
            maxY: max(a.maxY, b.maxY)
        };
    }
    exports.union = union;
    var BBox = function () {
        function BBox(box) {
            if ('x0' in box && 'y0' in box && 'x1' in box && 'y1' in box) {
                var _a = box, x0 = _a.x0, y0 = _a.y0, x1 = _a.x1, y1 = _a.y1;
                if (!(x0 <= x1 && y0 <= y1))
                    throw new Error('invalid bbox {x0: ' + x0 + ', y0: ' + y0 + ', x1: ' + x1 + ', y1: ' + y1 + '}');
                this.x0 = x0;
                this.y0 = y0;
                this.x1 = x1;
                this.y1 = y1;
            } else {
                var _b = box, x = _b.x, y = _b.y, width = _b.width, height = _b.height;
                if (!(width >= 0 && height >= 0))
                    throw new Error('invalid bbox {x: ' + x + ', y: ' + y + ', width: ' + width + ', height: ' + height + '}');
                this.x0 = x;
                this.y0 = y;
                this.x1 = x + width;
                this.y1 = y + height;
            }
        }
        Object.defineProperty(BBox.prototype, 'minX', {
            get: function () {
                return this.x0;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, 'minY', {
            get: function () {
                return this.y0;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, 'maxX', {
            get: function () {
                return this.x1;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, 'maxY', {
            get: function () {
                return this.y1;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, 'left', {
            get: function () {
                return this.x0;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, 'top', {
            get: function () {
                return this.y0;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, 'right', {
            get: function () {
                return this.x1;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, 'bottom', {
            get: function () {
                return this.y1;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, 'p0', {
            get: function () {
                return [
                    this.x0,
                    this.y0
                ];
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, 'p1', {
            get: function () {
                return [
                    this.x1,
                    this.y1
                ];
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, 'x', {
            get: function () {
                return this.x0;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, 'y', {
            get: function () {
                return this.y0;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, 'width', {
            get: function () {
                return this.x1 - this.x0;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, 'height', {
            get: function () {
                return this.y1 - this.y0;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, 'rect', {
            get: function () {
                return {
                    x: this.x,
                    y: this.y,
                    width: this.width,
                    height: this.height
                };
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, 'h_range', {
            get: function () {
                return {
                    start: this.x0,
                    end: this.x1
                };
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, 'v_range', {
            get: function () {
                return {
                    start: this.y0,
                    end: this.y1
                };
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, 'ranges', {
            get: function () {
                return [
                    this.h_range,
                    this.v_range
                ];
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(BBox.prototype, 'aspect', {
            get: function () {
                return this.width / this.height;
            },
            enumerable: true,
            configurable: true
        });
        BBox.prototype.contains = function (x, y) {
            return x >= this.x0 && x <= this.x1 && y >= this.y0 && y <= this.y1;
        };
        BBox.prototype.clip = function (x, y) {
            if (x < this.x0)
                x = this.x0;
            else if (x > this.x1)
                x = this.x1;
            if (y < this.y0)
                y = this.y0;
            else if (y > this.y1)
                y = this.y1;
            return [
                x,
                y
            ];
        };
        BBox.prototype.union = function (that) {
            return new BBox({
                x0: min(this.x0, that.x0),
                y0: min(this.y0, that.y0),
                x1: max(this.x1, that.x1),
                y1: max(this.y1, that.y1)
            });
        };
        return BBox;
    }();
    exports.BBox = BBox;    
},
/*core/util/callback*/
function _(require, module, exports) {
    function delay(func, wait) {
        return setTimeout(func, wait);
    }
    exports.delay = delay;
    var _defer = typeof requestAnimationFrame === 'function' ? requestAnimationFrame : setImmediate;
    function defer(func) {
        return _defer(func);
    }
    exports.defer = defer;
    function throttle(func, wait, options) {
        if (options === void 0) {
            options = {};
        }
        var context, args, result;
        var timeout = null;
        var previous = 0;
        var later = function () {
            previous = options.leading === false ? 0 : Date.now();
            timeout = null;
            result = func.apply(context, args);
            if (!timeout)
                context = args = null;
        };
        return function () {
            var now = Date.now();
            if (!previous && options.leading === false)
                previous = now;
            var remaining = wait - (now - previous);
            context = this;
            args = arguments;
            if (remaining <= 0 || remaining > wait) {
                if (timeout) {
                    clearTimeout(timeout);
                    timeout = null;
                }
                previous = now;
                result = func.apply(context, args);
                if (!timeout)
                    context = args = null;
            } else if (!timeout && options.trailing !== false) {
                timeout = setTimeout(later, remaining);
            }
            return result;
        };
    }
    exports.throttle = throttle;
    function once(func) {
        var done = false;
        var memo;
        return function () {
            if (!done) {
                done = true;
                memo = func();
            }
            return memo;
        };
    }
    exports.once = once;    
},
/*core/util/canvas*/
function _(require, module, exports) {
    function fixup_line_dash(ctx) {
        if (!ctx.setLineDash) {
            ctx.setLineDash = function (dash) {
                ctx.mozDash = dash;
                ctx.webkitLineDash = dash;
            };
        }
        if (!ctx.getLineDash) {
            ctx.getLineDash = function () {
                return ctx.mozDash;
            };
        }
    }
    function fixup_line_dash_offset(ctx) {
        ctx.setLineDashOffset = function (offset) {
            ctx.lineDashOffset = offset;
            ctx.mozDashOffset = offset;
            ctx.webkitLineDashOffset = offset;
        };
        ctx.getLineDashOffset = function () {
            return ctx.mozDashOffset;
        };
    }
    function fixup_image_smoothing(ctx) {
        ctx.setImageSmoothingEnabled = function (value) {
            ctx.imageSmoothingEnabled = value;
            ctx.mozImageSmoothingEnabled = value;
            ctx.oImageSmoothingEnabled = value;
            ctx.webkitImageSmoothingEnabled = value;
            ctx.msImageSmoothingEnabled = value;
        };
        ctx.getImageSmoothingEnabled = function () {
            var val = ctx.imageSmoothingEnabled;
            return val != null ? val : true;
        };
    }
    function fixup_measure_text(ctx) {
        if (ctx.measureText && ctx.html5MeasureText == null) {
            ctx.html5MeasureText = ctx.measureText;
            ctx.measureText = function (text) {
                var textMetrics = ctx.html5MeasureText(text);
                // fake it til you make it
                textMetrics.ascent = ctx.html5MeasureText('m').width * 1.6;
                return textMetrics;
            };
        }
    }
    function fixup_ellipse(ctx) {
        // implementing the ctx.ellipse function with bezier curves
        // we don't implement the startAngle, endAngle and anticlockwise arguments.
        function ellipse_bezier(x, y, radiusX, radiusY, rotation, _startAngle, _endAngle, anticlockwise) {
            if (anticlockwise === void 0) {
                anticlockwise = false;
            }
            var c = 0.551784;
            // see http://www.tinaja.com/glib/ellipse4.pdf
            ctx.translate(x, y);
            ctx.rotate(rotation);
            var rx = radiusX;
            var ry = radiusY;
            if (anticlockwise) {
                rx = -radiusX;
                ry = -radiusY;
            }
            ctx.moveTo(-rx, 0);
            // start point of first curve
            ctx.bezierCurveTo(-rx, ry * c, -rx * c, ry, 0, ry);
            ctx.bezierCurveTo(rx * c, ry, rx, ry * c, rx, 0);
            ctx.bezierCurveTo(rx, -ry * c, rx * c, -ry, 0, -ry);
            ctx.bezierCurveTo(-rx * c, -ry, -rx, -ry * c, -rx, 0);
            ctx.rotate(-rotation);
            ctx.translate(-x, -y);
        }
        if (!ctx.ellipse)
            ctx.ellipse = ellipse_bezier;
    }
    function fixup_ctx(ctx) {
        fixup_line_dash(ctx);
        fixup_line_dash_offset(ctx);
        fixup_image_smoothing(ctx);
        fixup_measure_text(ctx);
        fixup_ellipse(ctx);
    }
    exports.fixup_ctx = fixup_ctx;
    function get_scale_ratio(ctx, hidpi, backend) {
        if (backend == 'svg')
            return 1;
        else if (hidpi) {
            var devicePixelRatio_1 = window.devicePixelRatio || 1;
            var backingStoreRatio = ctx.webkitBackingStorePixelRatio || ctx.mozBackingStorePixelRatio || ctx.msBackingStorePixelRatio || ctx.oBackingStorePixelRatio || ctx.backingStorePixelRatio || 1;
            return devicePixelRatio_1 / backingStoreRatio;
        } else
            return 1;
    }
    exports.get_scale_ratio = get_scale_ratio;    
},
/*core/util/color*/
function _(require, module, exports) {
    /* XXX: partial */
    var svg_colors = require(39    /* ./svg_colors */);
    var array_1 = require(22    /* ./array */);
    var _component2hex = function (v) {
        var h = Number(v).toString(16);
        return h = h.length === 1 ? '0' + h : h;
    };
    exports.color2hex = function (color) {
        color = color + '';
        if (color.indexOf('#') === 0) {
            return color;
        } else if (svg_colors[color] != null) {
            return svg_colors[color];
        } else if (color.indexOf('rgb') === 0) {
            var rgb = color.replace(/^rgba?\(|\s+|\)$/g, '').split(',');
            var hex = rgb.slice(0, 3).map(function (v) {
                return _component2hex(v);
            }).join('');
            if (rgb.length === 4) {
                hex = hex + _component2hex(Math.floor(parseFloat(rgb.slice(3)) * 255));
            }
            var hex_string = '#' + hex.slice(0, 8);
            // can also be rgba
            return hex_string;
        } else {
            return color;
        }
    };
    exports.color2rgba = function (color, alpha) {
        if (alpha === void 0) {
            alpha = 1;
        }
        if (!color) {
            return [
                0,
                0,
                0,
                0
            ];    // transparent
        }
        // Convert to hex and then to clean version of 6 or 8 chars
        var hex = exports.color2hex(color);
        hex = hex.replace(/ |#/g, '');
        if (hex.length <= 4) {
            hex = hex.replace(/(.)/g, '$1$1');
        }
        // Convert pairs to numbers
        hex = hex.match(/../g);
        var rgba = hex.map(function (i) {
            return parseInt(i, 16) / 255;
        });
        // Ensure correct length, add alpha if necessary
        while (rgba.length < 3) {
            rgba.push(0);
        }
        if (rgba.length < 4) {
            rgba.push(alpha);
        }
        return rgba.slice(0, 4);    // return 4 elements
    };
    exports.valid_rgb = function (value) {
        var params;
        switch (value.substring(0, 4)) {
        case 'rgba': {
                params = {
                    start: 'rgba(',
                    len: 4,
                    alpha: true
                };
                break;
            }
        case 'rgb(': {
                params = {
                    start: 'rgb(',
                    len: 3,
                    alpha: false
                };
                break;
            }
        default:
            return false;
        }
        // if '.' and then ',' found, we know decimals are used on rgb
        if (new RegExp('.*?(\\.).*(,)').test(value)) {
            throw new Error('color expects integers for rgb in rgb/rgba tuple, received ' + value);
        }
        // extract the numerical values from inside parens
        var contents = value.replace(params.start, '').replace(')', '').split(',').map(parseFloat);
        // check length of array based on rgb/rgba
        if (contents.length !== params.len) {
            throw new Error('color expects rgba ' + params.len + '-tuple, received ' + value);
        }
        // check for valid numerical values for rgba
        if (params.alpha && !(0 <= contents[3] && contents[3] <= 1)) {
            throw new Error('color expects rgba 4-tuple to have alpha value between 0 and 1');
        }
        if (array_1.includes(contents.slice(0, 3).map(function (rgb) {
                return 0 <= rgb && rgb <= 255;
            }), false)) {
            throw new Error('color expects rgb to have value between 0 and 255');
        }
        return true;
    };    
},
/*core/util/data_structures*/
function _(require, module, exports) {
    var array_1 = require(22    /* ./array */);
    var eq_1 = require(29    /* ./eq */);
    var types_1 = require(43    /* ./types */);
    var MultiDict = function () {
        function MultiDict() {
            this._dict = {};
        }
        MultiDict.prototype._existing = function (key) {
            if (key in this._dict)
                return this._dict[key];
            else
                return null;
        };
        MultiDict.prototype.add_value = function (key, value) {
            /*
        if value == null
          throw new Error("Can't put null in this dict")
        if isArray(value)
          throw new Error("Can't put arrays in this dict")
        */
            var existing = this._existing(key);
            if (existing == null) {
                this._dict[key] = value;
            } else if (types_1.isArray(existing)) {
                existing.push(value);
            } else {
                this._dict[key] = [
                    existing,
                    value
                ];
            }
        };
        MultiDict.prototype.remove_value = function (key, value) {
            var existing = this._existing(key);
            if (types_1.isArray(existing)) {
                var new_array = array_1.difference(existing, [value]);
                if (new_array.length > 0)
                    this._dict[key] = new_array;
                else
                    delete this._dict[key];
            } else if (eq_1.isEqual(existing, value)) {
                delete this._dict[key];
            }
        };
        MultiDict.prototype.get_one = function (key, duplicate_error) {
            var existing = this._existing(key);
            if (types_1.isArray(existing)) {
                if (existing.length === 1)
                    return existing[0];
                else
                    throw new Error(duplicate_error);
            } else
                return existing;
        };
        return MultiDict;
    }();
    exports.MultiDict = MultiDict;
    var Set = function () {
        function Set(obj) {
            if (obj == null) {
                this.values = [];
            } else if (obj instanceof Set) {
                this.values = array_1.copy(obj.values);
            } else {
                this.values = this._compact(obj);
            }
        }
        Set.prototype._compact = function (array) {
            var newArray = [];
            for (var _i = 0, array_2 = array; _i < array_2.length; _i++) {
                var item = array_2[_i];
                if (newArray.indexOf(item) === -1) {
                    newArray.push(item);
                }
            }
            return newArray;
        };
        Set.prototype.push = function (item) {
            if (this.missing(item))
                this.values.push(item);
        };
        Set.prototype.remove = function (item) {
            var i = this.values.indexOf(item);
            this.values = this.values.slice(0, i).concat(this.values.slice(i + 1));
        };
        Set.prototype.length = function () {
            return this.values.length;
        };
        Set.prototype.includes = function (item) {
            return this.values.indexOf(item) != -1;
        };
        Set.prototype.missing = function (item) {
            return !this.includes(item);
        };
        Set.prototype.slice = function (from, to) {
            return this.values.slice(from, to);
        };
        Set.prototype.join = function (str) {
            return this.values.join(str);
        };
        Set.prototype.toString = function () {
            return this.join(', ');
        };
        Set.prototype.union = function (set) {
            set = new Set(set);
            return new Set(this.values.concat(set.values));
        };
        Set.prototype.intersect = function (set) {
            set = new Set(set);
            var newSet = new Set();
            for (var _i = 0, _a = set.values; _i < _a.length; _i++) {
                var item = _a[_i];
                if (this.includes(item) && set.includes(item))
                    newSet.push(item);
            }
            return newSet;
        };
        Set.prototype.diff = function (set) {
            set = new Set(set);
            var newSet = new Set();
            for (var _i = 0, _a = this.values; _i < _a.length; _i++) {
                var item = _a[_i];
                if (set.missing(item))
                    newSet.push(item);
            }
            return newSet;
        };
        return Set;
    }();
    exports.Set = Set;    
},
/*core/util/eq*/
function _(require, module, exports) {
    var types_1 = require(43    /* ./types */);
    var toString = Object.prototype.toString;
    // Internal recursive comparison function for `isEqual`.
    function eq(a, b, aStack, bStack) {
        // Identical objects are equal. `0 === -0`, but they aren't identical.
        // See the [Harmony `egal` proposal](http://wiki.ecmascript.org/doku.php?id=harmony:egal).
        if (a === b)
            return a !== 0 || 1 / a === 1 / b;
        // A strict comparison is necessary because `null == undefined`.
        if (a == null || b == null)
            return a === b;
        // Compare `[[Class]]` names.
        var className = toString.call(a);
        if (className !== toString.call(b))
            return false;
        switch (className) {
        // Strings, numbers, regular expressions, dates, and booleans are compared by value.
        case '[object RegExp]':
        // RegExps are coerced to strings for comparison (Note: '' + /a/i === '/a/i')
        case '[object String]':
            // Primitives and their corresponding object wrappers are equivalent; thus, `"5"` is
            // equivalent to `new String("5")`.
            return '' + a === '' + b;
        case '[object Number]':
            // `NaN`s are equivalent, but non-reflexive.
            // Object(NaN) is equivalent to NaN
            if (+a !== +a)
                return +b !== +b;
            // An `egal` comparison is performed for other numeric values.
            return +a === 0 ? 1 / +a === 1 / b : +a === +b;
        case '[object Date]':
        case '[object Boolean]':
            // Coerce dates and booleans to numeric primitive values. Dates are compared by their
            // millisecond representations. Note that invalid dates with millisecond representations
            // of `NaN` are not equivalent.
            return +a === +b;
        }
        var areArrays = className === '[object Array]';
        if (!areArrays) {
            if (typeof a != 'object' || typeof b != 'object')
                return false;
            // Objects with different constructors are not equivalent, but `Object`s or `Array`s
            // from different frames are.
            var aCtor = a.constructor, bCtor = b.constructor;
            if (aCtor !== bCtor && !(types_1.isFunction(aCtor) && aCtor instanceof aCtor && types_1.isFunction(bCtor) && bCtor instanceof bCtor) && ('constructor' in a && 'constructor' in b)) {
                return false;
            }
        }
        // Assume equality for cyclic structures. The algorithm for detecting cyclic
        // structures is adapted from ES 5.1 section 15.12.3, abstract operation `JO`.
        // Initializing stack of traversed objects.
        // It's done here since we only need them for objects and arrays comparison.
        aStack = aStack || [];
        bStack = bStack || [];
        var length = aStack.length;
        while (length--) {
            // Linear search. Performance is inversely proportional to the number of
            // unique nested structures.
            if (aStack[length] === a)
                return bStack[length] === b;
        }
        // Add the first object to the stack of traversed objects.
        aStack.push(a);
        bStack.push(b);
        // Recursively compare objects and arrays.
        if (areArrays) {
            // Compare array lengths to determine if a deep comparison is necessary.
            length = a.length;
            if (length !== b.length)
                return false;
            // Deep compare the contents, ignoring non-numeric properties.
            while (length--) {
                if (!eq(a[length], b[length], aStack, bStack))
                    return false;
            }
        } else {
            // Deep compare objects.
            var keys = Object.keys(a);
            var key = void 0;
            length = keys.length;
            // Ensure that both objects contain the same number of properties before comparing deep equality.
            if (Object.keys(b).length !== length)
                return false;
            while (length--) {
                // Deep compare each member
                key = keys[length];
                if (!(b.hasOwnProperty(key) && eq(a[key], b[key], aStack, bStack)))
                    return false;
            }
        }
        // Remove the first object from the stack of traversed objects.
        aStack.pop();
        bStack.pop();
        return true;
    }
    // Perform a deep comparison to check if two objects are equal.
    function isEqual(a, b) {
        return eq(a, b);
    }
    exports.isEqual = isEqual;    
},
/*core/util/math*/
function _(require, module, exports) {
    function angle_norm(angle) {
        while (angle < 0) {
            angle += 2 * Math.PI;
        }
        while (angle > 2 * Math.PI) {
            angle -= 2 * Math.PI;
        }
        return angle;
    }
    exports.angle_norm = angle_norm;
    function angle_dist(lhs, rhs) {
        return Math.abs(angle_norm(lhs - rhs));
    }
    exports.angle_dist = angle_dist;
    function angle_between(mid, lhs, rhs, direction) {
        var norm_mid = angle_norm(mid);
        var d = angle_dist(lhs, rhs);
        var cond = angle_dist(lhs, norm_mid) <= d && angle_dist(norm_mid, rhs) <= d;
        if (direction == 'anticlock')
            return cond;
        else
            return !cond;
    }
    exports.angle_between = angle_between;
    function random() {
        return Math.random();
    }
    exports.random = random;
    function randomIn(min, max) {
        if (max == null) {
            max = min;
            min = 0;
        }
        return min + Math.floor(Math.random() * (max - min + 1));
    }
    exports.randomIn = randomIn;
    function atan2(start, end) {
        /*
     * Calculate the angle between a line containing start and end points (composed
     * of [x, y] arrays) and the positive x-axis.
     */
        return Math.atan2(end[1] - start[1], end[0] - start[0]);
    }
    exports.atan2 = atan2;
    // http://www2.econ.osaka-u.ac.jp/~tanizaki/class/2013/econome3/13.pdf (Page 432)
    function rnorm(mu, sigma) {
        // Generate a random normal with a mean of 0 and a sigma of 1
        var r1;
        var r2;
        while (true) {
            r1 = random();
            r2 = random();
            r2 = (2 * r2 - 1) * Math.sqrt(2 * (1 / Math.E));
            if (-4 * r1 * r1 * Math.log(r1) >= r2 * r2)
                break;
        }
        var rn = r2 / r1;
        // Transform the standard normal to meet the characteristics that we want (mu, sigma)
        rn = mu + sigma * rn;
        return rn;
    }
    exports.rnorm = rnorm;
    function clamp(val, min, max) {
        if (val > max)
            return max;
        if (val < min)
            return min;
        return val;
    }
    exports.clamp = clamp;    
},
/*core/util/object*/
function _(require, module, exports) {
    var array_1 = require(22    /* ./array */);
    exports.keys = Object.keys;
    function values(object) {
        var keys = Object.keys(object);
        var length = keys.length;
        var values = new Array(length);
        for (var i = 0; i < length; i++) {
            values[i] = object[keys[i]];
        }
        return values;
    }
    exports.values = values;
    function extend(dest) {
        var sources = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            sources[_i - 1] = arguments[_i];
        }
        for (var _a = 0, sources_1 = sources; _a < sources_1.length; _a++) {
            var source = sources_1[_a];
            for (var key in source) {
                if (source.hasOwnProperty(key)) {
                    dest[key] = source[key];
                }
            }
        }
        return dest;
    }
    exports.extend = extend;
    function clone(obj) {
        return extend({}, obj);
    }
    exports.clone = clone;
    function merge(obj1, obj2) {
        /*
     * Returns an object with the array values for obj1 and obj2 unioned by key.
     */
        var result = Object.create(Object.prototype);
        var keys = array_1.concat([
            Object.keys(obj1),
            Object.keys(obj2)
        ]);
        for (var _i = 0, keys_1 = keys; _i < keys_1.length; _i++) {
            var key = keys_1[_i];
            var arr1 = obj1.hasOwnProperty(key) ? obj1[key] : [];
            var arr2 = obj2.hasOwnProperty(key) ? obj2[key] : [];
            result[key] = array_1.union(arr1, arr2);
        }
        return result;
    }
    exports.merge = merge;
    function size(obj) {
        return Object.keys(obj).length;
    }
    exports.size = size;
    function isEmpty(obj) {
        return size(obj) === 0;
    }
    exports.isEmpty = isEmpty;    
},
/*core/util/proj4*/
function _(require, module, exports) {
    /* XXX: partial */
    var proj4 = require(350    /* proj4/lib/core */);
    exports.proj4 = proj4;
    var Proj = require(338    /* proj4/lib/Proj */);
    var toPoint = require(344    /* proj4/lib/common/toPoint */);
    var defs = require(354    /* proj4/lib/defs */);
    var transform = require(363    /* proj4/lib/transform */);
    proj4.defaultDatum = 'WGS84';
    // default datum
    proj4.WGS84 = new Proj('WGS84');
    proj4.Proj = Proj;
    proj4.toPoint = toPoint;
    proj4.defs = defs;
    proj4.transform = transform;
    exports.mercator = defs('GOOGLE');
    exports.wgs84 = defs('WGS84');
    exports.mercator_bounds = {
        lon: [
            -20026376.39,
            20026376.39
        ],
        lat: [
            -20048966.1,
            20048966.1
        ]
    };
    var latlon_bounds = {
        lon: [
            -180,
            180
        ],
        lat: [
            -85.06,
            85.06
        ]
    };
    exports.clip_mercator = function (low, high, dimension) {
        var _a = exports.mercator_bounds[dimension], min = _a[0], max = _a[1];
        return [
            Math.max(low, min),
            Math.min(high, max)
        ];
    };
    exports.in_bounds = function (value, dimension) {
        return value > latlon_bounds[dimension][0] && value < latlon_bounds[dimension][1];
    };    
},
/*core/util/projections*/
function _(require, module, exports) {
    var proj4_1 = require(32    /* ./proj4 */);
    function project_xy(x, y) {
        var n = Math.min(x.length, y.length);
        var merc_x_s = new Array(n);
        var merc_y_s = new Array(n);
        for (var i = 0; i < n; i++) {
            var _a = proj4_1.proj4(proj4_1.mercator, [
                    x[i],
                    y[i]
                ]), merc_x = _a[0], merc_y = _a[1];
            merc_x_s[i] = merc_x;
            merc_y_s[i] = merc_y;
        }
        return [
            merc_x_s,
            merc_y_s
        ];
    }
    exports.project_xy = project_xy;
    function project_xsys(xs, ys) {
        var n = Math.min(xs.length, ys.length);
        var merc_xs_s = new Array(n);
        var merc_ys_s = new Array(n);
        for (var i = 0; i < n; i++) {
            var _a = project_xy(xs[i], ys[i]), merc_x_s = _a[0], merc_y_s = _a[1];
            merc_xs_s[i] = merc_x_s;
            merc_ys_s[i] = merc_y_s;
        }
        return [
            merc_xs_s,
            merc_ys_s
        ];
    }
    exports.project_xsys = project_xsys;    
},
/*core/util/refs*/
function _(require, module, exports) {
    var types_1 = require(43    /* ./types */);
    // Create a Bokeh reference from a HasProps subclass
    //
    // @param obj [HasProps] the object to create a reference for
    // @return [Object] a Bokeh reference for `obj`
    // @throw Error if `obj` is not a HasProps
    //
    function create_ref(obj) {
        var ref = {
            type: obj.type,
            id: obj.id
        };
        if (obj._subtype != null) {
            ref.subtype = obj._subtype;
        }
        return ref;
    }
    exports.create_ref = create_ref;
    // Determine whether an object has the proper format of a Bokeh reference
    //
    // @param arg [Object] the object to test
    // @return [bool] whether the object is a refererence
    //
    // @note this function does not check that the id and types are valid,
    //   only that the format is correct (all required keys are present)
    //
    function is_ref(arg) {
        if (types_1.isObject(arg)) {
            var keys = Object.keys(arg).sort();
            if (keys.length == 2)
                return keys[0] == 'id' && keys[1] == 'type';
            if (keys.length == 3)
                return keys[0] == 'id' && keys[1] == 'subtype' && keys[2] == 'type';
        }
        return false;
    }
    exports.is_ref = is_ref;    
},
/*core/util/selection*/
function _(require, module, exports) {
    function get_indices(data_source) {
        var selected = data_source.selected;
        if (selected['0d'].glyph)
            return selected['0d'].indices;
        else if (selected['1d'].indices.length > 0)
            return selected['1d'].indices;
        else if (selected['2d'].indices.length > 0)
            return selected['2d'].indices;
        else
            return [];
    }
    exports.get_indices = get_indices;    
},
/*core/util/serialization*/
function _(require, module, exports) {
    /* XXX: partial */
    var types_1 = require(43    /* ./types */);
    var array_1 = require(22    /* ./array */);
    exports.ARRAY_TYPES = {
        float32: Float32Array,
        float64: Float64Array,
        uint8: Uint8Array,
        int8: Int8Array,
        uint16: Uint16Array,
        int16: Int16Array,
        uint32: Uint32Array,
        int32: Int32Array
    };
    exports.DTYPES = function () {
        var dtypes = {};
        for (var k in exports.ARRAY_TYPES) {
            var v = exports.ARRAY_TYPES[k];
            dtypes[v.name] = k;
        }
        return dtypes;
    }();
    exports.BYTE_ORDER = function () {
        // record endian-ness
        var buf = new ArrayBuffer(2);
        var buf8 = new Uint8Array(buf);
        var buf16 = new Uint16Array(buf);
        buf8[0] = 170;
        buf8[1] = 187;
        if (buf16[0] === 48042)
            return 'little';
        else
            return 'big';
    }();
    exports.swap16 = function (a) {
        var x = new Uint8Array(a.buffer, a.byteOffset, a.length * 2);
        for (var i = 0, end = x.length; i < end; i += 2) {
            var t = x[i];
            x[i] = x[i + 1];
            x[i + 1] = t;
        }
        return null;
    };
    exports.swap32 = function (a) {
        var x = new Uint8Array(a.buffer, a.byteOffset, a.length * 4);
        for (var i = 0, end = x.length; i < end; i += 4) {
            var t = x[i];
            x[i] = x[i + 3];
            x[i + 3] = t;
            t = x[i + 1];
            x[i + 1] = x[i + 2];
            x[i + 2] = t;
        }
        return null;
    };
    exports.swap64 = function (a) {
        var x = new Uint8Array(a.buffer, a.byteOffset, a.length * 8);
        for (var i = 0, end = x.length; i < end; i += 8) {
            var t = x[i];
            x[i] = x[i + 7];
            x[i + 7] = t;
            t = x[i + 1];
            x[i + 1] = x[i + 6];
            x[i + 6] = t;
            t = x[i + 2];
            x[i + 2] = x[i + 5];
            x[i + 5] = t;
            t = x[i + 3];
            x[i + 3] = x[i + 4];
            x[i + 4] = t;
        }
        return null;
    };
    exports.process_buffer = function (spec, buffers) {
        var need_swap = spec.order !== exports.BYTE_ORDER;
        var shape = spec.shape;
        var bytes = null;
        for (var _i = 0, buffers_1 = buffers; _i < buffers_1.length; _i++) {
            var buf = buffers_1[_i];
            var header = JSON.parse(buf[0]);
            if (header.id === spec.__buffer__) {
                bytes = buf[1];
                break;
            }
        }
        var arr = new exports.ARRAY_TYPES[spec.dtype](bytes);
        if (need_swap) {
            if (arr.BYTES_PER_ELEMENT === 2) {
                exports.swap16(arr);
            } else if (arr.BYTES_PER_ELEMENT === 4) {
                exports.swap32(arr);
            } else if (arr.BYTES_PER_ELEMENT === 8) {
                exports.swap64(arr);
            }
        }
        return [
            arr,
            shape
        ];
    };
    exports.process_array = function (obj, buffers) {
        if (types_1.isObject(obj) && '__ndarray__' in obj) {
            return exports.decode_base64(obj);
        } else if (types_1.isObject(obj) && '__buffer__' in obj) {
            return exports.process_buffer(obj, buffers);
        } else if (types_1.isArray(obj)) {
            return [
                obj,
                []
            ];
        }
    };
    exports.arrayBufferToBase64 = function (buffer) {
        var bytes = new Uint8Array(buffer);
        var binary = array_1.map(bytes, function (b) {
            return String.fromCharCode(b);
        });
        return btoa(binary.join(''));
    };
    exports.base64ToArrayBuffer = function (base64) {
        var binary_string = atob(base64);
        var len = binary_string.length;
        var bytes = new Uint8Array(len);
        for (var i = 0, end = len; i < end; i++) {
            bytes[i] = binary_string.charCodeAt(i);
        }
        return bytes.buffer;
    };
    exports.decode_base64 = function (input) {
        var array;
        var bytes = exports.base64ToArrayBuffer(input['__ndarray__']);
        var dtype = input['dtype'];
        if (dtype in exports.ARRAY_TYPES) {
            array = new exports.ARRAY_TYPES[dtype](bytes);
        }
        var shape = input['shape'];
        return [
            array,
            shape
        ];
    };
    exports.encode_base64 = function (array, shape) {
        var b64 = exports.arrayBufferToBase64(array.buffer);
        var dtype = exports.DTYPES[array.constructor.name];
        var data = {
            __ndarray__: b64,
            shape: shape,
            dtype: dtype
        };
        return data;
    };
    exports.decode_column_data = function (data, buffers) {
        if (buffers === void 0) {
            buffers = [];
        }
        var new_data = {};
        var new_shapes = {};
        for (var k in data) {
            // might be array of scalars, or might be ragged array or arrays
            var v = data[k];
            if (types_1.isArray(v)) {
                // v is just a regular array of scalars
                if (v.length === 0 || !(types_1.isObject(v[0]) || types_1.isArray(v[0]))) {
                    new_data[k] = v;
                    continue;
                }
                // v is a ragged array of arrays
                var arrays = [];
                var shapes = [];
                for (var _i = 0, v_1 = v; _i < v_1.length; _i++) {
                    var obj = v_1[_i];
                    var _a = exports.process_array(obj, buffers), arr = _a[0], shape = _a[1];
                    arrays.push(arr);
                    shapes.push(shape);
                }
                new_data[k] = arrays;
                new_shapes[k] = shapes;    // must be object or array (single array case)
            } else {
                var _b = exports.process_array(v, buffers), arr = _b[0], shape = _b[1];
                new_data[k] = arr;
                new_shapes[k] = shape;
            }
        }
        return [
            new_data,
            new_shapes
        ];
    };
    exports.encode_column_data = function (data, shapes) {
        var new_data = {};
        for (var k in data) {
            var v = data[k];
            if ((v != null ? v.buffer : undefined) instanceof ArrayBuffer) {
                v = exports.encode_base64(v, shapes != null ? shapes[k] : undefined);
            } else if (types_1.isArray(v)) {
                var new_array = [];
                var _loop_1 = function (i, end) {
                    if ((v[i] != null ? v[i].buffer : undefined) instanceof ArrayBuffer) {
                        new_array.push(exports.encode_base64(v[i], __guard__(shapes != null ? shapes[k] : undefined, function (x) {
                            return x[i];
                        })));
                    } else {
                        new_array.push(v[i]);
                    }
                };
                for (var i = 0, end = v.length; i < end; i++) {
                    _loop_1(i, end);
                }
                v = new_array;
            }
            new_data[k] = v;
        }
        return new_data;
    };
    function __guard__(value, transform) {
        return typeof value !== 'undefined' && value !== null ? transform(value) : undefined;
    }    
},
/*core/util/spatial*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    /// <reference types="@types/rbush" />
    var rbush = require(366    /* rbush */);
    var SpatialIndex = function () {
        function SpatialIndex() {
        }
        return SpatialIndex;
    }();
    exports.SpatialIndex = SpatialIndex;
    var RBush = function (_super) {
        tslib_1.__extends(RBush, _super);
        function RBush(points) {
            var _this = _super.call(this) || this;
            _this.index = rbush();
            _this.index.load(points);
            return _this;
        }
        Object.defineProperty(RBush.prototype, 'bbox', {
            get: function () {
                var _a = this.index.toJSON(), minX = _a.minX, minY = _a.minY, maxX = _a.maxX, maxY = _a.maxY;
                return {
                    minX: minX,
                    minY: minY,
                    maxX: maxX,
                    maxY: maxY
                };
            },
            enumerable: true,
            configurable: true
        });
        RBush.prototype.search = function (rect) {
            return this.index.search(rect);
        };
        RBush.prototype.indices = function (rect) {
            var points = this.search(rect);
            var n = points.length;
            var indices = new Array(n);
            for (var j = 0; j < n; j++) {
                indices[j] = points[j].i;
            }
            return indices;
        };
        return RBush;
    }(SpatialIndex);
    exports.RBush = RBush;    
},
/*core/util/string*/
function _(require, module, exports) {
    var settings_1 = require(19    /* ../settings */);
    function startsWith(str, searchString, position) {
        if (position === void 0) {
            position = 0;
        }
        return str.substr(position, searchString.length) == searchString;
    }
    exports.startsWith = startsWith;
    function uuid4() {
        // from ipython project
        // http://www.ietf.org/rfc/rfc4122.txt
        var s = new Array(32);
        var hexDigits = '0123456789ABCDEF';
        for (var i = 0; i < 32; i++) {
            s[i] = hexDigits.substr(Math.floor(Math.random() * 16), 1);
        }
        s[12] = '4';
        // bits 12-15 of the time_hi_and_version field to 0010
        s[16] = hexDigits.substr(s[16].charCodeAt(0) & 3 | 8, 1);
        // bits 6-7 of the clock_seq_hi_and_reserved to 01
        return s.join('');
    }
    exports.uuid4 = uuid4;
    var counter = 1000;
    function uniqueId(prefix) {
        var id = settings_1.settings.dev ? 'j' + counter++ : uuid4();
        if (prefix != null)
            return prefix + '-' + id;
        else
            return id;
    }
    exports.uniqueId = uniqueId;
    function escape(s) {
        return s.replace(/(?:[&<>"'`])/g, function (ch) {
            switch (ch) {
            case '&':
                return '&amp;';
            case '<':
                return '&lt;';
            case '>':
                return '&gt;';
            case '"':
                return '&quot;';
            case '\'':
                return '&#x27;';
            case '`':
                return '&#x60;';
            default:
                return ch;
            }
        });
    }
    exports.escape = escape;
    function unescape(s) {
        return s.replace(/&(amp|lt|gt|quot|#x27|#x60);/g, function (_, entity) {
            switch (entity) {
            case 'amp':
                return '&';
            case 'lt':
                return '<';
            case 'gt':
                return '>';
            case 'quot':
                return '"';
            case '#x27':
                return '\'';
            case '#x60':
                return '`';
            default:
                return entity;
            }
        });
    }
    exports.unescape = unescape;    
},
/*core/util/svg_colors*/
function _(require, module, exports) {
    exports.indianred = '#CD5C5C';
    exports.lightcoral = '#F08080';
    exports.salmon = '#FA8072';
    exports.darksalmon = '#E9967A';
    exports.lightsalmon = '#FFA07A';
    exports.crimson = '#DC143C';
    exports.red = '#FF0000';
    exports.firebrick = '#B22222';
    exports.darkred = '#8B0000';
    exports.pink = '#FFC0CB';
    exports.lightpink = '#FFB6C1';
    exports.hotpink = '#FF69B4';
    exports.deeppink = '#FF1493';
    exports.mediumvioletred = '#C71585';
    exports.palevioletred = '#DB7093';
    exports.coral = '#FF7F50';
    exports.tomato = '#FF6347';
    exports.orangered = '#FF4500';
    exports.darkorange = '#FF8C00';
    exports.orange = '#FFA500';
    exports.gold = '#FFD700';
    exports.yellow = '#FFFF00';
    exports.lightyellow = '#FFFFE0';
    exports.lemonchiffon = '#FFFACD';
    exports.lightgoldenrodyellow = '#FAFAD2';
    exports.papayawhip = '#FFEFD5';
    exports.moccasin = '#FFE4B5';
    exports.peachpuff = '#FFDAB9';
    exports.palegoldenrod = '#EEE8AA';
    exports.khaki = '#F0E68C';
    exports.darkkhaki = '#BDB76B';
    exports.lavender = '#E6E6FA';
    exports.thistle = '#D8BFD8';
    exports.plum = '#DDA0DD';
    exports.violet = '#EE82EE';
    exports.orchid = '#DA70D6';
    exports.fuchsia = '#FF00FF';
    exports.magenta = '#FF00FF';
    exports.mediumorchid = '#BA55D3';
    exports.mediumpurple = '#9370DB';
    exports.blueviolet = '#8A2BE2';
    exports.darkviolet = '#9400D3';
    exports.darkorchid = '#9932CC';
    exports.darkmagenta = '#8B008B';
    exports.purple = '#800080';
    exports.indigo = '#4B0082';
    exports.slateblue = '#6A5ACD';
    exports.darkslateblue = '#483D8B';
    exports.mediumslateblue = '#7B68EE';
    exports.greenyellow = '#ADFF2F';
    exports.chartreuse = '#7FFF00';
    exports.lawngreen = '#7CFC00';
    exports.lime = '#00FF00';
    exports.limegreen = '#32CD32';
    exports.palegreen = '#98FB98';
    exports.lightgreen = '#90EE90';
    exports.mediumspringgreen = '#00FA9A';
    exports.springgreen = '#00FF7F';
    exports.mediumseagreen = '#3CB371';
    exports.seagreen = '#2E8B57';
    exports.forestgreen = '#228B22';
    exports.green = '#008000';
    exports.darkgreen = '#006400';
    exports.yellowgreen = '#9ACD32';
    exports.olivedrab = '#6B8E23';
    exports.olive = '#808000';
    exports.darkolivegreen = '#556B2F';
    exports.mediumaquamarine = '#66CDAA';
    exports.darkseagreen = '#8FBC8F';
    exports.lightseagreen = '#20B2AA';
    exports.darkcyan = '#008B8B';
    exports.teal = '#008080';
    exports.aqua = '#00FFFF';
    exports.cyan = '#00FFFF';
    exports.lightcyan = '#E0FFFF';
    exports.paleturquoise = '#AFEEEE';
    exports.aquamarine = '#7FFFD4';
    exports.turquoise = '#40E0D0';
    exports.mediumturquoise = '#48D1CC';
    exports.darkturquoise = '#00CED1';
    exports.cadetblue = '#5F9EA0';
    exports.steelblue = '#4682B4';
    exports.lightsteelblue = '#B0C4DE';
    exports.powderblue = '#B0E0E6';
    exports.lightblue = '#ADD8E6';
    exports.skyblue = '#87CEEB';
    exports.lightskyblue = '#87CEFA';
    exports.deepskyblue = '#00BFFF';
    exports.dodgerblue = '#1E90FF';
    exports.cornflowerblue = '#6495ED';
    exports.royalblue = '#4169E1';
    exports.blue = '#0000FF';
    exports.mediumblue = '#0000CD';
    exports.darkblue = '#00008B';
    exports.navy = '#000080';
    exports.midnightblue = '#191970';
    exports.cornsilk = '#FFF8DC';
    exports.blanchedalmond = '#FFEBCD';
    exports.bisque = '#FFE4C4';
    exports.navajowhite = '#FFDEAD';
    exports.wheat = '#F5DEB3';
    exports.burlywood = '#DEB887';
    exports.tan = '#D2B48C';
    exports.rosybrown = '#BC8F8F';
    exports.sandybrown = '#F4A460';
    exports.goldenrod = '#DAA520';
    exports.darkgoldenrod = '#B8860B';
    exports.peru = '#CD853F';
    exports.chocolate = '#D2691E';
    exports.saddlebrown = '#8B4513';
    exports.sienna = '#A0522D';
    exports.brown = '#A52A2A';
    exports.maroon = '#800000';
    exports.white = '#FFFFFF';
    exports.snow = '#FFFAFA';
    exports.honeydew = '#F0FFF0';
    exports.mintcream = '#F5FFFA';
    exports.azure = '#F0FFFF';
    exports.aliceblue = '#F0F8FF';
    exports.ghostwhite = '#F8F8FF';
    exports.whitesmoke = '#F5F5F5';
    exports.seashell = '#FFF5EE';
    exports.beige = '#F5F5DC';
    exports.oldlace = '#FDF5E6';
    exports.floralwhite = '#FFFAF0';
    exports.ivory = '#FFFFF0';
    exports.antiquewhite = '#FAEBD7';
    exports.linen = '#FAF0E6';
    exports.lavenderblush = '#FFF0F5';
    exports.mistyrose = '#FFE4E1';
    exports.gainsboro = '#DCDCDC';
    exports.lightgray = '#D3D3D3';
    exports.lightgrey = '#D3D3D3';
    exports.silver = '#C0C0C0';
    exports.darkgray = '#A9A9A9';
    exports.darkgrey = '#A9A9A9';
    exports.gray = '#808080';
    exports.grey = '#808080';
    exports.dimgray = '#696969';
    exports.dimgrey = '#696969';
    exports.lightslategray = '#778899';
    exports.lightslategrey = '#778899';
    exports.slategray = '#708090';
    exports.slategrey = '#708090';
    exports.darkslategray = '#2F4F4F';
    exports.darkslategrey = '#2F4F4F';
    exports.black = '#000000';    
},
/*core/util/templating*/
function _(require, module, exports) {
    /* XXX: partial */
    var sprintf_js_1 = require(367    /* sprintf-js */);
    var Numbro = require(337    /* numbro */);
    var tz = require(368    /* timezone */);
    var string_1 = require(38    /* ./string */);
    var types_1 = require(43    /* ./types */);
    var _format_number = function (number) {
        if (types_1.isNumber(number)) {
            var format = function () {
                switch (false) {
                case Math.floor(number) !== number:
                    return '%d';
                case !(Math.abs(number) > 0.1) || !(Math.abs(number) < 1000):
                    return '%0.3f';
                default:
                    return '%0.3e';
                }
            }();
            return sprintf_js_1.sprintf(format, number);
        } else {
            return '' + number;    // get strings for categorical types
        }
    };
    exports.replace_placeholders = function (string, data_source, i, formatters, special_vars) {
        if (formatters === void 0) {
            formatters = null;
        }
        if (special_vars === void 0) {
            special_vars = {};
        }
        string = string.replace(/(^|[^\$])\$(\w+)/g, function (_match, prefix, name) {
            return prefix + '@$' + name;
        });
        string = string.replace(/(^|[^@])@(?:(\$?\w+)|{([^{}]+)})(?:{([^{}]+)})?/g, function (_match, prefix, name, long_name, format) {
            name = long_name != null ? long_name : name;
            var value = name[0] === '$' ? special_vars[name.substring(1)] : __guard__(data_source.get_column(name), function (x) {
                return x[i];
            });
            var replacement = null;
            if (value == null) {
                replacement = '???';
            } else {
                // 'safe' format, just return the value as is
                if (format === 'safe') {
                    return '' + prefix + value;
                } else if (format != null) {
                    // see if the field has an entry in the formatters dict
                    if (formatters != null && name in formatters) {
                        if (formatters[name] === 'numeral') {
                            replacement = Numbro.format(value, format);
                        } else if (formatters[name] === 'datetime') {
                            replacement = tz(value, format);
                        } else if (formatters[name] === 'printf') {
                            replacement = sprintf_js_1.sprintf(format, value);
                        } else {
                            throw new Error('Unknown tooltip field formatter type \'' + formatters[name] + '\'');
                        }    // if not assume the format string is Numbro
                    } else {
                        replacement = Numbro.format(value, format);
                    }    // no format supplied, just use a basic default numeric format
                } else {
                    replacement = _format_number(value);
                }
            }
            return replacement = '' + prefix + string_1.escape(replacement);
        });
        return string;
    };
    function __guard__(value, transform) {
        return typeof value !== 'undefined' && value !== null ? transform(value) : undefined;
    }    
},
/*core/util/text*/
function _(require, module, exports) {
    var dom_1 = require(5    /* ../dom */);
    var cache = {};
    function get_text_height(font) {
        if (cache[font] != null)
            return cache[font];
        var text = dom_1.span({ style: { font: font } }, 'Hg');
        var block = dom_1.div({
            style: {
                display: 'inline-block',
                width: '1px',
                height: '0px'
            }
        });
        var elem = dom_1.div({}, text, block);
        document.body.appendChild(elem);
        try {
            block.style.verticalAlign = 'baseline';
            var ascent = dom_1.offset(block).top - dom_1.offset(text).top;
            block.style.verticalAlign = 'bottom';
            var height = dom_1.offset(block).top - dom_1.offset(text).top;
            var result = {
                height: height,
                ascent: ascent,
                descent: height - ascent
            };
            cache[font] = result;
            return result;
        } finally {
            document.body.removeChild(elem);
        }
    }
    exports.get_text_height = get_text_height;    
},
/*core/util/throttle*/
function _(require, module, exports) {
    /* XXX: partial */
    var _delay_animation = function (f) {
        return f();
    };
    var delay_animation = (typeof window !== 'undefined' && window !== null ? window.requestAnimationFrame : undefined) || (typeof window !== 'undefined' && window !== null ? window.mozRequestAnimationFrame : undefined) || (typeof window !== 'undefined' && window !== null ? window.webkitRequestAnimationFrame : undefined) || (typeof window !== 'undefined' && window !== null ? window.msRequestAnimationFrame : undefined) || _delay_animation;
    // Returns a function, that, when invoked, will only be triggered at
    // most once during a given window of time.
    //
    // In addition, if the browser supports requestAnimationFrame, the
    // throttled function will be run no more frequently than request
    // animation frame allows.
    //
    // @param func [function] the function to throttle
    // @param wait [number] time in milliseconds to use for window
    // @return [function] throttled function
    //
    exports.throttle = function (func, wait) {
        var _a = [
                null,
                null,
                null,
                null
            ], context = _a[0], args = _a[1], timeout = _a[2], result = _a[3];
        var previous = 0;
        var pending = false;
        var later = function () {
            previous = Date.now();
            timeout = null;
            pending = false;
            return result = func.apply(context, args);
        };
        return function () {
            var now = Date.now();
            var remaining = wait - (now - previous);
            context = this;
            args = arguments;
            if (remaining <= 0 && !pending) {
                clearTimeout(timeout);
                pending = true;
                delay_animation(later);
            } else if (!timeout && !pending) {
                timeout = setTimeout(function () {
                    return delay_animation(later);
                }, remaining);
            }
            return result;
        };
    };    
},
/*core/util/types*/
function _(require, module, exports) {
    var toString = Object.prototype.toString;
    function isBoolean(obj) {
        return obj === true || obj === false || toString.call(obj) === '[object Boolean]';
    }
    exports.isBoolean = isBoolean;
    function isNumber(obj) {
        return toString.call(obj) === '[object Number]';
    }
    exports.isNumber = isNumber;
    function isInteger(obj) {
        return isNumber(obj) && isFinite(obj) && Math.floor(obj) === obj;
    }
    exports.isInteger = isInteger;
    function isString(obj) {
        return toString.call(obj) === '[object String]';
    }
    exports.isString = isString;
    function isStrictNaN(obj) {
        return isNumber(obj) && obj !== +obj;
    }
    exports.isStrictNaN = isStrictNaN;
    function isFunction(obj) {
        return toString.call(obj) === '[object Function]';
    }
    exports.isFunction = isFunction;
    function isArray(obj) {
        return Array.isArray(obj);
    }
    exports.isArray = isArray;
    function isObject(obj) {
        var tp = typeof obj;
        return tp === 'function' || tp === 'object' && !!obj;
    }
    exports.isObject = isObject;    
},
/*core/util/wheel*/
function _(require, module, exports) {
    function fontSize(element) {
        var value = getComputedStyle(element).fontSize;
        if (value != null)
            return parseInt(value, 10);
        return null;
    }
    function lineHeight(element) {
        var parent = element.offsetParent || document.body;
        return fontSize(parent) || fontSize(element) || 16;
    }
    function pageHeight(element) {
        return element.clientHeight;    // XXX: should be content height?
    }
    function getDeltaY(event) {
        var deltaY = -event.deltaY;
        if (event.target instanceof HTMLElement) {
            switch (event.deltaMode) {
            case event.DOM_DELTA_LINE:
                deltaY *= lineHeight(event.target);
                break;
            case event.DOM_DELTA_PAGE:
                deltaY *= pageHeight(event.target);
                break;
            }
        }
        return deltaY;
    }
    exports.getDeltaY = getDeltaY;    
},
/*core/util/zoom*/
function _(require, module, exports) {
    var math_1 = require(30    /* ./math */);
    // Module for zoom-related functions
    function scale_highlow(range, factor, center) {
        var _a = [
                range.start,
                range.end
            ], low = _a[0], high = _a[1];
        var x = center != null ? center : (high + low) / 2;
        var x0 = low - (low - x) * factor;
        var x1 = high - (high - x) * factor;
        return [
            x0,
            x1
        ];
    }
    exports.scale_highlow = scale_highlow;
    function get_info(scales, _a) {
        var sxy0 = _a[0], sxy1 = _a[1];
        var info = {};
        for (var name_1 in scales) {
            var scale = scales[name_1];
            var _b = scale.r_invert(sxy0, sxy1), start = _b[0], end = _b[1];
            info[name_1] = {
                start: start,
                end: end
            };
        }
        return info;
    }
    exports.get_info = get_info;
    function scale_range(frame, factor, h_axis, v_axis, center) {
        /*
     * Utility function for zoom tools to calculate/create the zoom_info object
     * of the form required by ``PlotCanvasView.update_range``
     *
     * Parameters:
     *   frame : CartesianFrame
     *   factor : Number
     *   h_axis : Boolean, optional
     *     whether to zoom the horizontal axis (default = true)
     *   v_axis : Boolean, optional
     *     whether to zoom the horizontal axis (default = true)
     *   center : object, optional
     *     of form {'x': Number, 'y', Number}
     *
     * Returns:
     *   object:
     */
        if (h_axis === void 0) {
            h_axis = true;
        }
        if (v_axis === void 0) {
            v_axis = true;
        }
        // clamp the  magnitude of factor, if it is > 1 bad things happen
        factor = math_1.clamp(factor, -0.9, 0.9);
        var hfactor = h_axis ? factor : 0;
        var _a = scale_highlow(frame.bbox.h_range, hfactor, center != null ? center.x : undefined), sx0 = _a[0], sx1 = _a[1];
        var xrs = get_info(frame.xscales, [
            sx0,
            sx1
        ]);
        var vfactor = v_axis ? factor : 0;
        var _b = scale_highlow(frame.bbox.v_range, vfactor, center != null ? center.y : undefined), sy0 = _b[0], sy1 = _b[1];
        var yrs = get_info(frame.yscales, [
            sy0,
            sy1
        ]);
        // OK this sucks we can't set factor independently in each direction. It is used
        // for GMap plots, and GMap plots always preserve aspect, so effective the value
        // of 'dimensions' is ignored.
        return {
            xrs: xrs,
            yrs: yrs,
            factor: factor
        };
    }
    exports.scale_range = scale_range;    
},
/*core/view*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    var signaling_1 = require(20    /* ./signaling */);
    var string_1 = require(38    /* ./util/string */);
    var View = function (_super) {
        tslib_1.__extends(View, _super);
        function View(options) {
            var _this = _super.call(this) || this;
            _this.removed = new signaling_1.Signal(_this, 'removed');
            if (options.model != null)
                _this.model = options.model;
            else
                throw new Error('model of a view wasn\'t configured');
            _this._parent = options.parent;
            _this.id = options.id || string_1.uniqueId();
            _this.initialize(options);
            if (options.connect_signals !== false)
                _this.connect_signals();
            return _this;
        }
        View.prototype.initialize = function (_options) {
        };
        View.prototype.remove = function () {
            this._parent = undefined;
            this.disconnect_signals();
            this.removed.emit(undefined);
        };
        View.prototype.toString = function () {
            return this.model.type + 'View(' + this.id + ')';
        };
        Object.defineProperty(View.prototype, 'parent', {
            get: function () {
                if (this._parent !== undefined)
                    return this._parent;
                else
                    throw new Error('parent of a view wasn\'t configured');
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(View.prototype, 'is_root', {
            get: function () {
                return this.parent === null;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(View.prototype, 'root', {
            get: function () {
                return this.is_root ? this : this.parent.root;
            },
            enumerable: true,
            configurable: true
        });
        View.prototype.connect_signals = function () {
        };
        View.prototype.disconnect_signals = function () {
            signaling_1.Signal.disconnectReceiver(this);
        };
        View.prototype.notify_finished = function () {
            this.root.notify_finished();
        };
        return View;
    }(signaling_1.Signalable());
    exports.View = View;    
},
/*core/visuals*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    var mixins = require(16    /* ./property_mixins */);
    var color_1 = require(27    /* ./util/color */);
    var ContextProperties = function () {
        function ContextProperties(obj, prefix) {
            if (prefix === void 0) {
                prefix = '';
            }
            this.obj = obj;
            this.prefix = prefix;
            // }
            this.cache = {};
            var do_spec = obj.properties[prefix + this.do_attr].spec;
            this.doit = do_spec.value !== null;
            // XXX: can't be `undefined`, see TODOs below.
            for (var _i = 0, _a = this.attrs; _i < _a.length; _i++) {
                var attr = _a[_i];
                this[attr] = obj.properties[prefix + attr];
            }
        }
        ContextProperties.prototype.warm_cache = function (source) {
            for (var _i = 0, _a = this.attrs; _i < _a.length; _i++) {
                var attr = _a[_i];
                var prop = this.obj.properties[this.prefix + attr];
                if (prop.spec.value !== undefined)
                    this.cache[attr] = prop.spec.value;
                else
                    this.cache[attr + '_array'] = prop.array(source);
            }
        };
        ContextProperties.prototype.cache_select = function (attr, i) {
            var prop = this.obj.properties[this.prefix + attr];
            var value;
            if (prop.spec.value !== undefined)
                this.cache[attr] = value = prop.spec.value;
            else
                this.cache[attr] = value = this.cache[attr + '_array'][i];
            return value;
        };
        ContextProperties.prototype.set_vectorize = function (ctx, i) {
            if (this.all_indices != null)
                this._set_vectorize(ctx, this.all_indices[i]);
            else
                this._set_vectorize(ctx, i);
        };
        return ContextProperties;
    }();
    exports.ContextProperties = ContextProperties;
    var Line = function (_super) {
        tslib_1.__extends(Line, _super);
        function Line() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Line.prototype.set_value = function (ctx) {
            ctx.strokeStyle = this.line_color.value();
            ctx.globalAlpha = this.line_alpha.value();
            ctx.lineWidth = this.line_width.value();
            ctx.lineJoin = this.line_join.value();
            ctx.lineCap = this.line_cap.value();
            ctx.setLineDash(this.line_dash.value());
            ctx.setLineDashOffset(this.line_dash_offset.value());
        };
        Line.prototype._set_vectorize = function (ctx, i) {
            this.cache_select('line_color', i);
            if (ctx.strokeStyle !== this.cache.line_color)
                ctx.strokeStyle = this.cache.line_color;
            this.cache_select('line_alpha', i);
            if (ctx.globalAlpha !== this.cache.line_alpha)
                ctx.globalAlpha = this.cache.line_alpha;
            this.cache_select('line_width', i);
            if (ctx.lineWidth !== this.cache.line_width)
                ctx.lineWidth = this.cache.line_width;
            this.cache_select('line_join', i);
            if (ctx.lineJoin !== this.cache.line_join)
                ctx.lineJoin = this.cache.line_join;
            this.cache_select('line_cap', i);
            if (ctx.lineCap !== this.cache.line_cap)
                ctx.lineCap = this.cache.line_cap;
            this.cache_select('line_dash', i);
            if (ctx.getLineDash() !== this.cache.line_dash)
                ctx.setLineDash(this.cache.line_dash);
            this.cache_select('line_dash_offset', i);
            if (ctx.getLineDashOffset() !== this.cache.line_dash_offset)
                ctx.setLineDashOffset(this.cache.line_dash_offset);
        };
        Line.prototype.color_value = function () {
            var _a = color_1.color2rgba(this.line_color.value(), this.line_alpha.value()), r = _a[0], g = _a[1], b = _a[2], a = _a[3];
            return 'rgba(' + r * 255 + ',' + g * 255 + ',' + b * 255 + ',' + a + ')';
        };
        return Line;
    }(ContextProperties);
    exports.Line = Line;
    Line.prototype.attrs = Object.keys(mixins.line());
    Line.prototype.do_attr = 'line_color';
    var Fill = function (_super) {
        tslib_1.__extends(Fill, _super);
        function Fill() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Fill.prototype.set_value = function (ctx) {
            ctx.fillStyle = this.fill_color.value();
            ctx.globalAlpha = this.fill_alpha.value();
        };
        Fill.prototype._set_vectorize = function (ctx, i) {
            this.cache_select('fill_color', i);
            if (ctx.fillStyle !== this.cache.fill_color)
                ctx.fillStyle = this.cache.fill_color;
            this.cache_select('fill_alpha', i);
            if (ctx.globalAlpha !== this.cache.fill_alpha)
                ctx.globalAlpha = this.cache.fill_alpha;
        };
        Fill.prototype.color_value = function () {
            var _a = color_1.color2rgba(this.fill_color.value(), this.fill_alpha.value()), r = _a[0], g = _a[1], b = _a[2], a = _a[3];
            return 'rgba(' + r * 255 + ',' + g * 255 + ',' + b * 255 + ',' + a + ')';
        };
        return Fill;
    }(ContextProperties);
    exports.Fill = Fill;
    Fill.prototype.attrs = Object.keys(mixins.fill());
    Fill.prototype.do_attr = 'fill_color';
    var Text = function (_super) {
        tslib_1.__extends(Text, _super);
        function Text() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Text.prototype.cache_select = function (name, i) {
            var value;
            if (name == 'font') {
                _super.prototype.cache_select.call(this, 'text_font_style', i);
                _super.prototype.cache_select.call(this, 'text_font_size', i);
                _super.prototype.cache_select.call(this, 'text_font', i);
                var _a = this.cache, text_font_style = _a.text_font_style, text_font_size = _a.text_font_size, text_font = _a.text_font;
                this.cache.font = value = text_font_style + ' ' + text_font_size + ' ' + text_font;
            } else
                value = _super.prototype.cache_select.call(this, name, i);
            return value;
        };
        Text.prototype.font_value = function () {
            var font = this.text_font.value();
            var font_size = this.text_font_size.value();
            var font_style = this.text_font_style.value();
            return font_style + ' ' + font_size + ' ' + font;
        };
        Text.prototype.color_value = function () {
            var _a = color_1.color2rgba(this.text_color.value(), this.text_alpha.value()), r = _a[0], g = _a[1], b = _a[2], a = _a[3];
            return 'rgba(' + r * 255 + ',' + g * 255 + ',' + b * 255 + ',' + a + ')';
        };
        Text.prototype.set_value = function (ctx) {
            ctx.font = this.font_value();
            ctx.fillStyle = this.text_color.value();
            ctx.globalAlpha = this.text_alpha.value();
            ctx.textAlign = this.text_align.value();
            ctx.textBaseline = this.text_baseline.value();
        };
        Text.prototype._set_vectorize = function (ctx, i) {
            this.cache_select('font', i);
            if (ctx.font !== this.cache.font)
                ctx.font = this.cache.font;
            this.cache_select('text_color', i);
            if (ctx.fillStyle !== this.cache.text_color)
                ctx.fillStyle = this.cache.text_color;
            this.cache_select('text_alpha', i);
            if (ctx.globalAlpha !== this.cache.text_alpha)
                ctx.globalAlpha = this.cache.text_alpha;
            this.cache_select('text_align', i);
            if (ctx.textAlign !== this.cache.text_align)
                ctx.textAlign = this.cache.text_align;
            this.cache_select('text_baseline', i);
            if (ctx.textBaseline !== this.cache.text_baseline)
                ctx.textBaseline = this.cache.text_baseline;
        };
        return Text;
    }(ContextProperties);
    exports.Text = Text;
    Text.prototype.attrs = Object.keys(mixins.text());
    Text.prototype.do_attr = 'text_color';
    var Visuals = function () {
        function Visuals(model) {
            for (var _i = 0, _a = model.mixins; _i < _a.length; _i++) {
                var spec = _a[_i];
                var _b = spec.split(':'), name_1 = _b[0], _c = _b[1], prefix = _c === void 0 ? '' : _c;
                var cls = void 0;
                switch (name_1) {
                case 'line':
                    cls = Line;
                    break;
                case 'fill':
                    cls = Fill;
                    break;
                case 'text':
                    cls = Text;
                    break;
                default:
                    throw new Error('unknown visual: ' + name_1);
                }
                this[prefix + name_1] = new cls(model, prefix);
            }
        }
        Visuals.prototype.warm_cache = function (source) {
            for (var name_2 in this) {
                if (this.hasOwnProperty(name_2)) {
                    var prop = this[name_2];
                    if (prop instanceof ContextProperties)
                        prop.warm_cache(source);
                }
            }
        };
        Visuals.prototype.set_all_indices = function (all_indices) {
            for (var name_3 in this) {
                if (this.hasOwnProperty(name_3)) {
                    var prop = this[name_3];
                    if (prop instanceof ContextProperties)
                        prop.all_indices = all_indices;
                }
            }
        };
        return Visuals;
    }();
    exports.Visuals = Visuals;    
},
/*document*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    var base_1 = require(0    /* ./base */);
    var version_1 = require(253    /* ./version */);
    var logging_1 = require(14    /* ./core/logging */);
    var bokeh_events_1 = require(3    /* core/bokeh_events */);
    var has_props_1 = require(8    /* ./core/has_props */);
    var signaling_1 = require(20    /* ./core/signaling */);
    var refs_1 = require(34    /* ./core/util/refs */);
    var serialization_1 = require(36    /* ./core/util/serialization */);
    var data_structures_1 = require(28    /* ./core/util/data_structures */);
    var array_1 = require(22    /* ./core/util/array */);
    var object_1 = require(31    /* ./core/util/object */);
    var eq_1 = require(29    /* ./core/util/eq */);
    var types_1 = require(43    /* ./core/util/types */);
    var layout_dom_1 = require(140    /* ./models/layouts/layout_dom */);
    var column_data_source_1 = require(174    /* ./models/sources/column_data_source */);
    var model_1 = require(51    /* ./model */);
    var EventManager = function () {
        function EventManager(document) {
            this.document = document;
            /* Document */
            // Dispatches events to the subscribed models
            this.session = null;
            this.subscribed_models = new data_structures_1.Set();
        }
        EventManager.prototype.send_event = function (event) {
            // Send message to Python via session
            if (this.session != null)
                this.session.send_event(event);
        };
        EventManager.prototype.trigger = function (event) {
            for (var _i = 0, _a = this.subscribed_models.values; _i < _a.length; _i++) {
                var model_id = _a[_i];
                if (event.model_id != null && event.model_id !== model_id)
                    continue;
                var model = this.document._all_models[model_id];
                if (model != null)
                    model._process_event(event);
            }
        };
        return EventManager;
    }();
    exports.EventManager = EventManager;
    var DocumentChangedEvent = function () {
        function DocumentChangedEvent(document) {
            this.document = document;
        }
        return DocumentChangedEvent;
    }();
    exports.DocumentChangedEvent = DocumentChangedEvent;
    var ModelChangedEvent = function (_super) {
        tslib_1.__extends(ModelChangedEvent, _super);
        function ModelChangedEvent(document, model, attr, old, new_, setter_id) {
            var _this = _super.call(this, document) || this;
            _this.model = model;
            _this.attr = attr;
            _this.old = old;
            _this.new_ = new_;
            _this.setter_id = setter_id;
            return _this;
        }
        ModelChangedEvent.prototype.json = function (references) {
            if (this.attr === 'id') {
                throw new Error('\'id\' field should never change, whatever code just set it is wrong');
            }
            var value = this.new_;
            var value_json = has_props_1.HasProps._value_to_json(this.attr, value, this.model);
            var value_refs = {};
            has_props_1.HasProps._value_record_references(value, value_refs, true);
            // true = recurse
            if (this.model.id in value_refs && this.model !== value) {
                // we know we don't want a whole new copy of the obj we're
                // patching unless it's also the value itself
                delete value_refs[this.model.id];
            }
            for (var id in value_refs) {
                references[id] = value_refs[id];
            }
            return {
                kind: 'ModelChanged',
                model: this.model.ref(),
                attr: this.attr,
                new: value_json
            };
        };
        return ModelChangedEvent;
    }(DocumentChangedEvent);
    exports.ModelChangedEvent = ModelChangedEvent;
    var TitleChangedEvent = function (_super) {
        tslib_1.__extends(TitleChangedEvent, _super);
        function TitleChangedEvent(document, title, setter_id) {
            var _this = _super.call(this, document) || this;
            _this.title = title;
            _this.setter_id = setter_id;
            return _this;
        }
        TitleChangedEvent.prototype.json = function (_references) {
            return {
                kind: 'TitleChanged',
                title: this.title
            };
        };
        return TitleChangedEvent;
    }(DocumentChangedEvent);
    exports.TitleChangedEvent = TitleChangedEvent;
    var RootAddedEvent = function (_super) {
        tslib_1.__extends(RootAddedEvent, _super);
        function RootAddedEvent(document, model, setter_id) {
            var _this = _super.call(this, document) || this;
            _this.model = model;
            _this.setter_id = setter_id;
            return _this;
        }
        RootAddedEvent.prototype.json = function (references) {
            has_props_1.HasProps._value_record_references(this.model, references, true);
            return {
                kind: 'RootAdded',
                model: this.model.ref()
            };
        };
        return RootAddedEvent;
    }(DocumentChangedEvent);
    exports.RootAddedEvent = RootAddedEvent;
    var RootRemovedEvent = function (_super) {
        tslib_1.__extends(RootRemovedEvent, _super);
        function RootRemovedEvent(document, model, setter_id) {
            var _this = _super.call(this, document) || this;
            _this.model = model;
            _this.setter_id = setter_id;
            return _this;
        }
        RootRemovedEvent.prototype.json = function (_references) {
            return {
                kind: 'RootRemoved',
                model: this.model.ref()
            };
        };
        return RootRemovedEvent;
    }(DocumentChangedEvent);
    exports.RootRemovedEvent = RootRemovedEvent;
    exports.documents = [];
    exports.DEFAULT_TITLE = 'Bokeh Application';
    // This class should match the API of the Python Document class
    // as much as possible.
    var Document = function () {
        function Document() {
            exports.documents.push(this);
            this._init_timestamp = Date.now();
            this._title = exports.DEFAULT_TITLE;
            this._roots = [];
            this._all_models = {};
            this._all_models_by_name = new data_structures_1.MultiDict();
            this._all_models_freeze_count = 0;
            this._callbacks = [];
            this.event_manager = new EventManager(this);
            this.idle = new signaling_1.Signal(this, 'idle');
            this._idle_roots = new WeakMap();
            // TODO: WeakSet would be better
            this._interactive_timestamp = null;
            this._interactive_plot = null;
        }
        Object.defineProperty(Document.prototype, 'layoutables', {
            get: function () {
                return this._roots.filter(function (root) {
                    return root instanceof layout_dom_1.LayoutDOM;
                });
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Document.prototype, 'is_idle', {
            get: function () {
                for (var _i = 0, _a = this.layoutables; _i < _a.length; _i++) {
                    var root = _a[_i];
                    if (!this._idle_roots.has(root))
                        return false;
                }
                return true;
            },
            enumerable: true,
            configurable: true
        });
        Document.prototype.notify_idle = function (model) {
            this._idle_roots.set(model, true);
            if (this.is_idle) {
                logging_1.logger.info('document idle at ' + (Date.now() - this._init_timestamp) + ' ms');
                this.idle.emit(undefined);
            }
        };
        Document.prototype.clear = function () {
            this._push_all_models_freeze();
            try {
                while (this._roots.length > 0) {
                    this.remove_root(this._roots[0]);
                }
            } finally {
                this._pop_all_models_freeze();
            }
        };
        Document.prototype.interactive_start = function (plot) {
            if (this._interactive_plot == null) {
                this._interactive_plot = plot;
                this._interactive_plot.trigger_event(new bokeh_events_1.LODStart({}));
            }
            this._interactive_timestamp = Date.now();
        };
        Document.prototype.interactive_stop = function (plot) {
            if (this._interactive_plot != null && this._interactive_plot.id === plot.id) {
                this._interactive_plot.trigger_event(new bokeh_events_1.LODEnd({}));
            }
            this._interactive_plot = null;
            this._interactive_timestamp = null;
        };
        Document.prototype.interactive_duration = function () {
            if (this._interactive_timestamp == null)
                return -1;
            else
                return Date.now() - this._interactive_timestamp;
        };
        Document.prototype.destructively_move = function (dest_doc) {
            if (dest_doc === this) {
                throw new Error('Attempted to overwrite a document with itself');
            }
            dest_doc.clear();
            // we have to remove ALL roots before adding any
            // to the new doc or else models referenced from multiple
            // roots could be in both docs at once, which isn't allowed.
            var roots = array_1.copy(this._roots);
            this.clear();
            for (var _i = 0, roots_1 = roots; _i < roots_1.length; _i++) {
                var root = roots_1[_i];
                if (root.document != null)
                    throw new Error('Somehow we didn\'t detach ' + root);
            }
            if (Object.keys(this._all_models).length !== 0) {
                throw new Error('this._all_models still had stuff in it: ' + this._all_models);
            }
            for (var _a = 0, roots_2 = roots; _a < roots_2.length; _a++) {
                var root = roots_2[_a];
                dest_doc.add_root(root);
            }
            dest_doc.set_title(this._title);
        };
        // TODO other fields of doc
        Document.prototype._push_all_models_freeze = function () {
            this._all_models_freeze_count += 1;
        };
        Document.prototype._pop_all_models_freeze = function () {
            this._all_models_freeze_count -= 1;
            if (this._all_models_freeze_count === 0) {
                this._recompute_all_models();
            }
        };
        /*protected*/
        Document.prototype._invalidate_all_models = function () {
            logging_1.logger.debug('invalidating document models');
            // if freeze count is > 0, we'll recompute on unfreeze
            if (this._all_models_freeze_count === 0) {
                this._recompute_all_models();
            }
        };
        Document.prototype._recompute_all_models = function () {
            var new_all_models_set = new data_structures_1.Set();
            for (var _i = 0, _a = this._roots; _i < _a.length; _i++) {
                var r = _a[_i];
                new_all_models_set = new_all_models_set.union(r.references());
            }
            var old_all_models_set = new data_structures_1.Set(object_1.values(this._all_models));
            var to_detach = old_all_models_set.diff(new_all_models_set);
            var to_attach = new_all_models_set.diff(old_all_models_set);
            var recomputed = {};
            for (var _b = 0, _c = new_all_models_set.values; _b < _c.length; _b++) {
                var m = _c[_b];
                recomputed[m.id] = m;
            }
            for (var _d = 0, _e = to_detach.values; _d < _e.length; _d++) {
                var d = _e[_d];
                d.detach_document();
                if (d instanceof model_1.Model && d.name != null)
                    this._all_models_by_name.remove_value(d.name, d);
            }
            for (var _f = 0, _g = to_attach.values; _f < _g.length; _f++) {
                var a = _g[_f];
                a.attach_document(this);
                if (a instanceof model_1.Model && a.name != null)
                    this._all_models_by_name.add_value(a.name, a);
            }
            this._all_models = recomputed;
        };
        Document.prototype.roots = function () {
            return this._roots;
        };
        Document.prototype.add_root = function (model, setter_id) {
            logging_1.logger.debug('Adding root: ' + model);
            if (array_1.includes(this._roots, model))
                return;
            this._push_all_models_freeze();
            try {
                this._roots.push(model);
            } finally {
                this._pop_all_models_freeze();
            }
            this._trigger_on_change(new RootAddedEvent(this, model, setter_id));
        };
        Document.prototype.remove_root = function (model, setter_id) {
            var i = this._roots.indexOf(model);
            if (i < 0)
                return;
            this._push_all_models_freeze();
            try {
                this._roots.splice(i, 1);
            } finally {
                this._pop_all_models_freeze();
            }
            this._trigger_on_change(new RootRemovedEvent(this, model, setter_id));
        };
        Document.prototype.title = function () {
            return this._title;
        };
        Document.prototype.set_title = function (title, setter_id) {
            if (title !== this._title) {
                this._title = title;
                this._trigger_on_change(new TitleChangedEvent(this, title, setter_id));
            }
        };
        Document.prototype.get_model_by_id = function (model_id) {
            if (model_id in this._all_models) {
                return this._all_models[model_id];
            } else {
                return null;
            }
        };
        Document.prototype.get_model_by_name = function (name) {
            return this._all_models_by_name.get_one(name, 'Multiple models are named \'' + name + '\'');
        };
        Document.prototype.on_change = function (callback) {
            if (!array_1.includes(this._callbacks, callback))
                this._callbacks.push(callback);
        };
        Document.prototype.remove_on_change = function (callback) {
            var i = this._callbacks.indexOf(callback);
            if (i >= 0)
                this._callbacks.splice(i, 1);
        };
        Document.prototype._trigger_on_change = function (event) {
            for (var _i = 0, _a = this._callbacks; _i < _a.length; _i++) {
                var cb = _a[_i];
                cb(event);
            }
        };
        // called by the model
        Document.prototype._notify_change = function (model, attr, old, new_, options) {
            if (attr === 'name') {
                this._all_models_by_name.remove_value(old, model);
                if (new_ != null)
                    this._all_models_by_name.add_value(new_, model);
            }
            var setter_id = options != null ? options.setter_id : void 0;
            this._trigger_on_change(new ModelChangedEvent(this, model, attr, old, new_, setter_id));
        };
        Document._references_json = function (references, include_defaults) {
            if (include_defaults === void 0) {
                include_defaults = true;
            }
            var references_json = [];
            for (var _i = 0, references_1 = references; _i < references_1.length; _i++) {
                var r = references_1[_i];
                var ref = r.ref();
                ref.attributes = r.attributes_as_json(include_defaults);
                // server doesn't want id in here since it's already in ref above
                delete ref.attributes.id;
                references_json.push(ref);
            }
            return references_json;
        };
        Document._instantiate_object = function (obj_id, obj_type, obj_attrs) {
            var full_attrs = object_1.extend({}, obj_attrs, { id: obj_id });
            var model = base_1.Models(obj_type);
            return new model(full_attrs, { defer_initialization: true });
        };
        // given a JSON representation of all models in a graph, return a
        // dict of new model objects
        Document._instantiate_references_json = function (references_json, existing_models) {
            // Create all instances, but without setting their props
            var references = {};
            for (var _i = 0, references_json_1 = references_json; _i < references_json_1.length; _i++) {
                var obj = references_json_1[_i];
                var obj_id = obj.id;
                var obj_type = obj.type;
                var obj_attrs = obj.attributes || {};
                var instance = void 0;
                if (obj_id in existing_models)
                    instance = existing_models[obj_id];
                else {
                    instance = Document._instantiate_object(obj_id, obj_type, obj_attrs);
                    if (obj.subtype != null)
                        instance.set_subtype(obj.subtype);
                }
                references[instance.id] = instance;
            }
            return references;
        };
        // if v looks like a ref, or a collection, resolve it, otherwise return it unchanged
        // recurse into collections but not into HasProps
        Document._resolve_refs = function (value, old_references, new_references) {
            function resolve_ref(v) {
                if (refs_1.is_ref(v)) {
                    if (v.id in old_references)
                        return old_references[v.id];
                    else if (v.id in new_references)
                        return new_references[v.id];
                    else
                        throw new Error('reference ' + JSON.stringify(v) + ' isn\'t known (not in Document?)');
                } else if (types_1.isArray(v))
                    return resolve_array(v);
                else if (types_1.isObject(v))
                    return resolve_dict(v);
                else
                    return v;
            }
            function resolve_array(array) {
                var results = [];
                for (var _i = 0, array_2 = array; _i < array_2.length; _i++) {
                    var v = array_2[_i];
                    results.push(resolve_ref(v));
                }
                return results;
            }
            function resolve_dict(dict) {
                var resolved = {};
                for (var k in dict) {
                    var v = dict[k];
                    resolved[k] = resolve_ref(v);
                }
                return resolved;
            }
            return resolve_ref(value);
        };
        // given a JSON representation of all models in a graph and new
        // model instances, set the properties on the models from the
        // JSON
        Document._initialize_references_json = function (references_json, old_references, new_references) {
            var to_update = {};
            for (var _i = 0, references_json_2 = references_json; _i < references_json_2.length; _i++) {
                var obj = references_json_2[_i];
                var obj_id = obj.id;
                var obj_attrs = obj.attributes;
                var was_new = !(obj_id in old_references);
                var instance = !was_new ? old_references[obj_id] : new_references[obj_id];
                // replace references with actual instances in obj_attrs
                var resolved_attrs = Document._resolve_refs(obj_attrs, old_references, new_references);
                to_update[instance.id] = [
                    instance,
                    resolved_attrs,
                    was_new
                ];
            }
            function foreach_depth_first(items, f) {
                var already_started = {};
                function foreach_value(v) {
                    if (v instanceof has_props_1.HasProps) {
                        // note that we ignore instances that aren't updated (not in to_update)
                        if (!(v.id in already_started) && v.id in items) {
                            already_started[v.id] = true;
                            var _a = items[v.id], attrs = _a[1], was_new = _a[2];
                            for (var a in attrs) {
                                var e = attrs[a];
                                foreach_value(e);
                            }
                            f(v, attrs, was_new);
                        }
                    } else if (types_1.isArray(v)) {
                        for (var _i = 0, v_1 = v; _i < v_1.length; _i++) {
                            var e = v_1[_i];
                            foreach_value(e);
                        }
                    } else if (types_1.isObject(v)) {
                        for (var k in v) {
                            var e = v[k];
                            foreach_value(e);
                        }
                    }
                }
                for (var k in items) {
                    var _a = items[k], instance = _a[0];
                    foreach_value(instance);
                }
            }
            // this first pass removes all 'refs' replacing them with real instances
            foreach_depth_first(to_update, function (instance, attrs, was_new) {
                if (was_new)
                    instance.setv(attrs, { silent: true });
            });
            // after removing all the refs, we can run the initialize code safely
            foreach_depth_first(to_update, function (instance, _attrs, was_new) {
                if (was_new)
                    instance.finalize();
            });
        };
        Document._event_for_attribute_change = function (changed_obj, key, new_value, doc, value_refs) {
            var changed_model = doc.get_model_by_id(changed_obj.id);
            // XXX!
            if (!changed_model.attribute_is_serializable(key))
                return null;
            else {
                var event_1 = {
                    kind: 'ModelChanged',
                    model: {
                        id: changed_obj.id,
                        type: changed_obj.type
                    },
                    attr: key,
                    new: new_value
                };
                has_props_1.HasProps._json_record_references(doc, new_value, value_refs, true);
                // true = recurse
                return event_1;
            }
        };
        Document._events_to_sync_objects = function (from_obj, to_obj, to_doc, value_refs) {
            var from_keys = Object.keys(from_obj.attributes);
            //XXX!
            var to_keys = Object.keys(to_obj.attributes);
            //XXX!
            var removed = array_1.difference(from_keys, to_keys);
            var added = array_1.difference(to_keys, from_keys);
            var shared = array_1.intersection(from_keys, to_keys);
            var events = [];
            for (var _i = 0, removed_1 = removed; _i < removed_1.length; _i++) {
                var key = removed_1[_i];
                // we don't really have a "remove" event - not sure this ever
                // happens even. One way this could happen is if the server
                // does include_defaults=True and we do
                // include_defaults=false ... in that case it'd be best to
                // just ignore this probably. Warn about it, could mean
                // there's a bug if we don't have a key that the server sent.
                logging_1.logger.warn('Server sent key ' + key + ' but we don\'t seem to have it in our JSON');
            }
            for (var _a = 0, added_1 = added; _a < added_1.length; _a++) {
                var key = added_1[_a];
                var new_value = to_obj.attributes[key];
                // XXX!
                events.push(Document._event_for_attribute_change(from_obj, key, new_value, to_doc, value_refs));
            }
            for (var _b = 0, shared_1 = shared; _b < shared_1.length; _b++) {
                var key = shared_1[_b];
                var old_value = from_obj.attributes[key];
                // XXX!
                var new_value = to_obj.attributes[key];
                // XXX!
                if (old_value == null && new_value == null) {
                } else if (old_value == null || new_value == null) {
                    events.push(Document._event_for_attribute_change(from_obj, key, new_value, to_doc, value_refs));
                } else {
                    if (!eq_1.isEqual(old_value, new_value))
                        events.push(Document._event_for_attribute_change(from_obj, key, new_value, to_doc, value_refs));
                }
            }
            return events.filter(function (e) {
                return e != null;
            });
        };
        // we use this to detect changes during document deserialization
        // (in model constructors and initializers)
        Document._compute_patch_since_json = function (from_json, to_doc) {
            var to_json = to_doc.to_json(false);
            // include_defaults=false
            function refs(json) {
                var result = {};
                for (var _i = 0, _a = json.roots.references; _i < _a.length; _i++) {
                    var obj = _a[_i];
                    result[obj.id] = obj;
                }
                return result;
            }
            var from_references = refs(from_json);
            var from_roots = {};
            var from_root_ids = [];
            for (var _i = 0, _a = from_json.roots.root_ids; _i < _a.length; _i++) {
                var r = _a[_i];
                from_roots[r] = from_references[r];
                from_root_ids.push(r);
            }
            var to_references = refs(to_json);
            var to_roots = {};
            var to_root_ids = [];
            for (var _b = 0, _c = to_json.roots.root_ids; _b < _c.length; _b++) {
                var r = _c[_b];
                to_roots[r] = to_references[r];
                to_root_ids.push(r);
            }
            from_root_ids.sort();
            to_root_ids.sort();
            if (array_1.difference(from_root_ids, to_root_ids).length > 0 || array_1.difference(to_root_ids, from_root_ids).length > 0) {
                // this would arise if someone does add_root/remove_root during
                // document deserialization, hopefully they won't ever do so.
                throw new Error('Not implemented: computing add/remove of document roots');
            }
            var value_refs = {};
            var events = [];
            for (var id in to_doc._all_models) {
                if (id in from_references) {
                    var update_model_events = Document._events_to_sync_objects(from_references[id], to_references[id], to_doc, value_refs);
                    events = events.concat(update_model_events);
                }
            }
            return {
                references: Document._references_json(object_1.values(value_refs), false),
                events: events
            };
        };
        Document.prototype.to_json_string = function (include_defaults) {
            if (include_defaults === void 0) {
                include_defaults = true;
            }
            return JSON.stringify(this.to_json(include_defaults));
        };
        Document.prototype.to_json = function (include_defaults) {
            if (include_defaults === void 0) {
                include_defaults = true;
            }
            var root_ids = this._roots.map(function (r) {
                return r.id;
            });
            var root_references = object_1.values(this._all_models);
            return {
                title: this._title,
                roots: {
                    root_ids: root_ids,
                    references: Document._references_json(root_references, include_defaults)
                }
            };
        };
        Document.from_json_string = function (s) {
            var json = JSON.parse(s);
            return Document.from_json(json);
        };
        Document.from_json = function (json) {
            logging_1.logger.debug('Creating Document from JSON');
            var py_version = json.version;
            // XXX!
            var is_dev = py_version.indexOf('+') !== -1 || py_version.indexOf('-') !== -1;
            var versions_string = 'Library versions: JS (' + version_1.version + ') / Python (' + py_version + ')';
            if (!is_dev && version_1.version !== py_version) {
                logging_1.logger.warn('JS/Python version mismatch');
                logging_1.logger.warn(versions_string);
            } else
                logging_1.logger.debug(versions_string);
            var roots_json = json.roots;
            var root_ids = roots_json.root_ids;
            var references_json = roots_json.references;
            var references = Document._instantiate_references_json(references_json, {});
            Document._initialize_references_json(references_json, {}, references);
            var doc = new Document();
            for (var _i = 0, root_ids_1 = root_ids; _i < root_ids_1.length; _i++) {
                var r = root_ids_1[_i];
                doc.add_root(references[r]);
            }
            // XXX: HasProps
            doc.set_title(json.title);
            // XXX!
            return doc;
        };
        Document.prototype.replace_with_json = function (json) {
            var replacement = Document.from_json(json);
            replacement.destructively_move(this);
        };
        Document.prototype.create_json_patch_string = function (events) {
            return JSON.stringify(this.create_json_patch(events));
        };
        Document.prototype.create_json_patch = function (events) {
            var references = {};
            var json_events = [];
            for (var _i = 0, events_1 = events; _i < events_1.length; _i++) {
                var event_2 = events_1[_i];
                if (event_2.document !== this) {
                    logging_1.logger.warn('Cannot create a patch using events from a different document, event had ', event_2.document, ' we are ', this);
                    throw new Error('Cannot create a patch using events from a different document');
                }
                json_events.push(event_2.json(references));
            }
            return {
                events: json_events,
                references: Document._references_json(object_1.values(references))
            };
        };
        Document.prototype.apply_json_patch = function (patch, buffers, setter_id) {
            var references_json = patch.references;
            var events_json = patch.events;
            var references = Document._instantiate_references_json(references_json, this._all_models);
            // The model being changed isn't always in references so add it in
            for (var _i = 0, events_json_1 = events_json; _i < events_json_1.length; _i++) {
                var event_json = events_json_1[_i];
                switch (event_json.kind) {
                case 'RootAdded':
                case 'RootRemoved':
                case 'ModelChanged': {
                        var model_id = event_json.model.id;
                        if (model_id in this._all_models) {
                            references[model_id] = this._all_models[model_id];
                        } else {
                            if (!(model_id in references)) {
                                logging_1.logger.warn('Got an event for unknown model ', event_json.model);
                                throw new Error('event model wasn\'t known');
                            }
                        }
                        break;
                    }
                }
            }
            // split references into old and new so we know whether to initialize or update
            var old_references = {};
            var new_references = {};
            for (var id in references) {
                var value = references[id];
                if (id in this._all_models)
                    old_references[id] = value;
                else
                    new_references[id] = value;
            }
            Document._initialize_references_json(references_json, old_references, new_references);
            for (var _a = 0, events_json_2 = events_json; _a < events_json_2.length; _a++) {
                var event_json = events_json_2[_a];
                switch (event_json.kind) {
                case 'ModelChanged': {
                        var patched_id = event_json.model.id;
                        if (!(patched_id in this._all_models)) {
                            throw new Error('Cannot apply patch to ' + patched_id + ' which is not in the document');
                        }
                        var patched_obj = this._all_models[patched_id];
                        var attr = event_json.attr;
                        var model_type = event_json.model.type;
                        // XXXX currently still need this first branch, some updates (initial?) go through here
                        if (attr === 'data' && model_type === 'ColumnDataSource') {
                            var _b = serialization_1.decode_column_data(event_json.new, buffers), data = _b[0], shapes = _b[1];
                            patched_obj.setv({
                                _shapes: shapes,
                                data: data
                            }, { setter_id: setter_id });
                        } else {
                            var value = Document._resolve_refs(event_json.new, old_references, new_references);
                            patched_obj.setv((_c = {}, _c[attr] = value, _c), { setter_id: setter_id });
                        }
                        break;
                    }
                case 'ColumnDataChanged': {
                        var column_source_id = event_json.column_source.id;
                        if (!(column_source_id in this._all_models)) {
                            throw new Error('Cannot stream to ' + column_source_id + ' which is not in the document');
                        }
                        var column_source = this._all_models[column_source_id];
                        var _d = serialization_1.decode_column_data(event_json.new, buffers), data = _d[0], shapes = _d[1];
                        if (event_json.cols != null) {
                            for (var k in column_source.data) {
                                if (!(k in data)) {
                                    data[k] = column_source.data[k];
                                }
                            }
                            for (var k in column_source._shapes) {
                                if (!(k in shapes)) {
                                    shapes[k] = column_source._shapes[k];
                                }
                            }
                        }
                        column_source.setv({
                            _shapes: shapes,
                            data: data
                        }, {
                            setter_id: setter_id,
                            check_eq: false
                        });
                        break;
                    }
                case 'ColumnsStreamed': {
                        var column_source_id = event_json.column_source.id;
                        if (!(column_source_id in this._all_models)) {
                            throw new Error('Cannot stream to ' + column_source_id + ' which is not in the document');
                        }
                        var column_source = this._all_models[column_source_id];
                        if (!(column_source instanceof column_data_source_1.ColumnDataSource)) {
                            throw new Error('Cannot stream to non-ColumnDataSource');
                        }
                        var data = event_json.data;
                        var rollover = event_json.rollover;
                        column_source.stream(data, rollover);
                        break;
                    }
                case 'ColumnsPatched': {
                        var column_source_id = event_json.column_source.id;
                        if (!(column_source_id in this._all_models)) {
                            throw new Error('Cannot patch ' + column_source_id + ' which is not in the document');
                        }
                        var column_source = this._all_models[column_source_id];
                        if (!(column_source instanceof column_data_source_1.ColumnDataSource)) {
                            throw new Error('Cannot patch non-ColumnDataSource');
                        }
                        var patches = event_json.patches;
                        column_source.patch(patches);
                        break;
                    }
                case 'RootAdded': {
                        var root_id = event_json.model.id;
                        var root_obj = references[root_id];
                        this.add_root(root_obj, setter_id);
                        // XXX: HasProps
                        break;
                    }
                case 'RootRemoved': {
                        var root_id = event_json.model.id;
                        var root_obj = references[root_id];
                        this.remove_root(root_obj, setter_id);
                        // XXX: HasProps
                        break;
                    }
                case 'TitleChanged': {
                        this.set_title(event_json.title, setter_id);
                        break;
                    }
                default:
                    throw new Error('Unknown patch event ' + JSON.stringify(event_json));
                }
            }
            var _c;
        };
        return Document;
    }();
    exports.Document = Document;    
},
/*embed*/
function _(require, module, exports) {
    var base = require(0    /* ./base */);
    var logging_1 = require(14    /* ./core/logging */);
    var document_1 = require(48    /* ./document */);
    var dom_1 = require(5    /* ./core/dom */);
    var callback_1 = require(25    /* ./core/util/callback */);
    var string_1 = require(38    /* ./core/util/string */);
    var object_1 = require(31    /* ./core/util/object */);
    var types_1 = require(43    /* ./core/util/types */);
    var receiver_1 = require(251    /* ./protocol/receiver */);
    var connection_1 = require(1    /* ./client/connection */);
    // Matches Bokeh CSS class selector. Setting all Bokeh parent element class names
    // with this var prevents user configurations where css styling is unset.
    exports.BOKEH_ROOT = 'bk-root';
    function _handle_notebook_comms(receiver, comm_msg) {
        if (comm_msg.buffers.length > 0)
            receiver.consume(comm_msg.buffers[0].buffer);
        else
            receiver.consume(comm_msg.content.data);
        var msg = receiver.message;
        if (msg != null)
            this.apply_json_patch(msg.content, msg.buffers);
    }
    function _update_comms_callback(target, doc, comm) {
        if (target == comm.target_name) {
            var r = new receiver_1.Receiver();
            comm.on_msg(_handle_notebook_comms.bind(doc, r));
        }
    }
    function _init_comms(target, doc) {
        if (typeof Jupyter !== 'undefined' && Jupyter.notebook.kernel != null) {
            logging_1.logger.info('Registering Jupyter comms for target ' + target);
            var comm_manager = Jupyter.notebook.kernel.comm_manager;
            var update_comms = function (comm) {
                return _update_comms_callback(target, doc, comm);
            };
            for (var id in comm_manager.comms) {
                var promise = comm_manager.comms[id];
                promise.then(update_comms);
            }
            try {
                comm_manager.register_target(target, function (comm) {
                    logging_1.logger.info('Registering Jupyter comms for target ' + target);
                    var r = new receiver_1.Receiver();
                    comm.on_msg(_handle_notebook_comms.bind(doc, r));
                });
            } catch (e) {
                logging_1.logger.warn('Jupyter comms failed to register. push_notebook() will not function. (exception reported: ' + e + ')');
            }
        } else
            console.warn('Jupyter notebooks comms not available. push_notebook() will not function');
    }
    function _create_view(model) {
        var view = new model.default_view({
            model: model,
            parent: null
        });
        base.index[model.id] = view;
        return view;
    }
    function _get_element(item) {
        var element_id = item.elementid;
        var elem = document.getElementById(element_id);
        if (elem == null)
            throw new Error('Error rendering Bokeh model: could not find tag with id: ' + element_id);
        if (!document.body.contains(elem))
            throw new Error('Error rendering Bokeh model: element with id \'' + element_id + '\' must be under <body>');
        // if autoload script, replace script tag with div for embedding
        if (elem.tagName == 'SCRIPT') {
            fill_render_item_from_script_tag(elem, item);
            var container = dom_1.div({ class: exports.BOKEH_ROOT });
            dom_1.replaceWith(elem, container);
            var child = dom_1.div();
            container.appendChild(child);
            elem = child;
        }
        return elem;
    }
    // Replace element with a view of model_id from document
    function add_model_standalone(model_id, element, doc) {
        var model = doc.get_model_by_id(model_id);
        if (model == null)
            throw new Error('Model ' + model_id + ' was not in document ' + doc);
        var view = _create_view(model);
        view.renderTo(element, true);
        return view;
    }
    exports.add_model_standalone = add_model_standalone;
    // Fill element with the roots from doc
    function add_document_standalone(document, element, use_for_title) {
        if (use_for_title === void 0) {
            use_for_title = false;
        }
        // this is a LOCAL index of views used only by this particular rendering
        // call, so we can remove the views we create.
        var views = {};
        function render_model(model) {
            var view = _create_view(model);
            view.renderTo(element);
            views[model.id] = view;
        }
        function unrender_model(model) {
            if (model.id in views) {
                var view = views[model.id];
                element.removeChild(view.el);
                delete views[model.id];
                delete base.index[model.id];
            }
        }
        for (var _i = 0, _a = document.roots(); _i < _a.length; _i++) {
            var model = _a[_i];
            render_model(model);
        }
        if (use_for_title)
            window.document.title = document.title();
        document.on_change(function (event) {
            if (event instanceof document_1.RootAddedEvent)
                render_model(event.model);
            else if (event instanceof document_1.RootRemovedEvent)
                unrender_model(event.model);
            else if (use_for_title && event instanceof document_1.TitleChangedEvent)
                window.document.title = event.title;
        });
        return views;
    }
    exports.add_document_standalone = add_document_standalone;
    // map { websocket url to map { session id to promise of ClientSession } }
    var _sessions = {};
    function _get_session(websocket_url, session_id, args_string) {
        if (!(websocket_url in _sessions))
            _sessions[websocket_url] = {};
        var subsessions = _sessions[websocket_url];
        if (!(session_id in subsessions))
            subsessions[session_id] = connection_1.pull_session(websocket_url, session_id, args_string);
        return subsessions[session_id];
    }
    // Fill element with the roots from session_id
    function add_document_from_session(element, websocket_url, session_id, use_for_title) {
        var args_string = window.location.search.substr(1);
        var promise = _get_session(websocket_url, session_id, args_string);
        return promise.then(function (session) {
            return add_document_standalone(session.document, element, use_for_title);
        }, function (error) {
            logging_1.logger.error('Failed to load Bokeh session ' + session_id + ': ' + error);
            throw error;
        });
    }
    exports.add_document_from_session = add_document_from_session;
    // Replace element with a view of model_id from the given session
    function add_model_from_session(element, websocket_url, model_id, session_id) {
        var args_string = window.location.search.substr(1);
        var promise = _get_session(websocket_url, session_id, args_string);
        return promise.then(function (session) {
            var model = session.document.get_model_by_id(model_id);
            if (model == null)
                throw new Error('Did not find model ' + model_id + ' in session');
            var view = _create_view(model);
            view.renderTo(element, true);
            return view;
        }, function (error) {
            logging_1.logger.error('Failed to load Bokeh session ' + session_id + ': ' + error);
            throw error;
        });
    }
    exports.add_model_from_session = add_model_from_session;
    function inject_css(url) {
        var element = dom_1.link({
            href: url,
            rel: 'stylesheet',
            type: 'text/css'
        });
        document.body.appendChild(element);
    }
    exports.inject_css = inject_css;
    function inject_raw_css(css) {
        var element = dom_1.style({}, css);
        document.body.appendChild(element);
    }
    exports.inject_raw_css = inject_raw_css;
    // pull missing render item fields from data- attributes
    function fill_render_item_from_script_tag(script, item) {
        var _a = script.dataset, bokehLogLevel = _a.bokehLogLevel, bokehDocId = _a.bokehDocId, bokehModelId = _a.bokehModelId, bokehSessionId = _a.bokehSessionId;
        // length checks are because we put all the attributes on the tag
        // but sometimes set them to empty string
        if (bokehLogLevel != null && bokehLogLevel.length > 0)
            logging_1.set_log_level(bokehLogLevel);
        if (bokehDocId != null && bokehDocId.length > 0)
            item.docid = bokehDocId;
        if (bokehModelId != null && bokehModelId.length > 0)
            item.modelid = bokehModelId;
        if (bokehSessionId != null && bokehSessionId.length > 0)
            item.sessionid = bokehSessionId;
        logging_1.logger.info('Will inject Bokeh script tag with params ' + JSON.stringify(item));
    }
    function embed_items_notebook(docs_json, render_items) {
        if (object_1.size(docs_json) != 1)
            throw new Error('embed_items_notebook expects exactly one document in docs_json');
        var doc = document_1.Document.from_json(object_1.values(docs_json)[0]);
        for (var _i = 0, render_items_1 = render_items; _i < render_items_1.length; _i++) {
            var item = render_items_1[_i];
            if (item.notebook_comms_target != null)
                _init_comms(item.notebook_comms_target, doc);
            var elem = _get_element(item);
            if (item.modelid != null)
                add_model_standalone(item.modelid, elem, doc);
            else
                add_document_standalone(doc, elem, false);
        }
    }
    exports.embed_items_notebook = embed_items_notebook;
    function _get_ws_url(app_path, absolute_url) {
        var protocol = 'ws:';
        if (window.location.protocol == 'https:')
            protocol = 'wss:';
        var loc;
        if (absolute_url != null) {
            loc = document.createElement('a');
            loc.href = absolute_url;
        } else
            loc = window.location;
        if (app_path != null) {
            if (app_path == '/')
                app_path = '';
        } else
            app_path = loc.pathname.replace(/\/+$/, '');
        return protocol + '//' + loc.host + app_path + '/ws';
    }
    // TODO (bev) this is currently clunky. Standalone embeds only provide
    // the first two args, whereas server provide the app_app, and *may* prove and
    // absolute_url as well if non-relative links are needed for resources. This function
    // should probably be split in to two pieces to reflect the different usage patterns
    function embed_items(docs_json, render_items, app_path, absolute_url) {
        callback_1.defer(function () {
            return _embed_items(docs_json, render_items, app_path, absolute_url);
        });
    }
    exports.embed_items = embed_items;
    function _embed_items(docs_json, render_items, app_path, absolute_url) {
        if (types_1.isString(docs_json))
            docs_json = JSON.parse(string_1.unescape(docs_json));
        var docs = {};
        for (var docid in docs_json) {
            var doc_json = docs_json[docid];
            docs[docid] = document_1.Document.from_json(doc_json);
        }
        for (var _i = 0, render_items_2 = render_items; _i < render_items_2.length; _i++) {
            var item = render_items_2[_i];
            var elem = _get_element(item);
            var use_for_title = item.use_for_title != null && item.use_for_title;
            // handle server session cases
            if (item.sessionid != null) {
                var websocket_url = _get_ws_url(app_path, absolute_url);
                logging_1.logger.debug('embed: computed ws url: ' + websocket_url);
                var promise = void 0;
                if (item.modelid != null)
                    promise = add_model_from_session(elem, websocket_url, item.modelid, item.sessionid);
                else
                    promise = add_document_from_session(elem, websocket_url, item.sessionid, use_for_title);
                promise.then(function () {
                    console.log('Bokeh items were rendered successfully');
                }, function (error) {
                    console.log('Error rendering Bokeh items ', error);
                });    // handle standalone document cases
            } else if (item.docid != null) {
                if (item.modelid != null)
                    add_model_standalone(item.modelid, elem, docs[item.docid]);
                else
                    add_document_standalone(docs[item.docid], elem, use_for_title);
            } else
                throw new Error('Error rendering Bokeh items to element ' + item.elementid + ': no document ID or session ID specified');
        }
    }    
},
/*main*/
function _(require, module, exports) {
    require(249    /* ./polyfill */);
    var version_1 = require(253    /* ./version */);
    exports.version = version_1.version;
    var embed = require(49    /* ./embed */);
    exports.embed = embed;
    var logging_1 = require(14    /* ./core/logging */);
    exports.logger = logging_1.logger;
    exports.set_log_level = logging_1.set_log_level;
    var settings_1 = require(19    /* ./core/settings */);
    exports.settings = settings_1.settings;
    var base_1 = require(0    /* ./base */);
    exports.Models = base_1.Models;
    exports.index = base_1.index;
    var document_1 = require(48    /* ./document */);
    exports.documents = document_1.documents;
    var safely_1 = require(252    /* ./safely */);
    exports.safely = safely_1.safely;    
},
/*model*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    var has_props_1 = require(8    /* ./core/has_props */);
    var p = require(15    /* ./core/properties */);
    var types_1 = require(43    /* ./core/util/types */);
    var object_1 = require(31    /* ./core/util/object */);
    var logging_1 = require(14    /* ./core/logging */);
    var Model = function (_super) {
        tslib_1.__extends(Model, _super);
        function Model(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        Model.initClass = function () {
            this.prototype.type = 'Model';
            this.define({
                tags: [
                    p.Array,
                    []
                ],
                name: [p.String],
                js_property_callbacks: [
                    p.Any,
                    {}
                ],
                js_event_callbacks: [
                    p.Any,
                    {}
                ],
                subscribed_events: [
                    p.Array,
                    []
                ]
            });
        };
        Model.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            for (var base_evt in this.js_property_callbacks) {
                var callbacks = this.js_property_callbacks[base_evt];
                var _a = base_evt.split(':'), evt = _a[0], _b = _a[1], attr = _b === void 0 ? null : _b;
                var _loop_1 = function (cb) {
                    var signal = attr != null ? this_1.properties[attr][evt] : this_1[evt];
                    this_1.connect(signal, function () {
                        return cb.execute(_this, {});
                    });
                };
                var this_1 = this;
                for (var _i = 0, callbacks_1 = callbacks; _i < callbacks_1.length; _i++) {
                    var cb = callbacks_1[_i];
                    _loop_1(cb);
                }
            }
            this.connect(this.properties.js_event_callbacks.change, function () {
                return _this._update_event_callbacks;
            });
            this.connect(this.properties.subscribed_events.change, function () {
                return _this._update_event_callbacks;
            });
        };
        /*protected*/
        Model.prototype._process_event = function (event) {
            if (event.is_applicable_to(this)) {
                event = event._customize_event(this);
                for (var _i = 0, _a = this.js_event_callbacks[event.event_name] || []; _i < _a.length; _i++) {
                    var callback = _a[_i];
                    callback.execute(event, {});
                }
                if (this.document != null) {
                    if (this.subscribed_events.some(function (m) {
                            return m == event.event_name;
                        }))
                        this.document.event_manager.send_event(event);
                }
            }
        };
        Model.prototype.trigger_event = function (event) {
            if (this.document != null)
                this.document.event_manager.trigger(event.set_model_id(this.id));
        };
        Model.prototype._update_event_callbacks = function () {
            if (this.document == null) {
                // File an issue: SidePanel in particular seems to have this issue
                logging_1.logger.warn('WARNING: Document not defined for updating event callbacks');
                return;
            }
            this.document.event_manager.subscribed_models.push(this.id);
        };
        Model.prototype._doc_attached = function () {
            if (!object_1.isEmpty(this.js_event_callbacks) || !object_1.isEmpty(this.subscribed_events))
                this._update_event_callbacks();
        };
        Model.prototype.select = function (selector) {
            if (types_1.isString(selector))
                return this.references().filter(function (ref) {
                    return ref instanceof Model && ref.name === selector;
                });
            else if (selector.prototype instanceof has_props_1.HasProps)
                return this.references().filter(function (ref) {
                    return ref instanceof selector;
                });
            else
                throw new Error('invalid selector');
        };
        Model.prototype.select_one = function (selector) {
            var result = this.select(selector);
            switch (result.length) {
            case 0:
                return null;
            case 1:
                return result[0];
            default:
                throw new Error('found more than one object matching given selector');
            }
        };
        return Model;
    }(has_props_1.HasProps);
    exports.Model = Model;
    Model.initClass();    
},
/*models/annotations/annotation*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    var side_panel_1 = require(12    /* core/layout/side_panel */);
    var p = require(15    /* core/properties */);
    var renderer_1 = require(166    /* ../renderers/renderer */);
    var AnnotationView = function (_super) {
        tslib_1.__extends(AnnotationView, _super);
        function AnnotationView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        AnnotationView.prototype._get_size = function () {
            throw new Error('not implemented');
        };
        AnnotationView.prototype.get_size = function () {
            return this.model.visible ? Math.round(this._get_size()) : 0;
        };
        return AnnotationView;
    }(renderer_1.RendererView);
    exports.AnnotationView = AnnotationView;
    var Annotation = function (_super) {
        tslib_1.__extends(Annotation, _super);
        function Annotation(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        Annotation.initClass = function () {
            this.prototype.type = 'Annotation';
            this.define({ plot: [p.Instance] });
            this.override({ level: 'annotation' });
        };
        Annotation.prototype.add_panel = function (side) {
            if (this.panel == null || side !== this.panel.side) {
                var panel = new side_panel_1.SidePanel({ side: side });
                panel.attach_document(this.document);
                this.set_panel(panel);
            }
        };
        Annotation.prototype.set_panel = function (panel) {
            this.panel = panel;
            // If the annotation is in a side panel, we need to set level to overlay, so it is visible.
            this.level = 'overlay';
        };
        return Annotation;
    }(renderer_1.Renderer);
    exports.Annotation = Annotation;
    Annotation.initClass();    
},
/*models/annotations/arrow*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    /* XXX: partial */
    var annotation_1 = require(52    /* ./annotation */);
    var arrow_head_1 = require(54    /* ./arrow_head */);
    var column_data_source_1 = require(174    /* ../sources/column_data_source */);
    var p = require(15    /* core/properties */);
    var math_1 = require(30    /* core/util/math */);
    var ArrowView = function (_super) {
        tslib_1.__extends(ArrowView, _super);
        function ArrowView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        ArrowView.prototype.initialize = function (options) {
            _super.prototype.initialize.call(this, options);
            if (this.model.source == null) {
                this.model.source = new column_data_source_1.ColumnDataSource();
            }
            this.set_data(this.model.source);
        };
        ArrowView.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            this.connect(this.model.change, function () {
                return _this.plot_view.request_render();
            });
            this.connect(this.model.source.streaming, function () {
                return _this.set_data(_this.model.source);
            });
            this.connect(this.model.source.patching, function () {
                return _this.set_data(_this.model.source);
            });
            this.connect(this.model.source.change, function () {
                return _this.set_data(_this.model.source);
            });
        };
        ArrowView.prototype.set_data = function (source) {
            _super.prototype.set_data.call(this, source);
            this.visuals.warm_cache(source);
            return this.plot_view.request_render();
        };
        ArrowView.prototype._map_data = function () {
            var sx_end, sx_start, sy_end, sy_start;
            var frame = this.plot_view.frame;
            if (this.model.start_units === 'data') {
                sx_start = frame.xscales[this.model.x_range_name].v_compute(this._x_start);
                sy_start = frame.yscales[this.model.y_range_name].v_compute(this._y_start);
            } else {
                sx_start = frame.xview.v_compute(this._x_start);
                sy_start = frame.yview.v_compute(this._y_start);
            }
            if (this.model.end_units === 'data') {
                sx_end = frame.xscales[this.model.x_range_name].v_compute(this._x_end);
                sy_end = frame.yscales[this.model.y_range_name].v_compute(this._y_end);
            } else {
                sx_end = frame.xview.v_compute(this._x_end);
                sy_end = frame.yview.v_compute(this._y_end);
            }
            var start = [
                sx_start,
                sy_start
            ];
            var end = [
                sx_end,
                sy_end
            ];
            return [
                start,
                end
            ];
        };
        ArrowView.prototype.render = function () {
            if (!this.model.visible) {
                return;
            }
            var ctx = this.plot_view.canvas_view.ctx;
            ctx.save();
            // Order in this function is important. First we draw all the arrow heads.
            _a = this._map_data(), this.start = _a[0], this.end = _a[1];
            if (this.model.end != null) {
                this._arrow_head(ctx, 'render', this.model.end, this.start, this.end);
            }
            if (this.model.start != null) {
                this._arrow_head(ctx, 'render', this.model.start, this.end, this.start);
            }
            // Next we call .clip on all the arrow heads, inside an initial canvas sized
            // rect, to create an "inverted" clip region for the arrow heads
            ctx.beginPath();
            var _b = this.plot_model.canvas.bbox.rect, x = _b.x, y = _b.y, width = _b.width, height = _b.height;
            ctx.rect(x, y, width, height);
            if (this.model.end != null) {
                this._arrow_head(ctx, 'clip', this.model.end, this.start, this.end);
            }
            if (this.model.start != null) {
                this._arrow_head(ctx, 'clip', this.model.start, this.end, this.start);
            }
            ctx.closePath();
            ctx.clip();
            // Finally we draw the arrow body, with the clipping regions set up. This prevents
            // "fat" arrows from overlapping the arrow head in a bad way.
            this._arrow_body(ctx);
            return ctx.restore();
            var _a;
        };
        ArrowView.prototype._arrow_body = function (ctx) {
            if (!this.visuals.line.doit)
                return;
            for (var i = 0, end = this._x_start.length; i < end; i++) {
                this.visuals.line.set_vectorize(ctx, i);
                ctx.beginPath();
                ctx.moveTo(this.start[0][i], this.start[1][i]);
                ctx.lineTo(this.end[0][i], this.end[1][i]);
                ctx.stroke();
            }
        };
        ArrowView.prototype._arrow_head = function (ctx, action, head, start, end) {
            for (var i = 0, _end = this._x_start.length; i < _end; i++) {
                // arrow head runs orthogonal to arrow body
                var angle = Math.PI / 2 + math_1.atan2([
                    start[0][i],
                    start[1][i]
                ], [
                    end[0][i],
                    end[1][i]
                ]);
                ctx.save();
                ctx.translate(end[0][i], end[1][i]);
                ctx.rotate(angle);
                if (action === 'render') {
                    head.render(ctx);
                } else if (action === 'clip') {
                    head.clip(ctx);
                }
                ctx.restore();
            }
        };
        return ArrowView;
    }(annotation_1.AnnotationView);
    exports.ArrowView = ArrowView;
    var Arrow = function (_super) {
        tslib_1.__extends(Arrow, _super);
        function Arrow(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        Arrow.initClass = function () {
            this.prototype.type = 'Arrow';
            this.prototype.default_view = ArrowView;
            this.mixins(['line']);
            this.define({
                x_start: [p.NumberSpec],
                y_start: [p.NumberSpec],
                start_units: [
                    p.String,
                    'data'
                ],
                start: [
                    p.Instance,
                    null
                ],
                x_end: [p.NumberSpec],
                y_end: [p.NumberSpec],
                end_units: [
                    p.String,
                    'data'
                ],
                end: [
                    p.Instance,
                    function () {
                        return new arrow_head_1.OpenHead({});
                    }
                ],
                source: [p.Instance],
                x_range_name: [
                    p.String,
                    'default'
                ],
                y_range_name: [
                    p.String,
                    'default'
                ]
            });
        };
        return Arrow;
    }(annotation_1.Annotation);
    exports.Arrow = Arrow;
    Arrow.initClass();    
},
/*models/annotations/arrow_head*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    var annotation_1 = require(52    /* ./annotation */);
    var visuals_1 = require(47    /* core/visuals */);
    var p = require(15    /* core/properties */);
    var ArrowHead = function (_super) {
        tslib_1.__extends(ArrowHead, _super);
        function ArrowHead(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        ArrowHead.initClass = function () {
            this.prototype.type = 'ArrowHead';
            this.define({
                size: [
                    p.Number,
                    25
                ]
            });
        };
        ArrowHead.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            this.visuals = new visuals_1.Visuals(this);
        };
        return ArrowHead;
    }(annotation_1.Annotation);
    exports.ArrowHead = ArrowHead;
    ArrowHead.initClass();
    var OpenHead = function (_super) {
        tslib_1.__extends(OpenHead, _super);
        function OpenHead(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        OpenHead.initClass = function () {
            this.prototype.type = 'OpenHead';
            this.mixins(['line']);
        };
        OpenHead.prototype.clip = function (ctx, i) {
            // This method should not begin or close a path
            this.visuals.line.set_vectorize(ctx, i);
            ctx.moveTo(0.5 * this.size, this.size);
            ctx.lineTo(0.5 * this.size, -2);
            ctx.lineTo(-0.5 * this.size, -2);
            ctx.lineTo(-0.5 * this.size, this.size);
            ctx.lineTo(0, 0);
            ctx.lineTo(0.5 * this.size, this.size);
        };
        OpenHead.prototype.render = function (ctx, i) {
            if (this.visuals.line.doit) {
                this.visuals.line.set_vectorize(ctx, i);
                ctx.beginPath();
                ctx.moveTo(0.5 * this.size, this.size);
                ctx.lineTo(0, 0);
                ctx.lineTo(-0.5 * this.size, this.size);
                ctx.stroke();
            }
        };
        return OpenHead;
    }(ArrowHead);
    exports.OpenHead = OpenHead;
    OpenHead.initClass();
    var NormalHead = function (_super) {
        tslib_1.__extends(NormalHead, _super);
        function NormalHead(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        NormalHead.initClass = function () {
            this.prototype.type = 'NormalHead';
            this.mixins([
                'line',
                'fill'
            ]);
            this.override({ fill_color: 'black' });
        };
        NormalHead.prototype.clip = function (ctx, i) {
            // This method should not begin or close a path
            this.visuals.line.set_vectorize(ctx, i);
            ctx.moveTo(0.5 * this.size, this.size);
            ctx.lineTo(0.5 * this.size, -2);
            ctx.lineTo(-0.5 * this.size, -2);
            ctx.lineTo(-0.5 * this.size, this.size);
            ctx.lineTo(0.5 * this.size, this.size);
        };
        NormalHead.prototype.render = function (ctx, i) {
            if (this.visuals.fill.doit) {
                this.visuals.fill.set_vectorize(ctx, i);
                this._normal(ctx, i);
                ctx.fill();
            }
            if (this.visuals.line.doit) {
                this.visuals.line.set_vectorize(ctx, i);
                this._normal(ctx, i);
                ctx.stroke();
            }
        };
        NormalHead.prototype._normal = function (ctx, _i) {
            ctx.beginPath();
            ctx.moveTo(0.5 * this.size, this.size);
            ctx.lineTo(0, 0);
            ctx.lineTo(-0.5 * this.size, this.size);
            ctx.closePath();
        };
        return NormalHead;
    }(ArrowHead);
    exports.NormalHead = NormalHead;
    NormalHead.initClass();
    var VeeHead = function (_super) {
        tslib_1.__extends(VeeHead, _super);
        function VeeHead(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        VeeHead.initClass = function () {
            this.prototype.type = 'VeeHead';
            this.mixins([
                'line',
                'fill'
            ]);
            this.override({ fill_color: 'black' });
        };
        VeeHead.prototype.clip = function (ctx, i) {
            // This method should not begin or close a path
            this.visuals.line.set_vectorize(ctx, i);
            ctx.moveTo(0.5 * this.size, this.size);
            ctx.lineTo(0.5 * this.size, -2);
            ctx.lineTo(-0.5 * this.size, -2);
            ctx.lineTo(-0.5 * this.size, this.size);
            ctx.lineTo(0, 0.5 * this.size);
            ctx.lineTo(0.5 * this.size, this.size);
        };
        VeeHead.prototype.render = function (ctx, i) {
            if (this.visuals.fill.doit) {
                this.visuals.fill.set_vectorize(ctx, i);
                this._vee(ctx, i);
                ctx.fill();
            }
            if (this.visuals.line.doit) {
                this.visuals.line.set_vectorize(ctx, i);
                this._vee(ctx, i);
                ctx.stroke();
            }
        };
        VeeHead.prototype._vee = function (ctx, _i) {
            ctx.beginPath();
            ctx.moveTo(0.5 * this.size, this.size);
            ctx.lineTo(0, 0);
            ctx.lineTo(-0.5 * this.size, this.size);
            ctx.lineTo(0, 0.5 * this.size);
            ctx.closePath();
        };
        return VeeHead;
    }(ArrowHead);
    exports.VeeHead = VeeHead;
    VeeHead.initClass();
    var TeeHead = function (_super) {
        tslib_1.__extends(TeeHead, _super);
        function TeeHead(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        TeeHead.initClass = function () {
            this.prototype.type = 'TeeHead';
            this.mixins(['line']);
        };
        TeeHead.prototype.render = function (ctx, i) {
            if (this.visuals.line.doit) {
                this.visuals.line.set_vectorize(ctx, i);
                ctx.beginPath();
                ctx.moveTo(0.5 * this.size, 0);
                ctx.lineTo(-0.5 * this.size, 0);
                ctx.stroke();
            }
        };
        TeeHead.prototype.clip = function (_ctx, _i) {
        };
        return TeeHead;
    }(ArrowHead);
    exports.TeeHead = TeeHead;
    TeeHead.initClass();    
},
/*models/annotations/band*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    /* XXX: partial */
    var annotation_1 = require(52    /* ./annotation */);
    var column_data_source_1 = require(174    /* ../sources/column_data_source */);
    var p = require(15    /* core/properties */);
    var BandView = function (_super) {
        tslib_1.__extends(BandView, _super);
        function BandView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        BandView.prototype.initialize = function (options) {
            _super.prototype.initialize.call(this, options);
            this.set_data(this.model.source);
        };
        BandView.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            this.connect(this.model.source.streaming, function () {
                return _this.set_data(_this.model.source);
            });
            this.connect(this.model.source.patching, function () {
                return _this.set_data(_this.model.source);
            });
            this.connect(this.model.source.change, function () {
                return _this.set_data(_this.model.source);
            });
        };
        BandView.prototype.set_data = function (source) {
            _super.prototype.set_data.call(this, source);
            this.visuals.warm_cache(source);
            return this.plot_view.request_render();
        };
        BandView.prototype._map_data = function () {
            var _base_sx, _lower_sx, _upper_sx;
            var frame = this.plot_view.frame;
            var dim = this.model.dimension;
            var xscale = frame.xscales[this.model.x_range_name];
            var yscale = frame.yscales[this.model.y_range_name];
            var limit_scale = dim === 'height' ? yscale : xscale;
            var base_scale = dim === 'height' ? xscale : yscale;
            var limit_view = dim === 'height' ? frame.yview : frame.xview;
            var base_view = dim === 'height' ? frame.xview : frame.yview;
            if (this.model.lower.units === 'data') {
                _lower_sx = limit_scale.v_compute(this._lower);
            } else {
                _lower_sx = limit_view.v_compute(this._lower);
            }
            if (this.model.upper.units === 'data') {
                _upper_sx = limit_scale.v_compute(this._upper);
            } else {
                _upper_sx = limit_view.v_compute(this._upper);
            }
            if (this.model.base.units === 'data') {
                _base_sx = base_scale.v_compute(this._base);
            } else {
                _base_sx = base_view.v_compute(this._base);
            }
            var _a = dim === 'height' ? [
                    1,
                    0
                ] : [
                    0,
                    1
                ], i = _a[0], j = _a[1];
            var _lower = [
                _lower_sx,
                _base_sx
            ];
            var _upper = [
                _upper_sx,
                _base_sx
            ];
            this._lower_sx = _lower[i];
            this._lower_sy = _lower[j];
            this._upper_sx = _upper[i];
            return this._upper_sy = _upper[j];
        };
        BandView.prototype.render = function () {
            if (!this.model.visible) {
                return;
            }
            this._map_data();
            var ctx = this.plot_view.canvas_view.ctx;
            // Draw the band body
            ctx.beginPath();
            ctx.moveTo(this._lower_sx[0], this._lower_sy[0]);
            for (var i = 0, end = this._lower_sx.length; i < end; i++) {
                ctx.lineTo(this._lower_sx[i], this._lower_sy[i]);
            }
            // iterate backwards so that the upper end is below the lower start
            for (var start = this._upper_sx.length - 1, i = start; i >= 0; i--) {
                ctx.lineTo(this._upper_sx[i], this._upper_sy[i]);
            }
            ctx.closePath();
            if (this.visuals.fill.doit) {
                this.visuals.fill.set_value(ctx);
                ctx.fill();
            }
            // Draw the lower band edge
            ctx.beginPath();
            ctx.moveTo(this._lower_sx[0], this._lower_sy[0]);
            for (var i = 0, end = this._lower_sx.length; i < end; i++) {
                ctx.lineTo(this._lower_sx[i], this._lower_sy[i]);
            }
            if (this.visuals.line.doit) {
                this.visuals.line.set_value(ctx);
                ctx.stroke();
            }
            // Draw the upper band edge
            ctx.beginPath();
            ctx.moveTo(this._upper_sx[0], this._upper_sy[0]);
            for (var i = 0, end = this._upper_sx.length; i < end; i++) {
                ctx.lineTo(this._upper_sx[i], this._upper_sy[i]);
            }
            if (this.visuals.line.doit) {
                this.visuals.line.set_value(ctx);
                return ctx.stroke();
            }
        };
        return BandView;
    }(annotation_1.AnnotationView);
    exports.BandView = BandView;
    var Band = function (_super) {
        tslib_1.__extends(Band, _super);
        function Band(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        Band.initClass = function () {
            this.prototype.type = 'Band';
            this.prototype.default_view = BandView;
            this.mixins([
                'line',
                'fill'
            ]);
            this.define({
                lower: [p.DistanceSpec],
                upper: [p.DistanceSpec],
                base: [p.DistanceSpec],
                dimension: [
                    p.Dimension,
                    'height'
                ],
                source: [
                    p.Instance,
                    function () {
                        return new column_data_source_1.ColumnDataSource();
                    }
                ],
                x_range_name: [
                    p.String,
                    'default'
                ],
                y_range_name: [
                    p.String,
                    'default'
                ]
            });
            this.override({
                fill_color: '#fff9ba',
                fill_alpha: 0.4,
                line_color: '#cccccc',
                line_alpha: 0.3
            });
        };
        return Band;
    }(annotation_1.Annotation);
    exports.Band = Band;
    Band.initClass();    
},
/*models/annotations/box_annotation*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    /* XXX: partial */
    var annotation_1 = require(52    /* ./annotation */);
    var signaling_1 = require(20    /* core/signaling */);
    var dom_1 = require(5    /* core/dom */);
    var p = require(15    /* core/properties */);
    var types_1 = require(43    /* core/util/types */);
    var BoxAnnotationView = function (_super) {
        tslib_1.__extends(BoxAnnotationView, _super);
        function BoxAnnotationView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        BoxAnnotationView.prototype.initialize = function (options) {
            _super.prototype.initialize.call(this, options);
            this.plot_view.canvas_overlays.appendChild(this.el);
            this.el.classList.add('bk-shading');
            dom_1.hide(this.el);
        };
        BoxAnnotationView.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            // need to respond to either normal BB change events or silent
            // "data only updates" that tools might want to use
            if (this.model.render_mode === 'css') {
                // dispatch CSS update immediately
                this.connect(this.model.change, function () {
                    return _this.render();
                });
                this.connect(this.model.data_update, function () {
                    return _this.render();
                });
            } else {
                this.connect(this.model.change, function () {
                    return _this.plot_view.request_render();
                });
                this.connect(this.model.data_update, function () {
                    return _this.plot_view.request_render();
                });
            }
        };
        BoxAnnotationView.prototype.render = function () {
            var _this = this;
            if (!this.model.visible && this.model.render_mode === 'css') {
                dom_1.hide(this.el);
            }
            if (!this.model.visible) {
                return;
            }
            // don't render if *all* position are null
            if (this.model.left == null && this.model.right == null && this.model.top == null && this.model.bottom == null) {
                dom_1.hide(this.el);
                return null;
            }
            var frame = this.plot_model.frame;
            var xscale = frame.xscales[this.model.x_range_name];
            var yscale = frame.yscales[this.model.y_range_name];
            var _calc_dim = function (dim, dim_units, scale, view, frame_extrema) {
                var sdim;
                if (dim != null) {
                    if (_this.model.screen) {
                        sdim = dim;
                    } else {
                        if (dim_units === 'data') {
                            sdim = scale.compute(dim);
                        } else {
                            sdim = view.compute(dim);
                        }
                    }
                } else {
                    sdim = frame_extrema;
                }
                return sdim;
            };
            var sleft = _calc_dim(this.model.left, this.model.left_units, xscale, frame.xview, frame._left.value);
            var sright = _calc_dim(this.model.right, this.model.right_units, xscale, frame.xview, frame._right.value);
            var stop = _calc_dim(this.model.top, this.model.top_units, yscale, frame.yview, frame._top.value);
            var sbottom = _calc_dim(this.model.bottom, this.model.bottom_units, yscale, frame.yview, frame._bottom.value);
            var draw = this.model.render_mode === 'css' ? this._css_box.bind(this) : this._canvas_box.bind(this);
            return draw(sleft, sright, sbottom, stop);
        };
        BoxAnnotationView.prototype._css_box = function (sleft, sright, sbottom, stop) {
            var sw = Math.abs(sright - sleft);
            var sh = Math.abs(sbottom - stop);
            this.el.style.left = sleft + 'px';
            this.el.style.width = sw + 'px';
            this.el.style.top = stop + 'px';
            this.el.style.height = sh + 'px';
            this.el.style.borderWidth = this.model.line_width.value + 'px';
            this.el.style.borderColor = this.model.line_color.value;
            this.el.style.backgroundColor = this.model.fill_color.value;
            this.el.style.opacity = this.model.fill_alpha.value;
            // try our best to honor line dashing in some way, if we can
            var ld = this.model.line_dash;
            if (types_1.isArray(ld)) {
                ld = ld.length < 2 ? 'solid' : 'dashed';
            }
            if (types_1.isString(ld)) {
                this.el.style.borderStyle = ld;
            }
            return dom_1.show(this.el);
        };
        BoxAnnotationView.prototype._canvas_box = function (sleft, sright, sbottom, stop) {
            var ctx = this.plot_view.canvas_view.ctx;
            ctx.save();
            ctx.beginPath();
            ctx.rect(sleft, stop, sright - sleft, sbottom - stop);
            this.visuals.fill.set_value(ctx);
            ctx.fill();
            this.visuals.line.set_value(ctx);
            ctx.stroke();
            return ctx.restore();
        };
        return BoxAnnotationView;
    }(annotation_1.AnnotationView);
    exports.BoxAnnotationView = BoxAnnotationView;
    var BoxAnnotation = function (_super) {
        tslib_1.__extends(BoxAnnotation, _super);
        function BoxAnnotation(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        BoxAnnotation.initClass = function () {
            this.prototype.type = 'BoxAnnotation';
            this.prototype.default_view = BoxAnnotationView;
            this.mixins([
                'line',
                'fill'
            ]);
            this.define({
                render_mode: [
                    p.RenderMode,
                    'canvas'
                ],
                x_range_name: [
                    p.String,
                    'default'
                ],
                y_range_name: [
                    p.String,
                    'default'
                ],
                top: [
                    p.Number,
                    null
                ],
                top_units: [
                    p.SpatialUnits,
                    'data'
                ],
                bottom: [
                    p.Number,
                    null
                ],
                bottom_units: [
                    p.SpatialUnits,
                    'data'
                ],
                left: [
                    p.Number,
                    null
                ],
                left_units: [
                    p.SpatialUnits,
                    'data'
                ],
                right: [
                    p.Number,
                    null
                ],
                right_units: [
                    p.SpatialUnits,
                    'data'
                ]
            });
            this.internal({
                screen: [
                    p.Boolean,
                    false
                ]
            });
            this.override({
                fill_color: '#fff9ba',
                fill_alpha: 0.4,
                line_color: '#cccccc',
                line_alpha: 0.3
            });
        };
        BoxAnnotation.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            this.data_update = new signaling_1.Signal(this, 'data_update');
        };
        BoxAnnotation.prototype.update = function (_a) {
            var left = _a.left, right = _a.right, top = _a.top, bottom = _a.bottom;
            this.setv({
                left: left,
                right: right,
                top: top,
                bottom: bottom,
                screen: true
            }, { silent: true });
            this.data_update.emit();
        };
        return BoxAnnotation;
    }(annotation_1.Annotation);
    exports.BoxAnnotation = BoxAnnotation;
    BoxAnnotation.initClass();    
},
/*models/annotations/color_bar*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    /* XXX: partial */
    var annotation_1 = require(52    /* ./annotation */);
    var basic_ticker_1 = require(181    /* ../tickers/basic_ticker */);
    var basic_tick_formatter_1 = require(92    /* ../formatters/basic_tick_formatter */);
    var linear_color_mapper_1 = require(147    /* ../mappers/linear_color_mapper */);
    var linear_scale_1 = require(169    /* ../scales/linear_scale */);
    var log_scale_1 = require(170    /* ../scales/log_scale */);
    var range1d_1 = require(161    /* ../ranges/range1d */);
    var p = require(15    /* core/properties */);
    var text_util = require(41    /* core/util/text */);
    var array_1 = require(22    /* core/util/array */);
    var object_1 = require(31    /* core/util/object */);
    var types_1 = require(43    /* core/util/types */);
    var SHORT_DIM = 25;
    var LONG_DIM_MIN_SCALAR = 0.3;
    var LONG_DIM_MAX_SCALAR = 0.8;
    var ColorBarView = function (_super) {
        tslib_1.__extends(ColorBarView, _super);
        function ColorBarView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        ColorBarView.prototype.initialize = function (options) {
            _super.prototype.initialize.call(this, options);
            this._set_canvas_image();
        };
        ColorBarView.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            this.connect(this.model.properties.visible.change, function () {
                return _this.plot_view.request_render();
            });
            this.connect(this.model.ticker.change, function () {
                return _this.plot_view.request_render();
            });
            this.connect(this.model.formatter.change, function () {
                return _this.plot_view.request_render();
            });
            if (this.model.color_mapper != null) {
                this.connect(this.model.color_mapper.change, function () {
                    _this._set_canvas_image();
                    _this.plot_view.request_render();
                });
            }
        };
        ColorBarView.prototype._get_size = function () {
            if (this.model.color_mapper == null) {
                return 0;
            }
            var bbox = this.compute_legend_dimensions();
            var side = this.model.panel.side;
            if (side === 'above' || side === 'below') {
                return bbox.height;
            }
            if (side === 'left' || side === 'right') {
                return bbox.width;
            }
        };
        ColorBarView.prototype._set_canvas_image = function () {
            var h, w;
            if (this.model.color_mapper == null) {
                return;
            }
            var palette = this.model.color_mapper.palette;
            if (this.model.orientation === 'vertical') {
                palette = palette.slice(0).reverse();
            }
            switch (this.model.orientation) {
            case 'vertical':
                _a = [
                    1,
                    palette.length
                ], w = _a[0], h = _a[1];
                break;
            case 'horizontal':
                _b = [
                    palette.length,
                    1
                ], w = _b[0], h = _b[1];
                break;
            }
            var canvas = document.createElement('canvas');
            _c = [
                w,
                h
            ], canvas.width = _c[0], canvas.height = _c[1];
            var image_ctx = canvas.getContext('2d');
            var image_data = image_ctx.getImageData(0, 0, w, h);
            // We always want to draw the entire palette linearly, so we create a new
            // LinearColorMapper instance and map a monotonic range of values with
            // length = palette.length to get each palette color in order.
            var cmap = new linear_color_mapper_1.LinearColorMapper({ palette: palette });
            var buf = cmap.v_map_screen(array_1.range(0, palette.length));
            var buf8 = new Uint8Array(buf);
            image_data.data.set(buf8);
            image_ctx.putImageData(image_data, 0, 0);
            return this.image = canvas;
            var _a, _b, _c;
        };
        ColorBarView.prototype.compute_legend_dimensions = function () {
            var legend_height, legend_width;
            var image_dimensions = this.model._computed_image_dimensions();
            var _a = [
                    image_dimensions.height,
                    image_dimensions.width
                ], image_height = _a[0], image_width = _a[1];
            var label_extent = this._get_label_extent();
            var title_extent = this.model._title_extent();
            var tick_extent = this.model._tick_extent();
            var padding = this.model.padding;
            switch (this.model.orientation) {
            case 'vertical':
                legend_height = image_height + title_extent + padding * 2;
                legend_width = image_width + tick_extent + label_extent + padding * 2;
                break;
            case 'horizontal':
                legend_height = image_height + title_extent + tick_extent + label_extent + padding * 2;
                legend_width = image_width + padding * 2;
                break;
            }
            return {
                height: legend_height,
                width: legend_width
            };
        };
        ColorBarView.prototype.compute_legend_location = function () {
            var sx, sy;
            var legend_dimensions = this.compute_legend_dimensions();
            var _a = [
                    legend_dimensions.height,
                    legend_dimensions.width
                ], legend_height = _a[0], legend_width = _a[1];
            var legend_margin = this.model.margin;
            var panel = this.model.panel != null ? this.model.panel : this.plot_view.frame;
            var _b = panel.bbox.ranges, hr = _b[0], vr = _b[1];
            var location = this.model.location;
            if (types_1.isString(location)) {
                switch (location) {
                case 'top_left':
                    sx = hr.start + legend_margin;
                    sy = vr.start + legend_margin;
                    break;
                case 'top_center':
                    sx = (hr.end + hr.start) / 2 - legend_width / 2;
                    sy = vr.start + legend_margin;
                    break;
                case 'top_right':
                    sx = hr.end - legend_margin - legend_width;
                    sy = vr.start + legend_margin;
                    break;
                case 'bottom_right':
                    sx = hr.end - legend_margin - legend_width;
                    sy = vr.end - legend_margin - legend_height;
                    break;
                case 'bottom_center':
                    sx = (hr.end + hr.start) / 2 - legend_width / 2;
                    sy = vr.end - legend_margin - legend_height;
                    break;
                case 'bottom_left':
                    sx = hr.start + legend_margin;
                    sy = vr.end - legend_margin - legend_height;
                    break;
                case 'center_left':
                    sx = hr.start + legend_margin;
                    sy = (vr.end + vr.start) / 2 - legend_height / 2;
                    break;
                case 'center':
                    sx = (hr.end + hr.start) / 2 - legend_width / 2;
                    sy = (vr.end + vr.start) / 2 - legend_height / 2;
                    break;
                case 'center_right':
                    sx = hr.end - legend_margin - legend_width;
                    sy = (vr.end + vr.start) / 2 - legend_height / 2;
                    break;
                }
            } else if (types_1.isArray(location) && location.length === 2) {
                var vx = location[0], vy = location[1];
                sx = panel.xview.compute(vx);
                sy = panel.yview.compute(vy) - legend_height;
            }
            return {
                sx: sx,
                sy: sy
            };
        };
        ColorBarView.prototype.render = function () {
            if (!this.model.visible || this.model.color_mapper == null) {
                return;
            }
            var ctx = this.plot_view.canvas_view.ctx;
            ctx.save();
            var _a = this.compute_legend_location(), sx = _a.sx, sy = _a.sy;
            ctx.translate(sx, sy);
            this._draw_bbox(ctx);
            var image_offset = this._get_image_offset();
            ctx.translate(image_offset.x, image_offset.y);
            this._draw_image(ctx);
            if (this.model.color_mapper.low != null && this.model.color_mapper.high != null) {
                var tick_info = this.model.tick_info();
                this._draw_major_ticks(ctx, tick_info);
                this._draw_minor_ticks(ctx, tick_info);
                this._draw_major_labels(ctx, tick_info);
            }
            if (this.model.title) {
                this._draw_title(ctx);
            }
            return ctx.restore();
        };
        ColorBarView.prototype._draw_bbox = function (ctx) {
            var bbox = this.compute_legend_dimensions();
            ctx.save();
            if (this.visuals.background_fill.doit) {
                this.visuals.background_fill.set_value(ctx);
                ctx.fillRect(0, 0, bbox.width, bbox.height);
            }
            if (this.visuals.border_line.doit) {
                this.visuals.border_line.set_value(ctx);
                ctx.strokeRect(0, 0, bbox.width, bbox.height);
            }
            return ctx.restore();
        };
        ColorBarView.prototype._draw_image = function (ctx) {
            var image = this.model._computed_image_dimensions();
            ctx.save();
            ctx.setImageSmoothingEnabled(false);
            ctx.globalAlpha = this.model.scale_alpha;
            ctx.drawImage(this.image, 0, 0, image.width, image.height);
            if (this.visuals.bar_line.doit) {
                this.visuals.bar_line.set_value(ctx);
                ctx.strokeRect(0, 0, image.width, image.height);
            }
            return ctx.restore();
        };
        ColorBarView.prototype._draw_major_ticks = function (ctx, tick_info) {
            if (!this.visuals.major_tick_line.doit) {
                return;
            }
            var _a = this.model._normals(), nx = _a[0], ny = _a[1];
            var image = this.model._computed_image_dimensions();
            var _b = [
                    image.width * nx,
                    image.height * ny
                ], x_offset = _b[0], y_offset = _b[1];
            var _c = tick_info.coords.major, sx = _c[0], sy = _c[1];
            var tin = this.model.major_tick_in;
            var tout = this.model.major_tick_out;
            ctx.save();
            ctx.translate(x_offset, y_offset);
            this.visuals.major_tick_line.set_value(ctx);
            for (var i = 0, end = sx.length; i < end; i++) {
                ctx.beginPath();
                ctx.moveTo(Math.round(sx[i] + nx * tout), Math.round(sy[i] + ny * tout));
                ctx.lineTo(Math.round(sx[i] - nx * tin), Math.round(sy[i] - ny * tin));
                ctx.stroke();
            }
            return ctx.restore();
        };
        ColorBarView.prototype._draw_minor_ticks = function (ctx, tick_info) {
            if (!this.visuals.minor_tick_line.doit) {
                return;
            }
            var _a = this.model._normals(), nx = _a[0], ny = _a[1];
            var image = this.model._computed_image_dimensions();
            var _b = [
                    image.width * nx,
                    image.height * ny
                ], x_offset = _b[0], y_offset = _b[1];
            var _c = tick_info.coords.minor, sx = _c[0], sy = _c[1];
            var tin = this.model.minor_tick_in;
            var tout = this.model.minor_tick_out;
            ctx.save();
            ctx.translate(x_offset, y_offset);
            this.visuals.minor_tick_line.set_value(ctx);
            for (var i = 0, end = sx.length; i < end; i++) {
                ctx.beginPath();
                ctx.moveTo(Math.round(sx[i] + nx * tout), Math.round(sy[i] + ny * tout));
                ctx.lineTo(Math.round(sx[i] - nx * tin), Math.round(sy[i] - ny * tin));
                ctx.stroke();
            }
            return ctx.restore();
        };
        ColorBarView.prototype._draw_major_labels = function (ctx, tick_info) {
            if (!this.visuals.major_label_text.doit) {
                return;
            }
            var _a = this.model._normals(), nx = _a[0], ny = _a[1];
            var image = this.model._computed_image_dimensions();
            var _b = [
                    image.width * nx,
                    image.height * ny
                ], x_offset = _b[0], y_offset = _b[1];
            var standoff = this.model.label_standoff + this.model._tick_extent();
            var _c = [
                    standoff * nx,
                    standoff * ny
                ], x_standoff = _c[0], y_standoff = _c[1];
            var _d = tick_info.coords.major, sx = _d[0], sy = _d[1];
            var formatted_labels = tick_info.labels.major;
            this.visuals.major_label_text.set_value(ctx);
            ctx.save();
            ctx.translate(x_offset + x_standoff, y_offset + y_standoff);
            for (var i = 0, end = sx.length; i < end; i++) {
                ctx.fillText(formatted_labels[i], Math.round(sx[i] + nx * this.model.label_standoff), Math.round(sy[i] + ny * this.model.label_standoff));
            }
            return ctx.restore();
        };
        ColorBarView.prototype._draw_title = function (ctx) {
            if (!this.visuals.title_text.doit) {
                return;
            }
            ctx.save();
            this.visuals.title_text.set_value(ctx);
            ctx.fillText(this.model.title, 0, -this.model.title_standoff);
            return ctx.restore();
        };
        ColorBarView.prototype._get_label_extent = function () {
            var label_extent;
            var major_labels = this.model.tick_info().labels.major;
            if (this.model.color_mapper.low != null && this.model.color_mapper.high != null && !object_1.isEmpty(major_labels)) {
                var ctx_1 = this.plot_view.canvas_view.ctx;
                ctx_1.save();
                this.visuals.major_label_text.set_value(ctx_1);
                switch (this.model.orientation) {
                case 'vertical':
                    label_extent = array_1.max(major_labels.map(function (label) {
                        return ctx_1.measureText(label.toString()).width;
                    }));
                    break;
                case 'horizontal':
                    label_extent = text_util.get_text_height(this.visuals.major_label_text.font_value()).height;
                    break;
                }
                label_extent += this.model.label_standoff;
                ctx_1.restore();
            } else {
                label_extent = 0;
            }
            return label_extent;
        };
        ColorBarView.prototype._get_image_offset = function () {
            // Returns image offset relative to legend bounding box
            var x = this.model.padding;
            var y = this.model.padding + this.model._title_extent();
            return {
                x: x,
                y: y
            };
        };
        return ColorBarView;
    }(annotation_1.AnnotationView);
    exports.ColorBarView = ColorBarView;
    var ColorBar = function (_super) {
        tslib_1.__extends(ColorBar, _super);
        function ColorBar(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        ColorBar.initClass = function () {
            this.prototype.type = 'ColorBar';
            this.prototype.default_view = ColorBarView;
            this.mixins([
                'text:major_label_',
                'text:title_',
                'line:major_tick_',
                'line:minor_tick_',
                'line:border_',
                'line:bar_',
                'fill:background_'
            ]);
            this.define({
                location: [
                    p.Any,
                    'top_right'
                ],
                orientation: [
                    p.Orientation,
                    'vertical'
                ],
                title: [p.String],
                title_standoff: [
                    p.Number,
                    2
                ],
                width: [
                    p.Any,
                    'auto'
                ],
                height: [
                    p.Any,
                    'auto'
                ],
                scale_alpha: [
                    p.Number,
                    1
                ],
                ticker: [
                    p.Instance,
                    function () {
                        return new basic_ticker_1.BasicTicker();
                    }
                ],
                formatter: [
                    p.Instance,
                    function () {
                        return new basic_tick_formatter_1.BasicTickFormatter();
                    }
                ],
                major_label_overrides: [
                    p.Any,
                    {}
                ],
                color_mapper: [p.Instance],
                label_standoff: [
                    p.Number,
                    5
                ],
                margin: [
                    p.Number,
                    30
                ],
                padding: [
                    p.Number,
                    10
                ],
                major_tick_in: [
                    p.Number,
                    5
                ],
                major_tick_out: [
                    p.Number,
                    0
                ],
                minor_tick_in: [
                    p.Number,
                    0
                ],
                minor_tick_out: [
                    p.Number,
                    0
                ]
            });
            this.override({
                background_fill_color: '#ffffff',
                background_fill_alpha: 0.95,
                bar_line_color: null,
                border_line_color: null,
                major_label_text_align: 'center',
                major_label_text_baseline: 'middle',
                major_label_text_font_size: '8pt',
                major_tick_line_color: '#ffffff',
                minor_tick_line_color: null,
                title_text_font_size: '10pt',
                title_text_font_style: 'italic'
            });
        };
        ColorBar.prototype._normals = function () {
            var i, j;
            if (this.orientation === 'vertical') {
                _a = [
                    1,
                    0
                ], i = _a[0], j = _a[1];
            } else {
                _b = [
                    0,
                    1
                ], i = _b[0], j = _b[1];
            }
            return [
                i,
                j
            ];
            var _a, _b;
        };
        ColorBar.prototype._title_extent = function () {
            var font_value = this.title_text_font + ' ' + this.title_text_font_size + ' ' + this.title_text_font_style;
            var title_extent = this.title ? text_util.get_text_height(font_value).height + this.title_standoff : 0;
            return title_extent;
        };
        ColorBar.prototype._tick_extent = function () {
            var tick_extent;
            if (this.color_mapper.low != null && this.color_mapper.high != null) {
                tick_extent = array_1.max([
                    this.major_tick_out,
                    this.minor_tick_out
                ]);
            } else {
                tick_extent = 0;
            }
            return tick_extent;
        };
        ColorBar.prototype._computed_image_dimensions = function () {
            /*
        Heuristics to determine ColorBar image dimensions if set to "auto"
    
        Note: Returns the height/width values for the ColorBar's scale image, not
        the dimensions of the entire ColorBar.
    
        If the short dimension (the width of a vertical bar or height of a
        horizontal bar) is set to "auto", the resulting dimension will be set to
        25 px.
    
        For a ColorBar in a side panel with the long dimension (the height of a
        vertical bar or width of a horizontal bar) set to "auto", the
        resulting dimension will be as long as the adjacent frame edge, so that the
        bar "fits" to the plot.
    
        For a ColorBar in the plot frame with the long dimension set to "auto", the
        resulting dimension will be the greater of:
          * The length of the color palette * 25px
          * The parallel frame dimension * 0.30
            (i.e the frame height for a vertical ColorBar)
        But not greater than:
          * The parallel frame dimension * 0.80
        */
            var height, width;
            var frame_height = this.plot.plot_canvas.frame._height.value;
            var frame_width = this.plot.plot_canvas.frame._width.value;
            var title_extent = this._title_extent();
            switch (this.orientation) {
            case 'vertical':
                if (this.height === 'auto') {
                    if (this.panel != null) {
                        height = frame_height - 2 * this.padding - title_extent;
                    } else {
                        height = array_1.max([
                            this.color_mapper.palette.length * SHORT_DIM,
                            frame_height * LONG_DIM_MIN_SCALAR
                        ]);
                        height = array_1.min([
                            height,
                            frame_height * LONG_DIM_MAX_SCALAR - 2 * this.padding - title_extent
                        ]);
                    }
                } else {
                    height = this.height;
                }
                width = this.width === 'auto' ? SHORT_DIM : this.width;
                break;
            case 'horizontal':
                height = this.height === 'auto' ? SHORT_DIM : this.height;
                if (this.width === 'auto') {
                    if (this.panel != null) {
                        width = frame_width - 2 * this.padding;
                    } else {
                        width = array_1.max([
                            this.color_mapper.palette.length * SHORT_DIM,
                            frame_width * LONG_DIM_MIN_SCALAR
                        ]);
                        width = array_1.min([
                            width,
                            frame_width * LONG_DIM_MAX_SCALAR - 2 * this.padding
                        ]);
                    }
                } else {
                    width = this.width;
                }
                break;
            }
            return {
                'height': height,
                'width': width
            };
        };
        ColorBar.prototype._tick_coordinate_scale = function (scale_length) {
            /*
        Creates and returns a scale instance that maps the `color_mapper` range
        (low to high) to a screen space range equal to the length of the ColorBar's
        scale image. The scale is used to calculate the tick coordinates in screen
        coordinates for plotting purposes.
    
        Note: the type of color_mapper has to match the type of scale (i.e.
        a LinearColorMapper will require a corresponding LinearScale instance).
        */
            var scale;
            var ranges = {
                'source_range': new range1d_1.Range1d({
                    start: this.color_mapper.low,
                    end: this.color_mapper.high
                }),
                'target_range': new range1d_1.Range1d({
                    start: 0,
                    end: scale_length
                })
            };
            switch (this.color_mapper.type) {
            case 'LinearColorMapper':
                scale = new linear_scale_1.LinearScale(ranges);
                break;
            case 'LogColorMapper':
                scale = new log_scale_1.LogScale(ranges);
                break;
            }
            return scale;
        };
        ColorBar.prototype._format_major_labels = function (initial_labels, major_ticks) {
            var labels = initial_labels;
            // note: passing null as cross_loc probably means MercatorTickFormatters, etc
            // will not function properly in conjunction with colorbars
            var formatted_labels = this.formatter.doFormat(labels, null);
            for (var i = 0, end = major_ticks.length; i < end; i++) {
                if (major_ticks[i] in this.major_label_overrides) {
                    formatted_labels[i] = this.major_label_overrides[major_ticks[i]];
                }
            }
            return formatted_labels;
        };
        ColorBar.prototype.tick_info = function () {
            var scale_length;
            var coord;
            var image_dimensions = this._computed_image_dimensions();
            switch (this.orientation) {
            case 'vertical':
                scale_length = image_dimensions.height;
                break;
            case 'horizontal':
                scale_length = image_dimensions.width;
                break;
            }
            var scale = this._tick_coordinate_scale(scale_length);
            var _a = this._normals(), i = _a[0], j = _a[1];
            var _b = [
                    this.color_mapper.low,
                    this.color_mapper.high
                ], start = _b[0], end = _b[1];
            // note: passing null as cross_loc probably means MercatorTickers, etc
            // will not function properly in conjunction with colorbars
            var ticks = this.ticker.get_ticks(start, end, null, null, this.ticker.desired_num_ticks);
            var coords = {
                major: [
                    [],
                    []
                ],
                minor: [
                    [],
                    []
                ]
            };
            var majors = ticks.major;
            var minors = ticks.minor;
            var major_coords = coords.major;
            var minor_coords = coords.minor;
            for (var ii = 0, _end = majors.length; ii < _end; ii++) {
                if (majors[ii] < start || majors[ii] > end) {
                    continue;
                }
                major_coords[i].push(majors[ii]);
                major_coords[j].push(0);
            }
            for (var ii = 0, _end = minors.length; ii < _end; ii++) {
                if (minors[ii] < start || minors[ii] > end) {
                    continue;
                }
                minor_coords[i].push(minors[ii]);
                minor_coords[j].push(0);
            }
            var labels = { major: this._format_major_labels(major_coords[i].slice(0), majors) };
            // make deep copy
            major_coords[i] = scale.v_compute(major_coords[i]);
            minor_coords[i] = scale.v_compute(minor_coords[i]);
            // Because we want the scale to be reversed
            if (this.orientation === 'vertical') {
                major_coords[i] = new Float64Array(function () {
                    var result = [];
                    for (var _i = 0, _a = major_coords[i]; _i < _a.length; _i++) {
                        coord = _a[_i];
                        result.push(scale_length - coord);
                    }
                    return result;
                }());
                minor_coords[i] = new Float64Array(function () {
                    var result1 = [];
                    for (var _i = 0, _a = minor_coords[i]; _i < _a.length; _i++) {
                        coord = _a[_i];
                        result1.push(scale_length - coord);
                    }
                    return result1;
                }());
            }
            return {
                'ticks': ticks,
                'coords': coords,
                'labels': labels
            };
        };
        return ColorBar;
    }(annotation_1.Annotation);
    exports.ColorBar = ColorBar;
    ColorBar.initClass();    
},
/*models/annotations/index*/
function _(require, module, exports) {
    var annotation_1 = require(52    /* ./annotation */);
    exports.Annotation = annotation_1.Annotation;
    var arrow_1 = require(53    /* ./arrow */);
    exports.Arrow = arrow_1.Arrow;
    var arrow_head_1 = require(54    /* ./arrow_head */);
    exports.ArrowHead = arrow_head_1.ArrowHead;
    var arrow_head_2 = require(54    /* ./arrow_head */);
    exports.OpenHead = arrow_head_2.OpenHead;
    var arrow_head_3 = require(54    /* ./arrow_head */);
    exports.NormalHead = arrow_head_3.NormalHead;
    var arrow_head_4 = require(54    /* ./arrow_head */);
    exports.TeeHead = arrow_head_4.TeeHead;
    var arrow_head_5 = require(54    /* ./arrow_head */);
    exports.VeeHead = arrow_head_5.VeeHead;
    var band_1 = require(55    /* ./band */);
    exports.Band = band_1.Band;
    var box_annotation_1 = require(56    /* ./box_annotation */);
    exports.BoxAnnotation = box_annotation_1.BoxAnnotation;
    var color_bar_1 = require(57    /* ./color_bar */);
    exports.ColorBar = color_bar_1.ColorBar;
    var label_1 = require(59    /* ./label */);
    exports.Label = label_1.Label;
    var label_set_1 = require(60    /* ./label_set */);
    exports.LabelSet = label_set_1.LabelSet;
    var legend_1 = require(61    /* ./legend */);
    exports.Legend = legend_1.Legend;
    var legend_item_1 = require(62    /* ./legend_item */);
    exports.LegendItem = legend_item_1.LegendItem;
    var poly_annotation_1 = require(63    /* ./poly_annotation */);
    exports.PolyAnnotation = poly_annotation_1.PolyAnnotation;
    var span_1 = require(64    /* ./span */);
    exports.Span = span_1.Span;
    var text_annotation_1 = require(65    /* ./text_annotation */);
    exports.TextAnnotation = text_annotation_1.TextAnnotation;
    var title_1 = require(66    /* ./title */);
    exports.Title = title_1.Title;
    var toolbar_panel_1 = require(67    /* ./toolbar_panel */);
    exports.ToolbarPanel = toolbar_panel_1.ToolbarPanel;
    var tooltip_1 = require(68    /* ./tooltip */);
    exports.Tooltip = tooltip_1.Tooltip;
    var whisker_1 = require(69    /* ./whisker */);
    exports.Whisker = whisker_1.Whisker;    
},
/*models/annotations/label*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    /* XXX: partial */
    var text_annotation_1 = require(65    /* ./text_annotation */);
    var dom_1 = require(5    /* core/dom */);
    var p = require(15    /* core/properties */);
    var LabelView = function (_super) {
        tslib_1.__extends(LabelView, _super);
        function LabelView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        LabelView.prototype.initialize = function (options) {
            _super.prototype.initialize.call(this, options);
            this.visuals.warm_cache(null);
        };
        LabelView.prototype._get_size = function () {
            var ctx = this.plot_view.canvas_view.ctx;
            this.visuals.text.set_value(ctx);
            if (this.model.panel.is_horizontal) {
                var height = ctx.measureText(this.model.text).ascent;
                return height;
            } else {
                var width = ctx.measureText(this.model.text).width;
                return width;
            }
        };
        LabelView.prototype.render = function () {
            var angle;
            if (!this.model.visible && this.model.render_mode === 'css') {
                dom_1.hide(this.el);
            }
            if (!this.model.visible) {
                return;
            }
            // Here because AngleSpec does units tranform and label doesn't support specs
            switch (this.model.angle_units) {
            case 'rad':
                angle = -1 * this.model.angle;
                break;
            case 'deg':
                angle = -1 * this.model.angle * Math.PI / 180;
                break;
            }
            var panel = this.model.panel != null ? this.model.panel : this.plot_view.frame;
            var xscale = this.plot_view.frame.xscales[this.model.x_range_name];
            var yscale = this.plot_view.frame.yscales[this.model.y_range_name];
            var sx = this.model.x_units === 'data' ? xscale.compute(this.model.x) : panel.xview.compute(this.model.x);
            var sy = this.model.y_units === 'data' ? yscale.compute(this.model.y) : panel.yview.compute(this.model.y);
            sx += this.model.x_offset;
            sy -= this.model.y_offset;
            var draw = this.model.render_mode === 'canvas' ? this._canvas_text.bind(this) : this._css_text.bind(this);
            return draw(this.plot_view.canvas_view.ctx, this.model.text, sx, sy, angle);
        };
        return LabelView;
    }(text_annotation_1.TextAnnotationView);
    exports.LabelView = LabelView;
    var Label = function (_super) {
        tslib_1.__extends(Label, _super);
        function Label(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        Label.initClass = function () {
            this.prototype.type = 'Label';
            this.prototype.default_view = LabelView;
            this.mixins([
                'text',
                'line:border_',
                'fill:background_'
            ]);
            this.define({
                x: [p.Number],
                x_units: [
                    p.SpatialUnits,
                    'data'
                ],
                y: [p.Number],
                y_units: [
                    p.SpatialUnits,
                    'data'
                ],
                text: [p.String],
                angle: [
                    p.Angle,
                    0
                ],
                angle_units: [
                    p.AngleUnits,
                    'rad'
                ],
                x_offset: [
                    p.Number,
                    0
                ],
                y_offset: [
                    p.Number,
                    0
                ],
                x_range_name: [
                    p.String,
                    'default'
                ],
                y_range_name: [
                    p.String,
                    'default'
                ],
                render_mode: [
                    p.RenderMode,
                    'canvas'
                ]
            });
            this.override({
                background_fill_color: null,
                border_line_color: null
            });
        };
        return Label;
    }(text_annotation_1.TextAnnotation);
    exports.Label = Label;
    Label.initClass();    
},
/*models/annotations/label_set*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    /* XXX: partial */
    var text_annotation_1 = require(65    /* ./text_annotation */);
    var column_data_source_1 = require(174    /* ../sources/column_data_source */);
    var dom_1 = require(5    /* core/dom */);
    var p = require(15    /* core/properties */);
    var types_1 = require(43    /* core/util/types */);
    var array_1 = require(22    /* core/util/array */);
    var LabelSetView = function (_super) {
        tslib_1.__extends(LabelSetView, _super);
        function LabelSetView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        LabelSetView.prototype.initialize = function (options) {
            _super.prototype.initialize.call(this, options);
            this.set_data(this.model.source);
            if (this.model.render_mode === 'css') {
                for (var i = 0, end = this._text.length; i < end; i++) {
                    this.title_div = dom_1.div({
                        class: 'bk-annotation-child',
                        style: { display: 'none' }
                    });
                    this.el.appendChild(this.title_div);
                }
            }
        };
        LabelSetView.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            if (this.model.render_mode === 'css') {
                // dispatch CSS update immediately
                this.connect(this.model.change, function () {
                    _this.set_data(_this.model.source);
                    _this.render();
                });
                this.connect(this.model.source.streaming, function () {
                    _this.set_data(_this.model.source);
                    _this.render();
                });
                this.connect(this.model.source.patching, function () {
                    _this.set_data(_this.model.source);
                    _this.render();
                });
                this.connect(this.model.source.change, function () {
                    _this.set_data(_this.model.source);
                    _this.render();
                });
            } else {
                this.connect(this.model.change, function () {
                    _this.set_data(_this.model.source);
                    _this.plot_view.request_render();
                });
                this.connect(this.model.source.streaming, function () {
                    _this.set_data(_this.model.source);
                    _this.plot_view.request_render();
                });
                this.connect(this.model.source.patching, function () {
                    _this.set_data(_this.model.source);
                    _this.plot_view.request_render();
                });
                this.connect(this.model.source.change, function () {
                    _this.set_data(_this.model.source);
                    _this.plot_view.request_render();
                });
            }
        };
        LabelSetView.prototype.set_data = function (source) {
            _super.prototype.set_data.call(this, source);
            this.visuals.warm_cache(source);
        };
        LabelSetView.prototype._map_data = function () {
            var xscale = this.plot_view.frame.xscales[this.model.x_range_name];
            var yscale = this.plot_view.frame.yscales[this.model.y_range_name];
            var panel = this.model.panel != null ? this.model.panel : this.plot_view.frame;
            var sx = this.model.x_units === 'data' ? xscale.v_compute(this._x) : panel.xview.v_compute(this._x);
            var sy = this.model.y_units === 'data' ? yscale.v_compute(this._y) : panel.yview.v_compute(this._y);
            return [
                sx,
                sy
            ];
        };
        LabelSetView.prototype.render = function () {
            var _this = this;
            if (!this.model.visible && this.model.render_mode === 'css') {
                dom_1.hide(this.el);
            }
            if (!this.model.visible) {
                return;
            }
            var draw = this.model.render_mode === 'canvas' ? this._v_canvas_text.bind(this) : this._v_css_text.bind(this);
            var ctx = this.plot_view.canvas_view.ctx;
            var _a = this._map_data(), sx = _a[0], sy = _a[1];
            return array_1.range(0, this._text.length).map(function (i) {
                return draw(ctx, i, _this._text[i], sx[i] + _this._x_offset[i], sy[i] - _this._y_offset[i], _this._angle[i]);
            });
        };
        LabelSetView.prototype._get_size = function () {
            var ctx = this.plot_view.canvas_view.ctx;
            this.visuals.text.set_value(ctx);
            var side = this.model.panel.side;
            if (side === 'above' || side === 'below') {
                var height = ctx.measureText(this._text[0]).ascent;
                return height;
            }
            if (side === 'left' || side === 'right') {
                var width = ctx.measureText(this._text[0]).width;
                return width;
            }
        };
        LabelSetView.prototype._v_canvas_text = function (ctx, i, text, sx, sy, angle) {
            this.visuals.text.set_vectorize(ctx, i);
            var bbox_dims = this._calculate_bounding_box_dimensions(ctx, text);
            ctx.save();
            ctx.beginPath();
            ctx.translate(sx, sy);
            ctx.rotate(angle);
            ctx.rect(bbox_dims[0], bbox_dims[1], bbox_dims[2], bbox_dims[3]);
            if (this.visuals.background_fill.doit) {
                this.visuals.background_fill.set_vectorize(ctx, i);
                ctx.fill();
            }
            if (this.visuals.border_line.doit) {
                this.visuals.border_line.set_vectorize(ctx, i);
                ctx.stroke();
            }
            if (this.visuals.text.doit) {
                this.visuals.text.set_vectorize(ctx, i);
                ctx.fillText(text, 0, 0);
            }
            return ctx.restore();
        };
        LabelSetView.prototype._v_css_text = function (ctx, i, text, sx, sy, angle) {
            var line_dash;
            var el = this.el.childNodes[i];
            el.textContent = text;
            this.visuals.text.set_vectorize(ctx, i);
            var bbox_dims = this._calculate_bounding_box_dimensions(ctx, text);
            // attempt to support vector-style ("8 4 8") line dashing for css mode
            var ld = this.visuals.border_line.line_dash.value();
            if (types_1.isArray(ld)) {
                line_dash = ld.length < 2 ? 'solid' : 'dashed';
            }
            if (types_1.isString(ld)) {
                line_dash = ld;
            }
            this.visuals.border_line.set_vectorize(ctx, i);
            this.visuals.background_fill.set_vectorize(ctx, i);
            el.style.position = 'absolute';
            el.style.left = sx + bbox_dims[0] + 'px';
            el.style.top = sy + bbox_dims[1] + 'px';
            el.style.color = '' + this.visuals.text.text_color.value();
            el.style.opacity = '' + this.visuals.text.text_alpha.value();
            el.style.font = '' + this.visuals.text.font_value();
            el.style.lineHeight = 'normal';
            // needed to prevent ipynb css override
            if (angle) {
                el.style.transform = 'rotate(' + angle + 'rad)';
            }
            if (this.visuals.background_fill.doit) {
                el.style.backgroundColor = '' + this.visuals.background_fill.color_value();
            }
            if (this.visuals.border_line.doit) {
                el.style.borderStyle = '' + line_dash;
                el.style.borderWidth = this.visuals.border_line.line_width.value() + 'px';
                el.style.borderColor = '' + this.visuals.border_line.color_value();
            }
            return dom_1.show(el);
        };
        return LabelSetView;
    }(text_annotation_1.TextAnnotationView);
    exports.LabelSetView = LabelSetView;
    var LabelSet = function (_super) {
        tslib_1.__extends(LabelSet, _super);
        function LabelSet(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        LabelSet.initClass = function () {
            this.prototype.type = 'LabelSet';
            this.prototype.default_view = LabelSetView;
            this.mixins([
                'text',
                'line:border_',
                'fill:background_'
            ]);
            this.define({
                x: [p.NumberSpec],
                y: [p.NumberSpec],
                x_units: [
                    p.SpatialUnits,
                    'data'
                ],
                y_units: [
                    p.SpatialUnits,
                    'data'
                ],
                text: [
                    p.StringSpec,
                    { field: 'text' }
                ],
                angle: [
                    p.AngleSpec,
                    0
                ],
                x_offset: [
                    p.NumberSpec,
                    { value: 0 }
                ],
                y_offset: [
                    p.NumberSpec,
                    { value: 0 }
                ],
                source: [
                    p.Instance,
                    function () {
                        return new column_data_source_1.ColumnDataSource();
                    }
                ],
                x_range_name: [
                    p.String,
                    'default'
                ],
                y_range_name: [
                    p.String,
                    'default'
                ],
                render_mode: [
                    p.RenderMode,
                    'canvas'
                ]
            });
            this.override({
                background_fill_color: null,
                border_line_color: null
            });
        };
        return LabelSet;
    }(text_annotation_1.TextAnnotation);
    exports.LabelSet = LabelSet;
    LabelSet.initClass();    
},
/*models/annotations/legend*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    /* XXX: partial */
    var annotation_1 = require(52    /* ./annotation */);
    var p = require(15    /* core/properties */);
    var text_1 = require(41    /* core/util/text */);
    var bbox_1 = require(24    /* core/util/bbox */);
    var array_1 = require(22    /* core/util/array */);
    var object_1 = require(31    /* core/util/object */);
    var types_1 = require(43    /* core/util/types */);
    var LegendView = function (_super) {
        tslib_1.__extends(LegendView, _super);
        function LegendView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(LegendView.prototype, 'legend_padding', {
            get: function () {
                return this.visuals.border_line.line_color.value() != null ? this.model.padding : 0;
            },
            enumerable: true,
            configurable: true
        });
        LegendView.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            this.connect(this.model.properties.visible.change, function () {
                return _this.plot_view.request_render();
            });
        };
        LegendView.prototype.compute_legend_bbox = function () {
            var legend_names = this.model.get_legend_names();
            var _a = this.model, glyph_height = _a.glyph_height, glyph_width = _a.glyph_width;
            var _b = this.model, label_height = _b.label_height, label_width = _b.label_width;
            this.max_label_height = array_1.max([
                text_1.get_text_height(this.visuals.label_text.font_value()).height,
                label_height,
                glyph_height
            ]);
            // this is to measure text properties
            var ctx = this.plot_view.canvas_view.ctx;
            ctx.save();
            this.visuals.label_text.set_value(ctx);
            this.text_widths = {};
            for (var _i = 0, legend_names_1 = legend_names; _i < legend_names_1.length; _i++) {
                var name_1 = legend_names_1[_i];
                this.text_widths[name_1] = array_1.max([
                    ctx.measureText(name_1).width,
                    label_width
                ]);
            }
            ctx.restore();
            var max_label_width = Math.max(array_1.max(object_1.values(this.text_widths)), 0);
            var legend_margin = this.model.margin;
            var legend_padding = this.legend_padding;
            var legend_spacing = this.model.spacing;
            var label_standoff = this.model.label_standoff;
            var legend_height, legend_width;
            if (this.model.orientation === 'vertical') {
                legend_height = legend_names.length * this.max_label_height + Math.max(legend_names.length - 1, 0) * legend_spacing + 2 * legend_padding;
                legend_width = max_label_width + glyph_width + label_standoff + 2 * legend_padding;
            } else {
                legend_width = 2 * legend_padding + Math.max(legend_names.length - 1, 0) * legend_spacing;
                for (var name_2 in this.text_widths) {
                    var width = this.text_widths[name_2];
                    legend_width += array_1.max([
                        width,
                        label_width
                    ]) + glyph_width + label_standoff;
                }
                legend_height = this.max_label_height + 2 * legend_padding;
            }
            var panel = this.model.panel != null ? this.model.panel : this.plot_view.frame;
            var _c = panel.bbox.ranges, hr = _c[0], vr = _c[1];
            var location = this.model.location;
            var sx, sy;
            if (types_1.isString(location)) {
                switch (location) {
                case 'top_left':
                    sx = hr.start + legend_margin;
                    sy = vr.start + legend_margin;
                    break;
                case 'top_center':
                    sx = (hr.end + hr.start) / 2 - legend_width / 2;
                    sy = vr.start + legend_margin;
                    break;
                case 'top_right':
                    sx = hr.end - legend_margin - legend_width;
                    sy = vr.start + legend_margin;
                    break;
                case 'bottom_right':
                    sx = hr.end - legend_margin - legend_width;
                    sy = vr.end - legend_margin - legend_height;
                    break;
                case 'bottom_center':
                    sx = (hr.end + hr.start) / 2 - legend_width / 2;
                    sy = vr.end - legend_margin - legend_height;
                    break;
                case 'bottom_left':
                    sx = hr.start + legend_margin;
                    sy = vr.end - legend_margin - legend_height;
                    break;
                case 'center_left':
                    sx = hr.start + legend_margin;
                    sy = (vr.end + vr.start) / 2 - legend_height / 2;
                    break;
                case 'center':
                    sx = (hr.end + hr.start) / 2 - legend_width / 2;
                    sy = (vr.end + vr.start) / 2 - legend_height / 2;
                    break;
                case 'center_right':
                    sx = hr.end - legend_margin - legend_width;
                    sy = (vr.end + vr.start) / 2 - legend_height / 2;
                    break;
                }
            } else if (types_1.isArray(location) && location.length === 2) {
                var vx = location[0], vy = location[1];
                sx = panel.xview.compute(vx);
                sy = panel.yview.compute(vy) - legend_height;
            }
            return {
                x: sx,
                y: sy,
                width: legend_width,
                height: legend_height
            };
        };
        LegendView.prototype.bbox = function () {
            var _a = this.compute_legend_bbox(), x = _a.x, y = _a.y, width = _a.width, height = _a.height;
            return new bbox_1.BBox({
                x: x,
                y: y,
                width: width,
                height: height
            });
        };
        LegendView.prototype.on_hit = function (sx, sy) {
            var yoffset;
            var glyph_width = this.model.glyph_width;
            var legend_padding = this.legend_padding;
            var legend_spacing = this.model.spacing;
            var label_standoff = this.model.label_standoff;
            var xoffset = yoffset = legend_padding;
            var legend_bbox = this.compute_legend_bbox();
            var vertical = this.model.orientation === 'vertical';
            for (var _i = 0, _a = this.model.items; _i < _a.length; _i++) {
                var item = _a[_i];
                var labels = item.get_labels_list_from_label_prop();
                for (var _b = 0, labels_1 = labels; _b < labels_1.length; _b++) {
                    var label = labels_1[_b];
                    var x1 = legend_bbox.x + xoffset;
                    var y1 = legend_bbox.y + yoffset;
                    var h = void 0;
                    var w = void 0;
                    if (vertical)
                        _c = [
                            legend_bbox.width - 2 * legend_padding,
                            this.max_label_height
                        ], w = _c[0], h = _c[1];
                    else
                        _d = [
                            this.text_widths[label] + glyph_width + label_standoff,
                            this.max_label_height
                        ], w = _d[0], h = _d[1];
                    var bbox = new bbox_1.BBox({
                        x: x1,
                        y: y1,
                        width: w,
                        height: h
                    });
                    if (bbox.contains(sx, sy)) {
                        switch (this.model.click_policy) {
                        case 'hide': {
                                for (var _e = 0, _f = item.renderers; _e < _f.length; _e++) {
                                    var r = _f[_e];
                                    r.visible = !r.visible;
                                }
                                break;
                            }
                        case 'mute': {
                                for (var _g = 0, _h = item.renderers; _g < _h.length; _g++) {
                                    var r = _h[_g];
                                    r.muted = !r.muted;
                                }
                                break;
                            }
                        }
                        return true;
                    }
                    if (vertical) {
                        yoffset += this.max_label_height + legend_spacing;
                    } else {
                        xoffset += this.text_widths[label] + glyph_width + label_standoff + legend_spacing;
                    }
                }
            }
            return false;
            var _c, _d;
        };
        LegendView.prototype.render = function () {
            if (!this.model.visible) {
                return;
            }
            if (this.model.items.length === 0) {
                return;
            }
            var ctx = this.plot_view.canvas_view.ctx;
            var bbox = this.compute_legend_bbox();
            ctx.save();
            this._draw_legend_box(ctx, bbox);
            this._draw_legend_items(ctx, bbox);
            return ctx.restore();
        };
        LegendView.prototype._draw_legend_box = function (ctx, bbox) {
            ctx.beginPath();
            ctx.rect(bbox.x, bbox.y, bbox.width, bbox.height);
            this.visuals.background_fill.set_value(ctx);
            ctx.fill();
            if (this.visuals.border_line.doit) {
                this.visuals.border_line.set_value(ctx);
                return ctx.stroke();
            }
        };
        LegendView.prototype._draw_legend_items = function (ctx, bbox) {
            var _this = this;
            var yoffset;
            var glyph_height = this.model.glyph_height;
            var glyph_width = this.model.glyph_width;
            var legend_padding = this.legend_padding;
            var legend_spacing = this.model.spacing;
            var label_standoff = this.model.label_standoff;
            var xoffset = yoffset = legend_padding;
            var vertical = this.model.orientation === 'vertical';
            var _loop_1 = function (item) {
                var labels = item.get_labels_list_from_label_prop();
                var field = item.get_field_from_label_prop();
                if (labels.length === 0) {
                    return 'continue';
                }
                var active = function () {
                    switch (_this.model.click_policy) {
                    case 'none':
                        return true;
                    case 'hide':
                        return array_1.all(item.renderers, function (r) {
                            return r.visible;
                        });
                    case 'mute':
                        return array_1.all(item.renderers, function (r) {
                            return !r.muted;
                        });
                    }
                }();
                for (var _i = 0, labels_2 = labels; _i < labels_2.length; _i++) {
                    var label = labels_2[_i];
                    var x1 = bbox.x + xoffset;
                    var y1 = bbox.y + yoffset;
                    var x2 = x1 + glyph_width;
                    var y2 = y1 + glyph_height;
                    if (vertical) {
                        yoffset += this_1.max_label_height + legend_spacing;
                    } else {
                        xoffset += this_1.text_widths[label] + glyph_width + label_standoff + legend_spacing;
                    }
                    this_1.visuals.label_text.set_value(ctx);
                    ctx.fillText(label, x2 + label_standoff, y1 + this_1.max_label_height / 2);
                    for (var _a = 0, _b = item.renderers; _a < _b.length; _a++) {
                        var r = _b[_a];
                        var view = this_1.plot_view.renderer_views[r.id];
                        view.draw_legend(ctx, x1, x2, y1, y2, field, label);
                    }
                    if (!active) {
                        var h = void 0;
                        var w = void 0;
                        if (vertical)
                            _c = [
                                bbox.width - 2 * legend_padding,
                                this_1.max_label_height
                            ], w = _c[0], h = _c[1];
                        else
                            _d = [
                                this_1.text_widths[label] + glyph_width + label_standoff,
                                this_1.max_label_height
                            ], w = _d[0], h = _d[1];
                        ctx.beginPath();
                        ctx.rect(x1, y1, w, h);
                        this_1.visuals.inactive_fill.set_value(ctx);
                        ctx.fill();
                    }
                }
                var _c, _d;
            };
            var this_1 = this;
            for (var _i = 0, _a = this.model.items; _i < _a.length; _i++) {
                var item = _a[_i];
                _loop_1(item);
            }
            return null;
        };
        LegendView.prototype._get_size = function () {
            var bbox = this.compute_legend_bbox();
            var side = this.model.panel.side;
            if (side === 'above' || side === 'below') {
                return bbox.height + 2 * this.model.margin;
            }
            if (side === 'left' || side === 'right') {
                return bbox.width + 2 * this.model.margin;
            }
        };
        return LegendView;
    }(annotation_1.AnnotationView);
    exports.LegendView = LegendView;
    var Legend = function (_super) {
        tslib_1.__extends(Legend, _super);
        function Legend(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        Legend.initClass = function () {
            this.prototype.type = 'Legend';
            this.prototype.default_view = LegendView;
            this.mixins([
                'text:label_',
                'fill:inactive_',
                'line:border_',
                'fill:background_'
            ]);
            this.define({
                orientation: [
                    p.Orientation,
                    'vertical'
                ],
                location: [
                    p.Any,
                    'top_right'
                ],
                label_standoff: [
                    p.Number,
                    5
                ],
                glyph_height: [
                    p.Number,
                    20
                ],
                glyph_width: [
                    p.Number,
                    20
                ],
                label_height: [
                    p.Number,
                    20
                ],
                label_width: [
                    p.Number,
                    20
                ],
                margin: [
                    p.Number,
                    10
                ],
                padding: [
                    p.Number,
                    10
                ],
                spacing: [
                    p.Number,
                    3
                ],
                items: [
                    p.Array,
                    []
                ],
                click_policy: [
                    p.Any,
                    'none'
                ]
            });
            this.override({
                border_line_color: '#e5e5e5',
                border_line_alpha: 0.5,
                border_line_width: 1,
                background_fill_color: '#ffffff',
                background_fill_alpha: 0.95,
                inactive_fill_color: 'white',
                inactive_fill_alpha: 0.7,
                label_text_font_size: '10pt',
                label_text_baseline: 'middle'
            });
        };
        Legend.prototype.cursor = function () {
            if (this.click_policy === 'none') {
                return null;
            } else {
                return 'pointer';
            }
        };
        Legend.prototype.get_legend_names = function () {
            var legend_names = [];
            for (var _i = 0, _a = this.items; _i < _a.length; _i++) {
                var item = _a[_i];
                var labels = item.get_labels_list_from_label_prop();
                legend_names.push.apply(legend_names, labels);
            }
            return legend_names;
        };
        return Legend;
    }(annotation_1.Annotation);
    exports.Legend = Legend;
    Legend.initClass();    
},
/*models/annotations/legend_item*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    /* XXX: partial */
    var model_1 = require(51    /* ../../model */);
    var column_data_source_1 = require(174    /* ../sources/column_data_source */);
    var p = require(15    /* core/properties */);
    var logging_1 = require(14    /* core/logging */);
    var array_1 = require(22    /* core/util/array */);
    var LegendItem = function (_super) {
        tslib_1.__extends(LegendItem, _super);
        function LegendItem(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        LegendItem.initClass = function () {
            this.prototype.type = 'LegendItem';
            this.define({
                label: [
                    p.StringSpec,
                    null
                ],
                renderers: [
                    p.Array,
                    []
                ]
            });
        };
        LegendItem.prototype._check_data_sources_on_renderers = function () {
            var field = this.get_field_from_label_prop();
            if (field != null) {
                if (this.renderers.length < 1) {
                    return false;
                }
                var source = this.renderers[0].data_source;
                if (source != null) {
                    for (var _i = 0, _a = this.renderers; _i < _a.length; _i++) {
                        var r = _a[_i];
                        if (r.data_source !== source) {
                            return false;
                        }
                    }
                }
            }
            return true;
        };
        LegendItem.prototype._check_field_label_on_data_source = function () {
            var field = this.get_field_from_label_prop();
            if (field != null) {
                if (this.renderers.length < 1) {
                    return false;
                }
                var source = this.renderers[0].data_source;
                if (source != null && !array_1.includes(source.columns(), field)) {
                    return false;
                }
            }
            return true;
        };
        LegendItem.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            // Validate data_sources match
            var data_source_validation = this._check_data_sources_on_renderers();
            if (!data_source_validation) {
                logging_1.logger.error('Non matching data sources on legend item renderers');
            }
            // Validate label in data_source
            var field_validation = this._check_field_label_on_data_source();
            if (!field_validation) {
                logging_1.logger.error('Bad column name on label: ' + this.label);
            }
        };
        LegendItem.prototype.get_field_from_label_prop = function () {
            if (this.label != null && this.label.field != null) {
                return this.label.field;
            }
        };
        LegendItem.prototype.get_labels_list_from_label_prop = function () {
            // Always return a list of the labels
            if (this.label != null && this.label.value != null) {
                return [this.label.value];
            }
            var field = this.get_field_from_label_prop();
            if (field != null) {
                var source = void 0;
                if (this.renderers[0] && this.renderers[0].data_source != null) {
                    source = this.renderers[0].data_source;
                } else {
                    return ['No source found'];
                }
                if (source instanceof column_data_source_1.ColumnDataSource) {
                    var data = source.get_column(field);
                    if (data != null) {
                        return array_1.uniq(data);
                    } else {
                        return ['Invalid field'];
                    }
                }
            }
            return [];
        };
        return LegendItem;
    }(model_1.Model);
    exports.LegendItem = LegendItem;
    LegendItem.initClass();    
},
/*models/annotations/poly_annotation*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    /* XXX: partial */
    var annotation_1 = require(52    /* ./annotation */);
    var signaling_1 = require(20    /* core/signaling */);
    var p = require(15    /* core/properties */);
    var PolyAnnotationView = function (_super) {
        tslib_1.__extends(PolyAnnotationView, _super);
        function PolyAnnotationView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        PolyAnnotationView.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            // need to respond to either normal BB change events or silent
            // "data only updates" that tools might want to use
            this.connect(this.model.change, function () {
                return _this.plot_view.request_render();
            });
            this.connect(this.model.data_update, function () {
                return _this.plot_view.request_render();
            });
        };
        PolyAnnotationView.prototype.render = function () {
            if (!this.model.visible) {
                return;
            }
            var xs = this.model.xs;
            var ys = this.model.ys;
            if (xs.length !== ys.length) {
                return null;
            }
            if (xs.length < 3 || ys.length < 3) {
                return null;
            }
            var frame = this.plot_view.frame;
            var ctx = this.plot_view.canvas_view.ctx;
            for (var i = 0, end = xs.length; i < end; i++) {
                var sx = void 0, sy = void 0;
                if (this.model.xs_units === 'screen')
                    sx = this.model.screen ? xs[i] : frame.xview.compute(xs[i]);
                if (this.model.ys_units === 'screen')
                    sy = this.model.screen ? ys[i] : frame.yview.compute(ys[i]);
                if (i === 0) {
                    ctx.beginPath();
                    ctx.moveTo(sx, sy);
                } else {
                    ctx.lineTo(sx, sy);
                }
            }
            ctx.closePath();
            if (this.visuals.line.doit) {
                this.visuals.line.set_value(ctx);
                ctx.stroke();
            }
            if (this.visuals.fill.doit) {
                this.visuals.fill.set_value(ctx);
                return ctx.fill();
            }
        };
        return PolyAnnotationView;
    }(annotation_1.AnnotationView);
    exports.PolyAnnotationView = PolyAnnotationView;
    var PolyAnnotation = function (_super) {
        tslib_1.__extends(PolyAnnotation, _super);
        function PolyAnnotation(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        PolyAnnotation.initClass = function () {
            this.prototype.type = 'PolyAnnotation';
            this.prototype.default_view = PolyAnnotationView;
            this.mixins([
                'line',
                'fill'
            ]);
            this.define({
                xs: [
                    p.Array,
                    []
                ],
                xs_units: [
                    p.SpatialUnits,
                    'data'
                ],
                ys: [
                    p.Array,
                    []
                ],
                ys_units: [
                    p.SpatialUnits,
                    'data'
                ],
                x_range_name: [
                    p.String,
                    'default'
                ],
                y_range_name: [
                    p.String,
                    'default'
                ]
            });
            this.internal({
                screen: [
                    p.Boolean,
                    false
                ]
            });
            this.override({
                fill_color: '#fff9ba',
                fill_alpha: 0.4,
                line_color: '#cccccc',
                line_alpha: 0.3
            });
        };
        PolyAnnotation.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            this.data_update = new signaling_1.Signal(this, 'data_update');
        };
        PolyAnnotation.prototype.update = function (_a) {
            var xs = _a.xs, ys = _a.ys;
            this.setv({
                xs: xs,
                ys: ys,
                screen: true
            }, { silent: true });
            return this.data_update.emit();
        };
        return PolyAnnotation;
    }(annotation_1.Annotation);
    exports.PolyAnnotation = PolyAnnotation;
    PolyAnnotation.initClass();    
},
/*models/annotations/span*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    /* XXX: partial */
    var annotation_1 = require(52    /* ./annotation */);
    var dom_1 = require(5    /* core/dom */);
    var p = require(15    /* core/properties */);
    var SpanView = function (_super) {
        tslib_1.__extends(SpanView, _super);
        function SpanView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        SpanView.prototype.initialize = function (options) {
            _super.prototype.initialize.call(this, options);
            this.plot_view.canvas_overlays.appendChild(this.el);
            this.el.style.position = 'absolute';
            dom_1.hide(this.el);
        };
        SpanView.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            if (this.model.for_hover) {
                this.connect(this.model.properties.computed_location.change, function () {
                    return _this._draw_span();
                });
            } else {
                if (this.model.render_mode === 'canvas') {
                    this.connect(this.model.change, function () {
                        return _this.plot_view.request_render();
                    });
                    this.connect(this.model.properties.location.change, function () {
                        return _this.plot_view.request_render();
                    });
                } else {
                    this.connect(this.model.change, function () {
                        return _this.render();
                    });
                    this.connect(this.model.properties.location.change, function () {
                        return _this._draw_span();
                    });
                }
            }
        };
        SpanView.prototype.render = function () {
            if (!this.model.visible && this.model.render_mode === 'css') {
                dom_1.hide(this.el);
            }
            if (!this.model.visible) {
                return;
            }
            this._draw_span();
        };
        SpanView.prototype._draw_span = function () {
            var _this = this;
            var height, sleft, stop, width;
            var loc = this.model.for_hover ? this.model.computed_location : this.model.location;
            if (loc == null) {
                dom_1.hide(this.el);
                return;
            }
            var frame = this.plot_view.frame;
            var xscale = frame.xscales[this.model.x_range_name];
            var yscale = frame.yscales[this.model.y_range_name];
            var _calc_dim = function (scale, view) {
                if (_this.model.for_hover) {
                    return _this.model.computed_location;
                } else {
                    if (_this.model.location_units === 'data') {
                        return scale.compute(loc);
                    } else {
                        return view.compute(loc);
                    }
                }
            };
            if (this.model.dimension === 'width') {
                stop = _calc_dim(yscale, frame.yview);
                sleft = frame._left.value;
                width = frame._width.value;
                height = this.model.properties.line_width.value();
            } else {
                stop = frame._top.value;
                sleft = _calc_dim(xscale, frame.xview);
                width = this.model.properties.line_width.value();
                height = frame._height.value;
            }
            if (this.model.render_mode === 'css') {
                this.el.style.top = stop + 'px';
                this.el.style.left = sleft + 'px';
                this.el.style.width = width + 'px';
                this.el.style.height = height + 'px';
                this.el.style.zIndex = 1000;
                this.el.style.backgroundColor = this.model.properties.line_color.value();
                this.el.style.opacity = this.model.properties.line_alpha.value();
                return dom_1.show(this.el);
            } else if (this.model.render_mode === 'canvas') {
                var ctx = this.plot_view.canvas_view.ctx;
                ctx.save();
                ctx.beginPath();
                this.visuals.line.set_value(ctx);
                ctx.moveTo(sleft, stop);
                if (this.model.dimension === 'width') {
                    ctx.lineTo(sleft + width, stop);
                } else {
                    ctx.lineTo(sleft, stop + height);
                }
                ctx.stroke();
                return ctx.restore();
            }
        };
        return SpanView;
    }(annotation_1.AnnotationView);
    exports.SpanView = SpanView;
    var Span = function (_super) {
        tslib_1.__extends(Span, _super);
        function Span(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        Span.initClass = function () {
            this.prototype.type = 'Span';
            this.prototype.default_view = SpanView;
            this.mixins(['line']);
            this.define({
                render_mode: [
                    p.RenderMode,
                    'canvas'
                ],
                x_range_name: [
                    p.String,
                    'default'
                ],
                y_range_name: [
                    p.String,
                    'default'
                ],
                location: [
                    p.Number,
                    null
                ],
                location_units: [
                    p.SpatialUnits,
                    'data'
                ],
                dimension: [
                    p.Dimension,
                    'width'
                ]
            });
            this.override({ line_color: 'black' });
            this.internal({
                for_hover: [
                    p.Boolean,
                    false
                ],
                computed_location: [
                    p.Number,
                    null
                ]
            });
        };
        return Span;
    }(annotation_1.Annotation);
    exports.Span = Span;
    Span.initClass();    
},
/*models/annotations/text_annotation*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    /* XXX: partial */
    var annotation_1 = require(52    /* ./annotation */);
    var dom_1 = require(5    /* core/dom */);
    var types_1 = require(43    /* core/util/types */);
    var text_1 = require(41    /* core/util/text */);
    var TextAnnotationView = function (_super) {
        tslib_1.__extends(TextAnnotationView, _super);
        function TextAnnotationView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        TextAnnotationView.prototype.initialize = function (options) {
            _super.prototype.initialize.call(this, options);
            if (this.model.render_mode === 'css') {
                this.el.classList.add('bk-annotation');
                this.plot_view.canvas_overlays.appendChild(this.el);
            }
        };
        TextAnnotationView.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            if (this.model.render_mode === 'css') {
                // dispatch CSS update immediately
                this.connect(this.model.change, function () {
                    return _this.render();
                });
            } else {
                this.connect(this.model.change, function () {
                    return _this.plot_view.request_render();
                });
            }
        };
        TextAnnotationView.prototype._calculate_text_dimensions = function (ctx, text) {
            var width = ctx.measureText(text).width;
            var height = text_1.get_text_height(this.visuals.text.font_value()).height;
            return [
                width,
                height
            ];
        };
        TextAnnotationView.prototype._calculate_bounding_box_dimensions = function (ctx, text) {
            var x_offset, y_offset;
            var _a = this._calculate_text_dimensions(ctx, text), width = _a[0], height = _a[1];
            switch (ctx.textAlign) {
            case 'left':
                x_offset = 0;
                break;
            case 'center':
                x_offset = -width / 2;
                break;
            case 'right':
                x_offset = -width;
                break;
            }
            // guestimated from https://www.w3.org/TR/2dcontext/#dom-context-2d-textbaseline
            switch (ctx.textBaseline) {
            case 'top':
                y_offset = 0;
                break;
            case 'middle':
                y_offset = -0.5 * height;
                break;
            case 'bottom':
                y_offset = -1 * height;
                break;
            case 'alphabetic':
                y_offset = -0.8 * height;
                break;
            case 'hanging':
                y_offset = -0.17 * height;
                break;
            case 'ideographic':
                y_offset = -0.83 * height;
                break;
            }
            return [
                x_offset,
                y_offset,
                width,
                height
            ];
        };
        TextAnnotationView.prototype._get_size = function () {
            var ctx = this.plot_view.canvas_view.ctx;
            this.visuals.text.set_value(ctx);
            return ctx.measureText(this.model.text).ascent;
        };
        TextAnnotationView.prototype.render = function () {
            return null;
        };
        TextAnnotationView.prototype._canvas_text = function (ctx, text, sx, sy, angle) {
            this.visuals.text.set_value(ctx);
            var bbox_dims = this._calculate_bounding_box_dimensions(ctx, text);
            ctx.save();
            ctx.beginPath();
            ctx.translate(sx, sy);
            if (angle) {
                ctx.rotate(angle);
            }
            ctx.rect(bbox_dims[0], bbox_dims[1], bbox_dims[2], bbox_dims[3]);
            if (this.visuals.background_fill.doit) {
                this.visuals.background_fill.set_value(ctx);
                ctx.fill();
            }
            if (this.visuals.border_line.doit) {
                this.visuals.border_line.set_value(ctx);
                ctx.stroke();
            }
            if (this.visuals.text.doit) {
                this.visuals.text.set_value(ctx);
                ctx.fillText(text, 0, 0);
            }
            return ctx.restore();
        };
        TextAnnotationView.prototype._css_text = function (ctx, text, sx, sy, angle) {
            var line_dash;
            dom_1.hide(this.el);
            this.visuals.text.set_value(ctx);
            var bbox_dims = this._calculate_bounding_box_dimensions(ctx, text);
            // attempt to support vector string-style ("8 4 8") line dashing for css mode
            var ld = this.visuals.border_line.line_dash.value();
            if (types_1.isArray(ld)) {
                if (ld.length < 2) {
                    line_dash = 'solid';
                } else {
                    line_dash = 'dashed';
                }
            }
            if (types_1.isString(ld)) {
                line_dash = ld;
            }
            this.visuals.border_line.set_value(ctx);
            this.visuals.background_fill.set_value(ctx);
            this.el.style.position = 'absolute';
            this.el.style.left = sx + bbox_dims[0] + 'px';
            this.el.style.top = sy + bbox_dims[1] + 'px';
            this.el.style.color = '' + this.visuals.text.text_color.value();
            this.el.style.opacity = '' + this.visuals.text.text_alpha.value();
            this.el.style.font = '' + this.visuals.text.font_value();
            this.el.style.lineHeight = 'normal';
            // needed to prevent ipynb css override
            if (angle) {
                this.el.style.transform = 'rotate(' + angle + 'rad)';
            }
            if (this.visuals.background_fill.doit) {
                this.el.style.backgroundColor = '' + this.visuals.background_fill.color_value();
            }
            if (this.visuals.border_line.doit) {
                this.el.style.borderStyle = '' + line_dash;
                this.el.style.borderWidth = this.visuals.border_line.line_width.value() + 'px';
                this.el.style.borderColor = '' + this.visuals.border_line.color_value();
            }
            this.el.textContent = text;
            return dom_1.show(this.el);
        };
        return TextAnnotationView;
    }(annotation_1.AnnotationView);
    exports.TextAnnotationView = TextAnnotationView;
    var TextAnnotation = function (_super) {
        tslib_1.__extends(TextAnnotation, _super);
        function TextAnnotation(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        TextAnnotation.initClass = function () {
            this.prototype.type = 'TextAnnotation';
        };
        return TextAnnotation;
    }(annotation_1.Annotation);
    exports.TextAnnotation = TextAnnotation;
    TextAnnotation.initClass();    
},
/*models/annotations/title*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    /* XXX: partial */
    var text_annotation_1 = require(65    /* ./text_annotation */);
    var dom_1 = require(5    /* core/dom */);
    var p = require(15    /* core/properties */);
    var Visuals = require(47    /* core/visuals */);
    var TitleView = function (_super) {
        tslib_1.__extends(TitleView, _super);
        function TitleView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        TitleView.prototype.initialize = function (options) {
            _super.prototype.initialize.call(this, options);
            this.visuals.text = new Visuals.Text(this.model);
        };
        TitleView.prototype._get_location = function () {
            var sx, sy;
            var panel = this.model.panel;
            var hmargin = this.model.offset;
            var vmargin = 5;
            switch (panel.side) {
            case 'above':
            case 'below':
                switch (this.model.vertical_align) {
                case 'top':
                    sy = panel._top.value + vmargin;
                    break;
                case 'middle':
                    sy = panel._vcenter.value;
                    break;
                case 'bottom':
                    sy = panel._bottom.value - vmargin;
                    break;
                }
                switch (this.model.align) {
                case 'left':
                    sx = panel._left.value + hmargin;
                    break;
                case 'center':
                    sx = panel._hcenter.value;
                    break;
                case 'right':
                    sx = panel._right.value - hmargin;
                    break;
                }
                break;
            case 'left':
                switch (this.model.vertical_align) {
                case 'top':
                    sx = panel._left.value - vmargin;
                    break;
                case 'middle':
                    sx = panel._hcenter.value;
                    break;
                case 'bottom':
                    sx = panel._right.value + vmargin;
                    break;
                }
                switch (this.model.align) {
                case 'left':
                    sy = panel._bottom.value - hmargin;
                    break;
                case 'center':
                    sy = panel._vcenter.value;
                    break;
                case 'right':
                    sy = panel._top.value + hmargin;
                    break;
                }
                break;
            case 'right':
                switch (this.model.vertical_align) {
                case 'top':
                    sx = panel._right.value - vmargin;
                    break;
                case 'middle':
                    sx = panel._hcenter.value;
                    break;
                case 'bottom':
                    sx = panel._left.value + vmargin;
                    break;
                }
                switch (this.model.align) {
                case 'left':
                    sy = panel._top.value + hmargin;
                    break;
                case 'center':
                    sy = panel._vcenter.value;
                    break;
                case 'right':
                    sy = panel._bottom.value - hmargin;
                    break;
                }
                break;
            }
            return [
                sx,
                sy
            ];
        };
        TitleView.prototype.render = function () {
            if (!this.model.visible) {
                if (this.model.render_mode === 'css') {
                    dom_1.hide(this.el);
                }
                return;
            }
            var text = this.model.text;
            if (text == null || text.length === 0) {
                return;
            }
            this.model.text_baseline = this.model.vertical_align;
            this.model.text_align = this.model.align;
            var _a = this._get_location(), sx = _a[0], sy = _a[1];
            var angle = this.model.panel.get_label_angle_heuristic('parallel');
            var draw = this.model.render_mode === 'canvas' ? this._canvas_text.bind(this) : this._css_text.bind(this);
            return draw(this.plot_view.canvas_view.ctx, text, sx, sy, angle);
        };
        TitleView.prototype._get_size = function () {
            var text = this.model.text;
            if (text == null || text.length === 0) {
                return 0;
            } else {
                var ctx = this.plot_view.canvas_view.ctx;
                this.visuals.text.set_value(ctx);
                return ctx.measureText(text).ascent + 10;
            }
        };
        return TitleView;
    }(text_annotation_1.TextAnnotationView);
    exports.TitleView = TitleView;
    var Title = function (_super) {
        tslib_1.__extends(Title, _super);
        function Title(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        Title.initClass = function () {
            this.prototype.type = 'Title';
            this.prototype.default_view = TitleView;
            this.mixins([
                'line:border_',
                'fill:background_'
            ]);
            this.define({
                text: [p.String],
                text_font: [
                    p.Font,
                    'helvetica'
                ],
                text_font_size: [
                    p.FontSizeSpec,
                    '10pt'
                ],
                text_font_style: [
                    p.FontStyle,
                    'bold'
                ],
                text_color: [
                    p.ColorSpec,
                    '#444444'
                ],
                text_alpha: [
                    p.NumberSpec,
                    1
                ],
                vertical_align: [
                    p.VerticalAlign,
                    'bottom'
                ],
                align: [
                    p.TextAlign,
                    'left'
                ],
                offset: [
                    p.Number,
                    0
                ],
                render_mode: [
                    p.RenderMode,
                    'canvas'
                ]
            });
            this.override({
                background_fill_color: null,
                border_line_color: null
            });
            this.internal({
                text_align: [
                    p.TextAlign,
                    'left'
                ],
                text_baseline: [
                    p.TextBaseline,
                    'bottom'
                ]
            });
        };
        return Title;
    }(text_annotation_1.TextAnnotation);
    exports.Title = Title;
    Title.initClass();    
},
/*models/annotations/toolbar_panel*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    /* XXX: partial */
    var annotation_1 = require(52    /* ./annotation */);
    var build_views_1 = require(4    /* core/build_views */);
    var dom_1 = require(5    /* core/dom */);
    var p = require(15    /* core/properties */);
    var ToolbarPanelView = function (_super) {
        tslib_1.__extends(ToolbarPanelView, _super);
        function ToolbarPanelView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        ToolbarPanelView.prototype.initialize = function (options) {
            _super.prototype.initialize.call(this, options);
            this.plot_view.canvas_events.appendChild(this.el);
            this._toolbar_views = {};
            build_views_1.build_views(this._toolbar_views, [this.model.toolbar], { parent: this });
        };
        ToolbarPanelView.prototype.remove = function () {
            build_views_1.remove_views(this._toolbar_views);
            return _super.prototype.remove.call(this);
        };
        ToolbarPanelView.prototype.render = function () {
            _super.prototype.render.call(this);
            if (!this.model.visible) {
                dom_1.hide(this.el);
                return;
            }
            var panel = this.model.panel;
            this.el.style.position = 'absolute';
            this.el.style.left = panel._left.value + 'px';
            this.el.style.top = panel._top.value + 'px';
            this.el.style.width = panel._width.value + 'px';
            this.el.style.height = panel._height.value + 'px';
            this.el.style.overflow = 'hidden';
            var toolbar = this._toolbar_views[this.model.toolbar.id];
            toolbar.render();
            dom_1.empty(this.el);
            this.el.appendChild(toolbar.el);
            return dom_1.show(this.el);
        };
        ToolbarPanelView.prototype._get_size = function () {
            return 30;
        };
        return ToolbarPanelView;
    }(annotation_1.AnnotationView);
    exports.ToolbarPanelView = ToolbarPanelView;
    var ToolbarPanel = function (_super) {
        tslib_1.__extends(ToolbarPanel, _super);
        function ToolbarPanel(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        ToolbarPanel.initClass = function () {
            this.prototype.type = 'ToolbarPanel';
            this.prototype.default_view = ToolbarPanelView;
            this.define({ toolbar: [p.Instance] });
        };
        return ToolbarPanel;
    }(annotation_1.Annotation);
    exports.ToolbarPanel = ToolbarPanel;
    ToolbarPanel.initClass();    
},
/*models/annotations/tooltip*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    /* XXX: partial */
    var annotation_1 = require(52    /* ./annotation */);
    var dom_1 = require(5    /* core/dom */);
    var p = require(15    /* core/properties */);
    exports.compute_side = function (attachment, sx, sy, hcenter, vcenter) {
        var side;
        switch (attachment) {
        case 'horizontal':
            side = sx < hcenter ? 'right' : 'left';
            break;
        case 'vertical':
            side = sy < vcenter ? 'below' : 'above';
            break;
        default:
            side = attachment;
        }
        return side;
    };
    var TooltipView = function (_super) {
        tslib_1.__extends(TooltipView, _super);
        function TooltipView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        TooltipView.prototype.initialize = function (options) {
            _super.prototype.initialize.call(this, options);
            // TODO (bev) really probably need multiple divs
            this.plot_view.canvas_overlays.appendChild(this.el);
            this.el.style.zIndex = 1010;
            dom_1.hide(this.el);
        };
        TooltipView.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            this.connect(this.model.properties.data.change, function () {
                return _this._draw_tips();
            });
        };
        TooltipView.prototype.css_classes = function () {
            return _super.prototype.css_classes.call(this).concat('bk-tooltip');
        };
        TooltipView.prototype.render = function () {
            if (!this.model.visible) {
                return;
            }
            return this._draw_tips();
        };
        TooltipView.prototype._draw_tips = function () {
            var left, sx, sy, top;
            var data = this.model.data;
            dom_1.empty(this.el);
            dom_1.hide(this.el);
            if (this.model.custom) {
                this.el.classList.add('bk-tooltip-custom');
            } else {
                this.el.classList.remove('bk-tooltip-custom');
            }
            if (data.length === 0) {
                return;
            }
            var frame = this.plot_view.frame;
            for (var _i = 0, data_1 = data; _i < data_1.length; _i++) {
                var val = data_1[_i];
                var content = void 0;
                sx = val[0], sy = val[1], content = val[2];
                if (this.model.inner_only && !frame.bbox.contains(sx, sy)) {
                    continue;
                }
                var tip = dom_1.div({}, content);
                this.el.appendChild(tip);
            }
            var side = exports.compute_side(this.model.attachment, sx, sy, frame._hcenter.value, frame._vcenter.value);
            this.el.classList.remove('bk-right');
            this.el.classList.remove('bk-left');
            this.el.classList.remove('bk-above');
            this.el.classList.remove('bk-below');
            var arrow_size = 10;
            // XXX: keep in sync with less
            dom_1.show(this.el);
            // XXX: {offset,client}Width() gives 0 when display="none"
            // slightly confusing: side "left" (for example) is relative to point that
            // is being annotated but CS class "bk-left" is relative to the tooltip itself
            switch (side) {
            case 'right':
                this.el.classList.add('bk-left');
                left = sx + (this.el.offsetWidth - this.el.clientWidth) + arrow_size;
                top = sy - this.el.offsetHeight / 2;
                break;
            case 'left':
                this.el.classList.add('bk-right');
                left = sx - this.el.offsetWidth - arrow_size;
                top = sy - this.el.offsetHeight / 2;
                break;
            case 'below':
                this.el.classList.add('bk-above');
                top = sy + (this.el.offsetHeight - this.el.clientHeight) + arrow_size;
                left = Math.round(sx - this.el.offsetWidth / 2);
                break;
            case 'above':
                this.el.classList.add('bk-below');
                top = sy - this.el.offsetHeight - arrow_size;
                left = Math.round(sx - this.el.offsetWidth / 2);
                break;
            }
            if (this.model.show_arrow) {
                this.el.classList.add('bk-tooltip-arrow');
            }
            // TODO (bev) this is not currently bulletproof. If there are
            // two hits, not colocated and one is off the screen, that can
            // be problematic
            if (this.el.childNodes.length > 0) {
                this.el.style.top = top + 'px';
                return this.el.style.left = left + 'px';
            } else {
                return dom_1.hide(this.el);
            }
        };
        return TooltipView;
    }(annotation_1.AnnotationView);
    exports.TooltipView = TooltipView;
    var Tooltip = function (_super) {
        tslib_1.__extends(Tooltip, _super);
        function Tooltip(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        Tooltip.initClass = function () {
            this.prototype.type = 'Tooltip';
            this.prototype.default_view = TooltipView;
            this.define({
                attachment: [
                    p.String,
                    'horizontal'
                ],
                inner_only: [
                    p.Bool,
                    true
                ],
                show_arrow: [
                    p.Bool,
                    true
                ]
            });
            this.override({ level: 'overlay' });
            this.internal({
                data: [
                    p.Any,
                    []
                ],
                custom: [p.Any]
            });
        };
        Tooltip.prototype.clear = function () {
            this.data = [];
        };
        Tooltip.prototype.add = function (sx, sy, content) {
            var data = this.data;
            data.push([
                sx,
                sy,
                content
            ]);
            this.data = data;
            // TODO (bev) not sure why this is now necessary
            this.properties.data.change.emit(undefined);
        };
        return Tooltip;
    }(annotation_1.Annotation);
    exports.Tooltip = Tooltip;
    Tooltip.initClass();    
},
/*models/annotations/whisker*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    /* XXX: partial */
    var annotation_1 = require(52    /* ./annotation */);
    var column_data_source_1 = require(174    /* ../sources/column_data_source */);
    var arrow_head_1 = require(54    /* ./arrow_head */);
    var p = require(15    /* core/properties */);
    var WhiskerView = function (_super) {
        tslib_1.__extends(WhiskerView, _super);
        function WhiskerView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        WhiskerView.prototype.initialize = function (options) {
            _super.prototype.initialize.call(this, options);
            this.set_data(this.model.source);
        };
        WhiskerView.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            this.connect(this.model.source.streaming, function () {
                return _this.set_data(_this.model.source);
            });
            this.connect(this.model.source.patching, function () {
                return _this.set_data(_this.model.source);
            });
            this.connect(this.model.source.change, function () {
                return _this.set_data(_this.model.source);
            });
        };
        WhiskerView.prototype.set_data = function (source) {
            _super.prototype.set_data.call(this, source);
            this.visuals.warm_cache(source);
            return this.plot_view.request_render();
        };
        WhiskerView.prototype._map_data = function () {
            var _base_sx, _lower_sx, _upper_sx;
            var frame = this.plot_model.frame;
            var dim = this.model.dimension;
            var xscale = frame.xscales[this.model.x_range_name];
            var yscale = frame.yscales[this.model.y_range_name];
            var limit_scale = dim === 'height' ? yscale : xscale;
            var base_scale = dim === 'height' ? xscale : yscale;
            var limit_view = dim === 'height' ? frame.yview : frame.xview;
            var base_view = dim === 'height' ? frame.xview : frame.yview;
            if (this.model.lower.units === 'data') {
                _lower_sx = limit_scale.v_compute(this._lower);
            } else {
                _lower_sx = limit_view.v_compute(this._lower);
            }
            if (this.model.upper.units === 'data') {
                _upper_sx = limit_scale.v_compute(this._upper);
            } else {
                _upper_sx = limit_view.v_compute(this._upper);
            }
            if (this.model.base.units === 'data') {
                _base_sx = base_scale.v_compute(this._base);
            } else {
                _base_sx = base_view.v_compute(this._base);
            }
            var _a = dim === 'height' ? [
                    1,
                    0
                ] : [
                    0,
                    1
                ], i = _a[0], j = _a[1];
            var _lower = [
                _lower_sx,
                _base_sx
            ];
            var _upper = [
                _upper_sx,
                _base_sx
            ];
            this._lower_sx = _lower[i];
            this._lower_sy = _lower[j];
            this._upper_sx = _upper[i];
            return this._upper_sy = _upper[j];
        };
        WhiskerView.prototype.render = function () {
            if (!this.model.visible) {
                return;
            }
            this._map_data();
            var ctx = this.plot_view.canvas_view.ctx;
            if (this.visuals.line.doit) {
                for (var i = 0, end = this._lower_sx.length; i < end; i++) {
                    this.visuals.line.set_vectorize(ctx, i);
                    ctx.beginPath();
                    ctx.moveTo(this._lower_sx[i], this._lower_sy[i]);
                    ctx.lineTo(this._upper_sx[i], this._upper_sy[i]);
                    ctx.stroke();
                }
            }
            var angle = this.model.dimension === 'height' ? 0 : Math.PI / 2;
            if (this.model.lower_head != null) {
                for (var i = 0, end = this._lower_sx.length; i < end; i++) {
                    ctx.save();
                    ctx.translate(this._lower_sx[i], this._lower_sy[i]);
                    ctx.rotate(angle + Math.PI);
                    this.model.lower_head.render(ctx, i);
                    ctx.restore();
                }
            }
            if (this.model.upper_head != null) {
                for (var i = 0, end = this._upper_sx.length; i < end; i++) {
                    ctx.save();
                    ctx.translate(this._upper_sx[i], this._upper_sy[i]);
                    ctx.rotate(angle);
                    this.model.upper_head.render(ctx, i);
                    ctx.restore();
                }
            }
        };
        return WhiskerView;
    }(annotation_1.AnnotationView);
    exports.WhiskerView = WhiskerView;
    var Whisker = function (_super) {
        tslib_1.__extends(Whisker, _super);
        function Whisker(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        Whisker.initClass = function () {
            this.prototype.type = 'Whisker';
            this.prototype.default_view = WhiskerView;
            this.mixins(['line']);
            this.define({
                lower: [p.DistanceSpec],
                lower_head: [
                    p.Instance,
                    function () {
                        return new arrow_head_1.TeeHead({
                            level: 'underlay',
                            size: 10
                        });
                    }
                ],
                upper: [p.DistanceSpec],
                upper_head: [
                    p.Instance,
                    function () {
                        return new arrow_head_1.TeeHead({
                            level: 'underlay',
                            size: 10
                        });
                    }
                ],
                base: [p.DistanceSpec],
                dimension: [
                    p.Dimension,
                    'height'
                ],
                source: [
                    p.Instance,
                    function () {
                        return new column_data_source_1.ColumnDataSource();
                    }
                ],
                x_range_name: [
                    p.String,
                    'default'
                ],
                y_range_name: [
                    p.String,
                    'default'
                ]
            });
            this.override({ level: 'underlay' });
        };
        return Whisker;
    }(annotation_1.Annotation);
    exports.Whisker = Whisker;
    Whisker.initClass();    
},
/*models/axes/axis*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    var guide_renderer_1 = require(164    /* ../renderers/guide_renderer */);
    var p = require(15    /* core/properties */);
    var side_panel_1 = require(12    /* core/layout/side_panel */);
    var array_1 = require(22    /* core/util/array */);
    var types_1 = require(43    /* core/util/types */);
    var abs = Math.abs, min = Math.min, max = Math.max;
    var AxisView = function (_super) {
        tslib_1.__extends(AxisView, _super);
        function AxisView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        AxisView.prototype.render = function () {
            if (!this.model.visible)
                return;
            var extents = {
                tick: this._tick_extent(),
                tick_label: this._tick_label_extents(),
                axis_label: this._axis_label_extent()
            };
            var tick_coords = this.model.tick_coords;
            var ctx = this.plot_view.canvas_view.ctx;
            ctx.save();
            this._draw_rule(ctx, extents);
            this._draw_major_ticks(ctx, extents, tick_coords);
            this._draw_minor_ticks(ctx, extents, tick_coords);
            this._draw_major_labels(ctx, extents, tick_coords);
            this._draw_axis_label(ctx, extents, tick_coords);
            if (this._render != null)
                this._render(ctx, extents, tick_coords);
            ctx.restore();
        };
        AxisView.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            this.connect(this.model.change, function () {
                return _this.plot_view.request_render();
            });
        };
        AxisView.prototype.get_size = function () {
            return this.model.visible ? Math.round(this._get_size()) : 0;
        };
        AxisView.prototype._get_size = function () {
            return this._tick_extent() + this._tick_label_extent() + this._axis_label_extent();
        };
        // drawing sub functions -----------------------------------------------------
        AxisView.prototype._draw_rule = function (ctx, _extents) {
            if (!this.visuals.axis_line.doit)
                return;
            var _a = this.model.rule_coords, xs = _a[0], ys = _a[1];
            var _b = this.plot_view.map_to_screen(xs, ys, this.model.x_range_name, this.model.y_range_name), sxs = _b[0], sys = _b[1];
            var _c = this.model.normals, nx = _c[0], ny = _c[1];
            var _d = this.model.offsets, xoff = _d[0], yoff = _d[1];
            this.visuals.axis_line.set_value(ctx);
            ctx.beginPath();
            ctx.moveTo(Math.round(sxs[0] + nx * xoff), Math.round(sys[0] + ny * yoff));
            for (var i = 1; i < sxs.length; i++) {
                var sx = Math.round(sxs[i] + nx * xoff);
                var sy = Math.round(sys[i] + ny * yoff);
                ctx.lineTo(sx, sy);
            }
            ctx.stroke();
        };
        AxisView.prototype._draw_major_ticks = function (ctx, _extents, tick_coords) {
            var tin = this.model.major_tick_in;
            var tout = this.model.major_tick_out;
            var visuals = this.visuals.major_tick_line;
            this._draw_ticks(ctx, tick_coords.major, tin, tout, visuals);
        };
        AxisView.prototype._draw_minor_ticks = function (ctx, _extents, tick_coords) {
            var tin = this.model.minor_tick_in;
            var tout = this.model.minor_tick_out;
            var visuals = this.visuals.minor_tick_line;
            this._draw_ticks(ctx, tick_coords.minor, tin, tout, visuals);
        };
        AxisView.prototype._draw_major_labels = function (ctx, extents, tick_coords) {
            var coords = tick_coords.major;
            var labels = this.model.compute_labels(coords[this.model.dimension]);
            var orient = this.model.major_label_orientation;
            var standoff = extents.tick + this.model.major_label_standoff;
            var visuals = this.visuals.major_label_text;
            this._draw_oriented_labels(ctx, labels, coords, orient, this.model.panel.side, standoff, visuals);
        };
        AxisView.prototype._draw_axis_label = function (ctx, extents, _tick_coords) {
            if (this.model.axis_label == null || this.model.axis_label.length == 0)
                return;
            var sx;
            var sy;
            switch (this.model.panel.side) {
            case 'above':
                sx = this.model.panel._hcenter.value;
                sy = this.model.panel._bottom.value;
                break;
            case 'below':
                sx = this.model.panel._hcenter.value;
                sy = this.model.panel._top.value;
                break;
            case 'left':
                sx = this.model.panel._right.value;
                sy = this.model.panel._vcenter.value;
                break;
            case 'right':
                sx = this.model.panel._left.value;
                sy = this.model.panel._vcenter.value;
                break;
            default:
                throw new Error('unknown side: ' + this.model.panel.side);
            }
            var coords = [
                [sx],
                [sy]
            ];
            var standoff = extents.tick + array_1.sum(extents.tick_label) + this.model.axis_label_standoff;
            var visuals = this.visuals.axis_label_text;
            this._draw_oriented_labels(ctx, [this.model.axis_label], coords, 'parallel', this.model.panel.side, standoff, visuals, 'screen');
        };
        AxisView.prototype._draw_ticks = function (ctx, coords, tin, tout, visuals) {
            if (!visuals.doit || coords.length == 0)
                return;
            var x = coords[0], y = coords[1];
            var _a = this.plot_view.map_to_screen(x, y, this.model.x_range_name, this.model.y_range_name), sxs = _a[0], sys = _a[1];
            var _b = this.model.normals, nx = _b[0], ny = _b[1];
            var _c = this.model.offsets, xoff = _c[0], yoff = _c[1];
            var _d = [
                    nx * (xoff - tin),
                    ny * (yoff - tin)
                ], nxin = _d[0], nyin = _d[1];
            var _e = [
                    nx * (xoff + tout),
                    ny * (yoff + tout)
                ], nxout = _e[0], nyout = _e[1];
            visuals.set_value(ctx);
            for (var i = 0; i < sxs.length; i++) {
                var sx0 = Math.round(sxs[i] + nxout);
                var sy0 = Math.round(sys[i] + nyout);
                var sx1 = Math.round(sxs[i] + nxin);
                var sy1 = Math.round(sys[i] + nyin);
                ctx.beginPath();
                ctx.moveTo(sx0, sy0);
                ctx.lineTo(sx1, sy1);
                ctx.stroke();
            }
        };
        AxisView.prototype._draw_oriented_labels = function (ctx, labels, coords, orient, _side, standoff, visuals, units) {
            if (units === void 0) {
                units = 'data';
            }
            if (!visuals.doit || labels.length == 0)
                return;
            var sxs, sys;
            var xoff, yoff;
            if (units == 'screen') {
                sxs = coords[0], sys = coords[1];
                _a = [
                    0,
                    0
                ], xoff = _a[0], yoff = _a[1];
            } else {
                var dxs = coords[0], dys = coords[1];
                _b = this.plot_view.map_to_screen(dxs, dys, this.model.x_range_name, this.model.y_range_name), sxs = _b[0], sys = _b[1];
                _c = this.model.offsets, xoff = _c[0], yoff = _c[1];
            }
            var _d = this.model.normals, nx = _d[0], ny = _d[1];
            var nxd = nx * (xoff + standoff);
            var nyd = ny * (yoff + standoff);
            visuals.set_value(ctx);
            this.model.panel.apply_label_text_heuristics(ctx, orient);
            var angle;
            if (types_1.isString(orient))
                angle = this.model.panel.get_label_angle_heuristic(orient);
            else
                angle = -orient;
            for (var i = 0; i < sxs.length; i++) {
                var sx = Math.round(sxs[i] + nxd);
                var sy = Math.round(sys[i] + nyd);
                ctx.translate(sx, sy);
                ctx.rotate(angle);
                ctx.fillText(labels[i], 0, 0);
                ctx.rotate(-angle);
                ctx.translate(-sx, -sy);
            }
            var _a, _b, _c;
        };
        // extents sub functions -----------------------------------------------------
        AxisView.prototype._axis_label_extent = function () {
            if (this.model.axis_label == null || this.model.axis_label == '')
                return 0;
            var standoff = this.model.axis_label_standoff;
            var visuals = this.visuals.axis_label_text;
            return this._oriented_labels_extent([this.model.axis_label], 'parallel', this.model.panel.side, standoff, visuals);
        };
        AxisView.prototype._tick_extent = function () {
            return this.model.major_tick_out;
        };
        AxisView.prototype._tick_label_extent = function () {
            return array_1.sum(this._tick_label_extents());
        };
        AxisView.prototype._tick_label_extents = function () {
            var coords = this.model.tick_coords.major;
            var labels = this.model.compute_labels(coords[this.model.dimension]);
            var orient = this.model.major_label_orientation;
            var standoff = this.model.major_label_standoff;
            var visuals = this.visuals.major_label_text;
            return [this._oriented_labels_extent(labels, orient, this.model.panel.side, standoff, visuals)];
        };
        AxisView.prototype._oriented_labels_extent = function (labels, orient, side, standoff, visuals) {
            if (labels.length == 0)
                return 0;
            var ctx = this.plot_view.canvas_view.ctx;
            visuals.set_value(ctx);
            var hscale;
            var angle;
            if (types_1.isString(orient)) {
                hscale = 1;
                angle = this.model.panel.get_label_angle_heuristic(orient);
            } else {
                hscale = 2;
                angle = -orient;
            }
            angle = Math.abs(angle);
            var c = Math.cos(angle);
            var s = Math.sin(angle);
            var extent = 0;
            for (var i = 0; i < labels.length; i++) {
                var w = ctx.measureText(labels[i]).width * 1.1;
                var h = ctx.measureText(labels[i]).ascent * 0.9;
                var val = void 0;
                if (side == 'above' || side == 'below')
                    val = w * s + h / hscale * c;
                else
                    val = w * c + h / hscale * s;
                // update extent if current value is larger
                if (val > extent)
                    extent = val;
            }
            // only apply the standoff if we already have non-zero extent
            if (extent > 0)
                extent += standoff;
            return extent;
        };
        return AxisView;
    }(guide_renderer_1.GuideRendererView);
    exports.AxisView = AxisView;
    var Axis = function (_super) {
        tslib_1.__extends(Axis, _super);
        function Axis(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        Axis.initClass = function () {
            this.prototype.type = 'Axis';
            this.prototype.default_view = AxisView;
            this.mixins([
                'line:axis_',
                'line:major_tick_',
                'line:minor_tick_',
                'text:major_label_',
                'text:axis_label_'
            ]);
            this.define({
                bounds: [
                    p.Any,
                    'auto'
                ],
                ticker: [
                    p.Instance,
                    null
                ],
                formatter: [
                    p.Instance,
                    null
                ],
                x_range_name: [
                    p.String,
                    'default'
                ],
                y_range_name: [
                    p.String,
                    'default'
                ],
                axis_label: [
                    p.String,
                    ''
                ],
                axis_label_standoff: [
                    p.Int,
                    5
                ],
                major_label_standoff: [
                    p.Int,
                    5
                ],
                major_label_orientation: [
                    p.Any,
                    'horizontal'
                ],
                major_label_overrides: [
                    p.Any,
                    {}
                ],
                major_tick_in: [
                    p.Number,
                    2
                ],
                major_tick_out: [
                    p.Number,
                    6
                ],
                minor_tick_in: [
                    p.Number,
                    0
                ],
                minor_tick_out: [
                    p.Number,
                    4
                ]
            });
            this.override({
                axis_line_color: 'black',
                major_tick_line_color: 'black',
                minor_tick_line_color: 'black',
                major_label_text_font_size: '8pt',
                major_label_text_align: 'center',
                major_label_text_baseline: 'alphabetic',
                axis_label_text_font_size: '10pt',
                axis_label_text_font_style: 'italic'
            });
        };
        Axis.prototype.add_panel = function (side) {
            this.panel = new side_panel_1.SidePanel({ side: side });
            this.panel.attach_document(this.document);    // XXX!
        };
        Object.defineProperty(Axis.prototype, 'normals', {
            get: function () {
                return this.panel.normals;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Axis.prototype, 'dimension', {
            get: function () {
                return this.panel.dimension;
            },
            enumerable: true,
            configurable: true
        });
        Axis.prototype.compute_labels = function (ticks) {
            var labels = this.formatter.doFormat(ticks, this);
            for (var i = 0; i < ticks.length; i++) {
                if (ticks[i] in this.major_label_overrides)
                    labels[i] = this.major_label_overrides[ticks[i]];
            }
            return labels;
        };
        Axis.prototype.label_info = function (coords) {
            return {
                dim: this.dimension,
                coords: coords,
                side: this.panel.side,
                orient: this.major_label_orientation,
                standoff: this.major_label_standoff
            };
        };
        Object.defineProperty(Axis.prototype, 'offsets', {
            get: function () {
                var frame = this.plot.plot_canvas.frame;
                var _a = [
                        0,
                        0
                    ], xoff = _a[0], yoff = _a[1];
                switch (this.panel.side) {
                case 'below':
                    yoff = abs(this.panel._top.value - frame._bottom.value);
                    break;
                case 'above':
                    yoff = abs(this.panel._bottom.value - frame._top.value);
                    break;
                case 'right':
                    xoff = abs(this.panel._left.value - frame._right.value);
                    break;
                case 'left':
                    xoff = abs(this.panel._right.value - frame._left.value);
                    break;
                }
                return [
                    xoff,
                    yoff
                ];
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Axis.prototype, 'ranges', {
            get: function () {
                var i = this.dimension;
                var j = (i + 1) % 2;
                var frame = this.plot.plot_canvas.frame;
                var ranges = [
                    frame.x_ranges[this.x_range_name],
                    frame.y_ranges[this.y_range_name]
                ];
                return [
                    ranges[i],
                    ranges[j]
                ];
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Axis.prototype, 'computed_bounds', {
            get: function () {
                var range = this.ranges[0];
                var user_bounds = this.bounds;
                // XXX: ? 'auto'
                var range_bounds = [
                    range.min,
                    range.max
                ];
                if (user_bounds == 'auto')
                    return [
                        range.min,
                        range.max
                    ];
                else if (types_1.isArray(user_bounds)) {
                    var start = void 0;
                    var end = void 0;
                    var user_start = user_bounds[0], user_end = user_bounds[1];
                    var range_start = range_bounds[0], range_end = range_bounds[1];
                    if (abs(user_start - user_end) > abs(range_start - range_end)) {
                        start = max(min(user_start, user_end), range_start);
                        end = min(max(user_start, user_end), range_end);
                    } else {
                        start = min(user_start, user_end);
                        end = max(user_start, user_end);
                    }
                    return [
                        start,
                        end
                    ];
                } else
                    throw new Error('user bounds \'' + user_bounds + '\' not understood');
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Axis.prototype, 'rule_coords', {
            get: function () {
                var i = this.dimension;
                var j = (i + 1) % 2;
                var range = this.ranges[0];
                var _a = this.computed_bounds, start = _a[0], end = _a[1];
                var xs = new Array(2);
                var ys = new Array(2);
                var coords = [
                    xs,
                    ys
                ];
                coords[i][0] = Math.max(start, range.min);
                coords[i][1] = Math.min(end, range.max);
                if (coords[i][0] > coords[i][1])
                    coords[i][0] = coords[i][1] = NaN;
                coords[j][0] = this.loc;
                coords[j][1] = this.loc;
                return coords;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Axis.prototype, 'tick_coords', {
            get: function () {
                var i = this.dimension;
                var j = (i + 1) % 2;
                var range = this.ranges[0];
                var _a = this.computed_bounds, start = _a[0], end = _a[1];
                var ticks = this.ticker.get_ticks(start, end, range, this.loc, {});
                var majors = ticks.major;
                var minors = ticks.minor;
                var xs = [];
                var ys = [];
                var coords = [
                    xs,
                    ys
                ];
                var minor_xs = [];
                var minor_ys = [];
                var minor_coords = [
                    minor_xs,
                    minor_ys
                ];
                var _b = [
                        range.min,
                        range.max
                    ], range_min = _b[0], range_max = _b[1];
                for (var ii = 0; ii < majors.length; ii++) {
                    if (majors[ii] < range_min || majors[ii] > range_max)
                        continue;
                    coords[i].push(majors[ii]);
                    coords[j].push(this.loc);
                }
                for (var ii = 0; ii < minors.length; ii++) {
                    if (minors[ii] < range_min || minors[ii] > range_max)
                        continue;
                    minor_coords[i].push(minors[ii]);
                    minor_coords[j].push(this.loc);
                }
                return {
                    major: coords,
                    minor: minor_coords
                };
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Axis.prototype, 'loc', {
            get: function () {
                var _a = this.ranges, cross_range = _a[1];
                switch (this.panel.side) {
                case 'left':
                case 'below':
                    return cross_range.start;
                case 'right':
                case 'above':
                    return cross_range.end;
                }
            },
            enumerable: true,
            configurable: true
        });
        return Axis;
    }(guide_renderer_1.GuideRenderer);
    exports.Axis = Axis;
    Axis.initClass();    
},
/*models/axes/categorical_axis*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    var axis_1 = require(70    /* ./axis */);
    var categorical_ticker_1 = require(182    /* ../tickers/categorical_ticker */);
    var categorical_tick_formatter_1 = require(93    /* ../formatters/categorical_tick_formatter */);
    var CategoricalAxisView = function (_super) {
        tslib_1.__extends(CategoricalAxisView, _super);
        function CategoricalAxisView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        CategoricalAxisView.prototype._render = function (ctx, extents, tick_coords) {
            this._draw_group_separators(ctx, extents, tick_coords);
        };
        CategoricalAxisView.prototype._draw_group_separators = function (ctx, _extents, _tick_coords) {
            var range = this.model.ranges[0];
            var _a = this.model.computed_bounds, start = _a[0], end = _a[1];
            if (!range.tops || range.tops.length < 2 || !this.visuals.separator_line.doit)
                return;
            var dim = this.model.dimension;
            var alt = (dim + 1) % 2;
            var coords = [
                [],
                []
            ];
            var ind = 0;
            for (var i = 0; i < range.tops.length - 1; i++) {
                var first = void 0, last = void 0;
                for (var j = ind; j < range.factors.length; j++) {
                    if (range.factors[j][0] == range.tops[i + 1]) {
                        _b = [
                            range.factors[j - 1],
                            range.factors[j]
                        ], first = _b[0], last = _b[1];
                        ind = j;
                        break;
                    }
                }
                var pt = (range.synthetic(first) + range.synthetic(last)) / 2;
                if (pt > start && pt < end) {
                    coords[dim].push(pt);
                    coords[alt].push(this.model.loc);
                }
            }
            var tex = this._tick_label_extent();
            this._draw_ticks(ctx, coords, -3, tex - 6, this.visuals.separator_line);
            var _b;
        };
        CategoricalAxisView.prototype._draw_major_labels = function (ctx, extents, _tick_coords) {
            var info = this._get_factor_info();
            var standoff = extents.tick + this.model.major_label_standoff;
            for (var i = 0; i < info.length; i++) {
                var _a = info[i], labels = _a[0], coords = _a[1], orient = _a[2], visuals = _a[3];
                this._draw_oriented_labels(ctx, labels, coords, orient, this.model.panel.side, standoff, visuals);
                standoff += extents.tick_label[i];
            }
        };
        CategoricalAxisView.prototype._tick_label_extents = function () {
            var info = this._get_factor_info();
            var extents = [];
            for (var _i = 0, info_1 = info; _i < info_1.length; _i++) {
                var _a = info_1[_i], labels = _a[0], orient = _a[2], visuals = _a[3];
                var extent = this._oriented_labels_extent(labels, orient, this.model.panel.side, this.model.major_label_standoff, visuals);
                extents.push(extent);
            }
            return extents;
        };
        CategoricalAxisView.prototype._get_factor_info = function () {
            var range = this.model.ranges[0];
            var _a = this.model.computed_bounds, start = _a[0], end = _a[1];
            var loc = this.model.loc;
            var ticks = this.model.ticker.get_ticks(start, end, range, loc, {});
            var coords = this.model.tick_coords;
            var info = [];
            if (range.levels == 1) {
                var labels = this.model.formatter.doFormat(ticks.major, this);
                info.push([
                    labels,
                    coords.major,
                    this.model.major_label_orientation,
                    this.visuals.major_label_text
                ]);
            } else if (range.levels == 2) {
                var labels = this.model.formatter.doFormat(ticks.major.map(function (x) {
                    return x[1];
                }), this);
                info.push([
                    labels,
                    coords.major,
                    this.model.major_label_orientation,
                    this.visuals.major_label_text
                ]);
                info.push([
                    ticks.tops,
                    coords.tops,
                    'parallel',
                    this.visuals.group_text
                ]);
            } else if (range.levels == 3) {
                var labels = this.model.formatter.doFormat(ticks.major.map(function (x) {
                    return x[2];
                }), this);
                var mid_labels = ticks.mids.map(function (x) {
                    return x[1];
                });
                info.push([
                    labels,
                    coords.major,
                    this.model.major_label_orientation,
                    this.visuals.major_label_text
                ]);
                info.push([
                    mid_labels,
                    coords.mids,
                    'parallel',
                    this.visuals.subgroup_text
                ]);
                info.push([
                    ticks.tops,
                    coords.tops,
                    'parallel',
                    this.visuals.group_text
                ]);
            }
            return info;
        };
        return CategoricalAxisView;
    }(axis_1.AxisView);
    exports.CategoricalAxisView = CategoricalAxisView;
    var CategoricalAxis = function (_super) {
        tslib_1.__extends(CategoricalAxis, _super);
        function CategoricalAxis(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        CategoricalAxis.initClass = function () {
            this.prototype.type = 'CategoricalAxis';
            this.prototype.default_view = CategoricalAxisView;
            this.mixins([
                'line:separator_',
                'text:group_',
                'text:subgroup_'
            ]);
            this.override({
                ticker: function () {
                    return new categorical_ticker_1.CategoricalTicker();
                },
                formatter: function () {
                    return new categorical_tick_formatter_1.CategoricalTickFormatter();
                },
                separator_line_color: 'lightgrey',
                separator_line_width: 2,
                group_text_font_style: 'bold',
                group_text_font_size: '8pt',
                group_text_color: 'grey',
                subgroup_text_font_style: 'bold',
                subgroup_text_font_size: '8pt'
            });
        };
        Object.defineProperty(CategoricalAxis.prototype, 'tick_coords', {
            get: function () {
                var _this = this;
                var i = this.dimension;
                var j = (i + 1) % 2;
                var range = this.ranges[0];
                var _a = this.computed_bounds, start = _a[0], end = _a[1];
                var ticks = this.ticker.get_ticks(start, end, range, this.loc, {});
                var coords = {
                    major: [
                        [],
                        []
                    ],
                    mids: [
                        [],
                        []
                    ],
                    tops: [
                        [],
                        []
                    ],
                    minor: [
                        [],
                        []
                    ]
                };
                coords.major[i] = ticks.major;
                coords.major[j] = ticks.major.map(function (_x) {
                    return _this.loc;
                });
                if (range.levels == 3)
                    coords.mids[i] = ticks.mids;
                coords.mids[j] = ticks.mids.map(function (_x) {
                    return _this.loc;
                });
                if (range.levels > 1)
                    coords.tops[i] = ticks.tops;
                coords.tops[j] = ticks.tops.map(function (_x) {
                    return _this.loc;
                });
                return coords;
            },
            enumerable: true,
            configurable: true
        });
        return CategoricalAxis;
    }(axis_1.Axis);
    exports.CategoricalAxis = CategoricalAxis;
    CategoricalAxis.initClass();    
},
/*models/axes/continuous_axis*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    var axis_1 = require(70    /* ./axis */);
    var ContinuousAxis = function (_super) {
        tslib_1.__extends(ContinuousAxis, _super);
        function ContinuousAxis(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        ContinuousAxis.initClass = function () {
            this.prototype.type = 'ContinuousAxis';
        };
        return ContinuousAxis;
    }(axis_1.Axis);
    exports.ContinuousAxis = ContinuousAxis;
    ContinuousAxis.initClass();    
},
/*models/axes/datetime_axis*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    var linear_axis_1 = require(75    /* ./linear_axis */);
    var datetime_tick_formatter_1 = require(94    /* ../formatters/datetime_tick_formatter */);
    var datetime_ticker_1 = require(185    /* ../tickers/datetime_ticker */);
    var DatetimeAxisView = function (_super) {
        tslib_1.__extends(DatetimeAxisView, _super);
        function DatetimeAxisView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return DatetimeAxisView;
    }(linear_axis_1.LinearAxisView);
    exports.DatetimeAxisView = DatetimeAxisView;
    var DatetimeAxis = function (_super) {
        tslib_1.__extends(DatetimeAxis, _super);
        function DatetimeAxis(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        DatetimeAxis.initClass = function () {
            this.prototype.type = 'DatetimeAxis';
            this.prototype.default_view = DatetimeAxisView;
            this.override({
                ticker: function () {
                    return new datetime_ticker_1.DatetimeTicker();
                },
                formatter: function () {
                    return new datetime_tick_formatter_1.DatetimeTickFormatter();
                }
            });
        };
        return DatetimeAxis;
    }(linear_axis_1.LinearAxis);
    exports.DatetimeAxis = DatetimeAxis;
    DatetimeAxis.initClass();    
},
/*models/axes/index*/
function _(require, module, exports) {
    var axis_1 = require(70    /* ./axis */);
    exports.Axis = axis_1.Axis;
    var categorical_axis_1 = require(71    /* ./categorical_axis */);
    exports.CategoricalAxis = categorical_axis_1.CategoricalAxis;
    var continuous_axis_1 = require(72    /* ./continuous_axis */);
    exports.ContinuousAxis = continuous_axis_1.ContinuousAxis;
    var datetime_axis_1 = require(73    /* ./datetime_axis */);
    exports.DatetimeAxis = datetime_axis_1.DatetimeAxis;
    var linear_axis_1 = require(75    /* ./linear_axis */);
    exports.LinearAxis = linear_axis_1.LinearAxis;
    var log_axis_1 = require(76    /* ./log_axis */);
    exports.LogAxis = log_axis_1.LogAxis;    
},
/*models/axes/linear_axis*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    var axis_1 = require(70    /* ./axis */);
    var continuous_axis_1 = require(72    /* ./continuous_axis */);
    var basic_tick_formatter_1 = require(92    /* ../formatters/basic_tick_formatter */);
    var basic_ticker_1 = require(181    /* ../tickers/basic_ticker */);
    var LinearAxisView = function (_super) {
        tslib_1.__extends(LinearAxisView, _super);
        function LinearAxisView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return LinearAxisView;
    }(axis_1.AxisView);
    exports.LinearAxisView = LinearAxisView;
    var LinearAxis = function (_super) {
        tslib_1.__extends(LinearAxis, _super);
        function LinearAxis(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        LinearAxis.initClass = function () {
            this.prototype.type = 'LinearAxis';
            this.prototype.default_view = LinearAxisView;
            this.override({
                ticker: function () {
                    return new basic_ticker_1.BasicTicker();
                },
                formatter: function () {
                    return new basic_tick_formatter_1.BasicTickFormatter();
                }
            });
        };
        return LinearAxis;
    }(continuous_axis_1.ContinuousAxis);
    exports.LinearAxis = LinearAxis;
    LinearAxis.initClass();    
},
/*models/axes/log_axis*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    var axis_1 = require(70    /* ./axis */);
    var continuous_axis_1 = require(72    /* ./continuous_axis */);
    var log_tick_formatter_1 = require(97    /* ../formatters/log_tick_formatter */);
    var log_ticker_1 = require(189    /* ../tickers/log_ticker */);
    var LogAxisView = function (_super) {
        tslib_1.__extends(LogAxisView, _super);
        function LogAxisView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return LogAxisView;
    }(axis_1.AxisView);
    exports.LogAxisView = LogAxisView;
    var LogAxis = function (_super) {
        tslib_1.__extends(LogAxis, _super);
        function LogAxis(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        LogAxis.initClass = function () {
            this.prototype.type = 'LogAxis';
            this.prototype.default_view = LogAxisView;
            this.override({
                ticker: function () {
                    return new log_ticker_1.LogTicker();
                },
                formatter: function () {
                    return new log_tick_formatter_1.LogTickFormatter();
                }
            });
        };
        return LogAxis;
    }(continuous_axis_1.ContinuousAxis);
    exports.LogAxis = LogAxis;
    LogAxis.initClass();    
},
/*models/callbacks/customjs*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    /* XXX: partial */
    var p = require(15    /* core/properties */);
    var object_1 = require(31    /* core/util/object */);
    var model_1 = require(51    /* ../../model */);
    var CustomJS = function (_super) {
        tslib_1.__extends(CustomJS, _super);
        function CustomJS(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        CustomJS.initClass = function () {
            this.prototype.type = 'CustomJS';
            this.define({
                args: [
                    p.Any,
                    {}
                ],
                code: [
                    p.String,
                    ''
                ]
            });
        };
        Object.defineProperty(CustomJS.prototype, 'values', {
            get: function () {
                return this._make_values();
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(CustomJS.prototype, 'func', {
            get: function () {
                return this._make_func();
            },
            enumerable: true,
            configurable: true
        });
        CustomJS.prototype.execute = function (cb_obj, cb_data) {
            return this.func.apply(cb_obj, this.values.concat(cb_obj, cb_data, require, {}));
        };
        CustomJS.prototype._make_values = function () {
            return object_1.values(this.args);
        };
        CustomJS.prototype._make_func = function () {
            // this relies on Object.keys(args) and values(args) returning keys and values
            // in the same order
            return new (Function.bind.apply(Function, [void 0].concat(Object.keys(this.args), [
                'cb_obj',
                'cb_data',
                'require',
                'exports',
                this.code
            ])))();
        };
        return CustomJS;
    }(model_1.Model);
    exports.CustomJS = CustomJS;
    CustomJS.initClass();    
},
/*models/callbacks/index*/
function _(require, module, exports) {
    var customjs_1 = require(77    /* ./customjs */);
    exports.CustomJS = customjs_1.CustomJS;
    var open_url_1 = require(79    /* ./open_url */);
    exports.OpenURL = open_url_1.OpenURL;    
},
/*models/callbacks/open_url*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    /* XXX: partial */
    var model_1 = require(51    /* ../../model */);
    var p = require(15    /* core/properties */);
    var selection_1 = require(35    /* core/util/selection */);
    var templating_1 = require(40    /* core/util/templating */);
    var OpenURL = function (_super) {
        tslib_1.__extends(OpenURL, _super);
        function OpenURL(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        OpenURL.initClass = function () {
            this.prototype.type = 'OpenURL';
            this.define({
                url: [
                    p.String,
                    'http://'
                ]
            });
        };
        OpenURL.prototype.execute = function (_cb_obj, cb_data) {
            for (var _i = 0, _a = selection_1.get_indices(cb_data.source); _i < _a.length; _i++) {
                var i = _a[_i];
                var url = templating_1.replace_placeholders(this.url, cb_data.source, i);
                window.open(url);
            }
            return null;
        };
        return OpenURL;
    }(model_1.Model);
    exports.OpenURL = OpenURL;
    OpenURL.initClass();    
},
/*models/canvas/canvas*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    var layout_canvas_1 = require(11    /* core/layout/layout_canvas */);
    var dom_view_1 = require(6    /* core/dom_view */);
    var solver_1 = require(13    /* core/layout/solver */);
    var logging_1 = require(14    /* core/logging */);
    var p = require(15    /* core/properties */);
    var dom_1 = require(5    /* core/dom */);
    var canvas_1 = require(26    /* core/util/canvas */);
    var canvas2svg = require(254    /* canvas2svg */);
    // XXX: no typings
    // fixes up a problem with some versions of IE11
    // ref: http://stackoverflow.com/questions/22062313/imagedata-set-in-internetexplorer
    if (window.CanvasPixelArray != null) {
        window.CanvasPixelArray.prototype.set = function (arr) {
            for (var i = 0; i < this.length; i++) {
                this[i] = arr[i];
            }
        };
    }
    var CanvasView = function (_super) {
        tslib_1.__extends(CanvasView, _super);
        function CanvasView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        CanvasView.prototype.initialize = function (options) {
            _super.prototype.initialize.call(this, options);
            this.map_el = this.model.map ? this.el.appendChild(dom_1.div({ class: 'bk-canvas-map' })) : null;
            switch (this.model.output_backend) {
            case 'canvas':
            case 'webgl':
                this.canvas_el = this.el.appendChild(dom_1.canvas({ class: 'bk-canvas' }));
                this._ctx = this.canvas_el.getContext('2d');
                break;
            case 'svg':
                this._ctx = new canvas2svg();
                this.canvas_el = this.el.appendChild(this._ctx.getSvg());
                break;
            }
            this.overlays_el = this.el.appendChild(dom_1.div({ class: 'bk-canvas-overlays' }));
            this.events_el = this.el.appendChild(dom_1.div({ class: 'bk-canvas-events' }));
            this.ctx = this.get_ctx();
            // work around canvas incompatibilities
            canvas_1.fixup_ctx(this.ctx);
            logging_1.logger.debug('CanvasView initialized');
        };
        CanvasView.prototype.css_classes = function () {
            return _super.prototype.css_classes.call(this).concat('bk-canvas-wrapper');
        };
        // Method exists so that context can be stubbed in unit tests
        CanvasView.prototype.get_ctx = function () {
            return this._ctx;
        };
        CanvasView.prototype.get_canvas_element = function () {
            return this.canvas_el;
        };
        CanvasView.prototype.prepare_canvas = function () {
            // Ensure canvas has the correct size, taking HIDPI into account
            var width = this.model._width.value;
            var height = this.model._height.value;
            this.el.style.width = width + 'px';
            this.el.style.height = height + 'px';
            var pixel_ratio = canvas_1.get_scale_ratio(this.ctx, this.model.use_hidpi, this.model.output_backend);
            this.model.pixel_ratio = pixel_ratio;
            this.canvas_el.style.width = width + 'px';
            this.canvas_el.style.height = height + 'px';
            // XXX: io.export and canvas2svg don't like this
            // this.canvas_el.width = width*pixel_ratio
            // this.canvas_el.height = height*pixel_ratio
            this.canvas_el.setAttribute('width', '' + width * pixel_ratio);
            this.canvas_el.setAttribute('height', '' + height * pixel_ratio);
            logging_1.logger.debug('Rendering CanvasView with width: ' + width + ', height: ' + height + ', pixel ratio: ' + pixel_ratio);
        };
        CanvasView.prototype.set_dims = function (_a) {
            var width = _a[0], height = _a[1];
            // XXX: for whatever reason we need to protect against those nonsense values,
            //      that appear in the middle of updating layout. Otherwise we would get
            //      all possible errors from the layout solver.
            if (width == 0 || height == 0)
                return;
            if (width != this.model._width.value) {
                if (this._width_constraint != null && this.solver.has_constraint(this._width_constraint))
                    this.solver.remove_constraint(this._width_constraint);
                this._width_constraint = solver_1.EQ(this.model._width, -width);
                this.solver.add_constraint(this._width_constraint);
            }
            if (height != this.model._height.value) {
                if (this._height_constraint != null && this.solver.has_constraint(this._height_constraint))
                    this.solver.remove_constraint(this._height_constraint);
                this._height_constraint = solver_1.EQ(this.model._height, -height);
                this.solver.add_constraint(this._height_constraint);
            }
            this.solver.update_variables();
        };
        return CanvasView;
    }(dom_view_1.DOMView);
    exports.CanvasView = CanvasView;
    var Canvas = function (_super) {
        tslib_1.__extends(Canvas, _super);
        function Canvas(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        Canvas.initClass = function () {
            this.prototype.type = 'Canvas';
            this.prototype.default_view = CanvasView;
            this.internal({
                map: [
                    p.Boolean,
                    false
                ],
                use_hidpi: [
                    p.Boolean,
                    true
                ],
                pixel_ratio: [
                    p.Number,
                    1
                ],
                output_backend: [
                    p.OutputBackend,
                    'canvas'
                ]
            });
        };
        Object.defineProperty(Canvas.prototype, 'panel', {
            get: function () {
                return this;
            },
            enumerable: true,
            configurable: true
        });
        return Canvas;
    }(layout_canvas_1.LayoutCanvas);
    exports.Canvas = Canvas;
    Canvas.initClass();    
},
/*models/canvas/cartesian_frame*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    var categorical_scale_1 = require(167    /* ../scales/categorical_scale */);
    var linear_scale_1 = require(169    /* ../scales/linear_scale */);
    var log_scale_1 = require(170    /* ../scales/log_scale */);
    var range1d_1 = require(161    /* ../ranges/range1d */);
    var data_range1d_1 = require(157    /* ../ranges/data_range1d */);
    var factor_range_1 = require(158    /* ../ranges/factor_range */);
    var layout_canvas_1 = require(11    /* core/layout/layout_canvas */);
    var p = require(15    /* core/properties */);
    var CartesianFrame = function (_super) {
        tslib_1.__extends(CartesianFrame, _super);
        function CartesianFrame(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        CartesianFrame.initClass = function () {
            this.prototype.type = 'CartesianFrame';
            this.internal({
                extra_x_ranges: [
                    p.Any,
                    {}
                ],
                extra_y_ranges: [
                    p.Any,
                    {}
                ],
                x_range: [p.Instance],
                y_range: [p.Instance],
                x_scale: [p.Instance],
                y_scale: [p.Instance]
            });
        };
        CartesianFrame.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            this._configure_scales();
        };
        CartesianFrame.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            this.connect(this.change, function () {
                return _this._configure_scales();
            });
        };
        Object.defineProperty(CartesianFrame.prototype, 'panel', {
            get: function () {
                return this;
            },
            enumerable: true,
            configurable: true
        });
        CartesianFrame.prototype.get_editables = function () {
            return _super.prototype.get_editables.call(this).concat([
                this._width,
                this._height
            ]);
        };
        CartesianFrame.prototype.map_to_screen = function (x, y, x_name, y_name) {
            if (x_name === void 0) {
                x_name = 'default';
            }
            if (y_name === void 0) {
                y_name = 'default';
            }
            var sx = this.xscales[x_name].v_compute(x);
            var sy = this.yscales[y_name].v_compute(y);
            return [
                sx,
                sy
            ];
        };
        CartesianFrame.prototype._get_ranges = function (range, extra_ranges) {
            var ranges = {};
            ranges['default'] = range;
            if (extra_ranges != null) {
                for (var name_1 in extra_ranges)
                    ranges[name_1] = extra_ranges[name_1];
            }
            return ranges;
        };
        CartesianFrame.prototype._get_scales = function (scale, ranges, frame_range) {
            var scales = {};
            for (var name_2 in ranges) {
                var range = ranges[name_2];
                if (range instanceof data_range1d_1.DataRange1d || range instanceof range1d_1.Range1d) {
                    if (!(scale instanceof log_scale_1.LogScale) && !(scale instanceof linear_scale_1.LinearScale))
                        throw new Error('Range ' + range.type + ' is incompatible is Scale ' + scale.type);
                    // XXX: special case because CategoricalScale is a subclass of LinearScale, should be removed in future
                    if (scale instanceof categorical_scale_1.CategoricalScale)
                        throw new Error('Range ' + range.type + ' is incompatible is Scale ' + scale.type);
                }
                if (range instanceof factor_range_1.FactorRange) {
                    if (!(scale instanceof categorical_scale_1.CategoricalScale))
                        throw new Error('Range ' + range.type + ' is incompatible is Scale ' + scale.type);
                }
                if (scale instanceof log_scale_1.LogScale && range instanceof data_range1d_1.DataRange1d)
                    range.scale_hint = 'log';
                var s = scale.clone();
                s.setv({
                    source_range: range,
                    target_range: frame_range
                });
                scales[name_2] = s;
            }
            return scales;
        };
        CartesianFrame.prototype._configure_frame_ranges = function () {
            // data to/from screen space transform (left-bottom <-> left-top origin)
            this._h_target = new range1d_1.Range1d({
                start: this._left.value,
                end: this._right.value
            });
            this._v_target = new range1d_1.Range1d({
                start: this._bottom.value,
                end: this._top.value
            });
        };
        CartesianFrame.prototype._configure_scales = function () {
            this._configure_frame_ranges();
            this._x_ranges = this._get_ranges(this.x_range, this.extra_x_ranges);
            this._y_ranges = this._get_ranges(this.y_range, this.extra_y_ranges);
            this._xscales = this._get_scales(this.x_scale, this._x_ranges, this._h_target);
            this._yscales = this._get_scales(this.y_scale, this._y_ranges, this._v_target);
        };
        CartesianFrame.prototype.update_scales = function () {
            this._configure_frame_ranges();
            for (var name_3 in this._xscales) {
                var scale = this._xscales[name_3];
                scale.target_range = this._h_target;
            }
            for (var name_4 in this._yscales) {
                var scale = this._yscales[name_4];
                scale.target_range = this._v_target;
            }
        };
        Object.defineProperty(CartesianFrame.prototype, 'x_ranges', {
            get: function () {
                return this._x_ranges;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(CartesianFrame.prototype, 'y_ranges', {
            get: function () {
                return this._y_ranges;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(CartesianFrame.prototype, 'xscales', {
            get: function () {
                return this._xscales;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(CartesianFrame.prototype, 'yscales', {
            get: function () {
                return this._yscales;
            },
            enumerable: true,
            configurable: true
        });
        return CartesianFrame;
    }(layout_canvas_1.LayoutCanvas);
    exports.CartesianFrame = CartesianFrame;
    CartesianFrame.initClass();    
},
/*models/canvas/index*/
function _(require, module, exports) {
    var canvas_1 = require(80    /* ./canvas */);
    exports.Canvas = canvas_1.Canvas;
    var cartesian_frame_1 = require(81    /* ./cartesian_frame */);
    exports.CartesianFrame = cartesian_frame_1.CartesianFrame;    
},
/*models/expressions/expression*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    /* XXX: partial */
    var model_1 = require(51    /* ../../model */);
    var Expression = function (_super) {
        tslib_1.__extends(Expression, _super);
        function Expression(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        Expression.initClass = function () {
            this.prototype.type = 'Expression';
        };
        Expression.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            this._connected = {};
            this._result = {};
        };
        Expression.prototype._v_compute = function (source) {
            if (this._connected[source.id] == null) {
                this.connect(source.change, function () {
                    return this._result[source.id] = null;
                });
                this._connected[source.id] = true;
            }
            if (this._result[source.id] != null) {
                return this._result[source.id];
            }
            this._result[source.id] = this.v_compute(source);
            return this._result[source.id];
        };
        return Expression;
    }(model_1.Model);
    exports.Expression = Expression;
    Expression.initClass();    
},
/*models/expressions/index*/
function _(require, module, exports) {
    var expression_1 = require(83    /* ./expression */);
    exports.Expression = expression_1.Expression;
    var stack_1 = require(85    /* ./stack */);
    exports.Stack = stack_1.Stack;    
},
/*models/expressions/stack*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    /* XXX: partial */
    var expression_1 = require(83    /* ./expression */);
    var p = require(15    /* core/properties */);
    var Stack = function (_super) {
        tslib_1.__extends(Stack, _super);
        function Stack(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        Stack.initClass = function () {
            this.prototype.type = 'Stack';
            this.define({
                fields: [
                    p.Array,
                    []
                ]
            });
        };
        Stack.prototype.v_compute = function (source) {
            var result = new Float64Array(source.get_length());
            for (var _i = 0, _a = this.fields; _i < _a.length; _i++) {
                var f = _a[_i];
                for (var i = 0; i < source.data[f].length; i++) {
                    var x = source.data[f][i];
                    result[i] += x;
                }
            }
            return result;
        };
        return Stack;
    }(expression_1.Expression);
    exports.Stack = Stack;
    Stack.initClass();    
},
/*models/filters/boolean_filter*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    /* XXX: partial */
    var filter_1 = require(88    /* ./filter */);
    var p = require(15    /* core/properties */);
    var logging_1 = require(14    /* core/logging */);
    var array_1 = require(22    /* core/util/array */);
    var types_1 = require(43    /* core/util/types */);
    var BooleanFilter = function (_super) {
        tslib_1.__extends(BooleanFilter, _super);
        function BooleanFilter(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        BooleanFilter.initClass = function () {
            this.prototype.type = 'BooleanFilter';
            this.define({
                booleans: [
                    p.Array,
                    null
                ]
            });
        };
        BooleanFilter.prototype.compute_indices = function (source) {
            var _this = this;
            if ((this.booleans != null ? this.booleans.length : undefined) > 0) {
                if (array_1.all(this.booleans, types_1.isBoolean)) {
                    if (this.booleans.length !== source.get_length()) {
                        logging_1.logger.warn('BooleanFilter ' + this.id + ': length of booleans doesn\'t match data source');
                    }
                    return array_1.range(0, this.booleans.length).filter(function (i) {
                        return _this.booleans[i] === true;
                    });
                } else {
                    logging_1.logger.warn('BooleanFilter ' + this.id + ': booleans should be array of booleans, defaulting to no filtering');
                    return null;
                }
            } else {
                if ((this.booleans != null ? this.booleans.length : undefined) === 0) {
                    logging_1.logger.warn('BooleanFilter ' + this.id + ': booleans is empty, defaulting to no filtering');
                } else {
                    logging_1.logger.warn('BooleanFilter ' + this.id + ': booleans was not set, defaulting to no filtering');
                }
                return null;
            }
        };
        return BooleanFilter;
    }(filter_1.Filter);
    exports.BooleanFilter = BooleanFilter;
    BooleanFilter.initClass();    
},
/*models/filters/customjs_filter*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    /* XXX: partial */
    var filter_1 = require(88    /* ./filter */);
    var p = require(15    /* core/properties */);
    var object_1 = require(31    /* core/util/object */);
    var CustomJSFilter = function (_super) {
        tslib_1.__extends(CustomJSFilter, _super);
        function CustomJSFilter(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        CustomJSFilter.initClass = function () {
            this.prototype.type = 'CustomJSFilter';
            this.define({
                args: [
                    p.Any,
                    {}
                ],
                code: [
                    p.String,
                    ''
                ]
            });
        };
        Object.defineProperty(CustomJSFilter.prototype, 'values', {
            get: function () {
                return this._make_values();
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(CustomJSFilter.prototype, 'func', {
            get: function () {
                return this._make_func();
            },
            enumerable: true,
            configurable: true
        });
        CustomJSFilter.prototype.compute_indices = function (source) {
            this.filter = this.func.apply(this, this.values.concat([
                source,
                require,
                {}
            ]));
            return _super.prototype.compute_indices.call(this, source);
        };
        CustomJSFilter.prototype._make_values = function () {
            return object_1.values(this.args);
        };
        CustomJSFilter.prototype._make_func = function () {
            // this relies on Object.keys(args) and values(args) returning keys and values
            // in the same order
            return new (Function.bind.apply(Function, [void 0].concat(Object.keys(this.args), [
                'source',
                'require',
                'exports',
                this.code
            ])))();
        };
        return CustomJSFilter;
    }(filter_1.Filter);
    exports.CustomJSFilter = CustomJSFilter;
    CustomJSFilter.initClass();    
},
/*models/filters/filter*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    /* XXX: partial */
    var model_1 = require(51    /* ../../model */);
    var p = require(15    /* core/properties */);
    var types_1 = require(43    /* core/util/types */);
    var array_1 = require(22    /* core/util/array */);
    var logging_1 = require(14    /* core/logging */);
    var Filter = function (_super) {
        tslib_1.__extends(Filter, _super);
        function Filter(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        Filter.initClass = function () {
            this.prototype.type = 'Filter';
            this.define({
                filter: [
                    p.Array,
                    null
                ]
            });
        };
        Filter.prototype.compute_indices = function (_source) {
            var _this = this;
            if ((this.filter != null ? this.filter.length : undefined) >= 0) {
                if (array_1.all(this.filter, types_1.isBoolean)) {
                    return array_1.range(0, this.filter.length).filter(function (i) {
                        return _this.filter[i] === true;
                    });
                } else if (array_1.all(this.filter, types_1.isInteger)) {
                    return this.filter;
                } else {
                    logging_1.logger.warn('Filter ' + this.id + ': filter should either be array of only booleans or only integers, defaulting to no filtering');
                    return null;
                }
            } else {
                logging_1.logger.warn('Filter ' + this.id + ': filter was not set to be an array, defaulting to no filtering');
                return null;
            }
        };
        return Filter;
    }(model_1.Model);
    exports.Filter = Filter;
    Filter.initClass();    
},
/*models/filters/group_filter*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    /* XXX: partial */
    var filter_1 = require(88    /* ./filter */);
    var p = require(15    /* core/properties */);
    var logging_1 = require(14    /* core/logging */);
    var array_1 = require(22    /* core/util/array */);
    var GroupFilter = function (_super) {
        tslib_1.__extends(GroupFilter, _super);
        function GroupFilter(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        GroupFilter.initClass = function () {
            this.prototype.type = 'GroupFilter';
            this.define({
                column_name: [p.String],
                group: [p.String]
            });
        };
        GroupFilter.prototype.compute_indices = function (source) {
            var _this = this;
            var column = source.get_column(this.column_name);
            if (column == null) {
                logging_1.logger.warn('group filter: groupby column not found in data source');
                return null;
            } else {
                this.indices = array_1.range(0, source.get_length()).filter(function (i) {
                    return column[i] === _this.group;
                });
                if (this.indices.length === 0) {
                    logging_1.logger.warn('group filter: group \'' + this.group + '\' did not match any values in column \'' + this.column_name + '\'');
                }
                return this.indices;
            }
        };
        return GroupFilter;
    }(filter_1.Filter);
    exports.GroupFilter = GroupFilter;
    GroupFilter.initClass();    
},
/*models/filters/index*/
function _(require, module, exports) {
    var boolean_filter_1 = require(86    /* ./boolean_filter */);
    exports.BooleanFilter = boolean_filter_1.BooleanFilter;
    var customjs_filter_1 = require(87    /* ./customjs_filter */);
    exports.CustomJSFilter = customjs_filter_1.CustomJSFilter;
    var filter_1 = require(88    /* ./filter */);
    exports.Filter = filter_1.Filter;
    var group_filter_1 = require(89    /* ./group_filter */);
    exports.GroupFilter = group_filter_1.GroupFilter;
    var index_filter_1 = require(91    /* ./index_filter */);
    exports.IndexFilter = index_filter_1.IndexFilter;    
},
/*models/filters/index_filter*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    /* XXX: partial */
    var filter_1 = require(88    /* ./filter */);
    var p = require(15    /* core/properties */);
    var logging_1 = require(14    /* core/logging */);
    var types_1 = require(43    /* core/util/types */);
    var array_1 = require(22    /* core/util/array */);
    var IndexFilter = function (_super) {
        tslib_1.__extends(IndexFilter, _super);
        function IndexFilter(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        IndexFilter.initClass = function () {
            this.prototype.type = 'IndexFilter';
            this.define({
                indices: [
                    p.Array,
                    null
                ]
            });
        };
        IndexFilter.prototype.compute_indices = function (_source) {
            if ((this.indices != null ? this.indices.length : undefined) >= 0) {
                if (array_1.all(this.indices, types_1.isInteger)) {
                    return this.indices;
                } else {
                    logging_1.logger.warn('IndexFilter ' + this.id + ': indices should be array of integers, defaulting to no filtering');
                    return null;
                }
            } else {
                logging_1.logger.warn('IndexFilter ' + this.id + ': indices was not set, defaulting to no filtering');
                return null;
            }
        };
        return IndexFilter;
    }(filter_1.Filter);
    exports.IndexFilter = IndexFilter;
    IndexFilter.initClass();    
},
/*models/formatters/basic_tick_formatter*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    /* XXX: partial */
    var tick_formatter_1 = require(101    /* ./tick_formatter */);
    var p = require(15    /* core/properties */);
    var types_1 = require(43    /* core/util/types */);
    var BasicTickFormatter = function (_super) {
        tslib_1.__extends(BasicTickFormatter, _super);
        function BasicTickFormatter(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        BasicTickFormatter.initClass = function () {
            this.prototype.type = 'BasicTickFormatter';
            this.define({
                precision: [
                    p.Any,
                    'auto'
                ],
                use_scientific: [
                    p.Bool,
                    true
                ],
                power_limit_high: [
                    p.Number,
                    5
                ],
                power_limit_low: [
                    p.Number,
                    -3
                ]
            });
        };
        Object.defineProperty(BasicTickFormatter.prototype, 'scientific_limit_low', {
            get: function () {
                return Math.pow(10, this.power_limit_low);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(BasicTickFormatter.prototype, 'scientific_limit_high', {
            get: function () {
                return Math.pow(10, this.power_limit_high);
            },
            enumerable: true,
            configurable: true
        });
        BasicTickFormatter.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            this.last_precision = 3;
        };
        BasicTickFormatter.prototype.doFormat = function (ticks, _axis) {
            var labels;
            if (ticks.length === 0) {
                return [];
            }
            var zero_eps = 0;
            if (ticks.length >= 2) {
                zero_eps = Math.abs(ticks[1] - ticks[0]) / 10000;
            }
            var need_sci = false;
            if (this.use_scientific) {
                for (var _i = 0, ticks_1 = ticks; _i < ticks_1.length; _i++) {
                    var tick = ticks_1[_i];
                    var tick_abs = Math.abs(tick);
                    if (tick_abs > zero_eps && (tick_abs >= this.scientific_limit_high || tick_abs <= this.scientific_limit_low)) {
                        need_sci = true;
                        break;
                    }
                }
            }
            var precision = this.precision;
            if (precision == null || types_1.isNumber(precision)) {
                labels = new Array(ticks.length);
                if (need_sci) {
                    for (var i = 0, end = ticks.length; i < end; i++) {
                        labels[i] = ticks[i].toExponential(precision || undefined);
                    }
                } else {
                    for (var i = 0, end = ticks.length; i < end; i++) {
                        labels[i] = ticks[i].toFixed(precision || undefined).replace(/(\.[0-9]*?)0+$/, '$1').replace(/\.$/, '');
                    }
                }
                return labels;
            } else if (precision === 'auto') {
                labels = new Array(ticks.length);
                for (var x = this.last_precision, asc = this.last_precision <= 15; asc ? x <= 15 : x >= 15; asc ? x++ : x--) {
                    var is_ok = true;
                    if (need_sci) {
                        for (var i = 0, end = ticks.length; i < end; i++) {
                            labels[i] = ticks[i].toExponential(x);
                            if (i > 0) {
                                if (labels[i] === labels[i - 1]) {
                                    is_ok = false;
                                    break;
                                }
                            }
                        }
                        if (is_ok) {
                            break;
                        }
                    } else {
                        for (var i = 0, end = ticks.length; i < end; i++) {
                            labels[i] = ticks[i].toFixed(x).replace(/(\.[0-9]*?)0+$/, '$1').replace(/\.$/, '');
                            if (i > 0) {
                                if (labels[i] === labels[i - 1]) {
                                    is_ok = false;
                                    break;
                                }
                            }
                        }
                        if (is_ok) {
                            break;
                        }
                    }
                    if (is_ok) {
                        this.last_precision = x;
                        return labels;
                    }
                }
            }
            return labels;
        };
        return BasicTickFormatter;
    }(tick_formatter_1.TickFormatter);
    exports.BasicTickFormatter = BasicTickFormatter;
    BasicTickFormatter.initClass();    
},
/*models/formatters/categorical_tick_formatter*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    /* XXX: partial */
    var tick_formatter_1 = require(101    /* ./tick_formatter */);
    var CategoricalTickFormatter = function (_super) {
        tslib_1.__extends(CategoricalTickFormatter, _super);
        function CategoricalTickFormatter(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        CategoricalTickFormatter.initClass = function () {
            this.prototype.type = 'CategoricalTickFormatter';
        };
        CategoricalTickFormatter.prototype.doFormat = function (ticks, _axis) {
            return ticks;
        };
        return CategoricalTickFormatter;
    }(tick_formatter_1.TickFormatter);
    exports.CategoricalTickFormatter = CategoricalTickFormatter;
    CategoricalTickFormatter.initClass();    
},
/*models/formatters/datetime_tick_formatter*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    /* XXX: partial */
    var sprintf_js_1 = require(367    /* sprintf-js */);
    var tz = require(368    /* timezone */);
    var tick_formatter_1 = require(101    /* ./tick_formatter */);
    var logging_1 = require(14    /* core/logging */);
    var p = require(15    /* core/properties */);
    var array_1 = require(22    /* core/util/array */);
    var types_1 = require(43    /* core/util/types */);
    var _us = function (t) {
        // From double-precision unix (millisecond) timestamp get
        // microsecond since last second. Precision seems to run
        // out around the hundreds of nanoseconds scale, so rounding
        // to the nearest microsecond should round to a nice
        // microsecond / millisecond tick.
        return Math.round(t / 1000 % 1 * 1000000);
    };
    var _array = function (t) {
        return tz(t, '%Y %m %d %H %M %S').split(/\s+/).map(function (e) {
            return parseInt(e, 10);
        });
    };
    var _strftime = function (t, format) {
        if (types_1.isFunction(format)) {
            return format(t);
        } else {
            // Python's datetime library augments the microsecond directive %f, which is not
            // supported by the javascript library timezone: http://bigeasy.github.io/timezone/.
            // Use a regular expression to replace %f directive with microseconds.
            // TODO: what should we do for negative microsecond strings?
            var microsecond_replacement_string = sprintf_js_1.sprintf('$1%06d', _us(t));
            format = format.replace(/((^|[^%])(%%)*)%f/, microsecond_replacement_string);
            if (format.indexOf('%') === -1) {
                // timezone seems to ignore any strings without any formatting directives,
                // and just return the time argument back instead of the string argument.
                // But we want the string argument, in case a user supplies a format string
                // which doesn't contain a formatting directive or is only using %f.
                return format;
            }
            return tz(t, format);
        }
    };
    var DatetimeTickFormatter = function (_super) {
        tslib_1.__extends(DatetimeTickFormatter, _super);
        function DatetimeTickFormatter(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        DatetimeTickFormatter.initClass = function () {
            this.prototype.type = 'DatetimeTickFormatter';
            this.define({
                microseconds: [
                    p.Array,
                    ['%fus']
                ],
                milliseconds: [
                    p.Array,
                    [
                        '%3Nms',
                        '%S.%3Ns'
                    ]
                ],
                seconds: [
                    p.Array,
                    ['%Ss']
                ],
                minsec: [
                    p.Array,
                    [':%M:%S']
                ],
                minutes: [
                    p.Array,
                    [
                        ':%M',
                        '%Mm'
                    ]
                ],
                hourmin: [
                    p.Array,
                    ['%H:%M']
                ],
                hours: [
                    p.Array,
                    [
                        '%Hh',
                        '%H:%M'
                    ]
                ],
                days: [
                    p.Array,
                    [
                        '%m/%d',
                        '%a%d'
                    ]
                ],
                months: [
                    p.Array,
                    [
                        '%m/%Y',
                        '%b%y'
                    ]
                ],
                years: [
                    p.Array,
                    ['%Y']
                ]
            });
            // Labels of time units, from finest to coarsest.
            this.prototype.format_order = [
                'microseconds',
                'milliseconds',
                'seconds',
                'minsec',
                'minutes',
                'hourmin',
                'hours',
                'days',
                'months',
                'years'
            ];
            // Whether or not to strip the leading zeros on tick labels.
            this.prototype.strip_leading_zeros = true;
        };
        DatetimeTickFormatter.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            // TODO (bev) trigger update on format change
            this._update_width_formats();
        };
        DatetimeTickFormatter.prototype._update_width_formats = function () {
            var now = tz(new Date());
            var _widths = function (fmt_strings) {
                var sizes = fmt_strings.map(function (fmt_string) {
                    return _strftime(now, fmt_string).length;
                });
                var sorted = array_1.sortBy(array_1.zip(sizes, fmt_strings), function () {
                    var args = [];
                    for (var _i = 0; _i < arguments.length; _i++) {
                        args[_i] = arguments[_i];
                    }
                    var size = args[0][0];
                    return size;
                });
                return array_1.unzip(sorted);
            };
            return this._width_formats = {
                microseconds: _widths(this.microseconds),
                milliseconds: _widths(this.milliseconds),
                seconds: _widths(this.seconds),
                minsec: _widths(this.minsec),
                minutes: _widths(this.minutes),
                hourmin: _widths(this.hourmin),
                hours: _widths(this.hours),
                days: _widths(this.days),
                months: _widths(this.months),
                years: _widths(this.years)
            };
        };
        // FIXME There is some unfortunate flicker when panning/zooming near the
        // span boundaries.
        // FIXME Rounding is weird at the 20-us scale and below.
        DatetimeTickFormatter.prototype._get_resolution_str = function (resolution_secs, span_secs) {
            // Our resolution boundaries should not be round numbers, because we want
            // them to fall between the possible tick intervals (which *are* round
            // numbers, as we've worked hard to ensure).  Consequently, we adjust the
            // resolution upwards a small amount (less than any possible step in
            // scales) to make the effective boundaries slightly lower.
            var adjusted_secs = resolution_secs * 1.1;
            switch (false) {
            case !(adjusted_secs < 0.001):
                return 'microseconds';
            case !(adjusted_secs < 1):
                return 'milliseconds';
            case !(adjusted_secs < 60):
                if (span_secs >= 60) {
                    return 'minsec';
                } else {
                    return 'seconds';
                }
            case !(adjusted_secs < 3600):
                if (span_secs >= 3600) {
                    return 'hourmin';
                } else {
                    return 'minutes';
                }
            case !(adjusted_secs < 24 * 3600):
                return 'hours';
            case !(adjusted_secs < 31 * 24 * 3600):
                return 'days';
            case !(adjusted_secs < 365 * 24 * 3600):
                return 'months';
            default:
                return 'years';
            }
        };
        // TODO (bev) remove these unused "default" params and associated logic
        DatetimeTickFormatter.prototype.doFormat = function (ticks, _axis, _num_labels, char_width, fill_ratio, ticker) {
            if (_num_labels === void 0) {
                _num_labels = null;
            }
            if (char_width === void 0) {
                char_width = null;
            }
            if (fill_ratio === void 0) {
                fill_ratio = 0.3;
            }
            if (ticker === void 0) {
                ticker = null;
            }
            // In order to pick the right set of labels, we need to determine
            // the resolution of the ticks.  We can do this using a ticker if
            // it's provided, or by computing the resolution from the actual
            // ticks we've been given.
            var r;
            if (ticks.length === 0) {
                return [];
            }
            var span = Math.abs(ticks[ticks.length - 1] - ticks[0]) / 1000;
            if (ticker) {
                r = ticker.resolution;
            } else {
                r = span / (ticks.length - 1);
            }
            var resol = this._get_resolution_str(r, span);
            var _a = this._width_formats[resol], widths = _a[0], formats = _a[1];
            var format = formats[0];
            // FIXME I'm pretty sure this code won't work; luckily it doesn't seem to
            // be used.
            if (char_width) {
                // If a width is provided, then we pick the most appropriate scale,
                // otherwise just use the widest format
                var good_formats = [];
                for (var i = 0, end = widths.length; i < end; i++) {
                    if (widths[i] * ticks.length < fill_ratio * char_width) {
                        good_formats.push(this._width_formats[i]);
                    }
                }
                if (good_formats.length > 0) {
                    format = good_formats[good_formats.length - 1];
                }
            }
            // Apply the format to the tick values
            var labels = [];
            var resol_ndx = this.format_order.indexOf(resol);
            // This dictionary maps the name of a time resolution (in @format_order)
            // to its index in a time.localtime() timetuple.  The default is to map
            // everything to index 0, which is year.  This is not ideal; it might cause
            // a problem with the tick at midnight, january 1st, 0 a.d. being incorrectly
            // promoted at certain tick resolutions.
            var time_tuple_ndx_for_resol = {};
            for (var _i = 0, _b = this.format_order; _i < _b.length; _i++) {
                var fmt = _b[_i];
                time_tuple_ndx_for_resol[fmt] = 0;
            }
            time_tuple_ndx_for_resol['seconds'] = 5;
            time_tuple_ndx_for_resol['minsec'] = 4;
            time_tuple_ndx_for_resol['minutes'] = 4;
            time_tuple_ndx_for_resol['hourmin'] = 3;
            time_tuple_ndx_for_resol['hours'] = 3;
            // As we format each tick, check to see if we are at a boundary of the
            // next higher unit of time.  If so, replace the current format with one
            // from that resolution.  This is not the best heuristic in the world,
            // but it works!  There is some trickiness here due to having to deal
            // with hybrid formats in a reasonable manner.
            for (var _c = 0, ticks_1 = ticks; _c < ticks_1.length; _c++) {
                var t = ticks_1[_c];
                var s = void 0, tm = void 0;
                try {
                    tm = _array(t);
                    s = _strftime(t, format);
                } catch (error) {
                    logging_1.logger.warn('unable to format tick for timestamp value ' + t);
                    logging_1.logger.warn(' - ' + error);
                    labels.push('ERR');
                    continue;
                }
                var hybrid_handled = false;
                var next_ndx = resol_ndx;
                // The way to check that we are at the boundary of the next unit of
                // time is by checking that we have 0 units of the resolution, i.e.
                // we are at zero minutes, so display hours, or we are at zero seconds,
                // so display minutes (and if that is zero as well, then display hours).
                while (tm[time_tuple_ndx_for_resol[this.format_order[next_ndx]]] === 0) {
                    var next_format = void 0;
                    next_ndx += 1;
                    if (next_ndx === this.format_order.length) {
                        break;
                    }
                    if ((resol == 'minsec' || resol == 'hourmin') && !hybrid_handled) {
                        if (resol === 'minsec' && tm[4] === 0 && tm[5] !== 0 || resol === 'hourmin' && tm[3] === 0 && tm[4] !== 0) {
                            next_format = this._width_formats[this.format_order[resol_ndx - 1]][1][0];
                            s = _strftime(t, next_format);
                            break;
                        } else {
                            hybrid_handled = true;
                        }
                    }
                    next_format = this._width_formats[this.format_order[next_ndx]][1][0];
                    s = _strftime(t, next_format);
                }
                // TODO: should expose this in api. %H, %d, etc use leading zeros and
                // users might prefer to see them lined up correctly.
                if (this.strip_leading_zeros) {
                    var ss = s.replace(/^0+/g, '');
                    if (ss !== s && isNaN(parseInt(ss))) {
                        // If the string can now be parsed as starting with an integer, then
                        // leave all zeros stripped, otherwise start with a zero. Hence:
                        // A label such as '000ms' should leave one zero.
                        // A label such as '001ms' or '0-1ms' should not leave a leading zero.
                        ss = '0' + ss;
                    }
                    labels.push(ss);
                } else {
                    labels.push(s);
                }
            }
            return labels;
        };
        return DatetimeTickFormatter;
    }(tick_formatter_1.TickFormatter);
    exports.DatetimeTickFormatter = DatetimeTickFormatter;
    DatetimeTickFormatter.initClass();    
},
/*models/formatters/func_tick_formatter*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    /* XXX: partial */
    var tick_formatter_1 = require(101    /* ./tick_formatter */);
    var p = require(15    /* core/properties */);
    var object_1 = require(31    /* core/util/object */);
    var FuncTickFormatter = function (_super) {
        tslib_1.__extends(FuncTickFormatter, _super);
        function FuncTickFormatter(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        FuncTickFormatter.initClass = function () {
            this.prototype.type = 'FuncTickFormatter';
            this.define({
                args: [
                    p.Any,
                    {}
                ],
                code: [
                    p.String,
                    ''
                ]
            });
        };
        FuncTickFormatter.prototype._make_func = function () {
            return new (Function.bind.apply(Function, [
                void 0,
                'tick'
            ].concat(Object.keys(this.args), [
                'require',
                this.code
            ])))();
        };
        FuncTickFormatter.prototype.doFormat = function (ticks, _axis) {
            var _this = this;
            var func = this._make_func();
            return ticks.map(function (tick) {
                return func.apply(void 0, [tick].concat(object_1.values(_this.args), [require]));
            });
        };
        return FuncTickFormatter;
    }(tick_formatter_1.TickFormatter);
    exports.FuncTickFormatter = FuncTickFormatter;
    FuncTickFormatter.initClass();    
},
/*models/formatters/index*/
function _(require, module, exports) {
    var basic_tick_formatter_1 = require(92    /* ./basic_tick_formatter */);
    exports.BasicTickFormatter = basic_tick_formatter_1.BasicTickFormatter;
    var categorical_tick_formatter_1 = require(93    /* ./categorical_tick_formatter */);
    exports.CategoricalTickFormatter = categorical_tick_formatter_1.CategoricalTickFormatter;
    var datetime_tick_formatter_1 = require(94    /* ./datetime_tick_formatter */);
    exports.DatetimeTickFormatter = datetime_tick_formatter_1.DatetimeTickFormatter;
    var func_tick_formatter_1 = require(95    /* ./func_tick_formatter */);
    exports.FuncTickFormatter = func_tick_formatter_1.FuncTickFormatter;
    var log_tick_formatter_1 = require(97    /* ./log_tick_formatter */);
    exports.LogTickFormatter = log_tick_formatter_1.LogTickFormatter;
    var mercator_tick_formatter_1 = require(98    /* ./mercator_tick_formatter */);
    exports.MercatorTickFormatter = mercator_tick_formatter_1.MercatorTickFormatter;
    var numeral_tick_formatter_1 = require(99    /* ./numeral_tick_formatter */);
    exports.NumeralTickFormatter = numeral_tick_formatter_1.NumeralTickFormatter;
    var printf_tick_formatter_1 = require(100    /* ./printf_tick_formatter */);
    exports.PrintfTickFormatter = printf_tick_formatter_1.PrintfTickFormatter;
    var tick_formatter_1 = require(101    /* ./tick_formatter */);
    exports.TickFormatter = tick_formatter_1.TickFormatter;    
},
/*models/formatters/log_tick_formatter*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    /* XXX: partial */
    var tick_formatter_1 = require(101    /* ./tick_formatter */);
    var basic_tick_formatter_1 = require(92    /* ./basic_tick_formatter */);
    var logging_1 = require(14    /* core/logging */);
    var p = require(15    /* core/properties */);
    var LogTickFormatter = function (_super) {
        tslib_1.__extends(LogTickFormatter, _super);
        function LogTickFormatter(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        LogTickFormatter.initClass = function () {
            this.prototype.type = 'LogTickFormatter';
            this.define({
                ticker: [
                    p.Instance,
                    null
                ]
            });
        };
        LogTickFormatter.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            this.basic_formatter = new basic_tick_formatter_1.BasicTickFormatter();
            if (this.ticker == null) {
                logging_1.logger.warn('LogTickFormatter not configured with a ticker, using default base of 10 (labels will be incorrect if ticker base is not 10)');
            }
        };
        LogTickFormatter.prototype.doFormat = function (ticks, _axis) {
            var base;
            if (ticks.length === 0) {
                return [];
            }
            if (this.ticker != null) {
                base = this.ticker.base;
            } else {
                base = 10;
            }
            var small_interval = false;
            var labels = new Array(ticks.length);
            for (var i = 0, end = ticks.length; i < end; i++) {
                labels[i] = base + '^' + Math.round(Math.log(ticks[i]) / Math.log(base));
                if (i > 0 && labels[i] === labels[i - 1]) {
                    small_interval = true;
                    break;
                }
            }
            if (small_interval) {
                labels = this.basic_formatter.doFormat(ticks);
            }
            return labels;
        };
        return LogTickFormatter;
    }(tick_formatter_1.TickFormatter);
    exports.LogTickFormatter = LogTickFormatter;
    LogTickFormatter.initClass();    
},
/*models/formatters/mercator_tick_formatter*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    /* XXX: partial */
    var basic_tick_formatter_1 = require(92    /* ./basic_tick_formatter */);
    var p = require(15    /* core/properties */);
    var proj4_1 = require(32    /* core/util/proj4 */);
    var MercatorTickFormatter = function (_super) {
        tslib_1.__extends(MercatorTickFormatter, _super);
        function MercatorTickFormatter(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        MercatorTickFormatter.initClass = function () {
            this.prototype.type = 'MercatorTickFormatter';
            this.define({ dimension: [p.LatLon] });
        };
        MercatorTickFormatter.prototype.doFormat = function (ticks, axis) {
            if (this.dimension == null) {
                throw new Error('MercatorTickFormatter.dimension not configured');
            }
            if (ticks.length === 0) {
                return [];
            }
            var proj_ticks = new Array(ticks.length);
            if (this.dimension === 'lon') {
                for (var i = 0, end = ticks.length; i < end; i++) {
                    var lon = proj4_1.proj4(proj4_1.mercator).inverse([
                        ticks[i],
                        axis.loc
                    ])[0];
                    proj_ticks[i] = lon;
                }
            } else {
                for (var i = 0, end = ticks.length; i < end; i++) {
                    var _a = proj4_1.proj4(proj4_1.mercator).inverse([
                            axis.loc,
                            ticks[i]
                        ]), lat = _a[1];
                    proj_ticks[i] = lat;
                }
            }
            return _super.prototype.doFormat.call(this, proj_ticks, axis);
        };
        return MercatorTickFormatter;
    }(basic_tick_formatter_1.BasicTickFormatter);
    exports.MercatorTickFormatter = MercatorTickFormatter;
    MercatorTickFormatter.initClass();    
},
/*models/formatters/numeral_tick_formatter*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    /* XXX: partial */
    var Numbro = require(337    /* numbro */);
    var tick_formatter_1 = require(101    /* ./tick_formatter */);
    var p = require(15    /* core/properties */);
    var NumeralTickFormatter = function (_super) {
        tslib_1.__extends(NumeralTickFormatter, _super);
        function NumeralTickFormatter(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        NumeralTickFormatter.initClass = function () {
            this.prototype.type = 'NumeralTickFormatter';
            this.define({
                // TODO (bev) all of these could be tightened up
                format: [
                    p.String,
                    '0,0'
                ],
                language: [
                    p.String,
                    'en'
                ],
                rounding: [
                    p.String,
                    'round'
                ]
            });
        };
        NumeralTickFormatter.prototype.doFormat = function (ticks, _axis) {
            var _this = this;
            var format = this.format;
            var language = this.language;
            var rounding = function () {
                switch (_this.rounding) {
                case 'round':
                case 'nearest':
                    return Math.round;
                case 'floor':
                case 'rounddown':
                    return Math.floor;
                case 'ceil':
                case 'roundup':
                    return Math.ceil;
                }
            }();
            var labels = ticks.map(function (tick) {
                return Numbro.format(tick, format, language, rounding);
            });
            return labels;
        };
        return NumeralTickFormatter;
    }(tick_formatter_1.TickFormatter);
    exports.NumeralTickFormatter = NumeralTickFormatter;
    NumeralTickFormatter.initClass();    
},
/*models/formatters/printf_tick_formatter*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    /* XXX: partial */
    var sprintf_js_1 = require(367    /* sprintf-js */);
    var tick_formatter_1 = require(101    /* ./tick_formatter */);
    var p = require(15    /* core/properties */);
    var PrintfTickFormatter = function (_super) {
        tslib_1.__extends(PrintfTickFormatter, _super);
        function PrintfTickFormatter(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        PrintfTickFormatter.initClass = function () {
            this.prototype.type = 'PrintfTickFormatter';
            this.define({
                format: [
                    p.String,
                    '%s'
                ]
            });
        };
        PrintfTickFormatter.prototype.doFormat = function (ticks, _axis) {
            var format = this.format;
            var labels = ticks.map(function (tick) {
                return sprintf_js_1.sprintf(format, tick);
            });
            return labels;
        };
        return PrintfTickFormatter;
    }(tick_formatter_1.TickFormatter);
    exports.PrintfTickFormatter = PrintfTickFormatter;
    PrintfTickFormatter.initClass();    
},
/*models/formatters/tick_formatter*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    /* XXX: partial */
    var model_1 = require(51    /* ../../model */);
    var TickFormatter = function (_super) {
        tslib_1.__extends(TickFormatter, _super);
        function TickFormatter(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        TickFormatter.initClass = function () {
            this.prototype.type = 'TickFormatter';
        };
        return TickFormatter;
    }(model_1.Model);
    exports.TickFormatter = TickFormatter;
    TickFormatter.initClass();    
},
/*models/glyphs/annular_wedge*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    /* XXX: partial */
    var xy_glyph_1 = require(129    /* ./xy_glyph */);
    var hittest = require(9    /* core/hittest */);
    var p = require(15    /* core/properties */);
    var math_1 = require(30    /* core/util/math */);
    var AnnularWedgeView = function (_super) {
        tslib_1.__extends(AnnularWedgeView, _super);
        function AnnularWedgeView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        AnnularWedgeView.prototype._map_data = function () {
            if (this.model.properties.inner_radius.units === 'data')
                this.sinner_radius = this.sdist(this.renderer.xscale, this._x, this._inner_radius);
            else
                this.sinner_radius = this._inner_radius;
            if (this.model.properties.outer_radius.units === 'data')
                this.souter_radius = this.sdist(this.renderer.xscale, this._x, this._outer_radius);
            else
                this.souter_radius = this._outer_radius;
            this._angle = new Float32Array(this._start_angle.length);
            for (var i = 0, end = this._start_angle.length; i < end; i++) {
                this._angle[i] = this._end_angle[i] - this._start_angle[i];
            }
        };
        AnnularWedgeView.prototype._render = function (ctx, indices, _a) {
            var sx = _a.sx, sy = _a.sy, _start_angle = _a._start_angle, _angle = _a._angle, sinner_radius = _a.sinner_radius, souter_radius = _a.souter_radius;
            var direction = this.model.properties.direction.value();
            for (var _i = 0, indices_1 = indices; _i < indices_1.length; _i++) {
                var i = indices_1[_i];
                if (isNaN(sx[i] + sy[i] + sinner_radius[i] + souter_radius[i] + _start_angle[i] + _angle[i])) {
                    continue;
                }
                ctx.translate(sx[i], sy[i]);
                ctx.rotate(_start_angle[i]);
                ctx.moveTo(souter_radius[i], 0);
                ctx.beginPath();
                ctx.arc(0, 0, souter_radius[i], 0, _angle[i], direction);
                ctx.rotate(_angle[i]);
                ctx.lineTo(sinner_radius[i], 0);
                ctx.arc(0, 0, sinner_radius[i], 0, -_angle[i], !direction);
                ctx.closePath();
                ctx.rotate(-_angle[i] - _start_angle[i]);
                ctx.translate(-sx[i], -sy[i]);
                if (this.visuals.fill.doit) {
                    this.visuals.fill.set_vectorize(ctx, i);
                    ctx.fill();
                }
                if (this.visuals.line.doit) {
                    this.visuals.line.set_vectorize(ctx, i);
                    ctx.stroke();
                }
            }
        };
        AnnularWedgeView.prototype._hit_point = function (geometry) {
            var sx = geometry.sx, sy = geometry.sy;
            var x = this.renderer.xscale.invert(sx);
            var y = this.renderer.yscale.invert(sy);
            // check radius first
            var x0, x1, y0, y1;
            if (this.model.properties.outer_radius.units === 'data') {
                x0 = x - this.max_outer_radius;
                x1 = x + this.max_outer_radius;
                y0 = y - this.max_outer_radius;
                y1 = y + this.max_outer_radius;
            } else {
                var sx0 = sx - this.max_outer_radius;
                var sx1 = sx + this.max_outer_radius;
                _a = this.renderer.xscale.r_invert(sx0, sx1), x0 = _a[0], x1 = _a[1];
                var sy0 = sy - this.max_outer_radius;
                var sy1 = sy + this.max_outer_radius;
                _b = this.renderer.yscale.r_invert(sy0, sy1), y0 = _b[0], y1 = _b[1];
            }
            var candidates = [];
            var bbox = hittest.validate_bbox_coords([
                x0,
                x1
            ], [
                y0,
                y1
            ]);
            for (var _i = 0, _c = this.index.indices(bbox); _i < _c.length; _i++) {
                var i = _c[_i];
                var or2 = Math.pow(this.souter_radius[i], 2);
                var ir2 = Math.pow(this.sinner_radius[i], 2);
                var _d = this.renderer.xscale.r_compute(x, this._x[i]), sx0 = _d[0], sx1 = _d[1];
                var _e = this.renderer.yscale.r_compute(y, this._y[i]), sy0 = _e[0], sy1 = _e[1];
                var dist = Math.pow(sx0 - sx1, 2) + Math.pow(sy0 - sy1, 2);
                if (dist <= or2 && dist >= ir2) {
                    candidates.push([
                        i,
                        dist
                    ]);
                }
            }
            var direction = this.model.properties.direction.value();
            var hits = [];
            for (var _f = 0, candidates_1 = candidates; _f < candidates_1.length; _f++) {
                var _g = candidates_1[_f], i = _g[0], dist = _g[1];
                // NOTE: minus the angle because JS uses non-mathy convention for angles
                var angle = Math.atan2(sy - this.sy[i], sx - this.sx[i]);
                if (math_1.angle_between(-angle, -this._start_angle[i], -this._end_angle[i], direction)) {
                    hits.push([
                        i,
                        dist
                    ]);
                }
            }
            return hittest.create_1d_hit_test_result(hits);
            var _a, _b;
        };
        AnnularWedgeView.prototype.draw_legend_for_index = function (ctx, x0, x1, y0, y1, index) {
            return this._generic_area_legend(ctx, x0, x1, y0, y1, index);
        };
        AnnularWedgeView.prototype._scxy = function (i) {
            var r = (this.sinner_radius[i] + this.souter_radius[i]) / 2;
            var a = (this._start_angle[i] + this._end_angle[i]) / 2;
            return {
                x: this.sx[i] + r * Math.cos(a),
                y: this.sy[i] + r * Math.sin(a)
            };
        };
        AnnularWedgeView.prototype.scx = function (i) {
            return this._scxy(i).x;
        };
        AnnularWedgeView.prototype.scy = function (i) {
            return this._scxy(i).y;
        };
        return AnnularWedgeView;
    }(xy_glyph_1.XYGlyphView);
    exports.AnnularWedgeView = AnnularWedgeView;
    var AnnularWedge = function (_super) {
        tslib_1.__extends(AnnularWedge, _super);
        function AnnularWedge(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        AnnularWedge.initClass = function () {
            this.prototype.type = 'AnnularWedge';
            this.prototype.default_view = AnnularWedgeView;
            this.mixins([
                'line',
                'fill'
            ]);
            this.define({
                direction: [
                    p.Direction,
                    'anticlock'
                ],
                inner_radius: [p.DistanceSpec],
                outer_radius: [p.DistanceSpec],
                start_angle: [p.AngleSpec],
                end_angle: [p.AngleSpec]
            });
        };
        return AnnularWedge;
    }(xy_glyph_1.XYGlyph);
    exports.AnnularWedge = AnnularWedge;
    AnnularWedge.initClass();    
},
/*models/glyphs/annulus*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    /* XXX: partial */
    var xy_glyph_1 = require(129    /* ./xy_glyph */);
    var hittest = require(9    /* core/hittest */);
    var p = require(15    /* core/properties */);
    var AnnulusView = function (_super) {
        tslib_1.__extends(AnnulusView, _super);
        function AnnulusView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        AnnulusView.prototype._map_data = function () {
            if (this.model.properties.inner_radius.units === 'data') {
                this.sinner_radius = this.sdist(this.renderer.xscale, this._x, this._inner_radius);
            } else {
                this.sinner_radius = this._inner_radius;
            }
            if (this.model.properties.outer_radius.units === 'data') {
                return this.souter_radius = this.sdist(this.renderer.xscale, this._x, this._outer_radius);
            } else {
                return this.souter_radius = this._outer_radius;
            }
        };
        AnnulusView.prototype._render = function (ctx, indices, _a) {
            var sx = _a.sx, sy = _a.sy, sinner_radius = _a.sinner_radius, souter_radius = _a.souter_radius;
            for (var _i = 0, indices_1 = indices; _i < indices_1.length; _i++) {
                var i = indices_1[_i];
                if (isNaN(sx[i] + sy[i] + sinner_radius[i] + souter_radius[i]))
                    continue;
                // Because this visual has a whole in it, it proved "challenging"
                // for some browsers to render if drawn in one go --- i.e. it did not
                // work on IE. If we render in two parts (upper and lower part),
                // it is unambiguous what part should be filled. The line is
                // better drawn in one go though, otherwise the part where the pieces
                // meet will not be fully closed due to aa.
                // Detect Microsoft browser. Might need change for newer versions.
                var isie = navigator.userAgent.indexOf('MSIE') >= 0 || navigator.userAgent.indexOf('Trident') > 0 || navigator.userAgent.indexOf('Edge') > 0;
                if (this.visuals.fill.doit) {
                    this.visuals.fill.set_vectorize(ctx, i);
                    ctx.beginPath();
                    if (isie) {
                        // Draw two halves of the donut. Works on IE, but causes an aa line on Safari.
                        for (var _b = 0, _c = [
                                    false,
                                    true
                                ]; _b < _c.length; _b++) {
                            var clockwise = _c[_b];
                            ctx.arc(sx[i], sy[i], sinner_radius[i], 0, Math.PI, clockwise);
                            ctx.arc(sx[i], sy[i], souter_radius[i], Math.PI, 0, !clockwise);
                        }
                    } else {
                        // Draw donut in one go. Does not work on iE.
                        ctx.arc(sx[i], sy[i], sinner_radius[i], 0, 2 * Math.PI, true);
                        ctx.arc(sx[i], sy[i], souter_radius[i], 2 * Math.PI, 0, false);
                    }
                    ctx.fill();
                }
                if (this.visuals.line.doit) {
                    this.visuals.line.set_vectorize(ctx, i);
                    ctx.beginPath();
                    ctx.arc(sx[i], sy[i], sinner_radius[i], 0, 2 * Math.PI);
                    ctx.moveTo(sx[i] + souter_radius[i], sy[i]);
                    ctx.arc(sx[i], sy[i], souter_radius[i], 0, 2 * Math.PI);
                    ctx.stroke();
                }
            }
        };
        AnnulusView.prototype._hit_point = function (geometry) {
            var sx = geometry.sx, sy = geometry.sy;
            var x = this.renderer.xscale.invert(sx);
            var x0 = x - this.max_radius;
            var x1 = x + this.max_radius;
            var y = this.renderer.yscale.invert(sy);
            var y0 = y - this.max_radius;
            var y1 = y + this.max_radius;
            var hits = [];
            var bbox = hittest.validate_bbox_coords([
                x0,
                x1
            ], [
                y0,
                y1
            ]);
            for (var _i = 0, _a = this.index.indices(bbox); _i < _a.length; _i++) {
                var i = _a[_i];
                var or2 = Math.pow(this.souter_radius[i], 2);
                var ir2 = Math.pow(this.sinner_radius[i], 2);
                var _b = this.renderer.xscale.r_compute(x, this._x[i]), sx0 = _b[0], sx1 = _b[1];
                var _c = this.renderer.yscale.r_compute(y, this._y[i]), sy0 = _c[0], sy1 = _c[1];
                var dist = Math.pow(sx0 - sx1, 2) + Math.pow(sy0 - sy1, 2);
                if (dist <= or2 && dist >= ir2) {
                    hits.push([
                        i,
                        dist
                    ]);
                }
            }
            return hittest.create_1d_hit_test_result(hits);
        };
        AnnulusView.prototype.draw_legend_for_index = function (ctx, x0, x1, y0, y1, index) {
            var indices = [index];
            var sx = {};
            sx[index] = (x0 + x1) / 2;
            var sy = {};
            sy[index] = (y0 + y1) / 2;
            var r = Math.min(Math.abs(x1 - x0), Math.abs(y1 - y0)) * 0.5;
            var sinner_radius = {};
            sinner_radius[index] = r * 0.4;
            var souter_radius = {};
            souter_radius[index] = r * 0.8;
            var data = {
                sx: sx,
                sy: sy,
                sinner_radius: sinner_radius,
                souter_radius: souter_radius
            };
            return this._render(ctx, indices, data);
        };
        return AnnulusView;
    }(xy_glyph_1.XYGlyphView);
    exports.AnnulusView = AnnulusView;
    var Annulus = function (_super) {
        tslib_1.__extends(Annulus, _super);
        function Annulus(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        Annulus.initClass = function () {
            this.prototype.type = 'Annulus';
            this.prototype.default_view = AnnulusView;
            this.mixins([
                'line',
                'fill'
            ]);
            this.define({
                inner_radius: [p.DistanceSpec],
                outer_radius: [p.DistanceSpec]
            });
        };
        return Annulus;
    }(xy_glyph_1.XYGlyph);
    exports.Annulus = Annulus;
    Annulus.initClass();    
},
/*models/glyphs/arc*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    /* XXX: partial */
    var xy_glyph_1 = require(129    /* ./xy_glyph */);
    var p = require(15    /* core/properties */);
    var ArcView = function (_super) {
        tslib_1.__extends(ArcView, _super);
        function ArcView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        ArcView.prototype._map_data = function () {
            if (this.model.properties.radius.units === 'data') {
                return this.sradius = this.sdist(this.renderer.xscale, this._x, this._radius);
            } else {
                return this.sradius = this._radius;
            }
        };
        ArcView.prototype._render = function (ctx, indices, _a) {
            var sx = _a.sx, sy = _a.sy, sradius = _a.sradius, _start_angle = _a._start_angle, _end_angle = _a._end_angle;
            if (this.visuals.line.doit) {
                var direction = this.model.properties.direction.value();
                for (var _i = 0, indices_1 = indices; _i < indices_1.length; _i++) {
                    var i = indices_1[_i];
                    if (isNaN(sx[i] + sy[i] + sradius[i] + _start_angle[i] + _end_angle[i])) {
                        continue;
                    }
                    ctx.beginPath();
                    ctx.arc(sx[i], sy[i], sradius[i], _start_angle[i], _end_angle[i], direction);
                    this.visuals.line.set_vectorize(ctx, i);
                    ctx.stroke();
                }
            }
        };
        ArcView.prototype.draw_legend_for_index = function (ctx, x0, x1, y0, y1, index) {
            return this._generic_line_legend(ctx, x0, x1, y0, y1, index);
        };
        return ArcView;
    }(xy_glyph_1.XYGlyphView);
    exports.ArcView = ArcView;
    var Arc = function (_super) {
        tslib_1.__extends(Arc, _super);
        function Arc(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        Arc.initClass = function () {
            this.prototype.type = 'Arc';
            this.prototype.default_view = ArcView;
            this.mixins(['line']);
            this.define({
                direction: [
                    p.Direction,
                    'anticlock'
                ],
                radius: [p.DistanceSpec],
                start_angle: [p.AngleSpec],
                end_angle: [p.AngleSpec]
            });
        };
        return Arc;
    }(xy_glyph_1.XYGlyph);
    exports.Arc = Arc;
    Arc.initClass();    
},
/*models/glyphs/bezier*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    var spatial_1 = require(37    /* core/util/spatial */);
    var glyph_1 = require(109    /* ./glyph */);
    // algorithm adapted from http://stackoverflow.com/a/14429749/3406693
    var _cbb = function (x0, y0, x1, y1, x2, y2, x3, y3) {
        var t;
        var tvalues = [];
        var bounds = [
            [],
            []
        ];
        for (var i = 0; i <= 2; i++) {
            var a = void 0, b = void 0, c = void 0;
            if (i === 0) {
                b = 6 * x0 - 12 * x1 + 6 * x2;
                a = -3 * x0 + 9 * x1 - 9 * x2 + 3 * x3;
                c = 3 * x1 - 3 * x0;
            } else {
                b = 6 * y0 - 12 * y1 + 6 * y2;
                a = -3 * y0 + 9 * y1 - 9 * y2 + 3 * y3;
                c = 3 * y1 - 3 * y0;
            }
            if (Math.abs(a) < 1e-12) {
                if (Math.abs(b) < 1e-12) {
                    continue;
                }
                t = -c / b;
                if (0 < t && t < 1) {
                    tvalues.push(t);
                }
                continue;
            }
            var b2ac = b * b - 4 * c * a;
            var sqrtb2ac = Math.sqrt(b2ac);
            if (b2ac < 0) {
                continue;
            }
            var t1 = (-b + sqrtb2ac) / (2 * a);
            if (0 < t1 && t1 < 1) {
                tvalues.push(t1);
            }
            var t2 = (-b - sqrtb2ac) / (2 * a);
            if (0 < t2 && t2 < 1) {
                tvalues.push(t2);
            }
        }
        var j = tvalues.length;
        var jlen = j;
        while (j--) {
            t = tvalues[j];
            var mt = 1 - t;
            var x = mt * mt * mt * x0 + 3 * mt * mt * t * x1 + 3 * mt * t * t * x2 + t * t * t * x3;
            bounds[0][j] = x;
            var y = mt * mt * mt * y0 + 3 * mt * mt * t * y1 + 3 * mt * t * t * y2 + t * t * t * y3;
            bounds[1][j] = y;
        }
        bounds[0][jlen] = x0;
        bounds[1][jlen] = y0;
        bounds[0][jlen + 1] = x3;
        bounds[1][jlen + 1] = y3;
        return [
            Math.min.apply(null, bounds[0]),
            Math.max.apply(null, bounds[1]),
            Math.max.apply(null, bounds[0]),
            Math.min.apply(null, bounds[1])
        ];
    };
    var BezierView = function (_super) {
        tslib_1.__extends(BezierView, _super);
        function BezierView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        BezierView.prototype._index_data = function () {
            var points = [];
            for (var i = 0, end = this._x0.length; i < end; i++) {
                if (isNaN(this._x0[i] + this._x1[i] + this._y0[i] + this._y1[i] + this._cx0[i] + this._cy0[i] + this._cx1[i] + this._cy1[i])) {
                    continue;
                }
                var _a = _cbb(this._x0[i], this._y0[i], this._x1[i], this._y1[i], this._cx0[i], this._cy0[i], this._cx1[i], this._cy1[i]), x0 = _a[0], y0 = _a[1], x1 = _a[2], y1 = _a[3];
                points.push({
                    minX: x0,
                    minY: y0,
                    maxX: x1,
                    maxY: y1,
                    i: i
                });
            }
            return new spatial_1.RBush(points);
        };
        BezierView.prototype._render = function (ctx, indices, _a) {
            var sx0 = _a.sx0, sy0 = _a.sy0, sx1 = _a.sx1, sy1 = _a.sy1, scx0 = _a.scx0, scy0 = _a.scy0, scx1 = _a.scx1, scy1 = _a.scy1;
            if (this.visuals.line.doit) {
                for (var _i = 0, indices_1 = indices; _i < indices_1.length; _i++) {
                    var i = indices_1[_i];
                    if (isNaN(sx0[i] + sy0[i] + sx1[i] + sy1[i] + scx0[i] + scy0[i] + scx1[i] + scy1[i])) {
                        continue;
                    }
                    ctx.beginPath();
                    ctx.moveTo(sx0[i], sy0[i]);
                    ctx.bezierCurveTo(scx0[i], scy0[i], scx1[i], scy1[i], sx1[i], sy1[i]);
                    this.visuals.line.set_vectorize(ctx, i);
                    ctx.stroke();
                }
            }
        };
        BezierView.prototype.draw_legend_for_index = function (ctx, x0, x1, y0, y1, index) {
            return this._generic_line_legend(ctx, x0, x1, y0, y1, index);
        };
        return BezierView;
    }(glyph_1.GlyphView);
    exports.BezierView = BezierView;
    var Bezier = function (_super) {
        tslib_1.__extends(Bezier, _super);
        function Bezier(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        Bezier.initClass = function () {
            this.prototype.type = 'Bezier';
            this.prototype.default_view = BezierView;
            this.coords([
                [
                    'x0',
                    'y0'
                ],
                [
                    'x1',
                    'y1'
                ],
                [
                    'cx0',
                    'cy0'
                ],
                [
                    'cx1',
                    'cy1'
                ]
            ]);
            this.mixins(['line']);
        };
        return Bezier;
    }(glyph_1.Glyph);
    exports.Bezier = Bezier;
    Bezier.initClass();    
},
/*models/glyphs/box*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    var spatial_1 = require(37    /* core/util/spatial */);
    var glyph_1 = require(109    /* ./glyph */);
    var hittest = require(9    /* core/hittest */);
    // Not a publicly exposed Glyph, exists to factor code for bars and quads
    var BoxView = function (_super) {
        tslib_1.__extends(BoxView, _super);
        function BoxView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        BoxView.prototype._index_box = function (len) {
            var points = [];
            for (var i = 0, end = len; i < end; i++) {
                var _a = this._lrtb(i), l = _a[0], r = _a[1], t = _a[2], b = _a[3];
                if (isNaN(l + r + t + b) || !isFinite(l + r + t + b)) {
                    continue;
                }
                points.push({
                    minX: l,
                    minY: b,
                    maxX: r,
                    maxY: t,
                    i: i
                });
            }
            return new spatial_1.RBush(points);
        };
        BoxView.prototype._render = function (ctx, indices, _a) {
            var sleft = _a.sleft, sright = _a.sright, stop = _a.stop, sbottom = _a.sbottom;
            for (var _i = 0, indices_1 = indices; _i < indices_1.length; _i++) {
                var i = indices_1[_i];
                if (isNaN(sleft[i] + stop[i] + sright[i] + sbottom[i])) {
                    continue;
                }
                if (this.visuals.fill.doit) {
                    this.visuals.fill.set_vectorize(ctx, i);
                    ctx.fillRect(sleft[i], stop[i], sright[i] - sleft[i], sbottom[i] - stop[i]);
                }
                if (this.visuals.line.doit) {
                    ctx.beginPath();
                    ctx.rect(sleft[i], stop[i], sright[i] - sleft[i], sbottom[i] - stop[i]);
                    this.visuals.line.set_vectorize(ctx, i);
                    ctx.stroke();
                }
            }
        };
        BoxView.prototype._hit_rect = function (geometry) {
            return this._hit_rect_against_index(geometry);
        };
        BoxView.prototype._hit_point = function (geometry) {
            var sx = geometry.sx, sy = geometry.sy;
            var x = this.renderer.xscale.invert(sx);
            var y = this.renderer.yscale.invert(sy);
            var hits = this.index.indices({
                minX: x,
                minY: y,
                maxX: x,
                maxY: y
            });
            var result = hittest.create_hit_test_result();
            result['1d'].indices = hits;
            return result;
        };
        BoxView.prototype._hit_span = function (geometry) {
            var hits, maxX, minX;
            var sx = geometry.sx, sy = geometry.sy;
            if (geometry.direction === 'v') {
                var y = this.renderer.yscale.invert(sy);
                var hr = this.renderer.plot_view.frame.bbox.h_range;
                _a = this.renderer.xscale.r_invert(hr.start, hr.end), minX = _a[0], maxX = _a[1];
                hits = this.index.indices({
                    minX: minX,
                    minY: y,
                    maxX: maxX,
                    maxY: y
                });
            } else {
                var x = this.renderer.xscale.invert(sx);
                var vr = this.renderer.plot_view.frame.bbox.v_range;
                var _b = this.renderer.yscale.r_invert(vr.start, vr.end), minY = _b[0], maxY = _b[1];
                hits = this.index.indices({
                    minX: x,
                    minY: minY,
                    maxX: x,
                    maxY: maxY
                });
            }
            var result = hittest.create_hit_test_result();
            result['1d'].indices = hits;
            return result;
            var _a;
        };
        BoxView.prototype.draw_legend_for_index = function (ctx, x0, x1, y0, y1, index) {
            return this._generic_area_legend(ctx, x0, x1, y0, y1, index);
        };
        return BoxView;
    }(glyph_1.GlyphView);
    exports.BoxView = BoxView;
    var Box = function (_super) {
        tslib_1.__extends(Box, _super);
        function Box(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        Box.initClass = function () {
            this.prototype.type = 'Box';
            this.mixins([
                'line',
                'fill'
            ]);
        };
        return Box;
    }(glyph_1.Glyph);
    exports.Box = Box;
    Box.initClass();    
},
/*models/glyphs/circle*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    /* XXX: partial */
    var xy_glyph_1 = require(129    /* ./xy_glyph */);
    var hittest = require(9    /* core/hittest */);
    var p = require(15    /* core/properties */);
    var array_1 = require(22    /* core/util/array */);
    var CircleView = function (_super) {
        tslib_1.__extends(CircleView, _super);
        function CircleView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        CircleView.prototype._map_data = function () {
            // NOTE: Order is important here: size is always present (at least
            // a default), but radius is only present if a user specifies it
            if (this._radius != null) {
                if (this.model.properties.radius.spec.units === 'data') {
                    var rd = this.model.properties.radius_dimension.spec.value;
                    this.sradius = this.sdist(this.renderer[rd + 'scale'], this['_' + rd], this._radius);
                } else {
                    this.sradius = this._radius;
                    this.max_size = 2 * this.max_radius;
                }
            } else
                this.sradius = array_1.map(this._size, function (s) {
                    return s / 2;
                });
        };
        CircleView.prototype._mask_data = function (_all_indices) {
            var sx0, sx1, sy0, sy1, x0, x1, y0, y1;
            var _a = this.renderer.plot_view.frame.bbox.ranges, hr = _a[0], vr = _a[1];
            // check for radius first
            if (this._radius != null && this.model.properties.radius.units === 'data') {
                sx0 = hr.start;
                sx1 = hr.end;
                _b = this.renderer.xscale.r_invert(sx0, sx1), x0 = _b[0], x1 = _b[1];
                x0 -= this.max_radius;
                x1 += this.max_radius;
                sy0 = vr.start;
                sy1 = vr.end;
                _c = this.renderer.yscale.r_invert(sy0, sy1), y0 = _c[0], y1 = _c[1];
                y0 -= this.max_radius;
                y1 += this.max_radius;
            } else {
                sx0 = hr.start - this.max_size;
                sx1 = hr.end + this.max_size;
                _d = this.renderer.xscale.r_invert(sx0, sx1), x0 = _d[0], x1 = _d[1];
                sy0 = vr.start - this.max_size;
                sy1 = vr.end + this.max_size;
                _e = this.renderer.yscale.r_invert(sy0, sy1), y0 = _e[0], y1 = _e[1];
            }
            var bbox = hittest.validate_bbox_coords([
                x0,
                x1
            ], [
                y0,
                y1
            ]);
            return this.index.indices(bbox);
            var _b, _c, _d, _e;
        };
        CircleView.prototype._render = function (ctx, indices, _a) {
            var sx = _a.sx, sy = _a.sy, sradius = _a.sradius;
            for (var _i = 0, indices_1 = indices; _i < indices_1.length; _i++) {
                var i = indices_1[_i];
                if (isNaN(sx[i] + sy[i] + sradius[i])) {
                    continue;
                }
                ctx.beginPath();
                ctx.arc(sx[i], sy[i], sradius[i], 0, 2 * Math.PI, false);
                if (this.visuals.fill.doit) {
                    this.visuals.fill.set_vectorize(ctx, i);
                    ctx.fill();
                }
                if (this.visuals.line.doit) {
                    this.visuals.line.set_vectorize(ctx, i);
                    ctx.stroke();
                }
            }
        };
        CircleView.prototype._hit_point = function (geometry) {
            var dist, r2, sx0, sx1, sy0, sy1, x0, x1, y0, y1;
            var sx = geometry.sx, sy = geometry.sy;
            var x = this.renderer.xscale.invert(sx);
            var y = this.renderer.yscale.invert(sy);
            // check radius first
            if (this._radius != null && this.model.properties.radius.units === 'data') {
                x0 = x - this.max_radius;
                x1 = x + this.max_radius;
                y0 = y - this.max_radius;
                y1 = y + this.max_radius;
            } else {
                sx0 = sx - this.max_size;
                sx1 = sx + this.max_size;
                _a = this.renderer.xscale.r_invert(sx0, sx1), x0 = _a[0], x1 = _a[1];
                _b = [
                    Math.min(x0, x1),
                    Math.max(x0, x1)
                ], x0 = _b[0], x1 = _b[1];
                sy0 = sy - this.max_size;
                sy1 = sy + this.max_size;
                _c = this.renderer.yscale.r_invert(sy0, sy1), y0 = _c[0], y1 = _c[1];
                _d = [
                    Math.min(y0, y1),
                    Math.max(y0, y1)
                ], y0 = _d[0], y1 = _d[1];
            }
            var bbox = hittest.validate_bbox_coords([
                x0,
                x1
            ], [
                y0,
                y1
            ]);
            var candidates = this.index.indices(bbox);
            var hits = [];
            if (this._radius != null && this.model.properties.radius.units === 'data') {
                for (var _i = 0, candidates_1 = candidates; _i < candidates_1.length; _i++) {
                    var i = candidates_1[_i];
                    r2 = Math.pow(this.sradius[i], 2);
                    _e = this.renderer.xscale.r_compute(x, this._x[i]), sx0 = _e[0], sx1 = _e[1];
                    _f = this.renderer.yscale.r_compute(y, this._y[i]), sy0 = _f[0], sy1 = _f[1];
                    dist = Math.pow(sx0 - sx1, 2) + Math.pow(sy0 - sy1, 2);
                    if (dist <= r2) {
                        hits.push([
                            i,
                            dist
                        ]);
                    }
                }
            } else {
                for (var _g = 0, candidates_2 = candidates; _g < candidates_2.length; _g++) {
                    var i = candidates_2[_g];
                    r2 = Math.pow(this.sradius[i], 2);
                    dist = Math.pow(this.sx[i] - sx, 2) + Math.pow(this.sy[i] - sy, 2);
                    if (dist <= r2) {
                        hits.push([
                            i,
                            dist
                        ]);
                    }
                }
            }
            return hittest.create_1d_hit_test_result(hits);
            var _a, _b, _c, _d, _e, _f;
        };
        CircleView.prototype._hit_span = function (geometry) {
            var ms, x0, x1, y0, y1;
            var sx = geometry.sx, sy = geometry.sy;
            var _a = this.bounds(), minX = _a.minX, minY = _a.minY, maxX = _a.maxX, maxY = _a.maxY;
            var result = hittest.create_hit_test_result();
            if (geometry.direction === 'h') {
                // use circle bounds instead of current pointer y coordinates
                var sx0 = void 0, sx1 = void 0;
                y0 = minY;
                y1 = maxY;
                if (this._radius != null && this.model.properties.radius.units === 'data') {
                    sx0 = sx - this.max_radius;
                    sx1 = sx + this.max_radius;
                    _b = this.renderer.xscale.r_invert(sx0, sx1), x0 = _b[0], x1 = _b[1];
                } else {
                    ms = this.max_size / 2;
                    sx0 = sx - ms;
                    sx1 = sx + ms;
                    _c = this.renderer.xscale.r_invert(sx0, sx1), x0 = _c[0], x1 = _c[1];
                }
            } else {
                // use circle bounds instead of current pointer x coordinates
                var sy0 = void 0, sy1 = void 0;
                x0 = minX;
                x1 = maxX;
                if (this._radius != null && this.model.properties.radius.units === 'data') {
                    sy0 = sy - this.max_radius;
                    sy1 = sy + this.max_radius;
                    _d = this.renderer.yscale.r_invert(sy0, sy1), y0 = _d[0], y1 = _d[1];
                } else {
                    ms = this.max_size / 2;
                    sy0 = sy - ms;
                    sy1 = sy + ms;
                    _e = this.renderer.yscale.r_invert(sy0, sy1), y0 = _e[0], y1 = _e[1];
                }
            }
            var bbox = hittest.validate_bbox_coords([
                x0,
                x1
            ], [
                y0,
                y1
            ]);
            var hits = this.index.indices(bbox);
            result['1d'].indices = hits;
            return result;
            var _b, _c, _d, _e;
        };
        CircleView.prototype._hit_rect = function (geometry) {
            var sx0 = geometry.sx0, sx1 = geometry.sx1, sy0 = geometry.sy0, sy1 = geometry.sy1;
            var _a = this.renderer.xscale.r_invert(sx0, sx1), x0 = _a[0], x1 = _a[1];
            var _b = this.renderer.yscale.r_invert(sy0, sy1), y0 = _b[0], y1 = _b[1];
            var bbox = hittest.validate_bbox_coords([
                x0,
                x1
            ], [
                y0,
                y1
            ]);
            var result = hittest.create_hit_test_result();
            result['1d'].indices = this.index.indices(bbox);
            return result;
        };
        CircleView.prototype._hit_poly = function (geometry) {
            var sx = geometry.sx, sy = geometry.sy;
            // TODO (bev) use spatial index to pare candidate list
            var candidates = array_1.range(0, this.sx.length);
            var hits = [];
            for (var i = 0, end = candidates.length; i < end; i++) {
                var idx = candidates[i];
                if (hittest.point_in_poly(this.sx[i], this.sy[i], sx, sy)) {
                    hits.push(idx);
                }
            }
            var result = hittest.create_hit_test_result();
            result['1d'].indices = hits;
            return result;
        };
        // circle does not inherit from marker (since it also accepts radius) so we
        // must supply a draw_legend for it  here
        CircleView.prototype.draw_legend_for_index = function (ctx, x0, x1, y0, y1, index) {
            // using objects like this seems a little wonky, since the keys are coerced to
            // stings, but it works
            var indices = [index];
            var sx = {};
            sx[index] = (x0 + x1) / 2;
            var sy = {};
            sy[index] = (y0 + y1) / 2;
            var sradius = {};
            sradius[index] = Math.min(Math.abs(x1 - x0), Math.abs(y1 - y0)) * 0.2;
            var data = {
                sx: sx,
                sy: sy,
                sradius: sradius
            };
            return this._render(ctx, indices, data);
        };
        return CircleView;
    }(xy_glyph_1.XYGlyphView);
    exports.CircleView = CircleView;
    var Circle = function (_super) {
        tslib_1.__extends(Circle, _super);
        function Circle(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        Circle.initClass = function () {
            this.prototype.type = 'Circle';
            this.prototype.default_view = CircleView;
            this.mixins([
                'line',
                'fill'
            ]);
            this.define({
                angle: [
                    p.AngleSpec,
                    0
                ],
                size: [
                    p.DistanceSpec,
                    {
                        units: 'screen',
                        value: 4
                    }
                ],
                radius: [
                    p.DistanceSpec,
                    null
                ],
                radius_dimension: [
                    p.String,
                    'x'
                ]
            });
        };
        Circle.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            this.properties.radius.optional = true;
        };
        return Circle;
    }(xy_glyph_1.XYGlyph);
    exports.Circle = Circle;
    Circle.initClass();    
},
/*models/glyphs/ellipse*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    /* XXX: partial */
    var xy_glyph_1 = require(129    /* ./xy_glyph */);
    var p = require(15    /* core/properties */);
    var EllipseView = function (_super) {
        tslib_1.__extends(EllipseView, _super);
        function EllipseView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        EllipseView.prototype._set_data = function () {
            this.max_w2 = 0;
            if (this.model.properties.width.units === 'data') {
                this.max_w2 = this.max_width / 2;
            }
            this.max_h2 = 0;
            if (this.model.properties.height.units === 'data') {
                return this.max_h2 = this.max_height / 2;
            }
        };
        EllipseView.prototype._map_data = function () {
            if (this.model.properties.width.units === 'data') {
                this.sw = this.sdist(this.renderer.xscale, this._x, this._width, 'center');
            } else {
                this.sw = this._width;
            }
            if (this.model.properties.height.units === 'data') {
                return this.sh = this.sdist(this.renderer.yscale, this._y, this._height, 'center');
            } else {
                return this.sh = this._height;
            }
        };
        EllipseView.prototype._render = function (ctx, indices, _a) {
            var sx = _a.sx, sy = _a.sy, sw = _a.sw, sh = _a.sh;
            for (var _i = 0, indices_1 = indices; _i < indices_1.length; _i++) {
                var i = indices_1[_i];
                if (isNaN(sx[i] + sy[i] + sw[i] + sh[i] + this._angle[i])) {
                    continue;
                }
                ctx.beginPath();
                ctx.ellipse(sx[i], sy[i], sw[i] / 2, sh[i] / 2, this._angle[i], 0, 2 * Math.PI);
                if (this.visuals.fill.doit) {
                    this.visuals.fill.set_vectorize(ctx, i);
                    ctx.fill();
                }
                if (this.visuals.line.doit) {
                    this.visuals.line.set_vectorize(ctx, i);
                    ctx.stroke();
                }
            }
        };
        EllipseView.prototype.draw_legend_for_index = function (ctx, x0, x1, y0, y1, index) {
            var indices = [index];
            var sx = {};
            sx[index] = (x0 + x1) / 2;
            var sy = {};
            sy[index] = (y0 + y1) / 2;
            var scale = this.sw[index] / this.sh[index];
            var d = Math.min(Math.abs(x1 - x0), Math.abs(y1 - y0)) * 0.8;
            var sw = {};
            var sh = {};
            if (scale > 1) {
                sw[index] = d;
                sh[index] = d / scale;
            } else {
                sw[index] = d * scale;
                sh[index] = d;
            }
            var data = {
                sx: sx,
                sy: sy,
                sw: sw,
                sh: sh
            };
            return this._render(ctx, indices, data);
        };
        EllipseView.prototype._bounds = function (bds) {
            return this.max_wh2_bounds(bds);
        };
        return EllipseView;
    }(xy_glyph_1.XYGlyphView);
    exports.EllipseView = EllipseView;
    var Ellipse = function (_super) {
        tslib_1.__extends(Ellipse, _super);
        function Ellipse(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        Ellipse.initClass = function () {
            this.prototype.type = 'Ellipse';
            this.prototype.default_view = EllipseView;
            this.mixins([
                'line',
                'fill'
            ]);
            this.define({
                angle: [
                    p.AngleSpec,
                    0
                ],
                width: [p.DistanceSpec],
                height: [p.DistanceSpec]
            });
        };
        return Ellipse;
    }(xy_glyph_1.XYGlyph);
    exports.Ellipse = Ellipse;
    Ellipse.initClass();    
},
/*models/glyphs/glyph*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    /* XXX: partial */
    var hittest = require(9    /* core/hittest */);
    var p = require(15    /* core/properties */);
    var bbox = require(24    /* core/util/bbox */);
    var proj = require(33    /* core/util/projections */);
    var view_1 = require(46    /* core/view */);
    var model_1 = require(51    /* ../../model */);
    var visuals_1 = require(47    /* core/visuals */);
    var logging_1 = require(14    /* core/logging */);
    var object_1 = require(31    /* core/util/object */);
    var types_1 = require(43    /* core/util/types */);
    var line_1 = require(115    /* ./line */);
    var GlyphView = function (_super) {
        tslib_1.__extends(GlyphView, _super);
        function GlyphView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        GlyphView.prototype.initialize = function (options) {
            _super.prototype.initialize.call(this, options);
            this._nohit_warned = {};
            this.renderer = options.renderer;
            this.visuals = new visuals_1.Visuals(this.model);
            // Init gl (this should really be done anytime renderer is set,
            // and not done if it isn't ever set, but for now it only
            // matters in the unit tests because we build a view without a
            // renderer there)
            var ctx = this.renderer.plot_view.canvas_view.ctx;
            if (ctx.glcanvas != null) {
                var glglyphs = void 0;
                try {
                    glglyphs = require(430    /* ./webgl/index */);
                } catch (e) {
                    if (e.code === 'MODULE_NOT_FOUND') {
                        logging_1.logger.warn('WebGL was requested and is supported, but bokeh-gl(.min).js is not available, falling back to 2D rendering.');
                        glglyphs = null;
                    } else {
                        throw e;
                    }
                }
                if (glglyphs != null) {
                    var Cls = glglyphs[this.model.type + 'GLGlyph'];
                    if (Cls != null) {
                        this.glglyph = new Cls(ctx.glcanvas.gl, this);
                    }
                }
            }
        };
        GlyphView.prototype.set_visuals = function (source) {
            this.visuals.warm_cache(source);
            if (this.glglyph != null) {
                return this.glglyph.set_visuals_changed();
            }
        };
        GlyphView.prototype.render = function (ctx, indices, data) {
            ctx.beginPath();
            if (this.glglyph != null) {
                if (this.glglyph.render(ctx, indices, data)) {
                    return;
                }
            }
            return this._render(ctx, indices, data);
        };
        GlyphView.prototype.has_finished = function () {
            return true;
        };
        GlyphView.prototype.notify_finished = function () {
            return this.renderer.notify_finished();
        };
        GlyphView.prototype.bounds = function () {
            if (this.index == null) {
                return bbox.empty();
            } else {
                return this._bounds(this.index.bbox);
            }
        };
        GlyphView.prototype.log_bounds = function () {
            if (this.index == null) {
                return bbox.empty();
            }
            var bb = bbox.empty();
            var positive_x_bbs = this.index.search(bbox.positive_x());
            var positive_y_bbs = this.index.search(bbox.positive_y());
            for (var _i = 0, positive_x_bbs_1 = positive_x_bbs; _i < positive_x_bbs_1.length; _i++) {
                var x = positive_x_bbs_1[_i];
                if (x.minX < bb.minX) {
                    bb.minX = x.minX;
                }
                if (x.maxX > bb.maxX) {
                    bb.maxX = x.maxX;
                }
            }
            for (var _a = 0, positive_y_bbs_1 = positive_y_bbs; _a < positive_y_bbs_1.length; _a++) {
                var y = positive_y_bbs_1[_a];
                if (y.minY < bb.minY) {
                    bb.minY = y.minY;
                }
                if (y.maxY > bb.maxY) {
                    bb.maxY = y.maxY;
                }
            }
            return this._bounds(bb);
        };
        // this is available for subclasses to use, if appropriate.
        GlyphView.prototype.max_wh2_bounds = function (bds) {
            return {
                minX: bds.minX - this.max_w2,
                maxX: bds.maxX + this.max_w2,
                minY: bds.minY - this.max_h2,
                maxY: bds.maxY + this.max_h2
            };
        };
        GlyphView.prototype.get_anchor_point = function (anchor, i) {
            var rest = [];
            for (var _i = 2; _i < arguments.length; _i++) {
                rest[_i - 2] = arguments[_i];
            }
            var _a = rest[0], sx = _a[0], sy = _a[1];
            switch (anchor) {
            case 'center':
                return {
                    x: this.scx(i, sx, sy),
                    y: this.scy(i, sx, sy)
                };
            default:
                return null;
            }
        };
        // glyphs that need more sophisticated "snap to data" behaviour (like
        // snapping to a patch centroid, e.g, should override these
        GlyphView.prototype.scx = function (i, _sx, _sy) {
            return this.sx[i];
        };
        GlyphView.prototype.scy = function (i, _sx, _sy) {
            return this.sy[i];
        };
        GlyphView.prototype.sdist = function (scale, pts, spans, pts_location, dilate) {
            if (pts_location === void 0) {
                pts_location = 'edge';
            }
            if (dilate === void 0) {
                dilate = false;
            }
            var pt0, pt1;
            if (scale.source_range.v_synthetic != null) {
                pts = scale.source_range.v_synthetic(pts);
            }
            if (pts_location === 'center') {
                var halfspan_1 = spans.map(function (d) {
                    return d / 2;
                });
                pt0 = function () {
                    var result = [];
                    for (var i = 0, end = pts.length; i < end; i++) {
                        result.push(pts[i] - halfspan_1[i]);
                    }
                    return result;
                }();
                pt1 = function () {
                    var result = [];
                    for (var i = 0, end = pts.length; i < end; i++) {
                        result.push(pts[i] + halfspan_1[i]);
                    }
                    return result;
                }();
            } else {
                pt0 = pts;
                pt1 = function () {
                    var result = [];
                    for (var i = 0, end = pt0.length; i < end; i++) {
                        result.push(pt0[i] + spans[i]);
                    }
                    return result;
                }();
            }
            var spt0 = scale.v_compute(pt0);
            var spt1 = scale.v_compute(pt1);
            if (dilate) {
                return function () {
                    var result = [];
                    for (var i = 0, end = spt0.length; i < end; i++) {
                        result.push(Math.ceil(Math.abs(spt1[i] - spt0[i])));
                    }
                    return result;
                }();
            } else {
                return function () {
                    var result = [];
                    for (var i = 0, end = spt0.length; i < end; i++) {
                        result.push(Math.abs(spt1[i] - spt0[i]));
                    }
                    return result;
                }();
            }
        };
        GlyphView.prototype.draw_legend_for_index = function (_ctx, _x0, _x1, _y0, _y1, _index) {
            return null;
        };
        GlyphView.prototype._generic_line_legend = function (ctx, x0, x1, y0, y1, index) {
            ctx.save();
            ctx.beginPath();
            ctx.moveTo(x0, (y0 + y1) / 2);
            ctx.lineTo(x1, (y0 + y1) / 2);
            if (this.visuals.line.doit) {
                this.visuals.line.set_vectorize(ctx, index);
                ctx.stroke();
            }
            return ctx.restore();
        };
        GlyphView.prototype._generic_area_legend = function (ctx, x0, x1, y0, y1, index) {
            var w = Math.abs(x1 - x0);
            var dw = w * 0.1;
            var h = Math.abs(y1 - y0);
            var dh = h * 0.1;
            var sx0 = x0 + dw;
            var sx1 = x1 - dw;
            var sy0 = y0 + dh;
            var sy1 = y1 - dh;
            if (this.visuals.fill.doit) {
                this.visuals.fill.set_vectorize(ctx, index);
                ctx.fillRect(sx0, sy0, sx1 - sx0, sy1 - sy0);
            }
            if (this.visuals.line.doit) {
                ctx.beginPath();
                ctx.rect(sx0, sy0, sx1 - sx0, sy1 - sy0);
                this.visuals.line.set_vectorize(ctx, index);
                return ctx.stroke();
            }
        };
        GlyphView.prototype.hit_test = function (geometry) {
            var result = null;
            var func = '_hit_' + geometry.type;
            if (this[func] != null) {
                result = this[func](geometry);
            } else if (this._nohit_warned[geometry.type] == null) {
                logging_1.logger.debug('\'' + geometry.type + '\' selection not available for ' + this.model.type);
                this._nohit_warned[geometry.type] = true;
            }
            return result;
        };
        GlyphView.prototype._hit_rect_against_index = function (geometry) {
            var sx0 = geometry.sx0, sx1 = geometry.sx1, sy0 = geometry.sy0, sy1 = geometry.sy1;
            var _a = this.renderer.xscale.r_invert(sx0, sx1), x0 = _a[0], x1 = _a[1];
            var _b = this.renderer.yscale.r_invert(sy0, sy1), y0 = _b[0], y1 = _b[1];
            var bb = hittest.validate_bbox_coords([
                x0,
                x1
            ], [
                y0,
                y1
            ]);
            var result = hittest.create_hit_test_result();
            result['1d'].indices = this.index.indices(bb);
            return result;
        };
        GlyphView.prototype.set_data = function (source, indices, indices_to_update) {
            var data = this.model.materialize_dataspecs(source);
            this.visuals.set_all_indices(indices);
            if (indices && !(this instanceof line_1.LineView)) {
                var data_subset = {};
                var _loop_1 = function (k) {
                    var v = data[k];
                    if (k.charAt(0) === '_') {
                        data_subset[k] = indices.map(function (i) {
                            return v[i];
                        });
                    } else {
                        data_subset[k] = v;
                    }
                };
                for (var k in data) {
                    _loop_1(k);
                }
                data = data_subset;
            }
            object_1.extend(this, data);
            if (this.renderer.plot_view.model.use_map) {
                if (this._x != null) {
                    _a = proj.project_xy(this._x, this._y), this._x = _a[0], this._y = _a[1];
                }
                if (this._xs != null) {
                    _b = proj.project_xsys(this._xs, this._ys), this._xs = _b[0], this._ys = _b[1];
                }
            }
            // if we have any coordinates that are categorical, convert them to
            // synthetic coords here
            if (this.renderer.plot_view.frame.x_ranges != null) {
                var xr = this.renderer.plot_view.frame.x_ranges[this.model.x_range_name];
                var yr = this.renderer.plot_view.frame.y_ranges[this.model.y_range_name];
                for (var _i = 0, _c = this.model._coords; _i < _c.length; _i++) {
                    var _d = _c[_i], xname = _d[0], yname = _d[1];
                    xname = '_' + xname;
                    yname = '_' + yname;
                    if (xr.v_synthetic != null) {
                        this[xname] = xr.v_synthetic(this[xname]);
                    }
                    if (yr.v_synthetic != null) {
                        this[yname] = yr.v_synthetic(this[yname]);
                    }
                }
            }
            if (this.glglyph != null) {
                this.glglyph.set_data_changed(this._x.length);
            }
            this._set_data(source, indices_to_update);
            //TODO doesn't take subset indices into account
            return this.index = this._index_data();
            var _a, _b;
        };
        GlyphView.prototype._set_data = function (_source, _indices) {
        };
        GlyphView.prototype._index_data = function () {
        };
        GlyphView.prototype.mask_data = function (indices) {
            // WebGL can do the clipping much more efficiently
            if (this.glglyph != null) {
                return indices;
            } else {
                return this._mask_data(indices);
            }
        };
        GlyphView.prototype._mask_data = function (indices) {
            return indices;
        };
        GlyphView.prototype._bounds = function (bounds) {
            return bounds;
        };
        GlyphView.prototype.map_data = function () {
            // todo: if using gl, skip this (when is this called?)
            // map all the coordinate fields
            for (var _i = 0, _a = this.model._coords; _i < _a.length; _i++) {
                var _b = _a[_i], xname = _b[0], yname = _b[1];
                var sxname = 's' + xname;
                var syname = 's' + yname;
                xname = '_' + xname;
                yname = '_' + yname;
                if (types_1.isArray(this[xname] != null ? this[xname][0] : undefined) || __guard__(this[xname] != null ? this[xname][0] : undefined, function (x) {
                        return x.buffer;
                    }) instanceof ArrayBuffer) {
                    _c = [
                        [],
                        []
                    ], this[sxname] = _c[0], this[syname] = _c[1];
                    for (var i = 0, end = this[xname].length; i < end; i++) {
                        var _d = this.map_to_screen(this[xname][i], this[yname][i]), sx = _d[0], sy = _d[1];
                        this[sxname].push(sx);
                        this[syname].push(sy);
                    }
                } else {
                    _e = this.map_to_screen(this[xname], this[yname]), this[sxname] = _e[0], this[syname] = _e[1];
                }
            }
            return this._map_data();
            var _c, _e;
        };
        // This is where specs not included in coords are computed, e.g. radius.
        GlyphView.prototype._map_data = function () {
        };
        GlyphView.prototype.map_to_screen = function (x, y) {
            return this.renderer.plot_view.map_to_screen(x, y, this.model.x_range_name, this.model.y_range_name);
        };
        return GlyphView;
    }(view_1.View);
    exports.GlyphView = GlyphView;
    var Glyph = function (_super) {
        tslib_1.__extends(Glyph, _super);
        function Glyph(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        Glyph.initClass = function () {
            this.prototype.type = 'Glyph';
            this.prototype._coords = [];
            this.internal({
                x_range_name: [
                    p.String,
                    'default'
                ],
                y_range_name: [
                    p.String,
                    'default'
                ]
            });
        };
        Glyph.coords = function (coords) {
            var _coords = this.prototype._coords.concat(coords);
            this.prototype._coords = _coords;
            var result = {};
            for (var _i = 0, coords_1 = coords; _i < coords_1.length; _i++) {
                var _a = coords_1[_i], x = _a[0], y = _a[1];
                result[x] = [p.NumberSpec];
                result[y] = [p.NumberSpec];
            }
            return this.define(result);
        };
        return Glyph;
    }(model_1.Model);
    exports.Glyph = Glyph;
    Glyph.initClass();
    function __guard__(value, transform) {
        return typeof value !== 'undefined' && value !== null ? transform(value) : undefined;
    }    
},
/*models/glyphs/hbar*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    /* XXX: partial */
    var box_1 = require(106    /* ./box */);
    var p = require(15    /* core/properties */);
    var HBarView = function (_super) {
        tslib_1.__extends(HBarView, _super);
        function HBarView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        HBarView.prototype.scx = function (i) {
            return (this.sleft[i] + this.sright[i]) / 2;
        };
        HBarView.prototype._index_data = function () {
            return this._index_box(this._y.length);
        };
        HBarView.prototype._lrtb = function (i) {
            var l = Math.min(this._left[i], this._right[i]);
            var r = Math.max(this._left[i], this._right[i]);
            var t = this._y[i] + 0.5 * this._height[i];
            var b = this._y[i] - 0.5 * this._height[i];
            return [
                l,
                r,
                t,
                b
            ];
        };
        HBarView.prototype._map_data = function () {
            this.sy = this.renderer.yscale.v_compute(this._y);
            this.sright = this.renderer.xscale.v_compute(this._right);
            this.sleft = this.renderer.xscale.v_compute(this._left);
            this.stop = [];
            this.sbottom = [];
            this.sh = this.sdist(this.renderer.yscale, this._y, this._height, 'center');
            for (var i = 0, end = this.sy.length; i < end; i++) {
                this.stop.push(this.sy[i] - this.sh[i] / 2);
                this.sbottom.push(this.sy[i] + this.sh[i] / 2);
            }
            return null;
        };
        return HBarView;
    }(box_1.BoxView);
    exports.HBarView = HBarView;
    var HBar = function (_super) {
        tslib_1.__extends(HBar, _super);
        function HBar(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        HBar.initClass = function () {
            this.prototype.type = 'HBar';
            this.prototype.default_view = HBarView;
            this.coords([[
                    'left',
                    'y'
                ]]);
            this.define({
                height: [p.DistanceSpec],
                right: [p.NumberSpec]
            });
            this.override({ left: 0 });
        };
        return HBar;
    }(box_1.Box);
    exports.HBar = HBar;
    HBar.initClass();    
},
/*models/glyphs/image*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    /* XXX: partial */
    var xy_glyph_1 = require(129    /* ./xy_glyph */);
    var linear_color_mapper_1 = require(147    /* ../mappers/linear_color_mapper */);
    var p = require(15    /* core/properties */);
    var array_1 = require(22    /* core/util/array */);
    var ImageView = function (_super) {
        tslib_1.__extends(ImageView, _super);
        function ImageView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        ImageView.prototype.initialize = function (options) {
            _super.prototype.initialize.call(this, options);
            this.connect(this.model.color_mapper.change, function () {
                return this._update_image();
            });
        };
        ImageView.prototype._update_image = function () {
            // Only reset image_data if already initialized
            if (this.image_data != null) {
                this._set_data();
                return this.renderer.plot_view.request_render();
            }
        };
        ImageView.prototype._set_data = function () {
            if (this.image_data == null || this.image_data.length !== this._image.length) {
                this.image_data = new Array(this._image.length);
            }
            if (this._width == null || this._width.length !== this._image.length) {
                this._width = new Array(this._image.length);
            }
            if (this._height == null || this._height.length !== this._image.length) {
                this._height = new Array(this._image.length);
            }
            for (var i = 0, end = this._image.length; i < end; i++) {
                var canvas = void 0, img = void 0;
                var shape = [];
                if (this._image_shape != null) {
                    shape = this._image_shape[i];
                }
                if (shape.length > 0) {
                    img = this._image[i];
                    this._height[i] = shape[0];
                    this._width[i] = shape[1];
                } else {
                    img = array_1.concat(this._image[i]);
                    this._height[i] = this._image[i].length;
                    this._width[i] = this._image[i][0].length;
                }
                if (this.image_data[i] != null && this.image_data[i].width === this._width[i] && this.image_data[i].height === this._height[i]) {
                    canvas = this.image_data[i];
                } else {
                    canvas = document.createElement('canvas');
                    canvas.width = this._width[i];
                    canvas.height = this._height[i];
                }
                var ctx = canvas.getContext('2d');
                var image_data = ctx.getImageData(0, 0, this._width[i], this._height[i]);
                var cmap = this.model.color_mapper;
                var buf = cmap.v_map_screen(img, true);
                var buf8 = new Uint8Array(buf);
                image_data.data.set(buf8);
                ctx.putImageData(image_data, 0, 0);
                this.image_data[i] = canvas;
                this.max_dw = 0;
                if (this._dw.units === 'data') {
                    this.max_dw = array_1.max(this._dw);
                }
                this.max_dh = 0;
                if (this._dh.units === 'data') {
                    this.max_dh = array_1.max(this._dh);
                }
            }
        };
        ImageView.prototype._map_data = function () {
            switch (this.model.properties.dw.units) {
            case 'data':
                this.sw = this.sdist(this.renderer.xscale, this._x, this._dw, 'edge', this.model.dilate);
                break;
            case 'screen':
                this.sw = this._dw;
                break;
            }
            switch (this.model.properties.dh.units) {
            case 'data':
                return this.sh = this.sdist(this.renderer.yscale, this._y, this._dh, 'edge', this.model.dilate);
            case 'screen':
                return this.sh = this._dh;
            }
        };
        ImageView.prototype._render = function (ctx, indices, _a) {
            var image_data = _a.image_data, sx = _a.sx, sy = _a.sy, sw = _a.sw, sh = _a.sh;
            var old_smoothing = ctx.getImageSmoothingEnabled();
            ctx.setImageSmoothingEnabled(false);
            for (var _i = 0, indices_1 = indices; _i < indices_1.length; _i++) {
                var i = indices_1[_i];
                if (image_data[i] == null) {
                    continue;
                }
                if (isNaN(sx[i] + sy[i] + sw[i] + sh[i])) {
                    continue;
                }
                var y_offset = sy[i];
                ctx.translate(0, y_offset);
                ctx.scale(1, -1);
                ctx.translate(0, -y_offset);
                ctx.drawImage(image_data[i], sx[i] | 0, sy[i] | 0, sw[i], sh[i]);
                ctx.translate(0, y_offset);
                ctx.scale(1, -1);
                ctx.translate(0, -y_offset);
            }
            return ctx.setImageSmoothingEnabled(old_smoothing);
        };
        ImageView.prototype.bounds = function () {
            var bbox = this.index.bbox;
            bbox.maxX += this.max_dw;
            bbox.maxY += this.max_dh;
            return bbox;
        };
        return ImageView;
    }(xy_glyph_1.XYGlyphView);
    exports.ImageView = ImageView;
    // NOTE: this needs to be redefined here, because palettes are located in bokeh-api.js bundle
    var Greys9 = function () {
        return [
            0,
            2434341,
            5395026,
            7566195,
            9868950,
            12434877,
            14277081,
            15790320,
            16777215
        ];
    };
    var Image = function (_super) {
        tslib_1.__extends(Image, _super);
        function Image(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        Image.initClass = function () {
            this.prototype.type = 'Image';
            this.prototype.default_view = ImageView;
            this.define({
                image: [p.NumberSpec],
                dw: [p.DistanceSpec],
                dh: [p.DistanceSpec],
                dilate: [
                    p.Bool,
                    false
                ],
                color_mapper: [
                    p.Instance,
                    function () {
                        return new linear_color_mapper_1.LinearColorMapper({ palette: Greys9() });
                    }
                ]
            });
        };
        return Image;
    }(xy_glyph_1.XYGlyph);
    exports.Image = Image;
    Image.initClass();    
},
/*models/glyphs/image_rgba*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    /* XXX: partial */
    var xy_glyph_1 = require(129    /* ./xy_glyph */);
    var p = require(15    /* core/properties */);
    var array_1 = require(22    /* core/util/array */);
    var ImageRGBAView = function (_super) {
        tslib_1.__extends(ImageRGBAView, _super);
        function ImageRGBAView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        ImageRGBAView.prototype._set_data = function (_source, indices) {
            if (this.image_data == null || this.image_data.length !== this._image.length) {
                this.image_data = new Array(this._image.length);
            }
            if (this._width == null || this._width.length !== this._image.length) {
                this._width = new Array(this._image.length);
            }
            if (this._height == null || this._height.length !== this._image.length) {
                this._height = new Array(this._image.length);
            }
            for (var i = 0, end = this._image.length; i < end; i++) {
                var buf = void 0, canvas = void 0;
                if (indices != null && indices.indexOf(i) < 0) {
                    continue;
                }
                var shape = [];
                if (this._image_shape != null) {
                    shape = this._image_shape[i];
                }
                if (shape.length > 0) {
                    buf = this._image[i].buffer;
                    this._height[i] = shape[0];
                    this._width[i] = shape[1];
                } else {
                    var flat = array_1.concat(this._image[i]);
                    buf = new ArrayBuffer(flat.length * 4);
                    var color = new Uint32Array(buf);
                    for (var j = 0, endj = flat.length; j < endj; j++) {
                        color[j] = flat[j];
                    }
                    this._height[i] = this._image[i].length;
                    this._width[i] = this._image[i][0].length;
                }
                if (this.image_data[i] != null && this.image_data[i].width === this._width[i] && this.image_data[i].height === this._height[i]) {
                    canvas = this.image_data[i];
                } else {
                    canvas = document.createElement('canvas');
                    canvas.width = this._width[i];
                    canvas.height = this._height[i];
                }
                var ctx = canvas.getContext('2d');
                var image_data = ctx.getImageData(0, 0, this._width[i], this._height[i]);
                var buf8 = new Uint8Array(buf);
                image_data.data.set(buf8);
                ctx.putImageData(image_data, 0, 0);
                this.image_data[i] = canvas;
                this.max_dw = 0;
                if (this._dw.units === 'data') {
                    this.max_dw = array_1.max(this._dw);
                }
                this.max_dh = 0;
                if (this._dh.units === 'data') {
                    this.max_dh = array_1.max(this._dh);
                }
            }
        };
        ImageRGBAView.prototype._map_data = function () {
            switch (this.model.properties.dw.units) {
            case 'data':
                this.sw = this.sdist(this.renderer.xscale, this._x, this._dw, 'edge', this.model.dilate);
                break;
            case 'screen':
                this.sw = this._dw;
                break;
            }
            switch (this.model.properties.dh.units) {
            case 'data':
                return this.sh = this.sdist(this.renderer.yscale, this._y, this._dh, 'edge', this.model.dilate);
            case 'screen':
                return this.sh = this._dh;
            }
        };
        ImageRGBAView.prototype._render = function (ctx, indices, _a) {
            var image_data = _a.image_data, sx = _a.sx, sy = _a.sy, sw = _a.sw, sh = _a.sh;
            var old_smoothing = ctx.getImageSmoothingEnabled();
            ctx.setImageSmoothingEnabled(false);
            for (var _i = 0, indices_1 = indices; _i < indices_1.length; _i++) {
                var i = indices_1[_i];
                if (isNaN(sx[i] + sy[i] + sw[i] + sh[i])) {
                    continue;
                }
                var y_offset = sy[i];
                ctx.translate(0, y_offset);
                ctx.scale(1, -1);
                ctx.translate(0, -y_offset);
                ctx.drawImage(image_data[i], sx[i] | 0, sy[i] | 0, sw[i], sh[i]);
                ctx.translate(0, y_offset);
                ctx.scale(1, -1);
                ctx.translate(0, -y_offset);
            }
            return ctx.setImageSmoothingEnabled(old_smoothing);
        };
        ImageRGBAView.prototype.bounds = function () {
            var bbox = this.index.bbox;
            bbox.maxX += this.max_dw;
            bbox.maxY += this.max_dh;
            return bbox;
        };
        return ImageRGBAView;
    }(xy_glyph_1.XYGlyphView);
    exports.ImageRGBAView = ImageRGBAView;
    var ImageRGBA = function (_super) {
        tslib_1.__extends(ImageRGBA, _super);
        function ImageRGBA(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        ImageRGBA.initClass = function () {
            this.prototype.type = 'ImageRGBA';
            this.prototype.default_view = ImageRGBAView;
            this.define({
                image: [p.NumberSpec],
                dw: [p.DistanceSpec],
                dh: [p.DistanceSpec],
                dilate: [
                    p.Bool,
                    false
                ]
            });
        };
        return ImageRGBA;
    }(xy_glyph_1.XYGlyph);
    exports.ImageRGBA = ImageRGBA;
    ImageRGBA.initClass();    
},
/*models/glyphs/image_url*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    /* XXX: partial */
    var glyph_1 = require(109    /* ./glyph */);
    var logging_1 = require(14    /* core/logging */);
    var p = require(15    /* core/properties */);
    var ImageURLView = function (_super) {
        tslib_1.__extends(ImageURLView, _super);
        function ImageURLView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        ImageURLView.prototype.initialize = function (options) {
            var _this = this;
            _super.prototype.initialize.call(this, options);
            this.connect(this.model.properties.global_alpha.change, function () {
                return _this.renderer.request_render();
            });
        };
        ImageURLView.prototype._index_data = function () {
        };
        ImageURLView.prototype._set_data = function () {
            var _this = this;
            if (this.image == null || this.image.length !== this._url.length)
                this.image = this._url.map(function (_) {
                    return null;
                });
            var retry_attempts = this.model.retry_attempts;
            var retry_timeout = this.model.retry_timeout;
            this.retries = this._url.map(function (_) {
                return retry_attempts;
            });
            for (var i = 0, end = this._url.length; i < end; i++) {
                if (this._url[i] == null)
                    continue;
                var img = new Image();
                img.onerror = function (i, img) {
                    return function () {
                        if (_this.retries[i] > 0) {
                            logging_1.logger.trace('ImageURL failed to load ' + _this._url[i] + ' image, retrying in ' + retry_timeout + ' ms');
                            setTimeout(function () {
                                return img.src = _this._url[i];
                            }, retry_timeout);
                        } else {
                            logging_1.logger.warn('ImageURL unable to load ' + _this._url[i] + ' image after ' + retry_attempts + ' retries');
                        }
                        return _this.retries[i] -= 1;
                    };
                }(i, img);
                img.onload = function (img, i) {
                    return function () {
                        _this.image[i] = img;
                        return _this.renderer.request_render();
                    };
                }(img, i);
                img.src = this._url[i];
            }
        };
        ImageURLView.prototype.has_finished = function () {
            return _super.prototype.has_finished.call(this) && this._images_rendered === true;
        };
        ImageURLView.prototype._map_data = function () {
            var _this = this;
            // Better to check @model.w and @model.h for null since the set_data
            // machinery will have converted @_w and @_w to lists of null
            var ws = this.model.w != null ? this._w : function () {
                var result = [];
                for (var _i = 0, _a = _this._x; _i < _a.length; _i++) {
                    var _ = _a[_i];
                    result.push(NaN);
                }
                return result;
            }();
            var hs = this.model.h != null ? this._h : function () {
                var result1 = [];
                for (var _i = 0, _a = _this._x; _i < _a.length; _i++) {
                    var _ = _a[_i];
                    result1.push(NaN);
                }
                return result1;
            }();
            switch (this.model.properties.w.units) {
            case 'data': {
                    this.sw = this.sdist(this.renderer.xscale, this._x, ws, 'edge', this.model.dilate);
                    break;
                }
            case 'screen': {
                    this.sw = ws;
                    break;
                }
            }
            switch (this.model.properties.h.units) {
            case 'data': {
                    this.sh = this.sdist(this.renderer.yscale, this._y, hs, 'edge', this.model.dilate);
                    break;
                }
            case 'screen': {
                    this.sh = hs;
                    break;
                }
            }
        };
        ImageURLView.prototype._render = function (ctx, indices, _a) {
            var _url = _a._url, image = _a.image, sx = _a.sx, sy = _a.sy, sw = _a.sw, sh = _a.sh, _angle = _a._angle;
            // TODO (bev): take actual border width into account when clipping
            var frame = this.renderer.plot_view.frame;
            ctx.rect(frame._left.value + 1, frame._top.value + 1, frame._width.value - 2, frame._height.value - 2);
            ctx.clip();
            var finished = true;
            for (var _i = 0, indices_1 = indices; _i < indices_1.length; _i++) {
                var i = indices_1[_i];
                if (isNaN(sx[i] + sy[i] + _angle[i])) {
                    continue;
                }
                if (this.retries[i] === -1) {
                    continue;
                }
                if (image[i] == null) {
                    finished = false;
                    continue;
                }
                this._render_image(ctx, i, image[i], sx, sy, sw, sh, _angle);
            }
            if (finished && !this._images_rendered) {
                this._images_rendered = true;
                return this.notify_finished();
            }
        };
        ImageURLView.prototype._final_sx_sy = function (anchor, sx, sy, sw, sh) {
            switch (anchor) {
            case 'top_left':
                return [
                    sx,
                    sy
                ];
            case 'top_center':
                return [
                    sx - sw / 2,
                    sy
                ];
            case 'top_right':
                return [
                    sx - sw,
                    sy
                ];
            case 'center_right':
                return [
                    sx - sw,
                    sy - sh / 2
                ];
            case 'bottom_right':
                return [
                    sx - sw,
                    sy - sh
                ];
            case 'bottom_center':
                return [
                    sx - sw / 2,
                    sy - sh
                ];
            case 'bottom_left':
                return [
                    sx,
                    sy - sh
                ];
            case 'center_left':
                return [
                    sx,
                    sy - sh / 2
                ];
            case 'center':
                return [
                    sx - sw / 2,
                    sy - sh / 2
                ];
            }
        };
        ImageURLView.prototype._render_image = function (ctx, i, image, sx, sy, sw, sh, angle) {
            if (isNaN(sw[i])) {
                sw[i] = image.width;
            }
            if (isNaN(sh[i])) {
                sh[i] = image.height;
            }
            var anchor = this.model.anchor;
            _a = this._final_sx_sy(anchor, sx[i], sy[i], sw[i], sh[i]), sx = _a[0], sy = _a[1];
            ctx.save();
            ctx.globalAlpha = this.model.global_alpha;
            if (angle[i]) {
                ctx.translate(sx, sy);
                ctx.rotate(angle[i]);
                ctx.drawImage(image, 0, 0, sw[i], sh[i]);
                ctx.rotate(-angle[i]);
                ctx.translate(-sx, -sy);
            } else {
                ctx.drawImage(image, sx, sy, sw[i], sh[i]);
            }
            return ctx.restore();
            var _a;
        };
        return ImageURLView;
    }(glyph_1.GlyphView);
    exports.ImageURLView = ImageURLView;
    var ImageURL = function (_super) {
        tslib_1.__extends(ImageURL, _super);
        function ImageURL(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        ImageURL.initClass = function () {
            this.prototype.type = 'ImageURL';
            this.prototype.default_view = ImageURLView;
            this.coords([[
                    'x',
                    'y'
                ]]);
            this.define({
                url: [p.StringSpec],
                anchor: [
                    p.Anchor,
                    'top_left'
                ],
                global_alpha: [
                    p.Number,
                    1
                ],
                angle: [
                    p.AngleSpec,
                    0
                ],
                w: [p.DistanceSpec],
                h: [p.DistanceSpec],
                dilate: [
                    p.Bool,
                    false
                ],
                retry_attempts: [
                    p.Number,
                    0
                ],
                retry_timeout: [
                    p.Number,
                    0
                ]
            });
        };
        return ImageURL;
    }(glyph_1.Glyph);
    exports.ImageURL = ImageURL;
    ImageURL.initClass();    
},
/*models/glyphs/index*/
function _(require, module, exports) {
    var annular_wedge_1 = require(102    /* ./annular_wedge */);
    exports.AnnularWedge = annular_wedge_1.AnnularWedge;
    var annulus_1 = require(103    /* ./annulus */);
    exports.Annulus = annulus_1.Annulus;
    var arc_1 = require(104    /* ./arc */);
    exports.Arc = arc_1.Arc;
    var bezier_1 = require(105    /* ./bezier */);
    exports.Bezier = bezier_1.Bezier;
    var circle_1 = require(107    /* ./circle */);
    exports.Circle = circle_1.Circle;
    var ellipse_1 = require(108    /* ./ellipse */);
    exports.Ellipse = ellipse_1.Ellipse;
    var glyph_1 = require(109    /* ./glyph */);
    exports.Glyph = glyph_1.Glyph;
    var hbar_1 = require(110    /* ./hbar */);
    exports.HBar = hbar_1.HBar;
    var image_1 = require(111    /* ./image */);
    exports.Image = image_1.Image;
    var image_rgba_1 = require(112    /* ./image_rgba */);
    exports.ImageRGBA = image_rgba_1.ImageRGBA;
    var image_url_1 = require(113    /* ./image_url */);
    exports.ImageURL = image_url_1.ImageURL;
    var line_1 = require(115    /* ./line */);
    exports.Line = line_1.Line;
    var multi_line_1 = require(116    /* ./multi_line */);
    exports.MultiLine = multi_line_1.MultiLine;
    var oval_1 = require(117    /* ./oval */);
    exports.Oval = oval_1.Oval;
    var patch_1 = require(118    /* ./patch */);
    exports.Patch = patch_1.Patch;
    var patches_1 = require(119    /* ./patches */);
    exports.Patches = patches_1.Patches;
    var quad_1 = require(120    /* ./quad */);
    exports.Quad = quad_1.Quad;
    var quadratic_1 = require(121    /* ./quadratic */);
    exports.Quadratic = quadratic_1.Quadratic;
    var ray_1 = require(122    /* ./ray */);
    exports.Ray = ray_1.Ray;
    var rect_1 = require(123    /* ./rect */);
    exports.Rect = rect_1.Rect;
    var segment_1 = require(124    /* ./segment */);
    exports.Segment = segment_1.Segment;
    var step_1 = require(125    /* ./step */);
    exports.Step = step_1.Step;
    var text_1 = require(126    /* ./text */);
    exports.Text = text_1.Text;
    var vbar_1 = require(127    /* ./vbar */);
    exports.VBar = vbar_1.VBar;
    var wedge_1 = require(128    /* ./wedge */);
    exports.Wedge = wedge_1.Wedge;
    var xy_glyph_1 = require(129    /* ./xy_glyph */);
    exports.XYGlyph = xy_glyph_1.XYGlyph;    
},
/*models/glyphs/line*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    /* XXX: partial */
    var xy_glyph_1 = require(129    /* ./xy_glyph */);
    var hittest = require(9    /* core/hittest */);
    var LineView = function (_super) {
        tslib_1.__extends(LineView, _super);
        function LineView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        LineView.prototype._render = function (ctx, indices, _a) {
            var sx = _a.sx, sy = _a.sy;
            var drawing = false;
            this.visuals.line.set_value(ctx);
            var last_index = null;
            for (var _i = 0, indices_1 = indices; _i < indices_1.length; _i++) {
                var i = indices_1[_i];
                if (drawing) {
                    if (!isFinite(sx[i] + sy[i])) {
                        ctx.stroke();
                        ctx.beginPath();
                        drawing = false;
                        last_index = i;
                        continue;
                    }
                    if (last_index !== null && i - last_index > 1) {
                        ctx.stroke();
                        drawing = false;
                    }
                }
                if (drawing) {
                    ctx.lineTo(sx[i], sy[i]);
                } else {
                    ctx.beginPath();
                    ctx.moveTo(sx[i], sy[i]);
                    drawing = true;
                }
                last_index = i;
            }
            if (drawing) {
                return ctx.stroke();
            }
        };
        LineView.prototype._hit_point = function (geometry) {
            var _this = this;
            /* Check if the point geometry hits this line glyph and return an object
        that describes the hit result:
          Args:
            * geometry (object): object with the following keys
              * sx (float): screen x coordinate of the point
              * sy (float): screen y coordinate of the point
              * type (str): type of geometry (in this case it's a point)
          Output:
            Object with the following keys:
              * 0d (bool): whether the point hits the glyph or not
              * 1d (array(int)): array with the indices hit by the point
        */
            var result = hittest.create_hit_test_result();
            var point = {
                x: geometry.sx,
                y: geometry.sy
            };
            var shortest = 9999;
            var threshold = Math.max(2, this.visuals.line.line_width.value() / 2);
            for (var i = 0, end = this.sx.length - 1; i < end; i++) {
                var _a = [
                        {
                            x: this.sx[i],
                            y: this.sy[i]
                        },
                        {
                            x: this.sx[i + 1],
                            y: this.sy[i + 1]
                        }
                    ], p0 = _a[0], p1 = _a[1];
                var dist = hittest.dist_to_segment(point, p0, p1);
                if (dist < threshold && dist < shortest) {
                    shortest = dist;
                    result['0d'].glyph = this.model;
                    result['0d'].get_view = function () {
                        return _this;
                    };
                    result['0d'].flag = true;
                    // backward compat
                    result['0d'].indices = [i];
                }
            }
            return result;
        };
        LineView.prototype._hit_span = function (geometry) {
            var _this = this;
            var val, values;
            var sx = geometry.sx, sy = geometry.sy;
            var result = hittest.create_hit_test_result();
            if (geometry.direction === 'v') {
                val = this.renderer.yscale.invert(sy);
                values = this._y;
            } else {
                val = this.renderer.xscale.invert(sx);
                values = this._x;
            }
            for (var i = 0, end = values.length - 1; i < end; i++) {
                if (values[i] <= val && val <= values[i + 1] || values[i + 1] <= val && val <= values[i]) {
                    result['0d'].glyph = this.model;
                    result['0d'].get_view = function () {
                        return _this;
                    };
                    result['0d'].flag = true;
                    // backward compat
                    result['0d'].indices.push(i);
                }
            }
            return result;
        };
        LineView.prototype.get_interpolation_hit = function (i, geometry) {
            var x0, x1, y0, y1;
            var sx = geometry.sx, sy = geometry.sy;
            var _a = [
                    this._x[i],
                    this._y[i],
                    this._x[i + 1],
                    this._y[i + 1]
                ], x2 = _a[0], y2 = _a[1], x3 = _a[2], y3 = _a[3];
            if (geometry.type === 'point') {
                _b = this.renderer.yscale.r_invert(sy - 1, sy + 1), y0 = _b[0], y1 = _b[1];
                _c = this.renderer.xscale.r_invert(sx - 1, sx + 1), x0 = _c[0], x1 = _c[1];
            } else {
                if (geometry.direction === 'v') {
                    _d = this.renderer.yscale.r_invert(sy, sy), y0 = _d[0], y1 = _d[1];
                    _e = [
                        x2,
                        x3
                    ], x0 = _e[0], x1 = _e[1];
                } else {
                    _f = this.renderer.xscale.r_invert(sx, sx), x0 = _f[0], x1 = _f[1];
                    _g = [
                        y2,
                        y3
                    ], y0 = _g[0], y1 = _g[1];
                }
            }
            var res = hittest.check_2_segments_intersect(x0, y0, x1, y1, x2, y2, x3, y3);
            return [
                res.x,
                res.y
            ];
            var _b, _c, _d, _e, _f, _g;
        };
        LineView.prototype.draw_legend_for_index = function (ctx, x0, x1, y0, y1, index) {
            return this._generic_line_legend(ctx, x0, x1, y0, y1, index);
        };
        return LineView;
    }(xy_glyph_1.XYGlyphView);
    exports.LineView = LineView;
    var Line = function (_super) {
        tslib_1.__extends(Line, _super);
        function Line(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        Line.initClass = function () {
            this.prototype.type = 'Line';
            this.prototype.default_view = LineView;
            this.mixins(['line']);
        };
        return Line;
    }(xy_glyph_1.XYGlyph);
    exports.Line = Line;
    Line.initClass();    
},
/*models/glyphs/multi_line*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    /* XXX: partial */
    var spatial_1 = require(37    /* core/util/spatial */);
    var hittest = require(9    /* core/hittest */);
    var object_1 = require(31    /* core/util/object */);
    var array_1 = require(22    /* core/util/array */);
    var types_1 = require(43    /* core/util/types */);
    var glyph_1 = require(109    /* ./glyph */);
    var MultiLineView = function (_super) {
        tslib_1.__extends(MultiLineView, _super);
        function MultiLineView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        MultiLineView.prototype._index_data = function () {
            var _this = this;
            var points = [];
            var _loop_1 = function (i, end) {
                if (this_1._xs[i] === null || this_1._xs[i].length === 0) {
                    return 'continue';
                }
                var xs = function () {
                    var result = [];
                    for (var _i = 0, _a = _this._xs[i]; _i < _a.length; _i++) {
                        var x = _a[_i];
                        if (!types_1.isStrictNaN(x)) {
                            result.push(x);
                        }
                    }
                    return result;
                }();
                var ys = function () {
                    var result1 = [];
                    for (var _i = 0, _a = _this._ys[i]; _i < _a.length; _i++) {
                        var y = _a[_i];
                        if (!types_1.isStrictNaN(y))
                            result1.push(y);
                    }
                    return result1;
                }();
                points.push({
                    minX: array_1.min(xs),
                    minY: array_1.min(ys),
                    maxX: array_1.max(xs),
                    maxY: array_1.max(ys),
                    i: i
                });
            };
            var this_1 = this;
            for (var i = 0, end = this._xs.length; i < end; i++) {
                _loop_1(i, end);
            }
            return new spatial_1.RBush(points);
        };
        MultiLineView.prototype._render = function (ctx, indices, _a) {
            var sxs = _a.sxs, sys = _a.sys;
            for (var _i = 0, indices_1 = indices; _i < indices_1.length; _i++) {
                var i = indices_1[_i];
                var _b = [
                        sxs[i],
                        sys[i]
                    ], sx = _b[0], sy = _b[1];
                this.visuals.line.set_vectorize(ctx, i);
                for (var j = 0, end = sx.length; j < end; j++) {
                    if (j === 0) {
                        ctx.beginPath();
                        ctx.moveTo(sx[j], sy[j]);
                        continue;
                    } else if (isNaN(sx[j]) || isNaN(sy[j])) {
                        ctx.stroke();
                        ctx.beginPath();
                        continue;
                    } else {
                        ctx.lineTo(sx[j], sy[j]);
                    }
                }
                ctx.stroke();
            }
        };
        MultiLineView.prototype._hit_point = function (geometry) {
            var result = hittest.create_hit_test_result();
            var point = {
                x: geometry.sx,
                y: geometry.sy
            };
            var shortest = 9999;
            var hits = {};
            for (var i = 0, end = this.sxs.length; i < end; i++) {
                var threshold = Math.max(2, this.visuals.line.cache_select('line_width', i) / 2);
                var points = null;
                for (var j = 0, endj = this.sxs[i].length - 1; j < endj; j++) {
                    var _a = [
                            {
                                x: this.sxs[i][j],
                                y: this.sys[i][j]
                            },
                            {
                                x: this.sxs[i][j + 1],
                                y: this.sys[i][j + 1]
                            }
                        ], p0 = _a[0], p1 = _a[1];
                    var dist = hittest.dist_to_segment(point, p0, p1);
                    if (dist < threshold && dist < shortest) {
                        shortest = dist;
                        points = [j];
                    }
                }
                if (points) {
                    hits[i] = points;
                }
            }
            result['1d'].indices = object_1.keys(hits).map(parseInt);
            result['2d'].indices = hits;
            return result;
        };
        MultiLineView.prototype._hit_span = function (geometry) {
            var val, values;
            var sx = geometry.sx, sy = geometry.sy;
            var result = hittest.create_hit_test_result();
            if (geometry.direction === 'v') {
                val = this.renderer.yscale.invert(sy);
                values = this._ys;
            } else {
                val = this.renderer.xscale.invert(sx);
                values = this._xs;
            }
            var hits = {};
            for (var i = 0, end = values.length; i < end; i++) {
                var points = [];
                for (var j = 0, endj = values[i].length - 1; j < endj; j++) {
                    if (values[i][j] <= val && val <= values[i][j + 1]) {
                        points.push(j);
                    }
                }
                if (points.length > 0) {
                    hits[i] = points;
                }
            }
            result['1d'].indices = object_1.keys(hits).map(parseInt);
            result['2d'].indices = hits;
            return result;
        };
        MultiLineView.prototype.get_interpolation_hit = function (i, point_i, geometry) {
            var x0, x1, y0, y1;
            var sx = geometry.sx, sy = geometry.sy;
            var _a = [
                    this._xs[i][point_i],
                    this._ys[i][point_i],
                    this._xs[i][point_i + 1],
                    this._ys[i][point_i + 1]
                ], x2 = _a[0], y2 = _a[1], x3 = _a[2], y3 = _a[3];
            if (geometry.type === 'point') {
                _b = this.renderer.yscale.r_invert(sy - 1, sy + 1), y0 = _b[0], y1 = _b[1];
                _c = this.renderer.xscale.r_invert(sx - 1, sx + 1), x0 = _c[0], x1 = _c[1];
            } else {
                if (geometry.direction === 'v') {
                    _d = this.renderer.yscale.r_invert(sy, sy), y0 = _d[0], y1 = _d[1];
                    _e = [
                        x2,
                        x3
                    ], x0 = _e[0], x1 = _e[1];
                } else {
                    _f = this.renderer.xscale.r_invert(sx, sx), x0 = _f[0], x1 = _f[1];
                    _g = [
                        y2,
                        y3
                    ], y0 = _g[0], y1 = _g[1];
                }
            }
            var res = hittest.check_2_segments_intersect(x0, y0, x1, y1, x2, y2, x3, y3);
            return [
                res.x,
                res.y
            ];
            var _b, _c, _d, _e, _f, _g;
        };
        MultiLineView.prototype.draw_legend_for_index = function (ctx, x0, x1, y0, y1, index) {
            return this._generic_line_legend(ctx, x0, x1, y0, y1, index);
        };
        return MultiLineView;
    }(glyph_1.GlyphView);
    exports.MultiLineView = MultiLineView;
    var MultiLine = function (_super) {
        tslib_1.__extends(MultiLine, _super);
        function MultiLine(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        MultiLine.initClass = function () {
            this.prototype.type = 'MultiLine';
            this.prototype.default_view = MultiLineView;
            this.coords([[
                    'xs',
                    'ys'
                ]]);
            this.mixins(['line']);
        };
        return MultiLine;
    }(glyph_1.Glyph);
    exports.MultiLine = MultiLine;
    MultiLine.initClass();    
},
/*models/glyphs/oval*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    /* XXX: partial */
    var xy_glyph_1 = require(129    /* ./xy_glyph */);
    var p = require(15    /* core/properties */);
    var OvalView = function (_super) {
        tslib_1.__extends(OvalView, _super);
        function OvalView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        OvalView.prototype._set_data = function () {
            this.max_w2 = 0;
            if (this.model.properties.width.units === 'data') {
                this.max_w2 = this.max_width / 2;
            }
            this.max_h2 = 0;
            if (this.model.properties.height.units === 'data') {
                return this.max_h2 = this.max_height / 2;
            }
        };
        OvalView.prototype._map_data = function () {
            if (this.model.properties.width.units === 'data') {
                this.sw = this.sdist(this.renderer.xscale, this._x, this._width, 'center');
            } else {
                this.sw = this._width;
            }
            if (this.model.properties.height.units === 'data') {
                return this.sh = this.sdist(this.renderer.yscale, this._y, this._height, 'center');
            } else {
                return this.sh = this._height;
            }
        };
        OvalView.prototype._render = function (ctx, indices, _a) {
            var sx = _a.sx, sy = _a.sy, sw = _a.sw, sh = _a.sh;
            for (var _i = 0, indices_1 = indices; _i < indices_1.length; _i++) {
                var i = indices_1[_i];
                if (isNaN(sx[i] + sy[i] + sw[i] + sh[i] + this._angle[i])) {
                    continue;
                }
                ctx.translate(sx[i], sy[i]);
                ctx.rotate(this._angle[i]);
                ctx.beginPath();
                ctx.moveTo(0, -sh[i] / 2);
                ctx.bezierCurveTo(sw[i] / 2, -sh[i] / 2, sw[i] / 2, sh[i] / 2, 0, sh[i] / 2);
                ctx.bezierCurveTo(-sw[i] / 2, sh[i] / 2, -sw[i] / 2, -sh[i] / 2, 0, -sh[i] / 2);
                ctx.closePath();
                if (this.visuals.fill.doit) {
                    this.visuals.fill.set_vectorize(ctx, i);
                    ctx.fill();
                }
                if (this.visuals.line.doit) {
                    this.visuals.line.set_vectorize(ctx, i);
                    ctx.stroke();
                }
                ctx.rotate(-this._angle[i]);
                ctx.translate(-sx[i], -sy[i]);
            }
        };
        OvalView.prototype.draw_legend_for_index = function (ctx, x0, x1, y0, y1, index) {
            var indices = [index];
            var sx = {};
            sx[index] = (x0 + x1) / 2;
            var sy = {};
            sy[index] = (y0 + y1) / 2;
            var scale = this.sw[index] / this.sh[index];
            var d = Math.min(Math.abs(x1 - x0), Math.abs(y1 - y0)) * 0.8;
            var sw = {};
            var sh = {};
            if (scale > 1) {
                sw[index] = d;
                sh[index] = d / scale;
            } else {
                sw[index] = d * scale;
                sh[index] = d;
            }
            var data = {
                sx: sx,
                sy: sy,
                sw: sw,
                sh: sh
            };
            return this._render(ctx, indices, data);
        };
        OvalView.prototype._bounds = function (bds) {
            return this.max_wh2_bounds(bds);
        };
        return OvalView;
    }(xy_glyph_1.XYGlyphView);
    exports.OvalView = OvalView;
    var Oval = function (_super) {
        tslib_1.__extends(Oval, _super);
        function Oval(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        Oval.initClass = function () {
            this.prototype.type = 'Oval';
            this.prototype.default_view = OvalView;
            this.mixins([
                'line',
                'fill'
            ]);
            this.define({
                angle: [
                    p.AngleSpec,
                    0
                ],
                width: [p.DistanceSpec],
                height: [p.DistanceSpec]
            });
        };
        return Oval;
    }(xy_glyph_1.XYGlyph);
    exports.Oval = Oval;
    Oval.initClass();    
},
/*models/glyphs/patch*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    /* XXX: partial */
    var xy_glyph_1 = require(129    /* ./xy_glyph */);
    var PatchView = function (_super) {
        tslib_1.__extends(PatchView, _super);
        function PatchView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        PatchView.prototype._render = function (ctx, indices, _a) {
            var sx = _a.sx, sy = _a.sy;
            if (this.visuals.fill.doit) {
                this.visuals.fill.set_value(ctx);
                for (var _i = 0, indices_1 = indices; _i < indices_1.length; _i++) {
                    var i = indices_1[_i];
                    if (i === 0) {
                        ctx.beginPath();
                        ctx.moveTo(sx[i], sy[i]);
                        continue;
                    } else if (isNaN(sx[i] + sy[i])) {
                        ctx.closePath();
                        ctx.fill();
                        ctx.beginPath();
                        continue;
                    } else {
                        ctx.lineTo(sx[i], sy[i]);
                    }
                }
                ctx.closePath();
                ctx.fill();
            }
            if (this.visuals.line.doit) {
                this.visuals.line.set_value(ctx);
                for (var _b = 0, indices_2 = indices; _b < indices_2.length; _b++) {
                    var i = indices_2[_b];
                    if (i === 0) {
                        ctx.beginPath();
                        ctx.moveTo(sx[i], sy[i]);
                        continue;
                    } else if (isNaN(sx[i] + sy[i])) {
                        ctx.closePath();
                        ctx.stroke();
                        ctx.beginPath();
                        continue;
                    } else {
                        ctx.lineTo(sx[i], sy[i]);
                    }
                }
                ctx.closePath();
                return ctx.stroke();
            }
        };
        PatchView.prototype.draw_legend_for_index = function (ctx, x0, x1, y0, y1, index) {
            return this._generic_area_legend(ctx, x0, x1, y0, y1, index);
        };
        return PatchView;
    }(xy_glyph_1.XYGlyphView);
    exports.PatchView = PatchView;
    var Patch = function (_super) {
        tslib_1.__extends(Patch, _super);
        function Patch(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        Patch.initClass = function () {
            this.prototype.type = 'Patch';
            this.prototype.default_view = PatchView;
            this.mixins([
                'line',
                'fill'
            ]);
        };
        return Patch;
    }(xy_glyph_1.XYGlyph);
    exports.Patch = Patch;
    Patch.initClass();    
},
/*models/glyphs/patches*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    /* XXX: partial */
    var spatial_1 = require(37    /* core/util/spatial */);
    var glyph_1 = require(109    /* ./glyph */);
    var array_1 = require(22    /* core/util/array */);
    var types_1 = require(43    /* core/util/types */);
    var hittest = require(9    /* core/hittest */);
    var PatchesView = function (_super) {
        tslib_1.__extends(PatchesView, _super);
        function PatchesView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        PatchesView.prototype._build_discontinuous_object = function (nanned_qs) {
            // _s is @xs, @ys, @sxs, @sys
            // an object of n 1-d arrays in either data or screen units
            //
            // Each 1-d array gets broken to an array of arrays split
            // on any NaNs
            //
            // So:
            // { 0: [x11, x12],
            //   1: [x21, x22, x23],
            //   2: [x31, NaN, x32]
            // }
            // becomes
            // { 0: [[x11, x12]],
            //   1: [[x21, x22, x23]],
            //   2: [[x31],[x32]]
            // }
            var ds = {};
            for (var i = 0, end = nanned_qs.length; i < end; i++) {
                ds[i] = [];
                var qs = array_1.copy(nanned_qs[i]);
                while (qs.length > 0) {
                    var qs_part = void 0;
                    var nan_index = array_1.findLastIndex(qs, function (q) {
                        return types_1.isStrictNaN(q);
                    });
                    if (nan_index >= 0) {
                        qs_part = qs.splice(nan_index);
                    } else {
                        qs_part = qs;
                        qs = [];
                    }
                    var denanned = qs_part.filter(function (q) {
                        return !types_1.isStrictNaN(q);
                    });
                    ds[i].push(denanned);
                }
            }
            return ds;
        };
        PatchesView.prototype._index_data = function () {
            var xss = this._build_discontinuous_object(this._xs);
            var yss = this._build_discontinuous_object(this._ys);
            var points = [];
            for (var i = 0, end = this._xs.length; i < end; i++) {
                for (var j = 0, endj = xss[i].length; j < endj; j++) {
                    var xs = xss[i][j];
                    var ys = yss[i][j];
                    if (xs.length === 0) {
                        continue;
                    }
                    points.push({
                        minX: array_1.min(xs),
                        minY: array_1.min(ys),
                        maxX: array_1.max(xs),
                        maxY: array_1.max(ys),
                        i: i
                    });
                }
            }
            return new spatial_1.RBush(points);
        };
        PatchesView.prototype._mask_data = function (_all_indices) {
            var xr = this.renderer.plot_view.frame.x_ranges.default;
            var _a = [
                    xr.min,
                    xr.max
                ], x0 = _a[0], x1 = _a[1];
            var yr = this.renderer.plot_view.frame.y_ranges.default;
            var _b = [
                    yr.min,
                    yr.max
                ], y0 = _b[0], y1 = _b[1];
            var bbox = hittest.validate_bbox_coords([
                x0,
                x1
            ], [
                y0,
                y1
            ]);
            var indices = this.index.indices(bbox);
            // TODO (bev) this should be under test
            return indices.sort(function (a, b) {
                return a - b;
            });
        };
        PatchesView.prototype._render = function (ctx, indices, _a) {
            var sxs = _a.sxs, sys = _a.sys;
            // @sxss and @syss are used by _hit_point and sxc, syc
            // This is the earliest we can build them, and only build them once
            this.renderer.sxss = this._build_discontinuous_object(sxs);
            this.renderer.syss = this._build_discontinuous_object(sys);
            for (var _i = 0, indices_1 = indices; _i < indices_1.length; _i++) {
                var i = indices_1[_i];
                var _b = [
                        sxs[i],
                        sys[i]
                    ], sx = _b[0], sy = _b[1];
                if (this.visuals.fill.doit) {
                    this.visuals.fill.set_vectorize(ctx, i);
                    for (var j = 0, end = sx.length; j < end; j++) {
                        if (j === 0) {
                            ctx.beginPath();
                            ctx.moveTo(sx[j], sy[j]);
                            continue;
                        } else if (isNaN(sx[j] + sy[j])) {
                            ctx.closePath();
                            ctx.fill();
                            ctx.beginPath();
                            continue;
                        } else {
                            ctx.lineTo(sx[j], sy[j]);
                        }
                    }
                    ctx.closePath();
                    ctx.fill();
                }
                if (this.visuals.line.doit) {
                    this.visuals.line.set_vectorize(ctx, i);
                    for (var j = 0, end = sx.length; j < end; j++) {
                        if (j === 0) {
                            ctx.beginPath();
                            ctx.moveTo(sx[j], sy[j]);
                            continue;
                        } else if (isNaN(sx[j] + sy[j])) {
                            ctx.closePath();
                            ctx.stroke();
                            ctx.beginPath();
                            continue;
                        } else {
                            ctx.lineTo(sx[j], sy[j]);
                        }
                    }
                    ctx.closePath();
                    ctx.stroke();
                }
            }
        };
        PatchesView.prototype._hit_point = function (geometry) {
            var sx = geometry.sx, sy = geometry.sy;
            var x = this.renderer.xscale.invert(sx);
            var y = this.renderer.yscale.invert(sy);
            var candidates = this.index.indices({
                minX: x,
                minY: y,
                maxX: x,
                maxY: y
            });
            var hits = [];
            for (var i = 0, end = candidates.length; i < end; i++) {
                var idx = candidates[i];
                var sxs = this.renderer.sxss[idx];
                var sys = this.renderer.syss[idx];
                for (var j = 0, endj = sxs.length; j < endj; j++) {
                    if (hittest.point_in_poly(sx, sy, sxs[j], sys[j])) {
                        hits.push(idx);
                    }
                }
            }
            var result = hittest.create_hit_test_result();
            result['1d'].indices = hits;
            return result;
        };
        PatchesView.prototype._get_snap_coord = function (array) {
            var sum = 0;
            for (var _i = 0, array_2 = array; _i < array_2.length; _i++) {
                var s = array_2[_i];
                sum += s;
            }
            return sum / array.length;
        };
        PatchesView.prototype.scx = function (i, sx, sy) {
            if (this.renderer.sxss[i].length === 1) {
                // We don't have discontinuous objects so we're ok
                return this._get_snap_coord(this.sxs[i]);
            } else {
                // We have discontinuous objects, so we need to find which
                // one we're in, we can use point_in_poly again
                var sxs = this.renderer.sxss[i];
                var sys = this.renderer.syss[i];
                for (var j = 0, end = sxs.length; j < end; j++) {
                    if (hittest.point_in_poly(sx, sy, sxs[j], sys[j])) {
                        return this._get_snap_coord(sxs[j]);
                    }
                }
            }
            return null;
        };
        PatchesView.prototype.scy = function (i, sx, sy) {
            if (this.renderer.syss[i].length === 1) {
                // We don't have discontinuous objects so we're ok
                return this._get_snap_coord(this.sys[i]);
            } else {
                // We have discontinuous objects, so we need to find which
                // one we're in, we can use point_in_poly again
                var sxs = this.renderer.sxss[i];
                var sys = this.renderer.syss[i];
                for (var j = 0, end = sxs.length; j < end; j++) {
                    if (hittest.point_in_poly(sx, sy, sxs[j], sys[j])) {
                        return this._get_snap_coord(sys[j]);
                    }
                }
            }
        };
        PatchesView.prototype.draw_legend_for_index = function (ctx, x0, x1, y0, y1, index) {
            return this._generic_area_legend(ctx, x0, x1, y0, y1, index);
        };
        return PatchesView;
    }(glyph_1.GlyphView);
    exports.PatchesView = PatchesView;
    var Patches = function (_super) {
        tslib_1.__extends(Patches, _super);
        function Patches(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        Patches.initClass = function () {
            this.prototype.type = 'Patches';
            this.prototype.default_view = PatchesView;
            this.coords([[
                    'xs',
                    'ys'
                ]]);
            this.mixins([
                'line',
                'fill'
            ]);
        };
        return Patches;
    }(glyph_1.Glyph);
    exports.Patches = Patches;
    Patches.initClass();    
},
/*models/glyphs/quad*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    /* XXX: partial */
    var box_1 = require(106    /* ./box */);
    var QuadView = function (_super) {
        tslib_1.__extends(QuadView, _super);
        function QuadView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        QuadView.prototype.get_anchor_point = function (anchor, i, _spt) {
            var left = Math.min(this.sleft[i], this.sright[i]);
            var right = Math.max(this.sright[i], this.sleft[i]);
            var top = Math.min(this.stop[i], this.sbottom[i]);
            // screen coordinates !!!
            var bottom = Math.max(this.sbottom[i], this.stop[i]);
            //
            switch (anchor) {
            case 'top_left':
                return {
                    x: left,
                    y: top
                };
            case 'top_center':
                return {
                    x: (left + right) / 2,
                    y: top
                };
            case 'top_right':
                return {
                    x: right,
                    y: top
                };
            case 'center_right':
                return {
                    x: right,
                    y: (top + bottom) / 2
                };
            case 'bottom_right':
                return {
                    x: right,
                    y: bottom
                };
            case 'bottom_center':
                return {
                    x: (left + right) / 2,
                    y: bottom
                };
            case 'bottom_left':
                return {
                    x: left,
                    y: bottom
                };
            case 'center_left':
                return {
                    x: left,
                    y: (top + bottom) / 2
                };
            case 'center':
                return {
                    x: (left + right) / 2,
                    y: (top + bottom) / 2
                };
            }
        };
        QuadView.prototype.scx = function (i) {
            return (this.sleft[i] + this.sright[i]) / 2;
        };
        QuadView.prototype.scy = function (i) {
            return (this.stop[i] + this.sbottom[i]) / 2;
        };
        QuadView.prototype._index_data = function () {
            return this._index_box(this._right.length);
        };
        QuadView.prototype._lrtb = function (i) {
            var l = this._left[i];
            var r = this._right[i];
            var t = this._top[i];
            var b = this._bottom[i];
            return [
                l,
                r,
                t,
                b
            ];
        };
        return QuadView;
    }(box_1.BoxView);
    exports.QuadView = QuadView;
    var Quad = function (_super) {
        tslib_1.__extends(Quad, _super);
        function Quad(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        Quad.initClass = function () {
            this.prototype.type = 'Quad';
            this.prototype.default_view = QuadView;
            this.coords([
                [
                    'right',
                    'bottom'
                ],
                [
                    'left',
                    'top'
                ]
            ]);
        };
        return Quad;
    }(box_1.Box);
    exports.Quad = Quad;
    Quad.initClass();    
},
/*models/glyphs/quadratic*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    var spatial_1 = require(37    /* core/util/spatial */);
    var glyph_1 = require(109    /* ./glyph */);
    // Formula from: http://pomax.nihongoresources.com/pages/bezier/
    //
    // if segment is quadratic bezier do:
    //   for both directions do:
    //     if control between start and end, compute linear bounding box
    //     otherwise, compute
    //       bound = u(1-t)^2 + 2v(1-t)t + wt^2
    //         (with t = ((u-v) / (u-2v+w)), with {u = start, v = control, w = end})
    //       if control precedes start, min = bound, otherwise max = bound
    var _qbb = function (u, v, w) {
        if (v === (u + w) / 2) {
            return [
                u,
                w
            ];
        } else {
            var t = (u - v) / (u - 2 * v + w);
            var bd = u * Math.pow(1 - t, 2) + 2 * v * (1 - t) * t + w * Math.pow(t, 2);
            return [
                Math.min(u, w, bd),
                Math.max(u, w, bd)
            ];
        }
    };
    var QuadraticView = function (_super) {
        tslib_1.__extends(QuadraticView, _super);
        function QuadraticView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        QuadraticView.prototype._index_data = function () {
            var points = [];
            for (var i = 0, end = this._x0.length; i < end; i++) {
                if (isNaN(this._x0[i] + this._x1[i] + this._y0[i] + this._y1[i] + this._cx[i] + this._cy[i])) {
                    continue;
                }
                var _a = _qbb(this._x0[i], this._cx[i], this._x1[i]), x0 = _a[0], x1 = _a[1];
                var _b = _qbb(this._y0[i], this._cy[i], this._y1[i]), y0 = _b[0], y1 = _b[1];
                points.push({
                    minX: x0,
                    minY: y0,
                    maxX: x1,
                    maxY: y1,
                    i: i
                });
            }
            return new spatial_1.RBush(points);
        };
        QuadraticView.prototype._render = function (ctx, indices, _a) {
            var sx0 = _a.sx0, sy0 = _a.sy0, sx1 = _a.sx1, sy1 = _a.sy1, scx = _a.scx, scy = _a.scy;
            if (this.visuals.line.doit) {
                for (var _i = 0, indices_1 = indices; _i < indices_1.length; _i++) {
                    var i = indices_1[_i];
                    if (isNaN(sx0[i] + sy0[i] + sx1[i] + sy1[i] + scx[i] + scy[i])) {
                        continue;
                    }
                    ctx.beginPath();
                    ctx.moveTo(sx0[i], sy0[i]);
                    ctx.quadraticCurveTo(scx[i], scy[i], sx1[i], sy1[i]);
                    this.visuals.line.set_vectorize(ctx, i);
                    ctx.stroke();
                }
            }
        };
        QuadraticView.prototype.draw_legend_for_index = function (ctx, x0, x1, y0, y1, index) {
            return this._generic_line_legend(ctx, x0, x1, y0, y1, index);
        };
        return QuadraticView;
    }(glyph_1.GlyphView);
    exports.QuadraticView = QuadraticView;
    var Quadratic = function (_super) {
        tslib_1.__extends(Quadratic, _super);
        function Quadratic(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        Quadratic.initClass = function () {
            this.prototype.type = 'Quadratic';
            this.prototype.default_view = QuadraticView;
            this.coords([
                [
                    'x0',
                    'y0'
                ],
                [
                    'x1',
                    'y1'
                ],
                [
                    'cx',
                    'cy'
                ]
            ]);
            this.mixins(['line']);
        };
        return Quadratic;
    }(glyph_1.Glyph);
    exports.Quadratic = Quadratic;
    Quadratic.initClass();    
},
/*models/glyphs/ray*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    /* XXX: partial */
    var xy_glyph_1 = require(129    /* ./xy_glyph */);
    var p = require(15    /* core/properties */);
    var RayView = function (_super) {
        tslib_1.__extends(RayView, _super);
        function RayView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        RayView.prototype._map_data = function () {
            if (this.model.properties.length.units === 'data') {
                return this.slength = this.sdist(this.renderer.xscale, this._x, this._length);
            } else {
                return this.slength = this._length;
            }
        };
        RayView.prototype._render = function (ctx, indices, _a) {
            var sx = _a.sx, sy = _a.sy, slength = _a.slength, _angle = _a._angle;
            if (this.visuals.line.doit) {
                var width = this.renderer.plot_view.frame._width.value;
                var height = this.renderer.plot_view.frame._height.value;
                var inf_len = 2 * (width + height);
                for (var i = 0, end = slength.length; i < end; i++) {
                    if (slength[i] === 0) {
                        slength[i] = inf_len;
                    }
                }
                for (var _i = 0, indices_1 = indices; _i < indices_1.length; _i++) {
                    var i = indices_1[_i];
                    if (isNaN(sx[i] + sy[i] + _angle[i] + slength[i])) {
                        continue;
                    }
                    ctx.translate(sx[i], sy[i]);
                    ctx.rotate(_angle[i]);
                    ctx.beginPath();
                    ctx.moveTo(0, 0);
                    ctx.lineTo(slength[i], 0);
                    this.visuals.line.set_vectorize(ctx, i);
                    ctx.stroke();
                    ctx.rotate(-_angle[i]);
                    ctx.translate(-sx[i], -sy[i]);
                }
            }
        };
        RayView.prototype.draw_legend_for_index = function (ctx, x0, x1, y0, y1, index) {
            return this._generic_line_legend(ctx, x0, x1, y0, y1, index);
        };
        return RayView;
    }(xy_glyph_1.XYGlyphView);
    exports.RayView = RayView;
    var Ray = function (_super) {
        tslib_1.__extends(Ray, _super);
        function Ray(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        Ray.initClass = function () {
            this.prototype.type = 'Ray';
            this.prototype.default_view = RayView;
            this.mixins(['line']);
            this.define({
                length: [p.DistanceSpec],
                angle: [p.AngleSpec]
            });
        };
        return Ray;
    }(xy_glyph_1.XYGlyph);
    exports.Ray = Ray;
    Ray.initClass();    
},
/*models/glyphs/rect*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    /* XXX: partial */
    var xy_glyph_1 = require(129    /* ./xy_glyph */);
    var hittest = require(9    /* core/hittest */);
    var p = require(15    /* core/properties */);
    var array_1 = require(22    /* core/util/array */);
    var RectView = function (_super) {
        tslib_1.__extends(RectView, _super);
        function RectView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        RectView.prototype._set_data = function () {
            this.max_w2 = 0;
            if (this.model.properties.width.units === 'data') {
                this.max_w2 = this.max_width / 2;
            }
            this.max_h2 = 0;
            if (this.model.properties.height.units === 'data') {
                return this.max_h2 = this.max_height / 2;
            }
        };
        RectView.prototype._map_data = function () {
            var _this = this;
            if (this.model.properties.width.units === 'data') {
                _a = this._map_dist_corner_for_data_side_length(this._x, this._width, this.renderer.xscale, 0), this.sw = _a[0], this.sx0 = _a[1];
            } else {
                this.sw = this._width;
                this.sx0 = function () {
                    var result = [];
                    for (var i = 0, end = _this.sx.length; i < end; i++) {
                        result.push(_this.sx[i] - _this.sw[i] / 2);
                    }
                    return result;
                }();
            }
            if (this.model.properties.height.units === 'data') {
                _b = this._map_dist_corner_for_data_side_length(this._y, this._height, this.renderer.yscale, 1), this.sh = _b[0], this.sy1 = _b[1];
            } else {
                this.sh = this._height;
                this.sy1 = function () {
                    var result = [];
                    for (var i = 0, end = _this.sy.length; i < end; i++) {
                        result.push(_this.sy[i] - _this.sh[i] / 2);
                    }
                    return result;
                }();
            }
            return this.ssemi_diag = function () {
                var result = [];
                for (var i = 0, end = _this.sw.length; i < end; i++) {
                    result.push(Math.sqrt(_this.sw[i] / 2 * _this.sw[i] / 2 + _this.sh[i] / 2 * _this.sh[i] / 2));
                }
                return result;
            }();
            var _a, _b;
        };
        RectView.prototype._render = function (ctx, indices, _a) {
            var sx = _a.sx, sy = _a.sy, sx0 = _a.sx0, sy1 = _a.sy1, sw = _a.sw, sh = _a.sh, _angle = _a._angle;
            if (this.visuals.fill.doit) {
                for (var _i = 0, indices_1 = indices; _i < indices_1.length; _i++) {
                    var i = indices_1[_i];
                    if (isNaN(sx[i] + sy[i] + sx0[i] + sy1[i] + sw[i] + sh[i] + _angle[i])) {
                        continue;
                    }
                    //no need to test the return value, we call fillRect for every glyph anyway
                    this.visuals.fill.set_vectorize(ctx, i);
                    if (_angle[i]) {
                        ctx.translate(sx[i], sy[i]);
                        ctx.rotate(_angle[i]);
                        ctx.fillRect(-sw[i] / 2, -sh[i] / 2, sw[i], sh[i]);
                        ctx.rotate(-_angle[i]);
                        ctx.translate(-sx[i], -sy[i]);
                    } else {
                        ctx.fillRect(sx0[i], sy1[i], sw[i], sh[i]);
                    }
                }
            }
            if (this.visuals.line.doit) {
                ctx.beginPath();
                for (var _b = 0, indices_2 = indices; _b < indices_2.length; _b++) {
                    var i = indices_2[_b];
                    if (isNaN(sx[i] + sy[i] + sx0[i] + sy1[i] + sw[i] + sh[i] + _angle[i])) {
                        continue;
                    }
                    // fillRect does not fill zero-height or -width rects, but rect(...)
                    // does seem to stroke them (1px wide or tall). Explicitly ignore rects
                    // with zero width or height to be consistent
                    if (sw[i] === 0 || sh[i] === 0) {
                        continue;
                    }
                    if (_angle[i]) {
                        ctx.translate(sx[i], sy[i]);
                        ctx.rotate(_angle[i]);
                        ctx.rect(-sw[i] / 2, -sh[i] / 2, sw[i], sh[i]);
                        ctx.rotate(-_angle[i]);
                        ctx.translate(-sx[i], -sy[i]);
                    } else {
                        ctx.rect(sx0[i], sy1[i], sw[i], sh[i]);
                    }
                    this.visuals.line.set_vectorize(ctx, i);
                    ctx.stroke();
                    ctx.beginPath();
                }
                return ctx.stroke();
            }
        };
        RectView.prototype._hit_rect = function (geometry) {
            return this._hit_rect_against_index(geometry);
        };
        RectView.prototype._hit_point = function (geometry) {
            var _this = this;
            var sx = geometry.sx, sy = geometry.sy;
            var x = this.renderer.xscale.invert(sx);
            var y = this.renderer.yscale.invert(sy);
            var scenter_x = function () {
                var result1 = [];
                for (var i = 0, end = _this.sx0.length; i < end; i++) {
                    result1.push(_this.sx0[i] + _this.sw[i] / 2);
                }
                return result1;
            }();
            var scenter_y = function () {
                var result2 = [];
                for (var i = 0, end = _this.sy1.length; i < end; i++) {
                    result2.push(_this.sy1[i] + _this.sh[i] / 2);
                }
                return result2;
            }();
            var max_x2_ddist = array_1.max(this._ddist(0, scenter_x, this.ssemi_diag));
            var max_y2_ddist = array_1.max(this._ddist(1, scenter_y, this.ssemi_diag));
            var x0 = x - max_x2_ddist;
            var x1 = x + max_x2_ddist;
            var y0 = y - max_y2_ddist;
            var y1 = y + max_y2_ddist;
            var hits = [];
            var bbox = hittest.validate_bbox_coords([
                x0,
                x1
            ], [
                y0,
                y1
            ]);
            for (var _i = 0, _a = this.index.indices(bbox); _i < _a.length; _i++) {
                var i = _a[_i];
                var height_in = void 0, width_in = void 0;
                if (this._angle[i]) {
                    var s = Math.sin(-this._angle[i]);
                    var c = Math.cos(-this._angle[i]);
                    var px = c * (sx - this.sx[i]) - s * (sy - this.sy[i]) + this.sx[i];
                    var py = s * (sx - this.sx[i]) + c * (sy - this.sy[i]) + this.sy[i];
                    sx = px;
                    sy = py;
                    width_in = Math.abs(this.sx[i] - sx) <= this.sw[i] / 2;
                    height_in = Math.abs(this.sy[i] - sy) <= this.sh[i] / 2;
                } else {
                    width_in = sx - this.sx0[i] <= this.sw[i] && sx - this.sx0[i] >= 0;
                    height_in = sy - this.sy1[i] <= this.sh[i] && sy - this.sy1[i] >= 0;
                }
                if (height_in && width_in) {
                    hits.push(i);
                }
            }
            var result = hittest.create_hit_test_result();
            result['1d'].indices = hits;
            return result;
        };
        RectView.prototype._map_dist_corner_for_data_side_length = function (coord, side_length, scale, dim) {
            var spt_corner;
            if (scale.source_range.synthetic != null) {
                coord = coord.map(function (x) {
                    return scale.source_range.synthetic(x);
                });
            }
            var pt0 = function () {
                var result = [];
                for (var i = 0, end = coord.length; i < end; i++) {
                    result.push(Number(coord[i]) - side_length[i] / 2);
                }
                return result;
            }();
            var pt1 = function () {
                var result = [];
                for (var i = 0, end = coord.length; i < end; i++) {
                    result.push(Number(coord[i]) + side_length[i] / 2);
                }
                return result;
            }();
            var spt0 = scale.v_compute(pt0);
            var spt1 = scale.v_compute(pt1);
            var sside_length = this.sdist(scale, pt0, side_length, 'edge', this.model.dilate);
            if (dim === 0) {
                spt_corner = spt0;
                for (var i = 0, end = spt0.length; i < end; i++) {
                    if (spt0[i] !== spt1[i]) {
                        spt_corner = spt0[i] < spt1[i] ? spt0 : spt1;
                        break;
                    }
                }
                return [
                    sside_length,
                    spt_corner
                ];
            } else if (dim === 1) {
                spt_corner = spt0;
                for (var i = 0, end = spt0.length; i < end; i++) {
                    if (spt0[i] !== spt1[i]) {
                        spt_corner = spt0[i] < spt1[i] ? spt0 : spt1;
                        break;
                    }
                }
                return [
                    sside_length,
                    spt_corner
                ];
            }
        };
        RectView.prototype._ddist = function (dim, spts, spans) {
            var scale;
            if (dim === 0) {
                scale = this.renderer.xscale;
            } else {
                scale = this.renderer.yscale;
            }
            var spt0 = spts;
            var spt1 = function () {
                var result = [];
                for (var i = 0, end = spt0.length; i < end; i++) {
                    result.push(spt0[i] + spans[i]);
                }
                return result;
            }();
            var pt0 = scale.v_invert(spt0);
            var pt1 = scale.v_invert(spt1);
            return function () {
                var result = [];
                for (var i = 0, end = pt0.length; i < end; i++) {
                    result.push(Math.abs(pt1[i] - pt0[i]));
                }
                return result;
            }();
        };
        RectView.prototype.draw_legend_for_index = function (ctx, x0, x1, y0, y1, index) {
            return this._generic_area_legend(ctx, x0, x1, y0, y1, index);
        };
        RectView.prototype._bounds = function (bds) {
            return this.max_wh2_bounds(bds);
        };
        return RectView;
    }(xy_glyph_1.XYGlyphView);
    exports.RectView = RectView;
    var Rect = function (_super) {
        tslib_1.__extends(Rect, _super);
        function Rect(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        Rect.initClass = function () {
            this.prototype.type = 'Rect';
            this.prototype.default_view = RectView;
            this.mixins([
                'line',
                'fill'
            ]);
            this.define({
                angle: [
                    p.AngleSpec,
                    0
                ],
                width: [p.DistanceSpec],
                height: [p.DistanceSpec],
                dilate: [
                    p.Bool,
                    false
                ]
            });
        };
        return Rect;
    }(xy_glyph_1.XYGlyph);
    exports.Rect = Rect;
    Rect.initClass();    
},
/*models/glyphs/segment*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    /* XXX: partial */
    var hittest = require(9    /* core/hittest */);
    var spatial_1 = require(37    /* core/util/spatial */);
    var glyph_1 = require(109    /* ./glyph */);
    var SegmentView = function (_super) {
        tslib_1.__extends(SegmentView, _super);
        function SegmentView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        SegmentView.prototype._index_data = function () {
            var points = [];
            for (var i = 0, end = this._x0.length; i < end; i++) {
                if (!isNaN(this._x0[i] + this._x1[i] + this._y0[i] + this._y1[i])) {
                    points.push({
                        minX: Math.min(this._x0[i], this._x1[i]),
                        minY: Math.min(this._y0[i], this._y1[i]),
                        maxX: Math.max(this._x0[i], this._x1[i]),
                        maxY: Math.max(this._y0[i], this._y1[i]),
                        i: i
                    });
                }
            }
            return new spatial_1.RBush(points);
        };
        SegmentView.prototype._render = function (ctx, indices, _a) {
            var sx0 = _a.sx0, sy0 = _a.sy0, sx1 = _a.sx1, sy1 = _a.sy1;
            if (this.visuals.line.doit) {
                for (var _i = 0, indices_1 = indices; _i < indices_1.length; _i++) {
                    var i = indices_1[_i];
                    if (isNaN(sx0[i] + sy0[i] + sx1[i] + sy1[i])) {
                        continue;
                    }
                    ctx.beginPath();
                    ctx.moveTo(sx0[i], sy0[i]);
                    ctx.lineTo(sx1[i], sy1[i]);
                    this.visuals.line.set_vectorize(ctx, i);
                    ctx.stroke();
                }
            }
        };
        SegmentView.prototype._hit_point = function (geometry) {
            var sx = geometry.sx, sy = geometry.sy;
            var point = {
                x: sx,
                y: sy
            };
            var hits = [];
            var lw_voffset = 2;
            // FIXME: Use maximum of segments line_width/2 instead of magic constant 2
            var _a = this.renderer.xscale.r_invert(sx - lw_voffset, sx + lw_voffset), minX = _a[0], maxX = _a[1];
            var _b = this.renderer.yscale.r_invert(sy - lw_voffset, sy + lw_voffset), minY = _b[0], maxY = _b[1];
            var candidates = this.index.indices({
                minX: minX,
                minY: minY,
                maxX: maxX,
                maxY: maxY
            });
            for (var _i = 0, candidates_1 = candidates; _i < candidates_1.length; _i++) {
                var i = candidates_1[_i];
                var threshold2 = Math.pow(Math.max(2, this.visuals.line.cache_select('line_width', i) / 2), 2);
                var _c = [
                        {
                            x: this.sx0[i],
                            y: this.sy0[i]
                        },
                        {
                            x: this.sx1[i],
                            y: this.sy1[i]
                        }
                    ], p0 = _c[0], p1 = _c[1];
                var dist2 = hittest.dist_to_segment_squared(point, p0, p1);
                if (dist2 < threshold2) {
                    hits.push(i);
                }
            }
            var result = hittest.create_hit_test_result();
            result['1d'].indices = hits;
            return result;
        };
        SegmentView.prototype._hit_span = function (geometry) {
            var v0, v1, val;
            var _a = this.renderer.plot_view.frame.bbox.ranges, hr = _a[0], vr = _a[1];
            var sx = geometry.sx, sy = geometry.sy;
            if (geometry.direction === 'v') {
                val = this.renderer.yscale.invert(sy);
                _b = [
                    this._y0,
                    this._y1
                ], v0 = _b[0], v1 = _b[1];
            } else {
                val = this.renderer.xscale.invert(sx);
                _c = [
                    this._x0,
                    this._x1
                ], v0 = _c[0], v1 = _c[1];
            }
            var hits = [];
            var _d = this.renderer.xscale.r_invert(hr.start, hr.end), minX = _d[0], maxX = _d[1];
            var _e = this.renderer.yscale.r_invert(vr.start, vr.end), minY = _e[0], maxY = _e[1];
            var candidates = this.index.indices({
                minX: minX,
                minY: minY,
                maxX: maxX,
                maxY: maxY
            });
            for (var _i = 0, candidates_2 = candidates; _i < candidates_2.length; _i++) {
                var i = candidates_2[_i];
                if (v0[i] <= val && val <= v1[i] || v1[i] <= val && val <= v0[i]) {
                    hits.push(i);
                }
            }
            var result = hittest.create_hit_test_result();
            result['1d'].indices = hits;
            return result;
            var _b, _c;
        };
        SegmentView.prototype.scx = function (i) {
            return (this.sx0[i] + this.sx1[i]) / 2;
        };
        SegmentView.prototype.scy = function (i) {
            return (this.sy0[i] + this.sy1[i]) / 2;
        };
        SegmentView.prototype.draw_legend_for_index = function (ctx, x0, x1, y0, y1, index) {
            return this._generic_line_legend(ctx, x0, x1, y0, y1, index);
        };
        return SegmentView;
    }(glyph_1.GlyphView);
    exports.SegmentView = SegmentView;
    var Segment = function (_super) {
        tslib_1.__extends(Segment, _super);
        function Segment(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        Segment.initClass = function () {
            this.prototype.type = 'Segment';
            this.prototype.default_view = SegmentView;
            this.coords([
                [
                    'x0',
                    'y0'
                ],
                [
                    'x1',
                    'y1'
                ]
            ]);
            this.mixins(['line']);
        };
        return Segment;
    }(glyph_1.Glyph);
    exports.Segment = Segment;
    Segment.initClass();    
},
/*models/glyphs/step*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    /* XXX: partial */
    var xy_glyph_1 = require(129    /* ./xy_glyph */);
    var p = require(15    /* core/properties */);
    var StepView = function (_super) {
        tslib_1.__extends(StepView, _super);
        function StepView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        StepView.prototype._render = function (ctx, indices, _a) {
            var sx = _a.sx, sy = _a.sy;
            this.visuals.line.set_value(ctx);
            var L = indices.length;
            if (L < 2) {
                return;
            }
            ctx.beginPath();
            ctx.moveTo(sx[0], sy[0]);
            for (var i = 1, end = L; i < end; i++) {
                var x1 = void 0, x2 = void 0, y1 = void 0, y2 = void 0;
                switch (this.model.mode) {
                case 'before': {
                        _b = [
                            sx[i - 1],
                            sy[i]
                        ], x1 = _b[0], y1 = _b[1];
                        _c = [
                            sx[i],
                            sy[i]
                        ], x2 = _c[0], y2 = _c[1];
                        break;
                    }
                case 'after': {
                        _d = [
                            sx[i],
                            sy[i - 1]
                        ], x1 = _d[0], y1 = _d[1];
                        _e = [
                            sx[i],
                            sy[i]
                        ], x2 = _e[0], y2 = _e[1];
                        break;
                    }
                case 'center': {
                        var xm = (sx[i - 1] + sx[i]) / 2;
                        _f = [
                            xm,
                            sy[i - 1]
                        ], x1 = _f[0], y1 = _f[1];
                        _g = [
                            xm,
                            sy[i]
                        ], x2 = _g[0], y2 = _g[1];
                        break;
                    }
                }
                ctx.lineTo(x1, y1);
                ctx.lineTo(x2, y2);
            }
            ctx.lineTo(sx[L - 1], sy[L - 1]);
            return ctx.stroke();
            var _b, _c, _d, _e, _f, _g;
        };
        StepView.prototype.draw_legend_for_index = function (ctx, x0, x1, y0, y1, index) {
            return this._generic_line_legend(ctx, x0, x1, y0, y1, index);
        };
        return StepView;
    }(xy_glyph_1.XYGlyphView);
    exports.StepView = StepView;
    var Step = function (_super) {
        tslib_1.__extends(Step, _super);
        function Step(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        Step.initClass = function () {
            this.prototype.type = 'Step';
            this.prototype.default_view = StepView;
            this.mixins(['line']);
            this.define({
                mode: [
                    p.StepMode,
                    'before'
                ]
            });
        };
        return Step;
    }(xy_glyph_1.XYGlyph);
    exports.Step = Step;
    Step.initClass();    
},
/*models/glyphs/text*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    /* XXX: partial */
    var xy_glyph_1 = require(129    /* ./xy_glyph */);
    var p = require(15    /* core/properties */);
    var text_1 = require(41    /* core/util/text */);
    var TextView = function (_super) {
        tslib_1.__extends(TextView, _super);
        function TextView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        TextView.prototype._render = function (ctx, indices, _a) {
            var sx = _a.sx, sy = _a.sy, _x_offset = _a._x_offset, _y_offset = _a._y_offset, _angle = _a._angle, _text = _a._text;
            for (var _i = 0, indices_1 = indices; _i < indices_1.length; _i++) {
                var i = indices_1[_i];
                if (isNaN(sx[i] + sy[i] + _x_offset[i] + _y_offset[i] + _angle[i]) || _text[i] == null) {
                    continue;
                }
                if (this.visuals.text.doit) {
                    var text = '' + _text[i];
                    ctx.save();
                    ctx.translate(sx[i] + _x_offset[i], sy[i] + _y_offset[i]);
                    ctx.rotate(_angle[i]);
                    this.visuals.text.set_vectorize(ctx, i);
                    if (text.indexOf('\n') === -1) {
                        ctx.fillText(text, 0, 0);
                    } else {
                        var lines = text.split('\n');
                        var font = this.visuals.text.cache_select('font', i);
                        var height = text_1.get_text_height(font).height;
                        var line_height = this.visuals.text.text_line_height.value() * height;
                        var block_height = line_height * lines.length;
                        var baseline = this.visuals.text.cache_select('text_baseline', i);
                        var y = void 0;
                        switch (baseline) {
                        case 'top': {
                                y = 0;
                                break;
                            }
                        case 'middle': {
                                y = -block_height / 2 + line_height / 2;
                                break;
                            }
                        case 'bottom': {
                                y = -block_height + line_height;
                                break;
                            }
                        default: {
                                y = 0;
                                console.warn('\'' + baseline + '\' baseline not supported with multi line text');
                            }
                        }
                        for (var _b = 0, lines_1 = lines; _b < lines_1.length; _b++) {
                            var line = lines_1[_b];
                            ctx.fillText(line, 0, y);
                            y += line_height;
                        }
                    }
                    ctx.restore();
                }
            }
        };
        TextView.prototype.draw_legend_for_index = function (_ctx, _x0, _x1, _y0, _y1, _index) {
            return null;
        };
        return TextView;
    }(xy_glyph_1.XYGlyphView);
    exports.TextView = TextView;
    var Text = function (_super) {
        tslib_1.__extends(Text, _super);
        function Text(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        Text.initClass = function () {
            this.prototype.type = 'Text';
            this.prototype.default_view = TextView;
            this.mixins(['text']);
            this.define({
                text: [
                    p.StringSpec,
                    { field: 'text' }
                ],
                angle: [
                    p.AngleSpec,
                    0
                ],
                x_offset: [
                    p.NumberSpec,
                    0
                ],
                y_offset: [
                    p.NumberSpec,
                    0
                ]
            });
        };
        return Text;
    }(xy_glyph_1.XYGlyph);
    exports.Text = Text;
    Text.initClass();    
},
/*models/glyphs/vbar*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    /* XXX: partial */
    var box_1 = require(106    /* ./box */);
    var p = require(15    /* core/properties */);
    var VBarView = function (_super) {
        tslib_1.__extends(VBarView, _super);
        function VBarView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        VBarView.prototype.scy = function (i) {
            return (this.stop[i] + this.sbottom[i]) / 2;
        };
        VBarView.prototype._index_data = function () {
            return this._index_box(this._x.length);
        };
        VBarView.prototype._lrtb = function (i) {
            var l = this._x[i] - this._width[i] / 2;
            var r = this._x[i] + this._width[i] / 2;
            var t = Math.max(this._top[i], this._bottom[i]);
            var b = Math.min(this._top[i], this._bottom[i]);
            return [
                l,
                r,
                t,
                b
            ];
        };
        VBarView.prototype._map_data = function () {
            this.sx = this.renderer.xscale.v_compute(this._x);
            this.stop = this.renderer.yscale.v_compute(this._top);
            this.sbottom = this.renderer.yscale.v_compute(this._bottom);
            this.sleft = [];
            this.sright = [];
            this.sw = this.sdist(this.renderer.xscale, this._x, this._width, 'center');
            for (var i = 0, end = this.sx.length; i < end; i++) {
                this.sleft.push(this.sx[i] - this.sw[i] / 2);
                this.sright.push(this.sx[i] + this.sw[i] / 2);
            }
            return null;
        };
        return VBarView;
    }(box_1.BoxView);
    exports.VBarView = VBarView;
    var VBar = function (_super) {
        tslib_1.__extends(VBar, _super);
        function VBar(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        VBar.initClass = function () {
            this.prototype.type = 'VBar';
            this.prototype.default_view = VBarView;
            this.coords([[
                    'x',
                    'bottom'
                ]]);
            this.define({
                width: [p.DistanceSpec],
                top: [p.NumberSpec]
            });
            this.override({ bottom: 0 });
        };
        return VBar;
    }(box_1.Box);
    exports.VBar = VBar;
    VBar.initClass();    
},
/*models/glyphs/wedge*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    /* XXX: partial */
    var xy_glyph_1 = require(129    /* ./xy_glyph */);
    var hittest = require(9    /* core/hittest */);
    var p = require(15    /* core/properties */);
    var math_1 = require(30    /* core/util/math */);
    var WedgeView = function (_super) {
        tslib_1.__extends(WedgeView, _super);
        function WedgeView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        WedgeView.prototype._map_data = function () {
            if (this.model.properties.radius.units === 'data') {
                return this.sradius = this.sdist(this.renderer.xscale, this._x, this._radius);
            } else {
                return this.sradius = this._radius;
            }
        };
        WedgeView.prototype._render = function (ctx, indices, _a) {
            var sx = _a.sx, sy = _a.sy, sradius = _a.sradius, _start_angle = _a._start_angle, _end_angle = _a._end_angle;
            var direction = this.model.properties.direction.value();
            for (var _i = 0, indices_1 = indices; _i < indices_1.length; _i++) {
                var i = indices_1[_i];
                if (isNaN(sx[i] + sy[i] + sradius[i] + _start_angle[i] + _end_angle[i])) {
                    continue;
                }
                ctx.beginPath();
                ctx.arc(sx[i], sy[i], sradius[i], _start_angle[i], _end_angle[i], direction);
                ctx.lineTo(sx[i], sy[i]);
                ctx.closePath();
                if (this.visuals.fill.doit) {
                    this.visuals.fill.set_vectorize(ctx, i);
                    ctx.fill();
                }
                if (this.visuals.line.doit) {
                    this.visuals.line.set_vectorize(ctx, i);
                    ctx.stroke();
                }
            }
        };
        WedgeView.prototype._hit_point = function (geometry) {
            var dist, sx0, sx1, sy0, sy1, x0, x1, y0, y1;
            var sx = geometry.sx, sy = geometry.sy;
            var x = this.renderer.xscale.invert(sx);
            var y = this.renderer.yscale.invert(sy);
            // check radius first
            if (this.model.properties.radius.units === 'data') {
                x0 = x - this.max_radius;
                x1 = x + this.max_radius;
                y0 = y - this.max_radius;
                y1 = y + this.max_radius;
            } else {
                sx0 = sx - this.max_radius;
                sx1 = sx + this.max_radius;
                _a = this.renderer.xscale.r_invert(sx0, sx1), x0 = _a[0], x1 = _a[1];
                sy0 = sy - this.max_radius;
                sy1 = sy + this.max_radius;
                _b = this.renderer.yscale.r_invert(sy0, sy1), y0 = _b[0], y1 = _b[1];
            }
            var candidates = [];
            var bbox = hittest.validate_bbox_coords([
                x0,
                x1
            ], [
                y0,
                y1
            ]);
            for (var _i = 0, _c = this.index.indices(bbox); _i < _c.length; _i++) {
                var i = _c[_i];
                var r2 = Math.pow(this.sradius[i], 2);
                _d = this.renderer.xscale.r_compute(x, this._x[i]), sx0 = _d[0], sx1 = _d[1];
                _e = this.renderer.yscale.r_compute(y, this._y[i]), sy0 = _e[0], sy1 = _e[1];
                dist = Math.pow(sx0 - sx1, 2) + Math.pow(sy0 - sy1, 2);
                if (dist <= r2) {
                    candidates.push([
                        i,
                        dist
                    ]);
                }
            }
            var direction = this.model.properties.direction.value();
            var hits = [];
            for (var _f = 0, candidates_1 = candidates; _f < candidates_1.length; _f++) {
                var _g = candidates_1[_f], i = _g[0], dist_1 = _g[1];
                // NOTE: minus the angle because JS uses non-mathy convention for angles
                var angle = Math.atan2(sy - this.sy[i], sx - this.sx[i]);
                if (math_1.angle_between(-angle, -this._start_angle[i], -this._end_angle[i], direction)) {
                    hits.push([
                        i,
                        dist_1
                    ]);
                }
            }
            return hittest.create_1d_hit_test_result(hits);
            var _a, _b, _d, _e;
        };
        WedgeView.prototype.draw_legend_for_index = function (ctx, x0, x1, y0, y1, index) {
            return this._generic_area_legend(ctx, x0, x1, y0, y1, index);
        };
        return WedgeView;
    }(xy_glyph_1.XYGlyphView);
    exports.WedgeView = WedgeView;
    var Wedge = function (_super) {
        tslib_1.__extends(Wedge, _super);
        function Wedge(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        Wedge.initClass = function () {
            this.prototype.type = 'Wedge';
            this.prototype.default_view = WedgeView;
            this.mixins([
                'line',
                'fill'
            ]);
            this.define({
                direction: [
                    p.Direction,
                    'anticlock'
                ],
                radius: [p.DistanceSpec],
                start_angle: [p.AngleSpec],
                end_angle: [p.AngleSpec]
            });
        };
        return Wedge;
    }(xy_glyph_1.XYGlyph);
    exports.Wedge = Wedge;
    Wedge.initClass();    
},
/*models/glyphs/xy_glyph*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    var spatial_1 = require(37    /* core/util/spatial */);
    var glyph_1 = require(109    /* ./glyph */);
    var XYGlyphView = function (_super) {
        tslib_1.__extends(XYGlyphView, _super);
        function XYGlyphView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        XYGlyphView.prototype._index_data = function () {
            var points = [];
            for (var i = 0, end = this._x.length; i < end; i++) {
                var x = this._x[i];
                var y = this._y[i];
                if (isNaN(x + y) || !isFinite(x + y)) {
                    continue;
                }
                points.push({
                    minX: x,
                    minY: y,
                    maxX: x,
                    maxY: y,
                    i: i
                });
            }
            return new spatial_1.RBush(points);
        };
        return XYGlyphView;
    }(glyph_1.GlyphView);
    exports.XYGlyphView = XYGlyphView;
    var XYGlyph = function (_super) {
        tslib_1.__extends(XYGlyph, _super);
        function XYGlyph(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        XYGlyph.initClass = function () {
            this.prototype.type = 'XYGlyph';
            this.prototype.default_view = XYGlyphView;
            this.coords([[
                    'x',
                    'y'
                ]]);
        };
        return XYGlyph;
    }(glyph_1.Glyph);
    exports.XYGlyph = XYGlyph;
    XYGlyph.initClass();    
},
/*models/graphs/graph_hit_test_policy*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    /* XXX: partial */
    var model_1 = require(51    /* ../../model */);
    var array_1 = require(22    /* core/util/array */);
    var hittest_1 = require(9    /* core/hittest */);
    var GraphHitTestPolicy = function (_super) {
        tslib_1.__extends(GraphHitTestPolicy, _super);
        function GraphHitTestPolicy() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        GraphHitTestPolicy.prototype.do_selection = function (_geometry, _graph_view, _final, _append) {
            return false;
        };
        GraphHitTestPolicy.prototype.do_inspection = function (_geometry, _graph_view, _final, _append) {
            return false;
        };
        return GraphHitTestPolicy;
    }(model_1.Model);
    exports.GraphHitTestPolicy = GraphHitTestPolicy;
    var NodesOnly = function (_super) {
        tslib_1.__extends(NodesOnly, _super);
        function NodesOnly() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        NodesOnly.initClass = function () {
            this.prototype.type = 'NodesOnly';
        };
        NodesOnly.prototype._do = function (geometry, graph_view, final, append) {
            var node_view = graph_view.node_view;
            var hit_test_result = node_view.glyph.hit_test(geometry);
            // glyphs that don't have hit-testing implemented will return null
            if (hit_test_result === null) {
                return false;
            }
            this._node_selector.update(hit_test_result, final, append);
            return !this._node_selector.indices.is_empty();
        };
        NodesOnly.prototype.do_selection = function (geometry, graph_view, final, append) {
            this._node_selector = graph_view.node_view.model.data_source.selection_manager.selector;
            var did_hit = this._do(geometry, graph_view, final, append);
            graph_view.node_view.model.data_source.selected = this._node_selector.indices;
            graph_view.node_view.model.data_source._select.emit();
            return did_hit;
        };
        NodesOnly.prototype.do_inspection = function (geometry, graph_view, final, append) {
            this._node_selector = graph_view.model.get_selection_manager().get_or_create_inspector(graph_view.node_view.model);
            var did_hit = this._do(geometry, graph_view, final, append);
            // silently set inspected attr to avoid triggering data_source.change event and rerender
            graph_view.node_view.model.data_source.setv({ inspected: this._node_selector.indices }, { silent: true });
            graph_view.node_view.model.data_source.inspect.emit([
                graph_view.node_view,
                { geometry: geometry }
            ]);
            return did_hit;
        };
        return NodesOnly;
    }(GraphHitTestPolicy);
    exports.NodesOnly = NodesOnly;
    NodesOnly.initClass();
    var NodesAndLinkedEdges = function (_super) {
        tslib_1.__extends(NodesAndLinkedEdges, _super);
        function NodesAndLinkedEdges() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        NodesAndLinkedEdges.initClass = function () {
            this.prototype.type = 'NodesAndLinkedEdges';
        };
        NodesAndLinkedEdges.prototype._do = function (geometry, graph_view, final, append) {
            var _a = [
                    graph_view.node_view,
                    graph_view.edge_view
                ], node_view = _a[0], edge_view = _a[1];
            var hit_test_result = node_view.glyph.hit_test(geometry);
            // glyphs that don't have hit-testing implemented will return null
            if (hit_test_result === null) {
                return false;
            }
            this._node_selector.update(hit_test_result, final, append);
            var node_indices = function () {
                var result = [];
                for (var _i = 0, _a = hit_test_result['1d'].indices; _i < _a.length; _i++) {
                    var i = _a[_i];
                    result.push(node_view.model.data_source.data.index[i]);
                }
                return result;
            }();
            var edge_source = edge_view.model.data_source;
            var edge_indices = [];
            for (var i = 0, end = edge_source.data.start.length; i < end; i++) {
                if (array_1.includes(node_indices, edge_source.data.start[i]) || array_1.includes(node_indices, edge_source.data.end[i])) {
                    edge_indices.push(i);
                }
            }
            var linked_index = hittest_1.create_hit_test_result();
            for (var _i = 0, edge_indices_1 = edge_indices; _i < edge_indices_1.length; _i++) {
                var i = edge_indices_1[_i];
                linked_index['2d'].indices[i] = [0];
            }
            //currently only supports 2-element multilines, so this is all of it
            this._edge_selector.update(linked_index, final, append);
            return !this._node_selector.indices.is_empty();
        };
        NodesAndLinkedEdges.prototype.do_selection = function (geometry, graph_view, final, append) {
            this._node_selector = graph_view.node_view.model.data_source.selection_manager.selector;
            this._edge_selector = graph_view.edge_view.model.data_source.selection_manager.selector;
            var did_hit = this._do(geometry, graph_view, final, append);
            graph_view.node_view.model.data_source.selected = this._node_selector.indices;
            graph_view.edge_view.model.data_source.selected = this._edge_selector.indices;
            graph_view.node_view.model.data_source._select.emit();
            return did_hit;
        };
        NodesAndLinkedEdges.prototype.do_inspection = function (geometry, graph_view, final, append) {
            this._node_selector = graph_view.node_view.model.data_source.selection_manager.get_or_create_inspector(graph_view.node_view.model);
            this._edge_selector = graph_view.edge_view.model.data_source.selection_manager.get_or_create_inspector(graph_view.edge_view.model);
            var did_hit = this._do(geometry, graph_view, final, append);
            // silently set inspected attr to avoid triggering data_source.change event and rerender
            graph_view.node_view.model.data_source.setv({ inspected: this._node_selector.indices }, { silent: true });
            graph_view.edge_view.model.data_source.setv({ inspected: this._edge_selector.indices }, { silent: true });
            graph_view.node_view.model.data_source.inspect.emit([
                graph_view.node_view,
                { geometry: geometry }
            ]);
            return did_hit;
        };
        return NodesAndLinkedEdges;
    }(GraphHitTestPolicy);
    exports.NodesAndLinkedEdges = NodesAndLinkedEdges;
    NodesAndLinkedEdges.initClass();
    var EdgesAndLinkedNodes = function (_super) {
        tslib_1.__extends(EdgesAndLinkedNodes, _super);
        function EdgesAndLinkedNodes() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        EdgesAndLinkedNodes.initClass = function () {
            this.prototype.type = 'EdgesAndLinkedNodes';
        };
        EdgesAndLinkedNodes.prototype._do = function (geometry, graph_view, final, append) {
            var _a = [
                    graph_view.node_view,
                    graph_view.edge_view
                ], node_view = _a[0], edge_view = _a[1];
            var hit_test_result = edge_view.glyph.hit_test(geometry);
            // glyphs that don't have hit-testing implemented will return null
            if (hit_test_result === null) {
                return false;
            }
            this._edge_selector.update(hit_test_result, final, append);
            var edge_indices = function () {
                var result = [];
                for (var _i = 0, _a = Object.keys(hit_test_result['2d'].indices); _i < _a.length; _i++) {
                    var i = _a[_i];
                    result.push(parseInt(i));
                }
                return result;
            }();
            var nodes = [];
            for (var _i = 0, edge_indices_2 = edge_indices; _i < edge_indices_2.length; _i++) {
                var i = edge_indices_2[_i];
                nodes.push(edge_view.model.data_source.data.start[i]);
                nodes.push(edge_view.model.data_source.data.end[i]);
            }
            var node_indices = function () {
                var result = [];
                for (var _i = 0, _a = array_1.uniq(nodes); _i < _a.length; _i++) {
                    var i = _a[_i];
                    result.push(node_view.model.data_source.data.index.indexOf(i));
                }
                return result;
            }();
            var node_hit_test_result = hittest_1.create_hit_test_result();
            node_hit_test_result['1d'].indices = node_indices;
            this._node_selector.update(node_hit_test_result, final, append);
            return !this._edge_selector.indices.is_empty();
        };
        EdgesAndLinkedNodes.prototype.do_selection = function (geometry, graph_view, final, append) {
            this._edge_selector = graph_view.edge_view.model.data_source.selection_manager.selector;
            this._node_selector = graph_view.node_view.model.data_source.selection_manager.selector;
            var did_hit = this._do(geometry, graph_view, final, append);
            graph_view.edge_view.model.data_source.selected = this._edge_selector.indices;
            graph_view.node_view.model.data_source.selected = this._node_selector.indices;
            graph_view.edge_view.model.data_source._select.emit();
            return did_hit;
        };
        EdgesAndLinkedNodes.prototype.do_inspection = function (geometry, graph_view, final, append) {
            this._edge_selector = graph_view.edge_view.model.data_source.selection_manager.get_or_create_inspector(graph_view.edge_view.model);
            this._node_selector = graph_view.node_view.model.data_source.selection_manager.get_or_create_inspector(graph_view.node_view.model);
            var did_hit = this._do(geometry, graph_view, final, append);
            // silently set inspected attr to avoid triggering data_source.change event and rerender
            graph_view.edge_view.model.data_source.setv({ inspected: this._edge_selector.indices }, { silent: true });
            graph_view.node_view.model.data_source.setv({ inspected: this._node_selector.indices }, { silent: true });
            graph_view.edge_view.model.data_source.inspect.emit([
                graph_view.edge_view,
                { geometry: geometry }
            ]);
            return did_hit;
        };
        return EdgesAndLinkedNodes;
    }(GraphHitTestPolicy);
    exports.EdgesAndLinkedNodes = EdgesAndLinkedNodes;
    EdgesAndLinkedNodes.initClass();    
},
/*models/graphs/index*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    tslib_1.__exportStar(require(130    /* ./graph_hit_test_policy */), exports);
    tslib_1.__exportStar(require(132    /* ./layout_provider */), exports);
    tslib_1.__exportStar(require(133    /* ./static_layout_provider */), exports);    
},
/*models/graphs/layout_provider*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    /* XXX: partial */
    var model_1 = require(51    /* ../../model */);
    var LayoutProvider = function (_super) {
        tslib_1.__extends(LayoutProvider, _super);
        function LayoutProvider(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        LayoutProvider.initClass = function () {
            this.prototype.type = 'LayoutProvider';
        };
        LayoutProvider.prototype.get_node_coordinates = function (_graph_source) {
            // this is implemented by base classes
            return [
                [],
                []
            ];
        };
        LayoutProvider.prototype.get_edge_coordinates = function (_graph_source) {
            // this is implemented by base classes
            return [
                [],
                []
            ];
        };
        return LayoutProvider;
    }(model_1.Model);
    exports.LayoutProvider = LayoutProvider;
    LayoutProvider.initClass();    
},
/*models/graphs/static_layout_provider*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    /* XXX: partial */
    var layout_provider_1 = require(132    /* ./layout_provider */);
    var p = require(15    /* ../../core/properties */);
    var StaticLayoutProvider = function (_super) {
        tslib_1.__extends(StaticLayoutProvider, _super);
        function StaticLayoutProvider(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        StaticLayoutProvider.initClass = function () {
            this.prototype.type = 'StaticLayoutProvider';
            this.define({
                graph_layout: [
                    p.Any,
                    {}
                ]
            });
        };
        StaticLayoutProvider.prototype.get_node_coordinates = function (node_source) {
            var _a = [
                    [],
                    []
                ], xs = _a[0], ys = _a[1];
            for (var _i = 0, _b = node_source.data.index; _i < _b.length; _i++) {
                var i = _b[_i];
                var x = this.graph_layout[i] != null ? this.graph_layout[i][0] : NaN;
                var y = this.graph_layout[i] != null ? this.graph_layout[i][1] : NaN;
                xs.push(x);
                ys.push(y);
            }
            return [
                xs,
                ys
            ];
        };
        StaticLayoutProvider.prototype.get_edge_coordinates = function (edge_source) {
            var _a = [
                    [],
                    []
                ], xs = _a[0], ys = _a[1];
            var starts = edge_source.data.start;
            var ends = edge_source.data.end;
            var has_paths = edge_source.data.xs != null && edge_source.data.ys != null;
            for (var i = 0, endi = starts.length; i < endi; i++) {
                var in_layout = this.graph_layout[starts[i]] != null && this.graph_layout[ends[i]] != null;
                if (has_paths && in_layout) {
                    xs.push(edge_source.data.xs[i]);
                    ys.push(edge_source.data.ys[i]);
                } else {
                    var end = void 0, start = void 0;
                    if (in_layout) {
                        _b = [
                            this.graph_layout[starts[i]],
                            this.graph_layout[ends[i]]
                        ], start = _b[0], end = _b[1];
                    } else {
                        _c = [
                            [
                                NaN,
                                NaN
                            ],
                            [
                                NaN,
                                NaN
                            ]
                        ], start = _c[0], end = _c[1];
                    }
                    xs.push([
                        start[0],
                        end[0]
                    ]);
                    ys.push([
                        start[1],
                        end[1]
                    ]);
                }
            }
            return [
                xs,
                ys
            ];
            var _b, _c;
        };
        return StaticLayoutProvider;
    }(layout_provider_1.LayoutProvider);
    exports.StaticLayoutProvider = StaticLayoutProvider;
    StaticLayoutProvider.initClass();    
},
/*models/grids/grid*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    var guide_renderer_1 = require(164    /* ../renderers/guide_renderer */);
    var p = require(15    /* core/properties */);
    var types_1 = require(43    /* core/util/types */);
    var GridView = function (_super) {
        tslib_1.__extends(GridView, _super);
        function GridView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        Object.defineProperty(GridView.prototype, '_x_range_name', {
            get: function () {
                return this.model.x_range_name;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(GridView.prototype, '_y_range_name', {
            get: function () {
                return this.model.y_range_name;
            },
            enumerable: true,
            configurable: true
        });
        GridView.prototype.render = function () {
            if (!this.model.visible)
                return;
            var ctx = this.plot_view.canvas_view.ctx;
            ctx.save();
            this._draw_regions(ctx);
            this._draw_minor_grids(ctx);
            this._draw_grids(ctx);
            ctx.restore();
        };
        GridView.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            this.connect(this.model.change, function () {
                return _this.request_render();
            });
        };
        GridView.prototype._draw_regions = function (ctx) {
            if (!this.visuals.band_fill.doit)
                return;
            var _a = this.model.grid_coords('major', false), xs = _a[0], ys = _a[1];
            this.visuals.band_fill.set_value(ctx);
            for (var i = 0; i < xs.length - 1; i++) {
                if (i % 2 == 1) {
                    var _b = this.plot_view.map_to_screen(xs[i], ys[i], this._x_range_name, this._y_range_name), sx0 = _b[0], sy0 = _b[1];
                    var _c = this.plot_view.map_to_screen(xs[i + 1], ys[i + 1], this._x_range_name, this._y_range_name), sx1 = _c[0], sy1 = _c[1];
                    ctx.fillRect(sx0[0], sy0[0], sx1[1] - sx0[0], sy1[1] - sy0[0]);
                    ctx.fill();
                }
            }
        };
        GridView.prototype._draw_grids = function (ctx) {
            if (!this.visuals.grid_line.doit)
                return;
            var _a = this.model.grid_coords('major'), xs = _a[0], ys = _a[1];
            this._draw_grid_helper(ctx, this.visuals.grid_line, xs, ys);
        };
        GridView.prototype._draw_minor_grids = function (ctx) {
            if (!this.visuals.minor_grid_line.doit)
                return;
            var _a = this.model.grid_coords('minor'), xs = _a[0], ys = _a[1];
            this._draw_grid_helper(ctx, this.visuals.minor_grid_line, xs, ys);
        };
        GridView.prototype._draw_grid_helper = function (ctx, visuals, xs, ys) {
            visuals.set_value(ctx);
            for (var i = 0; i < xs.length; i++) {
                var _a = this.plot_view.map_to_screen(xs[i], ys[i], this._x_range_name, this._y_range_name), sx = _a[0], sy = _a[1];
                ctx.beginPath();
                ctx.moveTo(Math.round(sx[0]), Math.round(sy[0]));
                for (var i_1 = 1; i_1 < sx.length; i_1++)
                    ctx.lineTo(Math.round(sx[i_1]), Math.round(sy[i_1]));
                ctx.stroke();
            }
        };
        return GridView;
    }(guide_renderer_1.GuideRendererView);
    exports.GridView = GridView;
    var Grid = function (_super) {
        tslib_1.__extends(Grid, _super);
        function Grid(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        Grid.initClass = function () {
            this.prototype.type = 'Grid';
            this.prototype.default_view = GridView;
            this.mixins([
                'line:grid_',
                'line:minor_grid_',
                'fill:band_'
            ]);
            this.define({
                bounds: [
                    p.Any,
                    'auto'
                ],
                dimension: [
                    p.Number,
                    0
                ],
                ticker: [p.Instance],
                x_range_name: [
                    p.String,
                    'default'
                ],
                y_range_name: [
                    p.String,
                    'default'
                ]
            });
            this.override({
                level: 'underlay',
                band_fill_color: null,
                band_fill_alpha: 0,
                grid_line_color: '#e5e5e5',
                minor_grid_line_color: null
            });
        };
        Grid.prototype.ranges = function () {
            var i = this.dimension;
            var j = (i + 1) % 2;
            var frame = this.plot.plot_canvas.frame;
            var ranges = [
                frame.x_ranges[this.x_range_name],
                frame.y_ranges[this.y_range_name]
            ];
            return [
                ranges[i],
                ranges[j]
            ];
        };
        Grid.prototype.computed_bounds = function () {
            var range = this.ranges()[0];
            var user_bounds = this.bounds;
            var range_bounds = [
                range.min,
                range.max
            ];
            var start;
            var end;
            if (types_1.isArray(user_bounds)) {
                start = Math.min(user_bounds[0], user_bounds[1]);
                end = Math.max(user_bounds[0], user_bounds[1]);
                if (start < range_bounds[0])
                    start = range_bounds[0];
                // XXX:
                //else if (start > range_bounds[1])
                //  start = null
                if (end > range_bounds[1])
                    end = range_bounds[1];    // XXX:
                                              //else if (end < range_bounds[0])
                                              //  end = null
            } else {
                start = range_bounds[0], end = range_bounds[1];
            }
            return [
                start,
                end
            ];
        };
        Grid.prototype.grid_coords = function (location, exclude_ends) {
            if (exclude_ends === void 0) {
                exclude_ends = true;
            }
            var i = this.dimension;
            var j = (i + 1) % 2;
            var _a = this.ranges(), range = _a[0], cross_range = _a[1];
            var _b = this.computed_bounds(), start = _b[0], end = _b[1];
            _c = [
                Math.min(start, end),
                Math.max(start, end)
            ], start = _c[0], end = _c[1];
            // TODO: (bev) using cross_range.min for cross_loc is a bit of a cheat. Since we
            // currently only support "straight line" grids, this should be OK for now. If
            // we ever want to support "curved" grids, e.g. for some projections, we may
            // have to communicate more than just a single cross location.
            var ticks = this.ticker.get_ticks(start, end, range, cross_range.min, {})[location];
            var min = range.min;
            var max = range.max;
            var cmin = cross_range.min;
            var cmax = cross_range.max;
            var coords = [
                [],
                []
            ];
            for (var ii = 0; ii < ticks.length; ii++) {
                if ((ticks[ii] == min || ticks[ii] == max) && exclude_ends)
                    continue;
                var dim_i = [];
                var dim_j = [];
                var N = 2;
                for (var n = 0; n < N; n++) {
                    var loc = cmin + (cmax - cmin) / (N - 1) * n;
                    dim_i.push(ticks[ii]);
                    dim_j.push(loc);
                }
                coords[i].push(dim_i);
                coords[j].push(dim_j);
            }
            return coords;
            var _c;
        };
        return Grid;
    }(guide_renderer_1.GuideRenderer);
    exports.Grid = Grid;
    Grid.initClass();    
},
/*models/grids/index*/
function _(require, module, exports) {
    var grid_1 = require(134    /* ./grid */);
    exports.Grid = grid_1.Grid;    
},
/*models/index*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    tslib_1.__exportStar(require(58    /* ./annotations */), exports);
    tslib_1.__exportStar(require(74    /* ./axes */), exports);
    tslib_1.__exportStar(require(78    /* ./callbacks */), exports);
    tslib_1.__exportStar(require(82    /* ./canvas */), exports);
    tslib_1.__exportStar(require(84    /* ./expressions */), exports);
    tslib_1.__exportStar(require(90    /* ./filters */), exports);
    tslib_1.__exportStar(require(96    /* ./formatters */), exports);
    tslib_1.__exportStar(require(114    /* ./glyphs */), exports);
    tslib_1.__exportStar(require(131    /* ./graphs */), exports);
    tslib_1.__exportStar(require(135    /* ./grids */), exports);
    tslib_1.__exportStar(require(139    /* ./layouts */), exports);
    tslib_1.__exportStar(require(146    /* ./mappers */), exports);
    tslib_1.__exportStar(require(243    /* ./transforms */), exports);
    tslib_1.__exportStar(require(149    /* ./markers */), exports);
    tslib_1.__exportStar(require(153    /* ./plots */), exports);
    tslib_1.__exportStar(require(159    /* ./ranges */), exports);
    tslib_1.__exportStar(require(165    /* ./renderers */), exports);
    tslib_1.__exportStar(require(168    /* ./scales */), exports);
    tslib_1.__exportStar(require(178    /* ./sources */), exports);
    tslib_1.__exportStar(require(188    /* ./tickers */), exports);
    tslib_1.__exportStar(require(199    /* ./tiles */), exports);
    tslib_1.__exportStar(require(231    /* ./tools */), exports);    
},
/*models/layouts/box*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    var solver_1 = require(13    /* core/layout/solver */);
    var p = require(15    /* core/properties */);
    var array_1 = require(22    /* core/util/array */);
    var object_1 = require(31    /* core/util/object */);
    var layout_dom_1 = require(140    /* ./layout_dom */);
    var BoxView = function (_super) {
        tslib_1.__extends(BoxView, _super);
        function BoxView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        BoxView.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            this.connect(this.model.properties.children.change, function () {
                return _this.rebuild_child_views();
            });
        };
        BoxView.prototype.css_classes = function () {
            return _super.prototype.css_classes.call(this).concat('bk-grid');
        };
        BoxView.prototype.get_height = function () {
            var children = this.model.get_layoutable_children();
            var child_heights = children.map(function (child) {
                return child._height.value;
            });
            var height;
            if (this.model._horizontal)
                height = array_1.max(child_heights);
            else
                height = array_1.sum(child_heights);
            return height;
        };
        BoxView.prototype.get_width = function () {
            var children = this.model.get_layoutable_children();
            var child_widths = children.map(function (child) {
                return child._width.value;
            });
            var width;
            if (this.model._horizontal)
                width = array_1.sum(child_widths);
            else
                width = array_1.max(child_widths);
            return width;
        };
        return BoxView;
    }(layout_dom_1.LayoutDOMView);
    exports.BoxView = BoxView;
    var Box = function (_super) {
        tslib_1.__extends(Box, _super);
        function Box(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        Box.initClass = function () {
            this.prototype.type = 'Box';
            this.prototype.default_view = BoxView;
            this.define({
                children: [
                    p.Array,
                    []
                ]
            });
            this.internal({
                spacing: [
                    p.Number,
                    6
                ]
            });
        };
        Box.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            this._child_equal_size_width = new solver_1.Variable(this.toString() + '.child_equal_size_width');
            this._child_equal_size_height = new solver_1.Variable(this.toString() + '.child_equal_size_height');
            this._box_equal_size_top = new solver_1.Variable(this.toString() + '.box_equal_size_top');
            this._box_equal_size_bottom = new solver_1.Variable(this.toString() + '.box_equal_size_bottom');
            this._box_equal_size_left = new solver_1.Variable(this.toString() + '.box_equal_size_left');
            this._box_equal_size_right = new solver_1.Variable(this.toString() + '.box_equal_size_right');
            this._box_cell_align_top = new solver_1.Variable(this.toString() + '.box_cell_align_top');
            this._box_cell_align_bottom = new solver_1.Variable(this.toString() + '.box_cell_align_bottom');
            this._box_cell_align_left = new solver_1.Variable(this.toString() + '.box_cell_align_left');
            this._box_cell_align_right = new solver_1.Variable(this.toString() + '.box_cell_align_right');
        };
        Box.prototype.get_layoutable_children = function () {
            return this.children;
        };
        Box.prototype.get_constrained_variables = function () {
            return object_1.extend({}, _super.prototype.get_constrained_variables.call(this), {
                box_equal_size_top: this._box_equal_size_top,
                box_equal_size_bottom: this._box_equal_size_bottom,
                box_equal_size_left: this._box_equal_size_left,
                box_equal_size_right: this._box_equal_size_right,
                box_cell_align_top: this._box_cell_align_top,
                box_cell_align_bottom: this._box_cell_align_bottom,
                box_cell_align_left: this._box_cell_align_left,
                box_cell_align_right: this._box_cell_align_right
            });
        };
        Box.prototype.get_constraints = function () {
            var constraints = _super.prototype.get_constraints.call(this);
            var add = function () {
                var new_constraints = [];
                for (var _i = 0; _i < arguments.length; _i++) {
                    new_constraints[_i] = arguments[_i];
                }
                constraints.push.apply(constraints, new_constraints);
            };
            var children = this.get_layoutable_children();
            if (children.length == 0)
                // No need to continue further if there are no children. Children sure do
                // make life a lot more complicated.
                return constraints;
            for (var _i = 0, children_1 = children; _i < children_1.length; _i++) {
                var child = children_1[_i];
                var vars_1 = child.get_constrained_variables();
                // Make total widget sizes fill the orthogonal direction
                // TODO(bird) Can't we make this shorter by using span which has already picked a
                // dominant direction (we'd just also need to set a doc_span)
                var rect = this._child_rect(vars_1);
                if (this._horizontal) {
                    if (vars_1.height != null)
                        add(solver_1.EQ(rect.height, [
                            -1,
                            this._height
                        ]));
                } else {
                    if (vars_1.width != null)
                        add(solver_1.EQ(rect.width, [
                            -1,
                            this._width
                        ]));
                }
                // Add equal_size constraint
                // - A child's "interesting area" (like the plot area) is the same size as the previous child
                //   (a child can opt out of this by not returning the box_equal_size variables)
                if (this._horizontal) {
                    if (vars_1.box_equal_size_left != null && vars_1.box_equal_size_right != null && vars_1.width != null)
                        add(solver_1.EQ([
                            -1,
                            vars_1.box_equal_size_left
                        ], [
                            -1,
                            vars_1.box_equal_size_right
                        ], vars_1.width, this._child_equal_size_width));
                } else {
                    if (vars_1.box_equal_size_top != null && vars_1.box_equal_size_bottom != null && vars_1.height != null)
                        add(solver_1.EQ([
                            -1,
                            vars_1.box_equal_size_top
                        ], [
                            -1,
                            vars_1.box_equal_size_bottom
                        ], vars_1.height, this._child_equal_size_height));
                }
            }
            // TODO(bird) - This is the second time we loop through children
            var last = this._info(children[0].get_constrained_variables());
            add(solver_1.EQ(last.span.start, 0));
            for (var i = 1; i < children.length; i++) {
                var next = this._info(children[i].get_constrained_variables());
                // Each child's start equals the previous child's end (unless we have a fixed layout
                // in which case size may not be available)
                if (last.span.size)
                    add(solver_1.EQ(last.span.start, last.span.size, [
                        -1,
                        next.span.start
                    ]));
                // The whitespace at end of one child + start of next must equal the box spacing.
                // This must be a weak constraint because it can conflict with aligning the
                // alignable edges in each child. Alignment is generally more important visually than spacing.
                add(solver_1.WEAK_EQ(last.whitespace.after, next.whitespace.before, 0 - this.spacing));
                // If we can't satisfy the whitespace being equal to box spacing, we should fix
                // it (align things) by increasing rather than decreasing the whitespace.
                add(solver_1.GE(last.whitespace.after, next.whitespace.before, 0 - this.spacing));
                last = next;
            }
            // Child's side has to stick to the end of the box
            var vars = children[children.length - 1].get_constrained_variables();
            if (this._horizontal) {
                if (vars.width != null)
                    add(solver_1.EQ(last.span.start, last.span.size, [
                        -1,
                        this._width
                    ]));
            } else {
                if (vars.height != null)
                    add(solver_1.EQ(last.span.start, last.span.size, [
                        -1,
                        this._height
                    ]));
            }
            constraints = constraints.concat(// align outermost edges in both dimensions
            this._align_outer_edges_constraints(true), // horizontal=true
            this._align_outer_edges_constraints(false), // line up edges in same_arity boxes
            this._align_inner_cell_edges_constraints(), // build our equal_size bounds from the child ones
            this._box_equal_size_bounds(true), // horizontal=true
            this._box_equal_size_bounds(false), // propagate cell alignment (between same_arity boxes) up the hierarchy
            this._box_cell_align_bounds(true), // horizontal=true
            this._box_cell_align_bounds(false), // build our whitespace from the child ones
            this._box_whitespace(true), // horizontal=true
            this._box_whitespace(false));
            return constraints;
        };
        Box.prototype._child_rect = function (vars) {
            return {
                x: vars.origin_x,
                y: vars.origin_y,
                width: vars.width,
                height: vars.height
            };
        };
        Box.prototype._span = function (rect) {
            // return [coordinate, size] pair in box_aligned direction
            if (this._horizontal)
                return {
                    start: rect.x,
                    size: rect.width
                };
            else
                return {
                    start: rect.y,
                    size: rect.height
                };
        };
        Box.prototype._info = function (vars) {
            var whitespace;
            if (this._horizontal)
                whitespace = {
                    before: vars.whitespace_left,
                    after: vars.whitespace_right
                };
            else
                whitespace = {
                    before: vars.whitespace_top,
                    after: vars.whitespace_bottom
                };
            var span = this._span(this._child_rect(vars));
            return {
                span: span,
                whitespace: whitespace
            };
        };
        Box.prototype._flatten_cell_edge_variables = function (horizontal) {
            /*
         * All alignment happens in terms of the
         * box_cell_align_{left,right,top,bottom} variables. We add
         * "path" information to variables so we know which ones align,
         * where the "path" includes the box arity and box cell we went
         * through.
         *
         * If we have a row of three plots, we should align the top and
         * bottom variables between the three plots.
         *
         * The flattened dictionary in this case (for the top and left
         * only) should be:
         *
         *   box_cell_align_top : [ 3 vars ]
         *   box_cell_align_bottom : [ 3 vars ]
         *
         * We don't do left/right starting from a row, and left/right
         * edges have nothing to align with here.
         *
         * Now say we have a row of three columns, each with three
         * plots (3x3 = 9). We should align the top/bottom variables
         * across the top three, middle three, and bottom three plots,
         * as if those groupings were rows. We do this by flattening
         * starting from the row first, which gets us a dictionary only
         * of top/bottom variables.
         *
         *   box_cell_align_top col-3-0- : [ 3 plots from top of columns ]
         *   box_cell_align_top col-3-1- : [ 3 plots from middle of columns ]
         *   box_cell_align_top col-3-2- : [ 3 plots from bottom of columns ]
         *
         * "col-3-1-" = 3-cell column, cell index 1.
         *
         * In three later, separate calls to
         * _align_inner_cell_edges_constraints() on each column, we'll
         * get the left/right variables:
         *
         *   box_cell_align_left : [ 3 left-column plots ]
         *   box_cell_align_left : [ 3 middle-column plots ]
         *   box_cell_align_left : [ 3 right-column plots ]
         *
         * Now add another nesting - we have a row of three columns,
         * each with three rows, each with three plots. This is
         * arranged 3x9 = 27.
         *
         *   box_cell_align_top col-3-0- : [ 9 plots from top rows of columns ]
         *   box_cell_align_top col-3-1- : [ 9 plots from middle rows of columns ]
         *   box_cell_align_top col-3-2- : [ 9 plots from bottom rows of columns ]
         *
         * When we make the _align_inner_cell_edges_constraints() calls on each of the three
         * columns, each column will return row-pathed values
         *
         *   box_cell_align_left row-3-0-: [  3 plots in left column of left column ]
         *   box_cell_align_left row-3-1-: [  3 plots in middle column of left column ]
         *   box_cell_align_left row-3-2-: [  3 plots in right column of left column ]
         *   ... same for the middle and right columns
         *
         * Anyway in essence what we do is that we add only rows to the
         * path to left/right variables, and only columns to the path
         * to top/bottom variables.
         *
         * If we nest yet another level we would finally get paths with
         * multiple rows or multiple columns in them.
         */
            var relevant_edges;
            if (horizontal)
                relevant_edges = Box._top_bottom_inner_cell_edge_variables;
            else
                relevant_edges = Box._left_right_inner_cell_edge_variables;
            var add_path = horizontal != this._horizontal;
            var children = this.get_layoutable_children();
            var arity = children.length;
            var flattened = {};
            var cell = 0;
            for (var _i = 0, children_2 = children; _i < children_2.length; _i++) {
                var child = children_2[_i];
                var cell_vars = void 0;
                if (child instanceof Box)
                    cell_vars = child._flatten_cell_edge_variables(horizontal);
                else
                    cell_vars = {};
                var all_vars = child.get_constrained_variables();
                for (var _a = 0, relevant_edges_1 = relevant_edges; _a < relevant_edges_1.length; _a++) {
                    var name_1 = relevant_edges_1[_a];
                    if (name_1 in all_vars)
                        cell_vars[name_1] = [all_vars[name_1]];
                }
                for (var key in cell_vars) {
                    var variables = cell_vars[key];
                    var new_key = void 0;
                    if (add_path) {
                        var parsed = key.split(' ');
                        var kind = parsed[0];
                        var path = parsed.length > 1 ? parsed[1] : '';
                        var direction = this._horizontal ? 'row' : 'col';
                        // TODO should we "ignore" arity-1 boxes potentially by not adding a path suffix?
                        new_key = kind + ' ' + direction + '-' + arity + '-' + cell + '-' + path;
                    } else
                        new_key = key;
                    if (new_key in flattened)
                        flattened[new_key] = flattened[new_key].concat(variables);
                    else
                        flattened[new_key] = variables;
                }
                cell++;
            }
            return flattened;
        };
        // This should only be called on the toplevel box (twice,
        // once with horizontal=true and once with horizontal=false)
        Box.prototype._align_inner_cell_edges_constraints = function () {
            var constraints = [];
            // XXX: checking for `this.document?` is a temporary hack, because document isn't always
            // attached properly. However, if document is not attached then we know it can't be
            // a root, because otherwise add_root() would attach it. All this layout logic should
            // be part of views instead of models and use is_root, etc.
            if (this.document != null && array_1.includes(this.document.roots(), this)) {
                var flattened = this._flatten_cell_edge_variables(this._horizontal);
                for (var key in flattened) {
                    var variables = flattened[key];
                    if (variables.length > 1) {
                        //console.log("constraining ", key, " ", variables)
                        var last = variables[0];
                        for (var i = 1; i < variables.length; i++)
                            constraints.push(solver_1.EQ(variables[i], [
                                -1,
                                last
                            ]));
                    }
                }
            }
            return constraints;
        };
        // returns a two-item array where each item is a list of edge
        // children from the start and end respectively
        Box.prototype._find_edge_leaves = function (horizontal) {
            var children = this.get_layoutable_children();
            // console.log(`  finding edge leaves in ${children.length}-${this.type}, ` +
            //  `our orientation ${this._horizontal} finding ${horizontal} children `, children)
            var leaves = [
                [],
                []
            ];
            if (children.length > 0) {
                if (this._horizontal == horizontal) {
                    // note start and end may be the same
                    var start = children[0];
                    var end = children[children.length - 1];
                    if (start instanceof Box)
                        leaves[0] = leaves[0].concat(start._find_edge_leaves(horizontal)[0]);
                    else
                        leaves[0].push(start);
                    if (end instanceof Box)
                        leaves[1] = leaves[1].concat(end._find_edge_leaves(horizontal)[1]);
                    else
                        leaves[1].push(end);
                } else {
                    // if we are a column and someone wants the horizontal edges,
                    // we return the horizontal edges from all of our children
                    for (var _i = 0, children_3 = children; _i < children_3.length; _i++) {
                        var child = children_3[_i];
                        if (child instanceof Box) {
                            var child_leaves = child._find_edge_leaves(horizontal);
                            leaves[0] = leaves[0].concat(child_leaves[0]);
                            leaves[1] = leaves[1].concat(child_leaves[1]);
                        } else {
                            leaves[0].push(child);
                            leaves[1].push(child);
                        }
                    }
                }
            }
            // console.log("  start leaves ", leaves[0].map((leaf) -> leaf.id)
            // console.log("  end leaves ", leaves[1].map((leaf) -> leaf.id)
            return leaves;
        };
        Box.prototype._align_outer_edges_constraints = function (horizontal) {
            // console.log(`${if horizontal then 'horizontal' else 'vertical'} outer edge constraints in ${this.get_layoutable_children().length}-${this.type}`)
            var _a = this._find_edge_leaves(horizontal), start_leaves = _a[0], end_leaves = _a[1];
            var start_variable;
            var end_variable;
            if (horizontal) {
                start_variable = 'on_edge_align_left';
                end_variable = 'on_edge_align_right';
            } else {
                start_variable = 'on_edge_align_top';
                end_variable = 'on_edge_align_bottom';
            }
            var collect_vars = function (leaves, name) {
                //console.log(`collecting ${name} in `, leaves)
                var edges = [];
                for (var _i = 0, leaves_1 = leaves; _i < leaves_1.length; _i++) {
                    var leaf = leaves_1[_i];
                    var vars = leaf.get_constrained_variables();
                    if (name in vars)
                        edges.push(vars[name]);    //vars[name]['_debug'] = `${name} from ${leaf.id}`
                }
                return edges;
            };
            var start_edges = collect_vars(start_leaves, start_variable);
            var end_edges = collect_vars(end_leaves, end_variable);
            var result = [];
            var add_all_equal = function (edges) {
                if (edges.length > 1) {
                    var first = edges[0];
                    for (var i = 1; i < edges.length; i++) {
                        var edge = edges[i];
                        //console.log(`  constraining ${first._debug} == ${edge._debug}`)
                        result.push(solver_1.EQ([
                            -1,
                            first
                        ], edge));
                    }
                }
            };
            add_all_equal(start_edges);
            add_all_equal(end_edges);
            // console.log("computed constraints ", result)
            return result;
        };
        Box.prototype._box_insets_from_child_insets = function (horizontal, child_variable_prefix, our_variable_prefix, minimum) {
            var _a = this._find_edge_leaves(horizontal), start_leaves = _a[0], end_leaves = _a[1];
            var start_variable;
            var end_variable;
            var our_start;
            var our_end;
            if (horizontal) {
                start_variable = child_variable_prefix + '_left';
                end_variable = child_variable_prefix + '_right';
                our_start = this[our_variable_prefix + '_left'];
                our_end = this[our_variable_prefix + '_right'];
            } else {
                start_variable = child_variable_prefix + '_top';
                end_variable = child_variable_prefix + '_bottom';
                our_start = this[our_variable_prefix + '_top'];
                our_end = this[our_variable_prefix + '_bottom'];
            }
            var result = [];
            var add_constraints = function (ours, leaves, name) {
                for (var _i = 0, leaves_2 = leaves; _i < leaves_2.length; _i++) {
                    var leaf = leaves_2[_i];
                    var vars = leaf.get_constrained_variables();
                    if (name in vars) {
                        if (minimum)
                            result.push(solver_1.GE([
                                -1,
                                ours
                            ], vars[name]));
                        else
                            result.push(solver_1.EQ([
                                -1,
                                ours
                            ], vars[name]));
                    }
                }
            };
            add_constraints(our_start, start_leaves, start_variable);
            add_constraints(our_end, end_leaves, end_variable);
            return result;
        };
        Box.prototype._box_equal_size_bounds = function (horizontal) {
            // false = box bounds equal all outer child bounds exactly
            return this._box_insets_from_child_insets(horizontal, 'box_equal_size', '_box_equal_size', false);
        };
        Box.prototype._box_cell_align_bounds = function (horizontal) {
            // false = box bounds equal all outer child bounds exactly
            return this._box_insets_from_child_insets(horizontal, 'box_cell_align', '_box_cell_align', false);
        };
        Box.prototype._box_whitespace = function (horizontal) {
            // true = box whitespace must be the minimum of child
            // whitespaces (i.e. distance from box edge to the outermost
            // child pixels)
            return this._box_insets_from_child_insets(horizontal, 'whitespace', '_whitespace', true);
        };
        Box._left_right_inner_cell_edge_variables = [
            'box_cell_align_left',
            'box_cell_align_right'
        ];
        Box._top_bottom_inner_cell_edge_variables = [
            'box_cell_align_top',
            'box_cell_align_bottom'
        ];
        return Box;
    }(layout_dom_1.LayoutDOM);
    exports.Box = Box;
    Box.initClass();    
},
/*models/layouts/column*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    var box_1 = require(137    /* ./box */);
    var ColumnView = function (_super) {
        tslib_1.__extends(ColumnView, _super);
        function ColumnView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        ColumnView.prototype.css_classes = function () {
            return _super.prototype.css_classes.call(this).concat('bk-grid-column');
        };
        return ColumnView;
    }(box_1.BoxView);
    exports.ColumnView = ColumnView;
    var Column = function (_super) {
        tslib_1.__extends(Column, _super);
        function Column(attrs, opts) {
            var _this = _super.call(this, attrs, opts) || this;
            _this._horizontal = false;
            return _this;
        }
        Column.initClass = function () {
            this.prototype.type = 'Column';
            this.prototype.default_view = ColumnView;
        };
        return Column;
    }(box_1.Box);
    exports.Column = Column;
    Column.initClass();    
},
/*models/layouts/index*/
function _(require, module, exports) {
    var box_1 = require(137    /* ./box */);
    exports.Box = box_1.Box;
    var column_1 = require(138    /* ./column */);
    exports.Column = column_1.Column;
    var layout_dom_1 = require(140    /* ./layout_dom */);
    exports.LayoutDOM = layout_dom_1.LayoutDOM;
    var row_1 = require(141    /* ./row */);
    exports.Row = row_1.Row;
    var spacer_1 = require(142    /* ./spacer */);
    exports.Spacer = spacer_1.Spacer;
    var widget_box_1 = require(143    /* ./widget_box */);
    exports.WidgetBox = widget_box_1.WidgetBox;    
},
/*models/layouts/layout_dom*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    var model_1 = require(51    /* ../../model */);
    var dom_1 = require(5    /* core/dom */);
    var p = require(15    /* core/properties */);
    var layout_canvas_1 = require(11    /* core/layout/layout_canvas */);
    var solver_1 = require(13    /* core/layout/solver */);
    var build_views_1 = require(4    /* core/build_views */);
    var dom_view_1 = require(6    /* core/dom_view */);
    var LayoutDOMView = function (_super) {
        tslib_1.__extends(LayoutDOMView, _super);
        function LayoutDOMView() {
            var _this = _super !== null && _super.apply(this, arguments) || this;
            _this._solver_inited = false;
            _this._idle_notified = false;
            return _this;
        }
        LayoutDOMView.prototype.initialize = function (options) {
            _super.prototype.initialize.call(this, options);
            // this is a root view
            if (this.is_root)
                this._solver = new solver_1.Solver();
            this.child_views = {};
            this.build_child_views();
        };
        LayoutDOMView.prototype.remove = function () {
            for (var model_id in this.child_views) {
                var view = this.child_views[model_id];
                view.remove();
            }
            this.child_views = {};
            // remove on_resize
            _super.prototype.remove.call(this);
        };
        LayoutDOMView.prototype.has_finished = function () {
            if (!_super.prototype.has_finished.call(this))
                return false;
            for (var model_id in this.child_views) {
                var child = this.child_views[model_id];
                if (!child.has_finished())
                    return false;
            }
            return true;
        };
        LayoutDOMView.prototype.notify_finished = function () {
            if (!this.is_root)
                _super.prototype.notify_finished.call(this);
            else {
                if (!this._idle_notified && this.has_finished()) {
                    if (this.model.document != null) {
                        this._idle_notified = true;
                        this.model.document.notify_idle(this.model);
                    }
                }
            }
        };
        LayoutDOMView.prototype._calc_width_height = function () {
            var measuring = this.el;
            while (measuring = measuring.parentElement) {
                // .bk-root element doesn't bring any value
                if (measuring.classList.contains('bk-root'))
                    continue;
                // we reached <body> element, so use viewport size
                if (measuring == document.body) {
                    var _a = dom_1.margin(document.body), left = _a.left, right = _a.right, top_1 = _a.top, bottom = _a.bottom;
                    var width_1 = document.documentElement.clientWidth - left - right;
                    var height_1 = document.documentElement.clientHeight - top_1 - bottom;
                    return [
                        width_1,
                        height_1
                    ];
                }
                // stop on first element with sensible dimensions
                var _b = measuring.getBoundingClientRect(), width = _b.width, height = _b.height;
                if (width != 0 && height != 0)
                    return [
                        width,
                        height
                    ];
            }
            // this element is detached from DOM
            return [
                null,
                null
            ];
        };
        LayoutDOMView.prototype._init_solver = function () {
            this._root_width = new solver_1.Variable(this.toString() + '.root_width');
            this._root_height = new solver_1.Variable(this.toString() + '.root_height');
            // XXX: this relies on the fact that missing `strength` argument results
            // in strength being NaN, which behaves like `Strength.required`. However,
            // this is banned by the API.
            this._solver.add_edit_variable(this._root_width, NaN);
            this._solver.add_edit_variable(this._root_height, NaN);
            var editables = this.model.get_all_editables();
            for (var _i = 0, editables_1 = editables; _i < editables_1.length; _i++) {
                var edit_variable = editables_1[_i];
                this._solver.add_edit_variable(edit_variable, solver_1.Strength.strong);
            }
            var constraints = this.model.get_all_constraints();
            for (var _a = 0, constraints_1 = constraints; _a < constraints_1.length; _a++) {
                var constraint = constraints_1[_a];
                this._solver.add_constraint(constraint);
            }
            var variables = this.model.get_constrained_variables();
            if (variables.width != null)
                this._solver.add_constraint(solver_1.EQ(variables.width, this._root_width));
            if (variables.height != null)
                this._solver.add_constraint(solver_1.EQ(variables.height, this._root_height));
            this._solver.update_variables();
            this._solver_inited = true;
        };
        LayoutDOMView.prototype._suggest_dims = function (width, height) {
            var variables = this.model.get_constrained_variables();
            if (variables.width != null || variables.height != null) {
                if (width == null || height == null)
                    _a = this._calc_width_height(), width = _a[0], height = _a[1];
                if (variables.width != null && width != null)
                    this._solver.suggest_value(this._root_width, width);
                if (variables.height != null && height != null)
                    this._solver.suggest_value(this._root_height, height);
                this._solver.update_variables();
            }
            var _a;
        };
        LayoutDOMView.prototype.resize = function (width, height) {
            if (width === void 0) {
                width = null;
            }
            if (height === void 0) {
                height = null;
            }
            if (!this.is_root)
                this.root.resize(width, height);
            else
                this._do_layout(false, width, height);
        };
        LayoutDOMView.prototype.partial_layout = function () {
            if (!this.is_root)
                this.root.partial_layout();
            else
                this._do_layout(false);
        };
        LayoutDOMView.prototype.layout = function () {
            if (!this.is_root)
                this.root.layout();
            else
                this._do_layout(true);
        };
        LayoutDOMView.prototype._do_layout = function (full, width, height) {
            if (width === void 0) {
                width = null;
            }
            if (height === void 0) {
                height = null;
            }
            if (!this._solver_inited || full) {
                this._solver.clear();
                this._init_solver();
            }
            this._suggest_dims(width, height);
            // XXX: do layout twice, because there are interdependencies between views,
            // which currently cannot be resolved with one pass. The third one triggers
            // rendering and (expensive) painting.
            this._layout();
            // layout (1)
            this._layout();
            // layout (2)
            this._layout(true);
            // render & paint
            this.notify_finished();
        };
        LayoutDOMView.prototype._layout = function (final) {
            if (final === void 0) {
                final = false;
            }
            for (var _i = 0, _a = this.model.get_layoutable_children(); _i < _a.length; _i++) {
                var child = _a[_i];
                var child_view = this.child_views[child.id];
                if (child_view._layout != null)
                    child_view._layout(final);
            }
            this.render();
            if (final)
                this._has_finished = true;
        };
        LayoutDOMView.prototype.rebuild_child_views = function () {
            this.solver.clear();
            this.build_child_views();
            this.layout();
        };
        LayoutDOMView.prototype.build_child_views = function () {
            var children = this.model.get_layoutable_children();
            build_views_1.build_views(this.child_views, children, { parent: this });
            dom_1.empty(this.el);
            for (var _i = 0, children_1 = children; _i < children_1.length; _i++) {
                var child = children_1[_i];
                // Look-up the child_view in this.child_views and then append We can't just
                // read from this.child_views because then we don't get guaranteed ordering.
                // Which is a problem in non-box layouts.
                var child_view = this.child_views[child.id];
                this.el.appendChild(child_view.el);
            }
        };
        LayoutDOMView.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            if (this.is_root)
                window.addEventListener('resize', function () {
                    return _this.resize();
                });
            // XXX: this.connect(this.model.change, () => this.layout())
            this.connect(this.model.properties.sizing_mode.change, function () {
                return _this.layout();
            });
        };
        LayoutDOMView.prototype._render_classes = function () {
            this.el.className = '';
            // removes all classes
            for (var _i = 0, _a = this.css_classes(); _i < _a.length; _i++) {
                var name_1 = _a[_i];
                this.el.classList.add(name_1);
            }
            this.el.classList.add('bk-layout-' + this.model.sizing_mode);
            for (var _b = 0, _c = this.model.css_classes; _b < _c.length; _b++) {
                var cls = _c[_b];
                this.el.classList.add(cls);
            }
        };
        LayoutDOMView.prototype.render = function () {
            this._render_classes();
            switch (this.model.sizing_mode) {
            case 'fixed': {
                    // If the width or height is unset:
                    // - compute it from children
                    // - but then save for future use
                    // (for some reason widget boxes keep shrinking if you keep computing
                    // but this is more efficient and appropriate for fixed anyway).
                    var width = void 0;
                    if (this.model.width != null)
                        width = this.model.width;
                    else
                        width = this.get_width();
                    this.model.setv({ width: width }, { silent: true });
                    var height = void 0;
                    if (this.model.height != null)
                        height = this.model.height;
                    else
                        height = this.get_height();
                    this.model.setv({ height: height }, { silent: true });
                    this.solver.suggest_value(this.model._width, width);
                    this.solver.suggest_value(this.model._height, height);
                    break;
                }
            case 'scale_width': {
                    var height = this.get_height();
                    this.solver.suggest_value(this.model._height, height);
                    break;
                }
            case 'scale_height': {
                    var width = this.get_width();
                    this.solver.suggest_value(this.model._width, width);
                    break;
                }
            case 'scale_both': {
                    var _a = this.get_width_height(), width = _a[0], height = _a[1];
                    this.solver.suggest_value(this.model._width, width);
                    this.solver.suggest_value(this.model._height, height);
                    break;
                }
            }
            this.solver.update_variables();
            this.position();
        };
        LayoutDOMView.prototype.position = function () {
            switch (this.model.sizing_mode) {
            case 'fixed':
            case 'scale_width':
            case 'scale_height': {
                    this.el.style.position = 'relative';
                    this.el.style.left = '';
                    this.el.style.top = '';
                    break;
                }
            case 'scale_both':
            case 'stretch_both': {
                    this.el.style.position = 'absolute';
                    this.el.style.left = this.model._dom_left.value + 'px';
                    this.el.style.top = this.model._dom_top.value + 'px';
                    break;
                }
            }
            this.el.style.width = this.model._width.value + 'px';
            this.el.style.height = this.model._height.value + 'px';
        };
        LayoutDOMView.prototype.get_width_height = function () {
            var parent = this.el.parentElement;
            if (parent == null)
                throw new Error('detached element');
            var parent_height = parent.clientHeight;
            var parent_width = parent.clientWidth;
            var ar = this.model.get_aspect_ratio();
            var new_width_1 = parent_width;
            var new_height_1 = parent_width / ar;
            var new_width_2 = parent_height * ar;
            var new_height_2 = parent_height;
            var width;
            var height;
            if (new_width_1 < new_width_2) {
                width = new_width_1;
                height = new_height_1;
            } else {
                width = new_width_2;
                height = new_height_2;
            }
            return [
                width,
                height
            ];
        };
        return LayoutDOMView;
    }(dom_view_1.DOMView);
    exports.LayoutDOMView = LayoutDOMView;
    var LayoutDOM = function (_super) {
        tslib_1.__extends(LayoutDOM, _super);
        function LayoutDOM(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        LayoutDOM.initClass = function () {
            this.prototype.type = 'LayoutDOM';
            this.define({
                height: [p.Number],
                width: [p.Number],
                disabled: [
                    p.Bool,
                    false
                ],
                sizing_mode: [
                    p.SizingMode,
                    'fixed'
                ],
                css_classes: [
                    p.Array,
                    []
                ]
            });
        };
        LayoutDOM.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            this._width = new solver_1.Variable(this.toString() + '.width');
            this._height = new solver_1.Variable(this.toString() + '.height');
            this._left = new solver_1.Variable(this.toString() + '.left');
            this._right = new solver_1.Variable(this.toString() + '.right');
            this._top = new solver_1.Variable(this.toString() + '.top');
            this._bottom = new solver_1.Variable(this.toString() + '.bottom');
            this._dom_top = new solver_1.Variable(this.toString() + '.dom_top');
            this._dom_left = new solver_1.Variable(this.toString() + '.dom_left');
            this._width_minus_right = new solver_1.Variable(this.toString() + '.width_minus_right');
            this._height_minus_bottom = new solver_1.Variable(this.toString() + '.height_minus_bottom');
            this._whitespace_top = new solver_1.Variable(this.toString() + '.whitespace_top');
            this._whitespace_bottom = new solver_1.Variable(this.toString() + '.whitespace_bottom');
            this._whitespace_left = new solver_1.Variable(this.toString() + '.whitespace_left');
            this._whitespace_right = new solver_1.Variable(this.toString() + '.whitespace_right');
        };
        Object.defineProperty(LayoutDOM.prototype, 'layout_bbox', {
            get: function () {
                return {
                    top: this._top.value,
                    left: this._left.value,
                    width: this._width.value,
                    height: this._height.value,
                    right: this._right.value,
                    bottom: this._bottom.value,
                    dom_top: this._dom_top.value,
                    dom_left: this._dom_left.value
                };
            },
            enumerable: true,
            configurable: true
        });
        LayoutDOM.prototype.dump_layout = function () {
            var layoutables = {};
            var pending = [this];
            var obj;
            while (obj = pending.shift()) {
                pending.push.apply(pending, obj.get_layoutable_children());
                layoutables[obj.toString()] = obj.layout_bbox;
            }
            console.table(layoutables);
        };
        LayoutDOM.prototype.get_all_constraints = function () {
            var constraints = this.get_constraints();
            for (var _i = 0, _a = this.get_layoutable_children(); _i < _a.length; _i++) {
                var child = _a[_i];
                if (child instanceof layout_canvas_1.LayoutCanvas)
                    constraints = constraints.concat(child.get_constraints());
                else
                    constraints = constraints.concat(child.get_all_constraints());
            }
            return constraints;
        };
        LayoutDOM.prototype.get_all_editables = function () {
            var editables = this.get_editables();
            for (var _i = 0, _a = this.get_layoutable_children(); _i < _a.length; _i++) {
                var child = _a[_i];
                if (child instanceof layout_canvas_1.LayoutCanvas)
                    editables = editables.concat(child.get_editables());
                else
                    editables = editables.concat(child.get_all_editables());
            }
            return editables;
        };
        LayoutDOM.prototype.get_constraints = function () {
            return [
                // Make sure things dont squeeze out of their bounding box
                solver_1.GE(this._dom_left),
                solver_1.GE(this._dom_top),
                // Plot has to be inside the width/height
                solver_1.GE(this._left),
                solver_1.GE(this._width, [
                    -1,
                    this._right
                ]),
                solver_1.GE(this._top),
                solver_1.GE(this._height, [
                    -1,
                    this._bottom
                ]),
                // Declare computed constraints
                solver_1.EQ(this._width_minus_right, [
                    -1,
                    this._width
                ], this._right),
                solver_1.EQ(this._height_minus_bottom, [
                    -1,
                    this._height
                ], this._bottom)
            ];
        };
        LayoutDOM.prototype.get_layoutable_children = function () {
            return [];
        };
        LayoutDOM.prototype.get_editables = function () {
            switch (this.sizing_mode) {
            case 'fixed':
                return [
                    this._height,
                    this._width
                ];
            case 'scale_width':
                return [this._height];
            case 'scale_height':
                return [this._width];
            case 'scale_both':
                return [
                    this._width,
                    this._height
                ];
            default:
                return [];
            }
        };
        LayoutDOM.prototype.get_constrained_variables = function () {
            /*
         * THE FOLLOWING ARE OPTIONAL VARS THAT
         * YOU COULD ADD INTO SUBCLASSES
         *
         *  # When this widget is on the edge of a box visually,
         *  # align these variables down that edge. Right/bottom
         *  # are an inset from the edge.
         *  on_edge_align_top    : this._top
         *  on_edge_align_bottom : this._height_minus_bottom
         *  on_edge_align_left   : this._left
         *  on_edge_align_right  : this._width_minus_right
         *  # When this widget is in a box cell with the same "arity
         *  # path" as a widget in another cell, align these variables
         *  # between the two box cells. Right/bottom are an inset from
         *  # the edge.
         *  box_cell_align_top   : this._top
         *  box_cell_align_bottom: this._height_minus_bottom
         *  box_cell_align_left  : this._left
         *  box_cell_align_right : this._width_minus_right
         *  # When this widget is in a box, make these the same distance
         *  # apart in every widget. Right/bottom are inset from the edge.
         *  box_equal_size_top   : this._top
         *  box_equal_size_bottom: this._height_minus_bottom
         *  box_equal_size_left  : this._left
         *  box_equal_size_right : this._width_minus_right
         */
            var vars = {
                origin_x: this._dom_left,
                origin_y: this._dom_top,
                whitespace_top: this._whitespace_top,
                whitespace_bottom: this._whitespace_bottom,
                whitespace_left: this._whitespace_left,
                whitespace_right: this._whitespace_right
            };
            switch (this.sizing_mode) {
            case 'stretch_both':
                vars.width = this._width;
                vars.height = this._height;
                break;
            case 'scale_width':
                vars.width = this._width;
                break;
            case 'scale_height':
                vars.height = this._height;
                break;
            }
            return vars;
        };
        LayoutDOM.prototype.get_aspect_ratio = function () {
            return this.width / this.height;
        };
        return LayoutDOM;
    }(model_1.Model);
    exports.LayoutDOM = LayoutDOM;
    LayoutDOM.initClass();    
},
/*models/layouts/row*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    var box_1 = require(137    /* ./box */);
    var RowView = function (_super) {
        tslib_1.__extends(RowView, _super);
        function RowView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        RowView.prototype.css_classes = function () {
            return _super.prototype.css_classes.call(this).concat('bk-grid-row');
        };
        return RowView;
    }(box_1.BoxView);
    exports.RowView = RowView;
    var Row = function (_super) {
        tslib_1.__extends(Row, _super);
        function Row(attrs, opts) {
            var _this = _super.call(this, attrs, opts) || this;
            _this._horizontal = true;
            return _this;
        }
        Row.initClass = function () {
            this.prototype.type = 'Row';
            this.prototype.default_view = RowView;
        };
        return Row;
    }(box_1.Box);
    exports.Row = Row;
    Row.initClass();    
},
/*models/layouts/spacer*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    var layout_dom_1 = require(140    /* ./layout_dom */);
    var object_1 = require(31    /* core/util/object */);
    var SpacerView = function (_super) {
        tslib_1.__extends(SpacerView, _super);
        function SpacerView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        SpacerView.prototype.render = function () {
            _super.prototype.render.call(this);
            if (this.model.sizing_mode == 'fixed') {
                this.el.style.width = this.model.width + 'px';
                this.el.style.height = this.model.height + 'px';
            }
        };
        SpacerView.prototype.css_classes = function () {
            return _super.prototype.css_classes.call(this).concat('bk-spacer-box');
        };
        // spacer must always have some width/height
        SpacerView.prototype.get_width = function () {
            return 1;
        };
        SpacerView.prototype.get_height = function () {
            return 1;
        };
        return SpacerView;
    }(layout_dom_1.LayoutDOMView);
    exports.SpacerView = SpacerView;
    var Spacer = function (_super) {
        tslib_1.__extends(Spacer, _super);
        function Spacer(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        Spacer.initClass = function () {
            this.prototype.type = 'Spacer';
            this.prototype.default_view = SpacerView;
        };
        Spacer.prototype.get_constrained_variables = function () {
            return object_1.extend({}, _super.prototype.get_constrained_variables.call(this), {
                on_edge_align_top: this._top,
                on_edge_align_bottom: this._height_minus_bottom,
                on_edge_align_left: this._left,
                on_edge_align_right: this._width_minus_right,
                box_cell_align_top: this._top,
                box_cell_align_bottom: this._height_minus_bottom,
                box_cell_align_left: this._left,
                box_cell_align_right: this._width_minus_right,
                box_equal_size_top: this._top,
                box_equal_size_bottom: this._height_minus_bottom,
                box_equal_size_left: this._left,
                box_equal_size_right: this._width_minus_right
            });
        };
        return Spacer;
    }(layout_dom_1.LayoutDOM);
    exports.Spacer = Spacer;
    Spacer.initClass();    
},
/*models/layouts/widget_box*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    var logging_1 = require(14    /* core/logging */);
    var p = require(15    /* core/properties */);
    var object_1 = require(31    /* core/util/object */);
    var layout_dom_1 = require(140    /* ../layouts/layout_dom */);
    var WidgetBoxView = function (_super) {
        tslib_1.__extends(WidgetBoxView, _super);
        function WidgetBoxView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        WidgetBoxView.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            this.connect(this.model.properties.children.change, function () {
                return _this.rebuild_child_views();
            });
        };
        WidgetBoxView.prototype.css_classes = function () {
            return _super.prototype.css_classes.call(this).concat('bk-widget-box');
        };
        WidgetBoxView.prototype.render = function () {
            this._render_classes();
            // XXX: because no super()
            if (this.model.sizing_mode == 'fixed' || this.model.sizing_mode == 'scale_height') {
                var width = this.get_width();
                if (this.model._width.value != width)
                    this.solver.suggest_value(this.model._width, width);
            }
            if (this.model.sizing_mode == 'fixed' || this.model.sizing_mode == 'scale_width') {
                var height = this.get_height();
                if (this.model._height.value != height)
                    this.solver.suggest_value(this.model._height, height);
            }
            this.solver.update_variables();
            if (this.model.sizing_mode == 'stretch_both') {
                this.el.style.position = 'absolute';
                this.el.style.left = this.model._dom_left.value + 'px';
                this.el.style.top = this.model._dom_top.value + 'px';
                this.el.style.width = this.model._width.value + 'px';
                this.el.style.height = this.model._height.value + 'px';
            } else {
                // Note we DO NOT want to set a height (except in stretch_both). Widgets
                // are happier sizing themselves. We've tried to tell the layout what
                // the height is with the suggest_value. But that doesn't mean we need
                // to put it in the dom.
                var css_width = void 0;
                if (this.model._width.value - 20 > 0)
                    css_width = this.model._width.value - 20 + 'px';
                else
                    css_width = '100%';
                this.el.style.width = css_width;
            }
        };
        WidgetBoxView.prototype.get_height = function () {
            var height = 0;
            for (var key in this.child_views) {
                var child_view = this.child_views[key];
                var el = child_view.el;
                var style = getComputedStyle(el);
                var marginTop = parseInt(style.marginTop) || 0;
                var marginBottom = parseInt(style.marginBottom) || 0;
                height += el.offsetHeight + marginTop + marginBottom;
            }
            return height + 20;
        };
        WidgetBoxView.prototype.get_width = function () {
            if (this.model.width != null)
                return this.model.width;
            else {
                var width = this.el.scrollWidth + 20;
                for (var key in this.child_views) {
                    var child_view = this.child_views[key];
                    // Take the max width of all the children as the constrainer.
                    var child_width = child_view.el.scrollWidth;
                    if (child_width > width)
                        width = child_width;
                }
                return width;
            }
        };
        return WidgetBoxView;
    }(layout_dom_1.LayoutDOMView);
    exports.WidgetBoxView = WidgetBoxView;
    var WidgetBox = function (_super) {
        tslib_1.__extends(WidgetBox, _super);
        function WidgetBox(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        WidgetBox.initClass = function () {
            this.prototype.type = 'WidgetBox';
            this.prototype.default_view = WidgetBoxView;
            this.define({
                children: [
                    p.Array,
                    []
                ]
            });
        };
        WidgetBox.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            if (this.sizing_mode == 'fixed' && this.width == null) {
                this.width = 300;
                // Set a default for fixed.
                logging_1.logger.info('WidgetBox mode is fixed, but no width specified. Using default of 300.');
            }
        };
        WidgetBox.prototype.get_constrained_variables = function () {
            var vars = object_1.extend({}, _super.prototype.get_constrained_variables.call(this), {
                on_edge_align_top: this._top,
                on_edge_align_bottom: this._height_minus_bottom,
                on_edge_align_left: this._left,
                on_edge_align_right: this._width_minus_right,
                box_cell_align_top: this._top,
                box_cell_align_bottom: this._height_minus_bottom,
                box_cell_align_left: this._left,
                box_cell_align_right: this._width_minus_right,
                box_equal_size_top: this._top,
                box_equal_size_bottom: this._height_minus_bottom
            });
            if (this.sizing_mode != 'fixed') {
                vars.box_equal_size_left = this._left;
                vars.box_equal_size_right = this._width_minus_right;
            }
            return vars;
        };
        WidgetBox.prototype.get_layoutable_children = function () {
            return this.children;
        };
        return WidgetBox;
    }(layout_dom_1.LayoutDOM);
    exports.WidgetBox = WidgetBox;
    WidgetBox.initClass();    
},
/*models/mappers/categorical_color_mapper*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    /* XXX: partial */
    var color_mapper_1 = require(145    /* ./color_mapper */);
    var p = require(15    /* core/properties */);
    var array_1 = require(22    /* core/util/array */);
    var types_1 = require(43    /* core/util/types */);
    var _equals = function (a, b) {
        if (a.length !== b.length) {
            return false;
        }
        for (var i = 0, end = a.length; i < end; i++) {
            if (a[i] !== b[i]) {
                return false;
            }
        }
        return true;
    };
    var CategoricalColorMapper = function (_super) {
        tslib_1.__extends(CategoricalColorMapper, _super);
        function CategoricalColorMapper(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        CategoricalColorMapper.initClass = function () {
            this.prototype.type = 'CategoricalColorMapper';
            this.define({
                factors: [p.Array],
                start: [
                    p.Number,
                    0
                ],
                end: [p.Number]
            });
        };
        // XXX: not really string[], but Factor[]. This needs to be clarified across the repo.
        CategoricalColorMapper.prototype._get_values = function (data, palette, _image_glyph) {
            if (_image_glyph === void 0) {
                _image_glyph = false;
            }
            var values = [];
            var _loop_1 = function (d) {
                var color = void 0, key = void 0;
                if (types_1.isString(d)) {
                    key = this_1.factors.indexOf(d);
                } else {
                    if (this_1.start != null) {
                        if (this_1.end != null) {
                            d = d.slice(this_1.start, this_1.end);
                        } else {
                            d = d.slice(this_1.start);
                        }
                    } else if (this_1.end != null) {
                        d = d.slice(0, this_1.end);
                    }
                    if (d.length === 1) {
                        key = this_1.factors.indexOf(d[0]);
                    } else {
                        key = array_1.findIndex(this_1.factors, function (x) {
                            return _equals(x, d);
                        });
                    }
                }
                if (key < 0 || key >= palette.length) {
                    color = this_1.nan_color;
                } else {
                    color = palette[key];
                }
                values.push(color);
            };
            var this_1 = this;
            for (var _i = 0, data_1 = data; _i < data_1.length; _i++) {
                var d = data_1[_i];
                _loop_1(d);
            }
            return values;
        };
        return CategoricalColorMapper;
    }(color_mapper_1.ColorMapper);
    exports.CategoricalColorMapper = CategoricalColorMapper;
    CategoricalColorMapper.initClass();    
},
/*models/mappers/color_mapper*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    /* XXX: partial */
    var p = require(15    /* core/properties */);
    var transform_1 = require(248    /* ../transforms/transform */);
    var types_1 = require(43    /* core/util/types */);
    var ColorMapper = function (_super) {
        tslib_1.__extends(ColorMapper, _super);
        function ColorMapper(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        ColorMapper.initClass = function () {
            this.prototype.type = 'ColorMapper';
            this.define({
                palette: [p.Any],
                nan_color: [
                    p.Color,
                    'gray'
                ]
            });
        };
        ColorMapper.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            this._little_endian = this._is_little_endian();
            this._palette = this._build_palette(this.palette);
        };
        ColorMapper.prototype.connect_signals = function () {
            _super.prototype.connect_signals.call(this);
            this.connect(this.change, function () {
                this._palette = this._build_palette(this.palette);
            });
        };
        // TODO (bev) This should not be needed, everything should use v_compute
        ColorMapper.prototype.v_map_screen = function (data, image_glyph) {
            if (image_glyph === void 0) {
                image_glyph = false;
            }
            var values = this._get_values(data, this._palette, image_glyph);
            var buf = new ArrayBuffer(data.length * 4);
            if (this._little_endian) {
                var color = new Uint8Array(buf);
                for (var i = 0, end = data.length; i < end; i++) {
                    var value = values[i];
                    var ind = i * 4;
                    // Bitwise math in JS is limited to 31-bits, to handle 32-bit value
                    // this uses regular math to compute alpha instead (see issue #6755)
                    color[ind] = Math.floor(value / 4278190080 * 255);
                    color[ind + 1] = (value & 16711680) >> 16;
                    color[ind + 2] = (value & 65280) >> 8;
                    color[ind + 3] = value & 255;
                }
            } else {
                var color = new Uint32Array(buf);
                for (var i = 0, end = data.length; i < end; i++) {
                    var value = values[i];
                    color[i] = value << 8 | 255;
                }    // alpha
            }
            return buf;
        };
        ColorMapper.prototype.compute = function (_x) {
            // If it's just a single value, then a color mapper doesn't
            // really make sense, so return nothing
            return null;
        };
        ColorMapper.prototype.v_compute = function (xs) {
            return this._get_values(xs, this.palette);
        };
        ColorMapper.prototype._is_little_endian = function () {
            var buf = new ArrayBuffer(4);
            var buf8 = new Uint8Array(buf);
            var buf32 = new Uint32Array(buf);
            buf32[1] = 168496141;
            var little_endian = true;
            if (buf8[4] === 10 && buf8[5] === 11 && buf8[6] === 12 && buf8[7] === 13) {
                little_endian = false;
            }
            return little_endian;
        };
        ColorMapper.prototype._build_palette = function (palette) {
            var new_palette = new Uint32Array(palette.length);
            var _convert = function (value) {
                if (types_1.isNumber(value)) {
                    return value;
                } else {
                    if (value.length !== 9) {
                        value = value + 'ff';
                    }
                    return parseInt(value.slice(1), 16);
                }
            };
            for (var i = 0, end = palette.length; i < end; i++) {
                new_palette[i] = _convert(palette[i]);
            }
            return new_palette;
        };
        return ColorMapper;
    }(transform_1.Transform);
    exports.ColorMapper = ColorMapper;
    ColorMapper.initClass();    
},
/*models/mappers/index*/
function _(require, module, exports) {
    var categorical_color_mapper_1 = require(144    /* ./categorical_color_mapper */);
    exports.CategoricalColorMapper = categorical_color_mapper_1.CategoricalColorMapper;
    var color_mapper_1 = require(145    /* ./color_mapper */);
    exports.ColorMapper = color_mapper_1.ColorMapper;
    var linear_color_mapper_1 = require(147    /* ./linear_color_mapper */);
    exports.LinearColorMapper = linear_color_mapper_1.LinearColorMapper;
    var log_color_mapper_1 = require(148    /* ./log_color_mapper */);
    exports.LogColorMapper = log_color_mapper_1.LogColorMapper;    
},
/*models/mappers/linear_color_mapper*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    /* XXX: partial */
    var p = require(15    /* core/properties */);
    var color_1 = require(27    /* core/util/color */);
    var array_1 = require(22    /* core/util/array */);
    var color_mapper_1 = require(145    /* ./color_mapper */);
    var LinearColorMapper = function (_super) {
        tslib_1.__extends(LinearColorMapper, _super);
        function LinearColorMapper(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        LinearColorMapper.initClass = function () {
            this.prototype.type = 'LinearColorMapper';
            this.define({
                high: [p.Number],
                low: [p.Number],
                high_color: [p.Color],
                low_color: [p.Color]
            });
        };
        LinearColorMapper.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            this._nan_color = this._build_palette([color_1.color2hex(this.nan_color)])[0];
            this._high_color = this.high_color != null ? this._build_palette([color_1.color2hex(this.high_color)])[0] : undefined;
            this._low_color = this.low_color != null ? this._build_palette([color_1.color2hex(this.low_color)])[0] : undefined;
        };
        LinearColorMapper.prototype._get_values = function (data, palette, image_glyph) {
            if (image_glyph === void 0) {
                image_glyph = false;
            }
            var low = this.low != null ? this.low : array_1.min(data);
            var high = this.high != null ? this.high : array_1.max(data);
            var max_key = palette.length - 1;
            var values = [];
            var nan_color = image_glyph ? this._nan_color : this.nan_color;
            var low_color = image_glyph ? this._low_color : this.low_color;
            var high_color = image_glyph ? this._high_color : this.high_color;
            var norm_factor = 1 / (high - low);
            var normed_interval = 1 / palette.length;
            for (var _i = 0, data_1 = data; _i < data_1.length; _i++) {
                var d = data_1[_i];
                if (isNaN(d)) {
                    values.push(nan_color);
                    continue;
                }
                // This handles the edge case where d == high, since the code below maps
                // values exactly equal to high to palette.length, which is greater than
                // max_key
                if (d === high) {
                    values.push(palette[max_key]);
                    continue;
                }
                var normed_d = (d - low) * norm_factor;
                var key = Math.floor(normed_d / normed_interval);
                if (key < 0) {
                    if (this.low_color != null) {
                        values.push(low_color);
                    } else {
                        values.push(palette[0]);
                    }
                } else if (key > max_key) {
                    if (this.high_color != null) {
                        values.push(high_color);
                    } else {
                        values.push(palette[max_key]);
                    }
                } else {
                    values.push(palette[key]);
                }
            }
            return values;
        };
        return LinearColorMapper;
    }(color_mapper_1.ColorMapper);
    exports.LinearColorMapper = LinearColorMapper;
    LinearColorMapper.initClass();    
},
/*models/mappers/log_color_mapper*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    /* XXX: partial */
    var p = require(15    /* core/properties */);
    var color_1 = require(27    /* core/util/color */);
    var array_1 = require(22    /* core/util/array */);
    var color_mapper_1 = require(145    /* ./color_mapper */);
    // Math.log1p() is not supported by any version of IE, so let's use a polyfill based on
    // https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/log1p.
    var log1p = Math.log1p != null ? Math.log1p : function (x) {
        return Math.log(1 + x);
    };
    var LogColorMapper = function (_super) {
        tslib_1.__extends(LogColorMapper, _super);
        function LogColorMapper(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        LogColorMapper.initClass = function () {
            this.prototype.type = 'LogColorMapper';
            this.define({
                high: [p.Number],
                low: [p.Number],
                high_color: [p.Color],
                low_color: [p.Color]
            });
        };
        LogColorMapper.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            this._nan_color = this._build_palette([color_1.color2hex(this.nan_color)])[0];
            this._high_color = this.high_color != null ? this._build_palette([color_1.color2hex(this.high_color)])[0] : undefined;
            this._low_color = this.low_color != null ? this._build_palette([color_1.color2hex(this.low_color)])[0] : undefined;
        };
        LogColorMapper.prototype._get_values = function (data, palette, image_glyph) {
            if (image_glyph === void 0) {
                image_glyph = false;
            }
            var n = palette.length;
            var low = this.low != null ? this.low : array_1.min(data);
            var high = this.high != null ? this.high : array_1.max(data);
            var scale = n / (log1p(high) - log1p(low));
            // subtract the low offset
            var max_key = palette.length - 1;
            var values = [];
            var nan_color = image_glyph ? this._nan_color : this.nan_color;
            var high_color = image_glyph ? this._high_color : this.high_color;
            var low_color = image_glyph ? this._low_color : this.low_color;
            for (var _i = 0, data_1 = data; _i < data_1.length; _i++) {
                var d = data_1[_i];
                // Check NaN
                if (isNaN(d)) {
                    values.push(nan_color);
                    continue;
                }
                if (d > high) {
                    if (this.high_color != null) {
                        values.push(high_color);
                    } else {
                        values.push(palette[max_key]);
                    }
                    continue;
                }
                // This handles the edge case where d == high, since the code below maps
                // values exactly equal to high to palette.length, which is greater than
                // max_key
                if (d === high) {
                    values.push(palette[max_key]);
                    continue;
                }
                if (d < low) {
                    if (this.low_color != null) {
                        values.push(low_color);
                    } else {
                        values.push(palette[0]);
                    }
                    continue;
                }
                // Get the key
                var log = log1p(d) - log1p(low);
                // subtract the low offset
                var key = Math.floor(log * scale);
                // Deal with upper bound
                if (key > max_key) {
                    key = max_key;
                }
                values.push(palette[key]);
            }
            return values;
        };
        return LogColorMapper;
    }(color_mapper_1.ColorMapper);
    exports.LogColorMapper = LogColorMapper;
    LogColorMapper.initClass();    
},
/*models/markers/index*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    /* XXX: partial */
    var marker_1 = require(150    /* ./marker */);
    var SQ3 = Math.sqrt(3);
    var _one_x = function (ctx, r) {
        ctx.moveTo(-r, r);
        ctx.lineTo(r, -r);
        ctx.moveTo(-r, -r);
        return ctx.lineTo(r, r);
    };
    var _one_cross = function (ctx, r) {
        ctx.moveTo(0, r);
        ctx.lineTo(0, -r);
        ctx.moveTo(-r, 0);
        return ctx.lineTo(r, 0);
    };
    var _one_diamond = function (ctx, r) {
        ctx.moveTo(0, r);
        ctx.lineTo(r / 1.5, 0);
        ctx.lineTo(0, -r);
        ctx.lineTo(-r / 1.5, 0);
        return ctx.closePath();
    };
    var _one_tri = function (ctx, r) {
        var h = r * SQ3;
        var a = h / 3;
        // TODO (bev) use viewstate to take y-axis inversion into account
        ctx.moveTo(-r, a);
        ctx.lineTo(r, a);
        ctx.lineTo(0, a - h);
        return ctx.closePath();
    };
    var asterisk = function (ctx, i, _sx, _sy, r, line, _fill) {
        var r2 = r * 0.65;
        _one_cross(ctx, r);
        _one_x(ctx, r2);
        if (line.doit) {
            line.set_vectorize(ctx, i);
            ctx.stroke();
        }
    };
    var circle_cross = function (ctx, i, _sx, _sy, r, line, fill) {
        ctx.arc(0, 0, r, 0, 2 * Math.PI, false);
        if (fill.doit) {
            fill.set_vectorize(ctx, i);
            ctx.fill();
        }
        if (line.doit) {
            line.set_vectorize(ctx, i);
            _one_cross(ctx, r);
            ctx.stroke();
        }
    };
    var circle_x = function (ctx, i, _sx, _sy, r, line, fill) {
        ctx.arc(0, 0, r, 0, 2 * Math.PI, false);
        if (fill.doit) {
            fill.set_vectorize(ctx, i);
            ctx.fill();
        }
        if (line.doit) {
            line.set_vectorize(ctx, i);
            _one_x(ctx, r);
            ctx.stroke();
        }
    };
    var cross = function (ctx, i, _sx, _sy, r, line, _fill) {
        _one_cross(ctx, r);
        if (line.doit) {
            line.set_vectorize(ctx, i);
            ctx.stroke();
        }
    };
    var diamond = function (ctx, i, _sx, _sy, r, line, fill) {
        _one_diamond(ctx, r);
        if (fill.doit) {
            fill.set_vectorize(ctx, i);
            ctx.fill();
        }
        if (line.doit) {
            line.set_vectorize(ctx, i);
            ctx.stroke();
        }
    };
    var diamond_cross = function (ctx, i, _sx, _sy, r, line, fill) {
        _one_diamond(ctx, r);
        if (fill.doit) {
            fill.set_vectorize(ctx, i);
            ctx.fill();
        }
        if (line.doit) {
            line.set_vectorize(ctx, i);
            _one_cross(ctx, r);
            ctx.stroke();
        }
    };
    var inverted_triangle = function (ctx, i, _sx, _sy, r, line, fill) {
        ctx.rotate(Math.PI);
        _one_tri(ctx, r);
        ctx.rotate(-Math.PI);
        if (fill.doit) {
            fill.set_vectorize(ctx, i);
            ctx.fill();
        }
        if (line.doit) {
            line.set_vectorize(ctx, i);
            ctx.stroke();
        }
    };
    var square = function (ctx, i, _sx, _sy, r, line, fill) {
        var size = 2 * r;
        ctx.rect(-r, -r, size, size);
        if (fill.doit) {
            fill.set_vectorize(ctx, i);
            ctx.fill();
        }
        if (line.doit) {
            line.set_vectorize(ctx, i);
            ctx.stroke();
        }
    };
    var square_cross = function (ctx, i, _sx, _sy, r, line, fill) {
        var size = 2 * r;
        ctx.rect(-r, -r, size, size);
        if (fill.doit) {
            fill.set_vectorize(ctx, i);
            ctx.fill();
        }
        if (line.doit) {
            line.set_vectorize(ctx, i);
            _one_cross(ctx, r);
            ctx.stroke();
        }
    };
    var square_x = function (ctx, i, _sx, _sy, r, line, fill) {
        var size = 2 * r;
        ctx.rect(-r, -r, size, size);
        if (fill.doit) {
            fill.set_vectorize(ctx, i);
            ctx.fill();
        }
        if (line.doit) {
            line.set_vectorize(ctx, i);
            _one_x(ctx, r);
            ctx.stroke();
        }
    };
    var triangle = function (ctx, i, _sx, _sy, r, line, fill) {
        _one_tri(ctx, r);
        if (fill.doit) {
            fill.set_vectorize(ctx, i);
            ctx.fill();
        }
        if (line.doit) {
            line.set_vectorize(ctx, i);
            ctx.stroke();
        }
    };
    var x = function (ctx, i, _sx, _sy, r, line, _fill) {
        _one_x(ctx, r);
        if (line.doit) {
            line.set_vectorize(ctx, i);
            ctx.stroke();
        }
    };
    var _mk_model = function (type, f) {
        var view = function (_super) {
            tslib_1.__extends(view, _super);
            function view() {
                return _super !== null && _super.apply(this, arguments) || this;
            }
            view.initClass = function () {
                this.prototype._render_one = f;
            };
            return view;
        }(marker_1.MarkerView);
        view.initClass();
        var model = function (_super) {
            tslib_1.__extends(model, _super);
            function model() {
                return _super !== null && _super.apply(this, arguments) || this;
            }
            model.initClass = function () {
                this.prototype.default_view = view;
                this.prototype.type = type;
            };
            return model;
        }(marker_1.Marker);
        model.initClass();
        return model;
    };
    // markers are final, so no need to export views
    exports.Asterisk = _mk_model('Asterisk', asterisk);
    exports.CircleCross = _mk_model('CircleCross', circle_cross);
    exports.CircleX = _mk_model('CircleX', circle_x);
    exports.Cross = _mk_model('Cross', cross);
    exports.Diamond = _mk_model('Diamond', diamond);
    exports.DiamondCross = _mk_model('DiamondCross', diamond_cross);
    exports.InvertedTriangle = _mk_model('InvertedTriangle', inverted_triangle);
    exports.Square = _mk_model('Square', square);
    exports.SquareCross = _mk_model('SquareCross', square_cross);
    exports.SquareX = _mk_model('SquareX', square_x);
    exports.Triangle = _mk_model('Triangle', triangle);
    exports.X = _mk_model('X', x);    
},
/*models/markers/marker*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    /* XXX: partial */
    var xy_glyph_1 = require(129    /* ../glyphs/xy_glyph */);
    var hittest = require(9    /* core/hittest */);
    var p = require(15    /* core/properties */);
    var array_1 = require(22    /* core/util/array */);
    var MarkerView = function (_super) {
        tslib_1.__extends(MarkerView, _super);
        function MarkerView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        MarkerView.prototype.draw_legend_for_index = function (ctx, x0, x1, y0, y1, index) {
            // using objects like this seems a little wonky, since the keys are coerced to
            // stings, but it works
            var indices = [index];
            var sx = {};
            sx[index] = (x0 + x1) / 2;
            var sy = {};
            sy[index] = (y0 + y1) / 2;
            var size = {};
            size[index] = Math.min(Math.abs(x1 - x0), Math.abs(y1 - y0)) * 0.4;
            var angle = {};
            angle[index] = this._angle[index];
            var data = {
                sx: sx,
                sy: sy,
                _size: size,
                _angle: angle
            };
            return this._render(ctx, indices, data);
        };
        MarkerView.prototype._render = function (ctx, indices, _a) {
            var sx = _a.sx, sy = _a.sy, _size = _a._size, _angle = _a._angle;
            for (var _i = 0, indices_1 = indices; _i < indices_1.length; _i++) {
                var i = indices_1[_i];
                if (isNaN(sx[i] + sy[i] + _size[i] + _angle[i])) {
                    continue;
                }
                var r = _size[i] / 2;
                ctx.beginPath();
                ctx.translate(sx[i], sy[i]);
                if (_angle[i]) {
                    ctx.rotate(_angle[i]);
                }
                this._render_one(ctx, i, sx[i], sy[i], r, this.visuals.line, this.visuals.fill);
                if (_angle[i]) {
                    ctx.rotate(-_angle[i]);
                }
                ctx.translate(-sx[i], -sy[i]);
            }
        };
        MarkerView.prototype._mask_data = function (_all_indices) {
            // dilate the inner screen region by max_size and map back to data space for use in
            // spatial query
            var hr = this.renderer.plot_view.frame.bbox.h_range;
            var sx0 = hr.start - this.max_size;
            var sx1 = hr.end + this.max_size;
            var _a = this.renderer.xscale.r_invert(sx0, sx1), x0 = _a[0], x1 = _a[1];
            var vr = this.renderer.plot_view.frame.bbox.v_range;
            var sy0 = vr.start - this.max_size;
            var sy1 = vr.end + this.max_size;
            var _b = this.renderer.yscale.r_invert(sy0, sy1), y0 = _b[0], y1 = _b[1];
            var bbox = hittest.validate_bbox_coords([
                x0,
                x1
            ], [
                y0,
                y1
            ]);
            return this.index.indices(bbox);
        };
        MarkerView.prototype._hit_point = function (geometry) {
            var sx = geometry.sx, sy = geometry.sy;
            var sx0 = sx - this.max_size;
            var sx1 = sx + this.max_size;
            var _a = this.renderer.xscale.r_invert(sx0, sx1), x0 = _a[0], x1 = _a[1];
            var sy0 = sy - this.max_size;
            var sy1 = sy + this.max_size;
            var _b = this.renderer.yscale.r_invert(sy0, sy1), y0 = _b[0], y1 = _b[1];
            var bbox = hittest.validate_bbox_coords([
                x0,
                x1
            ], [
                y0,
                y1
            ]);
            var candidates = this.index.indices(bbox);
            var hits = [];
            for (var _i = 0, candidates_1 = candidates; _i < candidates_1.length; _i++) {
                var i = candidates_1[_i];
                var s2 = this._size[i] / 2;
                var dist = Math.abs(this.sx[i] - sx) + Math.abs(this.sy[i] - sy);
                if (Math.abs(this.sx[i] - sx) <= s2 && Math.abs(this.sy[i] - sy) <= s2) {
                    hits.push([
                        i,
                        dist
                    ]);
                }
            }
            return hittest.create_1d_hit_test_result(hits);
        };
        MarkerView.prototype._hit_span = function (geometry) {
            var ms, x0, x1, y0, y1;
            var sx = geometry.sx, sy = geometry.sy;
            var _a = this.bounds(), minX = _a.minX, minY = _a.minY, maxX = _a.maxX, maxY = _a.maxY;
            var result = hittest.create_hit_test_result();
            if (geometry.direction === 'h') {
                y0 = minY;
                y1 = maxY;
                ms = this.max_size / 2;
                var sx0 = sx - ms;
                var sx1 = sx + ms;
                _b = this.renderer.xscale.r_invert(sx0, sx1), x0 = _b[0], x1 = _b[1];
            } else {
                x0 = minX;
                x1 = maxX;
                ms = this.max_size / 2;
                var sy0 = sy - ms;
                var sy1 = sy + ms;
                _c = this.renderer.yscale.r_invert(sy0, sy1), y0 = _c[0], y1 = _c[1];
            }
            var bbox = hittest.validate_bbox_coords([
                x0,
                x1
            ], [
                y0,
                y1
            ]);
            var hits = this.index.indices(bbox);
            result['1d'].indices = hits;
            return result;
            var _b, _c;
        };
        MarkerView.prototype._hit_rect = function (geometry) {
            var sx0 = geometry.sx0, sx1 = geometry.sx1, sy0 = geometry.sy0, sy1 = geometry.sy1;
            var _a = this.renderer.xscale.r_invert(sx0, sx1), x0 = _a[0], x1 = _a[1];
            var _b = this.renderer.yscale.r_invert(sy0, sy1), y0 = _b[0], y1 = _b[1];
            var bbox = hittest.validate_bbox_coords([
                x0,
                x1
            ], [
                y0,
                y1
            ]);
            var result = hittest.create_hit_test_result();
            result['1d'].indices = this.index.indices(bbox);
            return result;
        };
        MarkerView.prototype._hit_poly = function (geometry) {
            var sx = geometry.sx, sy = geometry.sy;
            // TODO (bev) use spatial index to pare candidate list
            var candidates = array_1.range(0, this.sx.length);
            var hits = [];
            for (var i = 0, end = candidates.length; i < end; i++) {
                var idx = candidates[i];
                if (hittest.point_in_poly(this.sx[i], this.sy[i], sx, sy)) {
                    hits.push(idx);
                }
            }
            var result = hittest.create_hit_test_result();
            result['1d'].indices = hits;
            return result;
        };
        return MarkerView;
    }(xy_glyph_1.XYGlyphView);
    exports.MarkerView = MarkerView;
    var Marker = function (_super) {
        tslib_1.__extends(Marker, _super);
        function Marker(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        Marker.initClass = function () {
            this.mixins([
                'line',
                'fill'
            ]);
            this.define({
                size: [
                    p.DistanceSpec,
                    {
                        units: 'screen',
                        value: 4
                    }
                ],
                angle: [
                    p.AngleSpec,
                    0
                ]
            });
        };
        return Marker;
    }(xy_glyph_1.XYGlyph);
    exports.Marker = Marker;
    Marker.initClass();    
},
/*models/plots/gmap_plot*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    var logging_1 = require(14    /* core/logging */);
    var gmap_plot_canvas_1 = require(152    /* ./gmap_plot_canvas */);
    var plot_1 = require(154    /* ./plot */);
    var p = require(15    /* core/properties */);
    var model_1 = require(51    /* ../../model */);
    var MapOptions = function (_super) {
        tslib_1.__extends(MapOptions, _super);
        function MapOptions(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        MapOptions.initClass = function () {
            this.prototype.type = 'MapOptions';
            this.define({
                lat: [p.Number],
                lng: [p.Number],
                zoom: [
                    p.Number,
                    12
                ]
            });
        };
        return MapOptions;
    }(model_1.Model);
    exports.MapOptions = MapOptions;
    MapOptions.initClass();
    var GMapOptions = function (_super) {
        tslib_1.__extends(GMapOptions, _super);
        function GMapOptions(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        GMapOptions.initClass = function () {
            this.prototype.type = 'GMapOptions';
            this.define({
                map_type: [
                    p.String,
                    'roadmap'
                ],
                scale_control: [
                    p.Bool,
                    false
                ],
                styles: [p.String]
            });
        };
        return GMapOptions;
    }(MapOptions);
    exports.GMapOptions = GMapOptions;
    GMapOptions.initClass();
    var GMapPlotView = function (_super) {
        tslib_1.__extends(GMapPlotView, _super);
        function GMapPlotView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return GMapPlotView;
    }(plot_1.PlotView);
    exports.GMapPlotView = GMapPlotView;
    var GMapPlot = function (_super) {
        tslib_1.__extends(GMapPlot, _super);
        function GMapPlot(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        GMapPlot.initClass = function () {
            this.prototype.type = 'GMapPlot';
            this.prototype.default_view = GMapPlotView;
            // Set all the PlotCanvas properties as internal.
            // This seems to be necessary so that everything can initialize.
            // Feels very clumsy, but I'm not sure how the properties system wants
            // to handle something like this situation.
            this.define({
                map_options: [p.Instance],
                api_key: [p.String]
            });
        };
        GMapPlot.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            if (!this.api_key)
                logging_1.logger.error('api_key is required. See https://developers.google.com/maps/documentation/javascript/get-api-key for more information on how to obtain your own.');
        };
        GMapPlot.prototype._init_plot_canvas = function () {
            return new gmap_plot_canvas_1.GMapPlotCanvas({ plot: this });
        };
        return GMapPlot;
    }(plot_1.Plot);
    exports.GMapPlot = GMapPlot;
    GMapPlot.initClass();    
},
/*models/plots/gmap_plot_canvas*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    /* XXX: partial */
    var proj4_1 = require(32    /* core/util/proj4 */);
    var plot_canvas_1 = require(155    /* ./plot_canvas */);
    var signaling_1 = require(20    /* core/signaling */);
    var gmaps_ready = new signaling_1.Signal(this, 'gmaps_ready');
    var load_google_api = function (api_key) {
        window._bokeh_gmaps_callback = function () {
            return gmaps_ready.emit(undefined);
        };
        var script = document.createElement('script');
        script.type = 'text/javascript';
        script.src = 'https://maps.googleapis.com/maps/api/js?key=' + api_key + '&callback=_bokeh_gmaps_callback';
        return document.body.appendChild(script);
    };
    var GMapPlotCanvasView = function (_super) {
        tslib_1.__extends(GMapPlotCanvasView, _super);
        function GMapPlotCanvasView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        GMapPlotCanvasView.prototype.initialize = function (options) {
            var _this = this;
            this.pause();
            _super.prototype.initialize.call(this, options);
            this._tiles_loaded = false;
            this.zoom_count = 0;
            var mo = this.model.plot.map_options;
            this.initial_zoom = mo.zoom;
            this.initial_lat = mo.lat;
            this.initial_lng = mo.lng;
            this.canvas_view.map_el.style.position = 'absolute';
            if ((window.google != null ? window.google.maps : undefined) == null) {
                if (window._bokeh_gmaps_callback == null) {
                    load_google_api(this.model.plot.api_key);
                }
                gmaps_ready.connect(function () {
                    return _this.request_render();
                });
            }
            this.unpause();
        };
        GMapPlotCanvasView.prototype.update_range = function (range_info) {
            // RESET -------------------------
            if (range_info == null) {
                this.map.setCenter({
                    lat: this.initial_lat,
                    lng: this.initial_lng
                });
                this.map.setOptions({ zoom: this.initial_zoom });
                _super.prototype.update_range.call(this, null);    // PAN ----------------------------
            } else if (range_info.sdx != null || range_info.sdy != null) {
                this.map.panBy(range_info.sdx, range_info.sdy);
                _super.prototype.update_range.call(this, range_info);    // ZOOM ---------------------------
            } else if (range_info.factor != null) {
                // The zoom count decreases the sensitivity of the zoom. (We could make this user configurable)
                var zoom_change = void 0;
                if (this.zoom_count !== 10) {
                    this.zoom_count += 1;
                    return;
                }
                this.zoom_count = 0;
                this.pause();
                _super.prototype.update_range.call(this, range_info);
                if (range_info.factor < 0) {
                    zoom_change = -1;
                } else {
                    zoom_change = 1;
                }
                var old_map_zoom = this.map.getZoom();
                var new_map_zoom = old_map_zoom + zoom_change;
                // Zooming out too far causes problems
                if (new_map_zoom >= 2) {
                    this.map.setZoom(new_map_zoom);
                    // Check we haven't gone out of bounds, and if we have undo the zoom
                    var _a = this._get_projected_bounds(), proj_xstart = _a[0], proj_xend = _a[1];
                    if (proj_xend - proj_xstart < 0) {
                        this.map.setZoom(old_map_zoom);
                    }
                }
                this.unpause();
            }
            // Finally re-center
            return this._set_bokeh_ranges();
        };
        GMapPlotCanvasView.prototype._build_map = function () {
            var _this = this;
            var maps = window.google.maps;
            this.map_types = {
                satellite: maps.MapTypeId.SATELLITE,
                terrain: maps.MapTypeId.TERRAIN,
                roadmap: maps.MapTypeId.ROADMAP,
                hybrid: maps.MapTypeId.HYBRID
            };
            var mo = this.model.plot.map_options;
            var map_options = {
                center: new maps.LatLng(mo.lat, mo.lng),
                zoom: mo.zoom,
                disableDefaultUI: true,
                mapTypeId: this.map_types[mo.map_type],
                scaleControl: mo.scale_control
            };
            if (mo.styles != null) {
                map_options.styles = JSON.parse(mo.styles);
            }
            // create the map with above options in div
            this.map = new maps.Map(this.canvas_view.map_el, map_options);
            // update bokeh ranges whenever the map idles, which should be after most UI action
            maps.event.addListener(this.map, 'idle', function () {
                return _this._set_bokeh_ranges();
            });
            // also need an event when bounds change so that map resizes trigger renders too
            maps.event.addListener(this.map, 'bounds_changed', function () {
                return _this._set_bokeh_ranges();
            });
            maps.event.addListenerOnce(this.map, 'tilesloaded', function () {
                return _this._render_finished();
            });
            // wire up listeners so that changes to properties are reflected
            this.connect(this.model.plot.properties.map_options.change, function () {
                return _this._update_options();
            });
            this.connect(this.model.plot.map_options.properties.styles.change, function () {
                return _this._update_styles();
            });
            this.connect(this.model.plot.map_options.properties.lat.change, function () {
                return _this._update_center('lat');
            });
            this.connect(this.model.plot.map_options.properties.lng.change, function () {
                return _this._update_center('lng');
            });
            this.connect(this.model.plot.map_options.properties.zoom.change, function () {
                return _this._update_zoom();
            });
            this.connect(this.model.plot.map_options.properties.map_type.change, function () {
                return _this._update_map_type();
            });
            return this.connect(this.model.plot.map_options.properties.scale_control.change, function () {
                return _this._update_scale_control();
            });
        };
        GMapPlotCanvasView.prototype._render_finished = function () {
            this._tiles_loaded = true;
            return this.notify_finished();
        };
        GMapPlotCanvasView.prototype.has_finished = function () {
            return _super.prototype.has_finished.call(this) && this._tiles_loaded === true;
        };
        GMapPlotCanvasView.prototype._get_latlon_bounds = function () {
            var bounds = this.map.getBounds();
            var top_right = bounds.getNorthEast();
            var bottom_left = bounds.getSouthWest();
            var xstart = bottom_left.lng();
            var xend = top_right.lng();
            var ystart = bottom_left.lat();
            var yend = top_right.lat();
            return [
                xstart,
                xend,
                ystart,
                yend
            ];
        };
        GMapPlotCanvasView.prototype._get_projected_bounds = function () {
            var _a = this._get_latlon_bounds(), xstart = _a[0], xend = _a[1], ystart = _a[2], yend = _a[3];
            var _b = proj4_1.proj4(proj4_1.mercator, [
                    xstart,
                    ystart
                ]), proj_xstart = _b[0], proj_ystart = _b[1];
            var _c = proj4_1.proj4(proj4_1.mercator, [
                    xend,
                    yend
                ]), proj_xend = _c[0], proj_yend = _c[1];
            return [
                proj_xstart,
                proj_xend,
                proj_ystart,
                proj_yend
            ];
        };
        GMapPlotCanvasView.prototype._set_bokeh_ranges = function () {
            var _a = this._get_projected_bounds(), proj_xstart = _a[0], proj_xend = _a[1], proj_ystart = _a[2], proj_yend = _a[3];
            this.frame.x_range.setv({
                start: proj_xstart,
                end: proj_xend
            });
            return this.frame.y_range.setv({
                start: proj_ystart,
                end: proj_yend
            });
        };
        GMapPlotCanvasView.prototype._update_center = function (fld) {
            var c = this.map.getCenter().toJSON();
            c[fld] = this.model.plot.map_options[fld];
            this.map.setCenter(c);
            return this._set_bokeh_ranges();
        };
        GMapPlotCanvasView.prototype._update_map_type = function () {
            return this.map.setOptions({ mapTypeId: this.map_types[this.model.plot.map_options.map_type] });
        };
        GMapPlotCanvasView.prototype._update_scale_control = function () {
            return this.map.setOptions({ scaleControl: this.model.plot.map_options.scale_control });
        };
        GMapPlotCanvasView.prototype._update_options = function () {
            this._update_styles();
            this._update_center('lat');
            this._update_center('lng');
            this._update_zoom();
            return this._update_map_type();
        };
        GMapPlotCanvasView.prototype._update_styles = function () {
            return this.map.setOptions({ styles: JSON.parse(this.model.plot.map_options.styles) });
        };
        GMapPlotCanvasView.prototype._update_zoom = function () {
            this.map.setOptions({ zoom: this.model.plot.map_options.zoom });
            return this._set_bokeh_ranges();
        };
        // this method is expected and called by PlotCanvasView.render
        GMapPlotCanvasView.prototype._map_hook = function (_ctx, frame_box) {
            var left = frame_box[0], top = frame_box[1], width = frame_box[2], height = frame_box[3];
            this.canvas_view.map_el.style.top = top + 'px';
            this.canvas_view.map_el.style.left = left + 'px';
            this.canvas_view.map_el.style.width = width + 'px';
            this.canvas_view.map_el.style.height = height + 'px';
            if (this.map == null && (window.google != null ? window.google.maps : undefined) != null) {
                return this._build_map();
            }
        };
        // this overrides the standard _paint_empty to make the inner canvas transparent
        GMapPlotCanvasView.prototype._paint_empty = function (ctx, frame_box) {
            var ow = this.canvas._width.value;
            var oh = this.canvas._height.value;
            var left = frame_box[0], top = frame_box[1], iw = frame_box[2], ih = frame_box[3];
            ctx.clearRect(0, 0, ow, oh);
            ctx.beginPath();
            ctx.moveTo(0, 0);
            ctx.lineTo(0, oh);
            ctx.lineTo(ow, oh);
            ctx.lineTo(ow, 0);
            ctx.lineTo(0, 0);
            ctx.moveTo(left, top);
            ctx.lineTo(left + iw, top);
            ctx.lineTo(left + iw, top + ih);
            ctx.lineTo(left, top + ih);
            ctx.lineTo(left, top);
            ctx.closePath();
            ctx.fillStyle = this.model.plot.border_fill_color;
            return ctx.fill();
        };
        return GMapPlotCanvasView;
    }(plot_canvas_1.PlotCanvasView);
    exports.GMapPlotCanvasView = GMapPlotCanvasView;
    var GMapPlotCanvas = function (_super) {
        tslib_1.__extends(GMapPlotCanvas, _super);
        function GMapPlotCanvas(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        GMapPlotCanvas.initClass = function () {
            this.prototype.type = 'GMapPlotCanvas';
            this.prototype.default_view = GMapPlotCanvasView;
        };
        GMapPlotCanvas.prototype.initialize = function () {
            this.use_map = true;
            _super.prototype.initialize.call(this);
        };
        return GMapPlotCanvas;
    }(plot_canvas_1.PlotCanvas);
    exports.GMapPlotCanvas = GMapPlotCanvas;
    GMapPlotCanvas.initClass();    
},
/*models/plots/index*/
function _(require, module, exports) {
    var gmap_plot_1 = require(151    /* ./gmap_plot */);
    exports.MapOptions = gmap_plot_1.MapOptions;
    var gmap_plot_2 = require(151    /* ./gmap_plot */);
    exports.GMapOptions = gmap_plot_2.GMapOptions;
    var gmap_plot_3 = require(151    /* ./gmap_plot */);
    exports.GMapPlot = gmap_plot_3.GMapPlot;
    var gmap_plot_canvas_1 = require(152    /* ./gmap_plot_canvas */);
    exports.GMapPlotCanvas = gmap_plot_canvas_1.GMapPlotCanvas;
    var plot_1 = require(154    /* ./plot */);
    exports.Plot = plot_1.Plot;
    var plot_canvas_1 = require(155    /* ./plot_canvas */);
    exports.PlotCanvas = plot_canvas_1.PlotCanvas;    
},
/*models/plots/plot*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    var solver_1 = require(13    /* core/layout/solver */);
    var logging_1 = require(14    /* core/logging */);
    var p = require(15    /* core/properties */);
    var array_1 = require(22    /* core/util/array */);
    var object_1 = require(31    /* core/util/object */);
    var types_1 = require(43    /* core/util/types */);
    var layout_dom_1 = require(140    /* ../layouts/layout_dom */);
    var title_1 = require(66    /* ../annotations/title */);
    var linear_scale_1 = require(169    /* ../scales/linear_scale */);
    var toolbar_1 = require(238    /* ../tools/toolbar */);
    var toolbar_panel_1 = require(67    /* ../annotations/toolbar_panel */);
    var plot_canvas_1 = require(155    /* ./plot_canvas */);
    var column_data_source_1 = require(174    /* ../sources/column_data_source */);
    var glyph_renderer_1 = require(162    /* ../renderers/glyph_renderer */);
    var bokeh_events_1 = require(3    /* core/bokeh_events */);
    var PlotView = function (_super) {
        tslib_1.__extends(PlotView, _super);
        function PlotView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        PlotView.prototype.connect_signals = function () {
            _super.prototype.connect_signals.call(this);
            // Note: Title object cannot be replaced after initialization, similar to axes, and also
            // not being able to change the sizing_mode. All of these changes require a re-initialization
            // of all constraints which we don't currently support.
            var title_msg = 'Title object cannot be replaced. Try changing properties on title to update it after initialization.';
            this.connect(this.model.properties.title.change, function () {
                return logging_1.logger.warn(title_msg);
            });
        };
        PlotView.prototype.css_classes = function () {
            return _super.prototype.css_classes.call(this).concat('bk-plot-layout');
        };
        PlotView.prototype.get_height = function () {
            return this.model._width.value / this.model.get_aspect_ratio();
        };
        PlotView.prototype.get_width = function () {
            return this.model._height.value * this.model.get_aspect_ratio();
        };
        PlotView.prototype.save = function (name) {
            this.plot_canvas_view.save(name);
        };
        Object.defineProperty(PlotView.prototype, 'plot_canvas_view', {
            get: function () {
                // XXX: PlotCanvasView is not LayoutDOMView
                return this.child_views[this.model.plot_canvas.id];
            },
            enumerable: true,
            configurable: true
        });
        return PlotView;
    }(layout_dom_1.LayoutDOMView);
    exports.PlotView = PlotView;
    var Plot = function (_super) {
        tslib_1.__extends(Plot, _super);
        function Plot(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        Plot.initClass = function () {
            this.prototype.type = 'Plot';
            this.prototype.default_view = PlotView;
            this.mixins([
                'line:outline_',
                'fill:background_',
                'fill:border_'
            ]);
            this.define({
                toolbar: [
                    p.Instance,
                    function () {
                        return new toolbar_1.Toolbar();
                    }
                ],
                toolbar_location: [
                    p.Location,
                    'right'
                ],
                toolbar_sticky: [
                    p.Boolean,
                    true
                ],
                plot_width: [
                    p.Number,
                    600
                ],
                plot_height: [
                    p.Number,
                    600
                ],
                title: [
                    p.Any,
                    function () {
                        return new title_1.Title({ text: '' });
                    }
                ],
                title_location: [
                    p.Location,
                    'above'
                ],
                h_symmetry: [
                    p.Bool,
                    true
                ],
                v_symmetry: [
                    p.Bool,
                    false
                ],
                above: [
                    p.Array,
                    []
                ],
                below: [
                    p.Array,
                    []
                ],
                left: [
                    p.Array,
                    []
                ],
                right: [
                    p.Array,
                    []
                ],
                renderers: [
                    p.Array,
                    []
                ],
                x_range: [p.Instance],
                extra_x_ranges: [
                    p.Any,
                    {}
                ],
                y_range: [p.Instance],
                extra_y_ranges: [
                    p.Any,
                    {}
                ],
                x_scale: [
                    p.Instance,
                    function () {
                        return new linear_scale_1.LinearScale();
                    }
                ],
                y_scale: [
                    p.Instance,
                    function () {
                        return new linear_scale_1.LinearScale();
                    }
                ],
                lod_factor: [
                    p.Number,
                    10
                ],
                lod_interval: [
                    p.Number,
                    300
                ],
                lod_threshold: [
                    p.Number,
                    2000
                ],
                lod_timeout: [
                    p.Number,
                    500
                ],
                hidpi: [
                    p.Bool,
                    true
                ],
                output_backend: [
                    p.OutputBackend,
                    'canvas'
                ],
                min_border: [
                    p.Number,
                    5
                ],
                min_border_top: [
                    p.Number,
                    null
                ],
                min_border_left: [
                    p.Number,
                    null
                ],
                min_border_bottom: [
                    p.Number,
                    null
                ],
                min_border_right: [
                    p.Number,
                    null
                ],
                inner_width: [p.Number],
                inner_height: [p.Number],
                layout_width: [p.Number],
                layout_height: [p.Number],
                match_aspect: [
                    p.Bool,
                    false
                ],
                aspect_scale: [
                    p.Number,
                    1
                ]
            });
            this.override({
                outline_line_color: '#e5e5e5',
                border_fill_color: '#ffffff',
                background_fill_color: '#ffffff'
            });
            bokeh_events_1.register_with_event(bokeh_events_1.UIEvent, this);
        };
        Plot.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            for (var _i = 0, _a = object_1.values(this.extra_x_ranges).concat(this.x_range); _i < _a.length; _i++) {
                var xr = _a[_i];
                var plots = xr.plots;
                if (types_1.isArray(plots)) {
                    plots = plots.concat(this);
                    xr.setv({ plots: plots }, { silent: true });
                }
            }
            for (var _b = 0, _c = object_1.values(this.extra_y_ranges).concat(this.y_range); _b < _c.length; _b++) {
                var yr = _c[_b];
                var plots = yr.plots;
                if (types_1.isArray(plots)) {
                    plots = plots.concat(this);
                    yr.setv({ plots: plots }, { silent: true });
                }
            }
            // Min border applies to the edge of everything
            if (this.min_border != null) {
                if (this.min_border_top == null)
                    this.min_border_top = this.min_border;
                if (this.min_border_bottom == null)
                    this.min_border_bottom = this.min_border;
                if (this.min_border_left == null)
                    this.min_border_left = this.min_border;
                if (this.min_border_right == null)
                    this.min_border_right = this.min_border;
            }
            this._init_title_panel();
            this._init_toolbar_panel();
            this._plot_canvas = this._init_plot_canvas();
            this.plot_canvas.toolbar = this.toolbar;
            // Set width & height to be the passed in plot_width and plot_height
            // We may need to be more subtle about this - not sure why people use one
            // or the other.
            if (this.width == null)
                this.width = this.plot_width;
            if (this.height == null)
                this.height = this.plot_height;
            // Setup side renderers
            for (var _d = 0, _e = [
                        'above',
                        'below',
                        'left',
                        'right'
                    ]; _d < _e.length; _d++) {
                var side = _e[_d];
                var layout_renderers = this.getv(side);
                for (var _f = 0, layout_renderers_1 = layout_renderers; _f < layout_renderers_1.length; _f++) {
                    var renderer = layout_renderers_1[_f];
                    renderer.add_panel(side);
                }
            }
        };
        Plot.prototype._init_plot_canvas = function () {
            return new plot_canvas_1.PlotCanvas({ plot: this });
        };
        Plot.prototype._init_title_panel = function () {
            if (this.title != null) {
                var title = types_1.isString(this.title) ? new title_1.Title({ text: this.title }) : this.title;
                this.add_layout(title, this.title_location);
            }
        };
        Plot.prototype._init_toolbar_panel = function () {
            var _this = this;
            var tpanel = array_1.find(this.renderers, function (model) {
                return model instanceof toolbar_panel_1.ToolbarPanel && array_1.includes(model.tags, _this.id);
            });
            if (tpanel != null)
                this.remove_layout(tpanel);
            switch (this.toolbar_location) {
            case 'left':
            case 'right':
            case 'above':
            case 'below': {
                    tpanel = new toolbar_panel_1.ToolbarPanel({
                        toolbar: this.toolbar,
                        tags: [this.id]
                    });
                    this.toolbar.toolbar_location = this.toolbar_location;
                    if (this.toolbar_sticky) {
                        var models = this.getv(this.toolbar_location);
                        var title = array_1.find(models, function (model) {
                            return model instanceof title_1.Title;
                        });
                        if (title != null) {
                            tpanel.set_panel(title.panel);
                            // XXX, XXX: because find() doesn't provide narrowed types
                            this.add_renderers(tpanel);
                            return;
                        }
                    }
                    this.add_layout(tpanel, this.toolbar_location);
                    break;
                }
            }
        };
        Plot.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            this.connect(this.properties.toolbar_location.change, function () {
                return _this._init_toolbar_panel();
            });
        };
        Object.defineProperty(Plot.prototype, 'plot_canvas', {
            get: function () {
                return this._plot_canvas;
            },
            enumerable: true,
            configurable: true
        });
        Plot.prototype._doc_attached = function () {
            this.plot_canvas.attach_document(this.document);
            // XXX!
            _super.prototype._doc_attached.call(this);
        };
        Plot.prototype.add_renderers = function () {
            var new_renderers = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                new_renderers[_i] = arguments[_i];
            }
            var renderers = this.renderers;
            renderers = renderers.concat(new_renderers);
            this.renderers = renderers;
        };
        Plot.prototype.add_layout = function (renderer, side) {
            if (side === void 0) {
                side = 'center';
            }
            if (renderer.props.plot != null)
                renderer.plot = this;
            // XXX
            if (side != 'center') {
                var side_renderers = this.getv(side);
                side_renderers.push(renderer);
                renderer.add_panel(side);    // XXX
            }
            this.add_renderers(renderer);
        };
        Plot.prototype.remove_layout = function (renderer) {
            var del = function (items) {
                array_1.removeBy(items, function (item) {
                    return item == renderer;
                });
            };
            del(this.left);
            del(this.right);
            del(this.above);
            del(this.below);
            del(this.renderers);
        };
        Plot.prototype.add_glyph = function (glyph, source, extra_attrs) {
            if (source === void 0) {
                source = new column_data_source_1.ColumnDataSource();
            }
            if (extra_attrs === void 0) {
                extra_attrs = {};
            }
            var attrs = object_1.extend({}, extra_attrs, {
                data_source: source,
                glyph: glyph
            });
            var renderer = new glyph_renderer_1.GlyphRenderer(attrs);
            this.add_renderers(renderer);
            return renderer;
        };
        Plot.prototype.add_tools = function () {
            var tools = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                tools[_i] = arguments[_i];
            }
            for (var _a = 0, tools_1 = tools; _a < tools_1.length; _a++) {
                var tool = tools_1[_a];
                if (tool.overlay != null)
                    this.add_renderers(tool.overlay);
            }
            this.toolbar.tools = this.toolbar.tools.concat(tools);
        };
        Plot.prototype.get_layoutable_children = function () {
            return [this.plot_canvas];
        };
        Plot.prototype.get_constraints = function () {
            var constraints = _super.prototype.get_constraints.call(this);
            constraints.push(solver_1.EQ(this._width, [
                -1,
                this.plot_canvas._width
            ]));
            constraints.push(solver_1.EQ(this._height, [
                -1,
                this.plot_canvas._height
            ]));
            return constraints;
        };
        Plot.prototype.get_constrained_variables = function () {
            var vars = object_1.extend({}, _super.prototype.get_constrained_variables.call(this), {
                on_edge_align_top: this.plot_canvas._top,
                on_edge_align_bottom: this.plot_canvas._height_minus_bottom,
                on_edge_align_left: this.plot_canvas._left,
                on_edge_align_right: this.plot_canvas._width_minus_right,
                box_cell_align_top: this.plot_canvas._top,
                box_cell_align_bottom: this.plot_canvas._height_minus_bottom,
                box_cell_align_left: this.plot_canvas._left,
                box_cell_align_right: this.plot_canvas._width_minus_right,
                box_equal_size_top: this.plot_canvas._top,
                box_equal_size_bottom: this.plot_canvas._height_minus_bottom
            });
            if (this.sizing_mode != 'fixed') {
                vars.box_equal_size_left = this.plot_canvas._left;
                vars.box_equal_size_right = this.plot_canvas._width_minus_right;
            }
            return vars;
        };
        Object.defineProperty(Plot.prototype, 'all_renderers', {
            get: function () {
                var renderers = this.renderers;
                for (var _i = 0, _a = this.toolbar.tools; _i < _a.length; _i++) {
                    var tool = _a[_i];
                    renderers = renderers.concat(tool.synthetic_renderers);
                }
                return renderers;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Plot.prototype, 'webgl', {
            get: function () {
                logging_1.logger.warn('webgl attr is deprecated, use output_backend');
                return this.output_backend == 'webgl';
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Plot.prototype, 'tool_events', {
            get: function () {
                logging_1.logger.warn('tool_events attr is deprecated, use SelectionGeometry Event');
                return null;
            },
            enumerable: true,
            configurable: true
        });
        return Plot;
    }(layout_dom_1.LayoutDOM);
    exports.Plot = Plot;
    Plot.initClass();    
},
/*models/plots/plot_canvas*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    /* XXX: partial */
    var canvas_1 = require(80    /* ../canvas/canvas */);
    var cartesian_frame_1 = require(81    /* ../canvas/cartesian_frame */);
    var data_range1d_1 = require(157    /* ../ranges/data_range1d */);
    var glyph_renderer_1 = require(162    /* ../renderers/glyph_renderer */);
    var layout_dom_1 = require(140    /* ../layouts/layout_dom */);
    var signaling_1 = require(20    /* core/signaling */);
    var build_views_1 = require(4    /* core/build_views */);
    var ui_events_1 = require(21    /* core/ui_events */);
    var visuals_1 = require(47    /* core/visuals */);
    var dom_view_1 = require(6    /* core/dom_view */);
    var layout_canvas_1 = require(11    /* core/layout/layout_canvas */);
    var alignments_1 = require(10    /* core/layout/alignments */);
    var solver_1 = require(13    /* core/layout/solver */);
    var logging_1 = require(14    /* core/logging */);
    var enums = require(7    /* core/enums */);
    var p = require(15    /* core/properties */);
    var throttle_1 = require(42    /* core/util/throttle */);
    var types_1 = require(43    /* core/util/types */);
    var array_1 = require(22    /* core/util/array */);
    var object_1 = require(31    /* core/util/object */);
    var side_panel_1 = require(12    /* core/layout/side_panel */);
    // Notes on WebGL support:
    // Glyps can be rendered into the original 2D canvas, or in a (hidden)
    // webgl canvas that we create below. In this way, the rest of bokehjs
    // can keep working as it is, and we can incrementally update glyphs to
    // make them use GL.
    //
    // When the author or user wants to, we try to create a webgl canvas,
    // which is saved on the ctx object that gets passed around during drawing.
    // The presence (and not-being-false) of the ctx.glcanvas attribute is the
    // marker that we use throughout that determines whether we have gl support.
    var global_glcanvas = null;
    var PlotCanvasView = function (_super) {
        tslib_1.__extends(PlotCanvasView, _super);
        function PlotCanvasView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        PlotCanvasView.prototype.css_classes = function () {
            return _super.prototype.css_classes.call(this).concat('bk-plot-wrapper');
        };
        Object.defineProperty(PlotCanvasView.prototype, 'canvas_overlays', {
            get: function () {
                return this.canvas_view.overlays_el;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(PlotCanvasView.prototype, 'canvas_events', {
            get: function () {
                return this.canvas_view.events_el;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(PlotCanvasView.prototype, 'is_paused', {
            get: function () {
                return this._is_paused != null && this._is_paused !== 0;
            },
            enumerable: true,
            configurable: true
        });
        PlotCanvasView.prototype.view_options = function () {
            return object_1.extend({
                plot_view: this,
                parent: this
            }, this.options);
        };
        PlotCanvasView.prototype.pause = function () {
            if (this._is_paused == null) {
                return this._is_paused = 1;
            } else {
                return this._is_paused += 1;
            }
        };
        PlotCanvasView.prototype.unpause = function (no_render) {
            if (no_render === void 0) {
                no_render = false;
            }
            this._is_paused -= 1;
            if (this._is_paused === 0 && !no_render) {
                return this.request_render();
            }
        };
        PlotCanvasView.prototype.request_render = function () {
            return this.request_paint();
        };
        PlotCanvasView.prototype.request_paint = function () {
            if (!this.is_paused) {
                this.throttled_paint();
            }
        };
        PlotCanvasView.prototype.remove = function () {
            build_views_1.remove_views(this.renderer_views);
            build_views_1.remove_views(this.tool_views);
            this.canvas_view.remove();
            this.canvas_view = null;
            return _super.prototype.remove.call(this);
        };
        PlotCanvasView.prototype.initialize = function (options) {
            var _this = this;
            this.pause();
            _super.prototype.initialize.call(this, options);
            this.force_paint = new signaling_1.Signal(this, 'force_paint');
            this.state_changed = new signaling_1.Signal(this, 'state_changed');
            this.lod_started = false;
            this.visuals = new visuals_1.Visuals(this.model.plot);
            this._initial_state_info = {
                range: null,
                selection: {},
                dimensions: {
                    width: this.model.canvas._width.value,
                    height: this.model.canvas._height.value
                }
            };
            this.state = {
                history: [],
                index: -1
            };
            // compat, to be removed
            this.frame = this.model.frame;
            this.canvas = this.model.canvas;
            this.canvas_view = new this.canvas.default_view({
                model: this.canvas,
                parent: this
            });
            this.el.appendChild(this.canvas_view.el);
            this.canvas_view.render();
            // If requested, try enabling webgl
            if (this.model.plot.output_backend === 'webgl') {
                this.init_webgl();
            }
            this.throttled_paint = throttle_1.throttle(function () {
                return _this.force_paint.emit(undefined);
            }, 15);
            // TODO (bev) configurable
            this.ui_event_bus = new ui_events_1.UIEvents(this, this.model.toolbar, this.canvas_view.el, this.model.plot);
            this.levels = {};
            for (var _i = 0, _a = enums.RenderLevel; _i < _a.length; _i++) {
                var level = _a[_i];
                this.levels[level] = {};
            }
            this.renderer_views = {};
            this.tool_views = {};
            this.build_levels();
            this.build_tools();
            this.update_dataranges();
            this.unpause(true);
            logging_1.logger.debug('PlotView initialized');
        };
        PlotCanvasView.prototype.set_cursor = function (cursor) {
            if (cursor === void 0) {
                cursor = 'default';
            }
            return this.canvas_view.el.style.cursor = cursor;
        };
        PlotCanvasView.prototype.init_webgl = function () {
            var ctx = this.canvas_view.ctx;
            // We use a global invisible canvas and gl context. By having a global context,
            // we avoid the limitation of max 16 contexts that most browsers have.
            var glcanvas = global_glcanvas;
            if (glcanvas == null) {
                global_glcanvas = glcanvas = document.createElement('canvas');
                var opts = { 'premultipliedAlpha': true };
                // premultipliedAlpha is true by default
                glcanvas.gl = glcanvas.getContext('webgl', opts) || glcanvas.getContext('experimental-webgl', opts);
            }
            // If WebGL is available, we store a reference to the gl canvas on
            // the ctx object, because that's what gets passed everywhere.
            if (glcanvas.gl != null) {
                return ctx.glcanvas = glcanvas;
            } else {
                return logging_1.logger.warn('WebGL is not supported, falling back to 2D canvas.');
            }
        };
        PlotCanvasView.prototype.prepare_webgl = function (ratio, frame_box) {
            // Prepare WebGL for a drawing pass
            var ctx = this.canvas_view.ctx;
            var canvas = this.canvas_view.get_canvas_element();
            if (ctx.glcanvas) {
                // Sync canvas size
                ctx.glcanvas.width = canvas.width;
                ctx.glcanvas.height = canvas.height;
                // Prepare GL for drawing
                var gl = ctx.glcanvas.gl;
                gl.viewport(0, 0, ctx.glcanvas.width, ctx.glcanvas.height);
                gl.clearColor(0, 0, 0, 0);
                gl.clear(gl.COLOR_BUFFER_BIT || gl.DEPTH_BUFFER_BIT);
                // Clipping
                gl.enable(gl.SCISSOR_TEST);
                gl.scissor(ratio * frame_box[0], ratio * frame_box[1], ratio * frame_box[2], ratio * frame_box[3]);
                // Setup blending
                gl.enable(gl.BLEND);
                gl.blendFuncSeparate(gl.SRC_ALPHA, gl.ONE_MINUS_SRC_ALPHA, gl.ONE_MINUS_DST_ALPHA, gl.ONE);    // premultipliedAlpha == true
            }
        };
        //gl.blendFuncSeparate(gl.ONE_MINUS_DST_ALPHA, gl.DST_ALPHA, gl.ONE_MINUS_DST_ALPHA, gl.ONE)  # Without premultipliedAlpha == false
        PlotCanvasView.prototype.blit_webgl = function (ratio) {
            // This should be called when the ctx has no state except the HIDPI transform
            var ctx = this.canvas_view.ctx;
            if (ctx.glcanvas) {
                // Blit gl canvas into the 2D canvas. To do 1-on-1 blitting, we need
                // to remove the hidpi transform, then blit, then restore.
                // ctx.globalCompositeOperation = "source-over"  -> OK; is the default
                logging_1.logger.debug('drawing with WebGL');
                ctx.restore();
                ctx.drawImage(ctx.glcanvas, 0, 0);
                // Set back hidpi transform
                ctx.save();
                ctx.scale(ratio, ratio);
                return ctx.translate(0.5, 0.5);
            }
        };
        PlotCanvasView.prototype.update_dataranges = function () {
            // Update any DataRange1ds here
            var bounds_to_use;
            var frame = this.model.frame;
            var bounds = {};
            var log_bounds = {};
            var calculate_log_bounds = false;
            for (var _i = 0, _a = object_1.values(frame.x_ranges).concat(object_1.values(frame.y_ranges)); _i < _a.length; _i++) {
                var r_1 = _a[_i];
                if (r_1 instanceof data_range1d_1.DataRange1d) {
                    if (r_1.scale_hint === 'log') {
                        calculate_log_bounds = true;
                    }
                }
            }
            for (var k in this.renderer_views) {
                var v = this.renderer_views[k];
                var bds = __guardMethod__(v.glyph, 'bounds', function (o) {
                    return o.bounds();
                });
                if (bds != null) {
                    bounds[k] = bds;
                }
                if (calculate_log_bounds) {
                    var log_bds = __guardMethod__(v.glyph, 'log_bounds', function (o1) {
                        return o1.log_bounds();
                    });
                    if (log_bds != null) {
                        log_bounds[k] = log_bds;
                    }
                }
            }
            var follow_enabled = false;
            var has_bounds = false;
            var r = null;
            if (this.model.plot.match_aspect !== false && this.frame._width.value !== 0 && this.frame._height.value !== 0) {
                r = 1 / this.model.plot.aspect_scale * (this.frame._width.value / this.frame._height.value);
            }
            for (var _b = 0, _c = object_1.values(frame.x_ranges); _b < _c.length; _b++) {
                var xr = _c[_b];
                if (xr instanceof data_range1d_1.DataRange1d) {
                    bounds_to_use = xr.scale_hint === 'log' ? log_bounds : bounds;
                    xr.update(bounds_to_use, 0, this.model.id, r);
                    if (xr.follow) {
                        follow_enabled = true;
                    }
                }
                if (xr.bounds != null) {
                    has_bounds = true;
                }
            }
            for (var _d = 0, _e = object_1.values(frame.y_ranges); _d < _e.length; _d++) {
                var yr = _e[_d];
                if (yr instanceof data_range1d_1.DataRange1d) {
                    bounds_to_use = yr.scale_hint === 'log' ? log_bounds : bounds;
                    yr.update(bounds_to_use, 1, this.model.id, r);
                    if (yr.follow) {
                        follow_enabled = true;
                    }
                }
                if (yr.bounds != null) {
                    has_bounds = true;
                }
            }
            if (follow_enabled && has_bounds) {
                logging_1.logger.warn('Follow enabled so bounds are unset.');
                for (var _f = 0, _g = object_1.values(frame.x_ranges); _f < _g.length; _f++) {
                    var xr = _g[_f];
                    xr.bounds = null;
                }
                for (var _h = 0, _j = object_1.values(frame.y_ranges); _h < _j.length; _h++) {
                    var yr = _j[_h];
                    yr.bounds = null;
                }
            }
            return this.range_update_timestamp = Date.now();
        };
        PlotCanvasView.prototype.map_to_screen = function (x, y, x_name, y_name) {
            if (x_name === void 0) {
                x_name = 'default';
            }
            if (y_name === void 0) {
                y_name = 'default';
            }
            return this.frame.map_to_screen(x, y, x_name, y_name);
        };
        PlotCanvasView.prototype.push_state = function (type, info) {
            var prev_info = (this.state.history[this.state.index] != null ? this.state.history[this.state.index].info : undefined) || {};
            info = object_1.extend({}, this._initial_state_info, prev_info, info);
            this.state.history.slice(0, this.state.index + 1);
            this.state.history.push({
                type: type,
                info: info
            });
            this.state.index = this.state.history.length - 1;
            return this.state_changed.emit(undefined);
        };
        PlotCanvasView.prototype.clear_state = function () {
            this.state = {
                history: [],
                index: -1
            };
            return this.state_changed.emit(undefined);
        };
        PlotCanvasView.prototype.can_undo = function () {
            return this.state.index >= 0;
        };
        PlotCanvasView.prototype.can_redo = function () {
            return this.state.index < this.state.history.length - 1;
        };
        PlotCanvasView.prototype.undo = function () {
            if (this.can_undo()) {
                this.state.index -= 1;
                this._do_state_change(this.state.index);
                return this.state_changed.emit(undefined);
            }
        };
        PlotCanvasView.prototype.redo = function () {
            if (this.can_redo()) {
                this.state.index += 1;
                this._do_state_change(this.state.index);
                return this.state_changed.emit(undefined);
            }
        };
        PlotCanvasView.prototype._do_state_change = function (index) {
            var info = (this.state.history[index] != null ? this.state.history[index].info : undefined) || this._initial_state_info;
            if (info.range != null) {
                this.update_range(info.range);
            }
            if (info.selection != null) {
                return this.update_selection(info.selection);
            }
        };
        PlotCanvasView.prototype.get_selection = function () {
            var selection = {};
            for (var _i = 0, _a = this.model.plot.renderers; _i < _a.length; _i++) {
                var renderer = _a[_i];
                if (renderer instanceof glyph_renderer_1.GlyphRenderer) {
                    var selected = renderer.data_source.selected;
                    selection[renderer.id] = selected;
                }
            }
            return selection;
        };
        PlotCanvasView.prototype.update_selection = function (selection) {
            for (var _i = 0, _a = this.model.plot.renderers; _i < _a.length; _i++) {
                var renderer = _a[_i];
                if (!(renderer instanceof glyph_renderer_1.GlyphRenderer)) {
                    continue;
                }
                var ds = renderer.data_source;
                if (selection != null) {
                    if (array_1.includes(selection, renderer.id)) {
                        ds.selected = selection[renderer.id];
                    }
                } else {
                    ds.selection_manager.clear();
                }
            }
        };
        PlotCanvasView.prototype.reset_selection = function () {
            return this.update_selection(null);
        };
        PlotCanvasView.prototype._update_ranges_together = function (range_info_iter) {
            // Get weight needed to scale the diff of the range to honor interval limits
            var weight = 1;
            for (var _i = 0, range_info_iter_1 = range_info_iter; _i < range_info_iter_1.length; _i++) {
                var _a = range_info_iter_1[_i], rng = _a[0], range_info = _a[1];
                weight = Math.min(weight, this._get_weight_to_constrain_interval(rng, range_info));
            }
            // Apply shared weight to all ranges
            if (weight < 1) {
                for (var _b = 0, range_info_iter_2 = range_info_iter; _b < range_info_iter_2.length; _b++) {
                    var _c = range_info_iter_2[_b], rng = _c[0], range_info = _c[1];
                    range_info['start'] = weight * range_info['start'] + (1 - weight) * rng.start;
                    range_info['end'] = weight * range_info['end'] + (1 - weight) * rng.end;
                }
            }
        };
        PlotCanvasView.prototype._update_ranges_individually = function (range_info_iter, is_panning, is_scrolling) {
            var hit_bound = false;
            for (var _i = 0, range_info_iter_3 = range_info_iter; _i < range_info_iter_3.length; _i++) {
                var _a = range_info_iter_3[_i], rng = _a[0], range_info = _a[1];
                // Is this a reversed range?
                var is_reversed = rng.start > rng.end;
                // Limit range interval first. Note that for scroll events,
                // the interval has already been limited for all ranges simultaneously
                if (!is_scrolling) {
                    var weight = this._get_weight_to_constrain_interval(rng, range_info);
                    if (weight < 1) {
                        range_info['start'] = weight * range_info['start'] + (1 - weight) * rng.start;
                        range_info['end'] = weight * range_info['end'] + (1 - weight) * rng.end;
                    }
                }
                // Prevent range from going outside limits
                // Also ensure that range keeps the same delta when panning/scrolling
                if (rng.bounds != null) {
                    var min = rng.bounds[0];
                    var max = rng.bounds[1];
                    var new_interval = Math.abs(range_info['end'] - range_info['start']);
                    if (is_reversed) {
                        if (min != null) {
                            if (min >= range_info['end']) {
                                hit_bound = true;
                                range_info['end'] = min;
                                if (is_panning || is_scrolling) {
                                    range_info['start'] = min + new_interval;
                                }
                            }
                        }
                        if (max != null) {
                            if (max <= range_info['start']) {
                                hit_bound = true;
                                range_info['start'] = max;
                                if (is_panning || is_scrolling) {
                                    range_info['end'] = max - new_interval;
                                }
                            }
                        }
                    } else {
                        if (min != null) {
                            if (min >= range_info['start']) {
                                hit_bound = true;
                                range_info['start'] = min;
                                if (is_panning || is_scrolling) {
                                    range_info['end'] = min + new_interval;
                                }
                            }
                        }
                        if (max != null) {
                            if (max <= range_info['end']) {
                                hit_bound = true;
                                range_info['end'] = max;
                                if (is_panning || is_scrolling) {
                                    range_info['start'] = max - new_interval;
                                }
                            }
                        }
                    }
                }
            }
            // Cancel the event when hitting a bound while scrolling. This ensures that
            // the scroll-zoom tool maintains its focus position. Disabling the next
            // two lines would result in a more "gliding" behavior, allowing one to
            // zoom out more smoothly, at the cost of losing the focus position.
            if (is_scrolling && hit_bound) {
                return;
            }
            for (var _b = 0, range_info_iter_4 = range_info_iter; _b < range_info_iter_4.length; _b++) {
                var _c = range_info_iter_4[_b], rng = _c[0], range_info = _c[1];
                rng.have_updated_interactively = true;
                if (rng.start !== range_info['start'] || rng.end !== range_info['end']) {
                    rng.setv(range_info);
                }
            }
        };
        PlotCanvasView.prototype._get_weight_to_constrain_interval = function (rng, range_info) {
            // Get the weight by which a range-update can be applied
            // to still honor the interval limits (including the implicit
            // max interval imposed by the bounds)
            var max, min;
            var min_interval = rng.min_interval;
            var max_interval = rng.max_interval;
            var weight = 1;
            // Express bounds as a max_interval. By doing this, the application of
            // bounds and interval limits can be applied independent from each-other.
            if (rng.bounds != null) {
                _a = rng.bounds, min = _a[0], max = _a[1];
                if (min != null && max != null) {
                    var max_interval2 = Math.abs(max - min);
                    max_interval = max_interval != null ? Math.min(max_interval, max_interval2) : max_interval2;
                }
            }
            if (min_interval != null || max_interval != null) {
                var old_interval = Math.abs(rng.end - rng.start);
                var new_interval = Math.abs(range_info['end'] - range_info['start']);
                if (min_interval > 0 && new_interval < min_interval) {
                    weight = (old_interval - min_interval) / (old_interval - new_interval);
                }
                if (max_interval > 0 && new_interval > max_interval) {
                    weight = (max_interval - old_interval) / (new_interval - old_interval);
                }
                weight = Math.max(0, Math.min(1, weight));
            }
            return weight;
            var _a;
        };
        PlotCanvasView.prototype.update_range = function (range_info, is_panning, is_scrolling) {
            if (is_panning === void 0) {
                is_panning = false;
            }
            if (is_scrolling === void 0) {
                is_scrolling = false;
            }
            this.pause();
            if (range_info == null) {
                for (var name_1 in this.frame.x_ranges) {
                    var rng = this.frame.x_ranges[name_1];
                    rng.reset();
                }
                for (var name_2 in this.frame.y_ranges) {
                    var rng = this.frame.y_ranges[name_2];
                    rng.reset();
                }
                this.update_dataranges();
            } else {
                var range_info_iter = [];
                for (var name_3 in this.frame.x_ranges) {
                    var rng = this.frame.x_ranges[name_3];
                    range_info_iter.push([
                        rng,
                        range_info.xrs[name_3]
                    ]);
                }
                for (var name_4 in this.frame.y_ranges) {
                    var rng = this.frame.y_ranges[name_4];
                    range_info_iter.push([
                        rng,
                        range_info.yrs[name_4]
                    ]);
                }
                if (is_scrolling) {
                    this._update_ranges_together(range_info_iter);    // apply interval bounds while keeping aspect
                }
                this._update_ranges_individually(range_info_iter, is_panning, is_scrolling);
            }
            this.unpause();
        };
        PlotCanvasView.prototype.reset_range = function () {
            this.update_range(null);
        };
        PlotCanvasView.prototype.build_levels = function () {
            var renderer_models = this.model.plot.all_renderers;
            // should only bind events on NEW views
            var old_renderers = Object.keys(this.renderer_views);
            var new_renderer_views = build_views_1.build_views(this.renderer_views, renderer_models, this.view_options());
            var renderers_to_remove = array_1.difference(old_renderers, renderer_models.map(function (model) {
                return model.id;
            }));
            for (var _i = 0, renderers_to_remove_1 = renderers_to_remove; _i < renderers_to_remove_1.length; _i++) {
                var id_ = renderers_to_remove_1[_i];
                delete this.levels.glyph[id_];
            }
            for (var _a = 0, new_renderer_views_1 = new_renderer_views; _a < new_renderer_views_1.length; _a++) {
                var view = new_renderer_views_1[_a];
                this.levels[view.model.level][view.model.id] = view;
            }
            return this;
        };
        PlotCanvasView.prototype.get_renderer_views = function () {
            var _this = this;
            return this.model.plot.renderers.map(function (r) {
                return _this.levels[r.level][r.id];
            });
        };
        PlotCanvasView.prototype.build_tools = function () {
            var _this = this;
            var tool_models = this.model.plot.toolbar.tools;
            var new_tool_views = build_views_1.build_views(this.tool_views, tool_models, this.view_options());
            return new_tool_views.map(function (tool_view) {
                return _this.ui_event_bus.register_tool(tool_view);
            });
        };
        PlotCanvasView.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            this.connect(this.force_paint, function () {
                return _this.repaint();
            });
            var _a = this.model.frame, x_ranges = _a.x_ranges, y_ranges = _a.y_ranges;
            for (var name_5 in x_ranges) {
                var rng = x_ranges[name_5];
                this.connect(rng.change, function () {
                    return _this.request_render();
                });
            }
            for (var name_6 in y_ranges) {
                var rng = y_ranges[name_6];
                this.connect(rng.change, function () {
                    return _this.request_render();
                });
            }
            this.connect(this.model.plot.properties.renderers.change, function () {
                return _this.build_levels();
            });
            this.connect(this.model.plot.toolbar.properties.tools.change, function () {
                _this.build_levels();
                return _this.build_tools();
            });
            this.connect(this.model.plot.change, function () {
                return _this.request_render();
            });
        };
        PlotCanvasView.prototype.set_initial_range = function () {
            // check for good values for ranges before setting initial range
            var good_vals = true;
            var xrs = {};
            var yrs = {};
            for (var name_7 in this.frame.x_ranges) {
                var rng = this.frame.x_ranges[name_7];
                if (rng.start == null || rng.end == null || types_1.isStrictNaN(rng.start + rng.end)) {
                    good_vals = false;
                    break;
                }
                xrs[name_7] = {
                    start: rng.start,
                    end: rng.end
                };
            }
            if (good_vals) {
                for (var name_8 in this.frame.y_ranges) {
                    var rng = this.frame.y_ranges[name_8];
                    if (rng.start == null || rng.end == null || types_1.isStrictNaN(rng.start + rng.end)) {
                        good_vals = false;
                        break;
                    }
                    yrs[name_8] = {
                        start: rng.start,
                        end: rng.end
                    };
                }
            }
            if (good_vals) {
                this._initial_state_info.range = this.initial_range_info = {
                    xrs: xrs,
                    yrs: yrs
                };
                return logging_1.logger.debug('initial ranges set');
            } else {
                return logging_1.logger.warn('could not set initial ranges');
            }
        };
        PlotCanvasView.prototype.update_constraints = function () {
            this.solver.suggest_value(this.frame._width, this.canvas._width.value);
            this.solver.suggest_value(this.frame._height, this.canvas._height.value);
            for (var _ in this.renderer_views) {
                var view = this.renderer_views[_];
                if (view.model.panel != null) {
                    side_panel_1.update_panel_constraints(view);
                }
            }
            return this.solver.update_variables();
        };
        // XXX: bacause PlotCanvas is NOT a LayoutDOM
        PlotCanvasView.prototype._layout = function (final) {
            if (final === void 0) {
                final = false;
            }
            this.render();
            if (final) {
                this.model.plot.setv({
                    inner_width: Math.round(this.frame._width.value),
                    inner_height: Math.round(this.frame._height.value),
                    layout_width: Math.round(this.canvas._width.value),
                    layout_height: Math.round(this.canvas._height.value)
                }, { no_change: true });
                // XXX: can't be @request_paint(), because it would trigger back-and-forth
                // layout recomputing feedback loop between plots. Plots are also much more
                // responsive this way, especially in interactive mode.
                return this.paint();
            }
        };
        PlotCanvasView.prototype.has_finished = function () {
            if (!_super.prototype.has_finished.call(this)) {
                return false;
            }
            for (var level in this.levels) {
                var renderer_views = this.levels[level];
                for (var id in renderer_views) {
                    var view = renderer_views[id];
                    if (!view.has_finished()) {
                        return false;
                    }
                }
            }
            return true;
        };
        PlotCanvasView.prototype.render = function () {
            // Set the plot and canvas to the current model's size
            // This gets called upon solver resize events
            var width = this.model._width.value;
            var height = this.model._height.value;
            this.canvas_view.set_dims([
                width,
                height
            ]);
            this.update_constraints();
            if (this.model.plot.match_aspect !== false && this.frame._width.value !== 0 && this.frame._height.value !== 0) {
                this.update_dataranges();
            }
            // This allows the plot canvas to be positioned around the toolbar
            this.el.style.position = 'absolute';
            this.el.style.left = this.model._dom_left.value + 'px';
            this.el.style.top = this.model._dom_top.value + 'px';
            this.el.style.width = this.model._width.value + 'px';
            return this.el.style.height = this.model._height.value + 'px';
        };
        PlotCanvasView.prototype._needs_layout = function () {
            for (var _ in this.renderer_views) {
                var view = this.renderer_views[_];
                if (view.model.panel != null) {
                    if (side_panel_1._view_sizes.get(view) !== view.get_size()) {
                        return true;
                    }
                }
            }
            return false;
        };
        PlotCanvasView.prototype.repaint = function () {
            if (this._needs_layout()) {
                return this.parent.partial_layout();
            } else {
                return this.paint();
            }
        };
        PlotCanvasView.prototype.paint = function () {
            var _this = this;
            var ratio;
            if (this.is_paused) {
                return;
            }
            logging_1.logger.trace('PlotCanvas.render() for ' + this.model.id);
            // Prepare the canvas size, taking HIDPI into account. Note that this may cause a resize
            // of the canvas, which means that any previous calls to ctx.save() will be undone.
            this.canvas_view.prepare_canvas();
            if (this.model.document != null) {
                var interactive_duration = this.model.document.interactive_duration();
                if (interactive_duration >= 0 && interactive_duration < this.model.plot.lod_interval) {
                    var lod_timeout_1 = this.model.plot.lod_timeout;
                    setTimeout(function () {
                        if (_this.model.document.interactive_duration() > lod_timeout_1) {
                            _this.model.document.interactive_stop(_this.model.plot);
                        }
                        return _this.request_render();
                    }, lod_timeout_1);
                } else {
                    this.model.document.interactive_stop(this.model.plot);
                }
            }
            for (var k in this.renderer_views) {
                var v = this.renderer_views[k];
                if (this.range_update_timestamp == null || v.set_data_timestamp > this.range_update_timestamp) {
                    this.update_dataranges();
                    break;
                }
            }
            // TODO (bev) OK this sucks, but the event from the solver update doesn't
            // reach the frame in time (sometimes) so force an update here for now
            // (mp) not only that, but models don't know about solver anymore, so
            // frame can't update its scales.
            this.model.frame.update_scales();
            var ctx = this.canvas_view.ctx;
            ctx.pixel_ratio = ratio = this.canvas.pixel_ratio;
            // Also store on cts for WebGL
            // Set hidpi-transform
            ctx.save();
            // Save default state, do *after* getting ratio, cause setting canvas.width resets transforms
            ctx.scale(ratio, ratio);
            ctx.translate(0.5, 0.5);
            var frame_box = [
                this.frame._left.value,
                this.frame._top.value,
                this.frame._width.value,
                this.frame._height.value
            ];
            this._map_hook(ctx, frame_box);
            this._paint_empty(ctx, frame_box);
            this.prepare_webgl(ratio, frame_box);
            ctx.save();
            if (this.visuals.outline_line.doit) {
                this.visuals.outline_line.set_value(ctx);
                var x0 = frame_box[0], y0 = frame_box[1], w = frame_box[2], h = frame_box[3];
                // XXX: shrink outline region by 1px to make right and bottom lines visible
                // if they are on the edge of the canvas.
                if (x0 + w === this.canvas._width.value) {
                    w -= 1;
                }
                if (y0 + h === this.canvas._height.value) {
                    h -= 1;
                }
                ctx.strokeRect(x0, y0, w, h);
            }
            ctx.restore();
            this._paint_levels(ctx, [
                'image',
                'underlay',
                'glyph'
            ], frame_box);
            this.blit_webgl(ratio);
            this._paint_levels(ctx, ['annotation'], frame_box);
            this._paint_levels(ctx, ['overlay']);
            if (this.initial_range_info == null) {
                this.set_initial_range();
            }
            ctx.restore();
            // Restore to default state
            if (!this._has_finished) {
                this._has_finished = true;
                return this.notify_finished();
            }
        };
        PlotCanvasView.prototype._paint_levels = function (ctx, levels, clip_region) {
            if (clip_region === void 0) {
                clip_region = null;
            }
            ctx.save();
            if (clip_region != null && this.model.plot.output_backend === 'canvas') {
                ctx.beginPath();
                ctx.rect.apply(ctx, clip_region);
                ctx.clip();
            }
            var indices = {};
            for (var i = 0; i < this.model.plot.renderers.length; i++) {
                var renderer = this.model.plot.renderers[i];
                indices[renderer.id] = i;
            }
            var sortKey = function (renderer_view) {
                return indices[renderer_view.model.id];
            };
            for (var _i = 0, levels_1 = levels; _i < levels_1.length; _i++) {
                var level = levels_1[_i];
                var renderer_views = array_1.sortBy(object_1.values(this.levels[level]), sortKey);
                for (var _a = 0, renderer_views_1 = renderer_views; _a < renderer_views_1.length; _a++) {
                    var renderer_view = renderer_views_1[_a];
                    renderer_view.render();
                }
            }
            return ctx.restore();
        };
        PlotCanvasView.prototype._map_hook = function (_ctx, _frame_box) {
        };
        PlotCanvasView.prototype._paint_empty = function (ctx, frame_box) {
            var _a = [
                    0,
                    0,
                    this.canvas_view.model._width.value,
                    this.canvas_view.model._height.value
                ], cx = _a[0], cy = _a[1], cw = _a[2], ch = _a[3];
            var fx = frame_box[0], fy = frame_box[1], fw = frame_box[2], fh = frame_box[3];
            ctx.clearRect(cx, cy, cw, ch);
            if (this.visuals.border_fill.doit) {
                this.visuals.border_fill.set_value(ctx);
                ctx.fillRect(cx, cy, cw, ch);
                ctx.clearRect(fx, fy, fw, fh);
            }
            if (this.visuals.background_fill.doit) {
                this.visuals.background_fill.set_value(ctx);
                ctx.fillRect(fx, fy, fw, fh);
            }
        };
        PlotCanvasView.prototype.save = function (name) {
            switch (this.model.plot.output_backend) {
            case 'canvas':
            case 'webgl': {
                    var canvas = this.canvas_view.get_canvas_element();
                    if (canvas.msToBlob != null) {
                        var blob = canvas.msToBlob();
                        return window.navigator.msSaveBlob(blob, name);
                    } else {
                        var link = document.createElement('a');
                        link.href = canvas.toDataURL('image/png');
                        link.download = name + '.png';
                        link.target = '_blank';
                        return link.dispatchEvent(new MouseEvent('click'));
                    }
                }
            case 'svg': {
                    var svg = this.canvas_view.ctx.getSerializedSvg(true);
                    var svgblob = new Blob([svg], { type: 'text/plain' });
                    var downloadLink = document.createElement('a');
                    downloadLink.download = name + '.svg';
                    downloadLink.innerHTML = 'Download svg';
                    downloadLink.href = window.URL.createObjectURL(svgblob);
                    downloadLink.onclick = function (event) {
                        return document.body.removeChild(event.target);
                    };
                    downloadLink.style.display = 'none';
                    document.body.appendChild(downloadLink);
                    return downloadLink.click();
                }
            }
        };
        return PlotCanvasView;
    }(dom_view_1.DOMView);
    exports.PlotCanvasView = PlotCanvasView;
    var AbovePanel = function (_super) {
        tslib_1.__extends(AbovePanel, _super);
        function AbovePanel() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        AbovePanel.initClass = function () {
            this.prototype.type = 'AbovePanel';
        };
        return AbovePanel;
    }(layout_canvas_1.LayoutCanvas);
    AbovePanel.initClass();
    var BelowPanel = function (_super) {
        tslib_1.__extends(BelowPanel, _super);
        function BelowPanel() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        BelowPanel.initClass = function () {
            this.prototype.type = 'BelowPanel';
        };
        return BelowPanel;
    }(layout_canvas_1.LayoutCanvas);
    BelowPanel.initClass();
    var LeftPanel = function (_super) {
        tslib_1.__extends(LeftPanel, _super);
        function LeftPanel() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        LeftPanel.initClass = function () {
            this.prototype.type = 'LeftPanel';
        };
        return LeftPanel;
    }(layout_canvas_1.LayoutCanvas);
    LeftPanel.initClass();
    var RightPanel = function (_super) {
        tslib_1.__extends(RightPanel, _super);
        function RightPanel() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        RightPanel.initClass = function () {
            this.prototype.type = 'RightPanel';
        };
        return RightPanel;
    }(layout_canvas_1.LayoutCanvas);
    RightPanel.initClass();
    var PlotCanvas = function (_super) {
        tslib_1.__extends(PlotCanvas, _super);
        function PlotCanvas(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        PlotCanvas.initClass = function () {
            this.prototype.type = 'PlotCanvas';
            this.prototype.default_view = PlotCanvasView;
            this.internal({
                plot: [p.Instance],
                toolbar: [p.Instance],
                canvas: [p.Instance],
                frame: [p.Instance]
            });
            this.override({
                // We should find a way to enforce this
                sizing_mode: 'stretch_both'
            });
        };
        PlotCanvas.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            this.canvas = new canvas_1.Canvas({
                map: this.use_map != null ? this.use_map : false,
                use_hidpi: this.plot.hidpi,
                output_backend: this.plot.output_backend
            });
            this.frame = new cartesian_frame_1.CartesianFrame({
                x_range: this.plot.x_range,
                extra_x_ranges: this.plot.extra_x_ranges,
                x_scale: this.plot.x_scale,
                y_range: this.plot.y_range,
                extra_y_ranges: this.plot.extra_y_ranges,
                y_scale: this.plot.y_scale
            });
            this.above_panel = new AbovePanel();
            this.below_panel = new BelowPanel();
            this.left_panel = new LeftPanel();
            this.right_panel = new RightPanel();
            logging_1.logger.debug('PlotCanvas initialized');
        };
        PlotCanvas.prototype._doc_attached = function () {
            this.canvas.attach_document(this.document);
            this.frame.attach_document(this.document);
            this.above_panel.attach_document(this.document);
            this.below_panel.attach_document(this.document);
            this.left_panel.attach_document(this.document);
            this.right_panel.attach_document(this.document);
            _super.prototype._doc_attached.call(this);
            logging_1.logger.debug('PlotCanvas attached to document');
        };
        PlotCanvas.prototype.get_layoutable_children = function () {
            var children = [
                this.above_panel,
                this.below_panel,
                this.left_panel,
                this.right_panel,
                this.canvas,
                this.frame
            ];
            var collect_panels = function (layout_renderers) {
                for (var _i = 0, layout_renderers_1 = layout_renderers; _i < layout_renderers_1.length; _i++) {
                    var r = layout_renderers_1[_i];
                    if (r.panel != null)
                        children.push(r.panel);
                }
            };
            collect_panels(this.plot.above);
            collect_panels(this.plot.below);
            collect_panels(this.plot.left);
            collect_panels(this.plot.right);
            return children;
        };
        PlotCanvas.prototype.get_constraints = function () {
            return _super.prototype.get_constraints.call(this).concat(this._get_constant_constraints(), this._get_side_constraints());
        };
        PlotCanvas.prototype._get_constant_constraints = function () {
            return [
                // Set the origin. Everything else is positioned absolutely wrt canvas.
                solver_1.EQ(this.canvas._left, 0),
                solver_1.EQ(this.canvas._top, 0),
                solver_1.GE(this.above_panel._top, [
                    -1,
                    this.canvas._top
                ]),
                solver_1.EQ(this.above_panel._bottom, [
                    -1,
                    this.frame._top
                ]),
                solver_1.EQ(this.above_panel._left, [
                    -1,
                    this.left_panel._right
                ]),
                solver_1.EQ(this.above_panel._right, [
                    -1,
                    this.right_panel._left
                ]),
                solver_1.EQ(this.below_panel._top, [
                    -1,
                    this.frame._bottom
                ]),
                solver_1.LE(this.below_panel._bottom, [
                    -1,
                    this.canvas._bottom
                ]),
                solver_1.EQ(this.below_panel._left, [
                    -1,
                    this.left_panel._right
                ]),
                solver_1.EQ(this.below_panel._right, [
                    -1,
                    this.right_panel._left
                ]),
                solver_1.EQ(this.left_panel._top, [
                    -1,
                    this.above_panel._bottom
                ]),
                solver_1.EQ(this.left_panel._bottom, [
                    -1,
                    this.below_panel._top
                ]),
                solver_1.GE(this.left_panel._left, [
                    -1,
                    this.canvas._left
                ]),
                solver_1.EQ(this.left_panel._right, [
                    -1,
                    this.frame._left
                ]),
                solver_1.EQ(this.right_panel._top, [
                    -1,
                    this.above_panel._bottom
                ]),
                solver_1.EQ(this.right_panel._bottom, [
                    -1,
                    this.below_panel._top
                ]),
                solver_1.EQ(this.right_panel._left, [
                    -1,
                    this.frame._right
                ]),
                solver_1.LE(this.right_panel._right, [
                    -1,
                    this.canvas._right
                ]),
                solver_1.EQ(this._top, [
                    -1,
                    this.above_panel._bottom
                ]),
                solver_1.EQ(this._left, [
                    -1,
                    this.left_panel._right
                ]),
                solver_1.EQ(this._height, [
                    -1,
                    this._bottom
                ], [
                    -1,
                    this.canvas._bottom
                ], this.below_panel._top),
                solver_1.EQ(this._width, [
                    -1,
                    this._right
                ], [
                    -1,
                    this.canvas._right
                ], this.right_panel._left),
                solver_1.GE(this._top, -this.plot.min_border_top),
                solver_1.GE(this._left, -this.plot.min_border_left),
                solver_1.GE(this._height, [
                    -1,
                    this._bottom
                ], -this.plot.min_border_bottom),
                solver_1.GE(this._width, [
                    -1,
                    this._right
                ], -this.plot.min_border_right)
            ];
        };
        PlotCanvas.prototype._get_side_constraints = function () {
            var panels = function (objs) {
                return objs.map(function (obj) {
                    return obj.panel;
                });
            };
            var above = alignments_1.vstack(this.above_panel, panels(this.plot.above));
            var below = alignments_1.vstack(this.below_panel, array_1.reversed(panels(this.plot.below)));
            var left = alignments_1.hstack(this.left_panel, panels(this.plot.left));
            var right = alignments_1.hstack(this.right_panel, array_1.reversed(panels(this.plot.right)));
            return [].concat(above, below, left, right);
        };
        return PlotCanvas;
    }(layout_dom_1.LayoutDOM);
    exports.PlotCanvas = PlotCanvas;
    PlotCanvas.initClass();
    function __guardMethod__(obj, methodName, transform) {
        if (typeof obj !== 'undefined' && obj !== null && typeof obj[methodName] === 'function') {
            return transform(obj, methodName);
        } else {
            return undefined;
        }
    }    
},
/*models/ranges/data_range*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    var range_1 = require(160    /* ./range */);
    var p = require(15    /* core/properties */);
    var DataRange = function (_super) {
        tslib_1.__extends(DataRange, _super);
        function DataRange(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        DataRange.initClass = function () {
            this.prototype.type = 'DataRange';
            this.define({
                names: [
                    p.Array,
                    []
                ],
                renderers: [
                    p.Array,
                    []
                ]
            });
        };
        return DataRange;
    }(range_1.Range);
    exports.DataRange = DataRange;
    DataRange.initClass();    
},
/*models/ranges/data_range1d*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    var data_range_1 = require(156    /* ./data_range */);
    var glyph_renderer_1 = require(162    /* ../renderers/glyph_renderer */);
    var logging_1 = require(14    /* core/logging */);
    var p = require(15    /* core/properties */);
    var bbox = require(24    /* core/util/bbox */);
    var array_1 = require(22    /* core/util/array */);
    var DataRange1d = function (_super) {
        tslib_1.__extends(DataRange1d, _super);
        function DataRange1d(attrs, opts) {
            var _this = _super.call(this, attrs, opts) || this;
            _this._plot_bounds = {};
            _this.have_updated_interactively = false;
            return _this;
        }
        DataRange1d.initClass = function () {
            this.prototype.type = 'DataRange1d';
            this.define({
                start: [p.Number],
                end: [p.Number],
                range_padding: [
                    p.Number,
                    0.1
                ],
                range_padding_units: [
                    p.PaddingUnits,
                    'percent'
                ],
                flipped: [
                    p.Bool,
                    false
                ],
                follow: [p.StartEnd],
                follow_interval: [p.Number],
                default_span: [
                    p.Number,
                    2
                ],
                bounds: [p.Any],
                min_interval: [p.Any],
                max_interval: [p.Any]
            });
            this.internal({
                scale_hint: [
                    p.String,
                    'auto'
                ]
            });
        };
        DataRange1d.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            this._initial_start = this.start;
            this._initial_end = this.end;
            this._initial_range_padding = this.range_padding;
            this._initial_range_padding_units = this.range_padding_units;
            this._initial_follow = this.follow;
            this._initial_follow_interval = this.follow_interval;
            this._initial_default_span = this.default_span;
        };
        Object.defineProperty(DataRange1d.prototype, 'min', {
            get: function () {
                return Math.min(this.start, this.end);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(DataRange1d.prototype, 'max', {
            get: function () {
                return Math.max(this.start, this.end);
            },
            enumerable: true,
            configurable: true
        });
        DataRange1d.prototype.computed_renderers = function () {
            // TODO (bev) check that renderers actually configured with this range
            var names = this.names;
            var renderers = this.renderers;
            if (renderers.length == 0) {
                for (var _i = 0, _a = this.plots; _i < _a.length; _i++) {
                    var plot = _a[_i];
                    var rs = plot.renderers.filter(function (r) {
                        return r instanceof glyph_renderer_1.GlyphRenderer;
                    });
                    renderers = renderers.concat(rs);
                }
            }
            if (names.length > 0)
                renderers = renderers.filter(function (r) {
                    return array_1.includes(names, r.name);
                });
            logging_1.logger.debug('computed ' + renderers.length + ' renderers for DataRange1d ' + this.id);
            for (var _b = 0, renderers_1 = renderers; _b < renderers_1.length; _b++) {
                var r = renderers_1[_b];
                logging_1.logger.trace(' - ' + r.type + ' ' + r.id);
            }
            return renderers;
        };
        DataRange1d.prototype._compute_plot_bounds = function (renderers, bounds) {
            var result = bbox.empty();
            for (var _i = 0, renderers_2 = renderers; _i < renderers_2.length; _i++) {
                var r = renderers_2[_i];
                if (bounds[r.id] != null)
                    result = bbox.union(result, bounds[r.id]);
            }
            return result;
        };
        DataRange1d.prototype.adjust_bounds_for_aspect = function (bounds, ratio) {
            var result = bbox.empty();
            var width = bounds.maxX - bounds.minX;
            if (width <= 0) {
                width = 1;
            }
            var height = bounds.maxY - bounds.minY;
            if (height <= 0) {
                height = 1;
            }
            var xcenter = 0.5 * (bounds.maxX + bounds.minX);
            var ycenter = 0.5 * (bounds.maxY + bounds.minY);
            if (width < ratio * height) {
                width = ratio * height;
            } else {
                height = width / ratio;
            }
            result.maxX = xcenter + 0.5 * width;
            result.minX = xcenter - 0.5 * width;
            result.maxY = ycenter + 0.5 * height;
            result.minY = ycenter - 0.5 * height;
            return result;
        };
        DataRange1d.prototype._compute_min_max = function (plot_bounds, dimension) {
            var overall = bbox.empty();
            for (var k in plot_bounds) {
                var v = plot_bounds[k];
                overall = bbox.union(overall, v);
            }
            var min, max;
            if (dimension == 0)
                _a = [
                    overall.minX,
                    overall.maxX
                ], min = _a[0], max = _a[1];
            else
                _b = [
                    overall.minY,
                    overall.maxY
                ], min = _b[0], max = _b[1];
            return [
                min,
                max
            ];
            var _a, _b;
        };
        DataRange1d.prototype._compute_range = function (min, max) {
            var range_padding = this.range_padding;
            // XXX: ? 0
            var start, end;
            if (this.scale_hint == 'log') {
                if (isNaN(min) || !isFinite(min) || min <= 0) {
                    if (isNaN(max) || !isFinite(max) || max <= 0)
                        min = 0.1;
                    else
                        min = max / 100;
                    logging_1.logger.warn('could not determine minimum data value for log axis, DataRange1d using value ' + min);
                }
                if (isNaN(max) || !isFinite(max) || max <= 0) {
                    if (isNaN(min) || !isFinite(min) || min <= 0)
                        max = 10;
                    else
                        max = min * 100;
                    logging_1.logger.warn('could not determine maximum data value for log axis, DataRange1d using value ' + max);
                }
                var center = void 0, span = void 0;
                if (max == min) {
                    span = this.default_span + 0.001;
                    center = Math.log(min) / Math.log(10);
                } else {
                    var log_min = void 0, log_max = void 0;
                    if (this.range_padding_units == 'percent') {
                        log_min = Math.log(min) / Math.log(10);
                        log_max = Math.log(max) / Math.log(10);
                        span = (log_max - log_min) * (1 + range_padding);
                    } else {
                        log_min = Math.log(min - range_padding) / Math.log(10);
                        log_max = Math.log(max + range_padding) / Math.log(10);
                        span = log_max - log_min;
                    }
                    center = (log_min + log_max) / 2;
                }
                start = Math.pow(10, center - span / 2);
                end = Math.pow(10, center + span / 2);
            } else {
                var span = void 0;
                if (max == min)
                    span = this.default_span;
                else {
                    if (this.range_padding_units == 'percent')
                        span = (max - min) * (1 + range_padding);
                    else
                        span = max - min + 2 * range_padding;
                }
                var center = (max + min) / 2;
                start = center - span / 2;
                end = center + span / 2;
            }
            var follow_sign = +1;
            if (this.flipped) {
                _a = [
                    end,
                    start
                ], start = _a[0], end = _a[1];
                follow_sign = -1;
            }
            var follow_interval = this.follow_interval;
            if (follow_interval != null && Math.abs(start - end) > follow_interval) {
                if (this.follow == 'start')
                    end = start + follow_sign * follow_interval;
                else if (this.follow == 'end')
                    start = end - follow_sign * follow_interval;
            }
            return [
                start,
                end
            ];
            var _a;
        };
        DataRange1d.prototype.update = function (bounds, dimension, bounds_id, ratio) {
            if (this.have_updated_interactively)
                return;
            var renderers = this.computed_renderers();
            // update the raw data bounds for all renderers we care about
            var total_bounds = this._compute_plot_bounds(renderers, bounds);
            if (ratio != null)
                total_bounds = this.adjust_bounds_for_aspect(total_bounds, ratio);
            this._plot_bounds[bounds_id] = total_bounds;
            // compute the min/mix for our specified dimension
            var _a = this._compute_min_max(this._plot_bounds, dimension), min = _a[0], max = _a[1];
            // derive start, end from bounds and data range config
            var _b = this._compute_range(min, max), start = _b[0], end = _b[1];
            if (this._initial_start != null) {
                if (this.scale_hint == 'log') {
                    if (this._initial_start > 0)
                        start = this._initial_start;
                } else
                    start = this._initial_start;
            }
            if (this._initial_end != null) {
                if (this.scale_hint == 'log') {
                    if (this._initial_end > 0)
                        end = this._initial_end;
                } else
                    end = this._initial_end;
            }
            // only trigger updates when there are changes
            var _c = [
                    this.start,
                    this.end
                ], _start = _c[0], _end = _c[1];
            if (start != _start || end != _end) {
                var new_range = {};
                if (start != _start)
                    new_range.start = start;
                if (end != _end)
                    new_range.end = end;
                this.setv(new_range);
            }
            if (this.bounds == 'auto')
                this.setv({
                    bounds: [
                        start,
                        end
                    ]
                }, { silent: true });
            this.change.emit(undefined);
        };
        DataRange1d.prototype.reset = function () {
            this.have_updated_interactively = false;
            // change events silenced as PlotCanvasView.update_dataranges triggers property callbacks
            this.setv({
                range_padding: this._initial_range_padding,
                range_padding_units: this._initial_range_padding_units,
                follow: this._initial_follow,
                follow_interval: this._initial_follow_interval,
                default_span: this._initial_default_span
            }, { silent: true });
            this.change.emit(undefined);
        };
        return DataRange1d;
    }(data_range_1.DataRange);
    exports.DataRange1d = DataRange1d;
    DataRange1d.initClass();    
},
/*models/ranges/factor_range*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    var range_1 = require(160    /* ./range */);
    var p = require(15    /* core/properties */);
    var array_1 = require(22    /* core/util/array */);
    var types_1 = require(43    /* core/util/types */);
    function map_one_level(factors, padding, offset) {
        if (offset === void 0) {
            offset = 0;
        }
        var mapping = {};
        for (var i = 0; i < factors.length; i++) {
            var factor = factors[i];
            if (factor in mapping)
                throw new Error('duplicate factor or subfactor: ' + factor);
            else
                mapping[factor] = { value: 0.5 + i * (1 + padding) + offset };
        }
        return [
            mapping,
            (factors.length - 1) * padding
        ];
    }
    exports.map_one_level = map_one_level;
    function map_two_levels(factors, outer_pad, factor_pad, offset) {
        if (offset === void 0) {
            offset = 0;
        }
        var mapping = {};
        var tops = {};
        var tops_order = [];
        for (var _i = 0, factors_1 = factors; _i < factors_1.length; _i++) {
            var _a = factors_1[_i], f0 = _a[0], f1 = _a[1];
            if (!(f0 in tops)) {
                tops[f0] = [];
                tops_order.push(f0);
            }
            tops[f0].push(f1);
        }
        var suboffset = offset;
        var total_subpad = 0;
        var _loop_1 = function (f0) {
            var n = tops[f0].length;
            var _a = map_one_level(tops[f0], factor_pad, suboffset), submap = _a[0], subpad = _a[1];
            total_subpad += subpad;
            var subtot = array_1.sum(tops[f0].map(function (f1) {
                return submap[f1].value;
            }));
            mapping[f0] = {
                value: subtot / n,
                mapping: submap
            };
            suboffset += n + outer_pad + subpad;
        };
        for (var _b = 0, tops_order_1 = tops_order; _b < tops_order_1.length; _b++) {
            var f0 = tops_order_1[_b];
            _loop_1(f0);
        }
        return [
            mapping,
            tops_order,
            (tops_order.length - 1) * outer_pad + total_subpad
        ];
    }
    exports.map_two_levels = map_two_levels;
    function map_three_levels(factors, outer_pad, inner_pad, factor_pad, offset) {
        if (offset === void 0) {
            offset = 0;
        }
        var mapping = {};
        var tops = {};
        var tops_order = [];
        for (var _i = 0, factors_2 = factors; _i < factors_2.length; _i++) {
            var _a = factors_2[_i], f0 = _a[0], f1 = _a[1], f2 = _a[2];
            if (!(f0 in tops)) {
                tops[f0] = [];
                tops_order.push(f0);
            }
            tops[f0].push([
                f1,
                f2
            ]);
        }
        var mids_order = [];
        var suboffset = offset;
        var total_subpad = 0;
        var _loop_2 = function (f0) {
            var n = tops[f0].length;
            var _a = map_two_levels(tops[f0], inner_pad, factor_pad, suboffset), submap = _a[0], submids_order = _a[1], subpad = _a[2];
            for (var _i = 0, submids_order_1 = submids_order; _i < submids_order_1.length; _i++) {
                var f1 = submids_order_1[_i];
                mids_order.push([
                    f0,
                    f1
                ]);
            }
            total_subpad += subpad;
            var subtot = array_1.sum(tops[f0].map(function (_a) {
                var f1 = _a[0];
                return submap[f1].value;
            }));
            mapping[f0] = {
                value: subtot / n,
                mapping: submap
            };
            suboffset += n + outer_pad + subpad;
        };
        for (var _b = 0, tops_order_2 = tops_order; _b < tops_order_2.length; _b++) {
            var f0 = tops_order_2[_b];
            _loop_2(f0);
        }
        return [
            mapping,
            tops_order,
            mids_order,
            (tops_order.length - 1) * outer_pad + total_subpad
        ];
    }
    exports.map_three_levels = map_three_levels;
    var FactorRange = function (_super) {
        tslib_1.__extends(FactorRange, _super);
        function FactorRange(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        FactorRange.initClass = function () {
            this.prototype.type = 'FactorRange';
            this.define({
                factors: [
                    p.Array,
                    []
                ],
                factor_padding: [
                    p.Number,
                    0
                ],
                subgroup_padding: [
                    p.Number,
                    0.8
                ],
                group_padding: [
                    p.Number,
                    1.4
                ],
                range_padding: [
                    p.Number,
                    0
                ],
                range_padding_units: [
                    p.PaddingUnits,
                    'percent'
                ],
                start: [p.Number],
                end: [p.Number],
                bounds: [p.Any],
                min_interval: [p.Any],
                max_interval: [p.Any]
            });
            this.internal({
                levels: [p.Number],
                mids: [p.Array],
                tops: [p.Array],
                tops_groups: [p.Array]
            });
        };
        Object.defineProperty(FactorRange.prototype, 'min', {
            get: function () {
                return this.start;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(FactorRange.prototype, 'max', {
            get: function () {
                return this.end;
            },
            enumerable: true,
            configurable: true
        });
        FactorRange.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            this._init();
        };
        FactorRange.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            this.connect(this.properties.factors.change, function () {
                return _this.reset();
            });
            this.connect(this.properties.factor_padding.change, function () {
                return _this.reset();
            });
            this.connect(this.properties.group_padding.change, function () {
                return _this.reset();
            });
            this.connect(this.properties.subgroup_padding.change, function () {
                return _this.reset();
            });
            this.connect(this.properties.range_padding.change, function () {
                return _this.reset();
            });
            this.connect(this.properties.range_padding_units.change, function () {
                return _this.reset();
            });
        };
        FactorRange.prototype.reset = function () {
            this._init();
            this.change.emit(undefined);
        };
        FactorRange.prototype._lookup = function (x) {
            if (x.length == 1) {
                var m = this._mapping;
                if (!m.hasOwnProperty(x[0])) {
                    return NaN;
                }
                return m[x[0]].value;
            } else if (x.length == 2) {
                var m = this._mapping;
                if (!m.hasOwnProperty(x[0]) || !m[x[0]].mapping.hasOwnProperty(x[1])) {
                    return NaN;
                }
                return m[x[0]].mapping[x[1]].value;
            } else if (x.length == 3) {
                var m = this._mapping;
                if (!m.hasOwnProperty(x[0]) || !m[x[0]].mapping.hasOwnProperty(x[1]) || !m[x[0]].mapping[x[1]].mapping.hasOwnProperty(x[2])) {
                    return NaN;
                }
                return m[x[0]].mapping[x[1]].mapping[x[2]].value;
            } else
                return undefined;
        };
        // convert a string factor into a synthetic coordinate
        FactorRange.prototype.synthetic = function (x) {
            if (types_1.isNumber(x))
                return x;
            if (types_1.isString(x))
                return this._lookup([x]);
            var offset = 0;
            var off = x[x.length - 1];
            if (types_1.isNumber(off)) {
                offset = off;
                x = x.slice(0, -1);
            }
            return this._lookup(x) + offset;
        };
        // convert an array of string factors into synthetic coordinates
        FactorRange.prototype.v_synthetic = function (xs) {
            var _this = this;
            return xs.map(function (x) {
                return _this.synthetic(x);
            });
        };
        FactorRange.prototype._init = function () {
            var levels;
            var inside_padding;
            if (array_1.all(this.factors, types_1.isString)) {
                levels = 1;
                _a = map_one_level(this.factors, this.factor_padding), this._mapping = _a[0], inside_padding = _a[1];
            } else if (array_1.all(this.factors, function (x) {
                    return types_1.isArray(x) && x.length == 2 && types_1.isString(x[0]) && types_1.isString(x[1]);
                })) {
                levels = 2;
                _b = map_two_levels(this.factors, this.group_padding, this.factor_padding), this._mapping = _b[0], this.tops = _b[1], inside_padding = _b[2];
            } else if (array_1.all(this.factors, function (x) {
                    return types_1.isArray(x) && x.length == 3 && types_1.isString(x[0]) && types_1.isString(x[1]) && types_1.isString(x[2]);
                })) {
                levels = 3;
                _c = map_three_levels(this.factors, this.group_padding, this.subgroup_padding, this.factor_padding), this._mapping = _c[0], this.tops = _c[1], this.mids = _c[2], inside_padding = _c[3];
            } else
                throw new Error('???');
            var start = 0;
            var end = this.factors.length + inside_padding;
            if (this.range_padding_units == 'percent') {
                var half_span = (end - start) * this.range_padding / 2;
                start -= half_span;
                end += half_span;
            } else {
                start -= this.range_padding;
                end += this.range_padding;
            }
            this.setv({
                start: start,
                end: end,
                levels: levels
            }, { silent: true });
            if (this.bounds == 'auto')
                this.setv({
                    bounds: [
                        start,
                        end
                    ]
                }, { silent: true });
            var _a, _b, _c;
        };
        return FactorRange;
    }(range_1.Range);
    exports.FactorRange = FactorRange;
    FactorRange.initClass();    
},
/*models/ranges/index*/
function _(require, module, exports) {
    var data_range_1 = require(156    /* ./data_range */);
    exports.DataRange = data_range_1.DataRange;
    var data_range1d_1 = require(157    /* ./data_range1d */);
    exports.DataRange1d = data_range1d_1.DataRange1d;
    var factor_range_1 = require(158    /* ./factor_range */);
    exports.FactorRange = factor_range_1.FactorRange;
    var range_1 = require(160    /* ./range */);
    exports.Range = range_1.Range;
    var range1d_1 = require(161    /* ./range1d */);
    exports.Range1d = range1d_1.Range1d;    
},
/*models/ranges/range*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    var model_1 = require(51    /* ../../model */);
    var p = require(15    /* core/properties */);
    var types_1 = require(43    /* core/util/types */);
    var Range = function (_super) {
        tslib_1.__extends(Range, _super);
        function Range(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        Range.initClass = function () {
            this.prototype.type = 'Range';
            this.define({ callback: [p.Any] });
            this.internal({
                plots: [
                    p.Array,
                    []
                ]
            });
        };
        Range.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            this.connect(this.change, function () {
                return _this._emit_callback();
            });
        };
        Range.prototype.reset = function () {
            /**
         * This method should be reimplemented by subclasses and ensure that
         * the callback, if exists, is executed at completion.
         */
            this.change.emit(undefined);
        };
        Range.prototype._emit_callback = function () {
            if (this.callback != null) {
                if (types_1.isFunction(this.callback))
                    this.callback(this);
                else
                    this.callback.execute(this, {});
            }
        };
        return Range;
    }(model_1.Model);
    exports.Range = Range;
    Range.initClass();    
},
/*models/ranges/range1d*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    var range_1 = require(160    /* ./range */);
    var p = require(15    /* core/properties */);
    var Range1d = function (_super) {
        tslib_1.__extends(Range1d, _super);
        function Range1d(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        Range1d.initClass = function () {
            this.prototype.type = 'Range1d';
            this.define({
                start: [
                    p.Number,
                    0
                ],
                end: [
                    p.Number,
                    1
                ],
                bounds: [p.Any],
                min_interval: [p.Any],
                max_interval: [p.Any]
            });
        };
        Range1d.prototype._set_auto_bounds = function () {
            if (this.bounds == 'auto') {
                var min = Math.min(this._initial_start, this._initial_end);
                var max = Math.max(this._initial_start, this._initial_end);
                this.setv({
                    bounds: [
                        min,
                        max
                    ]
                }, { silent: true });
            }
        };
        Range1d.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            this._initial_start = this.start;
            this._initial_end = this.end;
            this._set_auto_bounds();
        };
        Object.defineProperty(Range1d.prototype, 'min', {
            get: function () {
                return Math.min(this.start, this.end);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Range1d.prototype, 'max', {
            get: function () {
                return Math.max(this.start, this.end);
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Range1d.prototype, 'is_reversed', {
            get: function () {
                return this.start > this.end;
            },
            enumerable: true,
            configurable: true
        });
        Range1d.prototype.reset = function () {
            this._set_auto_bounds();
            if (this.start != this._initial_start || this.end != this._initial_end)
                this.setv({
                    start: this._initial_start,
                    end: this._initial_end
                });
            else
                this.change.emit(undefined);
        };
        return Range1d;
    }(range_1.Range);
    exports.Range1d = Range1d;
    Range1d.initClass();    
},
/*models/renderers/glyph_renderer*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    /* XXX: partial */
    var renderer_1 = require(166    /* ./renderer */);
    var line_1 = require(115    /* ../glyphs/line */);
    var remote_data_source_1 = require(179    /* ../sources/remote_data_source */);
    var cds_view_1 = require(173    /* ../sources/cds_view */);
    var logging_1 = require(14    /* core/logging */);
    var p = require(15    /* core/properties */);
    var array_1 = require(22    /* core/util/array */);
    var object_1 = require(31    /* core/util/object */);
    var factor_range_1 = require(158    /* ../ranges/factor_range */);
    var GlyphRendererView = function (_super) {
        tslib_1.__extends(GlyphRendererView, _super);
        function GlyphRendererView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        GlyphRendererView.prototype.initialize = function (options) {
            _super.prototype.initialize.call(this, options);
            var base_glyph = this.model.glyph;
            var has_fill = array_1.includes(base_glyph.mixins, 'fill');
            var has_line = array_1.includes(base_glyph.mixins, 'line');
            var glyph_attrs = object_1.clone(base_glyph.attributes);
            delete glyph_attrs.id;
            var mk_glyph = function (defaults) {
                var attrs = object_1.clone(glyph_attrs);
                if (has_fill) {
                    object_1.extend(attrs, defaults.fill);
                }
                if (has_line) {
                    object_1.extend(attrs, defaults.line);
                }
                return new base_glyph.constructor(attrs);
            };
            this.glyph = this.build_glyph_view(base_glyph);
            var selection_glyph = this.model.selection_glyph;
            if (selection_glyph == null) {
                selection_glyph = mk_glyph({
                    fill: {},
                    line: {}
                });
            } else if (selection_glyph === 'auto') {
                selection_glyph = mk_glyph(this.model.selection_defaults);
            }
            this.selection_glyph = this.build_glyph_view(selection_glyph);
            var nonselection_glyph = this.model.nonselection_glyph;
            if (nonselection_glyph == null) {
                nonselection_glyph = mk_glyph({
                    fill: {},
                    line: {}
                });
            } else if (nonselection_glyph === 'auto') {
                nonselection_glyph = mk_glyph(this.model.nonselection_defaults);
            }
            this.nonselection_glyph = this.build_glyph_view(nonselection_glyph);
            var hover_glyph = this.model.hover_glyph;
            if (hover_glyph != null) {
                this.hover_glyph = this.build_glyph_view(hover_glyph);
            }
            var muted_glyph = this.model.muted_glyph;
            if (muted_glyph != null) {
                this.muted_glyph = this.build_glyph_view(muted_glyph);
            }
            var decimated_glyph = mk_glyph(this.model.decimated_defaults);
            this.decimated_glyph = this.build_glyph_view(decimated_glyph);
            this.xscale = this.plot_view.frame.xscales[this.model.x_range_name];
            this.yscale = this.plot_view.frame.yscales[this.model.y_range_name];
            this.set_data(false);
            if (this.model.data_source instanceof remote_data_source_1.RemoteDataSource) {
                return this.model.data_source.setup();
            }
        };
        GlyphRendererView.prototype.build_glyph_view = function (model) {
            return new model.default_view({
                model: model,
                renderer: this,
                plot_view: this.plot_view,
                parent: this
            });
        };
        GlyphRendererView.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            this.connect(this.model.change, function () {
                return _this.request_render();
            });
            this.connect(this.model.glyph.change, function () {
                return _this.set_data();
            });
            this.connect(this.model.data_source.change, function () {
                return _this.set_data();
            });
            this.connect(this.model.data_source.streaming, function () {
                return _this.set_data();
            });
            this.connect(this.model.data_source.patching, function (indices) {
                return _this.set_data(true, indices);
            });
            this.connect(this.model.data_source._select, function () {
                return _this.request_render();
            });
            if (this.hover_glyph != null) {
                this.connect(this.model.data_source.inspect, function () {
                    return _this.request_render();
                });
            }
            this.connect(this.model.properties.view.change, function () {
                return _this.set_data();
            });
            this.connect(this.model.view.change, function () {
                return _this.set_data();
            });
            var _a = this.plot_model.frame, x_ranges = _a.x_ranges, y_ranges = _a.y_ranges;
            for (var name_1 in x_ranges) {
                var rng = x_ranges[name_1];
                if (rng instanceof factor_range_1.FactorRange)
                    this.connect(rng.change, function () {
                        return _this.set_data();
                    });
            }
            for (var name_2 in y_ranges) {
                var rng = y_ranges[name_2];
                if (rng instanceof factor_range_1.FactorRange)
                    this.connect(rng.change, function () {
                        return _this.set_data();
                    });
            }
            this.connect(this.model.glyph.transformchange, function () {
                return _this.set_data();
            });
        };
        GlyphRendererView.prototype.have_selection_glyphs = function () {
            return this.selection_glyph != null && this.nonselection_glyph != null;
        };
        // in case of partial updates like patching, the list of indices that actually
        // changed may be passed as the "indices" parameter to afford any optional optimizations
        GlyphRendererView.prototype.set_data = function (request_render, indices) {
            if (request_render === void 0) {
                request_render = true;
            }
            if (indices === void 0) {
                indices = null;
            }
            var t0 = Date.now();
            var source = this.model.data_source;
            this.all_indices = this.model.view.indices;
            // TODO (bev) this is a bit clunky, need to make sure glyphs use the correct ranges when they call
            // mapping functions on the base Renderer class
            this.glyph.model.setv({
                x_range_name: this.model.x_range_name,
                y_range_name: this.model.y_range_name
            }, { silent: true });
            this.glyph.set_data(source, this.all_indices, indices);
            this.glyph.set_visuals(source);
            this.decimated_glyph.set_visuals(source);
            if (this.have_selection_glyphs()) {
                this.selection_glyph.set_visuals(source);
                this.nonselection_glyph.set_visuals(source);
            }
            if (this.hover_glyph != null) {
                this.hover_glyph.set_visuals(source);
            }
            if (this.muted_glyph != null) {
                this.muted_glyph.set_visuals(source);
            }
            var lod_factor = this.plot_model.plot.lod_factor;
            this.decimated = [];
            for (var i = 0, end = Math.floor(this.all_indices.length / lod_factor); i < end; i++) {
                this.decimated.push(i * lod_factor);
            }
            var dt = Date.now() - t0;
            logging_1.logger.debug(this.glyph.model.type + ' GlyphRenderer (' + this.model.id + '): set_data finished in ' + dt + 'ms');
            this.set_data_timestamp = Date.now();
            if (request_render) {
                return this.request_render();
            }
        };
        GlyphRendererView.prototype.render = function () {
            var _this = this;
            var dtrender, dtselect, glyph, nonselection_glyph, selection_glyph, trender;
            if (!this.model.visible) {
                return;
            }
            var t0 = Date.now();
            var glsupport = this.glyph.glglyph;
            this.glyph.map_data();
            var dtmap = Date.now() - t0;
            var tmask = Date.now();
            // all_indices is in full data space, indices is converted to subset space
            // either by mask_data (that uses the spatial index) or manually
            var indices = this.glyph.mask_data(this.all_indices);
            if (indices.length === this.all_indices.length) {
                indices = array_1.range(0, this.all_indices.length);
            }
            var dtmask = Date.now() - tmask;
            var ctx = this.plot_view.canvas_view.ctx;
            ctx.save();
            // selected is in full set space
            var _selected = this.model.data_source.selected;
            var selected;
            if (!_selected || _selected.length === 0) {
                selected = [];
            } else {
                if (_selected['0d'].glyph) {
                    selected = this.model.view.convert_indices_from_subset(indices);
                } else if (_selected['1d'].indices.length > 0) {
                    selected = _selected['1d'].indices;
                } else {
                    selected = function () {
                        var result = [];
                        for (var _i = 0, _a = Object.keys(_selected['2d'].indices); _i < _a.length; _i++) {
                            var i = _a[_i];
                            result.push(parseInt(i));
                        }
                        return result;
                    }();
                }
            }
            // inspected is in full set space
            var inspected = this.model.data_source.inspected;
            if (!inspected || inspected.length === 0) {
                inspected = [];
            } else {
                if (inspected['0d'].glyph) {
                    inspected = this.model.view.convert_indices_from_subset(indices);
                } else if (inspected['1d'].indices.length > 0) {
                    inspected = inspected['1d'].indices;
                } else {
                    inspected = function () {
                        var result = [];
                        for (var _i = 0, _a = Object.keys(inspected['2d'].indices); _i < _a.length; _i++) {
                            var i = _a[_i];
                            result.push(parseInt(i));
                        }
                        return result;
                    }();
                }
            }
            // inspected is transformed to subset space
            inspected = function () {
                var result = [];
                for (var _i = 0, indices_1 = indices; _i < indices_1.length; _i++) {
                    var i = indices_1[_i];
                    if (array_1.includes(inspected, _this.all_indices[i])) {
                        result.push(i);
                    }
                }
                return result;
            }();
            var lod_threshold = this.plot_model.plot.lod_threshold;
            if ((this.model.document != null ? this.model.document.interactive_duration() : undefined) > 0 && !glsupport && lod_threshold != null && this.all_indices.length > lod_threshold) {
                // Render decimated during interaction if too many elements and not using GL
                indices = this.decimated;
                glyph = this.decimated_glyph;
                nonselection_glyph = this.decimated_glyph;
                selection_glyph = this.selection_glyph;
            } else {
                glyph = this.model.muted && this.muted_glyph != null ? this.muted_glyph : this.glyph;
                nonselection_glyph = this.nonselection_glyph;
                selection_glyph = this.selection_glyph;
            }
            if (this.hover_glyph != null && inspected.length) {
                indices = array_1.difference(indices, inspected);
            }
            if (!(selected.length && this.have_selection_glyphs())) {
                trender = Date.now();
                if (this.glyph instanceof line_1.LineView) {
                    if (this.hover_glyph && inspected.length) {
                        this.hover_glyph.render(ctx, this.model.view.convert_indices_from_subset(inspected), this.glyph);
                    } else {
                        glyph.render(ctx, this.all_indices, this.glyph);
                    }
                } else {
                    glyph.render(ctx, indices, this.glyph);
                    if (this.hover_glyph && inspected.length) {
                        this.hover_glyph.render(ctx, inspected, this.glyph);
                    }
                }
                dtrender = Date.now() - trender;
            } else {
                // reset the selection mask
                var tselect = Date.now();
                var selected_mask = {};
                for (var _i = 0, selected_1 = selected; _i < selected_1.length; _i++) {
                    var i = selected_1[_i];
                    selected_mask[i] = true;
                }
                // intersect/different selection with render mask
                selected = new Array();
                var nonselected = new Array();
                // now, selected is changed to subset space, except for Line glyph
                if (this.glyph instanceof line_1.LineView) {
                    for (var _a = 0, _b = this.all_indices; _a < _b.length; _a++) {
                        var i = _b[_a];
                        if (selected_mask[i] != null) {
                            selected.push(i);
                        } else {
                            nonselected.push(i);
                        }
                    }
                } else {
                    for (var _c = 0, indices_2 = indices; _c < indices_2.length; _c++) {
                        var i = indices_2[_c];
                        if (selected_mask[this.all_indices[i]] != null) {
                            selected.push(i);
                        } else {
                            nonselected.push(i);
                        }
                    }
                }
                dtselect = Date.now() - tselect;
                trender = Date.now();
                nonselection_glyph.render(ctx, nonselected, this.glyph);
                selection_glyph.render(ctx, selected, this.glyph);
                if (this.hover_glyph != null) {
                    if (this.glyph instanceof line_1.LineView) {
                        this.hover_glyph.render(ctx, this.model.view.convert_indices_from_subset(inspected), this.glyph);
                    } else {
                        this.hover_glyph.render(ctx, inspected, this.glyph);
                    }
                }
                dtrender = Date.now() - trender;
            }
            this.last_dtrender = dtrender;
            var dttot = Date.now() - t0;
            logging_1.logger.debug(this.glyph.model.type + ' GlyphRenderer (' + this.model.id + '): render finished in ' + dttot + 'ms');
            logging_1.logger.trace(' - map_data finished in       : ' + dtmap + 'ms');
            if (dtmask != null) {
                logging_1.logger.trace(' - mask_data finished in      : ' + dtmask + 'ms');
            }
            if (dtselect != null) {
                logging_1.logger.trace(' - selection mask finished in : ' + dtselect + 'ms');
            }
            logging_1.logger.trace(' - glyph renders finished in  : ' + dtrender + 'ms');
            return ctx.restore();
        };
        GlyphRendererView.prototype.draw_legend = function (ctx, x0, x1, y0, y1, field, label) {
            var index = this.model.get_reference_point(field, label);
            return this.glyph.draw_legend_for_index(ctx, x0, x1, y0, y1, index);
        };
        GlyphRendererView.prototype.hit_test = function (geometry, final, append, mode) {
            if (mode === void 0) {
                mode = 'select';
            }
            return this.model.hit_test_helper(geometry, this, final, append, mode);
        };
        return GlyphRendererView;
    }(renderer_1.RendererView);
    exports.GlyphRendererView = GlyphRendererView;
    var GlyphRenderer = function (_super) {
        tslib_1.__extends(GlyphRenderer, _super);
        function GlyphRenderer(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        GlyphRenderer.initClass = function () {
            this.prototype.type = 'GlyphRenderer';
            this.prototype.default_view = GlyphRendererView;
            this.define({
                x_range_name: [
                    p.String,
                    'default'
                ],
                y_range_name: [
                    p.String,
                    'default'
                ],
                data_source: [p.Instance],
                view: [
                    p.Instance,
                    function () {
                        return new cds_view_1.CDSView();
                    }
                ],
                glyph: [p.Instance],
                hover_glyph: [p.Instance],
                nonselection_glyph: [
                    p.Any,
                    'auto'
                ],
                selection_glyph: [
                    p.Any,
                    'auto'
                ],
                muted_glyph: [p.Instance],
                muted: [
                    p.Bool,
                    false
                ]
            });
            this.override({ level: 'glyph' });
            this.prototype.selection_defaults = {
                fill: {},
                line: {}
            };
            this.prototype.decimated_defaults = {
                fill: {
                    fill_alpha: 0.3,
                    fill_color: 'grey'
                },
                line: {
                    line_alpha: 0.3,
                    line_color: 'grey'
                }
            };
            this.prototype.nonselection_defaults = {
                fill: {
                    fill_alpha: 0.2,
                    line_alpha: 0.2
                },
                line: {}
            };
        };
        GlyphRenderer.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            if (this.view.source == null) {
                this.view.source = this.data_source;
                this.view.compute_indices();
            }
        };
        GlyphRenderer.prototype.get_reference_point = function (field, value) {
            var index = 0;
            // This is the default to return
            if (field != null && this.data_source.get_column != null) {
                var data = this.data_source.get_column(field);
                if (data) {
                    var i = data.indexOf(value);
                    if (i > 0) {
                        index = i;
                    }
                }
            }
            return index;
        };
        GlyphRenderer.prototype.hit_test_helper = function (geometry, renderer_view, final, append, mode) {
            if (!this.visible) {
                return false;
            }
            var hit_test_result = renderer_view.glyph.hit_test(geometry);
            // glyphs that don't have hit-testing implemented will return null
            if (hit_test_result === null) {
                return false;
            }
            var indices = this.view.convert_selection_from_subset(hit_test_result);
            if (mode === 'select') {
                var selector = this.data_source.selection_manager.selector;
                selector.update(indices, final, append);
                this.data_source.selected = selector.indices;
                this.data_source._select.emit(undefined);
            } else {
                var inspector = this.data_source.selection_manager.get_or_create_inspector(this);
                inspector.update(indices, true, false, true);
                // silently set inspected attr to avoid triggering data_source.change event and rerender
                this.data_source.setv({ inspected: inspector.indices }, { silent: true });
                this.data_source.inspect.emit([
                    renderer_view,
                    { geometry: geometry }
                ]);
            }
            return !indices.is_empty();
        };
        GlyphRenderer.prototype.get_selection_manager = function () {
            return this.data_source.selection_manager;
        };
        return GlyphRenderer;
    }(renderer_1.Renderer);
    exports.GlyphRenderer = GlyphRenderer;
    GlyphRenderer.initClass();    
},
/*models/renderers/graph_renderer*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    /* XXX: partial */
    var renderer_1 = require(166    /* ./renderer */);
    var graph_hit_test_policy_1 = require(130    /* ../graphs/graph_hit_test_policy */);
    var p = require(15    /* core/properties */);
    var build_views_1 = require(4    /* core/build_views */);
    var GraphRendererView = function (_super) {
        tslib_1.__extends(GraphRendererView, _super);
        function GraphRendererView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        GraphRendererView.prototype.initialize = function (options) {
            _super.prototype.initialize.call(this, options);
            this.xscale = this.plot_view.frame.xscales['default'];
            this.yscale = this.plot_view.frame.yscales['default'];
            this._renderer_views = {};
            _a = build_views_1.build_views(this._renderer_views, [
                this.model.node_renderer,
                this.model.edge_renderer
            ], this.plot_view.view_options()), this.node_view = _a[0], this.edge_view = _a[1];
            this.set_data();
            var _a;
        };
        GraphRendererView.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            this.connect(this.model.layout_provider.change, function () {
                return _this.set_data();
            });
            this.connect(this.model.node_renderer.data_source._select, function () {
                return _this.set_data();
            });
            this.connect(this.model.node_renderer.data_source.inspect, function () {
                return _this.set_data();
            });
            this.connect(this.model.node_renderer.data_source.change, function () {
                return _this.set_data();
            });
            this.connect(this.model.edge_renderer.data_source._select, function () {
                return _this.set_data();
            });
            this.connect(this.model.edge_renderer.data_source.inspect, function () {
                return _this.set_data();
            });
            this.connect(this.model.edge_renderer.data_source.change, function () {
                return _this.set_data();
            });
            var _a = this.plot_model.frame, x_ranges = _a.x_ranges, y_ranges = _a.y_ranges;
            for (var name_1 in x_ranges) {
                var rng = x_ranges[name_1];
                this.connect(rng.change, function () {
                    return _this.set_data();
                });
            }
            for (var name_2 in y_ranges) {
                var rng = y_ranges[name_2];
                this.connect(rng.change, function () {
                    return _this.set_data();
                });
            }
        };
        GraphRendererView.prototype.set_data = function (request_render) {
            if (request_render === void 0) {
                request_render = true;
            }
            // TODO (bev) this is a bit clunky, need to make sure glyphs use the correct ranges when they call
            // mapping functions on the base Renderer class
            this.node_view.glyph.model.setv({
                x_range_name: this.model.x_range_name,
                y_range_name: this.model.y_range_name
            }, { silent: true });
            this.edge_view.glyph.model.setv({
                x_range_name: this.model.x_range_name,
                y_range_name: this.model.y_range_name
            }, { silent: true });
            _a = this.model.layout_provider.get_node_coordinates(this.model.node_renderer.data_source), this.node_view.glyph._x = _a[0], this.node_view.glyph._y = _a[1];
            _b = this.model.layout_provider.get_edge_coordinates(this.model.edge_renderer.data_source), this.edge_view.glyph._xs = _b[0], this.edge_view.glyph._ys = _b[1];
            this.node_view.glyph.index = this.node_view.glyph._index_data();
            this.edge_view.glyph.index = this.edge_view.glyph._index_data();
            if (request_render) {
                this.request_render();
            }
            var _a, _b;
        };
        GraphRendererView.prototype.render = function () {
            this.edge_view.render();
            return this.node_view.render();
        };
        GraphRendererView.prototype.hit_test = function (geometry, final, append, mode) {
            if (mode === void 0) {
                mode = 'select';
            }
            if (!this.model.visible) {
                return false;
            }
            var did_hit = false;
            if (mode === 'select') {
                did_hit = this.model.selection_policy != null ? this.model.selection_policy.do_selection(geometry, this, final, append) : undefined;
            } else {
                did_hit = this.model.inspection_policy != null ? this.model.inspection_policy.do_inspection(geometry, this, final, append) : undefined;
            }
            return did_hit;
        };
        return GraphRendererView;
    }(renderer_1.RendererView);
    exports.GraphRendererView = GraphRendererView;
    var GraphRenderer = function (_super) {
        tslib_1.__extends(GraphRenderer, _super);
        function GraphRenderer(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        GraphRenderer.initClass = function () {
            this.prototype.type = 'GraphRenderer';
            this.prototype.default_view = GraphRendererView;
            this.define({
                x_range_name: [
                    p.String,
                    'default'
                ],
                y_range_name: [
                    p.String,
                    'default'
                ],
                layout_provider: [p.Instance],
                node_renderer: [p.Instance],
                edge_renderer: [p.Instance],
                selection_policy: [
                    p.Instance,
                    function () {
                        return new graph_hit_test_policy_1.NodesOnly();
                    }
                ],
                inspection_policy: [
                    p.Instance,
                    function () {
                        return new graph_hit_test_policy_1.NodesOnly();
                    }
                ]
            });
            this.override({ level: 'glyph' });
        };
        GraphRenderer.prototype.get_selection_manager = function () {
            return this.node_renderer.data_source.selection_manager;
        };
        return GraphRenderer;
    }(renderer_1.Renderer);
    exports.GraphRenderer = GraphRenderer;
    GraphRenderer.initClass();    
},
/*models/renderers/guide_renderer*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    var renderer_1 = require(166    /* ./renderer */);
    var p = require(15    /* core/properties */);
    var GuideRendererView = function (_super) {
        tslib_1.__extends(GuideRendererView, _super);
        function GuideRendererView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return GuideRendererView;
    }(renderer_1.RendererView);
    exports.GuideRendererView = GuideRendererView;
    var GuideRenderer = function (_super) {
        tslib_1.__extends(GuideRenderer, _super);
        function GuideRenderer(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        GuideRenderer.initClass = function () {
            this.prototype.type = 'GuideRenderer';
            this.define({ plot: [p.Instance] });
            this.override({ level: 'overlay' });
        };
        return GuideRenderer;
    }(renderer_1.Renderer);
    exports.GuideRenderer = GuideRenderer;
    GuideRenderer.initClass();    
},
/*models/renderers/index*/
function _(require, module, exports) {
    var glyph_renderer_1 = require(162    /* ./glyph_renderer */);
    exports.GlyphRenderer = glyph_renderer_1.GlyphRenderer;
    var graph_renderer_1 = require(163    /* ./graph_renderer */);
    exports.GraphRenderer = graph_renderer_1.GraphRenderer;
    var guide_renderer_1 = require(164    /* ./guide_renderer */);
    exports.GuideRenderer = guide_renderer_1.GuideRenderer;
    var renderer_1 = require(166    /* ./renderer */);
    exports.Renderer = renderer_1.Renderer;    
},
/*models/renderers/renderer*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    var dom_view_1 = require(6    /* core/dom_view */);
    var visuals = require(47    /* core/visuals */);
    var p = require(15    /* core/properties */);
    var proj = require(33    /* core/util/projections */);
    var object_1 = require(31    /* core/util/object */);
    var model_1 = require(51    /* ../../model */);
    // This shouldn't be a DOMView, but annotations create a mess.
    var RendererView = function (_super) {
        tslib_1.__extends(RendererView, _super);
        function RendererView() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        RendererView.prototype.initialize = function (options) {
            _super.prototype.initialize.call(this, options);
            this.plot_view = options.plot_view;
            this.visuals = new visuals.Visuals(this.model);
            this._has_finished = true;    // XXX: should be in render() but subclasses don't respect super()
        };
        Object.defineProperty(RendererView.prototype, 'plot_model', {
            get: function () {
                return this.plot_view.model;
            },
            enumerable: true,
            configurable: true
        });
        RendererView.prototype.request_render = function () {
            this.plot_view.request_render();
        };
        RendererView.prototype.set_data = function (source) {
            var data = this.model.materialize_dataspecs(source);
            object_1.extend(this, data);
            if (this.plot_model.use_map) {
                var self_1 = this;
                if (self_1._x != null)
                    _a = proj.project_xy(self_1._x, self_1._y), self_1._x = _a[0], self_1._y = _a[1];
                if (self_1._xs != null)
                    _b = proj.project_xsys(self_1._xs, self_1._ys), self_1._xs = _b[0], self_1._ys = _b[1];
            }
            var _a, _b;
        };
        RendererView.prototype.map_to_screen = function (x, y) {
            return this.plot_view.map_to_screen(x, y, this.model.x_range_name, this.model.y_range_name);
        };
        return RendererView;
    }(dom_view_1.DOMView);
    exports.RendererView = RendererView;
    var Renderer = function (_super) {
        tslib_1.__extends(Renderer, _super);
        function Renderer(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        Renderer.initClass = function () {
            this.prototype.type = 'Renderer';
            this.define({
                level: [p.RenderLevel],
                visible: [
                    p.Bool,
                    true
                ]
            });
        };
        return Renderer;
    }(model_1.Model);
    exports.Renderer = Renderer;
    Renderer.initClass();    
},
/*models/scales/categorical_scale*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    var linear_scale_1 = require(169    /* ./linear_scale */);
    var CategoricalScale = function (_super) {
        tslib_1.__extends(CategoricalScale, _super);
        function CategoricalScale(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        CategoricalScale.initClass = function () {
            this.prototype.type = 'CategoricalScale';
        };
        CategoricalScale.prototype.compute = function (x) {
            return _super.prototype.compute.call(this, this.source_range.synthetic(x));
        };
        CategoricalScale.prototype.v_compute = function (xs) {
            return _super.prototype.v_compute.call(this, this.source_range.v_synthetic(xs));
        };
        return CategoricalScale;
    }(linear_scale_1.LinearScale);
    exports.CategoricalScale = CategoricalScale;
    CategoricalScale.initClass();    
},
/*models/scales/index*/
function _(require, module, exports) {
    var categorical_scale_1 = require(167    /* ./categorical_scale */);
    exports.CategoricalScale = categorical_scale_1.CategoricalScale;
    var linear_scale_1 = require(169    /* ./linear_scale */);
    exports.LinearScale = linear_scale_1.LinearScale;
    var log_scale_1 = require(170    /* ./log_scale */);
    exports.LogScale = log_scale_1.LogScale;
    var scale_1 = require(171    /* ./scale */);
    exports.Scale = scale_1.Scale;    
},
/*models/scales/linear_scale*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    var scale_1 = require(171    /* ./scale */);
    var LinearScale = function (_super) {
        tslib_1.__extends(LinearScale, _super);
        function LinearScale(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        LinearScale.initClass = function () {
            this.prototype.type = 'LinearScale';
        };
        LinearScale.prototype.compute = function (x) {
            var _a = this._compute_state(), factor = _a[0], offset = _a[1];
            return factor * x + offset;
        };
        LinearScale.prototype.v_compute = function (xs) {
            var _a = this._compute_state(), factor = _a[0], offset = _a[1];
            var result = new Float64Array(xs.length);
            for (var i = 0; i < xs.length; i++)
                result[i] = factor * xs[i] + offset;
            return result;
        };
        LinearScale.prototype.invert = function (xprime) {
            var _a = this._compute_state(), factor = _a[0], offset = _a[1];
            return (xprime - offset) / factor;
        };
        LinearScale.prototype.v_invert = function (xprimes) {
            var _a = this._compute_state(), factor = _a[0], offset = _a[1];
            var result = new Float64Array(xprimes.length);
            for (var i = 0; i < xprimes.length; i++)
                result[i] = (xprimes[i] - offset) / factor;
            return result;
        };
        LinearScale.prototype._compute_state = function () {
            //
            //  (t1 - t0)       (t1 - t0)
            //  --------- * x - --------- * s0 + t0
            //  (s1 - s0)       (s1 - s0)
            //
            // [  factor  ]     [    offset    ]
            //
            var source_start = this.source_range.start;
            var source_end = this.source_range.end;
            var target_start = this.target_range.start;
            var target_end = this.target_range.end;
            var factor = (target_end - target_start) / (source_end - source_start);
            var offset = -(factor * source_start) + target_start;
            return [
                factor,
                offset
            ];
        };
        return LinearScale;
    }(scale_1.Scale);
    exports.LinearScale = LinearScale;
    LinearScale.initClass();    
},
/*models/scales/log_scale*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    var scale_1 = require(171    /* ./scale */);
    var LogScale = function (_super) {
        tslib_1.__extends(LogScale, _super);
        function LogScale(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        LogScale.initClass = function () {
            this.prototype.type = 'LogScale';
        };
        LogScale.prototype.compute = function (x) {
            var _a = this._compute_state(), factor = _a[0], offset = _a[1], inter_factor = _a[2], inter_offset = _a[3];
            var value;
            if (inter_factor == 0)
                value = 0;
            else {
                var _x = (Math.log(x) - inter_offset) / inter_factor;
                if (isFinite(_x))
                    value = _x * factor + offset;
                else
                    value = NaN;
            }
            return value;
        };
        LogScale.prototype.v_compute = function (xs) {
            var _a = this._compute_state(), factor = _a[0], offset = _a[1], inter_factor = _a[2], inter_offset = _a[3];
            var result = new Float64Array(xs.length);
            if (inter_factor == 0) {
                for (var i = 0; i < xs.length; i++)
                    result[i] = 0;
            } else {
                for (var i = 0; i < xs.length; i++) {
                    var _x = (Math.log(xs[i]) - inter_offset) / inter_factor;
                    var value = void 0;
                    if (isFinite(_x))
                        value = _x * factor + offset;
                    else
                        value = NaN;
                    result[i] = value;
                }
            }
            return result;
        };
        LogScale.prototype.invert = function (xprime) {
            var _a = this._compute_state(), factor = _a[0], offset = _a[1], inter_factor = _a[2], inter_offset = _a[3];
            var value = (xprime - offset) / factor;
            return Math.exp(inter_factor * value + inter_offset);
        };
        LogScale.prototype.v_invert = function (xprimes) {
            var _a = this._compute_state(), factor = _a[0], offset = _a[1], inter_factor = _a[2], inter_offset = _a[3];
            var result = new Float64Array(xprimes.length);
            for (var i = 0; i < xprimes.length; i++) {
                var value = (xprimes[i] - offset) / factor;
                result[i] = Math.exp(inter_factor * value + inter_offset);
            }
            return result;
        };
        LogScale.prototype._get_safe_factor = function (orig_start, orig_end) {
            var start = orig_start < 0 ? 0 : orig_start;
            var end = orig_end < 0 ? 0 : orig_end;
            if (start == end) {
                if (start == 0)
                    _a = [
                        1,
                        10
                    ], start = _a[0], end = _a[1];
                else {
                    var log_val = Math.log(start) / Math.log(10);
                    start = Math.pow(10, Math.floor(log_val));
                    if (Math.ceil(log_val) != Math.floor(log_val))
                        end = Math.pow(10, Math.ceil(log_val));
                    else
                        end = Math.pow(10, Math.ceil(log_val) + 1);
                }
            }
            return [
                start,
                end
            ];
            var _a;
        };
        LogScale.prototype._compute_state = function () {
            var source_start = this.source_range.start;
            var source_end = this.source_range.end;
            var target_start = this.target_range.start;
            var target_end = this.target_range.end;
            var screen_range = target_end - target_start;
            var _a = this._get_safe_factor(source_start, source_end), start = _a[0], end = _a[1];
            var inter_factor;
            var inter_offset;
            if (start == 0) {
                inter_factor = Math.log(end);
                inter_offset = 0;
            } else {
                inter_factor = Math.log(end) - Math.log(start);
                inter_offset = Math.log(start);
            }
            var factor = screen_range;
            var offset = target_start;
            return [
                factor,
                offset,
                inter_factor,
                inter_offset
            ];
        };
        return LogScale;
    }(scale_1.Scale);
    exports.LogScale = LogScale;
    LogScale.initClass();    
},
/*models/scales/scale*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    var transforms_1 = require(243    /* ../transforms */);
    var p = require(15    /* core/properties */);
    var Scale = function (_super) {
        tslib_1.__extends(Scale, _super);
        function Scale(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        Scale.initClass = function () {
            this.prototype.type = 'Scale';
            this.internal({
                source_range: [p.Any],
                target_range: [p.Any]
            });
        };
        Scale.prototype.r_compute = function (x0, x1) {
            if (this.target_range.is_reversed)
                return [
                    this.compute(x1),
                    this.compute(x0)
                ];
            else
                return [
                    this.compute(x0),
                    this.compute(x1)
                ];
        };
        Scale.prototype.r_invert = function (sx0, sx1) {
            if (this.target_range.is_reversed)
                return [
                    this.invert(sx1),
                    this.invert(sx0)
                ];
            else
                return [
                    this.invert(sx0),
                    this.invert(sx1)
                ];
        };
        return Scale;
    }(transforms_1.Transform);
    exports.Scale = Scale;
    Scale.initClass();    
},
/*models/sources/ajax_data_source*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    /* XXX: partial */
    var remote_data_source_1 = require(179    /* ./remote_data_source */);
    var logging_1 = require(14    /* core/logging */);
    var p = require(15    /* core/properties */);
    var AjaxDataSource = function (_super) {
        tslib_1.__extends(AjaxDataSource, _super);
        function AjaxDataSource(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        AjaxDataSource.initClass = function () {
            this.prototype.type = 'AjaxDataSource';
            this.define({
                mode: [
                    p.String,
                    'replace'
                ],
                content_type: [
                    p.String,
                    'application/json'
                ],
                http_headers: [
                    p.Any,
                    {}
                ],
                max_size: [p.Number],
                method: [
                    p.String,
                    'POST'
                ],
                if_modified: [
                    p.Bool,
                    false
                ]
            });
        };
        AjaxDataSource.prototype.destroy = function () {
            if (this.interval != null)
                return clearInterval(this.interval);
            _super.prototype.destroy.call(this);
        };
        AjaxDataSource.prototype.setup = function () {
            if (this.initialized == null) {
                this.initialized = true;
                this.get_data(this.mode);
                if (this.polling_interval) {
                    this.interval = setInterval(this.get_data, this.polling_interval, this.mode, this.max_size, this.if_modified);
                }
            }
        };
        AjaxDataSource.prototype.get_data = function (mode, max_size, _if_modified) {
            var _this = this;
            if (max_size === void 0) {
                max_size = 0;
            }
            if (_if_modified === void 0) {
                _if_modified = false;
            }
            var xhr = new XMLHttpRequest();
            xhr.open(this.method, this.data_url, true);
            xhr.withCredentials = false;
            xhr.setRequestHeader('Content-Type', this.content_type);
            var http_headers = this.http_headers;
            for (var name_1 in http_headers) {
                var value = http_headers[name_1];
                xhr.setRequestHeader(name_1, value);
            }
            // TODO: if_modified
            xhr.addEventListener('load', function () {
                if (xhr.status === 200) {
                    var data = JSON.parse(xhr.responseText);
                    switch (mode) {
                    case 'replace': {
                            _this.data = data;
                            break;
                        }
                    case 'append': {
                            var original_data = _this.data;
                            for (var _i = 0, _a = _this.columns(); _i < _a.length; _i++) {
                                var column = _a[_i];
                                data[column] = original_data[column].concat(data[column]).slice(-max_size);
                            }
                            _this.data = data;
                            break;
                        }
                    }
                }
            });
            xhr.addEventListener('error', function () {
                logging_1.logger.error('Failed to fetch JSON from ' + _this.data_url + ' with code ' + xhr.status);
            });
            xhr.send();
        };
        return AjaxDataSource;
    }(remote_data_source_1.RemoteDataSource);
    exports.AjaxDataSource = AjaxDataSource;
    AjaxDataSource.initClass();    
},
/*models/sources/cds_view*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    /* XXX: partial */
    var model_1 = require(51    /* ../../model */);
    var p = require(15    /* core/properties */);
    var hittest_1 = require(9    /* core/hittest */);
    var array_1 = require(22    /* core/util/array */);
    var columnar_data_source_1 = require(175    /* ./columnar_data_source */);
    var CDSView = function (_super) {
        tslib_1.__extends(CDSView, _super);
        function CDSView(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        CDSView.initClass = function () {
            this.prototype.type = 'CDSView';
            this.define({
                filters: [
                    p.Array,
                    []
                ],
                source: [p.Instance]
            });
            this.internal({
                indices: [
                    p.Array,
                    []
                ],
                indices_map: [
                    p.Any,
                    {}
                ]
            });
        };
        CDSView.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            this.compute_indices();
        };
        CDSView.prototype.connect_signals = function () {
            var _this = this;
            _super.prototype.connect_signals.call(this);
            this.connect(this.properties.filters.change, function () {
                _this.compute_indices();
                _this.change.emit(undefined);
            });
            if (this.source != null) {
                if (this.source.change != null)
                    this.connect(this.source.change, function () {
                        return _this.compute_indices();
                    });
                if (this.source.streaming != null)
                    this.connect(this.source.streaming, function () {
                        return _this.compute_indices();
                    });
                if (this.source.patching != null)
                    this.connect(this.source.patching, function () {
                        return _this.compute_indices();
                    });
            }
        };
        CDSView.prototype.compute_indices = function () {
            var _this = this;
            var indices = this.filters.map(function (filter) {
                return filter.compute_indices(_this.source);
            });
            indices = function () {
                var result = [];
                for (var _i = 0, indices_1 = indices; _i < indices_1.length; _i++) {
                    var inds = indices_1[_i];
                    if (inds != null) {
                        result.push(inds);
                    }
                }
                return result;
            }();
            if (indices.length > 0) {
                this.indices = array_1.intersection.apply(this, indices);
            } else {
                if (this.source instanceof columnar_data_source_1.ColumnarDataSource) {
                    this.indices = this.source != null ? this.source.get_indices() : undefined;
                }
            }
            return this.indices_map_to_subset();
        };
        CDSView.prototype.indices_map_to_subset = function () {
            var _this = this;
            this.indices_map = {};
            return array_1.range(0, this.indices.length).map(function (i) {
                return _this.indices_map[_this.indices[i]] = i;
            });
        };
        CDSView.prototype.convert_selection_from_subset = function (selection_subset) {
            var _this = this;
            var selection_full = hittest_1.create_hit_test_result();
            selection_full.update_through_union(selection_subset);
            var indices_1d = selection_subset['1d']['indices'].map(function (i) {
                return _this.indices[i];
            });
            selection_full['1d']['indices'] = indices_1d;
            return selection_full;
        };
        CDSView.prototype.convert_selection_to_subset = function (selection_full) {
            var _this = this;
            var selection_subset = hittest_1.create_hit_test_result();
            selection_subset.update_through_union(selection_full);
            var indices_1d = selection_full['1d']['indices'].map(function (i) {
                return _this.indices_map[i];
            });
            selection_subset['1d']['indices'] = indices_1d;
            return selection_subset;
        };
        CDSView.prototype.convert_indices_from_subset = function (indices) {
            var _this = this;
            return indices.map(function (i) {
                return _this.indices[i];
            });
        };
        return CDSView;
    }(model_1.Model);
    exports.CDSView = CDSView;
    CDSView.initClass();    
},
/*models/sources/column_data_source*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    /* XXX: partial */
    var columnar_data_source_1 = require(175    /* ./columnar_data_source */);
    var has_props_1 = require(8    /* core/has_props */);
    var p = require(15    /* core/properties */);
    var data_structures_1 = require(28    /* core/util/data_structures */);
    var serialization = require(36    /* core/util/serialization */);
    var types_1 = require(43    /* core/util/types */);
    // exported for testing
    exports.concat_typed_arrays = function (a, b) {
        var c = new a.constructor(a.length + b.length);
        c.set(a, 0);
        c.set(b, a.length);
        return c;
    };
    //exported for testing
    exports.stream_to_column = function (col, new_col, rollover) {
        // handle regular (non-typed) arrays
        var tmp;
        if (col.concat != null) {
            col = col.concat(new_col);
            if (col.length > rollover) {
                col = col.slice(-rollover);
            }
            return col;
        }
        var total_len = col.length + new_col.length;
        // handle rollover case for typed arrays
        if (rollover != null && total_len > rollover) {
            var start = total_len - rollover;
            var end = col.length;
            // resize col if it is shorter than the rollover length
            if (col.length < rollover) {
                tmp = new col.constructor(rollover);
                tmp.set(col, 0);
                col = tmp;
            }
            // shift values in original col to accommodate new_col
            for (var i = start, endi = end; i < endi; i++) {
                col[i - start] = col[i];
            }
            // update end values in col with new_col
            for (var i = 0, endi = new_col.length; i < endi; i++) {
                col[i + (end - start)] = new_col[i];
            }
            return col;
        }
        // handle non-rollover case for typed arrays
        tmp = new col.constructor(new_col);
        return exports.concat_typed_arrays(col, tmp);
    };
    // exported for testing
    exports.slice = function (ind, length) {
        var ref, start, step, stop;
        if (types_1.isObject(ind)) {
            return [
                ind.start != null ? ind.start : 0,
                ind.stop != null ? ind.stop : length,
                ind.step != null ? ind.step : 1
            ];
        }
        return _a = ref = [
            ind,
            ind + 1,
            1
        ], start = _a[0], stop = _a[1], step = _a[2], _a, ref;
        var _a;
    };
    // exported for testing
    exports.patch_to_column = function (col, patch, shapes) {
        var patched = new data_structures_1.Set();
        var patched_range = false;
        for (var _i = 0, patch_1 = patch; _i < patch_1.length; _i++) {
            var _a = patch_1[_i], ind = _a[0], value = _a[1];
            // make the single index case look like the length-3 multi-index case
            var item = void 0, shape = void 0;
            if (!types_1.isArray(ind)) {
                if (types_1.isNumber(ind)) {
                    value = [value];
                    patched.push(ind);
                } else {
                    patched_range = true;
                }
                ind = [
                    0,
                    0,
                    ind
                ];
                shape = [
                    1,
                    col.length
                ];
                item = col;
            } else {
                patched.push(ind[0]);
                shape = shapes[ind[0]];
                item = col[ind[0]];
            }
            // this is basically like NumPy's "newaxis", inserting an empty dimension
            // makes length 2 and 3 multi-index cases uniform, so that the same code
            // can handle both
            if (ind.length === 2) {
                shape = [
                    1,
                    shape[0]
                ];
                ind = [
                    ind[0],
                    0,
                    ind[1]
                ];
            }
            // now this one nested loop handles all cases
            var flat_index = 0;
            var _b = exports.slice(ind[1], shape[0]), istart = _b[0], istop = _b[1], istep = _b[2];
            var _c = exports.slice(ind[2], shape[1]), jstart = _c[0], jstop = _c[1], jstep = _c[2];
            for (var i = istart; i < istop; i += istep) {
                for (var j = jstart; j < jstop; j += jstep) {
                    if (patched_range) {
                        patched.push(j);
                    }
                    item[i * shape[1] + j] = value[flat_index];
                    flat_index++;
                }
            }
        }
        return patched;
    };
    var ColumnDataSource = function (_super) {
        tslib_1.__extends(ColumnDataSource, _super);
        function ColumnDataSource(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        ColumnDataSource.initClass = function () {
            this.prototype.type = 'ColumnDataSource';
            this.define({
                data: [
                    p.Any,
                    {}
                ]
            });
        };
        ColumnDataSource.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            _a = serialization.decode_column_data(this.data), this.data = _a[0], this._shapes = _a[1];
            var _a;
        };
        ColumnDataSource.prototype.attributes_as_json = function (include_defaults, value_to_json) {
            if (include_defaults === void 0) {
                include_defaults = true;
            }
            if (value_to_json === void 0) {
                value_to_json = ColumnDataSource._value_to_json;
            }
            var attrs = {};
            var object = this.serializable_attributes();
            for (var _i = 0, _a = Object.keys(object || {}); _i < _a.length; _i++) {
                var key = _a[_i];
                var value = object[key];
                if (key === 'data') {
                    value = serialization.encode_column_data(value, this._shapes);
                }
                if (include_defaults) {
                    attrs[key] = value;
                } else if (key in this._set_after_defaults) {
                    attrs[key] = value;
                }
            }
            return value_to_json('attributes', attrs, this);
        };
        ColumnDataSource._value_to_json = function (key, value, optional_parent_object) {
            if (types_1.isObject(value) && key === 'data') {
                return serialization.encode_column_data(value, optional_parent_object._shapes);
            } else {
                return has_props_1.HasProps._value_to_json(key, value, optional_parent_object);
            }
        };
        ColumnDataSource.prototype.stream = function (new_data, rollover) {
            var data = this.data;
            for (var k in new_data) {
                data[k] = exports.stream_to_column(data[k], new_data[k], rollover);
            }
            this.setv({ data: data }, { silent: true });
            return this.streaming.emit(undefined);
        };
        ColumnDataSource.prototype.patch = function (patches) {
            var data = this.data;
            var patched = new data_structures_1.Set();
            for (var k in patches) {
                var patch = patches[k];
                patched = patched.union(exports.patch_to_column(data[k], patch, this._shapes[k]));
            }
            this.setv({ data: data }, { silent: true });
            return this.patching.emit(patched.values);
        };
        return ColumnDataSource;
    }(columnar_data_source_1.ColumnarDataSource);
    exports.ColumnDataSource = ColumnDataSource;
    ColumnDataSource.initClass();    
},
/*models/sources/columnar_data_source*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    /* XXX: partial */
    var data_source_1 = require(176    /* ./data_source */);
    var signaling_1 = require(20    /* core/signaling */);
    var logging_1 = require(14    /* core/logging */);
    var selection_manager_1 = require(17    /* core/selection_manager */);
    var p = require(15    /* core/properties */);
    var array_1 = require(22    /* core/util/array */);
    var object_1 = require(31    /* core/util/object */);
    var ColumnarDataSource = function (_super) {
        tslib_1.__extends(ColumnarDataSource, _super);
        function ColumnarDataSource(attrs, opts) {
            return _super.call(this, attrs, opts) || this;
        }
        ColumnarDataSource.initClass = function () {
            this.prototype.type = 'ColumnarDataSource';
            this.define({
                column_names: [
                    p.Array,
                    []
                ]
            });
            this.internal({
                selection_manager: [
                    p.Instance,
                    function (self) {
                        return new selection_manager_1.SelectionManager({ source: self });
                    }
                ],
                inspected: [p.Any],
                _shapes: [
                    p.Any,
                    {}
                ]
            });
        };
        ColumnarDataSource.prototype.initialize = function () {
            _super.prototype.initialize.call(this);
            this._select = new signaling_1.Signal(this, 'select');
            this.inspect = new signaling_1.Signal(this, 'inspect');
            // XXX: <[indices, tool, renderer-view, source, data], this>
            this.streaming = new signaling_1.Signal(this, 'streaming');
            this.patching = new signaling_1.Signal(this, 'patching');    // <number[], ColumnarDataSource>
        };
        ColumnarDataSource.prototype.get_column = function (colname) {
            var column = this.data[colname];
            return column != null ? column : null;
        };
        ColumnarDataSource.prototype.columns = function () {
            // return the column names in this data source
            return object_1.keys(this.data);
        };
        ColumnarDataSource.prototype.get_length = function (soft) {
            if (soft === void 0) {
                soft = true;
            }
            var lengths = array_1.uniq(object_1.values(this.data).map(function (v) {
                return v.length;
            }));
            switch (lengths.length) {
            case 0: {
                    return null;    // XXX: don't guess, treat on case-by-case basis
                }
            case 1: {
                    return lengths[0];
                }
            default: {
                    var msg = 'data source has columns of inconsistent lengths';
                    if (soft) {
                        logging_1.logger.warn(msg);
                        return lengths.sort()[0];
                    } else {
                        throw new Error(msg);
                    }
                }
            }
        };
        ColumnarDataSource.prototype.get_indices = function () {
            var length = this.get_length();
            return array_1.range(0, length != null ? length : 1);
        };
        return ColumnarDataSource;
    }(data_source_1.DataSource);
    exports.ColumnarDataSource = ColumnarDataSource;
    ColumnarDataSource.initClass();    
},
/*models/sources/data_source*/
function _(require, module, exports) {
    var tslib_1 = require(369    /* tslib */);
    var model_1 = require(51    /* ../../model */);
    var hittest = require(9    /* core/hittest */);
    var p = require(15    /* core/properties */);
    var types_1 = require(43    