# This file was automatically generated by bifcl from /usr/obj/ports/bro-2.5.3/bro-2.5.3/src/file_analysis/analyzer/x509/functions.bif (plugin mode).

export {


## Parses a certificate into an X509::Certificate structure.
##
## cert: The X509 certificate opaque handle.
##
## Returns: A X509::Certificate structure.
##
## .. bro:see:: x509_certificate x509_extension x509_ext_basic_constraints
##              x509_ext_subject_alternative_name x509_verify
##              x509_get_certificate_string
global x509_parse: function(cert: opaque of x509 ): X509::Certificate ;


## Returns the string form of a certificate.
##
## cert: The X509 certificate opaque handle.
##
## pem: A boolean that specifies if the certificate is returned
##      in pem-form (true), or as the raw ASN1 encoded binary
##      (false).
##
## Returns: X509 certificate as a string.
##
## .. bro:see:: x509_certificate x509_extension x509_ext_basic_constraints
##              x509_ext_subject_alternative_name x509_parse x509_verify
global x509_get_certificate_string: function(cert: opaque of x509 , pem: bool &default=F): string ;


## Verifies an OCSP reply.
##
## certs: Specifies the certificate chain to use. Server certificate first.
##
## ocsp_reply: the ocsp reply to validate.
##
## root_certs: A list of root certificates to validate the certificate chain.
##
## verify_time: Time for the validity check of the certificates.
##
## Returns: A record of type X509::Result containing the result code of the
##          verify operation.
##
## .. bro:see:: x509_certificate x509_extension x509_ext_basic_constraints
##              x509_ext_subject_alternative_name x509_parse
##              x509_get_certificate_string x509_verify
global x509_ocsp_verify: function(certs: x509_opaque_vector , ocsp_reply: string , root_certs: table_string_of_string , verify_time: time &default=network_time()): X509::Result ;


## Verifies a certificate.
##
## certs: Specifies a certificate chain that is being used to validate
##        the given certificate against the root store given in *root_certs*.
##        The host certificate has to be at index 0.
##
## root_certs: A list of root certificates to validate the certificate chain.
##
## verify_time: Time for the validity check of the certificates.
##
## Returns: A record of type X509::Result containing the result code of the
##          verify operation. In case of success also returns the full
##          certificate chain.
##
## .. bro:see:: x509_certificate x509_extension x509_ext_basic_constraints
##              x509_ext_subject_alternative_name x509_parse
##              x509_get_certificate_string x509_ocsp_verify
global x509_verify: function(certs: x509_opaque_vector , root_certs: table_string_of_string , verify_time: time &default=network_time()): X509::Result ;

} # end of export section
module GLOBAL;
