# This file was automatically generated by bifcl from /usr/obj/ports/bro-2.5.1/bro-2.5.1/src/probabilistic/bloom-filter.bif (alternative mode).

##! Functions to create and manipulate Bloom filters.

export {


module GLOBAL;


## Creates a basic Bloom filter.
##
## fp: The desired false-positive rate.
##
## capacity: the maximum number of elements that guarantees a false-positive
##           rate of *fp*.
##
## name: A name that uniquely identifies and seeds the Bloom filter. If empty,
##       the filter will use :bro:id:`global_hash_seed` if that's set, and
##       otherwise use a local seed tied to the current Bro process. Only
##       filters with the same seed can be merged with
##       :bro:id:`bloomfilter_merge`.
##
## Returns: A Bloom filter handle.
##
## .. bro:see:: bloomfilter_basic_init2 bloomfilter_counting_init bloomfilter_add
##    bloomfilter_lookup bloomfilter_clear bloomfilter_merge global_hash_seed
global bloomfilter_basic_init: function(fp: double , capacity: count , name: string &default=""): opaque of bloomfilter ;


## Creates a basic Bloom filter. This function serves as a low-level
## alternative to :bro:id:`bloomfilter_basic_init` where the user has full
## control over the number of hash functions and cells in the underlying bit
## vector.
##
## k: The number of hash functions to use.
##
## cells: The number of cells of the underlying bit vector.
##
## name: A name that uniquely identifies and seeds the Bloom filter. If empty,
##       the filter will use :bro:id:`global_hash_seed` if that's set, and
##       otherwise use a local seed tied to the current Bro process. Only
##       filters with the same seed can be merged with
##       :bro:id:`bloomfilter_merge`.
##
## Returns: A Bloom filter handle.
##
## .. bro:see:: bloomfilter_basic_init bloomfilter_counting_init  bloomfilter_add
##    bloomfilter_lookup bloomfilter_clear bloomfilter_merge global_hash_seed
global bloomfilter_basic_init2: function(k: count , cells: count , name: string &default=""): opaque of bloomfilter ;


## Creates a counting Bloom filter.
##
## k: The number of hash functions to use.
##
## cells: The number of cells of the underlying counter vector. As there's
##        no single answer to what's the best parameterization for a
##        counting Bloom filter, we refer to the Bloom filter literature
##        here for choosing an appropiate value.
##
## max: The maximum counter value associated with each element
##      described by *w = ceil(log_2(max))* bits. Each bit in the underlying
##      counter vector becomes a cell of size *w* bits.
##
## name: A name that uniquely identifies and seeds the Bloom filter. If empty,
##       the filter will use :bro:id:`global_hash_seed` if that's set, and
##       otherwise use a local seed tied to the current Bro process. Only
##       filters with the same seed can be merged with
##       :bro:id:`bloomfilter_merge`.
##
## Returns: A Bloom filter handle.
##
## .. bro:see:: bloomfilter_basic_init bloomfilter_basic_init2 bloomfilter_add
##    bloomfilter_lookup bloomfilter_clear bloomfilter_merge global_hash_seed
global bloomfilter_counting_init: function(k: count , cells: count , max: count , name: string &default=""): opaque of bloomfilter ;


## Adds an element to a Bloom filter.
##
## bf: The Bloom filter handle.
##
## x: The element to add.
##
## .. bro:see:: bloomfilter_basic_init bloomfilter_basic_init2 
##    bloomfilter_counting_init bloomfilter_lookup bloomfilter_clear 
##    bloomfilter_merge
global bloomfilter_add: function(bf: opaque of bloomfilter , x: any ): any ;


## Retrieves the counter for a given element in a Bloom filter.
##
## bf: The Bloom filter handle.
##
## x: The element to count.
##
## Returns: the counter associated with *x* in *bf*.
##
## .. bro:see:: bloomfilter_basic_init bloomfilter_basic_init2
##    bloomfilter_counting_init bloomfilter_add bloomfilter_clear
##    bloomfilter_merge
global bloomfilter_lookup: function(bf: opaque of bloomfilter , x: any ): count ;


## Removes all elements from a Bloom filter. This function resets all bits in
## the underlying bitvector back to 0 but does not change the parameterization
## of the Bloom filter, such as the element type and the hasher seed.
##
## bf: The Bloom filter handle.
##
## .. bro:see:: bloomfilter_basic_init bloomfilter_basic_init2
##    bloomfilter_counting_init bloomfilter_add bloomfilter_lookup
##    bloomfilter_merge
global bloomfilter_clear: function(bf: opaque of bloomfilter ): any ;


## Merges two Bloom filters.
##
## .. note:: Currently Bloom filters created by different Bro instances cannot
##    be merged. In the future, this will be supported as long as both filters
##    are created with the same name.
##
## bf1: The first Bloom filter handle.
##
## bf2: The second Bloom filter handle.
##
## Returns: The union of *bf1* and *bf2*.
##
## .. bro:see:: bloomfilter_basic_init bloomfilter_basic_init2
##    bloomfilter_counting_init bloomfilter_add bloomfilter_lookup
##    bloomfilter_clear
global bloomfilter_merge: function(bf1: opaque of bloomfilter , bf2: opaque of bloomfilter ): opaque of bloomfilter ;


## Returns a string with a representation of a Bloom filter's internal
## state. This is for debugging/testing purposes only.
## 
## bf: The Bloom filter handle.
##
## Returns: a string with a representation of a Bloom filter's internal state.
global bloomfilter_internal_state: function(bf: opaque of bloomfilter ): string ;

} # end of export section
module GLOBAL;
