/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.undo;

import javax.swing.UIManager;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;

public class UndoManager
extends CompoundEdit
implements UndoableEditListener {
    static final long serialVersionUID = -2077529998244066750L;
    int indexOfNextAdd;
    int limit = 100;

    public String toString() {
        return String.valueOf(super.toString()) + " limit: " + this.limit + " indexOfNextAdd: " + this.indexOfNextAdd;
    }

    public synchronized void end() {
        super.end();
        this.trimEdits(this.indexOfNextAdd, this.edits.size() - 1);
    }

    public synchronized int getLimit() {
        return this.limit;
    }

    public synchronized void setLimit(int limit) {
        if (!this.isInProgress()) {
            throw new IllegalStateException();
        }
        this.limit = limit;
        this.trimForLimit();
    }

    public synchronized void discardAllEdits() {
        int size = this.edits.size();
        int i = size - 1;
        while (i >= 0) {
            ((UndoableEdit)this.edits.get(i)).die();
            --i;
        }
        this.indexOfNextAdd = 0;
        this.edits.clear();
    }

    protected void trimForLimit() {
        int s = this.edits.size();
        if (this.limit <= 0 || s <= this.limit) {
            return;
        }
        int high = Math.min(this.indexOfNextAdd + this.limit / 2 - 1, s - 1);
        this.trimEdits(high + 1, s - 1);
        this.trimEdits(0, high - this.limit);
    }

    protected void trimEdits(int from, int to) {
        if (from > to) {
            return;
        }
        int i = to;
        while (i >= from) {
            ((UndoableEdit)this.edits.get(i)).die();
            --i;
        }
        if (to == from) {
            this.edits.remove(from);
        } else {
            this.edits.subList(from, to + 1).clear();
        }
        if (this.indexOfNextAdd > to) {
            this.indexOfNextAdd = this.indexOfNextAdd - to + from - 1;
        } else if (this.indexOfNextAdd >= from) {
            this.indexOfNextAdd = from;
        }
    }

    protected UndoableEdit editToBeUndone() {
        int i = this.indexOfNextAdd - 1;
        while (i >= 0) {
            UndoableEdit result = (UndoableEdit)this.edits.get(i);
            if (result.isSignificant()) {
                return result;
            }
            --i;
        }
        return null;
    }

    protected UndoableEdit editToBeRedone() {
        int i = this.indexOfNextAdd;
        while (i < this.edits.size()) {
            UndoableEdit result = (UndoableEdit)this.edits.get(i);
            if (result.isSignificant()) {
                return result;
            }
            ++i;
        }
        return null;
    }

    protected void undoTo(UndoableEdit edit) throws CannotUndoException {
        UndoableEdit cur;
        if (!this.edits.contains(edit)) {
            throw new CannotUndoException();
        }
        do {
            --this.indexOfNextAdd;
            cur = (UndoableEdit)this.edits.get(this.indexOfNextAdd);
            cur.undo();
        } while (cur != edit);
    }

    protected void redoTo(UndoableEdit edit) throws CannotRedoException {
        UndoableEdit cur;
        if (!this.edits.contains(edit)) {
            throw new CannotRedoException();
        }
        do {
            cur = (UndoableEdit)this.edits.get(this.indexOfNextAdd);
            ++this.indexOfNextAdd;
            cur.redo();
        } while (cur != edit);
    }

    public synchronized void undoOrRedo() throws CannotRedoException, CannotUndoException {
        if (this.indexOfNextAdd == this.edits.size()) {
            this.undo();
        } else {
            this.redo();
        }
    }

    public synchronized boolean canUndoOrRedo() {
        return this.indexOfNextAdd == this.edits.size() ? this.canUndo() : this.canRedo();
    }

    public synchronized void undo() throws CannotUndoException {
        if (!this.isInProgress()) {
            super.undo();
            return;
        }
        UndoableEdit edit = this.editToBeUndone();
        if (edit == null) {
            throw new CannotUndoException();
        }
        this.undoTo(edit);
    }

    public synchronized boolean canUndo() {
        if (!this.isInProgress()) {
            return super.canUndo();
        }
        UndoableEdit edit = this.editToBeUndone();
        return edit != null && edit.canUndo();
    }

    public synchronized void redo() throws CannotRedoException {
        if (!this.isInProgress()) {
            super.redo();
            return;
        }
        UndoableEdit edit = this.editToBeRedone();
        if (edit == null) {
            throw new CannotRedoException();
        }
        this.redoTo(edit);
    }

    public synchronized boolean canRedo() {
        if (!this.isInProgress()) {
            return super.canRedo();
        }
        UndoableEdit edit = this.editToBeRedone();
        return edit != null && edit.canRedo();
    }

    public synchronized boolean addEdit(UndoableEdit edit) {
        this.trimEdits(this.indexOfNextAdd, this.edits.size() - 1);
        boolean result = super.addEdit(edit);
        this.indexOfNextAdd = this.edits.size();
        this.trimForLimit();
        return result;
    }

    public synchronized String getUndoOrRedoPresentationName() {
        if (this.indexOfNextAdd == this.edits.size()) {
            return this.getUndoPresentationName();
        }
        return this.getRedoPresentationName();
    }

    public synchronized String getUndoPresentationName() {
        if (!this.isInProgress()) {
            return super.getUndoPresentationName();
        }
        UndoableEdit edit = this.editToBeUndone();
        if (edit == null) {
            return UIManager.getString("AbstractUndoableEdit.undoText");
        }
        return edit.getUndoPresentationName();
    }

    public synchronized String getRedoPresentationName() {
        if (!this.isInProgress()) {
            return super.getRedoPresentationName();
        }
        UndoableEdit edit = this.editToBeRedone();
        if (edit == null) {
            return UIManager.getString("AbstractUndoableEdit.redoText");
        }
        return edit.getRedoPresentationName();
    }

    public void undoableEditHappened(UndoableEditEvent event) {
        this.addEdit(event.getEdit());
    }
}

