/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.beans.PropertyVetoException;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleValue;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.WindowConstants;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.plaf.DesktopIconUI;
import javax.swing.plaf.InternalFrameUI;

public class JInternalFrame
extends JComponent
implements Accessible,
WindowConstants,
RootPaneContainer {
    private static final long serialVersionUID = -5425177187760785402L;
    public static final String CONTENT_PANE_PROPERTY = "contentPane";
    public static final String FRAME_ICON_PROPERTY = "frameIcon";
    public static final String GLASS_PANE_PROPERTY = "glassPane";
    public static final String IS_CLOSED_PROPERTY = "closed";
    public static final String IS_ICON_PROPERTY = "icon";
    public static final String IS_MAXIMUM_PROPERTY = "maximum";
    public static final String IS_SELECTED_PROPERTY = "selected";
    public static final String LAYERED_PANE_PROPERTY = "layeredPane";
    public static final String MENU_BAR_PROPERTY = "JMenuBar";
    public static final String ROOT_PANE_PROPERTY = "rootPane";
    public static final String TITLE_PROPERTY = "title";
    protected boolean closable;
    protected boolean iconable;
    protected boolean isClosed;
    protected boolean isIcon;
    protected boolean isMaximum;
    protected boolean isSelected;
    protected boolean maximizable;
    protected boolean rootPaneCheckingEnabled = false;
    protected boolean resizable;
    protected JDesktopIcon desktopIcon;
    protected Icon frameIcon;
    protected JRootPane rootPane;
    protected String title;
    private transient Rectangle storedBounds;
    private transient Component defaultFocus;
    private transient int defaultCloseOperation = 2;
    private transient boolean isFirstTimeVisible = true;
    private transient boolean wasIcon = false;

    public JInternalFrame() {
        this("", false, false, false, false);
    }

    public JInternalFrame(String title) {
        this(title, false, false, false, false);
    }

    public JInternalFrame(String title, boolean resizable) {
        this(title, resizable, false, false, false);
    }

    public JInternalFrame(String title, boolean resizable, boolean closable) {
        this(title, resizable, closable, false, false);
    }

    public JInternalFrame(String title, boolean resizable, boolean closable, boolean maximizable) {
        this(title, resizable, closable, maximizable, false);
    }

    public JInternalFrame(String title, boolean resizable, boolean closable, boolean maximizable, boolean iconifiable) {
        this.title = title;
        this.resizable = resizable;
        this.closable = closable;
        this.maximizable = maximizable;
        this.iconable = iconifiable;
        this.isMaximum = false;
        this.setRootPane(this.createRootPane());
        this.setVisible(false);
        this.setOpaque(true);
        this.desktopIcon = new JDesktopIcon(this);
        this.updateUI();
        this.setRootPaneCheckingEnabled(true);
    }

    protected void addImpl(Component comp, Object constraints, int index) {
        if (this.isRootPaneCheckingEnabled()) {
            this.getContentPane().add(comp, constraints, index);
        } else {
            super.addImpl(comp, constraints, index);
        }
    }

    public void addInternalFrameListener(InternalFrameListener l) {
        this.listenerList.add(InternalFrameListener.class, l);
    }

    protected JRootPane createRootPane() {
        return new JRootPane();
    }

    public void dispose() {
        if (this.isVisible()) {
            this.setVisible(false);
        }
        if (this.isSelected()) {
            try {
                this.setSelected(false);
            }
            catch (PropertyVetoException propertyVetoException) {}
        }
        if (!this.isClosed) {
            this.firePropertyChange(IS_CLOSED_PROPERTY, Boolean.FALSE, Boolean.TRUE);
            this.isClosed = true;
        }
        this.fireInternalFrameEvent(25551);
    }

    public void doDefaultCloseAction() {
        this.fireInternalFrameEvent(25550);
        switch (this.getDefaultCloseOperation()) {
            case 1: {
                this.setVisible(false);
                break;
            }
            case 2: {
                this.dispose();
            }
        }
    }

    protected void fireInternalFrameEvent(int id) {
        Object[] ifListeners = this.listenerList.getListenerList();
        InternalFrameEvent evt = new InternalFrameEvent(this, id);
        switch (id) {
            case 25550: {
                int i = ifListeners.length - 2;
                while (i >= 0) {
                    if (ifListeners[i] == InternalFrameListener.class) {
                        ((InternalFrameListener)ifListeners[i + 1]).internalFrameClosing(evt);
                    }
                    i -= 2;
                }
                break;
            }
            case 25554: {
                int i = ifListeners.length - 2;
                while (i >= 0) {
                    if (ifListeners[i] == InternalFrameListener.class) {
                        ((InternalFrameListener)ifListeners[i + 1]).internalFrameActivated(evt);
                    }
                    i -= 2;
                }
                break;
            }
            case 25551: {
                int i = ifListeners.length - 2;
                while (i >= 0) {
                    if (ifListeners[i] == InternalFrameListener.class) {
                        ((InternalFrameListener)ifListeners[i + 1]).internalFrameClosed(evt);
                    }
                    i -= 2;
                }
                break;
            }
            case 25555: {
                int i = ifListeners.length - 2;
                while (i >= 0) {
                    if (ifListeners[i] == InternalFrameListener.class) {
                        ((InternalFrameListener)ifListeners[i + 1]).internalFrameDeactivated(evt);
                    }
                    i -= 2;
                }
                break;
            }
            case 25553: {
                int i = ifListeners.length - 2;
                while (i >= 0) {
                    if (ifListeners[i] == InternalFrameListener.class) {
                        ((InternalFrameListener)ifListeners[i + 1]).internalFrameDeiconified(evt);
                    }
                    i -= 2;
                }
                break;
            }
            case 25552: {
                int i = ifListeners.length - 2;
                while (i >= 0) {
                    if (ifListeners[i] == InternalFrameListener.class) {
                        ((InternalFrameListener)ifListeners[i + 1]).internalFrameIconified(evt);
                    }
                    i -= 2;
                }
                break;
            }
            case 25549: {
                int i = ifListeners.length - 2;
                while (i >= 0) {
                    if (ifListeners[i] == InternalFrameListener.class) {
                        ((InternalFrameListener)ifListeners[i + 1]).internalFrameOpened(evt);
                    }
                    i -= 2;
                }
                break;
            }
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJInternalFrame();
        }
        return this.accessibleContext;
    }

    public Container getContentPane() {
        return this.getRootPane().getContentPane();
    }

    public int getDefaultCloseOperation() {
        return this.defaultCloseOperation;
    }

    public JDesktopIcon getDesktopIcon() {
        return this.desktopIcon;
    }

    public JDesktopPane getDesktopPane() {
        JDesktopPane value = (JDesktopPane)SwingUtilities.getAncestorOfClass(JDesktopPane.class, this);
        if (value == null && this.desktopIcon != null) {
            value = this.desktopIcon.getDesktopPane();
        }
        return value;
    }

    public final Container getFocusCycleRootAncestor() {
        return null;
    }

    public Component getFocusOwner() {
        Component focus;
        if (this.isSelected() && SwingUtilities.isDescendingFrom(focus = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner(), this)) {
            this.defaultFocus = focus;
            return focus;
        }
        return null;
    }

    public Icon getFrameIcon() {
        return this.frameIcon;
    }

    public Component getGlassPane() {
        return this.getRootPane().getGlassPane();
    }

    public InternalFrameListener[] getInternalFrameListeners() {
        return (InternalFrameListener[])this.listenerList.getListeners(InternalFrameListener.class);
    }

    public JMenuBar getJMenuBar() {
        return this.getRootPane().getJMenuBar();
    }

    public int getLayer() {
        return JLayeredPane.getLayer(this);
    }

    public JLayeredPane getLayeredPane() {
        return this.getRootPane().getLayeredPane();
    }

    public JMenuBar getMenuBar() {
        return this.getJMenuBar();
    }

    public Component getMostRecentFocusOwner() {
        if (this.isSelected()) {
            return this.getFocusOwner();
        }
        return this.defaultFocus;
    }

    public Rectangle getNormalBounds() {
        if (this.storedBounds == null) {
            return this.getBounds();
        }
        return this.storedBounds;
    }

    public JRootPane getRootPane() {
        return this.rootPane;
    }

    public String getTitle() {
        return this.title;
    }

    public InternalFrameUI getUI() {
        return (InternalFrameUI)this.ui;
    }

    public String getUIClassID() {
        return "InternalFrameUI";
    }

    public final String getWarningString() {
        return null;
    }

    public void hide() {
        if (this.isIcon()) {
            this.getDesktopIcon().hide();
        }
        super.hide();
    }

    public boolean isClosable() {
        return this.closable;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public final boolean isFocusCycleRoot() {
        return true;
    }

    public boolean isIcon() {
        return this.isIcon;
    }

    public boolean isIconifiable() {
        return this.iconable;
    }

    public boolean isMaximizable() {
        return this.maximizable;
    }

    public boolean isMaximum() {
        return this.isMaximum;
    }

    public boolean isResizable() {
        return this.resizable;
    }

    protected boolean isRootPaneCheckingEnabled() {
        return this.rootPaneCheckingEnabled;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void moveToBack() {
        Container p = this.getParent();
        if (p instanceof JLayeredPane) {
            ((JLayeredPane)p).moveToBack(this);
        }
    }

    public void moveToFront() {
        Container p = this.getParent();
        if (p != null && p instanceof JLayeredPane) {
            ((JLayeredPane)p).moveToFront(this);
        }
    }

    public void pack() {
        try {
            if (this.isIcon()) {
                this.setIcon(false);
            } else if (this.isMaximum()) {
                this.setMaximum(false);
            }
        }
        catch (PropertyVetoException propertyVetoException) {}
        this.setSize(this.getPreferredSize());
        this.validate();
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
    }

    protected String paramString() {
        return String.valueOf(super.paramString()) + ",title=" + this.getTitle();
    }

    public void remove(Component comp) {
        if (comp == this.rootPane || !this.isRootPaneCheckingEnabled()) {
            super.remove(comp);
        } else {
            this.getContentPane().remove(comp);
        }
    }

    public void removeInternalFrameListener(InternalFrameListener l) {
        this.listenerList.remove(InternalFrameListener.class, l);
    }

    public void reshape(int x, int y, int width, int height) {
        super.reshape(x, y, width, height);
        this.revalidate();
    }

    public void restoreSubcomponentFocus() {
        Component c = this.getMostRecentFocusOwner();
        if (c != null) {
            c.requestFocus();
        }
    }

    public void setClosable(boolean b) {
        if (this.closable != b) {
            this.closable = b;
            this.firePropertyChange("closable", !this.closable, this.closable);
        }
    }

    public void setClosed(boolean b) throws PropertyVetoException {
        if (b && !this.isClosed()) {
            this.fireInternalFrameEvent(25550);
            this.fireVetoableChange(IS_CLOSED_PROPERTY, false, true);
            this.isClosed = b;
            this.dispose();
            this.firePropertyChange(IS_CLOSED_PROPERTY, false, true);
        }
    }

    public void setContentPane(Container c) {
        if (c != this.getContentPane()) {
            Container old = this.getContentPane();
            this.getRootPane().setContentPane(c);
            this.firePropertyChange(CONTENT_PANE_PROPERTY, old, c);
        }
    }

    public void setDefaultCloseOperation(int operation) {
        this.defaultCloseOperation = operation;
    }

    public void setDesktopIcon(JDesktopIcon d) {
        if (this.desktopIcon != d) {
            JDesktopIcon oldIcon = this.desktopIcon;
            this.desktopIcon = d;
            this.firePropertyChange("desktopIcon", oldIcon, d);
        }
    }

    public final void setFocusCycleRoot(boolean focusCycleRoot) {
    }

    public void setFrameIcon(Icon icon) {
        if (icon != this.frameIcon) {
            Icon old = this.frameIcon;
            this.frameIcon = icon;
            this.firePropertyChange(FRAME_ICON_PROPERTY, old, this.frameIcon);
        }
    }

    public void setGlassPane(Component glass) {
        if (glass != this.getGlassPane()) {
            Component old = this.getGlassPane();
            this.getRootPane().setGlassPane(glass);
            this.firePropertyChange(GLASS_PANE_PROPERTY, old, glass);
        }
    }

    public void setIcon(boolean b) throws PropertyVetoException {
        if (b != this.isIcon()) {
            this.fireVetoableChange(IS_ICON_PROPERTY, b, this.isIcon);
            this.isIcon = b;
            this.firePropertyChange(IS_ICON_PROPERTY, !this.isIcon, this.isIcon);
            if (b) {
                this.fireInternalFrameEvent(25552);
            } else {
                this.fireInternalFrameEvent(25553);
            }
        }
    }

    public void setIconifiable(boolean b) {
        if (this.iconable != b) {
            this.iconable = b;
            this.firePropertyChange("iconable", !this.iconable, this.iconable);
        }
    }

    public void setJMenuBar(JMenuBar b) {
        JMenuBar old = this.getJMenuBar();
        this.getRootPane().setJMenuBar(b);
        this.firePropertyChange(MENU_BAR_PROPERTY, old, b);
    }

    public void setLayer(int layer) {
        this.setLayer(new Integer(layer));
    }

    public void setLayer(Integer layer) {
        Container p = this.getParent();
        if (p instanceof JLayeredPane) {
            JLayeredPane lp = (JLayeredPane)p;
            lp.setLayer(this, layer, lp.getPosition(this));
        } else {
            JLayeredPane.putLayer(this, layer);
            if (p != null) {
                p.repaint(this.getX(), this.getY(), this.getWidth(), this.getHeight());
            }
        }
    }

    public void setLayeredPane(JLayeredPane layered) {
        if (layered == null) {
            throw new IllegalComponentStateException("LayeredPane must not be null");
        }
        if (layered != this.getLayeredPane()) {
            JLayeredPane old = this.getLayeredPane();
            this.getRootPane().setLayeredPane(layered);
            this.firePropertyChange(LAYERED_PANE_PROPERTY, old, layered);
        }
    }

    public void setMaximizable(boolean b) {
        if (this.maximizable != b) {
            this.maximizable = b;
            this.firePropertyChange("maximizable", !this.maximizable, this.maximizable);
        }
    }

    public void setLayout(LayoutManager manager) {
        if (this.isRootPaneCheckingEnabled()) {
            this.getContentPane().setLayout(manager);
        } else {
            super.setLayout(manager);
        }
    }

    public void setMaximum(boolean b) throws PropertyVetoException {
        if (b != this.isMaximum) {
            this.fireVetoableChange(IS_MAXIMUM_PROPERTY, this.isMaximum, b);
            this.isMaximum = b;
            this.firePropertyChange(IS_MAXIMUM_PROPERTY, !this.isMaximum, this.isMaximum);
        }
    }

    public void setMenuBar(JMenuBar m) {
        this.setJMenuBar(m);
    }

    public void setNormalBounds(Rectangle r) {
        this.storedBounds = r;
    }

    public void setResizable(boolean b) {
        if (b != this.resizable) {
            this.resizable = b;
            this.firePropertyChange("resizable", !this.resizable, this.resizable);
        }
    }

    protected void setRootPane(JRootPane root) {
        if (this.rootPane != null) {
            this.remove(this.rootPane);
        }
        JRootPane old = this.rootPane;
        this.rootPane = root;
        if (this.rootPane != null) {
            boolean checkingEnabled = this.isRootPaneCheckingEnabled();
            try {
                this.setRootPaneCheckingEnabled(false);
                this.add((Component)this.rootPane, "Center");
            }
            finally {
                this.setRootPaneCheckingEnabled(checkingEnabled);
            }
        }
        this.firePropertyChange(ROOT_PANE_PROPERTY, old, this.rootPane);
    }

    protected void setRootPaneCheckingEnabled(boolean enabled) {
        this.rootPaneCheckingEnabled = enabled;
    }

    public void setSelected(boolean selected) throws PropertyVetoException {
        if (selected != this.isSelected && (!selected || (this.isIcon ? this.desktopIcon.isShowing() : this.isShowing()))) {
            this.fireVetoableChange(IS_SELECTED_PROPERTY, this.isSelected, selected);
            if (!selected) {
                this.defaultFocus = this.getMostRecentFocusOwner();
            }
            this.isSelected = selected;
            this.firePropertyChange(IS_SELECTED_PROPERTY, !this.isSelected, this.isSelected);
            if (this.isSelected) {
                this.fireInternalFrameEvent(25554);
            } else {
                this.fireInternalFrameEvent(25555);
            }
            if (selected) {
                this.restoreSubcomponentFocus();
            }
            this.repaint();
        }
    }

    public void setTitle(String title) {
        String old = this.title;
        this.title = title;
        this.firePropertyChange(TITLE_PROPERTY, old, this.title);
    }

    public void show() {
        if (!this.isVisible()) {
            if (this.isFirstTimeVisible) {
                this.isFirstTimeVisible = false;
                this.fireInternalFrameEvent(25549);
            }
            this.getDesktopIcon().setVisible(true);
            this.toFront();
            super.show();
            if (this.isIcon()) {
                return;
            }
            if (!this.isSelected()) {
                try {
                    this.setSelected(true);
                }
                catch (PropertyVetoException propertyVetoException) {}
            }
        }
    }

    public void setUI(InternalFrameUI ui) {
        boolean old = this.isRootPaneCheckingEnabled();
        this.setRootPaneCheckingEnabled(false);
        super.setUI(ui);
        this.setRootPaneCheckingEnabled(old);
    }

    public void toBack() {
        this.moveToBack();
    }

    public void toFront() {
        this.moveToFront();
    }

    public void updateUI() {
        boolean old = this.isRootPaneCheckingEnabled();
        this.setRootPaneCheckingEnabled(false);
        this.setUI((InternalFrameUI)UIManager.getUI(this));
        this.setRootPaneCheckingEnabled(old);
    }

    void setWasIcon(boolean b, String ID2) {
        if (b && !this.wasIcon) {
            this.wasIcon = b;
            this.firePropertyChange(ID2, !b, b);
        }
    }

    boolean getWasIcon() {
        return this.wasIcon;
    }

    private void fireVetoableChange(String name, boolean oldValue, boolean newValue) throws PropertyVetoException {
        super.fireVetoableChange(name, oldValue, newValue);
    }

    protected class AccessibleJInternalFrame
    extends JComponent.AccessibleJComponent
    implements AccessibleValue {
        private static final long serialVersionUID = 5931936924175476797L;

        protected AccessibleJInternalFrame() {
            super(JInternalFrame.this);
        }

        public String getAccessibleName() {
            return JInternalFrame.this.getTitle();
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.INTERNAL_FRAME;
        }

        public AccessibleValue getAccessibleValue() {
            return this;
        }

        public Number getCurrentAccessibleValue() {
            return new Integer(JInternalFrame.this.getLayer());
        }

        public Number getMaximumAccessibleValue() {
            return new Integer(Integer.MAX_VALUE);
        }

        public Number getMinimumAccessibleValue() {
            return new Integer(Integer.MIN_VALUE);
        }

        public boolean setCurrentAccessibleValue(Number n) {
            if (n == null) {
                return false;
            }
            JInternalFrame.this.setLayer(n.intValue());
            return true;
        }
    }

    public static class JDesktopIcon
    extends JComponent
    implements Accessible {
        private static final long serialVersionUID = 4672973344731387687L;
        JInternalFrame frame;

        public JDesktopIcon(JInternalFrame f) {
            this.frame = f;
            this.updateUI();
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleJDesktopIcon();
            }
            return this.accessibleContext;
        }

        public JDesktopPane getDesktopPane() {
            JDesktopPane p = (JDesktopPane)SwingUtilities.getAncestorOfClass(JDesktopPane.class, this);
            return p;
        }

        public JInternalFrame getInternalFrame() {
            return this.frame;
        }

        public DesktopIconUI getUI() {
            return (DesktopIconUI)this.ui;
        }

        public String getUIClassID() {
            return "DesktopIconUI";
        }

        public void setInternalFrame(JInternalFrame f) {
            this.frame = f;
        }

        public void setUI(DesktopIconUI ui) {
            super.setUI(ui);
        }

        public void updateUI() {
            this.setUI((DesktopIconUI)UIManager.getUI(this));
        }

        protected class AccessibleJDesktopIcon
        extends JComponent.AccessibleJComponent
        implements AccessibleValue {
            private static final long serialVersionUID = 5035560458941637802L;

            protected AccessibleJDesktopIcon() {
                super(JDesktopIcon.this);
            }

            public AccessibleRole getAccessibleRole() {
                return AccessibleRole.DESKTOP_ICON;
            }

            public AccessibleValue getAccessibleValue() {
                return this;
            }

            public Number getCurrentAccessibleValue() {
                return new Integer(JDesktopIcon.this.frame.getLayer());
            }

            public Number getMaximumAccessibleValue() {
                return new Integer(Integer.MAX_VALUE);
            }

            public Number getMinimumAccessibleValue() {
                return new Integer(Integer.MIN_VALUE);
            }

            public boolean setCurrentAccessibleValue(Number n) {
                if (n == null) {
                    return false;
                }
                JDesktopIcon.this.frame.setLayer(n.intValue());
                return true;
            }
        }
    }
}

