/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import gnu.java.security.Engine;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.MacSpi;
import javax.crypto.ShortBufferException;

public class Mac
implements Cloneable {
    private static final String SERVICE = "Mac";
    private MacSpi macSpi;
    private Provider provider;
    private String algorithm;
    private boolean virgin;

    protected Mac(MacSpi macSpi, Provider provider, String algorithm) {
        this.macSpi = macSpi;
        this.provider = provider;
        this.algorithm = algorithm;
        this.virgin = true;
    }

    public static final Mac getInstance(String algorithm) throws NoSuchAlgorithmException {
        Provider[] p = Security.getProviders();
        NoSuchAlgorithmException lastException = null;
        int i = 0;
        while (i < p.length) {
            try {
                return Mac.getInstance(algorithm, p[i]);
            }
            catch (NoSuchAlgorithmException x) {
                lastException = x;
                ++i;
            }
        }
        if (lastException != null) {
            throw lastException;
        }
        throw new NoSuchAlgorithmException(algorithm);
    }

    public static final Mac getInstance(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (provider == null) {
            throw new IllegalArgumentException("provider MUST NOT be null");
        }
        Provider p = Security.getProvider(provider);
        if (p == null) {
            throw new NoSuchProviderException(provider);
        }
        return Mac.getInstance(algorithm, p);
    }

    public static final Mac getInstance(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        Throwable cause;
        StringBuilder sb = new StringBuilder("Mac algorithm [").append(algorithm).append("] from provider[").append(provider).append("] could not be created");
        try {
            Object spi = Engine.getInstance(SERVICE, algorithm, provider);
            return new Mac((MacSpi)spi, provider, algorithm);
        }
        catch (InvocationTargetException x) {
            cause = x.getCause();
            if (cause instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)cause;
            }
            if (cause == null) {
                cause = x;
            }
        }
        catch (ClassCastException x) {
            cause = x;
        }
        NoSuchAlgorithmException x = new NoSuchAlgorithmException(sb.toString());
        x.initCause(cause);
        throw x;
    }

    public final byte[] doFinal() throws IllegalStateException {
        if (this.virgin) {
            throw new IllegalStateException("not initialized");
        }
        byte[] digest = this.macSpi.engineDoFinal();
        this.reset();
        return digest;
    }

    public final byte[] doFinal(byte[] input) throws IllegalStateException {
        this.update(input);
        byte[] digest = this.macSpi.engineDoFinal();
        this.reset();
        return digest;
    }

    public final void doFinal(byte[] output, int outOffset) throws IllegalStateException, ShortBufferException {
        if (this.virgin) {
            throw new IllegalStateException("not initialized");
        }
        if (output.length - outOffset < this.getMacLength()) {
            throw new ShortBufferException();
        }
        byte[] mac = this.macSpi.engineDoFinal();
        System.arraycopy(mac, 0, output, outOffset, this.getMacLength());
        this.reset();
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final int getMacLength() {
        return this.macSpi.engineGetMacLength();
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final void init(Key key) throws InvalidKeyException {
        try {
            this.init(key, null);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new IllegalArgumentException(String.valueOf(this.algorithm) + " needs parameters");
        }
    }

    public final void init(Key key, AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException, InvalidKeyException {
        this.macSpi.engineInit(key, params);
        this.virgin = false;
    }

    public final void reset() {
        this.macSpi.engineReset();
    }

    public final void update(byte input) throws IllegalStateException {
        if (this.virgin) {
            throw new IllegalStateException("not initialized");
        }
        this.macSpi.engineUpdate(input);
    }

    public final void update(byte[] input) throws IllegalStateException {
        this.update(input, 0, input.length);
    }

    public final void update(byte[] input, int offset, int length) throws IllegalStateException {
        if (this.virgin) {
            throw new IllegalStateException("not initialized");
        }
        this.macSpi.engineUpdate(input, offset, length);
    }

    public final void update(ByteBuffer buffer) {
        if (this.virgin) {
            throw new IllegalStateException("not initialized");
        }
        this.macSpi.engineUpdate(buffer);
    }

    public final Object clone() throws CloneNotSupportedException {
        Mac result = new Mac((MacSpi)this.macSpi.clone(), this.provider, this.algorithm);
        result.virgin = this.virgin;
        return result;
    }
}

