/*
 * Decompiled with CFR 0.152.
 */
package java.awt.event;

import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.EventQueue;

public class InvocationEvent
extends AWTEvent
implements ActiveEvent {
    private static final long serialVersionUID = 436056344909459450L;
    public static final int INVOCATION_FIRST = 1200;
    public static final int INVOCATION_DEFAULT = 1200;
    public static final int INVOCATION_LAST = 1200;
    protected Runnable runnable;
    protected Object notifier;
    protected boolean catchExceptions;
    private Exception exception;
    private Throwable throwable;
    private final long when = EventQueue.getMostRecentEventTime();

    public InvocationEvent(Object source, Runnable runnable) {
        this(source, 1200, runnable, null, false);
    }

    public InvocationEvent(Object source, Runnable runnable, Object notifier, boolean catchExceptions) {
        this(source, 1200, runnable, notifier, catchExceptions);
    }

    protected InvocationEvent(Object source, int id, Runnable runnable, Object notifier, boolean catchExceptions) {
        super(source, id);
        this.runnable = runnable;
        this.notifier = notifier;
        this.catchExceptions = catchExceptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatch() {
        Object o;
        if (this.catchExceptions) {
            try {
                this.runnable.run();
            }
            catch (Throwable t) {
                this.throwable = t;
                if (t instanceof Exception) {
                    this.exception = (Exception)t;
                }
            }
        } else {
            this.runnable.run();
        }
        if ((o = this.notifier) != null) {
            Object object = o;
            synchronized (object) {
                o.notifyAll();
            }
        }
    }

    public Exception getException() {
        return this.exception;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public long getWhen() {
        return this.when;
    }

    public String paramString() {
        return String.valueOf(this.id == 1200 ? "INVOCATION_DEFAULT,runnable=" : "unknown type,runnable=") + this.runnable + ",notifier=" + this.notifier + ",catchExceptions=" + this.catchExceptions + ",when=" + this.when;
    }
}

