/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import java.awt.AWTException;
import java.awt.GraphicsDevice;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.peer.RobotPeer;

public class GdkRobotPeer
implements RobotPeer {
    static final ColorModel cm = new DirectColorModel(32, -16777216, 0xFF0000, 65280, 255);

    public GdkRobotPeer(GraphicsDevice screen) throws AWTException {
        if (!this.initXTest()) {
            throw new AWTException("XTest extension not supported");
        }
    }

    native boolean initXTest();

    public native void mouseMove(int var1, int var2);

    public native void mousePress(int var1);

    public native void mouseRelease(int var1);

    public native void mouseWheel(int var1);

    public native void keyPress(int var1);

    public native void keyRelease(int var1);

    native int[] nativeGetRGBPixels(int var1, int var2, int var3, int var4);

    public int getRGBPixel(int x, int y) {
        return cm.getRGB(this.nativeGetRGBPixels(x, y, 1, 1)[0]);
    }

    public int[] getRGBPixels(Rectangle r) {
        int[] gdk_pixels = this.nativeGetRGBPixels(r.x, r.y, r.width, r.height);
        int[] pixels = new int[r.width * r.height];
        int i = 0;
        while (i < r.width * r.height) {
            pixels[i] = cm.getRGB(gdk_pixels[i]);
            ++i;
        }
        return pixels;
    }

    public void dispose() {
    }
}

