/*
 * Decompiled with CFR 0.152.
 */
package gnu.CORBA.Poa;

import gnu.CORBA.CDR.BufferedCdrOutput;
import gnu.CORBA.CDR.BufferredCdrInput;
import gnu.CORBA.OrbFunctional;
import gnu.CORBA.Poa.AOM;
import gnu.CORBA.Poa.AccessiblePolicy;
import gnu.CORBA.Poa.ForwardedServant;
import gnu.CORBA.Poa.LocalDelegate;
import gnu.CORBA.Poa.ORB_1_4;
import gnu.CORBA.Poa.ServantDelegateImpl;
import gnu.CORBA.Poa.StandardPolicies;
import gnu.CORBA.Poa.gnuForwardRequest;
import gnu.CORBA.Poa.gnuIdAssignmentPolicy;
import gnu.CORBA.Poa.gnuIdUniquenessPolicy;
import gnu.CORBA.Poa.gnuImplicitActivationPolicy;
import gnu.CORBA.Poa.gnuLifespanPolicy;
import gnu.CORBA.Poa.gnuPOAManager;
import gnu.CORBA.Poa.gnuRequestProcessingPolicy;
import gnu.CORBA.Poa.gnuServantObject;
import gnu.CORBA.Poa.gnuServantRetentionPolicy;
import gnu.CORBA.Poa.gnuThreadPolicy;
import gnu.java.lang.CPStringBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.OBJ_ADAPTER;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.SetOverrideType;
import org.omg.CORBA.TRANSIENT;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.PortableInterceptor.ObjectReferenceFactory;
import org.omg.PortableInterceptor.ObjectReferenceTemplate;
import org.omg.PortableInterceptor.ObjectReferenceTemplateHelper;
import org.omg.PortableServer.AdapterActivator;
import org.omg.PortableServer.ForwardRequest;
import org.omg.PortableServer.IdAssignmentPolicy;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.IdUniquenessPolicy;
import org.omg.PortableServer.IdUniquenessPolicyValue;
import org.omg.PortableServer.ImplicitActivationPolicy;
import org.omg.PortableServer.ImplicitActivationPolicyValue;
import org.omg.PortableServer.LifespanPolicy;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAManager;
import org.omg.PortableServer.POAManagerPackage.State;
import org.omg.PortableServer.POAPackage.AdapterAlreadyExists;
import org.omg.PortableServer.POAPackage.AdapterNonExistent;
import org.omg.PortableServer.POAPackage.InvalidPolicy;
import org.omg.PortableServer.POAPackage.NoServant;
import org.omg.PortableServer.POAPackage.ObjectAlreadyActive;
import org.omg.PortableServer.POAPackage.ObjectNotActive;
import org.omg.PortableServer.POAPackage.ServantAlreadyActive;
import org.omg.PortableServer.POAPackage.ServantNotActive;
import org.omg.PortableServer.POAPackage.WrongAdapter;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.RequestProcessingPolicy;
import org.omg.PortableServer.RequestProcessingPolicyValue;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer.ServantActivator;
import org.omg.PortableServer.ServantLocator;
import org.omg.PortableServer.ServantManager;
import org.omg.PortableServer.ServantRetentionPolicy;
import org.omg.PortableServer.ServantRetentionPolicyValue;
import org.omg.PortableServer.ThreadPolicy;
import org.omg.PortableServer.ThreadPolicyValue;

public class gnuPOA
extends LocalObject
implements POA,
ObjectReferenceFactory {
    private static final long serialVersionUID = 1L;
    ObjectReferenceTemplate refTemplate;
    static final String[] ref_template_ids = new String[]{ObjectReferenceTemplateHelper.id()};
    public final AOM aom = new AOM();
    final ArrayList children = new ArrayList();
    final String name;
    final POA parent;
    static final int SIGNATURE = 1718773093;
    AdapterActivator m_activator;
    POAManager m_manager;
    ServantActivator servant_activator;
    ServantLocator servant_locator;
    Servant default_servant;
    private byte[] m_poa_id;
    private final HashSet m_policies;
    Policy[] s_policies;
    final ORB_1_4 m_orb;
    boolean m_inDestruction;
    public final boolean retain_servant;
    ObjectReferenceFactory m_object_factory = this;

    public gnuPOA(gnuPOA a_parent, String a_name, POAManager a_manager, Policy[] a_policies, ORB_1_4 an_orb) throws InvalidPolicy {
        Policy[] all_policies = StandardPolicies.withDefault(a_policies);
        this.name = a_name;
        this.parent = a_parent;
        this.m_orb = an_orb;
        this.m_manager = a_manager != null ? a_manager : new gnuPOAManager();
        if (this.m_manager instanceof gnuPOAManager) {
            gnuPOAManager g = (gnuPOAManager)this.m_manager;
            g.addPoa(this);
        }
        this.m_policies = new HashSet(all_policies.length);
        this.s_policies = new Policy[all_policies.length];
        int i = 0;
        while (i < this.s_policies.length) {
            this.s_policies[i] = all_policies[i].copy();
            this.m_policies.add(((AccessiblePolicy)this.s_policies[i]).getValue());
            ++i;
        }
        this.retain_servant = this.applies(ServantRetentionPolicyValue.RETAIN);
        this.validatePolicies(a_policies);
        this.refTemplate = new RefTemplate();
    }

    public void waitWhileRunning() {
        boolean runs;
        long time = 1L;
        long max = 500L;
        do {
            if (!(runs = this.m_orb.currents.has(this))) continue;
            try {
                Thread.sleep(time);
                if ((time *= 2L) <= max) continue;
                time = max;
            }
            catch (InterruptedException interruptedException) {}
        } while (runs);
    }

    protected void etherealizeAll() {
        if (this.servant_activator == null) {
            return;
        }
        ArrayList keys = new ArrayList();
        keys.addAll(this.aom.keySet());
        int i = 0;
        while (i < keys.size()) {
            byte[] key = (byte[])keys.get(i);
            AOM.Obj obj = this.aom.get(key);
            if (obj.poa == this) {
                this.aom.remove(key);
                if (!obj.isDeactiveted()) {
                    boolean last = this.aom.findServant(obj.servant) == null;
                    this.servant_activator.etherealize(obj.key, this, obj.servant, true, last);
                }
            }
            ++i;
        }
    }

    protected POA createPoaInstance(String child_name, POAManager a_manager, Policy[] policies, ORB_1_4 an_orb) throws InvalidPolicy {
        POAManager some_manager;
        POAManager pOAManager = some_manager = a_manager == null ? new gnuPOAManager() : a_manager;
        if (some_manager instanceof gnuPOAManager) {
            ((gnuPOAManager)some_manager).addPoa(this);
        }
        return new gnuPOA(this, child_name, some_manager, policies, an_orb);
    }

    public final boolean applies(java.lang.Object policy_value) {
        return this.m_policies.contains(policy_value);
    }

    public final void required(java.lang.Object policy_value) throws WrongPolicy {
        if (!this.applies(policy_value)) {
            throw new WrongPolicy(policy_value + " policy required.");
        }
    }

    public final void excluding(java.lang.Object policy_value) throws WrongPolicy {
        if (this.applies(policy_value)) {
            throw new WrongPolicy(policy_value + " policy applies.");
        }
    }

    public POA find_POA(String poa_name, boolean activate_it) throws AdapterNonExistent {
        POA child;
        int i = 0;
        while (i < this.children.size()) {
            child = (POA)this.children.get(i);
            if (child.the_name().equals(poa_name)) {
                return child;
            }
            ++i;
        }
        if (activate_it && this.m_activator != null) {
            boolean activated = this.m_activator.unknown_adapter(this, poa_name);
            if (!activated) {
                throw new AdapterNonExistent(String.valueOf(poa_name) + " activation failed.");
            }
            int i2 = 0;
            while (i2 < this.children.size()) {
                child = (POA)this.children.get(i2);
                if (child.the_name().equals(poa_name)) {
                    return child;
                }
                ++i2;
            }
            throw new AdapterNonExistent(String.valueOf(poa_name) + " not created. ");
        }
        throw new AdapterNonExistent(poa_name);
    }

    public byte[] activate_object(Servant a_servant) throws ServantAlreadyActive, WrongPolicy {
        this.checkDiscarding();
        this.required(ServantRetentionPolicyValue.RETAIN);
        this.required(IdAssignmentPolicyValue.SYSTEM_ID);
        AOM.Obj exists = this.aom.findServant(a_servant);
        if (exists != null) {
            if (exists.isDeactiveted()) {
                exists.setDeactivated(false);
                this.incarnate(exists, exists.key, a_servant, false);
                return exists.key;
            }
            if (this.applies(IdUniquenessPolicyValue.UNIQUE_ID)) {
                throw new ServantAlreadyActive();
            }
        }
        byte[] object_key = AOM.getFreeId();
        ServantDelegateImpl delegate = new ServantDelegateImpl(a_servant, this, object_key);
        this.create_and_connect(object_key, a_servant._all_interfaces(this, object_key)[0], delegate);
        return object_key;
    }

    public void activate_object_with_id(byte[] an_Object_Id, Servant a_servant) throws ServantAlreadyActive, ObjectAlreadyActive, WrongPolicy {
        this.activate_object_with_id(an_Object_Id, a_servant, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void activate_object_with_id(byte[] an_Object_Id, Servant a_servant, boolean use_forwarding) throws ServantAlreadyActive, ObjectAlreadyActive, WrongPolicy {
        AOM.Obj sx;
        this.checkDiscarding();
        this.required(ServantRetentionPolicyValue.RETAIN);
        if (this.applies(IdUniquenessPolicyValue.UNIQUE_ID) && (sx = this.aom.findServant(a_servant, false)) != null) {
            throw new ServantAlreadyActive();
        }
        AOM.Obj exists = this.aom.get(an_Object_Id);
        if (exists != null) {
            if (exists.servant == null) {
                this.locateServant(an_Object_Id, a_servant, exists, use_forwarding);
                exists.setDeactivated(false);
                return;
            } else {
                if (!exists.isDeactiveted()) throw new ObjectAlreadyActive();
                exists.setDeactivated(false);
                this.incarnate(exists, an_Object_Id, a_servant, use_forwarding);
            }
            return;
        } else {
            ServantDelegateImpl delegate = new ServantDelegateImpl(a_servant, this, an_Object_Id);
            this.create_and_connect(an_Object_Id, a_servant._all_interfaces(this, an_Object_Id)[0], delegate);
        }
    }

    private void locateServant(byte[] an_Object_Id, Servant a_servant, AOM.Obj exists, boolean use_forwarding) throws InternalError {
        gnuServantObject object = exists.object;
        if (this.servant_activator != null) {
            exists.setServant(this.incarnate(exists, an_Object_Id, a_servant, use_forwarding));
        } else if (this.default_servant != null) {
            exists.setServant(this.default_servant);
        }
        if (exists.servant == null) {
            exists.setServant(a_servant);
        }
        if (exists.servant == null) {
            throw new OBJ_ADAPTER("no servant", 4, CompletionStatus.COMPLETED_NO);
        }
        ServantDelegateImpl delegate = new ServantDelegateImpl(exists.servant, this, an_Object_Id);
        exists.servant._set_delegate(delegate);
        object.setServant(exists.servant);
        this.connect_to_orb(an_Object_Id, delegate.object);
    }

    public void deactivate_object(byte[] the_Object_Id) throws ObjectNotActive, WrongPolicy {
        this.required(ServantRetentionPolicyValue.RETAIN);
        AOM.Obj exists = this.aom.get(the_Object_Id);
        if (exists == null || exists.isDeactiveted()) {
            throw new ObjectNotActive();
        }
        exists.setDeactivated(true);
        this.aom.remove(the_Object_Id);
        AOM.Obj other = this.aom.findServant(exists.servant, false);
        boolean remaining = other != null;
        this.aom.put(exists);
        if (this.servant_activator != null) {
            this.servant_activator.etherealize(the_Object_Id, this, exists.servant, false, remaining);
        }
    }

    public Object create_reference(String a_repository_id) throws WrongPolicy {
        this.required(IdAssignmentPolicyValue.SYSTEM_ID);
        return this.create_reference_with_id(AOM.getFreeId(), a_repository_id);
    }

    public Object create_reference_with_id(byte[] an_object_id, String a_repository_id) {
        Servant servant;
        String[] ids = a_repository_id == null ? (String[])null : new String[]{a_repository_id};
        AOM.Obj e = this.aom.get(an_object_id);
        if (e == null) {
            servant = null;
        } else {
            servant = e.servant;
            e.setDeactivated(false);
        }
        gnuServantObject object = new gnuServantObject(ids, an_object_id, this, this.m_orb);
        object._set_delegate(new LocalDelegate(object, this, an_object_id));
        this.aom.add(object.Id, object, servant, this);
        this.connect_to_orb(an_object_id, object);
        return object;
    }

    public POA create_POA(String child_name, POAManager manager, Policy[] policies) throws AdapterAlreadyExists, InvalidPolicy {
        int i = 0;
        while (i < this.children.size()) {
            POA child = (POA)this.children.get(i);
            if (child.the_name().equals(child_name)) {
                throw new AdapterAlreadyExists(String.valueOf(this.name) + "/" + child_name);
            }
            ++i;
        }
        POA poa = this.createPoaInstance(child_name, manager, policies, this.m_orb);
        this.children.add(poa);
        return poa;
    }

    public Servant get_servant() throws NoServant, WrongPolicy {
        this.required(RequestProcessingPolicyValue.USE_DEFAULT_SERVANT);
        if (this.default_servant == null) {
            throw new NoServant();
        }
        return this.default_servant;
    }

    public void set_servant(Servant a_servant) throws WrongPolicy {
        this.required(RequestProcessingPolicyValue.USE_DEFAULT_SERVANT);
        this.default_servant = a_servant;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void set_servant_manager(ServantManager a_manager) throws WrongPolicy {
        this.required(RequestProcessingPolicyValue.USE_SERVANT_MANAGER);
        if (this.servant_activator != null || this.servant_locator != null) {
            throw new BAD_INV_ORDER("Setting manager twice for " + this.name, 6, CompletionStatus.COMPLETED_NO);
        }
        if (this.applies(ServantRetentionPolicyValue.RETAIN)) {
            if (!(a_manager instanceof ServantActivator)) throw new OBJ_ADAPTER("RETAIN requires ServantActivator", 4, CompletionStatus.COMPLETED_NO);
            this.servant_activator = (ServantActivator)a_manager;
            return;
        } else {
            if (!this.applies(ServantRetentionPolicyValue.NON_RETAIN)) throw new WrongPolicy("No servant retention policy is specified.");
            if (!(a_manager instanceof ServantLocator)) throw new OBJ_ADAPTER("NON_RETAIN requires ServantLocator", 4, CompletionStatus.COMPLETED_NO);
            this.servant_locator = (ServantLocator)a_manager;
        }
    }

    public ServantManager get_servant_manager() throws WrongPolicy {
        this.required(RequestProcessingPolicyValue.USE_SERVANT_MANAGER);
        if (this.servant_activator != null) {
            return this.servant_activator;
        }
        return this.servant_locator;
    }

    public byte[] id() {
        if (this.m_poa_id != null) {
            return this.m_poa_id;
        }
        BufferedCdrOutput buffer = new BufferedCdrOutput();
        POA p = this;
        while (p != null) {
            buffer.write_string(p.the_name());
            p = p.the_parent();
        }
        this.m_poa_id = buffer.buffer.toByteArray();
        return this.m_poa_id;
    }

    public Object id_to_reference(byte[] the_Object_Id) throws ObjectNotActive, WrongPolicy {
        this.required(ServantRetentionPolicyValue.RETAIN);
        AOM.Obj ref = this.aom.get(the_Object_Id);
        if (ref == null) {
            throw new ObjectNotActive();
        }
        return ref.object;
    }

    public Servant id_to_servant(byte[] the_Object_Id) throws ObjectNotActive, WrongPolicy {
        if (this.applies(ServantRetentionPolicyValue.RETAIN)) {
            AOM.Obj ref = this.aom.get(the_Object_Id);
            if (ref == null || ref.isDeactiveted()) {
                if (this.default_servant != null) {
                    return this.default_servant;
                }
                throw new ObjectNotActive();
            }
            if (ref.servant != null) {
                return ref.servant;
            }
            if (this.default_servant != null) {
                return this.default_servant;
            }
            throw new ObjectNotActive();
        }
        if (this.default_servant != null) {
            return this.default_servant;
        }
        throw new WrongPolicy("Either RETAIN or USE_DEFAULT_SERVANT required.");
    }

    public byte[] reference_to_id(Object the_Object) throws WrongAdapter, WrongPolicy {
        AOM.Obj ref = this.aom.findObject(the_Object);
        if (ref == null) {
            throw new WrongAdapter();
        }
        return ref.key;
    }

    public Servant reference_to_servant(Object the_Object) throws ObjectNotActive, WrongPolicy, WrongAdapter {
        if (this.applies(ServantRetentionPolicyValue.RETAIN)) {
            AOM.Obj ref = this.aom.findObject(the_Object);
            if (ref == null) {
                String object;
                if (the_Object == null) {
                    object = "null passed";
                } else if (the_Object instanceof gnuServantObject) {
                    gnuServantObject gs = (gnuServantObject)the_Object;
                    object = "Wrong owner POA " + gs.poa.the_name();
                } else {
                    object = "Unknown " + the_Object.getClass().getName();
                }
                throw new WrongAdapter(String.valueOf(object) + " for '" + this.the_name() + "'");
            }
            if (ref.isDeactiveted() || ref.servant == null) {
                if (this.default_servant != null) {
                    return this.default_servant;
                }
                throw new ObjectNotActive();
            }
            return ref.servant;
        }
        if (this.default_servant != null) {
            return this.default_servant;
        }
        throw new WrongPolicy("Either RETAIN or USE_DEFAULT_SERVANT required.");
    }

    public byte[] servant_to_id(Servant the_Servant) throws ServantNotActive, WrongPolicy {
        if (this.applies(RequestProcessingPolicyValue.USE_DEFAULT_SERVANT) || this.applies(ServantRetentionPolicyValue.RETAIN) && (this.applies(IdUniquenessPolicyValue.UNIQUE_ID) || this.applies(ImplicitActivationPolicyValue.IMPLICIT_ACTIVATION))) {
            AOM.Obj ref = null;
            if (!this.applies(IdUniquenessPolicyValue.MULTIPLE_ID)) {
                ref = this.aom.findServant(the_Servant);
            }
            if (ref == null && this.applies(ImplicitActivationPolicyValue.IMPLICIT_ACTIVATION)) {
                try {
                    return this.activate_object(the_Servant);
                }
                catch (ServantAlreadyActive servantAlreadyActive) {
                    throw new InternalError();
                }
            }
            if (ref == null) {
                throw new ServantNotActive();
            }
            return ref.key;
        }
        throw new WrongPolicy("(RETAIN and UNIQUE ID) or USE_DEFAULT_SERVANT required.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object servant_to_reference(Servant the_Servant) throws ServantNotActive, WrongPolicy {
        this.required(ServantRetentionPolicyValue.RETAIN);
        AOM.Obj exists = null;
        if (!this.applies(IdUniquenessPolicyValue.MULTIPLE_ID)) {
            exists = this.aom.findServant(the_Servant);
        }
        if (exists != null) {
            if (!exists.isDeactiveted()) return exists.object;
            if (!this.applies(ImplicitActivationPolicyValue.IMPLICIT_ACTIVATION)) throw new ServantNotActive();
            this.checkDiscarding();
            exists.setDeactivated(false);
            this.incarnate(exists, exists.key, the_Servant, false);
        }
        if (exists != null || !this.applies(ImplicitActivationPolicyValue.IMPLICIT_ACTIVATION)) throw new ServantNotActive();
        this.checkDiscarding();
        byte[] object_key = AOM.getFreeId();
        ServantDelegateImpl delegate = new ServantDelegateImpl(the_Servant, this, object_key);
        this.create_and_connect(object_key, the_Servant._all_interfaces(this, object_key)[0], delegate);
        return delegate.object;
    }

    private Servant incarnate(AOM.Obj x, byte[] object_key, Servant a_servant, boolean use_forwarding) {
        if (this.servant_activator != null) {
            Servant servant;
            try {
                servant = this.servant_activator.incarnate(object_key, this);
            }
            catch (ForwardRequest ex) {
                if (use_forwarding) {
                    throw new gnuForwardRequest(ex.forward_reference);
                }
                servant = ForwardedServant.create((ObjectImpl)ex.forward_reference);
            }
            if (servant != null && x != null) {
                x.setServant(servant);
            }
            if (servant == null && x != null) {
                servant = x.servant;
            }
            return servant;
        }
        if (a_servant != null) {
            x.setServant(a_servant);
            return a_servant;
        }
        if (x.servant != null) {
            return x.servant;
        }
        if (this.default_servant != null) {
            x.setServant(this.default_servant);
            return x.servant;
        }
        throw new BAD_INV_ORDER("No servant given and the servant activator not set");
    }

    public POAManager the_POAManager() {
        return this.m_manager;
    }

    public AdapterActivator the_activator() {
        return this.m_activator;
    }

    public void the_activator(AdapterActivator an_activator) {
        this.m_activator = an_activator;
    }

    public POA[] the_children() {
        POA[] poas = new POA[this.children.size()];
        int i = 0;
        while (i < poas.length) {
            poas[i] = (POA)this.children.get(i);
            ++i;
        }
        return poas;
    }

    public String the_name() {
        return this.name;
    }

    public POA the_parent() {
        return this.parent;
    }

    public IdAssignmentPolicy create_id_assignment_policy(IdAssignmentPolicyValue a_value) {
        return new gnuIdAssignmentPolicy(a_value);
    }

    public IdUniquenessPolicy create_id_uniqueness_policy(IdUniquenessPolicyValue a_value) {
        return new gnuIdUniquenessPolicy(a_value);
    }

    public ImplicitActivationPolicy create_implicit_activation_policy(ImplicitActivationPolicyValue a_value) {
        return new gnuImplicitActivationPolicy(a_value);
    }

    public LifespanPolicy create_lifespan_policy(LifespanPolicyValue a_value) {
        return new gnuLifespanPolicy(a_value);
    }

    public RequestProcessingPolicy create_request_processing_policy(RequestProcessingPolicyValue a_value) {
        return new gnuRequestProcessingPolicy(a_value);
    }

    public ServantRetentionPolicy create_servant_retention_policy(ServantRetentionPolicyValue a_value) {
        return new gnuServantRetentionPolicy(a_value);
    }

    public ThreadPolicy create_thread_policy(ThreadPolicyValue a_value) {
        return new gnuThreadPolicy(a_value);
    }

    public void destroy(boolean etherealize_objects, boolean wait_for_completion) {
        if (this.m_orb.iIor != null) {
            this.m_orb.iIor.adapter_state_changed(new ObjectReferenceTemplate[]{this.getReferenceTemplate()}, (short)4);
        }
        if (wait_for_completion) {
            this.waitWhileRunning();
        }
        if (this.m_manager instanceof gnuPOAManager) {
            ((gnuPOAManager)this.m_manager).poaDestroyed(this);
        }
        gnuPOAManager g = new gnuPOAManager();
        g.state = State.INACTIVE;
        this.m_manager = g;
        if (this.parent instanceof gnuPOA) {
            ((gnuPOA)this.parent).children.remove(this);
        }
        this.unregisterFromManager();
        ArrayList keys = new ArrayList();
        keys.addAll(this.aom.keySet());
        int i = 0;
        while (i < keys.size()) {
            byte[] key = (byte[])keys.get(i);
            AOM.Obj obj = this.aom.get(key);
            if (obj.poa == this) {
                this.m_orb.disconnect(obj.object);
            }
            ++i;
        }
        this.m_orb.identityDestroyed(this);
        if (etherealize_objects && this.servant_activator != null && !this.m_inDestruction) {
            this.etherealizeAll();
        }
        this.m_inDestruction = true;
        POA[] ch = this.the_children();
        int i2 = 0;
        while (i2 < ch.length) {
            ch[i2].destroy(etherealize_objects, wait_for_completion);
            ++i2;
        }
    }

    protected void finalize() throws Throwable {
        if (!this.m_inDestruction) {
            this.destroy(false, false);
        }
    }

    private void unregisterFromManager() {
        if (this.m_manager instanceof gnuPOAManager) {
            gnuPOAManager p = (gnuPOAManager)this.m_manager;
            p.removePOA(this);
        }
    }

    public Policy _get_policy(int a_policy_type) throws BAD_PARAM {
        int i = 0;
        while (i < this.s_policies.length) {
            if (this.s_policies[i].policy_type() == a_policy_type) {
                return this.s_policies[i].copy();
            }
            ++i;
        }
        throw new BAD_PARAM("No policy type " + a_policy_type);
    }

    public Policy[] getPolicyArray() {
        Policy[] r = new Policy[this.s_policies.length];
        int i = 0;
        while (i < this.s_policies.length) {
            r[i] = this.s_policies[i].copy();
            ++i;
        }
        return r;
    }

    public Object _set_policy_override(Policy[] policies, SetOverrideType how) {
        throw new NO_IMPLEMENT("Use createPOA instead.");
    }

    public ORB orb() {
        return this.m_orb;
    }

    private void create_and_connect(byte[] object_key, String repository_id, ServantDelegateImpl delegate) {
        this.aom.add(delegate);
        this.connect_to_orb(object_key, this.getReferenceFactory().make_object(repository_id, object_key));
        if (this.servant_activator != null) {
            this.incarnate(null, object_key, delegate.servant, false);
        }
    }

    void checkDiscarding() throws TRANSIENT {
        if (this.m_manager.get_state() == State.DISCARDING) {
            throw new TRANSIENT("Discarding mode", 1, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    protected void connect_to_orb(byte[] an_Object_Id, Object object) {
        if (this.applies(ThreadPolicyValue.SINGLE_THREAD_MODEL)) {
            this.m_orb.connect_1_thread(object, this.toIORKey(an_Object_Id), this);
        } else {
            this.m_orb.connect(object, this.toIORKey(an_Object_Id));
        }
    }

    public String toString() {
        CPStringBuilder b = new CPStringBuilder(this.name);
        if (this.children.size() != 0) {
            b.append(" (");
            int i = 0;
            while (i < this.children.size()) {
                b.append(this.children.get(i));
                if (i < this.children.size() - 2) {
                    b.append(", ");
                }
                ++i;
            }
            b.append(")");
        }
        return b.toString();
    }

    protected boolean validatePolicies(Policy[] a) throws InvalidPolicy {
        if (this.applies(ServantRetentionPolicyValue.NON_RETAIN) && !this.applies(RequestProcessingPolicyValue.USE_DEFAULT_SERVANT) && !this.applies(RequestProcessingPolicyValue.USE_SERVANT_MANAGER)) {
            int p = 0;
            int i = 0;
            while (i < a.length) {
                if (a[i].policy_type() == 21) {
                    p = i;
                }
                i = (short)(i + 1);
            }
            throw new InvalidPolicy("NON_RETAIN requires either USE_DEFAULT_SERVANT or USE_SERVANT_MANAGER", (short)p);
        }
        return true;
    }

    public AOM.Obj findObject(Object object) {
        AOM.Obj h = this.aom.findObject(object);
        if (h != null) {
            return h;
        }
        int i = 0;
        while (i < this.children.size()) {
            h = ((gnuPOA)this.children.get(i)).findObject(object);
            if (h != null) {
                return h;
            }
            ++i;
        }
        return h;
    }

    public AOM.Obj findKey(byte[] object_id, byte[] poa_id) {
        AOM.Obj h = null;
        if (Arrays.equals(poa_id, this.id())) {
            h = this.aom.get(object_id);
        }
        if (h != null) {
            return h;
        }
        int i = 0;
        while (i < this.children.size()) {
            h = ((gnuPOA)this.children.get(i)).findKey(object_id, poa_id);
            if (h != null) {
                return h;
            }
            ++i;
        }
        return h;
    }

    public AOM.Obj findIorKey(byte[] ior_key) {
        BufferredCdrInput in = new BufferredCdrInput(ior_key);
        int signature = in.read_long();
        if (signature != 1718773093) {
            return null;
        }
        byte[] id = in.read_sequence();
        byte[] poa = in.read_sequence();
        return this.findKey(id, poa);
    }

    public byte[] toIORKey(byte[] object_id) {
        BufferedCdrOutput buffer = new BufferedCdrOutput();
        buffer.write_long(1718773093);
        buffer.write_sequence(object_id);
        buffer.write_sequence(this.id());
        return buffer.buffer.toByteArray();
    }

    public byte[] idFormIor(byte[] ior_key) {
        BufferredCdrInput in = new BufferredCdrInput(ior_key);
        int signature = in.read_long();
        if (signature != 1718773093) {
            return null;
        }
        byte[] object_id = in.read_sequence();
        byte[] poa_id = in.read_sequence();
        if (Arrays.equals(poa_id, this.id())) {
            return object_id;
        }
        return null;
    }

    public AOM.Obj findServant(Servant servant) {
        AOM.Obj h = this.aom.findServant(servant);
        if (h != null) {
            return h;
        }
        int i = 0;
        while (i < this.children.size()) {
            h = ((gnuPOA)this.children.get(i)).findServant(servant);
            if (h != null) {
                return h;
            }
            ++i;
        }
        return h;
    }

    public ObjectReferenceTemplate getReferenceTemplate() {
        if (this.refTemplate == null) {
            this.refTemplate = new RefTemplate();
        }
        return this.refTemplate;
    }

    public ObjectReferenceFactory getReferenceFactory() {
        return this.m_object_factory;
    }

    public void setReferenceFactory(ObjectReferenceFactory factory) {
        this.m_object_factory = factory;
    }

    public Object make_object(String a_repository_id, byte[] an_object_id) {
        AOM.Obj existing = this.aom.get(an_object_id);
        if (existing != null && existing.object != null) {
            return existing.object;
        }
        return new gnuServantObject(new String[]{a_repository_id}, an_object_id, this, this.m_orb);
    }

    public String[] _truncatable_ids() {
        return ref_template_ids;
    }

    class RefTemplate
    implements ObjectReferenceTemplate {
        private static final long serialVersionUID = 1L;
        final String[] m_adapter_name;

        RefTemplate() {
            ArrayList<String> names = new ArrayList<String>();
            names.add(gnuPOA.this.the_name());
            POA poa = gnuPOA.this.the_parent();
            while (poa != null) {
                names.add(poa.the_name());
                poa = poa.the_parent();
            }
            this.m_adapter_name = new String[names.size()];
            int i = 0;
            while (i < this.m_adapter_name.length) {
                this.m_adapter_name[i] = (String)names.get(this.m_adapter_name.length - i - 1);
                ++i;
            }
        }

        public String[] adapter_name() {
            return (String[])this.m_adapter_name.clone();
        }

        public String orb_id() {
            return gnuPOA.this.m_orb.orb_id;
        }

        public String server_id() {
            return OrbFunctional.server_id;
        }

        public Object make_object(String repositoryId, byte[] objectId) {
            return gnuPOA.this.create_reference_with_id(objectId, repositoryId);
        }

        public String[] _truncatable_ids() {
            return ref_template_ids;
        }
    }
}

