/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.keytool;

import gnu.classpath.Configuration;
import gnu.classpath.tools.common.ClasspathToolParser;
import gnu.classpath.tools.getopt.Option;
import gnu.classpath.tools.getopt.OptionException;
import gnu.classpath.tools.getopt.OptionGroup;
import gnu.classpath.tools.getopt.Parser;
import gnu.classpath.tools.keytool.Command;
import gnu.classpath.tools.keytool.Messages;
import java.io.PrintWriter;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.logging.Logger;

class PrintCertCmd
extends Command {
    private static final Logger log = Logger.getLogger(PrintCertCmd.class.getName());
    protected String _certFileName;

    PrintCertCmd() {
    }

    public void setFile(String pathName) {
        this._certFileName = pathName;
    }

    void setup() throws Exception {
        this.setInputStreamParam(this._certFileName);
        if (Configuration.DEBUG) {
            log.fine("-printcert handler will use the following options:");
            log.fine("  -file=" + this._certFileName);
            log.fine("  -v=" + this.verbose);
        }
    }

    void start() throws CertificateException {
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "start");
        }
        CertificateFactory x509Factory = CertificateFactory.getInstance("X.509");
        Certificate certificate = x509Factory.generateCertificate(this.inStream);
        PrintWriter writer = new PrintWriter(System.out, true);
        writer.println();
        this.printVerbose(certificate, writer);
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "start");
        }
    }

    Parser getParser() {
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "getParser");
        }
        ClasspathToolParser result = new ClasspathToolParser("printcert", true);
        result.setHeader(Messages.getString("PrintCertCmd.5"));
        result.setFooter(Messages.getString("PrintCertCmd.6"));
        OptionGroup options = new OptionGroup(Messages.getString("PrintCertCmd.7"));
        options.add(new Option("file", Messages.getString("PrintCertCmd.8"), Messages.getString("PrintCertCmd.9")){

            public void parsed(String argument) throws OptionException {
                PrintCertCmd.this._certFileName = argument;
            }
        });
        options.add(new Option("v", Messages.getString("PrintCertCmd.10")){

            public void parsed(String argument) throws OptionException {
                PrintCertCmd.this.verbose = true;
            }
        });
        result.add(options);
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "getParser", result);
        }
        return result;
    }
}

