# Copyright 2017 Google Inc. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# AUTOMATICALLY GENERATED; DO NOT EDIT.
# generated with: gcloud meta list-gcloud --format=json | python -c "import json; import sys; data = json.load(sys.stdin); print 'gcloud_tree =', data" >> gcloud_tree.py

gcloud_tree = {u'capsule': u'Manage Google Cloud Platform resources and developer workflow.',
 u'commands': {u'alpha': {u'capsule': u'*(ALPHA)* Alpha versions of gcloud commands.',
                          u'commands': {u'billing': {u'capsule': u'*(ALPHA)* Manage billing accounts and associate them with projects.',
                                                     u'commands': {u'accounts': {u'capsule': u'*(ALPHA)* List or describe billing accounts.',
                                                                                 u'commands': {u'describe': {u'capsule': u'*(ALPHA)* Show metadata for a billing account.',
                                                                                                             u'commands': {},
                                                                                                             u'flags': {},
                                                                                                             u'group': False,
                                                                                                             u'groups': {},
                                                                                                             u'hidden': False,
                                                                                                             u'name': u'describe',
                                                                                                             u'path': [u'gcloud',
                                                                                                                       u'alpha',
                                                                                                                       u'billing',
                                                                                                                       u'accounts',
                                                                                                                       u'describe'],
                                                                                                             u'positionals': [{u'completer': u'',
                                                                                                                               u'default': None,
                                                                                                                               u'description': u'Specify a billing account id. Billing account ids look like: 0X0X0X-0X0X0X-0X0X0X, and can be listed with, gcloud alpha billing accounts list.',
                                                                                                                               u'name': u'id',
                                                                                                                               u'nargs': u'0',
                                                                                                                               u'required': False,
                                                                                                                               u'value': u'ACCOUNT_ID'}],
                                                                                                             u'release': u'ALPHA',
                                                                                                             u'sections': {u'DESCRIPTION': u"This command shows info for a billing account, given it's ID.\n\nThis call can fail for the following reasons:\n* The account specified does not exist.\n* The active user does not have permission to access the given\naccount.\n",
                                                                                                                           u'EXAMPLES': u'*describe* 0X0X0X-0X0X0X-0X0X0X will print the info for billing\naccount 0X0X0X-0X0X0X-0X0X0X.\n'}},
                                                                                               u'list': {u'capsule': u'*(ALPHA)* List all active billing accounts.',
                                                                                                         u'commands': {},
                                                                                                         u'flags': {u'--filter': {u'attr': {},
                                                                                                                                  u'category': u'LIST COMMAND',
                                                                                                                                  u'choices': [],
                                                                                                                                  u'completer': u'',
                                                                                                                                  u'default': None,
                                                                                                                                  u'description': u'Apply a Boolean filter _EXPRESSION_ to each resource item to be listed.\nIf the expression evaluates True then that item is listed. For more\ndetails and examples of filter expressions run $ gcloud topic filters. This\nflag interacts with other flags that are applied in this order: *--flatten*,\n*--sort-by*, *--filter*, *--limit*.',
                                                                                                                                  u'group': u'',
                                                                                                                                  u'hidden': False,
                                                                                                                                  u'name': u'--filter',
                                                                                                                                  u'nargs': u'0',
                                                                                                                                  u'required': False,
                                                                                                                                  u'type': u'string',
                                                                                                                                  u'value': u'EXPRESSION'},
                                                                                                                    u'--limit': {u'attr': {},
                                                                                                                                 u'category': u'LIST COMMAND',
                                                                                                                                 u'choices': [],
                                                                                                                                 u'completer': u'',
                                                                                                                                 u'default': None,
                                                                                                                                 u'description': u'The maximum number of resources to list. The default is *unlimited*.\nThis flag interacts with other flags that are applied in this order:\n*--flatten*, *--sort-by*, *--filter*, *--limit*.',
                                                                                                                                 u'group': u'',
                                                                                                                                 u'hidden': False,
                                                                                                                                 u'name': u'--limit',
                                                                                                                                 u'nargs': u'0',
                                                                                                                                 u'required': False,
                                                                                                                                 u'type': u'string',
                                                                                                                                 u'value': u'LIMIT'},
                                                                                                                    u'--no-uri': {u'attr': {},
                                                                                                                                  u'category': u'LIST COMMAND',
                                                                                                                                  u'choices': [],
                                                                                                                                  u'completer': u'',
                                                                                                                                  u'default': True,
                                                                                                                                  u'description': u'',
                                                                                                                                  u'group': u'',
                                                                                                                                  u'hidden': True,
                                                                                                                                  u'name': u'--no-uri',
                                                                                                                                  u'nargs': u'0',
                                                                                                                                  u'required': False,
                                                                                                                                  u'type': u'bool',
                                                                                                                                  u'value': u'NO_URI'},
                                                                                                                    u'--page-size': {u'attr': {},
                                                                                                                                     u'category': u'LIST COMMAND',
                                                                                                                                     u'choices': [],
                                                                                                                                     u'completer': u'',
                                                                                                                                     u'default': None,
                                                                                                                                     u'description': u'Some services group resource list output into pages. This flag specifies\nthe maximum number of resources per page. The default is determined by the\nservice if it supports paging, otherwise it is *unlimited* (no paging).\nPaging may be applied before or after *--filter* and *--limit* depending\non the service.',
                                                                                                                                     u'group': u'',
                                                                                                                                     u'hidden': False,
                                                                                                                                     u'name': u'--page-size',
                                                                                                                                     u'nargs': u'0',
                                                                                                                                     u'required': False,
                                                                                                                                     u'type': u'string',
                                                                                                                                     u'value': u'PAGE_SIZE'},
                                                                                                                    u'--sort-by': {u'attr': {},
                                                                                                                                   u'category': u'LIST COMMAND',
                                                                                                                                   u'choices': [],
                                                                                                                                   u'completer': u'',
                                                                                                                                   u'default': None,
                                                                                                                                   u'description': u"A comma-separated list of resource field key names to sort by. The\ndefault order is ascending. Prefix a field with ``~'' for descending\norder on that field. This flag interacts with other flags that are applied\nin this order: *--flatten*, *--sort-by*, *--filter*, *--limit*.",
                                                                                                                                   u'group': u'',
                                                                                                                                   u'hidden': False,
                                                                                                                                   u'name': u'--sort-by',
                                                                                                                                   u'nargs': u'0',
                                                                                                                                   u'required': False,
                                                                                                                                   u'type': u'list',
                                                                                                                                   u'value': u'FIELD'},
                                                                                                                    u'--uri': {u'attr': {},
                                                                                                                               u'category': u'LIST COMMAND',
                                                                                                                               u'choices': [],
                                                                                                                               u'completer': u'',
                                                                                                                               u'default': False,
                                                                                                                               u'description': u'Print a list of resource URIs instead of the default output.',
                                                                                                                               u'group': u'',
                                                                                                                               u'hidden': False,
                                                                                                                               u'name': u'--uri',
                                                                                                                               u'nargs': u'0',
                                                                                                                               u'required': False,
                                                                                                                               u'type': u'bool',
                                                                                                                               u'value': u'URI'}},
                                                                                                         u'group': False,
                                                                                                         u'groups': {},
                                                                                                         u'hidden': False,
                                                                                                         u'name': u'list',
                                                                                                         u'path': [u'gcloud',
                                                                                                                   u'alpha',
                                                                                                                   u'billing',
                                                                                                                   u'accounts',
                                                                                                                   u'list'],
                                                                                                         u'positionals': [],
                                                                                                         u'release': u'ALPHA',
                                                                                                         u'sections': {u'DESCRIPTION': u'*(ALPHA)* *list* lists all billing accounts owned by the currently\nauthenticated user.'}},
                                                                                               u'projects': {u'capsule': u'*(ALPHA)* Manage the billing account configuration of your projects.',
                                                                                                             u'commands': {u'describe': {u'capsule': u'*(ALPHA)* Show detailed billing information for a project.',
                                                                                                                                         u'commands': {},
                                                                                                                                         u'flags': {},
                                                                                                                                         u'group': False,
                                                                                                                                         u'groups': {},
                                                                                                                                         u'hidden': False,
                                                                                                                                         u'name': u'describe',
                                                                                                                                         u'path': [u'gcloud',
                                                                                                                                                   u'alpha',
                                                                                                                                                   u'billing',
                                                                                                                                                   u'accounts',
                                                                                                                                                   u'projects',
                                                                                                                                                   u'describe'],
                                                                                                                                         u'positionals': [{u'completer': u'',
                                                                                                                                                           u'default': None,
                                                                                                                                                           u'description': u'Specify a project id.',
                                                                                                                                                           u'name': u'project-id',
                                                                                                                                                           u'nargs': u'0',
                                                                                                                                                           u'required': False,
                                                                                                                                                           u'value': u'PROJECT_ID'}],
                                                                                                                                         u'release': u'ALPHA',
                                                                                                                                         u'sections': {u'DESCRIPTION': u"\nThis command shows billing info for a project, given it's ID.\n\nThis call can fail for the following reasons:\n* The project specified does not exist.\n* The active user does not have permission to access the given\nproject.\n",
                                                                                                                                                       u'EXAMPLES': u'\n*describe* 0X0X0X-0X0X0X-0X0X0X will print the info for\nbilling account 0X0X0X-0X0X0X-0X0X0X.\n'}},
                                                                                                                           u'link': {u'capsule': u'*(ALPHA)* Link a project with a billing account.',
                                                                                                                                     u'commands': {},
                                                                                                                                     u'flags': {u'--account-id': {u'attr': {},
                                                                                                                                                                  u'category': u'',
                                                                                                                                                                  u'choices': [],
                                                                                                                                                                  u'completer': u'',
                                                                                                                                                                  u'default': None,
                                                                                                                                                                  u'description': u'Specify a billing account id. Billing account ids look like: 0X0X0X-0X0X0X-0X0X0X, and can be listed with, gcloud alpha billing accounts list.',
                                                                                                                                                                  u'group': u'',
                                                                                                                                                                  u'hidden': False,
                                                                                                                                                                  u'name': u'--account-id',
                                                                                                                                                                  u'nargs': u'0',
                                                                                                                                                                  u'required': True,
                                                                                                                                                                  u'type': u'string',
                                                                                                                                                                  u'value': u'ACCOUNT_ID'}},
                                                                                                                                     u'group': False,
                                                                                                                                     u'groups': {},
                                                                                                                                     u'hidden': False,
                                                                                                                                     u'name': u'link',
                                                                                                                                     u'path': [u'gcloud',
                                                                                                                                               u'alpha',
                                                                                                                                               u'billing',
                                                                                                                                               u'accounts',
                                                                                                                                               u'projects',
                                                                                                                                               u'link'],
                                                                                                                                     u'positionals': [{u'completer': u'',
                                                                                                                                                       u'default': None,
                                                                                                                                                       u'description': u'Specify a project id.',
                                                                                                                                                       u'name': u'projectId',
                                                                                                                                                       u'nargs': u'0',
                                                                                                                                                       u'required': False,
                                                                                                                                                       u'value': u'PROJECT_ID'}],
                                                                                                                                     u'release': u'ALPHA',
                                                                                                                                     u'sections': {u'DESCRIPTION': u'This command links a billing account to a project.\nIf the specified billing account is open, this has\nthe effect of enabling billing on the project.\n'}},
                                                                                                                           u'list': {u'capsule': u'*(ALPHA)* List all active projects associated with the specified billing account.',
                                                                                                                                     u'commands': {},
                                                                                                                                     u'flags': {u'--filter': {u'attr': {},
                                                                                                                                                              u'category': u'LIST COMMAND',
                                                                                                                                                              u'choices': [],
                                                                                                                                                              u'completer': u'',
                                                                                                                                                              u'default': None,
                                                                                                                                                              u'description': u'Apply a Boolean filter _EXPRESSION_ to each resource item to be listed.\nIf the expression evaluates True then that item is listed. For more\ndetails and examples of filter expressions run $ gcloud topic filters. This\nflag interacts with other flags that are applied in this order: *--flatten*,\n*--sort-by*, *--filter*, *--limit*.',
                                                                                                                                                              u'group': u'',
                                                                                                                                                              u'hidden': False,
                                                                                                                                                              u'name': u'--filter',
                                                                                                                                                              u'nargs': u'0',
                                                                                                                                                              u'required': False,
                                                                                                                                                              u'type': u'string',
                                                                                                                                                              u'value': u'EXPRESSION'},
                                                                                                                                                u'--limit': {u'attr': {},
                                                                                                                                                             u'category': u'LIST COMMAND',
                                                                                                                                                             u'choices': [],
                                                                                                                                                             u'completer': u'',
                                                                                                                                                             u'default': None,
                                                                                                                                                             u'description': u'The maximum number of resources to list. The default is *unlimited*.\nThis flag interacts with other flags that are applied in this order:\n*--flatten*, *--sort-by*, *--filter*, *--limit*.',
                                                                                                                                                             u'group': u'',
                                                                                                                                                             u'hidden': False,
                                                                                                                                                             u'name': u'--limit',
                                                                                                                                                             u'nargs': u'0',
                                                                                                                                                             u'required': False,
                                                                                                                                                             u'type': u'string',
                                                                                                                                                             u'value': u'LIMIT'},
                                                                                                                                                u'--page-size': {u'attr': {},
                                                                                                                                                                 u'category': u'LIST COMMAND',
                                                                                                                                                                 u'choices': [],
                                                                                                                                                                 u'completer': u'',
                                                                                                                                                                 u'default': None,
                                                                                                                                                                 u'description': u'Some services group resource list output into pages. This flag specifies\nthe maximum number of resources per page. The default is determined by the\nservice if it supports paging, otherwise it is *unlimited* (no paging).\nPaging may be applied before or after *--filter* and *--limit* depending\non the service.',
                                                                                                                                                                 u'group': u'',
                                                                                                                                                                 u'hidden': False,
                                                                                                                                                                 u'name': u'--page-size',
                                                                                                                                                                 u'nargs': u'0',
                                                                                                                                                                 u'required': False,
                                                                                                                                                                 u'type': u'string',
                                                                                                                                                                 u'value': u'PAGE_SIZE'},
                                                                                                                                                u'--sort-by': {u'attr': {},
                                                                                                                                                               u'category': u'LIST COMMAND',
                                                                                                                                                               u'choices': [],
                                                                                                                                                               u'completer': u'',
                                                                                                                                                               u'default': None,
                                                                                                                                                               u'description': u"A comma-separated list of resource field key names to sort by. The\ndefault order is ascending. Prefix a field with ``~'' for descending\norder on that field. This flag interacts with other flags that are applied\nin this order: *--flatten*, *--sort-by*, *--filter*, *--limit*.",
                                                                                                                                                               u'group': u'',
                                                                                                                                                               u'hidden': False,
                                                                                                                                                               u'name': u'--sort-by',
                                                                                                                                                               u'nargs': u'0',
                                                                                                                                                               u'required': False,
                                                                                                                                                               u'type': u'list',
                                                                                                                                                               u'value': u'FIELD'}},
                                                                                                                                     u'group': False,
                                                                                                                                     u'groups': {},
                                                                                                                                     u'hidden': False,
                                                                                                                                     u'name': u'list',
                                                                                                                                     u'path': [u'gcloud',
                                                                                                                                               u'alpha',
                                                                                                                                               u'billing',
                                                                                                                                               u'accounts',
                                                                                                                                               u'projects',
                                                                                                                                               u'list'],
                                                                                                                                     u'positionals': [{u'completer': u'',
                                                                                                                                                       u'default': None,
                                                                                                                                                       u'description': u'Specify a billing account id. Billing account ids look like: 0X0X0X-0X0X0X-0X0X0X, and can be listed with, gcloud alpha billing accounts list.',
                                                                                                                                                       u'name': u'id',
                                                                                                                                                       u'nargs': u'0',
                                                                                                                                                       u'required': False,
                                                                                                                                                       u'value': u'ACCOUNT_ID'}],
                                                                                                                                     u'release': u'ALPHA',
                                                                                                                                     u'sections': {u'DESCRIPTION': u'*(ALPHA)* *list* ACCOUNT_ID -- lists all active projects, for the specified\nbilling account id.'}},
                                                                                                                           u'unlink': {u'capsule': u'*(ALPHA)* Unlink the account (if any) linked with a project.',
                                                                                                                                       u'commands': {},
                                                                                                                                       u'flags': {},
                                                                                                                                       u'group': False,
                                                                                                                                       u'groups': {},
                                                                                                                                       u'hidden': False,
                                                                                                                                       u'name': u'unlink',
                                                                                                                                       u'path': [u'gcloud',
                                                                                                                                                 u'alpha',
                                                                                                                                                 u'billing',
                                                                                                                                                 u'accounts',
                                                                                                                                                 u'projects',
                                                                                                                                                 u'unlink'],
                                                                                                                                       u'positionals': [{u'completer': u'',
                                                                                                                                                         u'default': None,
                                                                                                                                                         u'description': u'Specify a project id.',
                                                                                                                                                         u'name': u'project-id',
                                                                                                                                                         u'nargs': u'0',
                                                                                                                                                         u'required': False,
                                                                                                                                                         u'value': u'PROJECT_ID'}],
                                                                                                                                       u'release': u'ALPHA',
                                                                                                                                       u'sections': {u'DESCRIPTION': u"\nThis command unlinks a project from it's linked billing\naccount. This disables billing on the project.\n"}}},
                                                                                                             u'flags': {},
                                                                                                             u'group': True,
                                                                                                             u'groups': {},
                                                                                                             u'hidden': False,
                                                                                                             u'name': u'projects',
                                                                                                             u'path': [u'gcloud',
                                                                                                                       u'alpha',
                                                                                                                       u'billing',
                                                                                                                       u'accounts',
                                                                                                                       u'projects'],
                                                                                                             u'positionals': [],
                                                                                                             u'release': u'ALPHA',
                                                                                                             u'sections': {u'DESCRIPTION': u'*(ALPHA)* Manage the billing account configuration of your projects.'}}},
                                                                                 u'flags': {},
                                                                                 u'group': True,
                                                                                 u'groups': {},
                                                                                 u'hidden': False,
                                                                                 u'name': u'accounts',
                                                                                 u'path': [u'gcloud',
                                                                                           u'alpha',
                                                                                           u'billing',
                                                                                           u'accounts'],
                                                                                 u'positionals': [],
                                                                                 u'release': u'ALPHA',
                                                                                 u'sections': {u'DESCRIPTION': u'*(ALPHA)* List or describe billing accounts.'}}},
                                                     u'flags': {},
                                                     u'group': True,
                                                     u'groups': {},
                                                     u'hidden': False,
                                                     u'name': u'billing',
                                                     u'path': [u'gcloud',
                                                               u'alpha',
                                                               u'billing'],
                                                     u'positionals': [],
                                                     u'release': u'ALPHA',
                                                     u'sections': {u'DESCRIPTION': u'*(ALPHA)* Manage billing accounts and associate them with projects.'}},
                                        u'bio': {u'capsule': u'*(ALPHA)* Bio command groups.',
                                                 u'commands': {u'operations': {u'capsule': u'*(ALPHA)* Bio operations commands.',
                                                                               u'commands': {u'cancel': {u'capsule': u'*(ALPHA)* Cancel a bio operation.',
                                                                                                         u'commands': {},
                                                                                                         u'flags': {},
                                                                                                         u'group': False,
                                                                                                         u'groups': {},
                                                                                                         u'hidden': False,
                                                                                                         u'name': u'cancel',
                                                                                                         u'path': [u'gcloud',
                                                                                                                   u'alpha',
                                                                                                                   u'bio',
                                                                                                                   u'operations',
                                                                                                                   u'cancel'],
                                                                                                         u'positionals': [{u'completer': u'',
                                                                                                                           u'default': None,
                                                                                                                           u'description': u'Name for the operation you want to cancel.',
                                                                                                                           u'name': u'name',
                                                                                                                           u'nargs': u'0',
                                                                                                                           u'required': False,
                                                                                                                           u'value': u'OPERATION_NAME'}],
                                                                                                         u'release': u'ALPHA',
                                                                                                         u'sections': {u'DESCRIPTION': u"*(ALPHA)* Cancels the operation with the given operation name.\n\nThis command can fail for the following reasons:\n* The operation specified does not exist.\n* The active account does not have Writer permissions for the operation's\nproject.\n\n## EXAMPLES\n\nThe following command cancels the operation with the name\n`OP-NAMES-ARE-A-UNIQUE-HASH`:\n\n  $ cancel OP-NAMES-ARE-A-UNIQUE-HASH"}},
                                                                                             u'describe': {u'capsule': u'*(ALPHA)* Show metadata about a bio operation.',
                                                                                                           u'commands': {},
                                                                                                           u'flags': {},
                                                                                                           u'group': False,
                                                                                                           u'groups': {},
                                                                                                           u'hidden': False,
                                                                                                           u'name': u'describe',
                                                                                                           u'path': [u'gcloud',
                                                                                                                     u'alpha',
                                                                                                                     u'bio',
                                                                                                                     u'operations',
                                                                                                                     u'describe'],
                                                                                                           u'positionals': [{u'completer': u'',
                                                                                                                             u'default': None,
                                                                                                                             u'description': u'Name for the operation you want to describe.',
                                                                                                                             u'name': u'name',
                                                                                                                             u'nargs': u'0',
                                                                                                                             u'required': False,
                                                                                                                             u'value': u'OPERATION_NAME'}],
                                                                                                           u'release': u'ALPHA',
                                                                                                           u'sections': {u'DESCRIPTION': u'*(ALPHA)* Shows metadata for a bio operation given a valid operation name.\n\nThis command can fail for the following reasons:\n* The operation specified does not exist.\n* The active account does not have permission to access the given operation.\n\n## EXAMPLES\n\nThe following command prints metadata for an operation with the name\n`OP-NAMES-ARE-A-UNIQUE-HASH`:\n\n  $ describe OP-NAMES-ARE-A-UNIQUE-HASH'}},
                                                                                             u'list': {u'capsule': u'*(ALPHA)* List bio operations associated with a project.',
                                                                                                       u'commands': {},
                                                                                                       u'flags': {u'--filter': {u'attr': {},
                                                                                                                                u'category': u'LIST COMMAND',
                                                                                                                                u'choices': [],
                                                                                                                                u'completer': u'',
                                                                                                                                u'default': None,
                                                                                                                                u'description': u'Apply a Boolean filter _EXPRESSION_ to each resource item to be listed.\nIf the expression evaluates True then that item is listed. For more\ndetails and examples of filter expressions run $ gcloud topic filters. This\nflag interacts with other flags that are applied in this order: *--flatten*,\n*--sort-by*, *--filter*, *--limit*.',
                                                                                                                                u'group': u'',
                                                                                                                                u'hidden': False,
                                                                                                                                u'name': u'--filter',
                                                                                                                                u'nargs': u'0',
                                                                                                                                u'required': False,
                                                                                                                                u'type': u'string',
                                                                                                                                u'value': u'EXPRESSION'},
                                                                                                                  u'--limit': {u'attr': {},
                                                                                                                               u'category': u'LIST COMMAND',
                                                                                                                               u'choices': [],
                                                                                                                               u'completer': u'',
                                                                                                                               u'default': None,
                                                                                                                               u'description': u'The maximum number of resources to list. The default is *unlimited*.\nThis flag interacts with other flags that are applied in this order:\n*--flatten*, *--sort-by*, *--filter*, *--limit*.',
                                                                                                                               u'group': u'',
                                                                                                                               u'hidden': False,
                                                                                                                               u'name': u'--limit',
                                                                                                                               u'nargs': u'0',
                                                                                                                               u'required': False,
                                                                                                                               u'type': u'string',
                                                                                                                               u'value': u'LIMIT'},
                                                                                                                  u'--no-uri': {u'attr': {},
                                                                                                                                u'category': u'LIST COMMAND',
                                                                                                                                u'choices': [],
                                                                                                                                u'completer': u'',
                                                                                                                                u'default': True,
                                                                                                                                u'description': u'',
                                                                                                                                u'group': u'',
                                                                                                                                u'hidden': True,
                                                                                                                                u'name': u'--no-uri',
                                                                                                                                u'nargs': u'0',
                                                                                                                                u'required': False,
                                                                                                                                u'type': u'bool',
                                                                                                                                u'value': u'NO_URI'},
                                                                                                                  u'--page-size': {u'attr': {},
                                                                                                                                   u'category': u'LIST COMMAND',
                                                                                                                                   u'choices': [],
                                                                                                                                   u'completer': u'',
                                                                                                                                   u'default': None,
                                                                                                                                   u'description': u'Some services group resource list output into pages. This flag specifies\nthe maximum number of resources per page. The default is determined by the\nservice if it supports paging, otherwise it is *unlimited* (no paging).\nPaging may be applied before or after *--filter* and *--limit* depending\non the service.',
                                                                                                                                   u'group': u'',
                                                                                                                                   u'hidden': False,
                                                                                                                                   u'name': u'--page-size',
                                                                                                                                   u'nargs': u'0',
                                                                                                                                   u'required': False,
                                                                                                                                   u'type': u'string',
                                                                                                                                   u'value': u'PAGE_SIZE'},
                                                                                                                  u'--sort-by': {u'attr': {},
                                                                                                                                 u'category': u'LIST COMMAND',
                                                                                                                                 u'choices': [],
                                                                                                                                 u'completer': u'',
                                                                                                                                 u'default': None,
                                                                                                                                 u'description': u"A comma-separated list of resource field key names to sort by. The\ndefault order is ascending. Prefix a field with ``~'' for descending\norder on that field. This flag interacts with other flags that are applied\nin this order: *--flatten*, *--sort-by*, *--filter*, *--limit*.",
                                                                                                                                 u'group': u'',
                                                                                                                                 u'hidden': False,
                                                                                                                                 u'name': u'--sort-by',
                                                                                                                                 u'nargs': u'0',
                                                                                                                                 u'required': False,
                                                                                                                                 u'type': u'list',
                                                                                                                                 u'value': u'FIELD'},
                                                                                                                  u'--uri': {u'attr': {},
                                                                                                                             u'category': u'LIST COMMAND',
                                                                                                                             u'choices': [],
                                                                                                                             u'completer': u'',
                                                                                                                             u'default': False,
                                                                                                                             u'description': u'Print a list of resource URIs instead of the default output.',
                                                                                                                             u'group': u'',
                                                                                                                             u'hidden': False,
                                                                                                                             u'name': u'--uri',
                                                                                                                             u'nargs': u'0',
                                                                                                                             u'required': False,
                                                                                                                             u'type': u'bool',
                                                                                                                             u'value': u'URI'}},
                                                                                                       u'group': False,
                                                                                                       u'groups': {},
                                                                                                       u'hidden': False,
                                                                                                       u'name': u'list',
                                                                                                       u'path': [u'gcloud',
                                                                                                                 u'alpha',
                                                                                                                 u'bio',
                                                                                                                 u'operations',
                                                                                                                 u'list'],
                                                                                                       u'positionals': [],
                                                                                                       u'release': u'ALPHA',
                                                                                                       u'sections': {u'DESCRIPTION': u'*(ALPHA)* You can specify the maximum number of operations to list using the `--limit`\nflag.\n\n## EXAMPLES\n\nThe following command lists a maximum of five operations:\n\n  $ list --limit=5'}}},
                                                                               u'flags': {},
                                                                               u'group': True,
                                                                               u'groups': {},
                                                                               u'hidden': False,
                                                                               u'name': u'operations',
                                                                               u'path': [u'gcloud',
                                                                                         u'alpha',
                                                                                         u'bio',
                                                                                         u'operations'],
                                                                               u'positionals': [],
                                                                               u'release': u'ALPHA',
                                                                               u'sections': {u'DESCRIPTION': u'*(ALPHA)* Bio operations commands.'}},
                                                               u'pipelines': {u'capsule': u'*(ALPHA)* Bio pipelines commands.',
                                                                              u'commands': {u'run': {u'capsule': u'*(ALPHA)* Bio pipelines run commands.',
                                                                                                     u'commands': {u'deepvariant-alpha1': {u'capsule': u'*(ALPHA)* Runs DeepVariant Alpha1.',
                                                                                                                                           u'commands': {},
                                                                                                                                           u'flags': {u'--input-pair': {u'attr': {},
                                                                                                                                                                        u'category': u'',
                                                                                                                                                                        u'choices': [],
                                                                                                                                                                        u'completer': u'',
                                                                                                                                                                        u'default': None,
                                                                                                                                                                        u'description': u'A comma-separated pair of Google Cloud Storage paths of the\n        forward and reverse strand FASTQ files used as input.',
                                                                                                                                                                        u'group': u'',
                                                                                                                                                                        u'hidden': False,
                                                                                                                                                                        u'name': u'--input-pair',
                                                                                                                                                                        u'nargs': u'0',
                                                                                                                                                                        u'required': True,
                                                                                                                                                                        u'type': u'list',
                                                                                                                                                                        u'value': u'FASTQ_PATH'},
                                                                                                                                                      u'--labels': {u'attr': {},
                                                                                                                                                                    u'category': u'',
                                                                                                                                                                    u'choices': [],
                                                                                                                                                                    u'completer': u'',
                                                                                                                                                                    u'default': None,
                                                                                                                                                                    u'description': u'A list of label KEY=VALUE pairs to add.',
                                                                                                                                                                    u'group': u'',
                                                                                                                                                                    u'hidden': False,
                                                                                                                                                                    u'name': u'--labels',
                                                                                                                                                                    u'nargs': u'0',
                                                                                                                                                                    u'required': False,
                                                                                                                                                                    u'type': u'dict',
                                                                                                                                                                    u'value': u'KEY=VALUE'},
                                                                                                                                                      u'--logging': {u'attr': {},
                                                                                                                                                                     u'category': u'',
                                                                                                                                                                     u'choices': [],
                                                                                                                                                                     u'completer': u'',
                                                                                                                                                                     u'default': None,
                                                                                                                                                                     u'description': u'The location in Google Cloud Storage to which the\n        pipeline logs will be copied. Can be specified as a fully qualified\n        directory path, in which case logs will be output with a unique id\n        as the filename in that directory, or as a fully specified path,\n        which must end in `.log`, in which case that path will be\n        used. Stdout and stderr logs from the run are also generated and\n        output as `-stdout.log` and `-stderr.log`. For example,\n        `gs://<user_bucket>/<log_path>`.',
                                                                                                                                                                     u'group': u'',
                                                                                                                                                                     u'hidden': False,
                                                                                                                                                                     u'name': u'--logging',
                                                                                                                                                                     u'nargs': u'0',
                                                                                                                                                                     u'required': True,
                                                                                                                                                                     u'type': u'string',
                                                                                                                                                                     u'value': u'LOGGING_PATH'},
                                                                                                                                                      u'--output-path': {u'attr': {},
                                                                                                                                                                         u'category': u'',
                                                                                                                                                                         u'choices': [],
                                                                                                                                                                         u'completer': u'',
                                                                                                                                                                         u'default': None,
                                                                                                                                                                         u'description': u'The Google Cloud Storage path for copying the final output files.\n        For example, `gs://<user_bucket>/<sample_name>/`.',
                                                                                                                                                                         u'group': u'',
                                                                                                                                                                         u'hidden': False,
                                                                                                                                                                         u'name': u'--output-path',
                                                                                                                                                                         u'nargs': u'0',
                                                                                                                                                                         u'required': True,
                                                                                                                                                                         u'type': u'string',
                                                                                                                                                                         u'value': u'OUTPUT_PATH'},
                                                                                                                                                      u'--sample-name': {u'attr': {},
                                                                                                                                                                         u'category': u'',
                                                                                                                                                                         u'choices': [],
                                                                                                                                                                         u'completer': u'',
                                                                                                                                                                         u'default': None,
                                                                                                                                                                         u'description': u'The sample name.',
                                                                                                                                                                         u'group': u'',
                                                                                                                                                                         u'hidden': False,
                                                                                                                                                                         u'name': u'--sample-name',
                                                                                                                                                                         u'nargs': u'0',
                                                                                                                                                                         u'required': True,
                                                                                                                                                                         u'type': u'string',
                                                                                                                                                                         u'value': u'SAMPLE_NAME'},
                                                                                                                                                      u'--zones': {u'attr': {},
                                                                                                                                                                   u'category': u'',
                                                                                                                                                                   u'choices': [],
                                                                                                                                                                   u'completer': u'',
                                                                                                                                                                   u'default': None,
                                                                                                                                                                   u'description': u'A list of Google Compute Engine zones which may\n        be used to run the pipeline. A zone with available quota will be\n        randomly selected at the time of execution. If empty, any zone may\n        be selected.',
                                                                                                                                                                   u'group': u'',
                                                                                                                                                                   u'hidden': False,
                                                                                                                                                                   u'name': u'--zones',
                                                                                                                                                                   u'nargs': u'0',
                                                                                                                                                                   u'required': False,
                                                                                                                                                                   u'type': u'list',
                                                                                                                                                                   u'value': u'ZONE'}},
                                                                                                                                           u'group': False,
                                                                                                                                           u'groups': {},
                                                                                                                                           u'hidden': False,
                                                                                                                                           u'name': u'deepvariant-alpha1',
                                                                                                                                           u'path': [u'gcloud',
                                                                                                                                                     u'alpha',
                                                                                                                                                     u'bio',
                                                                                                                                                     u'pipelines',
                                                                                                                                                     u'run',
                                                                                                                                                     u'deepvariant-alpha1'],
                                                                                                                                           u'positionals': [],
                                                                                                                                           u'release': u'ALPHA',
                                                                                                                                           u'sections': {u'DESCRIPTION': u'*(ALPHA)* See https://cloud.google.com/genomics/v1alpha2/deepvariant for more\ninformation.'}}},
                                                                                                     u'flags': {},
                                                                                                     u'group': True,
                                                                                                     u'groups': {},
                                                                                                     u'hidden': False,
                                                                                                     u'name': u'run',
                                                                                                     u'path': [u'gcloud',
                                                                                                               u'alpha',
                                                                                                               u'bio',
                                                                                                               u'pipelines',
                                                                                                               u'run'],
                                                                                                     u'positionals': [],
                                                                                                     u'release': u'ALPHA',
                                                                                                     u'sections': {u'DESCRIPTION': u'*(ALPHA)* Bio pipelines run commands.'}}},
                                                                              u'flags': {},
                                                                              u'group': True,
                                                                              u'groups': {},
                                                                              u'hidden': False,
                                                                              u'name': u'pipelines',
                                                                              u'path': [u'gcloud',
                                                                                        u'alpha',
                                                                                        u'bio',
                                                                                        u'pipelines'],
                                                                              u'positionals': [],
                                                                              u'release': u'ALPHA',
                                                                              u'sections': {u'DESCRIPTION': u'*(ALPHA)* Bio pipelines commands.'}}},
                                                 u'flags': {},
                                                 u'group': True,
                                                 u'groups': {},
                                                 u'hidden': False,
                                                 u'name': u'bio',
                                                 u'path': [u'gcloud',
                                                           u'alpha',
                                                           u'bio'],
                                                 u'positionals': [],
                                                 u'release': u'ALPHA',
                                                 u'sections': {u'DESCRIPTION': u'*(ALPHA)* Bio command groups.'}},
                                        u'compute': {u'capsule': u'*(ALPHA)* Create and manipulate Google Compute Engine resources.',
                                                     u'commands': {u'accelerator-types': {u'capsule': u'*(ALPHA)* Read Google Compute Engine accelerator types.',
                                                                                          u'commands': {u'describe': {u'capsule': u'*(ALPHA)* Describe Google Compute Engine accelerator types.',
                                                                                                                      u'commands': {},
                                                                                                                      u'flags': {u'--zone': {u'attr': {u'property': {u'name': u'compute/zone'}},
                                                                                                                                             u'category': u'',
                                                                                                                                             u'choices': [],
                                                                                                                                             u'completer': u'',
                                                                                                                                             u'default': None,
                                                                                                                                             u'description': u'The zone of the accelerator type to operate on. Overrides the default *compute/zone* property value for this command invocation.',
                                                                                                                                             u'group': u'',
                                                                                                                                             u'hidden': False,
                                                                                                                                             u'name': u'--zone',
                                                                                                                                             u'nargs': u'0',
                                                                                                                                             u'required': False,
                                                                                                                                             u'type': u'string',
                                                                                                                                             u'value': u'ZONE'}},
                                                                                                                      u'group': False,
                                                                                                                      u'groups': {},
                                                                                                                      u'hidden': False,
                                                                                                                      u'name': u'describe',
                                                                                                                      u'path': [u'gcloud',
                                                                                                                                u'alpha',
                                                                                                                                u'compute',
                                                                                                                                u'accelerator-types',
                                                                                                                                u'describe'],
                                                                                                                      u'positionals': [{u'completer': u'',
                                                                                                                                        u'default': None,
                                                                                                                                        u'description': u'The name of the accelerator type.',
                                                                                                                                        u'name': u'name',
                                                                                                                                        u'nargs': u'0',
                                                                                                                                        u'required': False,
                                                                                                                                        u'value': u'NAME'}],
                                                                                                                      u'release': u'ALPHA',
                                                                                                                      u'sections': {u'DESCRIPTION': u'*describe* displays all data associated with a Google Compute\nEngine accelerator type.\n'}},
                                                                                                        u'list': {u'capsule': u'*(ALPHA)* List Google Compute Engine accelerator types.',
                                                                                                                  u'commands': {},
                                                                                                                  u'flags': {u'--filter': {u'attr': {},
                                                                                                                                           u'category': u'LIST COMMAND',
                                                                                                                                           u'choices': [],
                                                                                                                                           u'completer': u'',
                                                                                                                                           u'default': None,
                                                                                                                                           u'description': u'Apply a Boolean filter _EXPRESSION_ to each resource item to be listed.\nIf the expression evaluates True then that item is listed. For more\ndetails and examples of filter expressions run $ gcloud topic filters. This\nflag interacts with other flags that are applied in this order: *--flatten*,\n*--sort-by*, *--filter*, *--limit*.',
                                                                                                                                           u'group': u'',
                                                                                                                                           u'hidden': False,
                                                                                                                                           u'name': u'--filter',
                                                                                                                                           u'nargs': u'0',
                                                                                                                                           u'required': False,
                                                                                                                                           u'type': u'string',
                                                                                                                                           u'value': u'EXPRESSION'},
                                                                                                                             u'--limit': {u'attr': {},
                                                                                                                                          u'category': u'LIST COMMAND',
                                                                                                                                          u'choices': [],
                                                                                                                                          u'completer': u'',
                                                                                                                                          u'default': None,
                                                                                                                                          u'description': u'The maximum number of resources to list. The default is *unlimited*.\nThis flag interacts with other flags that are applied in this order:\n*--flatten*, *--sort-by*, *--filter*, *--limit*.',
                                                                                                                                          u'group': u'',
                                                                                                                                          u'hidden': False,
                                                                                                                                          u'name': u'--limit',
                                                                                                                                          u'nargs': u'0',
                                                                                                                                          u'required': False,
                                                                                                                                          u'type': u'string',
                                                                                                                                          u'value': u'LIMIT'},
                                                                                                                             u'--no-uri': {u'attr': {},
                                                                                                                                           u'category': u'LIST COMMAND',
                                                                                                                                           u'choices': [],
                                                                                                                                           u'completer': u'',
                                                                                                                                           u'default': True,
                                                                                                                                           u'description': u'',
                                                                                                                                           u'group': u'',
                                                                                                                                           u'hidden': True,
                                                                                                                                           u'name': u'--no-uri',
                                                                                                                                           u'nargs': u'0',
                                                                                                                                           u'required': False,
                                                                                                                                           u'type': u'bool',
                                                                                                                                           u'value': u'NO_URI'},
                                                                                                                             u'--page-size': {u'attr': {},
                                                                                                                                              u'category': u'LIST COMMAND',
                                                                                                                                              u'choices': [],
                                                                                                                                              u'completer': u'',
                                                                                                                                              u'default': None,
                                                                                                                                              u'description': u'Some services group resource list output into pages. This flag specifies\nthe maximum number of resources per page. The default is determined by the\nservice if it supports paging, otherwise it is *unlimited* (no paging).\nPaging may be applied before or after *--filter* and *--limit* depending\non the service.',
                                                                                                                                              u'group': u'',
                                                                                                                                              u'hidden': False,
                                                                                                                                              u'name': u'--page-size',
                                                                                                                                              u'nargs': u'0',
                                                                                                                                              u'required': False,
                                                                                                                                              u'type': u'string',
                                                                                                                                              u'value': u'PAGE_SIZE'},
                                                                                                                             u'--sort-by': {u'attr': {},
                                                                                                                                            u'category': u'LIST COMMAND',
                                                                                                                                            u'choices': [],
                                                                                                                                            u'completer': u'',
                                                                                                                                            u'default': None,
                                                                                                                                            u'description': u"A comma-separated list of resource field key names to sort by. The\ndefault order is ascending. Prefix a field with ``~'' for descending\norder on that field. This flag interacts with other flags that are applied\nin this order: *--flatten*, *--sort-by*, *--filter*, *--limit*.",
                                                                                                                                            u'group': u'',
                                                                                                                                            u'hidden': False,
                                                                                                                                            u'name': u'--sort-by',
                                                                                                                                            u'nargs': u'0',
                                                                                                                                            u'required': False,
                                                                                                                                            u'type': u'list',
                                                                                                                                            u'value': u'FIELD'},
                                                                                                                             u'--uri': {u'attr': {},
                                                                                                                                        u'category': u'LIST COMMAND',
                                                                                                                                        u'choices': [],
                                                                                                                                        u'completer': u'',
                                                                                                                                        u'default': False,
                                                                                                                                        u'description': u'Print a list of resource URIs instead of the default output.',
                                                                                                                                        u'group': u'',
                                                                                                                                        u'hidden': False,
                                                                                                                                        u'name': u'--uri',
                                                                                                                                        u'nargs': u'0',
                                                                                                                                        u'required': False,
                                                                                                                                        u'type': u'bool',
                                                                                                                                        u'value': u'URI'}},
                                                                                                                  u'group': False,
                                                                                                                  u'groups': {},
                                                                                                                  u'hidden': False,
                                                                                                                  u'name': u'list',
                                                                                                                  u'path': [u'gcloud',
                                                                                                                            u'alpha',
                                                                                                                            u'compute',
                                                                                                                            u'accelerator-types',
                                                                                                                            u'list'],
                                                                                                                  u'positionals': [],
                                                                                                                  u'release': u'ALPHA',
                                                                                                                  u'sections': {u'DESCRIPTION': u"*list* displays all Google Compute Engine accelerator types in a project.\n\nBy default, accelerator types from all zones are listed. The results can be narrowed\ndown by providing the ``--zones'' flag.\n",
                                                                                                                                u'EXAMPLES': u"To list all accelerator types in a project in table form, run:\n\n  $ list\n\nTo list the URIs of all accelerator types in a project, run:\n\n  $ list --uri\n\nTo list all accelerator types in the ``us-central1-b'' and ``europe-west1-d'' zones,\nrun:\n\n  $ list --zones us-central1-b europe-west1-d\n"}}},
                                                                                          u'flags': {},
                                                                                          u'group': True,
                                                                                          u'groups': {},
                                                                                          u'hidden': False,
                                                                                          u'name': u'accelerator-types',
                                                                                          u'path': [u'gcloud',
                                                                                                    u'alpha',
                                                                                                    u'compute',
                                                                                                    u'accelerator-types'],
                                                                                          u'positionals': [],
                                                                                          u'release': u'ALPHA',
                                                                                          u'sections': {u'DESCRIPTION': u'*(ALPHA)* Read Google Compute Engine accelerator types.'}},
                                                                   u'addresses': {u'capsule': u'*(ALPHA)* Read and manipulate Google Compute Engine addresses.',
                                                                                  u'commands': {u'create': {u'capsule': u'*(ALPHA)* Reserve IP addresses.',
                                                                                                            u'commands': {},
                                                                                                            u'flags': {u'--addresses': {u'attr': {},
                                                                                                                                        u'category': u'',
                                                                                                                                        u'choices': [],
                                                                                                                                        u'completer': u'',
                                                                                                                                        u'default': None,
                                                                                                                                        u'description': u"Ephemeral IP addresses to promote to reserved status. Only addresses\nthat are being used by resources in the project can be promoted. When\nproviding this flag, a parallel list of names for the addresses can\nbe provided. For example,\n+\n  $ {command} ADDRESS-1 ADDRESS-2 --addresses 162.222.181.197,162.222.181.198 --region us-central1\n+\nwill result in 162.222.181.197 being reserved as\n'ADDRESS-1' and 162.222.181.198 as 'ADDRESS-2'. If\nno names are given, randomly-generated names will be assigned\nto the IP addresses.",
                                                                                                                                        u'group': u'',
                                                                                                                                        u'hidden': False,
                                                                                                                                        u'name': u'--addresses',
                                                                                                                                        u'nargs': u'0',
                                                                                                                                        u'required': False,
                                                                                                                                        u'type': u'list',
                                                                                                                                        u'value': u'ADDRESS'},
                                                                                                                       u'--description': {u'attr': {},
                                                                                                                                          u'category': u'',
                                                                                                                                          u'choices': [],
                                                                                                                                          u'completer': u'',
                                                                                                                                          u'default': None,
                                                                                                                                          u'description': u'An optional textual description for the addresses.',
                                                                                                                                          u'group': u'',
                                                                                                                                          u'hidden': False,
                                                                                                                                          u'name': u'--description',
                                                                                                                                          u'nargs': u'0',
                                                                                                                                          u'required': False,
                                                                                                                                          u'type': u'string',
                                                                                                                                          u'value': u'DESCRIPTION'},
                                                                                                                       u'--global': {u'attr': {},
                                                                                                                                     u'category': u'',
                                                                                                                                     u'choices': [],
                                                                                                                                     u'completer': u'',
                                                                                                                                     u'default': False,
                                                                                                                                     u'description': u'If provided, it is assumed the address name is global.',
                                                                                                                                     u'group': u'create.1',
                                                                                                                                     u'hidden': False,
                                                                                                                                     u'name': u'--global',
                                                                                                                                     u'nargs': u'0',
                                                                                                                                     u'required': False,
                                                                                                                                     u'type': u'bool',
                                                                                                                                     u'value': u'GLOBAL'},
                                                                                                                       u'--network-tier': {u'attr': {},
                                                                                                                                           u'category': u'',
                                                                                                                                           u'choices': [u'PREMIUM',
                                                                                                                                                        u'SELECT'],
                                                                                                                                           u'completer': u'',
                                                                                                                                           u'default': None,
                                                                                                                                           u'description': u'The network tier to assign to the reserved IP addresses. If left empty, `PREMIUM` is used. Supported network tiers are: `PREMIUM`, `SELECT`. _NETWORK_TIER_ must be one of: *PREMIUM*, *SELECT*.',
                                                                                                                                           u'group': u'',
                                                                                                                                           u'hidden': False,
                                                                                                                                           u'name': u'--network-tier',
                                                                                                                                           u'nargs': u'0',
                                                                                                                                           u'required': False,
                                                                                                                                           u'type': u'string',
                                                                                                                                           u'value': u'NETWORK_TIER'},
                                                                                                                       u'--region': {u'attr': {u'property': {u'name': u'compute/region'}},
                                                                                                                                     u'category': u'',
                                                                                                                                     u'choices': [],
                                                                                                                                     u'completer': u'',
                                                                                                                                     u'default': None,
                                                                                                                                     u'description': u"The region of the address name to operate on. If not specified, you will be prompted to select a region.\n+\nTo avoid prompting when this flag is omitted, you can set the\n``compute/region'' property:\n+\n  $ gcloud config set compute/region REGION\n+\nA list of regions can be fetched by running:\n+\n  $ gcloud compute regions list\n+\nTo unset the property, run:\n+\n  $ gcloud config unset compute/region\n+\nAlternatively, the region can be stored in the environment\nvariable ``CLOUDSDK_COMPUTE_REGION''.",
                                                                                                                                     u'group': u'create.1',
                                                                                                                                     u'hidden': False,
                                                                                                                                     u'name': u'--region',
                                                                                                                                     u'nargs': u'0',
                                                                                                                                     u'required': False,
                                                                                                                                     u'type': u'string',
                                                                                                                                     u'value': u'REGION'}},
                                                                                                            u'group': False,
                                                                                                            u'groups': {u'create.1': {u'description': u'At most one of these may be specified:',
                                                                                                                                      u'is_mutex': True,
                                                                                                                                      u'is_required': False}},
                                                                                                            u'hidden': False,
                                                                                                            u'name': u'create',
                                                                                                            u'path': [u'gcloud',
                                                                                                                      u'alpha',
                                                                                                                      u'compute',
                                                                                                                      u'addresses',
                                                                                                                      u'create'],
                                                                                                            u'positionals': [{u'completer': u'',
                                                                                                                              u'default': None,
                                                                                                                              u'description': u'The address names to operate on.',
                                                                                                                              u'name': u'name',
                                                                                                                              u'nargs': u'*',
                                                                                                                              u'required': False,
                                                                                                                              u'value': u'NAME'}],
                                                                                                            u'release': u'ALPHA',
                                                                                                            u'sections': {u'DESCRIPTION': u"*create* is used to reserve one or more IP addresses. Once\nan IP address is reserved, it will be associated with the\nproject until it is released using 'gcloud compute addresses\ndelete'. Ephemeral IP addresses that are in use by resources\nin the project, can be reserved using the ``--addresses''\nflag.\n",
                                                                                                                          u'EXAMPLES': u"To reserve three IP addresses in the ``us-central1'' region,\nrun:\n\n  $ create ADDRESS-1 ADDRESS-2 ADDRESS-3 --region us-central1\n\nTo reserve ephemeral IP addresses 162.222.181.198 and\n23.251.146.189 which are being used by virtual machine\ninstances in the ``us-central1'' region, run:\n\n  $ create --addresses 162.222.181.198,23.251.146.189 --region us-central1\n\nIn the above invocation, the two addresses will be assigned\nrandom names.\n"}},
                                                                                                u'delete': {u'capsule': u'*(ALPHA)* Release reserved IP addresses.',
                                                                                                            u'commands': {},
                                                                                                            u'flags': {u'--global': {u'attr': {},
                                                                                                                                     u'category': u'',
                                                                                                                                     u'choices': [],
                                                                                                                                     u'completer': u'',
                                                                                                                                     u'default': False,
                                                                                                                                     u'description': u'If provided, it is assumed the address name is global.',
                                                                                                                                     u'group': u'delete.1',
                                                                                                                                     u'hidden': False,
                                                                                                                                     u'name': u'--global',
                                                                                                                                     u'nargs': u'0',
                                                                                                                                     u'required': False,
                                                                                                                                     u'type': u'bool',
                                                                                                                                     u'value': u'GLOBAL'},
                                                                                                                       u'--region': {u'attr': {u'property': {u'name': u'compute/region'}},
                                                                                                                                     u'category': u'',
                                                                                                                                     u'choices': [],
                                                                                                                                     u'completer': u'',
                                                                                                                                     u'default': None,
                                                                                                                                     u'description': u"The region of the address name to operate on. If not specified, you will be prompted to select a region.\n+\nTo avoid prompting when this flag is omitted, you can set the\n``compute/region'' property:\n+\n  $ gcloud config set compute/region REGION\n+\nA list of regions can be fetched by running:\n+\n  $ gcloud compute regions list\n+\nTo unset the property, run:\n+\n  $ gcloud config unset compute/region\n+\nAlternatively, the region can be stored in the environment\nvariable ``CLOUDSDK_COMPUTE_REGION''.",
                                                                                                                                     u'group': u'delete.1',
                                                                                                                                     u'hidden': False,
                                                                                                                                     u'name': u'--region',
                                                                                                                                     u'nargs': u'0',
                                                                                                                                     u'required': False,
                                                                                                                                     u'type': u'string',
                                                                                                                                     u'value': u'REGION'}},
                                                                                                            u'group': False,
                                                                                                            u'groups': {u'delete.1': {u'description': u'At most one of these may be specified:',
                                                                                                                                      u'is_mutex': True,
                                                                                                                                      u'is_required': False}},
                                                                                                            u'hidden': False,
                                                                                                            u'name': u'delete',
                                                                                                            u'path': [u'gcloud',
                                                                                                                      u'alpha',
                                                                                                                      u'compute',
                                                                                                                      u'addresses',
                                                                                                                      u'delete'],
                                                                                                            u'positionals': [{u'completer': u'',
                                                                                                                              u'default': None,
                                                                                                                              u'description': u'The address names to operate on.',
                                                                                                                              u'name': u'name',
                                                                                                                              u'nargs': u'+',
                                                                                                                              u'required': False,
                                                                                                                              u'value': u'NAME'}],
                                                                                                            u'release': u'ALPHA',
                                                                                                            u'sections': {u'DESCRIPTION': u'*delete* releases one or more Google Compute Engine IP addresses.\n'}},
                                                                                                u'describe': {u'capsule': u'*(ALPHA)* Display detailed information about an address.',
                                                                                                              u'commands': {},
                                                                                                              u'flags': {u'--global': {u'attr': {},
                                                                                                                                       u'category': u'',
                                                                                                                                       u'choices': [],
                                                                                                                                       u'completer': u'',
                                                                                                                                       u'default': False,
                                                                                                                                       u'description': u'If provided, it is assumed that the requested resource is global.',
                                                                                                                                       u'group': u'describe.1',
                                                                                                                                       u'hidden': False,
                                                                                                                                       u'name': u'--global',
                                                                                                                                       u'nargs': u'0',
                                                                                                                                       u'required': False,
                                                                                                                                       u'type': u'bool',
                                                                                                                                       u'value': u'GLOBAL'},
                                                                                                                         u'--region': {u'attr': {u'property': {u'name': u'compute/region'}},
                                                                                                                                       u'category': u'',
                                                                                                                                       u'choices': [],
                                                                                                                                       u'completer': u'',
                                                                                                                                       u'default': None,
                                                                                                                                       u'description': u'The region of the resource to fetch. Overrides the default *compute/region* property value for this command invocation.',
                                                                                                                                       u'group': u'describe.1',
                                                                                                                                       u'hidden': False,
                                                                                                                                       u'name': u'--region',
                                                                                                                                       u'nargs': u'0',
                                                                                                                                       u'required': False,
                                                                                                                                       u'type': u'string',
                                                                                                                                       u'value': u'REGION'}},
                                                                                                              u'group': False,
                                                                                                              u'groups': {u'describe.1': {u'description': u'At most one of these may be specified:',
                                                                                                                                          u'is_mutex': True,
                                                                                                                                          u'is_required': False}},
                                                                                                              u'hidden': False,
                                                                                                              u'name': u'describe',
                                                                                                              u'path': [u'gcloud',
                                                                                                                        u'alpha',
                                                                                                                        u'compute',
                                                                                                                        u'addresses',
                                                                                                                        u'describe'],
                                                                                                              u'positionals': [{u'completer': u'',
                                                                                                                                u'default': None,
                                                                                                                                u'description': u'The name of the resource to fetch.',
                                                                                                                                u'name': u'name',
                                                                                                                                u'nargs': u'0',
                                                                                                                                u'required': False,
                                                                                                                                u'value': u'NAME'}],
                                                                                                              u'release': u'ALPHA',
                                                                                                              u'sections': {u'DESCRIPTION': u'*describe* displays all data associated with an address in a project.\n',
                                                                                                                            u'EXAMPLES': u'To get details about a global address, run:\n\n  $ describe ADDRESS --global\n\nTo get details about a regional address, run:\n\n  $ describe ADDRESS --region us-central1\n'}},
                                                                                                u'list': {u'capsule': u'*(ALPHA)* List addresses.',
                                                                                                          u'commands': {},
                                                                                                          u'flags': {u'--filter': {u'attr': {},
                                                                                                                                   u'category': u'LIST COMMAND',
                                                                                                                                   u'choices': [],
                                                                                                                                   u'completer': u'',
                                                                                                                                   u'default': None,
                                                                                                                                   u'description': u'Apply a Boolean filter _EXPRESSION_ to each resource item to be listed.\nIf the expression evaluates True then that item is listed. For more\ndetails and examples of filter expressions run $ gcloud topic filters. This\nflag interacts with other flags that are applied in this order: *--flatten*,\n*--sort-by*, *--filter*, *--limit*.',
                                                                                                                                   u'group': u'',
                                                                                                                                   u'hidden': False,
                                                                                                                                   u'name': u'--filter',
                                                                                                                                   u'nargs': u'0',
                                                                                                                                   u'required': False,
                                                                                                                                   u'type': u'string',
                                                                                                                                   u'value': u'EXPRESSION'},
                                                                                                                     u'--global': {u'attr': {},
                                                                                                                                   u'category': u'',
                                                                                                                                   u'choices': [],
                                                                                                                                   u'completer': u'',
                                                                                                                                   u'default': False,
                                                                                                                                   u'description': u'If provided, only global resources are shown.',
                                                                                                                                   u'group': u'list.1',
                                                                                                                                   u'hidden': False,
                                                                                                                                   u'name': u'--global',
                                                                                                                                   u'nargs': u'0',
                                                                                                                                   u'required': False,
                                                                                                                                   u'type': u'bool',
                                                                                                                                   u'value': u'GLOBAL'},
                                                                                                                     u'--limit': {u'attr': {},
                                                                                                                                  u'category': u'LIST COMMAND',
                                                                                                                                  u'choices': [],
                                                                                                                                  u'completer': u'',
                                                                                                                                  u'default': None,
                                                                                                                                  u'description': u'The maximum number of resources to list. The default is *unlimited*.\nThis flag interacts with other flags that are applied in this order:\n*--flatten*, *--sort-by*, *--filter*, *--limit*.',
                                                                                                                                  u'group': u'',
                                                                                                                                  u'hidden': False,
                                                                                                                                  u'name': u'--limit',
                                                                                                                                  u'nargs': u'0',
                                                                                                                                  u'required': False,
                                                                                                                                  u'type': u'string',
                                                                                                                                  u'value': u'LIMIT'},
                                                                                                                     u'--no-uri': {u'attr': {},
                                                                                                                                   u'category': u'LIST COMMAND',
                                                                                                                                   u'choices': [],
                                                                                                                                   u'completer': u'',
                                                                                                                                   u'default': True,
                                                                                                                                   u'description': u'',
                                                                                                                                   u'group': u'',
                                                                                                                                   u'hidden': True,
                                                                                                                                   u'name': u'--no-uri',
                                                                                                                                   u'nargs': u'0',
                                                                                                                                   u'required': False,
                                                                                                                                   u'type': u'bool',
                                                                                                                                   u'value': u'NO_URI'},
                                                                                                                     u'--page-size': {u'attr': {},
                                                                                                                                      u'category': u'LIST COMMAND',
                                                                                                                                      u'choices': [],
                                                                                                                                      u'completer': u'',
                                                                                                                                      u'default': None,
                                                                                                                                      u'description': u'Some services group resource list output into pages. This flag specifies\nthe maximum number of resources per page. The default is determined by the\nservice if it supports paging, otherwise it is *unlimited* (no paging).\nPaging may be applied before or after *--filter* and *--limit* depending\non the service.',
                                                                                                                                      u'group': u'',
                                                                                                                                      u'hidden': False,
                                                                                                                                      u'name': u'--page-size',
                                                                                                                                      u'nargs': u'0',
                                                                                                                                      u'required': False,
                                                                                                                                      u'type': u'string',
                                                                                                                                      u'value': u'PAGE_SIZE'},
                                                                                                                     u'--regexp': {u'attr': {},
                                                                                                                                   u'category': u'',
                                                                                                                                   u'choices': [],
                                                                                                                                   u'completer': u'',
                                                                                                                                   u'default': None,
                                                                                                                                   u'description': u'A regular expression to filter the names of the results on. Any names\nthat do not match the entire regular expression will be filtered out.',
                                                                                                                                   u'group': u'',
                                                                                                                                   u'hidden': False,
                                                                                                                                   u'name': u'--regexp',
                                                                                                                                   u'nargs': u'0',
                                                                                                                                   u'required': False,
                                                                                                                                   u'type': u'string',
                                                                                                                                   u'value': u'REGEXP'},
                                                                                                                     u'--regions': {u'attr': {},
                                                                                                                                    u'category': u'',
                                                                                                                                    u'choices': [],
                                                                                                                                    u'completer': u'',
                                                                                                                                    u'default': None,
                                                                                                                                    u'description': u'If provided, only regional resources are shown. If arguments are provided, only resources from the given regions are shown.',
                                                                                                                                    u'group': u'list.1',
                                                                                                                                    u'hidden': False,
                                                                                                                                    u'name': u'--regions',
                                                                                                                                    u'nargs': u'0',
                                                                                                                                    u'required': False,
                                                                                                                                    u'type': u'list',
                                                                                                                                    u'value': u'REGION'},
                                                                                                                     u'--sort-by': {u'attr': {},
                                                                                                                                    u'category': u'LIST COMMAND',
                                                                                                                                    u'choices': [],
                                                                                                                                    u'completer': u'',
                                                                                                                                    u'default': None,
                                                                                                                                    u'description': u"A comma-separated list of resource field key names to sort by. The\ndefault order is ascending. Prefix a field with ``~'' for descending\norder on that field. This flag interacts with other flags that are applied\nin this order: *--flatten*, *--sort-by*, *--filter*, *--limit*.",
                                                                                                                                    u'group': u'',
                                                                                                                                    u'hidden': False,
                                                                                                                                    u'name': u'--sort-by',
                                                                                                                                    u'nargs': u'0',
                                                                                                                                    u'required': False,
                                                                                                                                    u'type': u'list',
                                                                                                                                    u'value': u'FIELD'},
                                                                                                                     u'--uri': {u'attr': {},
                                                                                                                                u'category': u'LIST COMMAND',
                                                                                                                                u'choices': [],
                                                                                                                                u'completer': u'',
                                                                                                                                u'default': False,
                                                                                                                                u'description': u'Print a list of resource URIs instead of the default output.',
                                                                                                                                u'group': u'',
                                                                                                                                u'hidden': False,
                                                                                                                                u'name': u'--uri',
                                                                                                                                u'nargs': u'0',
                                                                                                                                u'required': False,
                                                                                                                                u'type': u'bool',
                                                                                                                                u'value': u'URI'}},
                                                                                                          u'group': False,
                                                                                                          u'groups': {u'list.1': {u'description': u'At most one of these may be specified:',
                                                                                                                                  u'is_mutex': True,
                                                                                                                                  u'is_required': False}},
                                                                                                          u'hidden': False,
                                                                                                          u'name': u'list',
                                                                                                          u'path': [u'gcloud',
                                                                                                                    u'alpha',
                                                                                                                    u'compute',
                                                                                                                    u'addresses',
                                                                                                                    u'list'],
                                                                                                          u'positionals': [{u'completer': u'',
                                                                                                                            u'default': [],
                                                                                                                            u'description': u'If provided, show details for the specified names and/or URIs of resources.',
                                                                                                                            u'name': u'names',
                                                                                                                            u'nargs': u'*',
                                                                                                                            u'required': False,
                                                                                                                            u'value': u'NAME'}],
                                                                                                          u'release': u'ALPHA',
                                                                                                          u'sections': {u'DESCRIPTION': u'*list* lists summary information of addresses in a project. The\n*--uri* option can be used to display URIs instead. Users who want to\nsee more data should use `gcloud compute addresses describe`.\n\nBy default, global addresses and addresses from all regions are listed.\nThe results can be narrowed down by providing the *--regions* or\n*--global* flag.\n',
                                                                                                                        u'EXAMPLES': u"To list all addresses in a project in table form, run:\n\n  $ list\n\nTo list the URIs of all addresses in a project, run:\n\n  $ list --uri\n\nTo list all of the global addresses in a project, run:\n\n  $ list --global\n\nTo list all of the regional addresses in a project, run:\n\n  $ list --regions\n\nTo list all of the addresses from the ``us-central1'' and the\n``europe-west1'' regions, run:\n\n  $ list --regions us-central1,europe-west1\n"}}},
                                                                                  u'flags': {},
                                                                                  u'group': True,
                                                                                  u'groups': {},
                                                                                  u'hidden': False,
                                                                                  u'name': u'addresses',
                                                                                  u'path': [u'gcloud',
                                                                                            u'alpha',
                                                                                            u'compute',
                                                                                            u'addresses'],
                                                                                  u'positionals': [],
                                                                                  u'release': u'ALPHA',
                                                                                  u'sections': {u'DESCRIPTION': u'*(ALPHA)* Read and manipulate Google Compute Engine addresses.'}},
                                                                   u'backend-buckets': {u'capsule': u'*(ALPHA)* Read and manipulate backend buckets.',
                                                                                        u'commands': {u'create': {u'capsule': u'*(ALPHA)* Create a backend bucket.',
                                                                                                                  u'commands': {},
                                                                                                                  u'flags': {u'--description': {u'attr': {},
                                                                                                                                                u'category': u'',
                                                                                                                                                u'choices': [],
                                                                                                                                                u'completer': u'',
                                                                                                                                                u'default': None,
                                                                                                                                                u'description': u'An optional, textual description for the backend bucket.',
                                                                                                                                                u'group': u'',
                                                                                                                                                u'hidden': False,
                                                                                                                                                u'name': u'--description',
                                                                                                                                                u'nargs': u'0',
                                                                                                                                                u'required': False,
                                                                                                                                                u'type': u'string',
                                                                                                                                                u'value': u'DESCRIPTION'},
                                                                                                                             u'--enable-cdn': {u'attr': {},
                                                                                                                                               u'category': u'',
                                                                                                                                               u'choices': [],
                                                                                                                                               u'completer': u'',
                                                                                                                                               u'default': False,
                                                                                                                                               u'description': u'Enable Cloud CDN for the backend bucket. Cloud CDN can cache HTTP\nresponses from a backend bucket at the edge of the network, close to\nusers.',
                                                                                                                                               u'group': u'',
                                                                                                                                               u'hidden': False,
                                                                                                                                               u'name': u'--enable-cdn',
                                                                                                                                               u'nargs': u'0',
                                                                                                                                               u'required': False,
                                                                                                                                               u'type': u'bool',
                                                                                                                                               u'value': u'ENABLE_CDN'},
                                                                                                                             u'--gcs-bucket-name': {u'attr': {},
                                                                                                                                                    u'category': u'',
                                                                                                                                                    u'choices': [],
                                                                                                                                                    u'completer': u'',
                                                                                                                                                    u'default': None,
                                                                                                                                                    u'description': u"The name of the Google Cloud Storage bucket to serve from. The storage\n        bucket must be owned by the project's owner.",
                                                                                                                                                    u'group': u'',
                                                                                                                                                    u'hidden': False,
                                                                                                                                                    u'name': u'--gcs-bucket-name',
                                                                                                                                                    u'nargs': u'0',
                                                                                                                                                    u'required': True,
                                                                                                                                                    u'type': u'string',
                                                                                                                                                    u'value': u'GCS_BUCKET_NAME'},
                                                                                                                             u'--no-enable-cdn': {u'attr': {},
                                                                                                                                                  u'category': u'',
                                                                                                                                                  u'choices': [],
                                                                                                                                                  u'completer': u'',
                                                                                                                                                  u'default': False,
                                                                                                                                                  u'description': u'',
                                                                                                                                                  u'group': u'',
                                                                                                                                                  u'hidden': True,
                                                                                                                                                  u'name': u'--no-enable-cdn',
                                                                                                                                                  u'nargs': u'0',
                                                                                                                                                  u'required': False,
                                                                                                                                                  u'type': u'bool',
                                                                                                                                                  u'value': u'NO_ENABLE_CDN'}},
                                                                                                                  u'group': False,
                                                                                                                  u'groups': {},
                                                                                                                  u'hidden': False,
                                                                                                                  u'name': u'create',
                                                                                                                  u'path': [u'gcloud',
                                                                                                                            u'alpha',
                                                                                                                            u'compute',
                                                                                                                            u'backend-buckets',
                                                                                                                            u'create'],
                                                                                                                  u'positionals': [{u'completer': u'',
                                                                                                                                    u'default': None,
                                                                                                                                    u'description': u'The name of the backend bucket.',
                                                                                                                                    u'name': u'name',
                                                                                                                                    u'nargs': u'0',
                                                                                                                                    u'required': False,
                                                                                                                                    u'value': u'NAME'}],
                                                                                                                  u'release': u'ALPHA',
                                                                                                                  u'sections': {u'DESCRIPTION': u'\n*create* is used to create backend buckets. Backend buckets\ndefine a Google Cloud Storage bucket that can serve content. URL\nmaps define which requests are sent to which backend buckets.\n'}},
                                                                                                      u'delete': {u'capsule': u'*(ALPHA)* Delete backend buckets.',
                                                                                                                  u'commands': {},
                                                                                                                  u'flags': {},
                                                                                                                  u'group': False,
                                                                                                                  u'groups': {},
                                                                                                                  u'hidden': False,
                                                                                                                  u'name': u'delete',
                                                                                                                  u'path': [u'gcloud',
                                                                                                                            u'alpha',
                                                                                                                            u'compute',
                                                                                                                            u'backend-buckets',
                                                                                                                            u'delete'],
                                                                                                                  u'positionals': [{u'completer': u'',
                                                                                                                                    u'default': None,
                                                                                                                                    u'description': u'The resources to delete.',
                                                                                                                                    u'name': u'names',
                                                                                                                                    u'nargs': u'+',
                                                                                                                                    u'required': False,
                                                                                                                                    u'value': u'NAME'}],
                                                                                                                  u'release': u'ALPHA',
                                                                                                                  u'sections': {u'DESCRIPTION': u'*(ALPHA)* *delete* deletes one or more backend buckets.'}},
                                                                                                      u'describe': {u'capsule': u'*(ALPHA)* Describe a backend bucket.',
                                                                                                                    u'commands': {},
                                                                                                                    u'flags': {},
                                                                                                                    u'group': False,
                                                                                                                    u'groups': {},
                                                                                                                    u'hidden': False,
                                                                                                                    u'name': u'describe',
                                                                                                                    u'path': [u'gcloud',
                                                                                                                              u'alpha',
                                                                                                                              u'compute',
                                                                                                                              u'backend-buckets',
                                                                                                                              u'describe'],
                                                                                                                    u'positionals': [{u'completer': u'',
                                                                                                                                      u'default': None,
                                                                                                                                      u'description': u'The name of the resource to fetch.',
                                                                                                                                      u'name': u'name',
                                                                                                                                      u'nargs': u'0',
                                                                                                                                      u'required': False,
                                                                                                                                      u'value': u'NAME'}],
                                                                                                                    u'release': u'ALPHA',
                                                                                                                    u'sections': {u'DESCRIPTION': u'*describe* displays all data associated with a backend bucket in a\nproject.\n'}},
                                                                                                      u'list': {u'capsule': u'*(ALPHA)* List Google Compute Engine backend buckets.',
                                                                                                                u'commands': {},
                                                                                                                u'flags': {u'--filter': {u'attr': {},
                                                                                                                                         u'category': u'LIST COMMAND',
                                                                                                                                         u'choices': [],
                                                                                                                                         u'completer': u'',
                                                                                                                                         u'default': None,
                                                                                                                                         u'description': u'Apply a Boolean filter _EXPRESSION_ to each resource item to be listed.\nIf the expression evaluates True then that item is listed. For more\ndetails and examples of filter expressions run $ gcloud topic filters. This\nflag interacts with other flags that are applied in this order: *--flatten*,\n*--sort-by*, *--filter*, *--limit*.',
                                                                                                                                         u'group': u'',
                                                                                                                                         u'hidden': False,
                                                                                                                                         u'name': u'--filter',
                                                                                                                                         u'nargs': u'0',
                                                                                                                                         u'required': False,
                                                                                                                                         u'type': u'string',
                                                                                                                                         u'value': u'EXPRESSION'},
                                                                                                                           u'--limit': {u'attr': {},
                                                                                                                                        u'category': u'LIST COMMAND',
                                                                                                                                        u'choices': [],
                                                                                                                                        u'completer': u'',
                                                                                                                                        u'default': None,
                                                                                                                                        u'description': u'The maximum number of resources to list. The default is *unlimited*.\nThis flag interacts with other flags that are applied in this order:\n*--flatten*, *--sort-by*, *--filter*, *--limit*.',
                                                                                                                                        u'group': u'',
                                                                                                                                        u'hidden': False,
                                                                                                                                        u'name': u'--limit',
                                                                                                                                        u'nargs': u'0',
                                                                                                                                        u'required': False,
                                                                                                                                        u'type': u'string',
                                                                                                                                        u'value': u'LIMIT'},
                                                                                                                           u'--no-uri': {u'attr': {},
                                                                                                                                         u'category': u'LIST COMMAND',
                                                                                                                                         u'choices': [],
                                                                                                                                         u'completer': u'',
                                                                                                                                         u'default': True,
                                                                                                                                         u'description': u'',
                                                                                                                                         u'group': u'',
                                                                                                                                         u'hidden': True,
                                                                                                                                         u'name': u'--no-uri',
                                                                                                                                         u'nargs': u'0',
                                                                                                                                         u'required': False,
                                                                                                                                         u'type': u'bool',
                                                                                                                                         u'value': u'NO_URI'},
                                                                                                                           u'--page-size': {u'attr': {},
                                                                                                                                            u'category': u'LIST COMMAND',
                                                                                                                                            u'choices': [],
                                                                                                                                            u'completer': u'',
                                                                                                                                            u'default': None,
                                                                                                                                            u'description': u'Some services group resource list output into pages. This flag specifies\nthe maximum number of resources per page. The default is determined by the\nservice if it supports paging, otherwise it is *unlimited* (no paging).\nPaging may be applied before or after *--filter* and *--limit* depending\non the service.',
                                                                                                                                            u'group': u'',
                                                                                                                                            u'hidden': False,
                                                                                                                                            u'name': u'--page-size',
                                                                                                                                            u'nargs': u'0',
                                                                                                                                            u'required': False,
                                                                                                                                            u'type': u'string',
                                                                                                                                            u'value': u'PAGE_SIZE'},
                                                                                                                           u'--regexp': {u'attr': {},
                                                                                                                                         u'category': u'',
                                                                                                                                         u'choices': [],
                                                                                                                                         u'completer': u'',
                                                                                                                                         u'default': None,
                                                                                                                                         u'description': u'A regular expression to filter the names of the results on. Any names\nthat do not match the entire regular expression will be filtered out.',
                                                                                                                                         u'group': u'',
                                                                                                                                         u'hidden': False,
                                                                                                                                         u'name': u'--regexp',
                                                                                                                                         u'nargs': u'0',
                                                                                                                                         u'required': False,
                                                                                                                                         u'type': u'string',
                                                                                                                                         u'value': u'REGEXP'},
                                                                                                                           u'--sort-by': {u'attr': {},
                                                                                                                                          u'category': u'LIST COMMAND',
                                                                                                                                          u'choices': [],
                                                                                                                                          u'completer': u'',
                                                                                                                                          u'default': None,
                                                                                                                                          u'description': u"A comma-separated list of resource field key names to sort by. The\ndefault order is ascending. Prefix a field with ``~'' for descending\norder on that field. This flag interacts with other flags that are applied\nin this order: *--flatten*, *--sort-by*, *--filter*, *--limit*.",
                                                                                                                                          u'group': u'',
                                                                                                                                          u'hidden': False,
                                                                                                                                          u'name': u'--sort-by',
                                                                                                                                          u'nargs': u'0',
                                                                                                                                          u'required': False,
                                                                                                                                          u'type': u'list',
                                                                                                                                          u'value': u'FIELD'},
                                                                                                                           u'--uri': {u'attr': {},
                                                                                                                                      u'category': u'LIST COMMAND',
                                                                                                                                      u'choices': [],
                                                                                                                                      u'completer': u'',
                                                                                                                                      u'default': False,
                                                                                                                                      u'description': u'Print a list of resource URIs instead of the default output.',
                                                                                                                                      u'group': u'',
                                                                                                                                      u'hidden': False,
                                                                                                                                      u'name': u'--uri',
                                                                                                                                      u'nargs': u'0',
                                                                                                                                      u'required': False,
                                                                                                                                      u'type': u'bool',
                                                                                                                                      u'value': u'URI'}},
                                                                                                                u'group': False,
                                                                                                                u'groups': {},
                                                                                                                u'hidden': False,
                                                                                                                u'name': u'list',
                                                                                                                u'path': [u'gcloud',
                                                                                                                          u'alpha',
                                                                                                                          u'compute',
                                                                                                                          u'backend-buckets',
                                                                                                                          u'list'],
                                                                                                                u'positionals': [{u'completer': u'',
                                                                                                                                  u'default': [],
                                                                                                                                  u'description': u'If provided, show details for the specified names and/or URIs of resources.',
                                                                                                                                  u'name': u'names',
                                                                                                                                  u'nargs': u'*',
                                                                                                                                  u'required': False,
                                                                                                                                  u'value': u'NAME'}],
                                                                                                                u'release': u'ALPHA',
                                                                                                                u'sections': {u'DESCRIPTION': u'*list* displays all Google Compute Engine backend buckets in a project.\n',
                                                                                                                              u'EXAMPLES': u'To list all backend buckets in a project in table form, run:\n\n  $ list\n\nTo list the URIs of all backend buckets in a project, run:\n\n  $ list --uri\n'}},
                                                                                                      u'update': {u'capsule': u'*(ALPHA)* Update a backend bucket.',
                                                                                                                  u'commands': {},
                                                                                                                  u'flags': {u'--description': {u'attr': {},
                                                                                                                                                u'category': u'',
                                                                                                                                                u'choices': [],
                                                                                                                                                u'completer': u'',
                                                                                                                                                u'default': None,
                                                                                                                                                u'description': u'An optional, textual description for the backend bucket.',
                                                                                                                                                u'group': u'',
                                                                                                                                                u'hidden': False,
                                                                                                                                                u'name': u'--description',
                                                                                                                                                u'nargs': u'0',
                                                                                                                                                u'required': False,
                                                                                                                                                u'type': u'string',
                                                                                                                                                u'value': u'DESCRIPTION'},
                                                                                                                             u'--enable-cdn': {u'attr': {},
                                                                                                                                               u'category': u'',
                                                                                                                                               u'choices': [],
                                                                                                                                               u'completer': u'',
                                                                                                                                               u'default': False,
                                                                                                                                               u'description': u'Enable Cloud CDN for the backend bucket. Cloud CDN can cache HTTP\nresponses from a backend bucket at the edge of the network, close to\nusers.',
                                                                                                                                               u'group': u'',
                                                                                                                                               u'hidden': False,
                                                                                                                                               u'name': u'--enable-cdn',
                                                                                                                                               u'nargs': u'0',
                                                                                                                                               u'required': False,
                                                                                                                                               u'type': u'bool',
                                                                                                                                               u'value': u'ENABLE_CDN'},
                                                                                                                             u'--gcs-bucket-name': {u'attr': {},
                                                                                                                                                    u'category': u'',
                                                                                                                                                    u'choices': [],
                                                                                                                                                    u'completer': u'',
                                                                                                                                                    u'default': None,
                                                                                                                                                    u'description': u"The name of the Google Cloud Storage bucket to serve from. The storage\n        bucket must be owned by the project's owner.",
                                                                                                                                                    u'group': u'',
                                                                                                                                                    u'hidden': False,
                                                                                                                                                    u'name': u'--gcs-bucket-name',
                                                                                                                                                    u'nargs': u'0',
                                                                                                                                                    u'required': False,
                                                                                                                                                    u'type': u'string',
                                                                                                                                                    u'value': u'GCS_BUCKET_NAME'},
                                                                                                                             u'--no-enable-cdn': {u'attr': {},
                                                                                                                                                  u'category': u'',
                                                                                                                                                  u'choices': [],
                                                                                                                                                  u'completer': u'',
                                                                                                                                                  u'default': False,
                                                                                                                                                  u'description': u'',
                                                                                                                                                  u'group': u'',
                                                                                                                                                  u'hidden': True,
                                                                                                                                                  u'name': u'--no-enable-cdn',
                                                                                                                                                  u'nargs': u'0',
                                                                                                                                                  u'required': False,
                                                                                                                                                  u'type': u'bool',
                                                                                                                                                  u'value': u'NO_ENABLE_CDN'}},
                                                                                                                  u'group': False,
                                                                                                                  u'groups': {},
                                                                                                                  u'hidden': False,
                                                                                                                  u'name': u'update',
                                                                                                                  u'path': [u'gcloud',
                                                                                                                            u'alpha',
                                                                                                                            u'compute',
                                                                                                                            u'backend-buckets',
                                                                                                                            u'update'],
                                                                                                                  u'positionals': [{u'completer': u'',
                                                                                                                                    u'default': None,
                                                                                                                                    u'description': u'The name of the backend bucket.',
                                                                                                                                    u'name': u'name',
                                                                                                                                    u'nargs': u'0',
                                                                                                                                    u'required': False,
                                                                                                                                    u'value': u'NAME'}],
                                                                                                                  u'release': u'ALPHA',
                                                                                                                  u'sections': {u'DESCRIPTION': u'\n*update* is used to update backend buckets.\n'}}},
                                                                                        u'flags': {},
                                                                                        u'group': True,
                                                                                        u'groups': {},
                                                                                        u'hidden': False,
                                                                                        u'name': u'backend-buckets',
                                                                                        u'path': [u'gcloud',
                                                                                                  u'alpha',
                                                                                                  u'compute',
                                                                                                  u'backend-buckets'],
                                                                                        u'positionals': [],
                                                                                        u'release': u'ALPHA',
                                                                                        u'sections': {u'DESCRIPTION': u'*(ALPHA)* Read and manipulate backend buckets.'}},
                                                                   u'backend-services': {u'capsule': u'*(ALPHA)* List, create, and delete backend services.',
                                                                                         u'commands': {u'add-backend': {u'capsule': u'*(ALPHA)* Add a backend to a backend service.',
                                                                                                                        u'commands': {},
                                                                                                                        u'flags': {u'--balancing-mode': {u'attr': {},
                                                                                                                                                         u'category': u'',
                                                                                                                                                         u'choices': [u'CONNECTION',
                                                                                                                                                                      u'RATE',
                                                                                                                                                                      u'UTILIZATION'],
                                                                                                                                                         u'completer': u'',
                                                                                                                                                         u'default': None,
                                                                                                                                                         u'description': u'Defines the strategy for balancing load.\n+\n*RATE* and the max rate arguments are available only\nin backend services with HTTP based protocols.\n+\nFor backend services with TCP/SSL protocol either *UTILIZATION* or\n*CONNECTION* are available.\n+\n_BALANCING_MODE_ must be one of:\n+\n*CONNECTION*:::           Spreads load based on how many concurrent connections the group\n          can handle. There are two ways to specify max connections:\n          *--max-connections* which defines the max number of connections\n          for the whole group or *--max-connections-per-instance*, which\n          defines the max number of connections on a per-instance basis.\n\n*RATE*:::           Spreads load based on how many requests per second (RPS) the group\n          can handle. There are two ways to specify max RPS: *--max-rate* which\n          defines the max RPS for the whole group or *--max-rate-per-instance*,\n          which defines the max RPS on a per-instance basis.\n\n*UTILIZATION*:::           Relies on the CPU utilization of the instances in the group when\n          balancing load. Use *--max-utilization* to set a maximum target CPU\n          utilization for each instance. Use *--max-rate-per-instance* or\n          *--max-rate* to optionally limit based on RPS in addition to CPU.\n          You can optionally also limit based on connections (for TCP/SSL) in\n          addition to CPU by setting *--max-connections* or\n          *--max-connections-per-instance*.\n\n+',
                                                                                                                                                         u'group': u'',
                                                                                                                                                         u'hidden': False,
                                                                                                                                                         u'name': u'--balancing-mode',
                                                                                                                                                         u'nargs': u'0',
                                                                                                                                                         u'required': False,
                                                                                                                                                         u'type': u'string',
                                                                                                                                                         u'value': u'BALANCING_MODE'},
                                                                                                                                   u'--capacity-scaler': {u'attr': {},
                                                                                                                                                          u'category': u'',
                                                                                                                                                          u'choices': [],
                                                                                                                                                          u'completer': u'',
                                                                                                                                                          u'default': None,
                                                                                                                                                          u'description': u"A float in the range [0.0, 1.0] that scales the maximum\nparameters for the group (e.g., max rate). A value of 0.0 will\ncause no requests to be sent to the group (i.e., it adds the\ngroup in a ``drained'' state).",
                                                                                                                                                          u'group': u'',
                                                                                                                                                          u'hidden': False,
                                                                                                                                                          u'name': u'--capacity-scaler',
                                                                                                                                                          u'nargs': u'0',
                                                                                                                                                          u'required': False,
                                                                                                                                                          u'type': u'string',
                                                                                                                                                          u'value': u'CAPACITY_SCALER'},
                                                                                                                                   u'--description': {u'attr': {},
                                                                                                                                                      u'category': u'',
                                                                                                                                                      u'choices': [],
                                                                                                                                                      u'completer': u'',
                                                                                                                                                      u'default': None,
                                                                                                                                                      u'description': u'An optional, textual description for the backend.',
                                                                                                                                                      u'group': u'',
                                                                                                                                                      u'hidden': False,
                                                                                                                                                      u'name': u'--description',
                                                                                                                                                      u'nargs': u'0',
                                                                                                                                                      u'required': False,
                                                                                                                                                      u'type': u'string',
                                                                                                                                                      u'value': u'DESCRIPTION'},
                                                                                                                                   u'--global': {u'attr': {},
                                                                                                                                                 u'category': u'',
                                                                                                                                                 u'choices': [],
                                                                                                                                                 u'completer': u'',
                                                                                                                                                 u'default': False,
                                                                                                                                                 u'description': u'If provided, it is assumed the backend service is global.',
                                                                                                                                                 u'group': u'add-backend.1',
                                                                                                                                                 u'hidden': False,
                                                                                                                                                 u'name': u'--global',
                                                                                                                                                 u'nargs': u'0',
                                                                                                                                                 u'required': False,
                                                                                                                                                 u'type': u'bool',
                                                                                                                                                 u'value': u'GLOBAL'},
                                                                                                                                   u'--instance-group': {u'attr': {},
                                                                                                                                                         u'category': u'',
                                                                                                                                                         u'choices': [],
                                                                                                                                                         u'completer': u'',
                                                                                                                                                         u'default': None,
                                                                                                                                                         u'description': u'The name of the instance group.',
                                                                                                                                                         u'group': u'',
                                                                                                                                                         u'hidden': False,
                                                                                                                                                         u'name': u'--instance-group',
                                                                                                                                                         u'nargs': u'0',
                                                                                                                                                         u'required': True,
                                                                                                                                                         u'type': u'string',
                                                                                                                                                         u'value': u'INSTANCE_GROUP'},
                                                                                                                                   u'--instance-group-region': {u'attr': {u'property': {u'name': u'compute/region'}},
                                                                                                                                                                u'category': u'',
                                                                                                                                                                u'choices': [],
                                                                                                                                                                u'completer': u'',
                                                                                                                                                                u'default': None,
                                                                                                                                                                u'description': u"The region of the instance group to add. If not specified, you will be prompted to select a region.\n+\nTo avoid prompting when this flag is omitted, you can set the\n``compute/region'' property:\n+\n  $ gcloud config set compute/region REGION\n+\nA list of regions can be fetched by running:\n+\n  $ gcloud compute regions list\n+\nTo unset the property, run:\n+\n  $ gcloud config unset compute/region\n+\nAlternatively, the region can be stored in the environment\nvariable ``CLOUDSDK_COMPUTE_REGION''.",
                                                                                                                                                                u'group': u'add-backend.2',
                                                                                                                                                                u'hidden': False,
                                                                                                                                                                u'name': u'--instance-group-region',
                                                                                                                                                                u'nargs': u'0',
                                                                                                                                                                u'required': False,
                                                                                                                                                                u'type': u'string',
                                                                                                                                                                u'value': u'INSTANCE_GROUP_REGION'},
                                                                                                                                   u'--instance-group-zone': {u'attr': {u'property': {u'name': u'compute/zone'}},
                                                                                                                                                              u'category': u'',
                                                                                                                                                              u'choices': [],
                                                                                                                                                              u'completer': u'',
                                                                                                                                                              u'default': None,
                                                                                                                                                              u'description': u"The zone of the instance group to add. If not specified, you will be prompted to select a zone.\n+\nTo avoid prompting when this flag is omitted, you can set the\n``compute/zone'' property:\n+\n  $ gcloud config set compute/zone ZONE\n+\nA list of zones can be fetched by running:\n+\n  $ gcloud compute zones list\n+\nTo unset the property, run:\n+\n  $ gcloud config unset compute/zone\n+\nAlternatively, the zone can be stored in the environment variable\n``CLOUDSDK_COMPUTE_ZONE''.",
                                                                                                                                                              u'group': u'add-backend.2',
                                                                                                                                                              u'hidden': False,
                                                                                                                                                              u'name': u'--instance-group-zone',
                                                                                                                                                              u'nargs': u'0',
                                                                                                                                                              u'required': False,
                                                                                                                                                              u'type': u'string',
                                                                                                                                                              u'value': u'INSTANCE_GROUP_ZONE'},
                                                                                                                                   u'--max-connections': {u'attr': {},
                                                                                                                                                          u'category': u'',
                                                                                                                                                          u'choices': [],
                                                                                                                                                          u'completer': u'',
                                                                                                                                                          u'default': None,
                                                                                                                                                          u'description': u'Maximum concurrent connections that the group can handle.',
                                                                                                                                                          u'group': u'add-backend.3',
                                                                                                                                                          u'hidden': False,
                                                                                                                                                          u'name': u'--max-connections',
                                                                                                                                                          u'nargs': u'0',
                                                                                                                                                          u'required': False,
                                                                                                                                                          u'type': u'string',
                                                                                                                                                          u'value': u'MAX_CONNECTIONS'},
                                                                                                                                   u'--max-connections-per-instance': {u'attr': {},
                                                                                                                                                                       u'category': u'',
                                                                                                                                                                       u'choices': [],
                                                                                                                                                                       u'completer': u'',
                                                                                                                                                                       u'default': None,
                                                                                                                                                                       u'description': u'The maximum concurrent connections per-instance.',
                                                                                                                                                                       u'group': u'add-backend.3',
                                                                                                                                                                       u'hidden': False,
                                                                                                                                                                       u'name': u'--max-connections-per-instance',
                                                                                                                                                                       u'nargs': u'0',
                                                                                                                                                                       u'required': False,
                                                                                                                                                                       u'type': u'string',
                                                                                                                                                                       u'value': u'MAX_CONNECTIONS_PER_INSTANCE'},
                                                                                                                                   u'--max-rate': {u'attr': {},
                                                                                                                                                   u'category': u'',
                                                                                                                                                   u'choices': [],
                                                                                                                                                   u'completer': u'',
                                                                                                                                                   u'default': None,
                                                                                                                                                   u'description': u'Maximum requests per second (RPS) that the group can handle.',
                                                                                                                                                   u'group': u'add-backend.3',
                                                                                                                                                   u'hidden': False,
                                                                                                                                                   u'name': u'--max-rate',
                                                                                                                                                   u'nargs': u'0',
                                                                                                                                                   u'required': False,
                                                                                                                                                   u'type': u'string',
                                                                                                                                                   u'value': u'MAX_RATE'},
                                                                                                                                   u'--max-rate-per-instance': {u'attr': {},
                                                                                                                                                                u'category': u'',
                                                                                                                                                                u'choices': [],
                                                                                                                                                                u'completer': u'',
                                                                                                                                                                u'default': None,
                                                                                                                                                                u'description': u'The maximum per-instance requests per second (RPS).',
                                                                                                                                                                u'group': u'add-backend.3',
                                                                                                                                                                u'hidden': False,
                                                                                                                                                                u'name': u'--max-rate-per-instance',
                                                                                                                                                                u'nargs': u'0',
                                                                                                                                                                u'required': False,
                                                                                                                                                                u'type': u'string',
                                                                                                                                                                u'value': u'MAX_RATE_PER_INSTANCE'},
                                                                                                                                   u'--max-utilization': {u'attr': {},
                                                                                                                                                          u'category': u'',
                                                                                                                                                          u'choices': [],
                                                                                                                                                          u'completer': u'',
                                                                                                                                                          u'default': None,
                                                                                                                                                          u'description': u'The target CPU utilization for the group as a float in the range\n[0.0, 1.0]. This flag can only be provided when the balancing\nmode is *UTILIZATION*.',
                                                                                                                                                          u'group': u'',
                                                                                                                                                          u'hidden': False,
                                                                                                                                                          u'name': u'--max-utilization',
                                                                                                                                                          u'nargs': u'0',
                                                                                                                                                          u'required': False,
                                                                                                                                                          u'type': u'string',
                                                                                                                                                          u'value': u'MAX_UTILIZATION'},
                                                                                                                                   u'--region': {u'attr': {u'property': {u'name': u'compute/region'}},
                                                                                                                                                 u'category': u'',
                                                                                                                                                 u'choices': [],
                                                                                                                                                 u'completer': u'',
                                                                                                                                                 u'default': None,
                                                                                                                                                 u'description': u'The region of the backend service to operate on. Overrides the default *compute/region* property value for this command invocation.',
                                                                                                                                                 u'group': u'add-backend.1',
                                                                                                                                                 u'hidden': False,
                                                                                                                                                 u'name': u'--region',
                                                                                                                                                 u'nargs': u'0',
                                                                                                                                                 u'required': False,
                                                                                                                                                 u'type': u'string',
                                                                                                                                                 u'value': u'REGION'}},
                                                                                                                        u'group': False,
                                                                                                                        u'groups': {u'add-backend.1': {u'description': u'At most one of these may be specified:',
                                                                                                                                                       u'is_mutex': True,
                                                                                                                                                       u'is_required': False},
                                                                                                                                    u'add-backend.2': {u'description': u'At most one of these may be specified:',
                                                                                                                                                       u'is_mutex': True,
                                                                                                                                                       u'is_required': False},
                                                                                                                                    u'add-backend.3': {u'description': u'At most one of these may be specified:',
                                                                                                                                                       u'is_mutex': True,
                                                                                                                                                       u'is_required': False}},
                                                                                                                        u'hidden': False,
                                                                                                                        u'name': u'add-backend',
                                                                                                                        u'path': [u'gcloud',
                                                                                                                                  u'alpha',
                                                                                                                                  u'compute',
                                                                                                                                  u'backend-services',
                                                                                                                                  u'add-backend'],
                                                                                                                        u'positionals': [{u'completer': u'',
                                                                                                                                          u'default': None,
                                                                                                                                          u'description': u'The name of the backend service.',
                                                                                                                                          u'name': u'name',
                                                                                                                                          u'nargs': u'0',
                                                                                                                                          u'required': False,
                                                                                                                                          u'value': u'NAME'}],
                                                                                                                        u'release': u'ALPHA',
                                                                                                                        u'sections': {u'DESCRIPTION': u'\n*add-backend* is used to add a backend to a backend service. A\nbackend is a group of tasks that can handle requests sent to a\nbackend service. Currently, the group of tasks can be one or\nmore Google Compute Engine virtual machine instances grouped\ntogether using an instance group.\n\nTraffic is first spread evenly across all virtual machines in\nthe group. When the group is full, traffic is sent to the next\nnearest group(s) that still have remaining capacity.\n\nTo modify the parameters of a backend after it has been added\nto the backend service, use\n`gcloud compute backend-services update-backend` or\n`gcloud compute backend-services edit`.\n'}},
                                                                                                       u'create': {u'capsule': u'*(ALPHA)* Create a backend service.',
                                                                                                                   u'commands': {},
                                                                                                                   u'flags': {u'--affinity-cookie-ttl': {u'attr': {},
                                                                                                                                                         u'category': u'',
                                                                                                                                                         u'choices': [],
                                                                                                                                                         u'completer': u'',
                                                                                                                                                         u'default': None,
                                                                                                                                                         u'description': u'If session-affinity is set to "generated_cookie", this flag sets\nthe TTL, in seconds, of the resulting cookie.  A setting of 0\nindicates that the cookie should be transient.',
                                                                                                                                                         u'group': u'',
                                                                                                                                                         u'hidden': False,
                                                                                                                                                         u'name': u'--affinity-cookie-ttl',
                                                                                                                                                         u'nargs': u'0',
                                                                                                                                                         u'required': False,
                                                                                                                                                         u'type': u'string',
                                                                                                                                                         u'value': u'AFFINITY_COOKIE_TTL'},
                                                                                                                              u'--cache-key-include-host': {u'attr': {u'inverted_synopsis': True},
                                                                                                                                                            u'category': u'',
                                                                                                                                                            u'choices': [],
                                                                                                                                                            u'completer': u'',
                                                                                                                                                            u'default': True,
                                                                                                                                                            u'description': u'Enable including host in cache key. If enabled, requests to different\nhosts will be cached separately. Can only be applied for global resources. Enabled by default, use *--no-cache-key-include-host* to disable.',
                                                                                                                                                            u'group': u'',
                                                                                                                                                            u'hidden': False,
                                                                                                                                                            u'name': u'--cache-key-include-host',
                                                                                                                                                            u'nargs': u'0',
                                                                                                                                                            u'required': False,
                                                                                                                                                            u'type': u'bool',
                                                                                                                                                            u'value': u'CACHE_KEY_INCLUDE_HOST'},
                                                                                                                              u'--cache-key-include-protocol': {u'attr': {u'inverted_synopsis': True},
                                                                                                                                                                u'category': u'',
                                                                                                                                                                u'choices': [],
                                                                                                                                                                u'completer': u'',
                                                                                                                                                                u'default': True,
                                                                                                                                                                u'description': u'Enable including protocol in cache key. If enabled, http and https\nrequests will be cached separately. Can only be applied for global\nresources. Enabled by default, use *--no-cache-key-include-protocol* to disable.',
                                                                                                                                                                u'group': u'',
                                                                                                                                                                u'hidden': False,
                                                                                                                                                                u'name': u'--cache-key-include-protocol',
                                                                                                                                                                u'nargs': u'0',
                                                                                                                                                                u'required': False,
                                                                                                                                                                u'type': u'bool',
                                                                                                                                                                u'value': u'CACHE_KEY_INCLUDE_PROTOCOL'},
                                                                                                                              u'--cache-key-include-query-string': {u'attr': {u'inverted_synopsis': True},
                                                                                                                                                                    u'category': u'',
                                                                                                                                                                    u'choices': [],
                                                                                                                                                                    u'completer': u'',
                                                                                                                                                                    u'default': True,
                                                                                                                                                                    u'description': u'Enable including query string in cache key. If enabled, the query string\nparameters will be included according to\n--cache-key-query-string-whitelist and\n--cache-key-query-string-blacklist. If neither is set, the entire query\nstring will be included. If disabled, then the entire query string will\nbe excluded. Can only be applied for global resources. Enabled by default, use *--no-cache-key-include-query-string* to disable.',
                                                                                                                                                                    u'group': u'',
                                                                                                                                                                    u'hidden': False,
                                                                                                                                                                    u'name': u'--cache-key-include-query-string',
                                                                                                                                                                    u'nargs': u'0',
                                                                                                                                                                    u'required': False,
                                                                                                                                                                    u'type': u'bool',
                                                                                                                                                                    u'value': u'CACHE_KEY_INCLUDE_QUERY_STRING'},
                                                                                                                              u'--cache-key-query-string-blacklist': {u'attr': {},
                                                                                                                                                                      u'category': u'',
                                                                                                                                                                      u'choices': [],
                                                                                                                                                                      u'completer': u'',
                                                                                                                                                                      u'default': None,
                                                                                                                                                                      u'description': u"Specifies a comma separated list of query string parameters to exclude\nin cache keys. All other parameters will be included. Either specify\n--cache-key-query-string-whitelist or --cache-key-query-string-blacklist,\nnot both. '&' and '=' will be percent encoded and not treated as\ndelimiters. Can only be applied for global resources.",
                                                                                                                                                                      u'group': u'create.1',
                                                                                                                                                                      u'hidden': False,
                                                                                                                                                                      u'name': u'--cache-key-query-string-blacklist',
                                                                                                                                                                      u'nargs': u'0',
                                                                                                                                                                      u'required': False,
                                                                                                                                                                      u'type': u'list',
                                                                                                                                                                      u'value': u'QUERY_STRING'},
                                                                                                                              u'--cache-key-query-string-whitelist': {u'attr': {},
                                                                                                                                                                      u'category': u'',
                                                                                                                                                                      u'choices': [],
                                                                                                                                                                      u'completer': u'',
                                                                                                                                                                      u'default': None,
                                                                                                                                                                      u'description': u"Specifies a comma separated list of query string parameters to include\nin cache keys. All other parameters will be excluded. Either specify\n--cache-key-query-string-whitelist or --cache-key-query-string-blacklist,\nnot both. '&' and '=' will be percent encoded and not treated as\ndelimiters. Can only be applied for global resources.",
                                                                                                                                                                      u'group': u'create.1',
                                                                                                                                                                      u'hidden': False,
                                                                                                                                                                      u'name': u'--cache-key-query-string-whitelist',
                                                                                                                                                                      u'nargs': u'0',
                                                                                                                                                                      u'required': False,
                                                                                                                                                                      u'type': u'list',
                                                                                                                                                                      u'value': u'QUERY_STRING'},
                                                                                                                              u'--connection-draining-timeout': {u'attr': {},
                                                                                                                                                                 u'category': u'',
                                                                                                                                                                 u'choices': [],
                                                                                                                                                                 u'completer': u'',
                                                                                                                                                                 u'default': None,
                                                                                                                                                                 u'description': u'Connection draining timeout to be used during removal of VMs from\ninstance groups. This guarantees that for the specified time all existing\nconnections to a VM will remain untouched, but no new connections will be\naccepted. Set timeout to zero to disable connection draining. Enable\nfeature by specifying a timeout of up to one hour.\nIf the flag is omitted API default value (0s) will be used.\nValid units for this flag are `s` for seconds, `m` for minutes, and\n`h` for hours.',
                                                                                                                                                                 u'group': u'',
                                                                                                                                                                 u'hidden': False,
                                                                                                                                                                 u'name': u'--connection-draining-timeout',
                                                                                                                                                                 u'nargs': u'0',
                                                                                                                                                                 u'required': False,
                                                                                                                                                                 u'type': u'string',
                                                                                                                                                                 u'value': u'CONNECTION_DRAINING_TIMEOUT'},
                                                                                                                              u'--description': {u'attr': {},
                                                                                                                                                 u'category': u'',
                                                                                                                                                 u'choices': [],
                                                                                                                                                 u'completer': u'',
                                                                                                                                                 u'default': None,
                                                                                                                                                 u'description': u'An optional, textual description for the backend service.',
                                                                                                                                                 u'group': u'',
                                                                                                                                                 u'hidden': False,
                                                                                                                                                 u'name': u'--description',
                                                                                                                                                 u'nargs': u'0',
                                                                                                                                                 u'required': False,
                                                                                                                                                 u'type': u'string',
                                                                                                                                                 u'value': u'DESCRIPTION'},
                                                                                                                              u'--enable-cdn': {u'attr': {},
                                                                                                                                                u'category': u'',
                                                                                                                                                u'choices': [],
                                                                                                                                                u'completer': u'',
                                                                                                                                                u'default': False,
                                                                                                                                                u'description': u'Enable Cloud CDN for the backend service. Cloud CDN can cache HTTP\nresponses from a backend service at the edge of the network, close to\nusers. Cloud CDN is disabled by default.',
                                                                                                                                                u'group': u'',
                                                                                                                                                u'hidden': False,
                                                                                                                                                u'name': u'--enable-cdn',
                                                                                                                                                u'nargs': u'0',
                                                                                                                                                u'required': False,
                                                                                                                                                u'type': u'bool',
                                                                                                                                                u'value': u'ENABLE_CDN'},
                                                                                                                              u'--global': {u'attr': {},
                                                                                                                                            u'category': u'',
                                                                                                                                            u'choices': [],
                                                                                                                                            u'completer': u'',
                                                                                                                                            u'default': False,
                                                                                                                                            u'description': u'If provided, it is assumed the backend service is global.',
                                                                                                                                            u'group': u'create.2',
                                                                                                                                            u'hidden': False,
                                                                                                                                            u'name': u'--global',
                                                                                                                                            u'nargs': u'0',
                                                                                                                                            u'required': False,
                                                                                                                                            u'type': u'bool',
                                                                                                                                            u'value': u'GLOBAL'},
                                                                                                                              u'--health-checks': {u'attr': {},
                                                                                                                                                   u'category': u'',
                                                                                                                                                   u'choices': [],
                                                                                                                                                   u'completer': u'',
                                                                                                                                                   u'default': None,
                                                                                                                                                   u'description': u'Specifies a list of health check objects for checking the health of\nthe backend service. Health checks need not be for the same protocol\nas that of the backend service.',
                                                                                                                                                   u'group': u'',
                                                                                                                                                   u'hidden': False,
                                                                                                                                                   u'name': u'--health-checks',
                                                                                                                                                   u'nargs': u'0',
                                                                                                                                                   u'required': False,
                                                                                                                                                   u'type': u'list',
                                                                                                                                                   u'value': u'HEALTH_CHECK'},
                                                                                                                              u'--http-health-checks': {u'attr': {},
                                                                                                                                                        u'category': u'',
                                                                                                                                                        u'choices': [],
                                                                                                                                                        u'completer': u'',
                                                                                                                                                        u'default': None,
                                                                                                                                                        u'description': u'Specifies a list of HTTP health check objects for checking the health\nof the backend service.',
                                                                                                                                                        u'group': u'',
                                                                                                                                                        u'hidden': False,
                                                                                                                                                        u'name': u'--http-health-checks',
                                                                                                                                                        u'nargs': u'0',
                                                                                                                                                        u'required': False,
                                                                                                                                                        u'type': u'list',
                                                                                                                                                        u'value': u'HTTP_HEALTH_CHECK'},
                                                                                                                              u'--https-health-checks': {u'attr': {},
                                                                                                                                                         u'category': u'',
                                                                                                                                                         u'choices': [],
                                                                                                                                                         u'completer': u'',
                                                                                                                                                         u'default': None,
                                                                                                                                                         u'description': u'Specifies a list of HTTPS health check objects for checking the health\nof the backend service.',
                                                                                                                                                         u'group': u'',
                                                                                                                                                         u'hidden': False,
                                                                                                                                                         u'name': u'--https-health-checks',
                                                                                                                                                         u'nargs': u'0',
                                                                                                                                                         u'required': False,
                                                                                                                                                         u'type': u'list',
                                                                                                                                                         u'value': u'HTTPS_HEALTH_CHECK'},
                                                                                                                              u'--iap': {u'attr': {},
                                                                                                                                         u'category': u'',
                                                                                                                                         u'choices': [],
                                                                                                                                         u'completer': u'',
                                                                                                                                         u'default': None,
                                                                                                                                         u'description': u"Configure Identity Aware Proxy (IAP) service. You can configure IAP to be\n'enabled' or 'disabled' (default). If it is enabled you can provide values\nfor 'oauth2-client-id' and 'oauth2-client-secret'. For example,\n'--iap=enabled,oauth2-client-id=foo,oauth2-client-secret=bar' will\nturn IAP on, and '--iap=disabled' will turn it off. See\nhttps://cloud.google.com/iap/ for more information about this feature.",
                                                                                                                                         u'group': u'',
                                                                                                                                         u'hidden': False,
                                                                                                                                         u'name': u'--iap',
                                                                                                                                         u'nargs': u'0',
                                                                                                                                         u'required': False,
                                                                                                                                         u'type': u'string',
                                                                                                                                         u'value': u'disabled|enabled,[oauth2-client-id=OAUTH2-CLIENT-ID,oauth2-client-secret=OAUTH2-CLIENT-SECRET]'},
                                                                                                                              u'--load-balancing-scheme': {u'attr': {},
                                                                                                                                                           u'category': u'',
                                                                                                                                                           u'choices': [u'INTERNAL',
                                                                                                                                                                        u'EXTERNAL'],
                                                                                                                                                           u'completer': u'',
                                                                                                                                                           u'default': u'EXTERNAL',
                                                                                                                                                           u'description': u'Specifies if this is internal or external load balancer. _LOAD_BALANCING_SCHEME_ must be one of: *INTERNAL*, *EXTERNAL*.',
                                                                                                                                                           u'group': u'',
                                                                                                                                                           u'hidden': False,
                                                                                                                                                           u'name': u'--load-balancing-scheme',
                                                                                                                                                           u'nargs': u'0',
                                                                                                                                                           u'required': False,
                                                                                                                                                           u'type': u'string',
                                                                                                                                                           u'value': u'LOAD_BALANCING_SCHEME'},
                                                                                                                              u'--no-cache-key-include-host': {u'attr': {},
                                                                                                                                                               u'category': u'',
                                                                                                                                                               u'choices': [],
                                                                                                                                                               u'completer': u'',
                                                                                                                                                               u'default': True,
                                                                                                                                                               u'description': u'',
                                                                                                                                                               u'group': u'',
                                                                                                                                                               u'hidden': True,
                                                                                                                                                               u'name': u'--no-cache-key-include-host',
                                                                                                                                                               u'nargs': u'0',
                                                                                                                                                               u'required': False,
                                                                                                                                                               u'type': u'bool',
                                                                                                                                                               u'value': u'NO_CACHE_KEY_INCLUDE_HOST'},
                                                                                                                              u'--no-cache-key-include-protocol': {u'attr': {},
                                                                                                                                                                   u'category': u'',
                                                                                                                                                                   u'choices': [],
                                                                                                                                                                   u'completer': u'',
                                                                                                                                                                   u'default': True,
                                                                                                                                                                   u'description': u'',
                                                                                                                                                                   u'group': u'',
                                                                                                                                                                   u'hidden': True,
                                                                                                                                                                   u'name': u'--no-cache-key-include-protocol',
                                                                                                                                                                   u'nargs': u'0',
                                                                                                                                                                   u'required': False,
                                                                                                                                                                   u'type': u'bool',
                                                                                                                                                                   u'value': u'NO_CACHE_KEY_INCLUDE_PROTOCOL'},
                                                                                                                              u'--no-cache-key-include-query-string': {u'attr': {},
                                                                                                                                                                       u'category': u'',
                                                                                                                                                                       u'choices': [],
                                                                                                                                                                       u'completer': u'',
                                                                                                                                                                       u'default': True,
                                                                                                                                                                       u'description': u'',
                                                                                                                                                                       u'group': u'',
                                                                                                                                                                       u'hidden': True,
                                                                                                                                                                       u'name': u'--no-cache-key-include-query-string',
                                                                                                                                                                       u'nargs': u'0',
                                                                                                                                                                       u'required': False,
                                                                                                                                                                       u'type': u'bool',
                                                                                                                                                                       u'value': u'NO_CACHE_KEY_INCLUDE_QUERY_STRING'},
                                                                                                                              u'--no-enable-cdn': {u'attr': {},
                                                                                                                                                   u'category': u'',
                                                                                                                                                   u'choices': [],
                                                                                                                                                   u'completer': u'',
                                                                                                                                                   u'default': False,
                                                                                                                                                   u'description': u'',
                                                                                                                                                   u'group': u'',
                                                                                                                                                   u'hidden': True,
                                                                                                                                                   u'name': u'--no-enable-cdn',
                                                                                                                                                   u'nargs': u'0',
                                                                                                                                                   u'required': False,
                                                                                                                                                   u'type': u'bool',
                                                                                                                                                   u'value': u'NO_ENABLE_CDN'},
                                                                                                                              u'--port': {u'attr': {},
                                                                                                                                          u'category': u'',
                                                                                                                                          u'choices': [],
                                                                                                                                          u'completer': u'',
                                                                                                                                          u'default': None,
                                                                                                                                          u'description': u'The TCP port to use when connecting to the backend. --port is being deprecated in favor of --port-name.',
                                                                                                                                          u'group': u'',
                                                                                                                                          u'hidden': False,
                                                                                                                                          u'name': u'--port',
                                                                                                                                          u'nargs': u'0',
                                                                                                                                          u'required': False,
                                                                                                                                          u'type': u'string',
                                                                                                                                          u'value': u'PORT'},
                                                                                                                              u'--port-name': {u'attr': {},
                                                                                                                                               u'category': u'',
                                                                                                                                               u'choices': [],
                                                                                                                                               u'completer': u'',
                                                                                                                                               u'default': None,
                                                                                                                                               u'description': u"The name of a service that has been added to an instance group\nin this backend. Instance group services map a name to a port\nnumber which is used by the load balancing service.\nOnly one ``port-name'' may be added to a backend service, and that\nname must exist as a service on all instance groups that are a\npart of this backend service. The port number associated with the\nname may differ between instances. If you do not specify\nthis flag, your instance groups must have a service named ``http''\nconfigured. See also\n`gcloud compute instance-groups set-named-ports --help`.",
                                                                                                                                               u'group': u'',
                                                                                                                                               u'hidden': False,
                                                                                                                                               u'name': u'--port-name',
                                                                                                                                               u'nargs': u'0',
                                                                                                                                               u'required': False,
                                                                                                                                               u'type': u'string',
                                                                                                                                               u'value': u'PORT_NAME'},
                                                                                                                              u'--protocol': {u'attr': {},
                                                                                                                                              u'category': u'',
                                                                                                                                              u'choices': [u'HTTP',
                                                                                                                                                           u'HTTPS',
                                                                                                                                                           u'SSL',
                                                                                                                                                           u'TCP',
                                                                                                                                                           u'UDP'],
                                                                                                                                              u'completer': u'',
                                                                                                                                              u'default': None,
                                                                                                                                              u'description': u'The protocol for incoming requests. _PROTOCOL_ must be one of: *HTTP*, *HTTPS*, *SSL*, *TCP*, *UDP*.',
                                                                                                                                              u'group': u'',
                                                                                                                                              u'hidden': False,
                                                                                                                                              u'name': u'--protocol',
                                                                                                                                              u'nargs': u'0',
                                                                                                                                              u'required': False,
                                                                                                                                              u'type': u'string',
                                                                                                                                              u'value': u'PROTOCOL'},
                                                                                                                              u'--region': {u'attr': {u'property': {u'name': u'compute/region'}},
                                                                                                                                            u'category': u'',
                                                                                                                                            u'choices': [],
                                                                                                                                            u'completer': u'',
                                                                                                                                            u'default': None,
                                                                                                                                            u'description': u'The region of the backend service to operate on. Overrides the default *compute/region* property value for this command invocation.',
                                                                                                                                            u'group': u'create.2',
                                                                                                                                            u'hidden': False,
                                                                                                                                            u'name': u'--region',
                                                                                                                                            u'nargs': u'0',
                                                                                                                                            u'required': False,
                                                                                                                                            u'type': u'string',
                                                                                                                                            u'value': u'REGION'},
                                                                                                                              u'--session-affinity': {u'attr': {},
                                                                                                                                                      u'category': u'',
                                                                                                                                                      u'choices': [u'CLIENT_IP',
                                                                                                                                                                   u'CLIENT_IP_PORT_PROTO',
                                                                                                                                                                   u'CLIENT_IP_PROTO',
                                                                                                                                                                   u'GENERATED_COOKIE',
                                                                                                                                                                   u'NONE'],
                                                                                                                                                      u'completer': u'',
                                                                                                                                                      u'default': None,
                                                                                                                                                      u'description': u'The type of session affinity to use for this backend service. _SESSION_AFFINITY_ must be one of:\n+\n*CLIENT_IP*::: Route requests to instances based on the hash of the client\'s IP address.\n*CLIENT_IP_PORT_PROTO*::: Connections from the same client IP with the same IP protocol and port will go to the same VM in the backend while that VM remains healthy. This option cannot be used for HTTP(S) load balancing.\n*CLIENT_IP_PROTO*::: Connections from the same client IP with the same IP protocol willgo to the same VM in the pool while that VM remains healthy. This option cannot be used for HTTP(s) load balancing.\n*GENERATED_COOKIE*::: Route requests to instances based on the contents of the "GCLB" cookie set by the load balancer.\n*NONE*::: Session affinity is disabled.\n+',
                                                                                                                                                      u'group': u'',
                                                                                                                                                      u'hidden': False,
                                                                                                                                                      u'name': u'--session-affinity',
                                                                                                                                                      u'nargs': u'0',
                                                                                                                                                      u'required': False,
                                                                                                                                                      u'type': u'string',
                                                                                                                                                      u'value': u'SESSION_AFFINITY'},
                                                                                                                              u'--timeout': {u'attr': {},
                                                                                                                                             u'category': u'',
                                                                                                                                             u'choices': [],
                                                                                                                                             u'completer': u'',
                                                                                                                                             u'default': u'30s',
                                                                                                                                             u'description': u"The amount of time to wait for a backend to respond to a request\nbefore considering the request failed. For example, specifying\n``10s'' will give backends 10 seconds to respond to\nrequests. Valid units for this flag are ``s'' for seconds, ``m''\nfor minutes, and ``h'' for hours.",
                                                                                                                                             u'group': u'',
                                                                                                                                             u'hidden': False,
                                                                                                                                             u'name': u'--timeout',
                                                                                                                                             u'nargs': u'0',
                                                                                                                                             u'required': False,
                                                                                                                                             u'type': u'string',
                                                                                                                                             u'value': u'TIMEOUT'}},
                                                                                                                   u'group': False,
                                                                                                                   u'groups': {u'create.1': {u'description': u'At most one of these may be specified:',
                                                                                                                                             u'is_mutex': True,
                                                                                                                                             u'is_required': False},
                                                                                                                               u'create.2': {u'description': u'At most one of these may be specified:',
                                                                                                                                             u'is_mutex': True,
                                                                                                                                             u'is_required': False}},
                                                                                                                   u'hidden': False,
                                                                                                                   u'name': u'create',
                                                                                                                   u'path': [u'gcloud',
                                                                                                                             u'alpha',
                                                                                                                             u'compute',
                                                                                                                             u'backend-services',
                                                                                                                             u'create'],
                                                                                                                   u'positionals': [{u'completer': u'',
                                                                                                                                     u'default': None,
                                                                                                                                     u'description': u'The name of the backend service.',
                                                                                                                                     u'name': u'name',
                                                                                                                                     u'nargs': u'0',
                                                                                                                                     u'required': False,
                                                                                                                                     u'value': u'NAME'}],
                                                                                                                   u'release': u'ALPHA',
                                                                                                                   u'sections': {u'DESCRIPTION': u"\n*create* is used to create backend services. Backend\nservices define groups of backends that can receive\ntraffic. Each backend group has parameters that define the\ngroup's capacity (e.g., max CPU utilization, max queries per\nsecond, ...). URL maps define which requests are sent to which\nbackend services.\n\nBackend services created through this command will start out\nwithout any backend groups. To add backend groups, use 'gcloud\ncompute backend-services add-backend' or 'gcloud compute\nbackend-services edit'.\n"}},
                                                                                                       u'delete': {u'capsule': u'*(ALPHA)* Delete backend services.',
                                                                                                                   u'commands': {},
                                                                                                                   u'flags': {u'--global': {u'attr': {},
                                                                                                                                            u'category': u'',
                                                                                                                                            u'choices': [],
                                                                                                                                            u'completer': u'',
                                                                                                                                            u'default': False,
                                                                                                                                            u'description': u'If provided, it is assumed the backend service is global.',
                                                                                                                                            u'group': u'delete.1',
                                                                                                                                            u'hidden': False,
                                                                                                                                            u'name': u'--global',
                                                                                                                                            u'nargs': u'0',
                                                                                                                                            u'required': False,
                                                                                                                                            u'type': u'bool',
                                                                                                                                            u'value': u'GLOBAL'},
                                                                                                                              u'--region': {u'attr': {u'property': {u'name': u'compute/region'}},
                                                                                                                                            u'category': u'',
                                                                                                                                            u'choices': [],
                                                                                                                                            u'completer': u'',
                                                                                                                                            u'default': None,
                                                                                                                                            u'description': u'The region of the backend service to operate on. Overrides the default *compute/region* property value for this command invocation.',
                                                                                                                                            u'group': u'delete.1',
                                                                                                                                            u'hidden': False,
                                                                                                                                            u'name': u'--region',
                                                                                                                                            u'nargs': u'0',
                                                                                                                                            u'required': False,
                                                                                                                                            u'type': u'string',
                                                                                                                                            u'value': u'REGION'}},
                                                                                                                   u'group': False,
                                                                                                                   u'groups': {u'delete.1': {u'description': u'At most one of these may be specified:',
                                                                                                                                             u'is_mutex': True,
                                                                                                                                             u'is_required': False}},
                                                                                                                   u'hidden': False,
                                                                                                                   u'name': u'delete',
                                                                                                                   u'path': [u'gcloud',
                                                                                                                             u'alpha',
                                                                                                                             u'compute',
                                                                                                                             u'backend-services',
                                                                                                                             u'delete'],
                                                                                                                   u'positionals': [{u'completer': u'',
                                                                                                                                     u'default': None,
                                                                                                                                     u'description': u'The names of the backend services.',
                                                                                                                                     u'name': u'name',
                                                                                                                                     u'nargs': u'+',
                                                                                                                                     u'required': False,
                                                                                                                                     u'value': u'NAME'}],
                                                                                                                   u'release': u'ALPHA',
                                                                                                                   u'sections': {u'DESCRIPTION': u'*(ALPHA)* *delete* deletes one or more backend services.'}},
                                                                                                       u'describe': {u'capsule': u'*(ALPHA)* Display detailed information about a backend service.',
                                                                                                                     u'commands': {},
                                                                                                                     u'flags': {u'--global': {u'attr': {},
                                                                                                                                              u'category': u'',
                                                                                                                                              u'choices': [],
                                                                                                                                              u'completer': u'',
                                                                                                                                              u'default': False,
                                                                                                                                              u'description': u'If provided, it is assumed that the requested resource is global.',
                                                                                                                                              u'group': u'describe.1',
                                                                                                                                              u'hidden': False,
                                                                                                                                              u'name': u'--global',
                                                                                                                                              u'nargs': u'0',
                                                                                                                                              u'required': False,
                                                                                                                                              u'type': u'bool',
                                                                                                                                              u'value': u'GLOBAL'},
                                                                                                                                u'--region': {u'attr': {u'property': {u'name': u'compute/region'}},
                                                                                                                                              u'category': u'',
                                                                                                                                              u'choices': [],
                                                                                                                                              u'completer': u'',
                                                                                                                                              u'default': None,
                                                                                                                                              u'description': u'The region of the resource to fetch. Overrides the default *compute/region* property value for this command invocation.',
                                                                                                                                              u'group': u'describe.1',
                                                                                                                                              u'hidden': False,
                                                                                                                                              u'name': u'--region',
                                                                                                                                              u'nargs': u'0',
                                                                                                                                              u'required': False,
                                                                                                                                              u'type': u'string',
                                                                                                                                              u'value': u'REGION'}},
                                                                                                                     u'group': False,
                                                                                                                     u'groups': {u'describe.1': {u'description': u'At most one of these may be specified:',
                                                                                                                                                 u'is_mutex': True,
                                                                                                                                                 u'is_required': False}},
                                                                                                                     u'hidden': False,
                                                                                                                     u'name': u'describe',
                                                                                                                     u'path': [u'gcloud',
                                                                                                                               u'alpha',
                                                                                                                               u'compute',
                                                                                                                               u'backend-services',
                                                                                                                               u'describe'],
                                                                                                                     u'positionals': [{u'completer': u'',
                                                                                                                                       u'default': None,
                                                                                                                                       u'description': u'The name of the resource to fetch.',
                                                                                                                                       u'name': u'name',
                                                                                                                                       u'nargs': u'0',
                                                                                                                                       u'required': False,
                                                                                                                                       u'value': u'NAME'}],
                                                                                                                     u'release': u'ALPHA',
                                                                                                                     u'sections': {u'DESCRIPTION': u'*describe* displays all data associated with a backend service in a project.\n',
                                                                                                                                   u'EXAMPLES': u"\nTo get details about a global backend service, run:\n\n  $ describe --global\n\nTo get details about a regional backend service in the ``us-central1'' regions,\nrun:\n\n  $ describe --region us-central1\n"}},
                                                                                                       u'edit': {u'capsule': u'*(ALPHA)* Modify backend services.',
                                                                                                                 u'commands': {},
                                                                                                                 u'flags': {u'--global': {u'attr': {},
                                                                                                                                          u'category': u'',
                                                                                                                                          u'choices': [],
                                                                                                                                          u'completer': u'',
                                                                                                                                          u'default': False,
                                                                                                                                          u'description': u'If provided, it is assumed the backend service is global.',
                                                                                                                                          u'group': u'edit.1',
                                                                                                                                          u'hidden': False,
                                                                                                                                          u'name': u'--global',
                                                                                                                                          u'nargs': u'0',
                                                                                                                                          u'required': False,
                                                                                                                                          u'type': u'bool',
                                                                                                                                          u'value': u'GLOBAL'},
                                                                                                                            u'--region': {u'attr': {u'property': {u'name': u'compute/region'}},
                                                                                                                                          u'category': u'',
                                                                                                                                          u'choices': [],
                                                                                                                                          u'completer': u'',
                                                                                                                                          u'default': None,
                                                                                                                                          u'description': u'The region of the backend service to operate on. Overrides the default *compute/region* property value for this command invocation.',
                                                                                                                                          u'group': u'edit.1',
                                                                                                                                          u'hidden': False,
                                                                                                                                          u'name': u'--region',
                                                                                                                                          u'nargs': u'0',
                                                                                                                                          u'required': False,
                                                                                                                                          u'type': u'string',
                                                                                                                                          u'value': u'REGION'}},
                                                                                                                 u'group': False,
                                                                                                                 u'groups': {u'edit.1': {u'description': u'At most one of these may be specified:',
                                                                                                                                         u'is_mutex': True,
                                                                                                                                         u'is_required': False}},
                                                                                                                 u'hidden': False,
                                                                                                                 u'name': u'edit',
                                                                                                                 u'path': [u'gcloud',
                                                                                                                           u'alpha',
                                                                                                                           u'compute',
                                                                                                                           u'backend-services',
                                                                                                                           u'edit'],
                                                                                                                 u'positionals': [{u'completer': u'',
                                                                                                                                   u'default': None,
                                                                                                                                   u'description': u'The name of the backend service.',
                                                                                                                                   u'name': u'name',
                                                                                                                                   u'nargs': u'0',
                                                                                                                                   u'required': False,
                                                                                                                                   u'value': u'NAME'}],
                                                                                                                 u'release': u'ALPHA',
                                                                                                                 u'sections': {u'DESCRIPTION': u'*edit* can be used to modify a backend service. The backend\nservice resource is fetched from the server and presented in a text\neditor. After the file is saved and closed, this command will\nupdate the resource. Only fields that can be modified are\ndisplayed in the editor.\n\nBackends are named by their associated instances groups, and one\nof the ``--group\'\' or ``--instance-group\'\' flags is required to\nidentify the backend that you are modifying.  You cannot "change"\nthe instance group associated with a backend, but you can accomplish\nsomething similar with ``backend-services remove-backend\'\' and\n``backend-services add-backend\'\'.\n\nThe editor used to modify the resource is chosen by inspecting\nthe ``EDITOR\'\' environment variable.\n'}},
                                                                                                       u'get-health': {u'capsule': u'*(ALPHA)* Get backend health statuses from a backend service.',
                                                                                                                       u'commands': {},
                                                                                                                       u'flags': {u'--filter': {u'attr': {},
                                                                                                                                                u'category': u'LIST COMMAND',
                                                                                                                                                u'choices': [],
                                                                                                                                                u'completer': u'',
                                                                                                                                                u'default': None,
                                                                                                                                                u'description': u'Apply a Boolean filter _EXPRESSION_ to each resource item to be listed.\nIf the expression evaluates True then that item is listed. For more\ndetails and examples of filter expressions run $ gcloud topic filters. This\nflag interacts with other flags that are applied in this order: *--flatten*,\n*--sort-by*, *--filter*, *--limit*.',
                                                                                                                                                u'group': u'',
                                                                                                                                                u'hidden': False,
                                                                                                                                                u'name': u'--filter',
                                                                                                                                                u'nargs': u'0',
                                                                                                                                                u'required': False,
                                                                                                                                                u'type': u'string',
                                                                                                                                                u'value': u'EXPRESSION'},
                                                                                                                                  u'--global': {u'attr': {},
                                                                                                                                                u'category': u'',
                                                                                                                                                u'choices': [],
                                                                                                                                                u'completer': u'',
                                                                                                                                                u'default': False,
                                                                                                                                                u'description': u'If provided, it is assumed the backend service is global.',
                                                                                                                                                u'group': u'get-health.1',
                                                                                                                                                u'hidden': False,
                                                                                                                                                u'name': u'--global',
                                                                                                                                                u'nargs': u'0',
                                                                                                                                                u'required': False,
                                                                                                                                                u'type': u'bool',
                                                                                                                                                u'value': u'GLOBAL'},
                                                                                                                                  u'--limit': {u'attr': {},
                                                                                                                                               u'category': u'LIST COMMAND',
                                                                                                                                               u'choices': [],
                                                                                                                                               u'completer': u'',
                                                                                                                                               u'default': None,
                                                                                                                                               u'description': u'The maximum number of resources to list. The default is *unlimited*.\nThis flag interacts with other flags that are applied in this order:\n*--flatten*, *--sort-by*, *--filter*, *--limit*.',
                                                                                                                                               u'group': u'',
                                                                                                                                               u'hidden': False,
                                                                                                                                               u'name': u'--limit',
                                                                                                                                               u'nargs': u'0',
                                                                                                                                               u'required': False,
                                                                                                                                               u'type': u'string',
                                                                                                                                               u'value': u'LIMIT'},
                                                                                                                                  u'--no-uri': {u'attr': {},
                                                                                                                                                u'category': u'LIST COMMAND',
                                                                                                                                                u'choices': [],
                                                                                                                                                u'completer': u'',
                                                                                                                                                u'default': True,
                                                                                                                                                u'description': u'',
                                                                                                                                                u'group': u'',
                                                                                                                                                u'hidden': True,
                                                                                                                                                u'name': u'--no-uri',
                                                                                                                                                u'nargs': u'0',
                                                                                                                                                u'required': False,
                                                                                                                                                u'type': u'bool',
                                                                                                                                                u'value': u'NO_URI'},
                                                                                                                                  u'--page-size': {u'attr': {},
                                                                                                                                                   u'category': u'LIST COMMAND',
                                                                                                                                                   u'choices': [],
                                                                                                                                                   u'completer': u'',
                                                                                                                                                   u'default': None,
                                                                                                                                                   u'description': u'Some services group resource list output into pages. This flag specifies\nthe maximum number of resources per page. The default is determined by the\nservice if it supports paging, otherwise it is *unlimited* (no paging).\nPaging may be applied before or after *--filter* and *--limit* depending\non the service.',
                                                                                                                                                   u'group': u'',
                                                                                                                                                   u'hidden': False,
                                                                                                                                                   u'name': u'--page-size',
                                                                                                                                                   u'nargs': u'0',
                                                                                                                                                   u'required': False,
                                                                                                                                                   u'type': u'string',
                                                                                                                                                   u'value': u'PAGE_SIZE'},
                                                                                                                                  u'--region': {u'attr': {u'property': {u'name': u'compute/region'}},
                                                                                                                                                u'category': u'',
                                                                                                                                                u'choices': [],
                                                                                                                                                u'completer': u'',
                                                                                                                                                u'default': None,
                                                                                                                                                u'description': u'The region of the backend service to operate on. Overrides the default *compute/region* property value for this command invocation.',
                                                                                                                                                u'group': u'get-health.1',
                                                                                                                                                u'hidden': False,
                                                                                                                                                u'name': u'--region',
                                                                                                                                                u'nargs': u'0',
                                                                                                                                                u'required': False,
                                                                                                                                                u'type': u'string',
                                                                                                                                                u'value': u'REGION'},
                                                                                                                                  u'--sort-by': {u'attr': {},
                                                                                                                                                 u'category': u'LIST COMMAND',
                                                                                                                                                 u'choices': [],
                                                                                                                                                 u'completer': u'',
                                                                                                                                                 u'default': None,
                                                                                                                                                 u'description': u"A comma-separated list of resource field key names to sort by. The\ndefault order is ascending. Prefix a field with ``~'' for descending\norder on that field. This flag interacts with other flags that are applied\nin this order: *--flatten*, *--sort-by*, *--filter*, *--limit*.",
                                                                                                                                                 u'group': u'',
                                                                                                                                                 u'hidden': False,
                                                                                                                                                 u'name': u'--sort-by',
                                                                                                                                                 u'nargs': u'0',
                                                                                                                                                 u'required': False,
                                                                                                                                                 u'type': u'list',
                                                                                                                                                 u'value': u'FIELD'},
                                                                                                                                  u'--uri': {u'attr': {},
                                                                                                                                             u'category': u'LIST COMMAND',
                                                                                                                                             u'choices': [],
                                                                                                                                             u'completer': u'',
                                                                                                                                             u'default': False,
                                                                                                                                             u'description': u'Print a list of resource URIs instead of the default output.',
                                                                                                                                             u'group': u'',
                                                                                                                                             u'hidden': False,
                                                                                                                                             u'name': u'--uri',
                                                                                                                                             u'nargs': u'0',
                                                                                                                                             u'required': False,
                                                                                                                                             u'type': u'bool',
                                                                                                                                             u'value': u'URI'}},
                                                                                                                       u'group': False,
                                                                                                                       u'groups': {u'get-health.1': {u'description': u'At most one of these may be specified:',
                                                                                                                                                     u'is_mutex': True,
                                                                                                                                                     u'is_required': False}},
                                                                                                                       u'hidden': False,
                                                                                                                       u'name': u'get-health',
                                                                                                                       u'path': [u'gcloud',
                                                                                                                                 u'alpha',
                                                                                                                                 u'compute',
                                                                                                                                 u'backend-services',
                                                                                                                                 u'get-health'],
                                                                                                                       u'positionals': [{u'completer': u'',
                                                                                                                                         u'default': None,
                                                                                                                                         u'description': u'The name of the backend service.',
                                                                                                                                         u'name': u'name',
                                                                                                                                         u'nargs': u'0',
                                                                                                                                         u'required': False,
                                                                                                                                         u'value': u'NAME'}],
                                                                                                                       u'release': u'ALPHA',
                                                                                                                       u'sections': {u'DESCRIPTION': u"\n*get-health* is used to request the current health status of\ninstances in a backend service. Every group in the service\nis checked and the health status of each configured instance\nis printed.\n\nIf a group contains names of instances that don't exist or\ninstances that haven't yet been pushed to the load-balancing\nsystem, they will not show up. Those that are listed as\n``HEALTHY'' are able to receive load-balanced traffic. Those that\nare marked as ``UNHEALTHY'' are either failing the configured\nhealth-check or not responding to it.\n\nSince the health checks are performed continuously and in\na distributed manner, the state returned by this command is\nthe most recent result of a vote of several redundant health\nchecks. Backend services that do not have a valid global\nforwarding rule referencing it will not be health checked and\nso will have no health status.\n"}},
                                                                                                       u'list': {u'capsule': u'*(ALPHA)* List Google Compute Engine backend services.',
                                                                                                                 u'commands': {},
                                                                                                                 u'flags': {u'--filter': {u'attr': {},
                                                                                                                                          u'category': u'LIST COMMAND',
                                                                                                                                          u'choices': [],
                                                                                                                                          u'completer': u'',
                                                                                                                                          u'default': None,
                                                                                                                                          u'description': u'Apply a Boolean filter _EXPRESSION_ to each resource item to be listed.\nIf the expression evaluates True then that item is listed. For more\ndetails and examples of filter expressions run $ gcloud topic filters. This\nflag interacts with other flags that are applied in this order: *--flatten*,\n*--sort-by*, *--filter*, *--limit*.',
                                                                                                                                          u'group': u'',
                                                                                                                                          u'hidden': False,
                                                                                                                                          u'name': u'--filter',
                                                                                                                                          u'nargs': u'0',
                                                                                                                                          u'required': False,
                                                                                                                                          u'type': u'string',
                                                                                                                                          u'value': u'EXPRESSION'},
                                                                                                                            u'--global': {u'attr': {},
                                                                                                                                          u'category': u'',
                                                                                                                                          u'choices': [],
                                                                                                                                          u'completer': u'',
                                                                                                                                          u'default': False,
                                                                                                                                          u'description': u'If provided, only global resources are shown.',
                                                                                                                                          u'group': u'list.1',
                                                                                                                                          u'hidden': False,
                                                                                                                                          u'name': u'--global',
                                                                                                                                          u'nargs': u'0',
                                                                                                                                          u'required': False,
                                                                                                                                          u'type': u'bool',
                                                                                                                                          u'value': u'GLOBAL'},
                                                                                                                            u'--limit': {u'attr': {},
                                                                                                                                         u'category': u'LIST COMMAND',
                                                                                                                                         u'choices': [],
                                                                                                                                         u'completer': u'',
                                                                                                                                         u'default': None,
                                                                                                                                         u'description': u'The maximum number of resources to list. The default is *unlimited*.\nThis flag interacts with other flags that are applied in this order:\n*--flatten*, *--sort-by*, *--filter*, *--limit*.',
                                                                                                                                         u'group': u'',
                                                                                                                                         u'hidden': False,
                                                                                                                                         u'name': u'--limit',
                                                                                                                                         u'nargs': u'0',
                                                                                                                                         u'required': False,
                                                                                                                                         u'type': u'string',
                                                                                                                                         u'value': u'LIMIT'},
                                                                                                                            u'--no-uri': {u'attr': {},
                                                                                                                                          u'category': u'LIST COMMAND',
                                                                                                                                          u'choices': [],
                                                                                                                                          u'completer': u'',
                                                                                                                                          u'default': True,
                                                                                                                                          u'description': u'',
                                                                                                                                          u'group': u'',
                                                                                                                                          u'hidden': True,
                                                                                                                                          u'name': u'--no-uri',
                                                                                                                                          u'nargs': u'0',
                                                                                                                                          u'required': False,
                                                                                                                                          u'type': u'bool',
                                                                                                                                          u'value': u'NO_URI'},
                                                                                                                            u'--page-size': {u'attr': {},
                                                                                                                                             u'category': u'LIST COMMAND',
                                                                                                                                             u'choices': [],
                                                                                                                                             u'completer': u'',
                                                                                                                                             u'default': None,
                                                                                                                                             u'description': u'Some services group resource list output into pages. This flag specifies\nthe maximum number of resources per page. The default is determined by the\nservice if it supports paging, otherwise it is *unlimited* (no paging).\nPaging may be applied before or after *--filter* and *--limit* depending\non the service.',
                                                                                                                                             u'group': u'',
                                                                                                                                             u'hidden': False,
                                                                                                                                             u'name': u'--page-size',
                                                                                                                                             u'nargs': u'0',
                                                                                                                                             u'required': False,
                                                                                                                                             u'type': u'string',
                                                                                                                                             u'value': u'PAGE_SIZE'},
                                                                                                                            u'--regexp': {u'attr': {},
                                                                                                                                          u'category': u'',
                                                                                                                                          u'choices': [],
                                                                                                                                          u'completer': u'',
                                                                                                                                          u'default': None,
                                                                                                                                          u'description': u'A regular expression to filter the names of the results on. Any names\nthat do not match the entire regular expression will be filtered out.',
                                                                                                                                          u'group': u'',
                                                                                                                                          u'hidden': False,
                                                                                                                                          u'name': u'--regexp',
                                                                                                                                          u'nargs': u'0',
                                                                                                                                          u'required': False,
                                                                                                                                          u'type': u'string',
                                                                                                                                          u'value': u'REGEXP'},
                                                                                                                            u'--regions': {u'attr': {},
                                                                                                                                           u'category': u'',
                                                                                                                                           u'choices': [],
                                                                                                                                           u'completer': u'',
                                                                                                                                           u'default': None,
                                                                                                                                           u'description': u'If provided, only regional resources are shown. If arguments are provided, only resources from the given regions are shown.',
                                                                                                                                           u'group': u'list.1',
                                                                                                                                           u'hidden': False,
                                                                                                                                           u'name': u'--regions',
                                                                                                                                           u'nargs': u'0',
                                                                                                                                           u'required': False,
                                                                                                                                           u'type': u'list',
                                                                                                                                           u'value': u'REGION'},
                                                                                                                            u'--sort-by': {u'attr': {},
                                                                                                                                           u'category': u'LIST COMMAND',
                                                                                                                                           u'choices': [],
                                                                                                                                           u'completer': u'',
                                                                                                                                           u'default': None,
                                                                                                                                           u'description': u"A comma-separated list of resource field key names to sort by. The\ndefault order is ascending. Prefix a field with ``~'' for descending\norder on that field. This flag interacts with other flags that are applied\nin this order: *--flatten*, *--sort-by*, *--filter*, *--limit*.",
                                                                                                                                           u'group': u'',
                                                                                                                                           u'hidden': False,
                                                                                                                                           u'name': u'--sort-by',
                                                                                                                                           u'nargs': u'0',
                                                                                                                                           u'required': False,
                                                                                                                                           u'type': u'list',
                                                                                                                                           u'value': u'FIELD'},
                                                                                                                            u'--uri': {u'attr': {},
                                                                                                                                       u'category': u'LIST COMMAND',
                                                                                                                                       u'choices': [],
                                                                                                                                       u'completer': u'',
                                                                                                                                       u'default': False,
                                                                                                                                       u'description': u'Print a list of resource URIs instead of the default output.',
                                                                                                                                       u'group': u'',
                                                                                                                                       u'hidden': False,
                                                                                                                                       u'name': u'--uri',
                                                                                                                                       u'nargs': u'0',
                                                                                                                                       u'required': False,
                                                                                                                                       u'type': u'bool',
                                                                                                                                       u'value': u'URI'}},
                                                                                                                 u'group': False,
                                                                                                                 u'groups': {u'list.1': {u'description': u'At most one of these may be specified:',
                                                                                                                                         u'is_mutex': True,
                                                                                                                                         u'is_required': False}},
                                                                                                                 u'hidden': False,
                                                                                                                 u'name': u'list',
                                                                                                                 u'path': [u'gcloud',
                                                                                                                           u'alpha',
                                                                                                                           u'compute',
                                                                                                                           u'backend-services',
                                                                                                                           u'list'],
                                                                                                                 u'positionals': [{u'completer': u'',
                                                                                                                                   u'default': [],
                                                                                                                                   u'description': u'If provided, show details for the specified names and/or URIs of resources.',
                                                                                                                                   u'name': u'names',
                                                                                                                                   u'nargs': u'*',
                                                                                                                                   u'required': False,
                                                                                                                                   u'value': u'NAME'}],
                                                                                                                 u'release': u'ALPHA',
                                                                                                                 u'sections': {u'DESCRIPTION': u"*list* displays all Google Compute Engine backend services in a project.\n\nBy default, global backend services and backend services from all regions are listed. The results can be narrowed down by\nproviding the ``--global'' or ``--regions'' flag.\n",
                                                                                                                               u'EXAMPLES': u"To list all backend services in a project in table form, run:\n\n  $ list\n\nTo list the URIs of all backend services in a project, run:\n\n  $ list --uri\n\nTo list all global backend services in a project, run:\n\n  $ list --global\n\nTo list all backend services in the ``us-central1'' and ``europe-west1'' regions,\nrun:\n\n  $ list --regions us-central1,europe-west1\n"}},
                                                                                                       u'remove-backend': {u'capsule': u'*(ALPHA)* Remove a backend from a backend service.',
                                                                                                                           u'commands': {},
                                                                                                                           u'flags': {u'--global': {u'attr': {},
                                                                                                                                                    u'category': u'',
                                                                                                                                                    u'choices': [],
                                                                                                                                                    u'completer': u'',
                                                                                                                                                    u'default': False,
                                                                                                                                                    u'description': u'If provided, it is assumed the backend service is global.',
                                                                                                                                                    u'group': u'remove-backend.1',
                                                                                                                                                    u'hidden': False,
                                                                                                                                                    u'name': u'--global',
                                                                                                                                                    u'nargs': u'0',
                                                                                                                                                    u'required': False,
                                                                                                                                                    u'type': u'bool',
                                                                                                                                                    u'value': u'GLOBAL'},
                                                                                                                                      u'--instance-group': {u'attr': {},
                                                                                                                                                            u'category': u'',
                                                                                                                                                            u'choices': [],
                                                                                                                                                            u'completer': u'',
                                                                                                                                                            u'default': None,
                                                                                                                                                            u'description': u'The name of the instance group.',
                                                                                                                                                            u'group': u'',
                                                                                                                                                            u'hidden': False,
                                                                                                                                                            u'name': u'--instance-group',
                                                                                                                                                            u'nargs': u'0',
                                                                                                                                                            u'required': True,
                                                                                                                                                            u'type': u'string',
                                                                                                                                                            u'value': u'INSTANCE_GROUP'},
                                                                                                                                      u'--instance-group-region': {u'attr': {u'property': {u'name': u'compute/region'}},
                                                                                                                                                                   u'category': u'',
                                                                                                                                                                   u'choices': [],
                                                                                                                                                                   u'completer': u'',
                                                                                                                                                                   u'default': None,
                                                                                                                                                                   u'description': u"The region of the instance group to remove. If not specified, you will be prompted to select a region.\n+\nTo avoid prompting when this flag is omitted, you can set the\n``compute/region'' property:\n+\n  $ gcloud config set compute/region REGION\n+\nA list of regions can be fetched by running:\n+\n  $ gcloud compute regions list\n+\nTo unset the property, run:\n+\n  $ gcloud config unset compute/region\n+\nAlternatively, the region can be stored in the environment\nvariable ``CLOUDSDK_COMPUTE_REGION''.",
                                                                                                                                                                   u'group': u'remove-backend.2',
                                                                                                                                                                   u'hidden': False,
                                                                                                                                                                   u'name': u'--instance-group-region',
                                                                                                                                                                   u'nargs': u'0',
                                                                                                                                                                   u'required': False,
                                                                                                                                                                   u'type': u'string',
                                                                                                                                                                   u'value': u'INSTANCE_GROUP_REGION'},
                                                                                                                                      u'--instance-group-zone': {u'attr': {u'property': {u'name': u'compute/zone'}},
                                                                                                                                                                 u'category': u'',
                                                                                                                                                                 u'choices': [],
                                                                                                                                                                 u'completer': u'',
                                                                                                                                                                 u'default': None,
                                                                                                                                                                 u'description': u"The zone of the instance group to remove. If not specified, you will be prompted to select a zone.\n+\nTo avoid prompting when this flag is omitted, you can set the\n``compute/zone'' property:\n+\n  $ gcloud config set compute/zone ZONE\n+\nA list of zones can be fetched by running:\n+\n  $ gcloud compute zones list\n+\nTo unset the property, run:\n+\n  $ gcloud config unset compute/zone\n+\nAlternatively, the zone can be stored in the environment variable\n``CLOUDSDK_COMPUTE_ZONE''.",
                                                                                                                                                                 u'group': u'remove-backend.2',
                                                                                                                                                                 u'hidden': False,
                                                                                                                                                                 u'name': u'--instance-group-zone',
                                                                                                                                                                 u'nargs': u'0',
                                                                                                                                                                 u'required': False,
                                                                                                                                                                 u'type': u'string',
                                                                                                                                                                 u'value': u'INSTANCE_GROUP_ZONE'},
                                                                                                                                      u'--region': {u'attr': {u'property': {u'name': u'compute/region'}},
                                                                                                                                                    u'category': u'',
                                                                                                                                                    u'choices': [],
                                                                                                                                                    u'completer': u'',
                                                                                                                                                    u'default': None,
                                                                                                                                                    u'description': u'The region of the backend service to operate on. Overrides the default *compute/region* property value for this command invocation.',
                                                                                                                                                    u'group': u'remove-backend.1',
                                                                                                                                                    u'hidden': False,
                                                                                                                                                    u'name': u'--region',
                                                                                                                                                    u'nargs': u'0',
                                                                                                                                                    u'required': False,
                                                                                                                                                    u'type': u'string',
                                                                                                                                                    u'value': u'REGION'}},
                                                                                                                           u'group': False,
                                                                                                                           u'groups': {u'remove-backend.1': {u'description': u'At most one of these may be specified:',
                                                                                                                                                             u'is_mutex': True,
                                                                                                                                                             u'is_required': False},
                                                                                                                                       u'remove-backend.2': {u'description': u'At most one of these may be specified:',
                                                                                                                                                             u'is_mutex': True,
                                                                                                                                                             u'is_required': False}},
                                                                                                                           u'hidden': False,
                                                                                                                           u'name': u'remove-backend',
                                                                                                                           u'path': [u'gcloud',
                                                                                                                                     u'alpha',
                                                                                                                                     u'compute',
                                                                                                                                     u'backend-services',
                                                                                                                                     u'remove-backend'],
                                                                                                                           u'positionals': [{u'completer': u'',
                                                                                                                                             u'default': None,
                                                                                                                                             u'description': u'The name of the backend service.',
                                                                                                                                             u'name': u'name',
                                                                                                                                             u'nargs': u'0',
                                                                                                                                             u'required': False,
                                                                                                                                             u'value': u'NAME'}],
                                                                                                                           u'release': u'ALPHA',
                                                                                                                           u'sections': {u'DESCRIPTION': u'*(ALPHA)* *remove-backend* is used to remove a backend from a backend\nservice.\n\nBefore removing a backend, it is a good idea to "drain" the\nbackend first. A backend can be drained by setting its\ncapacity scaler to zero through \'gcloud compute\nbackend-services edit\'.'}},
                                                                                                       u'update': {u'capsule': u'*(ALPHA)* Update a backend service.',
                                                                                                                   u'commands': {},
                                                                                                                   u'flags': {u'--affinity-cookie-ttl': {u'attr': {},
                                                                                                                                                         u'category': u'',
                                                                                                                                                         u'choices': [],
                                                                                                                                                         u'completer': u'',
                                                                                                                                                         u'default': None,
                                                                                                                                                         u'description': u'If session-affinity is set to "generated_cookie", this flag sets\nthe TTL, in seconds, of the resulting cookie.  A setting of 0\nindicates that the cookie should be transient.',
                                                                                                                                                         u'group': u'',
                                                                                                                                                         u'hidden': False,
                                                                                                                                                         u'name': u'--affinity-cookie-ttl',
                                                                                                                                                         u'nargs': u'0',
                                                                                                                                                         u'required': False,
                                                                                                                                                         u'type': u'string',
                                                                                                                                                         u'value': u'AFFINITY_COOKIE_TTL'},
                                                                                                                              u'--cache-key-include-host': {u'attr': {},
                                                                                                                                                            u'category': u'',
                                                                                                                                                            u'choices': [],
                                                                                                                                                            u'completer': u'',
                                                                                                                                                            u'default': False,
                                                                                                                                                            u'description': u'Enable including host in cache key. If enabled, requests to different\nhosts will be cached separately. Can only be applied for global resources.',
                                                                                                                                                            u'group': u'',
                                                                                                                                                            u'hidden': False,
                                                                                                                                                            u'name': u'--cache-key-include-host',
                                                                                                                                                            u'nargs': u'0',
                                                                                                                                                            u'required': False,
                                                                                                                                                            u'type': u'bool',
                                                                                                                                                            u'value': u'CACHE_KEY_INCLUDE_HOST'},
                                                                                                                              u'--cache-key-include-protocol': {u'attr': {},
                                                                                                                                                                u'category': u'',
                                                                                                                                                                u'choices': [],
                                                                                                                                                                u'completer': u'',
                                                                                                                                                                u'default': False,
                                                                                                                                                                u'description': u'Enable including protocol in cache key. If enabled, http and https\nrequests will be cached separately. Can only be applied for global\nresources.',
                                                                                                                                                                u'group': u'',
                                                                                                                                                                u'hidden': False,
                                                                                                                                                                u'name': u'--cache-key-include-protocol',
                                                                                                                                                                u'nargs': u'0',
                                                                                                                                                                u'required': False,
                                                                                                                                                                u'type': u'bool',
                                                                                                                                                                u'value': u'CACHE_KEY_INCLUDE_PROTOCOL'},
                                                                                                                              u'--cache-key-include-query-string': {u'attr': {},
                                                                                                                                                                    u'category': u'',
                                                                                                                                                                    u'choices': [],
                                                                                                                                                                    u'completer': u'',
                                                                                                                                                                    u'default': False,
                                                                                                                                                                    u'description': u'Enable including query string in cache key. If enabled, the query string\nparameters will be included according to\n--cache-key-query-string-whitelist and\n--cache-key-query-string-blacklist. If disabled, the entire query string\nwill be excluded. Use "--cache-key-query-string-blacklist=" (sets the\nblacklist to the empty list) to include the entire query string. Can\nonly be applied for global resources.',
                                                                                                                                                                    u'group': u'',
                                                                                                                                                                    u'hidden': False,
                                                                                                                                                                    u'name': u'--cache-key-include-query-string',
                                                                                                                                                                    u'nargs': u'0',
                                                                                                                                                                    u'required': False,
                                                                                                                                                                    u'type': u'bool',
                                                                                                                                                                    u'value': u'CACHE_KEY_INCLUDE_QUERY_STRING'},
                                                                                                                              u'--cache-key-query-string-blacklist': {u'attr': {},
                                                                                                                                                                      u'category': u'',
                                                                                                                                                                      u'choices': [],
                                                                                                                                                                      u'completer': u'',
                                                                                                                                                                      u'default': None,
                                                                                                                                                                      u'description': u"Specifies a comma separated list of query string parameters to exclude\nin cache keys. All other parameters will be included. Either specify\n--cache-key-query-string-whitelist or --cache-key-query-string-blacklist,\nnot both. '&' and '=' will be percent encoded and not treated as\ndelimiters. Can only be applied for global resources.",
                                                                                                                                                                      u'group': u'update.1',
                                                                                                                                                                      u'hidden': False,
                                                                                                                                                                      u'name': u'--cache-key-query-string-blacklist',
                                                                                                                                                                      u'nargs': u'0',
                                                                                                                                                                      u'required': False,
                                                                                                                                                                      u'type': u'list',
                                                                                                                                                                      u'value': u'QUERY_STRING'},
                                                                                                                              u'--cache-key-query-string-whitelist': {u'attr': {},
                                                                                                                                                                      u'category': u'',
                                                                                                                                                                      u'choices': [],
                                                                                                                                                                      u'completer': u'',
                                                                                                                                                                      u'default': None,
                                                                                                                                                                      u'description': u"Specifies a comma separated list of query string parameters to include\nin cache keys. All other parameters will be excluded. Either specify\n--cache-key-query-string-whitelist or --cache-key-query-string-blacklist,\nnot both. '&' and '=' will be percent encoded and not treated as\ndelimiters. Can only be applied for global resources.",
                                                                                                                                                                      u'group': u'update.1',
                                                                                                                                                                      u'hidden': False,
                                                                                                                                                                      u'name': u'--cache-key-query-string-whitelist',
                                                                                                                                                                      u'nargs': u'0',
                                                                                                                                                                      u'required': False,
                                                                                                                                                                      u'type': u'list',
                                                                                                                                                                      u'value': u'QUERY_STRING'},
                                                                                                                              u'--connection-draining-timeout': {u'attr': {},
                                                                                                                                                                 u'category': u'',
                                                                                                                                                                 u'choices': [],
                                                                                                                                                                 u'completer': u'',
                                                                                                                                                                 u'default': None,
                                                                                                                                                                 u'description': u'Connection draining timeout to be used during removal of VMs from\ninstance groups. This guarantees that for the specified time all existing\nconnections to a VM will remain untouched, but no new connections will be\naccepted. Set timeout to zero to disable connection draining. Enable\nfeature by specifying a timeout of up to one hour.\nIf the flag is omitted API default value (0s) will be used.\nValid units for this flag are `s` for seconds, `m` for minutes, and\n`h` for hours.',
                                                                                                                                                                 u'group': u'',
                                                                                                                                                                 u'hidden': False,
                                                                                                                                                                 u'name': u'--connection-draining-timeout',
                                                                                                                                                                 u'nargs': u'0',
                                                                                                                                                                 u'required': False,
                                                                                                                                                                 u'type': u'string',
                                                                                                                                                                 u'value': u'CONNECTION_DRAINING_TIMEOUT'},
                                                                                                                              u'--description': {u'attr': {},
                                                                                                                                                 u'category': u'',
                                                                                                                                                 u'choices': [],
                                                                                                                                                 u'completer': u'',
                                                                                                                                                 u'default': None,
                                                                                                                                                 u'description': u'An optional, textual description for the backend service.',
                                                                                                                                                 u'group': u'',
                                                                                                                                                 u'hidden': False,
                                                                                                                                                 u'name': u'--description',
                                                                                                                                                 u'nargs': u'0',
                                                                                                                                                 u'required': False,
                                                                                                                                                 u'type': u'string',
                                                                                                                                                 u'value': u'DESCRIPTION'},
                                                                                                                              u'--enable-cdn': {u'attr': {},
                                                                                                                                                u'category': u'',
                                                                                                                                                u'choices': [],
                                                                                                                                                u'completer': u'',
                                                                                                                                                u'default': False,
                                                                                                                                                u'description': u'Enable Cloud CDN for the backend service. Cloud CDN can cache HTTP\nresponses from a backend service at the edge of the network, close to\nusers. Cloud CDN is disabled by default.',
                                                                                                                                                u'group': u'',
                                                                                                                                                u'hidden': False,
                                                                                                                                                u'name': u'--enable-cdn',
                                                                                                                                                u'nargs': u'0',
                                                                                                                                                u'required': False,
                                                                                                                                                u'type': u'bool',
                                                                                                                                                u'value': u'ENABLE_CDN'},
                                                                                                                              u'--global': {u'attr': {},
                                                                                                                                            u'category': u'',
                                                                                                                                            u'choices': [],
                                                                                                                                            u'completer': u'',
                                                                                                                                            u'default': False,
                                                                                                                                            u'description': u'If provided, it is assumed the backend service is global.',
                                                                                                                                            u'group': u'update.2',
                                                                                                                                            u'hidden': False,
                                                                                                                                            u'name': u'--global',
                                                                                                                                            u'nargs': u'0',
                                                                                                                                            u'required': False,
                                                                                                                                            u'type': u'bool',
                                                                                                                                            u'value': u'GLOBAL'},
                                                                                                                              u'--health-checks': {u'attr': {},
                                                                                                                                                   u'category': u'',
                                                                                                                                                   u'choices': [],
                                                                                                                                                   u'completer': u'',
                                                                                                                                                   u'default': None,
                                                                                                                                                   u'description': u'Specifies a list of health check objects for checking the health of\nthe backend service. Health checks need not be for the same protocol\nas that of the backend service.',
                                                                                                                                                   u'group': u'',
                                                                                                                                                   u'hidden': False,
                                                                                                                                                   u'name': u'--health-checks',
                                                                                                                                                   u'nargs': u'0',
                                                                                                                                                   u'required': False,
                                                                                                                                                   u'type': u'list',
                                                                                                                                                   u'value': u'HEALTH_CHECK'},
                                                                                                                              u'--http-health-checks': {u'attr': {},
                                                                                                                                                        u'category': u'',
                                                                                                                                                        u'choices': [],
                                                                                                                                                        u'completer': u'',
                                                                                                                                                        u'default': None,
                                                                                                                                                        u'description': u'Specifies a list of HTTP health check objects for checking the health\nof the backend service.',
                                                                                                                                                        u'group': u'',
                                                                                                                                                        u'hidden': False,
                                                                                                                                                        u'name': u'--http-health-checks',
                                                                                                                                                        u'nargs': u'0',
                                                                                                                                                        u'required': False,
                                                                                                                                                        u'type': u'list',
                                                                                                                                                        u'value': u'HTTP_HEALTH_CHECK'},
                                                                                                                              u'--https-health-checks': {u'attr': {},
                                                                                                                                                         u'category': u'',
                                                                                                                                                         u'choices': [],
                                                                                                                                                         u'completer': u'',
                                                                                                                                                         u'default': None,
                                                                                                                                                         u'description': u'Specifies a list of HTTPS health check objects for checking the health\nof the backend service.',
                                                                                                                                                         u'group': u'',
                                                                                                                                                         u'hidden': False,
                                                                                                                                                         u'name': u'--https-health-checks',
                                                                                                                                                         u'nargs': u'0',
                                                                                                                                                         u'required': False,
                                                                                                                                                         u'type': u'list',
                                                                                                                                                         u'value': u'HTTPS_HEALTH_CHECK'},
                                                                                                                              u'--iap': {u'attr': {},
                                                                                                                                         u'category': u'',
                                                                                                                                         u'choices': [],
                                                                                                                                         u'completer': u'',
                                                                                                                                         u'default': None,
                                                                                                                                         u'description': u"Change the Identity Aware Proxy (IAP) service configuration for the\nbackend service. You can set IAP to 'enabled' or 'disabled', or modify\nthe OAuth2 client configuration (oauth2-client-id and\noauth2-client-secret) used by IAP. If any fields are unspecified, their\nvalues will not be modified. For instance, if IAP is enabled,\n'--iap=disabled' will disable IAP, and a subsequent '--iap=enabled' will\nthen enable it with the same OAuth2 client configuration as the first\ntime it was enabled. See\nhttps://cloud.google.com/iap/ for more information about this feature.",
                                                                                                                                         u'group': u'',
                                                                                                                                         u'hidden': False,
                                                                                                                                         u'name': u'--iap',
                                                                                                                                         u'nargs': u'0',
                                                                                                                                         u'required': False,
                                                                                                                                         u'type': u'string',
                                                                                                                                         u'value': u'disabled|enabled,[oauth2-client-id=OAUTH2-CLIENT-ID,oauth2-client-secret=OAUTH2-CLIENT-SECRET]'},
                                                                                                                              u'--no-cache-key-include-host': {u'attr': {},
                                                                                                                                                               u'category': u'',
                                                                                                                                                               u'choices': [],
                                                                                                                                                               u'completer': u'',
                                                                                                                                                               u'default': False,
                                                                                                                                                               u'description': u'',
                                                                                                                                                               u'group': u'',
                                                                                                                                                               u'hidden': True,
                                                                                                                                                               u'name': u'--no-cache-key-include-host',
                                                                                                                                                               u'nargs': u'0',
                                                                                                                                                               u'required': False,
                                                                                                                                                               u'type': u'bool',
                                                                                                                                                               u'value': u'NO_CACHE_KEY_INCLUDE_HOST'},
                                                                                                                              u'--no-cache-key-include-protocol': {u'attr': {},
                                                                                                                                                                   u'category': u'',
                                                                                                                                                                   u'choices': [],
                                                                                                                                                                   u'completer': u'',
                                                                                                                                                                   u'default': False,
                                                                                                                                                                   u'description': u'',
                                                                                                                                                                   u'group': u'',
                                                                                                                                                                   u'hidden': True,
                                                                                                                                                                   u'name': u'--no-cache-key-include-protocol',
                                                                                                                                                                   u'nargs': u'0',
                                                                                                                                                                   u'required': False,
                                                                                                                                                                   u'type': u'bool',
                                                                                                                                                                   u'value': u'NO_CACHE_KEY_INCLUDE_PROTOCOL'},
                                                                                                                              u'--no-cache-key-include-query-string': {u'attr': {},
                                                                                                                                                                       u'category': u'',
                                                                                                                                                                       u'choices': [],
                                                                                                                                                                       u'completer': u'',
                                                                                                                                                                       u'default': False,
                                                                                                                                                                       u'description': u'',
                                                                                                                                                                       u'group': u'',
                                                                                                                                                                       u'hidden': True,
                                                                                                                                                                       u'name': u'--no-cache-key-include-query-string',
                                                                                                                                                                       u'nargs': u'0',
                                                                                                                                                                       u'required': False,
                                                                                                                                                                       u'type': u'bool',
                                                                                                                                                                       u'value': u'NO_CACHE_KEY_INCLUDE_QUERY_STRING'},
                                                                                                                              u'--no-enable-cdn': {u'attr': {},
                                                                                                                                                   u'category': u'',
                                                                                                                                                   u'choices': [],
                                                                                                                                                   u'completer': u'',
                                                                                                                                                   u'default': False,
                                                                                                                                                   u'description': u'',
                                                                                                                                                   u'group': u'',
                                                                                                                                                   u'hidden': True,
                                                                                                                                                   u'name': u'--no-enable-cdn',
                                                                                                                                                   u'nargs': u'0',
                                                                                                                                                   u'required': False,
                                                                                                                                                   u'type': u'bool',
                                                                                                                                                   u'value': u'NO_ENABLE_CDN'},
                                                                                                                              u'--port': {u'attr': {},
                                                                                                                                          u'category': u'',
                                                                                                                                          u'choices': [],
                                                                                                                                          u'completer': u'',
                                                                                                                                          u'default': None,
                                                                                                                                          u'description': u'The TCP port to use when connecting to the backend. --port is being deprecated in favor of --port-name.',
                                                                                                                                          u'group': u'',
                                                                                                                                          u'hidden': False,
                                                                                                                                          u'name': u'--port',
                                                                                                                                          u'nargs': u'0',
                                                                                                                                          u'required': False,
                                                                                                                                          u'type': u'string',
                                                                                                                                          u'value': u'PORT'},
                                                                                                                              u'--port-name': {u'attr': {},
                                                                                                                                               u'category': u'',
                                                                                                                                               u'choices': [],
                                                                                                                                               u'completer': u'',
                                                                                                                                               u'default': None,
                                                                                                                                               u'description': u"The name of a service that has been added to an instance group\nin this backend. Instance group services map a name to a port\nnumber which is used by the load balancing service.\nOnly one ``port-name'' may be added to a backend service, and that\nname must exist as a service on all instance groups that are a\npart of this backend service. The port number associated with the\nname may differ between instances. If you do not specify\nthis flag, your instance groups must have a service named ``http''\nconfigured. See also\n`gcloud compute instance-groups set-named-ports --help`.",
                                                                                                                                               u'group': u'',
                                                                                                                                               u'hidden': False,
                                                                                                                                               u'name': u'--port-name',
                                                                                                                                               u'nargs': u'0',
                                                                                                                                               u'required': False,
                                                                                                                                               u'type': u'string',
                                                                                                                                               u'value': u'PORT_NAME'},
                                                                                                                              u'--protocol': {u'attr': {},
                                                                                                                                              u'category': u'',
                                                                                                                                              u'choices': [u'HTTP',
                                                                                                                                                           u'HTTPS',
                                                                                                                                                           u'SSL',
                                                                                                                                                           u'TCP',
                                                                                                                                                           u'UDP'],
                                                                                                                                              u'completer': u'',
                                                                                                                                              u'default': None,
                                                                                                                                              u'description': u'The protocol for incoming requests. _PROTOCOL_ must be one of: *HTTP*, *HTTPS*, *SSL*, *TCP*, *UDP*.',
                                                                                                                                              u'group': u'',
                                                                                                                                              u'hidden': False,
                                                                                                                                              u'name': u'--protocol',
                                                                                                                                              u'nargs': u'0',
                                                                                                                                              u'required': False,
                                                                                                                                              u'type': u'string',
                                                                                                                                              u'value': u'PROTOCOL'},
                                                                                                                              u'--region': {u'attr': {u'property': {u'name': u'compute/region'}},
                                                                                                                                            u'category': u'',
                                                                                                                                            u'choices': [],
                                                                                                                                            u'completer': u'',
                                                                                                                                            u'default': None,
                                                                                                                                            u'description': u'The region of the backend service to operate on. Overrides the default *compute/region* property value for this command invocation.',
                                                                                                                                            u'group': u'update.2',
                                                                                                                                            u'hidden': False,
                                                                                                                                            u'name': u'--region',
                                                                                                                                            u'nargs': u'0',
                                                                                                                                            u'required': False,
                                                                                                                                            u'type': u'string',
                                                                                                                                            u'value': u'REGION'},
                                                                                                                              u'--session-affinity': {u'attr': {},
                                                                                                                                                      u'category': u'',
                                                                                                                                                      u'choices': [u'CLIENT_IP',
                                                                                                                                                                   u'CLIENT_IP_PORT_PROTO',
                                                                                                                                                                   u'CLIENT_IP_PROTO',
                                                                                                                                                                   u'GENERATED_COOKIE',
                                                                                                                                                                   u'NONE'],
                                                                                                                                                      u'completer': u'',
                                                                                                                                                      u'default': None,
                                                                                                                                                      u'description': u'The type of session affinity to use for this backend service. _SESSION_AFFINITY_ must be one of:\n+\n*CLIENT_IP*::: Route requests to instances based on the hash of the client\'s IP address.\n*CLIENT_IP_PORT_PROTO*::: Connections from the same client IP with the same IP protocol and port will go to the same VM in the backend while that VM remains healthy. This option cannot be used for HTTP(S) load balancing.\n*CLIENT_IP_PROTO*::: Connections from the same client IP with the same IP protocol willgo to the same VM in the pool while that VM remains healthy. This option cannot be used for HTTP(s) load balancing.\n*GENERATED_COOKIE*::: Route requests to instances based on the contents of the "GCLB" cookie set by the load balancer.\n*NONE*::: Session affinity is disabled.\n+',
                                                                                                                                                      u'group': u'',
                                                                                                                                                      u'hidden': False,
                                                                                                                                                      u'name': u'--session-affinity',
                                                                                                                                                      u'nargs': u'0',
                                                                                                                                                      u'required': False,
                                                                                                                                                      u'type': u'string',
                                                                                                                                                      u'value': u'SESSION_AFFINITY'},
                                                                                                                              u'--timeout': {u'attr': {},
                                                                                                                                             u'category': u'',
                                                                                                                                             u'choices': [],
                                                                                                                                             u'completer': u'',
                                                                                                                                             u'default': None,
                                                                                                                                             u'description': u"The amount of time to wait for a backend to respond to a request\nbefore considering the request failed. For example, specifying\n``10s'' will give backends 10 seconds to respond to\nrequests. Valid units for this flag are ``s'' for seconds, ``m''\nfor minutes, and ``h'' for hours.",
                                                                                                                                             u'group': u'',
                                                                                                                                             u'hidden': False,
                                                                                                                                             u'name': u'--timeout',
                                                                                                                                             u'nargs': u'0',
                                                                                                                                             u'required': False,
                                                                                                                                             u'type': u'string',
                                                                                                                                             u'value': u'TIMEOUT'}},
                                                                                                                   u'group': False,
                                                                                                                   u'groups': {u'update.1': {u'description': u'At most one of these may be specified:',
                                                                                                                                             u'is_mutex': True,
                                                                                                                                             u'is_required': False},
                                                                                                                               u'update.2': {u'description': u'At most one of these may be specified:',
                                                                                                                                             u'is_mutex': True,
                                                                                                                                             u'is_required': False}},
                                                                                                                   u'hidden': False,
                                                                                                                   u'name': u'update',
                                                                                                                   u'path': [u'gcloud',
                                                                                                                             u'alpha',
                                                                                                                             u'compute',
                                                                                                                             u'backend-services',
                                                                                                                             u'update'],
                                                                                                                   u'positionals': [{u'completer': u'',
                                                                                                                                     u'default': None,
                                                                                                                                     u'description': u'The name of the backend service.',
                                                                                                                                     u'name': u'name',
                                                                                                                                     u'nargs': u'0',
                                                                                                                                     u'required': False,
                                                                                                                                     u'value': u'NAME'}],
                                                                                                                   u'release': u'ALPHA',
                                                                                                                   u'sections': {u'DESCRIPTION': u'\n*update* is used to update backend services.\n'}},
                                                                                                       u'update-backend': {u'capsule': u'*(ALPHA)* Update an existing backend in a backend service.',
                                                                                                                           u'commands': {},
                                                                                                                           u'flags': {u'--balancing-mode': {u'attr': {},
                                                                                                                                                            u'category': u'',
                                                                                                                                                            u'choices': [u'CONNECTION',
                                                                                                                                                                         u'RATE',
                                                                                                                                                                         u'UTILIZATION'],
                                                                                                                                                            u'completer': u'',
                                                                                                                                                            u'default': None,
                                                                                                                                                            u'description': u'Defines the strategy for balancing load.\n+\n*RATE* and the max rate arguments are available only\nin backend services with HTTP based protocols.\n+\nFor backend services with TCP/SSL protocol either *UTILIZATION* or\n*CONNECTION* are available.\n+\n_BALANCING_MODE_ must be one of:\n+\n*CONNECTION*:::           Spreads load based on how many concurrent connections the group\n          can handle. There are two ways to specify max connections:\n          *--max-connections* which defines the max number of connections\n          for the whole group or *--max-connections-per-instance*, which\n          defines the max number of connections on a per-instance basis.\n\n*RATE*:::           Spreads load based on how many requests per second (RPS) the group\n          can handle. There are two ways to specify max RPS: *--max-rate* which\n          defines the max RPS for the whole group or *--max-rate-per-instance*,\n          which defines the max RPS on a per-instance basis.\n\n*UTILIZATION*:::           Relies on the CPU utilization of the instances in the group when\n          balancing load. Use *--max-utilization* to set a maximum target CPU\n          utilization for each instance. Use *--max-rate-per-instance* or\n          *--max-rate* to optionally limit based on RPS in addition to CPU.\n          You can optionally also limit based on connections (for TCP/SSL) in\n          addition to CPU by setting *--max-connections* or\n          *--max-connections-per-instance*.\n\n+',
                                                                                                                                                            u'group': u'',
                                                                                                                                                            u'hidden': False,
                                                                                                                                                            u'name': u'--balancing-mode',
                                                                                                                                                            u'nargs': u'0',
                                                                                                                                                            u'required': False,
                                                                                                                                                            u'type': u'string',
                                                                                                                                                            u'value': u'BALANCING_MODE'},
                                                                                                                                      u'--capacity-scaler': {u'attr': {},
                                                                                                                                                             u'category': u'',
                                                                                                                                                             u'choices': [],
                                                                                                                                                             u'completer': u'',
                                                                                                                                                             u'default': None,
                                                                                                                                                             u'description': u"A float in the range [0.0, 1.0] that scales the maximum\nparameters for the group (e.g., max rate). A value of 0.0 will\ncause no requests to be sent to the group (i.e., it adds the\ngroup in a ``drained'' state).",
                                                                                                                                                             u'group': u'',
                                                                                                                                                             u'hidden': False,
                                                                                                                                                             u'name': u'--capacity-scaler',
                                                                                                                                                             u'nargs': u'0',
                                                                                                                                                             u'required': False,
                                                                                                                                                             u'type': u'string',
                                                                                                                                                             u'value': u'CAPACITY_SCALER'},
                                                                                                                                      u'--description': {u'attr': {},
                                                                                                                                                         u'category': u'',
                                                                                                                                                         u'choices': [],
                                                                                                                                                         u'completer': u'',
                                                                                                                                                         u'default': None,
                                                                                                                                                         u'description': u'An optional, textual description for the backend.',
                                                                                                                                                         u'group': u'',
                                                                                                                                                         u'hidden': False,
                                                                                                                                                         u'name': u'--description',
                                                                                                                                                         u'nargs': u'0',
                                                                                                                                                         u'required': False,
                                                                                                                                                         u'type': u'string',
                                                                                                                                                         u'value': u'DESCRIPTION'},
                                                                                                                                      u'--global': {u'attr': {},
                                                                                                                                                    u'category': u'',
                                                                                                                                                    u'choices': [],
                                                                                                                                                    u'completer': u'',
                                                                                                                                                    u'default': False,
                                                                                                                                                    u'description': u'If provided, it is assumed the backend service is global.',
                                                                                                                                                    u'group': u'update-backend.1',
                                                                                                                                                    u'hidden': False,
                                                                                                                                                    u'name': u'--global',
                                                                                                                                                    u'nargs': u'0',
                                                                                                                                                    u'required': False,
                                                                                                                                                    u'type': u'bool',
                                                                                                                                                    u'value': u'GLOBAL'},
                                                                                                                                      u'--instance-group': {u'attr': {},
                                                                                                                                                            u'category': u'',
                                                                                                                                                            u'choices': [],
                                                                                                                                                            u'completer': u'',
                                                                                                                                                            u'default': None,
                                                                                                                                                            u'description': u'The name of the instance group.',
                                                                                                                                                            u'group': u'',
                                                                                                                                                            u'hidden': False,
                                                                                                                                                            u'name': u'--instance-group',
                                                                                                                                                            u'nargs': u'0',
                                                                                                                                                            u'required': True,
                                                                                                                                                            u'type': u'string',
                                                                                                                                                            u'value': u'INSTANCE_GROUP'},
                                                                                                                                      u'--instance-group-region': {u'attr': {u'property': {u'name': u'compute/region'}},
                                                                                                                                                                   u'category': u'',
                                                                                                                                                                   u'choices': [],
                                                                                                                                                                   u'completer': u'',
                                                                                                                                                                   u'default': None,
                                                                                                                                                                   u'description': u"The region of the instance group to update. If not specified, you will be prompted to select a region.\n+\nTo avoid prompting when this flag is omitted, you can set the\n``compute/region'' property:\n+\n  $ gcloud config set compute/region REGION\n+\nA list of regions can be fetched by running:\n+\n  $ gcloud compute regions list\n+\nTo unset the property, run:\n+\n  $ gcloud config unset compute/region\n+\nAlternatively, the region can be stored in the environment\nvariable ``CLOUDSDK_COMPUTE_REGION''.",
                                                                                                                                                                   u'group': u'update-backend.2',
                                                                                                                                                                   u'hidden': False,
                                                                                                                                                                   u'name': u'--instance-group-region',
                                                                                                                                                                   u'nargs': u'0',
                                                                                                                                                                   u'required': False,
                                                                                                                                                                   u'type': u'string',
                                                                                                                                                                   u'value': u'INSTANCE_GROUP_REGION'},
                                                                                                                                      u'--instance-group-zone': {u'attr': {u'property': {u'name': u'compute/zone'}},
                                                                                                                                                                 u'category': u'',
                                                                                                                                                                 u'choices': [],
                                                                                                                                                                 u'completer': u'',
                                                                                                                                                                 u'default': None,
                                                                                                                                                                 u'description': u"The zone of the instance group to update. If not specified, you will be prompted to select a zone.\n+\nTo avoid prompting when this flag is omitted, you can set the\n``compute/zone'' property:\n+\n  $ gcloud config set compute/zone ZONE\n+\nA list of zones can be fetched by running:\n+\n  $ gcloud compute zones list\n+\nTo unset the property, run:\n+\n  $ gcloud config unset compute/zone\n+\nAlternatively, the zone can be stored in the environment variable\n``CLOUDSDK_COMPUTE_ZONE''.",
                                                                                                                                                                 u'group': u'update-backend.2',
                                                                                                                                                                 u'hidden': False,
                                                                                                                                                                 u'name': u'--instance-group-zone',
                                                                                                                                                                 u'nargs': u'0',
                                                                                                                                                                 u'required': False,
                                                                                                                                                                 u'type': u'string',
                                                                                                                                                                 u'value': u'INSTANCE_GROUP_ZONE'},
                                                                                                                                      u'--max-connections': {u'attr': {},
                                                                                                                                                             u'category': u'',
                                                                                                                                                             u'choices': [],
                                                                                                                                                             u'completer': u'',
                                                                                                                                                             u'default': None,
                                                                                                                                                             u'description': u'Maximum concurrent connections that the group can handle.',
                                                                                                                                                             u'group': u'update-backend.3',
                                                                                                                                                             u'hidden': False,
                                                                                                                                                             u'name': u'--max-connections',
                                                                                                                                                             u'nargs': u'0',
                                                                                                                                                             u'required': False,
                                                                                                                                                             u'type': u'string',
                                                                                                                                                             u'value': u'MAX_CONNECTIONS'},
                                                                                                                                      u'--max-connections-per-instance': {u'attr': {},
                                                                                                                                                                          u'category': u'',
                                                                                                                                                                          u'choices': [],
                                                                                                                                                                          u'completer': u'',
                                                                                                                                                                          u'default': None,
                                                                                                                                                                          u'description': u'The maximum concurrent connections per-instance.',
                                                                                                                                                                          u'group': u'update-backend.3',
                                                                                                                                                                          u'hidden': False,
                                                                                                                                                                          u'name': u'--max-connections-per-instance',
                                                                                                                                                                          u'nargs': u'0',
                                                                                                                                                                          u'required': False,
                                                                                                                                                                          u'type': u'string',
                                                                                                                                                                          u'value': u'MAX_CONNECTIONS_PER_INSTANCE'},
                                                                                                                                      u'--max-rate': {u'attr': {},
                                                                                                                                                      u'category': u'',
                                                                                                                                                      u'choices': [],
                                                                                                                                                      u'completer': u'',
                                                                                                                                                      u'default': None,
                                                                                                                                                      u'description': u'Maximum requests per second (RPS) that the group can handle.',
                                                                                                                                                      u'group': u'update-backend.3',
                                                                                                                                                      u'hidden': False,
                                                                                                                                                      u'name': u'--max-rate',
                                                                                                                                                      u'nargs': u'0',
                                                                                                                                                      u'required': False,
                                                                                                                                                      u'type': u'string',
                                                                                                                                                      u'value': u'MAX_RATE'},
                                                                                                                                      u'--max-rate-per-instance': {u'attr': {},
                                                                                                                                                                   u'category': u'',
                                                                                                                                                                   u'choices': [],
                                                                                                                                                                   u'completer': u'',
                                                                                                                                                                   u'default': None,
                                                                                                                                                                   u'description': u'The maximum per-instance requests per second (RPS).',
                                                                                                                                                                   u'group': u'update-backend.3',
                                                                                                                                                                   u'hidden': False,
                                                                                                                                                                   u'name': u'--max-rate-per-instance',
                                                                                                                                                                   u'nargs': u'0',
                                                                                                                                                                   u'required': False,
                                                                                                                                                                   u'type': u'string',
                                                                                                                                                                   u'value': u'MAX_RATE_PER_INSTANCE'},
                                                                                                                                      u'--max-utilization': {u'attr': {},
                                                                                                                                                             u'category': u'',
                                                                                                                                                             u'choices': [],
                                                                                                                                                             u'completer': u'',
                                                                                                                                                             u'default': None,
                                                                                                                                                             u'description': u'The target CPU utilization for the group as a float in the range\n[0.0, 1.0]. This flag can only be provided when the balancing\nmode is *UTILIZATION*.',
                                                                                                                                                             u'group': u'',
                                                                                                                                                             u'hidden': False,
                                                                                                                                                             u'name': u'--max-utilization',
                                                                                                                                                             u'nargs': u'0',
                                                                                                                                                             u'required': False,
                                                                                                                                                             u'type': u'string',
                                                                                                                                                             u'value': u'MAX_UTILIZATION'},
                                                                                                                                      u'--region': {u'attr': {u'property': {u'name': u'compute/region'}},
                                                                                                                                                    u'category': u'',
                                                                                                                                                    u'choices': [],
                                                                                                                                                    u'completer': u'',
                                                                                                                                                    u'default': None,
                                                                                                                                                    u'description': u'The region of the backend service to operate on. Overrides the default *compute/region* property value for this command invocation.',
                                                                                                                                                    u'group': u'update-backend.1',
                                                                                                                                                    u'hidden': False,
                                                                                                                                                    u'name': u'--region',
                                                                                                                                                    u'nargs': u'0',
                                                                                                                                                    u'required': False,
                                                                                                                                                    u'type': u'string',
                                                                                                                                                    u'value': u'REGION'}},
                                                                                                                           u'group': False,
                                                                                                                           u'groups': {u'update-backend.1': {u'description': u'At most one of these may be specified:',
                                                                                                                                                             u'is_mutex': True,
                                                                                                                                                             u'is_required': False},
                                                                                                                                       u'update-backend.2': {u'description': u'At most one of these may be specified:',
                                                                                                                                                             u'is_mutex': True,
                                                                                                                                                             u'is_required': False},
                                                                                                                                       u'update-backend.3': {u'description': u'At most one of these may be specified:',
                                                                                                                                                             u'is_mutex': True,
                                                                                                                                                             u'is_required': False}},
                                                                                                                           u'hidden': False,
                                                                                                                           u'name': u'update-backend',
                                                                                                                           u'path': [u'gcloud',
                                                                                                                                     u'alpha',
                                                                                                                                     u'compute',
                                                                                                                                     u'backend-services',
                                                                                                                                     u'update-backend'],
                                                                                                                           u'positionals': [{u'completer': u'',
                                                                                                                                             u'default': None,
                                                                                                                                             u'description': u'The name of the backend service.',
                                                                                                                                             u'name': u'name',
                                                                                                                                             u'nargs': u'0',
                                                                                                                                             u'required': False,
                                                                                                                                             u'value': u'NAME'}],
                                                                                                                           u'release': u'ALPHA',
                                                                                                                           u'sections': {u'DESCRIPTION': u'\n*update-backend* updates a backend that is part of a backend\nservice. This is useful for changing the way a backend\nbehaves. Example changes that can be made include changing the\nload balancing policy and ``draining\'\' a backend by setting\nits capacity scaler to zero.\n\nBackends are named by their associated instances groups, and one\nof the ``--group\'\' or ``--instance-group\'\' flags is required to\nidentify the backend that you are modifying.  You cannot "change"\nthe instance group associated with a backend, but you can accomplish\nsomething similar with ``backend-services remove-backend\'\' and\n``backend-services add-backend\'\'.\n\n`gcloud compute backend-services edit` can also be used to\nupdate a backend if the use of a text editor is desired.\n'}}},
                                                                                         u'flags': {},
                                                                                         u'group': True,
                                                                                         u'groups': {},
                                                                                         u'hidden': False,
                                                                                         u'name': u'backend-services',
                                                                                         u'path': [u'gcloud',
                                                                                                   u'alpha',
                                                                                                   u'compute',
                                                                                                   u'backend-services'],
                                                                                         u'positionals': [],
                                                                                         u'release': u'ALPHA',
                                                                                         u'sections': {u'DESCRIPTION': u'*(ALPHA)* List, create, and delete backend services.'}},
                                                                   u'config-ssh': {u'capsule': u'*(ALPHA)* Populate SSH config files with Host entries from each instance.',
                                                                                   u'commands': {},
                                                                                   u'flags': {u'--dry-run': {u'attr': {},
                                                                                                             u'category': u'',
                                                                                                             u'choices': [],
                                                                                                             u'completer': u'',
                                                                                                             u'default': False,
                                                                                                             u'description': u'If provided, the proposed changes to the SSH config file are printed to standard output and no actual changes are made.',
                                                                                                             u'group': u'',
                                                                                                             u'hidden': False,
                                                                                                             u'name': u'--dry-run',
                                                                                                             u'nargs': u'0',
                                                                                                             u'required': False,
                                                                                                             u'type': u'bool',
                                                                                                             u'value': u'DRY_RUN'},
                                                                                              u'--force-key-file-overwrite': {u'attr': {},
                                                                                                                              u'category': u'',
                                                                                                                              u'choices': [],
                                                                                                                              u'completer': u'',
                                                                                                                              u'default': False,
                                                                                                                              u'description': u'If enabled gcloud will regenerate and overwrite the files associated\nwith a broken SSH key without asking for confirmation in both\ninteractive and non-interactive environment.\n+\nIf disabled gcloud will not attempt to regenerate the files associated\nwith a broken SSH key and fail in both interactive and non-interactive\nenvironment.',
                                                                                                                              u'group': u'',
                                                                                                                              u'hidden': False,
                                                                                                                              u'name': u'--force-key-file-overwrite',
                                                                                                                              u'nargs': u'0',
                                                                                                                              u'required': False,
                                                                                                                              u'type': u'bool',
                                                                                                                              u'value': u'FORCE_KEY_FILE_OVERWRITE'},
                                                                                              u'--no-dry-run': {u'attr': {},
                                                                                                                u'category': u'',
                                                                                                                u'choices': [],
                                                                                                                u'completer': u'',
                                                                                                                u'default': True,
                                                                                                                u'description': u'',
                                                                                                                u'group': u'',
                                                                                                                u'hidden': True,
                                                                                                                u'name': u'--no-dry-run',
                                                                                                                u'nargs': u'0',
                                                                                                                u'required': False,
                                                                                                                u'type': u'bool',
                                                                                                                u'value': u'NO_DRY_RUN'},
                                                                                              u'--no-force-key-file-overwrite': {u'attr': {},
                                                                                                                                 u'category': u'',
                                                                                                                                 u'choices': [],
                                                                                                                                 u'completer': u'',
                                                                                                                                 u'default': False,
                                                                                                                                 u'description': u'',
                                                                                                                                 u'group': u'',
                                                                                                                                 u'hidden': True,
                                                                                                                                 u'name': u'--no-force-key-file-overwrite',
                                                                                                                                 u'nargs': u'0',
                                                                                                                                 u'required': False,
                                                                                                                                 u'type': u'bool',
                                                                                                                                 u'value': u'NO_FORCE_KEY_FILE_OVERWRITE'},
                                                                                              u'--no-remove': {u'attr': {},
                                                                                                               u'category': u'',
                                                                                                               u'choices': [],
                                                                                                               u'completer': u'',
                                                                                                               u'default': True,
                                                                                                               u'description': u'',
                                                                                                               u'group': u'',
                                                                                                               u'hidden': True,
                                                                                                               u'name': u'--no-remove',
                                                                                                               u'nargs': u'0',
                                                                                                               u'required': False,
                                                                                                               u'type': u'bool',
                                                                                                               u'value': u'NO_REMOVE'},
                                                                                              u'--remove': {u'attr': {},
                                                                                                            u'category': u'',
                                                                                                            u'choices': [],
                                                                                                            u'completer': u'',
                                                                                                            u'default': False,
                                                                                                            u'description': u'If provided, any changes made to the SSH config file by this tool are reverted.',
                                                                                                            u'group': u'',
                                                                                                            u'hidden': False,
                                                                                                            u'name': u'--remove',
                                                                                                            u'nargs': u'0',
                                                                                                            u'required': False,
                                                                                                            u'type': u'bool',
                                                                                                            u'value': u'REMOVE'},
                                                                                              u'--ssh-config-file': {u'attr': {},
                                                                                                                     u'category': u'',
                                                                                                                     u'choices': [],
                                                                                                                     u'completer': u'',
                                                                                                                     u'default': None,
                                                                                                                     u'description': u"Specifies an alternative per-user SSH configuration file. By\ndefault, this is ``~/.ssh/config''.",
                                                                                                                     u'group': u'',
                                                                                                                     u'hidden': False,
                                                                                                                     u'name': u'--ssh-config-file',
                                                                                                                     u'nargs': u'0',
                                                                                                                     u'required': False,
                                                                                                                     u'type': u'string',
                                                                                                                     u'value': u'SSH_CONFIG_FILE'},
                                                                                              u'--ssh-key-file': {u'attr': {},
                                                                                                                  u'category': u'',
                                                                                                                  u'choices': [],
                                                                                                                  u'completer': u'',
                                                                                                                  u'default': None,
                                                                                                                  u'description': u"The path to the SSH key file. By default, this is ``~/.ssh/google_compute_engine''.",
                                                                                                                  u'group': u'',
                                                                                                                  u'hidden': False,
                                                                                                                  u'name': u'--ssh-key-file',
                                                                                                                  u'nargs': u'0',
                                                                                                                  u'required': False,
                                                                                                                  u'type': u'string',
                                                                                                                  u'value': u'SSH_KEY_FILE'}},
                                                                                   u'group': False,
                                                                                   u'groups': {},
                                                                                   u'hidden': False,
                                                                                   u'name': u'config-ssh',
                                                                                   u'path': [u'gcloud',
                                                                                             u'alpha',
                                                                                             u'compute',
                                                                                             u'config-ssh'],
                                                                                   u'positionals': [],
                                                                                   u'release': u'ALPHA',
                                                                                   u'sections': {u'DESCRIPTION': u"*config-ssh* makes SSHing to virtual machine instances easier\nby adding an alias for each instance to the user SSH configuration\n(``~/.ssh/config'') file.\n\nIn most cases, it is sufficient to run:\n\n  $ config-ssh\n\nEach instance will be given an alias of the form\n``NAME.ZONE.PROJECT''. For example, if ``example-instance'' resides in\n``us-central1-a'', you can SSH to it by running:\n\n  $ ssh example-instance.us-central1-a.MY-PROJECT\n\nOn some platforms, the host alias can be tab-completed, making\nthe long alias less daunting to type.\n\nThe aliases created interface with SSH-based programs like\n*scp(1)*, so it is possible to use the aliases elsewhere:\n\n  $ scp ~/MY-FILE example-instance.us-central1-a.MY-PROJECT:~\n\nWhenever instances are added, removed, or their external IP\naddresses are changed, this command should be re-executed to\nupdate the configuration.\n\nThis command ensures that the user's public SSH key is present\nin the project's metadata. If the user does not have a public\nSSH key, one is generated using *ssh-keygen(1)* (if the `--quiet`\nflag is given, the generated key will have an empty passphrase).\n"}},
                                                                   u'connect-to-serial-port': {u'capsule': u'*(ALPHA)* Connect to the serial port of an instance.',
                                                                                               u'commands': {},
                                                                                               u'flags': {u'--dry-run': {u'attr': {},
                                                                                                                         u'category': u'',
                                                                                                                         u'choices': [],
                                                                                                                         u'completer': u'',
                                                                                                                         u'default': False,
                                                                                                                         u'description': u'If provided, the ssh command is printed to standard out rather than being executed.',
                                                                                                                         u'group': u'',
                                                                                                                         u'hidden': False,
                                                                                                                         u'name': u'--dry-run',
                                                                                                                         u'nargs': u'0',
                                                                                                                         u'required': False,
                                                                                                                         u'type': u'bool',
                                                                                                                         u'value': u'DRY_RUN'},
                                                                                                          u'--extra-args': {u'attr': {},
                                                                                                                            u'category': u'',
                                                                                                                            u'choices': [],
                                                                                                                            u'completer': u'',
                                                                                                                            u'default': {},
                                                                                                                            u'description': u'Optional arguments can be passed to the serial port connection by\npassing key-value pairs to this flag, such as max-connections=N or\nreplay-lines=N. See https://cloud.google.com/compute/docs/instances/interacting-with-serial-console for additional options.',
                                                                                                                            u'group': u'',
                                                                                                                            u'hidden': False,
                                                                                                                            u'name': u'--extra-args',
                                                                                                                            u'nargs': u'0',
                                                                                                                            u'required': False,
                                                                                                                            u'type': u'dict',
                                                                                                                            u'value': u'KEY=VALUE'},
                                                                                                          u'--force-key-file-overwrite': {u'attr': {},
                                                                                                                                          u'category': u'',
                                                                                                                                          u'choices': [],
                                                                                                                                          u'completer': u'',
                                                                                                                                          u'default': False,
                                                                                                                                          u'description': u'If enabled gcloud will regenerate and overwrite the files associated\nwith a broken SSH key without asking for confirmation in both\ninteractive and non-interactive environment.\n+\nIf disabled gcloud will not attempt to regenerate the files associated\nwith a broken SSH key and fail in both interactive and non-interactive\nenvironment.',
                                                                                                                                          u'group': u'',
                                                                                                                                          u'hidden': False,
                                                                                                                                          u'name': u'--force-key-file-overwrite',
                                                                                                                                          u'nargs': u'0',
                                                                                                                                          u'required': False,
                                                                                                                                          u'type': u'bool',
                                                                                                                                          u'value': u'FORCE_KEY_FILE_OVERWRITE'},
                                                                                                          u'--no-dry-run': {u'attr': {},
                                                                                                                            u'category': u'',
                                                                                                                            u'choices': [],
                                                                                                                            u'completer': u'',
                                                                                                                            u'default': True,
                                                                                                                            u'description': u'',
                                                                                                                            u'group': u'',
                                                                                                                            u'hidden': True,
                                                                                                                            u'name': u'--no-dry-run',
                                                                                                                            u'nargs': u'0',
                                                                                                                            u'required': False,
                                                                                                                            u'type': u'bool',
                                                                                                                            u'value': u'NO_DRY_RUN'},
                                                                                                          u'--no-force-key-file-overwrite': {u'attr': {},
                                                                                                                                             u'category': u'',
                                                                                                                                             u'choices': [],
                                                                                                                                             u'completer': u'',
                                                                                                                                             u'default': False,
                                                                                                                                             u'description': u'',
                                                                                                                                             u'group': u'',
                                                                                                                                             u'hidden': True,
                                                                                                                                             u'name': u'--no-force-key-file-overwrite',
                                                                                                                                             u'nargs': u'0',
                                                                                                                                             u'required': False,
                                                                                                                                             u'type': u'bool',
                                                                                                                                             u'value': u'NO_FORCE_KEY_FILE_OVERWRITE'},
                                                                                                          u'--no-plain': {u'attr': {},
                                                                                                                          u'category': u'',
                                                                                                                          u'choices': [],
                                                                                                                          u'completer': u'',
                                                                                                                          u'default': True,
                                                                                                                          u'description': u'',
                                                                                                                          u'group': u'',
                                                                                                                          u'hidden': True,
                                                                                                                          u'name': u'--no-plain',
                                                                                                                          u'nargs': u'0',
                                                                                                                          u'required': False,
                                                                                                                          u'type': u'bool',
                                                                                                                          u'value': u'NO_PLAIN'},
                                                                                                          u'--plain': {u'attr': {},
                                                                                                                       u'category': u'',
                                                                                                                       u'choices': [],
                                                                                                                       u'completer': u'',
                                                                                                                       u'default': False,
                                                                                                                       u'description': u'',
                                                                                                                       u'group': u'',
                                                                                                                       u'hidden': True,
                                                                                                                       u'name': u'--plain',
                                                                                                                       u'nargs': u'0',
                                                                                                                       u'required': False,
                                                                                                                       u'type': u'bool',
                                                                                                                       u'value': u'PLAIN'},
                                                                                                          u'--port': {u'attr': {},
                                                                                                                      u'category': u'',
                                                                                                                      u'choices': [],
                                                                                                                      u'completer': u'',
                                                                                                                      u'default': None,
                                                                                                                      u'description': u'The number of the requested serial port. Can be 1-4, default is 1.\n+\nInstances can support up to four serial ports. By default, this\ncommand will connect to the first serial port. Setting this flag\nwill connect to the requested serial port.',
                                                                                                                      u'group': u'',
                                                                                                                      u'hidden': False,
                                                                                                                      u'name': u'--port',
                                                                                                                      u'nargs': u'0',
                                                                                                                      u'required': False,
                                                                                                                      u'type': u'string',
                                                                                                                      u'value': u'PORT'},
                                                                                                          u'--serial-port-gateway': {u'attr': {},
                                                                                                                                     u'category': u'',
                                                                                                                                     u'choices': [],
                                                                                                                                     u'completer': u'',
                                                                                                                                     u'default': u'ssh-serialport.googleapis.com',
                                                                                                                                     u'description': u'',
                                                                                                                                     u'group': u'',
                                                                                                                                     u'hidden': True,
                                                                                                                                     u'name': u'--serial-port-gateway',
                                                                                                                                     u'nargs': u'0',
                                                                                                                                     u'required': False,
                                                                                                                                     u'type': u'string',
                                                                                                                                     u'value': u'SERIAL_PORT_GATEWAY'},
                                                                                                          u'--ssh-key-file': {u'attr': {},
                                                                                                                              u'category': u'',
                                                                                                                              u'choices': [],
                                                                                                                              u'completer': u'',
                                                                                                                              u'default': None,
                                                                                                                              u'description': u"The path to the SSH key file. By default, this is ``~/.ssh/google_compute_engine''.",
                                                                                                                              u'group': u'',
                                                                                                                              u'hidden': False,
                                                                                                                              u'name': u'--ssh-key-file',
                                                                                                                              u'nargs': u'0',
                                                                                                                              u'required': False,
                                                                                                                              u'type': u'string',
                                                                                                                              u'value': u'SSH_KEY_FILE'},
                                                                                                          u'--zone': {u'attr': {u'property': {u'name': u'compute/zone'}},
                                                                                                                      u'category': u'',
                                                                                                                      u'choices': [],
                                                                                                                      u'completer': u'',
                                                                                                                      u'default': None,
                                                                                                                      u'description': u"The zone of the instance to connect to. If not specified, you will be prompted to select a zone.\n+\nTo avoid prompting when this flag is omitted, you can set the\n``compute/zone'' property:\n+\n  $ gcloud config set compute/zone ZONE\n+\nA list of zones can be fetched by running:\n+\n  $ gcloud compute zones list\n+\nTo unset the property, run:\n+\n  $ gcloud config unset compute/zone\n+\nAlternatively, the zone can be stored in the environment variable\n``CLOUDSDK_COMPUTE_ZONE''.",
                                                                                                                      u'group': u'',
                                                                                                                      u'hidden': False,
                                                                                                                      u'name': u'--zone',
                                                                                                                      u'nargs': u'0',
                                                                                                                      u'required': False,
                                                                                                                      u'type': u'string',
                                                                                                                      u'value': u'ZONE'}},
                                                                                               u'group': False,
                                                                                               u'groups': {},
                                                                                               u'hidden': False,
                                                                                               u'name': u'connect-to-serial-port',
                                                                                               u'path': [u'gcloud',
                                                                                                         u'alpha',
                                                                                                         u'compute',
                                                                                                         u'connect-to-serial-port'],
                                                                                               u'positionals': [{u'completer': u'',
                                                                                                                 u'default': None,
                                                                                                                 u'description': u"Specifies the user/instance for the serial port connection.\n+\n``USER'' specifies the username to authenticate as. If omitted,\nthe current OS user is selected.",
                                                                                                                 u'name': u'user-host',
                                                                                                                 u'nargs': u'0',
                                                                                                                 u'required': False,
                                                                                                                 u'value': u'[USER@]INSTANCE'}],
                                                                                               u'release': u'ALPHA',
                                                                                               u'sections': {u'DESCRIPTION': u"*connect-to-serial-port* allows users to connect to, and interact with, a VM's\nvirtual serial port using ssh as the secure, authenticated transport\nprotocol.\n\nThe user must first enable serial port access to a given VM by setting\nthe 'serial-port-enable=true' metadata key-value pair. Setting\n'serial-port-enable' on the project-level metadata enables serial port\naccess to all VMs in the project.\n\nThis command uses the same SSH key pair as the `gcloud compute ssh`\ncommand and also ensures that the user's public SSH key is present in\nthe project's metadata. If the user does not have a public SSH key,\none is generated using ssh-keygen.\n"}},
                                                                   u'copy-files': {u'capsule': u'*(ALPHA)* Copy files to and from Google Compute Engine virtual machines.',
                                                                                   u'commands': {},
                                                                                   u'flags': {u'--dry-run': {u'attr': {},
                                                                                                             u'category': u'',
                                                                                                             u'choices': [],
                                                                                                             u'completer': u'',
                                                                                                             u'default': False,
                                                                                                             u'description': u'If provided, prints the command that would be run to standard out instead of executing it.',
                                                                                                             u'group': u'',
                                                                                                             u'hidden': False,
                                                                                                             u'name': u'--dry-run',
                                                                                                             u'nargs': u'0',
                                                                                                             u'required': False,
                                                                                                             u'type': u'bool',
                                                                                                             u'value': u'DRY_RUN'},
                                                                                              u'--force-key-file-overwrite': {u'attr': {},
                                                                                                                              u'category': u'',
                                                                                                                              u'choices': [],
                                                                                                                              u'completer': u'',
                                                                                                                              u'default': False,
                                                                                                                              u'description': u'If enabled gcloud will regenerate and overwrite the files associated\nwith a broken SSH key without asking for confirmation in both\ninteractive and non-interactive environment.\n+\nIf disabled gcloud will not attempt to regenerate the files associated\nwith a broken SSH key and fail in both interactive and non-interactive\nenvironment.',
                                                                                                                              u'group': u'',
                                                                                                                              u'hidden': False,
                                                                                                                              u'name': u'--force-key-file-overwrite',
                                                                                                                              u'nargs': u'0',
                                                                                                                              u'required': False,
                                                                                                                              u'type': u'bool',
                                                                                                                              u'value': u'FORCE_KEY_FILE_OVERWRITE'},
                                                                                              u'--no-dry-run': {u'attr': {},
                                                                                                                u'category': u'',
                                                                                                                u'choices': [],
                                                                                                                u'completer': u'',
                                                                                                                u'default': True,
                                                                                                                u'description': u'',
                                                                                                                u'group': u'',
                                                                                                                u'hidden': True,
                                                                                                                u'name': u'--no-dry-run',
                                                                                                                u'nargs': u'0',
                                                                                                                u'required': False,
                                                                                                                u'type': u'bool',
                                                                                                                u'value': u'NO_DRY_RUN'},
                                                                                              u'--no-force-key-file-overwrite': {u'attr': {},
                                                                                                                                 u'category': u'',
                                                                                                                                 u'choices': [],
                                                                                                                                 u'completer': u'',
                                                                                                                                 u'default': False,
                                                                                                                                 u'description': u'',
                                                                                                                                 u'group': u'',
                                                                                                                                 u'hidden': True,
                                                                                                                                 u'name': u'--no-force-key-file-overwrite',
                                                                                                                                 u'nargs': u'0',
                                                                                                                                 u'required': False,
                                                                                                                                 u'type': u'bool',
                                                                                                                                 u'value': u'NO_FORCE_KEY_FILE_OVERWRITE'},
                                                                                              u'--no-plain': {u'attr': {},
                                                                                                              u'category': u'',
                                                                                                              u'choices': [],
                                                                                                              u'completer': u'',
                                                                                                              u'default': True,
                                                                                                              u'description': u'',
                                                                                                              u'group': u'',
                                                                                                              u'hidden': True,
                                                                                                              u'name': u'--no-plain',
                                                                                                              u'nargs': u'0',
                                                                                                              u'required': False,
                                                                                                              u'type': u'bool',
                                                                                                              u'value': u'NO_PLAIN'},
                                                                                              u'--plain': {u'attr': {},
                                                                                                           u'category': u'',
                                                                                                           u'choices': [],
                                                                                                           u'completer': u'',
                                                                                                           u'default': False,
                                                                                                           u'description': u'Suppresses the automatic addition of *ssh(1)*/*scp(1)* flags. This flag\nis useful if you want to take care of authentication yourself or\nuse specific ssh/scp features.',
                                                                                                           u'group': u'',
                                                                                                           u'hidden': False,
                                                                                                           u'name': u'--plain',
                                                                                                           u'nargs': u'0',
                                                                                                           u'required': False,
                                                                                                           u'type': u'bool',
                                                                                                           u'value': u'PLAIN'},
                                                                                              u'--ssh-key-file': {u'attr': {},
                                                                                                                  u'category': u'',
                                                                                                                  u'choices': [],
                                                                                                                  u'completer': u'',
                                                                                                                  u'default': None,
                                                                                                                  u'description': u"The path to the SSH key file. By default, this is ``~/.ssh/google_compute_engine''.",
                                                                                                                  u'group': u'',
                                                                                                                  u'hidden': False,
                                                                                                                  u'name': u'--ssh-key-file',
                                                                                                                  u'nargs': u'0',
                                                                                                                  u'required': False,
                                                                                                                  u'type': u'string',
                                                                                                                  u'value': u'SSH_KEY_FILE'},
                                                                                              u'--strict-host-key-checking': {u'attr': {},
                                                                                                                              u'category': u'',
                                                                                                                              u'choices': [u'yes',
                                                                                                                                           u'no',
                                                                                                                                           u'ask'],
                                                                                                                              u'completer': u'',
                                                                                                                              u'default': None,
                                                                                                                              u'description': u"Override the default behavior of StrictHostKeyChecking. By default,\nStrictHostKeyChecking is set to 'no' the first time you connect to an\ninstance and will be set to 'yes' for all subsequent connections. Use\nthis flag to specify a value for the connection. _STRICT_HOST_KEY_CHECKING_ must be one of: *yes*, *no*, *ask*.",
                                                                                                                              u'group': u'',
                                                                                                                              u'hidden': False,
                                                                                                                              u'name': u'--strict-host-key-checking',
                                                                                                                              u'nargs': u'0',
                                                                                                                              u'required': False,
                                                                                                                              u'type': u'string',
                                                                                                                              u'value': u'STRICT_HOST_KEY_CHECKING'},
                                                                                              u'--zone': {u'attr': {u'property': {u'name': u'compute/zone'}},
                                                                                                          u'category': u'',
                                                                                                          u'choices': [],
                                                                                                          u'completer': u'',
                                                                                                          u'default': None,
                                                                                                          u'description': u"The zone of the instance to copy files to/from. If omitted,\nyou will be prompted to select a zone.\n+\nIf not specified, you will be prompted to select a zone.\n+\nTo avoid prompting when this flag is omitted, you can set the\n``compute/zone'' property:\n+\n  $ gcloud config set compute/zone ZONE\n+\nA list of zones can be fetched by running:\n+\n  $ gcloud compute zones list\n+\nTo unset the property, run:\n+\n  $ gcloud config unset compute/zone\n+\nAlternatively, the zone can be stored in the environment variable\n``CLOUDSDK_COMPUTE_ZONE''.",
                                                                                                          u'group': u'',
                                                                                                          u'hidden': False,
                                                                                                          u'name': u'--zone',
                                                                                                          u'nargs': u'0',
                                                                                                          u'required': False,
                                                                                                          u'type': u'string',
                                                                                                          u'value': u'ZONE'}},
                                                                                   u'group': False,
                                                                                   u'groups': {},
                                                                                   u'hidden': False,
                                                                                   u'name': u'copy-files',
                                                                                   u'path': [u'gcloud',
                                                                                             u'alpha',
                                                                                             u'compute',
                                                                                             u'copy-files'],
                                                                                   u'positionals': [{u'completer': u'',
                                                                                                     u'default': None,
                                                                                                     u'description': u'Specifies a source file.',
                                                                                                     u'name': u'sources',
                                                                                                     u'nargs': u'+',
                                                                                                     u'required': False,
                                                                                                     u'value': u'[[USER@]INSTANCE:]SRC'},
                                                                                                    {u'completer': u'',
                                                                                                     u'default': None,
                                                                                                     u'description': u'Specifies a destination for the source files.',
                                                                                                     u'name': u'destination',
                                                                                                     u'nargs': u'0',
                                                                                                     u'required': False,
                                                                                                     u'value': u'[[USER@]INSTANCE:]DEST'}],
                                                                                   u'release': u'ALPHA',
                                                                                   u'sections': {u'DESCRIPTION': u"*copy-files* copies files between a virtual machine instance\nand your local machine.\n\nTo denote a remote file, prefix the file name with the virtual\nmachine instance name (e.g., _example-instance_:~/_FILE_). To\ndenote a local file, do not add a prefix to the file name\n(e.g., ~/_FILE_). For example, to copy a remote directory\nto your local host, run:\n\n  $ copy-files example-instance:~/REMOTE-DIR ~/LOCAL-DIR --zone us-central1-a\n\nIn the above example, ``~/REMOTE-DIR'' from ``example-instance'' is\ncopied into the ~/_LOCAL-DIR_ directory.\n\nConversely, files from your local computer can be copied to a\nvirtual machine:\n\n  $ copy-files ~/LOCAL-FILE-1 ~/LOCAL-FILE-2 example-instance:~/REMOTE-DIR --zone us-central1-a\n\nIf a file contains a colon (``:''), you must specify it by\neither using an absolute path or a path that begins with\n``./''.\n\nUnder the covers, *scp(1)* is used to facilitate the transfer.\n\nWhen the destination is local, all sources must be the same\nvirtual machine instance. When the destination is remote, all\nsource must be local.\n\nThis command ensures that the user's public SSH key is present\nin the project's metadata. If the user does not have a public\nSSH key, one is generated using *ssh-keygen(1)* (if the the `--quiet`\nflag is given, the generated key will have an empty passphrase).\n"}},
                                                                   u'disk-types': {u'capsule': u'*(ALPHA)* Read Google Compute Engine virtual disk types.',
                                                                                   u'commands': {u'describe': {u'capsule': u'*(ALPHA)* Describe a Google Compute Engine disk type.',
                                                                                                               u'commands': {},
                                                                                                               u'flags': {u'--zone': {u'attr': {u'property': {u'name': u'compute/zone'}},
                                                                                                                                      u'category': u'',
                                                                                                                                      u'choices': [],
                                                                                                                                      u'completer': u'',
                                                                                                                                      u'default': None,
                                                                                                                                      u'description': u"The zone of the resource to fetch. If not specified, you will be prompted to select a zone.\n+\nTo avoid prompting when this flag is omitted, you can set the\n``compute/zone'' property:\n+\n  $ gcloud config set compute/zone ZONE\n+\nA list of zones can be fetched by running:\n+\n  $ gcloud compute zones list\n+\nTo unset the property, run:\n+\n  $ gcloud config unset compute/zone\n+\nAlternatively, the zone can be stored in the environment variable\n``CLOUDSDK_COMPUTE_ZONE''.",
                                                                                                                                      u'group': u'',
                                                                                                                                      u'hidden': False,
                                                                                                                                      u'name': u'--zone',
                                                                                                                                      u'nargs': u'0',
                                                                                                                                      u'required': False,
                                                                                                                                      u'type': u'string',
                                                                                                                                      u'value': u'ZONE'}},
                                                                                                               u'group': False,
                                                                                                               u'groups': {},
                                                                                                               u'hidden': False,
                                                                                                               u'name': u'describe',
                                                                                                               u'path': [u'gcloud',
                                                                                                                         u'alpha',
                                                                                                                         u'compute',
                                                                                                                         u'disk-types',
                                                                                                                         u'describe'],
                                                                                                               u'positionals': [{u'completer': u'',
                                                                                                                                 u'default': None,
                                                                                                                                 u'description': u'The name of the resource to fetch.',
                                                                                                                                 u'name': u'name',
                                                                                                                                 u'nargs': u'0',
                                                                                                                                 u'required': False,
                                                                                                                                 u'value': u'NAME'}],
                                                                                                               u'release': u'ALPHA',
                                                                                                               u'sections': {u'DESCRIPTION': u'*describe* displays all data associated with a Google Compute\nEngine disk type.\n'}},
                                                                                                 u'list': {u'capsule': u'*(ALPHA)* List Google Compute Engine disk types.',
                                                                                                           u'commands': {},
                                                                                                           u'flags': {u'--filter': {u'attr': {},
                                                                                                                                    u'category': u'LIST COMMAND',
                                                                                                                                    u'choices': [],
                                                                                                                                    u'completer': u'',
                                                                                                                                    u'default': None,
                                                                                                                                    u'description': u'Apply a Boolean filter _EXPRESSION_ to each resource item to be listed.\nIf the expression evaluates True then that item is listed. For more\ndetails and examples of filter expressions run $ gcloud topic filters. This\nflag interacts with other flags that are applied in this order: *--flatten*,\n*--sort-by*, *--filter*, *--limit*.',
                                                                                                                                    u'group': u'',
                                                                                                                                    u'hidden': False,
                                                                                                                                    u'name': u'--filter',
                                                                                                                                    u'nargs': u'0',
                                                                                                                                    u'required': False,
                                                                                                                                    u'type': u'string',
                                                                                                                                    u'value': u'EXPRESSION'},
                                                                                                                      u'--limit': {u'attr': {},
                                                                                                                                   u'category': u'LIST COMMAND',
                                                                                                                                   u'choices': [],
                                                                                                                                   u'completer': u'',
                                                                                                                                   u'default': None,
                                                                                                                                   u'description': u'The maximum number of resources to list. The default is *unlimited*.\nThis flag interacts with other flags that are applied in this order:\n*--flatten*, *--sort-by*, *--filter*, *--limit*.',
                                                                                                                                   u'group': u'',
                                                                                                                                   u'hidden': False,
                                                                                                                                   u'name': u'--limit',
                                                                                                                                   u'nargs': u'0',
                                                                                                                                   u'required': False,
                                                                                                                                   u'type': u'string',
                                                                                                                                   u'value': u'LIMIT'},
                                                                                                                      u'--no-uri': {u'attr': {},
                                                                                                                                    u'category': u'LIST COMMAND',
                                                                                                                                    u'choices': [],
                                                                                                                                    u'completer': u'',
                                                                                                                                    u'default': True,
                                                                                                                                    u'description': u'',
                                                                                                                                    u'group': u'',
                                                                                                                                    u'hidden': True,
                                                                                                                                    u'name': u'--no-uri',
                                                                                                                                    u'nargs': u'0',
                                                                                                                                    u'required': False,
                                                                                                                                    u'type': u'bool',
                                                                                                                                    u'value': u'NO_URI'},
                                                                                                                      u'--page-size': {u'attr': {},
                                                                                                                                       u'category': u'LIST COMMAND',
                                                                                                                                       u'choices': [],
                                                                                                                                       u'completer': u'',
                                                                                                                                       u'default': None,
                                                                                                                                       u'description': u'Some services group resource list output into pages. This flag specifies\nthe maximum number of resources per page. The default is determined by the\nservice if it supports paging, otherwise it is *unlimited* (no paging).\nPaging may be applied before or after *--filter* and *--limit* depending\non the service.',
                                                                                                                                       u'group': u'',
                                                                                                                                       u'hidden': False,
                                                                                                                                       u'name': u'--page-size',
                                                                                                                                       u'nargs': u'0',
                                                                                                                                       u'required': False,
                                                                                                                                       u'type': u'string',
                                                                                                                                       u'value': u'PAGE_SIZE'},
                                                                                                                      u'--regexp': {u'attr': {},
                                                                                                                                    u'category': u'',
                                                                                                                                    u'choices': [],
                                                                                                                                    u'completer': u'',
                                                                                                                                    u'default': None,
                                                                                                                                    u'description': u'A regular expression to filter the names of the results on. Any names\nthat do not match the entire regular expression will be filtered out.',
                                                                                                                                    u'group': u'',
                                                                                                                                    u'hidden': False,
                                                                                                                                    u'name': u'--regexp',
                                                                                                                                    u'nargs': u'0',
                                                                                                                                    u'required': False,
                                                                                                                                    u'type': u'string',
                                                                                                                                    u'value': u'REGEXP'},
                                                                                                                      u'--regions': {u'attr': {},
                                                                                                                                     u'category': u'',
                                                                                                                                     u'choices': [],
                                                                                                                                     u'completer': u'',
                                                                                                                                     u'default': None,
                                                                                                                                     u'description': u'If provided, only regional resources are shown. If arguments are provided, only resources from the given regions are shown.',
                                                                                                                                     u'group': u'list.1',
                                                                                                                                     u'hidden': False,
                                                                                                                                     u'name': u'--regions',
                                                                                                                                     u'nargs': u'0',
                                                                                                                                     u'required': False,
                                                                                                                                     u'type': u'list',
                                                                                                                                     u'value': u'REGION'},
                                                                                                                      u'--sort-by': {u'attr': {},
                                                                                                                                     u'category': u'LIST COMMAND',
                                                                                                                                     u'choices': [],
                                                                                                                                     u'completer': u'',
                                                                                                                                     u'default': None,
                                                                                                                                     u'description': u"A comma-separated list of resource field key names to sort by. The\ndefault order is ascending. Prefix a field with ``~'' for descending\norder on that field. This flag interacts with other flags that are applied\nin this order: *--flatten*, *--sort-by*, *--filter*, *--limit*.",
                                                                                                                                     u'group': u'',
                                                                                                                                     u'hidden': False,
                                                                                                                                     u'name': u'--sort-by',
                                                                                                                                     u'nargs': u'0',
                                                                                                                                     u'required': False,
                                                                                                                                     u'type': u'list',
                                                                                                                                     u'value': u'FIELD'},
                                                                                                                      u'--uri': {u'attr': {},
                                                                                                                                 u'category': u'LIST COMMAND',
                                                                                                                                 u'choices': [],
                                                                                                                                 u'completer': u'',
                                                                                                                                 u'default': False,
                                                                                                                                 u'description': u'Print a list of resource URIs instead of the default output.',
                                                                                                                                 u'group': u'',
                                                                                                                                 u'hidden': False,
                                                                                                                                 u'name': u'--uri',
                                                                                                                                 u'nargs': u'0',
                                                                                                                                 u'required': False,
                                                                                                                                 u'type': u'bool',
                                                                                                                                 u'value': u'URI'},
                                                                                                                      u'--zones': {u'attr': {},
                                                                                                                                   u'category': u'',
                                                                                                                                   u'choices': [],
                                                                                                                                   u'completer': u'',
                                                                                                                                   u'default': None,
                                                                                                                                   u'description': u'If provided, only zonal resources are shown. If arguments are provided, only resources from the given zones are shown.',
                                                                                                                                   u'group': u'list.1',
                                                                                                                                   u'hidden': False,
                                                                                                                                   u'name': u'--zones',
                                                                                                                                   u'nargs': u'0',
                                                                                                                                   u'required': False,
                                                                                                                                   u'type': u'list',
                                                                                                                                   u'value': u'ZONE'}},
                                                                                                           u'group': False,
                                                                                                           u'groups': {u'list.1': {u'description': u'At most one of these may be specified:',
                                                                                                                                   u'is_mutex': True,
                                                                                                                                   u'is_required': False}},
                                                                                                           u'hidden': False,
                                                                                                           u'name': u'list',
                                                                                                           u'path': [u'gcloud',
                                                                                                                     u'alpha',
                                                                                                                     u'compute',
                                                                                                                     u'disk-types',
                                                                                                                     u'list'],
                                                                                                           u'positionals': [{u'completer': u'',
                                                                                                                             u'default': [],
                                                                                                                             u'description': u'If provided, show details for the specified names and/or URIs of resources.',
                                                                                                                             u'name': u'names',
                                                                                                                             u'nargs': u'*',
                                                                                                                             u'required': False,
                                                                                                                             u'value': u'NAME'}],
                                                                                                           u'release': u'ALPHA',
                                                                                                           u'sections': {u'DESCRIPTION': u"*list* displays all Google Compute Engine disk types in a project.\n\nBy default, disk types from all regions and disk types from all zones are listed. The results can be narrowed down by\nproviding the ``--regions'' or ``--zones'' flag.\n",
                                                                                                                         u'EXAMPLES': u"To list all disk types in a project in table form, run:\n\n  $ list\n\nTo list the URIs of all disk types in a project, run:\n\n  $ list --uri\n\nTo list all disk types in the ``us-central1'' and ``europe-west1'' regions,\nrun:\n\n  $ list --regions us-central1,europe-west1\n\nTo list all disk types in zones ``us-central1-b'' and ``europe-west1-d'',\nrun:\n\n  $ list --zones us-central1,europe-west1\n"}}},
                                                                                   u'flags': {},
                                                                                   u'group': True,
                                                                                   u'groups': {},
                                                                                   u'hidden': False,
                                                                                   u'name': u'disk-types',
                                                                                   u'path': [u'gcloud',
                                                                                             u'alpha',
                                                                                             u'compute',
                                                                                             u'disk-types'],
                                                                                   u'positionals': [],
                                                                                   u'release': u'ALPHA',
                                                                                   u'sections': {u'DESCRIPTION': u'*(ALPHA)* Read Google Compute Engine virtual disk types.'}},
                                                                   u'disks': {u'capsule': u'*(ALPHA)* Read and manipulate Google Compute Engine disks.',
                                                                              u'commands': {u'create': {u'capsule': u'*(ALPHA)* Create Google Compute Engine persistent disks.',
                                                                                                        u'commands': {},
                                                                                                        u'flags': {u'--csek-key-file': {u'attr': {},
                                                                                                                                        u'category': u'',
                                                                                                                                        u'choices': [],
                                                                                                                                        u'completer': u'',
                                                                                                                                        u'default': None,
                                                                                                                                        u'description': u'Path to a Customer-Supplied Encryption Key (CSEK) key file, mapping\nGoogle Compute Engine resources to user managed keys to be used when\ncreating, mounting, or snapshotting disks.\nSee https://cloud.google.com/compute/docs/disks/customer-supplied-encryption for more details.',
                                                                                                                                        u'group': u'',
                                                                                                                                        u'hidden': False,
                                                                                                                                        u'name': u'--csek-key-file',
                                                                                                                                        u'nargs': u'0',
                                                                                                                                        u'required': False,
                                                                                                                                        u'type': u'string',
                                                                                                                                        u'value': u'FILE'},
                                                                                                                   u'--description': {u'attr': {},
                                                                                                                                      u'category': u'',
                                                                                                                                      u'choices': [],
                                                                                                                                      u'completer': u'',
                                                                                                                                      u'default': None,
                                                                                                                                      u'description': u'An optional, textual description for the disks being created.',
                                                                                                                                      u'group': u'',
                                                                                                                                      u'hidden': False,
                                                                                                                                      u'name': u'--description',
                                                                                                                                      u'nargs': u'0',
                                                                                                                                      u'required': False,
                                                                                                                                      u'type': u'string',
                                                                                                                                      u'value': u'DESCRIPTION'},
                                                                                                                   u'--image': {u'attr': {},
                                                                                                                                u'category': u'',
                                                                                                                                u'choices': [],
                                                                                                                                u'completer': u'',
                                                                                                                                u'default': None,
                                                                                                                                u'description': u"An image to apply to the disks being created. When using\nthis option, the size of the disks must be at least as large as\nthe image size. Use ``--size'' to adjust the size of the disks.\n+\nThis flag is mutually exclusive with ``--source-snapshot'' and\n``--image-family''.",
                                                                                                                                u'group': u'create.1',
                                                                                                                                u'hidden': False,
                                                                                                                                u'name': u'--image',
                                                                                                                                u'nargs': u'0',
                                                                                                                                u'required': False,
                                                                                                                                u'type': u'string',
                                                                                                                                u'value': u'IMAGE'},
                                                                                                                   u'--image-family': {u'attr': {},
                                                                                                                                       u'category': u'',
                                                                                                                                       u'choices': [],
                                                                                                                                       u'completer': u'',
                                                                                                                                       u'default': None,
                                                                                                                                       u'description': u'The family of the image that the boot disk will be initialized with. When a family is used instead of an image, the latest non-deprecated image associated with that family is used.',
                                                                                                                                       u'group': u'create.1',
                                                                                                                                       u'hidden': False,
                                                                                                                                       u'name': u'--image-family',
                                                                                                                                       u'nargs': u'0',
                                                                                                                                       u'required': False,
                                                                                                                                       u'type': u'string',
                                                                                                                                       u'value': u'IMAGE_FAMILY'},
                                                                                                                   u'--image-project': {u'attr': {},
                                                                                                                                        u'category': u'',
                                                                                                                                        u'choices': [],
                                                                                                                                        u'completer': u'',
                                                                                                                                        u'default': None,
                                                                                                                                        u'description': u"The project against which all image and image family references will be\nresolved. See ``--image'' for more details.",
                                                                                                                                        u'group': u'',
                                                                                                                                        u'hidden': False,
                                                                                                                                        u'name': u'--image-project',
                                                                                                                                        u'nargs': u'0',
                                                                                                                                        u'required': False,
                                                                                                                                        u'type': u'string',
                                                                                                                                        u'value': u'IMAGE_PROJECT'},
                                                                                                                   u'--no-require-csek-key-create': {u'attr': {},
                                                                                                                                                     u'category': u'',
                                                                                                                                                     u'choices': [],
                                                                                                                                                     u'completer': u'',
                                                                                                                                                     u'default': True,
                                                                                                                                                     u'description': u'',
                                                                                                                                                     u'group': u'',
                                                                                                                                                     u'hidden': True,
                                                                                                                                                     u'name': u'--no-require-csek-key-create',
                                                                                                                                                     u'nargs': u'0',
                                                                                                                                                     u'required': False,
                                                                                                                                                     u'type': u'bool',
                                                                                                                                                     u'value': u'NO_REQUIRE_CSEK_KEY_CREATE'},
                                                                                                                   u'--region': {u'attr': {u'property': {u'name': u'compute/region'}},
                                                                                                                                 u'category': u'',
                                                                                                                                 u'choices': [],
                                                                                                                                 u'completer': u'',
                                                                                                                                 u'default': None,
                                                                                                                                 u'description': u'',
                                                                                                                                 u'group': u'create.2',
                                                                                                                                 u'hidden': True,
                                                                                                                                 u'name': u'--region',
                                                                                                                                 u'nargs': u'0',
                                                                                                                                 u'required': False,
                                                                                                                                 u'type': u'string',
                                                                                                                                 u'value': u'REGION'},
                                                                                                                   u'--replica-zones': {u'attr': {},
                                                                                                                                        u'category': u'',
                                                                                                                                        u'choices': [],
                                                                                                                                        u'completer': u'',
                                                                                                                                        u'default': None,
                                                                                                                                        u'description': u'',
                                                                                                                                        u'group': u'',
                                                                                                                                        u'hidden': True,
                                                                                                                                        u'name': u'--replica-zones',
                                                                                                                                        u'nargs': u'0',
                                                                                                                                        u'required': False,
                                                                                                                                        u'type': u'list',
                                                                                                                                        u'value': u'ZONE1, ZONE2'},
                                                                                                                   u'--require-csek-key-create': {u'attr': {u'inverted_synopsis': True},
                                                                                                                                                  u'category': u'',
                                                                                                                                                  u'choices': [],
                                                                                                                                                  u'completer': u'',
                                                                                                                                                  u'default': True,
                                                                                                                                                  u'description': u'Refuse to create resources not protected by a user managed key in\nthe key file when --csek-key-file is given. This behavior is enabled\nby default to prevent incorrect gcloud invocations from accidentally\ncreating resources with no user managed key. Disabling the check\nallows creation of some resources without a matching\nCustomer-Supplied Encryption Key in the supplied --csek-key-file.\nSee https://cloud.google.com/compute/docs/disks/customer-supplied-encryption for more details. Enabled by default, use *--no-require-csek-key-create* to disable.',
                                                                                                                                                  u'group': u'',
                                                                                                                                                  u'hidden': False,
                                                                                                                                                  u'name': u'--require-csek-key-create',
                                                                                                                                                  u'nargs': u'0',
                                                                                                                                                  u'required': False,
                                                                                                                                                  u'type': u'bool',
                                                                                                                                                  u'value': u'REQUIRE_CSEK_KEY_CREATE'},
                                                                                                                   u'--size': {u'attr': {},
                                                                                                                               u'category': u'',
                                                                                                                               u'choices': [],
                                                                                                                               u'completer': u'',
                                                                                                                               u'default': None,
                                                                                                                               u'description': u"Indicates the size of the disks. The value must be a whole\nnumber followed by a size unit of ``KB'' for kilobyte, ``MB''\nfor megabyte, ``GB'' for gigabyte, or ``TB'' for terabyte. For\nexample, ``10GB'' will produce 10 gigabyte disks.  Disk size\nmust be a multiple of 10 GB.",
                                                                                                                               u'group': u'',
                                                                                                                               u'hidden': False,
                                                                                                                               u'name': u'--size',
                                                                                                                               u'nargs': u'0',
                                                                                                                               u'required': False,
                                                                                                                               u'type': u'string',
                                                                                                                               u'value': u'SIZE'},
                                                                                                                   u'--source-snapshot': {u'attr': {},
                                                                                                                                          u'category': u'',
                                                                                                                                          u'choices': [],
                                                                                                                                          u'completer': u'',
                                                                                                                                          u'default': None,
                                                                                                                                          u'description': u'A source snapshot used to create the disks. It is safe to\ndelete a snapshot after a disk has been created from the\nsnapshot. In such cases, the disks will no longer reference\nthe deleted snapshot. To get a list of snapshots in your\ncurrent project, run `gcloud compute snapshots list`. A\nsnapshot from an existing disk can be created using the\n`gcloud compute disks snapshot` command. This flag is mutually\nexclusive with *--image*.\n+\nWhen using this option, the size of the disks must be at least\nas large as the snapshot size. Use *--size* to adjust the\nsize of the disks.',
                                                                                                                                          u'group': u'create.1',
                                                                                                                                          u'hidden': False,
                                                                                                                                          u'name': u'--source-snapshot',
                                                                                                                                          u'nargs': u'0',
                                                                                                                                          u'required': False,
                                                                                                                                          u'type': u'string',
                                                                                                                                          u'value': u'SOURCE_SNAPSHOT'},
                                                                                                                   u'--type': {u'attr': {},
                                                                                                                               u'category': u'',
                                                                                                                               u'choices': [],
                                                                                                                               u'completer': u'',
                                                                                                                               u'default': None,
                                                                                                                               u'description': u'Specifies the type of disk to create. To get a\nlist of available disk types, run `gcloud compute disk-types list`.\nThe default disk type is pd-standard.',
                                                                                                                               u'group': u'',
                                                                                                                               u'hidden': False,
                                                                                                                               u'name': u'--type',
                                                                                                                               u'nargs': u'0',
                                                                                                                               u'required': False,
                                                                                                                               u'type': u'string',
                                                                                                                               u'value': u'TYPE'},
                                                                                                                   u'--zone': {u'attr': {u'property': {u'name': u'compute/zone'}},
                                                                                                                               u'category': u'',
                                                                                                                               u'choices': [],
                                                                                                                               u'completer': u'',
                                                                                                                               u'default': None,
                                                                                                                               u'description': u"The zone of the disk to operate on. If not specified, you will be prompted to select a zone.\n+\nTo avoid prompting when this flag is omitted, you can set the\n``compute/zone'' property:\n+\n  $ gcloud config set compute/zone ZONE\n+\nA list of zones can be fetched by running:\n+\n  $ gcloud compute zones list\n+\nTo unset the property, run:\n+\n  $ gcloud config unset compute/zone\n+\nAlternatively, the zone can be stored in the environment variable\n``CLOUDSDK_COMPUTE_ZONE''.",
                                                                                                                               u'group': u'create.2',
                                                                                                                               u'hidden': False,
                                                                                                                               u'name': u'--zone',
                                                                                                                               u'nargs': u'0',
                                                                                                                               u'required': False,
                                                                                                                               u'type': u'string',
                                                                                                                               u'value': u'ZONE'}},
                                                                                                        u'group': False,
                                                                                                        u'groups': {u'create.1': {u'description': u'At most one of these may be specified:',
                                                                                                                                  u'is_mutex': True,
                                                                                                                                  u'is_required': False},
                                                                                                                    u'create.2': {u'description': u'At most one of these may be specified:',
                                                                                                                                  u'is_mutex': True,
                                                                                                                                  u'is_required': False}},
                                                                                                        u'hidden': False,
                                                                                                        u'name': u'create',
                                                                                                        u'path': [u'gcloud',
                                                                                                                  u'alpha',
                                                                                                                  u'compute',
                                                                                                                  u'disks',
                                                                                                                  u'create'],
                                                                                                        u'positionals': [{u'completer': u'',
                                                                                                                          u'default': None,
                                                                                                                          u'description': u'The names of the disks.',
                                                                                                                          u'name': u'DISK-NAME',
                                                                                                                          u'nargs': u'+',
                                                                                                                          u'required': False,
                                                                                                                          u'value': u'DISK_NAME'}],
                                                                                                        u'release': u'ALPHA',
                                                                                                        u'sections': {u'DESCRIPTION': u'*create* creates one or more Google Compute Engine\npersistent disks. When creating virtual machine instances,\ndisks can be attached to the instances through the\n`gcloud compute instances create` command. Disks can also be\nattached to instances that are already running using\n`gcloud compute instances attach-disk`.\n\nDisks are zonal resources, so they reside in a particular zone\nfor their entire lifetime. The contents of a disk can be moved\nto a different zone by snapshotting the disk (using\n`gcloud compute disks snapshot`) and creating a new disk using\n`--source-snapshot` in the desired zone. The contents of a\ndisk can also be moved across project or zone by creating an\nimage (using `gcloud compute images create`) and creating a\nnew disk using `--image` in the desired project and/or\nzone.\n\nWhen creating disks, be sure to include the `--zone` option:\n\n  $ create my-disk-1 my-disk-2 --zone us-east1-a\n'}},
                                                                                            u'delete': {u'capsule': u'*(ALPHA)* Delete Google Compute Engine persistent disks.',
                                                                                                        u'commands': {},
                                                                                                        u'flags': {u'--region': {u'attr': {u'property': {u'name': u'compute/region'}},
                                                                                                                                 u'category': u'',
                                                                                                                                 u'choices': [],
                                                                                                                                 u'completer': u'',
                                                                                                                                 u'default': None,
                                                                                                                                 u'description': u'',
                                                                                                                                 u'group': u'delete.1',
                                                                                                                                 u'hidden': True,
                                                                                                                                 u'name': u'--region',
                                                                                                                                 u'nargs': u'0',
                                                                                                                                 u'required': False,
                                                                                                                                 u'type': u'string',
                                                                                                                                 u'value': u'REGION'},
                                                                                                                   u'--zone': {u'attr': {u'property': {u'name': u'compute/zone'}},
                                                                                                                               u'category': u'',
                                                                                                                               u'choices': [],
                                                                                                                               u'completer': u'',
                                                                                                                               u'default': None,
                                                                                                                               u'description': u"The zone of the disk to delete. If not specified, you will be prompted to select a zone.\n+\nTo avoid prompting when this flag is omitted, you can set the\n``compute/zone'' property:\n+\n  $ gcloud config set compute/zone ZONE\n+\nA list of zones can be fetched by running:\n+\n  $ gcloud compute zones list\n+\nTo unset the property, run:\n+\n  $ gcloud config unset compute/zone\n+\nAlternatively, the zone can be stored in the environment variable\n``CLOUDSDK_COMPUTE_ZONE''.",
                                                                                                                               u'group': u'delete.1',
                                                                                                                               u'hidden': False,
                                                                                                                               u'name': u'--zone',
                                                                                                                               u'nargs': u'0',
                                                                                                                               u'required': False,
                                                                                                                               u'type': u'string',
                                                                                                                               u'value': u'ZONE'}},
                                                                                                        u'group': False,
                                                                                                        u'groups': {u'delete.1': {u'description': u'At most one of these may be specified:',
                                                                                                                                  u'is_mutex': True,
                                                                                                                                  u'is_required': False}},
                                                                                                        u'hidden': False,
                                                                                                        u'name': u'delete',
                                                                                                        u'path': [u'gcloud',
                                                                                                                  u'alpha',
                                                                                                                  u'compute',
                                                                                                                  u'disks',
                                                                                                                  u'delete'],
                                                                                                        u'positionals': [{u'completer': u'',
                                                                                                                          u'default': None,
                                                                                                                          u'description': u'The names of the disks.',
                                                                                                                          u'name': u'DISK-NAME',
                                                                                                                          u'nargs': u'+',
                                                                                                                          u'required': False,
                                                                                                                          u'value': u'DISK_NAME'}],
                                                                                                        u'release': u'ALPHA',
                                                                                                        u'sections': {u'DESCRIPTION': u'*(ALPHA)* *delete* deletes one or more Google Compute Engine\npersistent disks. Disks can be deleted only if they are not\nbeing used by any virtual machine instances.'}},
                                                                                            u'describe': {u'capsule': u'*(ALPHA)* Describe a Google Compute Engine disk.',
                                                                                                          u'commands': {},
                                                                                                          u'flags': {u'--region': {u'attr': {u'property': {u'name': u'compute/region'}},
                                                                                                                                   u'category': u'',
                                                                                                                                   u'choices': [],
                                                                                                                                   u'completer': u'',
                                                                                                                                   u'default': None,
                                                                                                                                   u'description': u'',
                                                                                                                                   u'group': u'describe.1',
                                                                                                                                   u'hidden': True,
                                                                                                                                   u'name': u'--region',
                                                                                                                                   u'nargs': u'0',
                                                                                                                                   u'required': False,
                                                                                                                                   u'type': u'string',
                                                                                                                                   u'value': u'REGION'},
                                                                                                                     u'--zone': {u'attr': {u'property': {u'name': u'compute/zone'}},
                                                                                                                                 u'category': u'',
                                                                                                                                 u'choices': [],
                                                                                                                                 u'completer': u'',
                                                                                                                                 u'default': None,
                                                                                                                                 u'description': u"The zone of the disk to operate on. If not specified, you will be prompted to select a zone.\n+\nTo avoid prompting when this flag is omitted, you can set the\n``compute/zone'' property:\n+\n  $ gcloud config set compute/zone ZONE\n+\nA list of zones can be fetched by running:\n+\n  $ gcloud compute zones list\n+\nTo unset the property, run:\n+\n  $ gcloud config unset compute/zone\n+\nAlternatively, the zone can be stored in the environment variable\n``CLOUDSDK_COMPUTE_ZONE''.",
                                                                                                                                 u'group': u'describe.1',
                                                                                                                                 u'hidden': False,
                                                                                                                                 u'name': u'--zone',
                                                                                                                                 u'nargs': u'0',
                                                                                                                                 u'required': False,
                                                                                                                                 u'type': u'string',
                                                                                                                                 u'value': u'ZONE'}},
                                                                                                          u'group': False,
                                                                                                          u'groups': {u'describe.1': {u'description': u'At most one of these may be specified:',
                                                                                                                                      u'is_mutex': True,
                                                                                                                                      u'is_required': False}},
                                                                                                          u'hidden': False,
                                                                                                          u'name': u'describe',
                                                                                                          u'path': [u'gcloud',
                                                                                                                    u'alpha',
                                                                                                                    u'compute',
                                                                                                                    u'disks',
                                                                                                                    u'describe'],
                                                                                                          u'positionals': [{u'completer': u'',
                                                                                                                            u'default': None,
                                                                                                                            u'description': u'The name of the disk.',
                                                                                                                            u'name': u'DISK-NAME',
                                                                                                                            u'nargs': u'0',
                                                                                                                            u'required': False,
                                                                                                                            u'value': u'DISK_NAME'}],
                                                                                                          u'release': u'ALPHA',
                                                                                                          u'sections': {u'DESCRIPTION': u'*describe* displays all data associated with a Google Compute\nEngine disk in a project.\n'}},
                                                                                            u'list': {u'capsule': u'*(ALPHA)* List Google Compute Engine disks.',
                                                                                                      u'commands': {},
                                                                                                      u'flags': {u'--filter': {u'attr': {},
                                                                                                                               u'category': u'LIST COMMAND',
                                                                                                                               u'choices': [],
                                                                                                                               u'completer': u'',
                                                                                                                               u'default': None,
                                                                                                                               u'description': u'Apply a Boolean filter _EXPRESSION_ to each resource item to be listed.\nIf the expression evaluates True then that item is listed. For more\ndetails and examples of filter expressions run $ gcloud topic filters. This\nflag interacts with other flags that are applied in this order: *--flatten*,\n*--sort-by*, *--filter*, *--limit*.',
                                                                                                                               u'group': u'',
                                                                                                                               u'hidden': False,
                                                                                                                               u'name': u'--filter',
                                                                                                                               u'nargs': u'0',
                                                                                                                               u'required': False,
                                                                                                                               u'type': u'string',
                                                                                                                               u'value': u'EXPRESSION'},
                                                                                                                 u'--limit': {u'attr': {},
                                                                                                                              u'category': u'LIST COMMAND',
                                                                                                                              u'choices': [],
                                                                                                                              u'completer': u'',
                                                                                                                              u'default': None,
                                                                                                                              u'description': u'The maximum number of resources to list. The default is *unlimited*.\nThis flag interacts with other flags that are applied in this order:\n*--flatten*, *--sort-by*, *--filter*, *--limit*.',
                                                                                                                              u'group': u'',
                                                                                                                              u'hidden': False,
                                                                                                                              u'name': u'--limit',
                                                                                                                              u'nargs': u'0',
                                                                                                                              u'required': False,
                                                                                                                              u'type': u'string',
                                                                                                                              u'value': u'LIMIT'},
                                                                                                                 u'--no-uri': {u'attr': {},
                                                                                                                               u'category': u'LIST COMMAND',
                                                                                                                               u'choices': [],
                                                                                                                               u'completer': u'',
                                                                                                                               u'default': True,
                                                                                                                               u'description': u'',
                                                                                                                               u'group': u'',
                                                                                                                               u'hidden': True,
                                                                                                                               u'name': u'--no-uri',
                                                                                                                               u'nargs': u'0',
                                                                                                                               u'required': False,
                                                                                                                               u'type': u'bool',
                                                                                                                               u'value': u'NO_URI'},
                                                                                                                 u'--page-size': {u'attr': {},
                                                                                                                                  u'category': u'LIST COMMAND',
                                                                                                                                  u'choices': [],
                                                                                                                                  u'completer': u'',
                                                                                                                                  u'default': None,
                                                                                                                                  u'description': u'Some services group resource list output into pages. This flag specifies\nthe maximum number of resources per page. The default is determined by the\nservice if it supports paging, otherwise it is *unlimited* (no paging).\nPaging may be applied before or after *--filter* and *--limit* depending\non the service.',
                                                                                                                                  u'group': u'',
                                                                                                                                  u'hidden': False,
                                                                                                                                  u'name': u'--page-size',
                                                                                                                                  u'nargs': u'0',
                                                                                                                                  u'required': False,
                                                                                                                                  u'type': u'string',
                                                                                                                                  u'value': u'PAGE_SIZE'},
                                                                                                                 u'--regexp': {u'attr': {},
                                                                                                                               u'category': u'',
                                                                                                                               u'choices': [],
                                                                                                                               u'completer': u'',
                                                                                                                               u'default': None,
                                                                                                                               u'description': u'A regular expression to filter the names of the results on. Any names\nthat do not match the entire regular expression will be filtered out.',
                                                                                                                               u'group': u'',
                                                                                                                               u'hidden': False,
                                                                                                                               u'name': u'--regexp',
                                                                                                                               u'nargs': u'0',
                                                                                                                               u'required': False,
                                                                                                                               u'type': u'string',
                                                                                                                               u'value': u'REGEXP'},
                                                                                                                 u'--regions': {u'attr': {},
                                                                                                                                u'category': u'',
                                                                                                                                u'choices': [],
                                                                                                                                u'completer': u'',
                                                                                                                                u'default': None,
                                                                                                                                u'description': u'If provided, only regional resources are shown. If arguments are provided, only resources from the given regions are shown.',
                                                                                                                                u'group': u'list.1',
                                                                                                                                u'hidden': False,
                                                                                                                                u'name': u'--regions',
                                                                                                                                u'nargs': u'0',
                                                                                                                                u'required': False,
                                                                                                                                u'type': u'list',
                                                                                                                                u'value': u'REGION'},
                                                                                                                 u'--sort-by': {u'attr': {},
                                                                                                                                u'category': u'LIST COMMAND',
                                                                                                                                u'choices': [],
                                                                                                                                u'completer': u'',
                                                                                                                                u'default': None,
                                                                                                                                u'description': u"A comma-separated list of resource field key names to sort by. The\ndefault order is ascending. Prefix a field with ``~'' for descending\norder on that field. This flag interacts with other flags that are applied\nin this order: *--flatten*, *--sort-by*, *--filter*, *--limit*.",
                                                                                                                                u'group': u'',
                                                                                                                                u'hidden': False,
                                                                                                                                u'name': u'--sort-by',
                                                                                                                                u'nargs': u'0',
                                                                                                                                u'required': False,
                                                                                                                                u'type': u'list',
                                                                                                                                u'value': u'FIELD'},
                                                                                                                 u'--uri': {u'attr': {},
                                                                                                                            u'category': u'LIST COMMAND',
                                                                                                                            u'choices': [],
                                                                                                                            u'completer': u'',
                                                                                                                            u'default': False,
                                                                                                                            u'description': u'Print a list of resource URIs instead of the default output.',
                                                                                                                            u'group': u'',
                                                                                                                            u'hidden': False,
                                                                                                                            u'name': u'--uri',
                                                                                                                            u'nargs': u'0',
                                                                                                                            u'required': False,
                                                                                                                            u'type': u'bool',
                                                                                                                            u'value': u'URI'},
                                                                                                                 u'--zones': {u'attr': {},
                                                                                                                              u'category': u'',
                                                                                                                              u'choices': [],
                                                                                                                              u'completer': u'',
                                                                                                                              u'default': None,
                                                                                                                              u'description': u'If provided, only zonal resources are shown. If arguments are provided, only resources from the given zones are shown.',
                                                                                                                              u'group': u'list.1',
                                                                                                                              u'hidden': False,
                                                                                                                              u'name': u'--zones',
                                                                                                                              u'nargs': u'0',
                                                                                                                              u'required': False,
                                                                                                                              u'type': u'list',
                                                                                                                              u'value': u'ZONE'}},
                                                                                                      u'group': False,
                                                                                                      u'groups': {u'list.1': {u'description': u'At most one of these may be specified:',
                                                                                                                              u'is_mutex': True,
                                                                                                                              u'is_required': False}},
                                                                                                      u'hidden': False,
                                                                                                      u'name': u'list',
                                                                                                      u'path': [u'gcloud',
                                                                                                                u'alpha',
                                                                                                                u'compute',
                                                                                                                u'disks',
                                                                                                                u'list'],
                                                                                                      u'positionals': [{u'completer': u'',
                                                                                                                        u'default': [],
                                                                                                                        u'description': u'If provided, show details for the specified names and/or URIs of resources.',
                                                                                                                        u'name': u'names',
                                                                                                                        u'nargs': u'*',
                                                                                                                        u'required': False,
                                                                                                                        u'value': u'NAME'}],
                                                                                                      u'release': u'ALPHA',
                                                                                                      u'sections': {u'DESCRIPTION': u"*list* displays all Google Compute Engine disks in a project.\n\nBy default, disks from all regions and disks from all zones are listed. The results can be narrowed down by\nproviding the ``--regions'' or ``--zones'' flag.\n",
                                                                                                                    u'EXAMPLES': u"To list all disks in a project in table form, run:\n\n  $ list\n\nTo list the URIs of all disks in a project, run:\n\n  $ list --uri\n\nTo list all disks in the ``us-central1'' and ``europe-west1'' regions,\nrun:\n\n  $ list --regions us-central1,europe-west1\n\nTo list all disks in zones ``us-central1-b'' and ``europe-west1-d'',\nrun:\n\n  $ list --zones us-central1,europe-west1\n"}},
                                                                                            u'move': {u'capsule': u'*(ALPHA)* Move a disk between zones.',
                                                                                                      u'commands': {},
                                                                                                      u'flags': {u'--async': {u'attr': {},
                                                                                                                              u'category': u'',
                                                                                                                              u'choices': [],
                                                                                                                              u'completer': u'',
                                                                                                                              u'default': False,
                                                                                                                              u'description': u"Display information about the operation in progress and don't wait for\nthe operation to complete.",
                                                                                                                              u'group': u'',
                                                                                                                              u'hidden': False,
                                                                                                                              u'name': u'--async',
                                                                                                                              u'nargs': u'0',
                                                                                                                              u'required': False,
                                                                                                                              u'type': u'bool',
                                                                                                                              u'value': u'ASYNC'},
                                                                                                                 u'--destination-zone': {u'attr': {},
                                                                                                                                         u'category': u'',
                                                                                                                                         u'choices': [],
                                                                                                                                         u'completer': u'',
                                                                                                                                         u'default': None,
                                                                                                                                         u'description': u'The zone to move the disk to.',
                                                                                                                                         u'group': u'',
                                                                                                                                         u'hidden': False,
                                                                                                                                         u'name': u'--destination-zone',
                                                                                                                                         u'nargs': u'0',
                                                                                                                                         u'required': True,
                                                                                                                                         u'type': u'string',
                                                                                                                                         u'value': u'DESTINATION_ZONE'},
                                                                                                                 u'--no-async': {u'attr': {},
                                                                                                                                 u'category': u'',
                                                                                                                                 u'choices': [],
                                                                                                                                 u'completer': u'',
                                                                                                                                 u'default': True,
                                                                                                                                 u'description': u'',
                                                                                                                                 u'group': u'',
                                                                                                                                 u'hidden': True,
                                                                                                                                 u'name': u'--no-async',
                                                                                                                                 u'nargs': u'0',
                                                                                                                                 u'required': False,
                                                                                                                                 u'type': u'bool',
                                                                                                                                 u'value': u'NO_ASYNC'},
                                                                                                                 u'--zone': {u'attr': {u'property': {u'name': u'compute/zone'}},
                                                                                                                             u'category': u'',
                                                                                                                             u'choices': [],
                                                                                                                             u'completer': u'',
                                                                                                                             u'default': None,
                                                                                                                             u'description': u"The zone of the disk to operate on. If not specified, you will be prompted to select a zone.\n+\nTo avoid prompting when this flag is omitted, you can set the\n``compute/zone'' property:\n+\n  $ gcloud config set compute/zone ZONE\n+\nA list of zones can be fetched by running:\n+\n  $ gcloud compute zones list\n+\nTo unset the property, run:\n+\n  $ gcloud config unset compute/zone\n+\nAlternatively, the zone can be stored in the environment variable\n``CLOUDSDK_COMPUTE_ZONE''.",
                                                                                                                             u'group': u'',
                                                                                                                             u'hidden': False,
                                                                                                                             u'name': u'--zone',
                                                                                                                             u'nargs': u'0',
                                                                                                                             u'required': False,
                                                                                                                             u'type': u'string',
                                                                                                                             u'value': u'ZONE'}},
                                                                                                      u'group': False,
                                                                                                      u'groups': {},
                                                                                                      u'hidden': False,
                                                                                                      u'name': u'move',
                                                                                                      u'path': [u'gcloud',
                                                                                                                u'alpha',
                                                                                                                u'compute',
                                                                                                                u'disks',
                                                                                                                u'move'],
                                                                                                      u'positionals': [{u'completer': u'',
                                                                                                                        u'default': None,
                                                                                                                        u'description': u'The name of the disk.',
                                                                                                                        u'name': u'DISK-NAME',
                                                                                                                        u'nargs': u'0',
                                                                                                                        u'required': False,
                                                                                                                        u'value': u'DISK_NAME'}],
                                                                                                      u'release': u'ALPHA',
                                                                                                      u'sections': {u'DESCRIPTION': u'*move* facilitates moving a Google Compute Engine disk volume from\none zone to another. You cannot move a disk if it is attached to a\nrunning or stopped instance; use the gcloud compute instances move\ncommand instead.\n\nFor example, running:\n\n   $ gcloud compute disks move example-disk-1 --zone us-central1-b --destination-zone us-central1-f\n\nwill move the disk called example-disk-1, currently running in\nus-central1-b, to us-central1-f.\n'}},
                                                                                            u'resize': {u'capsule': u'*(ALPHA)* Resize a disk or disks.',
                                                                                                        u'commands': {},
                                                                                                        u'flags': {u'--region': {u'attr': {u'property': {u'name': u'compute/region'}},
                                                                                                                                 u'category': u'',
                                                                                                                                 u'choices': [],
                                                                                                                                 u'completer': u'',
                                                                                                                                 u'default': None,
                                                                                                                                 u'description': u'',
                                                                                                                                 u'group': u'resize.1',
                                                                                                                                 u'hidden': True,
                                                                                                                                 u'name': u'--region',
                                                                                                                                 u'nargs': u'0',
                                                                                                                                 u'required': False,
                                                                                                                                 u'type': u'string',
                                                                                                                                 u'value': u'REGION'},
                                                                                                                   u'--size': {u'attr': {},
                                                                                                                               u'category': u'',
                                                                                                                               u'choices': [],
                                                                                                                               u'completer': u'',
                                                                                                                               u'default': None,
                                                                                                                               u'description': u"Indicates the new size of the disks. The value must be a whole\nnumber followed by a size unit of ``KB'' for kilobyte, ``MB''\nfor megabyte, ``GB'' for gigabyte, or ``TB'' for terabyte. For\nexample, ``10GB'' will produce 10 gigabyte disks.  Disk size\nmust be a multiple of 10 GB.",
                                                                                                                               u'group': u'',
                                                                                                                               u'hidden': False,
                                                                                                                               u'name': u'--size',
                                                                                                                               u'nargs': u'0',
                                                                                                                               u'required': True,
                                                                                                                               u'type': u'string',
                                                                                                                               u'value': u'SIZE'},
                                                                                                                   u'--zone': {u'attr': {u'property': {u'name': u'compute/zone'}},
                                                                                                                               u'category': u'',
                                                                                                                               u'choices': [],
                                                                                                                               u'completer': u'',
                                                                                                                               u'default': None,
                                                                                                                               u'description': u"The zone of the disk to operate on. If not specified, you will be prompted to select a zone.\n+\nTo avoid prompting when this flag is omitted, you can set the\n``compute/zone'' property:\n+\n  $ gcloud config set compute/zone ZONE\n+\nA list of zones can be fetched by running:\n+\n  $ gcloud compute zones list\n+\nTo unset the property, run:\n+\n  $ gcloud config unset compute/zone\n+\nAlternatively, the zone can be stored in the environment variable\n``CLOUDSDK_COMPUTE_ZONE''.",
                                                                                                                               u'group': u'resize.1',
                                                                                                                               u'hidden': False,
                                                                                                                               u'name': u'--zone',
                                                                                                                               u'nargs': u'0',
                                                                                                                               u'required': False,
                                                                                                                               u'type': u'string',
                                                                                                                               u'value': u'ZONE'}},
                                                                                                        u'group': False,
                                                                                                        u'groups': {u'resize.1': {u'description': u'At most one of these may be specified:',
                                                                                                                                  u'is_mutex': True,
                                                                                                                                  u'is_required': False}},
                                                                                                        u'hidden': False,
                                                                                                        u'name': u'resize',
                                                                                                        u'path': [u'gcloud',
                                                                                                                  u'alpha',
                                                                                                                  u'compute',
                                                                                                                  u'disks',
                                                                                                                  u'resize'],
                                                                                                        u'positionals': [{u'completer': u'',
                                                                                                                          u'default': None,
                                                                                                                          u'description': u'The names of the disks.',
                                                                                                                          u'name': u'DISK-NAME',
                                                                                                                          u'nargs': u'+',
                                                                                                                          u'required': False,
                                                                                                                          u'value': u'DISK_NAME'}],
                                                                                                        u'release': u'ALPHA',
                                                                                                        u'sections': {u'DESCRIPTION': u'*resize* resizes a Google Compute Engine disk(s).\n\nOnly increasing disk size is supported. Disks can be resized\nregardless of whether they are attached.\n\n',
                                                                                                                      u'EXAMPLES': u'To resize a disk called example-disk-1 to new size 6TB, run:\n\n   $ resize example-disk-1 --size=6TB\n\nTo resize two disks called example-disk-2 and example-disk-3 to\nnew size 6TB, run:\n\n   $ resize example-disk-2 example-disk-3 --size=6TB\n\nThis assumes that original size of each of these disks is 6TB or less.\n'}},
                                                                                            u'snapshot': {u'capsule': u'*(ALPHA)* Create snapshots of Google Compute Engine persistent disks.',
                                                                                                          u'commands': {},
                                                                                                          u'flags': {u'--async': {u'attr': {},
                                                                                                                                  u'category': u'',
                                                                                                                                  u'choices': [],
                                                                                                                                  u'completer': u'',
                                                                                                                                  u'default': False,
                                                                                                                                  u'description': u"Display information about the operation in progress and don't wait for\nthe operation to complete.",
                                                                                                                                  u'group': u'',
                                                                                                                                  u'hidden': False,
                                                                                                                                  u'name': u'--async',
                                                                                                                                  u'nargs': u'0',
                                                                                                                                  u'required': False,
                                                                                                                                  u'type': u'bool',
                                                                                                                                  u'value': u'ASYNC'},
                                                                                                                     u'--csek-key-file': {u'attr': {},
                                                                                                                                          u'category': u'',
                                                                                                                                          u'choices': [],
                                                                                                                                          u'completer': u'',
                                                                                                                                          u'default': None,
                                                                                                                                          u'description': u'Path to a Customer-Supplied Encryption Key (CSEK) key file, mapping\nGoogle Compute Engine resources to user managed keys to be used when\ncreating, mounting, or snapshotting disks.\nSee https://cloud.google.com/compute/docs/disks/customer-supplied-encryption for more details.',
                                                                                                                                          u'group': u'',
                                                                                                                                          u'hidden': False,
                                                                                                                                          u'name': u'--csek-key-file',
                                                                                                                                          u'nargs': u'0',
                                                                                                                                          u'required': False,
                                                                                                                                          u'type': u'string',
                                                                                                                                          u'value': u'FILE'},
                                                                                                                     u'--description': {u'attr': {},
                                                                                                                                        u'category': u'',
                                                                                                                                        u'choices': [],
                                                                                                                                        u'completer': u'',
                                                                                                                                        u'default': None,
                                                                                                                                        u'description': u'An optional, textual description for the snapshots being created.',
                                                                                                                                        u'group': u'',
                                                                                                                                        u'hidden': False,
                                                                                                                                        u'name': u'--description',
                                                                                                                                        u'nargs': u'0',
                                                                                                                                        u'required': False,
                                                                                                                                        u'type': u'string',
                                                                                                                                        u'value': u'DESCRIPTION'},
                                                                                                                     u'--guest-flush': {u'attr': {},
                                                                                                                                        u'category': u'',
                                                                                                                                        u'choices': [],
                                                                                                                                        u'completer': u'',
                                                                                                                                        u'default': False,
                                                                                                                                        u'description': u'Create an application consistent snapshot by informing the OS to prepare for the snapshot process. Currently only supported on Windows instances using the Volume Shadow Copy Service (VSS).',
                                                                                                                                        u'group': u'',
                                                                                                                                        u'hidden': False,
                                                                                                                                        u'name': u'--guest-flush',
                                                                                                                                        u'nargs': u'0',
                                                                                                                                        u'required': False,
                                                                                                                                        u'type': u'bool',
                                                                                                                                        u'value': u'GUEST_FLUSH'},
                                                                                                                     u'--no-async': {u'attr': {},
                                                                                                                                     u'category': u'',
                                                                                                                                     u'choices': [],
                                                                                                                                     u'completer': u'',
                                                                                                                                     u'default': True,
                                                                                                                                     u'description': u'',
                                                                                                                                     u'group': u'',
                                                                                                                                     u'hidden': True,
                                                                                                                                     u'name': u'--no-async',
                                                                                                                                     u'nargs': u'0',
                                                                                                                                     u'required': False,
                                                                                                                                     u'type': u'bool',
                                                                                                                                     u'value': u'NO_ASYNC'},
                                                                                                                     u'--no-guest-flush': {u'attr': {},
                                                                                                                                           u'category': u'',
                                                                                                                                           u'choices': [],
                                                                                                                                           u'completer': u'',
                                                                                                                                           u'default': False,
                                                                                                                                           u'description': u'',
                                                                                                                                           u'group': u'',
                                                                                                                                           u'hidden': True,
                                                                                                                                           u'name': u'--no-guest-flush',
                                                                                                                                           u'nargs': u'0',
                                                                                                                                           u'required': False,
                                                                                                                                           u'type': u'bool',
                                                                                                                                           u'value': u'NO_GUEST_FLUSH'},
                                                                                                                     u'--region': {u'attr': {u'property': {u'name': u'compute/region'}},
                                                                                                                                   u'category': u'',
                                                                                                                                   u'choices': [],
                                                                                                                                   u'completer': u'',
                                                                                                                                   u'default': None,
                                                                                                                                   u'description': u'',
                                                                                                                                   u'group': u'snapshot.1',
                                                                                                                                   u'hidden': True,
                                                                                                                                   u'name': u'--region',
                                                                                                                                   u'nargs': u'0',
                                                                                                                                   u'required': False,
                                                                                                                                   u'type': u'string',
                                                                                                                                   u'value': u'REGION'},
                                                                                                                     u'--snapshot-names': {u'attr': {},
                                                                                                                                           u'category': u'',
                                                                                                                                           u'choices': [],
                                                                                                                                           u'completer': u'',
                                                                                                                                           u'default': None,
                                                                                                                                           u'description': u"Names to assign to the snapshots. Without this option, the\nname of each snapshot will be a random, 16-character\nhexadecimal number that starts with a letter. The values of\nthis option run parallel to the disks specified. For example,\n+\n  $ {command} my-disk-1 my-disk-2 my-disk-3 --snapshot-names snapshot-1,snapshot-2,snapshot-3\n+\nwill result in ``my-disk-1'' being snapshotted as\n``snapshot-1'', ``my-disk-2'' as ``snapshot-2'', and so on.",
                                                                                                                                           u'group': u'',
                                                                                                                                           u'hidden': False,
                                                                                                                                           u'name': u'--snapshot-names',
                                                                                                                                           u'nargs': u'0',
                                                                                                                                           u'required': False,
                                                                                                                                           u'type': u'list',
                                                                                                                                           u'value': u'SNAPSHOT_NAME'},
                                                                                                                     u'--zone': {u'attr': {u'property': {u'name': u'compute/zone'}},
                                                                                                                                 u'category': u'',
                                                                                                                                 u'choices': [],
                                                                                                                                 u'completer': u'',
                                                                                                                                 u'default': None,
                                                                                                                                 u'description': u"The zone of the disk to operate on. If not specified, you will be prompted to select a zone.\n+\nTo avoid prompting when this flag is omitted, you can set the\n``compute/zone'' property:\n+\n  $ gcloud config set compute/zone ZONE\n+\nA list of zones can be fetched by running:\n+\n  $ gcloud compute zones list\n+\nTo unset the property, run:\n+\n  $ gcloud config unset compute/zone\n+\nAlternatively, the zone can be stored in the environment variable\n``CLOUDSDK_COMPUTE_ZONE''.",
                                                                                                                                 u'group': u'snapshot.1',
                                                                                                                                 u'hidden': False,
                                                                                                                                 u'name': u'--zone',
                                                                                                                                 u'nargs': u'0',
                                                                                                                                 u'required': False,
                                                                                                                                 u'type': u'string',
                                                                                                                                 u'value': u'ZONE'}},
                                                                                                          u'group': False,
                                                                                                          u'groups': {u'snapshot.1': {u'description': u'At most one of these may be specified:',
                                                                                                                                      u'is_mutex': True,
                                                                                                                                      u'is_required': False}},
                                                                                                          u'hidden': False,
                                                                                                          u'name': u'snapshot',
                                                                                                          u'path': [u'gcloud',
                                                                                                                    u'alpha',
                                                                                                                    u'compute',
                                                                                                                    u'disks',
                                                                                                                    u'snapshot'],
                                                                                                          u'positionals': [{u'completer': u'',
                                                                                                                            u'default': None,
                                                                                                                            u'description': u'The names of the disks.',
                                                                                                                            u'name': u'DISK-NAME',
                                                                                                                            u'nargs': u'+',
                                                                                                                            u'required': False,
                                                                                                                            u'value': u'DISK_NAME'}],
                                                                                                          u'release': u'ALPHA',
                                                                                                          u'sections': {u'DESCRIPTION': u"Create snapshots of Google Compute Engine persistent disks.\n\n*snapshot* creates snapshots of persistent disks. Snapshots are useful\nfor backing up data or copying a persistent disk. Once created,\nsnapshots may be managed (listed, deleted, etc.) via\n``gcloud compute snapshots''.\n"}}},
                                                                              u'flags': {},
                                                                              u'group': True,
                                                                              u'groups': {},
                                                                              u'hidden': False,
                                                                              u'name': u'disks',
                                                                              u'path': [u'gcloud',
                                                                                        u'alpha',
                                                                                        u'compute',
                                                                                        u'disks'],
                                                                              u'positionals': [],
                                                                              u'release': u'ALPHA',
                                                                              u'sections': {u'DESCRIPTION': u'*(ALPHA)* Read and manipulate Google Compute Engine disks.'}},
                                                                   u'firewall-rules': {u'capsule': u'*(ALPHA)* List, create, update, and delete Google Compute Engine firewall rules.',
                                                                                       u'commands': {u'create': {u'capsule': u'*(ALPHA)* Create a Google Compute Engine firewall rule.',
                                                                                                                 u'commands': {},
                                                                                                                 u'flags': {u'--action': {u'attr': {},
                                                                                                                                          u'category': u'',
                                                                                                                                          u'choices': [u'ALLOW',
                                                                                                                                                       u'DENY'],
                                                                                                                                          u'completer': u'',
                                                                                                                                          u'default': None,
                                                                                                                                          u'description': u'The action for the firewall rule: whether to allow or deny matching\ntraffic. If specified, the flag `--rules` must also be specified. _ACTION_ must be one of: *ALLOW*, *DENY*.',
                                                                                                                                          u'group': u'create.1',
                                                                                                                                          u'hidden': False,
                                                                                                                                          u'name': u'--action',
                                                                                                                                          u'nargs': u'0',
                                                                                                                                          u'required': False,
                                                                                                                                          u'type': u'string',
                                                                                                                                          u'value': u'ACTION'},
                                                                                                                            u'--allow': {u'attr': {},
                                                                                                                                         u'category': u'',
                                                                                                                                         u'choices': [],
                                                                                                                                         u'completer': u'',
                                                                                                                                         u'default': None,
                                                                                                                                         u'description': u'A list of protocols and ports whose traffic will be allowed.\n+\nPROTOCOL is the IP protocol whose traffic will be allowed.\nPROTOCOL can be either the name of a well-known protocol\n(e.g., tcp or icmp) or the IP protocol number.\nA list of IP protocols can be found at\nlink:http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml[].\n+\nA port or port range can be specified after PROTOCOL to\nallow traffic through specific ports. If no port or port range\nis specified, connections through all ranges are allowed. For\nexample, the following will create a rule that allows TCP traffic\nthrough port 80 and allows ICMP traffic:\n+\n  $ {command} MY-RULE --allow tcp:80,icmp\n+\nTCP and UDP rules must include a port or port range.',
                                                                                                                                         u'group': u'create.1',
                                                                                                                                         u'hidden': False,
                                                                                                                                         u'name': u'--allow',
                                                                                                                                         u'nargs': u'0',
                                                                                                                                         u'required': False,
                                                                                                                                         u'type': u'list',
                                                                                                                                         u'value': u'PROTOCOL[:PORT[-PORT]]'},
                                                                                                                            u'--description': {u'attr': {},
                                                                                                                                               u'category': u'',
                                                                                                                                               u'choices': [],
                                                                                                                                               u'completer': u'',
                                                                                                                                               u'default': None,
                                                                                                                                               u'description': u'A textual description for the firewall rule.',
                                                                                                                                               u'group': u'',
                                                                                                                                               u'hidden': False,
                                                                                                                                               u'name': u'--description',
                                                                                                                                               u'nargs': u'0',
                                                                                                                                               u'required': False,
                                                                                                                                               u'type': u'string',
                                                                                                                                               u'value': u'DESCRIPTION'},
                                                                                                                            u'--destination-ranges': {u'attr': {},
                                                                                                                                                      u'category': u'',
                                                                                                                                                      u'choices': [],
                                                                                                                                                      u'completer': u'',
                                                                                                                                                      u'default': [],
                                                                                                                                                      u'description': u'The firewall rule will apply to traffic that has destination IP address\nin these IP address block list. The IP address blocks must be specified\nin CIDR format:\nlink:http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing[].\n+\nIf --destination-ranges is NOT provided, then this\nflag will default to 0.0.0.0/0, allowing all destinations. Multiple IP\naddress blocks can be specified if they are separated by commas.',
                                                                                                                                                      u'group': u'',
                                                                                                                                                      u'hidden': False,
                                                                                                                                                      u'name': u'--destination-ranges',
                                                                                                                                                      u'nargs': u'0',
                                                                                                                                                      u'required': False,
                                                                                                                                                      u'type': u'list',
                                                                                                                                                      u'value': u'CIDR_RANGE'},
                                                                                                                            u'--direction': {u'attr': {},
                                                                                                                                             u'category': u'',
                                                                                                                                             u'choices': [u'INGRESS',
                                                                                                                                                          u'EGRESS',
                                                                                                                                                          u'IN',
                                                                                                                                                          u'OUT'],
                                                                                                                                             u'completer': u'',
                                                                                                                                             u'default': None,
                                                                                                                                             u'description': u'If direction is NOT specified, then default is to apply on incoming\ntraffic. For incoming traffic, it is NOT supported to specify\ndestination-ranges; For outbound traffic, it is NOT supported to specify\nsource-ranges or source-tags. _DIRECTION_ must be one of: *INGRESS*, *EGRESS*, *IN*, *OUT*.',
                                                                                                                                             u'group': u'',
                                                                                                                                             u'hidden': False,
                                                                                                                                             u'name': u'--direction',
                                                                                                                                             u'nargs': u'0',
                                                                                                                                             u'required': False,
                                                                                                                                             u'type': u'string',
                                                                                                                                             u'value': u'DIRECTION'},
                                                                                                                            u'--network': {u'attr': {},
                                                                                                                                           u'category': u'',
                                                                                                                                           u'choices': [],
                                                                                                                                           u'completer': u'',
                                                                                                                                           u'default': u'default',
                                                                                                                                           u'description': u"The network to which this rule is attached. If omitted, the\nrule is attached to the ``default'' network.",
                                                                                                                                           u'group': u'',
                                                                                                                                           u'hidden': False,
                                                                                                                                           u'name': u'--network',
                                                                                                                                           u'nargs': u'0',
                                                                                                                                           u'required': False,
                                                                                                                                           u'type': u'string',
                                                                                                                                           u'value': u'NETWORK'},
                                                                                                                            u'--priority': {u'attr': {},
                                                                                                                                            u'category': u'',
                                                                                                                                            u'choices': [],
                                                                                                                                            u'completer': u'',
                                                                                                                                            u'default': None,
                                                                                                                                            u'description': u'This is an integer between 0 and 65535, both inclusive. When NOT\nspecified, the value assumed is 1000. Relative priority determines\nprecedence of conflicting rules: lower priority values imply higher\nprecedence. DENY rules take precedence over ALLOW rules having equal\npriority.',
                                                                                                                                            u'group': u'',
                                                                                                                                            u'hidden': False,
                                                                                                                                            u'name': u'--priority',
                                                                                                                                            u'nargs': u'0',
                                                                                                                                            u'required': False,
                                                                                                                                            u'type': u'string',
                                                                                                                                            u'value': u'PRIORITY'},
                                                                                                                            u'--rules': {u'attr': {},
                                                                                                                                         u'category': u'',
                                                                                                                                         u'choices': [],
                                                                                                                                         u'completer': u'',
                                                                                                                                         u'default': None,
                                                                                                                                         u'description': u'A list of protocols and ports to which the firewall rule will apply.\n+\nPROTOCOL is the IP protocol whose traffic will be checked.\nPROTOCOL can be either the name of a well-known protocol\n(e.g., tcp or icmp) or the IP protocol number.\nA list of IP protocols can be found at\nlink:http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml[].\n+\nA port or port range can be specified after PROTOCOL to which the\nfirewall rule apply on traffic through specific ports. If no port\nor port range is specified, connections through all ranges are applied.\nFor example, the following will create a rule that denys TCP\ntraffic through port 80 and ICMP traffic:\n+\n  $ {command} MY-RULE --action deny --rules tcp:80,icmp\n+\nTCP and UDP rules must include a port or port range.\n+\nIf specified, the flag --action must also be specified.',
                                                                                                                                         u'group': u'',
                                                                                                                                         u'hidden': False,
                                                                                                                                         u'name': u'--rules',
                                                                                                                                         u'nargs': u'0',
                                                                                                                                         u'required': False,
                                                                                                                                         u'type': u'list',
                                                                                                                                         u'value': u'PROTOCOL[:PORT[-PORT]]'},
                                                                                                                            u'--source-ranges': {u'attr': {},
                                                                                                                                                 u'category': u'',
                                                                                                                                                 u'choices': [],
                                                                                                                                                 u'completer': u'',
                                                                                                                                                 u'default': [],
                                                                                                                                                 u'description': u'A list of IP address blocks that are allowed to make inbound\nconnections that match the firewall rule to the instances on\nthe network. The IP address blocks must be specified in CIDR\nformat:\nlink:http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing[].\n+\nIf neither --source-ranges nor --source-tags is provided, then this\nflag will default to 0.0.0.0/0, allowing all sources. Multiple IP\naddress blocks can be specified if they are separated by commas.',
                                                                                                                                                 u'group': u'',
                                                                                                                                                 u'hidden': False,
                                                                                                                                                 u'name': u'--source-ranges',
                                                                                                                                                 u'nargs': u'0',
                                                                                                                                                 u'required': False,
                                                                                                                                                 u'type': u'list',
                                                                                                                                                 u'value': u'CIDR_RANGE'},
                                                                                                                            u'--source-tags': {u'attr': {},
                                                                                                                                               u'category': u'',
                                                                                                                                               u'choices': [],
                                                                                                                                               u'completer': u'',
                                                                                                                                               u'default': [],
                                                                                                                                               u'description': u'A list of instance tags indicating the set of instances on the\nnetwork which may make network connections that match the\nfirewall rule. If omitted, all instances on the network can\nmake connections that match the rule.\n+\nTags can be assigned to instances during instance creation.',
                                                                                                                                               u'group': u'',
                                                                                                                                               u'hidden': False,
                                                                                                                                               u'name': u'--source-tags',
                                                                                                                                               u'nargs': u'0',
                                                                                                                                               u'required': False,
                                                                                                                                               u'type': u'list',
                                                                                                                                               u'value': u'TAG'},
                                                                                                                            u'--target-tags': {u'attr': {},
                                                                                                                                               u'category': u'',
                                                                                                                                               u'choices': [],
                                                                                                                                               u'completer': u'',
                                                                                                                                               u'default': [],
                                                                                                                                               u'description': u'A list of instance tags indicating the set of instances on the\nnetwork which may accept inbound connections that match the\nfirewall rule. If omitted, all instances on the network can\nreceive inbound connections that match the rule.\n+\nTags can be assigned to instances during instance creation.',
                                                                                                                                               u'group': u'',
                                                                                                                                               u'hidden': False,
                                                                                                                                               u'name': u'--target-tags',
                                                                                                                                               u'nargs': u'0',
                                                                                                                                               u'required': False,
                                                                                                                                               u'type': u'list',
                                                                                                                                               u'value': u'TAG'}},
                                                                                                                 u'group': False,
                                                                                                                 u'groups': {u'create.1': {u'description': u'Exactly one of these must be specified:',
                                                                                                                                           u'is_mutex': True,
                                                                                                                                           u'is_required': True}},
                                                                                                                 u'hidden': False,
                                                                                                                 u'name': u'create',
                                                                                                                 u'path': [u'gcloud',
                                                                                                                           u'alpha',
                                                                                                                           u'compute',
                                                                                                                           u'firewall-rules',
                                                                                                                           u'create'],
                                                                                                                 u'positionals': [{u'completer': u'',
                                                                                                                                   u'default': None,
                                                                                                                                   u'description': u'The name of the firewall rule to create.',
                                                                                                                                   u'name': u'name',
                                                                                                                                   u'nargs': u'0',
                                                                                                                                   u'required': False,
                                                                                                                                   u'value': u'NAME'}],
                                                                                                                 u'release': u'ALPHA',
                                                                                                                 u'sections': {u'DESCRIPTION': u'*(ALPHA)* *create* is used to create firewall rules to allow/deny\nincoming/outgoing traffic.'}},
                                                                                                     u'delete': {u'capsule': u'*(ALPHA)* Delete Google Compute Engine firewall rules.',
                                                                                                                 u'commands': {},
                                                                                                                 u'flags': {},
                                                                                                                 u'group': False,
                                                                                                                 u'groups': {},
                                                                                                                 u'hidden': False,
                                                                                                                 u'name': u'delete',
                                                                                                                 u'path': [u'gcloud',
                                                                                                                           u'alpha',
                                                                                                                           u'compute',
                                                                                                                           u'firewall-rules',
                                                                                                                           u'delete'],
                                                                                                                 u'positionals': [{u'completer': u'',
                                                                                                                                   u'default': None,
                                                                                                                                   u'description': u'The resources to delete.',
                                                                                                                                   u'name': u'names',
                                                                                                                                   u'nargs': u'+',
                                                                                                                                   u'required': False,
                                                                                                                                   u'value': u'NAME'}],
                                                                                                                 u'release': u'ALPHA',
                                                                                                                 u'sections': {u'DESCRIPTION': u'*delete* deletes one or more Google Compute Engine firewall\n rules.\n'}},
                                                                                                     u'describe': {u'capsule': u'*(ALPHA)* Describe a Google Compute Engine firewall rule.',
                                                                                                                   u'commands': {},
                                                                                                                   u'flags': {},
                                                                                                                   u'group': False,
                                                                                                                   u'groups': {},
                                                                                                                   u'hidden': False,
                                                                                                                   u'name': u'describe',
                                                                                                                   u'path': [u'gcloud',
                                                                                                                             u'alpha',
                                                                                                                             u'compute',
                                                                                                                             u'firewall-rules',
                                                                                                                             u'describe'],
                                                                                                                   u'positionals': [{u'completer': u'',
                                                                                                                                     u'default': None,
                                                                                                                                     u'description': u'The name of the resource to fetch.',
                                                                                                                                     u'name': u'name',
                                                                                                                                     u'nargs': u'0',
                                                                                                                                     u'required': False,
                                                                                                                                     u'value': u'NAME'}],
                                                                                                                   u'release': u'ALPHA',
                                                                                                                   u'sections': {u'DESCRIPTION': u'*(ALPHA)* *describe* displays all data associated with a Google Compute\nEngine firewall rule in a project.'}},
                                                                                                     u'list': {u'capsule': u'*(ALPHA)* List Google Compute Engine firewall rules.',
                                                                                                               u'commands': {},
                                                                                                               u'flags': {u'--filter': {u'attr': {},
                                                                                                                                        u'category': u'LIST COMMAND',
                                                                                                                                        u'choices': [],
                                                                                                                                        u'completer': u'',
                                                                                                                                        u'default': None,
                                                                                                                                        u'description': u'Apply a Boolean filter _EXPRESSION_ to each resource item to be listed.\nIf the expression evaluates True then that item is listed. For more\ndetails and examples of filter expressions run $ gcloud topic filters. This\nflag interacts with other flags that are applied in this order: *--flatten*,\n*--sort-by*, *--filter*, *--limit*.',
                                                                                                                                        u'group': u'',
                                                                                                                                        u'hidden': False,
                                                                                                                                        u'name': u'--filter',
                                                                                                                                        u'nargs': u'0',
                                                                                                                                        u'required': False,
                                                                                                                                        u'type': u'string',
                                                                                                                                        u'value': u'EXPRESSION'},
                                                                                                                          u'--limit': {u'attr': {},
                                                                                                                                       u'category': u'LIST COMMAND',
                                                                                                                                       u'choices': [],
                                                                                                                                       u'completer': u'',
                                                                                                                                       u'default': None,
                                                                                                                                       u'description': u'The maximum number of resources to list. The default is *unlimited*.\nThis flag interacts with other flags that are applied in this order:\n*--flatten*, *--sort-by*, *--filter*, *--limit*.',
                                                                                                                                       u'group': u'',
                                                                                                                                       u'hidden': False,
                                                                                                                                       u'name': u'--limit',
                                                                                                                                       u'nargs': u'0',
                                                                                                                                       u'required': False,
                                                                                                                                       u'type': u'string',
                                                                                                                                       u'value': u'LIMIT'},
                                                                                                                          u'--no-uri': {u'attr': {},
                                                                                                                                        u'category': u'LIST COMMAND',
                                                                                                                                        u'choices': [],
                                                                                                                                        u'completer': u'',
                                                                                                                                        u'default': True,
                                                                                                                                        u'description': u'',
                                                                                                                                        u'group': u'',
                                                                                                                                        u'hidden': True,
                                                                                                                                        u'name': u'--no-uri',
                                                                                                                                        u'nargs': u'0',
                                                                                                                                        u'required': False,
                                                                                                                                        u'type': u'bool',
                                                                                                                                        u'value': u'NO_URI'},
                                                                                                                          u'--page-size': {u'attr': {},
                                                                                                                                           u'category': u'LIST COMMAND',
                                                                                                                                           u'choices': [],
                                                                                                                                           u'completer': u'',
                                                                                                                                           u'default': None,
                                                                                                                                           u'description': u'Some services group resource list output into pages. This flag specifies\nthe maximum number of resources per page. The default is determined by the\nservice if it supports paging, otherwise it is *unlimited* (no paging).\nPaging may be applied before or after *--filter* and *--limit* depending\non the service.',
                                                                                                                                           u'group': u'',
                                                                                                                                           u'hidden': False,
                                                                                                                                           u'name': u'--page-size',
                                                                                                                                           u'nargs': u'0',
                                                                                                                                           u'required': False,
                                                                                                                                           u'type': u'string',
                                                                                                                                           u'value': u'PAGE_SIZE'},
                                                                                                                          u'--regexp': {u'attr': {},
                                                                                                                                        u'category': u'',
                                                                                                                                        u'choices': [],
                                                                                                                                        u'completer': u'',
                                                                                                                                        u'default': None,
                                                                                                                                        u'description': u'A regular expression to filter the names of the results on. Any names\nthat do not match the entire regular expression will be filtered out.',
                                                                                                                                        u'group': u'',
                                                                                                                                        u'hidden': False,
                                                                                                                                        u'name': u'--regexp',
                                                                                                                                        u'nargs': u'0',
                                                                                                                                        u'required': False,
                                                                                                                                        u'type': u'string',
                                                                                                                                        u'value': u'REGEXP'},
                                                                                                                          u'--sort-by': {u'attr': {},
                                                                                                                                         u'category': u'LIST COMMAND',
                                                                                                                                         u'choices': [],
                                                                                                                                         u'completer': u'',
                                                                                                                                         u'default': None,
                                                                                                                                         u'description': u"A comma-separated list of resource field key names to sort by. The\ndefault order is ascending. Prefix a field with ``~'' for descending\norder on that field. This flag interacts with other flags that are applied\nin this order: *--flatten*, *--sort-by*, *--filter*, *--limit*.",
                                                                                                                                         u'group': u'',
                                                                                                                                         u'hidden': False,
                                                                                                                                         u'name': u'--sort-by',
                                                                                                                                         u'nargs': u'0',
                                                                                                                                         u'required': False,
                                                                                                                                         u'type': u'list',
                                                                                                                                         u'value': u'FIELD'},
                                                                                                                          u'--uri': {u'attr': {},
                                                                                                                                     u'category': u'LIST COMMAND',
                                                                                                                                     u'choices': [],
                                                                                                                                     u'completer': u'',
                                                                                                                                     u'default': False,
                                                                                                                                     u'description': u'Print a list of resource URIs instead of the default output.',
                                                                                                                                     u'group': u'',
                                                                                                                                     u'hidden': False,
                                                                                                                                     u'name': u'--uri',
                                                                                                                                     u'nargs': u'0',
                                                                                                                                     u'required': False,
                                                                                                                                     u'type': u'bool',
                                                                                                                                     u'value': u'URI'}},
                                                                                                               u'group': False,
                                                                                                               u'groups': {},
                                                                                                               u'hidden': False,
                                                                                                               u'name': u'list',
                                                                                                               u'path': [u'gcloud',
                                                                                                                         u'alpha',
                                                                                                                         u'compute',
                                                                                                                         u'firewall-rules',
                                                                                                                         u'list'],
                                                                                                               u'positionals': [{u'completer': u'',
                                                                                                                                 u'default': [],
                                                                                                                                 u'description': u'If provided, show details for the specified names and/or URIs of resources.',
                                                                                                                                 u'name': u'names',
                                                                                                                                 u'nargs': u'*',
                                                                                                                                 u'required': False,
                                                                                                                                 u'value': u'NAME'}],
                                                                                                               u'release': u'ALPHA',
                                                                                                               u'sections': {u'DESCRIPTION': u'*list* displays all Google Compute Engine firewall rules in a project.\n',
                                                                                                                             u'EXAMPLES': u'To list all firewall rules in a project in table form, run:\n\n  $ list\n\nTo list the URIs of all firewall rules in a project, run:\n\n  $ list --uri\n'}},
                                                                                                     u'update': {u'capsule': u'*(ALPHA)* Update a firewall rule.',
                                                                                                                 u'commands': {},
                                                                                                                 u'flags': {u'--allow': {u'attr': {},
                                                                                                                                         u'category': u'',
                                                                                                                                         u'choices': [],
                                                                                                                                         u'completer': u'',
                                                                                                                                         u'default': None,
                                                                                                                                         u'description': u'A list of protocols and ports whose traffic will be allowed.\n+\nPROTOCOL is the IP protocol whose traffic will be allowed.\nPROTOCOL can be either the name of a well-known protocol\n(e.g., tcp or icmp) or the IP protocol number.\nA list of IP protocols can be found at\nlink:http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml[].\n+\nA port or port range can be specified after PROTOCOL to\nallow traffic through specific ports. If no port or port range\nis specified, connections through all ranges are allowed. For\nexample, the following will create a rule that allows TCP traffic\nthrough port 80 and allows ICMP traffic:\n+\n  $ {command} MY-RULE --allow tcp:80,icmp\n+\nTCP and UDP rules must include a port or port range.\n+\nSetting this will override the current values.',
                                                                                                                                         u'group': u'',
                                                                                                                                         u'hidden': False,
                                                                                                                                         u'name': u'--allow',
                                                                                                                                         u'nargs': u'0',
                                                                                                                                         u'required': False,
                                                                                                                                         u'type': u'list',
                                                                                                                                         u'value': u'PROTOCOL[:PORT[-PORT]]'},
                                                                                                                            u'--description': {u'attr': {},
                                                                                                                                               u'category': u'',
                                                                                                                                               u'choices': [],
                                                                                                                                               u'completer': u'',
                                                                                                                                               u'default': None,
                                                                                                                                               u'description': u'A textual description for the firewall rule. Set to an empty string to clear existing.',
                                                                                                                                               u'group': u'',
                                                                                                                                               u'hidden': False,
                                                                                                                                               u'name': u'--description',
                                                                                                                                               u'nargs': u'0',
                                                                                                                                               u'required': False,
                                                                                                                                               u'type': u'string',
                                                                                                                                               u'value': u'DESCRIPTION'},
                                                                                                                            u'--destination-ranges': {u'attr': {},
                                                                                                                                                      u'category': u'',
                                                                                                                                                      u'choices': [],
                                                                                                                                                      u'completer': u'',
                                                                                                                                                      u'default': None,
                                                                                                                                                      u'description': u'The firewall rule will apply to traffic that has destination IP address\nin these IP address block list. The IP address blocks must be specified\nin CIDR format:\nlink:http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing[].\n+\nSetting this will override the existing destination ranges for the\nfirewall. The following will clear the existing destination ranges:\n+\n  $ {command} MY-RULE --destination-ranges',
                                                                                                                                                      u'group': u'',
                                                                                                                                                      u'hidden': False,
                                                                                                                                                      u'name': u'--destination-ranges',
                                                                                                                                                      u'nargs': u'0',
                                                                                                                                                      u'required': False,
                                                                                                                                                      u'type': u'list',
                                                                                                                                                      u'value': u'CIDR_RANGE'},
                                                                                                                            u'--priority': {u'attr': {},
                                                                                                                                            u'category': u'',
                                                                                                                                            u'choices': [],
                                                                                                                                            u'completer': u'',
                                                                                                                                            u'default': None,
                                                                                                                                            u'description': u'This is an integer between 0 and 65535, both inclusive. When NOT\nspecified, the value assumed is 1000. Relative priority determines\nprecedence of conflicting rules: lower priority values imply higher\nprecedence. DENY rules take precedence over ALLOW rules having equal\npriority.',
                                                                                                                                            u'group': u'',
                                                                                                                                            u'hidden': False,
                                                                                                                                            u'name': u'--priority',
                                                                                                                                            u'nargs': u'0',
                                                                                                                                            u'required': False,
                                                                                                                                            u'type': u'string',
                                                                                                                                            u'value': u'PRIORITY'},
                                                                                                                            u'--rules': {u'attr': {},
                                                                                                                                         u'category': u'',
                                                                                                                                         u'choices': [],
                                                                                                                                         u'completer': u'',
                                                                                                                                         u'default': None,
                                                                                                                                         u'description': u'A list of protocols and ports to which the firewall rule will apply.\n+\nPROTOCOL is the IP protocol whose traffic will be checked.\nPROTOCOL can be either the name of a well-known protocol\n(e.g., tcp or icmp) or the IP protocol number.\nA list of IP protocols can be found at\nlink:http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml[].\n+\nA port or port range can be specified after PROTOCOL to which the\nfirewall rule apply on traffic through specific ports. If no port\nor port range is specified, connections through all ranges are applied.\nFor example, the following will create a rule that denys TCP\ntraffic through port 80 and ICMP traffic:\n+\n  $ {command} MY-RULE --action deny --rules tcp:80,icmp\n+\nTCP and UDP rules must include a port or port range.\n+\nSetting this will override the current values.',
                                                                                                                                         u'group': u'',
                                                                                                                                         u'hidden': False,
                                                                                                                                         u'name': u'--rules',
                                                                                                                                         u'nargs': u'0',
                                                                                                                                         u'required': False,
                                                                                                                                         u'type': u'list',
                                                                                                                                         u'value': u'PROTOCOL[:PORT[-PORT]]'},
                                                                                                                            u'--source-ranges': {u'attr': {},
                                                                                                                                                 u'category': u'',
                                                                                                                                                 u'choices': [],
                                                                                                                                                 u'completer': u'',
                                                                                                                                                 u'default': None,
                                                                                                                                                 u'description': u'A list of IP address blocks that are allowed to make inbound\nconnections that match the firewall rule to the instances on\nthe network. The IP address blocks must be specified in CIDR\nformat:\nlink:http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing[].\n+\nSetting this will override the existing source ranges for the firewall.\nThe following will clear the existing source ranges:\n+\n  $ {command} MY-RULE --source-ranges',
                                                                                                                                                 u'group': u'',
                                                                                                                                                 u'hidden': False,
                                                                                                                                                 u'name': u'--source-ranges',
                                                                                                                                                 u'nargs': u'0',
                                                                                                                                                 u'required': False,
                                                                                                                                                 u'type': u'list',
                                                                                                                                                 u'value': u'CIDR_RANGE'},
                                                                                                                            u'--source-tags': {u'attr': {},
                                                                                                                                               u'category': u'',
                                                                                                                                               u'choices': [],
                                                                                                                                               u'completer': u'',
                                                                                                                                               u'default': None,
                                                                                                                                               u'description': u'A list of instance tags indicating the set of instances on the\nnetwork which may make network connections that match the\nfirewall rule. If omitted, all instances on the network can\nmake connections that match the rule.\n+\nTags can be assigned to instances during instance creation.\n+\nSetting this will override the existing source tags for the firewall.\nThe following will clear the existing source tags:\n+\n  $ {command} MY-RULE --source-tags',
                                                                                                                                               u'group': u'',
                                                                                                                                               u'hidden': False,
                                                                                                                                               u'name': u'--source-tags',
                                                                                                                                               u'nargs': u'0',
                                                                                                                                               u'required': False,
                                                                                                                                               u'type': u'list',
                                                                                                                                               u'value': u'TAG'},
                                                                                                                            u'--target-tags': {u'attr': {},
                                                                                                                                               u'category': u'',
                                                                                                                                               u'choices': [],
                                                                                                                                               u'completer': u'',
                                                                                                                                               u'default': None,
                                                                                                                                               u'description': u'A list of instance tags indicating the set of instances on the\nnetwork which may accept inbound connections that match the\nfirewall rule. If omitted, all instances on the network can\nreceive inbound connections that match the rule.\n+\nTags can be assigned to instances during instance creation.\n+\nSetting this will override the existing target tags for the firewall.\nThe following will clear the existing target tags:\n+\n  $ {command} MY-RULE --target-tags',
                                                                                                                                               u'group': u'',
                                                                                                                                               u'hidden': False,
                                                                                                                                               u'name': u'--target-tags',
                                                                                                                                               u'nargs': u'0',
                                                                                                                                               u'required': False,
                                                                                                                                               u'type': u'list',
                                                                                                                                               u'value': u'TAG'}},
                                                                                                                 u'group': False,
                                                                                                                 u'groups': {},
                                                                                                                 u'hidden': False,
                                                                                                                 u'name': u'update',
                                                                                                                 u'path': [u'gcloud',
                                                                                                                           u'alpha',
                                                                                                                           u'compute',
                                                                                                                           u'firewall-rules',
                                                                                                                           u'update'],
                                                                                                                 u'positionals': [{u'completer': u'',
                                                                                                                                   u'default': None,
                                                                                                                                   u'description': u'The name of the firewall rule to update.',
                                                                                                                                   u'name': u'name',
                                                                                                                                   u'nargs': u'0',
                                                                                                                                   u'required': False,
                                                                                                                                   u'value': u'NAME'}],
                                                                                                                 u'release': u'ALPHA',
                                                                                                                 u'sections': {u'DESCRIPTION': u'*update* is used to update firewall rules that allow/deny\nincoming/outgoing traffic. Only arguments passed in will be updated on\nthe firewall rule.  Other attributes will remain unaffected.\n'}}},
                                                                                       u'flags': {},
                                                                                       u'group': True,
                                                                                       u'groups': {},
                                                                                       u'hidden': False,
                                                                                       u'name': u'firewall-rules',
                                                                                       u'path': [u'gcloud',
                                                                                                 u'alpha',
                                                                                                 u'compute',
                                                                                                 u'firewall-rules'],
                                                                                       u'positionals': [],
                                                                                       u'release': u'ALPHA',
                                                                                       u'sections': {u'DESCRIPTION': u'*(ALPHA)* List, create, update, and delete Google Compute Engine firewall rules.'}},
                                                                   u'forwarding-rules': {u'capsule': u'*(ALPHA)* Read and manipulate forwarding rules to send traffic to load balancers.',
                                                                                         u'commands': {u'create': {u'capsule': u'*(ALPHA)* Create a forwarding rule to direct network traffic to a load balancer.',
                                                                                                                   u'commands': {},
                                                                                                                   u'flags': {u'--address': {u'attr': {},
                                                                                                                                             u'category': u'',
                                                                                                                                             u'choices': [],
                                                                                                                                             u'completer': u'',
                                                                                                                                             u'default': None,
                                                                                                                                             u'description': u'The external IP address that the forwarding rule will\nserve. All traffic sent to this IP address is directed to the\ntarget pointed to by the forwarding rule. If the address is\nreserved, it must either (1) reside in the global scope if the\nforwarding rule is being configured to point to a target HTTP\nproxy or (2) reside in the same region as the forwarding rule\nif the forwarding rule is being configured to point to a\ntarget pool or target instance. If this flag is omitted, an\nephemeral IP address is assigned.',
                                                                                                                                             u'group': u'',
                                                                                                                                             u'hidden': False,
                                                                                                                                             u'name': u'--address',
                                                                                                                                             u'nargs': u'0',
                                                                                                                                             u'required': False,
                                                                                                                                             u'type': u'string',
                                                                                                                                             u'value': u'ADDRESS'},
                                                                                                                              u'--address-region': {u'attr': {u'property': {u'name': u'compute/region'}},
                                                                                                                                                    u'category': u'',
                                                                                                                                                    u'choices': [],
                                                                                                                                                    u'completer': u'',
                                                                                                                                                    u'default': None,
                                                                                                                                                    u'description': u"The region of the address to operate on. If not specified, you will be prompted to select a region.\n+\nTo avoid prompting when this flag is omitted, you can set the\n``compute/region'' property:\n+\n  $ gcloud config set compute/region REGION\n+\nA list of regions can be fetched by running:\n+\n  $ gcloud compute regions list\n+\nTo unset the property, run:\n+\n  $ gcloud config unset compute/region\n+\nAlternatively, the region can be stored in the environment\nvariable ``CLOUDSDK_COMPUTE_REGION''.",
                                                                                                                                                    u'group': u'create.1',
                                                                                                                                                    u'hidden': False,
                                                                                                                                                    u'name': u'--address-region',
                                                                                                                                                    u'nargs': u'0',
                                                                                                                                                    u'required': False,
                                                                                                                                                    u'type': u'string',
                                                                                                                                                    u'value': u'ADDRESS_REGION'},
                                                                                                                              u'--backend-service': {u'attr': {},
                                                                                                                                                     u'category': u'',
                                                                                                                                                     u'choices': [],
                                                                                                                                                     u'completer': u'',
                                                                                                                                                     u'default': None,
                                                                                                                                                     u'description': u'The target backend service that will receive the traffic.',
                                                                                                                                                     u'group': u'create.2',
                                                                                                                                                     u'hidden': False,
                                                                                                                                                     u'name': u'--backend-service',
                                                                                                                                                     u'nargs': u'0',
                                                                                                                                                     u'required': False,
                                                                                                                                                     u'type': u'string',
                                                                                                                                                     u'value': u'BACKEND_SERVICE'},
                                                                                                                              u'--backend-service-region': {u'attr': {u'property': {u'name': u'compute/region'}},
                                                                                                                                                            u'category': u'',
                                                                                                                                                            u'choices': [],
                                                                                                                                                            u'completer': u'',
                                                                                                                                                            u'default': None,
                                                                                                                                                            u'description': u'The region of the backend service to operate on. If not specified it will be set the region of the forwarding rule. Overrides the default *compute/region* property value for this command invocation.',
                                                                                                                                                            u'group': u'create.3',
                                                                                                                                                            u'hidden': False,
                                                                                                                                                            u'name': u'--backend-service-region',
                                                                                                                                                            u'nargs': u'0',
                                                                                                                                                            u'required': False,
                                                                                                                                                            u'type': u'string',
                                                                                                                                                            u'value': u'BACKEND_SERVICE_REGION'},
                                                                                                                              u'--description': {u'attr': {},
                                                                                                                                                 u'category': u'',
                                                                                                                                                 u'choices': [],
                                                                                                                                                 u'completer': u'',
                                                                                                                                                 u'default': None,
                                                                                                                                                 u'description': u'An optional textual description for the forwarding rule.',
                                                                                                                                                 u'group': u'',
                                                                                                                                                 u'hidden': False,
                                                                                                                                                 u'name': u'--description',
                                                                                                                                                 u'nargs': u'0',
                                                                                                                                                 u'required': False,
                                                                                                                                                 u'type': u'string',
                                                                                                                                                 u'value': u'DESCRIPTION'},
                                                                                                                              u'--global': {u'attr': {},
                                                                                                                                            u'category': u'',
                                                                                                                                            u'choices': [],
                                                                                                                                            u'completer': u'',
                                                                                                                                            u'default': False,
                                                                                                                                            u'description': u'If provided, it is assumed the forwarding rule is global.',
                                                                                                                                            u'group': u'create.4',
                                                                                                                                            u'hidden': False,
                                                                                                                                            u'name': u'--global',
                                                                                                                                            u'nargs': u'0',
                                                                                                                                            u'required': False,
                                                                                                                                            u'type': u'bool',
                                                                                                                                            u'value': u'GLOBAL'},
                                                                                                                              u'--global-address': {u'attr': {},
                                                                                                                                                    u'category': u'',
                                                                                                                                                    u'choices': [],
                                                                                                                                                    u'completer': u'',
                                                                                                                                                    u'default': False,
                                                                                                                                                    u'description': u'If provided, it is assumed the address is global.',
                                                                                                                                                    u'group': u'create.1',
                                                                                                                                                    u'hidden': False,
                                                                                                                                                    u'name': u'--global-address',
                                                                                                                                                    u'nargs': u'0',
                                                                                                                                                    u'required': False,
                                                                                                                                                    u'type': u'bool',
                                                                                                                                                    u'value': u'GLOBAL_ADDRESS'},
                                                                                                                              u'--global-backend-service': {u'attr': {},
                                                                                                                                                            u'category': u'',
                                                                                                                                                            u'choices': [],
                                                                                                                                                            u'completer': u'',
                                                                                                                                                            u'default': False,
                                                                                                                                                            u'description': u'If provided, it is assumed the backend service is global.',
                                                                                                                                                            u'group': u'create.3',
                                                                                                                                                            u'hidden': False,
                                                                                                                                                            u'name': u'--global-backend-service',
                                                                                                                                                            u'nargs': u'0',
                                                                                                                                                            u'required': False,
                                                                                                                                                            u'type': u'bool',
                                                                                                                                                            u'value': u'GLOBAL_BACKEND_SERVICE'},
                                                                                                                              u'--ip-protocol': {u'attr': {},
                                                                                                                                                 u'category': u'',
                                                                                                                                                 u'choices': [u'AH',
                                                                                                                                                              u'ESP',
                                                                                                                                                              u'ICMP',
                                                                                                                                                              u'SCTP',
                                                                                                                                                              u'TCP',
                                                                                                                                                              u'UDP'],
                                                                                                                                                 u'completer': u'',
                                                                                                                                                 u'default': None,
                                                                                                                                                 u'description': u'The IP protocol that the rule will serve. The default is TCP. _IP_PROTOCOL_ must be one of: *AH*, *ESP*, *ICMP*, *SCTP*, *TCP*, *UDP*.',
                                                                                                                                                 u'group': u'',
                                                                                                                                                 u'hidden': False,
                                                                                                                                                 u'name': u'--ip-protocol',
                                                                                                                                                 u'nargs': u'0',
                                                                                                                                                 u'required': False,
                                                                                                                                                 u'type': u'string',
                                                                                                                                                 u'value': u'IP_PROTOCOL'},
                                                                                                                              u'--load-balancing-scheme': {u'attr': {},
                                                                                                                                                           u'category': u'',
                                                                                                                                                           u'choices': [u'EXTERNAL',
                                                                                                                                                                        u'INTERNAL'],
                                                                                                                                                           u'completer': u'',
                                                                                                                                                           u'default': u'EXTERNAL',
                                                                                                                                                           u'description': u'This signifies what the forwarding rule will be used for. _LOAD_BALANCING_SCHEME_ must be one of:\n+\n*EXTERNAL*::: Used for HTTP or HTTPS for External Load Balancing.\n*INTERNAL*::: Used for Internal Network Load Balancing.\n+',
                                                                                                                                                           u'group': u'',
                                                                                                                                                           u'hidden': False,
                                                                                                                                                           u'name': u'--load-balancing-scheme',
                                                                                                                                                           u'nargs': u'0',
                                                                                                                                                           u'required': False,
                                                                                                                                                           u'type': u'string',
                                                                                                                                                           u'value': u'LOAD_BALANCING_SCHEME'},
                                                                                                                              u'--network': {u'attr': {},
                                                                                                                                             u'category': u'',
                                                                                                                                             u'choices': [],
                                                                                                                                             u'completer': u'',
                                                                                                                                             u'default': None,
                                                                                                                                             u'description': u'(Only for Internal Load Balancing) The network that this forwarding\nrule applies to. If this field is not specified, the default network\nwill be used. In the absence of the default network, this field must\nbe specified.',
                                                                                                                                             u'group': u'',
                                                                                                                                             u'hidden': False,
                                                                                                                                             u'name': u'--network',
                                                                                                                                             u'nargs': u'0',
                                                                                                                                             u'required': False,
                                                                                                                                             u'type': u'string',
                                                                                                                                             u'value': u'NETWORK'},
                                                                                                                              u'--network-tier': {u'attr': {},
                                                                                                                                                  u'category': u'',
                                                                                                                                                  u'choices': [u'PREMIUM',
                                                                                                                                                               u'SELECT'],
                                                                                                                                                  u'completer': u'',
                                                                                                                                                  u'default': None,
                                                                                                                                                  u'description': u'The network tier to assign to the forwarding rules. If left empty, `PREMIUM` is used. Supported network tiers are: `PREMIUM`, `SELECT`. _NETWORK_TIER_ must be one of: *PREMIUM*, *SELECT*.',
                                                                                                                                                  u'group': u'',
                                                                                                                                                  u'hidden': False,
                                                                                                                                                  u'name': u'--network-tier',
                                                                                                                                                  u'nargs': u'0',
                                                                                                                                                  u'required': False,
                                                                                                                                                  u'type': u'string',
                                                                                                                                                  u'value': u'NETWORK_TIER'},
                                                                                                                              u'--port-range': {u'attr': {},
                                                                                                                                                u'category': u'',
                                                                                                                                                u'choices': [],
                                                                                                                                                u'completer': u'',
                                                                                                                                                u'default': None,
                                                                                                                                                u'description': u'DEPRECATED, use --ports. If specified, only packets addressed to ports in\nthe specified range will be forwarded. If not specified for regional\nforwarding rules, all ports are matched. This flag is required for global\nforwarding rules.\n+\nEither an individual port (`--port-range 80`) or a range of ports\n(`--port-range 3000-3100`) may be specified.',
                                                                                                                                                u'group': u'create.5',
                                                                                                                                                u'hidden': False,
                                                                                                                                                u'name': u'--port-range',
                                                                                                                                                u'nargs': u'0',
                                                                                                                                                u'required': False,
                                                                                                                                                u'type': u'string',
                                                                                                                                                u'value': u'[PORT | PORT-PORT]'},
                                                                                                                              u'--ports': {u'attr': {},
                                                                                                                                           u'category': u'',
                                                                                                                                           u'choices': [],
                                                                                                                                           u'completer': u'',
                                                                                                                                           u'default': [],
                                                                                                                                           u'description': u'If specified, only packets addressed to ports in the specified\nlist will be forwarded. If not specified for regional forwarding\nrules, all ports are matched. This flag is required for global\nforwarding rules and accepts a single continuous set of ports.\n+\nIndividual ports and ranges can be specified,\nfor example (`--ports 8000-8004` or `--ports 80`).',
                                                                                                                                           u'group': u'create.5',
                                                                                                                                           u'hidden': False,
                                                                                                                                           u'name': u'--ports',
                                                                                                                                           u'nargs': u'0',
                                                                                                                                           u'required': False,
                                                                                                                                           u'type': u'list',
                                                                                                                                           u'value': u'[PORT | PORT-PORT]'},
                                                                                                                              u'--region': {u'attr': {u'property': {u'name': u'compute/region'}},
                                                                                                                                            u'category': u'',
                                                                                                                                            u'choices': [],
                                                                                                                                            u'completer': u'',
                                                                                                                                            u'default': None,
                                                                                                                                            u'description': u"The region of the forwarding rule to operate on. If not specified, you will be prompted to select a region.\n+\nTo avoid prompting when this flag is omitted, you can set the\n``compute/region'' property:\n+\n  $ gcloud config set compute/region REGION\n+\nA list of regions can be fetched by running:\n+\n  $ gcloud compute regions list\n+\nTo unset the property, run:\n+\n  $ gcloud config unset compute/region\n+\nAlternatively, the region can be stored in the environment\nvariable ``CLOUDSDK_COMPUTE_REGION''.",
                                                                                                                                            u'group': u'create.4',
                                                                                                                                            u'hidden': False,
                                                                                                                                            u'name': u'--region',
                                                                                                                                            u'nargs': u'0',
                                                                                                                                            u'required': False,
                                                                                                                                            u'type': u'string',
                                                                                                                                            u'value': u'REGION'},
                                                                                                                              u'--service-label': {u'attr': {},
                                                                                                                                                   u'category': u'',
                                                                                                                                                   u'choices': [],
                                                                                                                                                   u'completer': u'',
                                                                                                                                                   u'default': None,
                                                                                                                                                   u'description': u'(Only for Internal Load Balancing): https://cloud.google.com/compute/docs/load-balancing/internal/\nThe DNS label to use as the prefix of the fully qualified domain name for this forwarding rule. The full name will be internally generated and output as dnsName. If this field is not specified, no DNS record will be generated and no DNS name will be output.',
                                                                                                                                                   u'group': u'',
                                                                                                                                                   u'hidden': False,
                                                                                                                                                   u'name': u'--service-label',
                                                                                                                                                   u'nargs': u'0',
                                                                                                                                                   u'required': False,
                                                                                                                                                   u'type': u'string',
                                                                                                                                                   u'value': u'SERVICE_LABEL'},
                                                                                                                              u'--subnet': {u'attr': {},
                                                                                                                                            u'category': u'',
                                                                                                                                            u'choices': [],
                                                                                                                                            u'completer': u'',
                                                                                                                                            u'default': None,
                                                                                                                                            u'description': u'(Only for Internal Load Balancing) The subnetwork that this forwarding\nrule applies to. If the network configured for this forwarding rule is\nin auto subnet mode, the subnetwork is optional. However, if the\nnetwork is in custom subnet mode, a subnetwork must be specified.',
                                                                                                                                            u'group': u'',
                                                                                                                                            u'hidden': False,
                                                                                                                                            u'name': u'--subnet',
                                                                                                                                            u'nargs': u'0',
                                                                                                                                            u'required': False,
                                                                                                                                            u'type': u'string',
                                                                                                                                            u'value': u'SUBNET'},
                                                                                                                              u'--subnet-region': {u'attr': {u'property': {u'name': u'compute/region'}},
                                                                                                                                                   u'category': u'',
                                                                                                                                                   u'choices': [],
                                                                                                                                                   u'completer': u'',
                                                                                                                                                   u'default': None,
                                                                                                                                                   u'description': u'The region of the subnetwork to operate on. If not specified it will be set the region of the forwarding rule. Overrides the default *compute/region* property value for this command invocation.',
                                                                                                                                                   u'group': u'',
                                                                                                                                                   u'hidden': False,
                                                                                                                                                   u'name': u'--subnet-region',
                                                                                                                                                   u'nargs': u'0',
                                                                                                                                                   u'required': False,
                                                                                                                                                   u'type': u'string',
                                                                                                                                                   u'value': u'SUBNET_REGION'},
                                                                                                                              u'--target-http-proxy': {u'attr': {},
                                                                                                                                                       u'category': u'',
                                                                                                                                                       u'choices': [],
                                                                                                                                                       u'completer': u'',
                                                                                                                                                       u'default': None,
                                                                                                                                                       u'description': u'The target HTTP proxy that will receive the traffic.',
                                                                                                                                                       u'group': u'create.2',
                                                                                                                                                       u'hidden': False,
                                                                                                                                                       u'name': u'--target-http-proxy',
                                                                                                                                                       u'nargs': u'0',
                                                                                                                                                       u'required': False,
                                                                                                                                                       u'type': u'string',
                                                                                                                                                       u'value': u'TARGET_HTTP_PROXY'},
                                                                                                                              u'--target-https-proxy': {u'attr': {},
                                                                                                                                                        u'category': u'',
                                                                                                                                                        u'choices': [],
                                                                                                                                                        u'completer': u'',
                                                                                                                                                        u'default': None,
                                                                                                                                                        u'description': u'The target HTTPS proxy that will receive the traffic.',
                                                                                                                                                        u'group': u'create.2',
                                                                                                                                                        u'hidden': False,
                                                                                                                                                        u'name': u'--target-https-proxy',
                                                                                                                                                        u'nargs': u'0',
                                                                                                                                                        u'required': False,
                                                                                                                                                        u'type': u'string',
                                                                                                                                                        u'value': u'TARGET_HTTPS_PROXY'},
                                                                                                                              u'--target-instance': {u'attr': {},
                                                                                                                                                     u'category': u'',
                                                                                                                                                     u'choices': [],
                                                                                                                                                     u'completer': u'',
                                                                                                                                                     u'default': None,
                                                                                                                                                     u'description': u"The name of the target instance that will receive the traffic. The\ntarget instance must be in a zone that's in the forwarding rule's\nregion. Global forwarding rules may not direct traffic to target\ninstances.\nIf not specified, you will be prompted to select a zone.\n+\nTo avoid prompting when this flag is omitted, you can set the\n``compute/zone'' property:\n+\n  $ gcloud config set compute/zone ZONE\n+\nA list of zones can be fetched by running:\n+\n  $ gcloud compute zones list\n+\nTo unset the property, run:\n+\n  $ gcloud config unset compute/zone\n+\nAlternatively, the zone can be stored in the environment variable\n``CLOUDSDK_COMPUTE_ZONE''.",
                                                                                                                                                     u'group': u'create.2',
                                                                                                                                                     u'hidden': False,
                                                                                                                                                     u'name': u'--target-instance',
                                                                                                                                                     u'nargs': u'0',
                                                                                                                                                     u'required': False,
                                                                                                                                                     u'type': u'string',
                                                                                                                                                     u'value': u'TARGET_INSTANCE'},
                                                                                                                              u'--target-instance-zone': {u'attr': {u'property': {u'name': u'compute/zone'}},
                                                                                                                                                          u'category': u'',
                                                                                                                                                          u'choices': [],
                                                                                                                                                          u'completer': u'',
                                                                                                                                                          u'default': None,
                                                                                                                                                          u'description': u'The zone of the target instance to operate on. Overrides the default *compute/zone* property value for this command invocation.',
                                                                                                                                                          u'group': u'',
                                                                                                                                                          u'hidden': False,
                                                                                                                                                          u'name': u'--target-instance-zone',
                                                                                                                                                          u'nargs': u'0',
                                                                                                                                                          u'required': False,
                                                                                                                                                          u'type': u'string',
                                                                                                                                                          u'value': u'TARGET_INSTANCE_ZONE'},
                                                                                                                              u'--target-pool': {u'attr': {},
                                                                                                                                                 u'category': u'',
                                                                                                                                                 u'choices': [],
                                                                                                                                                 u'completer': u'',
                                                                                                                                                 u'default': None,
                                                                                                                                                 u'description': u'The target pool that will receive the traffic. The target pool\nmust be in the same region as the forwarding rule. Global\nforwarding rules may not direct traffic to target pools.',
                                                                                                                                                 u'group': u'create.2',
                                                                                                                                                 u'hidden': False,
                                                                                                                                                 u'name': u'--target-pool',
                                                                                                                                                 u'nargs': u'0',
                                                                                                                                                 u'required': False,
                                                                                                                                                 u'type': u'string',
                                                                                                                                                 u'value': u'TARGET_POOL'},
                                                                                                                              u'--target-pool-region': {u'attr': {u'property': {u'name': u'compute/region'}},
                                                                                                                                                        u'category': u'',
                                                                                                                                                        u'choices': [],
                                                                                                                                                        u'completer': u'',
                                                                                                                                                        u'default': None,
                                                                                                                                                        u'description': u'The region of the target pool to operate on. If not specified it will be set the region of the forwarding rule. Overrides the default *compute/region* property value for this command invocation.',
                                                                                                                                                        u'group': u'',
                                                                                                                                                        u'hidden': False,
                                                                                                                                                        u'name': u'--target-pool-region',
                                                                                                                                                        u'nargs': u'0',
                                                                                                                                                        u'required': False,
                                                                                                                                                        u'type': u'string',
                                                                                                                                                        u'value': u'TARGET_POOL_REGION'},
                                                                                                                              u'--target-ssl-proxy': {u'attr': {},
                                                                                                                                                      u'category': u'',
                                                                                                                                                      u'choices': [],
                                                                                                                                                      u'completer': u'',
                                                                                                                                                      u'default': None,
                                                                                                                                                      u'description': u'The target SSL proxy that will receive the traffic.',
                                                                                                                                                      u'group': u'create.2',
                                                                                                                                                      u'hidden': False,
                                                                                                                                                      u'name': u'--target-ssl-proxy',
                                                                                                                                                      u'nargs': u'0',
                                                                                                                                                      u'required': False,
                                                                                                                                                      u'type': u'string',
                                                                                                                                                      u'value': u'TARGET_SSL_PROXY'},
                                                                                                                              u'--target-tcp-proxy': {u'attr': {},
                                                                                                                                                      u'category': u'',
                                                                                                                                                      u'choices': [],
                                                                                                                                                      u'completer': u'',
                                                                                                                                                      u'default': None,
                                                                                                                                                      u'description': u'The target TCP proxy that will receive the traffic.',
                                                                                                                                                      u'group': u'create.2',
                                                                                                                                                      u'hidden': False,
                                                                                                                                                      u'name': u'--target-tcp-proxy',
                                                                                                                                                      u'nargs': u'0',
                                                                                                                                                      u'required': False,
                                                                                                                                                      u'type': u'string',
                                                                                                                                                      u'value': u'TARGET_TCP_PROXY'},
                                                                                                                              u'--target-vpn-gateway': {u'attr': {},
                                                                                                                                                        u'category': u'',
                                                                                                                                                        u'choices': [],
                                                                                                                                                        u'completer': u'',
                                                                                                                                                        u'default': None,
                                                                                                                                                        u'description': u'The target VPN gateway that will receive forwarded traffic.',
                                                                                                                                                        u'group': u'create.2',
                                                                                                                                                        u'hidden': False,
                                                                                                                                                        u'name': u'--target-vpn-gateway',
                                                                                                                                                        u'nargs': u'0',
                                                                                                                                                        u'required': False,
                                                                                                                                                        u'type': u'string',
                                                                                                                                                        u'value': u'TARGET_VPN_GATEWAY'},
                                                                                                                              u'--target-vpn-gateway-region': {u'attr': {u'property': {u'name': u'compute/region'}},
                                                                                                                                                               u'category': u'',
                                                                                                                                                               u'choices': [],
                                                                                                                                                               u'completer': u'',
                                                                                                                                                               u'default': None,
                                                                                                                                                               u'description': u'The region of the VPN gateway to operate on. If not specified it will be set the region of the forwarding rule. Overrides the default *compute/region* property value for this command invocation.',
                                                                                                                                                               u'group': u'',
                                                                                                                                                               u'hidden': False,
                                                                                                                                                               u'name': u'--target-vpn-gateway-region',
                                                                                                                                                               u'nargs': u'0',
                                                                                                                                                               u'required': False,
                                                                                                                                                               u'type': u'string',
                                                                                                                                                               u'value': u'TARGET_VPN_GATEWAY_REGION'}},
                                                                                                                   u'group': False,
                                                                                                                   u'groups': {u'create.1': {u'description': u'At most one of these may be specified:',
                                                                                                                                             u'is_mutex': True,
                                                                                                                                             u'is_required': False},
                                                                                                                               u'create.2': {u'description': u'Exactly one of these must be specified:',
                                                                                                                                             u'is_mutex': True,
                                                                                                                                             u'is_required': True},
                                                                                                                               u'create.3': {u'description': u'At most one of these may be specified:',
                                                                                                                                             u'is_mutex': True,
                                                                                                                                             u'is_required': False},
                                                                                                                               u'create.4': {u'description': u'At most one of these may be specified:',
                                                                                                                                             u'is_mutex': True,
                                                                                                                                             u'is_required': False},
                                                                                                                               u'create.5': {u'description': u'At most one of these may be specified:',
                                                                                                                                             u'is_mutex': True,
                                                                                                                                             u'is_required': False}},
                                                                                                                   u'hidden': False,
                                                                                                                   u'name': u'create',
                                                                                                                   u'path': [u'gcloud',
                                                                                                                             u'alpha',
                                                                                                                             u'compute',
                                                                                                                             u'forwarding-rules',
                                                                                                                             u'create'],
                                                                                                                   u'positionals': [{u'completer': u'',
                                                                                                                                     u'default': None,
                                                                                                                                     u'description': u'The name of the forwarding rule.',
                                                                                                                                     u'name': u'name',
                                                                                                                                     u'nargs': u'0',
                                                                                                                                     u'required': False,
                                                                                                                                     u'value': u'NAME'}],
                                                                                                                   u'release': u'ALPHA',
                                                                                                                   u'sections': {u'DESCRIPTION': u"*create* is used to create a forwarding rule.         Forwarding rules match and direct certain types of traffic to a load\nbalancer which is controlled by a target pool, a target instance,\nor a target HTTP proxy. Target pools and target instances perform load\nbalancing at the layer 3 of the OSI networking model\n(http://en.wikipedia.org/wiki/Network_layer). Target\nHTTP proxies perform load balancing at layer 7.\n\nForwarding rules can be either regional or global. They are\nregional if they point to a target pool or a target instance\nand global if they point to a target HTTP proxy.\n\nFor more information on load balancing, see\nhttps://cloud.google.com/compute/docs/load-balancing-and-autoscaling/.\n\n\nWhen creating a forwarding rule, exactly one of  ``--target-instance'',\n``--target-pool'', ``--target-http-proxy'', ``--target-https-proxy'',\n``--target-ssl-proxy'', ``--target-tcp-proxy'', or\n``--target-vpn-gateway'' must be specified."}},
                                                                                                       u'delete': {u'capsule': u'*(ALPHA)* Delete forwarding rules.',
                                                                                                                   u'commands': {},
                                                                                                                   u'flags': {u'--global': {u'attr': {},
                                                                                                                                            u'category': u'',
                                                                                                                                            u'choices': [],
                                                                                                                                            u'completer': u'',
                                                                                                                                            u'default': False,
                                                                                                                                            u'description': u'If provided, it is assumed the forwarding rule is global.',
                                                                                                                                            u'group': u'delete.1',
                                                                                                                                            u'hidden': False,
                                                                                                                                            u'name': u'--global',
                                                                                                                                            u'nargs': u'0',
                                                                                                                                            u'required': False,
                                                                                                                                            u'type': u'bool',
                                                                                                                                            u'value': u'GLOBAL'},
                                                                                                                              u'--region': {u'attr': {u'property': {u'name': u'compute/region'}},
                                                                                                                                            u'category': u'',
                                                                                                                                            u'choices': [],
                                                                                                                                            u'completer': u'',
                                                                                                                                            u'default': None,
                                                                                                                                            u'description': u"The region of the forwarding rule to operate on. If not specified, you will be prompted to select a region.\n+\nTo avoid prompting when this flag is omitted, you can set the\n``compute/region'' property:\n+\n  $ gcloud config set compute/region REGION\n+\nA list of regions can be fetched by running:\n+\n  $ gcloud compute regions list\n+\nTo unset the property, run:\n+\n  $ gcloud config unset compute/region\n+\nAlternatively, the region can be stored in the environment\nvariable ``CLOUDSDK_COMPUTE_REGION''.",
                                                                                                                                            u'group': u'delete.1',
                                                                                                                                            u'hidden': False,
                                                                                                                                            u'name': u'--region',
                                                                                                                                            u'nargs': u'0',
                                                                                                                                            u'required': False,
                                                                                                                                            u'type': u'string',
                                                                                                                                            u'value': u'REGION'}},
                                                                                                                   u'group': False,
                                                                                                                   u'groups': {u'delete.1': {u'description': u'At most one of these may be specified:',
                                                                                                                                             u'is_mutex': True,
                                                                                                                                             u'is_required': False}},
                                                                                                                   u'hidden': False,
                                                                                                                   u'name': u'delete',
                                                                                                                   u'path': [u'gcloud',
                                                                                                                             u'alpha',
                                                                                                                             u'compute',
                                                                                                                             u'forwarding-rules',
                                                                                                                             u'delete'],
                                                                                                                   u'positionals': [{u'completer': u'',
                                                                                                                                     u'default': None,
                                                                                                                                     u'description': u'The names of the forwarding rules.',
                                                                                                                                     u'name': u'name',
                                                                                                                                     u'nargs': u'+',
                                                                                                                                     u'required': False,
                                                                                                                                     u'value': u'NAME'}],
                                                                                                                   u'release': u'ALPHA',
                                                                                                                   u'sections': {u'DESCRIPTION': u'*(ALPHA)* *delete* deletes one or more Google Compute Engine forwarding rules.'}},
                                                                                                       u'describe': {u'capsule': u'*(ALPHA)* Display detailed information about a forwarding rule.',
                                                                                                                     u'commands': {},
                                                                                                                     u'flags': {u'--global': {u'attr': {},
                                                                                                                                              u'category': u'',
                                                                                                                                              u'choices': [],
                                                                                                                                              u'completer': u'',
                                                                                                                                              u'default': False,
                                                                                                                                              u'description': u'If provided, it is assumed that the requested resource is global.',
                                                                                                                                              u'group': u'describe.1',
                                                                                                                                              u'hidden': False,
                                                                                                                                              u'name': u'--global',
                                                                                                                                              u'nargs': u'0',
                                                                                                                                              u'required': False,
                                                                                                                                              u'type': u'bool',
                                                                                                                                              u'value': u'GLOBAL'},
                                                                                                                                u'--region': {u'attr': {u'property': {u'name': u'compute/region'}},
                                                                                                                                              u'category': u'',
                                                                                                                                              u'choices': [],
                                                                                                                                              u'completer': u'',
                                                                                                                                              u'default': None,
                                                                                                                                              u'description': u'The region of the resource to fetch. Overrides the default *compute/region* property value for this command invocation.',
                                                                                                                                              u'group': u'describe.1',
                                                                                                                                              u'hidden': False,
                                                                                                                                              u'name': u'--region',
                                                                                                                                              u'nargs': u'0',
                                                                                                                                              u'required': False,
                                                                                                                                              u'type': u'string',
                                                                                                                                              u'value': u'REGION'}},
                                                                                                                     u'group': False,
                                                                                                                     u'groups': {u'describe.1': {u'description': u'At most one of these may be specified:',
                                                                                                                                                 u'is_mutex': True,
                                                                                                                                                 u'is_required': False}},
                                                                                                                     u'hidden': False,
                                                                                                                     u'name': u'describe',
                                                                                                                     u'path': [u'gcloud',
                                                                                                                               u'alpha',
                                                                                                                               u'compute',
                                                                                                                               u'forwarding-rules',
                                                                                                                               u'describe'],
                                                                                                                     u'positionals': [{u'completer': u'',
                                                                                                                                       u'default': None,
                                                                                                                                       u'description': u'The name of the resource to fetch.',
                                                                                                                                       u'name': u'name',
                                                                                                                                       u'nargs': u'0',
                                                                                                                                       u'required': False,
                                                                                                                                       u'value': u'NAME'}],
                                                                                                                     u'release': u'ALPHA',
                                                                                                                     u'sections': {u'DESCRIPTION': u'*describe* displays all data associated with a forwarding rule\nin a project.\n',
                                                                                                                                   u'EXAMPLES': u'To get details about a global forwarding rule, run:\n\n  $ describe FORWARDING-RULE --global\n\nTo get details about a regional forwarding rule, run:\n\n  $ describe FORWARDING-RULE --region us-central1\n'}},
                                                                                                       u'list': {u'capsule': u'*(ALPHA)* List Google Compute Engine forwarding rules.',
                                                                                                                 u'commands': {},
                                                                                                                 u'flags': {u'--filter': {u'attr': {},
                                                                                                                                          u'category': u'LIST COMMAND',
                                                                                                                                          u'choices': [],
                                                                                                                                          u'completer': u'',
                                                                                                                                          u'default': None,
                                                                                                                                          u'description': u'Apply a Boolean filter _EXPRESSION_ to each resource item to be listed.\nIf the expression evaluates True then that item is listed. For more\ndetails and examples of filter expressions run $ gcloud topic filters. This\nflag interacts with other flags that are applied in this order: *--flatten*,\n*--sort-by*, *--filter*, *--limit*.',
                                                                                                                                          u'group': u'',
                                                                                                                                          u'hidden': False,
                                                                                                                                          u'name': u'--filter',
                                                                                                                                          u'nargs': u'0',
                                                                                                                                          u'required': False,
                                                                                                                                          u'type': u'string',
                                                                                                                                          u'value': u'EXPRESSION'},
                                                                                                                            u'--global': {u'attr': {},
                                                                                                                                          u'category': u'',
                                                                                                                                          u'choices': [],
                                                                                                                                          u'completer': u'',
                                                                                                                                          u'default': False,
                                                                                                                                          u'description': u'If provided, only global resources are shown.',
                                                                                                                                          u'group': u'list.1',
                                                                                                                                          u'hidden': False,
                                                                                                                                          u'name': u'--global',
                                                                                                                                          u'nargs': u'0',
                                                                                                                                          u'required': False,
                                                                                                                                          u'type': u'bool',
                                                                                                                                          u'value': u'GLOBAL'},
                                                                                                                            u'--limit': {u'attr': {},
                                                                                                                                         u'category': u'LIST COMMAND',
                                                                                                                                         u'choices': [],
                                                                                                                                         u'completer': u'',
                                                                                                                                         u'default': None,
                                                                                                                                         u'description': u'The maximum number of resources to list. The default is *unlimited*.\nThis flag interacts with other flags that are applied in this order:\n*--flatten*, *--sort-by*, *--filter*, *--limit*.',
                                                                                                                                         u'group': u'',
                                                                                                                                         u'hidden': False,
                                                                                                                                         u'name': u'--limit',
                                                                                                                                         u'nargs': u'0',
                                                                                                                                         u'required': False,
                                                                                                                                         u'type': u'string',
                                                                                                                                         u'value': u'LIMIT'},
                                                                                                                            u'--no-uri': {u'attr': {},
                                                                                                                                          u'category': u'LIST COMMAND',
                                                                                                                                          u'choices': [],
                                                                                                                                          u'completer': u'',
                                                                                                                                          u'default': True,
                                                                                                                                          u'description': u'',
                                                                                                                                          u'group': u'',
                                                                                                                                          u'hidden': True,
                                                                                                                                          u'name': u'--no-uri',
                                                                                                                                          u'nargs': u'0',
                                                                                                                                          u'required': False,
                                                                                                                                          u'type': u'bool',
                                                                                                                                          u'value': u'NO_URI'},
                                                                                                                            u'--page-size': {u'attr': {},
                                                                                                                                             u'category': u'LIST COMMAND',
                                                                                                                                             u'choices': [],
                                                                                                                                             u'completer': u'',
                                                                                                                                             u'default': None,
                                                                                                                                             u'description': u'Some services group resource list output into pages. This flag specifies\nthe maximum number of resources per page. The default is determined by the\nservice if it supports paging, otherwise it is *unlimited* (no paging).\nPaging may be applied before or after *--filter* and *--limit* depending\non the service.',
                                                                                                                                             u'group': u'',
                                                                                                                                             u'hidden': False,
                                                                                                                                             u'name': u'--page-size',
                                                                                                                                             u'nargs': u'0',
                                                                                                                                             u'required': False,
                                                                                                                                             u'type': u'string',
                                                                                                                                             u'value': u'PAGE_SIZE'},
                                                                                                                            u'--regexp': {u'attr': {},
                                                                                                                                          u'category': u'',
                                                                                                                                          u'choices': [],
                                                                                                                                          u'completer': u'',
                                                                                                                                          u'default': None,
                                                                                                                                          u'description': u'A regular expression to filter the names of the results on. Any names\nthat do not match the entire regular expression will be filtered out.',
                                                                                                                                          u'group': u'',
                                                                                                                                          u'hidden': False,
                                                                                                                                          u'name': u'--regexp',
                                                                                                                                          u'nargs': u'0',
                                                                                                                                          u'required': False,
                                                                                                                                          u'type': u'string',
                                                                                                                                          u'value': u'REGEXP'},
                                                                                                                            u'--regions': {u'attr': {},
                                                                                                                                           u'category': u'',
                                                                                                                                           u'choices': [],
                                                                                                                                           u'completer': u'',
                                                                                                                                           u'default': None,
                                                                                                                                           u'description': u'If provided, only regional resources are shown. If arguments are provided, only resources from the given regions are shown.',
                                                                                                                                           u'group': u'list.1',
                                                                                                                                           u'hidden': False,
                                                                                                                                           u'name': u'--regions',
                                                                                                                                           u'nargs': u'0',
                                                                                                                                           u'required': False,
                                                                                                                                           u'type': u'list',
                                                                                                                                           u'value': u'REGION'},
                                                                                                                            u'--sort-by': {u'attr': {},
                                                                                                                                           u'category': u'LIST COMMAND',
                                                                                                                                           u'choices': [],
                                                                                                                                           u'completer': u'',
                                                                                                                                           u'default': None,
                                                                                                                                           u'description': u"A comma-separated list of resource field key names to sort by. The\ndefault order is ascending. Prefix a field with ``~'' for descending\norder on that field. This flag interacts with other flags that are applied\nin this order: *--flatten*, *--sort-by*, *--filter*, *--limit*.",
                                                                                                                                           u'group': u'',
                                                                                                                                           u'hidden': False,
                                                                                                                                           u'name': u'--sort-by',
                                                                                                                                           u'nargs': u'0',
                                                                                                                                           u'required': False,
                                                                                                                                           u'type': u'list',
                                                                                                                                           u'value': u'FIELD'},
                                                                                                                            u'--uri': {u'attr': {},
                                                                                                                                       u'category': u'LIST COMMAND',
                                                                                                                                       u'choices': [],
                                                                                                                                       u'completer': u'',
                                                                                                                                       u'default': False,
                                                                                                                                       u'description': u'Print a list of resource URIs instead of the default output.',
                                                                                                                                       u'group': u'',
                                                                                                                                       u'hidden': False,
                                                                                                                                       u'name': u'--uri',
                                                                                                                                       u'nargs': u'0',
                                                                                                                                       u'required': False,
                                                                                                                                       u'type': u'bool',
                                                                                                                                       u'value': u'URI'}},
                                                                                                                 u'group': False,
                                                                                                                 u'groups': {u'list.1': {u'description': u'At most one of these may be specified:',
                                                                                                                                         u'is_mutex': True,
                                                                                                                                         u'is_required': False}},
                                                                                                                 u'hidden': False,
                                                                                                                 u'name': u'list',
                                                                                                                 u'path': [u'gcloud',
                                                                                                                           u'alpha',
                                                                                                                           u'compute',
                                                                                                                           u'forwarding-rules',
                                                                                                                           u'list'],
                                                                                                                 u'positionals': [{u'completer': u'',
                                                                                                                                   u'default': [],
                                                                                                                                   u'description': u'If provided, show details for the specified names and/or URIs of resources.',
                                                                                                                                   u'name': u'names',
                                                                                                                                   u'nargs': u'*',
                                                                                                                                   u'required': False,
                                                                                                                                   u'value': u'NAME'}],
                                                                                                                 u'release': u'ALPHA',
                                                                                                                 u'sections': {u'DESCRIPTION': u"*list* displays all Google Compute Engine forwarding rules in a project.\n\nBy default, global forwarding rules and forwarding rules from all regions are listed. The results can be narrowed down by\nproviding the ``--global'' or ``--regions'' flag.\n",
                                                                                                                               u'EXAMPLES': u"To list all forwarding rules in a project in table form, run:\n\n  $ list\n\nTo list the URIs of all forwarding rules in a project, run:\n\n  $ list --uri\n\nTo list all global forwarding rules in a project, run:\n\n  $ list --global\n\nTo list all forwarding rules in the ``us-central1'' and ``europe-west1'' regions,\nrun:\n\n  $ list --regions us-central1,europe-west1\n"}},
                                                                                                       u'set-target': {u'capsule': u'*(ALPHA)* Modify a forwarding rule to direct network traffic to a new target.',
                                                                                                                       u'commands': {},
                                                                                                                       u'flags': {u'--backend-service': {u'attr': {},
                                                                                                                                                         u'category': u'',
                                                                                                                                                         u'choices': [],
                                                                                                                                                         u'completer': u'',
                                                                                                                                                         u'default': None,
                                                                                                                                                         u'description': u'The target backend service that will receive the traffic.',
                                                                                                                                                         u'group': u'set-target.1',
                                                                                                                                                         u'hidden': False,
                                                                                                                                                         u'name': u'--backend-service',
                                                                                                                                                         u'nargs': u'0',
                                                                                                                                                         u'required': False,
                                                                                                                                                         u'type': u'string',
                                                                                                                                                         u'value': u'BACKEND_SERVICE'},
                                                                                                                                  u'--backend-service-region': {u'attr': {u'property': {u'name': u'compute/region'}},
                                                                                                                                                                u'category': u'',
                                                                                                                                                                u'choices': [],
                                                                                                                                                                u'completer': u'',
                                                                                                                                                                u'default': None,
                                                                                                                                                                u'description': u'The region of the backend service to operate on. If not specified it will be set the region of the forwarding rule. Overrides the default *compute/region* property value for this command invocation.',
                                                                                                                                                                u'group': u'set-target.2',
                                                                                                                                                                u'hidden': False,
                                                                                                                                                                u'name': u'--backend-service-region',
                                                                                                                                                                u'nargs': u'0',
                                                                                                                                                                u'required': False,
                                                                                                                                                                u'type': u'string',
                                                                                                                                                                u'value': u'BACKEND_SERVICE_REGION'},
                                                                                                                                  u'--global': {u'attr': {},
                                                                                                                                                u'category': u'',
                                                                                                                                                u'choices': [],
                                                                                                                                                u'completer': u'',
                                                                                                                                                u'default': False,
                                                                                                                                                u'description': u'If provided, it is assumed the forwarding rule is global.',
                                                                                                                                                u'group': u'set-target.3',
                                                                                                                                                u'hidden': False,
                                                                                                                                                u'name': u'--global',
                                                                                                                                                u'nargs': u'0',
                                                                                                                                                u'required': False,
                                                                                                                                                u'type': u'bool',
                                                                                                                                                u'value': u'GLOBAL'},
                                                                                                                                  u'--global-backend-service': {u'attr': {},
                                                                                                                                                                u'category': u'',
                                                                                                                                                                u'choices': [],
                                                                                                                                                                u'completer': u'',
                                                                                                                                                                u'default': False,
                                                                                                                                                                u'description': u'If provided, it is assumed the backend service is global.',
                                                                                                                                                                u'group': u'set-target.2',
                                                                                                                                                                u'hidden': False,
                                                                                                                                                                u'name': u'--global-backend-service',
                                                                                                                                                                u'nargs': u'0',
                                                                                                                                                                u'required': False,
                                                                                                                                                                u'type': u'bool',
                                                                                                                                                                u'value': u'GLOBAL_BACKEND_SERVICE'},
                                                                                                                                  u'--load-balancing-scheme': {u'attr': {},
                                                                                                                                                               u'category': u'',
                                                                                                                                                               u'choices': [u'EXTERNAL',
                                                                                                                                                                            u'INTERNAL'],
                                                                                                                                                               u'completer': u'',
                                                                                                                                                               u'default': u'EXTERNAL',
                                                                                                                                                               u'description': u'This signifies what the forwarding rule will be used for. _LOAD_BALANCING_SCHEME_ must be one of:\n+\n*EXTERNAL*::: Used for HTTP or HTTPS for External Load Balancing.\n*INTERNAL*::: Used for Internal Network Load Balancing.\n+',
                                                                                                                                                               u'group': u'',
                                                                                                                                                               u'hidden': False,
                                                                                                                                                               u'name': u'--load-balancing-scheme',
                                                                                                                                                               u'nargs': u'0',
                                                                                                                                                               u'required': False,
                                                                                                                                                               u'type': u'string',
                                                                                                                                                               u'value': u'LOAD_BALANCING_SCHEME'},
                                                                                                                                  u'--network': {u'attr': {},
                                                                                                                                                 u'category': u'',
                                                                                                                                                 u'choices': [],
                                                                                                                                                 u'completer': u'',
                                                                                                                                                 u'default': None,
                                                                                                                                                 u'description': u'(Only for Internal Load Balancing) The network that this forwarding\nrule applies to. If this field is not specified, the default network\nwill be used. In the absence of the default network, this field must\nbe specified.',
                                                                                                                                                 u'group': u'',
                                                                                                                                                 u'hidden': False,
                                                                                                                                                 u'name': u'--network',
                                                                                                                                                 u'nargs': u'0',
                                                                                                                                                 u'required': False,
                                                                                                                                                 u'type': u'string',
                                                                                                                                                 u'value': u'NETWORK'},
                                                                                                                                  u'--region': {u'attr': {u'property': {u'name': u'compute/region'}},
                                                                                                                                                u'category': u'',
                                                                                                                                                u'choices': [],
                                                                                                                                                u'completer': u'',
                                                                                                                                                u'default': None,
                                                                                                                                                u'description': u"The region of the forwarding rule to operate on. If not specified, you will be prompted to select a region.\n+\nTo avoid prompting when this flag is omitted, you can set the\n``compute/region'' property:\n+\n  $ gcloud config set compute/region REGION\n+\nA list of regions can be fetched by running:\n+\n  $ gcloud compute regions list\n+\nTo unset the property, run:\n+\n  $ gcloud config unset compute/region\n+\nAlternatively, the region can be stored in the environment\nvariable ``CLOUDSDK_COMPUTE_REGION''.",
                                                                                                                                                u'group': u'set-target.3',
                                                                                                                                                u'hidden': False,
                                                                                                                                                u'name': u'--region',
                                                                                                                                                u'nargs': u'0',
                                                                                                                                                u'required': False,
                                                                                                                                                u'type': u'string',
                                                                                                                                                u'value': u'REGION'},
                                                                                                                                  u'--subnet': {u'attr': {},
                                                                                                                                                u'category': u'',
                                                                                                                                                u'choices': [],
                                                                                                                                                u'completer': u'',
                                                                                                                                                u'default': None,
                                                                                                                                                u'description': u'(Only for Internal Load Balancing) The subnetwork that this forwarding\nrule applies to. If the network configured for this forwarding rule is\nin auto subnet mode, the subnetwork is optional. However, if the\nnetwork is in custom subnet mode, a subnetwork must be specified.',
                                                                                                                                                u'group': u'',
                                                                                                                                                u'hidden': False,
                                                                                                                                                u'name': u'--subnet',
                                                                                                                                                u'nargs': u'0',
                                                                                                                                                u'required': False,
                                                                                                                                                u'type': u'string',
                                                                                                                                                u'value': u'SUBNET'},
                                                                                                                                  u'--subnet-region': {u'attr': {u'property': {u'name': u'compute/region'}},
                                                                                                                                                       u'category': u'',
                                                                                                                                                       u'choices': [],
                                                                                                                                                       u'completer': u'',
                                                                                                                                                       u'default': None,
                                                                                                                                                       u'description': u'The region of the subnetwork to operate on. If not specified it will be set the region of the forwarding rule. Overrides the default *compute/region* property value for this command invocation.',
                                                                                                                                                       u'group': u'',
                                                                                                                                                       u'hidden': False,
                                                                                                                                                       u'name': u'--subnet-region',
                                                                                                                                                       u'nargs': u'0',
                                                                                                                                                       u'required': False,
                                                                                                                                                       u'type': u'string',
                                                                                                                                                       u'value': u'SUBNET_REGION'},
                                                                                                                                  u'--target-http-proxy': {u'attr': {},
                                                                                                                                                           u'category': u'',
                                                                                                                                                           u'choices': [],
                                                                                                                                                           u'completer': u'',
                                                                                                                                                           u'default': None,
                                                                                                                                                           u'description': u'The target HTTP proxy that will receive the traffic.',
                                                                                                                                                           u'group': u'set-target.1',
                                                                                                                                                           u'hidden': False,
                                                                                                                                                           u'name': u'--target-http-proxy',
                                                                                                                                                           u'nargs': u'0',
                                                                                                                                                           u'required': False,
                                                                                                                                                           u'type': u'string',
                                                                                                                                                           u'value': u'TARGET_HTTP_PROXY'},
                                                                                                                                  u'--target-https-proxy': {u'attr': {},
                                                                                                                                                            u'category': u'',
                                                                                                                                                            u'choices': [],
                                                                                                                                                            u'completer': u'',
                                                                                                                                                            u'default': None,
                                                                                                                                                            u'description': u'The target HTTPS proxy that will receive the traffic.',
                                                                                                                                                            u'group': u'set-target.1',
                                                                                                                                                            u'hidden': False,
                                                                                                                                                            u'name': u'--target-https-proxy',
                                                                                                                                                            u'nargs': u'0',
                                                                                                                                                            u'required': False,
                                                                                                                                                            u'type': u'string',
                                                                                                                                                            u'value': u'TARGET_HTTPS_PROXY'},
                                                                                                                                  u'--target-instance': {u'attr': {},
                                                                                                                                                         u'category': u'',
                                                                                                                                                         u'choices': [],
                                                                                                                                                         u'completer': u'',
                                                                                                                                                         u'default': None,
                                                                                                                                                         u'description': u"The name of the target instance that will receive the traffic. The\ntarget instance must be in a zone that's in the forwarding rule's\nregion. Global forwarding rules may not direct traffic to target\ninstances.\nIf not specified, you will be prompted to select a zone.\n+\nTo avoid prompting when this flag is omitted, you can set the\n``compute/zone'' property:\n+\n  $ gcloud config set compute/zone ZONE\n+\nA list of zones can be fetched by running:\n+\n  $ gcloud compute zones list\n+\nTo unset the property, run:\n+\n  $ gcloud config unset compute/zone\n+\nAlternatively, the zone can be stored in the environment variable\n``CLOUDSDK_COMPUTE_ZONE''.",
                                                                                                                                                         u'group': u'set-target.1',
                                                                                                                                                         u'hidden': False,
                                                                                                                                                         u'name': u'--target-instance',
                                                                                                                                                         u'nargs': u'0',
                                                                                                                                                         u'required': False,
                                                                                                                                                         u'type': u'string',
                                                                                                                                                         u'value': u'TARGET_INSTANCE'},
                                                                                                                                  u'--target-instance-zone': {u'attr': {u'property': {u'name': u'compute/zone'}},
                                                                                                                                                              u'category': u'',
                                                                                                                                                              u'choices': [],
                                                                                                                                                              u'completer': u'',
                                                                                                                                                              u'default': None,
                                                                                                                                                              u'description': u'The zone of the target instance to operate on. Overrides the default *compute/zone* property value for this command invocation.',
                                                                                                                                                              u'group': u'',
                                                                                                                                                              u'hidden': False,
                                                                                                                                                              u'name': u'--target-instance-zone',
                                                                                                                                                              u'nargs': u'0',
                                                                                                                                                              u'required': False,
                                                                                                                                                              u'type': u'string',
                                                                                                                                                              u'value': u'TARGET_INSTANCE_ZONE'},
                                                                                                                                  u'--target-pool': {u'attr': {},
                                                                                                                                                     u'category': u'',
                                                                                                                                                     u'choices': [],
                                                                                                                                                     u'completer': u'',
                                                                                                                                                     u'default': None,
                                                                                                                                                     u'description': u'The target pool that will receive the traffic. The target pool\nmust be in the same region as the forwarding rule. Global\nforwarding rules may not direct traffic to target pools.',
                                                                                                                                                     u'group': u'set-target.1',
                                                                                                                                                     u'hidden': False,
                                                                                                                                                     u'name': u'--target-pool',
                                                                                                                                                     u'nargs': u'0',
                                                                                                                                                     u'required': False,
                                                                                                                                                     u'type': u'string',
                                                                                                                                                     u'value': u'TARGET_POOL'},
                                                                                                                                  u'--target-pool-region': {u'attr': {u'property': {u'name': u'compute/region'}},
                                                                                                                                                            u'category': u'',
                                                                                                                                                            u'choices': [],
                                                                                                                                                            u'completer': u'',
                                                                                                                                                            u'default': None,
                                                                                                                                                            u'description': u'The region of the target pool to operate on. If not specified it will be set the region of the forwarding rule. Overrides the default *compute/region* property value for this command invocation.',
                                                                                                                                                            u'group': u'',
                                                                                                                                                            u'hidden': False,
                                                                                                                                                            u'name': u'--target-pool-region',
                                                                                                                                                            u'nargs': u'0',
                                                                                                                                                            u'required': False,
                                                                                                                                                            u'type': u'string',
                                                                                                                                                            u'value': u'TARGET_POOL_REGION'},
                                                                                                                                  u'--target-ssl-proxy': {u'attr': {},
                                                                                                                                                          u'category': u'',
                                                                                                                                                          u'choices': [],
                                                                                                                                                          u'completer': u'',
                                                                                                                                                          u'default': None,
                                                                                                                                                          u'description': u'The target SSL proxy that will receive the traffic.',
                                                                                                                                                          u'group': u'set-target.1',
                                                                                                                                                          u'hidden': False,
                                                                                                                                                          u'name': u'--target-ssl-proxy',
                                                                                                                                                          u'nargs': u'0',
                                                                                                                                                          u'required': False,
                                                                                                                                                          u'type': u'string',
                                                                                                                                                          u'value': u'TARGET_SSL_PROXY'},
                                                                                                                                  u'--target-tcp-proxy': {u'attr': {},
                                                                                                                                                          u'category': u'',
                                                                                                                                                          u'choices': [],
                                                                                                                                                          u'completer': u'',
                                                                                                                                                          u'default': None,
                                                                                                                                                          u'description': u'The target TCP proxy that will receive the traffic.',
                                                                                                                                                          u'group': u'set-target.1',
                                                                                                                                                          u'hidden': False,
                                                                                                                                                          u'name': u'--target-tcp-proxy',
                                                                                                                                                          u'nargs': u'0',
                                                                                                                                                          u'required': False,
                                                                                                                                                          u'type': u'string',
                                                                                                                                                          u'value': u'TARGET_TCP_PROXY'},
                                                                                                                                  u'--target-vpn-gateway': {u'attr': {},
                                                                                                                                                            u'category': u'',
                                                                                                                                                            u'choices': [],
                                                                                                                                                            u'completer': u'',
                                                                                                                                                            u'default': None,
                                                                                                                                                            u'description': u'The target VPN gateway that will receive forwarded traffic.',
                                                                                                                                                            u'group': u'set-target.1',
                                                                                                                                                            u'hidden': False,
                                                                                                                                                            u'name': u'--target-vpn-gateway',
                                                                                                                                                            u'nargs': u'0',
                                                                                                                                                            u'required': False,
                                                                                                                                                            u'type': u'string',
                                                                                                                                                            u'value': u'TARGET_VPN_GATEWAY'},
                                                                                                                                  u'--target-vpn-gateway-region': {u'attr': {u'property': {u'name': u'compute/region'}},
                                                                                                                                                                   u'category': u'',
                                                                                                                                                                   u'choices': [],
                                                                                                                                                                   u'completer': u'',
                                                                                                                                                                   u'default': None,
                                                                                                                                                                   u'description': u'The region of the VPN gateway to operate on. If not specified it will be set the region of the forwarding rule. Overrides the default *compute/region* property value for this command invocation.',
                                                                                                                                                                   u'group': u'',
                                                                                                                                                                   u'hidden': False,
                                                                                                                                                                   u'name': u'--target-vpn-gateway-region',
                                                                                                                                                                   u'nargs': u'0',
                                                                                                                                                                   u'required': False,
                                                                                                                                                                   u'type': u'string',
                                                                                                                                                                   u'value': u'TARGET_VPN_GATEWAY_REGION'}},
                                                                                                                       u'group': False,
                                                                                                                       u'groups': {u'set-target.1': {u'description': u'Exactly one of these must be specified:',
                                                                                                                                                     u'is_mutex': True,
                                                                                                                                                     u'is_required': True},
                                                                                                                                   u'set-target.2': {u'description': u'At most one of these may be specified:',
                                                                                                                                                     u'is_mutex': True,
                                                                                                                                                     u'is_required': False},
                                                                                                                                   u'set-target.3': {u'description': u'At most one of these may be specified:',
                                                                                                                                                     u'is_mutex': True,
                                                                                                                                                     u'is_required': False}},
                                                                                                                       u'hidden': False,
                                                                                                                       u'name': u'set-target',
                                                                                                                       u'path': [u'gcloud',
                                                                                                                                 u'alpha',
                                                                                                                                 u'compute',
                                                                                                                                 u'forwarding-rules',
                                                                                                                                 u'set-target'],
                                                                                                                       u'positionals': [{u'completer': u'',
                                                                                                                                         u'default': None,
                                                                                                                                         u'description': u'The name of the forwarding rule.',
                                                                                                                                         u'name': u'name',
                                                                                                                                         u'nargs': u'0',
                                                                                                                                         u'required': False,
                                                                                                                                         u'value': u'NAME'}],
                                                                                                                       u'release': u'ALPHA',
                                                                                                                       u'sections': {u'DESCRIPTION': u"*set-target* is used to set a new target for a forwarding\nrule.         Forwarding rules match and direct certain types of traffic to a load\nbalancer which is controlled by a target pool, a target instance,\nor a target HTTP proxy. Target pools and target instances perform load\nbalancing at the layer 3 of the OSI networking model\n(http://en.wikipedia.org/wiki/Network_layer). Target\nHTTP proxies perform load balancing at layer 7.\n\nForwarding rules can be either regional or global. They are\nregional if they point to a target pool or a target instance\nand global if they point to a target HTTP proxy.\n\nFor more information on load balancing, see\nhttps://cloud.google.com/compute/docs/load-balancing-and-autoscaling/.\n\n\nWhen creating a forwarding rule, exactly one of  ``--target-instance'',\n``--target-pool'', ``--target-http-proxy'', ``--target-https-proxy'',\n``--target-ssl-proxy'', ``--target-tcp-proxy'' or\n``--target-vpn-gateway'' must be specified."}}},
                                                                                         u'flags': {},
                                                                                         u'group': True,
                                                                                         u'groups': {},
                                                                                         u'hidden': False,
                                                                                         u'name': u'forwarding-rules',
                                                                                         u'path': [u'gcloud',
                                                                                                   u'alpha',
                                                                                                   u'compute',
                                                                                                   u'forwarding-rules'],
                                                                                         u'positionals': [],
                                                                                         u'release': u'ALPHA',
                                                                                         u'sections': {u'DESCRIPTION': u'*(ALPHA)* Read and manipulate forwarding rules to send traffic to load balancers.'}},
                                                                   u'groups': {u'capsule': u'*(ALPHA)* Read and manipulate Google Compute Engine groups.',
                                                                               u'commands': {u'add-members': {u'capsule': u'*(ALPHA)* Add a user to a Google Compute Engine group.',
                                                                                                              u'commands': {},
                                                                                                              u'flags': {u'--members': {u'attr': {},
                                                                                                                                        u'category': u'',
                                                                                                                                        u'choices': [],
                                                                                                                                        u'completer': u'',
                                                                                                                                        u'default': None,
                                                                                                                                        u'description': u'The names or fully-qualified URLs of the users to add.',
                                                                                                                                        u'group': u'',
                                                                                                                                        u'hidden': False,
                                                                                                                                        u'name': u'--members',
                                                                                                                                        u'nargs': u'0',
                                                                                                                                        u'required': True,
                                                                                                                                        u'type': u'list',
                                                                                                                                        u'value': u'USERNAME'}},
                                                                                                              u'group': False,
                                                                                                              u'groups': {},
                                                                                                              u'hidden': False,
                                                                                                              u'name': u'add-members',
                                                                                                              u'path': [u'gcloud',
                                                                                                                        u'alpha',
                                                                                                                        u'compute',
                                                                                                                        u'groups',
                                                                                                                        u'add-members'],
                                                                                                              u'positionals': [{u'completer': u'',
                                                                                                                                u'default': None,
                                                                                                                                u'description': u'The names of the groups to add members to.',
                                                                                                                                u'name': u'names',
                                                                                                                                u'nargs': u'+',
                                                                                                                                u'required': False,
                                                                                                                                u'value': u'NAME'}],
                                                                                                              u'release': u'ALPHA',
                                                                                                              u'sections': {u'DESCRIPTION': u'*(ALPHA)* *add-members* adds a users to a Google Compute Engine group.',
                                                                                                                            u'EXAMPLES': u'To add a user to a group, run:\n\n  $ add-members example-group --members example-user\n\nTo add multiple users to multiple groups, run:\n\n  $ add-members example-group-1 example-group-2 --members example-user-1,example-user-2\n'}},
                                                                                             u'create': {u'capsule': u'*(ALPHA)* Create Google Compute Engine groups.',
                                                                                                         u'commands': {},
                                                                                                         u'flags': {u'--description': {u'attr': {},
                                                                                                                                       u'category': u'',
                                                                                                                                       u'choices': [],
                                                                                                                                       u'completer': u'',
                                                                                                                                       u'default': None,
                                                                                                                                       u'description': u'An optional, textual description for the group being created.',
                                                                                                                                       u'group': u'',
                                                                                                                                       u'hidden': False,
                                                                                                                                       u'name': u'--description',
                                                                                                                                       u'nargs': u'0',
                                                                                                                                       u'required': False,
                                                                                                                                       u'type': u'string',
                                                                                                                                       u'value': u'DESCRIPTION'}},
                                                                                                         u'group': False,
                                                                                                         u'groups': {},
                                                                                                         u'hidden': False,
                                                                                                         u'name': u'create',
                                                                                                         u'path': [u'gcloud',
                                                                                                                   u'alpha',
                                                                                                                   u'compute',
                                                                                                                   u'groups',
                                                                                                                   u'create'],
                                                                                                         u'positionals': [{u'completer': u'',
                                                                                                                           u'default': None,
                                                                                                                           u'description': u'The name of the group to create.',
                                                                                                                           u'name': u'names',
                                                                                                                           u'nargs': u'+',
                                                                                                                           u'required': False,
                                                                                                                           u'value': u'NAME'}],
                                                                                                         u'release': u'ALPHA',
                                                                                                         u'sections': {u'DESCRIPTION': u'*create* creates Google Compute Engine groups.\n',
                                                                                                                       u'EXAMPLES': u'To create a group, run:\n\n  $ create example-group\n'}},
                                                                                             u'delete': {u'capsule': u'*(ALPHA)* Delete Google Compute Engine groups.',
                                                                                                         u'commands': {},
                                                                                                         u'flags': {},
                                                                                                         u'group': False,
                                                                                                         u'groups': {},
                                                                                                         u'hidden': False,
                                                                                                         u'name': u'delete',
                                                                                                         u'path': [u'gcloud',
                                                                                                                   u'alpha',
                                                                                                                   u'compute',
                                                                                                                   u'groups',
                                                                                                                   u'delete'],
                                                                                                         u'positionals': [{u'completer': u'',
                                                                                                                           u'default': None,
                                                                                                                           u'description': u'The names of the groups to delete.',
                                                                                                                           u'name': u'names',
                                                                                                                           u'nargs': u'+',
                                                                                                                           u'required': False,
                                                                                                                           u'value': u'NAME'}],
                                                                                                         u'release': u'ALPHA',
                                                                                                         u'sections': {u'DESCRIPTION': u'*delete* deletes one or more Google Compute Engine groups.\n',
                                                                                                                       u'EXAMPLES': u'To delete a group, run:\n\n  $ delete example-group\n\nTo delete multiple groups, run:\n\n  $ delete example-group-1 example-group-2\n'}},
                                       