"""Generated message classes for bigtableadmin version v2.

"""
# NOTE: This file is autogenerated and should not be edited by hand.

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'bigtableadmin'


class BigtableadminOperationsCancelRequest(_messages.Message):
  """A BigtableadminOperationsCancelRequest object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class BigtableadminOperationsDeleteRequest(_messages.Message):
  """A BigtableadminOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class BigtableadminOperationsGetRequest(_messages.Message):
  """A BigtableadminOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class BigtableadminOperationsListRequest(_messages.Message):
  """A BigtableadminOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation collection.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class BigtableadminProjectsInstancesClustersCreateRequest(_messages.Message):
  """A BigtableadminProjectsInstancesClustersCreateRequest object.

  Fields:
    cluster: A Cluster resource to be passed as the request body.
    clusterId: The ID to be used when referring to the new cluster within its
      instance, e.g., just `mycluster` rather than
      `projects/myproject/instances/myinstance/clusters/mycluster`.
    parent: The unique name of the instance in which to create the new
      cluster. Values are of the form
      `projects/<project>/instances/<instance>`.
  """

  cluster = _messages.MessageField('Cluster', 1)
  clusterId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class BigtableadminProjectsInstancesClustersDeleteRequest(_messages.Message):
  """A BigtableadminProjectsInstancesClustersDeleteRequest object.

  Fields:
    name: The unique name of the cluster to be deleted. Values are of the form
      `projects/<project>/instances/<instance>/clusters/<cluster>`.
  """

  name = _messages.StringField(1, required=True)


class BigtableadminProjectsInstancesClustersGetRequest(_messages.Message):
  """A BigtableadminProjectsInstancesClustersGetRequest object.

  Fields:
    name: The unique name of the requested cluster. Values are of the form
      `projects/<project>/instances/<instance>/clusters/<cluster>`.
  """

  name = _messages.StringField(1, required=True)


class BigtableadminProjectsInstancesClustersListRequest(_messages.Message):
  """A BigtableadminProjectsInstancesClustersListRequest object.

  Fields:
    pageToken: The value of `next_page_token` returned by a previous call.
    parent: The unique name of the instance for which a list of clusters is
      requested. Values are of the form
      `projects/<project>/instances/<instance>`. Use `<instance> = '-'` to
      list Clusters for all Instances in a project, e.g.,
      `projects/myproject/instances/-`.
  """

  pageToken = _messages.StringField(1)
  parent = _messages.StringField(2, required=True)


class BigtableadminProjectsInstancesDeleteRequest(_messages.Message):
  """A BigtableadminProjectsInstancesDeleteRequest object.

  Fields:
    name: The unique name of the instance to be deleted. Values are of the
      form `projects/<project>/instances/<instance>`.
  """

  name = _messages.StringField(1, required=True)


class BigtableadminProjectsInstancesGetRequest(_messages.Message):
  """A BigtableadminProjectsInstancesGetRequest object.

  Fields:
    name: The unique name of the requested instance. Values are of the form
      `projects/<project>/instances/<instance>`.
  """

  name = _messages.StringField(1, required=True)


class BigtableadminProjectsInstancesListRequest(_messages.Message):
  """A BigtableadminProjectsInstancesListRequest object.

  Fields:
    pageToken: The value of `next_page_token` returned by a previous call.
    parent: The unique name of the project for which a list of instances is
      requested. Values are of the form `projects/<project>`.
  """

  pageToken = _messages.StringField(1)
  parent = _messages.StringField(2, required=True)


class BigtableadminProjectsInstancesTablesCreateRequest(_messages.Message):
  """A BigtableadminProjectsInstancesTablesCreateRequest object.

  Fields:
    createTableRequest: A CreateTableRequest resource to be passed as the
      request body.
    parent: The unique name of the instance in which to create the table.
      Values are of the form `projects/<project>/instances/<instance>`.
  """

  createTableRequest = _messages.MessageField('CreateTableRequest', 1)
  parent = _messages.StringField(2, required=True)


class BigtableadminProjectsInstancesTablesDeleteRequest(_messages.Message):
  """A BigtableadminProjectsInstancesTablesDeleteRequest object.

  Fields:
    name: The unique name of the table to be deleted. Values are of the form
      `projects/<project>/instances/<instance>/tables/<table>`.
  """

  name = _messages.StringField(1, required=True)


class BigtableadminProjectsInstancesTablesDropRowRangeRequest(_messages.Message):
  """A BigtableadminProjectsInstancesTablesDropRowRangeRequest object.

  Fields:
    dropRowRangeRequest: A DropRowRangeRequest resource to be passed as the
      request body.
    name: The unique name of the table on which to drop a range of rows.
      Values are of the form
      `projects/<project>/instances/<instance>/tables/<table>`.
  """

  dropRowRangeRequest = _messages.MessageField('DropRowRangeRequest', 1)
  name = _messages.StringField(2, required=True)


class BigtableadminProjectsInstancesTablesGetRequest(_messages.Message):
  """A BigtableadminProjectsInstancesTablesGetRequest object.

  Enums:
    ViewValueValuesEnum: The view to be applied to the returned table's
      fields. Defaults to `SCHEMA_ONLY` if unspecified.

  Fields:
    name: The unique name of the requested table. Values are of the form
      `projects/<project>/instances/<instance>/tables/<table>`.
    view: The view to be applied to the returned table's fields. Defaults to
      `SCHEMA_ONLY` if unspecified.
  """

  class ViewValueValuesEnum(_messages.Enum):
    """The view to be applied to the returned table's fields. Defaults to
    `SCHEMA_ONLY` if unspecified.

    Values:
      VIEW_UNSPECIFIED: <no description>
      NAME_ONLY: <no description>
      SCHEMA_VIEW: <no description>
      FULL: <no description>
    """
    VIEW_UNSPECIFIED = 0
    NAME_ONLY = 1
    SCHEMA_VIEW = 2
    FULL = 3

  name = _messages.StringField(1, required=True)
  view = _messages.EnumField('ViewValueValuesEnum', 2)


class BigtableadminProjectsInstancesTablesListRequest(_messages.Message):
  """A BigtableadminProjectsInstancesTablesListRequest object.

  Enums:
    ViewValueValuesEnum: The view to be applied to the returned tables'
      fields. Defaults to `NAME_ONLY` if unspecified; no others are currently
      supported.

  Fields:
    pageToken: The value of `next_page_token` returned by a previous call.
    parent: The unique name of the instance for which tables should be listed.
      Values are of the form `projects/<project>/instances/<instance>`.
    view: The view to be applied to the returned tables' fields. Defaults to
      `NAME_ONLY` if unspecified; no others are currently supported.
  """

  class ViewValueValuesEnum(_messages.Enum):
    """The view to be applied to the returned tables' fields. Defaults to
    `NAME_ONLY` if unspecified; no others are currently supported.

    Values:
      VIEW_UNSPECIFIED: <no description>
      NAME_ONLY: <no description>
      SCHEMA_VIEW: <no description>
      FULL: <no description>
    """
    VIEW_UNSPECIFIED = 0
    NAME_ONLY = 1
    SCHEMA_VIEW = 2
    FULL = 3

  pageToken = _messages.StringField(1)
  parent = _messages.StringField(2, required=True)
  view = _messages.EnumField('ViewValueValuesEnum', 3)


class BigtableadminProjectsInstancesTablesModifyColumnFamiliesRequest(_messages.Message):
  """A BigtableadminProjectsInstancesTablesModifyColumnFamiliesRequest object.

  Fields:
    modifyColumnFamiliesRequest: A ModifyColumnFamiliesRequest resource to be
      passed as the request body.
    name: The unique name of the table whose families should be modified.
      Values are of the form
      `projects/<project>/instances/<instance>/tables/<table>`.
  """

  modifyColumnFamiliesRequest = _messages.MessageField('ModifyColumnFamiliesRequest', 1)
  name = _messages.StringField(2, required=True)


class Cluster(_messages.Message):
  """A resizable group of nodes in a particular cloud location, capable of
  serving all Tables in the parent Instance.

  Enums:
    DefaultStorageTypeValueValuesEnum: (`CreationOnly`) The type of storage
      used by this cluster to serve its parent instance's tables, unless
      explicitly overridden.
    StateValueValuesEnum: (`OutputOnly`) The current state of the cluster.

  Fields:
    defaultStorageType: (`CreationOnly`) The type of storage used by this
      cluster to serve its parent instance's tables, unless explicitly
      overridden.
    location: (`CreationOnly`) The location where this cluster's nodes and
      storage reside. For best performance, clients should be located as close
      as possible to this cluster. Currently only zones are supported, so
      values should be of the form `projects/<project>/locations/<zone>`.
    name: (`OutputOnly`) The unique name of the cluster. Values are of the
      form `projects/<project>/instances/<instance>/clusters/a-z*`.
    serveNodes: The number of nodes allocated to this cluster. More nodes
      enable higher throughput and more consistent performance.
    state: (`OutputOnly`) The current state of the cluster.
  """

  class DefaultStorageTypeValueValuesEnum(_messages.Enum):
    """(`CreationOnly`) The type of storage used by this cluster to serve its
    parent instance's tables, unless explicitly overridden.

    Values:
      STORAGE_TYPE_UNSPECIFIED: The user did not specify a storage type.
      SSD: Flash (SSD) storage should be used.
      HDD: Magnetic drive (HDD) storage should be used.
    """
    STORAGE_TYPE_UNSPECIFIED = 0
    SSD = 1
    HDD = 2

  class StateValueValuesEnum(_messages.Enum):
    """(`OutputOnly`) The current state of the cluster.

    Values:
      STATE_NOT_KNOWN: The state of the cluster could not be determined.
      READY: The cluster has been successfully created and is ready to serve
        requests.
      CREATING: The cluster is currently being created, and may be destroyed
        if the creation process encounters an error. A cluster may not be able
        to serve requests while being created.
      RESIZING: The cluster is currently being resized, and may revert to its
        previous node count if the process encounters an error. A cluster is
        still capable of serving requests while being resized, but may exhibit
        performance as if its number of allocated nodes is between the
        starting and requested states.
      DISABLED: The cluster has no backing nodes. The data (tables) still
        exist, but no operations can be performed on the cluster.
    """
    STATE_NOT_KNOWN = 0
    READY = 1
    CREATING = 2
    RESIZING = 3
    DISABLED = 4

  defaultStorageType = _messages.EnumField('DefaultStorageTypeValueValuesEnum', 1)
  location = _messages.StringField(2)
  name = _messages.StringField(3)
  serveNodes = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  state = _messages.EnumField('StateValueValuesEnum', 5)


class ColumnFamily(_messages.Message):
  """A set of columns within a table which share a common configuration.

  Fields:
    gcRule: Garbage collection rule specified as a protobuf. Must serialize to
      at most 500 bytes.  NOTE: Garbage collection executes opportunistically
      in the background, and so it's possible for reads to return a cell even
      if it matches the active GC expression for its family.
  """

  gcRule = _messages.MessageField('GcRule', 1)


class CreateInstanceMetadata(_messages.Message):
  """The metadata for the Operation returned by CreateInstance.

  Fields:
    finishTime: The time at which the operation failed or was completed
      successfully.
    originalRequest: The request that prompted the initiation of this
      CreateInstance operation.
    requestTime: The time at which the original request was received.
  """

  finishTime = _messages.StringField(1)
  originalRequest = _messages.MessageField('CreateInstanceRequest', 2)
  requestTime = _messages.StringField(3)


class CreateInstanceRequest(_messages.Message):
  """Request message for BigtableInstanceAdmin.CreateInstance.

  Messages:
    ClustersValue: The clusters to be created within the instance, mapped by
      desired cluster ID, e.g., just `mycluster` rather than
      `projects/myproject/instances/myinstance/clusters/mycluster`. Fields
      marked `OutputOnly` must be left blank. Currently exactly one cluster
      must be specified.

  Fields:
    clusters: The clusters to be created within the instance, mapped by
      desired cluster ID, e.g., just `mycluster` rather than
      `projects/myproject/instances/myinstance/clusters/mycluster`. Fields
      marked `OutputOnly` must be left blank. Currently exactly one cluster
      must be specified.
    instance: The instance to create. Fields marked `OutputOnly` must be left
      blank.
    instanceId: The ID to be used when referring to the new instance within
      its project, e.g., just `myinstance` rather than
      `projects/myproject/instances/myinstance`.
    parent: The unique name of the project in which to create the new
      instance. Values are of the form `projects/<project>`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ClustersValue(_messages.Message):
    """The clusters to be created within the instance, mapped by desired
    cluster ID, e.g., just `mycluster` rather than
    `projects/myproject/instances/myinstance/clusters/mycluster`. Fields
    marked `OutputOnly` must be left blank. Currently exactly one cluster must
    be specified.

    Messages:
      AdditionalProperty: An additional property for a ClustersValue object.

    Fields:
      additionalProperties: Additional properties of type ClustersValue
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a ClustersValue object.

      Fields:
        key: Name of the additional property.
        value: A Cluster attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('Cluster', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  clusters = _messages.MessageField('ClustersValue', 1)
  instance = _messages.MessageField('Instance', 2)
  instanceId = _messages.StringField(3)
  parent = _messages.StringField(4)


class CreateTableRequest(_messages.Message):
  """Request message for
  google.bigtable.admin.v2.BigtableTableAdmin.CreateTable

  Fields:
    initialSplits: The optional list of row keys that will be used to
      initially split the table into several tablets (tablets are similar to
      HBase regions). Given two split keys, `s1` and `s2`, three tablets will
      be created, spanning the key ranges: `[, s1), [s1, s2), [s2, )`.
      Example:  * Row keys := `["a", "apple", "custom", "customer_1",
      "customer_2",`                `"other", "zz"]` * initial_split_keys :=
      `["apple", "customer_1", "customer_2", "other"]` * Key assignment:     -
      Tablet 1 `[, apple)                => {"a"}.`     - Tablet 2 `[apple,
      customer_1)      => {"apple", "custom"}.`     - Tablet 3 `[customer_1,
      customer_2) => {"customer_1"}.`     - Tablet 4 `[customer_2, other)
      => {"customer_2"}.`     - Tablet 5 `[other, )                =>
      {"other", "zz"}.`
    table: The Table to create.
    tableId: The name by which the new table should be referred to within the
      parent instance, e.g., `foobar` rather than `<parent>/tables/foobar`.
  """

  initialSplits = _messages.MessageField('Split', 1, repeated=True)
  table = _messages.MessageField('Table', 2)
  tableId = _messages.StringField(3)


class DropRowRangeRequest(_messages.Message):
  """Request message for
  google.bigtable.admin.v2.BigtableTableAdmin.DropRowRange

  Fields:
    deleteAllDataFromTable: Delete all rows in the table. Setting this to
      false is a no-op.
    rowKeyPrefix: Delete all rows that start with this row key prefix. Prefix
      cannot be zero length.
  """

  deleteAllDataFromTable = _messages.BooleanField(1)
  rowKeyPrefix = _messages.BytesField(2)


class Empty(_messages.Message):
  """A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance:      service Foo {
  rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty);     }  The
  JSON representation for `Empty` is empty JSON object `{}`.
  """



class GcRule(_messages.Message):
  """Rule for determining which cells to delete during garbage collection.

  Fields:
    intersection: Delete cells that would be deleted by every nested rule.
    maxAge: Delete cells in a column older than the given age. Values must be
      at least one millisecond, and will be truncated to microsecond
      granularity.
    maxNumVersions: Delete all cells in a column except the most recent N.
    union: Delete cells that would be deleted by any nested rule.
  """

  intersection = _messages.MessageField('Intersection', 1)
  maxAge = _messages.StringField(2)
  maxNumVersions = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  union = _messages.MessageField('Union', 4)


class Instance(_messages.Message):
  """A collection of Bigtable Tables and the resources that serve them. All
  tables in an instance are served from a single Cluster.

  Enums:
    StateValueValuesEnum: (`OutputOnly`) The current state of the instance.
    TypeValueValuesEnum: The type of the instance. Defaults to `PRODUCTION`.

  Fields:
    displayName: The descriptive name for this instance as it appears in UIs.
      Can be changed at any time, but should be kept globally unique to avoid
      confusion.
    name: (`OutputOnly`) The unique name of the instance. Values are of the
      form `projects/<project>/instances/a-z+[a-z0-9]`.
    state: (`OutputOnly`) The current state of the instance.
    type: The type of the instance. Defaults to `PRODUCTION`.
  """

  class StateValueValuesEnum(_messages.Enum):
    """(`OutputOnly`) The current state of the instance.

    Values:
      STATE_NOT_KNOWN: The state of the instance could not be determined.
      READY: The instance has been successfully created and can serve requests
        to its tables.
      CREATING: The instance is currently being created, and may be destroyed
        if the creation process encounters an error.
    """
    STATE_NOT_KNOWN = 0
    READY = 1
    CREATING = 2

  class TypeValueValuesEnum(_messages.Enum):
    """The type of the instance. Defaults to `PRODUCTION`.

    Values:
      TYPE_UNSPECIFIED: The type of the instance is unspecified. If set when
        creating an instance, a `PRODUCTION` instance will be created. If set
        when updating an instance, the type will be left unchanged.
      PRODUCTION: An instance meant for production use. `serve_nodes` must be
        set on the cluster.
      DEVELOPMENT: The instance is meant for development and testing purposes
        only; it has no performance or uptime guarantees and is not covered by
        SLA. After a development instance is created, it can be upgraded by
        updating the instance to type `PRODUCTION`. An instance created as a
        production instance cannot be changed to a development instance. When
        creating a development instance, `serve_nodes` on the cluster must not
        be set.
    """
    TYPE_UNSPECIFIED = 0
    PRODUCTION = 1
    DEVELOPMENT = 2

  displayName = _messages.StringField(1)
  name = _messages.StringField(2)
  state = _messages.EnumField('StateValueValuesEnum', 3)
  type = _messages.EnumField('TypeValueValuesEnum', 4)


class Intersection(_messages.Message):
  """A GcRule which deletes cells matching all of the given rules.

  Fields:
    rules: Only delete cells which would be deleted by every element of
      `rules`.
  """

  rules = _messages.MessageField('GcRule', 1, repeated=True)


class ListClustersResponse(_messages.Message):
  """Response message for BigtableInstanceAdmin.ListClusters.

  Fields:
    clusters: The list of requested clusters.
    failedLocations: Locations from which Cluster information could not be
      retrieved, due to an outage or some other transient condition. Clusters
      from these locations may be missing from `clusters`, or may only have
      partial information returned.
    nextPageToken: Set if not all clusters could be returned in a single
      response. Pass this value to `page_token` in another request to get the
      next page of results.
  """

  clusters = _messages.MessageField('Cluster', 1, repeated=True)
  failedLocations = _messages.StringField(2, repeated=True)
  nextPageToken = _messages.StringField(3)


class ListInstancesResponse(_messages.Message):
  """Response message for BigtableInstanceAdmin.ListInstances.

  Fields:
    failedLocations: Locations from which Instance information could not be
      retrieved, due to an outage or some other transient condition. Instances
      whose Clusters are all in one of the failed locations may be missing
      from `instances`, and Instances with at least one Cluster in a failed
      location may only have partial information returned.
    instances: The list of requested instances.
    nextPageToken: Set if not all instances could be returned in a single
      response. Pass this value to `page_token` in another request to get the
      next page of results.
  """

  failedLocations = _messages.StringField(1, repeated=True)
  instances = _messages.MessageField('Instance', 2, repeated=True)
  nextPageToken = _messages.StringField(3)


class ListOperationsResponse(_messages.Message):
  """The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)


class ListTablesResponse(_messages.Message):
  """Response message for
  google.bigtable.admin.v2.BigtableTableAdmin.ListTables

  Fields:
    nextPageToken: Set if not all tables could be returned in a single
      response. Pass this value to `page_token` in another request to get the
      next page of results.
    tables: The tables present in the requested instance.
  """

  nextPageToken = _messages.StringField(1)
  tables = _messages.MessageField('Table', 2, repeated=True)


class Modification(_messages.Message):
  """A create, update, or delete of a particular column family.

  Fields:
    create: Create a new column family with the specified schema, or fail if
      one already exists with the given ID.
    drop: Drop (delete) the column family with the given ID, or fail if no
      such family exists.
    id: The ID of the column family to be modified.
    update: Update an existing column family to the specified schema, or fail
      if no column family exists with the given ID.
  """

  create = _messages.MessageField('ColumnFamily', 1)
  drop = _messages.BooleanField(2)
  id = _messages.StringField(3)
  update = _messages.MessageField('ColumnFamily', 4)


class ModifyColumnFamiliesRequest(_messages.Message):
  """Request message for
  google.bigtable.admin.v2.BigtableTableAdmin.ModifyColumnFamilies

  Fields:
    modifications: Modifications to be atomically applied to the specified
      table's families. Entries are applied in order, meaning that earlier
      modifications can be masked by later ones (in the case of repeated
      updates to the same family, for example).
  """

  modifications = _messages.MessageField('Modification', 1, repeated=True)


class Operation(_messages.Message):
  """This resource represents a long-running operation that is the result of a
  network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation.
      It typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata.  Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal response of the operation in case of success.
      If the original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`.  If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource.  For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name.  For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If true, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation.  It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata.  Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should have the format of `operations/some/unique/name`.
    response: The normal response of the operation in case of success.  If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`.  If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource.  For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name.  For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    """Service-specific metadata associated with the operation.  It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata.  Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    """The normal response of the operation in case of success.  If the
    original method returns no data on success, such as `Delete`, the response
    is `google.protobuf.Empty`.  If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource.  For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name.  For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class Split(_messages.Message):
  """An initial split point for a newly created table.

  Fields:
    key: Row key to use as an initial tablet boundary.
  """

  key = _messages.BytesField(1)


class StandardQueryParameters(_messages.Message):
  """Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    bearer_token: OAuth bearer token.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    pp: Pretty-print response.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    """Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    """V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default=u'json')
  bearer_token = _messages.StringField(4)
  callback = _messages.StringField(5)
  fields = _messages.StringField(6)
  key = _messages.StringField(7)
  oauth_token = _messages.StringField(8)
  pp = _messages.BooleanField(9, default=True)
  prettyPrint = _messages.BooleanField(10, default=True)
  quotaUser = _messages.StringField(11)
  trace = _messages.StringField(12)
  uploadType = _messages.StringField(13)
  upload_protocol = _messages.StringField(14)


class Status(_messages.Message):
  """The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). The error model is designed to be:
  - Simple to use and understand for most users - Flexible enough to meet
  unexpected needs  # Overview  The `Status` message contains three pieces of
  data: error code, error message, and error details. The error code should be
  an enum value of google.rpc.Code, but it may accept additional error codes
  if needed.  The error message should be a developer-facing English message
  that helps developers *understand* and *resolve* the error. If a localized
  user-facing error message is needed, put the localized message in the error
  details or localize it in the client. The optional error details may contain
  arbitrary information about the error. There is a predefined set of error
  detail types in the package `google.rpc` which can be used for common error
  conditions.  # Language mapping  The `Status` message is the logical
  representation of the error model, but it is not necessarily the actual wire
  format. When the `Status` message is exposed in different client libraries
  and different wire protocols, it can be mapped differently. For example, it
  will likely be mapped to some exceptions in Java, but more likely mapped to
  some error codes in C.  # Other uses  The error model and the `Status`
  message can be used in a variety of environments, either with or without
  APIs, to provide a consistent developer experience across different
  environments.  Example uses of this error model include:  - Partial errors.
  If a service needs to return partial errors to the client,     it may embed
  the `Status` in the normal response to indicate the partial     errors.  -
  Workflow errors. A typical workflow has multiple steps. Each step may
  have a `Status` message for error reporting purpose.  - Batch operations. If
  a client uses batch request and batch response, the     `Status` message
  should be used directly inside batch response, one for     each error sub-
  response.  - Asynchronous operations. If an API call embeds asynchronous
  operation     results in its response, the status of those operations should
  be     represented directly using the `Status` message.  - Logging. If some
  API errors are stored in logs, the message `Status` could     be used
  directly after any stripping needed for security/privacy reasons.

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details.  There will be a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    """A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class Table(_messages.Message):
  """A collection of user data indexed by row, column, and timestamp. Each
  table is served using the resources of its parent cluster.

  Enums:
    GranularityValueValuesEnum: (`CreationOnly`) The granularity (e.g.
      `MILLIS`, `MICROS`) at which timestamps are stored in this table.
      Timestamps not matching the granularity will be rejected. If unspecified
      at creation time, the value will be set to `MILLIS`. Views:
      `SCHEMA_VIEW`, `FULL`

  Messages:
    ColumnFamiliesValue: (`CreationOnly`) The column families configured for
      this table, mapped by column family ID. Views: `SCHEMA_VIEW`, `FULL`

  Fields:
    columnFamilies: (`CreationOnly`) The column families configured for this
      table, mapped by column family ID. Views: `SCHEMA_VIEW`, `FULL`
    granularity: (`CreationOnly`) The granularity (e.g. `MILLIS`, `MICROS`) at
      which timestamps are stored in this table. Timestamps not matching the
      granularity will be rejected. If unspecified at creation time, the value
      will be set to `MILLIS`. Views: `SCHEMA_VIEW`, `FULL`
    name: (`OutputOnly`) The unique name of the table. Values are of the form
      `projects/<project>/instances/<instance>/tables/_a-zA-Z0-9*`. Views:
      `NAME_ONLY`, `SCHEMA_VIEW`, `FULL`
  """

  class GranularityValueValuesEnum(_messages.Enum):
    """(`CreationOnly`) The granularity (e.g. `MILLIS`, `MICROS`) at which
    timestamps are stored in this table. Timestamps not matching the
    granularity will be rejected. If unspecified at creation time, the value
    will be set to `MILLIS`. Views: `SCHEMA_VIEW`, `FULL`

    Values:
      TIMESTAMP_GRANULARITY_UNSPECIFIED: The user did not specify a
        granularity. Should not be returned. When specified during table
        creation, MILLIS will be used.
      MILLIS: The table keeps data versioned at a granularity of 1ms.
    """
    TIMESTAMP_GRANULARITY_UNSPECIFIED = 0
    MILLIS = 1

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ColumnFamiliesValue(_messages.Message):
    """(`CreationOnly`) The column families configured for this table, mapped
    by column family ID. Views: `SCHEMA_VIEW`, `FULL`

    Messages:
      AdditionalProperty: An additional property for a ColumnFamiliesValue
        object.

    Fields:
      additionalProperties: Additional properties of type ColumnFamiliesValue
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a ColumnFamiliesValue object.

      Fields:
        key: Name of the additional property.
        value: A ColumnFamily attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('ColumnFamily', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  columnFamilies = _messages.MessageField('ColumnFamiliesValue', 1)
  granularity = _messages.EnumField('GranularityValueValuesEnum', 2)
  name = _messages.StringField(3)


class Union(_messages.Message):
  """A GcRule which deletes cells matching any of the given rules.

  Fields:
    rules: Delete cells which would be deleted by any element of `rules`.
  """

  rules = _messages.MessageField('GcRule', 1, repeated=True)


class UpdateClusterMetadata(_messages.Message):
  """The metadata for the Operation returned by UpdateCluster.

  Fields:
    finishTime: The time at which the operation failed or was completed
      successfully.
    originalRequest: The request that prompted the initiation of this
      UpdateCluster operation.
    requestTime: The time at which the original request was received.
  """

  finishTime = _messages.StringField(1)
  originalRequest = _messages.MessageField('Cluster', 2)
  requestTime = _messages.StringField(3)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv',
    package=u'bigtableadmin')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1',
    package=u'bigtableadmin')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2',
    package=u'bigtableadmin')
