/*
 * Decompiled with CFR 0.152.
 */
package com.nwalsh.saxon;

import com.icl.saxon.om.NamePool;
import com.icl.saxon.output.Emitter;
import com.icl.saxon.tree.AttributeCollection;
import com.nwalsh.saxon.Callout;
import com.nwalsh.saxon.FormatCallout;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;

public class FormatGraphicCallout
extends FormatCallout {
    String graphicsPath = "";
    String graphicsExt = "";
    int graphicsMax = 0;

    public FormatGraphicCallout(NamePool nPool, String path, String ext, int max, boolean fo) {
        super(nPool, fo);
        this.graphicsPath = path;
        this.graphicsExt = ext;
        this.graphicsMax = max;
    }

    public void formatCallout(Emitter rtfEmitter, Callout callout) {
        Element area = callout.getArea();
        int num = callout.getCallout();
        String userLabel = this.areaLabel(area);
        String label = "(" + num + ")";
        if (userLabel != null) {
            label = userLabel;
        }
        try {
            if (userLabel == null && num <= this.graphicsMax) {
                int imgName = 0;
                AttributeCollection imgAttr = null;
                int[] namespaces = new int[1];
                if (this.foStylesheet) {
                    imgName = this.namePool.allocate("fo", "http://www.w3.org/1999/XSL/Format", "external-graphic");
                    imgAttr = new AttributeCollection(this.namePool);
                    imgAttr.addAttribute("", "", "src", "CDATA", this.graphicsPath + num + this.graphicsExt);
                } else {
                    imgName = this.namePool.allocate("", "", "img");
                    imgAttr = new AttributeCollection(this.namePool);
                    imgAttr.addAttribute("", "", "src", "CDATA", this.graphicsPath + num + this.graphicsExt);
                    imgAttr.addAttribute("", "", "alt", "CDATA", label);
                }
                this.startSpan(rtfEmitter);
                rtfEmitter.startElement(imgName, (Attributes)imgAttr, namespaces, 0);
                rtfEmitter.endElement(imgName);
                this.endSpan(rtfEmitter);
            } else {
                this.formatTextCallout(rtfEmitter, callout);
            }
        }
        catch (TransformerException e) {
            System.out.println("Transformer Exception in graphic formatCallout");
        }
    }
}

