<?php

// FIXME : use db functions properly
// $device_id_host = @dbFetchCell("SELECT device_id FROM devices WHERE `hostname` = '".mres($entry['host'])."' OR `sysName` = '".mres($entry['host'])."'");
// $device_id_ip = @dbFetchCell("SELECT device_id FROM ipv4_addresses AS A, ports AS I WHERE A.ipv4_address = '" . $entry['host']."' AND I.port_id = A.port_id");


function get_cache($host, $value)
{
    global $dev_cache;

    if (!isset($dev_cache[$host][$value])) {
        switch ($value) {
            case 'device_id':
                // Try by hostname
                $ip = inet_pton($host);
                if (inet_ntop($ip) === false) {
                    $dev_cache[$host]['device_id'] = dbFetchCell('SELECT `device_id` FROM devices WHERE `hostname` = ? OR `sysName` = ?', array($host, $host));
                } else {
                    $dev_cache[$host]['device_id'] = dbFetchCell('SELECT `device_id` FROM devices WHERE `hostname` = ? OR `sysName` = ? OR `ip` = ?', array($host, $host, $ip));
                }
                // If failed, try by IP
                if (!is_numeric($dev_cache[$host]['device_id'])) {
                    $dev_cache[$host]['device_id'] = dbFetchCell('SELECT `device_id` FROM `ipv4_addresses` AS A, `ports` AS I WHERE A.ipv4_address = ? AND I.port_id = A.port_id', array($host));
                }
                break;

            case 'os':
                $dev_cache[$host]['os'] = dbFetchCell('SELECT `os` FROM devices WHERE `device_id` = ?', array(get_cache($host, 'device_id')));
                break;

            case 'version':
                $dev_cache[$host]['version'] = dbFetchCell('SELECT `version` FROM devices WHERE `device_id`= ?', array(get_cache($host, 'device_id')));
                break;

            default:
                return null;
        }//end switch
    }//end if

    return $dev_cache[$host][$value];
}//end get_cache()


function process_syslog($entry, $update)
{
    global $config, $dev_cache;

    foreach ($config['syslog_filter'] as $bi) {
        if (strpos($entry['msg'], $bi) !== false) {
            return $entry;
        }
    }

    $entry['host'] = preg_replace("/^::ffff:/", "", $entry['host']);
    $entry['device_id'] = get_cache($entry['host'], 'device_id');
    if ($entry['device_id']) {
        $os = get_cache($entry['host'], 'os');

        if (in_array($os, array('ios', 'iosxe', 'catos'))) {
            // multipart message
            if (strpos($entry['msg'], ':') !== false) {
                $matches = array();
                $timestamp_prefix = '([\*\.]?[A-Z][a-z]{2} \d\d? \d\d:\d\d:\d\d(.\d\d\d)?( [A-Z]{3})?: )?';
                $program_match = '(?<program>%?[A-Za-z\d\-_]+(:[A-Z]* %[A-Z\d\-_]+)?)';
                $message_match = '(?<msg>.*)';
                if (preg_match('/^' . $timestamp_prefix . $program_match . ': ?' . $message_match . '/', $entry['msg'], $matches)) {
                    $entry['program'] = $matches['program'];
                    $entry['msg'] = $matches['msg'];
                }
                unset($matches);
            } else {
                // if this looks like a program (no groups of 2 or more lowercase letters), move it to program
                if (!preg_match('/[(a-z)]{2,}/', $entry['msg'])) {
                    $entry['program'] = $entry['msg'];
                    unset($entry['msg']);
                }
            }
        } elseif ($os == 'linux' and get_cache($entry['host'], 'version') == 'Point') {
            // Cisco WAP200 and similar
            $matches = array();
            if (preg_match('#Log: \[(?P<program>.*)\] - (?P<msg>.*)#', $entry['msg'], $matches)) {
                $entry['msg']     = $matches['msg'];
                $entry['program'] = $matches['program'];
            }

            unset($matches);
        } elseif ($os == 'linux') {
            $matches = array();
            // pam_krb5(sshd:auth): authentication failure; logname=root uid=0 euid=0 tty=ssh ruser= rhost=123.213.132.231
            // pam_krb5[sshd:auth]: authentication failure; logname=root uid=0 euid=0 tty=ssh ruser= rhost=123.213.132.231
            if (empty($entry['program']) and preg_match('#^(?P<program>([^(:]+\([^)]+\)|[^\[:]+\[[^\]]+\])) ?: ?(?P<msg>.*)$#', $entry['msg'], $matches)) {
                $entry['msg']     = $matches['msg'];
                $entry['program'] = $matches['program'];
            } // SYSLOG CONNECTION BROKEN; FD='6', SERVER='AF_INET(123.213.132.231:514)', time_reopen='60'
            // pam_krb5: authentication failure; logname=root uid=0 euid=0 tty=ssh ruser= rhost=123.213.132.231
            // Disabled because broke this:
            // diskio.c: don't know how to handle 10 request
            // elseif($pos = strpos($entry['msg'], ';') or $pos = strpos($entry['msg'], ':')) {
            // $entry['program'] = substr($entry['msg'], 0, $pos);
            // $entry['msg'] = substr($entry['msg'], $pos+1);
            // }
            // fallback, better than nothing...
            elseif (empty($entry['program']) and !empty($entry['facility'])) {
                $entry['program'] = $entry['facility'];
            }

            unset($matches);
        } elseif ($os == 'procurve') {
            $matches = array();
            if (preg_match('/^(?P<program>[A-Za-z]+): {2}(?P<msg>.*)/', $entry['msg'], $matches)) {
                $entry['msg']     = $matches['msg']. " [". $entry['program']. "]";
                $entry['program'] = $matches['program'];
            }
            unset($matches);
        }//end if

        if (!isset($entry['program'])) {
            $entry['program'] = $entry['msg'];
            unset($entry['msg']);
        }

        $entry['program'] = strtoupper($entry['program']);
        $entry = array_map('trim', $entry);

        if ($update) {
            dbInsert(
                array(
                    'device_id' => $entry['device_id'],
                    'program'   => $entry['program'],
                    'facility'  => $entry['facility'],
                    'priority'  => $entry['priority'],
                    'level'     => $entry['level'],
                    'tag'       => $entry['tag'],
                    'msg'       => $entry['msg'],
                    'timestamp' => $entry['timestamp'],
                ),
                'syslog'
            );
        }

        unset($os);
    }//end if

    return $entry;
}//end process_syslog()
