Ext.namespace("Zarafa.plugins.files");Zarafa.plugins.files.ABOUT='<p>Copyright (C) 2005-2015  Zarafa B.V. &lt;info@zarafa.com&gt; and its licensors</p><p>This program is free software: you can redistribute it and/or modify it under the terms of the GNU Affero General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.</p><p>This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Affero General Public License for more details.</p><p>You should have received a copy of the GNU Affero General Public License along with this program.  If not, see <a href="http://www.gnu.org/licenses/" target="_blank">http://www.gnu.org/licenses/</a>.</p><hr /><p>The files plugin contains the following third-party components:</p><h1>ExtJS ux.Media 2.1.3 extension</h1><p>Copyright(c) 2007-2010, Active Group, Inc.</p><p>License: ux.Media classes are licensed under the terms of the Open Source GPL 3.0 license (details: http://www.gnu.org/licenses/gpl.html).</p>';
Ext.namespace("Zarafa.plugins.files.data");
Zarafa.plugins.files.data.ResponseHandler=Ext.extend(Zarafa.core.data.AbstractResponseHandler,{nodeId:undefined,successCallback:null,failureCallback:null,doLoaddirectory:function(a){a.status===true?this.successCallback(a.items,a):this.failureCallback(a)},doGetversion:function(a){this.successCallback(a)},doCheckifexists:function(a){this.successCallback(a)},doGetdynamics:function(a){this.successCallback(a)},doTmpdownload:function(a){this.successCallback(a.items,a)},doCreatedir:function(a){this.successCallback(a)},
doUploadtooc:function(a){this.successCallback(a)},doUpdatesession:function(a){this.successCallback(a)},doClearcache:function(a){this.successCallback(a)},doMove:function(a){a.status===true?this.successCallback(a):this.failureCallback(a)},doError:function(a){a.error?Zarafa.common.dialogs.MessageBox.show({title:dgettext("plugin_files","Error"),msg:a.error.info.original_message,icon:Zarafa.common.dialogs.MessageBox.ERROR,buttons:Zarafa.common.dialogs.MessageBox.OK}):Zarafa.common.dialogs.MessageBox.show({title:dgettext("plugin_files",
"Error"),msg:a.info.original_message,icon:Zarafa.common.dialogs.MessageBox.ERROR,buttons:Zarafa.common.dialogs.MessageBox.OK})}});Ext.reg("zarafa.filesresponsehandler",Zarafa.plugins.files.data.ResponseHandler);Ext.namespace("Zarafa.plugins.files.data");
Zarafa.plugins.files.data.DirectoryLoader=Ext.extend(Ext.tree.TreeLoader,{files:false,constructor:function(a){a=a||{};if(Ext.isDefined(a.loadfiles))this.files=a.loadfiles;Ext.applyIf(a,{preloadChildren:true,directFn:this.loadFolder.createDelegate(this),listeners:{loadexception:function(b,c,d){Zarafa.common.dialogs.MessageBox.show({title:dgettext("plugin_files","Loading failed"),msg:d.error,icon:Zarafa.common.dialogs.MessageBox.ERROR,buttons:Zarafa.common.dialogs.MessageBox.OK})}}});Zarafa.plugins.files.data.DirectoryLoader.superclass.constructor.call(this,
a)},loadFolder:function(a,b){var c=new Zarafa.plugins.files.data.ResponseHandler({successCallback:function(d,e){var f=Zarafa.plugins.files.data.ComponentBox.getViewPanelToolbar();if(f)(f=f.uploadbutton)&&f.enable();b(d,e)},failureCallback:function(d){var e=Zarafa.plugins.files.data.ComponentBox.getViewPanelToolbar(),f=Zarafa.plugins.files.data.ComponentBox.getTabPanelItems(),g=Ext.WindowMgr.getActive();g&&g.close();container.getSharedComponent(Zarafa.core.data.SharedComponentType["common.create"]);
Ext.each(f,function(h){Ext.isDefined(h.xtype)&&h.xtype==="zarafa.filesuploadcontentpanel"&&h.close()});if(e)(e=e.uploadbutton)&&e.disable();Zarafa.common.dialogs.MessageBox.show({title:dgettext("plugin_files","Error"),msg:d.error,icon:Zarafa.common.dialogs.MessageBox.ERROR,buttons:Zarafa.common.dialogs.MessageBox.OK});b(undefined,{status:true,items:undefined})},nodeId:a});container.getRequest().singleRequest("filesbrowsermodule","loaddirectory",{id:a,loadfiles:this.files},c)}});Ext.namespace("Zarafa.plugins.files.data");
Zarafa.plugins.files.data.Version=Ext.extend(Object,{ocversion:undefined,plversion:undefined,isoc:false,init:function(){var a=new Zarafa.plugins.files.data.ResponseHandler({successCallback:this.gotVersion.createDelegate(this)});container.getRequest().singleRequest("filesmodule","getversion",{plugin:"files"},a)},gotVersion:function(a){this.ocversion=a.ocversion;this.plversion=a.version;this.isoc=this.ocversion?true:false},isOwncloud:function(){return this.isoc},getPluginVersion:function(){return this.plversion},
getFilesVersion:function(){if(this.ocversion){this.isoc=true;return this.ocversion}else{this.isoc=false;return dgettext("plugin_files","Unknown")}}});Zarafa.plugins.files.data.Version=new Zarafa.plugins.files.data.Version;Ext.namespace("Zarafa.plugins.files.data");
Zarafa.plugins.files.data.Dynamics=Ext.extend(Object,{dynData:undefined,init:function(){var a=new Zarafa.plugins.files.data.ResponseHandler({successCallback:this.gotDynamics.createDelegate(this)});container.getRequest().singleRequest("filesmodule","getdynamics",{plugin:"files"},a)},gotDynamics:function(a){this.dynData=a},getMaxUploadFilesize:function(){if(!Ext.isEmpty(this.dynData)&&this.dynData.uploadLimit)return this.dynData.uploadLimit},getCurrentStoreSize:function(){if(!Ext.isEmpty(this.dynData)&&
this.dynData.quotaSupport===true)return parseFloat(this.dynData.quotaUsed);return-1},getAvailableStoreSize:function(){if(!Ext.isEmpty(this.dynData)&&this.dynData.quotaSupport===true)return parseFloat(this.dynData.quotaAvailable);return-1}});Zarafa.plugins.files.data.Dynamics=new Zarafa.plugins.files.data.Dynamics;Ext.namespace("Zarafa.plugins.files.settings");
Zarafa.plugins.files.settings.SettingsFilesComponentsWidget=Ext.extend(Zarafa.settings.ui.SettingsWidget,{constructor:function(a){a=a||{};Ext.applyIf(a,{title:String.format(dgettext("plugin_files","Enable/Disable {0} components"),container.getSettingsModel().get("zarafa/v1/plugins/files/button_name")),layout:"form",items:[{xtype:"checkbox",name:"zarafa/v1/plugins/attachfromfiles/enable",ref:"attachFrom",fieldLabel:String.format(dgettext("plugin_files","Attach a file from {0}"),container.getSettingsModel().get("zarafa/v1/plugins/files/button_name")),
lazyInit:false},{xtype:"checkbox",name:"zarafa/v1/plugins/savetofiles/enable",ref:"attachTo",fieldLabel:String.format(dgettext("plugin_files","Save received attachments to {0}"),container.getSettingsModel().get("zarafa/v1/plugins/files/button_name")),lazyInit:false},{xtype:"checkbox",name:"zarafa/v1/plugins/filescontext/enable",ref:"enableBrowser",fieldLabel:dgettext("plugin_files","Enable file browser"),lazyInit:false}]});Zarafa.plugins.files.settings.SettingsFilesComponentsWidget.superclass.constructor.call(this,
a)},update:function(a){this.model=a;this.attachFrom.setValue(a.get(this.attachFrom.name));this.attachTo.setValue(a.get(this.attachTo.name));this.enableBrowser.setValue(a.get(this.enableBrowser.name))},updateSettings:function(a){a.set(this.attachFrom.name,this.attachFrom.getValue());a.set(this.attachTo.name,this.attachTo.getValue());a.set(this.enableBrowser.name,this.enableBrowser.getValue())}});Ext.reg("Zarafa.plugins.files.settingsfilescomponentswidget",Zarafa.plugins.files.settings.SettingsFilesComponentsWidget);
Ext.namespace("Zarafa.plugins.files.settings");
Zarafa.plugins.files.settings.SettingsFilesWidget=Ext.extend(Zarafa.settings.ui.SettingsWidget,{constructor:function(a){a=a||{};var b={xtype:"jsonstore",autoDestroy:true,fields:["type","text"],data:[{text:_("Webdav"),type:"webdav"},{text:_("FTP"),type:"ftp"}]};Ext.applyIf(a,{title:String.format(dgettext("plugin_files","General {0} settings"),container.getSettingsModel().get("zarafa/v1/plugins/files/button_name")),layout:"form",items:[{xtype:"textfield",name:"zarafa/v1/contexts/files/server",ref:"serverField",
fieldLabel:dgettext("plugin_files","Server address"),emptyText:"demo.files.org",anchor:"100%"},{xtype:"textfield",name:"zarafa/v1/contexts/files/port",ref:"portField",fieldLabel:dgettext("plugin_files","Server port"),emptyText:"80",anchor:"100%"},{xtype:"textfield",name:"zarafa/v1/contexts/files/port_ssl",ref:"portsslField",fieldLabel:dgettext("plugin_files","Server SSL port"),emptyText:"443",anchor:"100%"},{xtype:"textfield",name:"zarafa/v1/contexts/files/files_path",ref:"pathField",fieldLabel:String.format(dgettext("plugin_files",
"Path to {0}"),container.getSettingsModel().get("zarafa/v1/plugins/files/button_name")),emptyText:"",anchor:"100%",validator:function(c){if(/.*\/remote\.php\/webdav\/$|.*\/files\/webdav\.php\/$/g.test(c))return dgettext("plugin_files","No trailing slashes!");return true}},{xtype:"checkbox",name:"zarafa/v1/contexts/files/session_auth",ref:"sessionAuth",fieldLabel:dgettext("plugin_files","Use Zarafa credentials for authentication"),lazyInit:false,listeners:{check:this.onCheck,scope:this}},{xtype:"textfield",
name:"zarafa/v1/contexts/files/username",ref:"usernameField",fieldLabel:dgettext("plugin_files","Username"),emptyText:"test",anchor:"100%"},{xtype:"textfield",name:"zarafa/v1/contexts/files/password",ref:"passwordField",inputType:"password",fieldLabel:dgettext("plugin_files","Password"),emptyText:"test",anchor:"100%"},{xtype:"checkbox",name:"zarafa/v1/contexts/files/use_ssl",ref:"useSSL",fieldLabel:dgettext("plugin_files","Use SSL connections"),lazyInit:false,listeners:{check:this.onCheck,scope:this}},
{xtype:"combo",name:"zarafa/v1/contexts/files/backend",ref:"backendCombo",fieldLabel:dgettext("plugin_files","Backend to use"),store:b,mode:"local",triggerAction:"all",displayField:"text",valueField:"type",lazyInit:false,forceSelection:true,editable:false,autoSelect:true,lazyInit:false}]});Zarafa.plugins.files.settings.SettingsFilesWidget.superclass.constructor.call(this,a)},update:function(a){this.model=a;this.serverField.setValue(a.get(this.serverField.name));this.portField.setValue(a.get(this.portField.name));
this.portsslField.setValue(a.get(this.portsslField.name));this.pathField.setValue(a.get(this.pathField.name));this.sessionAuth.setValue(a.get(this.sessionAuth.name));this.usernameField.setValue(a.get(this.usernameField.name));this.passwordField.setValue(Zarafa.plugins.files.data.Helper.Base64.decode(a.get(this.passwordField.name)));this.useSSL.setValue(a.get(this.useSSL.name));this.backendCombo.setValue(a.get(this.backendCombo.name));if(a.get(this.useSSL.name)===true){this.portsslField.show();this.portsslField.label.show();
this.portField.hide();this.portField.label.hide()}else{this.portsslField.hide();this.portsslField.label.hide();this.portField.show();this.portField.label.show()}if(a.get(this.sessionAuth.name)===true){this.usernameField.hide();this.usernameField.label.hide();this.passwordField.hide();this.passwordField.label.hide()}else{this.usernameField.show();this.usernameField.label.show();this.passwordField.show();this.passwordField.label.show()}},updateSettings:function(a){var b=this.serverField.getValue()||
this.serverField.emptyText,c=this.portField.getValue()||this.portField.emptyText,d=this.portsslField.getValue()||this.portsslField.emptyText,e=this.pathField.getValue()||this.pathField.emptyText,f=this.usernameField.getValue()||this.usernameField.emptyText,g=this.passwordField.getValue()||this.passwordField.emptyText,h=this.backendCombo.getValue()||"webdav";a.beginEdit();a.set(this.serverField.name,b);a.set(this.portField.name,c);a.set(this.portsslField.name,d);a.set(this.pathField.name,e);a.set(this.sessionAuth.name,
this.sessionAuth.getValue());a.set(this.usernameField.name,f);a.set(this.passwordField.name,Zarafa.plugins.files.data.Helper.Base64.encode(g));a.set(this.useSSL.name,this.useSSL.getValue());a.set(this.backendCombo.name,h);a.endEdit();container.getRequest().singleRequest("filesmodule","updatesession",{},new Zarafa.plugins.files.data.ResponseHandler({successCallback:this.updateSessionDone.createDelegate(this)}))},updateSessionDone:function(a){if(a.status===true){container.getRequest().singleRequest("filesmodule",
"updatesession",{},null);Zarafa.plugins.files.data.Actions.reloadNavigatorTree();container.getNotifier().notify("info.files",dgettext("plugin_files","Session updated!"),dgettext("plugin_files","Settings applied successfully."))}else container.getNotifier().notify("error",dgettext("plugin_files","Session update failed!"),dgettext("plugin_files","Session update failed, please log in again."))},onCheck:function(a,b){if(a.name===this.sessionAuth.name&&b){this.usernameField.hide();this.usernameField.label.hide();
this.passwordField.hide();this.passwordField.label.hide()}else if(a.name===this.sessionAuth.name){this.usernameField.show();this.usernameField.label.show();this.passwordField.show();this.passwordField.label.show()}if(a.name===this.useSSL.name&&b){this.portsslField.show();this.portsslField.label.show();this.portField.hide();this.portField.label.hide()}else if(a.name===this.useSSL.name){this.portsslField.hide();this.portsslField.label.hide();this.portField.show();this.portField.label.show()}}});
Ext.reg("Zarafa.plugins.files.settingsfileswidget",Zarafa.plugins.files.settings.SettingsFilesWidget);Ext.namespace("Zarafa.plugins.files.settings");
Zarafa.plugins.files.settings.SettingsFilesVersionWidget=Ext.extend(Zarafa.settings.ui.SettingsWidget,{constructor:function(a){a=a||{};Ext.applyIf(a,{title:dgettext("plugin_files","Version information"),layout:"form",items:[{xtype:"displayfield",fieldLabel:dgettext("plugin_files","Files Backend"),value:Zarafa.plugins.files.data.Version.getFilesVersion(),htmlEncode:true},{xtype:"displayfield",fieldLabel:dgettext("plugin_files","Plugin"),value:Zarafa.plugins.files.data.Version.getPluginVersion(),htmlEncode:true},
{xtype:"displayfield",fieldLabel:dgettext("plugin_files","Maximum upload size"),value:Ext.util.Format.fileSize(Zarafa.plugins.files.data.Dynamics.getMaxUploadFilesize()),htmlEncode:true}]});Zarafa.plugins.files.settings.SettingsFilesVersionWidget.superclass.constructor.call(this,a)}});Ext.reg("Zarafa.plugins.files.settingsfilesversionwidget",Zarafa.plugins.files.settings.SettingsFilesVersionWidget);Ext.namespace("Zarafa.plugins.files.settings");
Zarafa.plugins.files.settings.SettingsFilesQuotaWidget=Ext.extend(Zarafa.settings.ui.SettingsWidget,{constructor:function(a){a=a||{};Ext.applyIf(a,{title:dgettext("plugin_files","Quota information"),layout:"form",items:[{xtype:"zarafa.plugins.files.quotabar",width:400,hidden:true,ref:"quotaBar",storeSize:0,warnQuota:0,hardQuota:0},{xtype:"displayfield",width:400,hideLabel:true,ref:"unavailableQuotaInfo",hidden:true,value:dgettext("plugin_files","Quota information is not available.")},{xtype:"displayfield",
hideLabel:true,width:400,ref:"quotaInfo"}]});Zarafa.plugins.files.settings.SettingsFilesQuotaWidget.superclass.constructor.call(this,a);this.on("afterrender",this.updateQuotaInfo,this)},updateQuotaInfo:function(){var a=Zarafa.plugins.files.data.Dynamics.getCurrentStoreSize(),b=a+Zarafa.plugins.files.data.Dynamics.getAvailableStoreSize(),c=b-102400,d=String.format(dgettext("plugin_files","{0} of disk space is used."),Ext.util.Format.fileSize(a)),e='<span class="zarafa-quota-string">'+d+"</span>";if(b&&
b>0){this.quotaBar.setStoreSize(a);this.quotaBar.setHardQuota(b);this.quotaBar.setWarnQuota(c);this.quotaBar.setVisible(true);this.unavailableQuotaInfo.setVisible(false);d=this.getQuotaSuggestionString(b,a);this.quotaInfo.setVisible(true);Ext.isEmpty(d)||(e+=" "+d)}else{this.quotaBar.setVisible(false);this.quotaInfo.setVisible(false);this.unavailableQuotaInfo.setVisible(true)}this.quotaInfo.setValue(e)},getQuotaSuggestionString:function(a,b){if(Ext.isDefined(b))if(a&&b>a)return String.format(dgettext("plugin_files",
"You have exceeded quota ({0}), you can not store more files on the server."),Ext.util.Format.fileSize(a));else if(a&&b<a)return String.format(dgettext("plugin_files","At {0} you won't be able to store files on the server."),Ext.util.Format.fileSize(a))}});Ext.reg("Zarafa.plugins.files.settingsfilesquotawidget",Zarafa.plugins.files.settings.SettingsFilesQuotaWidget);Ext.namespace("Zarafa.plugins.files.settings");
Zarafa.plugins.files.settings.SettingsFilesResetSettingsWidget=Ext.extend(Zarafa.settings.ui.SettingsWidget,{loadMask:undefined,constructor:function(a){a=a||{};Ext.applyIf(a,{title:_("Reset Files settings"),layout:"form",items:[{xtype:"displayfield",hideLabel:true,value:_("Resets Files settings to their original defaults")},{xtype:"button",text:_("Reset Files settings"),width:150,handler:this.onResetSettings,scope:this}]});Zarafa.plugins.files.settings.SettingsFilesResetSettingsWidget.superclass.constructor.call(this,
a)},onResetSettings:function(){var a=_("Your Files's settings will be restored to their default condition. Are you sure you want to reset all Files settings?");a+="<br/><br/>";a+=_("WebApp will automatically restart in order for these changes to take effect");a+="<br/>";Zarafa.common.dialogs.MessageBox.addCustomButtons({title:_("Reset Files settings"),msg:a,icon:Ext.MessageBox.QUESTION,fn:this.resetDefaultSettings,customButton:[{text:_("Reset"),name:"reset"},{text:_("Cancel"),name:"cancel"}],scope:this})},
resetDefaultSettings:function(a){if(a==="reset"){a=container.getSettingsModel();a.reset("zarafa/v1/contexts/files");a.save();this.loadMask=new Zarafa.common.ui.LoadMask(Ext.getBody(),{msg:"<b>"+_("Webapp is reloading, Please wait.")+"</b>"});this.loadMask.show();this.mon(a,"save",this.onSettingsSave,this);this.mon(a,"exception",this.onSettingsException,this)}},onSettingsSave:function(a,b){if(b.action===Zarafa.core.Actions.reset){this.mun(a,"save",this.onSettingsSave,this);this.mun(a,"exception",this.onSettingsException,
this);Zarafa.core.Util.reloadWebapp()}},onSettingsException:function(a,b,c,d){if(d.action===Zarafa.core.Actions.reset){this.loadMask.hide();this.mun(a,"save",this.onSettingsSave,this);this.mun(a,"exception",this.onSettingsException,this)}}});Ext.reg("Zarafa.plugins.files.settingsfilesresetsettingswidget",Zarafa.plugins.files.settings.SettingsFilesResetSettingsWidget);Ext.namespace("Zarafa.plugins.files.settings");
Zarafa.plugins.files.settings.SettingsFilesCategory=Ext.extend(Zarafa.settings.ui.SettingsCategory,{constructor:function(a){a=a||{};Ext.applyIf(a,{title:container.getSettingsModel().get("zarafa/v1/plugins/files/button_name"),categoryIndex:1,iconCls:"icon_files_category",items:[{xtype:"Zarafa.plugins.files.settingsfilescomponentswidget"},{xtype:"Zarafa.plugins.files.settingsfileswidget"},{xtype:"Zarafa.plugins.files.settingsfilesquotawidget"},{xtype:"Zarafa.plugins.files.settingsfilesversionwidget"},
{xtype:"Zarafa.plugins.files.settingsfilesresetsettingswidget"},container.populateInsertionPoint("context.settings.category.files",this)]});Zarafa.plugins.files.settings.SettingsFilesCategory.superclass.constructor.call(this,a)}});Ext.reg("Zarafa.plugins.files.settingsfilescategory",Zarafa.plugins.files.settings.SettingsFilesCategory);Ext.namespace("Zarafa.plugins.files.dialogs");
Zarafa.plugins.files.dialogs.AttachFromFilesTreePanel=Ext.extend(Ext.tree.TreePanel,{emailRecord:undefined,constructor:function(a){a=a||{};if(Ext.isDefined(a.emailrecord))this.emailRecord=a.emailrecord;Ext.applyIf(a,{root:{nodeType:"async",text:"/",id:"/",expanded:true},autoScroll:true,viewConfig:{style:{overflow:"auto",overflowX:"hidden"}},maskDisabled:true,loader:new Zarafa.plugins.files.data.DirectoryLoader({loadfiles:true}),buttons:[this.createActionButtons()]});Zarafa.plugins.files.dialogs.AttachFromFilesTreePanel.superclass.constructor.call(this,
a)},createActionButtons:function(){return[{xtype:"button",text:"&nbsp;&nbsp;&nbsp;&nbsp;"+dgettext("plugin_files","Add attachment"),tooltip:{title:dgettext("plugin_files","Add attachment"),text:dgettext("plugin_files","Add selected attachment from files to email attachment.")},iconCls:"icon_files_category",handler:this.downloadSelectedFilesFromFilesToTmp,scope:this}]},downloadSelectedFilesFromFilesToTmp:function(){var a=this.getChecked(),b=[],c=this.dialog.record;if(Ext.isDefined(this.emailRecord))c=
this.emailRecord;c=c.getAttachmentStore();var d=container.getSettingsModel().get("zarafa/v1/main/attachments/max_attachment_size"),e=false;Ext.each(a,function(g){if(g.attributes.filesize>d){Zarafa.common.dialogs.MessageBox.show({title:dgettext("plugin_files","Warning"),msg:String.format(dgettext("plugin_files","The file {0} is too large!"),g.attributes.filename)+" ("+dgettext("plugin_files","max")+": "+Ext.util.Format.fileSize(d)+")",icon:Zarafa.common.dialogs.MessageBox.WARNING,buttons:Zarafa.common.dialogs.MessageBox.OK});
e=true;return false}b.push(g.id)});if(!e)if(b.length<1)Zarafa.common.dialogs.MessageBox.show({title:dgettext("plugin_files","Warning"),msg:dgettext("plugin_files","You have to choose at least one file!"),icon:Zarafa.common.dialogs.MessageBox.WARNING,buttons:Zarafa.common.dialogs.MessageBox.OK});else try{this.disable();container.getRequest().singleRequest("filesmodule","download-to-tmp",{ids:b,dialog_attachments:c.getId()},new Zarafa.plugins.files.data.ResponseHandler({successCallback:this.addDownloadedFilesAsAttachmentToEmail.createDelegate(this)}))}catch(f){Zarafa.common.dialogs.MessageBox.show({title:dgettext("plugin_files",
"Warning"),msg:f.getMessage(),icon:Zarafa.common.dialogs.MessageBox.WARNING,buttons:Zarafa.common.dialogs.MessageBox.OK})}},convertDownloadedFileInfoToAttachmentRecord:function(a){var b=Zarafa.core.data.RecordFactory.createRecordObjectByObjectType(Zarafa.core.mapi.ObjectType.MAPI_ATTACH);b.set("tmpname",a.tmpname);b.set("name",a.name);b.set("size",a.size);return b},addDownloadedFilesAsAttachmentToEmail:function(a){var b=this.dialog.record;if(Ext.isDefined(this.emailRecord))b=this.emailRecord;var c=
b.getAttachmentStore(),d=null;Ext.each(a,function(e){d=this.convertDownloadedFileInfoToAttachmentRecord(e);c.add(d)},this);this.dialog.close()}});Ext.reg("Zarafa.plugins.files.attachfromfilestreepanel",Zarafa.plugins.files.dialogs.AttachFromFilesTreePanel);Ext.namespace("Zarafa.plugins.files.dialogs");
Zarafa.plugins.files.dialogs.AttachFromFilesContentPanel=Ext.extend(Zarafa.core.ui.ContentPanel,{record:null,constructor:function(a){a=a||{};Ext.applyIf(a,{layout:"fit",title:String.format(dgettext("plugin_files","{0} Attachment"),container.getSettingsModel().get("zarafa/v1/plugins/files/button_name")),closeOnSave:true,width:400,height:300,items:[{xtype:"Zarafa.plugins.files.attachfromfilestreepanel",emailrecord:a.emailrecord,ref:"treePanel"}]});Zarafa.plugins.files.dialogs.AttachFromFilesContentPanel.superclass.constructor.call(this,
a)}});Ext.reg("Zarafa.plugins.files.attachfromfilescontentpanel",Zarafa.plugins.files.dialogs.AttachFromFilesContentPanel);Ext.namespace("Zarafa.plugins.files.dialogs");
Zarafa.plugins.files.dialogs.SaveToFilesTreePanel=Ext.extend(Ext.tree.TreePanel,{selectedFolder:null,response:null,constructor:function(a){a=a||{};this.response=a.response;Ext.applyIf(a,{root:{nodeType:"async",text:"/",id:"/",expanded:true},autoScroll:true,viewConfig:{style:{overflow:"auto",overflowX:"hidden"}},maskDisabled:true,listeners:{click:function(b){this.selectedFolder=b.attributes.id}},loader:new Zarafa.plugins.files.data.DirectoryLoader({loadfiles:false}),buttons:[this.createActionButtons()]});
Zarafa.plugins.files.dialogs.SaveToFilesTreePanel.superclass.constructor.call(this,a)},createActionButtons:function(){return[{xtype:"button",text:dgettext("plugin_files","New folder"),tooltip:{title:dgettext("plugin_files","New folder"),text:dgettext("plugin_files","Create a new folder")},handler:this.newFolder,scope:this},{xtype:"button",text:"&nbsp;&nbsp;&nbsp;&nbsp;"+dgettext("plugin_files","Save"),tooltip:{title:dgettext("plugin_files","Store attachment"),text:String.format(dgettext("plugin_files",
"Store attachment to the selected {0} folder."),container.getSettingsModel().get("zarafa/v1/plugins/files/button_name"))},iconCls:"icon_files_category",handler:this.uploadFile,scope:this}]},uploadFile:function(){if(!Ext.isDefined(this.selectedFolder)||Ext.isEmpty(this.selectedFolder))Zarafa.plugins.files.data.Actions.msgWarning(dgettext("plugin_files","You have to choose a folder!"));else{for(var a=[],b=0,c=this.response.count;b<c;b++)a[b]={id:this.selectedFolder+this.response.items[b].filename,isFolder:false};
try{container.getRequest().singleRequest("filesmodule","checkifexists",{records:a,destination:this.selectedFolder},new Zarafa.plugins.files.data.ResponseHandler({successCallback:this.checkForDuplicateFileDone.createDelegate(this)}))}catch(d){Zarafa.plugins.files.data.Actions.msgWarning(d.message);return false}}},uploadDone:function(a){a.status===true?container.getNotifier().notify("info.files",dgettext("plugin_files","Uploaded"),String.format(dgettext("plugin_files","Attachment successfully stored to {0}"),
container.getSettingsModel().get("zarafa/v1/plugins/files/button_name"))):container.getNotifier().notify("error",dgettext("plugin_files","Upload Failed"),String.format(dgettext("plugin_files","Attachment could not be stored in {0}! Error:"),container.getSettingsModel().get("zarafa/v1/plugins/files/button_name"))+" "+a.status);this.dialog.close()},newFolder:function(){!Ext.isDefined(this.selectedFolder)||Ext.isEmpty(this.selectedFolder)?Zarafa.plugins.files.data.Actions.msgWarning(dgettext("plugin_files",
"You have to choose a folder!")):Zarafa.common.dialogs.MessageBox.prompt(dgettext("plugin_files","Folder Name"),dgettext("plugin_files","Please enter a foldername"),this.checkForDuplicateFolder,this)},checkForDuplicateFolder:function(a,b){if(a==="ok")if(Zarafa.plugins.files.data.Helper.File.isValidFilename(b))try{container.getRequest().singleRequest("filesmodule","checkifexists",{id:this.selectedFolder+b,isfolder:true},new Zarafa.plugins.files.data.ResponseHandler({successCallback:this.checkForDuplicateFolderDone.createDelegate(this,
[b],true)}))}catch(c){Zarafa.plugins.files.data.Actions.msgWarning(c.message);return false}else Zarafa.plugins.files.data.Actions.msgWarning(dgettext("plugin_files","Incorrect foldername"))},checkForDuplicateFolderDone:function(a,b){a.duplicate===false?this.createRemoteFolder(b):Zarafa.plugins.files.data.Actions.msgWarning(dgettext("plugin_files","Folder already exists"))},checkForDuplicateFileDone:function(a){a.duplicate===false?this.doUpload():Ext.MessageBox.confirm(dgettext("plugin_files","Confirm overwrite"),
dgettext("plugin_files","File already exists. Do you want to overwrite it?"),this.doUpload,this)},doUpload:function(a){if(!Ext.isDefined(a)||a==="yes"){container.getNotifier().notify("info.files",dgettext("plugin_files","Uploading..."),dgettext("plugin_files","Please be patient while the files are uploaded..."));try{this.disable();container.getRequest().singleRequest("filesmodule","uploadtooc",{items:this.response.items,count:this.response.count,type:this.response.type,destdir:this.selectedFolder},
new Zarafa.plugins.files.data.ResponseHandler({successCallback:this.uploadDone.createDelegate(this)}))}catch(b){Zarafa.plugins.files.data.Actions.msgWarning(b.message)}}},createRemoteFolder:function(a){try{container.getRequest().singleRequest("filesmodule","createdir",{dirname:this.selectedFolder+a,basedir:this.selectedFolder},new Zarafa.plugins.files.data.ResponseHandler({successCallback:this.createDirDone.createDelegate(this)}))}catch(b){Zarafa.plugins.files.data.Actions.msgWarning(b.message)}},
createDirDone:function(a){if(a.status===true){container.getNotifier().notify("info.files",dgettext("plugin_files","Created"),dgettext("plugin_files","Directory created!"));var b=this.getNodeById(a.basedir);if(Ext.isDefined(b))if(b.isLeaf()){b=this.getNodeById((a.basedir.substr(-1)=="/"?a.basedir.substr(0,a.basedir.length-1):a.basedir).match(/.*\//));if(Ext.isDefined(b)){b.on("expand",this.reloadParentDone.createDelegate(this,[a.basedir]),this,{single:true});b.reload()}}else b.reload()}else container.getNotifier().notify("error",
dgettext("plugin_files","Creation failed"),dgettext("plugin_files","Directory not created!"))},reloadParentDone:function(a){a=this.getNodeById(a);Ext.isDefined(a)&&a.expand()}});Ext.reg("Zarafa.plugins.files.savetofilestreepanel",Zarafa.plugins.files.dialogs.SaveToFilesTreePanel);Ext.namespace("Zarafa.plugins.files.dialogs");
Zarafa.plugins.files.dialogs.SaveToFilesContentPanel=Ext.extend(Zarafa.core.ui.ContentPanel,{constructor:function(a){a=a||{};Ext.applyIf(a,{layout:"fit",title:String.format(dgettext("plugin_files","{0} Attachment"),container.getSettingsModel().get("zarafa/v1/plugins/files/button_name")),closeOnSave:true,width:400,height:300,items:[{xtype:"Zarafa.plugins.files.savetofilestreepanel",ref:"treePanel",response:a.record}]});Zarafa.plugins.files.dialogs.SaveToFilesContentPanel.superclass.constructor.call(this,
a)}});Ext.reg("Zarafa.plugins.files.savetofilescontentpanel",Zarafa.plugins.files.dialogs.SaveToFilesContentPanel);Ext.namespace("Zarafa.plugins.files");
Zarafa.plugins.files.AttachFromFilesPlugin=Ext.extend(Zarafa.core.Plugin,{constructor:function(a){a=a||{};Zarafa.plugins.files.AttachFromFilesPlugin.superclass.constructor.call(this,a)},initPlugin:function(){Zarafa.plugins.files.AttachFromFilesPlugin.superclass.initPlugin.apply(this,arguments);this.registerInsertionPoint("main.attachment.method",this.onAttachmentInsertion);Zarafa.core.data.SharedComponentType.addProperty("common.dialog.attachments.files")},onAttachmentInsertion:function(a,b){return{text:container.getSettingsModel().get("zarafa/v1/plugins/files/button_name"),
handler:this.showFilesAttachmentDialog.createDelegate(this,[b]),scope:this,iconCls:"icon_files_category"}},showFilesAttachmentDialog:function(a){Zarafa.core.data.UIFactory.openLayerComponent(Zarafa.core.data.SharedComponentType["common.dialog.attachments.files"],a.record,{title:String.format(dgettext("plugin_files","Add attachment from {0}"),container.getSettingsModel().get("zarafa/v1/plugins/files/button_name")),manager:Ext.WindowMgr})},bidSharedComponent:function(a,b){var c=-1;switch(a){case Zarafa.core.data.SharedComponentType["common.dialog.attachments.files"]:if(b instanceof
Zarafa.core.data.IPMRecord)if(b.supportsAttachments())c=1;break}return c},getSharedComponent:function(a){var b;switch(a){case Zarafa.core.data.SharedComponentType["common.dialog.attachments.files"]:b=Zarafa.plugins.files.dialogs.AttachFromFilesContentPanel;break}return b}});
Zarafa.onReady(function(){Ext.isDefined(container.getSettingsModel().get("zarafa/v1/plugins/files/button_name"))&&container.getSettingsModel().get("zarafa/v1/plugins/files/enable")===true&&container.registerPlugin(new Zarafa.core.PluginMetaData({name:"attachfromfiles",allowUserVisible:false,displayName:String.format(dgettext("plugin_files","Attach a file from {0}"),container.getSettingsModel().get("zarafa/v1/plugins/files/button_name")),pluginConstructor:Zarafa.plugins.files.AttachFromFilesPlugin}))});
Ext.namespace("Zarafa.plugins.files");
Zarafa.plugins.files.SaveToFilesPlugin=Ext.extend(Zarafa.core.Plugin,{constructor:function(a){a=a||{};Zarafa.plugins.files.SaveToFilesPlugin.superclass.constructor.call(this,a)},initPlugin:function(){Zarafa.plugins.files.SaveToFilesPlugin.superclass.initPlugin.apply(this,arguments);this.registerInsertionPoint("common.contextmenu.attachment.actions",this.createAttachmentUploadInsertionPoint,this);this.registerInsertionPoint("context.mail.contextmenu.actions",this.createEmailUploadInsertionPoint,this);
Zarafa.core.data.SharedComponentType.addProperty("common.dialog.attachments.savetofiles")},createAttachmentUploadInsertionPoint:function(a,b){return{text:container.getSettingsModel().get("zarafa/v1/plugins/files/button_name"),handler:this.showFilesUploadAttachmentDialog.createDelegate(this,[b]),scope:this,iconCls:"icon_files_category"}},createEmailUploadInsertionPoint:function(a,b){return{text:dgettext("plugin_files","Add to Files"),handler:this.showFilesUploadEmailDialog.createDelegate(this,[b]),
scope:this,iconCls:"icon_files_category"}},showLoadingBar:function(){Zarafa.common.dialogs.MessageBox.show({title:dgettext("plugin_files","Please wait"),msg:dgettext("plugin_files","Loading attachment")+"...",progressText:dgettext("plugin_files","Initializing")+"...",width:300,wait:true,waitConfig:{interval:200},closable:false})},showFilesUploadAttachmentDialog:function(a){var b=a.records,c=b.store;a=c.getParentRecord().get("store_entryid");var d=c.getAttachmentParentRecordEntryId(),e=Array(1);e[0]=
b.get("attach_num")!=-1?b.get("attach_num"):b.get("tmpname");c=c.getId();b=b.get("name");jsonRecords=[];jsonRecords[0]={entryid:d,store:a,attachNum:e,dialog_attachments:c,filename:b};Zarafa.core.data.UIFactory.openLayerComponent(Zarafa.core.data.SharedComponentType["common.dialog.attachments.savetofiles"],{items:jsonRecords,type:"attachment",count:jsonRecords.length},{title:String.format(dgettext("plugin_files","Add attachment to {0}"),container.getSettingsModel().get("zarafa/v1/plugins/files/button_name")),
manager:Ext.WindowMgr})},showFilesUploadEmailDialog:function(a){a=[].concat(a.records);for(var b=[],c=0,d=a.length;c<d;c++)b[c]={store:a[c].get("store_entryid"),entryid:a[c].get("entryid"),filename:(Ext.isEmpty(a[c].get("subject"))?_("Untitled"):a[c].get("subject"))+".eml"};Zarafa.core.data.UIFactory.openLayerComponent(Zarafa.core.data.SharedComponentType["common.dialog.attachments.savetofiles"],{items:b,type:"mail",count:b.length},{title:String.format(dgettext("plugin_files","Add email to {0}"),
container.getSettingsModel().get("zarafa/v1/plugins/files/button_name")),manager:Ext.WindowMgr})},bidSharedComponent:function(a){var b=-1;switch(a){case Zarafa.core.data.SharedComponentType["common.dialog.attachments.savetofiles"]:b=1;break}return b},getSharedComponent:function(a){var b;switch(a){case Zarafa.core.data.SharedComponentType["common.dialog.attachments.savetofiles"]:b=Zarafa.plugins.files.dialogs.SaveToFilesContentPanel;break}return b}});
Zarafa.onReady(function(){Ext.isDefined(container.getSettingsModel().get("zarafa/v1/plugins/files/button_name"))&&container.getSettingsModel().get("zarafa/v1/plugins/files/enable")===true&&container.registerPlugin(new Zarafa.core.PluginMetaData({name:"savetofiles",allowUserVisible:false,displayName:String.format(dgettext("plugin_files","Save received attachments to {0}"),container.getSettingsModel().get("zarafa/v1/plugins/files/button_name")),pluginConstructor:Zarafa.plugins.files.SaveToFilesPlugin}))});
Ext.namespace("Zarafa.plugins.files.data");
Zarafa.plugins.files.data.Helper={Base64:{_keyStr:"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=",encode:function(a){var b="",c,d,e,f,g,h,i=0;for(a=this._utf8_encode(a);i<a.length;){c=a.charCodeAt(i++);d=a.charCodeAt(i++);e=a.charCodeAt(i++);f=c>>2;c=(c&3)<<4|d>>4;g=(d&15)<<2|e>>6;h=e&63;if(isNaN(d))g=h=64;else if(isNaN(e))h=64;b=b+this._keyStr.charAt(f)+this._keyStr.charAt(c)+this._keyStr.charAt(g)+this._keyStr.charAt(h)}return b},decode:function(a){var b="",c,d,e,f,g,h=0;for(a=
a.replace(/[^A-Za-z0-9\+\/\=]/g,"");h<a.length;){c=this._keyStr.indexOf(a.charAt(h++));d=this._keyStr.indexOf(a.charAt(h++));f=this._keyStr.indexOf(a.charAt(h++));g=this._keyStr.indexOf(a.charAt(h++));c=c<<2|d>>4;d=(d&15)<<4|f>>2;e=(f&3)<<6|g;b+=String.fromCharCode(c);if(f!=64)b+=String.fromCharCode(d);if(g!=64)b+=String.fromCharCode(e)}return b=this._utf8_decode(b)},_utf8_decode:function(a){for(var b="",c=0,d=0,e=0,f=0;c<a.length;){d=a.charCodeAt(c);if(d<128){b+=String.fromCharCode(d);c++}else if(d>
191&&d<224){e=a.charCodeAt(c+1);b+=String.fromCharCode((d&31)<<6|e&63);c+=2}else{e=a.charCodeAt(c+1);f=a.charCodeAt(c+2);b+=String.fromCharCode((d&15)<<12|(e&63)<<6|f&63);c+=3}}return b},_utf8_encode:function(a){a=a.replace(/\r\n/g,"\n");for(var b="",c=0;c<a.length;c++){var d=a.charCodeAt(c);if(d<128)b+=String.fromCharCode(d);else{if(d>127&&d<2048)b+=String.fromCharCode(d>>6|192);else{b+=String.fromCharCode(d>>12|224);b+=String.fromCharCode(d>>6&63|128)}b+=String.fromCharCode(d&63|128)}}return b}},
Renderer:{typeRenderer:function(a,b,c){switch(a){case Zarafa.plugins.files.data.FileTypes.FOLDER:b.css="zarafa-files-listview-icon "+Zarafa.plugins.files.data.Helper.File.getIconClass("folder","16");break;case Zarafa.plugins.files.data.FileTypes.FILE:b.css="zarafa-files-listview-icon "+Zarafa.plugins.files.data.Helper.File.getIconClass(c.get("filename"),"16");break;default:break}b.css+=" zarafa-grid-empty-cell";return""},datetimeRenderer:function(a,b){b.css="mail_date";a=new Date(a);return Ext.isDate(a)?
a.format(dgettext("plugin_files","l d/m/Y G:i")):dgettext("plugin_files","Never")}},Format:{fileSize:function(a){return a===-1||a==="none"?"":a<1024?a+" bytes":a<1048576?Math.round(a*10/1024)/10+" KB":a<1073741824?Math.round(a*10/1048576)/10+" MB":Math.round(a*10/1073741824)/10+" GB"},fileSizeList:function(a){return a===-1||a==="none"?"":a<1024?a<=100&&a!=0?"0.1 &nbsp;KB":Math.round(a*10/1024)/10+" &nbsp;KB":a<1048576?Math.round(a*10/1024)/10+" &nbsp;KB":a<1073741824?Math.round(a*10/1048576)/10+" &nbsp;MB":
a<1099511627776?Math.round(a*10/1073741824)/10+" &nbsp;GB":Math.round(a*10/1099511627776)/10+" &nbsp;TB"}},File:{getExtension:function(a){var b=a.lastIndexOf(".");return b<0?"":a.substr(b+1)},getIconClass:function(a,b){Ext.isDefined(b)||(b="48");if(a==="folder")return"files"+b+"icon_folder";var c=this.getExtension(a).toLowerCase(),d=["aac","ai","aiff","avi","bmp","c","cpp","css","dat","dmg","doc","docx","dotx","dwg","dxf","eps","exe","flv","gif","gz","h","hpp","html","ics","iso","java","jpg","js",
"key","less","mid","mp3","mp4","mpg","odf","ods","odt","otp","ots","ott","pdf","php","png","ppt","psd","py","qt","rar","rb","rtf","sass","sql","tga","tgz","tiff","txt","wav","xls","xlsx","xml","yml","zip"].indexOf(c);if(Ext.isEmpty(c)||d===-1)return"files"+b+"icon_blank";return"files"+b+"icon_"+c},isValidFilename:function(a){if(Ext.isEmpty(a))return false;if(a.indexOf("/")!==-1)return false;if(a.indexOf("\\")!==-1||a.indexOf("<")!==-1||a.indexOf(">")!==-1||a.indexOf(":")!==-1||a.indexOf("'")!==-1||
a.indexOf("|")!==-1||a.indexOf("?")!==-1||a.indexOf("*")!==-1)return false;return true}}};Ext.namespace("Zarafa.plugins.files.data");
Zarafa.plugins.files.data.ComponentBox=Ext.extend(Object,{getContext:function(){return container.getCurrentContext()},getContextModel:function(){return this.getContext().getModel()},getStore:function(){return this.getContextModel().getStore()},getNavigatorPanel:function(){return container.getNavigationBar()},getNavigatorTreePanel:function(){return this.getNavigatorPanel().filesTreepanel},getMainPanel:function(){try{return container.getContentPanel()}catch(a){return container.getTabPanel().getItem(0).getActiveItem()}},
getPreviewPanel:function(){return this.getMainPanel().filesPreview},getTabPanel:function(){return container.getTabPanel()},getTabPanelItems:function(){return this.getTabPanel().items.items},getViewPanel:function(){return this.getMainPanel().filesViewPanel},getViewPanelToolbar:function(){var a=this.getViewPanel();if(a)return a.topToolbar}});Zarafa.plugins.files.data.ComponentBox=new Zarafa.plugins.files.data.ComponentBox;Ext.namespace("Zarafa.plugins.files.data");
Zarafa.plugins.files.data.DataModes=Zarafa.core.Enum.create({ALL:0});Ext.namespace("Zarafa.plugins.files.data");Zarafa.plugins.files.data.FileTypes=Zarafa.core.Enum.create({FOLDER:0,FILE:1});Ext.namespace("Zarafa.plugins.files.data");Zarafa.plugins.files.data.ViewModes=Zarafa.core.Enum.create({NO_PREVIEW:0,RIGHT_PREVIEW:1,BOTTOM_PREVIEW:2});Ext.namespace("Zarafa.plugins.files.data");Zarafa.plugins.files.data.Views=Zarafa.core.Enum.create({LIST:0,ICON:1});Ext.namespace("Zarafa.plugins.files.data");
Zarafa.plugins.files.data.Actions={downloadFrame:undefined,convertDownloadedFileInfoToAttachmentRecord:function(a){var b=Zarafa.core.data.RecordFactory.createRecordObjectByObjectType(Zarafa.core.mapi.ObjectType.MAPI_ATTACH);b.set("tmpname",a.tmpname);b.set("name",a.name);b.set("size",a.size);return b},openCreateMailContent:function(a,b,c){var d=a.getAttachmentStore(),e=null;Ext.each(b,function(f){e=this.convertDownloadedFileInfoToAttachmentRecord(f);d.add(e)},this);Zarafa.core.data.UIFactory.openCreateRecord(a,
c)},openCreateMailContentForContacts:function(a,b,c){a=container.getContextByName("mail").getModel().createRecord();Zarafa.core.data.UIFactory.openLayerComponent(Zarafa.core.data.SharedComponentType["zarafa.plugins.files.attachdialog"],undefined,{title:String.format(dgettext("plugin_files","Add attachment from {0}"),container.getSettingsModel().get("zarafa/v1/plugins/files/button_name")),emailrecord:a,manager:Ext.WindowMgr});var d=a.getRecipientStore(),e=[];b=Ext.isArray(b)?b:[b];for(var f=0,g=b.length;f<
g;f++){var h=b[f];if(h.isOpened()){var i=h.convertToRecipient(Zarafa.core.mapi.RecipientType.MAPI_TO,true);d.add(i)}else e.push({fn:function(){var j=h;return function(k,l,m,o){var n=function(p,q){if(q===j){p.un("open",n,m);var r=j.convertToRecipient(Zarafa.core.mapi.RecipientType.MAPI_TO,true);d.add(r);o()}};j.getStore().on("open",n,m);j.open()}}()})}c=Ext.applyIf(c||{},{recordComponentPluginConfig:{loadTasks:e}});Zarafa.core.data.UIFactory.openCreateRecord(a,c)},openCreateFilesContent:function(a,
b){var c=a.createRecord();Zarafa.core.data.UIFactory.openCreateRecord(c,b)},openFilesContent:function(a){var b=Zarafa.plugins.files.data.ComponentBox.getNavigatorTreePanel(),c=Zarafa.plugins.files.data.ComponentBox.getStore();if(a.length==1&&a[0].get("type")===Zarafa.plugins.files.data.FileTypes.FOLDER){c.loadPath(a[0].get("id"));b.getNodeById(a[0].get("id")).reload()}else a.length>1&&this.downloadItem(a)},refreshNavigatorTree:function(){var a=Zarafa.plugins.files.data.ComponentBox.getNavigatorTreePanel(),
b=Zarafa.plugins.files.data.ComponentBox.getStore();a=a.getNodeById(b.getPath());Ext.isDefined(a)&&!a.isLeaf()&&a.reload()},createUploadDialog:function(a,b,c){if(!Ext.isDefined(c)||Ext.isEmpty(c))c=a.getStore().getPath();b=Ext.applyIf(b||{},{modal:true,parentID:c});Zarafa.core.data.UIFactory.openLayerComponent(Zarafa.core.data.SharedComponentType["zarafa.plugins.files.uploadpanel"],undefined,b)},createFolder:function(a,b,c){if(!Ext.isDefined(c)||Ext.isEmpty(c))c=a.getStore().getPath();Ext.MessageBox.prompt(dgettext("plugin_files",
"Folder name"),dgettext("plugin_files","Please enter a foldername"),this.doCreateFolder.createDelegate(this,[a,c],true),this)},doCreateFolder:function(a,b,c,d,e){if(a==="ok")try{a=false;if(d.getStore().findExact("id",e+b+"/")!=-1)a=true;if(Zarafa.plugins.files.data.Helper.File.isValidFilename(b))if(a)this.msgWarning(dgettext("plugin_files","Folder already exists"));else{var f=new Date,g=f.getTime()+f.getTimezoneOffset()*60*1E3,h=Zarafa.core.data.RecordFactory.createRecordObjectByCustomType(Zarafa.core.data.RecordCustomObjectType.ZARAFA_FILES,
{filename:b,path:e,id:e+b+"/",message_size:"-1",lastmodified:g,type:Zarafa.plugins.files.data.FileTypes.FOLDER});d.getStore().add(h);d.getStore().on("update",this.reloadCurrentDir,this,{single:true});d.getStore().commitChanges()}else this.msgWarning(dgettext("plugin_files","Incorrect foldername"))}catch(i){this.msgWarning(i.message)}},moveRecords:function(a,b,c){c=Ext.isDefined(c)?c:false;b=b instanceof Zarafa.plugins.files.data.FilesRecord?b.get("id"):b;if(c)this.doMoveRecords("yes",null,null,d,
b);else{var d=[];Ext.each(a,function(e){d.push(e.get("id"))});a=Zarafa.plugins.files.data.ComponentBox.getStore();a.on("load",this.checkForDuplicate.createDelegate(this,[d,a.getPath()],true),this,{single:true});a.loadPath(b)}},checkForDuplicate:function(a,b,c,d,e){var f=[],g=a.getPath();Ext.each(d,function(h){h=a.findExact("id",g+h.split("/").pop());h!=-1&&f.push(a.getById(h))});a.loadPath(e);f.length>0?Ext.MessageBox.confirm(dgettext("plugin_files","Confirm overwrite"),dgettext("plugin_files","File already exists. Do you want to overwrite it?"),
this.doMoveRecords.createDelegate(this,[d,g],true),this):this.doMoveRecords("yes",null,null,d,g)},doMoveRecords:function(a,b,c,d,e){if(!Ext.isDefined(a)||a==="yes")try{container.getRequest().singleRequest("filesbrowsermodule","move",{ids:d,overwrite:true,destination:e,destinationIsFolder:true},new Zarafa.plugins.files.data.ResponseHandler({successCallback:this.moveRecordsDone.createDelegate(this,[true],true),failureCallback:this.moveRecordsDone.createDelegate(this,[false],true)}))}catch(f){this.msgWarning(f.message);
return false}},moveRecordsDone:function(a,b){b||Zarafa.common.dialogs.MessageBox.show({title:dgettext("plugin_files","Error"),msg:a.message,icon:Zarafa.common.dialogs.MessageBox.ERROR,buttons:Zarafa.common.dialogs.MessageBox.OK});Zarafa.plugins.files.data.Actions.reloadCurrentDir()},openRenameDialog:function(a,b){Ext.MessageBox.prompt(dgettext("plugin_files","Rename"),dgettext("plugin_files","Please enter a new name"),this.doRename.createDelegate(this,[b],true),this,false,b.get("filename"))},doRename:function(a,
b,c,d){if(a==="ok")try{var e=d.get("path")==="/"?"":d.get("path"),f=/\/$/.test(d.get("id"))?"/":"";a=false;if(d.getStore().findExact("id",d.get("path")+b+f)!=-1)a=true;if(Zarafa.plugins.files.data.Helper.File.isValidFilename(b))if(a)this.msgWarning(/\/$/.test(d.get("id"))?dgettext("plugin_files","Foldername already exists"):dgettext("plugin_files","Filename already exists"));else{d.getStore().on("save",this.reloadCurrentDir,this,{single:true});d.beginEdit();d.set("filename",b);d.set("id",e+"/"+b+
f);d.endEdit()}else this.msgWarning(dgettext("plugin_files","Incorrect filename"))}catch(g){this.msgWarning(g.message)}},reloadCurrentDir:function(){Zarafa.plugins.files.data.ComponentBox.getStore().reload();this.refreshNavigatorTree()},reloadNavigatorTree:function(){var a=Zarafa.plugins.files.data.ComponentBox.getNavigatorTreePanel();Ext.isDefined(a)&&a.setRootNode({nodeType:"async",text:"/",id:"/",expanded:true})},clearCache:function(a){a=Ext.isDefined(a)?a:true;try{container.getRequest().singleRequest("filesmodule",
"clearcache",{},new Zarafa.plugins.files.data.ResponseHandler({successCallback:this.clearCacheDone.createDelegate(this,[a],true)}))}catch(b){this.msgWarning(b.message)}},clearCacheDone:function(a,b){b&&Zarafa.plugins.files.data.Actions.reloadCurrentDir()},downloadItem:function(a){container.getNotifier().notify("info.files",dgettext("plugin_files","Downloading"),dgettext("plugin_files","Download started... please wait!"));var b=Ext.getBody().createChild({tag:"iframe",cls:"x-hidden"});if(a.length==
1){a=this.getDownloadLink(a[0],false);b.dom.contentWindow.location=a}else if(a.length>1){a=this.getDownloadLinkForMultipleFiles(a,false);b.dom.contentWindow.location=a}},uploadItem:function(a,b){var c=b.getPath(),d={},e=new FormData;d.attachments=a;d.parentID=c;var f=false,g=false,h=new Ext.LoadMask(Zarafa.plugins.files.data.ComponentBox.getMainPanel().getEl(),{msg:dgettext("plugin_files","Uploading files")+"..."});h.show();for(var i in d){var j=d[i];if(Ext.isArray(j)||j instanceof FileList)for(var k=
0,l=j.length;k<l;k++){if(b.findExact("id",c+j[k].name)!=-1)f=true;e.append(i+"[]",j[k]);if(j[k].size>Zarafa.plugins.files.data.Dynamics.getMaxUploadFilesize())g=true}else e.append(i,j)}if(g){Zarafa.common.dialogs.MessageBox.show({title:dgettext("plugin_files","Error"),msg:String.format(dgettext("plugin_files","File is too large! Maximum allowed filesize: {0}."),Zarafa.plugins.files.data.Helper.Format.fileSize(Zarafa.plugins.files.data.Dynamics.getMaxUploadFilesize())),icon:Zarafa.common.dialogs.MessageBox.ERROR,
buttons:Zarafa.common.dialogs.MessageBox.OK});h.hide()}else f?Ext.MessageBox.confirm(dgettext("plugin_files","Confirm overwrite"),dgettext("plugin_files","File already exists. Do you want to overwrite it?"),this.doUpload.createDelegate(this,[e,h],true),this):this.doUpload("yes",null,null,e,h)},doUpload:function(a,b,c,d,e){if(!Ext.isDefined(a)||a==="yes"){a=new XMLHttpRequest;a.open("POST","plugins/files/php/upload_file.php",true);a.addEventListener("load",this.uploadDone.createDelegate(a,[e],true),
false);a.upload.addEventListener("progress",this.updateUploadProgress.createDelegate(this,[e],true),false);a.send(d)}else e.hide()},updateUploadProgress:function(a,b){if(a.lengthComputable){var c=Math.round(a.loaded/a.total*100);b.hide();b.msg=c<100?dgettext("plugin_files","Uploaded")+" "+c+"%":dgettext("plugin_files","Storing file on backend. Please wait")+"...";b.show()}},uploadDone:function(a,b){this.status==200&&Zarafa.plugins.files.data.Actions.clearCache();b.hide()},getDownloadLink:function(a,
b){return Ext.isDefined(b)&&b==false?a.getAttachmentUrl():a.getInlineImageUrl()},getDownloadLinkForMultipleFiles:function(a){var b="",c=document.URL;b=c.substring(0,c.lastIndexOf("/")+1);b+="plugins/files/php/proxy.php";Ext.each(a,function(d,e){b=Ext.urlAppend(b,"ids["+e+"]="+encodeURIComponent(d.get("id")))});return b=Ext.urlAppend(b,"inline=false")},msgWarning:function(a){Zarafa.common.dialogs.MessageBox.show({title:dgettext("plugin_files","Warning"),msg:a,icon:Zarafa.common.dialogs.MessageBox.WARNING,
buttons:Zarafa.common.dialogs.MessageBox.OK})}};Ext.namespace("Zarafa.plugins.files.data");Zarafa.plugins.files.data.FilesRecordFields=[{name:"id"},{name:"path"},{name:"type",type:"int",defaultValue:Zarafa.plugins.files.data.FileTypes.FOLDER},{name:"filename"},{name:"lastmodified",type:"int",defaultValue:null},{name:"message_size",type:"int",defaultValue:0}];
Zarafa.plugins.files.data.FilesRecord=Ext.extend(Zarafa.core.data.IPMRecord,{disabled:false,applyData:function(a){this.beginEdit();Ext.apply(this.data,a.data);Ext.apply(this.modified,a.modified);this.dirty=a.dirty;this.endEdit(false);return this},getInlineImageUrl:function(){var a="";a+="plugins/files/php/proxy.php?"+Ext.urlEncode({id:this.get("id"),inline:true});return a},getAttachmentUrl:function(){var a="";a=document.URL;a=a.substring(0,a.lastIndexOf("/")+1);a+="plugins/files/php/proxy.php?"+Ext.urlEncode({id:this.get("id"),
inline:false});return a},getThumbnailImageUrl:function(a,b){var c="";c+="plugins/files/php/proxy.php?"+Ext.urlEncode({id:this.get("id"),inline:false,thumb:true,width:a,height:b});return c},setDisabled:function(a){this.disabled=a},getDisabled:function(){return this.disabled}});Zarafa.core.data.RecordCustomObjectType.addProperty("ZARAFA_FILES");Zarafa.core.data.RecordFactory.addFieldToMessageClass("IPM.Files",Zarafa.plugins.files.data.FilesRecordFields);
Zarafa.core.data.RecordFactory.setBaseClassToMessageClass("IPM.Files",Zarafa.plugins.files.data.FilesRecord);Zarafa.core.data.RecordFactory.addFieldToCustomType(Zarafa.core.data.RecordCustomObjectType.ZARAFA_FILES,Zarafa.plugins.files.data.FilesRecordFields);Zarafa.core.data.RecordFactory.setBaseClassToCustomType(Zarafa.core.data.RecordCustomObjectType.ZARAFA_FILES,Zarafa.plugins.files.data.FilesRecord);Ext.namespace("Zarafa.plugins.files.data");
Zarafa.plugins.files.data.FilesStore=Ext.extend(Zarafa.core.data.ListModuleStore,{rootID:undefined,constructor:function(){this.rootID="/";Zarafa.plugins.files.data.FilesStore.superclass.constructor.call(this,{preferredMessageClass:"IPM.Files",autoSave:true,actionType:Zarafa.core.Actions.list,defaultSortInfo:{field:"filename",direction:"asc"},baseParams:{id:this.rootID}})},loadPath:function(a){this.rootID=a;this.load({params:{id:this.rootID}})},getPath:function(){return this.rootID}});Ext.namespace("Zarafa.plugins.files.dialogs");
Zarafa.plugins.files.dialogs.ShowFilesFileContentPanel=Ext.extend(Zarafa.core.ui.ContentPanel,{constructor:function(a){a=a||{};Ext.applyIf(a,{xtype:"zarafa.showfilescontentpanel",layout:"fit",title:dgettext("plugin_files","File information"),items:[this.createPanel(a)]});Zarafa.plugins.files.dialogs.ShowFilesFileContentPanel.superclass.constructor.call(this,a)},createPanel:function(a){return{xtype:"zarafa.filesfileinfo",record:a.record}}});Ext.reg("zarafa.showfilescontentpanel",Zarafa.plugins.files.dialogs.ShowFilesFileContentPanel);
Ext.namespace("Zarafa.plugins.files.dialogs");
Zarafa.plugins.files.dialogs.FilesUploadContentPanel=Ext.extend(Zarafa.core.ui.ContentPanel,{targetFolder:undefined,updateTask:undefined,constructor:function(a){a=a||{};Ext.applyIf(a,{xtype:"zarafa.filesuploadcontentpanel",layout:"fit",title:dgettext("plugin_files","Upload file"),items:[{xtype:"form",ref:"mainuploadform",layout:{type:"vbox",align:"stretch",pack:"start"},fileUpload:true,padding:5,items:[this.createFolderSelector(),this.createUploadField()],buttons:this.createActionButtons()}]});Zarafa.plugins.files.dialogs.FilesUploadContentPanel.superclass.constructor.call(this,
a);this.updateTask={run:function(){this.onUploadFieldChanged(null,this.mainuploadfield.getValue(),null)},interval:1E3,scope:this};Ext.TaskMgr.start(this.updateTask)},createUploadField:function(){return{xtype:"panel",title:dgettext("plugin_files","Select a file")+" ("+dgettext("plugin_files","Maximum upload size")+": "+Zarafa.plugins.files.data.Helper.Format.fileSize(Zarafa.plugins.files.data.Dynamics.getMaxUploadFilesize())+"):",layout:"form",height:62,items:[{xtype:"textfield",inputType:"file",style:{border:"none!important"},
autoCreate:{tag:"input",type:"text",size:"20",autocomplete:"off",multiple:"multiple"},name:"attachments[]",hideLabel:true,anchor:"100%",ref:"../../mainuploadfield",disabled:true,listeners:{change:this.onUploadFieldChanged,scope:this}}]}},createFolderSelector:function(){return{xtype:"treepanel",anchor:"0, 0",flex:1,title:dgettext("plugin_files","Select upload folder")+":",root:{nodeType:"async",text:"/",id:"/",expanded:true},autoScroll:true,viewConfig:{style:{overflow:"auto",overflowX:"hidden"}},maskDisabled:true,
listeners:{click:function(a){this.targetFolder=a.attributes.id;this.mainuploadfield.enable()},scope:this},loader:new Zarafa.plugins.files.data.DirectoryLoader({loadfiles:false})}},createActionButtons:function(){return[{xtype:"button",ref:"../../mainuploadbutton",disabled:true,text:"&nbsp;&nbsp;"+dgettext("plugin_files","Upload"),tooltip:{title:dgettext("plugin_files","Store selected file"),text:dgettext("plugin_files",String.format("Upload file to the selected {0} folder",container.getSettingsModel().get("zarafa/v1/plugins/files/button_name")))},
iconCls:"icon_files",handler:this.uploadFile,scope:this},{xtype:"button",text:dgettext("plugin_files","Cancel"),tooltip:{title:dgettext("plugin_files","Cancel"),text:dgettext("plugin_files","Close this window")},handler:this.onClose,scope:this}]},uploadFile:function(){var a=Zarafa.plugins.files.data.ComponentBox.getStore();a.on("load",this.checkForDuplicate,this,{single:true});a.loadPath(this.targetFolder)},checkForDuplicate:function(a){var b=this.mainuploadfield.getEl().dom.files,c=[];Ext.each(b,
function(d){d=a.findExact("id",a.getPath()+d.name);d!=-1&&c.push(a.getById(d))});c.length>0?Ext.MessageBox.confirm(dgettext("plugin_files","Confirm overwrite"),dgettext("plugin_files","File already exists. Do you want to overwrite it?"),this.doFormSubmit,this):this.doFormSubmit()},doFormSubmit:function(a){if(!Ext.isDefined(a)||a==="yes"){a=this.mainuploadform.getForm();a.isValid()&&Ext.isDefined(this.targetFolder)&&a.submit({waitMsg:dgettext("plugin_files","Uploading files")+"...",url:"plugins/files/php/upload_file.php",
params:{parentID:this.targetFolder},failure:function(b,c){Zarafa.common.dialogs.MessageBox.show({title:dgettext("plugin_files","Error"),msg:c.result.message,icon:Zarafa.common.dialogs.MessageBox.ERROR,buttons:Zarafa.common.dialogs.MessageBox.OK})},success:function(b,c){var d=container.getContextByName("filescontext");Zarafa.plugins.files.data.Actions.clearCache(false);d.model.store.loadPath(c.result.parent)},scope:this});a.on("actioncomplete",this.onClose,this,{delay:5});a.on("actionfailed",this.onClose,
this,{delay:5})}},onUploadFieldChanged:function(a,b){if(Ext.isEmpty(b))this.mainuploadbutton.setDisabled(true);else{var c=this.mainuploadfield.getEl().dom.files,d=false;Ext.each(c,function(e){if(e.size>Zarafa.plugins.files.data.Dynamics.getMaxUploadFilesize()){this.mainuploadfield.reset();Zarafa.common.dialogs.MessageBox.show({title:dgettext("plugin_files","Error"),msg:String.format(dgettext("plugin_files",'File "{0}" is too large! Maximum allowed filesize: {1}.'),e.name,Zarafa.plugins.files.data.Helper.Format.fileSize(Zarafa.plugins.files.data.Dynamics.getMaxUploadFilesize())),
icon:Zarafa.common.dialogs.MessageBox.ERROR,buttons:Zarafa.common.dialogs.MessageBox.OK});this.mainuploadbutton.setDisabled(true);d=true;return false}else d||this.mainuploadbutton.setDisabled(false)},this)}},onClose:function(){Ext.TaskMgr.stop(this.updateTask);this.close()}});Ext.reg("zarafa.filesuploadcontentpanel",Zarafa.plugins.files.dialogs.FilesUploadContentPanel);Ext.namespace("Zarafa.plugins.files.ui");
Zarafa.plugins.files.ui.UploadButton=Ext.extend(Ext.SplitButton,{model:undefined,constructor:function(a){a=a||{};if(!Ext.isDefined(a.model)&&Ext.isDefined(a.context))a.model=a.context.getModel();Ext.applyIf(a,{menu:{items:[{text:dgettext("plugin_files","Upload file"),iconCls:"icon_files_category",handler:function(){Zarafa.plugins.files.data.Actions.createUploadDialog(this.model)},scope:this},{text:dgettext("plugin_files","Create folder"),iconCls:"icon_folder_create",action:"folder",handler:function(){Zarafa.plugins.files.data.Actions.createFolder(this.model)},
scope:this}]},handler:function(){this.showMenu()},scope:this});Zarafa.plugins.files.ui.UploadButton.superclass.constructor.call(this,a)},onFileUpload:function(){Zarafa.plugins.files.data.Actions.createUploadDialog({parentID:"myroot",scope:this})}});Ext.reg("zarafa.filesuploadbutton",Zarafa.plugins.files.ui.UploadButton);Ext.namespace("Zarafa.plugins.files.ui");
Zarafa.plugins.files.ui.UploadPanel=Ext.extend(Zarafa.core.ui.ContentPanel,{callback:Ext.emptyFn,scope:undefined,parentID:"/",updateTask:undefined,constructor:function(a){a=a||{};Ext.applyIf(a,{title:dgettext("plugin_files","Select file"),layout:"fit",width:500,height:75,items:[{xtype:"form",layout:"fit",fileUpload:true,ref:"filesUploadform",buttonAlign:"left",padding:5,items:[{xtype:"textfield",inputType:"file",ref:"uploadField",style:{border:"none!important"},autoCreate:{tag:"input",type:"text",
size:"20",autocomplete:"off",multiple:"multiple"},name:"attachments[]",listeners:{change:this.onUploadFieldChanged,scope:this}}],buttons:[{xtype:"displayfield",value:dgettext("plugin_files","Maximum upload size")+" : "+Zarafa.plugins.files.data.Helper.Format.fileSize(Zarafa.plugins.files.data.Dynamics.getMaxUploadFilesize()),htmlEncode:true},{xtype:"tbfill"},{text:dgettext("plugin_files","Upload"),ref:"../uploadButton",iconCls:"icon_files",handler:this.onUpload,disabled:true,scope:this},{text:dgettext("plugin_files",
"Cancel"),handler:this.onClose,scope:this}]}]});Zarafa.plugins.files.ui.UploadPanel.superclass.constructor.call(this,a);this.updateTask={run:function(){this.onUploadFieldChanged(null,this.filesUploadform.uploadField.getValue(),null)},interval:1E3,scope:this};Ext.TaskMgr.start(this.updateTask)},onUpload:function(){var a=this.filesUploadform.uploadField.getEl().dom.files,b=Zarafa.plugins.files.data.ComponentBox.getStore(),c=[];this.hide();Ext.each(a,function(d){d=b.findExact("id",b.getPath()+d.name);
d!=-1&&c.push(b.getById(d))});c.length>0?Ext.MessageBox.confirm(dgettext("plugin_files","Confirm overwrite"),dgettext("plugin_files","File already exists. Do you want to overwrite it?"),function(d){d==="yes"?this.doFormSubmit():this.onClose()},this):this.doFormSubmit()},doFormSubmit:function(){var a=this.filesUploadform.getForm();a.isValid()&&a.submit({waitMsg:dgettext("plugin_files","Uploading files")+"...",url:"plugins/files/php/upload_file.php",params:{parentID:this.parentID},failure:this.uploadDone.createDelegate(this,
[false],true),success:this.uploadDone.createDelegate(this,[true],true),scope:this});a.on("actioncomplete",this.onClose,this,{delay:5});a.on("actionfailed",this.onClose,this,{delay:5})},uploadDone:function(a,b,c){if(c){Zarafa.plugins.files.data.Actions.clearCache();Zarafa.plugins.files.data.ComponentBox.getStore().loadPath(b.result.parent)}else Zarafa.common.dialogs.MessageBox.show({title:dgettext("plugin_files","Error"),msg:b.result.message,icon:Zarafa.common.dialogs.MessageBox.ERROR,buttons:Zarafa.common.dialogs.MessageBox.OK})},
onUploadFieldChanged:function(a,b){if(Ext.isEmpty(b))this.filesUploadform.uploadButton.setDisabled(true);else{var c=this.filesUploadform.uploadField.getEl().dom.files,d=false;Ext.each(c,function(e){if(e.size>Zarafa.plugins.files.data.Dynamics.getMaxUploadFilesize()){this.filesUploadform.uploadField.reset();Zarafa.common.dialogs.MessageBox.show({title:dgettext("plugin_files","Error"),msg:String.format(dgettext("plugin_files",'File "{0}" is too large! Maximum allowed filesize: {1}.'),e.name,Zarafa.plugins.files.data.Helper.Format.fileSize(Zarafa.plugins.files.data.Dynamics.getMaxUploadFilesize())),
icon:Zarafa.common.dialogs.MessageBox.ERROR,buttons:Zarafa.common.dialogs.MessageBox.OK});this.filesUploadform.uploadButton.setDisabled(true);d=true;return false}else d||this.filesUploadform.uploadButton.setDisabled(false)},this)}},onClose:function(){Ext.TaskMgr.stop(this.updateTask);this.close()}});Ext.reg("zarafa.plugins.files.uploadpanel",Zarafa.plugins.files.ui.UploadPanel);Ext.namespace("Zarafa.plugins.files.ui");
Zarafa.plugins.files.ui.NavigatorTreePanel=Ext.extend(Ext.tree.TreePanel,{constructor:function(a){a=a||{};Ext.applyIf(a,{xtype:"zarafa.filestreepanel",enableDD:true,ddGroup:"dd.filesrecord",root:{nodeType:"async",text:"/",id:"/",expanded:true},autoScroll:true,listeners:{click:this.onNodeClick,beforenodedrop:{fn:function(b){if(Ext.isArray(b.data.selections)){b.cancel=false;Ext.each(b.data.selections,function(c){c.setDisabled(true)});return Zarafa.plugins.files.data.Actions.moveRecords(b.data.selections,
b.target.id)}}},afterrender:function(){this.dragZone.lock()},expandnode:this.OnExpandNode,scope:this},viewConfig:{style:{overflow:"auto",overflowX:"hidden"}},maskDisabled:true,loader:new Zarafa.plugins.files.data.DirectoryLoader({loadfiles:false})});Zarafa.plugins.files.ui.NavigatorTreePanel.superclass.constructor.call(this,a)},onNodeClick:function(a){Zarafa.plugins.files.data.ComponentBox.getStore().loadPath(a.attributes.id);var b=this.getNodeById(a.attributes.id);if(a.isExpandable()){a=a.getUI();
Ext.get(a.iconNode).removeClass("icon_folder_note")}Ext.isDefined(b)&&!b.isLeaf()&&b.reload()},OnExpandNode:function(a){this.updateIcon(a);a.hasChildNodes()&&Ext.each(a.childNodes,function(b){this.updateIcon(b)},this)},updateIcon:function(a){a=a.getUI();Ext.get(a.iconNode).addClass("icon_folder_note")}});Ext.reg("zarafa.filestreepanel",Zarafa.plugins.files.ui.NavigatorTreePanel);Ext.namespace("Zarafa.plugins.files.ui");
Zarafa.plugins.files.ui.FilesViewPanel=Ext.extend(Ext.Panel,{constructor:function(a){a=a||{};Ext.applyIf(a,{xtype:"zarafa.filesviewpanel",border:false,cls:"zarafa-filesviewpanel",layout:"zarafa.collapsible",items:[{xtype:"zarafa.filesfileinfo"}]});Zarafa.plugins.files.ui.FilesViewPanel.superclass.constructor.call(this,a)}});Ext.reg("zarafa.filesviewpanel",Zarafa.plugins.files.ui.FilesViewPanel);Ext.namespace("Zarafa.plugins.files.ui");
Zarafa.plugins.files.ui.FilesFileInfo=Ext.extend(Ext.form.FormPanel,{defaultPreviewImage:"plugins/files/resources/images/no-preview.jpg",record:undefined,constructor:function(a){a=a||{};var b={type:"vbox",align:"stretch",pack:"start"};switch(Zarafa.plugins.files.data.ComponentBox.getContext().getCurrentViewMode()){case Zarafa.plugins.files.data.ViewModes.RIGHT_PREVIEW:break;case Zarafa.plugins.files.data.ViewModes.BOTTOM_PREVIEW:b={type:"hbox",align:"stretch",pack:"start"};break;default:break}a=Ext.applyIf(a,
{xtype:"zarafa.filesfileinfo",ref:"../fileinfo",autoDestroy:true,layout:b,border:false,items:[this.fieldSetFileInfo(),this.fieldSetFilePreview()]});if(Ext.isDefined(a.record)){this.record=a.record;a=Ext.applyIf(a,{listeners:{afterlayout:function(){this.update(this.record)}}})}Zarafa.plugins.files.ui.FilesFileInfo.superclass.constructor.call(this,a)},refresh:function(){this.removeAll();this.add(this.fieldSetFileInfo());this.add(this.fieldSetFilePreview())},fieldSetFileInfo:function(){return{xtype:"fieldset",
title:dgettext("plugin_files","File information"),height:150,width:300,defaults:{anchor:"-3"},items:[{xtype:"textfield",fieldLabel:dgettext("plugin_files","Filename"),ref:"../filename",value:"unknown",readOnly:true},{xtype:"textfield",fieldLabel:dgettext("plugin_files","Filesize"),ref:"../filesize",value:"unknown",readOnly:true},{xtype:"textfield",fieldLabel:dgettext("plugin_files","Last modified"),ref:"../lastmodified",value:"unknown",readOnly:true},{xtype:"textfield",fieldLabel:dgettext("plugin_files",
"Type"),ref:"../type",value:"unknown",readOnly:true}]}},fieldSetFilePreview:function(){var a="width: 100%;";switch(Zarafa.plugins.files.data.ComponentBox.getContext().getCurrentViewMode()){case Zarafa.plugins.files.data.ViewModes.RIGHT_PREVIEW:a="width: 100%;";break;case Zarafa.plugins.files.data.ViewModes.BOTTOM_PREVIEW:a="height: 100%;";break;default:break}return{xtype:"fieldset",title:dgettext("plugin_files","File preview"),ref:"filepreview",flex:1,defaultType:"textfield",items:[{xtype:"component",
id:"previewimage",autoEl:{tag:"img",src:this.defaultPreviewImage,style:a}}]}},setPreviewPanel:function(a,b){var c=Zarafa.plugins.files.data.ComponentBox.getContext().getCurrentViewMode(),d=Ext.ComponentMgr.isRegistered("mediapanel"),e="width: 100%;";switch(c){case Zarafa.plugins.files.data.ViewModes.RIGHT_PREVIEW:e="width: 100%;";break;case Zarafa.plugins.files.data.ViewModes.BOTTOM_PREVIEW:e="height: 100%;";break;default:break}c={};c=!Ext.isEmpty(b)&&/\.(gif|jpg|jpeg|tiff|png)$/i.test(b)?{xtype:"component",
autoEl:{tag:"img",src:Zarafa.plugins.files.data.Actions.getDownloadLink(a),style:e}}:d&&!Ext.isEmpty(b)&&/\.(pdf)$/i.test(b)?{xtype:"mediapanel",anchor:"0, 0",mediaCfg:{mediaType:"PDF",url:Zarafa.plugins.files.data.Actions.getDownloadLink(a),unsupportedText:dgettext("plugin_files","Sorry - no preview for this PDF file!")}}:!Ext.isEmpty(b)&&/\.(txt|html|php|js|c|cpp|h|java|sh|bat|log|cfg|conf|tex|py|pl)$/i.test(b)?{xtype:"textarea",hideLabel:true,readOnly:true,anchor:"0, 0",listeners:{afterrender:function(){Ext.Ajax.request({method:"GET",
url:Zarafa.plugins.files.data.Actions.getDownloadLink(a),success:function(f){this.setRawValue(f.responseText)},scope:this})}}}:d&&!Ext.isEmpty(b)&&/\.(mp3|aac|ogg)$/i.test(b)?{xtype:"mediapanel",anchor:"0, 0",mediaCfg:{mediaType:"JWP",url:"plugins/files/resources/flash/player.swf",width:"100%",height:100,start:false,loop:false,unsupportedText:dgettext("plugin_files","JW FLV Player is not installed/available."),params:{wmode:"transparent",allowscriptaccess:"always",allowfullscreen:"false",flashVars:{width:"@width",
height:"@height",autostart:"@start",file:Zarafa.plugins.files.data.Actions.getDownloadLink(a,false),skin:"plugins/files/resources/flash/jwskin/lightrv5/lightrv5.xml",type:"sound",showdigits:true,volume:15,repeat:"@loop"}}}}:d&&!Ext.isEmpty(b)&&/\.(mp4|flv|mov|webm)$/i.test(b)?{xtype:"mediapanel",anchor:"0, 0",mediaCfg:{mediaType:"JWP",url:"plugins/files/resources/flash/player.swf",width:"100%",start:false,loop:false,unsupportedText:dgettext("plugin_files","JW FLV Player is not installed/available."),
params:{wmode:"transparent",allowscriptaccess:"always",allowfullscreen:"false",flashVars:{width:"@width",height:"@height",autostart:"@start",file:Zarafa.plugins.files.data.Actions.getDownloadLink(a,false),skin:"plugins/files/resources/flash/jwskin/lightrv5/lightrv5.xml",type:"video",showdigits:true,volume:15,repeat:"@loop"}}}}:{xtype:"component",autoEl:{tag:"img",src:this.defaultPreviewImage,style:e}};this.filepreview.removeAll(true);this.filepreview.add(c);this.filepreview.doLayout()},update:function(a){var b=
this.getExtension(a.get("filename"));this.filename.setValue(a.get("filename"));if(a.get("type")==Zarafa.plugins.files.data.FileTypes.FILE){this.filesize.show();this.filesize.setValue(Zarafa.plugins.files.data.Helper.Format.fileSize(a.get("message_size")))}else this.filesize.hide();this.lastmodified.setValue(Ext.util.Format.date(new Date(a.get("lastmodified")),dgettext("plugin_files","d.m.Y G:i")));this.type.setValue(a.get("type")==Zarafa.plugins.files.data.FileTypes.FILE?String.format(dgettext("plugin_files",
"File ({0})"),b):dgettext("plugin_files","Folder"));this.setPreviewPanel(a,b)},onRender:function(a,b){Zarafa.plugins.files.ui.FilesFileInfo.superclass.onRender.call(this,a,b);this.resizeEl=this.positionEl=this.wrap=this.el.wrap({cls:"preview-body"})},getExtension:function(a){var b=a.lastIndexOf(".");return b<0?"":a.substr(b)}});Ext.reg("zarafa.filesfileinfo",Zarafa.plugins.files.ui.FilesFileInfo);Ext.namespace("Zarafa.plugins.files.ui");
Zarafa.plugins.files.ui.FilesPreviewPanelToolbarButtons=Ext.extend(Object,{model:undefined,constructor:function(a){Ext.apply(this,a)},getToolbarButtons:function(){return[{xtype:"tbfill"},{xtype:"zarafa.toolbarbutton",tooltip:dgettext("plugin_files","Delete"),overflowText:dgettext("plugin_files","Delete"),iconCls:"icon_delete",nonEmptySelectOnly:true,handler:this.onDelete,model:this.model},{xtype:"zarafa.toolbarbutton",tooltip:dgettext("plugin_files","Rename"),overflowText:dgettext("plugin_files",
"Rename"),iconCls:"icon_rename",nonEmptySelectOnly:true,handler:this.onRename,model:this.model}]},onRename:function(){var a=this.model.getSelectedRecords();a.length!=1?Zarafa.common.dialogs.MessageBox.show({title:dgettext("plugin_files","Warning"),msg:dgettext("plugin_files","You can only rename one file!"),icon:Zarafa.common.dialogs.MessageBox.WARNING,buttons:Zarafa.common.dialogs.MessageBox.OK}):Zarafa.plugins.files.data.Actions.openRenameDialog(this.model,a[0])},onDelete:function(){var a=true,
b=this.model.getSelectedRecords();Ext.each(b,function(d){if(d.get("id")===container.getSettingsModel().get("zarafa/v1/contexts/files/files_path")+"/"||d.get("filename")==="..")a=false},this);var c=container.getSettingsModel().get("zarafa/v1/contexts/files/ask_before_delete");if(a)if(c)Ext.MessageBox.confirm(dgettext("plugin_files","Confirm deletion"),dgettext("plugin_files","Are you sure?"),function(d){if(d=="yes"){Zarafa.plugins.files.data.ComponentBox.getStore().on("remove",function(){container.getCurrentContext().getCurrentView()===
Zarafa.plugins.files.data.Views.ICON?Zarafa.plugins.files.data.Actions.clearCache():Zarafa.plugins.files.data.Actions.refreshNavigatorTree()},null,{single:true});Zarafa.common.Actions.deleteRecords(b)}},this);else{Zarafa.plugins.files.data.ComponentBox.getStore().on("remove",function(){container.getCurrentContext().getCurrentView()===Zarafa.plugins.files.data.Views.ICON?Zarafa.plugins.files.data.Actions.clearCache():Zarafa.plugins.files.data.Actions.refreshNavigatorTree()},null,{single:true});Zarafa.common.Actions.deleteRecords(b)}else Zarafa.common.dialogs.MessageBox.show({title:dgettext("plugin_files",
"Warning"),msg:dgettext("plugin_files","You cannot delete the parent folder!"),icon:Zarafa.common.dialogs.MessageBox.WARNING,buttons:Zarafa.common.dialogs.MessageBox.OK})}});Ext.namespace("Zarafa.plugins.files.ui");
Zarafa.plugins.files.ui.FilesToolbar=Ext.extend(Ext.Toolbar,{constructor:function(a){a=a||{};a.plugins=Ext.value(a.plugins,[]);a.plugins.push("zarafa.recordcomponentupdaterplugin");Ext.applyIf(a,{items:[{xtype:"zarafa.filesuploadbutton",ref:"uploadbutton",plugins:["zarafa.recordcomponentupdaterplugin"],model:a.context.getModel(),overflowText:dgettext("plugin_files","Create something new")+"...",tooltip:{title:dgettext("plugin_files","New"),text:dgettext("plugin_files","Upload file / Create folder")},
iconCls:"icon_attachment"},{xtype:"zarafa.toolbarbutton",tooltip:{title:dgettext("plugin_files","Up"),text:dgettext("plugin_files","Go to parent directory")},overflowText:dgettext("plugin_files","Go to parent directory"),iconCls:"icon_up",handler:this.onMoveUp,model:a.context.getModel()},{xtype:"tbfill"},{xtype:"zarafa.toolbarbutton",tooltip:dgettext("plugin_files","Clear cache"),overflowText:dgettext("plugin_files","Clear cache"),iconCls:"icon_cache",hidden:!container.getSettingsModel().get("zarafa/v1/contexts/files/enable_caching"),
handler:this.onClearCache,model:a.context.getModel()},container.populateInsertionPoint("context.filescontext.toolbar.item",this),{xtype:"tbseparator"},{xtype:"tbtext",text:"Version: "+Zarafa.plugins.files.data.Version.getFilesVersion()}]});Zarafa.plugins.files.ui.FilesToolbar.superclass.constructor.call(this,a)},onClearCache:function(){Zarafa.plugins.files.data.Actions.clearCache()},onMoveUp:function(){var a=Zarafa.plugins.files.data.ComponentBox.getStore().getPath();if(a!=="/"){if(a.substring(a.length-
1)==="/")a=a.substring(0,a.length-1);a=a.substring(0,a.lastIndexOf("/")+1);Zarafa.plugins.files.data.ComponentBox.getStore().loadPath(a);Zarafa.plugins.files.data.Actions.reloadCurrentDir()}}});Ext.reg("zarafa.filestoolbar",Zarafa.plugins.files.ui.FilesToolbar);Ext.namespace("Zarafa.plugins.files.ui");
Zarafa.plugins.files.ui.FilesPreviewPanel=Ext.extend(Ext.Panel,{constructor:function(a){a=a||{};if(!Ext.isDefined(a.model)&&Ext.isDefined(a.context))a.model=a.context.getModel();var b=new Zarafa.plugins.files.ui.FilesPreviewPanelToolbarButtons({model:a.model});b=[container.populateInsertionPoint("filespreviewpanel.toolbar.left",this,a.model),{xtype:"tbfill"},b.getToolbarButtons(),container.populateInsertionPoint("filespreviewpanel.toolbar.right",this,a.model)];b=Ext.applyIf(a.tbar||{},{cls:"zarafa-previewpanel-toolbar",
xtype:"zarafa.toolbar",height:33,hidden:false,items:Ext.flatten(b)});Ext.applyIf(a,{xtype:"zarafa.filespreviewpanel",layout:"fit",stateful:true,cls:"zarafa-previewpanel zarafa-context-mainpanel",width:300,height:300,tbar:b});Zarafa.plugins.files.ui.FilesPreviewPanel.superclass.constructor.call(this,a)}});Ext.reg("zarafa.filespreviewpanel",Zarafa.plugins.files.ui.FilesPreviewPanel);Ext.namespace("Zarafa.plugins.files.ui");
Zarafa.plugins.files.ui.FilesFileGridColumnModel=Ext.extend(Zarafa.common.ui.grid.ColumnModel,{useCompactView:false,constructor:function(a){a=a||{};this.defaultColumns=this.createDefaultColumns();this.compactColumns=this.createCompactColumns();Ext.applyIf(a,{columns:this.defaultColumns,defaults:{sortable:true}});if(a.useCompactView===true)a.columns=this.compactColumns;Ext.apply(this,a);Zarafa.plugins.files.ui.FilesFileGridColumnModel.superclass.constructor.call(this,a)},createDefaultColumns:function(){return[{id:"type",
dataIndex:"type",header:'<p class="icon_index">&nbsp;</p>',headerCls:"zarafa-icon-column icon",renderer:Zarafa.plugins.files.data.Helper.Renderer.typeRenderer,width:24,fixed:true,tooltip:dgettext("plugin_files","Sort by: Type")},{header:"ID",dataIndex:"id",width:50,hidden:true,tooltip:dgettext("plugin_files","Sort by: ID")},{header:"Path",dataIndex:"path",width:100,hidden:true,tooltip:dgettext("plugin_files","Sort by: Path")},{header:dgettext("plugin_files","Filename"),dataIndex:"filename",width:160,
tooltip:dgettext("plugin_files","Sort by: Filename")},{header:dgettext("plugin_files","Last modified"),dataIndex:"lastmodified",width:160,renderer:Zarafa.plugins.files.data.Helper.Renderer.datetimeRenderer,tooltip:dgettext("plugin_files","Sort by: Last modified")},{header:dgettext("plugin_files","Size"),dataIndex:"message_size",css:"text-align:right;",width:80,renderer:Zarafa.plugins.files.data.Helper.Format.fileSizeList,tooltip:dgettext("plugin_files","Sort by: Size")}]},createCompactColumns:function(){return[{id:"column_type",
dataIndex:"type",header:'<p class="icon_index">&nbsp;</p>',headerCls:"zarafa-icon-column icon",renderer:Zarafa.plugins.files.data.Helper.Renderer.typeRenderer,width:24,fixed:true,tooltip:dgettext("plugin_files","Sort by: Type")},{header:dgettext("plugin_files","Filename"),dataIndex:"filename",width:160,tooltip:dgettext("plugin_files","Sort by: Filename")},{header:dgettext("plugin_files","Last modified"),dataIndex:"lastmodified",width:100,renderer:Zarafa.plugins.files.data.Helper.Renderer.datetimeRenderer,
tooltip:dgettext("plugin_files","Sort by: Last modified")},{header:dgettext("plugin_files","Size"),dataIndex:"message_size",css:"text-align:right;",width:80,hidden:true,renderer:Zarafa.plugins.files.data.Helper.Format.fileSizeList,tooltip:dgettext("plugin_files","Sort by: Size")}]},setCompactView:function(a){if(this.useCompactView!==a){if(this.useCompactView=a){this.name="compact";this.defaultColumns=this.config;this.columns=this.compactColumns}else{this.name="default";this.compactColumns=this.config;
this.columns=this.defaultColumns}this.setConfig(this.columns,false)}}});Ext.namespace("Zarafa.plugins.files.ui");
Zarafa.plugins.files.ui.FilesFileGridContextMenu=Ext.extend(Zarafa.core.ui.menu.ConditionalMenu,{context:undefined,model:undefined,grid:undefined,constructor:function(a){a=a||{};if(!Ext.isDefined(a.model)&&Ext.isDefined(a.context))a.model=a.context.getModel();Ext.applyIf(a,{items:[this.createContextActionItems(),{xtype:"menuseparator"},container.populateInsertionPoint("context.filescontext.contextmenu.actions",this),{xtype:"menuseparator"},container.populateInsertionPoint("context.filescontext.contextmenu.options",
this)]});Zarafa.plugins.files.ui.FilesFileGridContextMenu.superclass.constructor.call(this,a)},applyItemFilter:function(a,b,c,d){var e=true;if(b)if(!Ext.isDefined(a)||Ext.isArray(a)&&a.length!=1)e=false;if(c)for(b=0;b<a.length;b++){c=a[b];if(c.get("type")==Zarafa.plugins.files.data.FileTypes.FOLDER){e=false;break}}if(d)for(b=0;b<a.length;b++){c=a[b];if(c.get("id")===container.getSettingsModel().get("zarafa/v1/contexts/files/files_path")+"/"||c.get("filename")===".."){e=false;break}}return e},createContextActionItems:function(){return[{xtype:"zarafa.conditionalitem",
text:dgettext("plugin_files","Open"),iconCls:"icon_open",handler:this.onContextItemOpen,beforeShow:function(a,b){var c=this.applyItemFilter(b,false,true,false),d=this.applyItemFilter(b,true,false,false);a.setVisible(c||d)},scope:this},{xtype:"zarafa.conditionalitem",text:dgettext("plugin_files","Rename"),iconCls:"icon_rename",handler:this.onContextItemRename,beforeShow:function(a,b){a.setVisible(this.applyItemFilter(b,true,false,true))},scope:this},{xtype:"zarafa.conditionalitem",text:dgettext("plugin_files",
"Attach to mail"),iconCls:"icon_replyEmail",handler:this.onContextItemAttach,beforeShow:function(a,b){for(var c=this.applyItemFilter(b,false,true,true),d=container.getSettingsModel().get("zarafa/v1/main/attachments/max_attachment_size"),e=0;e<b.length;e++)if(b[e].get("message_size")>d){c=false;break}a.setVisible(c)},scope:this},{xtype:"zarafa.conditionalitem",text:dgettext("plugin_files","Delete"),iconCls:"icon_delete",handler:this.onContextItemDelete,beforeShow:function(a,b){a.setVisible(this.applyItemFilter(b,
false,false,true))},scope:this},{xtype:"zarafa.conditionalitem",text:dgettext("plugin_files","Info"),iconCls:"icon_info",disabled:Zarafa.plugins.files.data.ComponentBox.getContext().getCurrentViewMode()==Zarafa.plugins.files.data.ViewModes.NO_PREVIEW?false:true,handler:this.onContextItemInfo,beforeShow:function(a,b){a.setVisible(this.applyItemFilter(b,true,false,true))},scope:this}]},onContextItemOpen:function(){Zarafa.plugins.files.data.Actions.openFilesContent(this.records)},onContextItemDelete:function(){var a=
true;Ext.each(this.records,function(c){if(c.get("id")===container.getSettingsModel().get("zarafa/v1/contexts/files/files_path")+"/"||c.get("filename")==="..")a=false},this);var b=container.getSettingsModel().get("zarafa/v1/contexts/files/ask_before_delete");if(a)b?Ext.MessageBox.confirm(dgettext("plugin_files","Confirm deletion"),dgettext("plugin_files","Are you sure?"),this.doDelete,this):this.doDelete()},doDelete:function(a){if(!Ext.isDefined(a)||a==="yes"){Zarafa.plugins.files.data.ComponentBox.getStore().on("remove",
this.deleteDone,null,{single:true});Zarafa.common.Actions.deleteRecords(this.records)}},deleteDone:function(){container.getCurrentContext().getCurrentView()===Zarafa.plugins.files.data.Views.ICON?Zarafa.plugins.files.data.Actions.clearCache():Zarafa.plugins.files.data.Actions.refreshNavigatorTree()},onContextItemInfo:function(){var a=undefined;if(this.records.length==1)a=this.records[0];a=Ext.applyIf({},{modal:true,record:a});Zarafa.core.data.UIFactory.openLayerComponent(Zarafa.core.data.SharedComponentType["zarafa.plugins.files.fileinfopanel"],
undefined,a)},onContextItemRename:function(){Zarafa.plugins.files.data.Actions.openRenameDialog(this.model,this.records[0])},onContextItemAttach:function(){var a=container.getContextByName("mail").getModel().createRecord(),b=[],c=a.getAttachmentStore();Ext.each(this.records,function(e){b.push(e.get("id"))},this);container.getNotifier().notify("info.files",dgettext("plugin_files","Attaching"),dgettext("plugin_files","Creating email... Please wait!"));try{container.getRequest().singleRequest("filesmodule",
"download-to-tmp",{ids:b,dialog_attachments:c.getId()},new Zarafa.plugins.files.data.ResponseHandler({successCallback:this.attachToMail.createDelegate(this,[a],true)}))}catch(d){Zarafa.plugins.files.data.Actions.msgWarning(d.message)}},attachToMail:function(a,b,c){Zarafa.plugins.files.data.Actions.openCreateMailContent(c,a)}});Ext.reg("zarafa.filesfilegridcontextmenu",Zarafa.plugins.files.ui.FilesFileGridContextMenu);Ext.namespace("Zarafa.plugins.files.ui");
Zarafa.plugins.files.ui.FilesFileGrid=Ext.extend(Zarafa.common.ui.grid.GridPanel,{context:undefined,model:undefined,dropTarget:undefined,constructor:function(a){a=a||{};if(!Ext.isDefined(a.model)&&Ext.isDefined(a.context))a.model=a.context.getModel();if(!Ext.isDefined(a.store)&&Ext.isDefined(a.model))a.store=a.model.getStore();a.store=Ext.StoreMgr.lookup(a.store);Ext.applyIf(a,{xtype:"zarafa.filesfilegrid",ddGroup:"dd.filesrecord",id:"files-gridview",enableDragDrop:true,border:false,stateful:true,
statefulRelativeDimensions:false,loadMask:this.initLoadMask(),viewConfig:this.initViewConfig(),sm:this.initSelectionModel(),cm:this.initColumnModel(),keys:{key:Ext.EventObject.DELETE,handler:this.onKeyDelete,scope:this}});Zarafa.plugins.files.ui.FilesFileGrid.superclass.constructor.call(this,a)},initEvents:function(){Zarafa.mail.ui.MailGrid.superclass.initEvents.call(this);this.mon(this,"cellcontextmenu",this.onCellContextMenu,this);this.mon(this,"rowbodycontextmenu",this.onRowBodyContextMenu,this);
this.mon(this,"rowdblclick",this.onRowDblClick,this);this.mon(this,"afterrender",this.initDropTarget,this);this.mon(this.getSelectionModel(),"beforerowselect",this.onBeforeRowSelect,this,{buffer:1});this.mon(this.getSelectionModel(),"rowselect",this.onRowSelect,this,{buffer:1});this.mon(this.getSelectionModel(),"selectionchange",this.onSelectionChange,this,{buffer:1});this.mon(this.context,"viewmodechange",this.onContextViewModeChange,this);this.onContextViewModeChange(this.context,this.context.getCurrentViewMode())},
initLoadMask:function(){return{msg:dgettext("plugin_files","Loading files")+"..."}},initViewConfig:function(){return{enableRowBody:false,rowSelectorDepth:15}},initSelectionModel:function(){return new Ext.grid.RowSelectionModel},initColumnModel:function(){return new Zarafa.plugins.files.ui.FilesFileGridColumnModel},initDropTarget:function(){var a=this.getView().el.dom.childNodes[0].childNodes[1];a.addEventListener("dragstart",function(b){b.dataTransfer.effectAllowed="copy";b.preventDefault();b.stopPropagation()},
false);a.addEventListener("dragenter",function(b){b.preventDefault();b.stopPropagation()},false);a.addEventListener("dragover",function(b){b.dataTransfer.dropEffect="copy";b.preventDefault();b.stopPropagation()},false);a.addEventListener("dragleave",function(b){b.preventDefault();b.stopPropagation()},false);a.addEventListener("drop",function(b){b.preventDefault();b.stopPropagation();Zarafa.plugins.files.data.Actions.uploadItem(b.dataTransfer.files,Zarafa.plugins.files.data.ComponentBox.getStore());
return false},false);this.dropTarget=new Ext.dd.DropTarget(a,{ddGroup:"dd.filesrecord",copy:false,gridStore:this.getStore(),gridSM:this.getSelectionModel(),notifyDrop:function(b,c,d){b=b.getDragData(c).rowIndex;if(Ext.isDefined(b)&&this.gridStore.getAt(b).get("type")===Zarafa.plugins.files.data.FileTypes.FOLDER){Ext.each(d.selections,function(e){e.setDisabled(true)});return Zarafa.plugins.files.data.Actions.moveRecords(d.selections,this.gridStore.getAt(b))}else return false},notifyOver:function(b,
c){var d=b.getDragData(c).rowIndex;if(Ext.isDefined(d))if(this.gridStore.getAt(d).get("type")===Zarafa.plugins.files.data.FileTypes.FOLDER)return this.dropAllowed;return this.dropNotAllowed},notifyEnter:function(b,c){var d=b.getDragData(c).rowIndex;if(Ext.isDefined(d))if(this.gridStore.getAt(d).get("type")===Zarafa.plugins.files.data.FileTypes.FOLDER)return this.dropAllowed;return this.dropNotAllowed}});this.getView().dragZone.onBeforeDrag=function(b){return!b.grid.getStore().getAt(b.rowIndex).getDisabled()}},
onContextViewModeChange:function(a,b){var c=b===Zarafa.plugins.files.data.ViewModes.RIGHT_PREVIEW;this.getColumnModel().setCompactView(c)},onCellContextMenu:function(a,b,c,d){a=this.getSelectionModel();var e=this.getColumnModel();if(a.hasSelection()){if(!a.isSelected(b)){a.clearSelections();a.selectRow(b)}}else a.selectRow(b);b={};if(c>=0)b=e.getColumnById(e.getColumnId(c));c=a.getSelections();var f=true;Ext.each(c,function(g){if(g.getDisabled()===true)f=false});f&&Zarafa.core.data.UIFactory.openDefaultContextMenu(c,
{position:d.getXY(),context:this.context,grid:this})},onRowBodyContextMenu:function(a,b,c){this.onCellContextMenu(a,b,-1,c)},onRowDblClick:function(a,b){var c=a.store.getAt(b),d=Zarafa.plugins.files.data.ComponentBox.getNavigatorTreePanel();if(c.get("type")===Zarafa.plugins.files.data.FileTypes.FOLDER){this.store.loadPath(c.get("id"));c=d.getNodeById(c.get("id"));Ext.isDefined(c)&&!c.isLeaf()&&c.reload()}else Zarafa.plugins.files.data.Actions.downloadItem([c])},onKeyDelete:function(){var a=this.getSelectionModel().getSelections(),
b=true;if(!Ext.isEmpty(a)){Ext.each(a,function(d){if(d.get("id")===container.getSettingsModel().get("zarafa/v1/contexts/files/files_path")+"/"||d.get("filename")===".."||d.getDisabled()===true)b=false},this);var c=container.getSettingsModel().get("zarafa/v1/contexts/files/ask_before_delete");if(b)c?Ext.MessageBox.confirm("Confirm deletion","Are you sure?",this.doDelete.createDelegate(this,[a],true),this):this.doDelete("yes",null,null,a)}},doDelete:function(a,b,c,d){if(!Ext.isDefined(a)||a==="yes"){Zarafa.common.Actions.deleteRecords(d);
Zarafa.plugins.files.data.Actions.refreshNavigatorTree()}},onBeforeRowSelect:function(a,b,c,d){return!d.getDisabled()},onRowSelect:function(a,b,c){b=this.context.getCurrentViewMode();var d=a.getCount();if(b!=Zarafa.plugins.files.data.ViewModes.NO_PREVIEW)if(d==0)this.model.setPreviewRecord(undefined);else if(d==1&&a.getSelected()===c)c.get("id")!==container.getSettingsModel().get("zarafa/v1/contexts/files/files_path")+"/"&&c.get("filename")!==".."?this.model.setPreviewRecord(c):this.model.setPreviewRecord(undefined)},
onSelectionChange:function(a){a=a.getSelections();var b=this.context.getCurrentViewMode();this.model.setSelectedRecords(a);b!==Zarafa.plugins.files.data.ViewModes.NO_PREVIEW&&Ext.isEmpty(a)&&this.model.setPreviewRecord(undefined)}});Ext.reg("zarafa.filesfilegrid",Zarafa.plugins.files.ui.FilesFileGrid);Ext.namespace("Zarafa.plugins.files.ui");
Zarafa.plugins.files.ui.FilesIconView=Ext.extend(Zarafa.common.ui.DraggableDataView,{context:undefined,model:undefined,dropTarget:undefined,keyMap:undefined,constructor:function(a){a=a||{};if(!Ext.isDefined(a.model)&&Ext.isDefined(a.context))a.model=a.context.getModel();if(!Ext.isDefined(a.store)&&Ext.isDefined(a.model))a.store=a.model.getStore();a.store=Ext.StoreMgr.lookup(a.store);a.plugins=Ext.value(a.plugins,[]);a.plugins.push("zarafa.icondragselectorplugin");Ext.applyIf(a,{xtype:"zarafa.filesiconview",
cls:"zarafa-files-iconview",loadingText:dgettext("plugin_files","Loading files")+"...",deferEmptyText:false,autoScroll:true,emptyText:'<div class="emptytext">'+_("There are no items to show in this view")+"</div>",overClass:"zarafa-files-iconview-over",tpl:this.initTemplate(),multiSelect:true,selectedClass:"zarafa-files-iconview-selected",itemSelector:"div.zarafa-files-iconview-thumb",enableDragDrop:true,ddGroup:"dd.filesrecord"});Zarafa.plugins.files.ui.FilesIconView.superclass.constructor.call(this,
a);this.initEvents()},initTemplate:function(){return new Ext.XTemplate('<div style="height: 100%; width: 100%; overflow: auto;">','<tpl for=".">','<div class="zarafa-files-iconview-container {.:this.getHidden}">','<div class="zarafa-files-iconview-thumb {.:this.getTheme} {.:this.getHidden}">',"{.:this.getImage}","</div>",'<span class="zarafa-files-iconview-subject">{filename:htmlEncode}</span>',"</div>","</tpl>","</div>",{getHidden:function(a){if(a.filename==="..")return"files_type_hidden";return""},
getTheme:function(a){switch(a.type){case Zarafa.plugins.files.data.FileTypes.FOLDER:return Zarafa.plugins.files.data.Helper.File.getIconClass("folder");case Zarafa.plugins.files.data.FileTypes.FILE:return Zarafa.plugins.files.data.Helper.File.getIconClass(a.filename);default:return"files48icon_blank"}},getImage:function(a){var b=Zarafa.plugins.files.data.Helper.File.getExtension(a.filename).toLowerCase(),c=["jpg","gif","png","bmp"],d="",e="",f="";if(Ext.isEmpty(b)||c.indexOf(b)===-1)d="files_type_hidden ";
else{b=Zarafa.plugins.files.data.ComponentBox.getStore().getById(a.id);if(Ext.isDefined(b))e=b.getThumbnailImageUrl(40,50)}switch(a.type){case Zarafa.plugins.files.data.FileTypes.FOLDER:d="files_image files_type_hidden";break;case Zarafa.plugins.files.data.FileTypes.FILE:d+="files_image";break;default:d="files_image_hidden";break}Ext.isEmpty(e)||(f='<img class="'+d+'" src="'+e+'" />');return f}})},getMainPanel:function(){return this.ownerCt},initEvents:function(){this.on({contextmenu:this.onFilesIconContextMenu,
dblclick:this.onIconDblClick,selectionchange:this.onSelectionChange,afterrender:this.onAfterRender,scope:this})},onAfterRender:function(){this.keyMap=new Ext.KeyMap(this.getEl(),{key:Ext.EventObject.DELETE,fn:this.onKeyDelete.createDelegate(this)});this.initDropTarget()},onKeyDelete:function(){var a=this.getSelectedRecords(),b=true;if(!Ext.isEmpty(a)){Ext.each(a,function(d){if(d.get("id")===container.getSettingsModel().get("zarafa/v1/contexts/files/files_path")+"/"||d.get("filename")===".."||d.getDisabled()===
true)b=false},this);var c=container.getSettingsModel().get("zarafa/v1/contexts/files/ask_before_delete");if(b)c?Ext.MessageBox.confirm("Confirm deletion","Are you sure?",this.doDelete.createDelegate(this,[a],true),this):this.doDelete("yes",null,null,a)}},doDelete:function(a,b,c,d){if(!Ext.isDefined(a)||a==="yes"){Zarafa.common.Actions.deleteRecords(d);Zarafa.plugins.files.data.Actions.clearCache()}},initDropTarget:function(){var a=this.getEl();a.dom.addEventListener("dragstart",function(b){b.dataTransfer.effectAllowed=
"copy";b.preventDefault();b.stopPropagation()},false);a.dom.addEventListener("dragenter",function(b){b.preventDefault();b.stopPropagation()},false);a.dom.addEventListener("dragover",function(b){b.dataTransfer.dropEffect="copy";b.preventDefault();b.stopPropagation()},false);a.dom.addEventListener("dragleave",function(b){b.preventDefault();b.stopPropagation()},false);a.dom.addEventListener("drop",function(b){b.preventDefault();b.stopPropagation();Zarafa.plugins.files.data.Actions.uploadItem(b.dataTransfer.files,
Zarafa.plugins.files.data.ComponentBox.getStore());return false},false);this.dropTarget=new Ext.dd.DropTarget(a,{ddGroup:"dd.filesrecord",copy:false,fileStore:this.getStore(),notifyDrop:function(b,c,d){b=b.getDragData(c);if(Ext.isDefined(b)){b=b.index;if(Ext.isDefined(b)&&this.fileStore.getAt(b).get("type")===Zarafa.plugins.files.data.FileTypes.FOLDER){Ext.each(d.selections,function(e){e.setDisabled(true)});return Zarafa.plugins.files.data.Actions.moveRecords(d.selections,this.fileStore.getAt(b))}}return false},
notifyOver:function(b,c){var d=b.getDragData(c);if(Ext.isDefined(d)){d=d.index;if(Ext.isDefined(d))if(this.fileStore.getAt(d).get("type")===Zarafa.plugins.files.data.FileTypes.FOLDER)return this.dropAllowed}return this.dropNotAllowed},notifyEnter:function(b,c){var d=b.getDragData(c);if(Ext.isDefined(d)){d=d.index;if(Ext.isDefined(d))if(this.fileStore.getAt(d).get("type")===Zarafa.plugins.files.data.FileTypes.FOLDER)return this.dropAllowed}return this.dropNotAllowed}});this.dragZone.onBeforeDrag=function(b){return!this.view.getStore().getAt(b.index).getDisabled()}},
onFilesIconContextMenu:function(a,b,c,d){a.isSelected(c)||a.select(c);a=a.getSelectedRecords();var e=true;Ext.each(a,function(f){if(f.getDisabled()===true)e=false});e&&Zarafa.core.data.UIFactory.openDefaultContextMenu(a,{position:d.getXY(),context:this.context})},onIconDblClick:function(a,b){var c=this.getStore().getAt(b),d=Zarafa.plugins.files.data.ComponentBox.getNavigatorTreePanel();if(c.get("type")===Zarafa.plugins.files.data.FileTypes.FOLDER){this.store.loadPath(c.get("id"));c=d.getNodeById(c.get("id"));
Ext.isDefined(c)&&!c.isLeaf()&&c.reload()}else Zarafa.plugins.files.data.Actions.downloadItem([c])},onSelectionChange:function(a){this.model.setSelectedRecords(a.getSelectedRecords());var b=this.context.getCurrentViewMode();a=a.getSelectedRecords();var c=a.length;if(b!=Zarafa.plugins.files.data.ViewModes.NO_PREVIEW)if(c!=1)this.model.setPreviewRecord(undefined);else if(c==1)a[0].get("id")!==container.getSettingsModel().get("zarafa/v1/contexts/files/files_path")+"/"&&a[0].get("filename")!==".."?this.model.setPreviewRecord(a[0]):
this.model.setPreviewRecord(undefined)}});Ext.reg("zarafa.filesiconview",Zarafa.plugins.files.ui.FilesIconView);Ext.namespace("Zarafa.plugins.files.ui");
Zarafa.plugins.files.ui.FilesMainPanel=Ext.extend(Zarafa.common.ui.ContextMainPanel,{viewPanel:undefined,constructor:function(a){a=a||{};Ext.applyIf(a,{xtype:"zarafa.filesmainpanel",layout:"zarafa.switchborder",items:[this.initMainItems(a),this.initPreviewPanel(a.context)]});Zarafa.plugins.files.ui.FilesMainPanel.superclass.constructor.call(this,a)},initMainItems:function(a){return{xtype:"panel",ref:"filesViewPanel",layout:"zarafa.collapsible",cls:"zarafa-context-mainpanel",minWidth:200,minHeight:200,
region:"center",collapsible:false,split:true,items:[{xtype:"zarafa.switchviewcontentcontainer",ref:"../viewPanel",layout:"card",lazyItems:this.initViews(a.context)}],tbar:{xtype:"zarafa.filestoolbar",defaultTitle:dgettext("plugin_files","Files"),height:33,context:a.context}}},initViews:function(a){var b=[{xtype:"zarafa.filesfilegrid",flex:1,id:"files-gridview",anchor:"100%",context:a},{xtype:"zarafa.filesiconview",flex:1,id:"files-iconview",anchor:"100%",context:a}];a=container.populateInsertionPoint("context.files.views",
this,a);return b=b.concat(a)},initPreviewPanel:function(a){return{xtype:"zarafa.filespreviewpanel",ref:"filesPreview",region:"south",split:true,context:a}},initEvents:function(){if(Ext.isDefined(this.context)){this.mon(this.context,"viewchange",this.onViewChange,this);this.mon(this.context,"viewmodechange",this.onViewModeChange,this);this.onViewChange(this.context,this.context.getCurrentView());this.onViewModeChange(this.context,this.context.getCurrentViewMode())}},onViewChange:function(a,b){switch(b){case Zarafa.plugins.files.data.Views.LIST:this.viewPanel.switchView("files-gridview");
break;case Zarafa.plugins.files.data.Views.ICON:this.viewPanel.switchView("files-iconview");break}},onViewModeChange:function(a,b){var c;switch(b){case Zarafa.plugins.files.data.ViewModes.NO_PREVIEW:c=Zarafa.common.ui.layout.SwitchBorderLayout.Orientation.OFF;break;case Zarafa.plugins.files.data.ViewModes.RIGHT_PREVIEW:c=Zarafa.common.ui.layout.SwitchBorderLayout.Orientation.HORIZONTAL;break;case Zarafa.plugins.files.data.ViewModes.BOTTOM_PREVIEW:c=Zarafa.common.ui.layout.SwitchBorderLayout.Orientation.VERTICAL;
break;case Zarafa.plugins.files.data.ViewModes.SEARCH:return}var d=this.getLayout();if(Ext.isFunction(d.setOrientation))d.setOrientation(c);else if(Ext.isString(d))this.layoutConfig=Ext.apply(this.layoutConfig||{},{orientation:c});else this.layout.orientation=c}});Ext.reg("zarafa.filesmainpanel",Zarafa.plugins.files.ui.FilesMainPanel);
Ext.tree.TreeNodeUI.prototype.updateExpandIcon=Ext.tree.TreeNodeUI.prototype.updateExpandIcon.createSequence(function(){if(this.node.attributes.isFolder&&this.wasLeaf){this.removeClass("x-tree-node-leaf");this.addClass("x-tree-node-collapsed");this.c1="x-tree-node-expanded";this.c2="x-tree-node-collapsed";this.wasLeaf=false}});
Ext.tree.TreeNodeUI.prototype.ecClick=Ext.tree.TreeNodeUI.prototype.ecClick.createSequence(function(){var a=this.node;if(a.ownerTree instanceof Zarafa.plugins.files.ui.NavigatorTreePanel)a.isLoaded()||Ext.get(this.iconNode).removeClass("icon_folder_note")});Ext.namespace("Zarafa.plugins.files.ui");
Zarafa.plugins.files.ui.QuotaBar=Ext.extend(Ext.BoxComponent,{storeSize:undefined,warnQuota:undefined,hardQuota:undefined,quotaTemplate:'<div class="zarafa-quotabar"><div class="zarafa-quotabar-normal"></div><div class="zarafa-quotabar-warn"></div><div class="zarafa-quotabar-hard"></div></div>',constructor:function(a){a=a||{};Zarafa.plugins.files.ui.QuotaBar.superclass.constructor.call(this,a);this.quotaTemplate=new Ext.XTemplate(this.quotaTemplate,{compiled:true});this.on("afterrender",this.onQuotaBarRender,
this)},onQuotaBarRender:function(){this.quotaTemplate.overwrite(Ext.get(this.el));this.updateQuotaBar()},setStoreSize:function(a){this.storeSize=a},setWarnQuota:function(a){this.warnQuota=a},setHardQuota:function(a){this.hardQuota=a},updateQuotaBar:function(){if(this.el&&this.el.child("div.zarafa-quotabar"))if(this.hardQuota){if(!this.warnQuota)this.warnQuota=this.hardQuota-102400;var a=[];if(this.warnQuota&&(!this.hardQuota||this.warnQuota<this.hardQuota))a.push({size:this.warnQuota,element:"div.zarafa-quotabar-warn"});
this.hardQuota&&a.push({size:this.hardQuota,element:"div.zarafa-quotabar-hard"});var b=this.hardQuota||this.warnQuota;if(this.storeSize>b){b=this.storeSize;a.push({size:this.storeSize})}var c=this.el.child("div.zarafa-quotabar").getWidth(true);b=c/b;for(var d,e=0,f="div.zarafa-quotabar-normal",g=0;g<a.length;g++){d=a[g].size;if(this.storeSize<=d){d=this.storeSize;this.storeSize=0}d-=e;e+=d;if(f){d=Math.round(d*b);d=Math.max(d,0);if(c<d)d=c;this.el.child(f).setWidth(d);c-=d}(f=a[g].element)&&this.el.child(f).setWidth(0)}}}});
Ext.reg("zarafa.plugins.files.quotabar",Zarafa.plugins.files.ui.QuotaBar);Ext.namespace("Zarafa.plugins.files.context");
Zarafa.plugins.files.context.FilesContextModel=Ext.extend(Zarafa.core.ContextModel,{constructor:function(a){a=a||{};if(!Ext.isDefined(a.store))a.store=new Zarafa.plugins.files.data.FilesStore;Zarafa.plugins.files.context.FilesContextModel.superclass.constructor.call(this,a)},createRecord:function(a){a=a||"root";return Zarafa.core.data.RecordFactory.createRecordObjectByMessageClass("IPM.Files",{store_entryid:"files",parent_entryid:a})},setPreviewRecord:function(a,b){if(container.getCurrentContext().getName()===
"filescontext"){var c=Zarafa.plugins.files.data.ComponentBox.getPreviewPanel(),d;if(b&&this.previewRecord){d=container.getSharedComponent(Zarafa.core.data.SharedComponentType["common.preview"],this.previewRecord);c.removeAll();if(Ext.isDefined(d)){c.add(new d);c.doLayout();c.fileinfo.update(this.previewRecord)}}else if(this.previewRecord!==a){this.previewRecord=a;if(Ext.isDefined(a)){d=container.getSharedComponent(Zarafa.core.data.SharedComponentType["common.preview"],a);if(Ext.isDefined(d)&&c.fileinfo instanceof
d)c.fileinfo.update(a);else{c.removeAll();if(d){c.add(new d);c.doLayout();c.fileinfo.update(a)}}}}}},getDefaultFolder:function(){var a=container.getSettingsModel().get("zarafa/v1/contexts/files/iconid"),b=container.getSettingsModel().get("zarafa/v1/plugins/files/button_name");return{get:function(c){if(c=="icon_index")return a},getDisplayName:function(){return b+" - "+dgettext("plugin_files","Files")},getFullyQualifiedDisplayName:function(){return b+" - "+dgettext("plugin_files","Files")},getParentFolder:function(){},
set:function(){}}}});Ext.namespace("Zarafa.plugins.files.context");
Zarafa.plugins.files.context.FilesContext=Ext.extend(Zarafa.core.Context,{oldView:undefined,oldViewMode:undefined,constructor:function(a){a=a||{};Ext.applyIf(a,{current_view:Zarafa.plugins.files.data.Views.LIST,current_view_mode:Zarafa.plugins.files.data.ViewModes.RIGHT_PREVIEW});this.registerModules();this.registerInsertionPoint("main.maintabbar.left",this.createMainTab,this);this.registerInsertionPoint("main.maintoolbar.new.item",this.createNewFilesButton,this);this.registerInsertionPoint("main.toolbar.actions.last",
this.createMainToolbarButtons,this);this.registerInsertionPoint("navigation.center",this.createFilesNavigationPanel,this);this.registerInsertionPoint("context.addressbook.contextmenu.actions",this.createSendEmailContextItem,this);this.registerInsertionPoint("context.contact.contextmenu.actions",this.createSendEmailContextItem,this);this.registerInsertionPoint("context.contact.contactcontentpanel.toolbar.actions",this.createSendEmailButton,this);this.registerInsertionPoint("context.contact.distlistcontentpanel.toolbar.actions",
this.createSendEmailButton,this);Zarafa.plugins.files.context.FilesContext.superclass.constructor.call(this,a);Zarafa.core.data.SharedComponentType.addProperty("zarafa.plugins.files.uploadpanel");Zarafa.core.data.SharedComponentType.addProperty("zarafa.plugins.files.attachdialog");Zarafa.core.data.SharedComponentType.addProperty("zarafa.plugins.files.fileinfopanel")},getModel:function(){if(!Ext.isDefined(this.model))this.model=new Zarafa.plugins.files.context.FilesContextModel;return this.model},
bid:function(a){if(a.isContainerClass("IPF.Files",true))return 1;return-1},bidSharedComponent:function(a,b){var c=-1;if(Ext.isArray(b))b=b[0];switch(a){case Zarafa.core.data.SharedComponentType["zarafa.plugins.files.uploadpanel"]:case Zarafa.core.data.SharedComponentType["zarafa.plugins.files.attachdialog"]:case Zarafa.core.data.SharedComponentType["zarafa.plugins.files.fileinfopanel"]:c=1;break;case Zarafa.core.data.SharedComponentType["common.create"]:case Zarafa.core.data.SharedComponentType["common.view"]:case Zarafa.core.data.SharedComponentType["common.preview"]:if(b instanceof
Zarafa.core.data.IPMRecord&&b.isMessageClass("IPM.Files",true))c=1;break;case Zarafa.core.data.SharedComponentType["common.contextmenu"]:if(b instanceof Zarafa.core.data.IPMRecord&&b.isMessageClass("IPM.Files",true))c=1;break;default:break}return c},getSharedComponent:function(a){var b;switch(a){case Zarafa.core.data.SharedComponentType["zarafa.plugins.files.uploadpanel"]:b=Zarafa.plugins.files.ui.UploadPanel;break;case Zarafa.core.data.SharedComponentType["zarafa.plugins.files.attachdialog"]:b=Zarafa.plugins.files.dialogs.AttachFromFilesContentPanel;
break;case Zarafa.core.data.SharedComponentType["zarafa.plugins.files.fileinfopanel"]:b=Zarafa.plugins.files.dialogs.ShowFilesFileContentPanel;break;case Zarafa.core.data.SharedComponentType["common.create"]:b=Zarafa.plugins.files.dialogs.FilesUploadContentPanel;break;case Zarafa.core.data.SharedComponentType["common.view"]:b=Zarafa.plugins.files.ui.FilesViewPanel;break;case Zarafa.core.data.SharedComponentType["common.preview"]:b=Zarafa.plugins.files.ui.FilesViewPanel;break;case Zarafa.core.data.SharedComponentType["common.contextmenu"]:b=
Zarafa.plugins.files.ui.FilesFileGridContextMenu;break}return b},createFilesNavigationPanel:function(){return{xtype:"zarafa.contextnavigation",context:this,items:[{xtype:"panel",cls:"zarafa-context-navigation-block",title:container.getSettingsModel().get("zarafa/v1/plugins/files/button_name"),items:[{xtype:"zarafa.filestreepanel",ref:"../../../filesTreepanel"}]}]}},createContentPanel:function(){return{xtype:"zarafa.filesmainpanel",context:this}},createNewFilesButton:function(){return{xtype:"menuitem",
text:dgettext("plugin_files","Upload file"),iconCls:"icon_files_category",newMenuIndex:6,context:this.getName(),handler:function(){Zarafa.plugins.files.data.Actions.openCreateFilesContent(this.getModel())},scope:this}},createSendEmailContextItem:function(){return{text:dgettext("plugin_files","Send file"),iconCls:"icon_attachment",scope:this,handler:function(a){Zarafa.plugins.files.data.Actions.openCreateMailContentForContacts(this.getModel(),a.parentMenu.records)},beforeShow:function(a,b){for(var c=
false,d=0,e=b.length;d<e;d++)if(this.isSendEmailButtonVisible(b[d])){c=true;break}a.setVisible(c)}}},createSendEmailButton:function(){return{xtype:"button",plugins:["zarafa.recordcomponentupdaterplugin"],iconCls:"icon_attachment",overflowText:dgettext("plugin_files","Send file"),tooltip:{title:dgettext("plugin_files","Send file"),text:dgettext("plugin_files","Create a new email message with some files attached.")},handler:function(a){Zarafa.plugins.files.data.Actions.openCreateMailContentForContacts(this.getModel(),
a.record)},scope:this,update:function(a,b){this.record=a;if(b)this.scope.isSendEmailButtonVisible(a)||this.hide()}}},isSendEmailButtonVisible:function(a){if(a.phantom)return false;else if(a.isMessageClass("IPM.Contact"))if(!a.hasEmailAddress())return false;return true},getMainToolbarViewButtons:function(){var a=container.populateInsertionPoint("main.maintoolbar.view.files",this)||[],b=[{overflowText:dgettext("plugin_files","No preview"),iconCls:"icon_previewpanel_off",text:dgettext("plugin_files",
"No preview"),valueViewMode:Zarafa.plugins.files.data.ViewModes.NO_PREVIEW,valueDataMode:Zarafa.plugins.files.data.DataModes.ALL,handler:this.onContextSelectView,scope:this},{overflowText:dgettext("plugin_files","Right preview"),iconCls:"icon_previewpanel_right",text:dgettext("plugin_files","Right preview"),valueViewMode:Zarafa.plugins.files.data.ViewModes.RIGHT_PREVIEW,valueDataMode:Zarafa.plugins.files.data.DataModes.ALL,handler:this.onContextSelectView,scope:this},{overflowText:dgettext("plugin_files",
"Bottom preview"),iconCls:"icon_previewpanel_bottom",text:dgettext("plugin_files","Bottom preview"),valueViewMode:Zarafa.plugins.files.data.ViewModes.BOTTOM_PREVIEW,valueDataMode:Zarafa.plugins.files.data.DataModes.ALL,handler:this.onContextSelectView,scope:this}];b.push();return b.concat(a)},createMainToolbarButtons:function(){return[{xtype:"splitbutton",tooltip:dgettext("plugin_files","Switch view"),scale:"large",iconCls:"icon_viewswitch",handler:function(){this.showMenu()},listeners:{afterrender:this.onAfterRenderMainToolbarButtons,
scope:this},menu:new Ext.menu.Menu({items:[{text:dgettext("plugin_files","List"),overflowText:dgettext("plugin_files","List"),tooltip:dgettext("plugin_files","List"),iconCls:"icon_contact_list",valueView:Zarafa.plugins.files.data.Views.LIST,handler:this.onSwitchView,scope:this},{text:dgettext("plugin_files","Icons"),overflowText:dgettext("plugin_files","Icons"),tooltip:dgettext("plugin_files","Icons"),iconCls:"icon_note_icon_view",valueView:Zarafa.plugins.files.data.Views.ICON,handler:this.onSwitchView,
scope:this}]})}]},onAfterRenderMainToolbarButtons:function(a){a.mon(container,"contextswitch",function(b,c,d){this.setVisiblityMainToolbarButton(a,d)},this);a.mon(this,"viewchange",function(b){this.setVisiblityMainToolbarButton(a,b)},this);this.setVisiblityMainToolbarButton(a)},setVisiblityMainToolbarButton:function(a,b){b=b||container.getCurrentContext();b===this?a.show():a.hide()},onSwitchView:function(a){var b=this.getCurrentViewMode();this.switchView(a.valueView,b)},onContextSelectView:function(a){this.getModel().setDataMode(a.valueDataMode);
var b=a.valueView,c=a.valueViewMode;Ext.isDefined(a.valueView)||(b=this.getCurrentView());Ext.isDefined(a.valueViewMode)||(c=this.getCurrentViewMode());this.switchView(b,c);this.getModel().setPreviewRecord(undefined,true)},createMainTab:function(){return{text:this.getDisplayName(),tabOrderIndex:7,context:this.getName()}},registerModules:function(){Zarafa.core.ModuleNames["IPM.FILES"]={list:"filesbrowsermodule",item:"filesbrowsermodule"}}});
Zarafa.onReady(function(){Ext.isDefined(container.getSettingsModel().get("zarafa/v1/plugins/files/button_name"))&&container.getSettingsModel().get("zarafa/v1/plugins/files/enable")===true&&container.getSettingsModel().get("zarafa/v1/plugins/filescontext/enable")===true&&container.registerContext(new Zarafa.core.ContextMetaData({name:"filescontext",displayName:container.getSettingsModel().get("zarafa/v1/plugins/files/button_name"),allowUserVisible:false,pluginConstructor:Zarafa.plugins.files.context.FilesContext}))});
Ext.namespace("Zarafa.plugins.files");
Zarafa.plugins.files.FilesPlugin=Ext.extend(Zarafa.core.Plugin,{constructor:function(a){a=a||{};Zarafa.plugins.files.FilesPlugin.superclass.constructor.call(this,a)},initPlugin:function(){Zarafa.plugins.files.FilesPlugin.superclass.initPlugin.apply(this,arguments);Zarafa.plugins.files.data.Version.init();Zarafa.plugins.files.data.Dynamics.init();this.registerInsertionPoint("context.settings.categories",this.createSettingCategories,this);container.getSettingsModel().get("zarafa/v1/contexts/files/username")=="defaultusername"&&
container.getSettingsModel().set("zarafa/v1/contexts/files/username",container.getUser().getUserName());var a=Zarafa.core.mapi.IconIndex.addProperty("files");container.getSettingsModel().set("zarafa/v1/contexts/files/iconid",a);this.updateSesion()},createSettingCategories:function(){return{xtype:"Zarafa.plugins.files.settingsfilescategory"}},updateSesion:function(){container.getRequest().singleRequest("filesmodule","updatesession",{},null)}});
Zarafa.onReady(function(){Ext.isDefined(container.getSettingsModel().get("zarafa/v1/plugins/files/button_name"))&&container.registerPlugin(new Zarafa.core.PluginMetaData({name:"files",displayName:String.format(dgettext("plugin_files","{0} Plugin"),container.getSettingsModel().get("zarafa/v1/plugins/files/button_name")),about:Zarafa.plugins.files.ABOUT,allowUserDisable:true,pluginConstructor:Zarafa.plugins.files.FilesPlugin}))});
