/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.PlatformUtil;
import com.sun.javafx.css.StyleConverter;
import com.sun.javafx.css.StyleableBooleanProperty;
import com.sun.javafx.css.StyleableObjectProperty;
import com.sun.javafx.css.StyleableProperty;
import com.sun.javafx.css.converters.BooleanConverter;
import com.sun.javafx.css.converters.PaintConverter;
import com.sun.javafx.scene.control.behavior.TextInputControlBehavior;
import com.sun.javafx.scene.control.skin.FXVK;
import com.sun.javafx.scene.control.skin.SkinBase;
import com.sun.javafx.scene.control.skin.resources.ControlResources;
import com.sun.javafx.tk.FontMetrics;
import com.sun.javafx.tk.Toolkit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableObjectValue;
import javafx.beans.value.WritableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.IndexRange;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TextInputControl;
import javafx.scene.input.Clipboard;
import javafx.scene.input.InputMethodEvent;
import javafx.scene.input.InputMethodHighlight;
import javafx.scene.input.InputMethodRequests;
import javafx.scene.input.InputMethodTextRun;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.HLineTo;
import javafx.scene.shape.Line;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.Shape;
import javafx.scene.shape.VLineTo;
import javafx.scene.text.Font;
import javafx.stage.Window;
import javafx.util.Duration;

public abstract class TextInputControlSkin<T extends TextInputControl, B extends TextInputControlBehavior<T>>
extends SkinBase<T, B> {
    private static final boolean macOS = PlatformUtil.isMac();
    protected final ObjectProperty<Font> font = new StyleableObjectProperty<Font>(Font.getDefault()){

        @Override
        public Object getBean() {
            return TextInputControlSkin.this;
        }

        @Override
        public String getName() {
            return "font";
        }

        @Override
        public StyleableProperty getStyleableProperty() {
            return StyleableProperties.FONT;
        }
    };
    protected final ObservableObjectValue<FontMetrics> fontMetrics = new ObjectBinding<FontMetrics>(){
        {
            this.bind(TextInputControlSkin.this.font);
        }

        @Override
        protected FontMetrics computeValue() {
            TextInputControlSkin.this.invalidateMetrics();
            return Toolkit.getToolkit().getFontLoader().getFontMetrics((Font)TextInputControlSkin.this.font.get());
        }
    };
    protected final ObjectProperty<Paint> textFill = new StyleableObjectProperty<Paint>((Paint)Color.BLACK){

        @Override
        public Object getBean() {
            return TextInputControlSkin.this;
        }

        @Override
        public String getName() {
            return "textFill";
        }

        @Override
        public StyleableProperty getStyleableProperty() {
            return StyleableProperties.TEXT_FILL;
        }
    };
    protected final ObjectProperty<Paint> promptTextFill = new StyleableObjectProperty<Paint>((Paint)Color.GRAY){

        @Override
        public Object getBean() {
            return TextInputControlSkin.this;
        }

        @Override
        public String getName() {
            return "promptTextFill";
        }

        @Override
        public StyleableProperty getStyleableProperty() {
            return StyleableProperties.PROMPT_TEXT_FILL;
        }
    };
    protected final ObjectProperty<Paint> highlightFill = new StyleableObjectProperty<Paint>((Paint)Color.DODGERBLUE){

        @Override
        public Object getBean() {
            return TextInputControlSkin.this;
        }

        @Override
        public String getName() {
            return "highlightFill";
        }

        @Override
        public StyleableProperty getStyleableProperty() {
            return StyleableProperties.HIGHLIGHT_FILL;
        }
    };
    protected final ObjectProperty<Paint> highlightTextFill = new StyleableObjectProperty<Paint>((Paint)Color.WHITE){

        @Override
        public Object getBean() {
            return TextInputControlSkin.this;
        }

        @Override
        public String getName() {
            return "highlightTextFill";
        }

        @Override
        public StyleableProperty getStyleableProperty() {
            return StyleableProperties.HIGHLIGHT_TEXT_FILL;
        }
    };
    protected final BooleanProperty displayCaret = new StyleableBooleanProperty(true){

        @Override
        public Object getBean() {
            return TextInputControlSkin.this;
        }

        @Override
        public String getName() {
            return "displayCaret";
        }

        @Override
        public StyleableProperty getStyleableProperty() {
            return StyleableProperties.DISPLAY_CARET;
        }
    };
    private BooleanProperty blink = new SimpleBooleanProperty(this, "blink", true);
    protected ObservableBooleanValue caretVisible;
    private Timeline caretTimeline = new Timeline();
    protected final Path caretPath = new Path();
    protected StackPane caretHandle = null;
    protected StackPane selectionHandle1 = null;
    protected StackPane selectionHandle2 = null;
    private static boolean useFXVK = PlatformUtil.isEmbedded();
    static int vkType = -1;
    private int imstart;
    private int imlength;
    private List<Shape> imattrs = new ArrayList<Shape>();
    final MenuItem undoMI = new ContextMenuItem("Undo");
    final MenuItem redoMI = new ContextMenuItem("Redo");
    final MenuItem cutMI = new ContextMenuItem("Cut");
    final MenuItem copyMI = new ContextMenuItem("Copy");
    final MenuItem pasteMI = new ContextMenuItem("Paste");
    final MenuItem deleteMI = new ContextMenuItem("DeleteSelection");
    final MenuItem selectWordMI = new ContextMenuItem("SelectWord");
    final MenuItem selectAllMI = new ContextMenuItem("SelectAll");
    final MenuItem separatorMI = new SeparatorMenuItem();

    public Point2D getMenuPosition() {
        if (PlatformUtil.isEmbedded()) {
            if (this.caretHandle.isVisible()) {
                return new Point2D(this.caretHandle.getLayoutX() + this.caretHandle.getWidth() / 2.0, this.caretHandle.getLayoutY());
            }
            if (this.selectionHandle1.isVisible() && this.selectionHandle2.isVisible()) {
                return new Point2D((this.selectionHandle1.getLayoutX() + this.selectionHandle1.getWidth() / 2.0 + this.selectionHandle2.getLayoutX() + this.selectionHandle2.getWidth() / 2.0) / 2.0, this.selectionHandle2.getLayoutY() + this.selectionHandle2.getHeight() / 2.0);
            }
            return null;
        }
        throw new UnsupportedOperationException();
    }

    public void toggleUseVK() {
        if (++vkType < 4) {
            useFXVK = true;
            ((TextInputControl)this.getSkinnable()).getProperties().put("vkType", FXVK.VK_TYPE_NAMES[vkType]);
            FXVK.attach((Node)((Object)this.getSkinnable()));
        } else {
            FXVK.detach();
            vkType = -1;
            useFXVK = false;
        }
    }

    public TextInputControlSkin(T t, B b) {
        super(t, b);
        this.caretTimeline.setCycleCount(-1);
        this.caretTimeline.getKeyFrames().addAll((KeyFrame[])new KeyFrame[]{new KeyFrame(Duration.ZERO, new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent actionEvent) {
                TextInputControlSkin.this.blink.set(false);
            }
        }, new KeyValue[0]), new KeyFrame(Duration.seconds(0.5), new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent actionEvent) {
                TextInputControlSkin.this.blink.set(true);
            }
        }, new KeyValue[0]), new KeyFrame(Duration.seconds(1.0), new KeyValue[0])});
        this.caretVisible = new BooleanBinding((TextInputControl)t){
            final /* synthetic */ TextInputControl val$textInput;
            {
                this.val$textInput = textInputControl;
                this.bind(this.val$textInput.focusedProperty(), this.val$textInput.anchorProperty(), this.val$textInput.caretPositionProperty(), this.val$textInput.disabledProperty(), this.val$textInput.editableProperty(), TextInputControlSkin.this.displayCaret, TextInputControlSkin.this.blink);
            }

            @Override
            protected boolean computeValue() {
                return !TextInputControlSkin.this.blink.get() && TextInputControlSkin.this.displayCaret.get() && this.val$textInput.isFocused() && (PlatformUtil.isWindows() || this.val$textInput.getCaretPosition() == this.val$textInput.getAnchor()) && !this.val$textInput.isDisabled() && this.val$textInput.isEditable();
            }
        };
        if (PlatformUtil.isEmbedded()) {
            this.caretHandle = new StackPane();
            this.selectionHandle1 = new StackPane();
            this.selectionHandle2 = new StackPane();
            this.caretHandle.setManaged(false);
            this.selectionHandle1.setManaged(false);
            this.selectionHandle2.setManaged(false);
            this.caretHandle.visibleProperty().bind(new BooleanBinding((TextInputControl)t){
                final /* synthetic */ TextInputControl val$textInput;
                {
                    this.val$textInput = textInputControl;
                    this.bind(this.val$textInput.focusedProperty(), this.val$textInput.anchorProperty(), this.val$textInput.caretPositionProperty(), this.val$textInput.disabledProperty(), this.val$textInput.editableProperty(), this.val$textInput.lengthProperty(), TextInputControlSkin.this.displayCaret);
                }

                @Override
                protected boolean computeValue() {
                    return TextInputControlSkin.this.displayCaret.get() && this.val$textInput.isFocused() && this.val$textInput.getCaretPosition() == this.val$textInput.getAnchor() && !this.val$textInput.isDisabled() && this.val$textInput.isEditable() && this.val$textInput.getLength() > 0;
                }
            });
            this.selectionHandle1.visibleProperty().bind(new BooleanBinding((TextInputControl)t){
                final /* synthetic */ TextInputControl val$textInput;
                {
                    this.val$textInput = textInputControl;
                    this.bind(this.val$textInput.focusedProperty(), this.val$textInput.anchorProperty(), this.val$textInput.caretPositionProperty(), this.val$textInput.disabledProperty(), TextInputControlSkin.this.displayCaret);
                }

                @Override
                protected boolean computeValue() {
                    return TextInputControlSkin.this.displayCaret.get() && this.val$textInput.isFocused() && this.val$textInput.getCaretPosition() != this.val$textInput.getAnchor() && !this.val$textInput.isDisabled();
                }
            });
            this.selectionHandle2.visibleProperty().bind(new BooleanBinding((TextInputControl)t){
                final /* synthetic */ TextInputControl val$textInput;
                {
                    this.val$textInput = textInputControl;
                    this.bind(this.val$textInput.focusedProperty(), this.val$textInput.anchorProperty(), this.val$textInput.caretPositionProperty(), this.val$textInput.disabledProperty(), TextInputControlSkin.this.displayCaret);
                }

                @Override
                protected boolean computeValue() {
                    return TextInputControlSkin.this.displayCaret.get() && this.val$textInput.isFocused() && this.val$textInput.getCaretPosition() != this.val$textInput.getAnchor() && !this.val$textInput.isDisabled();
                }
            });
            this.caretHandle.getStyleClass().setAll((String[])new String[]{"caret-handle"});
            this.selectionHandle1.getStyleClass().setAll((String[])new String[]{"selection-handle"});
            this.selectionHandle2.getStyleClass().setAll((String[])new String[]{"selection-handle"});
            this.selectionHandle1.setId("selection-handle-1");
            this.selectionHandle2.setId("selection-handle-2");
            ((Node)t).focusedProperty().addListener(new InvalidationListener((TextInputControl)t){
                final /* synthetic */ TextInputControl val$textInput;
                {
                    this.val$textInput = textInputControl;
                }

                @Override
                public void invalidated(Observable observable) {
                    if (useFXVK) {
                        if (this.val$textInput.isEditable() && this.val$textInput.isFocused()) {
                            FXVK.attach(this.val$textInput);
                        } else if (!(TextInputControlSkin.this.getScene() != null && TextInputControlSkin.this.getScene().getWindow() != null && TextInputControlSkin.this.getScene().getWindow().isFocused() && TextInputControlSkin.this.getScene().getFocusOwner() instanceof TextInputControl && ((TextInputControl)TextInputControlSkin.this.getScene().getFocusOwner()).isEditable())) {
                            FXVK.detach();
                        }
                    }
                }
            });
        }
        if (((Node)t).getOnInputMethodTextChanged() == null) {
            ((Node)t).setOnInputMethodTextChanged((EventHandler<InputMethodEvent>)new EventHandler<InputMethodEvent>(){

                @Override
                public void handle(InputMethodEvent inputMethodEvent) {
                    TextInputControlSkin.this.handleInputMethodEvent(inputMethodEvent);
                }
            });
        }
        ((Node)t).setInputMethodRequests(new InputMethodRequests(){

            @Override
            public Point2D getTextLocation(int n) {
                Scene scene = TextInputControlSkin.this.getScene();
                Window window = scene.getWindow();
                Rectangle2D rectangle2D = TextInputControlSkin.this.getCharacterBounds(TextInputControlSkin.this.imstart + n);
                Point2D point2D = TextInputControlSkin.this.localToScene(rectangle2D.getMinX(), rectangle2D.getMaxY());
                Point2D point2D2 = new Point2D(window.getX() + scene.getX() + point2D.getX() - 6.0, window.getY() + scene.getY() + point2D.getY() - 42.0);
                return point2D2;
            }

            @Override
            public int getLocationOffset(int n, int n2) {
                return TextInputControlSkin.this.getInsertionPoint(n, n2);
            }

            @Override
            public void cancelLatestCommittedText() {
            }

            @Override
            public String getSelectedText() {
                TextInputControl textInputControl = (TextInputControl)TextInputControlSkin.this.getSkinnable();
                IndexRange indexRange = textInputControl.getSelection();
                return textInputControl.getText(indexRange.getStart(), indexRange.getEnd());
            }
        });
    }

    @Override
    public void dispose() {
        this.caretTimeline.stop();
        this.caretTimeline = null;
    }

    protected String maskText(String string) {
        return string;
    }

    public char getCharacter(int n) {
        return '\u0000';
    }

    public int getInsertionPoint(double d, double d2) {
        return 0;
    }

    public Rectangle2D getCharacterBounds(int n) {
        return null;
    }

    public double getLineHeight() {
        return this.fontMetrics.get().getLineHeight();
    }

    public void scrollCharacterToVisible(int n) {
    }

    protected void invalidateMetrics() {
    }

    protected void updateTextFill() {
    }

    protected void updateHighlightFill() {
    }

    protected void updateHighlightTextFill() {
    }

    protected void handleInputMethodEvent(InputMethodEvent inputMethodEvent) {
        TextInputControl textInputControl = (TextInputControl)this.getSkinnable();
        if (textInputControl.isEditable() && !textInputControl.textProperty().isBound() && !textInputControl.isDisabled()) {
            CharSequence charSequence;
            if (this.imlength != 0) {
                this.removeHighlight(this.imattrs);
                this.imattrs.clear();
                textInputControl.selectRange(this.imstart, this.imstart + this.imlength);
            }
            if (inputMethodEvent.getCommitted().length() != 0) {
                charSequence = inputMethodEvent.getCommitted();
                textInputControl.replaceText(textInputControl.getSelection(), (String)charSequence);
            }
            this.imstart = textInputControl.getSelection().getStart();
            charSequence = new StringBuilder();
            for (InputMethodTextRun object : inputMethodEvent.getComposed()) {
                ((StringBuilder)charSequence).append(object.getText());
            }
            this.imlength = ((StringBuilder)charSequence).length();
            if (this.imlength != 0) {
                textInputControl.replaceText(textInputControl.getSelection(), ((StringBuilder)charSequence).toString());
                int n = this.imstart;
                for (InputMethodTextRun inputMethodTextRun : inputMethodEvent.getComposed()) {
                    int n2 = n + inputMethodTextRun.getText().length();
                    this.createInputMethodAttributes(inputMethodTextRun.getHighlight(), n, n2);
                    n = n2;
                }
                this.addHighlight(this.imattrs, this.imstart);
                int n3 = inputMethodEvent.getCaretPosition();
                if (n3 >= 0 && n3 < this.imlength) {
                    textInputControl.selectRange(this.imstart + n3, this.imstart + n3);
                }
            }
        }
    }

    protected abstract PathElement[] getUnderlineShape(int var1, int var2);

    protected abstract PathElement[] getRangeShape(int var1, int var2);

    protected abstract void addHighlight(List<? extends Node> var1, int var2);

    protected abstract void removeHighlight(List<? extends Node> var1);

    private void createInputMethodAttributes(InputMethodHighlight inputMethodHighlight, int n, int n2) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (PathElement pathElement : this.getUnderlineShape(n, n2)) {
            if (pathElement instanceof MoveTo) {
                d = d2 = ((MoveTo)pathElement).getX();
                d3 = d4 = ((MoveTo)pathElement).getY();
                continue;
            }
            if (pathElement instanceof LineTo) {
                d = d < ((LineTo)pathElement).getX() ? d : ((LineTo)pathElement).getX();
                d2 = d2 > ((LineTo)pathElement).getX() ? d2 : ((LineTo)pathElement).getX();
                d3 = d3 < ((LineTo)pathElement).getY() ? d3 : ((LineTo)pathElement).getY();
                d4 = d4 > ((LineTo)pathElement).getY() ? d4 : ((LineTo)pathElement).getY();
                continue;
            }
            if (pathElement instanceof HLineTo) {
                d = d < ((HLineTo)pathElement).getX() ? d : ((HLineTo)pathElement).getX();
                d2 = d2 > ((HLineTo)pathElement).getX() ? d2 : ((HLineTo)pathElement).getX();
                continue;
            }
            if (pathElement instanceof VLineTo) {
                d3 = d3 < ((VLineTo)pathElement).getY() ? d3 : ((VLineTo)pathElement).getY();
                d4 = d4 > ((VLineTo)pathElement).getY() ? d4 : ((VLineTo)pathElement).getY();
                continue;
            }
            if (!(pathElement instanceof ClosePath)) continue;
            Shape shape = null;
            if (inputMethodHighlight == InputMethodHighlight.SELECTED_RAW) {
                shape = new Path();
                ((Path)shape).getElements().addAll((PathElement[])this.getRangeShape(n, n2));
                shape.setFill(Color.BLUE);
                shape.setOpacity(0.3f);
            } else if (inputMethodHighlight == InputMethodHighlight.UNSELECTED_RAW) {
                shape = new Line(d + 2.0, d4 + 1.0, d2 - 2.0, d4 + 1.0);
                shape.setStroke((Paint)this.textFill.get());
                shape.setStrokeWidth(d4 - d3);
                ObservableList<Double> observableList = shape.getStrokeDashArray();
                observableList.add(2.0);
                observableList.add(2.0);
            } else if (inputMethodHighlight == InputMethodHighlight.SELECTED_CONVERTED) {
                shape = new Line(d + 2.0, d4 + 1.0, d2 - 2.0, d4 + 1.0);
                shape.setStroke((Paint)this.textFill.get());
                shape.setStrokeWidth((d4 - d3) * 3.0);
            } else if (inputMethodHighlight == InputMethodHighlight.UNSELECTED_CONVERTED) {
                shape = new Line(d + 2.0, d4 + 1.0, d2 - 2.0, d4 + 1.0);
                shape.setStroke((Paint)this.textFill.get());
                shape.setStrokeWidth(d4 - d3);
            }
            shape.setManaged(false);
            shape.setSmooth(false);
            this.imattrs.add(shape);
        }
    }

    public void setCaretAnimating(boolean bl) {
        if (bl) {
            this.caretTimeline.play();
        } else {
            this.caretTimeline.stop();
            this.blink.set(true);
        }
    }

    public void populateContextMenu(ContextMenu contextMenu) {
        TextInputControl textInputControl = (TextInputControl)this.getSkinnable();
        boolean bl = textInputControl.isEditable();
        boolean bl2 = textInputControl.getLength() > 0;
        boolean bl3 = textInputControl.getSelection().getLength() > 0;
        boolean bl4 = this.maskText("A") != "A";
        ObservableList<MenuItem> observableList = contextMenu.getItems();
        if (PlatformUtil.isEmbedded()) {
            observableList.clear();
            if (!bl4 && bl3) {
                if (bl) {
                    observableList.add(this.cutMI);
                }
                observableList.add(this.copyMI);
            }
            if (bl && Clipboard.getSystemClipboard().hasString()) {
                observableList.add(this.pasteMI);
            }
            if (bl2) {
                if (!bl3) {
                    observableList.add(this.selectWordMI);
                }
                observableList.add(this.selectAllMI);
            }
            this.selectWordMI.getProperties().put("refreshMenu", Boolean.TRUE);
            this.selectAllMI.getProperties().put("refreshMenu", Boolean.TRUE);
        } else {
            if (bl) {
                observableList.setAll((MenuItem[])new MenuItem[]{this.undoMI, this.redoMI, this.cutMI, this.copyMI, this.pasteMI, this.deleteMI, this.separatorMI, this.selectAllMI});
            } else {
                observableList.setAll((MenuItem[])new MenuItem[]{this.copyMI, this.separatorMI, this.selectAllMI});
            }
            this.undoMI.setDisable(!((TextInputControlBehavior)this.getBehavior()).canUndo());
            this.redoMI.setDisable(!((TextInputControlBehavior)this.getBehavior()).canRedo());
            this.cutMI.setDisable(bl4 || !bl3);
            this.copyMI.setDisable(bl4 || !bl3);
            this.pasteMI.setDisable(!Clipboard.getSystemClipboard().hasString());
            this.deleteMI.setDisable(!bl3);
        }
    }

    @Deprecated
    public static List<StyleableProperty> impl_CSS_STYLEABLES() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    @Deprecated
    public List<StyleableProperty> impl_getStyleableProperties() {
        return TextInputControlSkin.impl_CSS_STYLEABLES();
    }

    class ContextMenuItem
    extends MenuItem {
        ContextMenuItem(final String string) {
            super(ControlResources.getString("TextInputControl.menu." + string));
            this.setOnAction(new EventHandler<ActionEvent>(){

                @Override
                public void handle(ActionEvent actionEvent) {
                    ((TextInputControlBehavior)TextInputControlSkin.this.getBehavior()).callAction(string);
                }
            });
        }
    }

    private static class StyleableProperties {
        private static final StyleableProperty<TextInputControlSkin, Font> FONT = new StyleableProperty.FONT<TextInputControlSkin>("-fx-font", Font.getDefault()){

            @Override
            public boolean isSettable(TextInputControlSkin textInputControlSkin) {
                return textInputControlSkin.font == null || !textInputControlSkin.font.isBound();
            }

            @Override
            public WritableValue<Font> getWritableValue(TextInputControlSkin textInputControlSkin) {
                return textInputControlSkin.font;
            }
        };
        private static final StyleableProperty<TextInputControlSkin, Paint> TEXT_FILL = new StyleableProperty<TextInputControlSkin, Paint>("-fx-text-fill", (StyleConverter)PaintConverter.getInstance(), (Paint)Color.BLACK){

            @Override
            public boolean isSettable(TextInputControlSkin textInputControlSkin) {
                return textInputControlSkin.textFill == null || !textInputControlSkin.textFill.isBound();
            }

            @Override
            public WritableValue<Paint> getWritableValue(TextInputControlSkin textInputControlSkin) {
                return textInputControlSkin.textFill;
            }
        };
        private static final StyleableProperty<TextInputControlSkin, Paint> PROMPT_TEXT_FILL = new StyleableProperty<TextInputControlSkin, Paint>("-fx-prompt-text-fill", (StyleConverter)PaintConverter.getInstance(), (Paint)Color.GRAY){

            @Override
            public boolean isSettable(TextInputControlSkin textInputControlSkin) {
                return textInputControlSkin.promptTextFill == null || !textInputControlSkin.promptTextFill.isBound();
            }

            @Override
            public WritableValue<Paint> getWritableValue(TextInputControlSkin textInputControlSkin) {
                return textInputControlSkin.promptTextFill;
            }
        };
        private static final StyleableProperty<TextInputControlSkin, Paint> HIGHLIGHT_FILL = new StyleableProperty<TextInputControlSkin, Paint>("-fx-highlight-fill", (StyleConverter)PaintConverter.getInstance(), (Paint)Color.DODGERBLUE){

            @Override
            public boolean isSettable(TextInputControlSkin textInputControlSkin) {
                return textInputControlSkin.highlightFill == null || !textInputControlSkin.highlightFill.isBound();
            }

            @Override
            public WritableValue<Paint> getWritableValue(TextInputControlSkin textInputControlSkin) {
                return textInputControlSkin.highlightFill;
            }
        };
        private static final StyleableProperty<TextInputControlSkin, Paint> HIGHLIGHT_TEXT_FILL = new StyleableProperty<TextInputControlSkin, Paint>("-fx-highlight-text-fill", (StyleConverter)PaintConverter.getInstance(), (Paint)Color.WHITE){

            @Override
            public boolean isSettable(TextInputControlSkin textInputControlSkin) {
                return textInputControlSkin.highlightTextFill == null || !textInputControlSkin.highlightTextFill.isBound();
            }

            @Override
            public WritableValue<Paint> getWritableValue(TextInputControlSkin textInputControlSkin) {
                return textInputControlSkin.highlightTextFill;
            }
        };
        private static final StyleableProperty<TextInputControlSkin, Boolean> DISPLAY_CARET = new StyleableProperty<TextInputControlSkin, Boolean>("-fx-display-caret", (StyleConverter)BooleanConverter.getInstance(), Boolean.TRUE){

            @Override
            public boolean isSettable(TextInputControlSkin textInputControlSkin) {
                return textInputControlSkin.displayCaret == null || !textInputControlSkin.displayCaret.isBound();
            }

            @Override
            public WritableValue<Boolean> getWritableValue(TextInputControlSkin textInputControlSkin) {
                return textInputControlSkin.displayCaret;
            }
        };
        private static final List<StyleableProperty> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList<StyleableProperty> arrayList = new ArrayList<StyleableProperty>(SkinBase.impl_CSS_STYLEABLES());
            Collections.addAll(arrayList, FONT, TEXT_FILL, PROMPT_TEXT_FILL, HIGHLIGHT_FILL, HIGHLIGHT_TEXT_FILL, DISPLAY_CARET);
            STYLEABLES = Collections.unmodifiableList(arrayList);
        }
    }
}

