/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpx;

import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public final class MPXJDateFormat
extends DateFormat {
    private SimpleDateFormat m_format = new SimpleDateFormat("dd/MM/yyyy", Locale.ENGLISH);
    private SimpleDateFormat m_alternativeFormat = new SimpleDateFormat("dd/MM/yyyy", Locale.ENGLISH);
    private String m_null = "NA";

    public void setLocale(Locale locale, String string) {
        this.m_format = new SimpleDateFormat(this.m_format.toPattern(), locale);
        this.m_alternativeFormat = new SimpleDateFormat(this.m_alternativeFormat.toPattern(), locale);
        this.m_null = string;
    }

    public void applyPattern(String string) {
        this.m_format.applyPattern(string);
        if (string.endsWith(" a")) {
            string = string.substring(0, string.length() - 2) + "a";
        }
        this.m_alternativeFormat.applyPattern(string);
    }

    public Date parse(String string, ParsePosition parsePosition) {
        Date date;
        if (string == null || string.trim().length() == 0) {
            date = null;
            parsePosition.setIndex(-1);
        } else if (string.equals(this.m_null)) {
            date = null;
            parsePosition.setIndex(-1);
        } else {
            Date date2 = this.m_format.parse(string, parsePosition);
            if (parsePosition.getIndex() == 0) {
                date2 = this.m_alternativeFormat.parse(string, parsePosition);
            }
            date = parsePosition.getIndex() != 0 ? date2 : null;
        }
        return date;
    }

    public StringBuffer format(Date date, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return this.m_format.format(date, stringBuffer, fieldPosition);
    }

    public void setAmPmText(String string, String string2) {
        String[] stringArray = new String[]{string, string2};
        DateFormatSymbols dateFormatSymbols = this.m_format.getDateFormatSymbols();
        dateFormatSymbols.setAmPmStrings(stringArray);
        this.m_format.setDateFormatSymbols(dateFormatSymbols);
        dateFormatSymbols = this.m_alternativeFormat.getDateFormatSymbols();
        dateFormatSymbols.setAmPmStrings(stringArray);
        this.m_alternativeFormat.setDateFormatSymbols(dateFormatSymbols);
    }
}

