/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.prefs.Preferences;
import org.apache.lucene.search.BooleanQuery;
import org.netbeans.modules.maven.indexer.api.NBArtifactInfo;
import org.netbeans.modules.maven.indexer.api.NBVersionInfo;
import org.netbeans.modules.maven.indexer.api.QueryField;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryQueries;
import org.netbeans.modules.maven.search.OpenArtifactInfo;
import org.netbeans.modules.maven.search.SearchSetupPanel;
import org.netbeans.spi.quicksearch.SearchProvider;
import org.netbeans.spi.quicksearch.SearchRequest;
import org.netbeans.spi.quicksearch.SearchResponse;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class MavenRepoProvider
implements SearchProvider {
    private static final String NOT_SHOW_AGAIN = "notShowAgain";
    private static final String SEARCH_ENABLED = "searchEnabled";
    private static final SearchSetup sSetup = new SearchSetup();

    public void evaluate(SearchRequest request, SearchResponse response) {
        List loadedRepos = RepositoryQueries.getLoadedContexts();
        Preferences prefs = NbPreferences.forModule(MavenRepoProvider.class);
        if (loadedRepos.size() == 0 && !prefs.getBoolean(SEARCH_ENABLED, false)) {
            if (!prefs.getBoolean(NOT_SHOW_AGAIN, false)) {
                response.addResult((Runnable)sSetup, NbBundle.getMessage(MavenRepoProvider.class, (String)"LBL_SearchSetup"), NbBundle.getMessage(MavenRepoProvider.class, (String)"TIP_SearchSetup"), null);
            }
            return;
        }
        List infos = null;
        try {
            infos = RepositoryQueries.find(this.getQuery(request), (RepositoryInfo[])new RepositoryInfo[0]);
        }
        catch (BooleanQuery.TooManyClauses e) {
            return;
        }
        TreeMap<String, ArrayList<NBVersionInfo>> map = new TreeMap<String, ArrayList<NBVersionInfo>>(new Comp(request.getText()));
        for (NBVersionInfo nbvi : infos) {
            String key = nbvi.getGroupId() + " : " + nbvi.getArtifactId();
            ArrayList<NBVersionInfo> get = (ArrayList<NBVersionInfo>)map.get(key);
            if (get == null) {
                get = new ArrayList<NBVersionInfo>();
                map.put(key, get);
            }
            get.add(nbvi);
        }
        Set entrySet = map.entrySet();
        for (Map.Entry entry : entrySet) {
            NBArtifactInfo nbai = new NBArtifactInfo((String)entry.getKey());
            nbai.addAlVersionInfos((Collection)entry.getValue());
            if (response.addResult((Runnable)new OpenArtifactInfo(nbai), nbai.getName())) continue;
            return;
        }
    }

    List<QueryField> getQuery(SearchRequest request) {
        ArrayList<QueryField> fq = new ArrayList<QueryField>();
        String q = request.getText();
        String[] splits = q.split(" ");
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("groupId");
        fields.add("artifactId");
        fields.add("version");
        fields.add("name");
        fields.add("description");
        fields.add("classes");
        for (String one : splits) {
            for (String fld : fields) {
                QueryField f = new QueryField();
                f.setField(fld);
                f.setValue(one);
                fq.add(f);
            }
        }
        return fq;
    }

    private static class SearchSetup
    implements Runnable {
        private SearchSetup() {
        }

        @Override
        public void run() {
            SearchSetupPanel ssPanel = new SearchSetupPanel();
            DialogDescriptor dd = new DialogDescriptor((Object)ssPanel, NbBundle.getBundle(MavenRepoProvider.class).getString("TIT_SearchSetup"));
            dd.setOptionType(0);
            Object ret = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
            if (ret == DialogDescriptor.YES_OPTION || ssPanel.isNotAgainChecked()) {
                Preferences prefs = NbPreferences.forModule(MavenRepoProvider.class);
                if (ret == DialogDescriptor.YES_OPTION) {
                    prefs.putBoolean(MavenRepoProvider.SEARCH_ENABLED, true);
                }
                if (ssPanel.isNotAgainChecked()) {
                    prefs.putBoolean(MavenRepoProvider.NOT_SHOW_AGAIN, true);
                }
            }
        }
    }

    private static class Comp
    implements Comparator<String> {
        private String query;

        public Comp(String q) {
            this.query = q;
        }

        @Override
        public int compare(String s1, String s2) {
            int index1 = s1.indexOf(this.query);
            int index2 = s2.indexOf(this.query);
            if (index1 >= 0 || index2 >= 0) {
                if (index1 < 0) {
                    return 1;
                }
                if (index2 < 0) {
                    return -1;
                }
                return s1.compareTo(s2);
            }
            return s1.compareTo(s2);
        }
    }
}

