/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.platform;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmProgressListener;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.platform.ParsingProgress;

public class ProgressListenerImpl
implements CsmProgressListener {
    private final Map<CsmProject, ParsingProgress> handles = new HashMap<CsmProject, ParsingProgress>();

    private synchronized ParsingProgress getHandle(CsmProject csmProject, boolean bl) {
        ParsingProgress parsingProgress = this.handles.get(csmProject);
        if (parsingProgress == null && bl) {
            parsingProgress = new ParsingProgress(csmProject);
            this.handles.put(csmProject, parsingProgress);
        }
        return parsingProgress;
    }

    public void projectParsingStarted(CsmProject csmProject) {
        if (TraceFlags.TRACE_PARSER_QUEUE) {
            System.err.println("ProgressListenerImpl.projectParsingStarted " + csmProject.getName());
        }
        this.getHandle(csmProject, true).start();
    }

    public void projectFilesCounted(CsmProject csmProject, int n) {
        if (TraceFlags.TRACE_PARSER_QUEUE) {
            System.err.println("ProgressListenerImpl.projectFilesCounted " + csmProject.getName() + ' ' + n);
        }
        this.getHandle(csmProject, true).switchToDeterminate(n);
    }

    public void projectParsingFinished(CsmProject csmProject) {
        if (TraceFlags.TRACE_PARSER_QUEUE) {
            System.err.println("ProgressListenerImpl.projectParsingFinished " + csmProject.getName());
        }
        this.done(csmProject);
    }

    public void projectLoaded(CsmProject csmProject) {
        if (TraceFlags.TRACE_PARSER_QUEUE) {
            System.err.println("ProgressListenerImpl.projectLoaded " + csmProject.getName());
        }
    }

    public void projectParsingCancelled(CsmProject csmProject) {
        if (TraceFlags.TRACE_PARSER_QUEUE) {
            System.err.println("ProgressListenerImpl.projectParsingCancelled " + csmProject.getName());
        }
        this.done(csmProject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void done(CsmProject csmProject) {
        this.getHandle(csmProject, true).finish();
        ProgressListenerImpl progressListenerImpl = this;
        synchronized (progressListenerImpl) {
            this.handles.remove(csmProject);
        }
    }

    public void fileInvalidated(CsmFile csmFile) {
    }

    public void fileAddedToParse(CsmFile csmFile) {
        CsmProject csmProject = csmFile.getProject();
        ParsingProgress parsingProgress = this.getHandle(csmProject, false);
        if (parsingProgress != null) {
            parsingProgress.addedToParse(csmFile);
        } else if (csmProject.isArtificial()) {
            for (CsmProject csmProject2 : CsmModelAccessor.getModel().projects()) {
                if (csmProject2.isArtificial() || !csmProject2.getLibraries().contains(csmProject) || (parsingProgress = this.getHandle(csmProject2, false)) == null) continue;
                parsingProgress.addedToParse(csmFile);
            }
        }
    }

    public void fileParsingStarted(CsmFile csmFile) {
        CsmProject csmProject;
        ParsingProgress parsingProgress;
        if (TraceFlags.TRACE_PARSER_QUEUE) {
            System.err.println("  ProgressListenerImpl.fileParsingStarted " + csmFile.getAbsolutePath());
        }
        if ((parsingProgress = this.getHandle(csmProject = csmFile.getProject(), false)) != null) {
            parsingProgress.nextCsmFile(csmFile);
        } else if (csmProject.isArtificial()) {
            for (CsmProject csmProject2 : CsmModelAccessor.getModel().projects()) {
                if (csmProject2.isArtificial() || !csmProject2.getLibraries().contains(csmProject) || (parsingProgress = this.getHandle(csmProject2, false)) == null) continue;
                parsingProgress.nextCsmFile(csmFile);
            }
        }
    }

    public void fileParsingFinished(CsmFile csmFile) {
        if (TraceFlags.TRACE_PARSER_QUEUE) {
            System.err.println("  ProgressListenerImpl.fileParsingFinished " + csmFile.getAbsolutePath());
        }
    }

    public void parserIdle() {
        if (TraceFlags.TRACE_PARSER_QUEUE) {
            System.err.println("  ProgressListenerImpl.parserIdle");
        }
    }
}

