/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.apt.support.APTPreprocHandler;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProgressSupport;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.debug.Diagnostic;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.utils.CndUtils;

public final class ParserQueue {
    private static ParserQueue instance = new ParserQueue(false);
    private final PriorityQueue<Entry> queue = new PriorityQueue();
    private volatile State state;
    private final Object suspendLock = new SuspendLock();
    private final Map<ProjectBase, ProjectData> projectData = new HashMap<ProjectBase, ProjectData>();
    private final Map<CsmProject, Object> projectLocks = new HashMap<CsmProject, Object>();
    private final AtomicInteger serial = new AtomicInteger(0);
    private final Object lock = new Lock();
    private final boolean addAlways;
    private final Diagnostic.StopWatch stopWatch = TraceFlags.TIMING ? new Diagnostic.StopWatch(false) : null;
    private final Diagnostic.ProjectStat parseWatch = TraceFlags.TIMING ? new Diagnostic.ProjectStat() : null;
    private final Map<ProjectBase, AtomicInteger> onStartLevel = new HashMap<ProjectBase, AtomicInteger>();

    static String tracePreprocStates(Collection<APTPreprocHandler.State> collection) {
        StringBuilder stringBuilder = new StringBuilder(40);
        boolean bl = false;
        for (APTPreprocHandler.State state : collection) {
            stringBuilder.append('(');
            if (!bl) {
                stringBuilder.append(';');
            }
            bl = false;
            stringBuilder.append(ParserQueue.tracePreprocState(state));
            stringBuilder.append(')');
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    static String tracePreprocState(APTPreprocHandler.State state) {
        if (state == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder("[");
        if (!state.isCleaned()) {
            stringBuilder.append("not");
        }
        stringBuilder.append(" cleaned, ");
        if (!state.isValid()) {
            stringBuilder.append("not");
        }
        stringBuilder.append(" valid, ");
        if (!state.isCompileContext()) {
            stringBuilder.append("not");
        }
        stringBuilder.append(" correct State]");
        return stringBuilder.toString();
    }

    private ParserQueue(boolean bl) {
        this.addAlways = bl;
    }

    public static ParserQueue instance() {
        return instance;
    }

    public static ParserQueue testInstance() {
        return new ParserQueue(true);
    }

    private String traceState4File(FileImpl fileImpl, Set<FileImpl> set) {
        StringBuilder stringBuilder = new StringBuilder(" ");
        stringBuilder.append(fileImpl);
        stringBuilder.append("\n of project ").append(fileImpl.getProjectImpl(true));
        stringBuilder.append("\n content of projects files set:\n");
        if (set != null) {
            stringBuilder.append(set);
            stringBuilder.append("\nqueue content is:\n");
            stringBuilder.append(this.toString(this.queue, false));
            stringBuilder.append("\nprojectData content is:\n");
            stringBuilder.append(this.projectData);
        }
        return stringBuilder.toString();
    }

    public void add(FileImpl fileImpl, APTPreprocHandler.State state, Position position) {
        this.add(fileImpl, Collections.singleton(state), position, true, FileAction.NOTHING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(FileImpl fileImpl, Collection<APTPreprocHandler.State> collection, Position position, boolean bl, FileAction fileAction) {
        int n;
        if (TraceFlags.TRACE_182342_BUG) {
            new Exception("ParserQueue: add for " + fileImpl).printStackTrace(System.err);
            n = 0;
            for (APTPreprocHandler.State object : collection) {
                System.err.printf("ParserQueue: State %d from original %s\n", n++, object);
            }
        }
        if (collection.isEmpty()) {
            Utils.LOG.severe("Adding a file with an emty preprocessor state set");
        }
        assert (this.state != null);
        if (TraceFlags.TRACE_PARSER_QUEUE) {
            System.err.println("ParserQueue: add " + fileImpl.getAbsolutePath() + " as " + (Object)((Object)position));
        }
        n = 0;
        Iterator<APTPreprocHandler.State> iterator = this.lock;
        synchronized (iterator) {
            if (this.state == State.OFF) {
                return false;
            }
            switch (fileAction) {
                case MARK_MORE_PARSE: {
                    fileImpl.markMoreParseNeeded();
                    break;
                }
                case MARK_REPARSE: {
                    fileImpl.markReparseNeeded(false);
                    break;
                }
                case MARK_REPARSE_AND_INVALIDATE: {
                    fileImpl.markReparseNeeded(true);
                }
            }
            if (!this.needEnqueue(fileImpl)) {
                if (TraceFlags.TRACE_PARSER_QUEUE) {
                    System.err.println("ParserQueue: do not add parsing or parsed " + fileImpl.getAbsolutePath());
                }
                return false;
            }
            if (this.queue.isEmpty()) {
                this.serial.set(0);
            }
            Set<FileImpl> set = this.getProjectFiles(fileImpl.getProjectImpl(true));
            Entry entry = null;
            boolean bl2 = false;
            if (set.contains(fileImpl)) {
                entry = this.findEntry(fileImpl);
                if (entry == null) {
                    FileImpl fileImpl2 = null;
                    for (FileImpl fileImpl3 : set) {
                        if (!fileImpl3.equals(fileImpl)) continue;
                        fileImpl2 = fileImpl3;
                    }
                    if (fileImpl2 == fileImpl) {
                        CndUtils.assertTrue((boolean)false, (String)("ProjectData contains file " + fileImpl + ", but there is no matching entry in the queue"));
                    } else {
                        CndUtils.assertTrue((boolean)false, (String)("ProjectData contains another instance of file " + fileImpl + ", so there is no matching entry in the queue"));
                    }
                    System.err.println(this.traceState4File(fileImpl, set));
                    System.err.println(this.traceState4File(fileImpl2, null));
                } else {
                    if (bl) {
                        entry.setStates(collection);
                    } else {
                        entry.addStates(collection);
                    }
                    if (fileImpl != entry.file) {
                        this.queue.remove(entry);
                        entry = new Entry(fileImpl, entry.getPreprocStates(), position, this.serial.incrementAndGet());
                        bl2 = true;
                    } else if (position.compareTo(entry.getPosition()) < 0) {
                        this.queue.remove(entry);
                        entry = new Entry(fileImpl, entry.getPreprocStates(), position, this.serial.incrementAndGet());
                        bl2 = true;
                    }
                }
            } else {
                assert (this.findEntry(fileImpl) == null) : "The queue should not contain the file " + this.traceState4File(fileImpl, set);
                set.add(fileImpl);
                n = 1;
            }
            if (entry == null) {
                entry = new Entry(fileImpl, collection, position, this.serial.incrementAndGet());
                bl2 = true;
            }
            if (bl2) {
                this.queue.add(entry);
                if (TraceFlags.TRACE_PARSER_QUEUE) {
                    System.err.println("ParserQueue: added entry " + entry.toString(TraceFlags.TRACE_PARSER_QUEUE_DETAILS));
                }
            }
            this.lock.notifyAll();
        }
        ProgressSupport.instance().fireFileInvalidated(fileImpl);
        if (n != 0) {
            ProgressSupport.instance().fireFileAddedToParse(fileImpl);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitReady() throws InterruptedException {
        if (TraceFlags.TRACE_PARSER_QUEUE) {
            System.err.println("ParserQueue: waitReady() ...");
        }
        Object object = this.lock;
        synchronized (object) {
            while (this.findFirstNotBeeingParsedEntry(false) == null && this.state != State.OFF) {
                this.lock.wait();
            }
        }
        if (TraceFlags.TRACE_PARSER_QUEUE) {
            System.err.println("ParserQueue: waiting finished");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend() {
        if (TraceFlags.TRACE_PARSER_QUEUE) {
            System.err.println("ParserQueue: suspending");
        }
        Object object = this.suspendLock;
        synchronized (object) {
            this.state = State.SUSPENDED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        if (TraceFlags.TRACE_PARSER_QUEUE) {
            System.err.println("ParserQueue: resuming");
        }
        Object object = this.suspendLock;
        synchronized (object) {
            this.state = State.ON;
            this.suspendLock.notifyAll();
        }
    }

    private Entry findFirstNotBeeingParsedEntry(boolean bl) {
        Entry entry;
        block2: {
            entry = null;
            FileImpl fileImpl = null;
            ProjectData projectData = null;
            ProjectBase projectBase = null;
            Iterator<Entry> iterator = this.queue.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return null;
                }
                entry = iterator.next();
                fileImpl = entry.getFile();
                projectBase = fileImpl.getProjectImpl(true);
                projectData = this.getProjectData(projectBase, true);
                if (!projectData.filesBeingParsed.contains(fileImpl)) break;
                if (!TraceFlags.TRACE_PARSER_QUEUE) continue;
                System.err.println(Thread.currentThread().getName() + ": beeing parsed by another thread " + fileImpl);
            }
            if (!bl) break block2;
            iterator.remove();
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry poll() throws InterruptedException {
        boolean bl;
        ProjectData projectData;
        ProjectBase projectBase;
        Object object = this.suspendLock;
        synchronized (object) {
            while (this.state == State.SUSPENDED) {
                if (TraceFlags.TRACE_PARSER_QUEUE) {
                    System.err.println("ParserQueue: waiting for resume");
                }
                this.suspendLock.wait();
            }
        }
        object = null;
        FileImpl fileImpl = null;
        Object object2 = this.lock;
        synchronized (object2) {
            object = this.findFirstNotBeeingParsedEntry(true);
            if (object == null) {
                return null;
            }
            fileImpl = ((Entry)object).getFile();
            projectBase = fileImpl.getProjectImpl(true);
            projectData = this.getProjectData(projectBase, true);
            projectData.filesInQueue.remove(fileImpl);
            projectData.filesBeingParsed.add(fileImpl);
            bl = this.markLastProjectFileActivityIfNeeded(projectData);
            if (TraceFlags.TIMING && this.stopWatch != null && !this.stopWatch.isRunning()) {
                this.stopWatch.start();
                System.err.println("=== Starting parser queue stopwatch " + projectBase.getName() + " (" + projectBase.getFileContainerSize() + " files)");
            }
        }
        ProgressSupport.instance().fireFileParsingStarted(fileImpl);
        if (bl) {
            this.handleLastProjectFile(projectBase, projectData);
        }
        if (TraceFlags.TRACE_PARSER_QUEUE_POLL) {
            System.err.printf("ParserQueue: polling %s with %d states in thread %s\n", ((Entry)object).getFile().getAbsolutePath(), ((Entry)object).getPreprocStates().size(), Thread.currentThread().getName());
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(FileImpl fileImpl) {
        ProjectData projectData;
        ProjectBase projectBase;
        boolean bl = false;
        Object object = this.lock;
        synchronized (object) {
            projectBase = fileImpl.getProjectImpl(true);
            projectData = this.getProjectData(projectBase, true);
            if (projectData.filesInQueue.contains(fileImpl)) {
                Entry entry = this.findEntry(fileImpl);
                if (entry != null) {
                    this.queue.remove(entry);
                }
                projectData.filesInQueue.remove(fileImpl);
                bl = this.markLastProjectFileActivityIfNeeded(projectData);
            }
        }
        if (bl) {
            this.handleLastProjectFile(projectBase, projectData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (TraceFlags.TRACE_PARSER_QUEUE) {
            System.err.println("ParserQueue: clearing");
        }
        ArrayList<ProjectBase> arrayList = null;
        Iterator iterator = this.lock;
        synchronized (iterator) {
            this.state = State.OFF;
            this.queue.clear();
            arrayList = new ArrayList<ProjectBase>(this.projectData.keySet());
            this.lock.notifyAll();
        }
        for (ProjectBase projectBase : arrayList) {
            ProgressSupport.instance().fireProjectParsingFinished(projectBase);
        }
        this.clearParseWatch();
    }

    public void startup() {
        this.state = State.ON;
    }

    void clearParseWatch() {
        if (this.parseWatch != null) {
            this.parseWatch.clear();
        }
    }

    void addParseStatistics(ProjectBase projectBase, FileImpl fileImpl, long l) {
        if (this.parseWatch != null) {
            this.parseWatch.addParseFileStatistics(projectBase, fileImpl, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll(ProjectBase projectBase) {
        boolean bl;
        ProjectData projectData;
        Object object = this.lock;
        synchronized (object) {
            projectData = this._clean(projectBase);
            bl = this.markLastProjectFileActivityIfNeeded(projectData);
        }
        if (bl) {
            this.handleLastProjectFile(projectBase, projectData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clean(ProjectBase projectBase) {
        Object object = this.lock;
        synchronized (object) {
            this._clean(projectBase);
        }
    }

    private ProjectData _clean(ProjectBase projectBase) {
        ProjectData projectData = this.getProjectData(projectBase, true);
        for (FileImpl fileImpl : projectData.filesInQueue) {
            Entry entry = this.findEntry(fileImpl);
            this.queue.remove(entry);
        }
        projectData.filesInQueue.clear();
        return projectData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isParsing(ProjectBase projectBase) {
        Object object = this.lock;
        synchronized (object) {
            ProjectData projectData = this.getProjectData(projectBase, false);
            if (projectData != null) {
                return !projectData.filesBeingParsed.isEmpty();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPendingProjectRelatedWork(ProjectBase projectBase, FileImpl fileImpl) {
        Object object = this.lock;
        synchronized (object) {
            ProjectData projectData = this.getProjectData(projectBase, false);
            if (projectData == null || projectData.noActivity()) {
                return false;
            }
            if (fileImpl == null) {
                return true;
            }
            if (projectData.filesBeingParsed.contains(fileImpl) || projectData.filesInQueue.contains(fileImpl)) {
                return projectData.filesBeingParsed.size() + projectData.filesInQueue.size() + projectData.pendingActivity > 1;
            }
            return !projectData.noActivity();
        }
    }

    private Set<FileImpl> getProjectFiles(ProjectBase projectBase) {
        return this.getProjectData(projectBase, true).filesInQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProjectData getProjectData(ProjectBase projectBase, boolean bl) {
        Object object = this.lock;
        synchronized (object) {
            ProjectBase projectBase2 = projectBase;
            ProjectData projectData = this.projectData.get(projectBase2);
            if (projectData == null && bl) {
                projectData = new ProjectData(false);
                this.projectData.put(projectBase2, projectData);
            }
            return projectData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeProjectData(ProjectBase projectBase) {
        Object object = this.lock;
        synchronized (object) {
            this.projectData.remove(projectBase);
        }
    }

    private boolean needEnqueue(FileImpl fileImpl) {
        return !fileImpl.getProjectImpl(true).isDisposing() || this.addAlways;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onStartAddingProjectFiles(ProjectBase projectBase) {
        boolean bl;
        Map<ProjectBase, AtomicInteger> map = this.onStartLevel;
        synchronized (map) {
            AtomicInteger atomicInteger = this.onStartLevel.get(projectBase);
            if (atomicInteger == null) {
                atomicInteger = new AtomicInteger();
                this.onStartLevel.put(projectBase, atomicInteger);
            }
            bl = atomicInteger.incrementAndGet() == 1;
        }
        if (bl) {
            this.getProjectData(projectBase, true).notifyListeners = true;
            ProgressSupport.instance().fireProjectParsingStarted(projectBase);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEndAddingProjectFiles(ProjectBase projectBase) {
        boolean bl;
        Map<ProjectBase, AtomicInteger> map = this.onStartLevel;
        synchronized (map) {
            AtomicInteger atomicInteger = this.onStartLevel.get(projectBase);
            if (atomicInteger == null) {
                assert (false) : "Not balanced start/end adding in project";
                atomicInteger = new AtomicInteger(1);
                this.onStartLevel.put(projectBase, atomicInteger);
            }
            boolean bl2 = bl = atomicInteger.decrementAndGet() == 0;
            if (bl) {
                this.onStartLevel.remove(projectBase);
            }
        }
        if (bl) {
            int n = this.getProjectFiles(projectBase).size();
            ProgressSupport.instance().fireProjectFilesCounted(projectBase, n);
            if (n == 0) {
                ProgressSupport.instance().fireProjectParsingFinished(projectBase);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onFileParsingFinished(FileImpl fileImpl) {
        boolean bl;
        ProjectData projectData;
        ProjectBase projectBase;
        boolean bl2 = false;
        Object object = this.lock;
        synchronized (object) {
            projectBase = fileImpl.getProjectImpl(true);
            projectData = this.getProjectData(projectBase, true);
            projectData.filesBeingParsed.remove(fileImpl);
            bl = this.markLastProjectFileActivityIfNeeded(projectData);
            if (bl) {
                bl2 = this.projectData.isEmpty();
                if (TraceFlags.TIMING && this.stopWatch != null && this.stopWatch.isRunning()) {
                    this.stopWatch.stopAndReport("=== Stopping parser queue stopwatch " + projectBase.getName() + " (" + projectBase.getFileContainerSize() + " files): \t");
                    if (this.parseWatch != null) {
                        this.parseWatch.traceProjectData(projectBase);
                    }
                }
            }
            this.lock.notifyAll();
        }
        ProgressSupport.instance().fireFileParsingFinished(fileImpl);
        if (bl) {
            if (TraceFlags.TRACE_CLOSE_PROJECT) {
                System.err.println("Last file in project " + projectBase.getName() + " (" + projectBase.getFileContainerSize() + " files)");
            }
            this.handleLastProjectFile(projectBase, projectData);
            if (bl2) {
                ProgressSupport.instance().fireIdle();
            }
            this.notifyWaitEmpty(projectBase);
        }
    }

    private boolean markLastProjectFileActivityIfNeeded(ProjectData projectData) {
        if (projectData.filesInQueue.isEmpty() && projectData.filesBeingParsed.isEmpty()) {
            projectData.pendingActivity++;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleLastProjectFile(ProjectBase projectBase, ProjectData projectData) {
        projectBase.onParseFinish();
        boolean bl = false;
        Object object = this.lock;
        synchronized (object) {
            projectData.pendingActivity--;
            if (projectData.isEmpty() && projectData.pendingActivity == 0) {
                this.projectData.remove(projectBase);
                bl = true;
            }
        }
        if (bl) {
            projectBase.notifyOnWaitParseLock();
            if (projectData.notifyListeners) {
                ProgressSupport.instance().fireProjectParsingFinished(projectBase);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyWaitEmpty(ProjectBase projectBase) {
        Object object;
        Object object2 = this.projectLocks;
        synchronized (object2) {
            object = this.projectLocks.remove(projectBase);
        }
        if (object != null) {
            object2 = object;
            synchronized (object2) {
                object.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitEmpty(ProjectBase projectBase) {
        if (TraceFlags.TRACE_CLOSE_PROJECT) {
            System.err.println("Waiting Empty Project " + projectBase.getName());
        }
        while (this.hasPendingProjectRelatedWork(projectBase, null)) {
            Object object;
            if (TraceFlags.TRACE_CLOSE_PROJECT) {
                System.err.println("Waiting Empty Project 2 " + projectBase.getName());
            }
            Object object2 = this.projectLocks;
            synchronized (object2) {
                object = this.projectLocks.get(projectBase);
                if (object == null) {
                    object = new ProjectWaitLock();
                    this.projectLocks.put(projectBase, object);
                }
            }
            object2 = object;
            synchronized (object2) {
                try {
                    object.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (TraceFlags.TRACE_CLOSE_PROJECT) {
            System.err.println("Finished waiting on Empty Project " + projectBase.getName());
        }
    }

    public long getStopWatchTime() {
        return TraceFlags.TIMING ? this.stopWatch.getTime() : -1L;
    }

    private String toString(PriorityQueue<Entry> priorityQueue, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Entry entry : priorityQueue) {
            stringBuilder.append(entry.toString(bl)).append("\n");
        }
        return stringBuilder.toString();
    }

    private Entry findEntry(FileImpl fileImpl) {
        int n = fileImpl.hashCode();
        for (Entry entry : this.queue) {
            FileImpl fileImpl2 = entry.getFile();
            if (fileImpl2 == fileImpl) {
                return entry;
            }
            if (n != fileImpl2.hashCode() || !fileImpl.equals(fileImpl2)) continue;
            return entry;
        }
        return null;
    }

    private static final class ProjectWaitLock {
        private ProjectWaitLock() {
        }
    }

    private static final class Lock {
        private Lock() {
        }
    }

    private static final class SuspendLock {
        private SuspendLock() {
        }
    }

    private static enum State {
        ON,
        OFF,
        SUSPENDED;

    }

    private static final class ProjectData {
        private final Set<FileImpl> filesInQueue = new HashSet<FileImpl>();
        private final Collection<FileImpl> filesBeingParsed = new LinkedHashSet<FileImpl>();
        private volatile boolean notifyListeners;
        private volatile int pendingActivity;

        ProjectData(boolean bl) {
            this.notifyListeners = bl;
            this.pendingActivity = 0;
        }

        public boolean isEmpty() {
            return this.filesInQueue.isEmpty() && this.filesBeingParsed.isEmpty();
        }

        public boolean noActivity() {
            return this.filesInQueue.isEmpty() && this.filesBeingParsed.isEmpty() && this.pendingActivity == 0;
        }

        public int size() {
            return this.filesInQueue.size();
        }
    }

    public static enum FileAction {
        NOTHING,
        MARK_MORE_PARSE,
        MARK_REPARSE,
        MARK_REPARSE_AND_INVALIDATE;

    }

    public static final class Entry
    implements Comparable<Entry> {
        private final FileImpl file;
        private Object ppState;
        private final Position position;
        private final int serial;

        private Entry(FileImpl fileImpl, Collection<APTPreprocHandler.State> collection, Position position, int n) {
            if (TraceFlags.TRACE_PARSER_QUEUE) {
                System.err.println("creating entry for " + fileImpl.getAbsolutePath() + " as " + ParserQueue.tracePreprocStates(collection));
            }
            this.file = fileImpl;
            this.ppState = collection.size() == 1 ? collection.iterator().next() : new ArrayList<APTPreprocHandler.State>(collection);
            this.position = position;
            this.serial = n;
        }

        public FileImpl getFile() {
            return this.file;
        }

        public Collection<APTPreprocHandler.State> getPreprocStates() {
            Object object = this.ppState;
            if (object instanceof APTPreprocHandler.State || object == null) {
                return Collections.singleton((APTPreprocHandler.State)object);
            }
            return (Collection)object;
        }

        public Position getPosition() {
            return this.position;
        }

        public String toString() {
            return this.toString(true);
        }

        public String toString(boolean bl) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("ParserQueue.Entry ").append(this.file).append(" of project ").append(this.file.getProject());
            if (bl) {
                stringBuilder.append("\nposition: ").append((Object)this.position);
                stringBuilder.append(", serial: ").append(this.serial);
                stringBuilder.append("\nwith PreprocStates:");
                for (APTPreprocHandler.State state : this.getPreprocStates()) {
                    stringBuilder.append('\n');
                    stringBuilder.append(state);
                }
            }
            return stringBuilder.toString();
        }

        private synchronized void addStates(Collection<APTPreprocHandler.State> collection) {
            Object object;
            if (this.ppState instanceof APTPreprocHandler.State) {
                object = (APTPreprocHandler.State)this.ppState;
                this.ppState = new ArrayList();
                ((Collection)this.ppState).add(object);
            }
            object = (Collection)this.ppState;
            for (APTPreprocHandler.State state : collection) {
                if (state != FileImpl.DUMMY_STATE) {
                    if (!object.contains(state)) {
                        object.add(state);
                        continue;
                    }
                    if (!TraceFlags.TIMING_PARSE_PER_FILE_FLAT) continue;
                    System.err.println("array already has the state " + state);
                    continue;
                }
                if (!TraceFlags.TIMING_PARSE_PER_FILE_FLAT) continue;
                System.err.println("skip adding dummy state");
            }
        }

        private synchronized void setStates(Collection<APTPreprocHandler.State> collection) {
            if (TraceFlags.TRACE_PARSER_QUEUE) {
                System.err.println("setPreprocStateIfNeed for " + this.file.getAbsolutePath() + " as " + ParserQueue.tracePreprocStates(collection) + " with current " + ParserQueue.tracePreprocStates(this.getPreprocStates()));
            }
            this.ppState = new ArrayList<APTPreprocHandler.State>(collection);
        }

        @Override
        public int compareTo(Entry entry) {
            int n = this.position.compareTo(entry.position);
            if (n == 0) {
                n = this.serial - entry.serial;
                return this.position == Position.HEAD ? -n : n;
            }
            return n;
        }

        public boolean equals(Object object) {
            if (object instanceof Entry) {
                return this.compareTo((Entry)object) == 0;
            }
            return false;
        }

        public int hashCode() {
            int n = 5;
            n = 97 * n + (this.position != null ? this.position.ordinal() : 0);
            n = 97 * n + this.serial;
            return n;
        }
    }

    public static enum Position {
        IMMEDIATE,
        HEAD,
        TAIL;

    }
}

