/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jellytools.testutils;

import java.awt.Toolkit;
import java.awt.datatransfer.Transferable;
import org.netbeans.jellytools.Bundle;
import org.netbeans.jellytools.NbDialogOperator;
import org.netbeans.jellytools.actions.DeleteAction;
import org.netbeans.jellytools.nodes.Node;
import org.netbeans.jellytools.properties.PropertySheetOperator;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.Waitable;
import org.netbeans.jemmy.Waiter;
import org.netbeans.jemmy.operators.JDialogOperator;

public class NodeUtils {
    public static void testClipboard(final Object clipboard1) {
        Waiter waiter = new Waiter(new Waitable(){

            public Object actionProduced(Object obj) {
                Transferable clipboard2 = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
                return clipboard1 != clipboard2 ? Boolean.TRUE : null;
            }

            public String getDescription() {
                return "Wait clipboard contains data";
            }
        });
        try {
            waiter.waitAction(null);
        }
        catch (InterruptedException e) {
            throw new JemmyException("Waiting interrupted.", (Throwable)e);
        }
    }

    public static void closeConfirmDeleteDialog() {
        String confirmTitle = Bundle.getString((String)"org.openide.explorer.Bundle", (String)"MSG_ConfirmDeleteObjectTitle");
        new JDialogOperator(confirmTitle).close();
    }

    public static void closeRenameDialog() {
        String renameTitle = Bundle.getString((String)"org.openide.actions.Bundle", (String)"CTL_RenameTitle");
        new JDialogOperator(renameTitle).close();
    }

    public static void closeProperties(String objectName) {
        new PropertySheetOperator(objectName).close();
    }

    public static void performDelete(Node node) {
        new DeleteAction().performAPI(node);
        String deleteTitle = Bundle.getString((String)"org.openide.explorer.Bundle", (String)"MSG_ConfirmDeleteObjectTitle");
        NbDialogOperator deleteOper = new NbDialogOperator(deleteTitle);
        deleteOper.yes();
    }
}

