/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.breakpoints;

import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.event.MethodEntryEvent;
import com.sun.jdi.event.MethodExitEvent;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.MethodEntryRequest;
import com.sun.jdi.request.MethodExitRequest;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.MethodBreakpoint;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.breakpoints.ClassBasedBreakpoint;
import org.netbeans.modules.debugger.jpda.expr.JDIVariable;
import org.netbeans.modules.debugger.jpda.jdi.ClassNotPreparedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InvalidRequestStateExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.LocatableWrapper;
import org.netbeans.modules.debugger.jpda.jdi.LocationWrapper;
import org.netbeans.modules.debugger.jpda.jdi.MethodWrapper;
import org.netbeans.modules.debugger.jpda.jdi.MirrorWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ReferenceTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.TypeComponentWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.EventWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.LocatableEventWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.MethodEntryEventWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.MethodExitEventWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.BreakpointRequestWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.EventRequestManagerWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.EventRequestWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.MethodEntryRequestWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.MethodExitRequestWrapper;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class MethodBreakpointImpl
extends ClassBasedBreakpoint {
    private MethodBreakpoint breakpoint;
    private final Map<Event, Value> returnValueByEvent = new WeakHashMap<Event, Value>();

    public MethodBreakpointImpl(MethodBreakpoint methodBreakpoint, JPDADebuggerImpl jPDADebuggerImpl, Session session) {
        super((JPDABreakpoint)methodBreakpoint, jPDADebuggerImpl, session);
        this.breakpoint = methodBreakpoint;
        this.set();
    }

    @Override
    protected void setRequests() {
        this.setClassRequests(this.breakpoint.getClassFilters(), this.breakpoint.getClassExclusionFilters(), 1);
        for (String string : this.breakpoint.getClassFilters()) {
            this.checkLoadedClasses(string, this.breakpoint.getClassExclusionFilters());
        }
    }

    @Override
    protected EventRequest createEventRequest(EventRequest eventRequest) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper {
        if (eventRequest instanceof BreakpointRequest) {
            return EventRequestManagerWrapper.createBreakpointRequest(this.getEventRequestManager(), BreakpointRequestWrapper.location((BreakpointRequest)eventRequest));
        }
        if (eventRequest instanceof MethodEntryRequest) {
            JPDAThread[] jPDAThreadArray;
            MethodEntryRequest methodEntryRequest = EventRequestManagerWrapper.createMethodEntryRequest(this.getEventRequestManager());
            ReferenceType referenceType = (ReferenceType)EventRequestWrapper.getProperty(eventRequest, "ReferenceType");
            MethodEntryRequestWrapper.addClassFilter(methodEntryRequest, referenceType);
            JPDAThread[] jPDAThreadArray2 = this.breakpoint.getThreadFilters((JPDADebugger)this.getDebugger());
            if (jPDAThreadArray2 != null && jPDAThreadArray2.length > 0) {
                jPDAThreadArray = jPDAThreadArray2;
                int n = jPDAThreadArray.length;
                for (int i = 0; i < n; ++i) {
                    JPDAThread jPDAThread = jPDAThreadArray[i];
                    MethodEntryRequestWrapper.addThreadFilter(methodEntryRequest, ((JPDAThreadImpl)jPDAThread).getThreadReference());
                }
            }
            if ((jPDAThreadArray = this.breakpoint.getInstanceFilters((JPDADebugger)this.getDebugger())) != null && jPDAThreadArray.length > 0) {
                for (JPDAThread jPDAThread : jPDAThreadArray) {
                    MethodEntryRequestWrapper.addInstanceFilter(methodEntryRequest, (ObjectReference)((JDIVariable)jPDAThread).getJDIValue());
                }
            }
            Object object = EventRequestWrapper.getProperty(eventRequest, "methodNames");
            EventRequestWrapper.putProperty(methodEntryRequest, "methodNames", object);
            EventRequestWrapper.putProperty(methodEntryRequest, "ReferenceType", referenceType);
            return methodEntryRequest;
        }
        if (eventRequest instanceof MethodExitRequest) {
            JPDAThread[] jPDAThreadArray;
            MethodExitRequest methodExitRequest = EventRequestManagerWrapper.createMethodExitRequest(this.getEventRequestManager());
            ReferenceType referenceType = (ReferenceType)EventRequestWrapper.getProperty(eventRequest, "ReferenceType");
            MethodExitRequestWrapper.addClassFilter(methodExitRequest, referenceType);
            JPDAThread[] jPDAThreadArray3 = this.breakpoint.getThreadFilters((JPDADebugger)this.getDebugger());
            if (jPDAThreadArray3 != null && jPDAThreadArray3.length > 0) {
                jPDAThreadArray = jPDAThreadArray3;
                int n = jPDAThreadArray.length;
                for (int i = 0; i < n; ++i) {
                    JPDAThread jPDAThread = jPDAThreadArray[i];
                    MethodExitRequestWrapper.addThreadFilter(methodExitRequest, ((JPDAThreadImpl)jPDAThread).getThreadReference());
                }
            }
            if ((jPDAThreadArray = this.breakpoint.getInstanceFilters((JPDADebugger)this.getDebugger())) != null && jPDAThreadArray.length > 0) {
                for (JPDAThread jPDAThread : jPDAThreadArray) {
                    MethodExitRequestWrapper.addInstanceFilter(methodExitRequest, (ObjectReference)((JDIVariable)jPDAThread).getJDIValue());
                }
            }
            Object object = EventRequestWrapper.getProperty(eventRequest, "methodNames");
            EventRequestWrapper.putProperty(methodExitRequest, "methodNames", object);
            EventRequestWrapper.putProperty(methodExitRequest, "ReferenceType", referenceType);
            return methodExitRequest;
        }
        return null;
    }

    @Override
    public boolean processCondition(Event event) {
        try {
            if (event instanceof BreakpointEvent) {
                return this.processCondition(event, this.breakpoint.getCondition(), LocatableEventWrapper.thread((BreakpointEvent)event), null);
            }
            if (event instanceof MethodEntryEvent) {
                String string = TypeComponentWrapper.name(MethodEntryEventWrapper.method((MethodEntryEvent)event));
                Set set = (Set)EventRequestWrapper.getProperty(EventWrapper.request(event), "methodNames");
                if (set == null || set.contains(string)) {
                    return this.processCondition(event, this.breakpoint.getCondition(), LocatableEventWrapper.thread((MethodEntryEvent)event), null);
                }
                return false;
            }
            if (event instanceof MethodExitEvent) {
                String string = TypeComponentWrapper.name(MethodExitEventWrapper.method((MethodExitEvent)event));
                Set set = (Set)EventRequestWrapper.getProperty(EventWrapper.request(event), "methodNames");
                if (set == null || set.contains(string)) {
                    boolean bl;
                    Value value = null;
                    VirtualMachine virtualMachine = MirrorWrapper.virtualMachine(event);
                    if (virtualMachine.canGetMethodReturnValues()) {
                        value = ((MethodExitEvent)event).returnValue();
                    }
                    if (bl = this.processCondition(event, this.breakpoint.getCondition(), LocatableEventWrapper.thread((MethodExitEvent)event), value)) {
                        this.returnValueByEvent.put(event, value);
                    }
                    return bl;
                }
                return false;
            }
            return true;
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return true;
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return true;
        }
    }

    @Override
    public boolean exec(Event event) {
        try {
            if (event instanceof BreakpointEvent) {
                return this.perform(event, LocatableEventWrapper.thread((BreakpointEvent)event), LocationWrapper.declaringType(LocatableWrapper.location((LocatableEvent)event)), null);
            }
            if (event instanceof MethodEntryEvent) {
                MethodEntryEvent methodEntryEvent = (MethodEntryEvent)event;
                ReferenceType referenceType = null;
                if (LocatableWrapper.location(methodEntryEvent) != null) {
                    referenceType = LocationWrapper.declaringType(LocatableWrapper.location(methodEntryEvent));
                }
                return this.perform(event, LocatableEventWrapper.thread(methodEntryEvent), referenceType, null);
            }
            if (event instanceof MethodExitEvent) {
                MethodExitEvent methodExitEvent = (MethodExitEvent)event;
                ReferenceType referenceType = null;
                if (LocatableWrapper.location(methodExitEvent) != null) {
                    referenceType = LocationWrapper.declaringType(LocatableWrapper.location(methodExitEvent));
                }
                Value value = this.returnValueByEvent.remove(event);
                return this.perform(event, LocatableEventWrapper.thread(methodExitEvent), referenceType, value);
            }
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return false;
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return false;
        }
        return super.exec(event);
    }

    @Override
    protected void classLoaded(List<ReferenceType> list) {
        boolean bl = false;
        String string = null;
        for (ReferenceType referenceType : list) {
            Iterator<Method> iterator;
            try {
                iterator = ReferenceTypeWrapper.methods0(referenceType).iterator();
            }
            catch (ClassNotPreparedExceptionWrapper classNotPreparedExceptionWrapper) {
                Exceptions.printStackTrace((Throwable)classNotPreparedExceptionWrapper);
                continue;
            }
            MethodEntryRequest methodEntryRequest = null;
            MethodExitRequest methodExitRequest = null;
            HashSet<String> hashSet = null;
            HashSet<String> hashSet2 = null;
            boolean bl2 = false;
            String string2 = this.breakpoint.getMethodName();
            String string3 = referenceType.name();
            int n = string3.lastIndexOf(46);
            if (n > 0) {
                string3 = string3.substring(n + 1);
            }
            if (string2.equals(string3)) {
                string2 = "<init>";
            }
            String string4 = this.breakpoint.getMethodSignature();
            while (iterator.hasNext()) {
                Method method = iterator.next();
                if (MethodWrapper.isBridge0(method)) continue;
                try {
                    JPDAThread jPDAThread;
                    int n2;
                    int n3;
                    JPDAThread[] jPDAThreadArray;
                    JPDAThread[] jPDAThreadArray2;
                    if (!string2.equals("") && (!MethodBreakpointImpl.match(TypeComponentWrapper.name(method), string2) || string4 != null && !MethodBreakpointImpl.egualMethodSignatures(string4, TypeComponentWrapper.signature(method)))) continue;
                    if ((this.breakpoint.getBreakpointType() & 1) != 0) {
                        if (MethodWrapper.location(method) != null && !MethodWrapper.isNative(method)) {
                            jPDAThreadArray2 = MethodWrapper.location(method);
                            jPDAThreadArray = EventRequestManagerWrapper.createBreakpointRequest(this.getEventRequestManager(), (Location)jPDAThreadArray2);
                            this.addEventRequest((EventRequest)jPDAThreadArray);
                            bl2 = true;
                        } else {
                            if (methodEntryRequest == null) {
                                methodEntryRequest = EventRequestManagerWrapper.createMethodEntryRequest(this.getEventRequestManager());
                                MethodEntryRequestWrapper.addClassFilter(methodEntryRequest, referenceType);
                                jPDAThreadArray2 = this.breakpoint.getThreadFilters((JPDADebugger)this.getDebugger());
                                if (jPDAThreadArray2 != null && jPDAThreadArray2.length > 0) {
                                    jPDAThreadArray = jPDAThreadArray2;
                                    n3 = jPDAThreadArray.length;
                                    for (n2 = 0; n2 < n3; ++n2) {
                                        JPDAThread jPDAThread2 = jPDAThreadArray[n2];
                                        MethodEntryRequestWrapper.addThreadFilter(methodEntryRequest, ((JPDAThreadImpl)jPDAThread2).getThreadReference());
                                    }
                                }
                                if ((jPDAThreadArray = this.breakpoint.getInstanceFilters((JPDADebugger)this.getDebugger())) != null && jPDAThreadArray.length > 0) {
                                    JPDAThread[] jPDAThreadArray3 = jPDAThreadArray;
                                    n2 = jPDAThreadArray3.length;
                                    for (int i = 0; i < n2; ++i) {
                                        jPDAThread = jPDAThreadArray3[i];
                                        MethodEntryRequestWrapper.addInstanceFilter(methodEntryRequest, (ObjectReference)((JDIVariable)jPDAThread).getJDIValue());
                                    }
                                }
                                hashSet = new HashSet<String>();
                                EventRequestWrapper.putProperty(methodEntryRequest, "methodNames", hashSet);
                                EventRequestWrapper.putProperty(methodEntryRequest, "ReferenceType", referenceType);
                            }
                            hashSet.add(TypeComponentWrapper.name(method));
                        }
                    }
                    if ((this.breakpoint.getBreakpointType() & 2) == 0) continue;
                    if (methodExitRequest == null) {
                        methodExitRequest = EventRequestManagerWrapper.createMethodExitRequest(this.getEventRequestManager());
                        MethodExitRequestWrapper.addClassFilter(methodExitRequest, referenceType);
                        jPDAThreadArray2 = this.breakpoint.getThreadFilters((JPDADebugger)this.getDebugger());
                        if (jPDAThreadArray2 != null && jPDAThreadArray2.length > 0) {
                            jPDAThreadArray = jPDAThreadArray2;
                            n3 = jPDAThreadArray.length;
                            for (n2 = 0; n2 < n3; ++n2) {
                                JPDAThread jPDAThread3 = jPDAThreadArray[n2];
                                MethodExitRequestWrapper.addThreadFilter(methodExitRequest, ((JPDAThreadImpl)jPDAThread3).getThreadReference());
                            }
                        }
                        if ((jPDAThreadArray = this.breakpoint.getInstanceFilters((JPDADebugger)this.getDebugger())) != null && jPDAThreadArray.length > 0) {
                            JPDAThread[] jPDAThreadArray4 = jPDAThreadArray;
                            n2 = jPDAThreadArray4.length;
                            for (int i = 0; i < n2; ++i) {
                                jPDAThread = jPDAThreadArray4[i];
                                MethodExitRequestWrapper.addInstanceFilter(methodExitRequest, (ObjectReference)((JDIVariable)jPDAThread).getJDIValue());
                            }
                        }
                        hashSet2 = new HashSet<String>();
                        EventRequestWrapper.putProperty(methodExitRequest, "methodNames", hashSet2);
                        EventRequestWrapper.putProperty(methodExitRequest, "ReferenceType", referenceType);
                    }
                    hashSet2.add(TypeComponentWrapper.name(method));
                }
                catch (InternalExceptionWrapper internalExceptionWrapper) {
                }
                catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
                }
                catch (InvalidRequestStateExceptionWrapper invalidRequestStateExceptionWrapper) {
                    Exceptions.printStackTrace((Throwable)invalidRequestStateExceptionWrapper);
                }
                catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                    return;
                }
            }
            try {
                if (methodEntryRequest != null) {
                    try {
                        this.addEventRequest(methodEntryRequest);
                    }
                    catch (InternalExceptionWrapper internalExceptionWrapper) {
                        methodEntryRequest = null;
                    }
                    catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
                        methodEntryRequest = null;
                    }
                    catch (InvalidRequestStateExceptionWrapper invalidRequestStateExceptionWrapper) {
                        Exceptions.printStackTrace((Throwable)invalidRequestStateExceptionWrapper);
                        methodEntryRequest = null;
                    }
                }
                if (methodExitRequest != null) {
                    try {
                        this.addEventRequest(methodExitRequest);
                    }
                    catch (InternalExceptionWrapper internalExceptionWrapper) {
                        methodExitRequest = null;
                    }
                    catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
                        methodExitRequest = null;
                    }
                    catch (InvalidRequestStateExceptionWrapper invalidRequestStateExceptionWrapper) {
                        Exceptions.printStackTrace((Throwable)invalidRequestStateExceptionWrapper);
                        methodExitRequest = null;
                    }
                }
            }
            catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                return;
            }
            if (bl2 || methodEntryRequest != null || methodExitRequest != null) {
                bl = true;
                continue;
            }
            if (string4 == null) {
                string = NbBundle.getMessage(MethodBreakpointImpl.class, (String)"MSG_NoMethod", (Object)referenceType.name(), (Object)string2);
                continue;
            }
            string = NbBundle.getMessage(MethodBreakpointImpl.class, (String)"MSG_NoMethodSign", (Object)referenceType.name(), (Object)string2, (Object)string4);
        }
        if (bl) {
            this.setValidity(Breakpoint.VALIDITY.VALID, null);
        } else {
            this.setValidity(Breakpoint.VALIDITY.INVALID, string);
        }
    }

    private static boolean egualMethodSignatures(String string, String string2) {
        int n = string.lastIndexOf(")");
        if (n > 0) {
            string = string.substring(0, n);
        }
        if ((n = string2.lastIndexOf(")")) > 0) {
            string2 = string2.substring(0, n);
        }
        return string.equals(string2);
    }
}

