/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entries;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import java.util.Set;
import javax.lang.model.element.TypeElement;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ui.TypeElementFinder;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class ServiceLocatorStrategyPanel
extends JPanel {
    public static final String IS_VALID = "ServiceLocatorStrategyPanel_isValid";
    private final ClasspathInfo cpInfo;
    private ButtonGroup buttonGroup1;
    private JTextField className;
    private JButton jButton1;
    private JRadioButton noServiceLocator;
    private JRadioButton unreferencedServiceLocator;

    public ServiceLocatorStrategyPanel(String string, ClasspathInfo classpathInfo) {
        this.initComponents();
        this.cpInfo = classpathInfo;
        if (string != null) {
            this.unreferencedServiceLocator.doClick();
            this.className.setText(string);
        } else {
            this.noServiceLocator.doClick();
        }
        this.className.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                ServiceLocatorStrategyPanel.this.validateClass();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                ServiceLocatorStrategyPanel.this.validateClass();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                ServiceLocatorStrategyPanel.this.validateClass();
            }
        });
    }

    public String classSelected() {
        return this.unreferencedServiceLocator.isSelected() ? this.className.getText() : null;
    }

    public JRadioButton getUnreferencedServiceLocator() {
        return this.unreferencedServiceLocator;
    }

    public JTextField getClassName() {
        return this.className;
    }

    private void validateClass() {
        if (this.unreferencedServiceLocator.isSelected()) {
            if (Utilities.isJavaIdentifier((String)this.className.getText())) {
                this.firePropertyChange(IS_VALID, false, true);
            } else {
                this.firePropertyChange(IS_VALID, true, false);
            }
        } else {
            this.firePropertyChange(IS_VALID, false, true);
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.noServiceLocator = new JRadioButton();
        this.unreferencedServiceLocator = new JRadioButton();
        this.className = new JTextField();
        this.jButton1 = new JButton();
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ui/logicalview/entries/Bundle");
        this.setBorder(BorderFactory.createTitledBorder(resourceBundle.getString("LBL_ServiceLocatorStrategy")));
        this.setLayout(new GridBagLayout());
        this.buttonGroup1.add(this.noServiceLocator);
        this.noServiceLocator.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.noServiceLocator, (String)resourceBundle.getString("LBL_NoServiceLocator"));
        this.noServiceLocator.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ServiceLocatorStrategyPanel.this.noLocator(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.add((Component)this.noServiceLocator, gridBagConstraints);
        this.noServiceLocator.getAccessibleContext().setAccessibleName("&Generator inline lookup code");
        this.noServiceLocator.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServiceLocatorStrategyPanel.class, (String)"ACSD_NoServiceLocator"));
        this.buttonGroup1.add(this.unreferencedServiceLocator);
        Mnemonics.setLocalizedText((AbstractButton)this.unreferencedServiceLocator, (String)resourceBundle.getString("LBL_UseServiceLocatorClass"));
        this.unreferencedServiceLocator.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ServiceLocatorStrategyPanel.this.unreferencedServiceLocatorItemStateChanged(itemEvent);
            }
        });
        this.unreferencedServiceLocator.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ServiceLocatorStrategyPanel.this.existingClassPressed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.add((Component)this.unreferencedServiceLocator, gridBagConstraints);
        this.unreferencedServiceLocator.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServiceLocatorStrategyPanel.class, (String)"ACSD_UseServiceLocatorClass"));
        this.className.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ServiceLocatorStrategyPanel.this.classNameActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        this.add((Component)this.className, gridBagConstraints);
        this.className.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACS_ExistingClassName"));
        this.className.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACS_ExistingClassName"));
        this.jButton1.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ui/logicalview/entries/Bundle").getString("MN_Browse").charAt(0));
        this.jButton1.setText("...");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ServiceLocatorStrategyPanel.this.jButton1ActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.add((Component)this.jButton1, gridBagConstraints);
        this.jButton1.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACS_Browse"));
        this.jButton1.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACS_Browse"));
    }

    private void classNameActionPerformed(ActionEvent actionEvent) {
        this.validateClass();
    }

    private void jButton1ActionPerformed(ActionEvent actionEvent) {
        this.className.setEnabled(true);
        this.unreferencedServiceLocator.setSelected(true);
        ElementHandle elementHandle = TypeElementFinder.find((ClasspathInfo)this.cpInfo, (TypeElementFinder.Customizer)new TypeElementFinder.Customizer(){

            public Set<ElementHandle<TypeElement>> query(ClasspathInfo classpathInfo, String string, ClassIndex.NameKind nameKind, Set<ClassIndex.SearchScope> set) {
                return classpathInfo.getClassIndex().getDeclaredTypes(string, nameKind, set);
            }

            public boolean accept(ElementHandle<TypeElement> elementHandle) {
                return true;
            }
        });
        if (elementHandle != null) {
            this.className.setText(elementHandle.getQualifiedName());
        }
    }

    private void unreferencedServiceLocatorItemStateChanged(ItemEvent itemEvent) {
        this.validateClass();
    }

    private void noLocator(ActionEvent actionEvent) {
        this.disableSelectors();
    }

    private void existingClassPressed(ActionEvent actionEvent) {
        this.disableSelectors();
        this.className.setEnabled(true);
        this.validateClass();
    }

    private void disableSelectors() {
        this.className.setEnabled(false);
    }
}

