/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.callgraph.impl;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.netbeans.api.visual.graph.GraphScene;
import org.netbeans.api.visual.graph.layout.GraphLayout;
import org.netbeans.api.visual.graph.layout.GridGraphLayout;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.layout.SceneLayout;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.modules.cnd.callgraph.api.Call;
import org.netbeans.modules.cnd.callgraph.api.CallModel;
import org.netbeans.modules.cnd.callgraph.api.Function;
import org.netbeans.modules.cnd.callgraph.impl.CallGraphScene;
import org.netbeans.modules.cnd.callgraph.impl.CallGraphState;
import org.netbeans.modules.cnd.callgraph.impl.CallNode;
import org.netbeans.modules.cnd.callgraph.impl.ExportAction;
import org.netbeans.modules.cnd.callgraph.impl.FunctionRootNode;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.explorer.view.ListView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.actions.Presenter;
import org.openide.windows.TopComponent;

public class CallGraphPanel
extends JPanel
implements ExplorerManager.Provider,
HelpCtx.Provider {
    private ExplorerManager explorerManager = new ExplorerManager();
    private AbstractNode root;
    private Action[] actions;
    private CallModel model;
    private boolean showGraph;
    private boolean isCalls;
    private boolean isShowOverriding;
    public static final String IS_CALLS = "CallGraphIsCalls";
    public static final String IS_SHOW_OVERRIDING = "CallGraphIsShowOverriding";
    private CallGraphScene scene;
    private static double dividerLocation = 0.5;
    private FocusTraversalPolicy newPolicy;
    private static final boolean isMacLaf = "Aqua".equals(UIManager.getLookAndFeel().getID());
    private static final Color macBackground = UIManager.getColor("NbExplorerView.background");
    private JToggleButton callers;
    private JToggleButton calls;
    private JPanel contextPanel;
    private JButton focusOn;
    private JScrollPane graphView;
    private JToolBar.Separator jSeparator1;
    private JSplitPane jSplitPane1;
    private JSplitPane jSplitPane2;
    private JToolBar jToolBar1;
    private JToggleButton overriding;
    private JButton refresh;
    private JScrollPane treeView;

    public CallGraphPanel(boolean showGraph) {
        this.initComponents();
        this.isCalls = NbPreferences.forModule(CallGraphPanel.class).getBoolean(IS_CALLS, true);
        this.isShowOverriding = NbPreferences.forModule(CallGraphPanel.class).getBoolean(IS_SHOW_OVERRIDING, false);
        this.getTreeView().setRootVisible(false);
        Children.SortedArray children = new Children.SortedArray();
        this.showGraph = showGraph;
        if (showGraph) {
            this.scene = new CallGraphScene();
            this.actions = new Action[]{new RefreshAction(), new FocusOnAction(), null, new WhoIsCalledAction(), new WhoCallsAction(), new ShowOverridingAction(), null, new ExportAction((Scene)this.scene, this)};
            this.scene.setExportAction(this.actions[this.actions.length - 1]);
        } else {
            this.actions = new Action[]{new RefreshAction(), new FocusOnAction(), null, new WhoIsCalledAction(), new WhoCallsAction(), new ShowOverridingAction()};
        }
        this.root = new AbstractNode((Children)children){

            public Action[] getActions(boolean context) {
                return CallGraphPanel.this.actions;
            }
        };
        this.getExplorerManager().setRootContext((Node)this.root);
        if (showGraph) {
            this.addComponentListener(new ComponentListener(){

                @Override
                public void componentResized(ComponentEvent e) {
                    CallGraphPanel.this.jSplitPane1.setDividerLocation(dividerLocation);
                }

                @Override
                public void componentMoved(ComponentEvent e) {
                }

                @Override
                public void componentShown(ComponentEvent e) {
                }

                @Override
                public void componentHidden(ComponentEvent e) {
                }
            });
            this.jSplitPane1.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("dividerLocation".equals(evt.getPropertyName())) {
                        dividerLocation = (double)CallGraphPanel.this.jSplitPane1.getDividerLocation() / (double)(CallGraphPanel.this.jSplitPane1.getWidth() - CallGraphPanel.this.jSplitPane1.getDividerSize());
                    }
                }
            });
            this.initGraph();
        } else {
            Component left = this.jSplitPane1.getLeftComponent();
            this.remove(this.jSplitPane1);
            this.jSplitPane1.remove(left);
            this.add(left, "Center");
        }
        this.getExplorerManager().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Node[] selectedNodes = CallGraphPanel.this.getExplorerManager().getSelectedNodes();
                if (selectedNodes.length == 1) {
                    Node selected = selectedNodes[0];
                    if (selected instanceof CallNode) {
                        CallGraphPanel.this.getContextPanel().setRootContent((CallNode)selected);
                    } else {
                        CallGraphPanel.this.getContextPanel().setRootContent(null);
                    }
                }
            }
        });
        ArrayList<Component> order = new ArrayList<Component>();
        order.add(this.treeView);
        order.add(this.contextPanel);
        order.add(this.refresh);
        order.add(this.focusOn);
        order.add(this.calls);
        order.add(this.callers);
        this.newPolicy = new MyOwnFocusTraversalPolicy(this, order);
        this.setFocusTraversalPolicy(this.newPolicy);
        if (isMacLaf) {
            this.jToolBar1.setBackground(macBackground);
        }
    }

    private void initGraph() {
        JComponent view = this.scene.createView();
        this.graphView.setViewportView(view);
        view.setFocusable(this.isCalls);
        GridGraphLayout layout = new GridGraphLayout();
        SceneLayout sceneLayout = LayoutFactory.createSceneGraphLayout((GraphScene)this.scene, (GraphLayout)layout);
        this.scene.setLayout(sceneLayout);
        sceneLayout.invokeLayout();
        this.graphView.setFocusable(false);
    }

    private void initComponents() {
        this.jToolBar1 = new JToolBar();
        this.refresh = new JButton();
        this.focusOn = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.calls = new JToggleButton();
        this.callers = new JToggleButton();
        this.overriding = new JToggleButton();
        this.jSplitPane1 = new JSplitPane();
        this.graphView = new JScrollPane();
        this.jSplitPane2 = new JSplitPane();
        this.treeView = new BeanTreeView();
        this.contextPanel = new ContextPanel();
        this.setFocusCycleRoot(true);
        this.setLayout(new BorderLayout());
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setOrientation(1);
        this.jToolBar1.setRollover(true);
        this.jToolBar1.setFocusable(false);
        this.refresh.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/cnd/callgraph/resources/refresh.png")));
        this.refresh.setToolTipText(NbBundle.getMessage(CallGraphPanel.class, (String)"RefreshActionTooltip"));
        this.refresh.setHorizontalTextPosition(0);
        this.refresh.setMaximumSize(new Dimension(28, 28));
        this.refresh.setMinimumSize(new Dimension(28, 28));
        this.refresh.setPreferredSize(new Dimension(28, 28));
        this.refresh.setVerticalTextPosition(3);
        this.refresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CallGraphPanel.this.refreshActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.refresh);
        this.focusOn.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/cnd/callgraph/resources/focus_on.png")));
        this.focusOn.setToolTipText(NbBundle.getMessage(CallGraphPanel.class, (String)"FocusOnActionTooltip"));
        this.focusOn.setHorizontalTextPosition(0);
        this.focusOn.setMaximumSize(new Dimension(28, 28));
        this.focusOn.setMinimumSize(new Dimension(28, 28));
        this.focusOn.setPreferredSize(new Dimension(28, 28));
        this.focusOn.setVerticalTextPosition(3);
        this.focusOn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CallGraphPanel.this.focusOnActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.focusOn);
        this.jSeparator1.setSeparatorSize(new Dimension(0, 4));
        this.jToolBar1.add(this.jSeparator1);
        this.calls.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/cnd/callgraph/resources/who_is_called.png")));
        this.calls.setToolTipText(NbBundle.getMessage(CallGraphPanel.class, (String)"CallsActionTooltip"));
        this.calls.setHorizontalTextPosition(0);
        this.calls.setMaximumSize(new Dimension(28, 28));
        this.calls.setMinimumSize(new Dimension(28, 28));
        this.calls.setPreferredSize(new Dimension(28, 28));
        this.calls.setVerticalTextPosition(3);
        this.calls.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CallGraphPanel.this.callsActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.calls);
        this.callers.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/cnd/callgraph/resources/who_calls.png")));
        this.callers.setToolTipText(NbBundle.getMessage(CallGraphPanel.class, (String)"CallersActionTooltip"));
        this.callers.setHorizontalTextPosition(0);
        this.callers.setMaximumSize(new Dimension(28, 28));
        this.callers.setMinimumSize(new Dimension(28, 28));
        this.callers.setPreferredSize(new Dimension(28, 28));
        this.callers.setVerticalTextPosition(3);
        this.callers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CallGraphPanel.this.callersActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.callers);
        this.overriding.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/cnd/callgraph/resources/show_overriding.gif")));
        this.overriding.setToolTipText(NbBundle.getMessage(CallGraphPanel.class, (String)"CallGraphPanel.overriding.toolTipText"));
        this.overriding.setFocusable(false);
        this.overriding.setHorizontalTextPosition(0);
        this.overriding.setMaximumSize(new Dimension(28, 28));
        this.overriding.setMinimumSize(new Dimension(28, 28));
        this.overriding.setPreferredSize(new Dimension(28, 28));
        this.overriding.setVerticalTextPosition(3);
        this.overriding.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CallGraphPanel.this.overridingActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.overriding);
        this.add((Component)this.jToolBar1, "Before");
        this.jSplitPane1.setDividerLocation(200);
        this.jSplitPane1.setResizeWeight(0.5);
        this.jSplitPane1.setFocusable(false);
        this.jSplitPane1.setOneTouchExpandable(true);
        this.graphView.setFocusable(false);
        this.jSplitPane1.setRightComponent(this.graphView);
        this.graphView.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CallGraphPanel.class, (String)"pictorial.part"));
        this.graphView.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CallGraphPanel.class, (String)"pictorial.part"));
        this.jSplitPane2.setOrientation(0);
        this.jSplitPane2.setResizeWeight(1.0);
        this.jSplitPane2.setFocusable(false);
        this.jSplitPane2.setLeftComponent(this.treeView);
        this.treeView.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CallGraphPanel.class, (String)"CGP_TreeView_AN"));
        this.treeView.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CallGraphPanel.class, (String)"CGP_TreeView_AD"));
        this.jSplitPane2.setRightComponent(this.contextPanel);
        this.contextPanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CallGraphPanel.class, (String)"CGP_ListView_AM"));
        this.contextPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CallGraphPanel.class, (String)"CGP_ListView_AD"));
        this.jSplitPane1.setLeftComponent(this.jSplitPane2);
        this.add((Component)this.jSplitPane1, "Center");
    }

    private void refreshActionPerformed(ActionEvent evt) {
        this.update();
    }

    private void callsActionPerformed(ActionEvent evt) {
        if (this.isCalls == this.calls.isSelected()) {
            return;
        }
        this.setDirection(true);
    }

    private void callersActionPerformed(ActionEvent evt) {
        if (this.isCalls != this.callers.isSelected()) {
            return;
        }
        this.setDirection(false);
    }

    private void focusOnActionPerformed(ActionEvent evt) {
        Node[] nodes = this.getExplorerManager().getSelectedNodes();
        if (nodes == null || nodes.length != 1) {
            return;
        }
        Node node = nodes[0];
        if (node instanceof FunctionRootNode) {
            this.update();
        } else if (node instanceof CallNode) {
            Call call = ((CallNode)node).getCall();
            if (this.isCalls) {
                this.model.setRoot(call.getCallee());
            } else {
                this.model.setRoot(call.getCaller());
            }
            this.setName(this.model.getName());
            this.setToolTipText(this.getName() + " - " + NbBundle.getMessage(this.getClass(), (String)"CTL_CallGraphTopComponent"));
            Container parent = this.getParent();
            while (parent != null) {
                if (parent instanceof JTabbedPane) {
                    int i = ((JTabbedPane)parent).getSelectedIndex();
                    if (i < 0) break;
                    ((JTabbedPane)parent).setTitleAt(i, this.getName() + "  ");
                    break;
                }
                if (!(parent instanceof TopComponent)) continue;
                ((TopComponent)parent).setName(this.getToolTipText());
                break;
            }
            this.update();
        }
    }

    private void overridingActionPerformed(ActionEvent evt) {
        this.setShowOverriding(!this.isShowOverriding);
    }

    private void setShowOverriding(boolean showOverriding) {
        this.isShowOverriding = showOverriding;
        NbPreferences.forModule(CallGraphPanel.class).putBoolean(IS_SHOW_OVERRIDING, this.isShowOverriding);
        this.updateButtons();
        this.update();
    }

    private void setDirection(boolean direction) {
        this.isCalls = direction;
        NbPreferences.forModule(CallGraphPanel.class).putBoolean(IS_CALLS, this.isCalls);
        this.updateButtons();
        this.update();
    }

    private void updateButtons() {
        this.calls.setSelected(this.isCalls);
        this.callers.setSelected(!this.isCalls);
        this.overriding.setSelected(this.isShowOverriding);
    }

    public void setModel(CallModel model) {
        this.model = model;
        if (this.showGraph) {
            this.scene.setModel(model);
        }
        this.updateButtons();
        this.update();
    }

    private synchronized void update() {
        Function function;
        if (this.showGraph) {
            this.scene.clean();
            this.scene.setShowOverriding(this.isShowOverriding);
        }
        if ((function = this.model.getRoot()) != null) {
            final Children children = this.root.getChildren();
            if (!Children.MUTEX.isReadAccess()) {
                Children.MUTEX.writeAccess(new Runnable(){

                    @Override
                    public void run() {
                        children.remove(children.getNodes());
                        CallGraphState state = new CallGraphState(CallGraphPanel.this.model, CallGraphPanel.this.scene, CallGraphPanel.this.actions);
                        FunctionRootNode node = new FunctionRootNode(function, state, CallGraphPanel.this.isCalls, CallGraphPanel.this.isShowOverriding);
                        children.add(new Node[]{node});
                        try {
                            CallGraphPanel.this.getExplorerManager().setSelectedNodes(new Node[]{node});
                        }
                        catch (PropertyVetoException propertyVetoException) {
                            // empty catch block
                        }
                        SwingUtilities.invokeLater(new Runnable((Node)node){
                            final /* synthetic */ Node val$node;
                            {
                                this.val$node = node;
                            }

                            @Override
                            public void run() {
                                CallGraphPanel.this.getTreeView().expandNode(this.val$node);
                            }
                        });
                    }
                });
            }
        } else {
            final Children children = this.root.getChildren();
            if (!Children.MUTEX.isReadAccess()) {
                Children.MUTEX.writeAccess(new Runnable(){

                    @Override
                    public void run() {
                        children.remove(children.getNodes());
                    }
                });
            }
        }
    }

    @Override
    public void requestFocus() {
        super.requestFocus();
        this.treeView.requestFocus();
    }

    @Override
    public boolean requestFocusInWindow() {
        super.requestFocusInWindow();
        return this.treeView.requestFocusInWindow();
    }

    public final BeanTreeView getTreeView() {
        return (BeanTreeView)this.treeView;
    }

    private ContextPanel getContextPanel() {
        return (ContextPanel)this.contextPanel;
    }

    public final ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("CallGraphView");
    }

    public static class MyOwnFocusTraversalPolicy
    extends FocusTraversalPolicy {
        private ArrayList<Component> order;
        private Container panel;

        public MyOwnFocusTraversalPolicy(Container panel, List<Component> order) {
            this.order = new ArrayList(order.size());
            this.order.addAll(order);
            this.panel = panel;
        }

        @Override
        public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
            if (focusCycleRoot == this.panel) {
                int idx = this.getIndex(aComponent);
                idx = (idx + 1) % this.order.size();
                return this.getComponentAtIndex(idx);
            }
            return null;
        }

        private int getIndex(Component aComponent) {
            int idx = this.order.indexOf(aComponent);
            while (idx == -1) {
                if ((aComponent = aComponent.getParent()) == null) {
                    return -1;
                }
                idx = this.order.indexOf(aComponent);
            }
            return idx;
        }

        private Component getComponentAtIndex(int idx) {
            if (idx == 0) {
                return ((BeanTreeView)this.order.get(idx)).getViewport().getView();
            }
            if (idx == 1) {
                return ((ContextPanel)this.order.get(idx)).listView.getViewport().getView();
            }
            return this.order.get(idx);
        }

        @Override
        public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
            if (focusCycleRoot == this.panel) {
                int idx = this.getIndex(aComponent) - 1;
                if (idx < 0) {
                    idx = this.order.size() - 1;
                }
                return this.getComponentAtIndex(idx);
            }
            return null;
        }

        @Override
        public Component getDefaultComponent(Container focusCycleRoot) {
            if (focusCycleRoot == this.panel) {
                return this.getComponentAtIndex(0);
            }
            return null;
        }

        @Override
        public Component getLastComponent(Container focusCycleRoot) {
            if (focusCycleRoot == this.panel) {
                return this.getComponentAtIndex(this.order.size() - 1);
            }
            return null;
        }

        @Override
        public Component getFirstComponent(Container focusCycleRoot) {
            if (focusCycleRoot == this.panel) {
                return this.getComponentAtIndex(0);
            }
            return null;
        }
    }

    private static final class ContextPanel
    extends JPanel
    implements ExplorerManager.Provider {
        private ExplorerManager managerCtx = new ExplorerManager();
        private ListView listView = new ListView();

        private ContextPanel() {
            this.listView.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CallGraphPanel.class, (String)"CGP_ListView_AM"));
            this.listView.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CallGraphPanel.class, (String)"CGP_ListView_AD"));
            this.setLayout(new BorderLayout());
            this.add((Component)this.listView, "Center");
            this.listView.setFocusable(false);
            this.listView.setHorizontalScrollBarPolicy(31);
        }

        public ExplorerManager getExplorerManager() {
            return this.managerCtx;
        }

        @Override
        public boolean requestFocusInWindow() {
            super.requestFocusInWindow();
            return this.listView.requestFocusInWindow();
        }

        private void setRootContent(CallNode node) {
            List list;
            if (node == null) {
                list = Collections.emptyList();
            } else {
                list = new ArrayList(1);
                Call call = node.getCall();
                list.add(new CallContext(call));
            }
            CallContextRoot root = new CallContextRoot(new ContextList(list));
            this.getExplorerManager().setRootContext((Node)root);
        }

        public static class CallContext
        extends AbstractNode {
            private Call call;

            public CallContext(Call element) {
                super(Children.LEAF);
                this.call = element;
            }

            public String getHtmlDisplayName() {
                if (this.call != null) {
                    return this.call.getHtmlDisplayName();
                }
                return super.getHtmlDisplayName();
            }

            public Action getPreferredAction() {
                return null;
            }

            public String getShortDescription() {
                String ret = this.call.getDescription();
                if (ret != null) {
                    return ret;
                }
                return super.getShortDescription();
            }

            public Action[] getActions(boolean context) {
                return new Action[0];
            }
        }

        private static final class CallContextRoot
        extends AbstractNode {
            public CallContextRoot(Children.Array array) {
                super((Children)array);
            }
        }

        private static final class ContextList
        extends Children.Array {
            private ContextList(Collection<Node> nodes) {
                super(nodes);
            }
        }
    }

    private final class FocusOnAction
    extends AbstractAction
    implements Presenter.Popup {
        private JMenuItem menuItem;

        public FocusOnAction() {
            this.putValue("Name", NbBundle.getMessage(CallGraphPanel.class, (String)"FocusOnAction"));
            this.putValue("SmallIcon", CallGraphPanel.this.focusOn.getIcon());
            this.menuItem = new JMenuItem(this);
            Mnemonics.setLocalizedText((AbstractButton)this.menuItem, (String)((String)this.getValue("Name")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CallGraphPanel.this.focusOnActionPerformed(e);
        }

        public final JMenuItem getPopupPresenter() {
            return this.menuItem;
        }
    }

    private final class ShowOverridingAction
    extends AbstractAction
    implements Presenter.Popup {
        private JCheckBoxMenuItem menuItem;

        public ShowOverridingAction() {
            this.putValue("Name", NbBundle.getMessage(CallGraphPanel.class, (String)"ShowOverridingAction"));
            this.putValue("SmallIcon", CallGraphPanel.this.overriding.getIcon());
            this.menuItem = new JCheckBoxMenuItem(this);
            Mnemonics.setLocalizedText((AbstractButton)this.menuItem, (String)((String)this.getValue("Name")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CallGraphPanel.this.setShowOverriding(!CallGraphPanel.this.isShowOverriding);
        }

        public final JMenuItem getPopupPresenter() {
            this.menuItem.setSelected(CallGraphPanel.this.isShowOverriding);
            return this.menuItem;
        }
    }

    private final class WhoIsCalledAction
    extends AbstractAction
    implements Presenter.Popup {
        private JRadioButtonMenuItem menuItem;

        public WhoIsCalledAction() {
            this.putValue("Name", NbBundle.getMessage(CallGraphPanel.class, (String)"CallsAction"));
            this.putValue("SmallIcon", CallGraphPanel.this.calls.getIcon());
            this.menuItem = new JRadioButtonMenuItem(this);
            Mnemonics.setLocalizedText((AbstractButton)this.menuItem, (String)((String)this.getValue("Name")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CallGraphPanel.this.setDirection(true);
        }

        public final JMenuItem getPopupPresenter() {
            this.menuItem.setSelected(CallGraphPanel.this.isCalls);
            return this.menuItem;
        }
    }

    private final class WhoCallsAction
    extends AbstractAction
    implements Presenter.Popup {
        private JRadioButtonMenuItem menuItem;

        public WhoCallsAction() {
            this.putValue("Name", NbBundle.getMessage(CallGraphPanel.class, (String)"CallersAction"));
            this.putValue("SmallIcon", CallGraphPanel.this.callers.getIcon());
            this.menuItem = new JRadioButtonMenuItem(this);
            Mnemonics.setLocalizedText((AbstractButton)this.menuItem, (String)((String)this.getValue("Name")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CallGraphPanel.this.setDirection(false);
        }

        public final JMenuItem getPopupPresenter() {
            this.menuItem.setSelected(!CallGraphPanel.this.isCalls);
            return this.menuItem;
        }
    }

    private final class RefreshAction
    extends AbstractAction
    implements Presenter.Popup {
        private JMenuItem menuItem;

        public RefreshAction() {
            this.putValue("Name", NbBundle.getMessage(CallGraphPanel.class, (String)"RefreshAction"));
            this.putValue("SmallIcon", CallGraphPanel.this.refresh.getIcon());
            this.menuItem = new JMenuItem(this);
            Mnemonics.setLocalizedText((AbstractButton)this.menuItem, (String)((String)this.getValue("Name")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CallGraphPanel.this.refreshActionPerformed(e);
        }

        public final JMenuItem getPopupPresenter() {
            return this.menuItem;
        }
    }
}

