/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.actions;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.debugger.jpda.ui.EditorContextBridge;
import org.netbeans.spi.debugger.ActionsProviderSupport;
import org.netbeans.spi.debugger.ContextProvider;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class ToggleBreakpointActionProvider
extends ActionsProviderSupport
implements PropertyChangeListener {
    private JPDADebugger debugger;

    public ToggleBreakpointActionProvider() {
        EditorContextBridge.getContext().addPropertyChangeListener((PropertyChangeListener)this);
    }

    public ToggleBreakpointActionProvider(ContextProvider contextProvider) {
        this.debugger = (JPDADebugger)contextProvider.lookupFirst(null, JPDADebugger.class);
        this.debugger.addPropertyChangeListener("state", (PropertyChangeListener)this);
        EditorContextBridge.getContext().addPropertyChangeListener((PropertyChangeListener)this);
    }

    private void destroy() {
        this.debugger.removePropertyChangeListener("state", (PropertyChangeListener)this);
        EditorContextBridge.getContext().removePropertyChangeListener((PropertyChangeListener)this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        FileObject fileObject;
        String string = EditorContextBridge.getContext().getCurrentURL();
        try {
            fileObject = URLMapper.findFileObject((URL)new URL(string));
        }
        catch (MalformedURLException malformedURLException) {
            fileObject = null;
        }
        this.setEnabled(ActionsManager.ACTION_TOGGLE_BREAKPOINT, EditorContextBridge.getContext().getCurrentLineNumber() >= 0 && fileObject != null && "text/x-java".equals(fileObject.getMIMEType()));
        if (this.debugger != null && this.debugger.getState() == 4) {
            this.destroy();
        }
    }

    public Set getActions() {
        return Collections.singleton(ActionsManager.ACTION_TOGGLE_BREAKPOINT);
    }

    public void doAction(Object object) {
        DebuggerManager debuggerManager = DebuggerManager.getDebuggerManager();
        int n = EditorContextBridge.getContext().getCurrentLineNumber();
        String string = EditorContextBridge.getContext().getCurrentURL();
        if ("".equals(string.trim())) {
            return;
        }
        LineBreakpoint lineBreakpoint = ToggleBreakpointActionProvider.findBreakpoint(string, n);
        if (lineBreakpoint != null) {
            debuggerManager.removeBreakpoint((Breakpoint)lineBreakpoint);
            return;
        }
        JEditorPane[] jEditorPaneArray = new JEditorPane[1];
        int n2 = this.checkLineBreakability(string, n, jEditorPaneArray);
        if (n2 != n) {
            if (n2 == -1 || ToggleBreakpointActionProvider.findBreakpoint(string, n2) != null) {
                Toolkit.getDefaultToolkit().beep();
                if (jEditorPaneArray[0] != null) {
                    Utilities.setStatusText((JTextComponent)jEditorPaneArray[0], (String)"");
                    String string2 = NbBundle.getMessage(ToggleBreakpointActionProvider.class, (String)"CTL_Cannot_Toggle_Breakpoint");
                    Utilities.setStatusText((JTextComponent)jEditorPaneArray[0], (String)string2);
                }
                return;
            }
            if (jEditorPaneArray[0] != null) {
                Utilities.setStatusText((JTextComponent)jEditorPaneArray[0], (String)"");
                String string3 = NbBundle.getMessage(ToggleBreakpointActionProvider.class, (String)"CTL_Breakpoint_Position_Adjusted");
                Utilities.setStatusText((JTextComponent)jEditorPaneArray[0], (String)string3);
            }
            n = n2;
        }
        lineBreakpoint = LineBreakpoint.create((String)string, (int)n);
        lineBreakpoint.setPrintText(NbBundle.getBundle(ToggleBreakpointActionProvider.class).getString("CTL_Line_Breakpoint_Print_Text"));
        debuggerManager.addBreakpoint((Breakpoint)lineBreakpoint);
    }

    public void postAction(final Object object, final Runnable runnable) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ToggleBreakpointActionProvider.this.doAction(object);
                runnable.run();
            }
        });
    }

    private int checkLineBreakability(String string, int n, final JEditorPane[] jEditorPaneArray) {
        Object[] objectArray;
        block23: {
            int n2;
            FileObject fileObject = null;
            try {
                fileObject = URLMapper.findFileObject((URL)new URL(string));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            if (fileObject == null) {
                return n;
            }
            DataObject dataObject = null;
            try {
                dataObject = DataObject.find((FileObject)fileObject);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
            if (dataObject == null) {
                return n;
            }
            final EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
            if (editorCookie == null) {
                return n;
            }
            BaseDocument baseDocument = (BaseDocument)editorCookie.getDocument();
            if (baseDocument == null) {
                return n;
            }
            final int n3 = Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)(n - 1));
            try {
                n2 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n3);
            }
            catch (BadLocationException badLocationException) {
                return n;
            }
            JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
            if (javaSource == null) {
                return n;
            }
            if (SwingUtilities.isEventDispatchThread()) {
                objectArray = editorCookie.getOpenedPanes();
                if (objectArray != null && objectArray.length > 0) {
                    jEditorPaneArray[0] = objectArray[0];
                }
            } else {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            JEditorPane[] jEditorPaneArray2 = editorCookie.getOpenedPanes();
                            if (jEditorPaneArray2 != null && jEditorPaneArray2.length > 0) {
                                jEditorPaneArray[0] = jEditorPaneArray2[0];
                            }
                        }
                    });
                }
                catch (InvocationTargetException invocationTargetException) {
                    Exceptions.printStackTrace((Throwable)invocationTargetException);
                }
                catch (InterruptedException interruptedException) {
                    Exceptions.printStackTrace((Throwable)interruptedException);
                }
            }
            objectArray = new int[]{n};
            try {
                Future future = javaSource.runWhenScanFinished((Task)new CancellableTask<CompilationController>((int[])objectArray, baseDocument){
                    final /* synthetic */ int[] val$result;
                    final /* synthetic */ BaseDocument val$doc;
                    {
                        this.val$result = nArray;
                        this.val$doc = baseDocument;
                    }

                    public void cancel() {
                    }

                    public void run(CompilationController compilationController) throws Exception {
                        if (compilationController.toPhase(JavaSource.Phase.RESOLVED).compareTo((Enum)JavaSource.Phase.RESOLVED) < 0) {
                            ErrorManager.getDefault().log(16, "Unable to resolve " + compilationController.getFileObject() + " to phase " + JavaSource.Phase.RESOLVED + ", current phase = " + compilationController.getPhase() + "\nDiagnostics = " + compilationController.getDiagnostics() + "\nFree memory = " + Runtime.getRuntime().freeMemory());
                            return;
                        }
                        SourcePositions sourcePositions = compilationController.getTrees().getSourcePositions();
                        CompilationUnitTree compilationUnitTree = compilationController.getCompilationUnit();
                        TreeUtilities treeUtilities = compilationController.getTreeUtilities();
                        Tree tree = null;
                        Tree tree2 = null;
                        TreePath treePath = null;
                        TreePath treePath2 = null;
                        Tree tree3 = null;
                        long l = 0L;
                        long l2 = 0L;
                        for (int i = n3; i <= n2; ++i) {
                            TreePath treePath3 = treeUtilities.pathFor(i);
                            Tree tree4 = treePath3.getLeaf();
                            if (tree4.equals(tree3)) continue;
                            long l3 = sourcePositions.getStartPosition(compilationUnitTree, tree4);
                            long l4 = sourcePositions.getEndPosition(compilationUnitTree, tree4);
                            if (tree == null && l3 < (long)n3) {
                                tree = tree4;
                                treePath = treePath3;
                                tree3 = tree4;
                                continue;
                            }
                            if (l3 >= (long)n3) {
                                if (tree2 == null || l >= l3 && l2 <= l4) {
                                    tree2 = tree4;
                                    treePath2 = treePath3;
                                    l = l3;
                                    l2 = l4;
                                    if (tree2 instanceof VariableTree && ToggleBreakpointActionProvider.isBreakable(treePath2)) {
                                        break;
                                    }
                                } else if (l3 > l2) {
                                    if (ToggleBreakpointActionProvider.isBreakable(treePath2)) break;
                                    tree2 = tree4;
                                    treePath2 = treePath3;
                                    l = l3;
                                    l2 = l4;
                                    if (tree2 instanceof VariableTree && ToggleBreakpointActionProvider.isBreakable(treePath2)) break;
                                }
                            }
                            tree3 = tree4;
                        }
                        if (tree2 == null || !ToggleBreakpointActionProvider.isBreakable(treePath2)) {
                            if (tree != null && ToggleBreakpointActionProvider.isBreakable(treePath)) {
                                long l5 = sourcePositions.getStartPosition(compilationUnitTree, tree);
                                this.val$result[0] = Utilities.getLineOffset((BaseDocument)this.val$doc, (int)((int)l5)) + 1;
                            } else {
                                long l6;
                                Tree tree5;
                                if (tree != null && tree instanceof BlockTree && (tree5 = treePath.getParentPath().getLeaf()) instanceof MethodTree && (l6 = sourcePositions.getEndPosition(compilationUnitTree, tree5)) <= (long)n2) {
                                    return;
                                }
                                this.val$result[0] = -1;
                            }
                        }
                    }
                }, true);
                if (future.isDone()) break block23;
                if (EventQueue.isDispatchThread()) {
                    return n;
                }
                try {
                    future.get();
                }
                catch (InterruptedException interruptedException) {
                    return n;
                }
                catch (ExecutionException executionException) {
                    ErrorManager.getDefault().notify((Throwable)executionException);
                    return n;
                }
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
                return n;
            }
        }
        return (int)objectArray[0];
    }

    private static boolean isBreakable(TreePath treePath) {
        Tree tree = treePath.getLeaf();
        switch (tree.getKind()) {
            case BLOCK: 
            case CLASS: 
            case COMPILATION_UNIT: 
            case IMPORT: 
            case MODIFIERS: 
            case EMPTY_STATEMENT: {
                return false;
            }
        }
        while (treePath != null) {
            VariableTree variableTree;
            tree = treePath.getLeaf();
            Tree.Kind kind = tree.getKind();
            if (kind == Tree.Kind.IMPORT) {
                return false;
            }
            if (kind == Tree.Kind.VARIABLE && (variableTree = (VariableTree)tree).getInitializer() == null) {
                return false;
            }
            treePath = treePath.getParentPath();
        }
        return true;
    }

    static LineBreakpoint findBreakpoint(String string, int n) {
        Breakpoint[] breakpointArray = DebuggerManager.getDebuggerManager().getBreakpoints();
        for (int i = 0; i < breakpointArray.length; ++i) {
            LineBreakpoint lineBreakpoint;
            if (!(breakpointArray[i] instanceof LineBreakpoint) || !(lineBreakpoint = (LineBreakpoint)breakpointArray[i]).getURL().equals(string) || lineBreakpoint.getLineNumber() != n) continue;
            return lineBreakpoint;
        }
        return null;
    }
}

